// DO NOT EDIT: This file is autogenerated via the builtin command.

package sensu

import (
	ast "github.com/influxdata/flux/ast"
	runtime "github.com/influxdata/flux/runtime"
)

func init() {
	runtime.RegisterPackage(pkgAST)
}

var pkgAST = &ast.Package{
	BaseNode: ast.BaseNode{
		Comments: nil,
		Errors:   nil,
		Loc:      nil,
	},
	Files: []*ast.File{&ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 15,
					Line:   71,
				},
				File:   "sensu.flux",
				Source: "package sensu\n\nimport \"http\"\nimport \"json\"\n\n// toSensuName translates a string value to a Sensu name.\n// Characters not being [a-zA-Z0-9_.\\-] are replaced by underscore.\nbuiltin toSensuName : (v: string) => string\n\n// `event` sends a single event to Sensu as described in https://docs.sensu.io/sensu-go/latest/api/events/#create-a-new-event API. \n// `url` - string - base URL of [Sensu API](https://docs.sensu.io/sensu-go/latest/migrate/#architecture) without a trailing slash, for example \"http://localhost:8080\" .\n// `apiKey` - string - Sensu [API Key](https://docs.sensu.io/sensu-go/latest/operations/control-access/).\n// `checkName` - string - Check name, it can contain [a-zA-Z0-9_.\\-] characters, other characters are replaced by underscore.\n// `text` - string - The event text (named output in a Sensu Event).\n// `handlers` - array<string> - Sensu handlers to execute, optional.\n// `status` - int - The event status, 0 (default) indicates \"OK\", 1 indicates \"WARNING\", 2 indicates \"CRITICAL\", any other value indicates an “UNKNOWN” or custom status.\n// `state` - string - The event state can be \"failing\", \"passing\" or \"flapping\". Defaults to \"passing\" for 0 status, \"failing\" otherwise. \n// `namespace` - string - The Sensu namespace. Defaults to \"default\".\n// `entityName` - string - Source of the event, it can contain [a-zA-Z0-9_.\\-] characters, other characters are replaced by underscore. Defaults to \"influxdb\".\nevent = (url, apiKey, checkName, text, handlers = [], status=0, state=\"\", namespace=\"default\", entityName=\"influxdb\") => {\n    data = {\n        entity: {\n            entity_class: \"proxy\",\n            metadata: {\n                name: toSensuName(v:entityName),\n            }\n        },\n        check: {\n            output: text,\n            state: if state != \"\" then state else if status == 0 then \"passing\" else \"failing\",\n            status: status,\n            handlers: handlers,\n            interval: 60, // required\n            metadata: {\n                name: toSensuName(v:checkName)\n            }\n        }\n    }\n\n    headers = {\n        \"Content-Type\": \"application/json; charset=utf-8\",\n        \"Authorization\": \"Key \" + apiKey,\n    }\n    enc = json.encode(v:data)\n    return http.post(headers: headers, url: url + \"/api/core/v2/namespaces/\" + namespace + \"/events\", data: enc)\n}\n\n// `endpoint` creates a factory function that creates a target function for pipeline `|>` to send event to Sensu for each table row.\n// `url` - string - base URL of [Sensu API](https://docs.sensu.io/sensu-go/latest/migrate/#architecture) without a trailing slash, for example \"http://localhost:8080\" .\n// `apiKey` - string - Sensu [API Key](https://docs.sensu.io/sensu-go/latest/operations/control-access/).\n// `handlers` - array<string> - Sensu handlers to execute.\n// `namespace` - string - The Sensu namespace. Defaults to \"default\".\n// `entityName` - string - Source of the event, it can contain [a-zA-Z0-9_.\\-] characters, other characters are replaced by underscore. Defaults to \"influxdb\".\n// The returned factory function accepts a `mapFn` parameter.\n// The `mapFn` must return an object with `checkName`, `text`, and `status`, as defined in the `event` function arguments.\nendpoint = (url, apiKey, handlers = [], namespace=\"default\", entityName=\"influxdb\") =>\n    (mapFn) =>\n        (tables=<-) => tables\n            |> map(fn: (r) => {\n                obj = mapFn(r: r)\n                return {r with _sent: string(v: 2 == event(\n                    url: url,\n                    apiKey: apiKey,\n                    checkName: obj.checkName,\n                    text: obj.text,\n                    handlers: handlers,\n                    status: obj.status,\n                    namespace: namespace,\n                    entityName: entityName,\n                ) / 100)}\n            })",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// toSensuName translates a string value to a Sensu name.\n"}, ast.Comment{Text: "// Characters not being [a-zA-Z0-9_.\\-] are replaced by underscore.\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 20,
						Line:   8,
					},
					File:   "sensu.flux",
					Source: "builtin toSensuName",
					Start: ast.Position{
						Column: 1,
						Line:   8,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 20,
							Line:   8,
						},
						File:   "sensu.flux",
						Source: "toSensuName",
						Start: ast.Position{
							Column: 9,
							Line:   8,
						},
					},
				},
				Name: "toSensuName",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 44,
							Line:   8,
						},
						File:   "sensu.flux",
						Source: "(v: string) => string",
						Start: ast.Position{
							Column: 23,
							Line:   8,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 44,
								Line:   8,
							},
							File:   "sensu.flux",
							Source: "(v: string) => string",
							Start: ast.Position{
								Column: 23,
								Line:   8,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 33,
									Line:   8,
								},
								File:   "sensu.flux",
								Source: "v: string",
								Start: ast.Position{
									Column: 24,
									Line:   8,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   8,
									},
									File:   "sensu.flux",
									Source: "v",
									Start: ast.Position{
										Column: 24,
										Line:   8,
									},
								},
							},
							Name: "v",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 33,
										Line:   8,
									},
									File:   "sensu.flux",
									Source: "string",
									Start: ast.Position{
										Column: 27,
										Line:   8,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 33,
											Line:   8,
										},
										File:   "sensu.flux",
										Source: "string",
										Start: ast.Position{
											Column: 27,
											Line:   8,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 44,
									Line:   8,
								},
								File:   "sensu.flux",
								Source: "string",
								Start: ast.Position{
									Column: 38,
									Line:   8,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 44,
										Line:   8,
									},
									File:   "sensu.flux",
									Source: "string",
									Start: ast.Position{
										Column: 38,
										Line:   8,
									},
								},
							},
							Name: "string",
						},
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   46,
					},
					File:   "sensu.flux",
					Source: "event = (url, apiKey, checkName, text, handlers = [], status=0, state=\"\", namespace=\"default\", entityName=\"influxdb\") => {\n    data = {\n        entity: {\n            entity_class: \"proxy\",\n            metadata: {\n                name: toSensuName(v:entityName),\n            }\n        },\n        check: {\n            output: text,\n            state: if state != \"\" then state else if status == 0 then \"passing\" else \"failing\",\n            status: status,\n            handlers: handlers,\n            interval: 60, // required\n            metadata: {\n                name: toSensuName(v:checkName)\n            }\n        }\n    }\n\n    headers = {\n        \"Content-Type\": \"application/json; charset=utf-8\",\n        \"Authorization\": \"Key \" + apiKey,\n    }\n    enc = json.encode(v:data)\n    return http.post(headers: headers, url: url + \"/api/core/v2/namespaces/\" + namespace + \"/events\", data: enc)\n}",
					Start: ast.Position{
						Column: 1,
						Line:   20,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// `event` sends a single event to Sensu as described in https://docs.sensu.io/sensu-go/latest/api/events/#create-a-new-event API. \n"}, ast.Comment{Text: "// `url` - string - base URL of [Sensu API](https://docs.sensu.io/sensu-go/latest/migrate/#architecture) without a trailing slash, for example \"http://localhost:8080\" .\n"}, ast.Comment{Text: "// `apiKey` - string - Sensu [API Key](https://docs.sensu.io/sensu-go/latest/operations/control-access/).\n"}, ast.Comment{Text: "// `checkName` - string - Check name, it can contain [a-zA-Z0-9_.\\-] characters, other characters are replaced by underscore.\n"}, ast.Comment{Text: "// `text` - string - The event text (named output in a Sensu Event).\n"}, ast.Comment{Text: "// `handlers` - array<string> - Sensu handlers to execute, optional.\n"}, ast.Comment{Text: "// `status` - int - The event status, 0 (default) indicates \"OK\", 1 indicates \"WARNING\", 2 indicates \"CRITICAL\", any other value indicates an “UNKNOWN” or custom status.\n"}, ast.Comment{Text: "// `state` - string - The event state can be \"failing\", \"passing\" or \"flapping\". Defaults to \"passing\" for 0 status, \"failing\" otherwise. \n"}, ast.Comment{Text: "// `namespace` - string - The Sensu namespace. Defaults to \"default\".\n"}, ast.Comment{Text: "// `entityName` - string - Source of the event, it can contain [a-zA-Z0-9_.\\-] characters, other characters are replaced by underscore. Defaults to \"influxdb\".\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   20,
						},
						File:   "sensu.flux",
						Source: "event",
						Start: ast.Position{
							Column: 1,
							Line:   20,
						},
					},
				},
				Name: "event",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   46,
						},
						File:   "sensu.flux",
						Source: "(url, apiKey, checkName, text, handlers = [], status=0, state=\"\", namespace=\"default\", entityName=\"influxdb\") => {\n    data = {\n        entity: {\n            entity_class: \"proxy\",\n            metadata: {\n                name: toSensuName(v:entityName),\n            }\n        },\n        check: {\n            output: text,\n            state: if state != \"\" then state else if status == 0 then \"passing\" else \"failing\",\n            status: status,\n            handlers: handlers,\n            interval: 60, // required\n            metadata: {\n                name: toSensuName(v:checkName)\n            }\n        }\n    }\n\n    headers = {\n        \"Content-Type\": \"application/json; charset=utf-8\",\n        \"Authorization\": \"Key \" + apiKey,\n    }\n    enc = json.encode(v:data)\n    return http.post(headers: headers, url: url + \"/api/core/v2/namespaces/\" + namespace + \"/events\", data: enc)\n}",
						Start: ast.Position{
							Column: 9,
							Line:   20,
						},
					},
				},
				Body: &ast.Block{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   46,
							},
							File:   "sensu.flux",
							Source: "{\n    data = {\n        entity: {\n            entity_class: \"proxy\",\n            metadata: {\n                name: toSensuName(v:entityName),\n            }\n        },\n        check: {\n            output: text,\n            state: if state != \"\" then state else if status == 0 then \"passing\" else \"failing\",\n            status: status,\n            handlers: handlers,\n            interval: 60, // required\n            metadata: {\n                name: toSensuName(v:checkName)\n            }\n        }\n    }\n\n    headers = {\n        \"Content-Type\": \"application/json; charset=utf-8\",\n        \"Authorization\": \"Key \" + apiKey,\n    }\n    enc = json.encode(v:data)\n    return http.post(headers: headers, url: url + \"/api/core/v2/namespaces/\" + namespace + \"/events\", data: enc)\n}",
							Start: ast.Position{
								Column: 122,
								Line:   20,
							},
						},
					},
					Body: []ast.Statement{&ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   38,
								},
								File:   "sensu.flux",
								Source: "data = {\n        entity: {\n            entity_class: \"proxy\",\n            metadata: {\n                name: toSensuName(v:entityName),\n            }\n        },\n        check: {\n            output: text,\n            state: if state != \"\" then state else if status == 0 then \"passing\" else \"failing\",\n            status: status,\n            handlers: handlers,\n            interval: 60, // required\n            metadata: {\n                name: toSensuName(v:checkName)\n            }\n        }\n    }",
								Start: ast.Position{
									Column: 5,
									Line:   21,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 9,
										Line:   21,
									},
									File:   "sensu.flux",
									Source: "data",
									Start: ast.Position{
										Column: 5,
										Line:   21,
									},
								},
							},
							Name: "data",
						},
						Init: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   38,
									},
									File:   "sensu.flux",
									Source: "{\n        entity: {\n            entity_class: \"proxy\",\n            metadata: {\n                name: toSensuName(v:entityName),\n            }\n        },\n        check: {\n            output: text,\n            state: if state != \"\" then state else if status == 0 then \"passing\" else \"failing\",\n            status: status,\n            handlers: handlers,\n            interval: 60, // required\n            metadata: {\n                name: toSensuName(v:checkName)\n            }\n        }\n    }",
									Start: ast.Position{
										Column: 12,
										Line:   21,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 10,
											Line:   27,
										},
										File:   "sensu.flux",
										Source: "entity: {\n            entity_class: \"proxy\",\n            metadata: {\n                name: toSensuName(v:entityName),\n            }\n        }",
										Start: ast.Position{
											Column: 9,
											Line:   22,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 15,
												Line:   22,
											},
											File:   "sensu.flux",
											Source: "entity",
											Start: ast.Position{
												Column: 9,
												Line:   22,
											},
										},
									},
									Name: "entity",
								},
								Separator: nil,
								Value: &ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 10,
												Line:   27,
											},
											File:   "sensu.flux",
											Source: "{\n            entity_class: \"proxy\",\n            metadata: {\n                name: toSensuName(v:entityName),\n            }\n        }",
											Start: ast.Position{
												Column: 17,
												Line:   22,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 34,
													Line:   23,
												},
												File:   "sensu.flux",
												Source: "entity_class: \"proxy\"",
												Start: ast.Position{
													Column: 13,
													Line:   23,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 25,
														Line:   23,
													},
													File:   "sensu.flux",
													Source: "entity_class",
													Start: ast.Position{
														Column: 13,
														Line:   23,
													},
												},
											},
											Name: "entity_class",
										},
										Separator: nil,
										Value: &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 34,
														Line:   23,
													},
													File:   "sensu.flux",
													Source: "\"proxy\"",
													Start: ast.Position{
														Column: 27,
														Line:   23,
													},
												},
											},
											Value: "proxy",
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 14,
													Line:   26,
												},
												File:   "sensu.flux",
												Source: "metadata: {\n                name: toSensuName(v:entityName),\n            }",
												Start: ast.Position{
													Column: 13,
													Line:   24,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 21,
														Line:   24,
													},
													File:   "sensu.flux",
													Source: "metadata",
													Start: ast.Position{
														Column: 13,
														Line:   24,
													},
												},
											},
											Name: "metadata",
										},
										Separator: nil,
										Value: &ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 14,
														Line:   26,
													},
													File:   "sensu.flux",
													Source: "{\n                name: toSensuName(v:entityName),\n            }",
													Start: ast.Position{
														Column: 23,
														Line:   24,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 48,
															Line:   25,
														},
														File:   "sensu.flux",
														Source: "name: toSensuName(v:entityName)",
														Start: ast.Position{
															Column: 17,
															Line:   25,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 21,
																Line:   25,
															},
															File:   "sensu.flux",
															Source: "name",
															Start: ast.Position{
																Column: 17,
																Line:   25,
															},
														},
													},
													Name: "name",
												},
												Separator: nil,
												Value: &ast.CallExpression{
													Arguments: []ast.Expression{&ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 47,
																	Line:   25,
																},
																File:   "sensu.flux",
																Source: "v:entityName",
																Start: ast.Position{
																	Column: 35,
																	Line:   25,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 47,
																		Line:   25,
																	},
																	File:   "sensu.flux",
																	Source: "v:entityName",
																	Start: ast.Position{
																		Column: 35,
																		Line:   25,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 36,
																			Line:   25,
																		},
																		File:   "sensu.flux",
																		Source: "v",
																		Start: ast.Position{
																			Column: 35,
																			Line:   25,
																		},
																	},
																},
																Name: "v",
															},
															Separator: nil,
															Value: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 47,
																			Line:   25,
																		},
																		File:   "sensu.flux",
																		Source: "entityName",
																		Start: ast.Position{
																			Column: 37,
																			Line:   25,
																		},
																	},
																},
																Name: "entityName",
															},
														}},
														Rbrace: nil,
														With:   nil,
													}},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 48,
																Line:   25,
															},
															File:   "sensu.flux",
															Source: "toSensuName(v:entityName)",
															Start: ast.Position{
																Column: 23,
																Line:   25,
															},
														},
													},
													Callee: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 34,
																	Line:   25,
																},
																File:   "sensu.flux",
																Source: "toSensuName",
																Start: ast.Position{
																	Column: 23,
																	Line:   25,
																},
															},
														},
														Name: "toSensuName",
													},
													Lparen: nil,
													Rparen: nil,
												},
											}},
											Rbrace: nil,
											With:   nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 10,
											Line:   37,
										},
										File:   "sensu.flux",
										Source: "check: {\n            output: text,\n            state: if state != \"\" then state else if status == 0 then \"passing\" else \"failing\",\n            status: status,\n            handlers: handlers,\n            interval: 60, // required\n            metadata: {\n                name: toSensuName(v:checkName)\n            }\n        }",
										Start: ast.Position{
											Column: 9,
											Line:   28,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   28,
											},
											File:   "sensu.flux",
											Source: "check",
											Start: ast.Position{
												Column: 9,
												Line:   28,
											},
										},
									},
									Name: "check",
								},
								Separator: nil,
								Value: &ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 10,
												Line:   37,
											},
											File:   "sensu.flux",
											Source: "{\n            output: text,\n            state: if state != \"\" then state else if status == 0 then \"passing\" else \"failing\",\n            status: status,\n            handlers: handlers,\n            interval: 60, // required\n            metadata: {\n                name: toSensuName(v:checkName)\n            }\n        }",
											Start: ast.Position{
												Column: 16,
												Line:   28,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 25,
													Line:   29,
												},
												File:   "sensu.flux",
												Source: "output: text",
												Start: ast.Position{
													Column: 13,
													Line:   29,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 19,
														Line:   29,
													},
													File:   "sensu.flux",
													Source: "output",
													Start: ast.Position{
														Column: 13,
														Line:   29,
													},
												},
											},
											Name: "output",
										},
										Separator: nil,
										Value: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 25,
														Line:   29,
													},
													File:   "sensu.flux",
													Source: "text",
													Start: ast.Position{
														Column: 21,
														Line:   29,
													},
												},
											},
											Name: "text",
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 95,
													Line:   30,
												},
												File:   "sensu.flux",
												Source: "state: if state != \"\" then state else if status == 0 then \"passing\" else \"failing\"",
												Start: ast.Position{
													Column: 13,
													Line:   30,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   30,
													},
													File:   "sensu.flux",
													Source: "state",
													Start: ast.Position{
														Column: 13,
														Line:   30,
													},
												},
											},
											Name: "state",
										},
										Separator: nil,
										Value: &ast.ConditionalExpression{
											Alternate: &ast.ConditionalExpression{
												Alternate: &ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 95,
																Line:   30,
															},
															File:   "sensu.flux",
															Source: "\"failing\"",
															Start: ast.Position{
																Column: 86,
																Line:   30,
															},
														},
													},
													Value: "failing",
												},
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 95,
															Line:   30,
														},
														File:   "sensu.flux",
														Source: "if status == 0 then \"passing\" else \"failing\"",
														Start: ast.Position{
															Column: 51,
															Line:   30,
														},
													},
												},
												Consequent: &ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 80,
																Line:   30,
															},
															File:   "sensu.flux",
															Source: "\"passing\"",
															Start: ast.Position{
																Column: 71,
																Line:   30,
															},
														},
													},
													Value: "passing",
												},
												Test: &ast.BinaryExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 65,
																Line:   30,
															},
															File:   "sensu.flux",
															Source: "status == 0",
															Start: ast.Position{
																Column: 54,
																Line:   30,
															},
														},
													},
													Left: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 60,
																	Line:   30,
																},
																File:   "sensu.flux",
																Source: "status",
																Start: ast.Position{
																	Column: 54,
																	Line:   30,
																},
															},
														},
														Name: "status",
													},
													Operator: 17,
													Right: &ast.IntegerLiteral{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 65,
																	Line:   30,
																},
																File:   "sensu.flux",
																Source: "0",
																Start: ast.Position{
																	Column: 64,
																	Line:   30,
																},
															},
														},
														Value: int64(0),
													},
												},
												Tk_else: nil,
												Tk_if:   nil,
												Tk_then: nil,
											},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 95,
														Line:   30,
													},
													File:   "sensu.flux",
													Source: "if state != \"\" then state else if status == 0 then \"passing\" else \"failing\"",
													Start: ast.Position{
														Column: 20,
														Line:   30,
													},
												},
											},
											Consequent: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 45,
															Line:   30,
														},
														File:   "sensu.flux",
														Source: "state",
														Start: ast.Position{
															Column: 40,
															Line:   30,
														},
													},
												},
												Name: "state",
											},
											Test: &ast.BinaryExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 34,
															Line:   30,
														},
														File:   "sensu.flux",
														Source: "state != \"\"",
														Start: ast.Position{
															Column: 23,
															Line:   30,
														},
													},
												},
												Left: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 28,
																Line:   30,
															},
															File:   "sensu.flux",
															Source: "state",
															Start: ast.Position{
																Column: 23,
																Line:   30,
															},
														},
													},
													Name: "state",
												},
												Operator: 18,
												Right: &ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 34,
																Line:   30,
															},
															File:   "sensu.flux",
															Source: "\"\"",
															Start: ast.Position{
																Column: 32,
																Line:   30,
															},
														},
													},
													Value: "",
												},
											},
											Tk_else: nil,
											Tk_if:   nil,
											Tk_then: nil,
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 27,
													Line:   31,
												},
												File:   "sensu.flux",
												Source: "status: status",
												Start: ast.Position{
													Column: 13,
													Line:   31,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 19,
														Line:   31,
													},
													File:   "sensu.flux",
													Source: "status",
													Start: ast.Position{
														Column: 13,
														Line:   31,
													},
												},
											},
											Name: "status",
										},
										Separator: nil,
										Value: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 27,
														Line:   31,
													},
													File:   "sensu.flux",
													Source: "status",
													Start: ast.Position{
														Column: 21,
														Line:   31,
													},
												},
											},
											Name: "status",
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 31,
													Line:   32,
												},
												File:   "sensu.flux",
												Source: "handlers: handlers",
												Start: ast.Position{
													Column: 13,
													Line:   32,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 21,
														Line:   32,
													},
													File:   "sensu.flux",
													Source: "handlers",
													Start: ast.Position{
														Column: 13,
														Line:   32,
													},
												},
											},
											Name: "handlers",
										},
										Separator: nil,
										Value: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 31,
														Line:   32,
													},
													File:   "sensu.flux",
													Source: "handlers",
													Start: ast.Position{
														Column: 23,
														Line:   32,
													},
												},
											},
											Name: "handlers",
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 25,
													Line:   33,
												},
												File:   "sensu.flux",
												Source: "interval: 60",
												Start: ast.Position{
													Column: 13,
													Line:   33,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 21,
														Line:   33,
													},
													File:   "sensu.flux",
													Source: "interval",
													Start: ast.Position{
														Column: 13,
														Line:   33,
													},
												},
											},
											Name: "interval",
										},
										Separator: nil,
										Value: &ast.IntegerLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 25,
														Line:   33,
													},
													File:   "sensu.flux",
													Source: "60",
													Start: ast.Position{
														Column: 23,
														Line:   33,
													},
												},
											},
											Value: int64(60),
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 14,
													Line:   36,
												},
												File:   "sensu.flux",
												Source: "metadata: {\n                name: toSensuName(v:checkName)\n            }",
												Start: ast.Position{
													Column: 13,
													Line:   34,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: []ast.Comment{ast.Comment{Text: "// required\n"}},
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 21,
														Line:   34,
													},
													File:   "sensu.flux",
													Source: "metadata",
													Start: ast.Position{
														Column: 13,
														Line:   34,
													},
												},
											},
											Name: "metadata",
										},
										Separator: nil,
										Value: &ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 14,
														Line:   36,
													},
													File:   "sensu.flux",
													Source: "{\n                name: toSensuName(v:checkName)\n            }",
													Start: ast.Position{
														Column: 23,
														Line:   34,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 47,
															Line:   35,
														},
														File:   "sensu.flux",
														Source: "name: toSensuName(v:checkName)",
														Start: ast.Position{
															Column: 17,
															Line:   35,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 21,
																Line:   35,
															},
															File:   "sensu.flux",
															Source: "name",
															Start: ast.Position{
																Column: 17,
																Line:   35,
															},
														},
													},
													Name: "name",
												},
												Separator: nil,
												Value: &ast.CallExpression{
													Arguments: []ast.Expression{&ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 46,
																	Line:   35,
																},
																File:   "sensu.flux",
																Source: "v:checkName",
																Start: ast.Position{
																	Column: 35,
																	Line:   35,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 46,
																		Line:   35,
																	},
																	File:   "sensu.flux",
																	Source: "v:checkName",
																	Start: ast.Position{
																		Column: 35,
																		Line:   35,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 36,
																			Line:   35,
																		},
																		File:   "sensu.flux",
																		Source: "v",
																		Start: ast.Position{
																			Column: 35,
																			Line:   35,
																		},
																	},
																},
																Name: "v",
															},
															Separator: nil,
															Value: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 46,
																			Line:   35,
																		},
																		File:   "sensu.flux",
																		Source: "checkName",
																		Start: ast.Position{
																			Column: 37,
																			Line:   35,
																		},
																	},
																},
																Name: "checkName",
															},
														}},
														Rbrace: nil,
														With:   nil,
													}},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 47,
																Line:   35,
															},
															File:   "sensu.flux",
															Source: "toSensuName(v:checkName)",
															Start: ast.Position{
																Column: 23,
																Line:   35,
															},
														},
													},
													Callee: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 34,
																	Line:   35,
																},
																File:   "sensu.flux",
																Source: "toSensuName",
																Start: ast.Position{
																	Column: 23,
																	Line:   35,
																},
															},
														},
														Name: "toSensuName",
													},
													Lparen: nil,
													Rparen: nil,
												},
											}},
											Rbrace: nil,
											With:   nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   43,
								},
								File:   "sensu.flux",
								Source: "headers = {\n        \"Content-Type\": \"application/json; charset=utf-8\",\n        \"Authorization\": \"Key \" + apiKey,\n    }",
								Start: ast.Position{
									Column: 5,
									Line:   40,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   40,
									},
									File:   "sensu.flux",
									Source: "headers",
									Start: ast.Position{
										Column: 5,
										Line:   40,
									},
								},
							},
							Name: "headers",
						},
						Init: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   43,
									},
									File:   "sensu.flux",
									Source: "{\n        \"Content-Type\": \"application/json; charset=utf-8\",\n        \"Authorization\": \"Key \" + apiKey,\n    }",
									Start: ast.Position{
										Column: 15,
										Line:   40,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 58,
											Line:   41,
										},
										File:   "sensu.flux",
										Source: "\"Content-Type\": \"application/json; charset=utf-8\"",
										Start: ast.Position{
											Column: 9,
											Line:   41,
										},
									},
								},
								Comma: nil,
								Key: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 23,
												Line:   41,
											},
											File:   "sensu.flux",
											Source: "\"Content-Type\"",
											Start: ast.Position{
												Column: 9,
												Line:   41,
											},
										},
									},
									Value: "Content-Type",
								},
								Separator: nil,
								Value: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 58,
												Line:   41,
											},
											File:   "sensu.flux",
											Source: "\"application/json; charset=utf-8\"",
											Start: ast.Position{
												Column: 25,
												Line:   41,
											},
										},
									},
									Value: "application/json; charset=utf-8",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   42,
										},
										File:   "sensu.flux",
										Source: "\"Authorization\": \"Key \" + apiKey",
										Start: ast.Position{
											Column: 9,
											Line:   42,
										},
									},
								},
								Comma: nil,
								Key: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 24,
												Line:   42,
											},
											File:   "sensu.flux",
											Source: "\"Authorization\"",
											Start: ast.Position{
												Column: 9,
												Line:   42,
											},
										},
									},
									Value: "Authorization",
								},
								Separator: nil,
								Value: &ast.BinaryExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   42,
											},
											File:   "sensu.flux",
											Source: "\"Key \" + apiKey",
											Start: ast.Position{
												Column: 26,
												Line:   42,
											},
										},
									},
									Left: &ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 32,
													Line:   42,
												},
												File:   "sensu.flux",
												Source: "\"Key \"",
												Start: ast.Position{
													Column: 26,
													Line:   42,
												},
											},
										},
										Value: "Key ",
									},
									Operator: 5,
									Right: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   42,
												},
												File:   "sensu.flux",
												Source: "apiKey",
												Start: ast.Position{
													Column: 35,
													Line:   42,
												},
											},
										},
										Name: "apiKey",
									},
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   44,
								},
								File:   "sensu.flux",
								Source: "enc = json.encode(v:data)",
								Start: ast.Position{
									Column: 5,
									Line:   44,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 8,
										Line:   44,
									},
									File:   "sensu.flux",
									Source: "enc",
									Start: ast.Position{
										Column: 5,
										Line:   44,
									},
								},
							},
							Name: "enc",
						},
						Init: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   44,
										},
										File:   "sensu.flux",
										Source: "v:data",
										Start: ast.Position{
											Column: 23,
											Line:   44,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   44,
											},
											File:   "sensu.flux",
											Source: "v:data",
											Start: ast.Position{
												Column: 23,
												Line:   44,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 24,
													Line:   44,
												},
												File:   "sensu.flux",
												Source: "v",
												Start: ast.Position{
													Column: 23,
													Line:   44,
												},
											},
										},
										Name: "v",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 29,
													Line:   44,
												},
												File:   "sensu.flux",
												Source: "data",
												Start: ast.Position{
													Column: 25,
													Line:   44,
												},
											},
										},
										Name: "data",
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   44,
									},
									File:   "sensu.flux",
									Source: "json.encode(v:data)",
									Start: ast.Position{
										Column: 11,
										Line:   44,
									},
								},
							},
							Callee: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 22,
											Line:   44,
										},
										File:   "sensu.flux",
										Source: "json.encode",
										Start: ast.Position{
											Column: 11,
											Line:   44,
										},
									},
								},
								Lbrack: nil,
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 15,
												Line:   44,
											},
											File:   "sensu.flux",
											Source: "json",
											Start: ast.Position{
												Column: 11,
												Line:   44,
											},
										},
									},
									Name: "json",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 22,
												Line:   44,
											},
											File:   "sensu.flux",
											Source: "encode",
											Start: ast.Position{
												Column: 16,
												Line:   44,
											},
										},
									},
									Name: "encode",
								},
								Rbrack: nil,
							},
							Lparen: nil,
							Rparen: nil,
						},
					}, &ast.ReturnStatement{
						Argument: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 112,
											Line:   45,
										},
										File:   "sensu.flux",
										Source: "headers: headers, url: url + \"/api/core/v2/namespaces/\" + namespace + \"/events\", data: enc",
										Start: ast.Position{
											Column: 22,
											Line:   45,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 38,
												Line:   45,
											},
											File:   "sensu.flux",
											Source: "headers: headers",
											Start: ast.Position{
												Column: 22,
												Line:   45,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 29,
													Line:   45,
												},
												File:   "sensu.flux",
												Source: "headers",
												Start: ast.Position{
													Column: 22,
													Line:   45,
												},
											},
										},
										Name: "headers",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 38,
													Line:   45,
												},
												File:   "sensu.flux",
												Source: "headers",
												Start: ast.Position{
													Column: 31,
													Line:   45,
												},
											},
										},
										Name: "headers",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 101,
												Line:   45,
											},
											File:   "sensu.flux",
											Source: "url: url + \"/api/core/v2/namespaces/\" + namespace + \"/events\"",
											Start: ast.Position{
												Column: 40,
												Line:   45,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 43,
													Line:   45,
												},
												File:   "sensu.flux",
												Source: "url",
												Start: ast.Position{
													Column: 40,
													Line:   45,
												},
											},
										},
										Name: "url",
									},
									Separator: nil,
									Value: &ast.BinaryExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 101,
													Line:   45,
												},
												File:   "sensu.flux",
												Source: "url + \"/api/core/v2/namespaces/\" + namespace + \"/events\"",
												Start: ast.Position{
													Column: 45,
													Line:   45,
												},
											},
										},
										Left: &ast.BinaryExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 89,
														Line:   45,
													},
													File:   "sensu.flux",
													Source: "url + \"/api/core/v2/namespaces/\" + namespace",
													Start: ast.Position{
														Column: 45,
														Line:   45,
													},
												},
											},
											Left: &ast.BinaryExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 77,
															Line:   45,
														},
														File:   "sensu.flux",
														Source: "url + \"/api/core/v2/namespaces/\"",
														Start: ast.Position{
															Column: 45,
															Line:   45,
														},
													},
												},
												Left: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 48,
																Line:   45,
															},
															File:   "sensu.flux",
															Source: "url",
															Start: ast.Position{
																Column: 45,
																Line:   45,
															},
														},
													},
													Name: "url",
												},
												Operator: 5,
												Right: &ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 77,
																Line:   45,
															},
															File:   "sensu.flux",
															Source: "\"/api/core/v2/namespaces/\"",
															Start: ast.Position{
																Column: 51,
																Line:   45,
															},
														},
													},
													Value: "/api/core/v2/namespaces/",
												},
											},
											Operator: 5,
											Right: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 89,
															Line:   45,
														},
														File:   "sensu.flux",
														Source: "namespace",
														Start: ast.Position{
															Column: 80,
															Line:   45,
														},
													},
												},
												Name: "namespace",
											},
										},
										Operator: 5,
										Right: &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 101,
														Line:   45,
													},
													File:   "sensu.flux",
													Source: "\"/events\"",
													Start: ast.Position{
														Column: 92,
														Line:   45,
													},
												},
											},
											Value: "/events",
										},
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 112,
												Line:   45,
											},
											File:   "sensu.flux",
											Source: "data: enc",
											Start: ast.Position{
												Column: 103,
												Line:   45,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 107,
													Line:   45,
												},
												File:   "sensu.flux",
												Source: "data",
												Start: ast.Position{
													Column: 103,
													Line:   45,
												},
											},
										},
										Name: "data",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 112,
													Line:   45,
												},
												File:   "sensu.flux",
												Source: "enc",
												Start: ast.Position{
													Column: 109,
													Line:   45,
												},
											},
										},
										Name: "enc",
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 113,
										Line:   45,
									},
									File:   "sensu.flux",
									Source: "http.post(headers: headers, url: url + \"/api/core/v2/namespaces/\" + namespace + \"/events\", data: enc)",
									Start: ast.Position{
										Column: 12,
										Line:   45,
									},
								},
							},
							Callee: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   45,
										},
										File:   "sensu.flux",
										Source: "http.post",
										Start: ast.Position{
											Column: 12,
											Line:   45,
										},
									},
								},
								Lbrack: nil,
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 16,
												Line:   45,
											},
											File:   "sensu.flux",
											Source: "http",
											Start: ast.Position{
												Column: 12,
												Line:   45,
											},
										},
									},
									Name: "http",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 21,
												Line:   45,
											},
											File:   "sensu.flux",
											Source: "post",
											Start: ast.Position{
												Column: 17,
												Line:   45,
											},
										},
									},
									Name: "post",
								},
								Rbrack: nil,
							},
							Lparen: nil,
							Rparen: nil,
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 113,
									Line:   45,
								},
								File:   "sensu.flux",
								Source: "return http.post(headers: headers, url: url + \"/api/core/v2/namespaces/\" + namespace + \"/events\", data: enc)",
								Start: ast.Position{
									Column: 5,
									Line:   45,
								},
							},
						},
					}},
					Lbrace: nil,
					Rbrace: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 13,
								Line:   20,
							},
							File:   "sensu.flux",
							Source: "url",
							Start: ast.Position{
								Column: 10,
								Line:   20,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 13,
									Line:   20,
								},
								File:   "sensu.flux",
								Source: "url",
								Start: ast.Position{
									Column: 10,
									Line:   20,
								},
							},
						},
						Name: "url",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 21,
								Line:   20,
							},
							File:   "sensu.flux",
							Source: "apiKey",
							Start: ast.Position{
								Column: 15,
								Line:   20,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   20,
								},
								File:   "sensu.flux",
								Source: "apiKey",
								Start: ast.Position{
									Column: 15,
									Line:   20,
								},
							},
						},
						Name: "apiKey",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 32,
								Line:   20,
							},
							File:   "sensu.flux",
							Source: "checkName",
							Start: ast.Position{
								Column: 23,
								Line:   20,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   20,
								},
								File:   "sensu.flux",
								Source: "checkName",
								Start: ast.Position{
									Column: 23,
									Line:   20,
								},
							},
						},
						Name: "checkName",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 38,
								Line:   20,
							},
							File:   "sensu.flux",
							Source: "text",
							Start: ast.Position{
								Column: 34,
								Line:   20,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 38,
									Line:   20,
								},
								File:   "sensu.flux",
								Source: "text",
								Start: ast.Position{
									Column: 34,
									Line:   20,
								},
							},
						},
						Name: "text",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 53,
								Line:   20,
							},
							File:   "sensu.flux",
							Source: "handlers = []",
							Start: ast.Position{
								Column: 40,
								Line:   20,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 48,
									Line:   20,
								},
								File:   "sensu.flux",
								Source: "handlers",
								Start: ast.Position{
									Column: 40,
									Line:   20,
								},
							},
						},
						Name: "handlers",
					},
					Separator: nil,
					Value: &ast.ArrayExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 53,
									Line:   20,
								},
								File:   "sensu.flux",
								Source: "[]",
								Start: ast.Position{
									Column: 51,
									Line:   20,
								},
							},
						},
						Elements: []ast.Expression{},
						Lbrack:   nil,
						Rbrack:   nil,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 63,
								Line:   20,
							},
							File:   "sensu.flux",
							Source: "status=0",
							Start: ast.Position{
								Column: 55,
								Line:   20,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 61,
									Line:   20,
								},
								File:   "sensu.flux",
								Source: "status",
								Start: ast.Position{
									Column: 55,
									Line:   20,
								},
							},
						},
						Name: "status",
					},
					Separator: nil,
					Value: &ast.IntegerLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 63,
									Line:   20,
								},
								File:   "sensu.flux",
								Source: "0",
								Start: ast.Position{
									Column: 62,
									Line:   20,
								},
							},
						},
						Value: int64(0),
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 73,
								Line:   20,
							},
							File:   "sensu.flux",
							Source: "state=\"\"",
							Start: ast.Position{
								Column: 65,
								Line:   20,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 70,
									Line:   20,
								},
								File:   "sensu.flux",
								Source: "state",
								Start: ast.Position{
									Column: 65,
									Line:   20,
								},
							},
						},
						Name: "state",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 73,
									Line:   20,
								},
								File:   "sensu.flux",
								Source: "\"\"",
								Start: ast.Position{
									Column: 71,
									Line:   20,
								},
							},
						},
						Value: "",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 94,
								Line:   20,
							},
							File:   "sensu.flux",
							Source: "namespace=\"default\"",
							Start: ast.Position{
								Column: 75,
								Line:   20,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 84,
									Line:   20,
								},
								File:   "sensu.flux",
								Source: "namespace",
								Start: ast.Position{
									Column: 75,
									Line:   20,
								},
							},
						},
						Name: "namespace",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 94,
									Line:   20,
								},
								File:   "sensu.flux",
								Source: "\"default\"",
								Start: ast.Position{
									Column: 85,
									Line:   20,
								},
							},
						},
						Value: "default",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 117,
								Line:   20,
							},
							File:   "sensu.flux",
							Source: "entityName=\"influxdb\"",
							Start: ast.Position{
								Column: 96,
								Line:   20,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 106,
									Line:   20,
								},
								File:   "sensu.flux",
								Source: "entityName",
								Start: ast.Position{
									Column: 96,
									Line:   20,
								},
							},
						},
						Name: "entityName",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 117,
									Line:   20,
								},
								File:   "sensu.flux",
								Source: "\"influxdb\"",
								Start: ast.Position{
									Column: 107,
									Line:   20,
								},
							},
						},
						Value: "influxdb",
					},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 15,
						Line:   71,
					},
					File:   "sensu.flux",
					Source: "endpoint = (url, apiKey, handlers = [], namespace=\"default\", entityName=\"influxdb\") =>\n    (mapFn) =>\n        (tables=<-) => tables\n            |> map(fn: (r) => {\n                obj = mapFn(r: r)\n                return {r with _sent: string(v: 2 == event(\n                    url: url,\n                    apiKey: apiKey,\n                    checkName: obj.checkName,\n                    text: obj.text,\n                    handlers: handlers,\n                    status: obj.status,\n                    namespace: namespace,\n                    entityName: entityName,\n                ) / 100)}\n            })",
					Start: ast.Position{
						Column: 1,
						Line:   56,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// `endpoint` creates a factory function that creates a target function for pipeline `|>` to send event to Sensu for each table row.\n"}, ast.Comment{Text: "// `url` - string - base URL of [Sensu API](https://docs.sensu.io/sensu-go/latest/migrate/#architecture) without a trailing slash, for example \"http://localhost:8080\" .\n"}, ast.Comment{Text: "// `apiKey` - string - Sensu [API Key](https://docs.sensu.io/sensu-go/latest/operations/control-access/).\n"}, ast.Comment{Text: "// `handlers` - array<string> - Sensu handlers to execute.\n"}, ast.Comment{Text: "// `namespace` - string - The Sensu namespace. Defaults to \"default\".\n"}, ast.Comment{Text: "// `entityName` - string - Source of the event, it can contain [a-zA-Z0-9_.\\-] characters, other characters are replaced by underscore. Defaults to \"influxdb\".\n"}, ast.Comment{Text: "// The returned factory function accepts a `mapFn` parameter.\n"}, ast.Comment{Text: "// The `mapFn` must return an object with `checkName`, `text`, and `status`, as defined in the `event` function arguments.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 9,
							Line:   56,
						},
						File:   "sensu.flux",
						Source: "endpoint",
						Start: ast.Position{
							Column: 1,
							Line:   56,
						},
					},
				},
				Name: "endpoint",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   71,
						},
						File:   "sensu.flux",
						Source: "(url, apiKey, handlers = [], namespace=\"default\", entityName=\"influxdb\") =>\n    (mapFn) =>\n        (tables=<-) => tables\n            |> map(fn: (r) => {\n                obj = mapFn(r: r)\n                return {r with _sent: string(v: 2 == event(\n                    url: url,\n                    apiKey: apiKey,\n                    checkName: obj.checkName,\n                    text: obj.text,\n                    handlers: handlers,\n                    status: obj.status,\n                    namespace: namespace,\n                    entityName: entityName,\n                ) / 100)}\n            })",
						Start: ast.Position{
							Column: 12,
							Line:   56,
						},
					},
				},
				Body: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 15,
								Line:   71,
							},
							File:   "sensu.flux",
							Source: "(mapFn) =>\n        (tables=<-) => tables\n            |> map(fn: (r) => {\n                obj = mapFn(r: r)\n                return {r with _sent: string(v: 2 == event(\n                    url: url,\n                    apiKey: apiKey,\n                    checkName: obj.checkName,\n                    text: obj.text,\n                    handlers: handlers,\n                    status: obj.status,\n                    namespace: namespace,\n                    entityName: entityName,\n                ) / 100)}\n            })",
							Start: ast.Position{
								Column: 5,
								Line:   57,
							},
						},
					},
					Body: &ast.FunctionExpression{
						Arrow: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   71,
								},
								File:   "sensu.flux",
								Source: "(tables=<-) => tables\n            |> map(fn: (r) => {\n                obj = mapFn(r: r)\n                return {r with _sent: string(v: 2 == event(\n                    url: url,\n                    apiKey: apiKey,\n                    checkName: obj.checkName,\n                    text: obj.text,\n                    handlers: handlers,\n                    status: obj.status,\n                    namespace: namespace,\n                    entityName: entityName,\n                ) / 100)}\n            })",
								Start: ast.Position{
									Column: 9,
									Line:   58,
								},
							},
						},
						Body: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   58,
										},
										File:   "sensu.flux",
										Source: "tables",
										Start: ast.Position{
											Column: 24,
											Line:   58,
										},
									},
								},
								Name: "tables",
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 15,
										Line:   71,
									},
									File:   "sensu.flux",
									Source: "tables\n            |> map(fn: (r) => {\n                obj = mapFn(r: r)\n                return {r with _sent: string(v: 2 == event(\n                    url: url,\n                    apiKey: apiKey,\n                    checkName: obj.checkName,\n                    text: obj.text,\n                    handlers: handlers,\n                    status: obj.status,\n                    namespace: namespace,\n                    entityName: entityName,\n                ) / 100)}\n            })",
									Start: ast.Position{
										Column: 24,
										Line:   58,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   71,
											},
											File:   "sensu.flux",
											Source: "fn: (r) => {\n                obj = mapFn(r: r)\n                return {r with _sent: string(v: 2 == event(\n                    url: url,\n                    apiKey: apiKey,\n                    checkName: obj.checkName,\n                    text: obj.text,\n                    handlers: handlers,\n                    status: obj.status,\n                    namespace: namespace,\n                    entityName: entityName,\n                ) / 100)}\n            }",
											Start: ast.Position{
												Column: 20,
												Line:   59,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 14,
													Line:   71,
												},
												File:   "sensu.flux",
												Source: "fn: (r) => {\n                obj = mapFn(r: r)\n                return {r with _sent: string(v: 2 == event(\n                    url: url,\n                    apiKey: apiKey,\n                    checkName: obj.checkName,\n                    text: obj.text,\n                    handlers: handlers,\n                    status: obj.status,\n                    namespace: namespace,\n                    entityName: entityName,\n                ) / 100)}\n            }",
												Start: ast.Position{
													Column: 20,
													Line:   59,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 22,
														Line:   59,
													},
													File:   "sensu.flux",
													Source: "fn",
													Start: ast.Position{
														Column: 20,
														Line:   59,
													},
												},
											},
											Name: "fn",
										},
										Separator: nil,
										Value: &ast.FunctionExpression{
											Arrow: nil,
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 14,
														Line:   71,
													},
													File:   "sensu.flux",
													Source: "(r) => {\n                obj = mapFn(r: r)\n                return {r with _sent: string(v: 2 == event(\n                    url: url,\n                    apiKey: apiKey,\n                    checkName: obj.checkName,\n                    text: obj.text,\n                    handlers: handlers,\n                    status: obj.status,\n                    namespace: namespace,\n                    entityName: entityName,\n                ) / 100)}\n            }",
													Start: ast.Position{
														Column: 24,
														Line:   59,
													},
												},
											},
											Body: &ast.Block{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 14,
															Line:   71,
														},
														File:   "sensu.flux",
														Source: "{\n                obj = mapFn(r: r)\n                return {r with _sent: string(v: 2 == event(\n                    url: url,\n                    apiKey: apiKey,\n                    checkName: obj.checkName,\n                    text: obj.text,\n                    handlers: handlers,\n                    status: obj.status,\n                    namespace: namespace,\n                    entityName: entityName,\n                ) / 100)}\n            }",
														Start: ast.Position{
															Column: 31,
															Line:   59,
														},
													},
												},
												Body: []ast.Statement{&ast.VariableAssignment{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 34,
																Line:   60,
															},
															File:   "sensu.flux",
															Source: "obj = mapFn(r: r)",
															Start: ast.Position{
																Column: 17,
																Line:   60,
															},
														},
													},
													ID: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 20,
																	Line:   60,
																},
																File:   "sensu.flux",
																Source: "obj",
																Start: ast.Position{
																	Column: 17,
																	Line:   60,
																},
															},
														},
														Name: "obj",
													},
													Init: &ast.CallExpression{
														Arguments: []ast.Expression{&ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 33,
																		Line:   60,
																	},
																	File:   "sensu.flux",
																	Source: "r: r",
																	Start: ast.Position{
																		Column: 29,
																		Line:   60,
																	},
																},
															},
															Lbrace: nil,
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 33,
																			Line:   60,
																		},
																		File:   "sensu.flux",
																		Source: "r: r",
																		Start: ast.Position{
																			Column: 29,
																			Line:   60,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 30,
																				Line:   60,
																			},
																			File:   "sensu.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 29,
																				Line:   60,
																			},
																		},
																	},
																	Name: "r",
																},
																Separator: nil,
																Value: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 33,
																				Line:   60,
																			},
																			File:   "sensu.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 32,
																				Line:   60,
																			},
																		},
																	},
																	Name: "r",
																},
															}},
															Rbrace: nil,
															With:   nil,
														}},
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 34,
																	Line:   60,
																},
																File:   "sensu.flux",
																Source: "mapFn(r: r)",
																Start: ast.Position{
																	Column: 23,
																	Line:   60,
																},
															},
														},
														Callee: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 28,
																		Line:   60,
																	},
																	File:   "sensu.flux",
																	Source: "mapFn",
																	Start: ast.Position{
																		Column: 23,
																		Line:   60,
																	},
																},
															},
															Name: "mapFn",
														},
														Lparen: nil,
														Rparen: nil,
													},
												}, &ast.ReturnStatement{
													Argument: &ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 26,
																	Line:   70,
																},
																File:   "sensu.flux",
																Source: "{r with _sent: string(v: 2 == event(\n                    url: url,\n                    apiKey: apiKey,\n                    checkName: obj.checkName,\n                    text: obj.text,\n                    handlers: handlers,\n                    status: obj.status,\n                    namespace: namespace,\n                    entityName: entityName,\n                ) / 100)}",
																Start: ast.Position{
																	Column: 24,
																	Line:   61,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 25,
																		Line:   70,
																	},
																	File:   "sensu.flux",
																	Source: "_sent: string(v: 2 == event(\n                    url: url,\n                    apiKey: apiKey,\n                    checkName: obj.checkName,\n                    text: obj.text,\n                    handlers: handlers,\n                    status: obj.status,\n                    namespace: namespace,\n                    entityName: entityName,\n                ) / 100)",
																	Start: ast.Position{
																		Column: 32,
																		Line:   61,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 37,
																			Line:   61,
																		},
																		File:   "sensu.flux",
																		Source: "_sent",
																		Start: ast.Position{
																			Column: 32,
																			Line:   61,
																		},
																	},
																},
																Name: "_sent",
															},
															Separator: nil,
															Value: &ast.CallExpression{
																Arguments: []ast.Expression{&ast.ObjectExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 24,
																				Line:   70,
																			},
																			File:   "sensu.flux",
																			Source: "v: 2 == event(\n                    url: url,\n                    apiKey: apiKey,\n                    checkName: obj.checkName,\n                    text: obj.text,\n                    handlers: handlers,\n                    status: obj.status,\n                    namespace: namespace,\n                    entityName: entityName,\n                ) / 100",
																			Start: ast.Position{
																				Column: 46,
																				Line:   61,
																			},
																		},
																	},
																	Lbrace: nil,
																	Properties: []*ast.Property{&ast.Property{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 24,
																					Line:   70,
																				},
																				File:   "sensu.flux",
																				Source: "v: 2 == event(\n                    url: url,\n                    apiKey: apiKey,\n                    checkName: obj.checkName,\n                    text: obj.text,\n                    handlers: handlers,\n                    status: obj.status,\n                    namespace: namespace,\n                    entityName: entityName,\n                ) / 100",
																				Start: ast.Position{
																					Column: 46,
																					Line:   61,
																				},
																			},
																		},
																		Comma: nil,
																		Key: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 47,
																						Line:   61,
																					},
																					File:   "sensu.flux",
																					Source: "v",
																					Start: ast.Position{
																						Column: 46,
																						Line:   61,
																					},
																				},
																			},
																			Name: "v",
																		},
																		Separator: nil,
																		Value: &ast.BinaryExpression{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 24,
																						Line:   70,
																					},
																					File:   "sensu.flux",
																					Source: "2 == event(\n                    url: url,\n                    apiKey: apiKey,\n                    checkName: obj.checkName,\n                    text: obj.text,\n                    handlers: handlers,\n                    status: obj.status,\n                    namespace: namespace,\n                    entityName: entityName,\n                ) / 100",
																					Start: ast.Position{
																						Column: 49,
																						Line:   61,
																					},
																				},
																			},
																			Left: &ast.IntegerLiteral{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 50,
																							Line:   61,
																						},
																						File:   "sensu.flux",
																						Source: "2",
																						Start: ast.Position{
																							Column: 49,
																							Line:   61,
																						},
																					},
																				},
																				Value: int64(2),
																			},
																			Operator: 17,
																			Right: &ast.BinaryExpression{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 24,
																							Line:   70,
																						},
																						File:   "sensu.flux",
																						Source: "event(\n                    url: url,\n                    apiKey: apiKey,\n                    checkName: obj.checkName,\n                    text: obj.text,\n                    handlers: handlers,\n                    status: obj.status,\n                    namespace: namespace,\n                    entityName: entityName,\n                ) / 100",
																						Start: ast.Position{
																							Column: 54,
																							Line:   61,
																						},
																					},
																				},
																				Left: &ast.CallExpression{
																					Arguments: []ast.Expression{&ast.ObjectExpression{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 43,
																									Line:   69,
																								},
																								File:   "sensu.flux",
																								Source: "url: url,\n                    apiKey: apiKey,\n                    checkName: obj.checkName,\n                    text: obj.text,\n                    handlers: handlers,\n                    status: obj.status,\n                    namespace: namespace,\n                    entityName: entityName",
																								Start: ast.Position{
																									Column: 21,
																									Line:   62,
																								},
																							},
																						},
																						Lbrace: nil,
																						Properties: []*ast.Property{&ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 29,
																										Line:   62,
																									},
																									File:   "sensu.flux",
																									Source: "url: url",
																									Start: ast.Position{
																										Column: 21,
																										Line:   62,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 24,
																											Line:   62,
																										},
																										File:   "sensu.flux",
																										Source: "url",
																										Start: ast.Position{
																											Column: 21,
																											Line:   62,
																										},
																									},
																								},
																								Name: "url",
																							},
																							Separator: nil,
																							Value: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 29,
																											Line:   62,
																										},
																										File:   "sensu.flux",
																										Source: "url",
																										Start: ast.Position{
																											Column: 26,
																											Line:   62,
																										},
																									},
																								},
																								Name: "url",
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 35,
																										Line:   63,
																									},
																									File:   "sensu.flux",
																									Source: "apiKey: apiKey",
																									Start: ast.Position{
																										Column: 21,
																										Line:   63,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 27,
																											Line:   63,
																										},
																										File:   "sensu.flux",
																										Source: "apiKey",
																										Start: ast.Position{
																											Column: 21,
																											Line:   63,
																										},
																									},
																								},
																								Name: "apiKey",
																							},
																							Separator: nil,
																							Value: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 35,
																											Line:   63,
																										},
																										File:   "sensu.flux",
																										Source: "apiKey",
																										Start: ast.Position{
																											Column: 29,
																											Line:   63,
																										},
																									},
																								},
																								Name: "apiKey",
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 45,
																										Line:   64,
																									},
																									File:   "sensu.flux",
																									Source: "checkName: obj.checkName",
																									Start: ast.Position{
																										Column: 21,
																										Line:   64,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 30,
																											Line:   64,
																										},
																										File:   "sensu.flux",
																										Source: "checkName",
																										Start: ast.Position{
																											Column: 21,
																											Line:   64,
																										},
																									},
																								},
																								Name: "checkName",
																							},
																							Separator: nil,
																							Value: &ast.MemberExpression{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 45,
																											Line:   64,
																										},
																										File:   "sensu.flux",
																										Source: "obj.checkName",
																										Start: ast.Position{
																											Column: 32,
																											Line:   64,
																										},
																									},
																								},
																								Lbrack: nil,
																								Object: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 35,
																												Line:   64,
																											},
																											File:   "sensu.flux",
																											Source: "obj",
																											Start: ast.Position{
																												Column: 32,
																												Line:   64,
																											},
																										},
																									},
																									Name: "obj",
																								},
																								Property: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 45,
																												Line:   64,
																											},
																											File:   "sensu.flux",
																											Source: "checkName",
																											Start: ast.Position{
																												Column: 36,
																												Line:   64,
																											},
																										},
																									},
																									Name: "checkName",
																								},
																								Rbrack: nil,
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 35,
																										Line:   65,
																									},
																									File:   "sensu.flux",
																									Source: "text: obj.text",
																									Start: ast.Position{
																										Column: 21,
																										Line:   65,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 25,
																											Line:   65,
																										},
																										File:   "sensu.flux",
																										Source: "text",
																										Start: ast.Position{
																											Column: 21,
																											Line:   65,
																										},
																									},
																								},
																								Name: "text",
																							},
																							Separator: nil,
																							Value: &ast.MemberExpression{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 35,
																											Line:   65,
																										},
																										File:   "sensu.flux",
																										Source: "obj.text",
																										Start: ast.Position{
																											Column: 27,
																											Line:   65,
																										},
																									},
																								},
																								Lbrack: nil,
																								Object: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 30,
																												Line:   65,
																											},
																											File:   "sensu.flux",
																											Source: "obj",
																											Start: ast.Position{
																												Column: 27,
																												Line:   65,
																											},
																										},
																									},
																									Name: "obj",
																								},
																								Property: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 35,
																												Line:   65,
																											},
																											File:   "sensu.flux",
																											Source: "text",
																											Start: ast.Position{
																												Column: 31,
																												Line:   65,
																											},
																										},
																									},
																									Name: "text",
																								},
																								Rbrack: nil,
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 39,
																										Line:   66,
																									},
																									File:   "sensu.flux",
																									Source: "handlers: handlers",
																									Start: ast.Position{
																										Column: 21,
																										Line:   66,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 29,
																											Line:   66,
																										},
																										File:   "sensu.flux",
																										Source: "handlers",
																										Start: ast.Position{
																											Column: 21,
																											Line:   66,
																										},
																									},
																								},
																								Name: "handlers",
																							},
																							Separator: nil,
																							Value: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 39,
																											Line:   66,
																										},
																										File:   "sensu.flux",
																										Source: "handlers",
																										Start: ast.Position{
																											Column: 31,
																											Line:   66,
																										},
																									},
																								},
																								Name: "handlers",
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 39,
																										Line:   67,
																									},
																									File:   "sensu.flux",
																									Source: "status: obj.status",
																									Start: ast.Position{
																										Column: 21,
																										Line:   67,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 27,
																											Line:   67,
																										},
																										File:   "sensu.flux",
																										Source: "status",
																										Start: ast.Position{
																											Column: 21,
																											Line:   67,
																										},
																									},
																								},
																								Name: "status",
																							},
																							Separator: nil,
																							Value: &ast.MemberExpression{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 39,
																											Line:   67,
																										},
																										File:   "sensu.flux",
																										Source: "obj.status",
																										Start: ast.Position{
																											Column: 29,
																											Line:   67,
																										},
																									},
																								},
																								Lbrack: nil,
																								Object: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 32,
																												Line:   67,
																											},
																											File:   "sensu.flux",
																											Source: "obj",
																											Start: ast.Position{
																												Column: 29,
																												Line:   67,
																											},
																										},
																									},
																									Name: "obj",
																								},
																								Property: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 39,
																												Line:   67,
																											},
																											File:   "sensu.flux",
																											Source: "status",
																											Start: ast.Position{
																												Column: 33,
																												Line:   67,
																											},
																										},
																									},
																									Name: "status",
																								},
																								Rbrack: nil,
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 41,
																										Line:   68,
																									},
																									File:   "sensu.flux",
																									Source: "namespace: namespace",
																									Start: ast.Position{
																										Column: 21,
																										Line:   68,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 30,
																											Line:   68,
																										},
																										File:   "sensu.flux",
																										Source: "namespace",
																										Start: ast.Position{
																											Column: 21,
																											Line:   68,
																										},
																									},
																								},
																								Name: "namespace",
																							},
																							Separator: nil,
																							Value: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 41,
																											Line:   68,
																										},
																										File:   "sensu.flux",
																										Source: "namespace",
																										Start: ast.Position{
																											Column: 32,
																											Line:   68,
																										},
																									},
																								},
																								Name: "namespace",
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 43,
																										Line:   69,
																									},
																									File:   "sensu.flux",
																									Source: "entityName: entityName",
																									Start: ast.Position{
																										Column: 21,
																										Line:   69,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 31,
																											Line:   69,
																										},
																										File:   "sensu.flux",
																										Source: "entityName",
																										Start: ast.Position{
																											Column: 21,
																											Line:   69,
																										},
																									},
																								},
																								Name: "entityName",
																							},
																							Separator: nil,
																							Value: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 43,
																											Line:   69,
																										},
																										File:   "sensu.flux",
																										Source: "entityName",
																										Start: ast.Position{
																											Column: 33,
																											Line:   69,
																										},
																									},
																								},
																								Name: "entityName",
																							},
																						}},
																						Rbrace: nil,
																						With:   nil,
																					}},
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 18,
																								Line:   70,
																							},
																							File:   "sensu.flux",
																							Source: "event(\n                    url: url,\n                    apiKey: apiKey,\n                    checkName: obj.checkName,\n                    text: obj.text,\n                    handlers: handlers,\n                    status: obj.status,\n                    namespace: namespace,\n                    entityName: entityName,\n                )",
																							Start: ast.Position{
																								Column: 54,
																								Line:   61,
																							},
																						},
																					},
																					Callee: &ast.Identifier{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 59,
																									Line:   61,
																								},
																								File:   "sensu.flux",
																								Source: "event",
																								Start: ast.Position{
																									Column: 54,
																									Line:   61,
																								},
																							},
																						},
																						Name: "event",
																					},
																					Lparen: nil,
																					Rparen: nil,
																				},
																				Operator: 2,
																				Right: &ast.IntegerLiteral{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 24,
																								Line:   70,
																							},
																							File:   "sensu.flux",
																							Source: "100",
																							Start: ast.Position{
																								Column: 21,
																								Line:   70,
																							},
																						},
																					},
																					Value: int64(100),
																				},
																			},
																		},
																	}},
																	Rbrace: nil,
																	With:   nil,
																}},
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 25,
																			Line:   70,
																		},
																		File:   "sensu.flux",
																		Source: "string(v: 2 == event(\n                    url: url,\n                    apiKey: apiKey,\n                    checkName: obj.checkName,\n                    text: obj.text,\n                    handlers: handlers,\n                    status: obj.status,\n                    namespace: namespace,\n                    entityName: entityName,\n                ) / 100)",
																		Start: ast.Position{
																			Column: 39,
																			Line:   61,
																		},
																	},
																},
																Callee: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 45,
																				Line:   61,
																			},
																			File:   "sensu.flux",
																			Source: "string",
																			Start: ast.Position{
																				Column: 39,
																				Line:   61,
																			},
																		},
																	},
																	Name: "string",
																},
																Lparen: nil,
																Rparen: nil,
															},
														}},
														Rbrace: nil,
														With: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 26,
																		Line:   61,
																	},
																	File:   "sensu.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 25,
																		Line:   61,
																	},
																},
															},
															Name: "r",
														},
													},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 26,
																Line:   70,
															},
															File:   "sensu.flux",
															Source: "return {r with _sent: string(v: 2 == event(\n                    url: url,\n                    apiKey: apiKey,\n                    checkName: obj.checkName,\n                    text: obj.text,\n                    handlers: handlers,\n                    status: obj.status,\n                    namespace: namespace,\n                    entityName: entityName,\n                ) / 100)}",
															Start: ast.Position{
																Column: 17,
																Line:   61,
															},
														},
													},
												}},
												Lbrace: nil,
												Rbrace: nil,
											},
											Lparen: nil,
											Params: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 26,
															Line:   59,
														},
														File:   "sensu.flux",
														Source: "r",
														Start: ast.Position{
															Column: 25,
															Line:   59,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 26,
																Line:   59,
															},
															File:   "sensu.flux",
															Source: "r",
															Start: ast.Position{
																Column: 25,
																Line:   59,
															},
														},
													},
													Name: "r",
												},
												Separator: nil,
												Value:     nil,
											}},
											Rparan: nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 15,
											Line:   71,
										},
										File:   "sensu.flux",
										Source: "map(fn: (r) => {\n                obj = mapFn(r: r)\n                return {r with _sent: string(v: 2 == event(\n                    url: url,\n                    apiKey: apiKey,\n                    checkName: obj.checkName,\n                    text: obj.text,\n                    handlers: handlers,\n                    status: obj.status,\n                    namespace: namespace,\n                    entityName: entityName,\n                ) / 100)}\n            })",
										Start: ast.Position{
											Column: 16,
											Line:   59,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 19,
												Line:   59,
											},
											File:   "sensu.flux",
											Source: "map",
											Start: ast.Position{
												Column: 16,
												Line:   59,
											},
										},
									},
									Name: "map",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						Lparen: nil,
						Params: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 19,
										Line:   58,
									},
									File:   "sensu.flux",
									Source: "tables=<-",
									Start: ast.Position{
										Column: 10,
										Line:   58,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 16,
											Line:   58,
										},
										File:   "sensu.flux",
										Source: "tables",
										Start: ast.Position{
											Column: 10,
											Line:   58,
										},
									},
								},
								Name: "tables",
							},
							Separator: nil,
							Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 19,
										Line:   58,
									},
									File:   "sensu.flux",
									Source: "<-",
									Start: ast.Position{
										Column: 17,
										Line:   58,
									},
								},
							}},
						}},
						Rparan: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{&ast.Property{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 11,
									Line:   57,
								},
								File:   "sensu.flux",
								Source: "mapFn",
								Start: ast.Position{
									Column: 6,
									Line:   57,
								},
							},
						},
						Comma: nil,
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   57,
									},
									File:   "sensu.flux",
									Source: "mapFn",
									Start: ast.Position{
										Column: 6,
										Line:   57,
									},
								},
							},
							Name: "mapFn",
						},
						Separator: nil,
						Value:     nil,
					}},
					Rparan: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 16,
								Line:   56,
							},
							File:   "sensu.flux",
							Source: "url",
							Start: ast.Position{
								Column: 13,
								Line:   56,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   56,
								},
								File:   "sensu.flux",
								Source: "url",
								Start: ast.Position{
									Column: 13,
									Line:   56,
								},
							},
						},
						Name: "url",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 24,
								Line:   56,
							},
							File:   "sensu.flux",
							Source: "apiKey",
							Start: ast.Position{
								Column: 18,
								Line:   56,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 24,
									Line:   56,
								},
								File:   "sensu.flux",
								Source: "apiKey",
								Start: ast.Position{
									Column: 18,
									Line:   56,
								},
							},
						},
						Name: "apiKey",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 39,
								Line:   56,
							},
							File:   "sensu.flux",
							Source: "handlers = []",
							Start: ast.Position{
								Column: 26,
								Line:   56,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   56,
								},
								File:   "sensu.flux",
								Source: "handlers",
								Start: ast.Position{
									Column: 26,
									Line:   56,
								},
							},
						},
						Name: "handlers",
					},
					Separator: nil,
					Value: &ast.ArrayExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 39,
									Line:   56,
								},
								File:   "sensu.flux",
								Source: "[]",
								Start: ast.Position{
									Column: 37,
									Line:   56,
								},
							},
						},
						Elements: []ast.Expression{},
						Lbrack:   nil,
						Rbrack:   nil,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 60,
								Line:   56,
							},
							File:   "sensu.flux",
							Source: "namespace=\"default\"",
							Start: ast.Position{
								Column: 41,
								Line:   56,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 50,
									Line:   56,
								},
								File:   "sensu.flux",
								Source: "namespace",
								Start: ast.Position{
									Column: 41,
									Line:   56,
								},
							},
						},
						Name: "namespace",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 60,
									Line:   56,
								},
								File:   "sensu.flux",
								Source: "\"default\"",
								Start: ast.Position{
									Column: 51,
									Line:   56,
								},
							},
						},
						Value: "default",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 83,
								Line:   56,
							},
							File:   "sensu.flux",
							Source: "entityName=\"influxdb\"",
							Start: ast.Position{
								Column: 62,
								Line:   56,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 72,
									Line:   56,
								},
								File:   "sensu.flux",
								Source: "entityName",
								Start: ast.Position{
									Column: 62,
									Line:   56,
								},
							},
						},
						Name: "entityName",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 83,
									Line:   56,
								},
								File:   "sensu.flux",
								Source: "\"influxdb\"",
								Start: ast.Position{
									Column: 73,
									Line:   56,
								},
							},
						},
						Value: "influxdb",
					},
				}},
				Rparan: nil,
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   3,
					},
					File:   "sensu.flux",
					Source: "import \"http\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   3,
						},
						File:   "sensu.flux",
						Source: "\"http\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "http",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   4,
					},
					File:   "sensu.flux",
					Source: "import \"json\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   4,
						},
						File:   "sensu.flux",
						Source: "\"json\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "json",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "sensu.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   1,
					},
					File:   "sensu.flux",
					Source: "package sensu",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   1,
						},
						File:   "sensu.flux",
						Source: "sensu",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "sensu",
			},
		},
	}},
	Package: "sensu",
	Path:    "contrib/sranka/sensu",
}
