// DO NOT EDIT: This file is autogenerated via the builtin command.

package testdata

import (
	ast "github.com/influxdata/flux/ast"
	parser "github.com/influxdata/flux/internal/parser"
)

var FluxTestPackages = []*ast.Package{&ast.Package{
	BaseNode: ast.BaseNode{
		Comments: nil,
		Errors:   nil,
		Loc:      nil,
	},
	Files: []*ast.File{&ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 102,
					Line:   46,
				},
				File:   "combine_pivot_test.flux",
				Source: "package testdata_test\n\nimport \"testing\"\n\noption now = () => (2030-01-01T00:00:00Z)\n\ninData = \"\n#datatype,string,long,string,dateTime:RFC3339,double,string\n#group,false,false,true,false,false,true\n#default,_result,,,,,\n,result,table,_measurement,_time,_value,_field\n,,0,memory,2018-12-19T22:13:30Z,1,user1\n,,0,memory,2018-12-19T22:13:40Z,5,user1\n,,0,memory,2018-12-19T22:13:50Z,3,user1\n,,0,memory,2018-12-19T22:14:00Z,6,user1\n,,0,memory,2018-12-19T22:14:10Z,6,user1\n,,0,memory,2018-12-19T22:14:20Z,3,user1\n,,1,memory,2018-12-19T22:13:30Z,6,user2\n,,1,memory,2018-12-19T22:13:40Z,7,user2\n,,1,memory,2018-12-19T22:13:50Z,3,user2\n,,1,memory,2018-12-19T22:14:00Z,4,user2\n,,1,memory,2018-12-19T22:14:10Z,9,user2\n,,1,memory,2018-12-19T22:14:20Z,8,user2\n\"\n\noutData = \"\n#datatype,string,long,string,dateTime:RFC3339,double,double\n#group,false,false,true,false,false,false\n#default,_result,,,,,\n,result,table,_measurement,_time,user1,user2\n,,0,memory,2018-12-19T22:13:30Z,1,6\n,,0,memory,2018-12-19T22:13:40Z,5,7\n,,0,memory,2018-12-19T22:13:50Z,3,3\n,,0,memory,2018-12-19T22:14:00Z,6,4\n,,0,memory,2018-12-19T22:14:10Z,6,9\n,,0,memory,2018-12-19T22:14:20Z,3,8\n\"\n\nt_combine_join = (table=<-) =>\n    (table\n        |> range(start: 2018-12-15T00:00:00Z)\n        |> drop(columns: [\"_start\", \"_stop\"])\n\t\t|> pivot(rowKey:[\"_time\", \"_measurement\"], columnKey: [\"_field\"], valueColumn: \"_value\"))\n\ntest _combine_join = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_combine_join})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   5,
						},
						File:   "combine_pivot_test.flux",
						Source: "now = () => (2030-01-01T00:00:00Z)",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   5,
							},
							File:   "combine_pivot_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   5,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   5,
							},
							File:   "combine_pivot_test.flux",
							Source: "() => (2030-01-01T00:00:00Z)",
							Start: ast.Position{
								Column: 14,
								Line:   5,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   5,
								},
								File:   "combine_pivot_test.flux",
								Source: "(2030-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 20,
									Line:   5,
								},
							},
						},
						Expression: &ast.DateTimeLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   5,
									},
									File:   "combine_pivot_test.flux",
									Source: "2030-01-01T00:00:00Z",
									Start: ast.Position{
										Column: 21,
										Line:   5,
									},
								},
							},
							Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 42,
						Line:   5,
					},
					File:   "combine_pivot_test.flux",
					Source: "option now = () => (2030-01-01T00:00:00Z)",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   24,
					},
					File:   "combine_pivot_test.flux",
					Source: "inData = \"\n#datatype,string,long,string,dateTime:RFC3339,double,string\n#group,false,false,true,false,false,true\n#default,_result,,,,,\n,result,table,_measurement,_time,_value,_field\n,,0,memory,2018-12-19T22:13:30Z,1,user1\n,,0,memory,2018-12-19T22:13:40Z,5,user1\n,,0,memory,2018-12-19T22:13:50Z,3,user1\n,,0,memory,2018-12-19T22:14:00Z,6,user1\n,,0,memory,2018-12-19T22:14:10Z,6,user1\n,,0,memory,2018-12-19T22:14:20Z,3,user1\n,,1,memory,2018-12-19T22:13:30Z,6,user2\n,,1,memory,2018-12-19T22:13:40Z,7,user2\n,,1,memory,2018-12-19T22:13:50Z,3,user2\n,,1,memory,2018-12-19T22:14:00Z,4,user2\n,,1,memory,2018-12-19T22:14:10Z,9,user2\n,,1,memory,2018-12-19T22:14:20Z,8,user2\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   7,
						},
						File:   "combine_pivot_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   7,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   24,
						},
						File:   "combine_pivot_test.flux",
						Source: "\"\n#datatype,string,long,string,dateTime:RFC3339,double,string\n#group,false,false,true,false,false,true\n#default,_result,,,,,\n,result,table,_measurement,_time,_value,_field\n,,0,memory,2018-12-19T22:13:30Z,1,user1\n,,0,memory,2018-12-19T22:13:40Z,5,user1\n,,0,memory,2018-12-19T22:13:50Z,3,user1\n,,0,memory,2018-12-19T22:14:00Z,6,user1\n,,0,memory,2018-12-19T22:14:10Z,6,user1\n,,0,memory,2018-12-19T22:14:20Z,3,user1\n,,1,memory,2018-12-19T22:13:30Z,6,user2\n,,1,memory,2018-12-19T22:13:40Z,7,user2\n,,1,memory,2018-12-19T22:13:50Z,3,user2\n,,1,memory,2018-12-19T22:14:00Z,4,user2\n,,1,memory,2018-12-19T22:14:10Z,9,user2\n,,1,memory,2018-12-19T22:14:20Z,8,user2\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   7,
						},
					},
				},
				Value: "\n#datatype,string,long,string,dateTime:RFC3339,double,string\n#group,false,false,true,false,false,true\n#default,_result,,,,,\n,result,table,_measurement,_time,_value,_field\n,,0,memory,2018-12-19T22:13:30Z,1,user1\n,,0,memory,2018-12-19T22:13:40Z,5,user1\n,,0,memory,2018-12-19T22:13:50Z,3,user1\n,,0,memory,2018-12-19T22:14:00Z,6,user1\n,,0,memory,2018-12-19T22:14:10Z,6,user1\n,,0,memory,2018-12-19T22:14:20Z,3,user1\n,,1,memory,2018-12-19T22:13:30Z,6,user2\n,,1,memory,2018-12-19T22:13:40Z,7,user2\n,,1,memory,2018-12-19T22:13:50Z,3,user2\n,,1,memory,2018-12-19T22:14:00Z,4,user2\n,,1,memory,2018-12-19T22:14:10Z,9,user2\n,,1,memory,2018-12-19T22:14:20Z,8,user2\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   37,
					},
					File:   "combine_pivot_test.flux",
					Source: "outData = \"\n#datatype,string,long,string,dateTime:RFC3339,double,double\n#group,false,false,true,false,false,false\n#default,_result,,,,,\n,result,table,_measurement,_time,user1,user2\n,,0,memory,2018-12-19T22:13:30Z,1,6\n,,0,memory,2018-12-19T22:13:40Z,5,7\n,,0,memory,2018-12-19T22:13:50Z,3,3\n,,0,memory,2018-12-19T22:14:00Z,6,4\n,,0,memory,2018-12-19T22:14:10Z,6,9\n,,0,memory,2018-12-19T22:14:20Z,3,8\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   26,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   26,
						},
						File:   "combine_pivot_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   26,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   37,
						},
						File:   "combine_pivot_test.flux",
						Source: "\"\n#datatype,string,long,string,dateTime:RFC3339,double,double\n#group,false,false,true,false,false,false\n#default,_result,,,,,\n,result,table,_measurement,_time,user1,user2\n,,0,memory,2018-12-19T22:13:30Z,1,6\n,,0,memory,2018-12-19T22:13:40Z,5,7\n,,0,memory,2018-12-19T22:13:50Z,3,3\n,,0,memory,2018-12-19T22:14:00Z,6,4\n,,0,memory,2018-12-19T22:14:10Z,6,9\n,,0,memory,2018-12-19T22:14:20Z,3,8\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   26,
						},
					},
				},
				Value: "\n#datatype,string,long,string,dateTime:RFC3339,double,double\n#group,false,false,true,false,false,false\n#default,_result,,,,,\n,result,table,_measurement,_time,user1,user2\n,,0,memory,2018-12-19T22:13:30Z,1,6\n,,0,memory,2018-12-19T22:13:40Z,5,7\n,,0,memory,2018-12-19T22:13:50Z,3,3\n,,0,memory,2018-12-19T22:14:00Z,6,4\n,,0,memory,2018-12-19T22:14:10Z,6,9\n,,0,memory,2018-12-19T22:14:20Z,3,8\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 92,
						Line:   43,
					},
					File:   "combine_pivot_test.flux",
					Source: "t_combine_join = (table=<-) =>\n    (table\n        |> range(start: 2018-12-15T00:00:00Z)\n        |> drop(columns: [\"_start\", \"_stop\"])\n\t\t|> pivot(rowKey:[\"_time\", \"_measurement\"], columnKey: [\"_field\"], valueColumn: \"_value\"))",
					Start: ast.Position{
						Column: 1,
						Line:   39,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   39,
						},
						File:   "combine_pivot_test.flux",
						Source: "t_combine_join",
						Start: ast.Position{
							Column: 1,
							Line:   39,
						},
					},
				},
				Name: "t_combine_join",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 92,
							Line:   43,
						},
						File:   "combine_pivot_test.flux",
						Source: "(table=<-) =>\n    (table\n        |> range(start: 2018-12-15T00:00:00Z)\n        |> drop(columns: [\"_start\", \"_stop\"])\n\t\t|> pivot(rowKey:[\"_time\", \"_measurement\"], columnKey: [\"_field\"], valueColumn: \"_value\"))",
						Start: ast.Position{
							Column: 18,
							Line:   39,
						},
					},
				},
				Body: &ast.ParenExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 92,
								Line:   43,
							},
							File:   "combine_pivot_test.flux",
							Source: "(table\n        |> range(start: 2018-12-15T00:00:00Z)\n        |> drop(columns: [\"_start\", \"_stop\"])\n\t\t|> pivot(rowKey:[\"_time\", \"_measurement\"], columnKey: [\"_field\"], valueColumn: \"_value\"))",
							Start: ast.Position{
								Column: 5,
								Line:   40,
							},
						},
					},
					Expression: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   40,
											},
											File:   "combine_pivot_test.flux",
											Source: "table",
											Start: ast.Position{
												Column: 6,
												Line:   40,
											},
										},
									},
									Name: "table",
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 46,
											Line:   41,
										},
										File:   "combine_pivot_test.flux",
										Source: "table\n        |> range(start: 2018-12-15T00:00:00Z)",
										Start: ast.Position{
											Column: 6,
											Line:   40,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 45,
													Line:   41,
												},
												File:   "combine_pivot_test.flux",
												Source: "start: 2018-12-15T00:00:00Z",
												Start: ast.Position{
													Column: 18,
													Line:   41,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 45,
														Line:   41,
													},
													File:   "combine_pivot_test.flux",
													Source: "start: 2018-12-15T00:00:00Z",
													Start: ast.Position{
														Column: 18,
														Line:   41,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 23,
															Line:   41,
														},
														File:   "combine_pivot_test.flux",
														Source: "start",
														Start: ast.Position{
															Column: 18,
															Line:   41,
														},
													},
												},
												Name: "start",
											},
											Separator: nil,
											Value: &ast.DateTimeLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 45,
															Line:   41,
														},
														File:   "combine_pivot_test.flux",
														Source: "2018-12-15T00:00:00Z",
														Start: ast.Position{
															Column: 25,
															Line:   41,
														},
													},
												},
												Value: parser.MustParseTime("2018-12-15T00:00:00Z"),
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 46,
												Line:   41,
											},
											File:   "combine_pivot_test.flux",
											Source: "range(start: 2018-12-15T00:00:00Z)",
											Start: ast.Position{
												Column: 12,
												Line:   41,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 17,
													Line:   41,
												},
												File:   "combine_pivot_test.flux",
												Source: "range",
												Start: ast.Position{
													Column: 12,
													Line:   41,
												},
											},
										},
										Name: "range",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 46,
										Line:   42,
									},
									File:   "combine_pivot_test.flux",
									Source: "table\n        |> range(start: 2018-12-15T00:00:00Z)\n        |> drop(columns: [\"_start\", \"_stop\"])",
									Start: ast.Position{
										Column: 6,
										Line:   40,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 45,
												Line:   42,
											},
											File:   "combine_pivot_test.flux",
											Source: "columns: [\"_start\", \"_stop\"]",
											Start: ast.Position{
												Column: 17,
												Line:   42,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 45,
													Line:   42,
												},
												File:   "combine_pivot_test.flux",
												Source: "columns: [\"_start\", \"_stop\"]",
												Start: ast.Position{
													Column: 17,
													Line:   42,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 24,
														Line:   42,
													},
													File:   "combine_pivot_test.flux",
													Source: "columns",
													Start: ast.Position{
														Column: 17,
														Line:   42,
													},
												},
											},
											Name: "columns",
										},
										Separator: nil,
										Value: &ast.ArrayExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 45,
														Line:   42,
													},
													File:   "combine_pivot_test.flux",
													Source: "[\"_start\", \"_stop\"]",
													Start: ast.Position{
														Column: 26,
														Line:   42,
													},
												},
											},
											Elements: []ast.Expression{&ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 35,
															Line:   42,
														},
														File:   "combine_pivot_test.flux",
														Source: "\"_start\"",
														Start: ast.Position{
															Column: 27,
															Line:   42,
														},
													},
												},
												Value: "_start",
											}, &ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 44,
															Line:   42,
														},
														File:   "combine_pivot_test.flux",
														Source: "\"_stop\"",
														Start: ast.Position{
															Column: 37,
															Line:   42,
														},
													},
												},
												Value: "_stop",
											}},
											Lbrack: nil,
											Rbrack: nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 46,
											Line:   42,
										},
										File:   "combine_pivot_test.flux",
										Source: "drop(columns: [\"_start\", \"_stop\"])",
										Start: ast.Position{
											Column: 12,
											Line:   42,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 16,
												Line:   42,
											},
											File:   "combine_pivot_test.flux",
											Source: "drop",
											Start: ast.Position{
												Column: 12,
												Line:   42,
											},
										},
									},
									Name: "drop",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 91,
									Line:   43,
								},
								File:   "combine_pivot_test.flux",
								Source: "table\n        |> range(start: 2018-12-15T00:00:00Z)\n        |> drop(columns: [\"_start\", \"_stop\"])\n\t\t|> pivot(rowKey:[\"_time\", \"_measurement\"], columnKey: [\"_field\"], valueColumn: \"_value\")",
								Start: ast.Position{
									Column: 6,
									Line:   40,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 90,
											Line:   43,
										},
										File:   "combine_pivot_test.flux",
										Source: "rowKey:[\"_time\", \"_measurement\"], columnKey: [\"_field\"], valueColumn: \"_value\"",
										Start: ast.Position{
											Column: 12,
											Line:   43,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 44,
												Line:   43,
											},
											File:   "combine_pivot_test.flux",
											Source: "rowKey:[\"_time\", \"_measurement\"]",
											Start: ast.Position{
												Column: 12,
												Line:   43,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   43,
												},
												File:   "combine_pivot_test.flux",
												Source: "rowKey",
												Start: ast.Position{
													Column: 12,
													Line:   43,
												},
											},
										},
										Name: "rowKey",
									},
									Separator: nil,
									Value: &ast.ArrayExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 44,
													Line:   43,
												},
												File:   "combine_pivot_test.flux",
												Source: "[\"_time\", \"_measurement\"]",
												Start: ast.Position{
													Column: 19,
													Line:   43,
												},
											},
										},
										Elements: []ast.Expression{&ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 27,
														Line:   43,
													},
													File:   "combine_pivot_test.flux",
													Source: "\"_time\"",
													Start: ast.Position{
														Column: 20,
														Line:   43,
													},
												},
											},
											Value: "_time",
										}, &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 43,
														Line:   43,
													},
													File:   "combine_pivot_test.flux",
													Source: "\"_measurement\"",
													Start: ast.Position{
														Column: 29,
														Line:   43,
													},
												},
											},
											Value: "_measurement",
										}},
										Lbrack: nil,
										Rbrack: nil,
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 67,
												Line:   43,
											},
											File:   "combine_pivot_test.flux",
											Source: "columnKey: [\"_field\"]",
											Start: ast.Position{
												Column: 46,
												Line:   43,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 55,
													Line:   43,
												},
												File:   "combine_pivot_test.flux",
												Source: "columnKey",
												Start: ast.Position{
													Column: 46,
													Line:   43,
												},
											},
										},
										Name: "columnKey",
									},
									Separator: nil,
									Value: &ast.ArrayExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 67,
													Line:   43,
												},
												File:   "combine_pivot_test.flux",
												Source: "[\"_field\"]",
												Start: ast.Position{
													Column: 57,
													Line:   43,
												},
											},
										},
										Elements: []ast.Expression{&ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 66,
														Line:   43,
													},
													File:   "combine_pivot_test.flux",
													Source: "\"_field\"",
													Start: ast.Position{
														Column: 58,
														Line:   43,
													},
												},
											},
											Value: "_field",
										}},
										Lbrack: nil,
										Rbrack: nil,
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 90,
												Line:   43,
											},
											File:   "combine_pivot_test.flux",
											Source: "valueColumn: \"_value\"",
											Start: ast.Position{
												Column: 69,
												Line:   43,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 80,
													Line:   43,
												},
												File:   "combine_pivot_test.flux",
												Source: "valueColumn",
												Start: ast.Position{
													Column: 69,
													Line:   43,
												},
											},
										},
										Name: "valueColumn",
									},
									Separator: nil,
									Value: &ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 90,
													Line:   43,
												},
												File:   "combine_pivot_test.flux",
												Source: "\"_value\"",
												Start: ast.Position{
													Column: 82,
													Line:   43,
												},
											},
										},
										Value: "_value",
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 91,
										Line:   43,
									},
									File:   "combine_pivot_test.flux",
									Source: "pivot(rowKey:[\"_time\", \"_measurement\"], columnKey: [\"_field\"], valueColumn: \"_value\")",
									Start: ast.Position{
										Column: 6,
										Line:   43,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 11,
											Line:   43,
										},
										File:   "combine_pivot_test.flux",
										Source: "pivot",
										Start: ast.Position{
											Column: 6,
											Line:   43,
										},
									},
								},
								Name: "pivot",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					Lparen: nil,
					Rparen: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 27,
								Line:   39,
							},
							File:   "combine_pivot_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 19,
								Line:   39,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 24,
									Line:   39,
								},
								File:   "combine_pivot_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 19,
									Line:   39,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 27,
								Line:   39,
							},
							File:   "combine_pivot_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 25,
								Line:   39,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 102,
							Line:   46,
						},
						File:   "combine_pivot_test.flux",
						Source: "_combine_join = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_combine_join})",
						Start: ast.Position{
							Column: 6,
							Line:   45,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 19,
								Line:   45,
							},
							File:   "combine_pivot_test.flux",
							Source: "_combine_join",
							Start: ast.Position{
								Column: 6,
								Line:   45,
							},
						},
					},
					Name: "_combine_join",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 102,
								Line:   46,
							},
							File:   "combine_pivot_test.flux",
							Source: "() =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_combine_join})",
							Start: ast.Position{
								Column: 22,
								Line:   45,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 102,
									Line:   46,
								},
								File:   "combine_pivot_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_combine_join})",
								Start: ast.Position{
									Column: 2,
									Line:   46,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 101,
										Line:   46,
									},
									File:   "combine_pivot_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_combine_join}",
									Start: ast.Position{
										Column: 3,
										Line:   46,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   46,
										},
										File:   "combine_pivot_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 4,
											Line:   46,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 9,
												Line:   46,
											},
											File:   "combine_pivot_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 4,
												Line:   46,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 42,
													Line:   46,
												},
												File:   "combine_pivot_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 31,
													Line:   46,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 42,
														Line:   46,
													},
													File:   "combine_pivot_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 31,
														Line:   46,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 34,
															Line:   46,
														},
														File:   "combine_pivot_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 31,
															Line:   46,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 42,
															Line:   46,
														},
														File:   "combine_pivot_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 36,
															Line:   46,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   46,
											},
											File:   "combine_pivot_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 11,
												Line:   46,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   46,
												},
												File:   "combine_pivot_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 11,
													Line:   46,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   46,
													},
													File:   "combine_pivot_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 11,
														Line:   46,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 30,
														Line:   46,
													},
													File:   "combine_pivot_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 19,
														Line:   46,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 80,
											Line:   46,
										},
										File:   "combine_pivot_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 45,
											Line:   46,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   46,
											},
											File:   "combine_pivot_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 45,
												Line:   46,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 79,
													Line:   46,
												},
												File:   "combine_pivot_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 67,
													Line:   46,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 79,
														Line:   46,
													},
													File:   "combine_pivot_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 67,
														Line:   46,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 70,
															Line:   46,
														},
														File:   "combine_pivot_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 67,
															Line:   46,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 79,
															Line:   46,
														},
														File:   "combine_pivot_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 72,
															Line:   46,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 80,
												Line:   46,
											},
											File:   "combine_pivot_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 51,
												Line:   46,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 66,
													Line:   46,
												},
												File:   "combine_pivot_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 51,
													Line:   46,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 58,
														Line:   46,
													},
													File:   "combine_pivot_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 51,
														Line:   46,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 66,
														Line:   46,
													},
													File:   "combine_pivot_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 59,
														Line:   46,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 100,
											Line:   46,
										},
										File:   "combine_pivot_test.flux",
										Source: "fn: t_combine_join",
										Start: ast.Position{
											Column: 82,
											Line:   46,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 84,
												Line:   46,
											},
											File:   "combine_pivot_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 82,
												Line:   46,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 100,
												Line:   46,
											},
											File:   "combine_pivot_test.flux",
											Source: "t_combine_join",
											Start: ast.Position{
												Column: 86,
												Line:   46,
											},
										},
									},
									Name: "t_combine_join",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 102,
						Line:   46,
					},
					File:   "combine_pivot_test.flux",
					Source: "test _combine_join = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_combine_join})",
					Start: ast.Position{
						Column: 1,
						Line:   45,
					},
				},
			},
		}},
		Eof: []ast.Comment{ast.Comment{Text: "// Equivalent TICKscript query:\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// stream\n"}, ast.Comment{Text: "//    |from()\n"}, ast.Comment{Text: "//      .measurement('request_latency')\n"}, ast.Comment{Text: "//    |combine(lambda: \"_field\"=='user1;, lambda: \"_field\"=='user2')\n"}, ast.Comment{Text: "//      .as('user1', 'user2')"}},
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "combine_pivot_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "combine_pivot_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "combine_pivot_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 22,
						Line:   1,
					},
					File:   "combine_pivot_test.flux",
					Source: "package testdata_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 22,
							Line:   1,
						},
						File:   "combine_pivot_test.flux",
						Source: "testdata_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "testdata_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 94,
					Line:   51,
				},
				File:   "delete_drop_test.flux",
				Source: "package testdata_test\n\nimport \"testing\"\n\noption now = () => (2030-01-01T00:00:00Z)\n\ninData = \"\n#datatype,string,long,string,string,string,dateTime:RFC3339,boolean\n#group,false,false,true,true,true,false,false\n#default,_result,,,,,,\n,result,table,_measurement,_field,t0,_time,_value\n,,0,m1,f1,server01,2018-12-19T22:13:30Z,false\n,,0,m1,f1,server01,2018-12-19T22:13:40Z,true\n,,0,m1,f1,server01,2018-12-19T22:13:50Z,false\n,,0,m1,f1,server01,2018-12-19T22:14:00Z,false\n,,0,m1,f1,server01,2018-12-19T22:14:10Z,true\n,,0,m1,f1,server01,2018-12-19T22:14:20Z,true\n,,1,m1,f1,server02,2018-12-19T22:13:30Z,false\n,,1,m1,f1,server02,2018-12-19T22:13:40Z,true\n,,1,m1,f1,server02,2018-12-19T22:13:50Z,false\n,,1,m1,f1,server02,2018-12-19T22:14:00Z,true\n,,1,m1,f1,server02,2018-12-19T22:14:10Z,true\n,,1,m1,f1,server02,2018-12-19T22:14:20Z,false\n\"\n\noutData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,string,dateTime:RFC3339\n#group,false,false,true,true,true,true,true,false\n#default,_result,,,,,,,\n,result,table,_start,_stop,_measurement,_field,t0,_time\n,,0,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server01,2018-12-19T22:13:30Z\n,,0,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server01,2018-12-19T22:13:40Z\n,,0,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server01,2018-12-19T22:13:50Z\n,,0,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server01,2018-12-19T22:14:00Z\n,,0,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server01,2018-12-19T22:14:10Z\n,,0,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server01,2018-12-19T22:14:20Z\n,,1,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server02,2018-12-19T22:13:30Z\n,,1,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server02,2018-12-19T22:13:40Z\n,,1,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server02,2018-12-19T22:13:50Z\n,,1,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server02,2018-12-19T22:14:00Z\n,,1,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server02,2018-12-19T22:14:10Z\n,,1,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server02,2018-12-19T22:14:20Z\n\"\n\nt_drop = (table=<-) =>\n\t(table\n\t\t|> range(start: 2018-12-15T00:00:00Z)\n\t\t|> drop(columns: [\"_value\"]))\n\ntest _drop = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_drop})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   5,
						},
						File:   "delete_drop_test.flux",
						Source: "now = () => (2030-01-01T00:00:00Z)",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   5,
							},
							File:   "delete_drop_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   5,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   5,
							},
							File:   "delete_drop_test.flux",
							Source: "() => (2030-01-01T00:00:00Z)",
							Start: ast.Position{
								Column: 14,
								Line:   5,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   5,
								},
								File:   "delete_drop_test.flux",
								Source: "(2030-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 20,
									Line:   5,
								},
							},
						},
						Expression: &ast.DateTimeLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   5,
									},
									File:   "delete_drop_test.flux",
									Source: "2030-01-01T00:00:00Z",
									Start: ast.Position{
										Column: 21,
										Line:   5,
									},
								},
							},
							Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 42,
						Line:   5,
					},
					File:   "delete_drop_test.flux",
					Source: "option now = () => (2030-01-01T00:00:00Z)",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   24,
					},
					File:   "delete_drop_test.flux",
					Source: "inData = \"\n#datatype,string,long,string,string,string,dateTime:RFC3339,boolean\n#group,false,false,true,true,true,false,false\n#default,_result,,,,,,\n,result,table,_measurement,_field,t0,_time,_value\n,,0,m1,f1,server01,2018-12-19T22:13:30Z,false\n,,0,m1,f1,server01,2018-12-19T22:13:40Z,true\n,,0,m1,f1,server01,2018-12-19T22:13:50Z,false\n,,0,m1,f1,server01,2018-12-19T22:14:00Z,false\n,,0,m1,f1,server01,2018-12-19T22:14:10Z,true\n,,0,m1,f1,server01,2018-12-19T22:14:20Z,true\n,,1,m1,f1,server02,2018-12-19T22:13:30Z,false\n,,1,m1,f1,server02,2018-12-19T22:13:40Z,true\n,,1,m1,f1,server02,2018-12-19T22:13:50Z,false\n,,1,m1,f1,server02,2018-12-19T22:14:00Z,true\n,,1,m1,f1,server02,2018-12-19T22:14:10Z,true\n,,1,m1,f1,server02,2018-12-19T22:14:20Z,false\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   7,
						},
						File:   "delete_drop_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   7,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   24,
						},
						File:   "delete_drop_test.flux",
						Source: "\"\n#datatype,string,long,string,string,string,dateTime:RFC3339,boolean\n#group,false,false,true,true,true,false,false\n#default,_result,,,,,,\n,result,table,_measurement,_field,t0,_time,_value\n,,0,m1,f1,server01,2018-12-19T22:13:30Z,false\n,,0,m1,f1,server01,2018-12-19T22:13:40Z,true\n,,0,m1,f1,server01,2018-12-19T22:13:50Z,false\n,,0,m1,f1,server01,2018-12-19T22:14:00Z,false\n,,0,m1,f1,server01,2018-12-19T22:14:10Z,true\n,,0,m1,f1,server01,2018-12-19T22:14:20Z,true\n,,1,m1,f1,server02,2018-12-19T22:13:30Z,false\n,,1,m1,f1,server02,2018-12-19T22:13:40Z,true\n,,1,m1,f1,server02,2018-12-19T22:13:50Z,false\n,,1,m1,f1,server02,2018-12-19T22:14:00Z,true\n,,1,m1,f1,server02,2018-12-19T22:14:10Z,true\n,,1,m1,f1,server02,2018-12-19T22:14:20Z,false\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   7,
						},
					},
				},
				Value: "\n#datatype,string,long,string,string,string,dateTime:RFC3339,boolean\n#group,false,false,true,true,true,false,false\n#default,_result,,,,,,\n,result,table,_measurement,_field,t0,_time,_value\n,,0,m1,f1,server01,2018-12-19T22:13:30Z,false\n,,0,m1,f1,server01,2018-12-19T22:13:40Z,true\n,,0,m1,f1,server01,2018-12-19T22:13:50Z,false\n,,0,m1,f1,server01,2018-12-19T22:14:00Z,false\n,,0,m1,f1,server01,2018-12-19T22:14:10Z,true\n,,0,m1,f1,server01,2018-12-19T22:14:20Z,true\n,,1,m1,f1,server02,2018-12-19T22:13:30Z,false\n,,1,m1,f1,server02,2018-12-19T22:13:40Z,true\n,,1,m1,f1,server02,2018-12-19T22:13:50Z,false\n,,1,m1,f1,server02,2018-12-19T22:14:00Z,true\n,,1,m1,f1,server02,2018-12-19T22:14:10Z,true\n,,1,m1,f1,server02,2018-12-19T22:14:20Z,false\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   43,
					},
					File:   "delete_drop_test.flux",
					Source: "outData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,string,dateTime:RFC3339\n#group,false,false,true,true,true,true,true,false\n#default,_result,,,,,,,\n,result,table,_start,_stop,_measurement,_field,t0,_time\n,,0,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server01,2018-12-19T22:13:30Z\n,,0,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server01,2018-12-19T22:13:40Z\n,,0,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server01,2018-12-19T22:13:50Z\n,,0,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server01,2018-12-19T22:14:00Z\n,,0,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server01,2018-12-19T22:14:10Z\n,,0,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server01,2018-12-19T22:14:20Z\n,,1,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server02,2018-12-19T22:13:30Z\n,,1,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server02,2018-12-19T22:13:40Z\n,,1,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server02,2018-12-19T22:13:50Z\n,,1,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server02,2018-12-19T22:14:00Z\n,,1,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server02,2018-12-19T22:14:10Z\n,,1,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server02,2018-12-19T22:14:20Z\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   26,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   26,
						},
						File:   "delete_drop_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   26,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   43,
						},
						File:   "delete_drop_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,string,dateTime:RFC3339\n#group,false,false,true,true,true,true,true,false\n#default,_result,,,,,,,\n,result,table,_start,_stop,_measurement,_field,t0,_time\n,,0,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server01,2018-12-19T22:13:30Z\n,,0,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server01,2018-12-19T22:13:40Z\n,,0,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server01,2018-12-19T22:13:50Z\n,,0,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server01,2018-12-19T22:14:00Z\n,,0,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server01,2018-12-19T22:14:10Z\n,,0,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server01,2018-12-19T22:14:20Z\n,,1,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server02,2018-12-19T22:13:30Z\n,,1,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server02,2018-12-19T22:13:40Z\n,,1,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server02,2018-12-19T22:13:50Z\n,,1,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server02,2018-12-19T22:14:00Z\n,,1,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server02,2018-12-19T22:14:10Z\n,,1,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server02,2018-12-19T22:14:20Z\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   26,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,string,dateTime:RFC3339\n#group,false,false,true,true,true,true,true,false\n#default,_result,,,,,,,\n,result,table,_start,_stop,_measurement,_field,t0,_time\n,,0,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server01,2018-12-19T22:13:30Z\n,,0,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server01,2018-12-19T22:13:40Z\n,,0,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server01,2018-12-19T22:13:50Z\n,,0,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server01,2018-12-19T22:14:00Z\n,,0,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server01,2018-12-19T22:14:10Z\n,,0,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server01,2018-12-19T22:14:20Z\n,,1,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server02,2018-12-19T22:13:30Z\n,,1,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server02,2018-12-19T22:13:40Z\n,,1,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server02,2018-12-19T22:13:50Z\n,,1,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server02,2018-12-19T22:14:00Z\n,,1,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server02,2018-12-19T22:14:10Z\n,,1,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server02,2018-12-19T22:14:20Z\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 32,
						Line:   48,
					},
					File:   "delete_drop_test.flux",
					Source: "t_drop = (table=<-) =>\n\t(table\n\t\t|> range(start: 2018-12-15T00:00:00Z)\n\t\t|> drop(columns: [\"_value\"]))",
					Start: ast.Position{
						Column: 1,
						Line:   45,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   45,
						},
						File:   "delete_drop_test.flux",
						Source: "t_drop",
						Start: ast.Position{
							Column: 1,
							Line:   45,
						},
					},
				},
				Name: "t_drop",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 32,
							Line:   48,
						},
						File:   "delete_drop_test.flux",
						Source: "(table=<-) =>\n\t(table\n\t\t|> range(start: 2018-12-15T00:00:00Z)\n\t\t|> drop(columns: [\"_value\"]))",
						Start: ast.Position{
							Column: 10,
							Line:   45,
						},
					},
				},
				Body: &ast.ParenExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 32,
								Line:   48,
							},
							File:   "delete_drop_test.flux",
							Source: "(table\n\t\t|> range(start: 2018-12-15T00:00:00Z)\n\t\t|> drop(columns: [\"_value\"]))",
							Start: ast.Position{
								Column: 2,
								Line:   46,
							},
						},
					},
					Expression: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 8,
											Line:   46,
										},
										File:   "delete_drop_test.flux",
										Source: "table",
										Start: ast.Position{
											Column: 3,
											Line:   46,
										},
									},
								},
								Name: "table",
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   47,
									},
									File:   "delete_drop_test.flux",
									Source: "table\n\t\t|> range(start: 2018-12-15T00:00:00Z)",
									Start: ast.Position{
										Column: 3,
										Line:   46,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 39,
												Line:   47,
											},
											File:   "delete_drop_test.flux",
											Source: "start: 2018-12-15T00:00:00Z",
											Start: ast.Position{
												Column: 12,
												Line:   47,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   47,
												},
												File:   "delete_drop_test.flux",
												Source: "start: 2018-12-15T00:00:00Z",
												Start: ast.Position{
													Column: 12,
													Line:   47,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   47,
													},
													File:   "delete_drop_test.flux",
													Source: "start",
													Start: ast.Position{
														Column: 12,
														Line:   47,
													},
												},
											},
											Name: "start",
										},
										Separator: nil,
										Value: &ast.DateTimeLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   47,
													},
													File:   "delete_drop_test.flux",
													Source: "2018-12-15T00:00:00Z",
													Start: ast.Position{
														Column: 19,
														Line:   47,
													},
												},
											},
											Value: parser.MustParseTime("2018-12-15T00:00:00Z"),
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   47,
										},
										File:   "delete_drop_test.flux",
										Source: "range(start: 2018-12-15T00:00:00Z)",
										Start: ast.Position{
											Column: 6,
											Line:   47,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   47,
											},
											File:   "delete_drop_test.flux",
											Source: "range",
											Start: ast.Position{
												Column: 6,
												Line:   47,
											},
										},
									},
									Name: "range",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 31,
									Line:   48,
								},
								File:   "delete_drop_test.flux",
								Source: "table\n\t\t|> range(start: 2018-12-15T00:00:00Z)\n\t\t|> drop(columns: [\"_value\"])",
								Start: ast.Position{
									Column: 3,
									Line:   46,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   48,
										},
										File:   "delete_drop_test.flux",
										Source: "columns: [\"_value\"]",
										Start: ast.Position{
											Column: 11,
											Line:   48,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 30,
												Line:   48,
											},
											File:   "delete_drop_test.flux",
											Source: "columns: [\"_value\"]",
											Start: ast.Position{
												Column: 11,
												Line:   48,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   48,
												},
												File:   "delete_drop_test.flux",
												Source: "columns",
												Start: ast.Position{
													Column: 11,
													Line:   48,
												},
											},
										},
										Name: "columns",
									},
									Separator: nil,
									Value: &ast.ArrayExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   48,
												},
												File:   "delete_drop_test.flux",
												Source: "[\"_value\"]",
												Start: ast.Position{
													Column: 20,
													Line:   48,
												},
											},
										},
										Elements: []ast.Expression{&ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 29,
														Line:   48,
													},
													File:   "delete_drop_test.flux",
													Source: "\"_value\"",
													Start: ast.Position{
														Column: 21,
														Line:   48,
													},
												},
											},
											Value: "_value",
										}},
										Lbrack: nil,
										Rbrack: nil,
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   48,
									},
									File:   "delete_drop_test.flux",
									Source: "drop(columns: [\"_value\"])",
									Start: ast.Position{
										Column: 6,
										Line:   48,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 10,
											Line:   48,
										},
										File:   "delete_drop_test.flux",
										Source: "drop",
										Start: ast.Position{
											Column: 6,
											Line:   48,
										},
									},
								},
								Name: "drop",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					Lparen: nil,
					Rparen: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 19,
								Line:   45,
							},
							File:   "delete_drop_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 11,
								Line:   45,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   45,
								},
								File:   "delete_drop_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 11,
									Line:   45,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 19,
								Line:   45,
							},
							File:   "delete_drop_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 17,
								Line:   45,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 94,
							Line:   51,
						},
						File:   "delete_drop_test.flux",
						Source: "_drop = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_drop})",
						Start: ast.Position{
							Column: 6,
							Line:   50,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   50,
							},
							File:   "delete_drop_test.flux",
							Source: "_drop",
							Start: ast.Position{
								Column: 6,
								Line:   50,
							},
						},
					},
					Name: "_drop",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 94,
								Line:   51,
							},
							File:   "delete_drop_test.flux",
							Source: "() =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_drop})",
							Start: ast.Position{
								Column: 14,
								Line:   50,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 94,
									Line:   51,
								},
								File:   "delete_drop_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_drop})",
								Start: ast.Position{
									Column: 2,
									Line:   51,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 93,
										Line:   51,
									},
									File:   "delete_drop_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_drop}",
									Start: ast.Position{
										Column: 3,
										Line:   51,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   51,
										},
										File:   "delete_drop_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 4,
											Line:   51,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 9,
												Line:   51,
											},
											File:   "delete_drop_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 4,
												Line:   51,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 42,
													Line:   51,
												},
												File:   "delete_drop_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 31,
													Line:   51,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 42,
														Line:   51,
													},
													File:   "delete_drop_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 31,
														Line:   51,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 34,
															Line:   51,
														},
														File:   "delete_drop_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 31,
															Line:   51,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 42,
															Line:   51,
														},
														File:   "delete_drop_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 36,
															Line:   51,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   51,
											},
											File:   "delete_drop_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 11,
												Line:   51,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   51,
												},
												File:   "delete_drop_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 11,
													Line:   51,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   51,
													},
													File:   "delete_drop_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 11,
														Line:   51,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 30,
														Line:   51,
													},
													File:   "delete_drop_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 19,
														Line:   51,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 80,
											Line:   51,
										},
										File:   "delete_drop_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 45,
											Line:   51,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   51,
											},
											File:   "delete_drop_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 45,
												Line:   51,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 79,
													Line:   51,
												},
												File:   "delete_drop_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 67,
													Line:   51,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 79,
														Line:   51,
													},
													File:   "delete_drop_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 67,
														Line:   51,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 70,
															Line:   51,
														},
														File:   "delete_drop_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 67,
															Line:   51,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 79,
															Line:   51,
														},
														File:   "delete_drop_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 72,
															Line:   51,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 80,
												Line:   51,
											},
											File:   "delete_drop_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 51,
												Line:   51,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 66,
													Line:   51,
												},
												File:   "delete_drop_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 51,
													Line:   51,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 58,
														Line:   51,
													},
													File:   "delete_drop_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 51,
														Line:   51,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 66,
														Line:   51,
													},
													File:   "delete_drop_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 59,
														Line:   51,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 92,
											Line:   51,
										},
										File:   "delete_drop_test.flux",
										Source: "fn: t_drop",
										Start: ast.Position{
											Column: 82,
											Line:   51,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 84,
												Line:   51,
											},
											File:   "delete_drop_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 82,
												Line:   51,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 92,
												Line:   51,
											},
											File:   "delete_drop_test.flux",
											Source: "t_drop",
											Start: ast.Position{
												Column: 86,
												Line:   51,
											},
										},
									},
									Name: "t_drop",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 94,
						Line:   51,
					},
					File:   "delete_drop_test.flux",
					Source: "test _drop = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_drop})",
					Start: ast.Position{
						Column: 1,
						Line:   50,
					},
				},
			},
		}},
		Eof: []ast.Comment{ast.Comment{Text: "// Equivalent TICKscript query:\n"}, ast.Comment{Text: "// stream\n"}, ast.Comment{Text: "//   |delete()\n"}, ast.Comment{Text: "//     .field('_value')"}},
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "delete_drop_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "delete_drop_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "delete_drop_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 22,
						Line:   1,
					},
					File:   "delete_drop_test.flux",
					Source: "package testdata_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 22,
							Line:   1,
						},
						File:   "delete_drop_test.flux",
						Source: "testdata_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "testdata_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 93,
					Line:   34,
				},
				File:   "eval_map_with_test.flux",
				Source: "package testdata_test\n \nimport \"testing\"\n\noption now = () => (2030-01-01T00:00:00Z)\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,long,string,string,string\n#group,false,false,false,false,true,true,true\n#default,_result,,,,,,\n,result,table,_time,_value,_field,_measurement,host\n,,0,2018-05-22T19:53:26Z,100,load1,system,host.local\n,,0,2018-05-22T19:53:36Z,101,load1,system,host.local\n,,0,2018-05-22T19:53:46Z,102,load1,system,host.local\n\"\n\noutData = \"\n#datatype,string,long,dateTime:RFC3339,long,string,string,string,long\n#group,false,false,false,false,true,true,true,false\n#default,_result,,,,,,,\n,result,table,_time,_value,_field,_measurement,host,_newValue\n,,0,2018-05-22T19:53:26Z,100,load1,system,host.local,200\n,,0,2018-05-22T19:53:36Z,101,load1,system,host.local,202\n,,0,2018-05-22T19:53:46Z,102,load1,system,host.local,204\n\"\n\nt_map = (table=<-) =>\n\t(table\n\t    |> range(start: 2018-05-15T00:00:00Z)\n\t    |> drop(columns: [\"_start\", \"_stop\"])\n\t\t|> map(fn: (r) => ({r with _newValue: 2 * r._value})))\n\ntest _map = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_map})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   5,
						},
						File:   "eval_map_with_test.flux",
						Source: "now = () => (2030-01-01T00:00:00Z)",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   5,
							},
							File:   "eval_map_with_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   5,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   5,
							},
							File:   "eval_map_with_test.flux",
							Source: "() => (2030-01-01T00:00:00Z)",
							Start: ast.Position{
								Column: 14,
								Line:   5,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   5,
								},
								File:   "eval_map_with_test.flux",
								Source: "(2030-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 20,
									Line:   5,
								},
							},
						},
						Expression: &ast.DateTimeLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   5,
									},
									File:   "eval_map_with_test.flux",
									Source: "2030-01-01T00:00:00Z",
									Start: ast.Position{
										Column: 21,
										Line:   5,
									},
								},
							},
							Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 42,
						Line:   5,
					},
					File:   "eval_map_with_test.flux",
					Source: "option now = () => (2030-01-01T00:00:00Z)",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   15,
					},
					File:   "eval_map_with_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,long,string,string,string\n#group,false,false,false,false,true,true,true\n#default,_result,,,,,,\n,result,table,_time,_value,_field,_measurement,host\n,,0,2018-05-22T19:53:26Z,100,load1,system,host.local\n,,0,2018-05-22T19:53:36Z,101,load1,system,host.local\n,,0,2018-05-22T19:53:46Z,102,load1,system,host.local\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   7,
						},
						File:   "eval_map_with_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   7,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   15,
						},
						File:   "eval_map_with_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,long,string,string,string\n#group,false,false,false,false,true,true,true\n#default,_result,,,,,,\n,result,table,_time,_value,_field,_measurement,host\n,,0,2018-05-22T19:53:26Z,100,load1,system,host.local\n,,0,2018-05-22T19:53:36Z,101,load1,system,host.local\n,,0,2018-05-22T19:53:46Z,102,load1,system,host.local\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   7,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,long,string,string,string\n#group,false,false,false,false,true,true,true\n#default,_result,,,,,,\n,result,table,_time,_value,_field,_measurement,host\n,,0,2018-05-22T19:53:26Z,100,load1,system,host.local\n,,0,2018-05-22T19:53:36Z,101,load1,system,host.local\n,,0,2018-05-22T19:53:46Z,102,load1,system,host.local\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   25,
					},
					File:   "eval_map_with_test.flux",
					Source: "outData = \"\n#datatype,string,long,dateTime:RFC3339,long,string,string,string,long\n#group,false,false,false,false,true,true,true,false\n#default,_result,,,,,,,\n,result,table,_time,_value,_field,_measurement,host,_newValue\n,,0,2018-05-22T19:53:26Z,100,load1,system,host.local,200\n,,0,2018-05-22T19:53:36Z,101,load1,system,host.local,202\n,,0,2018-05-22T19:53:46Z,102,load1,system,host.local,204\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   17,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   17,
						},
						File:   "eval_map_with_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   17,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   25,
						},
						File:   "eval_map_with_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,long,string,string,string,long\n#group,false,false,false,false,true,true,true,false\n#default,_result,,,,,,,\n,result,table,_time,_value,_field,_measurement,host,_newValue\n,,0,2018-05-22T19:53:26Z,100,load1,system,host.local,200\n,,0,2018-05-22T19:53:36Z,101,load1,system,host.local,202\n,,0,2018-05-22T19:53:46Z,102,load1,system,host.local,204\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   17,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,long,string,string,string,long\n#group,false,false,false,false,true,true,true,false\n#default,_result,,,,,,,\n,result,table,_time,_value,_field,_measurement,host,_newValue\n,,0,2018-05-22T19:53:26Z,100,load1,system,host.local,200\n,,0,2018-05-22T19:53:36Z,101,load1,system,host.local,202\n,,0,2018-05-22T19:53:46Z,102,load1,system,host.local,204\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 57,
						Line:   31,
					},
					File:   "eval_map_with_test.flux",
					Source: "t_map = (table=<-) =>\n\t(table\n\t    |> range(start: 2018-05-15T00:00:00Z)\n\t    |> drop(columns: [\"_start\", \"_stop\"])\n\t\t|> map(fn: (r) => ({r with _newValue: 2 * r._value})))",
					Start: ast.Position{
						Column: 1,
						Line:   27,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   27,
						},
						File:   "eval_map_with_test.flux",
						Source: "t_map",
						Start: ast.Position{
							Column: 1,
							Line:   27,
						},
					},
				},
				Name: "t_map",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 57,
							Line:   31,
						},
						File:   "eval_map_with_test.flux",
						Source: "(table=<-) =>\n\t(table\n\t    |> range(start: 2018-05-15T00:00:00Z)\n\t    |> drop(columns: [\"_start\", \"_stop\"])\n\t\t|> map(fn: (r) => ({r with _newValue: 2 * r._value})))",
						Start: ast.Position{
							Column: 9,
							Line:   27,
						},
					},
				},
				Body: &ast.ParenExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 57,
								Line:   31,
							},
							File:   "eval_map_with_test.flux",
							Source: "(table\n\t    |> range(start: 2018-05-15T00:00:00Z)\n\t    |> drop(columns: [\"_start\", \"_stop\"])\n\t\t|> map(fn: (r) => ({r with _newValue: 2 * r._value})))",
							Start: ast.Position{
								Column: 2,
								Line:   28,
							},
						},
					},
					Expression: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 8,
												Line:   28,
											},
											File:   "eval_map_with_test.flux",
											Source: "table",
											Start: ast.Position{
												Column: 3,
												Line:   28,
											},
										},
									},
									Name: "table",
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   29,
										},
										File:   "eval_map_with_test.flux",
										Source: "table\n\t    |> range(start: 2018-05-15T00:00:00Z)",
										Start: ast.Position{
											Column: 3,
											Line:   28,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 42,
													Line:   29,
												},
												File:   "eval_map_with_test.flux",
												Source: "start: 2018-05-15T00:00:00Z",
												Start: ast.Position{
													Column: 15,
													Line:   29,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 42,
														Line:   29,
													},
													File:   "eval_map_with_test.flux",
													Source: "start: 2018-05-15T00:00:00Z",
													Start: ast.Position{
														Column: 15,
														Line:   29,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 20,
															Line:   29,
														},
														File:   "eval_map_with_test.flux",
														Source: "start",
														Start: ast.Position{
															Column: 15,
															Line:   29,
														},
													},
												},
												Name: "start",
											},
											Separator: nil,
											Value: &ast.DateTimeLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 42,
															Line:   29,
														},
														File:   "eval_map_with_test.flux",
														Source: "2018-05-15T00:00:00Z",
														Start: ast.Position{
															Column: 22,
															Line:   29,
														},
													},
												},
												Value: parser.MustParseTime("2018-05-15T00:00:00Z"),
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   29,
											},
											File:   "eval_map_with_test.flux",
											Source: "range(start: 2018-05-15T00:00:00Z)",
											Start: ast.Position{
												Column: 9,
												Line:   29,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 14,
													Line:   29,
												},
												File:   "eval_map_with_test.flux",
												Source: "range",
												Start: ast.Position{
													Column: 9,
													Line:   29,
												},
											},
										},
										Name: "range",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 43,
										Line:   30,
									},
									File:   "eval_map_with_test.flux",
									Source: "table\n\t    |> range(start: 2018-05-15T00:00:00Z)\n\t    |> drop(columns: [\"_start\", \"_stop\"])",
									Start: ast.Position{
										Column: 3,
										Line:   28,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 42,
												Line:   30,
											},
											File:   "eval_map_with_test.flux",
											Source: "columns: [\"_start\", \"_stop\"]",
											Start: ast.Position{
												Column: 14,
												Line:   30,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 42,
													Line:   30,
												},
												File:   "eval_map_with_test.flux",
												Source: "columns: [\"_start\", \"_stop\"]",
												Start: ast.Position{
													Column: 14,
													Line:   30,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 21,
														Line:   30,
													},
													File:   "eval_map_with_test.flux",
													Source: "columns",
													Start: ast.Position{
														Column: 14,
														Line:   30,
													},
												},
											},
											Name: "columns",
										},
										Separator: nil,
										Value: &ast.ArrayExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 42,
														Line:   30,
													},
													File:   "eval_map_with_test.flux",
													Source: "[\"_start\", \"_stop\"]",
													Start: ast.Position{
														Column: 23,
														Line:   30,
													},
												},
											},
											Elements: []ast.Expression{&ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 32,
															Line:   30,
														},
														File:   "eval_map_with_test.flux",
														Source: "\"_start\"",
														Start: ast.Position{
															Column: 24,
															Line:   30,
														},
													},
												},
												Value: "_start",
											}, &ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 41,
															Line:   30,
														},
														File:   "eval_map_with_test.flux",
														Source: "\"_stop\"",
														Start: ast.Position{
															Column: 34,
															Line:   30,
														},
													},
												},
												Value: "_stop",
											}},
											Lbrack: nil,
											Rbrack: nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   30,
										},
										File:   "eval_map_with_test.flux",
										Source: "drop(columns: [\"_start\", \"_stop\"])",
										Start: ast.Position{
											Column: 9,
											Line:   30,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 13,
												Line:   30,
											},
											File:   "eval_map_with_test.flux",
											Source: "drop",
											Start: ast.Position{
												Column: 9,
												Line:   30,
											},
										},
									},
									Name: "drop",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 56,
									Line:   31,
								},
								File:   "eval_map_with_test.flux",
								Source: "table\n\t    |> range(start: 2018-05-15T00:00:00Z)\n\t    |> drop(columns: [\"_start\", \"_stop\"])\n\t\t|> map(fn: (r) => ({r with _newValue: 2 * r._value}))",
								Start: ast.Position{
									Column: 3,
									Line:   28,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 55,
											Line:   31,
										},
										File:   "eval_map_with_test.flux",
										Source: "fn: (r) => ({r with _newValue: 2 * r._value})",
										Start: ast.Position{
											Column: 10,
											Line:   31,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 55,
												Line:   31,
											},
											File:   "eval_map_with_test.flux",
											Source: "fn: (r) => ({r with _newValue: 2 * r._value})",
											Start: ast.Position{
												Column: 10,
												Line:   31,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 12,
													Line:   31,
												},
												File:   "eval_map_with_test.flux",
												Source: "fn",
												Start: ast.Position{
													Column: 10,
													Line:   31,
												},
											},
										},
										Name: "fn",
									},
									Separator: nil,
									Value: &ast.FunctionExpression{
										Arrow: nil,
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 55,
													Line:   31,
												},
												File:   "eval_map_with_test.flux",
												Source: "(r) => ({r with _newValue: 2 * r._value})",
												Start: ast.Position{
													Column: 14,
													Line:   31,
												},
											},
										},
										Body: &ast.ParenExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 55,
														Line:   31,
													},
													File:   "eval_map_with_test.flux",
													Source: "({r with _newValue: 2 * r._value})",
													Start: ast.Position{
														Column: 21,
														Line:   31,
													},
												},
											},
											Expression: &ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 54,
															Line:   31,
														},
														File:   "eval_map_with_test.flux",
														Source: "{r with _newValue: 2 * r._value}",
														Start: ast.Position{
															Column: 22,
															Line:   31,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 53,
																Line:   31,
															},
															File:   "eval_map_with_test.flux",
															Source: "_newValue: 2 * r._value",
															Start: ast.Position{
																Column: 30,
																Line:   31,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 39,
																	Line:   31,
																},
																File:   "eval_map_with_test.flux",
																Source: "_newValue",
																Start: ast.Position{
																	Column: 30,
																	Line:   31,
																},
															},
														},
														Name: "_newValue",
													},
													Separator: nil,
													Value: &ast.BinaryExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 53,
																	Line:   31,
																},
																File:   "eval_map_with_test.flux",
																Source: "2 * r._value",
																Start: ast.Position{
																	Column: 41,
																	Line:   31,
																},
															},
														},
														Left: &ast.IntegerLiteral{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 42,
																		Line:   31,
																	},
																	File:   "eval_map_with_test.flux",
																	Source: "2",
																	Start: ast.Position{
																		Column: 41,
																		Line:   31,
																	},
																},
															},
															Value: int64(2),
														},
														Operator: 1,
														Right: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 53,
																		Line:   31,
																	},
																	File:   "eval_map_with_test.flux",
																	Source: "r._value",
																	Start: ast.Position{
																		Column: 45,
																		Line:   31,
																	},
																},
															},
															Lbrack: nil,
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 46,
																			Line:   31,
																		},
																		File:   "eval_map_with_test.flux",
																		Source: "r",
																		Start: ast.Position{
																			Column: 45,
																			Line:   31,
																		},
																	},
																},
																Name: "r",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 53,
																			Line:   31,
																		},
																		File:   "eval_map_with_test.flux",
																		Source: "_value",
																		Start: ast.Position{
																			Column: 47,
																			Line:   31,
																		},
																	},
																},
																Name: "_value",
															},
															Rbrack: nil,
														},
													},
												}},
												Rbrace: nil,
												With: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 24,
																Line:   31,
															},
															File:   "eval_map_with_test.flux",
															Source: "r",
															Start: ast.Position{
																Column: 23,
																Line:   31,
															},
														},
													},
													Name: "r",
												},
											},
											Lparen: nil,
											Rparen: nil,
										},
										Lparen: nil,
										Params: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 16,
														Line:   31,
													},
													File:   "eval_map_with_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 15,
														Line:   31,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 16,
															Line:   31,
														},
														File:   "eval_map_with_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 15,
															Line:   31,
														},
													},
												},
												Name: "r",
											},
											Separator: nil,
											Value:     nil,
										}},
										Rparan: nil,
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 56,
										Line:   31,
									},
									File:   "eval_map_with_test.flux",
									Source: "map(fn: (r) => ({r with _newValue: 2 * r._value}))",
									Start: ast.Position{
										Column: 6,
										Line:   31,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 9,
											Line:   31,
										},
										File:   "eval_map_with_test.flux",
										Source: "map",
										Start: ast.Position{
											Column: 6,
											Line:   31,
										},
									},
								},
								Name: "map",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					Lparen: nil,
					Rparen: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 18,
								Line:   27,
							},
							File:   "eval_map_with_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 10,
								Line:   27,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   27,
								},
								File:   "eval_map_with_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 10,
									Line:   27,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 18,
								Line:   27,
							},
							File:   "eval_map_with_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 16,
								Line:   27,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 93,
							Line:   34,
						},
						File:   "eval_map_with_test.flux",
						Source: "_map = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_map})",
						Start: ast.Position{
							Column: 6,
							Line:   33,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 10,
								Line:   33,
							},
							File:   "eval_map_with_test.flux",
							Source: "_map",
							Start: ast.Position{
								Column: 6,
								Line:   33,
							},
						},
					},
					Name: "_map",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 93,
								Line:   34,
							},
							File:   "eval_map_with_test.flux",
							Source: "() =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_map})",
							Start: ast.Position{
								Column: 13,
								Line:   33,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 93,
									Line:   34,
								},
								File:   "eval_map_with_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_map})",
								Start: ast.Position{
									Column: 2,
									Line:   34,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 92,
										Line:   34,
									},
									File:   "eval_map_with_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_map}",
									Start: ast.Position{
										Column: 3,
										Line:   34,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   34,
										},
										File:   "eval_map_with_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 4,
											Line:   34,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 9,
												Line:   34,
											},
											File:   "eval_map_with_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 4,
												Line:   34,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 42,
													Line:   34,
												},
												File:   "eval_map_with_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 31,
													Line:   34,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 42,
														Line:   34,
													},
													File:   "eval_map_with_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 31,
														Line:   34,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 34,
															Line:   34,
														},
														File:   "eval_map_with_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 31,
															Line:   34,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 42,
															Line:   34,
														},
														File:   "eval_map_with_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 36,
															Line:   34,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   34,
											},
											File:   "eval_map_with_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 11,
												Line:   34,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   34,
												},
												File:   "eval_map_with_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 11,
													Line:   34,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   34,
													},
													File:   "eval_map_with_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 11,
														Line:   34,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 30,
														Line:   34,
													},
													File:   "eval_map_with_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 19,
														Line:   34,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 80,
											Line:   34,
										},
										File:   "eval_map_with_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 45,
											Line:   34,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   34,
											},
											File:   "eval_map_with_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 45,
												Line:   34,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 79,
													Line:   34,
												},
												File:   "eval_map_with_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 67,
													Line:   34,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 79,
														Line:   34,
													},
													File:   "eval_map_with_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 67,
														Line:   34,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 70,
															Line:   34,
														},
														File:   "eval_map_with_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 67,
															Line:   34,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 79,
															Line:   34,
														},
														File:   "eval_map_with_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 72,
															Line:   34,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 80,
												Line:   34,
											},
											File:   "eval_map_with_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 51,
												Line:   34,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 66,
													Line:   34,
												},
												File:   "eval_map_with_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 51,
													Line:   34,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 58,
														Line:   34,
													},
													File:   "eval_map_with_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 51,
														Line:   34,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 66,
														Line:   34,
													},
													File:   "eval_map_with_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 59,
														Line:   34,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 91,
											Line:   34,
										},
										File:   "eval_map_with_test.flux",
										Source: "fn: t_map",
										Start: ast.Position{
											Column: 82,
											Line:   34,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 84,
												Line:   34,
											},
											File:   "eval_map_with_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 82,
												Line:   34,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 91,
												Line:   34,
											},
											File:   "eval_map_with_test.flux",
											Source: "t_map",
											Start: ast.Position{
												Column: 86,
												Line:   34,
											},
										},
									},
									Name: "t_map",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 93,
						Line:   34,
					},
					File:   "eval_map_with_test.flux",
					Source: "test _map = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_map})",
					Start: ast.Position{
						Column: 1,
						Line:   33,
					},
				},
			},
		}},
		Eof: []ast.Comment{ast.Comment{Text: "// Equivalent TICKscript query:\n"}, ast.Comment{Text: "// stream \n"}, ast.Comment{Text: "// \t |eval(lambda: 2 * _value)\n"}, ast.Comment{Text: "//\t\t.as('_newValue')"}},
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "eval_map_with_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "eval_map_with_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "eval_map_with_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 22,
						Line:   1,
					},
					File:   "eval_map_with_test.flux",
					Source: "package testdata_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 22,
							Line:   1,
						},
						File:   "eval_map_with_test.flux",
						Source: "testdata_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "testdata_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 101,
					Line:   51,
				},
				File:   "fill_default_test.flux",
				Source: "package testdata_test\n \nimport \"testing\"\n\noption now = () => (2030-01-01T00:00:00Z)\n\ninData = \"\n#datatype,string,long,string,string,string,dateTime:RFC3339,string\n#group,false,false,true,true,true,false,false\n#default,_result,,,,,,\n,result,table,_measurement,_field,t0,_time,_value\n,,0,m1,f1,server01,2018-12-19T22:13:30Z,\n,,0,m1,f1,server01,2018-12-19T22:13:40Z,banana\n,,0,m1,f1,server01,2018-12-19T22:13:50Z,apple\n,,0,m1,f1,server01,2018-12-19T22:14:00Z,peach\n,,0,m1,f1,server01,2018-12-19T22:14:10Z,\n,,0,m1,f1,server01,2018-12-19T22:14:20Z,raspberry\n,,1,m1,f1,server02,2018-12-19T22:13:30Z,watermelon\n,,1,m1,f1,server02,2018-12-19T22:13:40Z,grape\n,,1,m1,f1,server02,2018-12-19T22:13:50Z,\n,,1,m1,f1,server02,2018-12-19T22:14:00Z,mango\n,,1,m1,f1,server02,2018-12-19T22:14:10Z,orange\n,,1,m1,f1,server02,2018-12-19T22:14:20Z,\n\"\n\noutData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,string,dateTime:RFC3339,string\n#group,false,false,true,true,true,true,true,false,false\n#default,_result,,,,,,,,\n,result,table,_start,_stop,_measurement,_field,t0,_time,_value\n,,0,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server01,2018-12-19T22:13:30Z,tomato\n,,0,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server01,2018-12-19T22:13:40Z,banana\n,,0,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server01,2018-12-19T22:13:50Z,apple\n,,0,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server01,2018-12-19T22:14:00Z,peach\n,,0,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server01,2018-12-19T22:14:10Z,tomato\n,,0,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server01,2018-12-19T22:14:20Z,raspberry\n,,1,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server02,2018-12-19T22:13:30Z,watermelon\n,,1,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server02,2018-12-19T22:13:40Z,grape\n,,1,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server02,2018-12-19T22:13:50Z,tomato\n,,1,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server02,2018-12-19T22:14:00Z,mango\n,,1,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server02,2018-12-19T22:14:10Z,orange\n,,1,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server02,2018-12-19T22:14:20Z,tomato\n\"\n\nt_fill_string = (table=<-) =>\n\t(table\n\t\t|> range(start: 2018-12-15T00:00:00Z)\n\t\t|> fill(value: \"tomato\"))\n\ntest _fill = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_fill_string})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   5,
						},
						File:   "fill_default_test.flux",
						Source: "now = () => (2030-01-01T00:00:00Z)",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   5,
							},
							File:   "fill_default_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   5,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   5,
							},
							File:   "fill_default_test.flux",
							Source: "() => (2030-01-01T00:00:00Z)",
							Start: ast.Position{
								Column: 14,
								Line:   5,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   5,
								},
								File:   "fill_default_test.flux",
								Source: "(2030-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 20,
									Line:   5,
								},
							},
						},
						Expression: &ast.DateTimeLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   5,
									},
									File:   "fill_default_test.flux",
									Source: "2030-01-01T00:00:00Z",
									Start: ast.Position{
										Column: 21,
										Line:   5,
									},
								},
							},
							Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 42,
						Line:   5,
					},
					File:   "fill_default_test.flux",
					Source: "option now = () => (2030-01-01T00:00:00Z)",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   24,
					},
					File:   "fill_default_test.flux",
					Source: "inData = \"\n#datatype,string,long,string,string,string,dateTime:RFC3339,string\n#group,false,false,true,true,true,false,false\n#default,_result,,,,,,\n,result,table,_measurement,_field,t0,_time,_value\n,,0,m1,f1,server01,2018-12-19T22:13:30Z,\n,,0,m1,f1,server01,2018-12-19T22:13:40Z,banana\n,,0,m1,f1,server01,2018-12-19T22:13:50Z,apple\n,,0,m1,f1,server01,2018-12-19T22:14:00Z,peach\n,,0,m1,f1,server01,2018-12-19T22:14:10Z,\n,,0,m1,f1,server01,2018-12-19T22:14:20Z,raspberry\n,,1,m1,f1,server02,2018-12-19T22:13:30Z,watermelon\n,,1,m1,f1,server02,2018-12-19T22:13:40Z,grape\n,,1,m1,f1,server02,2018-12-19T22:13:50Z,\n,,1,m1,f1,server02,2018-12-19T22:14:00Z,mango\n,,1,m1,f1,server02,2018-12-19T22:14:10Z,orange\n,,1,m1,f1,server02,2018-12-19T22:14:20Z,\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   7,
						},
						File:   "fill_default_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   7,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   24,
						},
						File:   "fill_default_test.flux",
						Source: "\"\n#datatype,string,long,string,string,string,dateTime:RFC3339,string\n#group,false,false,true,true,true,false,false\n#default,_result,,,,,,\n,result,table,_measurement,_field,t0,_time,_value\n,,0,m1,f1,server01,2018-12-19T22:13:30Z,\n,,0,m1,f1,server01,2018-12-19T22:13:40Z,banana\n,,0,m1,f1,server01,2018-12-19T22:13:50Z,apple\n,,0,m1,f1,server01,2018-12-19T22:14:00Z,peach\n,,0,m1,f1,server01,2018-12-19T22:14:10Z,\n,,0,m1,f1,server01,2018-12-19T22:14:20Z,raspberry\n,,1,m1,f1,server02,2018-12-19T22:13:30Z,watermelon\n,,1,m1,f1,server02,2018-12-19T22:13:40Z,grape\n,,1,m1,f1,server02,2018-12-19T22:13:50Z,\n,,1,m1,f1,server02,2018-12-19T22:14:00Z,mango\n,,1,m1,f1,server02,2018-12-19T22:14:10Z,orange\n,,1,m1,f1,server02,2018-12-19T22:14:20Z,\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   7,
						},
					},
				},
				Value: "\n#datatype,string,long,string,string,string,dateTime:RFC3339,string\n#group,false,false,true,true,true,false,false\n#default,_result,,,,,,\n,result,table,_measurement,_field,t0,_time,_value\n,,0,m1,f1,server01,2018-12-19T22:13:30Z,\n,,0,m1,f1,server01,2018-12-19T22:13:40Z,banana\n,,0,m1,f1,server01,2018-12-19T22:13:50Z,apple\n,,0,m1,f1,server01,2018-12-19T22:14:00Z,peach\n,,0,m1,f1,server01,2018-12-19T22:14:10Z,\n,,0,m1,f1,server01,2018-12-19T22:14:20Z,raspberry\n,,1,m1,f1,server02,2018-12-19T22:13:30Z,watermelon\n,,1,m1,f1,server02,2018-12-19T22:13:40Z,grape\n,,1,m1,f1,server02,2018-12-19T22:13:50Z,\n,,1,m1,f1,server02,2018-12-19T22:14:00Z,mango\n,,1,m1,f1,server02,2018-12-19T22:14:10Z,orange\n,,1,m1,f1,server02,2018-12-19T22:14:20Z,\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   43,
					},
					File:   "fill_default_test.flux",
					Source: "outData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,string,dateTime:RFC3339,string\n#group,false,false,true,true,true,true,true,false,false\n#default,_result,,,,,,,,\n,result,table,_start,_stop,_measurement,_field,t0,_time,_value\n,,0,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server01,2018-12-19T22:13:30Z,tomato\n,,0,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server01,2018-12-19T22:13:40Z,banana\n,,0,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server01,2018-12-19T22:13:50Z,apple\n,,0,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server01,2018-12-19T22:14:00Z,peach\n,,0,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server01,2018-12-19T22:14:10Z,tomato\n,,0,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server01,2018-12-19T22:14:20Z,raspberry\n,,1,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server02,2018-12-19T22:13:30Z,watermelon\n,,1,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server02,2018-12-19T22:13:40Z,grape\n,,1,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server02,2018-12-19T22:13:50Z,tomato\n,,1,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server02,2018-12-19T22:14:00Z,mango\n,,1,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server02,2018-12-19T22:14:10Z,orange\n,,1,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server02,2018-12-19T22:14:20Z,tomato\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   26,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   26,
						},
						File:   "fill_default_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   26,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   43,
						},
						File:   "fill_default_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,string,dateTime:RFC3339,string\n#group,false,false,true,true,true,true,true,false,false\n#default,_result,,,,,,,,\n,result,table,_start,_stop,_measurement,_field,t0,_time,_value\n,,0,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server01,2018-12-19T22:13:30Z,tomato\n,,0,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server01,2018-12-19T22:13:40Z,banana\n,,0,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server01,2018-12-19T22:13:50Z,apple\n,,0,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server01,2018-12-19T22:14:00Z,peach\n,,0,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server01,2018-12-19T22:14:10Z,tomato\n,,0,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server01,2018-12-19T22:14:20Z,raspberry\n,,1,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server02,2018-12-19T22:13:30Z,watermelon\n,,1,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server02,2018-12-19T22:13:40Z,grape\n,,1,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server02,2018-12-19T22:13:50Z,tomato\n,,1,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server02,2018-12-19T22:14:00Z,mango\n,,1,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server02,2018-12-19T22:14:10Z,orange\n,,1,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server02,2018-12-19T22:14:20Z,tomato\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   26,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,string,dateTime:RFC3339,string\n#group,false,false,true,true,true,true,true,false,false\n#default,_result,,,,,,,,\n,result,table,_start,_stop,_measurement,_field,t0,_time,_value\n,,0,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server01,2018-12-19T22:13:30Z,tomato\n,,0,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server01,2018-12-19T22:13:40Z,banana\n,,0,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server01,2018-12-19T22:13:50Z,apple\n,,0,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server01,2018-12-19T22:14:00Z,peach\n,,0,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server01,2018-12-19T22:14:10Z,tomato\n,,0,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server01,2018-12-19T22:14:20Z,raspberry\n,,1,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server02,2018-12-19T22:13:30Z,watermelon\n,,1,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server02,2018-12-19T22:13:40Z,grape\n,,1,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server02,2018-12-19T22:13:50Z,tomato\n,,1,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server02,2018-12-19T22:14:00Z,mango\n,,1,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server02,2018-12-19T22:14:10Z,orange\n,,1,2018-12-15T00:00:00Z,2030-01-01T00:00:00Z,m1,f1,server02,2018-12-19T22:14:20Z,tomato\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 28,
						Line:   48,
					},
					File:   "fill_default_test.flux",
					Source: "t_fill_string = (table=<-) =>\n\t(table\n\t\t|> range(start: 2018-12-15T00:00:00Z)\n\t\t|> fill(value: \"tomato\"))",
					Start: ast.Position{
						Column: 1,
						Line:   45,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   45,
						},
						File:   "fill_default_test.flux",
						Source: "t_fill_string",
						Start: ast.Position{
							Column: 1,
							Line:   45,
						},
					},
				},
				Name: "t_fill_string",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 28,
							Line:   48,
						},
						File:   "fill_default_test.flux",
						Source: "(table=<-) =>\n\t(table\n\t\t|> range(start: 2018-12-15T00:00:00Z)\n\t\t|> fill(value: \"tomato\"))",
						Start: ast.Position{
							Column: 17,
							Line:   45,
						},
					},
				},
				Body: &ast.ParenExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 28,
								Line:   48,
							},
							File:   "fill_default_test.flux",
							Source: "(table\n\t\t|> range(start: 2018-12-15T00:00:00Z)\n\t\t|> fill(value: \"tomato\"))",
							Start: ast.Position{
								Column: 2,
								Line:   46,
							},
						},
					},
					Expression: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 8,
											Line:   46,
										},
										File:   "fill_default_test.flux",
										Source: "table",
										Start: ast.Position{
											Column: 3,
											Line:   46,
										},
									},
								},
								Name: "table",
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   47,
									},
									File:   "fill_default_test.flux",
									Source: "table\n\t\t|> range(start: 2018-12-15T00:00:00Z)",
									Start: ast.Position{
										Column: 3,
										Line:   46,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 39,
												Line:   47,
											},
											File:   "fill_default_test.flux",
											Source: "start: 2018-12-15T00:00:00Z",
											Start: ast.Position{
												Column: 12,
												Line:   47,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   47,
												},
												File:   "fill_default_test.flux",
												Source: "start: 2018-12-15T00:00:00Z",
												Start: ast.Position{
													Column: 12,
													Line:   47,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   47,
													},
													File:   "fill_default_test.flux",
													Source: "start",
													Start: ast.Position{
														Column: 12,
														Line:   47,
													},
												},
											},
											Name: "start",
										},
										Separator: nil,
										Value: &ast.DateTimeLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   47,
													},
													File:   "fill_default_test.flux",
													Source: "2018-12-15T00:00:00Z",
													Start: ast.Position{
														Column: 19,
														Line:   47,
													},
												},
											},
											Value: parser.MustParseTime("2018-12-15T00:00:00Z"),
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   47,
										},
										File:   "fill_default_test.flux",
										Source: "range(start: 2018-12-15T00:00:00Z)",
										Start: ast.Position{
											Column: 6,
											Line:   47,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   47,
											},
											File:   "fill_default_test.flux",
											Source: "range",
											Start: ast.Position{
												Column: 6,
												Line:   47,
											},
										},
									},
									Name: "range",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 27,
									Line:   48,
								},
								File:   "fill_default_test.flux",
								Source: "table\n\t\t|> range(start: 2018-12-15T00:00:00Z)\n\t\t|> fill(value: \"tomato\")",
								Start: ast.Position{
									Column: 3,
									Line:   46,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 26,
											Line:   48,
										},
										File:   "fill_default_test.flux",
										Source: "value: \"tomato\"",
										Start: ast.Position{
											Column: 11,
											Line:   48,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 26,
												Line:   48,
											},
											File:   "fill_default_test.flux",
											Source: "value: \"tomato\"",
											Start: ast.Position{
												Column: 11,
												Line:   48,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 16,
													Line:   48,
												},
												File:   "fill_default_test.flux",
												Source: "value",
												Start: ast.Position{
													Column: 11,
													Line:   48,
												},
											},
										},
										Name: "value",
									},
									Separator: nil,
									Value: &ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 26,
													Line:   48,
												},
												File:   "fill_default_test.flux",
												Source: "\"tomato\"",
												Start: ast.Position{
													Column: 18,
													Line:   48,
												},
											},
										},
										Value: "tomato",
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 27,
										Line:   48,
									},
									File:   "fill_default_test.flux",
									Source: "fill(value: \"tomato\")",
									Start: ast.Position{
										Column: 6,
										Line:   48,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 10,
											Line:   48,
										},
										File:   "fill_default_test.flux",
										Source: "fill",
										Start: ast.Position{
											Column: 6,
											Line:   48,
										},
									},
								},
								Name: "fill",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					Lparen: nil,
					Rparen: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   45,
							},
							File:   "fill_default_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 18,
								Line:   45,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 23,
									Line:   45,
								},
								File:   "fill_default_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 18,
									Line:   45,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   45,
							},
							File:   "fill_default_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 24,
								Line:   45,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 101,
							Line:   51,
						},
						File:   "fill_default_test.flux",
						Source: "_fill = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_fill_string})",
						Start: ast.Position{
							Column: 6,
							Line:   50,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   50,
							},
							File:   "fill_default_test.flux",
							Source: "_fill",
							Start: ast.Position{
								Column: 6,
								Line:   50,
							},
						},
					},
					Name: "_fill",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 101,
								Line:   51,
							},
							File:   "fill_default_test.flux",
							Source: "() =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_fill_string})",
							Start: ast.Position{
								Column: 14,
								Line:   50,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 101,
									Line:   51,
								},
								File:   "fill_default_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_fill_string})",
								Start: ast.Position{
									Column: 2,
									Line:   51,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 100,
										Line:   51,
									},
									File:   "fill_default_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_fill_string}",
									Start: ast.Position{
										Column: 3,
										Line:   51,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   51,
										},
										File:   "fill_default_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 4,
											Line:   51,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 9,
												Line:   51,
											},
											File:   "fill_default_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 4,
												Line:   51,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 42,
													Line:   51,
												},
												File:   "fill_default_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 31,
													Line:   51,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 42,
														Line:   51,
													},
													File:   "fill_default_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 31,
														Line:   51,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 34,
															Line:   51,
														},
														File:   "fill_default_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 31,
															Line:   51,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 42,
															Line:   51,
														},
														File:   "fill_default_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 36,
															Line:   51,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   51,
											},
											File:   "fill_default_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 11,
												Line:   51,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   51,
												},
												File:   "fill_default_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 11,
													Line:   51,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   51,
													},
													File:   "fill_default_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 11,
														Line:   51,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 30,
														Line:   51,
													},
													File:   "fill_default_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 19,
														Line:   51,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 80,
											Line:   51,
										},
										File:   "fill_default_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 45,
											Line:   51,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   51,
											},
											File:   "fill_default_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 45,
												Line:   51,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 79,
													Line:   51,
												},
												File:   "fill_default_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 67,
													Line:   51,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 79,
														Line:   51,
													},
													File:   "fill_default_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 67,
														Line:   51,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 70,
															Line:   51,
														},
														File:   "fill_default_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 67,
															Line:   51,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 79,
															Line:   51,
														},
														File:   "fill_default_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 72,
															Line:   51,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 80,
												Line:   51,
											},
											File:   "fill_default_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 51,
												Line:   51,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 66,
													Line:   51,
												},
												File:   "fill_default_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 51,
													Line:   51,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 58,
														Line:   51,
													},
													File:   "fill_default_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 51,
														Line:   51,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 66,
														Line:   51,
													},
													File:   "fill_default_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 59,
														Line:   51,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 99,
											Line:   51,
										},
										File:   "fill_default_test.flux",
										Source: "fn: t_fill_string",
										Start: ast.Position{
											Column: 82,
											Line:   51,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 84,
												Line:   51,
											},
											File:   "fill_default_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 82,
												Line:   51,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 99,
												Line:   51,
											},
											File:   "fill_default_test.flux",
											Source: "t_fill_string",
											Start: ast.Position{
												Column: 86,
												Line:   51,
											},
										},
									},
									Name: "t_fill_string",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 101,
						Line:   51,
					},
					File:   "fill_default_test.flux",
					Source: "test _fill = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_fill_string})",
					Start: ast.Position{
						Column: 1,
						Line:   50,
					},
				},
			},
		}},
		Eof: []ast.Comment{ast.Comment{Text: "// Equivalent TICKscript query:\n"}, ast.Comment{Text: "// stream\n"}, ast.Comment{Text: "//   |default()\n"}, ast.Comment{Text: "//     .field('_value', tomato)"}},
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "fill_default_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "fill_default_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "fill_default_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 22,
						Line:   1,
					},
					File:   "fill_default_test.flux",
					Source: "package testdata_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 22,
							Line:   1,
						},
						File:   "fill_default_test.flux",
						Source: "testdata_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "testdata_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 95,
					Line:   32,
				},
				File:   "flatten_pivot_test.flux",
				Source: "package testdata_test\n\nimport \"testing\"\n\noption now = () => (2030-01-01T00:00:00Z)\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,long\n#group,false,false,false,true,true,false,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,_field,port,_value\n,,0,2018-05-22T19:53:26Z,m,A,80,3524\n,,0,2018-05-22T19:53:26Z,m,A,443,7253\n,,0,2018-05-22T19:53:26Z,m,B,443,9082\n\"\n\noutData = \"\n#datatype,string,long,dateTime:RFC3339,string,long,long,long\n#group,false,false,false,true,false,false,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,A_80,A_443,B_443\n,,0,2018-05-22T19:53:26Z,m,3524,7253,9082\n\"\n\nt_pivot = (table=<-) =>\n\t(table\n\t    |> range(start: 2018-05-15T00:00:00Z)\n\t    |> drop(columns: [\"_start\", \"_stop\"])\n\t\t|> pivot(rowKey: [\"_time\", \"_measurement\"], columnKey: [\"_field\", \"port\"], valueColumn: \"_value\"))\n\ntest _pivot = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_pivot})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   5,
						},
						File:   "flatten_pivot_test.flux",
						Source: "now = () => (2030-01-01T00:00:00Z)",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   5,
							},
							File:   "flatten_pivot_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   5,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   5,
							},
							File:   "flatten_pivot_test.flux",
							Source: "() => (2030-01-01T00:00:00Z)",
							Start: ast.Position{
								Column: 14,
								Line:   5,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   5,
								},
								File:   "flatten_pivot_test.flux",
								Source: "(2030-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 20,
									Line:   5,
								},
							},
						},
						Expression: &ast.DateTimeLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   5,
									},
									File:   "flatten_pivot_test.flux",
									Source: "2030-01-01T00:00:00Z",
									Start: ast.Position{
										Column: 21,
										Line:   5,
									},
								},
							},
							Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 42,
						Line:   5,
					},
					File:   "flatten_pivot_test.flux",
					Source: "option now = () => (2030-01-01T00:00:00Z)",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   15,
					},
					File:   "flatten_pivot_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,long\n#group,false,false,false,true,true,false,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,_field,port,_value\n,,0,2018-05-22T19:53:26Z,m,A,80,3524\n,,0,2018-05-22T19:53:26Z,m,A,443,7253\n,,0,2018-05-22T19:53:26Z,m,B,443,9082\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   7,
						},
						File:   "flatten_pivot_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   7,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   15,
						},
						File:   "flatten_pivot_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,string,long\n#group,false,false,false,true,true,false,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,_field,port,_value\n,,0,2018-05-22T19:53:26Z,m,A,80,3524\n,,0,2018-05-22T19:53:26Z,m,A,443,7253\n,,0,2018-05-22T19:53:26Z,m,B,443,9082\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   7,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,string,long\n#group,false,false,false,true,true,false,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,_field,port,_value\n,,0,2018-05-22T19:53:26Z,m,A,80,3524\n,,0,2018-05-22T19:53:26Z,m,A,443,7253\n,,0,2018-05-22T19:53:26Z,m,B,443,9082\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   23,
					},
					File:   "flatten_pivot_test.flux",
					Source: "outData = \"\n#datatype,string,long,dateTime:RFC3339,string,long,long,long\n#group,false,false,false,true,false,false,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,A_80,A_443,B_443\n,,0,2018-05-22T19:53:26Z,m,3524,7253,9082\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   17,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   17,
						},
						File:   "flatten_pivot_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   17,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   23,
						},
						File:   "flatten_pivot_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,long,long,long\n#group,false,false,false,true,false,false,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,A_80,A_443,B_443\n,,0,2018-05-22T19:53:26Z,m,3524,7253,9082\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   17,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,long,long,long\n#group,false,false,false,true,false,false,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,A_80,A_443,B_443\n,,0,2018-05-22T19:53:26Z,m,3524,7253,9082\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 101,
						Line:   29,
					},
					File:   "flatten_pivot_test.flux",
					Source: "t_pivot = (table=<-) =>\n\t(table\n\t    |> range(start: 2018-05-15T00:00:00Z)\n\t    |> drop(columns: [\"_start\", \"_stop\"])\n\t\t|> pivot(rowKey: [\"_time\", \"_measurement\"], columnKey: [\"_field\", \"port\"], valueColumn: \"_value\"))",
					Start: ast.Position{
						Column: 1,
						Line:   25,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   25,
						},
						File:   "flatten_pivot_test.flux",
						Source: "t_pivot",
						Start: ast.Position{
							Column: 1,
							Line:   25,
						},
					},
				},
				Name: "t_pivot",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 101,
							Line:   29,
						},
						File:   "flatten_pivot_test.flux",
						Source: "(table=<-) =>\n\t(table\n\t    |> range(start: 2018-05-15T00:00:00Z)\n\t    |> drop(columns: [\"_start\", \"_stop\"])\n\t\t|> pivot(rowKey: [\"_time\", \"_measurement\"], columnKey: [\"_field\", \"port\"], valueColumn: \"_value\"))",
						Start: ast.Position{
							Column: 11,
							Line:   25,
						},
					},
				},
				Body: &ast.ParenExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 101,
								Line:   29,
							},
							File:   "flatten_pivot_test.flux",
							Source: "(table\n\t    |> range(start: 2018-05-15T00:00:00Z)\n\t    |> drop(columns: [\"_start\", \"_stop\"])\n\t\t|> pivot(rowKey: [\"_time\", \"_measurement\"], columnKey: [\"_field\", \"port\"], valueColumn: \"_value\"))",
							Start: ast.Position{
								Column: 2,
								Line:   26,
							},
						},
					},
					Expression: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 8,
												Line:   26,
											},
											File:   "flatten_pivot_test.flux",
											Source: "table",
											Start: ast.Position{
												Column: 3,
												Line:   26,
											},
										},
									},
									Name: "table",
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   27,
										},
										File:   "flatten_pivot_test.flux",
										Source: "table\n\t    |> range(start: 2018-05-15T00:00:00Z)",
										Start: ast.Position{
											Column: 3,
											Line:   26,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 42,
													Line:   27,
												},
												File:   "flatten_pivot_test.flux",
												Source: "start: 2018-05-15T00:00:00Z",
												Start: ast.Position{
													Column: 15,
													Line:   27,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 42,
														Line:   27,
													},
													File:   "flatten_pivot_test.flux",
													Source: "start: 2018-05-15T00:00:00Z",
													Start: ast.Position{
														Column: 15,
														Line:   27,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 20,
															Line:   27,
														},
														File:   "flatten_pivot_test.flux",
														Source: "start",
														Start: ast.Position{
															Column: 15,
															Line:   27,
														},
													},
												},
												Name: "start",
											},
											Separator: nil,
											Value: &ast.DateTimeLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 42,
															Line:   27,
														},
														File:   "flatten_pivot_test.flux",
														Source: "2018-05-15T00:00:00Z",
														Start: ast.Position{
															Column: 22,
															Line:   27,
														},
													},
												},
												Value: parser.MustParseTime("2018-05-15T00:00:00Z"),
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   27,
											},
											File:   "flatten_pivot_test.flux",
											Source: "range(start: 2018-05-15T00:00:00Z)",
											Start: ast.Position{
												Column: 9,
												Line:   27,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 14,
													Line:   27,
												},
												File:   "flatten_pivot_test.flux",
												Source: "range",
												Start: ast.Position{
													Column: 9,
													Line:   27,
												},
											},
										},
										Name: "range",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 43,
										Line:   28,
									},
									File:   "flatten_pivot_test.flux",
									Source: "table\n\t    |> range(start: 2018-05-15T00:00:00Z)\n\t    |> drop(columns: [\"_start\", \"_stop\"])",
									Start: ast.Position{
										Column: 3,
										Line:   26,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 42,
												Line:   28,
											},
											File:   "flatten_pivot_test.flux",
											Source: "columns: [\"_start\", \"_stop\"]",
											Start: ast.Position{
												Column: 14,
												Line:   28,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 42,
													Line:   28,
												},
												File:   "flatten_pivot_test.flux",
												Source: "columns: [\"_start\", \"_stop\"]",
												Start: ast.Position{
													Column: 14,
													Line:   28,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 21,
														Line:   28,
													},
													File:   "flatten_pivot_test.flux",
													Source: "columns",
													Start: ast.Position{
														Column: 14,
														Line:   28,
													},
												},
											},
											Name: "columns",
										},
										Separator: nil,
										Value: &ast.ArrayExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 42,
														Line:   28,
													},
													File:   "flatten_pivot_test.flux",
													Source: "[\"_start\", \"_stop\"]",
													Start: ast.Position{
														Column: 23,
														Line:   28,
													},
												},
											},
											Elements: []ast.Expression{&ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 32,
															Line:   28,
														},
														File:   "flatten_pivot_test.flux",
														Source: "\"_start\"",
														Start: ast.Position{
															Column: 24,
															Line:   28,
														},
													},
												},
												Value: "_start",
											}, &ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 41,
															Line:   28,
														},
														File:   "flatten_pivot_test.flux",
														Source: "\"_stop\"",
														Start: ast.Position{
															Column: 34,
															Line:   28,
														},
													},
												},
												Value: "_stop",
											}},
											Lbrack: nil,
											Rbrack: nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   28,
										},
										File:   "flatten_pivot_test.flux",
										Source: "drop(columns: [\"_start\", \"_stop\"])",
										Start: ast.Position{
											Column: 9,
											Line:   28,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 13,
												Line:   28,
											},
											File:   "flatten_pivot_test.flux",
											Source: "drop",
											Start: ast.Position{
												Column: 9,
												Line:   28,
											},
										},
									},
									Name: "drop",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 100,
									Line:   29,
								},
								File:   "flatten_pivot_test.flux",
								Source: "table\n\t    |> range(start: 2018-05-15T00:00:00Z)\n\t    |> drop(columns: [\"_start\", \"_stop\"])\n\t\t|> pivot(rowKey: [\"_time\", \"_measurement\"], columnKey: [\"_field\", \"port\"], valueColumn: \"_value\")",
								Start: ast.Position{
									Column: 3,
									Line:   26,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 99,
											Line:   29,
										},
										File:   "flatten_pivot_test.flux",
										Source: "rowKey: [\"_time\", \"_measurement\"], columnKey: [\"_field\", \"port\"], valueColumn: \"_value\"",
										Start: ast.Position{
											Column: 12,
											Line:   29,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 45,
												Line:   29,
											},
											File:   "flatten_pivot_test.flux",
											Source: "rowKey: [\"_time\", \"_measurement\"]",
											Start: ast.Position{
												Column: 12,
												Line:   29,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   29,
												},
												File:   "flatten_pivot_test.flux",
												Source: "rowKey",
												Start: ast.Position{
													Column: 12,
													Line:   29,
												},
											},
										},
										Name: "rowKey",
									},
									Separator: nil,
									Value: &ast.ArrayExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 45,
													Line:   29,
												},
												File:   "flatten_pivot_test.flux",
												Source: "[\"_time\", \"_measurement\"]",
												Start: ast.Position{
													Column: 20,
													Line:   29,
												},
											},
										},
										Elements: []ast.Expression{&ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 28,
														Line:   29,
													},
													File:   "flatten_pivot_test.flux",
													Source: "\"_time\"",
													Start: ast.Position{
														Column: 21,
														Line:   29,
													},
												},
											},
											Value: "_time",
										}, &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 44,
														Line:   29,
													},
													File:   "flatten_pivot_test.flux",
													Source: "\"_measurement\"",
													Start: ast.Position{
														Column: 30,
														Line:   29,
													},
												},
											},
											Value: "_measurement",
										}},
										Lbrack: nil,
										Rbrack: nil,
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 76,
												Line:   29,
											},
											File:   "flatten_pivot_test.flux",
											Source: "columnKey: [\"_field\", \"port\"]",
											Start: ast.Position{
												Column: 47,
												Line:   29,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 56,
													Line:   29,
												},
												File:   "flatten_pivot_test.flux",
												Source: "columnKey",
												Start: ast.Position{
													Column: 47,
													Line:   29,
												},
											},
										},
										Name: "columnKey",
									},
									Separator: nil,
									Value: &ast.ArrayExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 76,
													Line:   29,
												},
												File:   "flatten_pivot_test.flux",
												Source: "[\"_field\", \"port\"]",
												Start: ast.Position{
													Column: 58,
													Line:   29,
												},
											},
										},
										Elements: []ast.Expression{&ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 67,
														Line:   29,
													},
													File:   "flatten_pivot_test.flux",
													Source: "\"_field\"",
													Start: ast.Position{
														Column: 59,
														Line:   29,
													},
												},
											},
											Value: "_field",
										}, &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 75,
														Line:   29,
													},
													File:   "flatten_pivot_test.flux",
													Source: "\"port\"",
													Start: ast.Position{
														Column: 69,
														Line:   29,
													},
												},
											},
											Value: "port",
										}},
										Lbrack: nil,
										Rbrack: nil,
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 99,
												Line:   29,
											},
											File:   "flatten_pivot_test.flux",
											Source: "valueColumn: \"_value\"",
											Start: ast.Position{
												Column: 78,
												Line:   29,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 89,
													Line:   29,
												},
												File:   "flatten_pivot_test.flux",
												Source: "valueColumn",
												Start: ast.Position{
													Column: 78,
													Line:   29,
												},
											},
										},
										Name: "valueColumn",
									},
									Separator: nil,
									Value: &ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 99,
													Line:   29,
												},
												File:   "flatten_pivot_test.flux",
												Source: "\"_value\"",
												Start: ast.Position{
													Column: 91,
													Line:   29,
												},
											},
										},
										Value: "_value",
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 100,
										Line:   29,
									},
									File:   "flatten_pivot_test.flux",
									Source: "pivot(rowKey: [\"_time\", \"_measurement\"], columnKey: [\"_field\", \"port\"], valueColumn: \"_value\")",
									Start: ast.Position{
										Column: 6,
										Line:   29,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 11,
											Line:   29,
										},
										File:   "flatten_pivot_test.flux",
										Source: "pivot",
										Start: ast.Position{
											Column: 6,
											Line:   29,
										},
									},
								},
								Name: "pivot",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					Lparen: nil,
					Rparen: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 20,
								Line:   25,
							},
							File:   "flatten_pivot_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 12,
								Line:   25,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 17,
									Line:   25,
								},
								File:   "flatten_pivot_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 12,
									Line:   25,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 20,
								Line:   25,
							},
							File:   "flatten_pivot_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 18,
								Line:   25,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 95,
							Line:   32,
						},
						File:   "flatten_pivot_test.flux",
						Source: "_pivot = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_pivot})",
						Start: ast.Position{
							Column: 6,
							Line:   31,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 12,
								Line:   31,
							},
							File:   "flatten_pivot_test.flux",
							Source: "_pivot",
							Start: ast.Position{
								Column: 6,
								Line:   31,
							},
						},
					},
					Name: "_pivot",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 95,
								Line:   32,
							},
							File:   "flatten_pivot_test.flux",
							Source: "() =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_pivot})",
							Start: ast.Position{
								Column: 15,
								Line:   31,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 95,
									Line:   32,
								},
								File:   "flatten_pivot_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_pivot})",
								Start: ast.Position{
									Column: 2,
									Line:   32,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 94,
										Line:   32,
									},
									File:   "flatten_pivot_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_pivot}",
									Start: ast.Position{
										Column: 3,
										Line:   32,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   32,
										},
										File:   "flatten_pivot_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 4,
											Line:   32,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 9,
												Line:   32,
											},
											File:   "flatten_pivot_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 4,
												Line:   32,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 42,
													Line:   32,
												},
												File:   "flatten_pivot_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 31,
													Line:   32,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 42,
														Line:   32,
													},
													File:   "flatten_pivot_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 31,
														Line:   32,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 34,
															Line:   32,
														},
														File:   "flatten_pivot_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 31,
															Line:   32,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 42,
															Line:   32,
														},
														File:   "flatten_pivot_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 36,
															Line:   32,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   32,
											},
											File:   "flatten_pivot_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 11,
												Line:   32,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   32,
												},
												File:   "flatten_pivot_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 11,
													Line:   32,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   32,
													},
													File:   "flatten_pivot_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 11,
														Line:   32,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 30,
														Line:   32,
													},
													File:   "flatten_pivot_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 19,
														Line:   32,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 80,
											Line:   32,
										},
										File:   "flatten_pivot_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 45,
											Line:   32,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   32,
											},
											File:   "flatten_pivot_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 45,
												Line:   32,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 79,
													Line:   32,
												},
												File:   "flatten_pivot_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 67,
													Line:   32,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 79,
														Line:   32,
													},
													File:   "flatten_pivot_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 67,
														Line:   32,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 70,
															Line:   32,
														},
														File:   "flatten_pivot_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 67,
															Line:   32,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 79,
															Line:   32,
														},
														File:   "flatten_pivot_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 72,
															Line:   32,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 80,
												Line:   32,
											},
											File:   "flatten_pivot_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 51,
												Line:   32,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 66,
													Line:   32,
												},
												File:   "flatten_pivot_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 51,
													Line:   32,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 58,
														Line:   32,
													},
													File:   "flatten_pivot_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 51,
														Line:   32,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 66,
														Line:   32,
													},
													File:   "flatten_pivot_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 59,
														Line:   32,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 93,
											Line:   32,
										},
										File:   "flatten_pivot_test.flux",
										Source: "fn: t_pivot",
										Start: ast.Position{
											Column: 82,
											Line:   32,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 84,
												Line:   32,
											},
											File:   "flatten_pivot_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 82,
												Line:   32,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 93,
												Line:   32,
											},
											File:   "flatten_pivot_test.flux",
											Source: "t_pivot",
											Start: ast.Position{
												Column: 86,
												Line:   32,
											},
										},
									},
									Name: "t_pivot",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 95,
						Line:   32,
					},
					File:   "flatten_pivot_test.flux",
					Source: "test _pivot = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_pivot})",
					Start: ast.Position{
						Column: 1,
						Line:   31,
					},
				},
			},
		}},
		Eof: []ast.Comment{ast.Comment{Text: "// Equivalent TICKscript query:\n"}, ast.Comment{Text: "// stream\n"}, ast.Comment{Text: "//   |flatten()\n"}, ast.Comment{Text: "//     .on('_field', 'port')"}},
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "flatten_pivot_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "flatten_pivot_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "flatten_pivot_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 22,
						Line:   1,
					},
					File:   "flatten_pivot_test.flux",
					Source: "package testdata_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 22,
							Line:   1,
						},
						File:   "flatten_pivot_test.flux",
						Source: "testdata_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "testdata_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 100,
					Line:   60,
				},
				File:   "noop_yield_test.flux",
				Source: "package testdata_test\n\nimport \"testing\"\n\noption now = () => (2030-01-01T00:00:00Z)\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,double,string,string\n#group,false,false,false,false,true,true\n#default,_result,,,,,\n,result,table,_time,_value,_measurement,_field\n,,0,2018-05-22T19:53:26Z,0,CPU,user1\n,,0,2018-05-22T19:53:36Z,1,CPU,user1\n,,1,2018-05-22T19:53:26Z,4,CPU,user2\n,,1,2018-05-22T19:53:36Z,20,CPU,user2\n,,1,2018-05-22T19:53:46Z,7,CPU,user2\n,,1,2018-05-22T19:53:56Z,10,CPU,user2\n,,2,2018-05-22T19:53:26Z,1,RAM,user1\n,,2,2018-05-22T19:53:36Z,2,RAM,user1\n,,2,2018-05-22T19:53:46Z,3,RAM,user1\n,,2,2018-05-22T19:53:56Z,5,RAM,user1\n,,3,2018-05-22T19:53:26Z,2,RAM,user2\n,,3,2018-05-22T19:53:36Z,4,RAM,user2\n,,3,2018-05-22T19:53:46Z,4,RAM,user2\n,,3,2018-05-22T19:53:56Z,0,RAM,user2\n,,3,2018-05-22T19:54:06Z,2,RAM,user2\n,,3,2018-05-22T19:54:16Z,10,RAM,user2\n\"\n\noutData = \"\n#datatype,string,long,dateTime:RFC3339,double,string,string\n#group,false,false,false,false,true,true\n#default,_result,,,,,\n,result,table,_time,_value,_measurement,_field\n,_results,0,2018-05-22T19:53:26Z,0,CPU,user1\n,_results,0,2018-05-22T19:53:36Z,1,CPU,user1\n,_results,1,2018-05-22T19:53:26Z,4,CPU,user2\n,_results,1,2018-05-22T19:53:36Z,20,CPU,user2\n,_results,1,2018-05-22T19:53:46Z,7,CPU,user2\n,_results,1,2018-05-22T19:53:56Z,10,CPU,user2\n,_results,2,2018-05-22T19:53:26Z,1,RAM,user1\n,_results,2,2018-05-22T19:53:36Z,2,RAM,user1\n,_results,2,2018-05-22T19:53:46Z,3,RAM,user1\n,_results,2,2018-05-22T19:53:56Z,5,RAM,user1\n,_results,3,2018-05-22T19:53:26Z,2,RAM,user2\n,_results,3,2018-05-22T19:53:36Z,4,RAM,user2\n,_results,3,2018-05-22T19:53:46Z,4,RAM,user2\n,_results,3,2018-05-22T19:53:56Z,0,RAM,user2\n,_results,3,2018-05-22T19:54:06Z,2,RAM,user2\n,_results,3,2018-05-22T19:54:16Z,10,RAM,user2\n\"\n\nt_noop_yield = (table=<-) =>\n    (table\n        |> range(start: 2018-05-15T00:00:00Z)\n        |> drop(columns: [\"_start\", \"_stop\"]))\n// yield() is implicit here\n\ntest _noop_yield = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_noop_yield})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   5,
						},
						File:   "noop_yield_test.flux",
						Source: "now = () => (2030-01-01T00:00:00Z)",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   5,
							},
							File:   "noop_yield_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   5,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   5,
							},
							File:   "noop_yield_test.flux",
							Source: "() => (2030-01-01T00:00:00Z)",
							Start: ast.Position{
								Column: 14,
								Line:   5,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   5,
								},
								File:   "noop_yield_test.flux",
								Source: "(2030-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 20,
									Line:   5,
								},
							},
						},
						Expression: &ast.DateTimeLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   5,
									},
									File:   "noop_yield_test.flux",
									Source: "2030-01-01T00:00:00Z",
									Start: ast.Position{
										Column: 21,
										Line:   5,
									},
								},
							},
							Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 42,
						Line:   5,
					},
					File:   "noop_yield_test.flux",
					Source: "option now = () => (2030-01-01T00:00:00Z)",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   28,
					},
					File:   "noop_yield_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,double,string,string\n#group,false,false,false,false,true,true\n#default,_result,,,,,\n,result,table,_time,_value,_measurement,_field\n,,0,2018-05-22T19:53:26Z,0,CPU,user1\n,,0,2018-05-22T19:53:36Z,1,CPU,user1\n,,1,2018-05-22T19:53:26Z,4,CPU,user2\n,,1,2018-05-22T19:53:36Z,20,CPU,user2\n,,1,2018-05-22T19:53:46Z,7,CPU,user2\n,,1,2018-05-22T19:53:56Z,10,CPU,user2\n,,2,2018-05-22T19:53:26Z,1,RAM,user1\n,,2,2018-05-22T19:53:36Z,2,RAM,user1\n,,2,2018-05-22T19:53:46Z,3,RAM,user1\n,,2,2018-05-22T19:53:56Z,5,RAM,user1\n,,3,2018-05-22T19:53:26Z,2,RAM,user2\n,,3,2018-05-22T19:53:36Z,4,RAM,user2\n,,3,2018-05-22T19:53:46Z,4,RAM,user2\n,,3,2018-05-22T19:53:56Z,0,RAM,user2\n,,3,2018-05-22T19:54:06Z,2,RAM,user2\n,,3,2018-05-22T19:54:16Z,10,RAM,user2\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   7,
						},
						File:   "noop_yield_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   7,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   28,
						},
						File:   "noop_yield_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,double,string,string\n#group,false,false,false,false,true,true\n#default,_result,,,,,\n,result,table,_time,_value,_measurement,_field\n,,0,2018-05-22T19:53:26Z,0,CPU,user1\n,,0,2018-05-22T19:53:36Z,1,CPU,user1\n,,1,2018-05-22T19:53:26Z,4,CPU,user2\n,,1,2018-05-22T19:53:36Z,20,CPU,user2\n,,1,2018-05-22T19:53:46Z,7,CPU,user2\n,,1,2018-05-22T19:53:56Z,10,CPU,user2\n,,2,2018-05-22T19:53:26Z,1,RAM,user1\n,,2,2018-05-22T19:53:36Z,2,RAM,user1\n,,2,2018-05-22T19:53:46Z,3,RAM,user1\n,,2,2018-05-22T19:53:56Z,5,RAM,user1\n,,3,2018-05-22T19:53:26Z,2,RAM,user2\n,,3,2018-05-22T19:53:36Z,4,RAM,user2\n,,3,2018-05-22T19:53:46Z,4,RAM,user2\n,,3,2018-05-22T19:53:56Z,0,RAM,user2\n,,3,2018-05-22T19:54:06Z,2,RAM,user2\n,,3,2018-05-22T19:54:16Z,10,RAM,user2\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   7,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,double,string,string\n#group,false,false,false,false,true,true\n#default,_result,,,,,\n,result,table,_time,_value,_measurement,_field\n,,0,2018-05-22T19:53:26Z,0,CPU,user1\n,,0,2018-05-22T19:53:36Z,1,CPU,user1\n,,1,2018-05-22T19:53:26Z,4,CPU,user2\n,,1,2018-05-22T19:53:36Z,20,CPU,user2\n,,1,2018-05-22T19:53:46Z,7,CPU,user2\n,,1,2018-05-22T19:53:56Z,10,CPU,user2\n,,2,2018-05-22T19:53:26Z,1,RAM,user1\n,,2,2018-05-22T19:53:36Z,2,RAM,user1\n,,2,2018-05-22T19:53:46Z,3,RAM,user1\n,,2,2018-05-22T19:53:56Z,5,RAM,user1\n,,3,2018-05-22T19:53:26Z,2,RAM,user2\n,,3,2018-05-22T19:53:36Z,4,RAM,user2\n,,3,2018-05-22T19:53:46Z,4,RAM,user2\n,,3,2018-05-22T19:53:56Z,0,RAM,user2\n,,3,2018-05-22T19:54:06Z,2,RAM,user2\n,,3,2018-05-22T19:54:16Z,10,RAM,user2\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   51,
					},
					File:   "noop_yield_test.flux",
					Source: "outData = \"\n#datatype,string,long,dateTime:RFC3339,double,string,string\n#group,false,false,false,false,true,true\n#default,_result,,,,,\n,result,table,_time,_value,_measurement,_field\n,_results,0,2018-05-22T19:53:26Z,0,CPU,user1\n,_results,0,2018-05-22T19:53:36Z,1,CPU,user1\n,_results,1,2018-05-22T19:53:26Z,4,CPU,user2\n,_results,1,2018-05-22T19:53:36Z,20,CPU,user2\n,_results,1,2018-05-22T19:53:46Z,7,CPU,user2\n,_results,1,2018-05-22T19:53:56Z,10,CPU,user2\n,_results,2,2018-05-22T19:53:26Z,1,RAM,user1\n,_results,2,2018-05-22T19:53:36Z,2,RAM,user1\n,_results,2,2018-05-22T19:53:46Z,3,RAM,user1\n,_results,2,2018-05-22T19:53:56Z,5,RAM,user1\n,_results,3,2018-05-22T19:53:26Z,2,RAM,user2\n,_results,3,2018-05-22T19:53:36Z,4,RAM,user2\n,_results,3,2018-05-22T19:53:46Z,4,RAM,user2\n,_results,3,2018-05-22T19:53:56Z,0,RAM,user2\n,_results,3,2018-05-22T19:54:06Z,2,RAM,user2\n,_results,3,2018-05-22T19:54:16Z,10,RAM,user2\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   30,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   30,
						},
						File:   "noop_yield_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   30,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   51,
						},
						File:   "noop_yield_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,double,string,string\n#group,false,false,false,false,true,true\n#default,_result,,,,,\n,result,table,_time,_value,_measurement,_field\n,_results,0,2018-05-22T19:53:26Z,0,CPU,user1\n,_results,0,2018-05-22T19:53:36Z,1,CPU,user1\n,_results,1,2018-05-22T19:53:26Z,4,CPU,user2\n,_results,1,2018-05-22T19:53:36Z,20,CPU,user2\n,_results,1,2018-05-22T19:53:46Z,7,CPU,user2\n,_results,1,2018-05-22T19:53:56Z,10,CPU,user2\n,_results,2,2018-05-22T19:53:26Z,1,RAM,user1\n,_results,2,2018-05-22T19:53:36Z,2,RAM,user1\n,_results,2,2018-05-22T19:53:46Z,3,RAM,user1\n,_results,2,2018-05-22T19:53:56Z,5,RAM,user1\n,_results,3,2018-05-22T19:53:26Z,2,RAM,user2\n,_results,3,2018-05-22T19:53:36Z,4,RAM,user2\n,_results,3,2018-05-22T19:53:46Z,4,RAM,user2\n,_results,3,2018-05-22T19:53:56Z,0,RAM,user2\n,_results,3,2018-05-22T19:54:06Z,2,RAM,user2\n,_results,3,2018-05-22T19:54:16Z,10,RAM,user2\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   30,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,double,string,string\n#group,false,false,false,false,true,true\n#default,_result,,,,,\n,result,table,_time,_value,_measurement,_field\n,_results,0,2018-05-22T19:53:26Z,0,CPU,user1\n,_results,0,2018-05-22T19:53:36Z,1,CPU,user1\n,_results,1,2018-05-22T19:53:26Z,4,CPU,user2\n,_results,1,2018-05-22T19:53:36Z,20,CPU,user2\n,_results,1,2018-05-22T19:53:46Z,7,CPU,user2\n,_results,1,2018-05-22T19:53:56Z,10,CPU,user2\n,_results,2,2018-05-22T19:53:26Z,1,RAM,user1\n,_results,2,2018-05-22T19:53:36Z,2,RAM,user1\n,_results,2,2018-05-22T19:53:46Z,3,RAM,user1\n,_results,2,2018-05-22T19:53:56Z,5,RAM,user1\n,_results,3,2018-05-22T19:53:26Z,2,RAM,user2\n,_results,3,2018-05-22T19:53:36Z,4,RAM,user2\n,_results,3,2018-05-22T19:53:46Z,4,RAM,user2\n,_results,3,2018-05-22T19:53:56Z,0,RAM,user2\n,_results,3,2018-05-22T19:54:06Z,2,RAM,user2\n,_results,3,2018-05-22T19:54:16Z,10,RAM,user2\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 47,
						Line:   56,
					},
					File:   "noop_yield_test.flux",
					Source: "t_noop_yield = (table=<-) =>\n    (table\n        |> range(start: 2018-05-15T00:00:00Z)\n        |> drop(columns: [\"_start\", \"_stop\"]))",
					Start: ast.Position{
						Column: 1,
						Line:   53,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   53,
						},
						File:   "noop_yield_test.flux",
						Source: "t_noop_yield",
						Start: ast.Position{
							Column: 1,
							Line:   53,
						},
					},
				},
				Name: "t_noop_yield",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 47,
							Line:   56,
						},
						File:   "noop_yield_test.flux",
						Source: "(table=<-) =>\n    (table\n        |> range(start: 2018-05-15T00:00:00Z)\n        |> drop(columns: [\"_start\", \"_stop\"]))",
						Start: ast.Position{
							Column: 16,
							Line:   53,
						},
					},
				},
				Body: &ast.ParenExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 47,
								Line:   56,
							},
							File:   "noop_yield_test.flux",
							Source: "(table\n        |> range(start: 2018-05-15T00:00:00Z)\n        |> drop(columns: [\"_start\", \"_stop\"]))",
							Start: ast.Position{
								Column: 5,
								Line:   54,
							},
						},
					},
					Expression: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 11,
											Line:   54,
										},
										File:   "noop_yield_test.flux",
										Source: "table",
										Start: ast.Position{
											Column: 6,
											Line:   54,
										},
									},
								},
								Name: "table",
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 46,
										Line:   55,
									},
									File:   "noop_yield_test.flux",
									Source: "table\n        |> range(start: 2018-05-15T00:00:00Z)",
									Start: ast.Position{
										Column: 6,
										Line:   54,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 45,
												Line:   55,
											},
											File:   "noop_yield_test.flux",
											Source: "start: 2018-05-15T00:00:00Z",
											Start: ast.Position{
												Column: 18,
												Line:   55,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 45,
													Line:   55,
												},
												File:   "noop_yield_test.flux",
												Source: "start: 2018-05-15T00:00:00Z",
												Start: ast.Position{
													Column: 18,
													Line:   55,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 23,
														Line:   55,
													},
													File:   "noop_yield_test.flux",
													Source: "start",
													Start: ast.Position{
														Column: 18,
														Line:   55,
													},
												},
											},
											Name: "start",
										},
										Separator: nil,
										Value: &ast.DateTimeLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 45,
														Line:   55,
													},
													File:   "noop_yield_test.flux",
													Source: "2018-05-15T00:00:00Z",
													Start: ast.Position{
														Column: 25,
														Line:   55,
													},
												},
											},
											Value: parser.MustParseTime("2018-05-15T00:00:00Z"),
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 46,
											Line:   55,
										},
										File:   "noop_yield_test.flux",
										Source: "range(start: 2018-05-15T00:00:00Z)",
										Start: ast.Position{
											Column: 12,
											Line:   55,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   55,
											},
											File:   "noop_yield_test.flux",
											Source: "range",
											Start: ast.Position{
												Column: 12,
												Line:   55,
											},
										},
									},
									Name: "range",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 46,
									Line:   56,
								},
								File:   "noop_yield_test.flux",
								Source: "table\n        |> range(start: 2018-05-15T00:00:00Z)\n        |> drop(columns: [\"_start\", \"_stop\"])",
								Start: ast.Position{
									Column: 6,
									Line:   54,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 45,
											Line:   56,
										},
										File:   "noop_yield_test.flux",
										Source: "columns: [\"_start\", \"_stop\"]",
										Start: ast.Position{
											Column: 17,
											Line:   56,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 45,
												Line:   56,
											},
											File:   "noop_yield_test.flux",
											Source: "columns: [\"_start\", \"_stop\"]",
											Start: ast.Position{
												Column: 17,
												Line:   56,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 24,
													Line:   56,
												},
												File:   "noop_yield_test.flux",
												Source: "columns",
												Start: ast.Position{
													Column: 17,
													Line:   56,
												},
											},
										},
										Name: "columns",
									},
									Separator: nil,
									Value: &ast.ArrayExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 45,
													Line:   56,
												},
												File:   "noop_yield_test.flux",
												Source: "[\"_start\", \"_stop\"]",
												Start: ast.Position{
													Column: 26,
													Line:   56,
												},
											},
										},
										Elements: []ast.Expression{&ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 35,
														Line:   56,
													},
													File:   "noop_yield_test.flux",
													Source: "\"_start\"",
													Start: ast.Position{
														Column: 27,
														Line:   56,
													},
												},
											},
											Value: "_start",
										}, &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 44,
														Line:   56,
													},
													File:   "noop_yield_test.flux",
													Source: "\"_stop\"",
													Start: ast.Position{
														Column: 37,
														Line:   56,
													},
												},
											},
											Value: "_stop",
										}},
										Lbrack: nil,
										Rbrack: nil,
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 46,
										Line:   56,
									},
									File:   "noop_yield_test.flux",
									Source: "drop(columns: [\"_start\", \"_stop\"])",
									Start: ast.Position{
										Column: 12,
										Line:   56,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 16,
											Line:   56,
										},
										File:   "noop_yield_test.flux",
										Source: "drop",
										Start: ast.Position{
											Column: 12,
											Line:   56,
										},
									},
								},
								Name: "drop",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					Lparen: nil,
					Rparen: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 25,
								Line:   53,
							},
							File:   "noop_yield_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 17,
								Line:   53,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 22,
									Line:   53,
								},
								File:   "noop_yield_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 17,
									Line:   53,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 25,
								Line:   53,
							},
							File:   "noop_yield_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 23,
								Line:   53,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 100,
							Line:   60,
						},
						File:   "noop_yield_test.flux",
						Source: "_noop_yield = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_noop_yield})",
						Start: ast.Position{
							Column: 6,
							Line:   59,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 17,
								Line:   59,
							},
							File:   "noop_yield_test.flux",
							Source: "_noop_yield",
							Start: ast.Position{
								Column: 6,
								Line:   59,
							},
						},
					},
					Name: "_noop_yield",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 100,
								Line:   60,
							},
							File:   "noop_yield_test.flux",
							Source: "() =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_noop_yield})",
							Start: ast.Position{
								Column: 20,
								Line:   59,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 100,
									Line:   60,
								},
								File:   "noop_yield_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_noop_yield})",
								Start: ast.Position{
									Column: 2,
									Line:   60,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 99,
										Line:   60,
									},
									File:   "noop_yield_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_noop_yield}",
									Start: ast.Position{
										Column: 3,
										Line:   60,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   60,
										},
										File:   "noop_yield_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 4,
											Line:   60,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 9,
												Line:   60,
											},
											File:   "noop_yield_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 4,
												Line:   60,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 42,
													Line:   60,
												},
												File:   "noop_yield_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 31,
													Line:   60,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 42,
														Line:   60,
													},
													File:   "noop_yield_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 31,
														Line:   60,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 34,
															Line:   60,
														},
														File:   "noop_yield_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 31,
															Line:   60,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 42,
															Line:   60,
														},
														File:   "noop_yield_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 36,
															Line:   60,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   60,
											},
											File:   "noop_yield_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 11,
												Line:   60,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   60,
												},
												File:   "noop_yield_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 11,
													Line:   60,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   60,
													},
													File:   "noop_yield_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 11,
														Line:   60,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 30,
														Line:   60,
													},
													File:   "noop_yield_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 19,
														Line:   60,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 80,
											Line:   60,
										},
										File:   "noop_yield_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 45,
											Line:   60,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   60,
											},
											File:   "noop_yield_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 45,
												Line:   60,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 79,
													Line:   60,
												},
												File:   "noop_yield_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 67,
													Line:   60,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 79,
														Line:   60,
													},
													File:   "noop_yield_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 67,
														Line:   60,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 70,
															Line:   60,
														},
														File:   "noop_yield_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 67,
															Line:   60,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 79,
															Line:   60,
														},
														File:   "noop_yield_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 72,
															Line:   60,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 80,
												Line:   60,
											},
											File:   "noop_yield_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 51,
												Line:   60,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 66,
													Line:   60,
												},
												File:   "noop_yield_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 51,
													Line:   60,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 58,
														Line:   60,
													},
													File:   "noop_yield_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 51,
														Line:   60,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 66,
														Line:   60,
													},
													File:   "noop_yield_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 59,
														Line:   60,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 98,
											Line:   60,
										},
										File:   "noop_yield_test.flux",
										Source: "fn: t_noop_yield",
										Start: ast.Position{
											Column: 82,
											Line:   60,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 84,
												Line:   60,
											},
											File:   "noop_yield_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 82,
												Line:   60,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 98,
												Line:   60,
											},
											File:   "noop_yield_test.flux",
											Source: "t_noop_yield",
											Start: ast.Position{
												Column: 86,
												Line:   60,
											},
										},
									},
									Name: "t_noop_yield",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// yield() is implicit here\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 100,
						Line:   60,
					},
					File:   "noop_yield_test.flux",
					Source: "test _noop_yield = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_noop_yield})",
					Start: ast.Position{
						Column: 1,
						Line:   59,
					},
				},
			},
		}},
		Eof: []ast.Comment{ast.Comment{Text: "// In TICKscript, noOp is implicit (NoOpNode is automatically appended to any node that is a source for a StatsNode)"}},
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "noop_yield_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "noop_yield_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "noop_yield_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 22,
						Line:   1,
					},
					File:   "noop_yield_test.flux",
					Source: "package testdata_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 22,
							Line:   1,
						},
						File:   "noop_yield_test.flux",
						Source: "testdata_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "testdata_test",
			},
		},
	}},
	Package: "testdata_test",
	Path:    "testing/kapacitor",
}}
