// DO NOT EDIT: This file is autogenerated via the builtin command.

package universe

import (
	ast "github.com/influxdata/flux/ast"
	runtime "github.com/influxdata/flux/runtime"
)

func init() {
	runtime.RegisterPackage(pkgAST)
}

var pkgAST = &ast.Package{
	BaseNode: ast.BaseNode{
		Comments: nil,
		Errors:   nil,
		Loc:      nil,
	},
	Files: []*ast.File{&ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 87,
					Line:   383,
				},
				File:   "universe.flux",
				Source: "package universe\n\n\nimport \"system\"\nimport \"date\"\nimport \"math\"\nimport \"strings\"\nimport \"regexp\"\n\n// now is a function option whose default behaviour is to return the current system time\noption now = system.time\n\n// Booleans\nbuiltin true : bool\nbuiltin false : bool\n\n// Transformation functions\nbuiltin chandeMomentumOscillator : (<-tables: [A], n: int, ?columns: [string]) => [B] where A: Record, B: Record\nbuiltin columns : (<-tables: [A], ?column: string) => [B] where A: Record, B: Record\nbuiltin count : (<-tables: [A], ?column: string) => [B] where A: Record, B: Record\nbuiltin covariance : (<-tables: [A], ?pearsonr: bool, ?valueDst: string, columns: [string]) => [B] where A: Record, B: Record\nbuiltin cumulativeSum : (<-tables: [A], ?columns: [string]) => [B] where A: Record, B: Record\nbuiltin derivative : (\n    <-tables: [A],\n    ?unit: duration,\n    ?nonNegative: bool,\n    ?columns: [string],\n    ?timeColumn: string,\n) => [B] where\n    A: Record,\n    B: Record\nbuiltin die : (msg: string) => A\nbuiltin difference : (<-tables: [T], ?nonNegative: bool, ?columns: [string], ?keepFirst: bool) => [R] where T: Record, R: Record\nbuiltin distinct : (<-tables: [A], ?column: string) => [B] where A: Record, B: Record\nbuiltin drop : (<-tables: [A], ?fn: (column: string) => bool, ?columns: [string]) => [B] where A: Record, B: Record\nbuiltin duplicate : (<-tables: [A], column: string, as: string) => [B] where A: Record, B: Record\nbuiltin elapsed : (<-tables: [A], ?unit: duration, ?timeColumn: string, ?columnName: string) => [B] where A: Record, B: Record\nbuiltin exponentialMovingAverage : (<-tables: [{B with _value: A}], n: int) => [{B with _value: A}] where A: Numeric\nbuiltin fill : (<-tables: [A], ?column: string, ?value: B, ?usePrevious: bool) => [C] where A: Record, C: Record\nbuiltin filter : (<-tables: [A], fn: (r: A) => bool, ?onEmpty: string) => [A] where A: Record\nbuiltin first : (<-tables: [A], ?column: string) => [A] where A: Record\nbuiltin group : (<-tables: [A], ?mode: string, ?columns: [string]) => [A] where A: Record\nbuiltin histogram : (\n    <-tables: [A],\n    ?column: string,\n    ?upperBoundColumn: string,\n    ?countColumn: string,\n    bins: [float],\n    ?normalize: bool,\n) => [B] where\n    A: Record,\n    B: Record\nbuiltin histogramQuantile : (\n    <-tables: [A],\n    ?quantile: float,\n    ?countColumn: string,\n    ?upperBoundColumn: string,\n    ?valueColumn: string,\n    ?minValue: float,\n) => [B] where\n    A: Record,\n    B: Record\nbuiltin holtWinters : (\n    <-tables: [A],\n    n: int,\n    interval: duration,\n    ?withFit: bool,\n    ?column: string,\n    ?timeColumn: string,\n    ?seasonality: int,\n) => [B] where\n    A: Record,\n    B: Record\nbuiltin hourSelection : (<-tables: [A], start: int, stop: int, ?timeColumn: string) => [A] where A: Record\nbuiltin integral : (\n    <-tables: [A],\n    ?unit: duration,\n    ?timeColumn: string,\n    ?column: string,\n    ?interpolate: string,\n) => [B] where\n    A: Record,\n    B: Record\nbuiltin join : (<-tables: A, ?method: string, ?on: [string]) => [B] where A: Record, B: Record\nbuiltin kaufmansAMA : (<-tables: [A], n: int, ?column: string) => [B] where A: Record, B: Record\nbuiltin keep : (<-tables: [A], ?columns: [string], ?fn: (column: string) => bool) => [B] where A: Record, B: Record\nbuiltin keyValues : (<-tables: [A], ?keyColumns: [string]) => [{C with _key: string, _value: B}] where A: Record, C: Record\nbuiltin keys : (<-tables: [A], ?column: string) => [B] where A: Record, B: Record\nbuiltin last : (<-tables: [A], ?column: string) => [A] where A: Record\nbuiltin limit : (<-tables: [A], n: int, ?offset: int) => [A]\nbuiltin map : (<-tables: [A], fn: (r: A) => B, ?mergeKey: bool) => [B]\nbuiltin max : (<-tables: [A], ?column: string) => [A] where A: Record\nbuiltin mean : (<-tables: [A], ?column: string) => [B] where A: Record, B: Record\nbuiltin min : (<-tables: [A], ?column: string) => [A] where A: Record\nbuiltin mode : (<-tables: [A], ?column: string) => [{C with _value: B}] where A: Record, C: Record\nbuiltin movingAverage : (<-tables: [{B with _value: A}], n: int) => [{B with _value: float}] where A: Numeric\nbuiltin quantile : (\n    <-tables: [A],\n    ?column: string,\n    q: float,\n    ?compression: float,\n    ?method: string,\n) => [A] where\n    A: Record\nbuiltin pivot : (<-tables: [A], rowKey: [string], columnKey: [string], valueColumn: string) => [B] where A: Record, B: Record\nbuiltin range : (\n    <-tables: [{A with _time: time}],\n    start: B,\n    ?stop: C,\n) => [{A with\n    _time: time,\n    _start: time,\n    _stop: time,\n}]\nbuiltin reduce : (<-tables: [A], fn: (r: A, accumulator: B) => B, identity: B) => [C] where A: Record, B: Record, C: Record\nbuiltin relativeStrengthIndex : (<-tables: [A], n: int, ?columns: [string]) => [B] where A: Record, B: Record\nbuiltin rename : (<-tables: [A], ?fn: (column: string) => string, ?columns: B) => [C] where A: Record, B: Record, C: Record\nbuiltin sample : (<-tables: [A], n: int, ?pos: int, ?column: string) => [A] where A: Record\nbuiltin set : (<-tables: [A], key: string, value: string) => [A] where A: Record\nbuiltin tail : (<-tables: [A], n: int, ?offset: int) => [A]\nbuiltin timeShift : (<-tables: [A], duration: duration, ?columns: [string]) => [A]\nbuiltin skew : (<-tables: [A], ?column: string) => [B] where A: Record, B: Record\nbuiltin spread : (<-tables: [A], ?column: string) => [B] where A: Record, B: Record\nbuiltin sort : (<-tables: [A], ?columns: [string], ?desc: bool) => [A] where A: Record\nbuiltin stateTracking : (\n    <-tables: [A],\n    fn: (r: A) => bool,\n    ?countColumn: string,\n    ?durationColumn: string,\n    ?durationUnit: duration,\n    ?timeColumn: string,\n) => [B] where\n    A: Record,\n    B: Record\nbuiltin stddev : (<-tables: [A], ?column: string, ?mode: string) => [B] where A: Record, B: Record\nbuiltin sum : (<-tables: [A], ?column: string) => [B] where A: Record, B: Record\nbuiltin tripleExponentialDerivative : (<-tables: [{B with _value: A}], n: int) => [{B with _value: float}] where A: Numeric, B: Record\nbuiltin union : (tables: [[A]]) => [A] where A: Record\nbuiltin unique : (<-tables: [A], ?column: string) => [A] where A: Record\nbuiltin window : (\n    <-tables: [A],\n    ?every: duration,\n    ?period: duration,\n    ?offset: duration,\n    ?timeColumn: string,\n    ?startColumn: string,\n    ?stopColumn: string,\n    ?createEmpty: bool,\n) => [B] where\n    A: Record,\n    B: Record\nbuiltin yield : (<-tables: [A], ?name: string) => [A] where A: Record\n\n// stream/table index functions\nbuiltin tableFind : (<-tables: [A], fn: (key: B) => bool) => [A] where A: Record, B: Record\nbuiltin getColumn : (<-table: [A], column: string) => [B] where A: Record\nbuiltin getRecord : (<-table: [A], idx: int) => A where A: Record\nbuiltin findColumn : (<-tables: [A], fn: (key: B) => bool, column: string) => [C] where A: Record, B: Record\nbuiltin findRecord : (<-tables: [A], fn: (key: B) => bool, idx: int) => A where A: Record, B: Record\n\n// type conversion functions\nbuiltin bool : (v: A) => bool\nbuiltin bytes : (v: A) => bytes\nbuiltin duration : (v: A) => duration\nbuiltin float : (v: A) => float\nbuiltin int : (v: A) => int\nbuiltin string : (v: A) => string\nbuiltin time : (v: A) => time\nbuiltin uint : (v: A) => uint\n\n// contains function\nbuiltin contains : (value: A, set: [A]) => bool where A: Nullable\n\n// other builtins\nbuiltin inf : duration\nbuiltin length : (arr: [A]) => int\nbuiltin linearBins : (start: float, width: float, count: int, ?infinity: bool) => [float]\nbuiltin logarithmicBins : (start: float, factor: float, count: int, ?infinity: bool) => [float]\n\n// sleep is the identity function with the side effect of delaying execution by a specified duration\nbuiltin sleep : (<-v: A, duration: duration) => A\n\n// die returns a fatal error from within a flux script\nbuiltin die : (msg: string) => A\n\n// Time weighted average where values at the beginning and end of the range are linearly interpolated.\ntimeWeightedAvg = (tables=<-, unit) => tables\n    |> integral(unit: unit, interpolate: \"linear\")\n    |> map(fn: (r) => ({r with _value: r._value * float(v: uint(v: unit)) / float(v: int(v: r._stop) - int(v: r._start))}))\n\n// covariance function with automatic join\ncov = (x, y, on, pearsonr=false) => join(\n    tables: {x: x, y: y},\n    on: on,\n)\n    |> covariance(pearsonr: pearsonr, columns: [\"_value_x\", \"_value_y\"])\npearsonr = (x, y, on) => cov(x: x, y: y, on: on, pearsonr: true)\n\n// AggregateWindow applies an aggregate function to fixed windows of time.\n// The procedure is to window the data, perform an aggregate operation,\n// and then undo the windowing to produce an output table for every input table.\naggregateWindow = (every, fn, offset=0s, column=\"_value\", timeSrc=\"_stop\", timeDst=\"_time\", createEmpty=true, tables=<-) => tables\n    |> window(every: every, offset: offset, createEmpty: createEmpty)\n    |> fn(column: column)\n    |> duplicate(column: timeSrc, as: timeDst)\n    |> window(every: inf, timeColumn: timeDst)\n\n// Increase returns the total non-negative difference between values in a table.\n// A main usage case is tracking changes in counter values which may wrap over time when they hit\n// a threshold or are reset. In the case of a wrap/reset,\n// we can assume that the absolute delta between two points will be at least their non-negative difference.\nincrease = (tables=<-, columns=[\"_value\"]) => tables\n    |> difference(nonNegative: true, columns: columns)\n    |> cumulativeSum(columns: columns)\n\n// median returns the 50th percentile.\nmedian = (method=\"estimate_tdigest\", compression=0.0, column=\"_value\", tables=<-) => tables\n    |> quantile(q: 0.5, method: method, compression: compression, column: column)\n\n// stateCount computes the number of consecutive records in a given state.\n// The state is defined via the function fn. For each consecutive point for\n// which the expression evaluates as true, the state count will be incremented\n// When a point evaluates as false, the state count is reset.\n//\n// The state count will be added as an additional column to each record. If the\n// expression evaluates as false, the value will be -1. If the expression\n// generates an error during evaluation, the point is discarded, and does not\n// affect the state count.\nstateCount = (fn, column=\"stateCount\", tables=<-) => tables\n    |> stateTracking(countColumn: column, fn: fn)\n\n// stateDuration computes the duration of a given state.\n// The state is defined via the function fn. For each consecutive point for\n// which the expression evaluates as true, the state duration will be\n// incremented by the duration between points. When a point evaluates as false,\n// the state duration is reset.\n//\n// The state duration will be added as an additional column to each record. If the\n// expression evaluates as false, the value will be -1. If the expression\n// generates an error during evaluation, the point is discarded, and does not\n// affect the state duration.\n//\n// Note that as the first point in the given state has no previous point, its\n// state duration will be 0.\n//\n// The duration is represented as an integer in the units specified.\nstateDuration = (fn, column=\"stateDuration\", timeColumn=\"_time\", unit=1s, tables=<-) => tables\n    |> stateTracking(durationColumn: column, timeColumn: timeColumn, fn: fn, durationUnit: unit)\n\n// _sortLimit is a helper function, which sorts and limits a table.\n_sortLimit = (n, desc, columns=[\"_value\"], tables=<-) => tables\n    |> sort(columns: columns, desc: desc)\n    |> limit(n: n)\n\n// top sorts a table by columns and keeps only the top n records.\ntop = (n, columns=[\"_value\"], tables=<-) => tables\n    |> _sortLimit(n: n, columns: columns, desc: true)\n\n// top sorts a table by columns and keeps only the bottom n records.\nbottom = (n, columns=[\"_value\"], tables=<-) => tables\n    |> _sortLimit(n: n, columns: columns, desc: false)\n\n// _highestOrLowest is a helper function, which reduces all groups into a single group by specific tags and a reducer function,\n// then it selects the highest or lowest records based on the column and the _sortLimit function.\n// The default reducer assumes no reducing needs to be performed.\n_highestOrLowest = (n, _sortLimit, reducer, column=\"_value\", groupColumns=[], tables=<-) => tables\n    |> group(columns: groupColumns)\n    |> reducer()\n    |> group(columns: [])\n    |> _sortLimit(n: n, columns: [column])\n\n// highestMax returns the top N records from all groups using the maximum of each group.\nhighestMax = (n, column=\"_value\", groupColumns=[], tables=<-) => tables\n    |> _highestOrLowest(\n        n: n,\n        column: column,\n        groupColumns: groupColumns,\n        // TODO(nathanielc): Once max/min support selecting based on multiple columns change this to pass all columns.\n        reducer: (tables=<-) => tables |> max(column: column),\n        _sortLimit: top,\n    )\n\n// highestAverage returns the top N records from all groups using the average of each group.\nhighestAverage = (n, column=\"_value\", groupColumns=[], tables=<-) => tables\n    |> _highestOrLowest(\n        n: n,\n        column: column,\n        groupColumns: groupColumns,\n        reducer: (tables=<-) => tables |> mean(column: column),\n        _sortLimit: top,\n    )\n\n// highestCurrent returns the top N records from all groups using the last value of each group.\nhighestCurrent = (n, column=\"_value\", groupColumns=[], tables=<-) => tables\n    |> _highestOrLowest(\n        n: n,\n        column: column,\n        groupColumns: groupColumns,\n        reducer: (tables=<-) => tables |> last(column: column),\n        _sortLimit: top,\n    )\n\n// lowestMin returns the bottom N records from all groups using the minimum of each group.\nlowestMin = (n, column=\"_value\", groupColumns=[], tables=<-) => tables\n    |> _highestOrLowest(\n        n: n,\n        column: column,\n        groupColumns: groupColumns,\n        // TODO(nathanielc): Once max/min support selecting based on multiple columns change this to pass all columns.\n        reducer: (tables=<-) => tables |> min(column: column),\n        _sortLimit: bottom,\n    )\n\n// lowestAverage returns the bottom N records from all groups using the average of each group.\nlowestAverage = (n, column=\"_value\", groupColumns=[], tables=<-) => tables\n    |> _highestOrLowest(\n        n: n,\n        column: column,\n        groupColumns: groupColumns,\n        reducer: (tables=<-) => tables |> mean(column: column),\n        _sortLimit: bottom,\n    )\n\n// lowestCurrent returns the bottom N records from all groups using the last value of each group.\nlowestCurrent = (n, column=\"_value\", groupColumns=[], tables=<-) => tables\n    |> _highestOrLowest(\n        n: n,\n        column: column,\n        groupColumns: groupColumns,\n        reducer: (tables=<-) => tables |> last(column: column),\n        _sortLimit: bottom,\n    )\n\n// timedMovingAverage constructs a simple moving average over windows of 'period' duration\n// eg: A 5 year moving average would be called as such:\n//    movingAverage(1y, 5y)\ntimedMovingAverage = (every, period, column=\"_value\", tables=<-) => tables\n    |> window(every: every, period: period)\n    |> mean(column: column)\n    |> duplicate(column: \"_stop\", as: \"_time\")\n    |> window(every: inf)\n\n// Double Exponential Moving Average computes the double exponential moving averages of the `_value` column.\n// eg: A 5 point double exponential moving average would be called as such:\n// from(bucket: \"telegraf/autogen\"):\n//    |> range(start: -7d)\n//    |> doubleEMA(n: 5)\ndoubleEMA = (n, tables=<-) => tables\n    |> exponentialMovingAverage(n: n)\n    |> duplicate(column: \"_value\", as: \"__ema\")\n    |> exponentialMovingAverage(n: n)\n    |> map(fn: (r) => ({r with _value: 2.0 * r.__ema - r._value}))\n    |> drop(columns: [\"__ema\"])\n\n// Triple Exponential Moving Average computes the triple exponential moving averages of the `_value` column.\n// eg: A 5 point triple exponential moving average would be called as such:\n// from(bucket: \"telegraf/autogen\"):\n//    |> range(start: -7d)\n//    |> tripleEMA(n: 5)\ntripleEMA = (n, tables=<-) => tables\n    |> exponentialMovingAverage(n: n)\n    |> duplicate(column: \"_value\", as: \"__ema1\")\n    |> exponentialMovingAverage(n: n)\n    |> duplicate(column: \"_value\", as: \"__ema2\")\n    |> exponentialMovingAverage(n: n)\n    |> map(fn: (r) => ({r with _value: 3.0 * r.__ema1 - 3.0 * r.__ema2 + r._value}))\n    |> drop(columns: [\"__ema1\", \"__ema2\"])\n\n// truncateTimeColumn takes in a time column t and a Duration unit and truncates each value of t to the given unit via map\n// Change from _time to timeColumn once Flux Issue 1122 is resolved\ntruncateTimeColumn = (timeColumn=\"_time\", unit, tables=<-) => tables\n    |> map(fn: (r) => ({r with _time: date.truncate(t: r._time, unit: unit)}))\n\n// kaufmansER computes Kaufman's Efficiency Ratios of the `_value` column\nkaufmansER = (n, tables=<-) => tables\n    |> chandeMomentumOscillator(n: n)\n    |> map(fn: (r) => ({r with _value: math.abs(x: r._value) / 100.0}))\ntoString = (tables=<-) => tables |> map(fn: (r) => ({r with _value: string(v: r._value)}))\ntoInt = (tables=<-) => tables |> map(fn: (r) => ({r with _value: int(v: r._value)}))\ntoUInt = (tables=<-) => tables |> map(fn: (r) => ({r with _value: uint(v: r._value)}))\ntoFloat = (tables=<-) => tables |> map(fn: (r) => ({r with _value: float(v: r._value)}))\ntoBool = (tables=<-) => tables |> map(fn: (r) => ({r with _value: bool(v: r._value)}))\ntoTime = (tables=<-) => tables |> map(fn: (r) => ({r with _value: time(v: r._value)}))",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 25,
							Line:   11,
						},
						File:   "universe.flux",
						Source: "now = system.time",
						Start: ast.Position{
							Column: 8,
							Line:   11,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   11,
							},
							File:   "universe.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   11,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.MemberExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 25,
								Line:   11,
							},
							File:   "universe.flux",
							Source: "system.time",
							Start: ast.Position{
								Column: 14,
								Line:   11,
							},
						},
					},
					Lbrack: nil,
					Object: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   11,
								},
								File:   "universe.flux",
								Source: "system",
								Start: ast.Position{
									Column: 14,
									Line:   11,
								},
							},
						},
						Name: "system",
					},
					Property: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   11,
								},
								File:   "universe.flux",
								Source: "time",
								Start: ast.Position{
									Column: 21,
									Line:   11,
								},
							},
						},
						Name: "time",
					},
					Rbrack: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// now is a function option whose default behaviour is to return the current system time\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 25,
						Line:   11,
					},
					File:   "universe.flux",
					Source: "option now = system.time",
					Start: ast.Position{
						Column: 1,
						Line:   11,
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// Booleans\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   14,
					},
					File:   "universe.flux",
					Source: "builtin true",
					Start: ast.Position{
						Column: 1,
						Line:   14,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   14,
						},
						File:   "universe.flux",
						Source: "true",
						Start: ast.Position{
							Column: 9,
							Line:   14,
						},
					},
				},
				Name: "true",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 20,
							Line:   14,
						},
						File:   "universe.flux",
						Source: "bool",
						Start: ast.Position{
							Column: 16,
							Line:   14,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.NamedType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 20,
								Line:   14,
							},
							File:   "universe.flux",
							Source: "bool",
							Start: ast.Position{
								Column: 16,
								Line:   14,
							},
						},
					},
					ID: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   14,
								},
								File:   "universe.flux",
								Source: "bool",
								Start: ast.Position{
									Column: 16,
									Line:   14,
								},
							},
						},
						Name: "bool",
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   15,
					},
					File:   "universe.flux",
					Source: "builtin false",
					Start: ast.Position{
						Column: 1,
						Line:   15,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   15,
						},
						File:   "universe.flux",
						Source: "false",
						Start: ast.Position{
							Column: 9,
							Line:   15,
						},
					},
				},
				Name: "false",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 21,
							Line:   15,
						},
						File:   "universe.flux",
						Source: "bool",
						Start: ast.Position{
							Column: 17,
							Line:   15,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.NamedType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 21,
								Line:   15,
							},
							File:   "universe.flux",
							Source: "bool",
							Start: ast.Position{
								Column: 17,
								Line:   15,
							},
						},
					},
					ID: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   15,
								},
								File:   "universe.flux",
								Source: "bool",
								Start: ast.Position{
									Column: 17,
									Line:   15,
								},
							},
						},
						Name: "bool",
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// Transformation functions\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 33,
						Line:   18,
					},
					File:   "universe.flux",
					Source: "builtin chandeMomentumOscillator",
					Start: ast.Position{
						Column: 1,
						Line:   18,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 33,
							Line:   18,
						},
						File:   "universe.flux",
						Source: "chandeMomentumOscillator",
						Start: ast.Position{
							Column: 9,
							Line:   18,
						},
					},
				},
				Name: "chandeMomentumOscillator",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 113,
							Line:   18,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], n: int, ?columns: [string]) => [B] where A: Record, B: Record",
						Start: ast.Position{
							Column: 36,
							Line:   18,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 102,
								Line:   18,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 93,
								Line:   18,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 102,
									Line:   18,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 96,
									Line:   18,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 94,
									Line:   18,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 93,
									Line:   18,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 113,
								Line:   18,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 104,
								Line:   18,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 113,
									Line:   18,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 107,
									Line:   18,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 105,
									Line:   18,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 104,
									Line:   18,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 86,
								Line:   18,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], n: int, ?columns: [string]) => [B]",
							Start: ast.Position{
								Column: 36,
								Line:   18,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 50,
									Line:   18,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 37,
									Line:   18,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 45,
										Line:   18,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 39,
										Line:   18,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 50,
										Line:   18,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 47,
										Line:   18,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 49,
											Line:   18,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 48,
											Line:   18,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   18,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 48,
												Line:   18,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 58,
									Line:   18,
								},
								File:   "universe.flux",
								Source: "n: int",
								Start: ast.Position{
									Column: 52,
									Line:   18,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 53,
										Line:   18,
									},
									File:   "universe.flux",
									Source: "n",
									Start: ast.Position{
										Column: 52,
										Line:   18,
									},
								},
							},
							Name: "n",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 58,
										Line:   18,
									},
									File:   "universe.flux",
									Source: "int",
									Start: ast.Position{
										Column: 55,
										Line:   18,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 58,
											Line:   18,
										},
										File:   "universe.flux",
										Source: "int",
										Start: ast.Position{
											Column: 55,
											Line:   18,
										},
									},
								},
								Name: "int",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 78,
									Line:   18,
								},
								File:   "universe.flux",
								Source: "?columns: [string]",
								Start: ast.Position{
									Column: 60,
									Line:   18,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 68,
										Line:   18,
									},
									File:   "universe.flux",
									Source: "columns",
									Start: ast.Position{
										Column: 61,
										Line:   18,
									},
								},
							},
							Name: "columns",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 78,
										Line:   18,
									},
									File:   "universe.flux",
									Source: "[string]",
									Start: ast.Position{
										Column: 70,
										Line:   18,
									},
								},
							},
							ElementType: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 77,
											Line:   18,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 71,
											Line:   18,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 77,
												Line:   18,
											},
											File:   "universe.flux",
											Source: "string",
											Start: ast.Position{
												Column: 71,
												Line:   18,
											},
										},
									},
									Name: "string",
								},
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 86,
									Line:   18,
								},
								File:   "universe.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 83,
									Line:   18,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 85,
										Line:   18,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 84,
										Line:   18,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 85,
											Line:   18,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 84,
											Line:   18,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 16,
						Line:   19,
					},
					File:   "universe.flux",
					Source: "builtin columns",
					Start: ast.Position{
						Column: 1,
						Line:   19,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 16,
							Line:   19,
						},
						File:   "universe.flux",
						Source: "columns",
						Start: ast.Position{
							Column: 9,
							Line:   19,
						},
					},
				},
				Name: "columns",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 85,
							Line:   19,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], ?column: string) => [B] where A: Record, B: Record",
						Start: ast.Position{
							Column: 19,
							Line:   19,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 74,
								Line:   19,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 65,
								Line:   19,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 74,
									Line:   19,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 68,
									Line:   19,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 66,
									Line:   19,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 65,
									Line:   19,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 85,
								Line:   19,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 76,
								Line:   19,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 85,
									Line:   19,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 79,
									Line:   19,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 77,
									Line:   19,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 76,
									Line:   19,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 58,
								Line:   19,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], ?column: string) => [B]",
							Start: ast.Position{
								Column: 19,
								Line:   19,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 33,
									Line:   19,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 20,
									Line:   19,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 28,
										Line:   19,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 22,
										Line:   19,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 33,
										Line:   19,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 30,
										Line:   19,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 32,
											Line:   19,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 31,
											Line:   19,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 32,
												Line:   19,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 31,
												Line:   19,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 50,
									Line:   19,
								},
								File:   "universe.flux",
								Source: "?column: string",
								Start: ast.Position{
									Column: 35,
									Line:   19,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   19,
									},
									File:   "universe.flux",
									Source: "column",
									Start: ast.Position{
										Column: 36,
										Line:   19,
									},
								},
							},
							Name: "column",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 50,
										Line:   19,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 44,
										Line:   19,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 50,
											Line:   19,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 44,
											Line:   19,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 58,
									Line:   19,
								},
								File:   "universe.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 55,
									Line:   19,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 57,
										Line:   19,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 56,
										Line:   19,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 57,
											Line:   19,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 56,
											Line:   19,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   20,
					},
					File:   "universe.flux",
					Source: "builtin count",
					Start: ast.Position{
						Column: 1,
						Line:   20,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   20,
						},
						File:   "universe.flux",
						Source: "count",
						Start: ast.Position{
							Column: 9,
							Line:   20,
						},
					},
				},
				Name: "count",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 83,
							Line:   20,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], ?column: string) => [B] where A: Record, B: Record",
						Start: ast.Position{
							Column: 17,
							Line:   20,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 72,
								Line:   20,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 63,
								Line:   20,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 72,
									Line:   20,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 66,
									Line:   20,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 64,
									Line:   20,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 63,
									Line:   20,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 83,
								Line:   20,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 74,
								Line:   20,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 83,
									Line:   20,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 77,
									Line:   20,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 75,
									Line:   20,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 74,
									Line:   20,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 56,
								Line:   20,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], ?column: string) => [B]",
							Start: ast.Position{
								Column: 17,
								Line:   20,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 31,
									Line:   20,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 18,
									Line:   20,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 26,
										Line:   20,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 20,
										Line:   20,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   20,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 28,
										Line:   20,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   20,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 29,
											Line:   20,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 30,
												Line:   20,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 29,
												Line:   20,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 48,
									Line:   20,
								},
								File:   "universe.flux",
								Source: "?column: string",
								Start: ast.Position{
									Column: 33,
									Line:   20,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   20,
									},
									File:   "universe.flux",
									Source: "column",
									Start: ast.Position{
										Column: 34,
										Line:   20,
									},
								},
							},
							Name: "column",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 48,
										Line:   20,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 42,
										Line:   20,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 48,
											Line:   20,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 42,
											Line:   20,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 56,
									Line:   20,
								},
								File:   "universe.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 53,
									Line:   20,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 55,
										Line:   20,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 54,
										Line:   20,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 55,
											Line:   20,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 54,
											Line:   20,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 19,
						Line:   21,
					},
					File:   "universe.flux",
					Source: "builtin covariance",
					Start: ast.Position{
						Column: 1,
						Line:   21,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 19,
							Line:   21,
						},
						File:   "universe.flux",
						Source: "covariance",
						Start: ast.Position{
							Column: 9,
							Line:   21,
						},
					},
				},
				Name: "covariance",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 126,
							Line:   21,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], ?pearsonr: bool, ?valueDst: string, columns: [string]) => [B] where A: Record, B: Record",
						Start: ast.Position{
							Column: 22,
							Line:   21,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 115,
								Line:   21,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 106,
								Line:   21,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 115,
									Line:   21,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 109,
									Line:   21,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 107,
									Line:   21,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 106,
									Line:   21,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 126,
								Line:   21,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 117,
								Line:   21,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 126,
									Line:   21,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 120,
									Line:   21,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 118,
									Line:   21,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 117,
									Line:   21,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 99,
								Line:   21,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], ?pearsonr: bool, ?valueDst: string, columns: [string]) => [B]",
							Start: ast.Position{
								Column: 22,
								Line:   21,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 36,
									Line:   21,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 23,
									Line:   21,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   21,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 25,
										Line:   21,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 36,
										Line:   21,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 33,
										Line:   21,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 35,
											Line:   21,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 34,
											Line:   21,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 35,
												Line:   21,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 34,
												Line:   21,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 53,
									Line:   21,
								},
								File:   "universe.flux",
								Source: "?pearsonr: bool",
								Start: ast.Position{
									Column: 38,
									Line:   21,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 47,
										Line:   21,
									},
									File:   "universe.flux",
									Source: "pearsonr",
									Start: ast.Position{
										Column: 39,
										Line:   21,
									},
								},
							},
							Name: "pearsonr",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 53,
										Line:   21,
									},
									File:   "universe.flux",
									Source: "bool",
									Start: ast.Position{
										Column: 49,
										Line:   21,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 53,
											Line:   21,
										},
										File:   "universe.flux",
										Source: "bool",
										Start: ast.Position{
											Column: 49,
											Line:   21,
										},
									},
								},
								Name: "bool",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 72,
									Line:   21,
								},
								File:   "universe.flux",
								Source: "?valueDst: string",
								Start: ast.Position{
									Column: 55,
									Line:   21,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 64,
										Line:   21,
									},
									File:   "universe.flux",
									Source: "valueDst",
									Start: ast.Position{
										Column: 56,
										Line:   21,
									},
								},
							},
							Name: "valueDst",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 72,
										Line:   21,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 66,
										Line:   21,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 72,
											Line:   21,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 66,
											Line:   21,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 91,
									Line:   21,
								},
								File:   "universe.flux",
								Source: "columns: [string]",
								Start: ast.Position{
									Column: 74,
									Line:   21,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 81,
										Line:   21,
									},
									File:   "universe.flux",
									Source: "columns",
									Start: ast.Position{
										Column: 74,
										Line:   21,
									},
								},
							},
							Name: "columns",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 91,
										Line:   21,
									},
									File:   "universe.flux",
									Source: "[string]",
									Start: ast.Position{
										Column: 83,
										Line:   21,
									},
								},
							},
							ElementType: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 90,
											Line:   21,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 84,
											Line:   21,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 90,
												Line:   21,
											},
											File:   "universe.flux",
											Source: "string",
											Start: ast.Position{
												Column: 84,
												Line:   21,
											},
										},
									},
									Name: "string",
								},
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 99,
									Line:   21,
								},
								File:   "universe.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 96,
									Line:   21,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 98,
										Line:   21,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 97,
										Line:   21,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 98,
											Line:   21,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 97,
											Line:   21,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 22,
						Line:   22,
					},
					File:   "universe.flux",
					Source: "builtin cumulativeSum",
					Start: ast.Position{
						Column: 1,
						Line:   22,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 22,
							Line:   22,
						},
						File:   "universe.flux",
						Source: "cumulativeSum",
						Start: ast.Position{
							Column: 9,
							Line:   22,
						},
					},
				},
				Name: "cumulativeSum",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 94,
							Line:   22,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], ?columns: [string]) => [B] where A: Record, B: Record",
						Start: ast.Position{
							Column: 25,
							Line:   22,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 83,
								Line:   22,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 74,
								Line:   22,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 83,
									Line:   22,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 77,
									Line:   22,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 75,
									Line:   22,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 74,
									Line:   22,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 94,
								Line:   22,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 85,
								Line:   22,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 94,
									Line:   22,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 88,
									Line:   22,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 86,
									Line:   22,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 85,
									Line:   22,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 67,
								Line:   22,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], ?columns: [string]) => [B]",
							Start: ast.Position{
								Column: 25,
								Line:   22,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 39,
									Line:   22,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 26,
									Line:   22,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 34,
										Line:   22,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 28,
										Line:   22,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 39,
										Line:   22,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 36,
										Line:   22,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 38,
											Line:   22,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 37,
											Line:   22,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 38,
												Line:   22,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 37,
												Line:   22,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 59,
									Line:   22,
								},
								File:   "universe.flux",
								Source: "?columns: [string]",
								Start: ast.Position{
									Column: 41,
									Line:   22,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 49,
										Line:   22,
									},
									File:   "universe.flux",
									Source: "columns",
									Start: ast.Position{
										Column: 42,
										Line:   22,
									},
								},
							},
							Name: "columns",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 59,
										Line:   22,
									},
									File:   "universe.flux",
									Source: "[string]",
									Start: ast.Position{
										Column: 51,
										Line:   22,
									},
								},
							},
							ElementType: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 58,
											Line:   22,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 52,
											Line:   22,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 58,
												Line:   22,
											},
											File:   "universe.flux",
											Source: "string",
											Start: ast.Position{
												Column: 52,
												Line:   22,
											},
										},
									},
									Name: "string",
								},
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 67,
									Line:   22,
								},
								File:   "universe.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 64,
									Line:   22,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 66,
										Line:   22,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 65,
										Line:   22,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 66,
											Line:   22,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 65,
											Line:   22,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 19,
						Line:   23,
					},
					File:   "universe.flux",
					Source: "builtin derivative",
					Start: ast.Position{
						Column: 1,
						Line:   23,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 19,
							Line:   23,
						},
						File:   "universe.flux",
						Source: "derivative",
						Start: ast.Position{
							Column: 9,
							Line:   23,
						},
					},
				},
				Name: "derivative",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   31,
						},
						File:   "universe.flux",
						Source: "(\n    <-tables: [A],\n    ?unit: duration,\n    ?nonNegative: bool,\n    ?columns: [string],\n    ?timeColumn: string,\n) => [B] where\n    A: Record,\n    B: Record",
						Start: ast.Position{
							Column: 22,
							Line:   23,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   30,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 5,
								Line:   30,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   30,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 8,
									Line:   30,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   30,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 5,
									Line:   30,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   31,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 5,
								Line:   31,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   31,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 8,
									Line:   31,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   31,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 5,
									Line:   31,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 9,
								Line:   29,
							},
							File:   "universe.flux",
							Source: "(\n    <-tables: [A],\n    ?unit: duration,\n    ?nonNegative: bool,\n    ?columns: [string],\n    ?timeColumn: string,\n) => [B]",
							Start: ast.Position{
								Column: 22,
								Line:   23,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 18,
									Line:   24,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 5,
									Line:   24,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   24,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 7,
										Line:   24,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   24,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 15,
										Line:   24,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 17,
											Line:   24,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 16,
											Line:   24,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   24,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 16,
												Line:   24,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   25,
								},
								File:   "universe.flux",
								Source: "?unit: duration",
								Start: ast.Position{
									Column: 5,
									Line:   25,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 10,
										Line:   25,
									},
									File:   "universe.flux",
									Source: "unit",
									Start: ast.Position{
										Column: 6,
										Line:   25,
									},
								},
							},
							Name: "unit",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 20,
										Line:   25,
									},
									File:   "universe.flux",
									Source: "duration",
									Start: ast.Position{
										Column: 12,
										Line:   25,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 20,
											Line:   25,
										},
										File:   "universe.flux",
										Source: "duration",
										Start: ast.Position{
											Column: 12,
											Line:   25,
										},
									},
								},
								Name: "duration",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 23,
									Line:   26,
								},
								File:   "universe.flux",
								Source: "?nonNegative: bool",
								Start: ast.Position{
									Column: 5,
									Line:   26,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 17,
										Line:   26,
									},
									File:   "universe.flux",
									Source: "nonNegative",
									Start: ast.Position{
										Column: 6,
										Line:   26,
									},
								},
							},
							Name: "nonNegative",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 23,
										Line:   26,
									},
									File:   "universe.flux",
									Source: "bool",
									Start: ast.Position{
										Column: 19,
										Line:   26,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 23,
											Line:   26,
										},
										File:   "universe.flux",
										Source: "bool",
										Start: ast.Position{
											Column: 19,
											Line:   26,
										},
									},
								},
								Name: "bool",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 23,
									Line:   27,
								},
								File:   "universe.flux",
								Source: "?columns: [string]",
								Start: ast.Position{
									Column: 5,
									Line:   27,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   27,
									},
									File:   "universe.flux",
									Source: "columns",
									Start: ast.Position{
										Column: 6,
										Line:   27,
									},
								},
							},
							Name: "columns",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 23,
										Line:   27,
									},
									File:   "universe.flux",
									Source: "[string]",
									Start: ast.Position{
										Column: 15,
										Line:   27,
									},
								},
							},
							ElementType: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 22,
											Line:   27,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 16,
											Line:   27,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 22,
												Line:   27,
											},
											File:   "universe.flux",
											Source: "string",
											Start: ast.Position{
												Column: 16,
												Line:   27,
											},
										},
									},
									Name: "string",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 24,
									Line:   28,
								},
								File:   "universe.flux",
								Source: "?timeColumn: string",
								Start: ast.Position{
									Column: 5,
									Line:   28,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 16,
										Line:   28,
									},
									File:   "universe.flux",
									Source: "timeColumn",
									Start: ast.Position{
										Column: 6,
										Line:   28,
									},
								},
							},
							Name: "timeColumn",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 24,
										Line:   28,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 18,
										Line:   28,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 24,
											Line:   28,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 18,
											Line:   28,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 9,
									Line:   29,
								},
								File:   "universe.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 6,
									Line:   29,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 8,
										Line:   29,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 7,
										Line:   29,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 8,
											Line:   29,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 7,
											Line:   29,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 12,
						Line:   32,
					},
					File:   "universe.flux",
					Source: "builtin die",
					Start: ast.Position{
						Column: 1,
						Line:   32,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   32,
						},
						File:   "universe.flux",
						Source: "die",
						Start: ast.Position{
							Column: 9,
							Line:   32,
						},
					},
				},
				Name: "die",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 33,
							Line:   32,
						},
						File:   "universe.flux",
						Source: "(msg: string) => A",
						Start: ast.Position{
							Column: 15,
							Line:   32,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 33,
								Line:   32,
							},
							File:   "universe.flux",
							Source: "(msg: string) => A",
							Start: ast.Position{
								Column: 15,
								Line:   32,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 27,
									Line:   32,
								},
								File:   "universe.flux",
								Source: "msg: string",
								Start: ast.Position{
									Column: 16,
									Line:   32,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 19,
										Line:   32,
									},
									File:   "universe.flux",
									Source: "msg",
									Start: ast.Position{
										Column: 16,
										Line:   32,
									},
								},
							},
							Name: "msg",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 27,
										Line:   32,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 21,
										Line:   32,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 27,
											Line:   32,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 21,
											Line:   32,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.TvarType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 33,
									Line:   32,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 32,
									Line:   32,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 33,
										Line:   32,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 32,
										Line:   32,
									},
								},
							},
							Name: "A",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 19,
						Line:   33,
					},
					File:   "universe.flux",
					Source: "builtin difference",
					Start: ast.Position{
						Column: 1,
						Line:   33,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 19,
							Line:   33,
						},
						File:   "universe.flux",
						Source: "difference",
						Start: ast.Position{
							Column: 9,
							Line:   33,
						},
					},
				},
				Name: "difference",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 129,
							Line:   33,
						},
						File:   "universe.flux",
						Source: "(<-tables: [T], ?nonNegative: bool, ?columns: [string], ?keepFirst: bool) => [R] where T: Record, R: Record",
						Start: ast.Position{
							Column: 22,
							Line:   33,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 118,
								Line:   33,
							},
							File:   "universe.flux",
							Source: "T: Record",
							Start: ast.Position{
								Column: 109,
								Line:   33,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 118,
									Line:   33,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 112,
									Line:   33,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 110,
									Line:   33,
								},
								File:   "universe.flux",
								Source: "T",
								Start: ast.Position{
									Column: 109,
									Line:   33,
								},
							},
						},
						Name: "T",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 129,
								Line:   33,
							},
							File:   "universe.flux",
							Source: "R: Record",
							Start: ast.Position{
								Column: 120,
								Line:   33,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 129,
									Line:   33,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 123,
									Line:   33,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 121,
									Line:   33,
								},
								File:   "universe.flux",
								Source: "R",
								Start: ast.Position{
									Column: 120,
									Line:   33,
								},
							},
						},
						Name: "R",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 102,
								Line:   33,
							},
							File:   "universe.flux",
							Source: "(<-tables: [T], ?nonNegative: bool, ?columns: [string], ?keepFirst: bool) => [R]",
							Start: ast.Position{
								Column: 22,
								Line:   33,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 36,
									Line:   33,
								},
								File:   "universe.flux",
								Source: "<-tables: [T]",
								Start: ast.Position{
									Column: 23,
									Line:   33,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   33,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 25,
										Line:   33,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 36,
										Line:   33,
									},
									File:   "universe.flux",
									Source: "[T]",
									Start: ast.Position{
										Column: 33,
										Line:   33,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 35,
											Line:   33,
										},
										File:   "universe.flux",
										Source: "T",
										Start: ast.Position{
											Column: 34,
											Line:   33,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 35,
												Line:   33,
											},
											File:   "universe.flux",
											Source: "T",
											Start: ast.Position{
												Column: 34,
												Line:   33,
											},
										},
									},
									Name: "T",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 56,
									Line:   33,
								},
								File:   "universe.flux",
								Source: "?nonNegative: bool",
								Start: ast.Position{
									Column: 38,
									Line:   33,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 50,
										Line:   33,
									},
									File:   "universe.flux",
									Source: "nonNegative",
									Start: ast.Position{
										Column: 39,
										Line:   33,
									},
								},
							},
							Name: "nonNegative",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 56,
										Line:   33,
									},
									File:   "universe.flux",
									Source: "bool",
									Start: ast.Position{
										Column: 52,
										Line:   33,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 56,
											Line:   33,
										},
										File:   "universe.flux",
										Source: "bool",
										Start: ast.Position{
											Column: 52,
											Line:   33,
										},
									},
								},
								Name: "bool",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 76,
									Line:   33,
								},
								File:   "universe.flux",
								Source: "?columns: [string]",
								Start: ast.Position{
									Column: 58,
									Line:   33,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 66,
										Line:   33,
									},
									File:   "universe.flux",
									Source: "columns",
									Start: ast.Position{
										Column: 59,
										Line:   33,
									},
								},
							},
							Name: "columns",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 76,
										Line:   33,
									},
									File:   "universe.flux",
									Source: "[string]",
									Start: ast.Position{
										Column: 68,
										Line:   33,
									},
								},
							},
							ElementType: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 75,
											Line:   33,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 69,
											Line:   33,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 75,
												Line:   33,
											},
											File:   "universe.flux",
											Source: "string",
											Start: ast.Position{
												Column: 69,
												Line:   33,
											},
										},
									},
									Name: "string",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 94,
									Line:   33,
								},
								File:   "universe.flux",
								Source: "?keepFirst: bool",
								Start: ast.Position{
									Column: 78,
									Line:   33,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 88,
										Line:   33,
									},
									File:   "universe.flux",
									Source: "keepFirst",
									Start: ast.Position{
										Column: 79,
										Line:   33,
									},
								},
							},
							Name: "keepFirst",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 94,
										Line:   33,
									},
									File:   "universe.flux",
									Source: "bool",
									Start: ast.Position{
										Column: 90,
										Line:   33,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 94,
											Line:   33,
										},
										File:   "universe.flux",
										Source: "bool",
										Start: ast.Position{
											Column: 90,
											Line:   33,
										},
									},
								},
								Name: "bool",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 102,
									Line:   33,
								},
								File:   "universe.flux",
								Source: "[R]",
								Start: ast.Position{
									Column: 99,
									Line:   33,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 101,
										Line:   33,
									},
									File:   "universe.flux",
									Source: "R",
									Start: ast.Position{
										Column: 100,
										Line:   33,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 101,
											Line:   33,
										},
										File:   "universe.flux",
										Source: "R",
										Start: ast.Position{
											Column: 100,
											Line:   33,
										},
									},
								},
								Name: "R",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   34,
					},
					File:   "universe.flux",
					Source: "builtin distinct",
					Start: ast.Position{
						Column: 1,
						Line:   34,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   34,
						},
						File:   "universe.flux",
						Source: "distinct",
						Start: ast.Position{
							Column: 9,
							Line:   34,
						},
					},
				},
				Name: "distinct",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 86,
							Line:   34,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], ?column: string) => [B] where A: Record, B: Record",
						Start: ast.Position{
							Column: 20,
							Line:   34,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 75,
								Line:   34,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 66,
								Line:   34,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 75,
									Line:   34,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 69,
									Line:   34,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 67,
									Line:   34,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 66,
									Line:   34,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 86,
								Line:   34,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 77,
								Line:   34,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 86,
									Line:   34,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 80,
									Line:   34,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 78,
									Line:   34,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 77,
									Line:   34,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 59,
								Line:   34,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], ?column: string) => [B]",
							Start: ast.Position{
								Column: 20,
								Line:   34,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   34,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 21,
									Line:   34,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   34,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 23,
										Line:   34,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 34,
										Line:   34,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 31,
										Line:   34,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 33,
											Line:   34,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 32,
											Line:   34,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 33,
												Line:   34,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 32,
												Line:   34,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 51,
									Line:   34,
								},
								File:   "universe.flux",
								Source: "?column: string",
								Start: ast.Position{
									Column: 36,
									Line:   34,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 43,
										Line:   34,
									},
									File:   "universe.flux",
									Source: "column",
									Start: ast.Position{
										Column: 37,
										Line:   34,
									},
								},
							},
							Name: "column",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 51,
										Line:   34,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 45,
										Line:   34,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 51,
											Line:   34,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 45,
											Line:   34,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 59,
									Line:   34,
								},
								File:   "universe.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 56,
									Line:   34,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 58,
										Line:   34,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 57,
										Line:   34,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 58,
											Line:   34,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 57,
											Line:   34,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   35,
					},
					File:   "universe.flux",
					Source: "builtin drop",
					Start: ast.Position{
						Column: 1,
						Line:   35,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   35,
						},
						File:   "universe.flux",
						Source: "drop",
						Start: ast.Position{
							Column: 9,
							Line:   35,
						},
					},
				},
				Name: "drop",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 116,
							Line:   35,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], ?fn: (column: string) => bool, ?columns: [string]) => [B] where A: Record, B: Record",
						Start: ast.Position{
							Column: 16,
							Line:   35,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 105,
								Line:   35,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 96,
								Line:   35,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 105,
									Line:   35,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 99,
									Line:   35,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 97,
									Line:   35,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 96,
									Line:   35,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 116,
								Line:   35,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 107,
								Line:   35,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 116,
									Line:   35,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 110,
									Line:   35,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 108,
									Line:   35,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 107,
									Line:   35,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 89,
								Line:   35,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], ?fn: (column: string) => bool, ?columns: [string]) => [B]",
							Start: ast.Position{
								Column: 16,
								Line:   35,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   35,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 17,
									Line:   35,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   35,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 19,
										Line:   35,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   35,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 27,
										Line:   35,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   35,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 28,
											Line:   35,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   35,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 28,
												Line:   35,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 61,
									Line:   35,
								},
								File:   "universe.flux",
								Source: "?fn: (column: string) => bool",
								Start: ast.Position{
									Column: 32,
									Line:   35,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 35,
										Line:   35,
									},
									File:   "universe.flux",
									Source: "fn",
									Start: ast.Position{
										Column: 33,
										Line:   35,
									},
								},
							},
							Name: "fn",
						},
						Ty: &ast.FunctionType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 61,
										Line:   35,
									},
									File:   "universe.flux",
									Source: "(column: string) => bool",
									Start: ast.Position{
										Column: 37,
										Line:   35,
									},
								},
							},
							Parameters: []*ast.ParameterType{&ast.ParameterType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 52,
											Line:   35,
										},
										File:   "universe.flux",
										Source: "column: string",
										Start: ast.Position{
											Column: 38,
											Line:   35,
										},
									},
								},
								Kind: "Required",
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 44,
												Line:   35,
											},
											File:   "universe.flux",
											Source: "column",
											Start: ast.Position{
												Column: 38,
												Line:   35,
											},
										},
									},
									Name: "column",
								},
								Ty: &ast.NamedType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 52,
												Line:   35,
											},
											File:   "universe.flux",
											Source: "string",
											Start: ast.Position{
												Column: 46,
												Line:   35,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 52,
													Line:   35,
												},
												File:   "universe.flux",
												Source: "string",
												Start: ast.Position{
													Column: 46,
													Line:   35,
												},
											},
										},
										Name: "string",
									},
								},
							}},
							Return: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 61,
											Line:   35,
										},
										File:   "universe.flux",
										Source: "bool",
										Start: ast.Position{
											Column: 57,
											Line:   35,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 61,
												Line:   35,
											},
											File:   "universe.flux",
											Source: "bool",
											Start: ast.Position{
												Column: 57,
												Line:   35,
											},
										},
									},
									Name: "bool",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 81,
									Line:   35,
								},
								File:   "universe.flux",
								Source: "?columns: [string]",
								Start: ast.Position{
									Column: 63,
									Line:   35,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 71,
										Line:   35,
									},
									File:   "universe.flux",
									Source: "columns",
									Start: ast.Position{
										Column: 64,
										Line:   35,
									},
								},
							},
							Name: "columns",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 81,
										Line:   35,
									},
									File:   "universe.flux",
									Source: "[string]",
									Start: ast.Position{
										Column: 73,
										Line:   35,
									},
								},
							},
							ElementType: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 80,
											Line:   35,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 74,
											Line:   35,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 80,
												Line:   35,
											},
											File:   "universe.flux",
											Source: "string",
											Start: ast.Position{
												Column: 74,
												Line:   35,
											},
										},
									},
									Name: "string",
								},
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 89,
									Line:   35,
								},
								File:   "universe.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 86,
									Line:   35,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 88,
										Line:   35,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 87,
										Line:   35,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 88,
											Line:   35,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 87,
											Line:   35,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   36,
					},
					File:   "universe.flux",
					Source: "builtin duplicate",
					Start: ast.Position{
						Column: 1,
						Line:   36,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   36,
						},
						File:   "universe.flux",
						Source: "duplicate",
						Start: ast.Position{
							Column: 9,
							Line:   36,
						},
					},
				},
				Name: "duplicate",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 98,
							Line:   36,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], column: string, as: string) => [B] where A: Record, B: Record",
						Start: ast.Position{
							Column: 21,
							Line:   36,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 87,
								Line:   36,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 78,
								Line:   36,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 87,
									Line:   36,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 81,
									Line:   36,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 79,
									Line:   36,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 78,
									Line:   36,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 98,
								Line:   36,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 89,
								Line:   36,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 98,
									Line:   36,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 92,
									Line:   36,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 90,
									Line:   36,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 89,
									Line:   36,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 71,
								Line:   36,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], column: string, as: string) => [B]",
							Start: ast.Position{
								Column: 21,
								Line:   36,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 35,
									Line:   36,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 22,
									Line:   36,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   36,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 24,
										Line:   36,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 35,
										Line:   36,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 32,
										Line:   36,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 34,
											Line:   36,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 33,
											Line:   36,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 34,
												Line:   36,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 33,
												Line:   36,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 51,
									Line:   36,
								},
								File:   "universe.flux",
								Source: "column: string",
								Start: ast.Position{
									Column: 37,
									Line:   36,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 43,
										Line:   36,
									},
									File:   "universe.flux",
									Source: "column",
									Start: ast.Position{
										Column: 37,
										Line:   36,
									},
								},
							},
							Name: "column",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 51,
										Line:   36,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 45,
										Line:   36,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 51,
											Line:   36,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 45,
											Line:   36,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 63,
									Line:   36,
								},
								File:   "universe.flux",
								Source: "as: string",
								Start: ast.Position{
									Column: 53,
									Line:   36,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 55,
										Line:   36,
									},
									File:   "universe.flux",
									Source: "as",
									Start: ast.Position{
										Column: 53,
										Line:   36,
									},
								},
							},
							Name: "as",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 63,
										Line:   36,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 57,
										Line:   36,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 63,
											Line:   36,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 57,
											Line:   36,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 71,
									Line:   36,
								},
								File:   "universe.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 68,
									Line:   36,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 70,
										Line:   36,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 69,
										Line:   36,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 70,
											Line:   36,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 69,
											Line:   36,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 16,
						Line:   37,
					},
					File:   "universe.flux",
					Source: "builtin elapsed",
					Start: ast.Position{
						Column: 1,
						Line:   37,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 16,
							Line:   37,
						},
						File:   "universe.flux",
						Source: "elapsed",
						Start: ast.Position{
							Column: 9,
							Line:   37,
						},
					},
				},
				Name: "elapsed",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 127,
							Line:   37,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], ?unit: duration, ?timeColumn: string, ?columnName: string) => [B] where A: Record, B: Record",
						Start: ast.Position{
							Column: 19,
							Line:   37,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 116,
								Line:   37,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 107,
								Line:   37,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 116,
									Line:   37,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 110,
									Line:   37,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 108,
									Line:   37,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 107,
									Line:   37,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 127,
								Line:   37,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 118,
								Line:   37,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 127,
									Line:   37,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 121,
									Line:   37,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 119,
									Line:   37,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 118,
									Line:   37,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 100,
								Line:   37,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], ?unit: duration, ?timeColumn: string, ?columnName: string) => [B]",
							Start: ast.Position{
								Column: 19,
								Line:   37,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 33,
									Line:   37,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 20,
									Line:   37,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 28,
										Line:   37,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 22,
										Line:   37,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 33,
										Line:   37,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 30,
										Line:   37,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 32,
											Line:   37,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 31,
											Line:   37,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 32,
												Line:   37,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 31,
												Line:   37,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 50,
									Line:   37,
								},
								File:   "universe.flux",
								Source: "?unit: duration",
								Start: ast.Position{
									Column: 35,
									Line:   37,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   37,
									},
									File:   "universe.flux",
									Source: "unit",
									Start: ast.Position{
										Column: 36,
										Line:   37,
									},
								},
							},
							Name: "unit",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 50,
										Line:   37,
									},
									File:   "universe.flux",
									Source: "duration",
									Start: ast.Position{
										Column: 42,
										Line:   37,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 50,
											Line:   37,
										},
										File:   "universe.flux",
										Source: "duration",
										Start: ast.Position{
											Column: 42,
											Line:   37,
										},
									},
								},
								Name: "duration",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 71,
									Line:   37,
								},
								File:   "universe.flux",
								Source: "?timeColumn: string",
								Start: ast.Position{
									Column: 52,
									Line:   37,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 63,
										Line:   37,
									},
									File:   "universe.flux",
									Source: "timeColumn",
									Start: ast.Position{
										Column: 53,
										Line:   37,
									},
								},
							},
							Name: "timeColumn",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 71,
										Line:   37,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 65,
										Line:   37,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 71,
											Line:   37,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 65,
											Line:   37,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 92,
									Line:   37,
								},
								File:   "universe.flux",
								Source: "?columnName: string",
								Start: ast.Position{
									Column: 73,
									Line:   37,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 84,
										Line:   37,
									},
									File:   "universe.flux",
									Source: "columnName",
									Start: ast.Position{
										Column: 74,
										Line:   37,
									},
								},
							},
							Name: "columnName",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 92,
										Line:   37,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 86,
										Line:   37,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 92,
											Line:   37,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 86,
											Line:   37,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 100,
									Line:   37,
								},
								File:   "universe.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 97,
									Line:   37,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 99,
										Line:   37,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 98,
										Line:   37,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 99,
											Line:   37,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 98,
											Line:   37,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 33,
						Line:   38,
					},
					File:   "universe.flux",
					Source: "builtin exponentialMovingAverage",
					Start: ast.Position{
						Column: 1,
						Line:   38,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 33,
							Line:   38,
						},
						File:   "universe.flux",
						Source: "exponentialMovingAverage",
						Start: ast.Position{
							Column: 9,
							Line:   38,
						},
					},
				},
				Name: "exponentialMovingAverage",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 117,
							Line:   38,
						},
						File:   "universe.flux",
						Source: "(<-tables: [{B with _value: A}], n: int) => [{B with _value: A}] where A: Numeric",
						Start: ast.Position{
							Column: 36,
							Line:   38,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 117,
								Line:   38,
							},
							File:   "universe.flux",
							Source: "A: Numeric",
							Start: ast.Position{
								Column: 107,
								Line:   38,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 117,
									Line:   38,
								},
								File:   "universe.flux",
								Source: "Numeric",
								Start: ast.Position{
									Column: 110,
									Line:   38,
								},
							},
						},
						Name: "Numeric",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 108,
									Line:   38,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 107,
									Line:   38,
								},
							},
						},
						Name: "A",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 100,
								Line:   38,
							},
							File:   "universe.flux",
							Source: "(<-tables: [{B with _value: A}], n: int) => [{B with _value: A}]",
							Start: ast.Position{
								Column: 36,
								Line:   38,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 67,
									Line:   38,
								},
								File:   "universe.flux",
								Source: "<-tables: [{B with _value: A}]",
								Start: ast.Position{
									Column: 37,
									Line:   38,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 45,
										Line:   38,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 39,
										Line:   38,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 67,
										Line:   38,
									},
									File:   "universe.flux",
									Source: "[{B with _value: A}]",
									Start: ast.Position{
										Column: 47,
										Line:   38,
									},
								},
							},
							ElementType: &ast.RecordType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 66,
											Line:   38,
										},
										File:   "universe.flux",
										Source: "{B with _value: A}",
										Start: ast.Position{
											Column: 48,
											Line:   38,
										},
									},
								},
								Properties: []*ast.PropertyType{&ast.PropertyType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 65,
												Line:   38,
											},
											File:   "universe.flux",
											Source: "_value: A",
											Start: ast.Position{
												Column: 56,
												Line:   38,
											},
										},
									},
									Name: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 62,
													Line:   38,
												},
												File:   "universe.flux",
												Source: "_value",
												Start: ast.Position{
													Column: 56,
													Line:   38,
												},
											},
										},
										Name: "_value",
									},
									Ty: &ast.TvarType{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 65,
													Line:   38,
												},
												File:   "universe.flux",
												Source: "A",
												Start: ast.Position{
													Column: 64,
													Line:   38,
												},
											},
										},
										ID: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 65,
														Line:   38,
													},
													File:   "universe.flux",
													Source: "A",
													Start: ast.Position{
														Column: 64,
														Line:   38,
													},
												},
											},
											Name: "A",
										},
									},
								}},
								Tvar: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 50,
												Line:   38,
											},
											File:   "universe.flux",
											Source: "B",
											Start: ast.Position{
												Column: 49,
												Line:   38,
											},
										},
									},
									Name: "B",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 75,
									Line:   38,
								},
								File:   "universe.flux",
								Source: "n: int",
								Start: ast.Position{
									Column: 69,
									Line:   38,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 70,
										Line:   38,
									},
									File:   "universe.flux",
									Source: "n",
									Start: ast.Position{
										Column: 69,
										Line:   38,
									},
								},
							},
							Name: "n",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 75,
										Line:   38,
									},
									File:   "universe.flux",
									Source: "int",
									Start: ast.Position{
										Column: 72,
										Line:   38,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 75,
											Line:   38,
										},
										File:   "universe.flux",
										Source: "int",
										Start: ast.Position{
											Column: 72,
											Line:   38,
										},
									},
								},
								Name: "int",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 100,
									Line:   38,
								},
								File:   "universe.flux",
								Source: "[{B with _value: A}]",
								Start: ast.Position{
									Column: 80,
									Line:   38,
								},
							},
						},
						ElementType: &ast.RecordType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 99,
										Line:   38,
									},
									File:   "universe.flux",
									Source: "{B with _value: A}",
									Start: ast.Position{
										Column: 81,
										Line:   38,
									},
								},
							},
							Properties: []*ast.PropertyType{&ast.PropertyType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 98,
											Line:   38,
										},
										File:   "universe.flux",
										Source: "_value: A",
										Start: ast.Position{
											Column: 89,
											Line:   38,
										},
									},
								},
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 95,
												Line:   38,
											},
											File:   "universe.flux",
											Source: "_value",
											Start: ast.Position{
												Column: 89,
												Line:   38,
											},
										},
									},
									Name: "_value",
								},
								Ty: &ast.TvarType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 98,
												Line:   38,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 97,
												Line:   38,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 98,
													Line:   38,
												},
												File:   "universe.flux",
												Source: "A",
												Start: ast.Position{
													Column: 97,
													Line:   38,
												},
											},
										},
										Name: "A",
									},
								},
							}},
							Tvar: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 83,
											Line:   38,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 82,
											Line:   38,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   39,
					},
					File:   "universe.flux",
					Source: "builtin fill",
					Start: ast.Position{
						Column: 1,
						Line:   39,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   39,
						},
						File:   "universe.flux",
						Source: "fill",
						Start: ast.Position{
							Column: 9,
							Line:   39,
						},
					},
				},
				Name: "fill",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 113,
							Line:   39,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], ?column: string, ?value: B, ?usePrevious: bool) => [C] where A: Record, C: Record",
						Start: ast.Position{
							Column: 16,
							Line:   39,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 102,
								Line:   39,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 93,
								Line:   39,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 102,
									Line:   39,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 96,
									Line:   39,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 94,
									Line:   39,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 93,
									Line:   39,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 113,
								Line:   39,
							},
							File:   "universe.flux",
							Source: "C: Record",
							Start: ast.Position{
								Column: 104,
								Line:   39,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 113,
									Line:   39,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 107,
									Line:   39,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 105,
									Line:   39,
								},
								File:   "universe.flux",
								Source: "C",
								Start: ast.Position{
									Column: 104,
									Line:   39,
								},
							},
						},
						Name: "C",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 86,
								Line:   39,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], ?column: string, ?value: B, ?usePrevious: bool) => [C]",
							Start: ast.Position{
								Column: 16,
								Line:   39,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   39,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 17,
									Line:   39,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   39,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 19,
										Line:   39,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   39,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 27,
										Line:   39,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   39,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 28,
											Line:   39,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   39,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 28,
												Line:   39,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 47,
									Line:   39,
								},
								File:   "universe.flux",
								Source: "?column: string",
								Start: ast.Position{
									Column: 32,
									Line:   39,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 39,
										Line:   39,
									},
									File:   "universe.flux",
									Source: "column",
									Start: ast.Position{
										Column: 33,
										Line:   39,
									},
								},
							},
							Name: "column",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 47,
										Line:   39,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 41,
										Line:   39,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 47,
											Line:   39,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 41,
											Line:   39,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 58,
									Line:   39,
								},
								File:   "universe.flux",
								Source: "?value: B",
								Start: ast.Position{
									Column: 49,
									Line:   39,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 55,
										Line:   39,
									},
									File:   "universe.flux",
									Source: "value",
									Start: ast.Position{
										Column: 50,
										Line:   39,
									},
								},
							},
							Name: "value",
						},
						Ty: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 58,
										Line:   39,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 57,
										Line:   39,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 58,
											Line:   39,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 57,
											Line:   39,
										},
									},
								},
								Name: "B",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 78,
									Line:   39,
								},
								File:   "universe.flux",
								Source: "?usePrevious: bool",
								Start: ast.Position{
									Column: 60,
									Line:   39,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 72,
										Line:   39,
									},
									File:   "universe.flux",
									Source: "usePrevious",
									Start: ast.Position{
										Column: 61,
										Line:   39,
									},
								},
							},
							Name: "usePrevious",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 78,
										Line:   39,
									},
									File:   "universe.flux",
									Source: "bool",
									Start: ast.Position{
										Column: 74,
										Line:   39,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 78,
											Line:   39,
										},
										File:   "universe.flux",
										Source: "bool",
										Start: ast.Position{
											Column: 74,
											Line:   39,
										},
									},
								},
								Name: "bool",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 86,
									Line:   39,
								},
								File:   "universe.flux",
								Source: "[C]",
								Start: ast.Position{
									Column: 83,
									Line:   39,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 85,
										Line:   39,
									},
									File:   "universe.flux",
									Source: "C",
									Start: ast.Position{
										Column: 84,
										Line:   39,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 85,
											Line:   39,
										},
										File:   "universe.flux",
										Source: "C",
										Start: ast.Position{
											Column: 84,
											Line:   39,
										},
									},
								},
								Name: "C",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 15,
						Line:   40,
					},
					File:   "universe.flux",
					Source: "builtin filter",
					Start: ast.Position{
						Column: 1,
						Line:   40,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   40,
						},
						File:   "universe.flux",
						Source: "filter",
						Start: ast.Position{
							Column: 9,
							Line:   40,
						},
					},
				},
				Name: "filter",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 94,
							Line:   40,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], fn: (r: A) => bool, ?onEmpty: string) => [A] where A: Record",
						Start: ast.Position{
							Column: 18,
							Line:   40,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 94,
								Line:   40,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 85,
								Line:   40,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 94,
									Line:   40,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 88,
									Line:   40,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 86,
									Line:   40,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 85,
									Line:   40,
								},
							},
						},
						Name: "A",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 78,
								Line:   40,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], fn: (r: A) => bool, ?onEmpty: string) => [A]",
							Start: ast.Position{
								Column: 18,
								Line:   40,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   40,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 19,
									Line:   40,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 27,
										Line:   40,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 21,
										Line:   40,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 32,
										Line:   40,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 29,
										Line:   40,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 31,
											Line:   40,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 30,
											Line:   40,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 31,
												Line:   40,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 30,
												Line:   40,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 52,
									Line:   40,
								},
								File:   "universe.flux",
								Source: "fn: (r: A) => bool",
								Start: ast.Position{
									Column: 34,
									Line:   40,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 36,
										Line:   40,
									},
									File:   "universe.flux",
									Source: "fn",
									Start: ast.Position{
										Column: 34,
										Line:   40,
									},
								},
							},
							Name: "fn",
						},
						Ty: &ast.FunctionType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 52,
										Line:   40,
									},
									File:   "universe.flux",
									Source: "(r: A) => bool",
									Start: ast.Position{
										Column: 38,
										Line:   40,
									},
								},
							},
							Parameters: []*ast.ParameterType{&ast.ParameterType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   40,
										},
										File:   "universe.flux",
										Source: "r: A",
										Start: ast.Position{
											Column: 39,
											Line:   40,
										},
									},
								},
								Kind: "Required",
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 40,
												Line:   40,
											},
											File:   "universe.flux",
											Source: "r",
											Start: ast.Position{
												Column: 39,
												Line:   40,
											},
										},
									},
									Name: "r",
								},
								Ty: &ast.TvarType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   40,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 42,
												Line:   40,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 43,
													Line:   40,
												},
												File:   "universe.flux",
												Source: "A",
												Start: ast.Position{
													Column: 42,
													Line:   40,
												},
											},
										},
										Name: "A",
									},
								},
							}},
							Return: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 52,
											Line:   40,
										},
										File:   "universe.flux",
										Source: "bool",
										Start: ast.Position{
											Column: 48,
											Line:   40,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 52,
												Line:   40,
											},
											File:   "universe.flux",
											Source: "bool",
											Start: ast.Position{
												Column: 48,
												Line:   40,
											},
										},
									},
									Name: "bool",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 70,
									Line:   40,
								},
								File:   "universe.flux",
								Source: "?onEmpty: string",
								Start: ast.Position{
									Column: 54,
									Line:   40,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 62,
										Line:   40,
									},
									File:   "universe.flux",
									Source: "onEmpty",
									Start: ast.Position{
										Column: 55,
										Line:   40,
									},
								},
							},
							Name: "onEmpty",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 70,
										Line:   40,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 64,
										Line:   40,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 70,
											Line:   40,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 64,
											Line:   40,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 78,
									Line:   40,
								},
								File:   "universe.flux",
								Source: "[A]",
								Start: ast.Position{
									Column: 75,
									Line:   40,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 77,
										Line:   40,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 76,
										Line:   40,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 77,
											Line:   40,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 76,
											Line:   40,
										},
									},
								},
								Name: "A",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   41,
					},
					File:   "universe.flux",
					Source: "builtin first",
					Start: ast.Position{
						Column: 1,
						Line:   41,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   41,
						},
						File:   "universe.flux",
						Source: "first",
						Start: ast.Position{
							Column: 9,
							Line:   41,
						},
					},
				},
				Name: "first",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 72,
							Line:   41,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], ?column: string) => [A] where A: Record",
						Start: ast.Position{
							Column: 17,
							Line:   41,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 72,
								Line:   41,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 63,
								Line:   41,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 72,
									Line:   41,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 66,
									Line:   41,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 64,
									Line:   41,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 63,
									Line:   41,
								},
							},
						},
						Name: "A",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 56,
								Line:   41,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], ?column: string) => [A]",
							Start: ast.Position{
								Column: 17,
								Line:   41,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 31,
									Line:   41,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 18,
									Line:   41,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 26,
										Line:   41,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 20,
										Line:   41,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   41,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 28,
										Line:   41,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   41,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 29,
											Line:   41,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 30,
												Line:   41,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 29,
												Line:   41,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 48,
									Line:   41,
								},
								File:   "universe.flux",
								Source: "?column: string",
								Start: ast.Position{
									Column: 33,
									Line:   41,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   41,
									},
									File:   "universe.flux",
									Source: "column",
									Start: ast.Position{
										Column: 34,
										Line:   41,
									},
								},
							},
							Name: "column",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 48,
										Line:   41,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 42,
										Line:   41,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 48,
											Line:   41,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 42,
											Line:   41,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 56,
									Line:   41,
								},
								File:   "universe.flux",
								Source: "[A]",
								Start: ast.Position{
									Column: 53,
									Line:   41,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 55,
										Line:   41,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 54,
										Line:   41,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 55,
											Line:   41,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 54,
											Line:   41,
										},
									},
								},
								Name: "A",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   42,
					},
					File:   "universe.flux",
					Source: "builtin group",
					Start: ast.Position{
						Column: 1,
						Line:   42,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   42,
						},
						File:   "universe.flux",
						Source: "group",
						Start: ast.Position{
							Column: 9,
							Line:   42,
						},
					},
				},
				Name: "group",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 90,
							Line:   42,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], ?mode: string, ?columns: [string]) => [A] where A: Record",
						Start: ast.Position{
							Column: 17,
							Line:   42,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 90,
								Line:   42,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 81,
								Line:   42,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 90,
									Line:   42,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 84,
									Line:   42,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 82,
									Line:   42,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 81,
									Line:   42,
								},
							},
						},
						Name: "A",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 74,
								Line:   42,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], ?mode: string, ?columns: [string]) => [A]",
							Start: ast.Position{
								Column: 17,
								Line:   42,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 31,
									Line:   42,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 18,
									Line:   42,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 26,
										Line:   42,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 20,
										Line:   42,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   42,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 28,
										Line:   42,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   42,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 29,
											Line:   42,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 30,
												Line:   42,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 29,
												Line:   42,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 46,
									Line:   42,
								},
								File:   "universe.flux",
								Source: "?mode: string",
								Start: ast.Position{
									Column: 33,
									Line:   42,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 38,
										Line:   42,
									},
									File:   "universe.flux",
									Source: "mode",
									Start: ast.Position{
										Column: 34,
										Line:   42,
									},
								},
							},
							Name: "mode",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 46,
										Line:   42,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 40,
										Line:   42,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 46,
											Line:   42,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 40,
											Line:   42,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 66,
									Line:   42,
								},
								File:   "universe.flux",
								Source: "?columns: [string]",
								Start: ast.Position{
									Column: 48,
									Line:   42,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 56,
										Line:   42,
									},
									File:   "universe.flux",
									Source: "columns",
									Start: ast.Position{
										Column: 49,
										Line:   42,
									},
								},
							},
							Name: "columns",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 66,
										Line:   42,
									},
									File:   "universe.flux",
									Source: "[string]",
									Start: ast.Position{
										Column: 58,
										Line:   42,
									},
								},
							},
							ElementType: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 65,
											Line:   42,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 59,
											Line:   42,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 65,
												Line:   42,
											},
											File:   "universe.flux",
											Source: "string",
											Start: ast.Position{
												Column: 59,
												Line:   42,
											},
										},
									},
									Name: "string",
								},
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 74,
									Line:   42,
								},
								File:   "universe.flux",
								Source: "[A]",
								Start: ast.Position{
									Column: 71,
									Line:   42,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 73,
										Line:   42,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 72,
										Line:   42,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 73,
											Line:   42,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 72,
											Line:   42,
										},
									},
								},
								Name: "A",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   43,
					},
					File:   "universe.flux",
					Source: "builtin histogram",
					Start: ast.Position{
						Column: 1,
						Line:   43,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   43,
						},
						File:   "universe.flux",
						Source: "histogram",
						Start: ast.Position{
							Column: 9,
							Line:   43,
						},
					},
				},
				Name: "histogram",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   52,
						},
						File:   "universe.flux",
						Source: "(\n    <-tables: [A],\n    ?column: string,\n    ?upperBoundColumn: string,\n    ?countColumn: string,\n    bins: [float],\n    ?normalize: bool,\n) => [B] where\n    A: Record,\n    B: Record",
						Start: ast.Position{
							Column: 21,
							Line:   43,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   51,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 5,
								Line:   51,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   51,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 8,
									Line:   51,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   51,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 5,
									Line:   51,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   52,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 5,
								Line:   52,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   52,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 8,
									Line:   52,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   52,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 5,
									Line:   52,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 9,
								Line:   50,
							},
							File:   "universe.flux",
							Source: "(\n    <-tables: [A],\n    ?column: string,\n    ?upperBoundColumn: string,\n    ?countColumn: string,\n    bins: [float],\n    ?normalize: bool,\n) => [B]",
							Start: ast.Position{
								Column: 21,
								Line:   43,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 18,
									Line:   44,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 5,
									Line:   44,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   44,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 7,
										Line:   44,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   44,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 15,
										Line:   44,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 17,
											Line:   44,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 16,
											Line:   44,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   44,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 16,
												Line:   44,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   45,
								},
								File:   "universe.flux",
								Source: "?column: string",
								Start: ast.Position{
									Column: 5,
									Line:   45,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   45,
									},
									File:   "universe.flux",
									Source: "column",
									Start: ast.Position{
										Column: 6,
										Line:   45,
									},
								},
							},
							Name: "column",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 20,
										Line:   45,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 14,
										Line:   45,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 20,
											Line:   45,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 14,
											Line:   45,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   46,
								},
								File:   "universe.flux",
								Source: "?upperBoundColumn: string",
								Start: ast.Position{
									Column: 5,
									Line:   46,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 22,
										Line:   46,
									},
									File:   "universe.flux",
									Source: "upperBoundColumn",
									Start: ast.Position{
										Column: 6,
										Line:   46,
									},
								},
							},
							Name: "upperBoundColumn",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   46,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 24,
										Line:   46,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   46,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 24,
											Line:   46,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   47,
								},
								File:   "universe.flux",
								Source: "?countColumn: string",
								Start: ast.Position{
									Column: 5,
									Line:   47,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 17,
										Line:   47,
									},
									File:   "universe.flux",
									Source: "countColumn",
									Start: ast.Position{
										Column: 6,
										Line:   47,
									},
								},
							},
							Name: "countColumn",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   47,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 19,
										Line:   47,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 25,
											Line:   47,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 19,
											Line:   47,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 18,
									Line:   48,
								},
								File:   "universe.flux",
								Source: "bins: [float]",
								Start: ast.Position{
									Column: 5,
									Line:   48,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 9,
										Line:   48,
									},
									File:   "universe.flux",
									Source: "bins",
									Start: ast.Position{
										Column: 5,
										Line:   48,
									},
								},
							},
							Name: "bins",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   48,
									},
									File:   "universe.flux",
									Source: "[float]",
									Start: ast.Position{
										Column: 11,
										Line:   48,
									},
								},
							},
							ElementType: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 17,
											Line:   48,
										},
										File:   "universe.flux",
										Source: "float",
										Start: ast.Position{
											Column: 12,
											Line:   48,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   48,
											},
											File:   "universe.flux",
											Source: "float",
											Start: ast.Position{
												Column: 12,
												Line:   48,
											},
										},
									},
									Name: "float",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   49,
								},
								File:   "universe.flux",
								Source: "?normalize: bool",
								Start: ast.Position{
									Column: 5,
									Line:   49,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 15,
										Line:   49,
									},
									File:   "universe.flux",
									Source: "normalize",
									Start: ast.Position{
										Column: 6,
										Line:   49,
									},
								},
							},
							Name: "normalize",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 21,
										Line:   49,
									},
									File:   "universe.flux",
									Source: "bool",
									Start: ast.Position{
										Column: 17,
										Line:   49,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   49,
										},
										File:   "universe.flux",
										Source: "bool",
										Start: ast.Position{
											Column: 17,
											Line:   49,
										},
									},
								},
								Name: "bool",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 9,
									Line:   50,
								},
								File:   "universe.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 6,
									Line:   50,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 8,
										Line:   50,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 7,
										Line:   50,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 8,
											Line:   50,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 7,
											Line:   50,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 26,
						Line:   53,
					},
					File:   "universe.flux",
					Source: "builtin histogramQuantile",
					Start: ast.Position{
						Column: 1,
						Line:   53,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 26,
							Line:   53,
						},
						File:   "universe.flux",
						Source: "histogramQuantile",
						Start: ast.Position{
							Column: 9,
							Line:   53,
						},
					},
				},
				Name: "histogramQuantile",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   62,
						},
						File:   "universe.flux",
						Source: "(\n    <-tables: [A],\n    ?quantile: float,\n    ?countColumn: string,\n    ?upperBoundColumn: string,\n    ?valueColumn: string,\n    ?minValue: float,\n) => [B] where\n    A: Record,\n    B: Record",
						Start: ast.Position{
							Column: 29,
							Line:   53,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   61,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 5,
								Line:   61,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   61,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 8,
									Line:   61,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   61,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 5,
									Line:   61,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   62,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 5,
								Line:   62,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   62,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 8,
									Line:   62,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   62,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 5,
									Line:   62,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 9,
								Line:   60,
							},
							File:   "universe.flux",
							Source: "(\n    <-tables: [A],\n    ?quantile: float,\n    ?countColumn: string,\n    ?upperBoundColumn: string,\n    ?valueColumn: string,\n    ?minValue: float,\n) => [B]",
							Start: ast.Position{
								Column: 29,
								Line:   53,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 18,
									Line:   54,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 5,
									Line:   54,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   54,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 7,
										Line:   54,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   54,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 15,
										Line:   54,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 17,
											Line:   54,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 16,
											Line:   54,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   54,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 16,
												Line:   54,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   55,
								},
								File:   "universe.flux",
								Source: "?quantile: float",
								Start: ast.Position{
									Column: 5,
									Line:   55,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 14,
										Line:   55,
									},
									File:   "universe.flux",
									Source: "quantile",
									Start: ast.Position{
										Column: 6,
										Line:   55,
									},
								},
							},
							Name: "quantile",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 21,
										Line:   55,
									},
									File:   "universe.flux",
									Source: "float",
									Start: ast.Position{
										Column: 16,
										Line:   55,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   55,
										},
										File:   "universe.flux",
										Source: "float",
										Start: ast.Position{
											Column: 16,
											Line:   55,
										},
									},
								},
								Name: "float",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   56,
								},
								File:   "universe.flux",
								Source: "?countColumn: string",
								Start: ast.Position{
									Column: 5,
									Line:   56,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 17,
										Line:   56,
									},
									File:   "universe.flux",
									Source: "countColumn",
									Start: ast.Position{
										Column: 6,
										Line:   56,
									},
								},
							},
							Name: "countColumn",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   56,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 19,
										Line:   56,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 25,
											Line:   56,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 19,
											Line:   56,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   57,
								},
								File:   "universe.flux",
								Source: "?upperBoundColumn: string",
								Start: ast.Position{
									Column: 5,
									Line:   57,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 22,
										Line:   57,
									},
									File:   "universe.flux",
									Source: "upperBoundColumn",
									Start: ast.Position{
										Column: 6,
										Line:   57,
									},
								},
							},
							Name: "upperBoundColumn",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   57,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 24,
										Line:   57,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   57,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 24,
											Line:   57,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   58,
								},
								File:   "universe.flux",
								Source: "?valueColumn: string",
								Start: ast.Position{
									Column: 5,
									Line:   58,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 17,
										Line:   58,
									},
									File:   "universe.flux",
									Source: "valueColumn",
									Start: ast.Position{
										Column: 6,
										Line:   58,
									},
								},
							},
							Name: "valueColumn",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   58,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 19,
										Line:   58,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 25,
											Line:   58,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 19,
											Line:   58,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   59,
								},
								File:   "universe.flux",
								Source: "?minValue: float",
								Start: ast.Position{
									Column: 5,
									Line:   59,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 14,
										Line:   59,
									},
									File:   "universe.flux",
									Source: "minValue",
									Start: ast.Position{
										Column: 6,
										Line:   59,
									},
								},
							},
							Name: "minValue",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 21,
										Line:   59,
									},
									File:   "universe.flux",
									Source: "float",
									Start: ast.Position{
										Column: 16,
										Line:   59,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   59,
										},
										File:   "universe.flux",
										Source: "float",
										Start: ast.Position{
											Column: 16,
											Line:   59,
										},
									},
								},
								Name: "float",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 9,
									Line:   60,
								},
								File:   "universe.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 6,
									Line:   60,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 8,
										Line:   60,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 7,
										Line:   60,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 8,
											Line:   60,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 7,
											Line:   60,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 20,
						Line:   63,
					},
					File:   "universe.flux",
					Source: "builtin holtWinters",
					Start: ast.Position{
						Column: 1,
						Line:   63,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 20,
							Line:   63,
						},
						File:   "universe.flux",
						Source: "holtWinters",
						Start: ast.Position{
							Column: 9,
							Line:   63,
						},
					},
				},
				Name: "holtWinters",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   73,
						},
						File:   "universe.flux",
						Source: "(\n    <-tables: [A],\n    n: int,\n    interval: duration,\n    ?withFit: bool,\n    ?column: string,\n    ?timeColumn: string,\n    ?seasonality: int,\n) => [B] where\n    A: Record,\n    B: Record",
						Start: ast.Position{
							Column: 23,
							Line:   63,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   72,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 5,
								Line:   72,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   72,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 8,
									Line:   72,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   72,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 5,
									Line:   72,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   73,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 5,
								Line:   73,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   73,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 8,
									Line:   73,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   73,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 5,
									Line:   73,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 9,
								Line:   71,
							},
							File:   "universe.flux",
							Source: "(\n    <-tables: [A],\n    n: int,\n    interval: duration,\n    ?withFit: bool,\n    ?column: string,\n    ?timeColumn: string,\n    ?seasonality: int,\n) => [B]",
							Start: ast.Position{
								Column: 23,
								Line:   63,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 18,
									Line:   64,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 5,
									Line:   64,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   64,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 7,
										Line:   64,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   64,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 15,
										Line:   64,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 17,
											Line:   64,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 16,
											Line:   64,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   64,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 16,
												Line:   64,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 11,
									Line:   65,
								},
								File:   "universe.flux",
								Source: "n: int",
								Start: ast.Position{
									Column: 5,
									Line:   65,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   65,
									},
									File:   "universe.flux",
									Source: "n",
									Start: ast.Position{
										Column: 5,
										Line:   65,
									},
								},
							},
							Name: "n",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   65,
									},
									File:   "universe.flux",
									Source: "int",
									Start: ast.Position{
										Column: 8,
										Line:   65,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 11,
											Line:   65,
										},
										File:   "universe.flux",
										Source: "int",
										Start: ast.Position{
											Column: 8,
											Line:   65,
										},
									},
								},
								Name: "int",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 23,
									Line:   66,
								},
								File:   "universe.flux",
								Source: "interval: duration",
								Start: ast.Position{
									Column: 5,
									Line:   66,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   66,
									},
									File:   "universe.flux",
									Source: "interval",
									Start: ast.Position{
										Column: 5,
										Line:   66,
									},
								},
							},
							Name: "interval",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 23,
										Line:   66,
									},
									File:   "universe.flux",
									Source: "duration",
									Start: ast.Position{
										Column: 15,
										Line:   66,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 23,
											Line:   66,
										},
										File:   "universe.flux",
										Source: "duration",
										Start: ast.Position{
											Column: 15,
											Line:   66,
										},
									},
								},
								Name: "duration",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 19,
									Line:   67,
								},
								File:   "universe.flux",
								Source: "?withFit: bool",
								Start: ast.Position{
									Column: 5,
									Line:   67,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   67,
									},
									File:   "universe.flux",
									Source: "withFit",
									Start: ast.Position{
										Column: 6,
										Line:   67,
									},
								},
							},
							Name: "withFit",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 19,
										Line:   67,
									},
									File:   "universe.flux",
									Source: "bool",
									Start: ast.Position{
										Column: 15,
										Line:   67,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 19,
											Line:   67,
										},
										File:   "universe.flux",
										Source: "bool",
										Start: ast.Position{
											Column: 15,
											Line:   67,
										},
									},
								},
								Name: "bool",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   68,
								},
								File:   "universe.flux",
								Source: "?column: string",
								Start: ast.Position{
									Column: 5,
									Line:   68,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   68,
									},
									File:   "universe.flux",
									Source: "column",
									Start: ast.Position{
										Column: 6,
										Line:   68,
									},
								},
							},
							Name: "column",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 20,
										Line:   68,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 14,
										Line:   68,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 20,
											Line:   68,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 14,
											Line:   68,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 24,
									Line:   69,
								},
								File:   "universe.flux",
								Source: "?timeColumn: string",
								Start: ast.Position{
									Column: 5,
									Line:   69,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 16,
										Line:   69,
									},
									File:   "universe.flux",
									Source: "timeColumn",
									Start: ast.Position{
										Column: 6,
										Line:   69,
									},
								},
							},
							Name: "timeColumn",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 24,
										Line:   69,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 18,
										Line:   69,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 24,
											Line:   69,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 18,
											Line:   69,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 22,
									Line:   70,
								},
								File:   "universe.flux",
								Source: "?seasonality: int",
								Start: ast.Position{
									Column: 5,
									Line:   70,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 17,
										Line:   70,
									},
									File:   "universe.flux",
									Source: "seasonality",
									Start: ast.Position{
										Column: 6,
										Line:   70,
									},
								},
							},
							Name: "seasonality",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 22,
										Line:   70,
									},
									File:   "universe.flux",
									Source: "int",
									Start: ast.Position{
										Column: 19,
										Line:   70,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 22,
											Line:   70,
										},
										File:   "universe.flux",
										Source: "int",
										Start: ast.Position{
											Column: 19,
											Line:   70,
										},
									},
								},
								Name: "int",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 9,
									Line:   71,
								},
								File:   "universe.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 6,
									Line:   71,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 8,
										Line:   71,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 7,
										Line:   71,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 8,
											Line:   71,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 7,
											Line:   71,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 22,
						Line:   74,
					},
					File:   "universe.flux",
					Source: "builtin hourSelection",
					Start: ast.Position{
						Column: 1,
						Line:   74,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 22,
							Line:   74,
						},
						File:   "universe.flux",
						Source: "hourSelection",
						Start: ast.Position{
							Column: 9,
							Line:   74,
						},
					},
				},
				Name: "hourSelection",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 107,
							Line:   74,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], start: int, stop: int, ?timeColumn: string) => [A] where A: Record",
						Start: ast.Position{
							Column: 25,
							Line:   74,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 107,
								Line:   74,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 98,
								Line:   74,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 107,
									Line:   74,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 101,
									Line:   74,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 99,
									Line:   74,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 98,
									Line:   74,
								},
							},
						},
						Name: "A",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 91,
								Line:   74,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], start: int, stop: int, ?timeColumn: string) => [A]",
							Start: ast.Position{
								Column: 25,
								Line:   74,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 39,
									Line:   74,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 26,
									Line:   74,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 34,
										Line:   74,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 28,
										Line:   74,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 39,
										Line:   74,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 36,
										Line:   74,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 38,
											Line:   74,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 37,
											Line:   74,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 38,
												Line:   74,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 37,
												Line:   74,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 51,
									Line:   74,
								},
								File:   "universe.flux",
								Source: "start: int",
								Start: ast.Position{
									Column: 41,
									Line:   74,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 46,
										Line:   74,
									},
									File:   "universe.flux",
									Source: "start",
									Start: ast.Position{
										Column: 41,
										Line:   74,
									},
								},
							},
							Name: "start",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 51,
										Line:   74,
									},
									File:   "universe.flux",
									Source: "int",
									Start: ast.Position{
										Column: 48,
										Line:   74,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 51,
											Line:   74,
										},
										File:   "universe.flux",
										Source: "int",
										Start: ast.Position{
											Column: 48,
											Line:   74,
										},
									},
								},
								Name: "int",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 62,
									Line:   74,
								},
								File:   "universe.flux",
								Source: "stop: int",
								Start: ast.Position{
									Column: 53,
									Line:   74,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 57,
										Line:   74,
									},
									File:   "universe.flux",
									Source: "stop",
									Start: ast.Position{
										Column: 53,
										Line:   74,
									},
								},
							},
							Name: "stop",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 62,
										Line:   74,
									},
									File:   "universe.flux",
									Source: "int",
									Start: ast.Position{
										Column: 59,
										Line:   74,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 62,
											Line:   74,
										},
										File:   "universe.flux",
										Source: "int",
										Start: ast.Position{
											Column: 59,
											Line:   74,
										},
									},
								},
								Name: "int",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 83,
									Line:   74,
								},
								File:   "universe.flux",
								Source: "?timeColumn: string",
								Start: ast.Position{
									Column: 64,
									Line:   74,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 75,
										Line:   74,
									},
									File:   "universe.flux",
									Source: "timeColumn",
									Start: ast.Position{
										Column: 65,
										Line:   74,
									},
								},
							},
							Name: "timeColumn",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 83,
										Line:   74,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 77,
										Line:   74,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 83,
											Line:   74,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 77,
											Line:   74,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 91,
									Line:   74,
								},
								File:   "universe.flux",
								Source: "[A]",
								Start: ast.Position{
									Column: 88,
									Line:   74,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 90,
										Line:   74,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 89,
										Line:   74,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 90,
											Line:   74,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 89,
											Line:   74,
										},
									},
								},
								Name: "A",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   75,
					},
					File:   "universe.flux",
					Source: "builtin integral",
					Start: ast.Position{
						Column: 1,
						Line:   75,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   75,
						},
						File:   "universe.flux",
						Source: "integral",
						Start: ast.Position{
							Column: 9,
							Line:   75,
						},
					},
				},
				Name: "integral",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   83,
						},
						File:   "universe.flux",
						Source: "(\n    <-tables: [A],\n    ?unit: duration,\n    ?timeColumn: string,\n    ?column: string,\n    ?interpolate: string,\n) => [B] where\n    A: Record,\n    B: Record",
						Start: ast.Position{
							Column: 20,
							Line:   75,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   82,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 5,
								Line:   82,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   82,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 8,
									Line:   82,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   82,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 5,
									Line:   82,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   83,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 5,
								Line:   83,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   83,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 8,
									Line:   83,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   83,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 5,
									Line:   83,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 9,
								Line:   81,
							},
							File:   "universe.flux",
							Source: "(\n    <-tables: [A],\n    ?unit: duration,\n    ?timeColumn: string,\n    ?column: string,\n    ?interpolate: string,\n) => [B]",
							Start: ast.Position{
								Column: 20,
								Line:   75,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 18,
									Line:   76,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 5,
									Line:   76,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   76,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 7,
										Line:   76,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   76,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 15,
										Line:   76,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 17,
											Line:   76,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 16,
											Line:   76,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   76,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 16,
												Line:   76,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   77,
								},
								File:   "universe.flux",
								Source: "?unit: duration",
								Start: ast.Position{
									Column: 5,
									Line:   77,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 10,
										Line:   77,
									},
									File:   "universe.flux",
									Source: "unit",
									Start: ast.Position{
										Column: 6,
										Line:   77,
									},
								},
							},
							Name: "unit",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 20,
										Line:   77,
									},
									File:   "universe.flux",
									Source: "duration",
									Start: ast.Position{
										Column: 12,
										Line:   77,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 20,
											Line:   77,
										},
										File:   "universe.flux",
										Source: "duration",
										Start: ast.Position{
											Column: 12,
											Line:   77,
										},
									},
								},
								Name: "duration",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 24,
									Line:   78,
								},
								File:   "universe.flux",
								Source: "?timeColumn: string",
								Start: ast.Position{
									Column: 5,
									Line:   78,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 16,
										Line:   78,
									},
									File:   "universe.flux",
									Source: "timeColumn",
									Start: ast.Position{
										Column: 6,
										Line:   78,
									},
								},
							},
							Name: "timeColumn",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 24,
										Line:   78,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 18,
										Line:   78,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 24,
											Line:   78,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 18,
											Line:   78,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   79,
								},
								File:   "universe.flux",
								Source: "?column: string",
								Start: ast.Position{
									Column: 5,
									Line:   79,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   79,
									},
									File:   "universe.flux",
									Source: "column",
									Start: ast.Position{
										Column: 6,
										Line:   79,
									},
								},
							},
							Name: "column",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 20,
										Line:   79,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 14,
										Line:   79,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 20,
											Line:   79,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 14,
											Line:   79,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   80,
								},
								File:   "universe.flux",
								Source: "?interpolate: string",
								Start: ast.Position{
									Column: 5,
									Line:   80,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 17,
										Line:   80,
									},
									File:   "universe.flux",
									Source: "interpolate",
									Start: ast.Position{
										Column: 6,
										Line:   80,
									},
								},
							},
							Name: "interpolate",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   80,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 19,
										Line:   80,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 25,
											Line:   80,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 19,
											Line:   80,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 9,
									Line:   81,
								},
								File:   "universe.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 6,
									Line:   81,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 8,
										Line:   81,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 7,
										Line:   81,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 8,
											Line:   81,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 7,
											Line:   81,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   84,
					},
					File:   "universe.flux",
					Source: "builtin join",
					Start: ast.Position{
						Column: 1,
						Line:   84,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   84,
						},
						File:   "universe.flux",
						Source: "join",
						Start: ast.Position{
							Column: 9,
							Line:   84,
						},
					},
				},
				Name: "join",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 95,
							Line:   84,
						},
						File:   "universe.flux",
						Source: "(<-tables: A, ?method: string, ?on: [string]) => [B] where A: Record, B: Record",
						Start: ast.Position{
							Column: 16,
							Line:   84,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 84,
								Line:   84,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 75,
								Line:   84,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 84,
									Line:   84,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 78,
									Line:   84,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 76,
									Line:   84,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 75,
									Line:   84,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 95,
								Line:   84,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 86,
								Line:   84,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 95,
									Line:   84,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 89,
									Line:   84,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 87,
									Line:   84,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 86,
									Line:   84,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 68,
								Line:   84,
							},
							File:   "universe.flux",
							Source: "(<-tables: A, ?method: string, ?on: [string]) => [B]",
							Start: ast.Position{
								Column: 16,
								Line:   84,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 28,
									Line:   84,
								},
								File:   "universe.flux",
								Source: "<-tables: A",
								Start: ast.Position{
									Column: 17,
									Line:   84,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   84,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 19,
										Line:   84,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 28,
										Line:   84,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 27,
										Line:   84,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 28,
											Line:   84,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 27,
											Line:   84,
										},
									},
								},
								Name: "A",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 45,
									Line:   84,
								},
								File:   "universe.flux",
								Source: "?method: string",
								Start: ast.Position{
									Column: 30,
									Line:   84,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 37,
										Line:   84,
									},
									File:   "universe.flux",
									Source: "method",
									Start: ast.Position{
										Column: 31,
										Line:   84,
									},
								},
							},
							Name: "method",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 45,
										Line:   84,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 39,
										Line:   84,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 45,
											Line:   84,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 39,
											Line:   84,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 60,
									Line:   84,
								},
								File:   "universe.flux",
								Source: "?on: [string]",
								Start: ast.Position{
									Column: 47,
									Line:   84,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 50,
										Line:   84,
									},
									File:   "universe.flux",
									Source: "on",
									Start: ast.Position{
										Column: 48,
										Line:   84,
									},
								},
							},
							Name: "on",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 60,
										Line:   84,
									},
									File:   "universe.flux",
									Source: "[string]",
									Start: ast.Position{
										Column: 52,
										Line:   84,
									},
								},
							},
							ElementType: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 59,
											Line:   84,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 53,
											Line:   84,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 59,
												Line:   84,
											},
											File:   "universe.flux",
											Source: "string",
											Start: ast.Position{
												Column: 53,
												Line:   84,
											},
										},
									},
									Name: "string",
								},
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 68,
									Line:   84,
								},
								File:   "universe.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 65,
									Line:   84,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 67,
										Line:   84,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 66,
										Line:   84,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 67,
											Line:   84,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 66,
											Line:   84,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 20,
						Line:   85,
					},
					File:   "universe.flux",
					Source: "builtin kaufmansAMA",
					Start: ast.Position{
						Column: 1,
						Line:   85,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 20,
							Line:   85,
						},
						File:   "universe.flux",
						Source: "kaufmansAMA",
						Start: ast.Position{
							Column: 9,
							Line:   85,
						},
					},
				},
				Name: "kaufmansAMA",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 97,
							Line:   85,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], n: int, ?column: string) => [B] where A: Record, B: Record",
						Start: ast.Position{
							Column: 23,
							Line:   85,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 86,
								Line:   85,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 77,
								Line:   85,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 86,
									Line:   85,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 80,
									Line:   85,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 78,
									Line:   85,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 77,
									Line:   85,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 97,
								Line:   85,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 88,
								Line:   85,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 97,
									Line:   85,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 91,
									Line:   85,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 89,
									Line:   85,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 88,
									Line:   85,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 70,
								Line:   85,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], n: int, ?column: string) => [B]",
							Start: ast.Position{
								Column: 23,
								Line:   85,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 37,
									Line:   85,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 24,
									Line:   85,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 32,
										Line:   85,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 26,
										Line:   85,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 37,
										Line:   85,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 34,
										Line:   85,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 36,
											Line:   85,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 35,
											Line:   85,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 36,
												Line:   85,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 35,
												Line:   85,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 45,
									Line:   85,
								},
								File:   "universe.flux",
								Source: "n: int",
								Start: ast.Position{
									Column: 39,
									Line:   85,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   85,
									},
									File:   "universe.flux",
									Source: "n",
									Start: ast.Position{
										Column: 39,
										Line:   85,
									},
								},
							},
							Name: "n",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 45,
										Line:   85,
									},
									File:   "universe.flux",
									Source: "int",
									Start: ast.Position{
										Column: 42,
										Line:   85,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 45,
											Line:   85,
										},
										File:   "universe.flux",
										Source: "int",
										Start: ast.Position{
											Column: 42,
											Line:   85,
										},
									},
								},
								Name: "int",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 62,
									Line:   85,
								},
								File:   "universe.flux",
								Source: "?column: string",
								Start: ast.Position{
									Column: 47,
									Line:   85,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 54,
										Line:   85,
									},
									File:   "universe.flux",
									Source: "column",
									Start: ast.Position{
										Column: 48,
										Line:   85,
									},
								},
							},
							Name: "column",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 62,
										Line:   85,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 56,
										Line:   85,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 62,
											Line:   85,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 56,
											Line:   85,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 70,
									Line:   85,
								},
								File:   "universe.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 67,
									Line:   85,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 69,
										Line:   85,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 68,
										Line:   85,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 69,
											Line:   85,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 68,
											Line:   85,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   86,
					},
					File:   "universe.flux",
					Source: "builtin keep",
					Start: ast.Position{
						Column: 1,
						Line:   86,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   86,
						},
						File:   "universe.flux",
						Source: "keep",
						Start: ast.Position{
							Column: 9,
							Line:   86,
						},
					},
				},
				Name: "keep",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 116,
							Line:   86,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], ?columns: [string], ?fn: (column: string) => bool) => [B] where A: Record, B: Record",
						Start: ast.Position{
							Column: 16,
							Line:   86,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 105,
								Line:   86,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 96,
								Line:   86,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 105,
									Line:   86,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 99,
									Line:   86,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 97,
									Line:   86,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 96,
									Line:   86,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 116,
								Line:   86,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 107,
								Line:   86,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 116,
									Line:   86,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 110,
									Line:   86,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 108,
									Line:   86,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 107,
									Line:   86,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 89,
								Line:   86,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], ?columns: [string], ?fn: (column: string) => bool) => [B]",
							Start: ast.Position{
								Column: 16,
								Line:   86,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   86,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 17,
									Line:   86,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   86,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 19,
										Line:   86,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   86,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 27,
										Line:   86,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   86,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 28,
											Line:   86,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   86,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 28,
												Line:   86,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 50,
									Line:   86,
								},
								File:   "universe.flux",
								Source: "?columns: [string]",
								Start: ast.Position{
									Column: 32,
									Line:   86,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   86,
									},
									File:   "universe.flux",
									Source: "columns",
									Start: ast.Position{
										Column: 33,
										Line:   86,
									},
								},
							},
							Name: "columns",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 50,
										Line:   86,
									},
									File:   "universe.flux",
									Source: "[string]",
									Start: ast.Position{
										Column: 42,
										Line:   86,
									},
								},
							},
							ElementType: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 49,
											Line:   86,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 43,
											Line:   86,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   86,
											},
											File:   "universe.flux",
											Source: "string",
											Start: ast.Position{
												Column: 43,
												Line:   86,
											},
										},
									},
									Name: "string",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 81,
									Line:   86,
								},
								File:   "universe.flux",
								Source: "?fn: (column: string) => bool",
								Start: ast.Position{
									Column: 52,
									Line:   86,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 55,
										Line:   86,
									},
									File:   "universe.flux",
									Source: "fn",
									Start: ast.Position{
										Column: 53,
										Line:   86,
									},
								},
							},
							Name: "fn",
						},
						Ty: &ast.FunctionType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 81,
										Line:   86,
									},
									File:   "universe.flux",
									Source: "(column: string) => bool",
									Start: ast.Position{
										Column: 57,
										Line:   86,
									},
								},
							},
							Parameters: []*ast.ParameterType{&ast.ParameterType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 72,
											Line:   86,
										},
										File:   "universe.flux",
										Source: "column: string",
										Start: ast.Position{
											Column: 58,
											Line:   86,
										},
									},
								},
								Kind: "Required",
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 64,
												Line:   86,
											},
											File:   "universe.flux",
											Source: "column",
											Start: ast.Position{
												Column: 58,
												Line:   86,
											},
										},
									},
									Name: "column",
								},
								Ty: &ast.NamedType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 72,
												Line:   86,
											},
											File:   "universe.flux",
											Source: "string",
											Start: ast.Position{
												Column: 66,
												Line:   86,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 72,
													Line:   86,
												},
												File:   "universe.flux",
												Source: "string",
												Start: ast.Position{
													Column: 66,
													Line:   86,
												},
											},
										},
										Name: "string",
									},
								},
							}},
							Return: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 81,
											Line:   86,
										},
										File:   "universe.flux",
										Source: "bool",
										Start: ast.Position{
											Column: 77,
											Line:   86,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 81,
												Line:   86,
											},
											File:   "universe.flux",
											Source: "bool",
											Start: ast.Position{
												Column: 77,
												Line:   86,
											},
										},
									},
									Name: "bool",
								},
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 89,
									Line:   86,
								},
								File:   "universe.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 86,
									Line:   86,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 88,
										Line:   86,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 87,
										Line:   86,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 88,
											Line:   86,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 87,
											Line:   86,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   87,
					},
					File:   "universe.flux",
					Source: "builtin keyValues",
					Start: ast.Position{
						Column: 1,
						Line:   87,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   87,
						},
						File:   "universe.flux",
						Source: "keyValues",
						Start: ast.Position{
							Column: 9,
							Line:   87,
						},
					},
				},
				Name: "keyValues",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 124,
							Line:   87,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], ?keyColumns: [string]) => [{C with _key: string, _value: B}] where A: Record, C: Record",
						Start: ast.Position{
							Column: 21,
							Line:   87,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 113,
								Line:   87,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 104,
								Line:   87,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 113,
									Line:   87,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 107,
									Line:   87,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 105,
									Line:   87,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 104,
									Line:   87,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 124,
								Line:   87,
							},
							File:   "universe.flux",
							Source: "C: Record",
							Start: ast.Position{
								Column: 115,
								Line:   87,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 124,
									Line:   87,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 118,
									Line:   87,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 116,
									Line:   87,
								},
								File:   "universe.flux",
								Source: "C",
								Start: ast.Position{
									Column: 115,
									Line:   87,
								},
							},
						},
						Name: "C",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 97,
								Line:   87,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], ?keyColumns: [string]) => [{C with _key: string, _value: B}]",
							Start: ast.Position{
								Column: 21,
								Line:   87,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 35,
									Line:   87,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 22,
									Line:   87,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   87,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 24,
										Line:   87,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 35,
										Line:   87,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 32,
										Line:   87,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 34,
											Line:   87,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 33,
											Line:   87,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 34,
												Line:   87,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 33,
												Line:   87,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 58,
									Line:   87,
								},
								File:   "universe.flux",
								Source: "?keyColumns: [string]",
								Start: ast.Position{
									Column: 37,
									Line:   87,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 48,
										Line:   87,
									},
									File:   "universe.flux",
									Source: "keyColumns",
									Start: ast.Position{
										Column: 38,
										Line:   87,
									},
								},
							},
							Name: "keyColumns",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 58,
										Line:   87,
									},
									File:   "universe.flux",
									Source: "[string]",
									Start: ast.Position{
										Column: 50,
										Line:   87,
									},
								},
							},
							ElementType: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 57,
											Line:   87,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 51,
											Line:   87,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 57,
												Line:   87,
											},
											File:   "universe.flux",
											Source: "string",
											Start: ast.Position{
												Column: 51,
												Line:   87,
											},
										},
									},
									Name: "string",
								},
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 97,
									Line:   87,
								},
								File:   "universe.flux",
								Source: "[{C with _key: string, _value: B}]",
								Start: ast.Position{
									Column: 63,
									Line:   87,
								},
							},
						},
						ElementType: &ast.RecordType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 96,
										Line:   87,
									},
									File:   "universe.flux",
									Source: "{C with _key: string, _value: B}",
									Start: ast.Position{
										Column: 64,
										Line:   87,
									},
								},
							},
							Properties: []*ast.PropertyType{&ast.PropertyType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 84,
											Line:   87,
										},
										File:   "universe.flux",
										Source: "_key: string",
										Start: ast.Position{
											Column: 72,
											Line:   87,
										},
									},
								},
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 76,
												Line:   87,
											},
											File:   "universe.flux",
											Source: "_key",
											Start: ast.Position{
												Column: 72,
												Line:   87,
											},
										},
									},
									Name: "_key",
								},
								Ty: &ast.NamedType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 84,
												Line:   87,
											},
											File:   "universe.flux",
											Source: "string",
											Start: ast.Position{
												Column: 78,
												Line:   87,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 84,
													Line:   87,
												},
												File:   "universe.flux",
												Source: "string",
												Start: ast.Position{
													Column: 78,
													Line:   87,
												},
											},
										},
										Name: "string",
									},
								},
							}, &ast.PropertyType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 95,
											Line:   87,
										},
										File:   "universe.flux",
										Source: "_value: B",
										Start: ast.Position{
											Column: 86,
											Line:   87,
										},
									},
								},
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 92,
												Line:   87,
											},
											File:   "universe.flux",
											Source: "_value",
											Start: ast.Position{
												Column: 86,
												Line:   87,
											},
										},
									},
									Name: "_value",
								},
								Ty: &ast.TvarType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 95,
												Line:   87,
											},
											File:   "universe.flux",
											Source: "B",
											Start: ast.Position{
												Column: 94,
												Line:   87,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 95,
													Line:   87,
												},
												File:   "universe.flux",
												Source: "B",
												Start: ast.Position{
													Column: 94,
													Line:   87,
												},
											},
										},
										Name: "B",
									},
								},
							}},
							Tvar: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 66,
											Line:   87,
										},
										File:   "universe.flux",
										Source: "C",
										Start: ast.Position{
											Column: 65,
											Line:   87,
										},
									},
								},
								Name: "C",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   88,
					},
					File:   "universe.flux",
					Source: "builtin keys",
					Start: ast.Position{
						Column: 1,
						Line:   88,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   88,
						},
						File:   "universe.flux",
						Source: "keys",
						Start: ast.Position{
							Column: 9,
							Line:   88,
						},
					},
				},
				Name: "keys",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 82,
							Line:   88,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], ?column: string) => [B] where A: Record, B: Record",
						Start: ast.Position{
							Column: 16,
							Line:   88,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 71,
								Line:   88,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 62,
								Line:   88,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 71,
									Line:   88,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 65,
									Line:   88,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 63,
									Line:   88,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 62,
									Line:   88,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 82,
								Line:   88,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 73,
								Line:   88,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 82,
									Line:   88,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 76,
									Line:   88,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 74,
									Line:   88,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 73,
									Line:   88,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 55,
								Line:   88,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], ?column: string) => [B]",
							Start: ast.Position{
								Column: 16,
								Line:   88,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   88,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 17,
									Line:   88,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   88,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 19,
										Line:   88,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   88,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 27,
										Line:   88,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   88,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 28,
											Line:   88,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   88,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 28,
												Line:   88,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 47,
									Line:   88,
								},
								File:   "universe.flux",
								Source: "?column: string",
								Start: ast.Position{
									Column: 32,
									Line:   88,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 39,
										Line:   88,
									},
									File:   "universe.flux",
									Source: "column",
									Start: ast.Position{
										Column: 33,
										Line:   88,
									},
								},
							},
							Name: "column",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 47,
										Line:   88,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 41,
										Line:   88,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 47,
											Line:   88,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 41,
											Line:   88,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 55,
									Line:   88,
								},
								File:   "universe.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 52,
									Line:   88,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 54,
										Line:   88,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 53,
										Line:   88,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 54,
											Line:   88,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 53,
											Line:   88,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   89,
					},
					File:   "universe.flux",
					Source: "builtin last",
					Start: ast.Position{
						Column: 1,
						Line:   89,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   89,
						},
						File:   "universe.flux",
						Source: "last",
						Start: ast.Position{
							Column: 9,
							Line:   89,
						},
					},
				},
				Name: "last",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 71,
							Line:   89,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], ?column: string) => [A] where A: Record",
						Start: ast.Position{
							Column: 16,
							Line:   89,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 71,
								Line:   89,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 62,
								Line:   89,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 71,
									Line:   89,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 65,
									Line:   89,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 63,
									Line:   89,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 62,
									Line:   89,
								},
							},
						},
						Name: "A",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 55,
								Line:   89,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], ?column: string) => [A]",
							Start: ast.Position{
								Column: 16,
								Line:   89,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   89,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 17,
									Line:   89,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   89,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 19,
										Line:   89,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   89,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 27,
										Line:   89,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   89,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 28,
											Line:   89,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   89,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 28,
												Line:   89,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 47,
									Line:   89,
								},
								File:   "universe.flux",
								Source: "?column: string",
								Start: ast.Position{
									Column: 32,
									Line:   89,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 39,
										Line:   89,
									},
									File:   "universe.flux",
									Source: "column",
									Start: ast.Position{
										Column: 33,
										Line:   89,
									},
								},
							},
							Name: "column",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 47,
										Line:   89,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 41,
										Line:   89,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 47,
											Line:   89,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 41,
											Line:   89,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 55,
									Line:   89,
								},
								File:   "universe.flux",
								Source: "[A]",
								Start: ast.Position{
									Column: 52,
									Line:   89,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 54,
										Line:   89,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 53,
										Line:   89,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 54,
											Line:   89,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 53,
											Line:   89,
										},
									},
								},
								Name: "A",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   90,
					},
					File:   "universe.flux",
					Source: "builtin limit",
					Start: ast.Position{
						Column: 1,
						Line:   90,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   90,
						},
						File:   "universe.flux",
						Source: "limit",
						Start: ast.Position{
							Column: 9,
							Line:   90,
						},
					},
				},
				Name: "limit",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 61,
							Line:   90,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], n: int, ?offset: int) => [A]",
						Start: ast.Position{
							Column: 17,
							Line:   90,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 61,
								Line:   90,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], n: int, ?offset: int) => [A]",
							Start: ast.Position{
								Column: 17,
								Line:   90,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 31,
									Line:   90,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 18,
									Line:   90,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 26,
										Line:   90,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 20,
										Line:   90,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   90,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 28,
										Line:   90,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   90,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 29,
											Line:   90,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 30,
												Line:   90,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 29,
												Line:   90,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 39,
									Line:   90,
								},
								File:   "universe.flux",
								Source: "n: int",
								Start: ast.Position{
									Column: 33,
									Line:   90,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 34,
										Line:   90,
									},
									File:   "universe.flux",
									Source: "n",
									Start: ast.Position{
										Column: 33,
										Line:   90,
									},
								},
							},
							Name: "n",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 39,
										Line:   90,
									},
									File:   "universe.flux",
									Source: "int",
									Start: ast.Position{
										Column: 36,
										Line:   90,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 39,
											Line:   90,
										},
										File:   "universe.flux",
										Source: "int",
										Start: ast.Position{
											Column: 36,
											Line:   90,
										},
									},
								},
								Name: "int",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 53,
									Line:   90,
								},
								File:   "universe.flux",
								Source: "?offset: int",
								Start: ast.Position{
									Column: 41,
									Line:   90,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 48,
										Line:   90,
									},
									File:   "universe.flux",
									Source: "offset",
									Start: ast.Position{
										Column: 42,
										Line:   90,
									},
								},
							},
							Name: "offset",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 53,
										Line:   90,
									},
									File:   "universe.flux",
									Source: "int",
									Start: ast.Position{
										Column: 50,
										Line:   90,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 53,
											Line:   90,
										},
										File:   "universe.flux",
										Source: "int",
										Start: ast.Position{
											Column: 50,
											Line:   90,
										},
									},
								},
								Name: "int",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 61,
									Line:   90,
								},
								File:   "universe.flux",
								Source: "[A]",
								Start: ast.Position{
									Column: 58,
									Line:   90,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 60,
										Line:   90,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 59,
										Line:   90,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 60,
											Line:   90,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 59,
											Line:   90,
										},
									},
								},
								Name: "A",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 12,
						Line:   91,
					},
					File:   "universe.flux",
					Source: "builtin map",
					Start: ast.Position{
						Column: 1,
						Line:   91,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   91,
						},
						File:   "universe.flux",
						Source: "map",
						Start: ast.Position{
							Column: 9,
							Line:   91,
						},
					},
				},
				Name: "map",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 71,
							Line:   91,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], fn: (r: A) => B, ?mergeKey: bool) => [B]",
						Start: ast.Position{
							Column: 15,
							Line:   91,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 71,
								Line:   91,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], fn: (r: A) => B, ?mergeKey: bool) => [B]",
							Start: ast.Position{
								Column: 15,
								Line:   91,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 29,
									Line:   91,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 16,
									Line:   91,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 24,
										Line:   91,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 18,
										Line:   91,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   91,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 26,
										Line:   91,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 28,
											Line:   91,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 27,
											Line:   91,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 28,
												Line:   91,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 27,
												Line:   91,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 46,
									Line:   91,
								},
								File:   "universe.flux",
								Source: "fn: (r: A) => B",
								Start: ast.Position{
									Column: 31,
									Line:   91,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 33,
										Line:   91,
									},
									File:   "universe.flux",
									Source: "fn",
									Start: ast.Position{
										Column: 31,
										Line:   91,
									},
								},
							},
							Name: "fn",
						},
						Ty: &ast.FunctionType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 46,
										Line:   91,
									},
									File:   "universe.flux",
									Source: "(r: A) => B",
									Start: ast.Position{
										Column: 35,
										Line:   91,
									},
								},
							},
							Parameters: []*ast.ParameterType{&ast.ParameterType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   91,
										},
										File:   "universe.flux",
										Source: "r: A",
										Start: ast.Position{
											Column: 36,
											Line:   91,
										},
									},
								},
								Kind: "Required",
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 37,
												Line:   91,
											},
											File:   "universe.flux",
											Source: "r",
											Start: ast.Position{
												Column: 36,
												Line:   91,
											},
										},
									},
									Name: "r",
								},
								Ty: &ast.TvarType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 40,
												Line:   91,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 39,
												Line:   91,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 40,
													Line:   91,
												},
												File:   "universe.flux",
												Source: "A",
												Start: ast.Position{
													Column: 39,
													Line:   91,
												},
											},
										},
										Name: "A",
									},
								},
							}},
							Return: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 46,
											Line:   91,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 45,
											Line:   91,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 46,
												Line:   91,
											},
											File:   "universe.flux",
											Source: "B",
											Start: ast.Position{
												Column: 45,
												Line:   91,
											},
										},
									},
									Name: "B",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 63,
									Line:   91,
								},
								File:   "universe.flux",
								Source: "?mergeKey: bool",
								Start: ast.Position{
									Column: 48,
									Line:   91,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 57,
										Line:   91,
									},
									File:   "universe.flux",
									Source: "mergeKey",
									Start: ast.Position{
										Column: 49,
										Line:   91,
									},
								},
							},
							Name: "mergeKey",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 63,
										Line:   91,
									},
									File:   "universe.flux",
									Source: "bool",
									Start: ast.Position{
										Column: 59,
										Line:   91,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 63,
											Line:   91,
										},
										File:   "universe.flux",
										Source: "bool",
										Start: ast.Position{
											Column: 59,
											Line:   91,
										},
									},
								},
								Name: "bool",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 71,
									Line:   91,
								},
								File:   "universe.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 68,
									Line:   91,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 70,
										Line:   91,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 69,
										Line:   91,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 70,
											Line:   91,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 69,
											Line:   91,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 12,
						Line:   92,
					},
					File:   "universe.flux",
					Source: "builtin max",
					Start: ast.Position{
						Column: 1,
						Line:   92,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   92,
						},
						File:   "universe.flux",
						Source: "max",
						Start: ast.Position{
							Column: 9,
							Line:   92,
						},
					},
				},
				Name: "max",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 70,
							Line:   92,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], ?column: string) => [A] where A: Record",
						Start: ast.Position{
							Column: 15,
							Line:   92,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 70,
								Line:   92,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 61,
								Line:   92,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 70,
									Line:   92,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 64,
									Line:   92,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 62,
									Line:   92,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 61,
									Line:   92,
								},
							},
						},
						Name: "A",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 54,
								Line:   92,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], ?column: string) => [A]",
							Start: ast.Position{
								Column: 15,
								Line:   92,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 29,
									Line:   92,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 16,
									Line:   92,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 24,
										Line:   92,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 18,
										Line:   92,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   92,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 26,
										Line:   92,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 28,
											Line:   92,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 27,
											Line:   92,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 28,
												Line:   92,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 27,
												Line:   92,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 46,
									Line:   92,
								},
								File:   "universe.flux",
								Source: "?column: string",
								Start: ast.Position{
									Column: 31,
									Line:   92,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 38,
										Line:   92,
									},
									File:   "universe.flux",
									Source: "column",
									Start: ast.Position{
										Column: 32,
										Line:   92,
									},
								},
							},
							Name: "column",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 46,
										Line:   92,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 40,
										Line:   92,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 46,
											Line:   92,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 40,
											Line:   92,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 54,
									Line:   92,
								},
								File:   "universe.flux",
								Source: "[A]",
								Start: ast.Position{
									Column: 51,
									Line:   92,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 53,
										Line:   92,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 52,
										Line:   92,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 53,
											Line:   92,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 52,
											Line:   92,
										},
									},
								},
								Name: "A",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   93,
					},
					File:   "universe.flux",
					Source: "builtin mean",
					Start: ast.Position{
						Column: 1,
						Line:   93,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   93,
						},
						File:   "universe.flux",
						Source: "mean",
						Start: ast.Position{
							Column: 9,
							Line:   93,
						},
					},
				},
				Name: "mean",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 82,
							Line:   93,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], ?column: string) => [B] where A: Record, B: Record",
						Start: ast.Position{
							Column: 16,
							Line:   93,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 71,
								Line:   93,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 62,
								Line:   93,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 71,
									Line:   93,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 65,
									Line:   93,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 63,
									Line:   93,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 62,
									Line:   93,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 82,
								Line:   93,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 73,
								Line:   93,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 82,
									Line:   93,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 76,
									Line:   93,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 74,
									Line:   93,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 73,
									Line:   93,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 55,
								Line:   93,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], ?column: string) => [B]",
							Start: ast.Position{
								Column: 16,
								Line:   93,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   93,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 17,
									Line:   93,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   93,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 19,
										Line:   93,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   93,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 27,
										Line:   93,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   93,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 28,
											Line:   93,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   93,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 28,
												Line:   93,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 47,
									Line:   93,
								},
								File:   "universe.flux",
								Source: "?column: string",
								Start: ast.Position{
									Column: 32,
									Line:   93,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 39,
										Line:   93,
									},
									File:   "universe.flux",
									Source: "column",
									Start: ast.Position{
										Column: 33,
										Line:   93,
									},
								},
							},
							Name: "column",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 47,
										Line:   93,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 41,
										Line:   93,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 47,
											Line:   93,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 41,
											Line:   93,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 55,
									Line:   93,
								},
								File:   "universe.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 52,
									Line:   93,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 54,
										Line:   93,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 53,
										Line:   93,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 54,
											Line:   93,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 53,
											Line:   93,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 12,
						Line:   94,
					},
					File:   "universe.flux",
					Source: "builtin min",
					Start: ast.Position{
						Column: 1,
						Line:   94,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   94,
						},
						File:   "universe.flux",
						Source: "min",
						Start: ast.Position{
							Column: 9,
							Line:   94,
						},
					},
				},
				Name: "min",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 70,
							Line:   94,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], ?column: string) => [A] where A: Record",
						Start: ast.Position{
							Column: 15,
							Line:   94,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 70,
								Line:   94,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 61,
								Line:   94,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 70,
									Line:   94,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 64,
									Line:   94,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 62,
									Line:   94,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 61,
									Line:   94,
								},
							},
						},
						Name: "A",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 54,
								Line:   94,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], ?column: string) => [A]",
							Start: ast.Position{
								Column: 15,
								Line:   94,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 29,
									Line:   94,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 16,
									Line:   94,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 24,
										Line:   94,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 18,
										Line:   94,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   94,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 26,
										Line:   94,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 28,
											Line:   94,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 27,
											Line:   94,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 28,
												Line:   94,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 27,
												Line:   94,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 46,
									Line:   94,
								},
								File:   "universe.flux",
								Source: "?column: string",
								Start: ast.Position{
									Column: 31,
									Line:   94,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 38,
										Line:   94,
									},
									File:   "universe.flux",
									Source: "column",
									Start: ast.Position{
										Column: 32,
										Line:   94,
									},
								},
							},
							Name: "column",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 46,
										Line:   94,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 40,
										Line:   94,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 46,
											Line:   94,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 40,
											Line:   94,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 54,
									Line:   94,
								},
								File:   "universe.flux",
								Source: "[A]",
								Start: ast.Position{
									Column: 51,
									Line:   94,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 53,
										Line:   94,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 52,
										Line:   94,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 53,
											Line:   94,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 52,
											Line:   94,
										},
									},
								},
								Name: "A",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   95,
					},
					File:   "universe.flux",
					Source: "builtin mode",
					Start: ast.Position{
						Column: 1,
						Line:   95,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   95,
						},
						File:   "universe.flux",
						Source: "mode",
						Start: ast.Position{
							Column: 9,
							Line:   95,
						},
					},
				},
				Name: "mode",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 99,
							Line:   95,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], ?column: string) => [{C with _value: B}] where A: Record, C: Record",
						Start: ast.Position{
							Column: 16,
							Line:   95,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 88,
								Line:   95,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 79,
								Line:   95,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 88,
									Line:   95,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 82,
									Line:   95,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 80,
									Line:   95,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 79,
									Line:   95,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 99,
								Line:   95,
							},
							File:   "universe.flux",
							Source: "C: Record",
							Start: ast.Position{
								Column: 90,
								Line:   95,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 99,
									Line:   95,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 93,
									Line:   95,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 91,
									Line:   95,
								},
								File:   "universe.flux",
								Source: "C",
								Start: ast.Position{
									Column: 90,
									Line:   95,
								},
							},
						},
						Name: "C",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 72,
								Line:   95,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], ?column: string) => [{C with _value: B}]",
							Start: ast.Position{
								Column: 16,
								Line:   95,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   95,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 17,
									Line:   95,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   95,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 19,
										Line:   95,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   95,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 27,
										Line:   95,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   95,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 28,
											Line:   95,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   95,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 28,
												Line:   95,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 47,
									Line:   95,
								},
								File:   "universe.flux",
								Source: "?column: string",
								Start: ast.Position{
									Column: 32,
									Line:   95,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 39,
										Line:   95,
									},
									File:   "universe.flux",
									Source: "column",
									Start: ast.Position{
										Column: 33,
										Line:   95,
									},
								},
							},
							Name: "column",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 47,
										Line:   95,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 41,
										Line:   95,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 47,
											Line:   95,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 41,
											Line:   95,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 72,
									Line:   95,
								},
								File:   "universe.flux",
								Source: "[{C with _value: B}]",
								Start: ast.Position{
									Column: 52,
									Line:   95,
								},
							},
						},
						ElementType: &ast.RecordType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 71,
										Line:   95,
									},
									File:   "universe.flux",
									Source: "{C with _value: B}",
									Start: ast.Position{
										Column: 53,
										Line:   95,
									},
								},
							},
							Properties: []*ast.PropertyType{&ast.PropertyType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 70,
											Line:   95,
										},
										File:   "universe.flux",
										Source: "_value: B",
										Start: ast.Position{
											Column: 61,
											Line:   95,
										},
									},
								},
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 67,
												Line:   95,
											},
											File:   "universe.flux",
											Source: "_value",
											Start: ast.Position{
												Column: 61,
												Line:   95,
											},
										},
									},
									Name: "_value",
								},
								Ty: &ast.TvarType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 70,
												Line:   95,
											},
											File:   "universe.flux",
											Source: "B",
											Start: ast.Position{
												Column: 69,
												Line:   95,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 70,
													Line:   95,
												},
												File:   "universe.flux",
												Source: "B",
												Start: ast.Position{
													Column: 69,
													Line:   95,
												},
											},
										},
										Name: "B",
									},
								},
							}},
							Tvar: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 55,
											Line:   95,
										},
										File:   "universe.flux",
										Source: "C",
										Start: ast.Position{
											Column: 54,
											Line:   95,
										},
									},
								},
								Name: "C",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 22,
						Line:   96,
					},
					File:   "universe.flux",
					Source: "builtin movingAverage",
					Start: ast.Position{
						Column: 1,
						Line:   96,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 22,
							Line:   96,
						},
						File:   "universe.flux",
						Source: "movingAverage",
						Start: ast.Position{
							Column: 9,
							Line:   96,
						},
					},
				},
				Name: "movingAverage",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 110,
							Line:   96,
						},
						File:   "universe.flux",
						Source: "(<-tables: [{B with _value: A}], n: int) => [{B with _value: float}] where A: Numeric",
						Start: ast.Position{
							Column: 25,
							Line:   96,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 110,
								Line:   96,
							},
							File:   "universe.flux",
							Source: "A: Numeric",
							Start: ast.Position{
								Column: 100,
								Line:   96,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 110,
									Line:   96,
								},
								File:   "universe.flux",
								Source: "Numeric",
								Start: ast.Position{
									Column: 103,
									Line:   96,
								},
							},
						},
						Name: "Numeric",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 101,
									Line:   96,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 100,
									Line:   96,
								},
							},
						},
						Name: "A",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 93,
								Line:   96,
							},
							File:   "universe.flux",
							Source: "(<-tables: [{B with _value: A}], n: int) => [{B with _value: float}]",
							Start: ast.Position{
								Column: 25,
								Line:   96,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 56,
									Line:   96,
								},
								File:   "universe.flux",
								Source: "<-tables: [{B with _value: A}]",
								Start: ast.Position{
									Column: 26,
									Line:   96,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 34,
										Line:   96,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 28,
										Line:   96,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 56,
										Line:   96,
									},
									File:   "universe.flux",
									Source: "[{B with _value: A}]",
									Start: ast.Position{
										Column: 36,
										Line:   96,
									},
								},
							},
							ElementType: &ast.RecordType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 55,
											Line:   96,
										},
										File:   "universe.flux",
										Source: "{B with _value: A}",
										Start: ast.Position{
											Column: 37,
											Line:   96,
										},
									},
								},
								Properties: []*ast.PropertyType{&ast.PropertyType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 54,
												Line:   96,
											},
											File:   "universe.flux",
											Source: "_value: A",
											Start: ast.Position{
												Column: 45,
												Line:   96,
											},
										},
									},
									Name: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 51,
													Line:   96,
												},
												File:   "universe.flux",
												Source: "_value",
												Start: ast.Position{
													Column: 45,
													Line:   96,
												},
											},
										},
										Name: "_value",
									},
									Ty: &ast.TvarType{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 54,
													Line:   96,
												},
												File:   "universe.flux",
												Source: "A",
												Start: ast.Position{
													Column: 53,
													Line:   96,
												},
											},
										},
										ID: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 54,
														Line:   96,
													},
													File:   "universe.flux",
													Source: "A",
													Start: ast.Position{
														Column: 53,
														Line:   96,
													},
												},
											},
											Name: "A",
										},
									},
								}},
								Tvar: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 39,
												Line:   96,
											},
											File:   "universe.flux",
											Source: "B",
											Start: ast.Position{
												Column: 38,
												Line:   96,
											},
										},
									},
									Name: "B",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 64,
									Line:   96,
								},
								File:   "universe.flux",
								Source: "n: int",
								Start: ast.Position{
									Column: 58,
									Line:   96,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 59,
										Line:   96,
									},
									File:   "universe.flux",
									Source: "n",
									Start: ast.Position{
										Column: 58,
										Line:   96,
									},
								},
							},
							Name: "n",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 64,
										Line:   96,
									},
									File:   "universe.flux",
									Source: "int",
									Start: ast.Position{
										Column: 61,
										Line:   96,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 64,
											Line:   96,
										},
										File:   "universe.flux",
										Source: "int",
										Start: ast.Position{
											Column: 61,
											Line:   96,
										},
									},
								},
								Name: "int",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 93,
									Line:   96,
								},
								File:   "universe.flux",
								Source: "[{B with _value: float}]",
								Start: ast.Position{
									Column: 69,
									Line:   96,
								},
							},
						},
						ElementType: &ast.RecordType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 92,
										Line:   96,
									},
									File:   "universe.flux",
									Source: "{B with _value: float}",
									Start: ast.Position{
										Column: 70,
										Line:   96,
									},
								},
							},
							Properties: []*ast.PropertyType{&ast.PropertyType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 91,
											Line:   96,
										},
										File:   "universe.flux",
										Source: "_value: float",
										Start: ast.Position{
											Column: 78,
											Line:   96,
										},
									},
								},
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 84,
												Line:   96,
											},
											File:   "universe.flux",
											Source: "_value",
											Start: ast.Position{
												Column: 78,
												Line:   96,
											},
										},
									},
									Name: "_value",
								},
								Ty: &ast.NamedType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 91,
												Line:   96,
											},
											File:   "universe.flux",
											Source: "float",
											Start: ast.Position{
												Column: 86,
												Line:   96,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 91,
													Line:   96,
												},
												File:   "universe.flux",
												Source: "float",
												Start: ast.Position{
													Column: 86,
													Line:   96,
												},
											},
										},
										Name: "float",
									},
								},
							}},
							Tvar: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 72,
											Line:   96,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 71,
											Line:   96,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   97,
					},
					File:   "universe.flux",
					Source: "builtin quantile",
					Start: ast.Position{
						Column: 1,
						Line:   97,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   97,
						},
						File:   "universe.flux",
						Source: "quantile",
						Start: ast.Position{
							Column: 9,
							Line:   97,
						},
					},
				},
				Name: "quantile",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   104,
						},
						File:   "universe.flux",
						Source: "(\n    <-tables: [A],\n    ?column: string,\n    q: float,\n    ?compression: float,\n    ?method: string,\n) => [A] where\n    A: Record",
						Start: ast.Position{
							Column: 20,
							Line:   97,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   104,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 5,
								Line:   104,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   104,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 8,
									Line:   104,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   104,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 5,
									Line:   104,
								},
							},
						},
						Name: "A",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 9,
								Line:   103,
							},
							File:   "universe.flux",
							Source: "(\n    <-tables: [A],\n    ?column: string,\n    q: float,\n    ?compression: float,\n    ?method: string,\n) => [A]",
							Start: ast.Position{
								Column: 20,
								Line:   97,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 18,
									Line:   98,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 5,
									Line:   98,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   98,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 7,
										Line:   98,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   98,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 15,
										Line:   98,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 17,
											Line:   98,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 16,
											Line:   98,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   98,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 16,
												Line:   98,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   99,
								},
								File:   "universe.flux",
								Source: "?column: string",
								Start: ast.Position{
									Column: 5,
									Line:   99,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   99,
									},
									File:   "universe.flux",
									Source: "column",
									Start: ast.Position{
										Column: 6,
										Line:   99,
									},
								},
							},
							Name: "column",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 20,
										Line:   99,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 14,
										Line:   99,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 20,
											Line:   99,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 14,
											Line:   99,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 13,
									Line:   100,
								},
								File:   "universe.flux",
								Source: "q: float",
								Start: ast.Position{
									Column: 5,
									Line:   100,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   100,
									},
									File:   "universe.flux",
									Source: "q",
									Start: ast.Position{
										Column: 5,
										Line:   100,
									},
								},
							},
							Name: "q",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   100,
									},
									File:   "universe.flux",
									Source: "float",
									Start: ast.Position{
										Column: 8,
										Line:   100,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   100,
										},
										File:   "universe.flux",
										Source: "float",
										Start: ast.Position{
											Column: 8,
											Line:   100,
										},
									},
								},
								Name: "float",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 24,
									Line:   101,
								},
								File:   "universe.flux",
								Source: "?compression: float",
								Start: ast.Position{
									Column: 5,
									Line:   101,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 17,
										Line:   101,
									},
									File:   "universe.flux",
									Source: "compression",
									Start: ast.Position{
										Column: 6,
										Line:   101,
									},
								},
							},
							Name: "compression",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 24,
										Line:   101,
									},
									File:   "universe.flux",
									Source: "float",
									Start: ast.Position{
										Column: 19,
										Line:   101,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 24,
											Line:   101,
										},
										File:   "universe.flux",
										Source: "float",
										Start: ast.Position{
											Column: 19,
											Line:   101,
										},
									},
								},
								Name: "float",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   102,
								},
								File:   "universe.flux",
								Source: "?method: string",
								Start: ast.Position{
									Column: 5,
									Line:   102,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   102,
									},
									File:   "universe.flux",
									Source: "method",
									Start: ast.Position{
										Column: 6,
										Line:   102,
									},
								},
							},
							Name: "method",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 20,
										Line:   102,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 14,
										Line:   102,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 20,
											Line:   102,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 14,
											Line:   102,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 9,
									Line:   103,
								},
								File:   "universe.flux",
								Source: "[A]",
								Start: ast.Position{
									Column: 6,
									Line:   103,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 8,
										Line:   103,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 7,
										Line:   103,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 8,
											Line:   103,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 7,
											Line:   103,
										},
									},
								},
								Name: "A",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   105,
					},
					File:   "universe.flux",
					Source: "builtin pivot",
					Start: ast.Position{
						Column: 1,
						Line:   105,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   105,
						},
						File:   "universe.flux",
						Source: "pivot",
						Start: ast.Position{
							Column: 9,
							Line:   105,
						},
					},
				},
				Name: "pivot",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 126,
							Line:   105,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], rowKey: [string], columnKey: [string], valueColumn: string) => [B] where A: Record, B: Record",
						Start: ast.Position{
							Column: 17,
							Line:   105,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 115,
								Line:   105,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 106,
								Line:   105,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 115,
									Line:   105,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 109,
									Line:   105,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 107,
									Line:   105,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 106,
									Line:   105,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 126,
								Line:   105,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 117,
								Line:   105,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 126,
									Line:   105,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 120,
									Line:   105,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 118,
									Line:   105,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 117,
									Line:   105,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 99,
								Line:   105,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], rowKey: [string], columnKey: [string], valueColumn: string) => [B]",
							Start: ast.Position{
								Column: 17,
								Line:   105,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 31,
									Line:   105,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 18,
									Line:   105,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 26,
										Line:   105,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 20,
										Line:   105,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   105,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 28,
										Line:   105,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   105,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 29,
											Line:   105,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 30,
												Line:   105,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 29,
												Line:   105,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 49,
									Line:   105,
								},
								File:   "universe.flux",
								Source: "rowKey: [string]",
								Start: ast.Position{
									Column: 33,
									Line:   105,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 39,
										Line:   105,
									},
									File:   "universe.flux",
									Source: "rowKey",
									Start: ast.Position{
										Column: 33,
										Line:   105,
									},
								},
							},
							Name: "rowKey",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 49,
										Line:   105,
									},
									File:   "universe.flux",
									Source: "[string]",
									Start: ast.Position{
										Column: 41,
										Line:   105,
									},
								},
							},
							ElementType: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 48,
											Line:   105,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 42,
											Line:   105,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 48,
												Line:   105,
											},
											File:   "universe.flux",
											Source: "string",
											Start: ast.Position{
												Column: 42,
												Line:   105,
											},
										},
									},
									Name: "string",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 70,
									Line:   105,
								},
								File:   "universe.flux",
								Source: "columnKey: [string]",
								Start: ast.Position{
									Column: 51,
									Line:   105,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 60,
										Line:   105,
									},
									File:   "universe.flux",
									Source: "columnKey",
									Start: ast.Position{
										Column: 51,
										Line:   105,
									},
								},
							},
							Name: "columnKey",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 70,
										Line:   105,
									},
									File:   "universe.flux",
									Source: "[string]",
									Start: ast.Position{
										Column: 62,
										Line:   105,
									},
								},
							},
							ElementType: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 69,
											Line:   105,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 63,
											Line:   105,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 69,
												Line:   105,
											},
											File:   "universe.flux",
											Source: "string",
											Start: ast.Position{
												Column: 63,
												Line:   105,
											},
										},
									},
									Name: "string",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 91,
									Line:   105,
								},
								File:   "universe.flux",
								Source: "valueColumn: string",
								Start: ast.Position{
									Column: 72,
									Line:   105,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 83,
										Line:   105,
									},
									File:   "universe.flux",
									Source: "valueColumn",
									Start: ast.Position{
										Column: 72,
										Line:   105,
									},
								},
							},
							Name: "valueColumn",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 91,
										Line:   105,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 85,
										Line:   105,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 91,
											Line:   105,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 85,
											Line:   105,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 99,
									Line:   105,
								},
								File:   "universe.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 96,
									Line:   105,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 98,
										Line:   105,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 97,
										Line:   105,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 98,
											Line:   105,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 97,
											Line:   105,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   106,
					},
					File:   "universe.flux",
					Source: "builtin range",
					Start: ast.Position{
						Column: 1,
						Line:   106,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   106,
						},
						File:   "universe.flux",
						Source: "range",
						Start: ast.Position{
							Column: 9,
							Line:   106,
						},
					},
				},
				Name: "range",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 3,
							Line:   114,
						},
						File:   "universe.flux",
						Source: "(\n    <-tables: [{A with _time: time}],\n    start: B,\n    ?stop: C,\n) => [{A with\n    _time: time,\n    _start: time,\n    _stop: time,\n}]",
						Start: ast.Position{
							Column: 17,
							Line:   106,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 3,
								Line:   114,
							},
							File:   "universe.flux",
							Source: "(\n    <-tables: [{A with _time: time}],\n    start: B,\n    ?stop: C,\n) => [{A with\n    _time: time,\n    _start: time,\n    _stop: time,\n}]",
							Start: ast.Position{
								Column: 17,
								Line:   106,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 37,
									Line:   107,
								},
								File:   "universe.flux",
								Source: "<-tables: [{A with _time: time}]",
								Start: ast.Position{
									Column: 5,
									Line:   107,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   107,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 7,
										Line:   107,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 37,
										Line:   107,
									},
									File:   "universe.flux",
									Source: "[{A with _time: time}]",
									Start: ast.Position{
										Column: 15,
										Line:   107,
									},
								},
							},
							ElementType: &ast.RecordType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 36,
											Line:   107,
										},
										File:   "universe.flux",
										Source: "{A with _time: time}",
										Start: ast.Position{
											Column: 16,
											Line:   107,
										},
									},
								},
								Properties: []*ast.PropertyType{&ast.PropertyType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 35,
												Line:   107,
											},
											File:   "universe.flux",
											Source: "_time: time",
											Start: ast.Position{
												Column: 24,
												Line:   107,
											},
										},
									},
									Name: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 29,
													Line:   107,
												},
												File:   "universe.flux",
												Source: "_time",
												Start: ast.Position{
													Column: 24,
													Line:   107,
												},
											},
										},
										Name: "_time",
									},
									Ty: &ast.NamedType{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 35,
													Line:   107,
												},
												File:   "universe.flux",
												Source: "time",
												Start: ast.Position{
													Column: 31,
													Line:   107,
												},
											},
										},
										ID: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 35,
														Line:   107,
													},
													File:   "universe.flux",
													Source: "time",
													Start: ast.Position{
														Column: 31,
														Line:   107,
													},
												},
											},
											Name: "time",
										},
									},
								}},
								Tvar: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 18,
												Line:   107,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 17,
												Line:   107,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 13,
									Line:   108,
								},
								File:   "universe.flux",
								Source: "start: B",
								Start: ast.Position{
									Column: 5,
									Line:   108,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 10,
										Line:   108,
									},
									File:   "universe.flux",
									Source: "start",
									Start: ast.Position{
										Column: 5,
										Line:   108,
									},
								},
							},
							Name: "start",
						},
						Ty: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   108,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 12,
										Line:   108,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   108,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 12,
											Line:   108,
										},
									},
								},
								Name: "B",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 13,
									Line:   109,
								},
								File:   "universe.flux",
								Source: "?stop: C",
								Start: ast.Position{
									Column: 5,
									Line:   109,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 10,
										Line:   109,
									},
									File:   "universe.flux",
									Source: "stop",
									Start: ast.Position{
										Column: 6,
										Line:   109,
									},
								},
							},
							Name: "stop",
						},
						Ty: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   109,
									},
									File:   "universe.flux",
									Source: "C",
									Start: ast.Position{
										Column: 12,
										Line:   109,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   109,
										},
										File:   "universe.flux",
										Source: "C",
										Start: ast.Position{
											Column: 12,
											Line:   109,
										},
									},
								},
								Name: "C",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 3,
									Line:   114,
								},
								File:   "universe.flux",
								Source: "[{A with\n    _time: time,\n    _start: time,\n    _stop: time,\n}]",
								Start: ast.Position{
									Column: 6,
									Line:   110,
								},
							},
						},
						ElementType: &ast.RecordType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 2,
										Line:   114,
									},
									File:   "universe.flux",
									Source: "{A with\n    _time: time,\n    _start: time,\n    _stop: time,\n}",
									Start: ast.Position{
										Column: 7,
										Line:   110,
									},
								},
							},
							Properties: []*ast.PropertyType{&ast.PropertyType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 16,
											Line:   111,
										},
										File:   "universe.flux",
										Source: "_time: time",
										Start: ast.Position{
											Column: 5,
											Line:   111,
										},
									},
								},
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 10,
												Line:   111,
											},
											File:   "universe.flux",
											Source: "_time",
											Start: ast.Position{
												Column: 5,
												Line:   111,
											},
										},
									},
									Name: "_time",
								},
								Ty: &ast.NamedType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 16,
												Line:   111,
											},
											File:   "universe.flux",
											Source: "time",
											Start: ast.Position{
												Column: 12,
												Line:   111,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 16,
													Line:   111,
												},
												File:   "universe.flux",
												Source: "time",
												Start: ast.Position{
													Column: 12,
													Line:   111,
												},
											},
										},
										Name: "time",
									},
								},
							}, &ast.PropertyType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 17,
											Line:   112,
										},
										File:   "universe.flux",
										Source: "_start: time",
										Start: ast.Position{
											Column: 5,
											Line:   112,
										},
									},
								},
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   112,
											},
											File:   "universe.flux",
											Source: "_start",
											Start: ast.Position{
												Column: 5,
												Line:   112,
											},
										},
									},
									Name: "_start",
								},
								Ty: &ast.NamedType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   112,
											},
											File:   "universe.flux",
											Source: "time",
											Start: ast.Position{
												Column: 13,
												Line:   112,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 17,
													Line:   112,
												},
												File:   "universe.flux",
												Source: "time",
												Start: ast.Position{
													Column: 13,
													Line:   112,
												},
											},
										},
										Name: "time",
									},
								},
							}, &ast.PropertyType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 16,
											Line:   113,
										},
										File:   "universe.flux",
										Source: "_stop: time",
										Start: ast.Position{
											Column: 5,
											Line:   113,
										},
									},
								},
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 10,
												Line:   113,
											},
											File:   "universe.flux",
											Source: "_stop",
											Start: ast.Position{
												Column: 5,
												Line:   113,
											},
										},
									},
									Name: "_stop",
								},
								Ty: &ast.NamedType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 16,
												Line:   113,
											},
											File:   "universe.flux",
											Source: "time",
											Start: ast.Position{
												Column: 12,
												Line:   113,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 16,
													Line:   113,
												},
												File:   "universe.flux",
												Source: "time",
												Start: ast.Position{
													Column: 12,
													Line:   113,
												},
											},
										},
										Name: "time",
									},
								},
							}},
							Tvar: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 9,
											Line:   110,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 8,
											Line:   110,
										},
									},
								},
								Name: "A",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 15,
						Line:   115,
					},
					File:   "universe.flux",
					Source: "builtin reduce",
					Start: ast.Position{
						Column: 1,
						Line:   115,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   115,
						},
						File:   "universe.flux",
						Source: "reduce",
						Start: ast.Position{
							Column: 9,
							Line:   115,
						},
					},
				},
				Name: "reduce",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 124,
							Line:   115,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], fn: (r: A, accumulator: B) => B, identity: B) => [C] where A: Record, B: Record, C: Record",
						Start: ast.Position{
							Column: 18,
							Line:   115,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 102,
								Line:   115,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 93,
								Line:   115,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 102,
									Line:   115,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 96,
									Line:   115,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 94,
									Line:   115,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 93,
									Line:   115,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 113,
								Line:   115,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 104,
								Line:   115,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 113,
									Line:   115,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 107,
									Line:   115,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 105,
									Line:   115,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 104,
									Line:   115,
								},
							},
						},
						Name: "B",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 124,
								Line:   115,
							},
							File:   "universe.flux",
							Source: "C: Record",
							Start: ast.Position{
								Column: 115,
								Line:   115,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 124,
									Line:   115,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 118,
									Line:   115,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 116,
									Line:   115,
								},
								File:   "universe.flux",
								Source: "C",
								Start: ast.Position{
									Column: 115,
									Line:   115,
								},
							},
						},
						Name: "C",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 86,
								Line:   115,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], fn: (r: A, accumulator: B) => B, identity: B) => [C]",
							Start: ast.Position{
								Column: 18,
								Line:   115,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   115,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 19,
									Line:   115,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 27,
										Line:   115,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 21,
										Line:   115,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 32,
										Line:   115,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 29,
										Line:   115,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 31,
											Line:   115,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 30,
											Line:   115,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 31,
												Line:   115,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 30,
												Line:   115,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 65,
									Line:   115,
								},
								File:   "universe.flux",
								Source: "fn: (r: A, accumulator: B) => B",
								Start: ast.Position{
									Column: 34,
									Line:   115,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 36,
										Line:   115,
									},
									File:   "universe.flux",
									Source: "fn",
									Start: ast.Position{
										Column: 34,
										Line:   115,
									},
								},
							},
							Name: "fn",
						},
						Ty: &ast.FunctionType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 65,
										Line:   115,
									},
									File:   "universe.flux",
									Source: "(r: A, accumulator: B) => B",
									Start: ast.Position{
										Column: 38,
										Line:   115,
									},
								},
							},
							Parameters: []*ast.ParameterType{&ast.ParameterType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   115,
										},
										File:   "universe.flux",
										Source: "r: A",
										Start: ast.Position{
											Column: 39,
											Line:   115,
										},
									},
								},
								Kind: "Required",
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 40,
												Line:   115,
											},
											File:   "universe.flux",
											Source: "r",
											Start: ast.Position{
												Column: 39,
												Line:   115,
											},
										},
									},
									Name: "r",
								},
								Ty: &ast.TvarType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   115,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 42,
												Line:   115,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 43,
													Line:   115,
												},
												File:   "universe.flux",
												Source: "A",
												Start: ast.Position{
													Column: 42,
													Line:   115,
												},
											},
										},
										Name: "A",
									},
								},
							}, &ast.ParameterType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 59,
											Line:   115,
										},
										File:   "universe.flux",
										Source: "accumulator: B",
										Start: ast.Position{
											Column: 45,
											Line:   115,
										},
									},
								},
								Kind: "Required",
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 56,
												Line:   115,
											},
											File:   "universe.flux",
											Source: "accumulator",
											Start: ast.Position{
												Column: 45,
												Line:   115,
											},
										},
									},
									Name: "accumulator",
								},
								Ty: &ast.TvarType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 59,
												Line:   115,
											},
											File:   "universe.flux",
											Source: "B",
											Start: ast.Position{
												Column: 58,
												Line:   115,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 59,
													Line:   115,
												},
												File:   "universe.flux",
												Source: "B",
												Start: ast.Position{
													Column: 58,
													Line:   115,
												},
											},
										},
										Name: "B",
									},
								},
							}},
							Return: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 65,
											Line:   115,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 64,
											Line:   115,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 65,
												Line:   115,
											},
											File:   "universe.flux",
											Source: "B",
											Start: ast.Position{
												Column: 64,
												Line:   115,
											},
										},
									},
									Name: "B",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 78,
									Line:   115,
								},
								File:   "universe.flux",
								Source: "identity: B",
								Start: ast.Position{
									Column: 67,
									Line:   115,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 75,
										Line:   115,
									},
									File:   "universe.flux",
									Source: "identity",
									Start: ast.Position{
										Column: 67,
										Line:   115,
									},
								},
							},
							Name: "identity",
						},
						Ty: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 78,
										Line:   115,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 77,
										Line:   115,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 78,
											Line:   115,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 77,
											Line:   115,
										},
									},
								},
								Name: "B",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 86,
									Line:   115,
								},
								File:   "universe.flux",
								Source: "[C]",
								Start: ast.Position{
									Column: 83,
									Line:   115,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 85,
										Line:   115,
									},
									File:   "universe.flux",
									Source: "C",
									Start: ast.Position{
										Column: 84,
										Line:   115,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 85,
											Line:   115,
										},
										File:   "universe.flux",
										Source: "C",
										Start: ast.Position{
											Column: 84,
											Line:   115,
										},
									},
								},
								Name: "C",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 30,
						Line:   116,
					},
					File:   "universe.flux",
					Source: "builtin relativeStrengthIndex",
					Start: ast.Position{
						Column: 1,
						Line:   116,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 30,
							Line:   116,
						},
						File:   "universe.flux",
						Source: "relativeStrengthIndex",
						Start: ast.Position{
							Column: 9,
							Line:   116,
						},
					},
				},
				Name: "relativeStrengthIndex",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 110,
							Line:   116,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], n: int, ?columns: [string]) => [B] where A: Record, B: Record",
						Start: ast.Position{
							Column: 33,
							Line:   116,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 99,
								Line:   116,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 90,
								Line:   116,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 99,
									Line:   116,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 93,
									Line:   116,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 91,
									Line:   116,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 90,
									Line:   116,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 110,
								Line:   116,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 101,
								Line:   116,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 110,
									Line:   116,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 104,
									Line:   116,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 102,
									Line:   116,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 101,
									Line:   116,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 83,
								Line:   116,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], n: int, ?columns: [string]) => [B]",
							Start: ast.Position{
								Column: 33,
								Line:   116,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 47,
									Line:   116,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 34,
									Line:   116,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   116,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 36,
										Line:   116,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 47,
										Line:   116,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 44,
										Line:   116,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 46,
											Line:   116,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 45,
											Line:   116,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 46,
												Line:   116,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 45,
												Line:   116,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 55,
									Line:   116,
								},
								File:   "universe.flux",
								Source: "n: int",
								Start: ast.Position{
									Column: 49,
									Line:   116,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 50,
										Line:   116,
									},
									File:   "universe.flux",
									Source: "n",
									Start: ast.Position{
										Column: 49,
										Line:   116,
									},
								},
							},
							Name: "n",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 55,
										Line:   116,
									},
									File:   "universe.flux",
									Source: "int",
									Start: ast.Position{
										Column: 52,
										Line:   116,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 55,
											Line:   116,
										},
										File:   "universe.flux",
										Source: "int",
										Start: ast.Position{
											Column: 52,
											Line:   116,
										},
									},
								},
								Name: "int",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 75,
									Line:   116,
								},
								File:   "universe.flux",
								Source: "?columns: [string]",
								Start: ast.Position{
									Column: 57,
									Line:   116,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 65,
										Line:   116,
									},
									File:   "universe.flux",
									Source: "columns",
									Start: ast.Position{
										Column: 58,
										Line:   116,
									},
								},
							},
							Name: "columns",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 75,
										Line:   116,
									},
									File:   "universe.flux",
									Source: "[string]",
									Start: ast.Position{
										Column: 67,
										Line:   116,
									},
								},
							},
							ElementType: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 74,
											Line:   116,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 68,
											Line:   116,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 74,
												Line:   116,
											},
											File:   "universe.flux",
											Source: "string",
											Start: ast.Position{
												Column: 68,
												Line:   116,
											},
										},
									},
									Name: "string",
								},
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 83,
									Line:   116,
								},
								File:   "universe.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 80,
									Line:   116,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 82,
										Line:   116,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 81,
										Line:   116,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 82,
											Line:   116,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 81,
											Line:   116,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 15,
						Line:   117,
					},
					File:   "universe.flux",
					Source: "builtin rename",
					Start: ast.Position{
						Column: 1,
						Line:   117,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   117,
						},
						File:   "universe.flux",
						Source: "rename",
						Start: ast.Position{
							Column: 9,
							Line:   117,
						},
					},
				},
				Name: "rename",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 124,
							Line:   117,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], ?fn: (column: string) => string, ?columns: B) => [C] where A: Record, B: Record, C: Record",
						Start: ast.Position{
							Column: 18,
							Line:   117,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 102,
								Line:   117,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 93,
								Line:   117,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 102,
									Line:   117,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 96,
									Line:   117,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 94,
									Line:   117,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 93,
									Line:   117,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 113,
								Line:   117,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 104,
								Line:   117,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 113,
									Line:   117,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 107,
									Line:   117,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 105,
									Line:   117,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 104,
									Line:   117,
								},
							},
						},
						Name: "B",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 124,
								Line:   117,
							},
							File:   "universe.flux",
							Source: "C: Record",
							Start: ast.Position{
								Column: 115,
								Line:   117,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 124,
									Line:   117,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 118,
									Line:   117,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 116,
									Line:   117,
								},
								File:   "universe.flux",
								Source: "C",
								Start: ast.Position{
									Column: 115,
									Line:   117,
								},
							},
						},
						Name: "C",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 86,
								Line:   117,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], ?fn: (column: string) => string, ?columns: B) => [C]",
							Start: ast.Position{
								Column: 18,
								Line:   117,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   117,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 19,
									Line:   117,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 27,
										Line:   117,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 21,
										Line:   117,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 32,
										Line:   117,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 29,
										Line:   117,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 31,
											Line:   117,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 30,
											Line:   117,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 31,
												Line:   117,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 30,
												Line:   117,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 65,
									Line:   117,
								},
								File:   "universe.flux",
								Source: "?fn: (column: string) => string",
								Start: ast.Position{
									Column: 34,
									Line:   117,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 37,
										Line:   117,
									},
									File:   "universe.flux",
									Source: "fn",
									Start: ast.Position{
										Column: 35,
										Line:   117,
									},
								},
							},
							Name: "fn",
						},
						Ty: &ast.FunctionType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 65,
										Line:   117,
									},
									File:   "universe.flux",
									Source: "(column: string) => string",
									Start: ast.Position{
										Column: 39,
										Line:   117,
									},
								},
							},
							Parameters: []*ast.ParameterType{&ast.ParameterType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 54,
											Line:   117,
										},
										File:   "universe.flux",
										Source: "column: string",
										Start: ast.Position{
											Column: 40,
											Line:   117,
										},
									},
								},
								Kind: "Required",
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 46,
												Line:   117,
											},
											File:   "universe.flux",
											Source: "column",
											Start: ast.Position{
												Column: 40,
												Line:   117,
											},
										},
									},
									Name: "column",
								},
								Ty: &ast.NamedType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 54,
												Line:   117,
											},
											File:   "universe.flux",
											Source: "string",
											Start: ast.Position{
												Column: 48,
												Line:   117,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 54,
													Line:   117,
												},
												File:   "universe.flux",
												Source: "string",
												Start: ast.Position{
													Column: 48,
													Line:   117,
												},
											},
										},
										Name: "string",
									},
								},
							}},
							Return: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 65,
											Line:   117,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 59,
											Line:   117,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 65,
												Line:   117,
											},
											File:   "universe.flux",
											Source: "string",
											Start: ast.Position{
												Column: 59,
												Line:   117,
											},
										},
									},
									Name: "string",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 78,
									Line:   117,
								},
								File:   "universe.flux",
								Source: "?columns: B",
								Start: ast.Position{
									Column: 67,
									Line:   117,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 75,
										Line:   117,
									},
									File:   "universe.flux",
									Source: "columns",
									Start: ast.Position{
										Column: 68,
										Line:   117,
									},
								},
							},
							Name: "columns",
						},
						Ty: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 78,
										Line:   117,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 77,
										Line:   117,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 78,
											Line:   117,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 77,
											Line:   117,
										},
									},
								},
								Name: "B",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 86,
									Line:   117,
								},
								File:   "universe.flux",
								Source: "[C]",
								Start: ast.Position{
									Column: 83,
									Line:   117,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 85,
										Line:   117,
									},
									File:   "universe.flux",
									Source: "C",
									Start: ast.Position{
										Column: 84,
										Line:   117,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 85,
											Line:   117,
										},
										File:   "universe.flux",
										Source: "C",
										Start: ast.Position{
											Column: 84,
											Line:   117,
										},
									},
								},
								Name: "C",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 15,
						Line:   118,
					},
					File:   "universe.flux",
					Source: "builtin sample",
					Start: ast.Position{
						Column: 1,
						Line:   118,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   118,
						},
						File:   "universe.flux",
						Source: "sample",
						Start: ast.Position{
							Column: 9,
							Line:   118,
						},
					},
				},
				Name: "sample",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 92,
							Line:   118,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], n: int, ?pos: int, ?column: string) => [A] where A: Record",
						Start: ast.Position{
							Column: 18,
							Line:   118,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 92,
								Line:   118,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 83,
								Line:   118,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 92,
									Line:   118,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 86,
									Line:   118,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 84,
									Line:   118,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 83,
									Line:   118,
								},
							},
						},
						Name: "A",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 76,
								Line:   118,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], n: int, ?pos: int, ?column: string) => [A]",
							Start: ast.Position{
								Column: 18,
								Line:   118,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   118,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 19,
									Line:   118,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 27,
										Line:   118,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 21,
										Line:   118,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 32,
										Line:   118,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 29,
										Line:   118,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 31,
											Line:   118,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 30,
											Line:   118,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 31,
												Line:   118,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 30,
												Line:   118,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   118,
								},
								File:   "universe.flux",
								Source: "n: int",
								Start: ast.Position{
									Column: 34,
									Line:   118,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 35,
										Line:   118,
									},
									File:   "universe.flux",
									Source: "n",
									Start: ast.Position{
										Column: 34,
										Line:   118,
									},
								},
							},
							Name: "n",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   118,
									},
									File:   "universe.flux",
									Source: "int",
									Start: ast.Position{
										Column: 37,
										Line:   118,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   118,
										},
										File:   "universe.flux",
										Source: "int",
										Start: ast.Position{
											Column: 37,
											Line:   118,
										},
									},
								},
								Name: "int",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 51,
									Line:   118,
								},
								File:   "universe.flux",
								Source: "?pos: int",
								Start: ast.Position{
									Column: 42,
									Line:   118,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 46,
										Line:   118,
									},
									File:   "universe.flux",
									Source: "pos",
									Start: ast.Position{
										Column: 43,
										Line:   118,
									},
								},
							},
							Name: "pos",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 51,
										Line:   118,
									},
									File:   "universe.flux",
									Source: "int",
									Start: ast.Position{
										Column: 48,
										Line:   118,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 51,
											Line:   118,
										},
										File:   "universe.flux",
										Source: "int",
										Start: ast.Position{
											Column: 48,
											Line:   118,
										},
									},
								},
								Name: "int",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 68,
									Line:   118,
								},
								File:   "universe.flux",
								Source: "?column: string",
								Start: ast.Position{
									Column: 53,
									Line:   118,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 60,
										Line:   118,
									},
									File:   "universe.flux",
									Source: "column",
									Start: ast.Position{
										Column: 54,
										Line:   118,
									},
								},
							},
							Name: "column",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 68,
										Line:   118,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 62,
										Line:   118,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 68,
											Line:   118,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 62,
											Line:   118,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 76,
									Line:   118,
								},
								File:   "universe.flux",
								Source: "[A]",
								Start: ast.Position{
									Column: 73,
									Line:   118,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 75,
										Line:   118,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 74,
										Line:   118,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 75,
											Line:   118,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 74,
											Line:   118,
										},
									},
								},
								Name: "A",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 12,
						Line:   119,
					},
					File:   "universe.flux",
					Source: "builtin set",
					Start: ast.Position{
						Column: 1,
						Line:   119,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   119,
						},
						File:   "universe.flux",
						Source: "set",
						Start: ast.Position{
							Column: 9,
							Line:   119,
						},
					},
				},
				Name: "set",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 81,
							Line:   119,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], key: string, value: string) => [A] where A: Record",
						Start: ast.Position{
							Column: 15,
							Line:   119,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 81,
								Line:   119,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 72,
								Line:   119,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 81,
									Line:   119,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 75,
									Line:   119,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 73,
									Line:   119,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 72,
									Line:   119,
								},
							},
						},
						Name: "A",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 65,
								Line:   119,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], key: string, value: string) => [A]",
							Start: ast.Position{
								Column: 15,
								Line:   119,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 29,
									Line:   119,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 16,
									Line:   119,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 24,
										Line:   119,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 18,
										Line:   119,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   119,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 26,
										Line:   119,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 28,
											Line:   119,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 27,
											Line:   119,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 28,
												Line:   119,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 27,
												Line:   119,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   119,
								},
								File:   "universe.flux",
								Source: "key: string",
								Start: ast.Position{
									Column: 31,
									Line:   119,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 34,
										Line:   119,
									},
									File:   "universe.flux",
									Source: "key",
									Start: ast.Position{
										Column: 31,
										Line:   119,
									},
								},
							},
							Name: "key",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   119,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 36,
										Line:   119,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 42,
											Line:   119,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 36,
											Line:   119,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 57,
									Line:   119,
								},
								File:   "universe.flux",
								Source: "value: string",
								Start: ast.Position{
									Column: 44,
									Line:   119,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 49,
										Line:   119,
									},
									File:   "universe.flux",
									Source: "value",
									Start: ast.Position{
										Column: 44,
										Line:   119,
									},
								},
							},
							Name: "value",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 57,
										Line:   119,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 51,
										Line:   119,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 57,
											Line:   119,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 51,
											Line:   119,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 65,
									Line:   119,
								},
								File:   "universe.flux",
								Source: "[A]",
								Start: ast.Position{
									Column: 62,
									Line:   119,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 64,
										Line:   119,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 63,
										Line:   119,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 64,
											Line:   119,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 63,
											Line:   119,
										},
									},
								},
								Name: "A",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   120,
					},
					File:   "universe.flux",
					Source: "builtin tail",
					Start: ast.Position{
						Column: 1,
						Line:   120,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   120,
						},
						File:   "universe.flux",
						Source: "tail",
						Start: ast.Position{
							Column: 9,
							Line:   120,
						},
					},
				},
				Name: "tail",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 60,
							Line:   120,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], n: int, ?offset: int) => [A]",
						Start: ast.Position{
							Column: 16,
							Line:   120,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 60,
								Line:   120,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], n: int, ?offset: int) => [A]",
							Start: ast.Position{
								Column: 16,
								Line:   120,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   120,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 17,
									Line:   120,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   120,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 19,
										Line:   120,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   120,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 27,
										Line:   120,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   120,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 28,
											Line:   120,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   120,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 28,
												Line:   120,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 38,
									Line:   120,
								},
								File:   "universe.flux",
								Source: "n: int",
								Start: ast.Position{
									Column: 32,
									Line:   120,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 33,
										Line:   120,
									},
									File:   "universe.flux",
									Source: "n",
									Start: ast.Position{
										Column: 32,
										Line:   120,
									},
								},
							},
							Name: "n",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 38,
										Line:   120,
									},
									File:   "universe.flux",
									Source: "int",
									Start: ast.Position{
										Column: 35,
										Line:   120,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 38,
											Line:   120,
										},
										File:   "universe.flux",
										Source: "int",
										Start: ast.Position{
											Column: 35,
											Line:   120,
										},
									},
								},
								Name: "int",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 52,
									Line:   120,
								},
								File:   "universe.flux",
								Source: "?offset: int",
								Start: ast.Position{
									Column: 40,
									Line:   120,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 47,
										Line:   120,
									},
									File:   "universe.flux",
									Source: "offset",
									Start: ast.Position{
										Column: 41,
										Line:   120,
									},
								},
							},
							Name: "offset",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 52,
										Line:   120,
									},
									File:   "universe.flux",
									Source: "int",
									Start: ast.Position{
										Column: 49,
										Line:   120,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 52,
											Line:   120,
										},
										File:   "universe.flux",
										Source: "int",
										Start: ast.Position{
											Column: 49,
											Line:   120,
										},
									},
								},
								Name: "int",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 60,
									Line:   120,
								},
								File:   "universe.flux",
								Source: "[A]",
								Start: ast.Position{
									Column: 57,
									Line:   120,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 59,
										Line:   120,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 58,
										Line:   120,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 59,
											Line:   120,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 58,
											Line:   120,
										},
									},
								},
								Name: "A",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   121,
					},
					File:   "universe.flux",
					Source: "builtin timeShift",
					Start: ast.Position{
						Column: 1,
						Line:   121,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   121,
						},
						File:   "universe.flux",
						Source: "timeShift",
						Start: ast.Position{
							Column: 9,
							Line:   121,
						},
					},
				},
				Name: "timeShift",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 83,
							Line:   121,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], duration: duration, ?columns: [string]) => [A]",
						Start: ast.Position{
							Column: 21,
							Line:   121,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 83,
								Line:   121,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], duration: duration, ?columns: [string]) => [A]",
							Start: ast.Position{
								Column: 21,
								Line:   121,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 35,
									Line:   121,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 22,
									Line:   121,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   121,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 24,
										Line:   121,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 35,
										Line:   121,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 32,
										Line:   121,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 34,
											Line:   121,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 33,
											Line:   121,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 34,
												Line:   121,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 33,
												Line:   121,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 55,
									Line:   121,
								},
								File:   "universe.flux",
								Source: "duration: duration",
								Start: ast.Position{
									Column: 37,
									Line:   121,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 45,
										Line:   121,
									},
									File:   "universe.flux",
									Source: "duration",
									Start: ast.Position{
										Column: 37,
										Line:   121,
									},
								},
							},
							Name: "duration",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 55,
										Line:   121,
									},
									File:   "universe.flux",
									Source: "duration",
									Start: ast.Position{
										Column: 47,
										Line:   121,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 55,
											Line:   121,
										},
										File:   "universe.flux",
										Source: "duration",
										Start: ast.Position{
											Column: 47,
											Line:   121,
										},
									},
								},
								Name: "duration",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 75,
									Line:   121,
								},
								File:   "universe.flux",
								Source: "?columns: [string]",
								Start: ast.Position{
									Column: 57,
									Line:   121,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 65,
										Line:   121,
									},
									File:   "universe.flux",
									Source: "columns",
									Start: ast.Position{
										Column: 58,
										Line:   121,
									},
								},
							},
							Name: "columns",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 75,
										Line:   121,
									},
									File:   "universe.flux",
									Source: "[string]",
									Start: ast.Position{
										Column: 67,
										Line:   121,
									},
								},
							},
							ElementType: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 74,
											Line:   121,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 68,
											Line:   121,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 74,
												Line:   121,
											},
											File:   "universe.flux",
											Source: "string",
											Start: ast.Position{
												Column: 68,
												Line:   121,
											},
										},
									},
									Name: "string",
								},
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 83,
									Line:   121,
								},
								File:   "universe.flux",
								Source: "[A]",
								Start: ast.Position{
									Column: 80,
									Line:   121,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 82,
										Line:   121,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 81,
										Line:   121,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 82,
											Line:   121,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 81,
											Line:   121,
										},
									},
								},
								Name: "A",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   122,
					},
					File:   "universe.flux",
					Source: "builtin skew",
					Start: ast.Position{
						Column: 1,
						Line:   122,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   122,
						},
						File:   "universe.flux",
						Source: "skew",
						Start: ast.Position{
							Column: 9,
							Line:   122,
						},
					},
				},
				Name: "skew",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 82,
							Line:   122,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], ?column: string) => [B] where A: Record, B: Record",
						Start: ast.Position{
							Column: 16,
							Line:   122,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 71,
								Line:   122,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 62,
								Line:   122,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 71,
									Line:   122,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 65,
									Line:   122,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 63,
									Line:   122,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 62,
									Line:   122,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 82,
								Line:   122,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 73,
								Line:   122,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 82,
									Line:   122,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 76,
									Line:   122,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 74,
									Line:   122,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 73,
									Line:   122,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 55,
								Line:   122,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], ?column: string) => [B]",
							Start: ast.Position{
								Column: 16,
								Line:   122,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   122,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 17,
									Line:   122,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   122,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 19,
										Line:   122,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   122,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 27,
										Line:   122,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   122,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 28,
											Line:   122,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   122,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 28,
												Line:   122,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 47,
									Line:   122,
								},
								File:   "universe.flux",
								Source: "?column: string",
								Start: ast.Position{
									Column: 32,
									Line:   122,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 39,
										Line:   122,
									},
									File:   "universe.flux",
									Source: "column",
									Start: ast.Position{
										Column: 33,
										Line:   122,
									},
								},
							},
							Name: "column",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 47,
										Line:   122,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 41,
										Line:   122,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 47,
											Line:   122,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 41,
											Line:   122,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 55,
									Line:   122,
								},
								File:   "universe.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 52,
									Line:   122,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 54,
										Line:   122,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 53,
										Line:   122,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 54,
											Line:   122,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 53,
											Line:   122,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 15,
						Line:   123,
					},
					File:   "universe.flux",
					Source: "builtin spread",
					Start: ast.Position{
						Column: 1,
						Line:   123,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   123,
						},
						File:   "universe.flux",
						Source: "spread",
						Start: ast.Position{
							Column: 9,
							Line:   123,
						},
					},
				},
				Name: "spread",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 84,
							Line:   123,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], ?column: string) => [B] where A: Record, B: Record",
						Start: ast.Position{
							Column: 18,
							Line:   123,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 73,
								Line:   123,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 64,
								Line:   123,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 73,
									Line:   123,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 67,
									Line:   123,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 65,
									Line:   123,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 64,
									Line:   123,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 84,
								Line:   123,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 75,
								Line:   123,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 84,
									Line:   123,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 78,
									Line:   123,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 76,
									Line:   123,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 75,
									Line:   123,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 57,
								Line:   123,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], ?column: string) => [B]",
							Start: ast.Position{
								Column: 18,
								Line:   123,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   123,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 19,
									Line:   123,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 27,
										Line:   123,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 21,
										Line:   123,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 32,
										Line:   123,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 29,
										Line:   123,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 31,
											Line:   123,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 30,
											Line:   123,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 31,
												Line:   123,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 30,
												Line:   123,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 49,
									Line:   123,
								},
								File:   "universe.flux",
								Source: "?column: string",
								Start: ast.Position{
									Column: 34,
									Line:   123,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   123,
									},
									File:   "universe.flux",
									Source: "column",
									Start: ast.Position{
										Column: 35,
										Line:   123,
									},
								},
							},
							Name: "column",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 49,
										Line:   123,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 43,
										Line:   123,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 49,
											Line:   123,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 43,
											Line:   123,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 57,
									Line:   123,
								},
								File:   "universe.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 54,
									Line:   123,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 56,
										Line:   123,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 55,
										Line:   123,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 56,
											Line:   123,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 55,
											Line:   123,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   124,
					},
					File:   "universe.flux",
					Source: "builtin sort",
					Start: ast.Position{
						Column: 1,
						Line:   124,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   124,
						},
						File:   "universe.flux",
						Source: "sort",
						Start: ast.Position{
							Column: 9,
							Line:   124,
						},
					},
				},
				Name: "sort",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 87,
							Line:   124,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], ?columns: [string], ?desc: bool) => [A] where A: Record",
						Start: ast.Position{
							Column: 16,
							Line:   124,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 87,
								Line:   124,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 78,
								Line:   124,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 87,
									Line:   124,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 81,
									Line:   124,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 79,
									Line:   124,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 78,
									Line:   124,
								},
							},
						},
						Name: "A",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 71,
								Line:   124,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], ?columns: [string], ?desc: bool) => [A]",
							Start: ast.Position{
								Column: 16,
								Line:   124,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   124,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 17,
									Line:   124,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   124,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 19,
										Line:   124,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   124,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 27,
										Line:   124,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   124,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 28,
											Line:   124,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   124,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 28,
												Line:   124,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 50,
									Line:   124,
								},
								File:   "universe.flux",
								Source: "?columns: [string]",
								Start: ast.Position{
									Column: 32,
									Line:   124,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   124,
									},
									File:   "universe.flux",
									Source: "columns",
									Start: ast.Position{
										Column: 33,
										Line:   124,
									},
								},
							},
							Name: "columns",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 50,
										Line:   124,
									},
									File:   "universe.flux",
									Source: "[string]",
									Start: ast.Position{
										Column: 42,
										Line:   124,
									},
								},
							},
							ElementType: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 49,
											Line:   124,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 43,
											Line:   124,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   124,
											},
											File:   "universe.flux",
											Source: "string",
											Start: ast.Position{
												Column: 43,
												Line:   124,
											},
										},
									},
									Name: "string",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 63,
									Line:   124,
								},
								File:   "universe.flux",
								Source: "?desc: bool",
								Start: ast.Position{
									Column: 52,
									Line:   124,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 57,
										Line:   124,
									},
									File:   "universe.flux",
									Source: "desc",
									Start: ast.Position{
										Column: 53,
										Line:   124,
									},
								},
							},
							Name: "desc",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 63,
										Line:   124,
									},
									File:   "universe.flux",
									Source: "bool",
									Start: ast.Position{
										Column: 59,
										Line:   124,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 63,
											Line:   124,
										},
										File:   "universe.flux",
										Source: "bool",
										Start: ast.Position{
											Column: 59,
											Line:   124,
										},
									},
								},
								Name: "bool",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 71,
									Line:   124,
								},
								File:   "universe.flux",
								Source: "[A]",
								Start: ast.Position{
									Column: 68,
									Line:   124,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 70,
										Line:   124,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 69,
										Line:   124,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 70,
											Line:   124,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 69,
											Line:   124,
										},
									},
								},
								Name: "A",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 22,
						Line:   125,
					},
					File:   "universe.flux",
					Source: "builtin stateTracking",
					Start: ast.Position{
						Column: 1,
						Line:   125,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 22,
							Line:   125,
						},
						File:   "universe.flux",
						Source: "stateTracking",
						Start: ast.Position{
							Column: 9,
							Line:   125,
						},
					},
				},
				Name: "stateTracking",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   134,
						},
						File:   "universe.flux",
						Source: "(\n    <-tables: [A],\n    fn: (r: A) => bool,\n    ?countColumn: string,\n    ?durationColumn: string,\n    ?durationUnit: duration,\n    ?timeColumn: string,\n) => [B] where\n    A: Record,\n    B: Record",
						Start: ast.Position{
							Column: 25,
							Line:   125,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   133,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 5,
								Line:   133,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   133,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 8,
									Line:   133,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   133,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 5,
									Line:   133,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   134,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 5,
								Line:   134,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   134,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 8,
									Line:   134,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   134,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 5,
									Line:   134,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 9,
								Line:   132,
							},
							File:   "universe.flux",
							Source: "(\n    <-tables: [A],\n    fn: (r: A) => bool,\n    ?countColumn: string,\n    ?durationColumn: string,\n    ?durationUnit: duration,\n    ?timeColumn: string,\n) => [B]",
							Start: ast.Position{
								Column: 25,
								Line:   125,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 18,
									Line:   126,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 5,
									Line:   126,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   126,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 7,
										Line:   126,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   126,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 15,
										Line:   126,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 17,
											Line:   126,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 16,
											Line:   126,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   126,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 16,
												Line:   126,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 23,
									Line:   127,
								},
								File:   "universe.flux",
								Source: "fn: (r: A) => bool",
								Start: ast.Position{
									Column: 5,
									Line:   127,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 7,
										Line:   127,
									},
									File:   "universe.flux",
									Source: "fn",
									Start: ast.Position{
										Column: 5,
										Line:   127,
									},
								},
							},
							Name: "fn",
						},
						Ty: &ast.FunctionType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 23,
										Line:   127,
									},
									File:   "universe.flux",
									Source: "(r: A) => bool",
									Start: ast.Position{
										Column: 9,
										Line:   127,
									},
								},
							},
							Parameters: []*ast.ParameterType{&ast.ParameterType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 14,
											Line:   127,
										},
										File:   "universe.flux",
										Source: "r: A",
										Start: ast.Position{
											Column: 10,
											Line:   127,
										},
									},
								},
								Kind: "Required",
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   127,
											},
											File:   "universe.flux",
											Source: "r",
											Start: ast.Position{
												Column: 10,
												Line:   127,
											},
										},
									},
									Name: "r",
								},
								Ty: &ast.TvarType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   127,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 13,
												Line:   127,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 14,
													Line:   127,
												},
												File:   "universe.flux",
												Source: "A",
												Start: ast.Position{
													Column: 13,
													Line:   127,
												},
											},
										},
										Name: "A",
									},
								},
							}},
							Return: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 23,
											Line:   127,
										},
										File:   "universe.flux",
										Source: "bool",
										Start: ast.Position{
											Column: 19,
											Line:   127,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 23,
												Line:   127,
											},
											File:   "universe.flux",
											Source: "bool",
											Start: ast.Position{
												Column: 19,
												Line:   127,
											},
										},
									},
									Name: "bool",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   128,
								},
								File:   "universe.flux",
								Source: "?countColumn: string",
								Start: ast.Position{
									Column: 5,
									Line:   128,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 17,
										Line:   128,
									},
									File:   "universe.flux",
									Source: "countColumn",
									Start: ast.Position{
										Column: 6,
										Line:   128,
									},
								},
							},
							Name: "countColumn",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   128,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 19,
										Line:   128,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 25,
											Line:   128,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 19,
											Line:   128,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 28,
									Line:   129,
								},
								File:   "universe.flux",
								Source: "?durationColumn: string",
								Start: ast.Position{
									Column: 5,
									Line:   129,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 20,
										Line:   129,
									},
									File:   "universe.flux",
									Source: "durationColumn",
									Start: ast.Position{
										Column: 6,
										Line:   129,
									},
								},
							},
							Name: "durationColumn",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 28,
										Line:   129,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 22,
										Line:   129,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 28,
											Line:   129,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 22,
											Line:   129,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 28,
									Line:   130,
								},
								File:   "universe.flux",
								Source: "?durationUnit: duration",
								Start: ast.Position{
									Column: 5,
									Line:   130,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   130,
									},
									File:   "universe.flux",
									Source: "durationUnit",
									Start: ast.Position{
										Column: 6,
										Line:   130,
									},
								},
							},
							Name: "durationUnit",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 28,
										Line:   130,
									},
									File:   "universe.flux",
									Source: "duration",
									Start: ast.Position{
										Column: 20,
										Line:   130,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 28,
											Line:   130,
										},
										File:   "universe.flux",
										Source: "duration",
										Start: ast.Position{
											Column: 20,
											Line:   130,
										},
									},
								},
								Name: "duration",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 24,
									Line:   131,
								},
								File:   "universe.flux",
								Source: "?timeColumn: string",
								Start: ast.Position{
									Column: 5,
									Line:   131,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 16,
										Line:   131,
									},
									File:   "universe.flux",
									Source: "timeColumn",
									Start: ast.Position{
										Column: 6,
										Line:   131,
									},
								},
							},
							Name: "timeColumn",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 24,
										Line:   131,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 18,
										Line:   131,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 24,
											Line:   131,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 18,
											Line:   131,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 9,
									Line:   132,
								},
								File:   "universe.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 6,
									Line:   132,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 8,
										Line:   132,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 7,
										Line:   132,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 8,
											Line:   132,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 7,
											Line:   132,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 15,
						Line:   135,
					},
					File:   "universe.flux",
					Source: "builtin stddev",
					Start: ast.Position{
						Column: 1,
						Line:   135,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   135,
						},
						File:   "universe.flux",
						Source: "stddev",
						Start: ast.Position{
							Column: 9,
							Line:   135,
						},
					},
				},
				Name: "stddev",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 99,
							Line:   135,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], ?column: string, ?mode: string) => [B] where A: Record, B: Record",
						Start: ast.Position{
							Column: 18,
							Line:   135,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 88,
								Line:   135,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 79,
								Line:   135,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 88,
									Line:   135,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 82,
									Line:   135,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 80,
									Line:   135,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 79,
									Line:   135,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 99,
								Line:   135,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 90,
								Line:   135,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 99,
									Line:   135,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 93,
									Line:   135,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 91,
									Line:   135,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 90,
									Line:   135,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 72,
								Line:   135,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], ?column: string, ?mode: string) => [B]",
							Start: ast.Position{
								Column: 18,
								Line:   135,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   135,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 19,
									Line:   135,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 27,
										Line:   135,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 21,
										Line:   135,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 32,
										Line:   135,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 29,
										Line:   135,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 31,
											Line:   135,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 30,
											Line:   135,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 31,
												Line:   135,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 30,
												Line:   135,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 49,
									Line:   135,
								},
								File:   "universe.flux",
								Source: "?column: string",
								Start: ast.Position{
									Column: 34,
									Line:   135,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   135,
									},
									File:   "universe.flux",
									Source: "column",
									Start: ast.Position{
										Column: 35,
										Line:   135,
									},
								},
							},
							Name: "column",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 49,
										Line:   135,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 43,
										Line:   135,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 49,
											Line:   135,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 43,
											Line:   135,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 64,
									Line:   135,
								},
								File:   "universe.flux",
								Source: "?mode: string",
								Start: ast.Position{
									Column: 51,
									Line:   135,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 56,
										Line:   135,
									},
									File:   "universe.flux",
									Source: "mode",
									Start: ast.Position{
										Column: 52,
										Line:   135,
									},
								},
							},
							Name: "mode",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 64,
										Line:   135,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 58,
										Line:   135,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 64,
											Line:   135,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 58,
											Line:   135,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 72,
									Line:   135,
								},
								File:   "universe.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 69,
									Line:   135,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 71,
										Line:   135,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 70,
										Line:   135,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 71,
											Line:   135,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 70,
											Line:   135,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 12,
						Line:   136,
					},
					File:   "universe.flux",
					Source: "builtin sum",
					Start: ast.Position{
						Column: 1,
						Line:   136,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   136,
						},
						File:   "universe.flux",
						Source: "sum",
						Start: ast.Position{
							Column: 9,
							Line:   136,
						},
					},
				},
				Name: "sum",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 81,
							Line:   136,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], ?column: string) => [B] where A: Record, B: Record",
						Start: ast.Position{
							Column: 15,
							Line:   136,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 70,
								Line:   136,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 61,
								Line:   136,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 70,
									Line:   136,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 64,
									Line:   136,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 62,
									Line:   136,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 61,
									Line:   136,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 81,
								Line:   136,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 72,
								Line:   136,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 81,
									Line:   136,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 75,
									Line:   136,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 73,
									Line:   136,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 72,
									Line:   136,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 54,
								Line:   136,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], ?column: string) => [B]",
							Start: ast.Position{
								Column: 15,
								Line:   136,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 29,
									Line:   136,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 16,
									Line:   136,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 24,
										Line:   136,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 18,
										Line:   136,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   136,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 26,
										Line:   136,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 28,
											Line:   136,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 27,
											Line:   136,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 28,
												Line:   136,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 27,
												Line:   136,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 46,
									Line:   136,
								},
								File:   "universe.flux",
								Source: "?column: string",
								Start: ast.Position{
									Column: 31,
									Line:   136,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 38,
										Line:   136,
									},
									File:   "universe.flux",
									Source: "column",
									Start: ast.Position{
										Column: 32,
										Line:   136,
									},
								},
							},
							Name: "column",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 46,
										Line:   136,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 40,
										Line:   136,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 46,
											Line:   136,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 40,
											Line:   136,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 54,
									Line:   136,
								},
								File:   "universe.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 51,
									Line:   136,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 53,
										Line:   136,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 52,
										Line:   136,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 53,
											Line:   136,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 52,
											Line:   136,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 36,
						Line:   137,
					},
					File:   "universe.flux",
					Source: "builtin tripleExponentialDerivative",
					Start: ast.Position{
						Column: 1,
						Line:   137,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 36,
							Line:   137,
						},
						File:   "universe.flux",
						Source: "tripleExponentialDerivative",
						Start: ast.Position{
							Column: 9,
							Line:   137,
						},
					},
				},
				Name: "tripleExponentialDerivative",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 135,
							Line:   137,
						},
						File:   "universe.flux",
						Source: "(<-tables: [{B with _value: A}], n: int) => [{B with _value: float}] where A: Numeric, B: Record",
						Start: ast.Position{
							Column: 39,
							Line:   137,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 124,
								Line:   137,
							},
							File:   "universe.flux",
							Source: "A: Numeric",
							Start: ast.Position{
								Column: 114,
								Line:   137,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 124,
									Line:   137,
								},
								File:   "universe.flux",
								Source: "Numeric",
								Start: ast.Position{
									Column: 117,
									Line:   137,
								},
							},
						},
						Name: "Numeric",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 115,
									Line:   137,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 114,
									Line:   137,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 135,
								Line:   137,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 126,
								Line:   137,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 135,
									Line:   137,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 129,
									Line:   137,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 127,
									Line:   137,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 126,
									Line:   137,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 107,
								Line:   137,
							},
							File:   "universe.flux",
							Source: "(<-tables: [{B with _value: A}], n: int) => [{B with _value: float}]",
							Start: ast.Position{
								Column: 39,
								Line:   137,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 70,
									Line:   137,
								},
								File:   "universe.flux",
								Source: "<-tables: [{B with _value: A}]",
								Start: ast.Position{
									Column: 40,
									Line:   137,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 48,
										Line:   137,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 42,
										Line:   137,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 70,
										Line:   137,
									},
									File:   "universe.flux",
									Source: "[{B with _value: A}]",
									Start: ast.Position{
										Column: 50,
										Line:   137,
									},
								},
							},
							ElementType: &ast.RecordType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 69,
											Line:   137,
										},
										File:   "universe.flux",
										Source: "{B with _value: A}",
										Start: ast.Position{
											Column: 51,
											Line:   137,
										},
									},
								},
								Properties: []*ast.PropertyType{&ast.PropertyType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 68,
												Line:   137,
											},
											File:   "universe.flux",
											Source: "_value: A",
											Start: ast.Position{
												Column: 59,
												Line:   137,
											},
										},
									},
									Name: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 65,
													Line:   137,
												},
												File:   "universe.flux",
												Source: "_value",
												Start: ast.Position{
													Column: 59,
													Line:   137,
												},
											},
										},
										Name: "_value",
									},
									Ty: &ast.TvarType{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 68,
													Line:   137,
												},
												File:   "universe.flux",
												Source: "A",
												Start: ast.Position{
													Column: 67,
													Line:   137,
												},
											},
										},
										ID: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 68,
														Line:   137,
													},
													File:   "universe.flux",
													Source: "A",
													Start: ast.Position{
														Column: 67,
														Line:   137,
													},
												},
											},
											Name: "A",
										},
									},
								}},
								Tvar: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 53,
												Line:   137,
											},
											File:   "universe.flux",
											Source: "B",
											Start: ast.Position{
												Column: 52,
												Line:   137,
											},
										},
									},
									Name: "B",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 78,
									Line:   137,
								},
								File:   "universe.flux",
								Source: "n: int",
								Start: ast.Position{
									Column: 72,
									Line:   137,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 73,
										Line:   137,
									},
									File:   "universe.flux",
									Source: "n",
									Start: ast.Position{
										Column: 72,
										Line:   137,
									},
								},
							},
							Name: "n",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 78,
										Line:   137,
									},
									File:   "universe.flux",
									Source: "int",
									Start: ast.Position{
										Column: 75,
										Line:   137,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 78,
											Line:   137,
										},
										File:   "universe.flux",
										Source: "int",
										Start: ast.Position{
											Column: 75,
											Line:   137,
										},
									},
								},
								Name: "int",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 107,
									Line:   137,
								},
								File:   "universe.flux",
								Source: "[{B with _value: float}]",
								Start: ast.Position{
									Column: 83,
									Line:   137,
								},
							},
						},
						ElementType: &ast.RecordType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 106,
										Line:   137,
									},
									File:   "universe.flux",
									Source: "{B with _value: float}",
									Start: ast.Position{
										Column: 84,
										Line:   137,
									},
								},
							},
							Properties: []*ast.PropertyType{&ast.PropertyType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 105,
											Line:   137,
										},
										File:   "universe.flux",
										Source: "_value: float",
										Start: ast.Position{
											Column: 92,
											Line:   137,
										},
									},
								},
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 98,
												Line:   137,
											},
											File:   "universe.flux",
											Source: "_value",
											Start: ast.Position{
												Column: 92,
												Line:   137,
											},
										},
									},
									Name: "_value",
								},
								Ty: &ast.NamedType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 105,
												Line:   137,
											},
											File:   "universe.flux",
											Source: "float",
											Start: ast.Position{
												Column: 100,
												Line:   137,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 105,
													Line:   137,
												},
												File:   "universe.flux",
												Source: "float",
												Start: ast.Position{
													Column: 100,
													Line:   137,
												},
											},
										},
										Name: "float",
									},
								},
							}},
							Tvar: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 86,
											Line:   137,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 85,
											Line:   137,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   138,
					},
					File:   "universe.flux",
					Source: "builtin union",
					Start: ast.Position{
						Column: 1,
						Line:   138,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   138,
						},
						File:   "universe.flux",
						Source: "union",
						Start: ast.Position{
							Column: 9,
							Line:   138,
						},
					},
				},
				Name: "union",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 55,
							Line:   138,
						},
						File:   "universe.flux",
						Source: "(tables: [[A]]) => [A] where A: Record",
						Start: ast.Position{
							Column: 17,
							Line:   138,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 55,
								Line:   138,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 46,
								Line:   138,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 55,
									Line:   138,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 49,
									Line:   138,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 47,
									Line:   138,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 46,
									Line:   138,
								},
							},
						},
						Name: "A",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 39,
								Line:   138,
							},
							File:   "universe.flux",
							Source: "(tables: [[A]]) => [A]",
							Start: ast.Position{
								Column: 17,
								Line:   138,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 31,
									Line:   138,
								},
								File:   "universe.flux",
								Source: "tables: [[A]]",
								Start: ast.Position{
									Column: 18,
									Line:   138,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 24,
										Line:   138,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 18,
										Line:   138,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   138,
									},
									File:   "universe.flux",
									Source: "[[A]]",
									Start: ast.Position{
										Column: 26,
										Line:   138,
									},
								},
							},
							ElementType: &ast.ArrayType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   138,
										},
										File:   "universe.flux",
										Source: "[A]",
										Start: ast.Position{
											Column: 27,
											Line:   138,
										},
									},
								},
								ElementType: &ast.TvarType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   138,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 28,
												Line:   138,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 29,
													Line:   138,
												},
												File:   "universe.flux",
												Source: "A",
												Start: ast.Position{
													Column: 28,
													Line:   138,
												},
											},
										},
										Name: "A",
									},
								},
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 39,
									Line:   138,
								},
								File:   "universe.flux",
								Source: "[A]",
								Start: ast.Position{
									Column: 36,
									Line:   138,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 38,
										Line:   138,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 37,
										Line:   138,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 38,
											Line:   138,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 37,
											Line:   138,
										},
									},
								},
								Name: "A",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 15,
						Line:   139,
					},
					File:   "universe.flux",
					Source: "builtin unique",
					Start: ast.Position{
						Column: 1,
						Line:   139,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   139,
						},
						File:   "universe.flux",
						Source: "unique",
						Start: ast.Position{
							Column: 9,
							Line:   139,
						},
					},
				},
				Name: "unique",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 73,
							Line:   139,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], ?column: string) => [A] where A: Record",
						Start: ast.Position{
							Column: 18,
							Line:   139,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 73,
								Line:   139,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 64,
								Line:   139,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 73,
									Line:   139,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 67,
									Line:   139,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 65,
									Line:   139,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 64,
									Line:   139,
								},
							},
						},
						Name: "A",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 57,
								Line:   139,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], ?column: string) => [A]",
							Start: ast.Position{
								Column: 18,
								Line:   139,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   139,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 19,
									Line:   139,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 27,
										Line:   139,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 21,
										Line:   139,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 32,
										Line:   139,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 29,
										Line:   139,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 31,
											Line:   139,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 30,
											Line:   139,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 31,
												Line:   139,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 30,
												Line:   139,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 49,
									Line:   139,
								},
								File:   "universe.flux",
								Source: "?column: string",
								Start: ast.Position{
									Column: 34,
									Line:   139,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   139,
									},
									File:   "universe.flux",
									Source: "column",
									Start: ast.Position{
										Column: 35,
										Line:   139,
									},
								},
							},
							Name: "column",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 49,
										Line:   139,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 43,
										Line:   139,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 49,
											Line:   139,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 43,
											Line:   139,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 57,
									Line:   139,
								},
								File:   "universe.flux",
								Source: "[A]",
								Start: ast.Position{
									Column: 54,
									Line:   139,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 56,
										Line:   139,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 55,
										Line:   139,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 56,
											Line:   139,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 55,
											Line:   139,
										},
									},
								},
								Name: "A",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 15,
						Line:   140,
					},
					File:   "universe.flux",
					Source: "builtin window",
					Start: ast.Position{
						Column: 1,
						Line:   140,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   140,
						},
						File:   "universe.flux",
						Source: "window",
						Start: ast.Position{
							Column: 9,
							Line:   140,
						},
					},
				},
				Name: "window",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   151,
						},
						File:   "universe.flux",
						Source: "(\n    <-tables: [A],\n    ?every: duration,\n    ?period: duration,\n    ?offset: duration,\n    ?timeColumn: string,\n    ?startColumn: string,\n    ?stopColumn: string,\n    ?createEmpty: bool,\n) => [B] where\n    A: Record,\n    B: Record",
						Start: ast.Position{
							Column: 18,
							Line:   140,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   150,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 5,
								Line:   150,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   150,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 8,
									Line:   150,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   150,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 5,
									Line:   150,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   151,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 5,
								Line:   151,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   151,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 8,
									Line:   151,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   151,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 5,
									Line:   151,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 9,
								Line:   149,
							},
							File:   "universe.flux",
							Source: "(\n    <-tables: [A],\n    ?every: duration,\n    ?period: duration,\n    ?offset: duration,\n    ?timeColumn: string,\n    ?startColumn: string,\n    ?stopColumn: string,\n    ?createEmpty: bool,\n) => [B]",
							Start: ast.Position{
								Column: 18,
								Line:   140,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 18,
									Line:   141,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 5,
									Line:   141,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   141,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 7,
										Line:   141,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   141,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 15,
										Line:   141,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 17,
											Line:   141,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 16,
											Line:   141,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   141,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 16,
												Line:   141,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   142,
								},
								File:   "universe.flux",
								Source: "?every: duration",
								Start: ast.Position{
									Column: 5,
									Line:   142,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   142,
									},
									File:   "universe.flux",
									Source: "every",
									Start: ast.Position{
										Column: 6,
										Line:   142,
									},
								},
							},
							Name: "every",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 21,
										Line:   142,
									},
									File:   "universe.flux",
									Source: "duration",
									Start: ast.Position{
										Column: 13,
										Line:   142,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   142,
										},
										File:   "universe.flux",
										Source: "duration",
										Start: ast.Position{
											Column: 13,
											Line:   142,
										},
									},
								},
								Name: "duration",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 22,
									Line:   143,
								},
								File:   "universe.flux",
								Source: "?period: duration",
								Start: ast.Position{
									Column: 5,
									Line:   143,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   143,
									},
									File:   "universe.flux",
									Source: "period",
									Start: ast.Position{
										Column: 6,
										Line:   143,
									},
								},
							},
							Name: "period",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 22,
										Line:   143,
									},
									File:   "universe.flux",
									Source: "duration",
									Start: ast.Position{
										Column: 14,
										Line:   143,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 22,
											Line:   143,
										},
										File:   "universe.flux",
										Source: "duration",
										Start: ast.Position{
											Column: 14,
											Line:   143,
										},
									},
								},
								Name: "duration",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 22,
									Line:   144,
								},
								File:   "universe.flux",
								Source: "?offset: duration",
								Start: ast.Position{
									Column: 5,
									Line:   144,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   144,
									},
									File:   "universe.flux",
									Source: "offset",
									Start: ast.Position{
										Column: 6,
										Line:   144,
									},
								},
							},
							Name: "offset",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 22,
										Line:   144,
									},
									File:   "universe.flux",
									Source: "duration",
									Start: ast.Position{
										Column: 14,
										Line:   144,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 22,
											Line:   144,
										},
										File:   "universe.flux",
										Source: "duration",
										Start: ast.Position{
											Column: 14,
											Line:   144,
										},
									},
								},
								Name: "duration",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 24,
									Line:   145,
								},
								File:   "universe.flux",
								Source: "?timeColumn: string",
								Start: ast.Position{
									Column: 5,
									Line:   145,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 16,
										Line:   145,
									},
									File:   "universe.flux",
									Source: "timeColumn",
									Start: ast.Position{
										Column: 6,
										Line:   145,
									},
								},
							},
							Name: "timeColumn",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 24,
										Line:   145,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 18,
										Line:   145,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 24,
											Line:   145,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 18,
											Line:   145,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   146,
								},
								File:   "universe.flux",
								Source: "?startColumn: string",
								Start: ast.Position{
									Column: 5,
									Line:   146,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 17,
										Line:   146,
									},
									File:   "universe.flux",
									Source: "startColumn",
									Start: ast.Position{
										Column: 6,
										Line:   146,
									},
								},
							},
							Name: "startColumn",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   146,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 19,
										Line:   146,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 25,
											Line:   146,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 19,
											Line:   146,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 24,
									Line:   147,
								},
								File:   "universe.flux",
								Source: "?stopColumn: string",
								Start: ast.Position{
									Column: 5,
									Line:   147,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 16,
										Line:   147,
									},
									File:   "universe.flux",
									Source: "stopColumn",
									Start: ast.Position{
										Column: 6,
										Line:   147,
									},
								},
							},
							Name: "stopColumn",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 24,
										Line:   147,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 18,
										Line:   147,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 24,
											Line:   147,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 18,
											Line:   147,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 23,
									Line:   148,
								},
								File:   "universe.flux",
								Source: "?createEmpty: bool",
								Start: ast.Position{
									Column: 5,
									Line:   148,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 17,
										Line:   148,
									},
									File:   "universe.flux",
									Source: "createEmpty",
									Start: ast.Position{
										Column: 6,
										Line:   148,
									},
								},
							},
							Name: "createEmpty",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 23,
										Line:   148,
									},
									File:   "universe.flux",
									Source: "bool",
									Start: ast.Position{
										Column: 19,
										Line:   148,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 23,
											Line:   148,
										},
										File:   "universe.flux",
										Source: "bool",
										Start: ast.Position{
											Column: 19,
											Line:   148,
										},
									},
								},
								Name: "bool",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 9,
									Line:   149,
								},
								File:   "universe.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 6,
									Line:   149,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 8,
										Line:   149,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 7,
										Line:   149,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 8,
											Line:   149,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 7,
											Line:   149,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   152,
					},
					File:   "universe.flux",
					Source: "builtin yield",
					Start: ast.Position{
						Column: 1,
						Line:   152,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   152,
						},
						File:   "universe.flux",
						Source: "yield",
						Start: ast.Position{
							Column: 9,
							Line:   152,
						},
					},
				},
				Name: "yield",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 70,
							Line:   152,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], ?name: string) => [A] where A: Record",
						Start: ast.Position{
							Column: 17,
							Line:   152,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 70,
								Line:   152,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 61,
								Line:   152,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 70,
									Line:   152,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 64,
									Line:   152,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 62,
									Line:   152,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 61,
									Line:   152,
								},
							},
						},
						Name: "A",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 54,
								Line:   152,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], ?name: string) => [A]",
							Start: ast.Position{
								Column: 17,
								Line:   152,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 31,
									Line:   152,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 18,
									Line:   152,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 26,
										Line:   152,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 20,
										Line:   152,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   152,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 28,
										Line:   152,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   152,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 29,
											Line:   152,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 30,
												Line:   152,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 29,
												Line:   152,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 46,
									Line:   152,
								},
								File:   "universe.flux",
								Source: "?name: string",
								Start: ast.Position{
									Column: 33,
									Line:   152,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 38,
										Line:   152,
									},
									File:   "universe.flux",
									Source: "name",
									Start: ast.Position{
										Column: 34,
										Line:   152,
									},
								},
							},
							Name: "name",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 46,
										Line:   152,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 40,
										Line:   152,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 46,
											Line:   152,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 40,
											Line:   152,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 54,
									Line:   152,
								},
								File:   "universe.flux",
								Source: "[A]",
								Start: ast.Position{
									Column: 51,
									Line:   152,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 53,
										Line:   152,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 52,
										Line:   152,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 53,
											Line:   152,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 52,
											Line:   152,
										},
									},
								},
								Name: "A",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// stream/table index functions\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   155,
					},
					File:   "universe.flux",
					Source: "builtin tableFind",
					Start: ast.Position{
						Column: 1,
						Line:   155,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   155,
						},
						File:   "universe.flux",
						Source: "tableFind",
						Start: ast.Position{
							Column: 9,
							Line:   155,
						},
					},
				},
				Name: "tableFind",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 92,
							Line:   155,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], fn: (key: B) => bool) => [A] where A: Record, B: Record",
						Start: ast.Position{
							Column: 21,
							Line:   155,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 81,
								Line:   155,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 72,
								Line:   155,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 81,
									Line:   155,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 75,
									Line:   155,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 73,
									Line:   155,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 72,
									Line:   155,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 92,
								Line:   155,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 83,
								Line:   155,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 92,
									Line:   155,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 86,
									Line:   155,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 84,
									Line:   155,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 83,
									Line:   155,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 65,
								Line:   155,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], fn: (key: B) => bool) => [A]",
							Start: ast.Position{
								Column: 21,
								Line:   155,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 35,
									Line:   155,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 22,
									Line:   155,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   155,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 24,
										Line:   155,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 35,
										Line:   155,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 32,
										Line:   155,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 34,
											Line:   155,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 33,
											Line:   155,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 34,
												Line:   155,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 33,
												Line:   155,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 57,
									Line:   155,
								},
								File:   "universe.flux",
								Source: "fn: (key: B) => bool",
								Start: ast.Position{
									Column: 37,
									Line:   155,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 39,
										Line:   155,
									},
									File:   "universe.flux",
									Source: "fn",
									Start: ast.Position{
										Column: 37,
										Line:   155,
									},
								},
							},
							Name: "fn",
						},
						Ty: &ast.FunctionType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 57,
										Line:   155,
									},
									File:   "universe.flux",
									Source: "(key: B) => bool",
									Start: ast.Position{
										Column: 41,
										Line:   155,
									},
								},
							},
							Parameters: []*ast.ParameterType{&ast.ParameterType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 48,
											Line:   155,
										},
										File:   "universe.flux",
										Source: "key: B",
										Start: ast.Position{
											Column: 42,
											Line:   155,
										},
									},
								},
								Kind: "Required",
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 45,
												Line:   155,
											},
											File:   "universe.flux",
											Source: "key",
											Start: ast.Position{
												Column: 42,
												Line:   155,
											},
										},
									},
									Name: "key",
								},
								Ty: &ast.TvarType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 48,
												Line:   155,
											},
											File:   "universe.flux",
											Source: "B",
											Start: ast.Position{
												Column: 47,
												Line:   155,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 48,
													Line:   155,
												},
												File:   "universe.flux",
												Source: "B",
												Start: ast.Position{
													Column: 47,
													Line:   155,
												},
											},
										},
										Name: "B",
									},
								},
							}},
							Return: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 57,
											Line:   155,
										},
										File:   "universe.flux",
										Source: "bool",
										Start: ast.Position{
											Column: 53,
											Line:   155,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 57,
												Line:   155,
											},
											File:   "universe.flux",
											Source: "bool",
											Start: ast.Position{
												Column: 53,
												Line:   155,
											},
										},
									},
									Name: "bool",
								},
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 65,
									Line:   155,
								},
								File:   "universe.flux",
								Source: "[A]",
								Start: ast.Position{
									Column: 62,
									Line:   155,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 64,
										Line:   155,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 63,
										Line:   155,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 64,
											Line:   155,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 63,
											Line:   155,
										},
									},
								},
								Name: "A",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   156,
					},
					File:   "universe.flux",
					Source: "builtin getColumn",
					Start: ast.Position{
						Column: 1,
						Line:   156,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   156,
						},
						File:   "universe.flux",
						Source: "getColumn",
						Start: ast.Position{
							Column: 9,
							Line:   156,
						},
					},
				},
				Name: "getColumn",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 74,
							Line:   156,
						},
						File:   "universe.flux",
						Source: "(<-table: [A], column: string) => [B] where A: Record",
						Start: ast.Position{
							Column: 21,
							Line:   156,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 74,
								Line:   156,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 65,
								Line:   156,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 74,
									Line:   156,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 68,
									Line:   156,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 66,
									Line:   156,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 65,
									Line:   156,
								},
							},
						},
						Name: "A",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 58,
								Line:   156,
							},
							File:   "universe.flux",
							Source: "(<-table: [A], column: string) => [B]",
							Start: ast.Position{
								Column: 21,
								Line:   156,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   156,
								},
								File:   "universe.flux",
								Source: "<-table: [A]",
								Start: ast.Position{
									Column: 22,
									Line:   156,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   156,
									},
									File:   "universe.flux",
									Source: "table",
									Start: ast.Position{
										Column: 24,
										Line:   156,
									},
								},
							},
							Name: "table",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 34,
										Line:   156,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 31,
										Line:   156,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 33,
											Line:   156,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 32,
											Line:   156,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 33,
												Line:   156,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 32,
												Line:   156,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 50,
									Line:   156,
								},
								File:   "universe.flux",
								Source: "column: string",
								Start: ast.Position{
									Column: 36,
									Line:   156,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   156,
									},
									File:   "universe.flux",
									Source: "column",
									Start: ast.Position{
										Column: 36,
										Line:   156,
									},
								},
							},
							Name: "column",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 50,
										Line:   156,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 44,
										Line:   156,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 50,
											Line:   156,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 44,
											Line:   156,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 58,
									Line:   156,
								},
								File:   "universe.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 55,
									Line:   156,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 57,
										Line:   156,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 56,
										Line:   156,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 57,
											Line:   156,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 56,
											Line:   156,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   157,
					},
					File:   "universe.flux",
					Source: "builtin getRecord",
					Start: ast.Position{
						Column: 1,
						Line:   157,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   157,
						},
						File:   "universe.flux",
						Source: "getRecord",
						Start: ast.Position{
							Column: 9,
							Line:   157,
						},
					},
				},
				Name: "getRecord",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 66,
							Line:   157,
						},
						File:   "universe.flux",
						Source: "(<-table: [A], idx: int) => A where A: Record",
						Start: ast.Position{
							Column: 21,
							Line:   157,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 66,
								Line:   157,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 57,
								Line:   157,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 66,
									Line:   157,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 60,
									Line:   157,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 58,
									Line:   157,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 57,
									Line:   157,
								},
							},
						},
						Name: "A",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 50,
								Line:   157,
							},
							File:   "universe.flux",
							Source: "(<-table: [A], idx: int) => A",
							Start: ast.Position{
								Column: 21,
								Line:   157,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   157,
								},
								File:   "universe.flux",
								Source: "<-table: [A]",
								Start: ast.Position{
									Column: 22,
									Line:   157,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   157,
									},
									File:   "universe.flux",
									Source: "table",
									Start: ast.Position{
										Column: 24,
										Line:   157,
									},
								},
							},
							Name: "table",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 34,
										Line:   157,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 31,
										Line:   157,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 33,
											Line:   157,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 32,
											Line:   157,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 33,
												Line:   157,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 32,
												Line:   157,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 44,
									Line:   157,
								},
								File:   "universe.flux",
								Source: "idx: int",
								Start: ast.Position{
									Column: 36,
									Line:   157,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 39,
										Line:   157,
									},
									File:   "universe.flux",
									Source: "idx",
									Start: ast.Position{
										Column: 36,
										Line:   157,
									},
								},
							},
							Name: "idx",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 44,
										Line:   157,
									},
									File:   "universe.flux",
									Source: "int",
									Start: ast.Position{
										Column: 41,
										Line:   157,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 44,
											Line:   157,
										},
										File:   "universe.flux",
										Source: "int",
										Start: ast.Position{
											Column: 41,
											Line:   157,
										},
									},
								},
								Name: "int",
							},
						},
					}},
					Return: &ast.TvarType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 50,
									Line:   157,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 49,
									Line:   157,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 50,
										Line:   157,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 49,
										Line:   157,
									},
								},
							},
							Name: "A",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 19,
						Line:   158,
					},
					File:   "universe.flux",
					Source: "builtin findColumn",
					Start: ast.Position{
						Column: 1,
						Line:   158,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 19,
							Line:   158,
						},
						File:   "universe.flux",
						Source: "findColumn",
						Start: ast.Position{
							Column: 9,
							Line:   158,
						},
					},
				},
				Name: "findColumn",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 109,
							Line:   158,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], fn: (key: B) => bool, column: string) => [C] where A: Record, B: Record",
						Start: ast.Position{
							Column: 22,
							Line:   158,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 98,
								Line:   158,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 89,
								Line:   158,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 98,
									Line:   158,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 92,
									Line:   158,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 90,
									Line:   158,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 89,
									Line:   158,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 109,
								Line:   158,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 100,
								Line:   158,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 109,
									Line:   158,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 103,
									Line:   158,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 101,
									Line:   158,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 100,
									Line:   158,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 82,
								Line:   158,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], fn: (key: B) => bool, column: string) => [C]",
							Start: ast.Position{
								Column: 22,
								Line:   158,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 36,
									Line:   158,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 23,
									Line:   158,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   158,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 25,
										Line:   158,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 36,
										Line:   158,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 33,
										Line:   158,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 35,
											Line:   158,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 34,
											Line:   158,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 35,
												Line:   158,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 34,
												Line:   158,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 58,
									Line:   158,
								},
								File:   "universe.flux",
								Source: "fn: (key: B) => bool",
								Start: ast.Position{
									Column: 38,
									Line:   158,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   158,
									},
									File:   "universe.flux",
									Source: "fn",
									Start: ast.Position{
										Column: 38,
										Line:   158,
									},
								},
							},
							Name: "fn",
						},
						Ty: &ast.FunctionType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 58,
										Line:   158,
									},
									File:   "universe.flux",
									Source: "(key: B) => bool",
									Start: ast.Position{
										Column: 42,
										Line:   158,
									},
								},
							},
							Parameters: []*ast.ParameterType{&ast.ParameterType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 49,
											Line:   158,
										},
										File:   "universe.flux",
										Source: "key: B",
										Start: ast.Position{
											Column: 43,
											Line:   158,
										},
									},
								},
								Kind: "Required",
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 46,
												Line:   158,
											},
											File:   "universe.flux",
											Source: "key",
											Start: ast.Position{
												Column: 43,
												Line:   158,
											},
										},
									},
									Name: "key",
								},
								Ty: &ast.TvarType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   158,
											},
											File:   "universe.flux",
											Source: "B",
											Start: ast.Position{
												Column: 48,
												Line:   158,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 49,
													Line:   158,
												},
												File:   "universe.flux",
												Source: "B",
												Start: ast.Position{
													Column: 48,
													Line:   158,
												},
											},
										},
										Name: "B",
									},
								},
							}},
							Return: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 58,
											Line:   158,
										},
										File:   "universe.flux",
										Source: "bool",
										Start: ast.Position{
											Column: 54,
											Line:   158,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 58,
												Line:   158,
											},
											File:   "universe.flux",
											Source: "bool",
											Start: ast.Position{
												Column: 54,
												Line:   158,
											},
										},
									},
									Name: "bool",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 74,
									Line:   158,
								},
								File:   "universe.flux",
								Source: "column: string",
								Start: ast.Position{
									Column: 60,
									Line:   158,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 66,
										Line:   158,
									},
									File:   "universe.flux",
									Source: "column",
									Start: ast.Position{
										Column: 60,
										Line:   158,
									},
								},
							},
							Name: "column",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 74,
										Line:   158,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 68,
										Line:   158,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 74,
											Line:   158,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 68,
											Line:   158,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 82,
									Line:   158,
								},
								File:   "universe.flux",
								Source: "[C]",
								Start: ast.Position{
									Column: 79,
									Line:   158,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 81,
										Line:   158,
									},
									File:   "universe.flux",
									Source: "C",
									Start: ast.Position{
										Column: 80,
										Line:   158,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 81,
											Line:   158,
										},
										File:   "universe.flux",
										Source: "C",
										Start: ast.Position{
											Column: 80,
											Line:   158,
										},
									},
								},
								Name: "C",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 19,
						Line:   159,
					},
					File:   "universe.flux",
					Source: "builtin findRecord",
					Start: ast.Position{
						Column: 1,
						Line:   159,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 19,
							Line:   159,
						},
						File:   "universe.flux",
						Source: "findRecord",
						Start: ast.Position{
							Column: 9,
							Line:   159,
						},
					},
				},
				Name: "findRecord",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 101,
							Line:   159,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], fn: (key: B) => bool, idx: int) => A where A: Record, B: Record",
						Start: ast.Position{
							Column: 22,
							Line:   159,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 90,
								Line:   159,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 81,
								Line:   159,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 90,
									Line:   159,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 84,
									Line:   159,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 82,
									Line:   159,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 81,
									Line:   159,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 101,
								Line:   159,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 92,
								Line:   159,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 101,
									Line:   159,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 95,
									Line:   159,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 93,
									Line:   159,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 92,
									Line:   159,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 74,
								Line:   159,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], fn: (key: B) => bool, idx: int) => A",
							Start: ast.Position{
								Column: 22,
								Line:   159,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 36,
									Line:   159,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 23,
									Line:   159,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   159,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 25,
										Line:   159,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 36,
										Line:   159,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 33,
										Line:   159,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 35,
											Line:   159,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 34,
											Line:   159,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 35,
												Line:   159,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 34,
												Line:   159,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 58,
									Line:   159,
								},
								File:   "universe.flux",
								Source: "fn: (key: B) => bool",
								Start: ast.Position{
									Column: 38,
									Line:   159,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   159,
									},
									File:   "universe.flux",
									Source: "fn",
									Start: ast.Position{
										Column: 38,
										Line:   159,
									},
								},
							},
							Name: "fn",
						},
						Ty: &ast.FunctionType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 58,
										Line:   159,
									},
									File:   "universe.flux",
									Source: "(key: B) => bool",
									Start: ast.Position{
										Column: 42,
										Line:   159,
									},
								},
							},
							Parameters: []*ast.ParameterType{&ast.ParameterType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 49,
											Line:   159,
										},
										File:   "universe.flux",
										Source: "key: B",
										Start: ast.Position{
											Column: 43,
											Line:   159,
										},
									},
								},
								Kind: "Required",
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 46,
												Line:   159,
											},
											File:   "universe.flux",
											Source: "key",
											Start: ast.Position{
												Column: 43,
												Line:   159,
											},
										},
									},
									Name: "key",
								},
								Ty: &ast.TvarType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   159,
											},
											File:   "universe.flux",
											Source: "B",
											Start: ast.Position{
												Column: 48,
												Line:   159,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 49,
													Line:   159,
												},
												File:   "universe.flux",
												Source: "B",
												Start: ast.Position{
													Column: 48,
													Line:   159,
												},
											},
										},
										Name: "B",
									},
								},
							}},
							Return: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 58,
											Line:   159,
										},
										File:   "universe.flux",
										Source: "bool",
										Start: ast.Position{
											Column: 54,
											Line:   159,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 58,
												Line:   159,
											},
											File:   "universe.flux",
											Source: "bool",
											Start: ast.Position{
												Column: 54,
												Line:   159,
											},
										},
									},
									Name: "bool",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 68,
									Line:   159,
								},
								File:   "universe.flux",
								Source: "idx: int",
								Start: ast.Position{
									Column: 60,
									Line:   159,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 63,
										Line:   159,
									},
									File:   "universe.flux",
									Source: "idx",
									Start: ast.Position{
										Column: 60,
										Line:   159,
									},
								},
							},
							Name: "idx",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 68,
										Line:   159,
									},
									File:   "universe.flux",
									Source: "int",
									Start: ast.Position{
										Column: 65,
										Line:   159,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 68,
											Line:   159,
										},
										File:   "universe.flux",
										Source: "int",
										Start: ast.Position{
											Column: 65,
											Line:   159,
										},
									},
								},
								Name: "int",
							},
						},
					}},
					Return: &ast.TvarType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 74,
									Line:   159,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 73,
									Line:   159,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 74,
										Line:   159,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 73,
										Line:   159,
									},
								},
							},
							Name: "A",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// type conversion functions\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   162,
					},
					File:   "universe.flux",
					Source: "builtin bool",
					Start: ast.Position{
						Column: 1,
						Line:   162,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   162,
						},
						File:   "universe.flux",
						Source: "bool",
						Start: ast.Position{
							Column: 9,
							Line:   162,
						},
					},
				},
				Name: "bool",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 30,
							Line:   162,
						},
						File:   "universe.flux",
						Source: "(v: A) => bool",
						Start: ast.Position{
							Column: 16,
							Line:   162,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 30,
								Line:   162,
							},
							File:   "universe.flux",
							Source: "(v: A) => bool",
							Start: ast.Position{
								Column: 16,
								Line:   162,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   162,
								},
								File:   "universe.flux",
								Source: "v: A",
								Start: ast.Position{
									Column: 17,
									Line:   162,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   162,
									},
									File:   "universe.flux",
									Source: "v",
									Start: ast.Position{
										Column: 17,
										Line:   162,
									},
								},
							},
							Name: "v",
						},
						Ty: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 21,
										Line:   162,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 20,
										Line:   162,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   162,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 20,
											Line:   162,
										},
									},
								},
								Name: "A",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   162,
								},
								File:   "universe.flux",
								Source: "bool",
								Start: ast.Position{
									Column: 26,
									Line:   162,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   162,
									},
									File:   "universe.flux",
									Source: "bool",
									Start: ast.Position{
										Column: 26,
										Line:   162,
									},
								},
							},
							Name: "bool",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   163,
					},
					File:   "universe.flux",
					Source: "builtin bytes",
					Start: ast.Position{
						Column: 1,
						Line:   163,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   163,
						},
						File:   "universe.flux",
						Source: "bytes",
						Start: ast.Position{
							Column: 9,
							Line:   163,
						},
					},
				},
				Name: "bytes",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 32,
							Line:   163,
						},
						File:   "universe.flux",
						Source: "(v: A) => bytes",
						Start: ast.Position{
							Column: 17,
							Line:   163,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 32,
								Line:   163,
							},
							File:   "universe.flux",
							Source: "(v: A) => bytes",
							Start: ast.Position{
								Column: 17,
								Line:   163,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 22,
									Line:   163,
								},
								File:   "universe.flux",
								Source: "v: A",
								Start: ast.Position{
									Column: 18,
									Line:   163,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 19,
										Line:   163,
									},
									File:   "universe.flux",
									Source: "v",
									Start: ast.Position{
										Column: 18,
										Line:   163,
									},
								},
							},
							Name: "v",
						},
						Ty: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 22,
										Line:   163,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 21,
										Line:   163,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 22,
											Line:   163,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 21,
											Line:   163,
										},
									},
								},
								Name: "A",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   163,
								},
								File:   "universe.flux",
								Source: "bytes",
								Start: ast.Position{
									Column: 27,
									Line:   163,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 32,
										Line:   163,
									},
									File:   "universe.flux",
									Source: "bytes",
									Start: ast.Position{
										Column: 27,
										Line:   163,
									},
								},
							},
							Name: "bytes",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   164,
					},
					File:   "universe.flux",
					Source: "builtin duration",
					Start: ast.Position{
						Column: 1,
						Line:   164,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   164,
						},
						File:   "universe.flux",
						Source: "duration",
						Start: ast.Position{
							Column: 9,
							Line:   164,
						},
					},
				},
				Name: "duration",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 38,
							Line:   164,
						},
						File:   "universe.flux",
						Source: "(v: A) => duration",
						Start: ast.Position{
							Column: 20,
							Line:   164,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 38,
								Line:   164,
							},
							File:   "universe.flux",
							Source: "(v: A) => duration",
							Start: ast.Position{
								Column: 20,
								Line:   164,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   164,
								},
								File:   "universe.flux",
								Source: "v: A",
								Start: ast.Position{
									Column: 21,
									Line:   164,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 22,
										Line:   164,
									},
									File:   "universe.flux",
									Source: "v",
									Start: ast.Position{
										Column: 21,
										Line:   164,
									},
								},
							},
							Name: "v",
						},
						Ty: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   164,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 24,
										Line:   164,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 25,
											Line:   164,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 24,
											Line:   164,
										},
									},
								},
								Name: "A",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 38,
									Line:   164,
								},
								File:   "universe.flux",
								Source: "duration",
								Start: ast.Position{
									Column: 30,
									Line:   164,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 38,
										Line:   164,
									},
									File:   "universe.flux",
									Source: "duration",
									Start: ast.Position{
										Column: 30,
										Line:   164,
									},
								},
							},
							Name: "duration",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   165,
					},
					File:   "universe.flux",
					Source: "builtin float",
					Start: ast.Position{
						Column: 1,
						Line:   165,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   165,
						},
						File:   "universe.flux",
						Source: "float",
						Start: ast.Position{
							Column: 9,
							Line:   165,
						},
					},
				},
				Name: "float",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 32,
							Line:   165,
						},
						File:   "universe.flux",
						Source: "(v: A) => float",
						Start: ast.Position{
							Column: 17,
							Line:   165,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 32,
								Line:   165,
							},
							File:   "universe.flux",
							Source: "(v: A) => float",
							Start: ast.Position{
								Column: 17,
								Line:   165,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 22,
									Line:   165,
								},
								File:   "universe.flux",
								Source: "v: A",
								Start: ast.Position{
									Column: 18,
									Line:   165,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 19,
										Line:   165,
									},
									File:   "universe.flux",
									Source: "v",
									Start: ast.Position{
										Column: 18,
										Line:   165,
									},
								},
							},
							Name: "v",
						},
						Ty: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 22,
										Line:   165,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 21,
										Line:   165,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 22,
											Line:   165,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 21,
											Line:   165,
										},
									},
								},
								Name: "A",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   165,
								},
								File:   "universe.flux",
								Source: "float",
								Start: ast.Position{
									Column: 27,
									Line:   165,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 32,
										Line:   165,
									},
									File:   "universe.flux",
									Source: "float",
									Start: ast.Position{
										Column: 27,
										Line:   165,
									},
								},
							},
							Name: "float",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 12,
						Line:   166,
					},
					File:   "universe.flux",
					Source: "builtin int",
					Start: ast.Position{
						Column: 1,
						Line:   166,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   166,
						},
						File:   "universe.flux",
						Source: "int",
						Start: ast.Position{
							Column: 9,
							Line:   166,
						},
					},
				},
				Name: "int",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 28,
							Line:   166,
						},
						File:   "universe.flux",
						Source: "(v: A) => int",
						Start: ast.Position{
							Column: 15,
							Line:   166,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 28,
								Line:   166,
							},
							File:   "universe.flux",
							Source: "(v: A) => int",
							Start: ast.Position{
								Column: 15,
								Line:   166,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   166,
								},
								File:   "universe.flux",
								Source: "v: A",
								Start: ast.Position{
									Column: 16,
									Line:   166,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 17,
										Line:   166,
									},
									File:   "universe.flux",
									Source: "v",
									Start: ast.Position{
										Column: 16,
										Line:   166,
									},
								},
							},
							Name: "v",
						},
						Ty: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 20,
										Line:   166,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 19,
										Line:   166,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 20,
											Line:   166,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 19,
											Line:   166,
										},
									},
								},
								Name: "A",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 28,
									Line:   166,
								},
								File:   "universe.flux",
								Source: "int",
								Start: ast.Position{
									Column: 25,
									Line:   166,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 28,
										Line:   166,
									},
									File:   "universe.flux",
									Source: "int",
									Start: ast.Position{
										Column: 25,
										Line:   166,
									},
								},
							},
							Name: "int",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 15,
						Line:   167,
					},
					File:   "universe.flux",
					Source: "builtin string",
					Start: ast.Position{
						Column: 1,
						Line:   167,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   167,
						},
						File:   "universe.flux",
						Source: "string",
						Start: ast.Position{
							Column: 9,
							Line:   167,
						},
					},
				},
				Name: "string",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 34,
							Line:   167,
						},
						File:   "universe.flux",
						Source: "(v: A) => string",
						Start: ast.Position{
							Column: 18,
							Line:   167,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 34,
								Line:   167,
							},
							File:   "universe.flux",
							Source: "(v: A) => string",
							Start: ast.Position{
								Column: 18,
								Line:   167,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 23,
									Line:   167,
								},
								File:   "universe.flux",
								Source: "v: A",
								Start: ast.Position{
									Column: 19,
									Line:   167,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 20,
										Line:   167,
									},
									File:   "universe.flux",
									Source: "v",
									Start: ast.Position{
										Column: 19,
										Line:   167,
									},
								},
							},
							Name: "v",
						},
						Ty: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 23,
										Line:   167,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 22,
										Line:   167,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 23,
											Line:   167,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 22,
											Line:   167,
										},
									},
								},
								Name: "A",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   167,
								},
								File:   "universe.flux",
								Source: "string",
								Start: ast.Position{
									Column: 28,
									Line:   167,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 34,
										Line:   167,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 28,
										Line:   167,
									},
								},
							},
							Name: "string",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   168,
					},
					File:   "universe.flux",
					Source: "builtin time",
					Start: ast.Position{
						Column: 1,
						Line:   168,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   168,
						},
						File:   "universe.flux",
						Source: "time",
						Start: ast.Position{
							Column: 9,
							Line:   168,
						},
					},
				},
				Name: "time",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 30,
							Line:   168,
						},
						File:   "universe.flux",
						Source: "(v: A) => time",
						Start: ast.Position{
							Column: 16,
							Line:   168,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 30,
								Line:   168,
							},
							File:   "universe.flux",
							Source: "(v: A) => time",
							Start: ast.Position{
								Column: 16,
								Line:   168,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   168,
								},
								File:   "universe.flux",
								Source: "v: A",
								Start: ast.Position{
									Column: 17,
									Line:   168,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   168,
									},
									File:   "universe.flux",
									Source: "v",
									Start: ast.Position{
										Column: 17,
										Line:   168,
									},
								},
							},
							Name: "v",
						},
						Ty: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 21,
										Line:   168,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 20,
										Line:   168,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   168,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 20,
											Line:   168,
										},
									},
								},
								Name: "A",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   168,
								},
								File:   "universe.flux",
								Source: "time",
								Start: ast.Position{
									Column: 26,
									Line:   168,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   168,
									},
									File:   "universe.flux",
									Source: "time",
									Start: ast.Position{
										Column: 26,
										Line:   168,
									},
								},
							},
							Name: "time",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   169,
					},
					File:   "universe.flux",
					Source: "builtin uint",
					Start: ast.Position{
						Column: 1,
						Line:   169,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   169,
						},
						File:   "universe.flux",
						Source: "uint",
						Start: ast.Position{
							Column: 9,
							Line:   169,
						},
					},
				},
				Name: "uint",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 30,
							Line:   169,
						},
						File:   "universe.flux",
						Source: "(v: A) => uint",
						Start: ast.Position{
							Column: 16,
							Line:   169,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 30,
								Line:   169,
							},
							File:   "universe.flux",
							Source: "(v: A) => uint",
							Start: ast.Position{
								Column: 16,
								Line:   169,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   169,
								},
								File:   "universe.flux",
								Source: "v: A",
								Start: ast.Position{
									Column: 17,
									Line:   169,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   169,
									},
									File:   "universe.flux",
									Source: "v",
									Start: ast.Position{
										Column: 17,
										Line:   169,
									},
								},
							},
							Name: "v",
						},
						Ty: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 21,
										Line:   169,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 20,
										Line:   169,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   169,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 20,
											Line:   169,
										},
									},
								},
								Name: "A",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   169,
								},
								File:   "universe.flux",
								Source: "uint",
								Start: ast.Position{
									Column: 26,
									Line:   169,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   169,
									},
									File:   "universe.flux",
									Source: "uint",
									Start: ast.Position{
										Column: 26,
										Line:   169,
									},
								},
							},
							Name: "uint",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// contains function\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   172,
					},
					File:   "universe.flux",
					Source: "builtin contains",
					Start: ast.Position{
						Column: 1,
						Line:   172,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   172,
						},
						File:   "universe.flux",
						Source: "contains",
						Start: ast.Position{
							Column: 9,
							Line:   172,
						},
					},
				},
				Name: "contains",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 66,
							Line:   172,
						},
						File:   "universe.flux",
						Source: "(value: A, set: [A]) => bool where A: Nullable",
						Start: ast.Position{
							Column: 20,
							Line:   172,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 66,
								Line:   172,
							},
							File:   "universe.flux",
							Source: "A: Nullable",
							Start: ast.Position{
								Column: 55,
								Line:   172,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 66,
									Line:   172,
								},
								File:   "universe.flux",
								Source: "Nullable",
								Start: ast.Position{
									Column: 58,
									Line:   172,
								},
							},
						},
						Name: "Nullable",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 56,
									Line:   172,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 55,
									Line:   172,
								},
							},
						},
						Name: "A",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 48,
								Line:   172,
							},
							File:   "universe.flux",
							Source: "(value: A, set: [A]) => bool",
							Start: ast.Position{
								Column: 20,
								Line:   172,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 29,
									Line:   172,
								},
								File:   "universe.flux",
								Source: "value: A",
								Start: ast.Position{
									Column: 21,
									Line:   172,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 26,
										Line:   172,
									},
									File:   "universe.flux",
									Source: "value",
									Start: ast.Position{
										Column: 21,
										Line:   172,
									},
								},
							},
							Name: "value",
						},
						Ty: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   172,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 28,
										Line:   172,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   172,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 28,
											Line:   172,
										},
									},
								},
								Name: "A",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 39,
									Line:   172,
								},
								File:   "universe.flux",
								Source: "set: [A]",
								Start: ast.Position{
									Column: 31,
									Line:   172,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 34,
										Line:   172,
									},
									File:   "universe.flux",
									Source: "set",
									Start: ast.Position{
										Column: 31,
										Line:   172,
									},
								},
							},
							Name: "set",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 39,
										Line:   172,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 36,
										Line:   172,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 38,
											Line:   172,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 37,
											Line:   172,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 38,
												Line:   172,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 37,
												Line:   172,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 48,
									Line:   172,
								},
								File:   "universe.flux",
								Source: "bool",
								Start: ast.Position{
									Column: 44,
									Line:   172,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 48,
										Line:   172,
									},
									File:   "universe.flux",
									Source: "bool",
									Start: ast.Position{
										Column: 44,
										Line:   172,
									},
								},
							},
							Name: "bool",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// other builtins\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 12,
						Line:   175,
					},
					File:   "universe.flux",
					Source: "builtin inf",
					Start: ast.Position{
						Column: 1,
						Line:   175,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   175,
						},
						File:   "universe.flux",
						Source: "inf",
						Start: ast.Position{
							Column: 9,
							Line:   175,
						},
					},
				},
				Name: "inf",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 23,
							Line:   175,
						},
						File:   "universe.flux",
						Source: "duration",
						Start: ast.Position{
							Column: 15,
							Line:   175,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.NamedType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 23,
								Line:   175,
							},
							File:   "universe.flux",
							Source: "duration",
							Start: ast.Position{
								Column: 15,
								Line:   175,
							},
						},
					},
					ID: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 23,
									Line:   175,
								},
								File:   "universe.flux",
								Source: "duration",
								Start: ast.Position{
									Column: 15,
									Line:   175,
								},
							},
						},
						Name: "duration",
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 15,
						Line:   176,
					},
					File:   "universe.flux",
					Source: "builtin length",
					Start: ast.Position{
						Column: 1,
						Line:   176,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   176,
						},
						File:   "universe.flux",
						Source: "length",
						Start: ast.Position{
							Column: 9,
							Line:   176,
						},
					},
				},
				Name: "length",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 35,
							Line:   176,
						},
						File:   "universe.flux",
						Source: "(arr: [A]) => int",
						Start: ast.Position{
							Column: 18,
							Line:   176,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 35,
								Line:   176,
							},
							File:   "universe.flux",
							Source: "(arr: [A]) => int",
							Start: ast.Position{
								Column: 18,
								Line:   176,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 27,
									Line:   176,
								},
								File:   "universe.flux",
								Source: "arr: [A]",
								Start: ast.Position{
									Column: 19,
									Line:   176,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 22,
										Line:   176,
									},
									File:   "universe.flux",
									Source: "arr",
									Start: ast.Position{
										Column: 19,
										Line:   176,
									},
								},
							},
							Name: "arr",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 27,
										Line:   176,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 24,
										Line:   176,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 26,
											Line:   176,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 25,
											Line:   176,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 26,
												Line:   176,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 25,
												Line:   176,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 35,
									Line:   176,
								},
								File:   "universe.flux",
								Source: "int",
								Start: ast.Position{
									Column: 32,
									Line:   176,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 35,
										Line:   176,
									},
									File:   "universe.flux",
									Source: "int",
									Start: ast.Position{
										Column: 32,
										Line:   176,
									},
								},
							},
							Name: "int",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 19,
						Line:   177,
					},
					File:   "universe.flux",
					Source: "builtin linearBins",
					Start: ast.Position{
						Column: 1,
						Line:   177,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 19,
							Line:   177,
						},
						File:   "universe.flux",
						Source: "linearBins",
						Start: ast.Position{
							Column: 9,
							Line:   177,
						},
					},
				},
				Name: "linearBins",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 90,
							Line:   177,
						},
						File:   "universe.flux",
						Source: "(start: float, width: float, count: int, ?infinity: bool) => [float]",
						Start: ast.Position{
							Column: 22,
							Line:   177,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 90,
								Line:   177,
							},
							File:   "universe.flux",
							Source: "(start: float, width: float, count: int, ?infinity: bool) => [float]",
							Start: ast.Position{
								Column: 22,
								Line:   177,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 35,
									Line:   177,
								},
								File:   "universe.flux",
								Source: "start: float",
								Start: ast.Position{
									Column: 23,
									Line:   177,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 28,
										Line:   177,
									},
									File:   "universe.flux",
									Source: "start",
									Start: ast.Position{
										Column: 23,
										Line:   177,
									},
								},
							},
							Name: "start",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 35,
										Line:   177,
									},
									File:   "universe.flux",
									Source: "float",
									Start: ast.Position{
										Column: 30,
										Line:   177,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 35,
											Line:   177,
										},
										File:   "universe.flux",
										Source: "float",
										Start: ast.Position{
											Column: 30,
											Line:   177,
										},
									},
								},
								Name: "float",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 49,
									Line:   177,
								},
								File:   "universe.flux",
								Source: "width: float",
								Start: ast.Position{
									Column: 37,
									Line:   177,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   177,
									},
									File:   "universe.flux",
									Source: "width",
									Start: ast.Position{
										Column: 37,
										Line:   177,
									},
								},
							},
							Name: "width",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 49,
										Line:   177,
									},
									File:   "universe.flux",
									Source: "float",
									Start: ast.Position{
										Column: 44,
										Line:   177,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 49,
											Line:   177,
										},
										File:   "universe.flux",
										Source: "float",
										Start: ast.Position{
											Column: 44,
											Line:   177,
										},
									},
								},
								Name: "float",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 61,
									Line:   177,
								},
								File:   "universe.flux",
								Source: "count: int",
								Start: ast.Position{
									Column: 51,
									Line:   177,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 56,
										Line:   177,
									},
									File:   "universe.flux",
									Source: "count",
									Start: ast.Position{
										Column: 51,
										Line:   177,
									},
								},
							},
							Name: "count",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 61,
										Line:   177,
									},
									File:   "universe.flux",
									Source: "int",
									Start: ast.Position{
										Column: 58,
										Line:   177,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 61,
											Line:   177,
										},
										File:   "universe.flux",
										Source: "int",
										Start: ast.Position{
											Column: 58,
											Line:   177,
										},
									},
								},
								Name: "int",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 78,
									Line:   177,
								},
								File:   "universe.flux",
								Source: "?infinity: bool",
								Start: ast.Position{
									Column: 63,
									Line:   177,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 72,
										Line:   177,
									},
									File:   "universe.flux",
									Source: "infinity",
									Start: ast.Position{
										Column: 64,
										Line:   177,
									},
								},
							},
							Name: "infinity",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 78,
										Line:   177,
									},
									File:   "universe.flux",
									Source: "bool",
									Start: ast.Position{
										Column: 74,
										Line:   177,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 78,
											Line:   177,
										},
										File:   "universe.flux",
										Source: "bool",
										Start: ast.Position{
											Column: 74,
											Line:   177,
										},
									},
								},
								Name: "bool",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 90,
									Line:   177,
								},
								File:   "universe.flux",
								Source: "[float]",
								Start: ast.Position{
									Column: 83,
									Line:   177,
								},
							},
						},
						ElementType: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 89,
										Line:   177,
									},
									File:   "universe.flux",
									Source: "float",
									Start: ast.Position{
										Column: 84,
										Line:   177,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 89,
											Line:   177,
										},
										File:   "universe.flux",
										Source: "float",
										Start: ast.Position{
											Column: 84,
											Line:   177,
										},
									},
								},
								Name: "float",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 24,
						Line:   178,
					},
					File:   "universe.flux",
					Source: "builtin logarithmicBins",
					Start: ast.Position{
						Column: 1,
						Line:   178,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 24,
							Line:   178,
						},
						File:   "universe.flux",
						Source: "logarithmicBins",
						Start: ast.Position{
							Column: 9,
							Line:   178,
						},
					},
				},
				Name: "logarithmicBins",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 96,
							Line:   178,
						},
						File:   "universe.flux",
						Source: "(start: float, factor: float, count: int, ?infinity: bool) => [float]",
						Start: ast.Position{
							Column: 27,
							Line:   178,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 96,
								Line:   178,
							},
							File:   "universe.flux",
							Source: "(start: float, factor: float, count: int, ?infinity: bool) => [float]",
							Start: ast.Position{
								Column: 27,
								Line:   178,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   178,
								},
								File:   "universe.flux",
								Source: "start: float",
								Start: ast.Position{
									Column: 28,
									Line:   178,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 33,
										Line:   178,
									},
									File:   "universe.flux",
									Source: "start",
									Start: ast.Position{
										Column: 28,
										Line:   178,
									},
								},
							},
							Name: "start",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   178,
									},
									File:   "universe.flux",
									Source: "float",
									Start: ast.Position{
										Column: 35,
										Line:   178,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   178,
										},
										File:   "universe.flux",
										Source: "float",
										Start: ast.Position{
											Column: 35,
											Line:   178,
										},
									},
								},
								Name: "float",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 55,
									Line:   178,
								},
								File:   "universe.flux",
								Source: "factor: float",
								Start: ast.Position{
									Column: 42,
									Line:   178,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 48,
										Line:   178,
									},
									File:   "universe.flux",
									Source: "factor",
									Start: ast.Position{
										Column: 42,
										Line:   178,
									},
								},
							},
							Name: "factor",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 55,
										Line:   178,
									},
									File:   "universe.flux",
									Source: "float",
									Start: ast.Position{
										Column: 50,
										Line:   178,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 55,
											Line:   178,
										},
										File:   "universe.flux",
										Source: "float",
										Start: ast.Position{
											Column: 50,
											Line:   178,
										},
									},
								},
								Name: "float",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 67,
									Line:   178,
								},
								File:   "universe.flux",
								Source: "count: int",
								Start: ast.Position{
									Column: 57,
									Line:   178,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 62,
										Line:   178,
									},
									File:   "universe.flux",
									Source: "count",
									Start: ast.Position{
										Column: 57,
										Line:   178,
									},
								},
							},
							Name: "count",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 67,
										Line:   178,
									},
									File:   "universe.flux",
									Source: "int",
									Start: ast.Position{
										Column: 64,
										Line:   178,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 67,
											Line:   178,
										},
										File:   "universe.flux",
										Source: "int",
										Start: ast.Position{
											Column: 64,
											Line:   178,
										},
									},
								},
								Name: "int",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 84,
									Line:   178,
								},
								File:   "universe.flux",
								Source: "?infinity: bool",
								Start: ast.Position{
									Column: 69,
									Line:   178,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 78,
										Line:   178,
									},
									File:   "universe.flux",
									Source: "infinity",
									Start: ast.Position{
										Column: 70,
										Line:   178,
									},
								},
							},
							Name: "infinity",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 84,
										Line:   178,
									},
									File:   "universe.flux",
									Source: "bool",
									Start: ast.Position{
										Column: 80,
										Line:   178,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 84,
											Line:   178,
										},
										File:   "universe.flux",
										Source: "bool",
										Start: ast.Position{
											Column: 80,
											Line:   178,
										},
									},
								},
								Name: "bool",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 96,
									Line:   178,
								},
								File:   "universe.flux",
								Source: "[float]",
								Start: ast.Position{
									Column: 89,
									Line:   178,
								},
							},
						},
						ElementType: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 95,
										Line:   178,
									},
									File:   "universe.flux",
									Source: "float",
									Start: ast.Position{
										Column: 90,
										Line:   178,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 95,
											Line:   178,
										},
										File:   "universe.flux",
										Source: "float",
										Start: ast.Position{
											Column: 90,
											Line:   178,
										},
									},
								},
								Name: "float",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// sleep is the identity function with the side effect of delaying execution by a specified duration\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   181,
					},
					File:   "universe.flux",
					Source: "builtin sleep",
					Start: ast.Position{
						Column: 1,
						Line:   181,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   181,
						},
						File:   "universe.flux",
						Source: "sleep",
						Start: ast.Position{
							Column: 9,
							Line:   181,
						},
					},
				},
				Name: "sleep",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 50,
							Line:   181,
						},
						File:   "universe.flux",
						Source: "(<-v: A, duration: duration) => A",
						Start: ast.Position{
							Column: 17,
							Line:   181,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 50,
								Line:   181,
							},
							File:   "universe.flux",
							Source: "(<-v: A, duration: duration) => A",
							Start: ast.Position{
								Column: 17,
								Line:   181,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 24,
									Line:   181,
								},
								File:   "universe.flux",
								Source: "<-v: A",
								Start: ast.Position{
									Column: 18,
									Line:   181,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 21,
										Line:   181,
									},
									File:   "universe.flux",
									Source: "v",
									Start: ast.Position{
										Column: 20,
										Line:   181,
									},
								},
							},
							Name: "v",
						},
						Ty: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 24,
										Line:   181,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 23,
										Line:   181,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 24,
											Line:   181,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 23,
											Line:   181,
										},
									},
								},
								Name: "A",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 44,
									Line:   181,
								},
								File:   "universe.flux",
								Source: "duration: duration",
								Start: ast.Position{
									Column: 26,
									Line:   181,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 34,
										Line:   181,
									},
									File:   "universe.flux",
									Source: "duration",
									Start: ast.Position{
										Column: 26,
										Line:   181,
									},
								},
							},
							Name: "duration",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 44,
										Line:   181,
									},
									File:   "universe.flux",
									Source: "duration",
									Start: ast.Position{
										Column: 36,
										Line:   181,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 44,
											Line:   181,
										},
										File:   "universe.flux",
										Source: "duration",
										Start: ast.Position{
											Column: 36,
											Line:   181,
										},
									},
								},
								Name: "duration",
							},
						},
					}},
					Return: &ast.TvarType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 50,
									Line:   181,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 49,
									Line:   181,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 50,
										Line:   181,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 49,
										Line:   181,
									},
								},
							},
							Name: "A",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// die returns a fatal error from within a flux script\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 12,
						Line:   184,
					},
					File:   "universe.flux",
					Source: "builtin die",
					Start: ast.Position{
						Column: 1,
						Line:   184,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   184,
						},
						File:   "universe.flux",
						Source: "die",
						Start: ast.Position{
							Column: 9,
							Line:   184,
						},
					},
				},
				Name: "die",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 33,
							Line:   184,
						},
						File:   "universe.flux",
						Source: "(msg: string) => A",
						Start: ast.Position{
							Column: 15,
							Line:   184,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 33,
								Line:   184,
							},
							File:   "universe.flux",
							Source: "(msg: string) => A",
							Start: ast.Position{
								Column: 15,
								Line:   184,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 27,
									Line:   184,
								},
								File:   "universe.flux",
								Source: "msg: string",
								Start: ast.Position{
									Column: 16,
									Line:   184,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 19,
										Line:   184,
									},
									File:   "universe.flux",
									Source: "msg",
									Start: ast.Position{
										Column: 16,
										Line:   184,
									},
								},
							},
							Name: "msg",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 27,
										Line:   184,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 21,
										Line:   184,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 27,
											Line:   184,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 21,
											Line:   184,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.TvarType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 33,
									Line:   184,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 32,
									Line:   184,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 33,
										Line:   184,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 32,
										Line:   184,
									},
								},
							},
							Name: "A",
						},
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 124,
						Line:   189,
					},
					File:   "universe.flux",
					Source: "timeWeightedAvg = (tables=<-, unit) => tables\n    |> integral(unit: unit, interpolate: \"linear\")\n    |> map(fn: (r) => ({r with _value: r._value * float(v: uint(v: unit)) / float(v: int(v: r._stop) - int(v: r._start))}))",
					Start: ast.Position{
						Column: 1,
						Line:   187,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// Time weighted average where values at the beginning and end of the range are linearly interpolated.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 16,
							Line:   187,
						},
						File:   "universe.flux",
						Source: "timeWeightedAvg",
						Start: ast.Position{
							Column: 1,
							Line:   187,
						},
					},
				},
				Name: "timeWeightedAvg",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 124,
							Line:   189,
						},
						File:   "universe.flux",
						Source: "(tables=<-, unit) => tables\n    |> integral(unit: unit, interpolate: \"linear\")\n    |> map(fn: (r) => ({r with _value: r._value * float(v: uint(v: unit)) / float(v: int(v: r._stop) - int(v: r._start))}))",
						Start: ast.Position{
							Column: 19,
							Line:   187,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 46,
										Line:   187,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 40,
										Line:   187,
									},
								},
							},
							Name: "tables",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 51,
									Line:   188,
								},
								File:   "universe.flux",
								Source: "tables\n    |> integral(unit: unit, interpolate: \"linear\")",
								Start: ast.Position{
									Column: 40,
									Line:   187,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 50,
											Line:   188,
										},
										File:   "universe.flux",
										Source: "unit: unit, interpolate: \"linear\"",
										Start: ast.Position{
											Column: 17,
											Line:   188,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 27,
												Line:   188,
											},
											File:   "universe.flux",
											Source: "unit: unit",
											Start: ast.Position{
												Column: 17,
												Line:   188,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 21,
													Line:   188,
												},
												File:   "universe.flux",
												Source: "unit",
												Start: ast.Position{
													Column: 17,
													Line:   188,
												},
											},
										},
										Name: "unit",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 27,
													Line:   188,
												},
												File:   "universe.flux",
												Source: "unit",
												Start: ast.Position{
													Column: 23,
													Line:   188,
												},
											},
										},
										Name: "unit",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 50,
												Line:   188,
											},
											File:   "universe.flux",
											Source: "interpolate: \"linear\"",
											Start: ast.Position{
												Column: 29,
												Line:   188,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 40,
													Line:   188,
												},
												File:   "universe.flux",
												Source: "interpolate",
												Start: ast.Position{
													Column: 29,
													Line:   188,
												},
											},
										},
										Name: "interpolate",
									},
									Separator: nil,
									Value: &ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 50,
													Line:   188,
												},
												File:   "universe.flux",
												Source: "\"linear\"",
												Start: ast.Position{
													Column: 42,
													Line:   188,
												},
											},
										},
										Value: "linear",
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 51,
										Line:   188,
									},
									File:   "universe.flux",
									Source: "integral(unit: unit, interpolate: \"linear\")",
									Start: ast.Position{
										Column: 8,
										Line:   188,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 16,
											Line:   188,
										},
										File:   "universe.flux",
										Source: "integral",
										Start: ast.Position{
											Column: 8,
											Line:   188,
										},
									},
								},
								Name: "integral",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 124,
								Line:   189,
							},
							File:   "universe.flux",
							Source: "tables\n    |> integral(unit: unit, interpolate: \"linear\")\n    |> map(fn: (r) => ({r with _value: r._value * float(v: uint(v: unit)) / float(v: int(v: r._stop) - int(v: r._start))}))",
							Start: ast.Position{
								Column: 40,
								Line:   187,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 123,
										Line:   189,
									},
									File:   "universe.flux",
									Source: "fn: (r) => ({r with _value: r._value * float(v: uint(v: unit)) / float(v: int(v: r._stop) - int(v: r._start))})",
									Start: ast.Position{
										Column: 12,
										Line:   189,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 123,
											Line:   189,
										},
										File:   "universe.flux",
										Source: "fn: (r) => ({r with _value: r._value * float(v: uint(v: unit)) / float(v: int(v: r._stop) - int(v: r._start))})",
										Start: ast.Position{
											Column: 12,
											Line:   189,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   189,
											},
											File:   "universe.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 12,
												Line:   189,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.FunctionExpression{
									Arrow: nil,
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 123,
												Line:   189,
											},
											File:   "universe.flux",
											Source: "(r) => ({r with _value: r._value * float(v: uint(v: unit)) / float(v: int(v: r._stop) - int(v: r._start))})",
											Start: ast.Position{
												Column: 16,
												Line:   189,
											},
										},
									},
									Body: &ast.ParenExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 123,
													Line:   189,
												},
												File:   "universe.flux",
												Source: "({r with _value: r._value * float(v: uint(v: unit)) / float(v: int(v: r._stop) - int(v: r._start))})",
												Start: ast.Position{
													Column: 23,
													Line:   189,
												},
											},
										},
										Expression: &ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 122,
														Line:   189,
													},
													File:   "universe.flux",
													Source: "{r with _value: r._value * float(v: uint(v: unit)) / float(v: int(v: r._stop) - int(v: r._start))}",
													Start: ast.Position{
														Column: 24,
														Line:   189,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 121,
															Line:   189,
														},
														File:   "universe.flux",
														Source: "_value: r._value * float(v: uint(v: unit)) / float(v: int(v: r._stop) - int(v: r._start))",
														Start: ast.Position{
															Column: 32,
															Line:   189,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 38,
																Line:   189,
															},
															File:   "universe.flux",
															Source: "_value",
															Start: ast.Position{
																Column: 32,
																Line:   189,
															},
														},
													},
													Name: "_value",
												},
												Separator: nil,
												Value: &ast.BinaryExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 121,
																Line:   189,
															},
															File:   "universe.flux",
															Source: "r._value * float(v: uint(v: unit)) / float(v: int(v: r._stop) - int(v: r._start))",
															Start: ast.Position{
																Column: 40,
																Line:   189,
															},
														},
													},
													Left: &ast.BinaryExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 74,
																	Line:   189,
																},
																File:   "universe.flux",
																Source: "r._value * float(v: uint(v: unit))",
																Start: ast.Position{
																	Column: 40,
																	Line:   189,
																},
															},
														},
														Left: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 48,
																		Line:   189,
																	},
																	File:   "universe.flux",
																	Source: "r._value",
																	Start: ast.Position{
																		Column: 40,
																		Line:   189,
																	},
																},
															},
															Lbrack: nil,
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 41,
																			Line:   189,
																		},
																		File:   "universe.flux",
																		Source: "r",
																		Start: ast.Position{
																			Column: 40,
																			Line:   189,
																		},
																	},
																},
																Name: "r",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 48,
																			Line:   189,
																		},
																		File:   "universe.flux",
																		Source: "_value",
																		Start: ast.Position{
																			Column: 42,
																			Line:   189,
																		},
																	},
																},
																Name: "_value",
															},
															Rbrack: nil,
														},
														Operator: 1,
														Right: &ast.CallExpression{
															Arguments: []ast.Expression{&ast.ObjectExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 73,
																			Line:   189,
																		},
																		File:   "universe.flux",
																		Source: "v: uint(v: unit)",
																		Start: ast.Position{
																			Column: 57,
																			Line:   189,
																		},
																	},
																},
																Lbrace: nil,
																Properties: []*ast.Property{&ast.Property{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 73,
																				Line:   189,
																			},
																			File:   "universe.flux",
																			Source: "v: uint(v: unit)",
																			Start: ast.Position{
																				Column: 57,
																				Line:   189,
																			},
																		},
																	},
																	Comma: nil,
																	Key: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 58,
																					Line:   189,
																				},
																				File:   "universe.flux",
																				Source: "v",
																				Start: ast.Position{
																					Column: 57,
																					Line:   189,
																				},
																			},
																		},
																		Name: "v",
																	},
																	Separator: nil,
																	Value: &ast.CallExpression{
																		Arguments: []ast.Expression{&ast.ObjectExpression{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 72,
																						Line:   189,
																					},
																					File:   "universe.flux",
																					Source: "v: unit",
																					Start: ast.Position{
																						Column: 65,
																						Line:   189,
																					},
																				},
																			},
																			Lbrace: nil,
																			Properties: []*ast.Property{&ast.Property{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 72,
																							Line:   189,
																						},
																						File:   "universe.flux",
																						Source: "v: unit",
																						Start: ast.Position{
																							Column: 65,
																							Line:   189,
																						},
																					},
																				},
																				Comma: nil,
																				Key: &ast.Identifier{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 66,
																								Line:   189,
																							},
																							File:   "universe.flux",
																							Source: "v",
																							Start: ast.Position{
																								Column: 65,
																								Line:   189,
																							},
																						},
																					},
																					Name: "v",
																				},
																				Separator: nil,
																				Value: &ast.Identifier{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 72,
																								Line:   189,
																							},
																							File:   "universe.flux",
																							Source: "unit",
																							Start: ast.Position{
																								Column: 68,
																								Line:   189,
																							},
																						},
																					},
																					Name: "unit",
																				},
																			}},
																			Rbrace: nil,
																			With:   nil,
																		}},
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 73,
																					Line:   189,
																				},
																				File:   "universe.flux",
																				Source: "uint(v: unit)",
																				Start: ast.Position{
																					Column: 60,
																					Line:   189,
																				},
																			},
																		},
																		Callee: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 64,
																						Line:   189,
																					},
																					File:   "universe.flux",
																					Source: "uint",
																					Start: ast.Position{
																						Column: 60,
																						Line:   189,
																					},
																				},
																			},
																			Name: "uint",
																		},
																		Lparen: nil,
																		Rparen: nil,
																	},
																}},
																Rbrace: nil,
																With:   nil,
															}},
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 74,
																		Line:   189,
																	},
																	File:   "universe.flux",
																	Source: "float(v: uint(v: unit))",
																	Start: ast.Position{
																		Column: 51,
																		Line:   189,
																	},
																},
															},
															Callee: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 56,
																			Line:   189,
																		},
																		File:   "universe.flux",
																		Source: "float",
																		Start: ast.Position{
																			Column: 51,
																			Line:   189,
																		},
																	},
																},
																Name: "float",
															},
															Lparen: nil,
															Rparen: nil,
														},
													},
													Operator: 2,
													Right: &ast.CallExpression{
														Arguments: []ast.Expression{&ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 120,
																		Line:   189,
																	},
																	File:   "universe.flux",
																	Source: "v: int(v: r._stop) - int(v: r._start)",
																	Start: ast.Position{
																		Column: 83,
																		Line:   189,
																	},
																},
															},
															Lbrace: nil,
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 120,
																			Line:   189,
																		},
																		File:   "universe.flux",
																		Source: "v: int(v: r._stop) - int(v: r._start)",
																		Start: ast.Position{
																			Column: 83,
																			Line:   189,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 84,
																				Line:   189,
																			},
																			File:   "universe.flux",
																			Source: "v",
																			Start: ast.Position{
																				Column: 83,
																				Line:   189,
																			},
																		},
																	},
																	Name: "v",
																},
																Separator: nil,
																Value: &ast.BinaryExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 120,
																				Line:   189,
																			},
																			File:   "universe.flux",
																			Source: "int(v: r._stop) - int(v: r._start)",
																			Start: ast.Position{
																				Column: 86,
																				Line:   189,
																			},
																		},
																	},
																	Left: &ast.CallExpression{
																		Arguments: []ast.Expression{&ast.ObjectExpression{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 100,
																						Line:   189,
																					},
																					File:   "universe.flux",
																					Source: "v: r._stop",
																					Start: ast.Position{
																						Column: 90,
																						Line:   189,
																					},
																				},
																			},
																			Lbrace: nil,
																			Properties: []*ast.Property{&ast.Property{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 100,
																							Line:   189,
																						},
																						File:   "universe.flux",
																						Source: "v: r._stop",
																						Start: ast.Position{
																							Column: 90,
																							Line:   189,
																						},
																					},
																				},
																				Comma: nil,
																				Key: &ast.Identifier{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 91,
																								Line:   189,
																							},
																							File:   "universe.flux",
																							Source: "v",
																							Start: ast.Position{
																								Column: 90,
																								Line:   189,
																							},
																						},
																					},
																					Name: "v",
																				},
																				Separator: nil,
																				Value: &ast.MemberExpression{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 100,
																								Line:   189,
																							},
																							File:   "universe.flux",
																							Source: "r._stop",
																							Start: ast.Position{
																								Column: 93,
																								Line:   189,
																							},
																						},
																					},
																					Lbrack: nil,
																					Object: &ast.Identifier{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 94,
																									Line:   189,
																								},
																								File:   "universe.flux",
																								Source: "r",
																								Start: ast.Position{
																									Column: 93,
																									Line:   189,
																								},
																							},
																						},
																						Name: "r",
																					},
																					Property: &ast.Identifier{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 100,
																									Line:   189,
																								},
																								File:   "universe.flux",
																								Source: "_stop",
																								Start: ast.Position{
																									Column: 95,
																									Line:   189,
																								},
																							},
																						},
																						Name: "_stop",
																					},
																					Rbrack: nil,
																				},
																			}},
																			Rbrace: nil,
																			With:   nil,
																		}},
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 101,
																					Line:   189,
																				},
																				File:   "universe.flux",
																				Source: "int(v: r._stop)",
																				Start: ast.Position{
																					Column: 86,
																					Line:   189,
																				},
																			},
																		},
																		Callee: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 89,
																						Line:   189,
																					},
																					File:   "universe.flux",
																					Source: "int",
																					Start: ast.Position{
																						Column: 86,
																						Line:   189,
																					},
																				},
																			},
																			Name: "int",
																		},
																		Lparen: nil,
																		Rparen: nil,
																	},
																	Operator: 6,
																	Right: &ast.CallExpression{
																		Arguments: []ast.Expression{&ast.ObjectExpression{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 119,
																						Line:   189,
																					},
																					File:   "universe.flux",
																					Source: "v: r._start",
																					Start: ast.Position{
																						Column: 108,
																						Line:   189,
																					},
																				},
																			},
																			Lbrace: nil,
																			Properties: []*ast.Property{&ast.Property{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 119,
																							Line:   189,
																						},
																						File:   "universe.flux",
																						Source: "v: r._start",
																						Start: ast.Position{
																							Column: 108,
																							Line:   189,
																						},
																					},
																				},
																				Comma: nil,
																				Key: &ast.Identifier{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 109,
																								Line:   189,
																							},
																							File:   "universe.flux",
																							Source: "v",
																							Start: ast.Position{
																								Column: 108,
																								Line:   189,
																							},
																						},
																					},
																					Name: "v",
																				},
																				Separator: nil,
																				Value: &ast.MemberExpression{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 119,
																								Line:   189,
																							},
																							File:   "universe.flux",
																							Source: "r._start",
																							Start: ast.Position{
																								Column: 111,
																								Line:   189,
																							},
																						},
																					},
																					Lbrack: nil,
																					Object: &ast.Identifier{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 112,
																									Line:   189,
																								},
																								File:   "universe.flux",
																								Source: "r",
																								Start: ast.Position{
																									Column: 111,
																									Line:   189,
																								},
																							},
																						},
																						Name: "r",
																					},
																					Property: &ast.Identifier{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 119,
																									Line:   189,
																								},
																								File:   "universe.flux",
																								Source: "_start",
																								Start: ast.Position{
																									Column: 113,
																									Line:   189,
																								},
																							},
																						},
																						Name: "_start",
																					},
																					Rbrack: nil,
																				},
																			}},
																			Rbrace: nil,
																			With:   nil,
																		}},
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 120,
																					Line:   189,
																				},
																				File:   "universe.flux",
																				Source: "int(v: r._start)",
																				Start: ast.Position{
																					Column: 104,
																					Line:   189,
																				},
																			},
																		},
																		Callee: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 107,
																						Line:   189,
																					},
																					File:   "universe.flux",
																					Source: "int",
																					Start: ast.Position{
																						Column: 104,
																						Line:   189,
																					},
																				},
																			},
																			Name: "int",
																		},
																		Lparen: nil,
																		Rparen: nil,
																	},
																},
															}},
															Rbrace: nil,
															With:   nil,
														}},
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 121,
																	Line:   189,
																},
																File:   "universe.flux",
																Source: "float(v: int(v: r._stop) - int(v: r._start))",
																Start: ast.Position{
																	Column: 77,
																	Line:   189,
																},
															},
														},
														Callee: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 82,
																		Line:   189,
																	},
																	File:   "universe.flux",
																	Source: "float",
																	Start: ast.Position{
																		Column: 77,
																		Line:   189,
																	},
																},
															},
															Name: "float",
														},
														Lparen: nil,
														Rparen: nil,
													},
												},
											}},
											Rbrace: nil,
											With: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 26,
															Line:   189,
														},
														File:   "universe.flux",
														Source: "r",
														Start: ast.Position{
															Column: 25,
															Line:   189,
														},
													},
												},
												Name: "r",
											},
										},
										Lparen: nil,
										Rparen: nil,
									},
									Lparen: nil,
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   189,
												},
												File:   "universe.flux",
												Source: "r",
												Start: ast.Position{
													Column: 17,
													Line:   189,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   189,
													},
													File:   "universe.flux",
													Source: "r",
													Start: ast.Position{
														Column: 17,
														Line:   189,
													},
												},
											},
											Name: "r",
										},
										Separator: nil,
										Value:     nil,
									}},
									Rparan: nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 124,
									Line:   189,
								},
								File:   "universe.flux",
								Source: "map(fn: (r) => ({r with _value: r._value * float(v: uint(v: unit)) / float(v: int(v: r._stop) - int(v: r._start))}))",
								Start: ast.Position{
									Column: 8,
									Line:   189,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   189,
									},
									File:   "universe.flux",
									Source: "map",
									Start: ast.Position{
										Column: 8,
										Line:   189,
									},
								},
							},
							Name: "map",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 29,
								Line:   187,
							},
							File:   "universe.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 20,
								Line:   187,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   187,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 20,
									Line:   187,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 29,
								Line:   187,
							},
							File:   "universe.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 27,
								Line:   187,
							},
						},
					}},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 35,
								Line:   187,
							},
							File:   "universe.flux",
							Source: "unit",
							Start: ast.Position{
								Column: 31,
								Line:   187,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 35,
									Line:   187,
								},
								File:   "universe.flux",
								Source: "unit",
								Start: ast.Position{
									Column: 31,
									Line:   187,
								},
							},
						},
						Name: "unit",
					},
					Separator: nil,
					Value:     nil,
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 73,
						Line:   196,
					},
					File:   "universe.flux",
					Source: "cov = (x, y, on, pearsonr=false) => join(\n    tables: {x: x, y: y},\n    on: on,\n)\n    |> covariance(pearsonr: pearsonr, columns: [\"_value_x\", \"_value_y\"])",
					Start: ast.Position{
						Column: 1,
						Line:   192,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// covariance function with automatic join\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 4,
							Line:   192,
						},
						File:   "universe.flux",
						Source: "cov",
						Start: ast.Position{
							Column: 1,
							Line:   192,
						},
					},
				},
				Name: "cov",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 73,
							Line:   196,
						},
						File:   "universe.flux",
						Source: "(x, y, on, pearsonr=false) => join(\n    tables: {x: x, y: y},\n    on: on,\n)\n    |> covariance(pearsonr: pearsonr, columns: [\"_value_x\", \"_value_y\"])",
						Start: ast.Position{
							Column: 7,
							Line:   192,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   194,
									},
									File:   "universe.flux",
									Source: "tables: {x: x, y: y},\n    on: on",
									Start: ast.Position{
										Column: 5,
										Line:   193,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 25,
											Line:   193,
										},
										File:   "universe.flux",
										Source: "tables: {x: x, y: y}",
										Start: ast.Position{
											Column: 5,
											Line:   193,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   193,
											},
											File:   "universe.flux",
											Source: "tables",
											Start: ast.Position{
												Column: 5,
												Line:   193,
											},
										},
									},
									Name: "tables",
								},
								Separator: nil,
								Value: &ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 25,
												Line:   193,
											},
											File:   "universe.flux",
											Source: "{x: x, y: y}",
											Start: ast.Position{
												Column: 13,
												Line:   193,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   193,
												},
												File:   "universe.flux",
												Source: "x: x",
												Start: ast.Position{
													Column: 14,
													Line:   193,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 15,
														Line:   193,
													},
													File:   "universe.flux",
													Source: "x",
													Start: ast.Position{
														Column: 14,
														Line:   193,
													},
												},
											},
											Name: "x",
										},
										Separator: nil,
										Value: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   193,
													},
													File:   "universe.flux",
													Source: "x",
													Start: ast.Position{
														Column: 17,
														Line:   193,
													},
												},
											},
											Name: "x",
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 24,
													Line:   193,
												},
												File:   "universe.flux",
												Source: "y: y",
												Start: ast.Position{
													Column: 20,
													Line:   193,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 21,
														Line:   193,
													},
													File:   "universe.flux",
													Source: "y",
													Start: ast.Position{
														Column: 20,
														Line:   193,
													},
												},
											},
											Name: "y",
										},
										Separator: nil,
										Value: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 24,
														Line:   193,
													},
													File:   "universe.flux",
													Source: "y",
													Start: ast.Position{
														Column: 23,
														Line:   193,
													},
												},
											},
											Name: "y",
										},
									}},
									Rbrace: nil,
									With:   nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 11,
											Line:   194,
										},
										File:   "universe.flux",
										Source: "on: on",
										Start: ast.Position{
											Column: 5,
											Line:   194,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 7,
												Line:   194,
											},
											File:   "universe.flux",
											Source: "on",
											Start: ast.Position{
												Column: 5,
												Line:   194,
											},
										},
									},
									Name: "on",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   194,
											},
											File:   "universe.flux",
											Source: "on",
											Start: ast.Position{
												Column: 9,
												Line:   194,
											},
										},
									},
									Name: "on",
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 2,
									Line:   195,
								},
								File:   "universe.flux",
								Source: "join(\n    tables: {x: x, y: y},\n    on: on,\n)",
								Start: ast.Position{
									Column: 37,
									Line:   192,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   192,
									},
									File:   "universe.flux",
									Source: "join",
									Start: ast.Position{
										Column: 37,
										Line:   192,
									},
								},
							},
							Name: "join",
						},
						Lparen: nil,
						Rparen: nil,
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 73,
								Line:   196,
							},
							File:   "universe.flux",
							Source: "join(\n    tables: {x: x, y: y},\n    on: on,\n)\n    |> covariance(pearsonr: pearsonr, columns: [\"_value_x\", \"_value_y\"])",
							Start: ast.Position{
								Column: 37,
								Line:   192,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 72,
										Line:   196,
									},
									File:   "universe.flux",
									Source: "pearsonr: pearsonr, columns: [\"_value_x\", \"_value_y\"]",
									Start: ast.Position{
										Column: 19,
										Line:   196,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 37,
											Line:   196,
										},
										File:   "universe.flux",
										Source: "pearsonr: pearsonr",
										Start: ast.Position{
											Column: 19,
											Line:   196,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 27,
												Line:   196,
											},
											File:   "universe.flux",
											Source: "pearsonr",
											Start: ast.Position{
												Column: 19,
												Line:   196,
											},
										},
									},
									Name: "pearsonr",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 37,
												Line:   196,
											},
											File:   "universe.flux",
											Source: "pearsonr",
											Start: ast.Position{
												Column: 29,
												Line:   196,
											},
										},
									},
									Name: "pearsonr",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 72,
											Line:   196,
										},
										File:   "universe.flux",
										Source: "columns: [\"_value_x\", \"_value_y\"]",
										Start: ast.Position{
											Column: 39,
											Line:   196,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 46,
												Line:   196,
											},
											File:   "universe.flux",
											Source: "columns",
											Start: ast.Position{
												Column: 39,
												Line:   196,
											},
										},
									},
									Name: "columns",
								},
								Separator: nil,
								Value: &ast.ArrayExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 72,
												Line:   196,
											},
											File:   "universe.flux",
											Source: "[\"_value_x\", \"_value_y\"]",
											Start: ast.Position{
												Column: 48,
												Line:   196,
											},
										},
									},
									Elements: []ast.Expression{&ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 59,
													Line:   196,
												},
												File:   "universe.flux",
												Source: "\"_value_x\"",
												Start: ast.Position{
													Column: 49,
													Line:   196,
												},
											},
										},
										Value: "_value_x",
									}, &ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 71,
													Line:   196,
												},
												File:   "universe.flux",
												Source: "\"_value_y\"",
												Start: ast.Position{
													Column: 61,
													Line:   196,
												},
											},
										},
										Value: "_value_y",
									}},
									Lbrack: nil,
									Rbrack: nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 73,
									Line:   196,
								},
								File:   "universe.flux",
								Source: "covariance(pearsonr: pearsonr, columns: [\"_value_x\", \"_value_y\"])",
								Start: ast.Position{
									Column: 8,
									Line:   196,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   196,
									},
									File:   "universe.flux",
									Source: "covariance",
									Start: ast.Position{
										Column: 8,
										Line:   196,
									},
								},
							},
							Name: "covariance",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 9,
								Line:   192,
							},
							File:   "universe.flux",
							Source: "x",
							Start: ast.Position{
								Column: 8,
								Line:   192,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 9,
									Line:   192,
								},
								File:   "universe.flux",
								Source: "x",
								Start: ast.Position{
									Column: 8,
									Line:   192,
								},
							},
						},
						Name: "x",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 12,
								Line:   192,
							},
							File:   "universe.flux",
							Source: "y",
							Start: ast.Position{
								Column: 11,
								Line:   192,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 12,
									Line:   192,
								},
								File:   "universe.flux",
								Source: "y",
								Start: ast.Position{
									Column: 11,
									Line:   192,
								},
							},
						},
						Name: "y",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 16,
								Line:   192,
							},
							File:   "universe.flux",
							Source: "on",
							Start: ast.Position{
								Column: 14,
								Line:   192,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   192,
								},
								File:   "universe.flux",
								Source: "on",
								Start: ast.Position{
									Column: 14,
									Line:   192,
								},
							},
						},
						Name: "on",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 32,
								Line:   192,
							},
							File:   "universe.flux",
							Source: "pearsonr=false",
							Start: ast.Position{
								Column: 18,
								Line:   192,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   192,
								},
								File:   "universe.flux",
								Source: "pearsonr",
								Start: ast.Position{
									Column: 18,
									Line:   192,
								},
							},
						},
						Name: "pearsonr",
					},
					Separator: nil,
					Value: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   192,
								},
								File:   "universe.flux",
								Source: "false",
								Start: ast.Position{
									Column: 27,
									Line:   192,
								},
							},
						},
						Name: "false",
					},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 65,
						Line:   197,
					},
					File:   "universe.flux",
					Source: "pearsonr = (x, y, on) => cov(x: x, y: y, on: on, pearsonr: true)",
					Start: ast.Position{
						Column: 1,
						Line:   197,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 9,
							Line:   197,
						},
						File:   "universe.flux",
						Source: "pearsonr",
						Start: ast.Position{
							Column: 1,
							Line:   197,
						},
					},
				},
				Name: "pearsonr",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 65,
							Line:   197,
						},
						File:   "universe.flux",
						Source: "(x, y, on) => cov(x: x, y: y, on: on, pearsonr: true)",
						Start: ast.Position{
							Column: 12,
							Line:   197,
						},
					},
				},
				Body: &ast.CallExpression{
					Arguments: []ast.Expression{&ast.ObjectExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 64,
									Line:   197,
								},
								File:   "universe.flux",
								Source: "x: x, y: y, on: on, pearsonr: true",
								Start: ast.Position{
									Column: 30,
									Line:   197,
								},
							},
						},
						Lbrace: nil,
						Properties: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 34,
										Line:   197,
									},
									File:   "universe.flux",
									Source: "x: x",
									Start: ast.Position{
										Column: 30,
										Line:   197,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 31,
											Line:   197,
										},
										File:   "universe.flux",
										Source: "x",
										Start: ast.Position{
											Column: 30,
											Line:   197,
										},
									},
								},
								Name: "x",
							},
							Separator: nil,
							Value: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 34,
											Line:   197,
										},
										File:   "universe.flux",
										Source: "x",
										Start: ast.Position{
											Column: 33,
											Line:   197,
										},
									},
								},
								Name: "x",
							},
						}, &ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   197,
									},
									File:   "universe.flux",
									Source: "y: y",
									Start: ast.Position{
										Column: 36,
										Line:   197,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 37,
											Line:   197,
										},
										File:   "universe.flux",
										Source: "y",
										Start: ast.Position{
											Column: 36,
											Line:   197,
										},
									},
								},
								Name: "y",
							},
							Separator: nil,
							Value: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   197,
										},
										File:   "universe.flux",
										Source: "y",
										Start: ast.Position{
											Column: 39,
											Line:   197,
										},
									},
								},
								Name: "y",
							},
						}, &ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 48,
										Line:   197,
									},
									File:   "universe.flux",
									Source: "on: on",
									Start: ast.Position{
										Column: 42,
										Line:   197,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 44,
											Line:   197,
										},
										File:   "universe.flux",
										Source: "on",
										Start: ast.Position{
											Column: 42,
											Line:   197,
										},
									},
								},
								Name: "on",
							},
							Separator: nil,
							Value: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 48,
											Line:   197,
										},
										File:   "universe.flux",
										Source: "on",
										Start: ast.Position{
											Column: 46,
											Line:   197,
										},
									},
								},
								Name: "on",
							},
						}, &ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 64,
										Line:   197,
									},
									File:   "universe.flux",
									Source: "pearsonr: true",
									Start: ast.Position{
										Column: 50,
										Line:   197,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 58,
											Line:   197,
										},
										File:   "universe.flux",
										Source: "pearsonr",
										Start: ast.Position{
											Column: 50,
											Line:   197,
										},
									},
								},
								Name: "pearsonr",
							},
							Separator: nil,
							Value: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 64,
											Line:   197,
										},
										File:   "universe.flux",
										Source: "true",
										Start: ast.Position{
											Column: 60,
											Line:   197,
										},
									},
								},
								Name: "true",
							},
						}},
						Rbrace: nil,
						With:   nil,
					}},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 65,
								Line:   197,
							},
							File:   "universe.flux",
							Source: "cov(x: x, y: y, on: on, pearsonr: true)",
							Start: ast.Position{
								Column: 26,
								Line:   197,
							},
						},
					},
					Callee: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 29,
									Line:   197,
								},
								File:   "universe.flux",
								Source: "cov",
								Start: ast.Position{
									Column: 26,
									Line:   197,
								},
							},
						},
						Name: "cov",
					},
					Lparen: nil,
					Rparen: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   197,
							},
							File:   "universe.flux",
							Source: "x",
							Start: ast.Position{
								Column: 13,
								Line:   197,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   197,
								},
								File:   "universe.flux",
								Source: "x",
								Start: ast.Position{
									Column: 13,
									Line:   197,
								},
							},
						},
						Name: "x",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 17,
								Line:   197,
							},
							File:   "universe.flux",
							Source: "y",
							Start: ast.Position{
								Column: 16,
								Line:   197,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 17,
									Line:   197,
								},
								File:   "universe.flux",
								Source: "y",
								Start: ast.Position{
									Column: 16,
									Line:   197,
								},
							},
						},
						Name: "y",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 21,
								Line:   197,
							},
							File:   "universe.flux",
							Source: "on",
							Start: ast.Position{
								Column: 19,
								Line:   197,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   197,
								},
								File:   "universe.flux",
								Source: "on",
								Start: ast.Position{
									Column: 19,
									Line:   197,
								},
							},
						},
						Name: "on",
					},
					Separator: nil,
					Value:     nil,
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 47,
						Line:   206,
					},
					File:   "universe.flux",
					Source: "aggregateWindow = (every, fn, offset=0s, column=\"_value\", timeSrc=\"_stop\", timeDst=\"_time\", createEmpty=true, tables=<-) => tables\n    |> window(every: every, offset: offset, createEmpty: createEmpty)\n    |> fn(column: column)\n    |> duplicate(column: timeSrc, as: timeDst)\n    |> window(every: inf, timeColumn: timeDst)",
					Start: ast.Position{
						Column: 1,
						Line:   202,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// AggregateWindow applies an aggregate function to fixed windows of time.\n"}, ast.Comment{Text: "// The procedure is to window the data, perform an aggregate operation,\n"}, ast.Comment{Text: "// and then undo the windowing to produce an output table for every input table.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 16,
							Line:   202,
						},
						File:   "universe.flux",
						Source: "aggregateWindow",
						Start: ast.Position{
							Column: 1,
							Line:   202,
						},
					},
				},
				Name: "aggregateWindow",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 47,
							Line:   206,
						},
						File:   "universe.flux",
						Source: "(every, fn, offset=0s, column=\"_value\", timeSrc=\"_stop\", timeDst=\"_time\", createEmpty=true, tables=<-) => tables\n    |> window(every: every, offset: offset, createEmpty: createEmpty)\n    |> fn(column: column)\n    |> duplicate(column: timeSrc, as: timeDst)\n    |> window(every: inf, timeColumn: timeDst)",
						Start: ast.Position{
							Column: 19,
							Line:   202,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 131,
												Line:   202,
											},
											File:   "universe.flux",
											Source: "tables",
											Start: ast.Position{
												Column: 125,
												Line:   202,
											},
										},
									},
									Name: "tables",
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 70,
											Line:   203,
										},
										File:   "universe.flux",
										Source: "tables\n    |> window(every: every, offset: offset, createEmpty: createEmpty)",
										Start: ast.Position{
											Column: 125,
											Line:   202,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 69,
													Line:   203,
												},
												File:   "universe.flux",
												Source: "every: every, offset: offset, createEmpty: createEmpty",
												Start: ast.Position{
													Column: 15,
													Line:   203,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 27,
														Line:   203,
													},
													File:   "universe.flux",
													Source: "every: every",
													Start: ast.Position{
														Column: 15,
														Line:   203,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 20,
															Line:   203,
														},
														File:   "universe.flux",
														Source: "every",
														Start: ast.Position{
															Column: 15,
															Line:   203,
														},
													},
												},
												Name: "every",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 27,
															Line:   203,
														},
														File:   "universe.flux",
														Source: "every",
														Start: ast.Position{
															Column: 22,
															Line:   203,
														},
													},
												},
												Name: "every",
											},
										}, &ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 43,
														Line:   203,
													},
													File:   "universe.flux",
													Source: "offset: offset",
													Start: ast.Position{
														Column: 29,
														Line:   203,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 35,
															Line:   203,
														},
														File:   "universe.flux",
														Source: "offset",
														Start: ast.Position{
															Column: 29,
															Line:   203,
														},
													},
												},
												Name: "offset",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 43,
															Line:   203,
														},
														File:   "universe.flux",
														Source: "offset",
														Start: ast.Position{
															Column: 37,
															Line:   203,
														},
													},
												},
												Name: "offset",
											},
										}, &ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 69,
														Line:   203,
													},
													File:   "universe.flux",
													Source: "createEmpty: createEmpty",
													Start: ast.Position{
														Column: 45,
														Line:   203,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 56,
															Line:   203,
														},
														File:   "universe.flux",
														Source: "createEmpty",
														Start: ast.Position{
															Column: 45,
															Line:   203,
														},
													},
												},
												Name: "createEmpty",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 69,
															Line:   203,
														},
														File:   "universe.flux",
														Source: "createEmpty",
														Start: ast.Position{
															Column: 58,
															Line:   203,
														},
													},
												},
												Name: "createEmpty",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 70,
												Line:   203,
											},
											File:   "universe.flux",
											Source: "window(every: every, offset: offset, createEmpty: createEmpty)",
											Start: ast.Position{
												Column: 8,
												Line:   203,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 14,
													Line:   203,
												},
												File:   "universe.flux",
												Source: "window",
												Start: ast.Position{
													Column: 8,
													Line:   203,
												},
											},
										},
										Name: "window",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 26,
										Line:   204,
									},
									File:   "universe.flux",
									Source: "tables\n    |> window(every: every, offset: offset, createEmpty: createEmpty)\n    |> fn(column: column)",
									Start: ast.Position{
										Column: 125,
										Line:   202,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 25,
												Line:   204,
											},
											File:   "universe.flux",
											Source: "column: column",
											Start: ast.Position{
												Column: 11,
												Line:   204,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 25,
													Line:   204,
												},
												File:   "universe.flux",
												Source: "column: column",
												Start: ast.Position{
													Column: 11,
													Line:   204,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   204,
													},
													File:   "universe.flux",
													Source: "column",
													Start: ast.Position{
														Column: 11,
														Line:   204,
													},
												},
											},
											Name: "column",
										},
										Separator: nil,
										Value: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 25,
														Line:   204,
													},
													File:   "universe.flux",
													Source: "column",
													Start: ast.Position{
														Column: 19,
														Line:   204,
													},
												},
											},
											Name: "column",
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 26,
											Line:   204,
										},
										File:   "universe.flux",
										Source: "fn(column: column)",
										Start: ast.Position{
											Column: 8,
											Line:   204,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 10,
												Line:   204,
											},
											File:   "universe.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 8,
												Line:   204,
											},
										},
									},
									Name: "fn",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 47,
									Line:   205,
								},
								File:   "universe.flux",
								Source: "tables\n    |> window(every: every, offset: offset, createEmpty: createEmpty)\n    |> fn(column: column)\n    |> duplicate(column: timeSrc, as: timeDst)",
								Start: ast.Position{
									Column: 125,
									Line:   202,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 46,
											Line:   205,
										},
										File:   "universe.flux",
										Source: "column: timeSrc, as: timeDst",
										Start: ast.Position{
											Column: 18,
											Line:   205,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 33,
												Line:   205,
											},
											File:   "universe.flux",
											Source: "column: timeSrc",
											Start: ast.Position{
												Column: 18,
												Line:   205,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 24,
													Line:   205,
												},
												File:   "universe.flux",
												Source: "column",
												Start: ast.Position{
													Column: 18,
													Line:   205,
												},
											},
										},
										Name: "column",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 33,
													Line:   205,
												},
												File:   "universe.flux",
												Source: "timeSrc",
												Start: ast.Position{
													Column: 26,
													Line:   205,
												},
											},
										},
										Name: "timeSrc",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 46,
												Line:   205,
											},
											File:   "universe.flux",
											Source: "as: timeDst",
											Start: ast.Position{
												Column: 35,
												Line:   205,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 37,
													Line:   205,
												},
												File:   "universe.flux",
												Source: "as",
												Start: ast.Position{
													Column: 35,
													Line:   205,
												},
											},
										},
										Name: "as",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 46,
													Line:   205,
												},
												File:   "universe.flux",
												Source: "timeDst",
												Start: ast.Position{
													Column: 39,
													Line:   205,
												},
											},
										},
										Name: "timeDst",
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 47,
										Line:   205,
									},
									File:   "universe.flux",
									Source: "duplicate(column: timeSrc, as: timeDst)",
									Start: ast.Position{
										Column: 8,
										Line:   205,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 17,
											Line:   205,
										},
										File:   "universe.flux",
										Source: "duplicate",
										Start: ast.Position{
											Column: 8,
											Line:   205,
										},
									},
								},
								Name: "duplicate",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 47,
								Line:   206,
							},
							File:   "universe.flux",
							Source: "tables\n    |> window(every: every, offset: offset, createEmpty: createEmpty)\n    |> fn(column: column)\n    |> duplicate(column: timeSrc, as: timeDst)\n    |> window(every: inf, timeColumn: timeDst)",
							Start: ast.Position{
								Column: 125,
								Line:   202,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 46,
										Line:   206,
									},
									File:   "universe.flux",
									Source: "every: inf, timeColumn: timeDst",
									Start: ast.Position{
										Column: 15,
										Line:   206,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 25,
											Line:   206,
										},
										File:   "universe.flux",
										Source: "every: inf",
										Start: ast.Position{
											Column: 15,
											Line:   206,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   206,
											},
											File:   "universe.flux",
											Source: "every",
											Start: ast.Position{
												Column: 15,
												Line:   206,
											},
										},
									},
									Name: "every",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 25,
												Line:   206,
											},
											File:   "universe.flux",
											Source: "inf",
											Start: ast.Position{
												Column: 22,
												Line:   206,
											},
										},
									},
									Name: "inf",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 46,
											Line:   206,
										},
										File:   "universe.flux",
										Source: "timeColumn: timeDst",
										Start: ast.Position{
											Column: 27,
											Line:   206,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 37,
												Line:   206,
											},
											File:   "universe.flux",
											Source: "timeColumn",
											Start: ast.Position{
												Column: 27,
												Line:   206,
											},
										},
									},
									Name: "timeColumn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 46,
												Line:   206,
											},
											File:   "universe.flux",
											Source: "timeDst",
											Start: ast.Position{
												Column: 39,
												Line:   206,
											},
										},
									},
									Name: "timeDst",
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 47,
									Line:   206,
								},
								File:   "universe.flux",
								Source: "window(every: inf, timeColumn: timeDst)",
								Start: ast.Position{
									Column: 8,
									Line:   206,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 14,
										Line:   206,
									},
									File:   "universe.flux",
									Source: "window",
									Start: ast.Position{
										Column: 8,
										Line:   206,
									},
								},
							},
							Name: "window",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 25,
								Line:   202,
							},
							File:   "universe.flux",
							Source: "every",
							Start: ast.Position{
								Column: 20,
								Line:   202,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   202,
								},
								File:   "universe.flux",
								Source: "every",
								Start: ast.Position{
									Column: 20,
									Line:   202,
								},
							},
						},
						Name: "every",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 29,
								Line:   202,
							},
							File:   "universe.flux",
							Source: "fn",
							Start: ast.Position{
								Column: 27,
								Line:   202,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 29,
									Line:   202,
								},
								File:   "universe.flux",
								Source: "fn",
								Start: ast.Position{
									Column: 27,
									Line:   202,
								},
							},
						},
						Name: "fn",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 40,
								Line:   202,
							},
							File:   "universe.flux",
							Source: "offset=0s",
							Start: ast.Position{
								Column: 31,
								Line:   202,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 37,
									Line:   202,
								},
								File:   "universe.flux",
								Source: "offset",
								Start: ast.Position{
									Column: 31,
									Line:   202,
								},
							},
						},
						Name: "offset",
					},
					Separator: nil,
					Value: &ast.DurationLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   202,
								},
								File:   "universe.flux",
								Source: "0s",
								Start: ast.Position{
									Column: 38,
									Line:   202,
								},
							},
						},
						Values: []ast.Duration{ast.Duration{
							Magnitude: int64(0),
							Unit:      "s",
						}},
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 57,
								Line:   202,
							},
							File:   "universe.flux",
							Source: "column=\"_value\"",
							Start: ast.Position{
								Column: 42,
								Line:   202,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 48,
									Line:   202,
								},
								File:   "universe.flux",
								Source: "column",
								Start: ast.Position{
									Column: 42,
									Line:   202,
								},
							},
						},
						Name: "column",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 57,
									Line:   202,
								},
								File:   "universe.flux",
								Source: "\"_value\"",
								Start: ast.Position{
									Column: 49,
									Line:   202,
								},
							},
						},
						Value: "_value",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 74,
								Line:   202,
							},
							File:   "universe.flux",
							Source: "timeSrc=\"_stop\"",
							Start: ast.Position{
								Column: 59,
								Line:   202,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 66,
									Line:   202,
								},
								File:   "universe.flux",
								Source: "timeSrc",
								Start: ast.Position{
									Column: 59,
									Line:   202,
								},
							},
						},
						Name: "timeSrc",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 74,
									Line:   202,
								},
								File:   "universe.flux",
								Source: "\"_stop\"",
								Start: ast.Position{
									Column: 67,
									Line:   202,
								},
							},
						},
						Value: "_stop",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 91,
								Line:   202,
							},
							File:   "universe.flux",
							Source: "timeDst=\"_time\"",
							Start: ast.Position{
								Column: 76,
								Line:   202,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 83,
									Line:   202,
								},
								File:   "universe.flux",
								Source: "timeDst",
								Start: ast.Position{
									Column: 76,
									Line:   202,
								},
							},
						},
						Name: "timeDst",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 91,
									Line:   202,
								},
								File:   "universe.flux",
								Source: "\"_time\"",
								Start: ast.Position{
									Column: 84,
									Line:   202,
								},
							},
						},
						Value: "_time",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 109,
								Line:   202,
							},
							File:   "universe.flux",
							Source: "createEmpty=true",
							Start: ast.Position{
								Column: 93,
								Line:   202,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 104,
									Line:   202,
								},
								File:   "universe.flux",
								Source: "createEmpty",
								Start: ast.Position{
									Column: 93,
									Line:   202,
								},
							},
						},
						Name: "createEmpty",
					},
					Separator: nil,
					Value: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 109,
									Line:   202,
								},
								File:   "universe.flux",
								Source: "true",
								Start: ast.Position{
									Column: 105,
									Line:   202,
								},
							},
						},
						Name: "true",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 120,
								Line:   202,
							},
							File:   "universe.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 111,
								Line:   202,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 117,
									Line:   202,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 111,
									Line:   202,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 120,
								Line:   202,
							},
							File:   "universe.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 118,
								Line:   202,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 39,
						Line:   214,
					},
					File:   "universe.flux",
					Source: "increase = (tables=<-, columns=[\"_value\"]) => tables\n    |> difference(nonNegative: true, columns: columns)\n    |> cumulativeSum(columns: columns)",
					Start: ast.Position{
						Column: 1,
						Line:   212,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// Increase returns the total non-negative difference between values in a table.\n"}, ast.Comment{Text: "// A main usage case is tracking changes in counter values which may wrap over time when they hit\n"}, ast.Comment{Text: "// a threshold or are reset. In the case of a wrap/reset,\n"}, ast.Comment{Text: "// we can assume that the absolute delta between two points will be at least their non-negative difference.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 9,
							Line:   212,
						},
						File:   "universe.flux",
						Source: "increase",
						Start: ast.Position{
							Column: 1,
							Line:   212,
						},
					},
				},
				Name: "increase",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 39,
							Line:   214,
						},
						File:   "universe.flux",
						Source: "(tables=<-, columns=[\"_value\"]) => tables\n    |> difference(nonNegative: true, columns: columns)\n    |> cumulativeSum(columns: columns)",
						Start: ast.Position{
							Column: 12,
							Line:   212,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 53,
										Line:   212,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 47,
										Line:   212,
									},
								},
							},
							Name: "tables",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 55,
									Line:   213,
								},
								File:   "universe.flux",
								Source: "tables\n    |> difference(nonNegative: true, columns: columns)",
								Start: ast.Position{
									Column: 47,
									Line:   212,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 54,
											Line:   213,
										},
										File:   "universe.flux",
										Source: "nonNegative: true, columns: columns",
										Start: ast.Position{
											Column: 19,
											Line:   213,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 36,
												Line:   213,
											},
											File:   "universe.flux",
											Source: "nonNegative: true",
											Start: ast.Position{
												Column: 19,
												Line:   213,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   213,
												},
												File:   "universe.flux",
												Source: "nonNegative",
												Start: ast.Position{
													Column: 19,
													Line:   213,
												},
											},
										},
										Name: "nonNegative",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 36,
													Line:   213,
												},
												File:   "universe.flux",
												Source: "true",
												Start: ast.Position{
													Column: 32,
													Line:   213,
												},
											},
										},
										Name: "true",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 54,
												Line:   213,
											},
											File:   "universe.flux",
											Source: "columns: columns",
											Start: ast.Position{
												Column: 38,
												Line:   213,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 45,
													Line:   213,
												},
												File:   "universe.flux",
												Source: "columns",
												Start: ast.Position{
													Column: 38,
													Line:   213,
												},
											},
										},
										Name: "columns",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 54,
													Line:   213,
												},
												File:   "universe.flux",
												Source: "columns",
												Start: ast.Position{
													Column: 47,
													Line:   213,
												},
											},
										},
										Name: "columns",
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 55,
										Line:   213,
									},
									File:   "universe.flux",
									Source: "difference(nonNegative: true, columns: columns)",
									Start: ast.Position{
										Column: 8,
										Line:   213,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 18,
											Line:   213,
										},
										File:   "universe.flux",
										Source: "difference",
										Start: ast.Position{
											Column: 8,
											Line:   213,
										},
									},
								},
								Name: "difference",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 39,
								Line:   214,
							},
							File:   "universe.flux",
							Source: "tables\n    |> difference(nonNegative: true, columns: columns)\n    |> cumulativeSum(columns: columns)",
							Start: ast.Position{
								Column: 47,
								Line:   212,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 38,
										Line:   214,
									},
									File:   "universe.flux",
									Source: "columns: columns",
									Start: ast.Position{
										Column: 22,
										Line:   214,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 38,
											Line:   214,
										},
										File:   "universe.flux",
										Source: "columns: columns",
										Start: ast.Position{
											Column: 22,
											Line:   214,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   214,
											},
											File:   "universe.flux",
											Source: "columns",
											Start: ast.Position{
												Column: 22,
												Line:   214,
											},
										},
									},
									Name: "columns",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 38,
												Line:   214,
											},
											File:   "universe.flux",
											Source: "columns",
											Start: ast.Position{
												Column: 31,
												Line:   214,
											},
										},
									},
									Name: "columns",
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 39,
									Line:   214,
								},
								File:   "universe.flux",
								Source: "cumulativeSum(columns: columns)",
								Start: ast.Position{
									Column: 8,
									Line:   214,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 21,
										Line:   214,
									},
									File:   "universe.flux",
									Source: "cumulativeSum",
									Start: ast.Position{
										Column: 8,
										Line:   214,
									},
								},
							},
							Name: "cumulativeSum",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 22,
								Line:   212,
							},
							File:   "universe.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 13,
								Line:   212,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 19,
									Line:   212,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 13,
									Line:   212,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 22,
								Line:   212,
							},
							File:   "universe.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 20,
								Line:   212,
							},
						},
					}},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   212,
							},
							File:   "universe.flux",
							Source: "columns=[\"_value\"]",
							Start: ast.Position{
								Column: 24,
								Line:   212,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 31,
									Line:   212,
								},
								File:   "universe.flux",
								Source: "columns",
								Start: ast.Position{
									Column: 24,
									Line:   212,
								},
							},
						},
						Name: "columns",
					},
					Separator: nil,
					Value: &ast.ArrayExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   212,
								},
								File:   "universe.flux",
								Source: "[\"_value\"]",
								Start: ast.Position{
									Column: 32,
									Line:   212,
								},
							},
						},
						Elements: []ast.Expression{&ast.StringLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   212,
									},
									File:   "universe.flux",
									Source: "\"_value\"",
									Start: ast.Position{
										Column: 33,
										Line:   212,
									},
								},
							},
							Value: "_value",
						}},
						Lbrack: nil,
						Rbrack: nil,
					},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 82,
						Line:   218,
					},
					File:   "universe.flux",
					Source: "median = (method=\"estimate_tdigest\", compression=0.0, column=\"_value\", tables=<-) => tables\n    |> quantile(q: 0.5, method: method, compression: compression, column: column)",
					Start: ast.Position{
						Column: 1,
						Line:   217,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// median returns the 50th percentile.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   217,
						},
						File:   "universe.flux",
						Source: "median",
						Start: ast.Position{
							Column: 1,
							Line:   217,
						},
					},
				},
				Name: "median",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 82,
							Line:   218,
						},
						File:   "universe.flux",
						Source: "(method=\"estimate_tdigest\", compression=0.0, column=\"_value\", tables=<-) => tables\n    |> quantile(q: 0.5, method: method, compression: compression, column: column)",
						Start: ast.Position{
							Column: 10,
							Line:   217,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 92,
									Line:   217,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 86,
									Line:   217,
								},
							},
						},
						Name: "tables",
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 82,
								Line:   218,
							},
							File:   "universe.flux",
							Source: "tables\n    |> quantile(q: 0.5, method: method, compression: compression, column: column)",
							Start: ast.Position{
								Column: 86,
								Line:   217,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 81,
										Line:   218,
									},
									File:   "universe.flux",
									Source: "q: 0.5, method: method, compression: compression, column: column",
									Start: ast.Position{
										Column: 17,
										Line:   218,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 23,
											Line:   218,
										},
										File:   "universe.flux",
										Source: "q: 0.5",
										Start: ast.Position{
											Column: 17,
											Line:   218,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 18,
												Line:   218,
											},
											File:   "universe.flux",
											Source: "q",
											Start: ast.Position{
												Column: 17,
												Line:   218,
											},
										},
									},
									Name: "q",
								},
								Separator: nil,
								Value: &ast.FloatLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 23,
												Line:   218,
											},
											File:   "universe.flux",
											Source: "0.5",
											Start: ast.Position{
												Column: 20,
												Line:   218,
											},
										},
									},
									Value: 0.5,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 39,
											Line:   218,
										},
										File:   "universe.flux",
										Source: "method: method",
										Start: ast.Position{
											Column: 25,
											Line:   218,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 31,
												Line:   218,
											},
											File:   "universe.flux",
											Source: "method",
											Start: ast.Position{
												Column: 25,
												Line:   218,
											},
										},
									},
									Name: "method",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 39,
												Line:   218,
											},
											File:   "universe.flux",
											Source: "method",
											Start: ast.Position{
												Column: 33,
												Line:   218,
											},
										},
									},
									Name: "method",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 65,
											Line:   218,
										},
										File:   "universe.flux",
										Source: "compression: compression",
										Start: ast.Position{
											Column: 41,
											Line:   218,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 52,
												Line:   218,
											},
											File:   "universe.flux",
											Source: "compression",
											Start: ast.Position{
												Column: 41,
												Line:   218,
											},
										},
									},
									Name: "compression",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 65,
												Line:   218,
											},
											File:   "universe.flux",
											Source: "compression",
											Start: ast.Position{
												Column: 54,
												Line:   218,
											},
										},
									},
									Name: "compression",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 81,
											Line:   218,
										},
										File:   "universe.flux",
										Source: "column: column",
										Start: ast.Position{
											Column: 67,
											Line:   218,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 73,
												Line:   218,
											},
											File:   "universe.flux",
											Source: "column",
											Start: ast.Position{
												Column: 67,
												Line:   218,
											},
										},
									},
									Name: "column",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 81,
												Line:   218,
											},
											File:   "universe.flux",
											Source: "column",
											Start: ast.Position{
												Column: 75,
												Line:   218,
											},
										},
									},
									Name: "column",
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 82,
									Line:   218,
								},
								File:   "universe.flux",
								Source: "quantile(q: 0.5, method: method, compression: compression, column: column)",
								Start: ast.Position{
									Column: 8,
									Line:   218,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 16,
										Line:   218,
									},
									File:   "universe.flux",
									Source: "quantile",
									Start: ast.Position{
										Column: 8,
										Line:   218,
									},
								},
							},
							Name: "quantile",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 36,
								Line:   217,
							},
							File:   "universe.flux",
							Source: "method=\"estimate_tdigest\"",
							Start: ast.Position{
								Column: 11,
								Line:   217,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 17,
									Line:   217,
								},
								File:   "universe.flux",
								Source: "method",
								Start: ast.Position{
									Column: 11,
									Line:   217,
								},
							},
						},
						Name: "method",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 36,
									Line:   217,
								},
								File:   "universe.flux",
								Source: "\"estimate_tdigest\"",
								Start: ast.Position{
									Column: 18,
									Line:   217,
								},
							},
						},
						Value: "estimate_tdigest",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 53,
								Line:   217,
							},
							File:   "universe.flux",
							Source: "compression=0.0",
							Start: ast.Position{
								Column: 38,
								Line:   217,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 49,
									Line:   217,
								},
								File:   "universe.flux",
								Source: "compression",
								Start: ast.Position{
									Column: 38,
									Line:   217,
								},
							},
						},
						Name: "compression",
					},
					Separator: nil,
					Value: &ast.FloatLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 53,
									Line:   217,
								},
								File:   "universe.flux",
								Source: "0.0",
								Start: ast.Position{
									Column: 50,
									Line:   217,
								},
							},
						},
						Value: 0.0,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 70,
								Line:   217,
							},
							File:   "universe.flux",
							Source: "column=\"_value\"",
							Start: ast.Position{
								Column: 55,
								Line:   217,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 61,
									Line:   217,
								},
								File:   "universe.flux",
								Source: "column",
								Start: ast.Position{
									Column: 55,
									Line:   217,
								},
							},
						},
						Name: "column",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 70,
									Line:   217,
								},
								File:   "universe.flux",
								Source: "\"_value\"",
								Start: ast.Position{
									Column: 62,
									Line:   217,
								},
							},
						},
						Value: "_value",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 81,
								Line:   217,
							},
							File:   "universe.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 72,
								Line:   217,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 78,
									Line:   217,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 72,
									Line:   217,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 81,
								Line:   217,
							},
							File:   "universe.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 79,
								Line:   217,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 50,
						Line:   230,
					},
					File:   "universe.flux",
					Source: "stateCount = (fn, column=\"stateCount\", tables=<-) => tables\n    |> stateTracking(countColumn: column, fn: fn)",
					Start: ast.Position{
						Column: 1,
						Line:   229,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// stateCount computes the number of consecutive records in a given state.\n"}, ast.Comment{Text: "// The state is defined via the function fn. For each consecutive point for\n"}, ast.Comment{Text: "// which the expression evaluates as true, the state count will be incremented\n"}, ast.Comment{Text: "// When a point evaluates as false, the state count is reset.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// The state count will be added as an additional column to each record. If the\n"}, ast.Comment{Text: "// expression evaluates as false, the value will be -1. If the expression\n"}, ast.Comment{Text: "// generates an error during evaluation, the point is discarded, and does not\n"}, ast.Comment{Text: "// affect the state count.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 11,
							Line:   229,
						},
						File:   "universe.flux",
						Source: "stateCount",
						Start: ast.Position{
							Column: 1,
							Line:   229,
						},
					},
				},
				Name: "stateCount",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 50,
							Line:   230,
						},
						File:   "universe.flux",
						Source: "(fn, column=\"stateCount\", tables=<-) => tables\n    |> stateTracking(countColumn: column, fn: fn)",
						Start: ast.Position{
							Column: 14,
							Line:   229,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 60,
									Line:   229,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 54,
									Line:   229,
								},
							},
						},
						Name: "tables",
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 50,
								Line:   230,
							},
							File:   "universe.flux",
							Source: "tables\n    |> stateTracking(countColumn: column, fn: fn)",
							Start: ast.Position{
								Column: 54,
								Line:   229,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 49,
										Line:   230,
									},
									File:   "universe.flux",
									Source: "countColumn: column, fn: fn",
									Start: ast.Position{
										Column: 22,
										Line:   230,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   230,
										},
										File:   "universe.flux",
										Source: "countColumn: column",
										Start: ast.Position{
											Column: 22,
											Line:   230,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 33,
												Line:   230,
											},
											File:   "universe.flux",
											Source: "countColumn",
											Start: ast.Position{
												Column: 22,
												Line:   230,
											},
										},
									},
									Name: "countColumn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   230,
											},
											File:   "universe.flux",
											Source: "column",
											Start: ast.Position{
												Column: 35,
												Line:   230,
											},
										},
									},
									Name: "column",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 49,
											Line:   230,
										},
										File:   "universe.flux",
										Source: "fn: fn",
										Start: ast.Position{
											Column: 43,
											Line:   230,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 45,
												Line:   230,
											},
											File:   "universe.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 43,
												Line:   230,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   230,
											},
											File:   "universe.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 47,
												Line:   230,
											},
										},
									},
									Name: "fn",
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 50,
									Line:   230,
								},
								File:   "universe.flux",
								Source: "stateTracking(countColumn: column, fn: fn)",
								Start: ast.Position{
									Column: 8,
									Line:   230,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 21,
										Line:   230,
									},
									File:   "universe.flux",
									Source: "stateTracking",
									Start: ast.Position{
										Column: 8,
										Line:   230,
									},
								},
							},
							Name: "stateTracking",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 17,
								Line:   229,
							},
							File:   "universe.flux",
							Source: "fn",
							Start: ast.Position{
								Column: 15,
								Line:   229,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 17,
									Line:   229,
								},
								File:   "universe.flux",
								Source: "fn",
								Start: ast.Position{
									Column: 15,
									Line:   229,
								},
							},
						},
						Name: "fn",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 38,
								Line:   229,
							},
							File:   "universe.flux",
							Source: "column=\"stateCount\"",
							Start: ast.Position{
								Column: 19,
								Line:   229,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   229,
								},
								File:   "universe.flux",
								Source: "column",
								Start: ast.Position{
									Column: 19,
									Line:   229,
								},
							},
						},
						Name: "column",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 38,
									Line:   229,
								},
								File:   "universe.flux",
								Source: "\"stateCount\"",
								Start: ast.Position{
									Column: 26,
									Line:   229,
								},
							},
						},
						Value: "stateCount",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 49,
								Line:   229,
							},
							File:   "universe.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 40,
								Line:   229,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 46,
									Line:   229,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 40,
									Line:   229,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 49,
								Line:   229,
							},
							File:   "universe.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 47,
								Line:   229,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 97,
						Line:   248,
					},
					File:   "universe.flux",
					Source: "stateDuration = (fn, column=\"stateDuration\", timeColumn=\"_time\", unit=1s, tables=<-) => tables\n    |> stateTracking(durationColumn: column, timeColumn: timeColumn, fn: fn, durationUnit: unit)",
					Start: ast.Position{
						Column: 1,
						Line:   247,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// stateDuration computes the duration of a given state.\n"}, ast.Comment{Text: "// The state is defined via the function fn. For each consecutive point for\n"}, ast.Comment{Text: "// which the expression evaluates as true, the state duration will be\n"}, ast.Comment{Text: "// incremented by the duration between points. When a point evaluates as false,\n"}, ast.Comment{Text: "// the state duration is reset.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// The state duration will be added as an additional column to each record. If the\n"}, ast.Comment{Text: "// expression evaluates as false, the value will be -1. If the expression\n"}, ast.Comment{Text: "// generates an error during evaluation, the point is discarded, and does not\n"}, ast.Comment{Text: "// affect the state duration.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// Note that as the first point in the given state has no previous point, its\n"}, ast.Comment{Text: "// state duration will be 0.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// The duration is represented as an integer in the units specified.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   247,
						},
						File:   "universe.flux",
						Source: "stateDuration",
						Start: ast.Position{
							Column: 1,
							Line:   247,
						},
					},
				},
				Name: "stateDuration",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 97,
							Line:   248,
						},
						File:   "universe.flux",
						Source: "(fn, column=\"stateDuration\", timeColumn=\"_time\", unit=1s, tables=<-) => tables\n    |> stateTracking(durationColumn: column, timeColumn: timeColumn, fn: fn, durationUnit: unit)",
						Start: ast.Position{
							Column: 17,
							Line:   247,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 95,
									Line:   247,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 89,
									Line:   247,
								},
							},
						},
						Name: "tables",
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 97,
								Line:   248,
							},
							File:   "universe.flux",
							Source: "tables\n    |> stateTracking(durationColumn: column, timeColumn: timeColumn, fn: fn, durationUnit: unit)",
							Start: ast.Position{
								Column: 89,
								Line:   247,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 96,
										Line:   248,
									},
									File:   "universe.flux",
									Source: "durationColumn: column, timeColumn: timeColumn, fn: fn, durationUnit: unit",
									Start: ast.Position{
										Column: 22,
										Line:   248,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 44,
											Line:   248,
										},
										File:   "universe.flux",
										Source: "durationColumn: column",
										Start: ast.Position{
											Column: 22,
											Line:   248,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 36,
												Line:   248,
											},
											File:   "universe.flux",
											Source: "durationColumn",
											Start: ast.Position{
												Column: 22,
												Line:   248,
											},
										},
									},
									Name: "durationColumn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 44,
												Line:   248,
											},
											File:   "universe.flux",
											Source: "column",
											Start: ast.Position{
												Column: 38,
												Line:   248,
											},
										},
									},
									Name: "column",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 68,
											Line:   248,
										},
										File:   "universe.flux",
										Source: "timeColumn: timeColumn",
										Start: ast.Position{
											Column: 46,
											Line:   248,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 56,
												Line:   248,
											},
											File:   "universe.flux",
											Source: "timeColumn",
											Start: ast.Position{
												Column: 46,
												Line:   248,
											},
										},
									},
									Name: "timeColumn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 68,
												Line:   248,
											},
											File:   "universe.flux",
											Source: "timeColumn",
											Start: ast.Position{
												Column: 58,
												Line:   248,
											},
										},
									},
									Name: "timeColumn",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 76,
											Line:   248,
										},
										File:   "universe.flux",
										Source: "fn: fn",
										Start: ast.Position{
											Column: 70,
											Line:   248,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 72,
												Line:   248,
											},
											File:   "universe.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 70,
												Line:   248,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 76,
												Line:   248,
											},
											File:   "universe.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 74,
												Line:   248,
											},
										},
									},
									Name: "fn",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 96,
											Line:   248,
										},
										File:   "universe.flux",
										Source: "durationUnit: unit",
										Start: ast.Position{
											Column: 78,
											Line:   248,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 90,
												Line:   248,
											},
											File:   "universe.flux",
											Source: "durationUnit",
											Start: ast.Position{
												Column: 78,
												Line:   248,
											},
										},
									},
									Name: "durationUnit",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 96,
												Line:   248,
											},
											File:   "universe.flux",
											Source: "unit",
											Start: ast.Position{
												Column: 92,
												Line:   248,
											},
										},
									},
									Name: "unit",
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 97,
									Line:   248,
								},
								File:   "universe.flux",
								Source: "stateTracking(durationColumn: column, timeColumn: timeColumn, fn: fn, durationUnit: unit)",
								Start: ast.Position{
									Column: 8,
									Line:   248,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 21,
										Line:   248,
									},
									File:   "universe.flux",
									Source: "stateTracking",
									Start: ast.Position{
										Column: 8,
										Line:   248,
									},
								},
							},
							Name: "stateTracking",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 20,
								Line:   247,
							},
							File:   "universe.flux",
							Source: "fn",
							Start: ast.Position{
								Column: 18,
								Line:   247,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   247,
								},
								File:   "universe.flux",
								Source: "fn",
								Start: ast.Position{
									Column: 18,
									Line:   247,
								},
							},
						},
						Name: "fn",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 44,
								Line:   247,
							},
							File:   "universe.flux",
							Source: "column=\"stateDuration\"",
							Start: ast.Position{
								Column: 22,
								Line:   247,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 28,
									Line:   247,
								},
								File:   "universe.flux",
								Source: "column",
								Start: ast.Position{
									Column: 22,
									Line:   247,
								},
							},
						},
						Name: "column",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 44,
									Line:   247,
								},
								File:   "universe.flux",
								Source: "\"stateDuration\"",
								Start: ast.Position{
									Column: 29,
									Line:   247,
								},
							},
						},
						Value: "stateDuration",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 64,
								Line:   247,
							},
							File:   "universe.flux",
							Source: "timeColumn=\"_time\"",
							Start: ast.Position{
								Column: 46,
								Line:   247,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 56,
									Line:   247,
								},
								File:   "universe.flux",
								Source: "timeColumn",
								Start: ast.Position{
									Column: 46,
									Line:   247,
								},
							},
						},
						Name: "timeColumn",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 64,
									Line:   247,
								},
								File:   "universe.flux",
								Source: "\"_time\"",
								Start: ast.Position{
									Column: 57,
									Line:   247,
								},
							},
						},
						Value: "_time",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 73,
								Line:   247,
							},
							File:   "universe.flux",
							Source: "unit=1s",
							Start: ast.Position{
								Column: 66,
								Line:   247,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 70,
									Line:   247,
								},
								File:   "universe.flux",
								Source: "unit",
								Start: ast.Position{
									Column: 66,
									Line:   247,
								},
							},
						},
						Name: "unit",
					},
					Separator: nil,
					Value: &ast.DurationLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 73,
									Line:   247,
								},
								File:   "universe.flux",
								Source: "1s",
								Start: ast.Position{
									Column: 71,
									Line:   247,
								},
							},
						},
						Values: []ast.Duration{ast.Duration{
							Magnitude: int64(1),
							Unit:      "s",
						}},
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 84,
								Line:   247,
							},
							File:   "universe.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 75,
								Line:   247,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 81,
									Line:   247,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 75,
									Line:   247,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 84,
								Line:   247,
							},
							File:   "universe.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 82,
								Line:   247,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 19,
						Line:   253,
					},
					File:   "universe.flux",
					Source: "_sortLimit = (n, desc, columns=[\"_value\"], tables=<-) => tables\n    |> sort(columns: columns, desc: desc)\n    |> limit(n: n)",
					Start: ast.Position{
						Column: 1,
						Line:   251,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// _sortLimit is a helper function, which sorts and limits a table.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 11,
							Line:   251,
						},
						File:   "universe.flux",
						Source: "_sortLimit",
						Start: ast.Position{
							Column: 1,
							Line:   251,
						},
					},
				},
				Name: "_sortLimit",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 19,
							Line:   253,
						},
						File:   "universe.flux",
						Source: "(n, desc, columns=[\"_value\"], tables=<-) => tables\n    |> sort(columns: columns, desc: desc)\n    |> limit(n: n)",
						Start: ast.Position{
							Column: 14,
							Line:   251,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 64,
										Line:   251,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 58,
										Line:   251,
									},
								},
							},
							Name: "tables",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   252,
								},
								File:   "universe.flux",
								Source: "tables\n    |> sort(columns: columns, desc: desc)",
								Start: ast.Position{
									Column: 58,
									Line:   251,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   252,
										},
										File:   "universe.flux",
										Source: "columns: columns, desc: desc",
										Start: ast.Position{
											Column: 13,
											Line:   252,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   252,
											},
											File:   "universe.flux",
											Source: "columns: columns",
											Start: ast.Position{
												Column: 13,
												Line:   252,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 20,
													Line:   252,
												},
												File:   "universe.flux",
												Source: "columns",
												Start: ast.Position{
													Column: 13,
													Line:   252,
												},
											},
										},
										Name: "columns",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 29,
													Line:   252,
												},
												File:   "universe.flux",
												Source: "columns",
												Start: ast.Position{
													Column: 22,
													Line:   252,
												},
											},
										},
										Name: "columns",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   252,
											},
											File:   "universe.flux",
											Source: "desc: desc",
											Start: ast.Position{
												Column: 31,
												Line:   252,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 35,
													Line:   252,
												},
												File:   "universe.flux",
												Source: "desc",
												Start: ast.Position{
													Column: 31,
													Line:   252,
												},
											},
										},
										Name: "desc",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   252,
												},
												File:   "universe.flux",
												Source: "desc",
												Start: ast.Position{
													Column: 37,
													Line:   252,
												},
											},
										},
										Name: "desc",
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   252,
									},
									File:   "universe.flux",
									Source: "sort(columns: columns, desc: desc)",
									Start: ast.Position{
										Column: 8,
										Line:   252,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 12,
											Line:   252,
										},
										File:   "universe.flux",
										Source: "sort",
										Start: ast.Position{
											Column: 8,
											Line:   252,
										},
									},
								},
								Name: "sort",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 19,
								Line:   253,
							},
							File:   "universe.flux",
							Source: "tables\n    |> sort(columns: columns, desc: desc)\n    |> limit(n: n)",
							Start: ast.Position{
								Column: 58,
								Line:   251,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   253,
									},
									File:   "universe.flux",
									Source: "n: n",
									Start: ast.Position{
										Column: 14,
										Line:   253,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 18,
											Line:   253,
										},
										File:   "universe.flux",
										Source: "n: n",
										Start: ast.Position{
											Column: 14,
											Line:   253,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 15,
												Line:   253,
											},
											File:   "universe.flux",
											Source: "n",
											Start: ast.Position{
												Column: 14,
												Line:   253,
											},
										},
									},
									Name: "n",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 18,
												Line:   253,
											},
											File:   "universe.flux",
											Source: "n",
											Start: ast.Position{
												Column: 17,
												Line:   253,
											},
										},
									},
									Name: "n",
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 19,
									Line:   253,
								},
								File:   "universe.flux",
								Source: "limit(n: n)",
								Start: ast.Position{
									Column: 8,
									Line:   253,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   253,
									},
									File:   "universe.flux",
									Source: "limit",
									Start: ast.Position{
										Column: 8,
										Line:   253,
									},
								},
							},
							Name: "limit",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 16,
								Line:   251,
							},
							File:   "universe.flux",
							Source: "n",
							Start: ast.Position{
								Column: 15,
								Line:   251,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   251,
								},
								File:   "universe.flux",
								Source: "n",
								Start: ast.Position{
									Column: 15,
									Line:   251,
								},
							},
						},
						Name: "n",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 22,
								Line:   251,
							},
							File:   "universe.flux",
							Source: "desc",
							Start: ast.Position{
								Column: 18,
								Line:   251,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 22,
									Line:   251,
								},
								File:   "universe.flux",
								Source: "desc",
								Start: ast.Position{
									Column: 18,
									Line:   251,
								},
							},
						},
						Name: "desc",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   251,
							},
							File:   "universe.flux",
							Source: "columns=[\"_value\"]",
							Start: ast.Position{
								Column: 24,
								Line:   251,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 31,
									Line:   251,
								},
								File:   "universe.flux",
								Source: "columns",
								Start: ast.Position{
									Column: 24,
									Line:   251,
								},
							},
						},
						Name: "columns",
					},
					Separator: nil,
					Value: &ast.ArrayExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   251,
								},
								File:   "universe.flux",
								Source: "[\"_value\"]",
								Start: ast.Position{
									Column: 32,
									Line:   251,
								},
							},
						},
						Elements: []ast.Expression{&ast.StringLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   251,
									},
									File:   "universe.flux",
									Source: "\"_value\"",
									Start: ast.Position{
										Column: 33,
										Line:   251,
									},
								},
							},
							Value: "_value",
						}},
						Lbrack: nil,
						Rbrack: nil,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 53,
								Line:   251,
							},
							File:   "universe.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 44,
								Line:   251,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 50,
									Line:   251,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 44,
									Line:   251,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 53,
								Line:   251,
							},
							File:   "universe.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 51,
								Line:   251,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 54,
						Line:   257,
					},
					File:   "universe.flux",
					Source: "top = (n, columns=[\"_value\"], tables=<-) => tables\n    |> _sortLimit(n: n, columns: columns, desc: true)",
					Start: ast.Position{
						Column: 1,
						Line:   256,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// top sorts a table by columns and keeps only the top n records.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 4,
							Line:   256,
						},
						File:   "universe.flux",
						Source: "top",
						Start: ast.Position{
							Column: 1,
							Line:   256,
						},
					},
				},
				Name: "top",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 54,
							Line:   257,
						},
						File:   "universe.flux",
						Source: "(n, columns=[\"_value\"], tables=<-) => tables\n    |> _sortLimit(n: n, columns: columns, desc: true)",
						Start: ast.Position{
							Column: 7,
							Line:   256,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 51,
									Line:   256,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 45,
									Line:   256,
								},
							},
						},
						Name: "tables",
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 54,
								Line:   257,
							},
							File:   "universe.flux",
							Source: "tables\n    |> _sortLimit(n: n, columns: columns, desc: true)",
							Start: ast.Position{
								Column: 45,
								Line:   256,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 53,
										Line:   257,
									},
									File:   "universe.flux",
									Source: "n: n, columns: columns, desc: true",
									Start: ast.Position{
										Column: 19,
										Line:   257,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 23,
											Line:   257,
										},
										File:   "universe.flux",
										Source: "n: n",
										Start: ast.Position{
											Column: 19,
											Line:   257,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   257,
											},
											File:   "universe.flux",
											Source: "n",
											Start: ast.Position{
												Column: 19,
												Line:   257,
											},
										},
									},
									Name: "n",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 23,
												Line:   257,
											},
											File:   "universe.flux",
											Source: "n",
											Start: ast.Position{
												Column: 22,
												Line:   257,
											},
										},
									},
									Name: "n",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   257,
										},
										File:   "universe.flux",
										Source: "columns: columns",
										Start: ast.Position{
											Column: 25,
											Line:   257,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 32,
												Line:   257,
											},
											File:   "universe.flux",
											Source: "columns",
											Start: ast.Position{
												Column: 25,
												Line:   257,
											},
										},
									},
									Name: "columns",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   257,
											},
											File:   "universe.flux",
											Source: "columns",
											Start: ast.Position{
												Column: 34,
												Line:   257,
											},
										},
									},
									Name: "columns",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 53,
											Line:   257,
										},
										File:   "universe.flux",
										Source: "desc: true",
										Start: ast.Position{
											Column: 43,
											Line:   257,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 47,
												Line:   257,
											},
											File:   "universe.flux",
											Source: "desc",
											Start: ast.Position{
												Column: 43,
												Line:   257,
											},
										},
									},
									Name: "desc",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 53,
												Line:   257,
											},
											File:   "universe.flux",
											Source: "true",
											Start: ast.Position{
												Column: 49,
												Line:   257,
											},
										},
									},
									Name: "true",
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 54,
									Line:   257,
								},
								File:   "universe.flux",
								Source: "_sortLimit(n: n, columns: columns, desc: true)",
								Start: ast.Position{
									Column: 8,
									Line:   257,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   257,
									},
									File:   "universe.flux",
									Source: "_sortLimit",
									Start: ast.Position{
										Column: 8,
										Line:   257,
									},
								},
							},
							Name: "_sortLimit",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 9,
								Line:   256,
							},
							File:   "universe.flux",
							Source: "n",
							Start: ast.Position{
								Column: 8,
								Line:   256,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 9,
									Line:   256,
								},
								File:   "universe.flux",
								Source: "n",
								Start: ast.Position{
									Column: 8,
									Line:   256,
								},
							},
						},
						Name: "n",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 29,
								Line:   256,
							},
							File:   "universe.flux",
							Source: "columns=[\"_value\"]",
							Start: ast.Position{
								Column: 11,
								Line:   256,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 18,
									Line:   256,
								},
								File:   "universe.flux",
								Source: "columns",
								Start: ast.Position{
									Column: 11,
									Line:   256,
								},
							},
						},
						Name: "columns",
					},
					Separator: nil,
					Value: &ast.ArrayExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 29,
									Line:   256,
								},
								File:   "universe.flux",
								Source: "[\"_value\"]",
								Start: ast.Position{
									Column: 19,
									Line:   256,
								},
							},
						},
						Elements: []ast.Expression{&ast.StringLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 28,
										Line:   256,
									},
									File:   "universe.flux",
									Source: "\"_value\"",
									Start: ast.Position{
										Column: 20,
										Line:   256,
									},
								},
							},
							Value: "_value",
						}},
						Lbrack: nil,
						Rbrack: nil,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 40,
								Line:   256,
							},
							File:   "universe.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 31,
								Line:   256,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 37,
									Line:   256,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 31,
									Line:   256,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 40,
								Line:   256,
							},
							File:   "universe.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 38,
								Line:   256,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 55,
						Line:   261,
					},
					File:   "universe.flux",
					Source: "bottom = (n, columns=[\"_value\"], tables=<-) => tables\n    |> _sortLimit(n: n, columns: columns, desc: false)",
					Start: ast.Position{
						Column: 1,
						Line:   260,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// top sorts a table by columns and keeps only the bottom n records.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   260,
						},
						File:   "universe.flux",
						Source: "bottom",
						Start: ast.Position{
							Column: 1,
							Line:   260,
						},
					},
				},
				Name: "bottom",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 55,
							Line:   261,
						},
						File:   "universe.flux",
						Source: "(n, columns=[\"_value\"], tables=<-) => tables\n    |> _sortLimit(n: n, columns: columns, desc: false)",
						Start: ast.Position{
							Column: 10,
							Line:   260,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 54,
									Line:   260,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 48,
									Line:   260,
								},
							},
						},
						Name: "tables",
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 55,
								Line:   261,
							},
							File:   "universe.flux",
							Source: "tables\n    |> _sortLimit(n: n, columns: columns, desc: false)",
							Start: ast.Position{
								Column: 48,
								Line:   260,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 54,
										Line:   261,
									},
									File:   "universe.flux",
									Source: "n: n, columns: columns, desc: false",
									Start: ast.Position{
										Column: 19,
										Line:   261,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 23,
											Line:   261,
										},
										File:   "universe.flux",
										Source: "n: n",
										Start: ast.Position{
											Column: 19,
											Line:   261,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   261,
											},
											File:   "universe.flux",
											Source: "n",
											Start: ast.Position{
												Column: 19,
												Line:   261,
											},
										},
									},
									Name: "n",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 23,
												Line:   261,
											},
											File:   "universe.flux",
											Source: "n",
											Start: ast.Position{
												Column: 22,
												Line:   261,
											},
										},
									},
									Name: "n",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   261,
										},
										File:   "universe.flux",
										Source: "columns: columns",
										Start: ast.Position{
											Column: 25,
											Line:   261,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 32,
												Line:   261,
											},
											File:   "universe.flux",
											Source: "columns",
											Start: ast.Position{
												Column: 25,
												Line:   261,
											},
										},
									},
									Name: "columns",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   261,
											},
											File:   "universe.flux",
											Source: "columns",
											Start: ast.Position{
												Column: 34,
												Line:   261,
											},
										},
									},
									Name: "columns",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 54,
											Line:   261,
										},
										File:   "universe.flux",
										Source: "desc: false",
										Start: ast.Position{
											Column: 43,
											Line:   261,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 47,
												Line:   261,
											},
											File:   "universe.flux",
											Source: "desc",
											Start: ast.Position{
												Column: 43,
												Line:   261,
											},
										},
									},
									Name: "desc",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 54,
												Line:   261,
											},
											File:   "universe.flux",
											Source: "false",
											Start: ast.Position{
												Column: 49,
												Line:   261,
											},
										},
									},
									Name: "false",
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 55,
									Line:   261,
								},
								File:   "universe.flux",
								Source: "_sortLimit(n: n, columns: columns, desc: false)",
								Start: ast.Position{
									Column: 8,
									Line:   261,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   261,
									},
									File:   "universe.flux",
									Source: "_sortLimit",
									Start: ast.Position{
										Column: 8,
										Line:   261,
									},
								},
							},
							Name: "_sortLimit",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 12,
								Line:   260,
							},
							File:   "universe.flux",
							Source: "n",
							Start: ast.Position{
								Column: 11,
								Line:   260,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 12,
									Line:   260,
								},
								File:   "universe.flux",
								Source: "n",
								Start: ast.Position{
									Column: 11,
									Line:   260,
								},
							},
						},
						Name: "n",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 32,
								Line:   260,
							},
							File:   "universe.flux",
							Source: "columns=[\"_value\"]",
							Start: ast.Position{
								Column: 14,
								Line:   260,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   260,
								},
								File:   "universe.flux",
								Source: "columns",
								Start: ast.Position{
									Column: 14,
									Line:   260,
								},
							},
						},
						Name: "columns",
					},
					Separator: nil,
					Value: &ast.ArrayExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   260,
								},
								File:   "universe.flux",
								Source: "[\"_value\"]",
								Start: ast.Position{
									Column: 22,
									Line:   260,
								},
							},
						},
						Elements: []ast.Expression{&ast.StringLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   260,
									},
									File:   "universe.flux",
									Source: "\"_value\"",
									Start: ast.Position{
										Column: 23,
										Line:   260,
									},
								},
							},
							Value: "_value",
						}},
						Lbrack: nil,
						Rbrack: nil,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 43,
								Line:   260,
							},
							File:   "universe.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 34,
								Line:   260,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   260,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 34,
									Line:   260,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 43,
								Line:   260,
							},
							File:   "universe.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 41,
								Line:   260,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 43,
						Line:   270,
					},
					File:   "universe.flux",
					Source: "_highestOrLowest = (n, _sortLimit, reducer, column=\"_value\", groupColumns=[], tables=<-) => tables\n    |> group(columns: groupColumns)\n    |> reducer()\n    |> group(columns: [])\n    |> _sortLimit(n: n, columns: [column])",
					Start: ast.Position{
						Column: 1,
						Line:   266,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// _highestOrLowest is a helper function, which reduces all groups into a single group by specific tags and a reducer function,\n"}, ast.Comment{Text: "// then it selects the highest or lowest records based on the column and the _sortLimit function.\n"}, ast.Comment{Text: "// The default reducer assumes no reducing needs to be performed.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   266,
						},
						File:   "universe.flux",
						Source: "_highestOrLowest",
						Start: ast.Position{
							Column: 1,
							Line:   266,
						},
					},
				},
				Name: "_highestOrLowest",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 43,
							Line:   270,
						},
						File:   "universe.flux",
						Source: "(n, _sortLimit, reducer, column=\"_value\", groupColumns=[], tables=<-) => tables\n    |> group(columns: groupColumns)\n    |> reducer()\n    |> group(columns: [])\n    |> _sortLimit(n: n, columns: [column])",
						Start: ast.Position{
							Column: 20,
							Line:   266,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 99,
												Line:   266,
											},
											File:   "universe.flux",
											Source: "tables",
											Start: ast.Position{
												Column: 93,
												Line:   266,
											},
										},
									},
									Name: "tables",
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 36,
											Line:   267,
										},
										File:   "universe.flux",
										Source: "tables\n    |> group(columns: groupColumns)",
										Start: ast.Position{
											Column: 93,
											Line:   266,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 35,
													Line:   267,
												},
												File:   "universe.flux",
												Source: "columns: groupColumns",
												Start: ast.Position{
													Column: 14,
													Line:   267,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 35,
														Line:   267,
													},
													File:   "universe.flux",
													Source: "columns: groupColumns",
													Start: ast.Position{
														Column: 14,
														Line:   267,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 21,
															Line:   267,
														},
														File:   "universe.flux",
														Source: "columns",
														Start: ast.Position{
															Column: 14,
															Line:   267,
														},
													},
												},
												Name: "columns",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 35,
															Line:   267,
														},
														File:   "universe.flux",
														Source: "groupColumns",
														Start: ast.Position{
															Column: 23,
															Line:   267,
														},
													},
												},
												Name: "groupColumns",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 36,
												Line:   267,
											},
											File:   "universe.flux",
											Source: "group(columns: groupColumns)",
											Start: ast.Position{
												Column: 8,
												Line:   267,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 13,
													Line:   267,
												},
												File:   "universe.flux",
												Source: "group",
												Start: ast.Position{
													Column: 8,
													Line:   267,
												},
											},
										},
										Name: "group",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 17,
										Line:   268,
									},
									File:   "universe.flux",
									Source: "tables\n    |> group(columns: groupColumns)\n    |> reducer()",
									Start: ast.Position{
										Column: 93,
										Line:   266,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: nil,
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 17,
											Line:   268,
										},
										File:   "universe.flux",
										Source: "reducer()",
										Start: ast.Position{
											Column: 8,
											Line:   268,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 15,
												Line:   268,
											},
											File:   "universe.flux",
											Source: "reducer",
											Start: ast.Position{
												Column: 8,
												Line:   268,
											},
										},
									},
									Name: "reducer",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   269,
								},
								File:   "universe.flux",
								Source: "tables\n    |> group(columns: groupColumns)\n    |> reducer()\n    |> group(columns: [])",
								Start: ast.Position{
									Column: 93,
									Line:   266,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 25,
											Line:   269,
										},
										File:   "universe.flux",
										Source: "columns: []",
										Start: ast.Position{
											Column: 14,
											Line:   269,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 25,
												Line:   269,
											},
											File:   "universe.flux",
											Source: "columns: []",
											Start: ast.Position{
												Column: 14,
												Line:   269,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 21,
													Line:   269,
												},
												File:   "universe.flux",
												Source: "columns",
												Start: ast.Position{
													Column: 14,
													Line:   269,
												},
											},
										},
										Name: "columns",
									},
									Separator: nil,
									Value: &ast.ArrayExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 25,
													Line:   269,
												},
												File:   "universe.flux",
												Source: "[]",
												Start: ast.Position{
													Column: 23,
													Line:   269,
												},
											},
										},
										Elements: []ast.Expression{},
										Lbrack:   nil,
										Rbrack:   nil,
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 26,
										Line:   269,
									},
									File:   "universe.flux",
									Source: "group(columns: [])",
									Start: ast.Position{
										Column: 8,
										Line:   269,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   269,
										},
										File:   "universe.flux",
										Source: "group",
										Start: ast.Position{
											Column: 8,
											Line:   269,
										},
									},
								},
								Name: "group",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 43,
								Line:   270,
							},
							File:   "universe.flux",
							Source: "tables\n    |> group(columns: groupColumns)\n    |> reducer()\n    |> group(columns: [])\n    |> _sortLimit(n: n, columns: [column])",
							Start: ast.Position{
								Column: 93,
								Line:   266,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   270,
									},
									File:   "universe.flux",
									Source: "n: n, columns: [column]",
									Start: ast.Position{
										Column: 19,
										Line:   270,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 23,
											Line:   270,
										},
										File:   "universe.flux",
										Source: "n: n",
										Start: ast.Position{
											Column: 19,
											Line:   270,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   270,
											},
											File:   "universe.flux",
											Source: "n",
											Start: ast.Position{
												Column: 19,
												Line:   270,
											},
										},
									},
									Name: "n",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 23,
												Line:   270,
											},
											File:   "universe.flux",
											Source: "n",
											Start: ast.Position{
												Column: 22,
												Line:   270,
											},
										},
									},
									Name: "n",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 42,
											Line:   270,
										},
										File:   "universe.flux",
										Source: "columns: [column]",
										Start: ast.Position{
											Column: 25,
											Line:   270,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 32,
												Line:   270,
											},
											File:   "universe.flux",
											Source: "columns",
											Start: ast.Position{
												Column: 25,
												Line:   270,
											},
										},
									},
									Name: "columns",
								},
								Separator: nil,
								Value: &ast.ArrayExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 42,
												Line:   270,
											},
											File:   "universe.flux",
											Source: "[column]",
											Start: ast.Position{
												Column: 34,
												Line:   270,
											},
										},
									},
									Elements: []ast.Expression{&ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   270,
												},
												File:   "universe.flux",
												Source: "column",
												Start: ast.Position{
													Column: 35,
													Line:   270,
												},
											},
										},
										Name: "column",
									}},
									Lbrack: nil,
									Rbrack: nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 43,
									Line:   270,
								},
								File:   "universe.flux",
								Source: "_sortLimit(n: n, columns: [column])",
								Start: ast.Position{
									Column: 8,
									Line:   270,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   270,
									},
									File:   "universe.flux",
									Source: "_sortLimit",
									Start: ast.Position{
										Column: 8,
										Line:   270,
									},
								},
							},
							Name: "_sortLimit",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 22,
								Line:   266,
							},
							File:   "universe.flux",
							Source: "n",
							Start: ast.Position{
								Column: 21,
								Line:   266,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 22,
									Line:   266,
								},
								File:   "universe.flux",
								Source: "n",
								Start: ast.Position{
									Column: 21,
									Line:   266,
								},
							},
						},
						Name: "n",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 34,
								Line:   266,
							},
							File:   "universe.flux",
							Source: "_sortLimit",
							Start: ast.Position{
								Column: 24,
								Line:   266,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   266,
								},
								File:   "universe.flux",
								Source: "_sortLimit",
								Start: ast.Position{
									Column: 24,
									Line:   266,
								},
							},
						},
						Name: "_sortLimit",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 43,
								Line:   266,
							},
							File:   "universe.flux",
							Source: "reducer",
							Start: ast.Position{
								Column: 36,
								Line:   266,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 43,
									Line:   266,
								},
								File:   "universe.flux",
								Source: "reducer",
								Start: ast.Position{
									Column: 36,
									Line:   266,
								},
							},
						},
						Name: "reducer",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 60,
								Line:   266,
							},
							File:   "universe.flux",
							Source: "column=\"_value\"",
							Start: ast.Position{
								Column: 45,
								Line:   266,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 51,
									Line:   266,
								},
								File:   "universe.flux",
								Source: "column",
								Start: ast.Position{
									Column: 45,
									Line:   266,
								},
							},
						},
						Name: "column",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 60,
									Line:   266,
								},
								File:   "universe.flux",
								Source: "\"_value\"",
								Start: ast.Position{
									Column: 52,
									Line:   266,
								},
							},
						},
						Value: "_value",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 77,
								Line:   266,
							},
							File:   "universe.flux",
							Source: "groupColumns=[]",
							Start: ast.Position{
								Column: 62,
								Line:   266,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 74,
									Line:   266,
								},
								File:   "universe.flux",
								Source: "groupColumns",
								Start: ast.Position{
									Column: 62,
									Line:   266,
								},
							},
						},
						Name: "groupColumns",
					},
					Separator: nil,
					Value: &ast.ArrayExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 77,
									Line:   266,
								},
								File:   "universe.flux",
								Source: "[]",
								Start: ast.Position{
									Column: 75,
									Line:   266,
								},
							},
						},
						Elements: []ast.Expression{},
						Lbrack:   nil,
						Rbrack:   nil,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 88,
								Line:   266,
							},
							File:   "universe.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 79,
								Line:   266,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 85,
									Line:   266,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 79,
									Line:   266,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 88,
								Line:   266,
							},
							File:   "universe.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 86,
								Line:   266,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 6,
						Line:   281,
					},
					File:   "universe.flux",
					Source: "highestMax = (n, column=\"_value\", groupColumns=[], tables=<-) => tables\n    |> _highestOrLowest(\n        n: n,\n        column: column,\n        groupColumns: groupColumns,\n        // TODO(nathanielc): Once max/min support selecting based on multiple columns change this to pass all columns.\n        reducer: (tables=<-) => tables |> max(column: column),\n        _sortLimit: top,\n    )",
					Start: ast.Position{
						Column: 1,
						Line:   273,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// highestMax returns the top N records from all groups using the maximum of each group.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 11,
							Line:   273,
						},
						File:   "universe.flux",
						Source: "highestMax",
						Start: ast.Position{
							Column: 1,
							Line:   273,
						},
					},
				},
				Name: "highestMax",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   281,
						},
						File:   "universe.flux",
						Source: "(n, column=\"_value\", groupColumns=[], tables=<-) => tables\n    |> _highestOrLowest(\n        n: n,\n        column: column,\n        groupColumns: groupColumns,\n        // TODO(nathanielc): Once max/min support selecting based on multiple columns change this to pass all columns.\n        reducer: (tables=<-) => tables |> max(column: column),\n        _sortLimit: top,\n    )",
						Start: ast.Position{
							Column: 14,
							Line:   273,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 72,
									Line:   273,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 66,
									Line:   273,
								},
							},
						},
						Name: "tables",
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 6,
								Line:   281,
							},
							File:   "universe.flux",
							Source: "tables\n    |> _highestOrLowest(\n        n: n,\n        column: column,\n        groupColumns: groupColumns,\n        // TODO(nathanielc): Once max/min support selecting based on multiple columns change this to pass all columns.\n        reducer: (tables=<-) => tables |> max(column: column),\n        _sortLimit: top,\n    )",
							Start: ast.Position{
								Column: 66,
								Line:   273,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 24,
										Line:   280,
									},
									File:   "universe.flux",
									Source: "n: n,\n        column: column,\n        groupColumns: groupColumns,\n        // TODO(nathanielc): Once max/min support selecting based on multiple columns change this to pass all columns.\n        reducer: (tables=<-) => tables |> max(column: column),\n        _sortLimit: top",
									Start: ast.Position{
										Column: 9,
										Line:   275,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   275,
										},
										File:   "universe.flux",
										Source: "n: n",
										Start: ast.Position{
											Column: 9,
											Line:   275,
										},
		