// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cognitoidentityprovider

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeResourceServerInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the resource server
	//
	// Identifier is a required field
	Identifier *string `min:"1" type:"string" required:"true"`

	// The user pool ID for the user pool that hosts the resource server.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeResourceServerInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeResourceServerInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeResourceServerInput"}

	if s.Identifier == nil {
		invalidParams.Add(aws.NewErrParamRequired("Identifier"))
	}
	if s.Identifier != nil && len(*s.Identifier) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Identifier", 1))
	}

	if s.UserPoolId == nil {
		invalidParams.Add(aws.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeResourceServerOutput struct {
	_ struct{} `type:"structure"`

	// The resource server.
	//
	// ResourceServer is a required field
	ResourceServer *ResourceServerType `type:"structure" required:"true"`
}

// String returns the string representation
func (s DescribeResourceServerOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeResourceServer = "DescribeResourceServer"

// DescribeResourceServerRequest returns a request value for making API operation for
// Amazon Cognito Identity Provider.
//
// Describes a resource server.
//
//    // Example sending a request using DescribeResourceServerRequest.
//    req := client.DescribeResourceServerRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeResourceServer
func (c *Client) DescribeResourceServerRequest(input *DescribeResourceServerInput) DescribeResourceServerRequest {
	op := &aws.Operation{
		Name:       opDescribeResourceServer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeResourceServerInput{}
	}

	req := c.newRequest(op, input, &DescribeResourceServerOutput{})
	return DescribeResourceServerRequest{Request: req, Input: input, Copy: c.DescribeResourceServerRequest}
}

// DescribeResourceServerRequest is the request type for the
// DescribeResourceServer API operation.
type DescribeResourceServerRequest struct {
	*aws.Request
	Input *DescribeResourceServerInput
	Copy  func(*DescribeResourceServerInput) DescribeResourceServerRequest
}

// Send marshals and sends the DescribeResourceServer API request.
func (r DescribeResourceServerRequest) Send(ctx context.Context) (*DescribeResourceServerResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeResourceServerResponse{
		DescribeResourceServerOutput: r.Request.Data.(*DescribeResourceServerOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeResourceServerResponse is the response type for the
// DescribeResourceServer API operation.
type DescribeResourceServerResponse struct {
	*DescribeResourceServerOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeResourceServer request.
func (r *DescribeResourceServerResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
