// Code generated by lister-gen. DO NOT EDIT.

package v1

import (
	v1 "github.com/openshift/api/template/v1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// TemplateLister helps list Templates.
// All objects returned here must be treated as read-only.
type TemplateLister interface {
	// List lists all Templates in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1.Template, err error)
	// Templates returns an object that can list and get Templates.
	Templates(namespace string) TemplateNamespaceLister
	TemplateListerExpansion
}

// templateLister implements the TemplateLister interface.
type templateLister struct {
	indexer cache.Indexer
}

// NewTemplateLister returns a new TemplateLister.
func NewTemplateLister(indexer cache.Indexer) TemplateLister {
	return &templateLister{indexer: indexer}
}

// List lists all Templates in the indexer.
func (s *templateLister) List(selector labels.Selector) (ret []*v1.Template, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.Template))
	})
	return ret, err
}

// Templates returns an object that can list and get Templates.
func (s *templateLister) Templates(namespace string) TemplateNamespaceLister {
	return templateNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// TemplateNamespaceLister helps list and get Templates.
// All objects returned here must be treated as read-only.
type TemplateNamespaceLister interface {
	// List lists all Templates in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1.Template, err error)
	// Get retrieves the Template from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v1.Template, error)
	TemplateNamespaceListerExpansion
}

// templateNamespaceLister implements the TemplateNamespaceLister
// interface.
type templateNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all Templates in the indexer for a given namespace.
func (s templateNamespaceLister) List(selector labels.Selector) (ret []*v1.Template, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.Template))
	})
	return ret, err
}

// Get retrieves the Template from the indexer for a given namespace and name.
func (s templateNamespaceLister) Get(name string) (*v1.Template, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1.Resource("template"), name)
	}
	return obj.(*v1.Template), nil
}
