// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.22.0
// 	protoc        v3.12.3
// source: google/ads/googleads/v1/common/user_lists.proto

package common

import (
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	wrappers "github.com/golang/protobuf/ptypes/wrappers"
	enums "google.golang.org/genproto/googleapis/ads/googleads/v1/enums"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// SimilarUserList is a list of users which are similar to users from another
// UserList. These lists are read-only and automatically created by Google.
type SimilarUserListInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Seed UserList from which this list is derived.
	SeedUserList *wrappers.StringValue `protobuf:"bytes,1,opt,name=seed_user_list,json=seedUserList,proto3" json:"seed_user_list,omitempty"`
}

func (x *SimilarUserListInfo) Reset() {
	*x = SimilarUserListInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v1_common_user_lists_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SimilarUserListInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SimilarUserListInfo) ProtoMessage() {}

func (x *SimilarUserListInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v1_common_user_lists_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SimilarUserListInfo.ProtoReflect.Descriptor instead.
func (*SimilarUserListInfo) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v1_common_user_lists_proto_rawDescGZIP(), []int{0}
}

func (x *SimilarUserListInfo) GetSeedUserList() *wrappers.StringValue {
	if x != nil {
		return x.SeedUserList
	}
	return nil
}

// UserList of CRM users provided by the advertiser.
type CrmBasedUserListInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A string that uniquely identifies a mobile application from which the data
	// was collected to the Google Ads API.
	// For iOS, the ID string is the 9 digit string that appears at the end of an
	// App Store URL (e.g., "476943146" for "Flood-It! 2" whose App Store link is
	// http://itunes.apple.com/us/app/flood-it!-2/id476943146).
	// For Android, the ID string is the application's package name
	// (e.g., "com.labpixies.colordrips" for "Color Drips" given Google Play link
	// https://play.google.com/store/apps/details?id=com.labpixies.colordrips).
	// Required when creating CrmBasedUserList for uploading mobile advertising
	// IDs.
	AppId *wrappers.StringValue `protobuf:"bytes,1,opt,name=app_id,json=appId,proto3" json:"app_id,omitempty"`
	// Matching key type of the list.
	// Mixed data types are not allowed on the same list.
	// This field is required for an ADD operation.
	UploadKeyType enums.CustomerMatchUploadKeyTypeEnum_CustomerMatchUploadKeyType `protobuf:"varint,2,opt,name=upload_key_type,json=uploadKeyType,proto3,enum=google.ads.googleads.v1.enums.CustomerMatchUploadKeyTypeEnum_CustomerMatchUploadKeyType" json:"upload_key_type,omitempty"`
	// Data source of the list. Default value is FIRST_PARTY.
	// Only whitelisted customers can create third-party sourced CRM lists.
	DataSourceType enums.UserListCrmDataSourceTypeEnum_UserListCrmDataSourceType `protobuf:"varint,3,opt,name=data_source_type,json=dataSourceType,proto3,enum=google.ads.googleads.v1.enums.UserListCrmDataSourceTypeEnum_UserListCrmDataSourceType" json:"data_source_type,omitempty"`
}

func (x *CrmBasedUserListInfo) Reset() {
	*x = CrmBasedUserListInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v1_common_user_lists_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CrmBasedUserListInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CrmBasedUserListInfo) ProtoMessage() {}

func (x *CrmBasedUserListInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v1_common_user_lists_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CrmBasedUserListInfo.ProtoReflect.Descriptor instead.
func (*CrmBasedUserListInfo) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v1_common_user_lists_proto_rawDescGZIP(), []int{1}
}

func (x *CrmBasedUserListInfo) GetAppId() *wrappers.StringValue {
	if x != nil {
		return x.AppId
	}
	return nil
}

func (x *CrmBasedUserListInfo) GetUploadKeyType() enums.CustomerMatchUploadKeyTypeEnum_CustomerMatchUploadKeyType {
	if x != nil {
		return x.UploadKeyType
	}
	return enums.CustomerMatchUploadKeyTypeEnum_UNSPECIFIED
}

func (x *CrmBasedUserListInfo) GetDataSourceType() enums.UserListCrmDataSourceTypeEnum_UserListCrmDataSourceType {
	if x != nil {
		return x.DataSourceType
	}
	return enums.UserListCrmDataSourceTypeEnum_UNSPECIFIED
}

// A client defined rule based on custom parameters sent by web sites or
// uploaded by the advertiser.
type UserListRuleInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Rule type is used to determine how to group rule items.
	//
	// The default is OR of ANDs (disjunctive normal form).
	// That is, rule items will be ANDed together within rule item groups and the
	// groups themselves will be ORed together.
	//
	// Currently AND of ORs (conjunctive normal form) is only supported for
	// ExpressionRuleUserList.
	RuleType enums.UserListRuleTypeEnum_UserListRuleType `protobuf:"varint,1,opt,name=rule_type,json=ruleType,proto3,enum=google.ads.googleads.v1.enums.UserListRuleTypeEnum_UserListRuleType" json:"rule_type,omitempty"`
	// List of rule item groups that defines this rule.
	// Rule item groups are grouped together based on rule_type.
	RuleItemGroups []*UserListRuleItemGroupInfo `protobuf:"bytes,2,rep,name=rule_item_groups,json=ruleItemGroups,proto3" json:"rule_item_groups,omitempty"`
}

func (x *UserListRuleInfo) Reset() {
	*x = UserListRuleInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v1_common_user_lists_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UserListRuleInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserListRuleInfo) ProtoMessage() {}

func (x *UserListRuleInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v1_common_user_lists_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserListRuleInfo.ProtoReflect.Descriptor instead.
func (*UserListRuleInfo) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v1_common_user_lists_proto_rawDescGZIP(), []int{2}
}

func (x *UserListRuleInfo) GetRuleType() enums.UserListRuleTypeEnum_UserListRuleType {
	if x != nil {
		return x.RuleType
	}
	return enums.UserListRuleTypeEnum_UNSPECIFIED
}

func (x *UserListRuleInfo) GetRuleItemGroups() []*UserListRuleItemGroupInfo {
	if x != nil {
		return x.RuleItemGroups
	}
	return nil
}

// A group of rule items.
type UserListRuleItemGroupInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Rule items that will be grouped together based on rule_type.
	RuleItems []*UserListRuleItemInfo `protobuf:"bytes,1,rep,name=rule_items,json=ruleItems,proto3" json:"rule_items,omitempty"`
}

func (x *UserListRuleItemGroupInfo) Reset() {
	*x = UserListRuleItemGroupInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v1_common_user_lists_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UserListRuleItemGroupInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserListRuleItemGroupInfo) ProtoMessage() {}

func (x *UserListRuleItemGroupInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v1_common_user_lists_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserListRuleItemGroupInfo.ProtoReflect.Descriptor instead.
func (*UserListRuleItemGroupInfo) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v1_common_user_lists_proto_rawDescGZIP(), []int{3}
}

func (x *UserListRuleItemGroupInfo) GetRuleItems() []*UserListRuleItemInfo {
	if x != nil {
		return x.RuleItems
	}
	return nil
}

// An atomic rule item.
type UserListRuleItemInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Rule variable name. It should match the corresponding key name fired
	// by the pixel.
	// A name must begin with US-ascii letters or underscore or UTF8 code that is
	// greater than 127 and consist of US-ascii letters or digits or underscore or
	// UTF8 code that is greater than 127.
	// For websites, there are two built-in variable URL (name = 'url__') and
	// referrer URL (name = 'ref_url__').
	// This field must be populated when creating a new rule item.
	Name *wrappers.StringValue `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// An atomic rule item.
	//
	// Types that are assignable to RuleItem:
	//	*UserListRuleItemInfo_NumberRuleItem
	//	*UserListRuleItemInfo_StringRuleItem
	//	*UserListRuleItemInfo_DateRuleItem
	RuleItem isUserListRuleItemInfo_RuleItem `protobuf_oneof:"rule_item"`
}

func (x *UserListRuleItemInfo) Reset() {
	*x = UserListRuleItemInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v1_common_user_lists_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UserListRuleItemInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserListRuleItemInfo) ProtoMessage() {}

func (x *UserListRuleItemInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v1_common_user_lists_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserListRuleItemInfo.ProtoReflect.Descriptor instead.
func (*UserListRuleItemInfo) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v1_common_user_lists_proto_rawDescGZIP(), []int{4}
}

func (x *UserListRuleItemInfo) GetName() *wrappers.StringValue {
	if x != nil {
		return x.Name
	}
	return nil
}

func (m *UserListRuleItemInfo) GetRuleItem() isUserListRuleItemInfo_RuleItem {
	if m != nil {
		return m.RuleItem
	}
	return nil
}

func (x *UserListRuleItemInfo) GetNumberRuleItem() *UserListNumberRuleItemInfo {
	if x, ok := x.GetRuleItem().(*UserListRuleItemInfo_NumberRuleItem); ok {
		return x.NumberRuleItem
	}
	return nil
}

func (x *UserListRuleItemInfo) GetStringRuleItem() *UserListStringRuleItemInfo {
	if x, ok := x.GetRuleItem().(*UserListRuleItemInfo_StringRuleItem); ok {
		return x.StringRuleItem
	}
	return nil
}

func (x *UserListRuleItemInfo) GetDateRuleItem() *UserListDateRuleItemInfo {
	if x, ok := x.GetRuleItem().(*UserListRuleItemInfo_DateRuleItem); ok {
		return x.DateRuleItem
	}
	return nil
}

type isUserListRuleItemInfo_RuleItem interface {
	isUserListRuleItemInfo_RuleItem()
}

type UserListRuleItemInfo_NumberRuleItem struct {
	// An atomic rule item composed of a number operation.
	NumberRuleItem *UserListNumberRuleItemInfo `protobuf:"bytes,2,opt,name=number_rule_item,json=numberRuleItem,proto3,oneof"`
}

type UserListRuleItemInfo_StringRuleItem struct {
	// An atomic rule item composed of a string operation.
	StringRuleItem *UserListStringRuleItemInfo `protobuf:"bytes,3,opt,name=string_rule_item,json=stringRuleItem,proto3,oneof"`
}

type UserListRuleItemInfo_DateRuleItem struct {
	// An atomic rule item composed of a date operation.
	DateRuleItem *UserListDateRuleItemInfo `protobuf:"bytes,4,opt,name=date_rule_item,json=dateRuleItem,proto3,oneof"`
}

func (*UserListRuleItemInfo_NumberRuleItem) isUserListRuleItemInfo_RuleItem() {}

func (*UserListRuleItemInfo_StringRuleItem) isUserListRuleItemInfo_RuleItem() {}

func (*UserListRuleItemInfo_DateRuleItem) isUserListRuleItemInfo_RuleItem() {}

// A rule item composed of a date operation.
type UserListDateRuleItemInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Date comparison operator.
	// This field is required and must be populated when creating new date
	// rule item.
	Operator enums.UserListDateRuleItemOperatorEnum_UserListDateRuleItemOperator `protobuf:"varint,1,opt,name=operator,proto3,enum=google.ads.googleads.v1.enums.UserListDateRuleItemOperatorEnum_UserListDateRuleItemOperator" json:"operator,omitempty"`
	// String representing date value to be compared with the rule variable.
	// Supported date format is YYYY-MM-DD.
	// Times are reported in the customer's time zone.
	Value *wrappers.StringValue `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	// The relative date value of the right hand side denoted by number of days
	// offset from now. The value field will override this field when both are
	// present.
	OffsetInDays *wrappers.Int64Value `protobuf:"bytes,3,opt,name=offset_in_days,json=offsetInDays,proto3" json:"offset_in_days,omitempty"`
}

func (x *UserListDateRuleItemInfo) Reset() {
	*x = UserListDateRuleItemInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v1_common_user_lists_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UserListDateRuleItemInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserListDateRuleItemInfo) ProtoMessage() {}

func (x *UserListDateRuleItemInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v1_common_user_lists_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserListDateRuleItemInfo.ProtoReflect.Descriptor instead.
func (*UserListDateRuleItemInfo) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v1_common_user_lists_proto_rawDescGZIP(), []int{5}
}

func (x *UserListDateRuleItemInfo) GetOperator() enums.UserListDateRuleItemOperatorEnum_UserListDateRuleItemOperator {
	if x != nil {
		return x.Operator
	}
	return enums.UserListDateRuleItemOperatorEnum_UNSPECIFIED
}

func (x *UserListDateRuleItemInfo) GetValue() *wrappers.StringValue {
	if x != nil {
		return x.Value
	}
	return nil
}

func (x *UserListDateRuleItemInfo) GetOffsetInDays() *wrappers.Int64Value {
	if x != nil {
		return x.OffsetInDays
	}
	return nil
}

// A rule item composed of a number operation.
type UserListNumberRuleItemInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Number comparison operator.
	// This field is required and must be populated when creating a new number
	// rule item.
	Operator enums.UserListNumberRuleItemOperatorEnum_UserListNumberRuleItemOperator `protobuf:"varint,1,opt,name=operator,proto3,enum=google.ads.googleads.v1.enums.UserListNumberRuleItemOperatorEnum_UserListNumberRuleItemOperator" json:"operator,omitempty"`
	// Number value to be compared with the variable.
	// This field is required and must be populated when creating a new number
	// rule item.
	Value *wrappers.DoubleValue `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *UserListNumberRuleItemInfo) Reset() {
	*x = UserListNumberRuleItemInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v1_common_user_lists_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UserListNumberRuleItemInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserListNumberRuleItemInfo) ProtoMessage() {}

func (x *UserListNumberRuleItemInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v1_common_user_lists_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserListNumberRuleItemInfo.ProtoReflect.Descriptor instead.
func (*UserListNumberRuleItemInfo) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v1_common_user_lists_proto_rawDescGZIP(), []int{6}
}

func (x *UserListNumberRuleItemInfo) GetOperator() enums.UserListNumberRuleItemOperatorEnum_UserListNumberRuleItemOperator {
	if x != nil {
		return x.Operator
	}
	return enums.UserListNumberRuleItemOperatorEnum_UNSPECIFIED
}

func (x *UserListNumberRuleItemInfo) GetValue() *wrappers.DoubleValue {
	if x != nil {
		return x.Value
	}
	return nil
}

// A rule item composed of a string operation.
type UserListStringRuleItemInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// String comparison operator.
	// This field is required and must be populated when creating a new string
	// rule item.
	Operator enums.UserListStringRuleItemOperatorEnum_UserListStringRuleItemOperator `protobuf:"varint,1,opt,name=operator,proto3,enum=google.ads.googleads.v1.enums.UserListStringRuleItemOperatorEnum_UserListStringRuleItemOperator" json:"operator,omitempty"`
	// The right hand side of the string rule item. For URLs or referrer URLs,
	// the value can not contain illegal URL chars such as newlines, quotes,
	// tabs, or parentheses. This field is required and must be populated when
	// creating a new string rule item.
	Value *wrappers.StringValue `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *UserListStringRuleItemInfo) Reset() {
	*x = UserListStringRuleItemInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v1_common_user_lists_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UserListStringRuleItemInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserListStringRuleItemInfo) ProtoMessage() {}

func (x *UserListStringRuleItemInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v1_common_user_lists_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserListStringRuleItemInfo.ProtoReflect.Descriptor instead.
func (*UserListStringRuleItemInfo) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v1_common_user_lists_proto_rawDescGZIP(), []int{7}
}

func (x *UserListStringRuleItemInfo) GetOperator() enums.UserListStringRuleItemOperatorEnum_UserListStringRuleItemOperator {
	if x != nil {
		return x.Operator
	}
	return enums.UserListStringRuleItemOperatorEnum_UNSPECIFIED
}

func (x *UserListStringRuleItemInfo) GetValue() *wrappers.StringValue {
	if x != nil {
		return x.Value
	}
	return nil
}

// User lists defined by combining two rules, left operand and right operand.
// There are two operators: AND where left operand and right operand have to be
// true; AND_NOT where left operand is true but right operand is false.
type CombinedRuleUserListInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Left operand of the combined rule.
	// This field is required and must be populated when creating new combined
	// rule based user list.
	LeftOperand *UserListRuleInfo `protobuf:"bytes,1,opt,name=left_operand,json=leftOperand,proto3" json:"left_operand,omitempty"`
	// Right operand of the combined rule.
	// This field is required and must be populated when creating new combined
	// rule based user list.
	RightOperand *UserListRuleInfo `protobuf:"bytes,2,opt,name=right_operand,json=rightOperand,proto3" json:"right_operand,omitempty"`
	// Operator to connect the two operands.
	//
	// Required for creating a combined rule user list.
	RuleOperator enums.UserListCombinedRuleOperatorEnum_UserListCombinedRuleOperator `protobuf:"varint,3,opt,name=rule_operator,json=ruleOperator,proto3,enum=google.ads.googleads.v1.enums.UserListCombinedRuleOperatorEnum_UserListCombinedRuleOperator" json:"rule_operator,omitempty"`
}

func (x *CombinedRuleUserListInfo) Reset() {
	*x = CombinedRuleUserListInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v1_common_user_lists_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CombinedRuleUserListInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CombinedRuleUserListInfo) ProtoMessage() {}

func (x *CombinedRuleUserListInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v1_common_user_lists_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CombinedRuleUserListInfo.ProtoReflect.Descriptor instead.
func (*CombinedRuleUserListInfo) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v1_common_user_lists_proto_rawDescGZIP(), []int{8}
}

func (x *CombinedRuleUserListInfo) GetLeftOperand() *UserListRuleInfo {
	if x != nil {
		return x.LeftOperand
	}
	return nil
}

func (x *CombinedRuleUserListInfo) GetRightOperand() *UserListRuleInfo {
	if x != nil {
		return x.RightOperand
	}
	return nil
}

func (x *CombinedRuleUserListInfo) GetRuleOperator() enums.UserListCombinedRuleOperatorEnum_UserListCombinedRuleOperator {
	if x != nil {
		return x.RuleOperator
	}
	return enums.UserListCombinedRuleOperatorEnum_UNSPECIFIED
}

// Visitors of a page during specific dates.
type DateSpecificRuleUserListInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Boolean rule that defines visitor of a page.
	//
	// Required for creating a date specific rule user list.
	Rule *UserListRuleInfo `protobuf:"bytes,1,opt,name=rule,proto3" json:"rule,omitempty"`
	// Start date of users visit. If set to 2000-01-01, then the list includes all
	// users before end_date. The date's format should be YYYY-MM-DD.
	//
	// Required for creating a data specific rule user list.
	StartDate *wrappers.StringValue `protobuf:"bytes,2,opt,name=start_date,json=startDate,proto3" json:"start_date,omitempty"`
	// End date of users visit. If set to 2037-12-30, then the list includes all
	// users after start_date. The date's format should be YYYY-MM-DD.
	//
	// Required for creating a data specific rule user list.
	EndDate *wrappers.StringValue `protobuf:"bytes,3,opt,name=end_date,json=endDate,proto3" json:"end_date,omitempty"`
}

func (x *DateSpecificRuleUserListInfo) Reset() {
	*x = DateSpecificRuleUserListInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v1_common_user_lists_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DateSpecificRuleUserListInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DateSpecificRuleUserListInfo) ProtoMessage() {}

func (x *DateSpecificRuleUserListInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v1_common_user_lists_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DateSpecificRuleUserListInfo.ProtoReflect.Descriptor instead.
func (*DateSpecificRuleUserListInfo) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v1_common_user_lists_proto_rawDescGZIP(), []int{9}
}

func (x *DateSpecificRuleUserListInfo) GetRule() *UserListRuleInfo {
	if x != nil {
		return x.Rule
	}
	return nil
}

func (x *DateSpecificRuleUserListInfo) GetStartDate() *wrappers.StringValue {
	if x != nil {
		return x.StartDate
	}
	return nil
}

func (x *DateSpecificRuleUserListInfo) GetEndDate() *wrappers.StringValue {
	if x != nil {
		return x.EndDate
	}
	return nil
}

// Visitors of a page. The page visit is defined by one boolean rule expression.
type ExpressionRuleUserListInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Boolean rule that defines this user list. The rule consists of a list of
	// rule item groups and each rule item group consists of a list of rule items.
	// All the rule item groups are ORed or ANDed together for evaluation based on
	// rule.rule_type.
	//
	// Required for creating an expression rule user list.
	Rule *UserListRuleInfo `protobuf:"bytes,1,opt,name=rule,proto3" json:"rule,omitempty"`
}

func (x *ExpressionRuleUserListInfo) Reset() {
	*x = ExpressionRuleUserListInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v1_common_user_lists_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExpressionRuleUserListInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExpressionRuleUserListInfo) ProtoMessage() {}

func (x *ExpressionRuleUserListInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v1_common_user_lists_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExpressionRuleUserListInfo.ProtoReflect.Descriptor instead.
func (*ExpressionRuleUserListInfo) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v1_common_user_lists_proto_rawDescGZIP(), []int{10}
}

func (x *ExpressionRuleUserListInfo) GetRule() *UserListRuleInfo {
	if x != nil {
		return x.Rule
	}
	return nil
}

// Representation of a userlist that is generated by a rule.
type RuleBasedUserListInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The status of pre-population. The field is default to NONE if not set which
	// means the previous users will not be considered. If set to REQUESTED, past
	// site visitors or app users who match the list definition will be included
	// in the list (works on the Display Network only). This will only
	// add past users from within the last 30 days, depending on the
	// list's membership duration and the date when the remarketing tag is added.
	// The status will be updated to FINISHED once request is processed, or FAILED
	// if the request fails.
	PrepopulationStatus enums.UserListPrepopulationStatusEnum_UserListPrepopulationStatus `protobuf:"varint,1,opt,name=prepopulation_status,json=prepopulationStatus,proto3,enum=google.ads.googleads.v1.enums.UserListPrepopulationStatusEnum_UserListPrepopulationStatus" json:"prepopulation_status,omitempty"`
	// Subtypes of rule based user lists.
	//
	// Types that are assignable to RuleBasedUserList:
	//	*RuleBasedUserListInfo_CombinedRuleUserList
	//	*RuleBasedUserListInfo_DateSpecificRuleUserList
	//	*RuleBasedUserListInfo_ExpressionRuleUserList
	RuleBasedUserList isRuleBasedUserListInfo_RuleBasedUserList `protobuf_oneof:"rule_based_user_list"`
}

func (x *RuleBasedUserListInfo) Reset() {
	*x = RuleBasedUserListInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v1_common_user_lists_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RuleBasedUserListInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RuleBasedUserListInfo) ProtoMessage() {}

func (x *RuleBasedUserListInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v1_common_user_lists_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RuleBasedUserListInfo.ProtoReflect.Descriptor instead.
func (*RuleBasedUserListInfo) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v1_common_user_lists_proto_rawDescGZIP(), []int{11}
}

func (x *RuleBasedUserListInfo) GetPrepopulationStatus() enums.UserListPrepopulationStatusEnum_UserListPrepopulationStatus {
	if x != nil {
		return x.PrepopulationStatus
	}
	return enums.UserListPrepopulationStatusEnum_UNSPECIFIED
}

func (m *RuleBasedUserListInfo) GetRuleBasedUserList() isRuleBasedUserListInfo_RuleBasedUserList {
	if m != nil {
		return m.RuleBasedUserList
	}
	return nil
}

func (x *RuleBasedUserListInfo) GetCombinedRuleUserList() *CombinedRuleUserListInfo {
	if x, ok := x.GetRuleBasedUserList().(*RuleBasedUserListInfo_CombinedRuleUserList); ok {
		return x.CombinedRuleUserList
	}
	return nil
}

func (x *RuleBasedUserListInfo) GetDateSpecificRuleUserList() *DateSpecificRuleUserListInfo {
	if x, ok := x.GetRuleBasedUserList().(*RuleBasedUserListInfo_DateSpecificRuleUserList); ok {
		return x.DateSpecificRuleUserList
	}
	return nil
}

func (x *RuleBasedUserListInfo) GetExpressionRuleUserList() *ExpressionRuleUserListInfo {
	if x, ok := x.GetRuleBasedUserList().(*RuleBasedUserListInfo_ExpressionRuleUserList); ok {
		return x.ExpressionRuleUserList
	}
	return nil
}

type isRuleBasedUserListInfo_RuleBasedUserList interface {
	isRuleBasedUserListInfo_RuleBasedUserList()
}

type RuleBasedUserListInfo_CombinedRuleUserList struct {
	// User lists defined by combining two rules.
	// There are two operators: AND, where the left and right operands have to
	// be true; AND_NOT where left operand is true but right operand is false.
	CombinedRuleUserList *CombinedRuleUserListInfo `protobuf:"bytes,2,opt,name=combined_rule_user_list,json=combinedRuleUserList,proto3,oneof"`
}

type RuleBasedUserListInfo_DateSpecificRuleUserList struct {
	// Visitors of a page during specific dates. The visiting periods are
	// defined as follows:
	// Between start_date (inclusive) and end_date (inclusive);
	// Before end_date (exclusive) with start_date = 2000-01-01;
	// After start_date (exclusive) with end_date = 2037-12-30.
	DateSpecificRuleUserList *DateSpecificRuleUserListInfo `protobuf:"bytes,3,opt,name=date_specific_rule_user_list,json=dateSpecificRuleUserList,proto3,oneof"`
}

type RuleBasedUserListInfo_ExpressionRuleUserList struct {
	// Visitors of a page. The page visit is defined by one boolean rule
	// expression.
	ExpressionRuleUserList *ExpressionRuleUserListInfo `protobuf:"bytes,4,opt,name=expression_rule_user_list,json=expressionRuleUserList,proto3,oneof"`
}

func (*RuleBasedUserListInfo_CombinedRuleUserList) isRuleBasedUserListInfo_RuleBasedUserList() {}

func (*RuleBasedUserListInfo_DateSpecificRuleUserList) isRuleBasedUserListInfo_RuleBasedUserList() {}

func (*RuleBasedUserListInfo_ExpressionRuleUserList) isRuleBasedUserListInfo_RuleBasedUserList() {}

// Represents a user list that is a custom combination of user lists.
type LogicalUserListInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Logical list rules that define this user list. The rules are defined as a
	// logical operator (ALL/ANY/NONE) and a list of user lists. All the rules are
	// ANDed when they are evaluated.
	//
	// Required for creating a logical user list.
	Rules []*UserListLogicalRuleInfo `protobuf:"bytes,1,rep,name=rules,proto3" json:"rules,omitempty"`
}

func (x *LogicalUserListInfo) Reset() {
	*x = LogicalUserListInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v1_common_user_lists_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LogicalUserListInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LogicalUserListInfo) ProtoMessage() {}

func (x *LogicalUserListInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v1_common_user_lists_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LogicalUserListInfo.ProtoReflect.Descriptor instead.
func (*LogicalUserListInfo) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v1_common_user_lists_proto_rawDescGZIP(), []int{12}
}

func (x *LogicalUserListInfo) GetRules() []*UserListLogicalRuleInfo {
	if x != nil {
		return x.Rules
	}
	return nil
}

// A user list logical rule. A rule has a logical operator (and/or/not) and a
// list of user lists as operands.
type UserListLogicalRuleInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The logical operator of the rule.
	Operator enums.UserListLogicalRuleOperatorEnum_UserListLogicalRuleOperator `protobuf:"varint,1,opt,name=operator,proto3,enum=google.ads.googleads.v1.enums.UserListLogicalRuleOperatorEnum_UserListLogicalRuleOperator" json:"operator,omitempty"`
	// The list of operands of the rule.
	RuleOperands []*LogicalUserListOperandInfo `protobuf:"bytes,2,rep,name=rule_operands,json=ruleOperands,proto3" json:"rule_operands,omitempty"`
}

func (x *UserListLogicalRuleInfo) Reset() {
	*x = UserListLogicalRuleInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v1_common_user_lists_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UserListLogicalRuleInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserListLogicalRuleInfo) ProtoMessage() {}

func (x *UserListLogicalRuleInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v1_common_user_lists_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserListLogicalRuleInfo.ProtoReflect.Descriptor instead.
func (*UserListLogicalRuleInfo) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v1_common_user_lists_proto_rawDescGZIP(), []int{13}
}

func (x *UserListLogicalRuleInfo) GetOperator() enums.UserListLogicalRuleOperatorEnum_UserListLogicalRuleOperator {
	if x != nil {
		return x.Operator
	}
	return enums.UserListLogicalRuleOperatorEnum_UNSPECIFIED
}

func (x *UserListLogicalRuleInfo) GetRuleOperands() []*LogicalUserListOperandInfo {
	if x != nil {
		return x.RuleOperands
	}
	return nil
}

// Operand of logical user list that consists of a user list.
type LogicalUserListOperandInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Resource name of a user list as an operand.
	UserList *wrappers.StringValue `protobuf:"bytes,1,opt,name=user_list,json=userList,proto3" json:"user_list,omitempty"`
}

func (x *LogicalUserListOperandInfo) Reset() {
	*x = LogicalUserListOperandInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v1_common_user_lists_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LogicalUserListOperandInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LogicalUserListOperandInfo) ProtoMessage() {}

func (x *LogicalUserListOperandInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v1_common_user_lists_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LogicalUserListOperandInfo.ProtoReflect.Descriptor instead.
func (*LogicalUserListOperandInfo) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v1_common_user_lists_proto_rawDescGZIP(), []int{14}
}

func (x *LogicalUserListOperandInfo) GetUserList() *wrappers.StringValue {
	if x != nil {
		return x.UserList
	}
	return nil
}

// User list targeting as a collection of conversions or remarketing actions.
type BasicUserListInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Actions associated with this user list.
	Actions []*UserListActionInfo `protobuf:"bytes,1,rep,name=actions,proto3" json:"actions,omitempty"`
}

func (x *BasicUserListInfo) Reset() {
	*x = BasicUserListInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v1_common_user_lists_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BasicUserListInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BasicUserListInfo) ProtoMessage() {}

func (x *BasicUserListInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v1_common_user_lists_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BasicUserListInfo.ProtoReflect.Descriptor instead.
func (*BasicUserListInfo) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v1_common_user_lists_proto_rawDescGZIP(), []int{15}
}

func (x *BasicUserListInfo) GetActions() []*UserListActionInfo {
	if x != nil {
		return x.Actions
	}
	return nil
}

// Represents an action type used for building remarketing user lists.
type UserListActionInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Subtypes of user list action.
	//
	// Types that are assignable to UserListAction:
	//	*UserListActionInfo_ConversionAction
	//	*UserListActionInfo_RemarketingAction
	UserListAction isUserListActionInfo_UserListAction `protobuf_oneof:"user_list_action"`
}

func (x *UserListActionInfo) Reset() {
	*x = UserListActionInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v1_common_user_lists_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UserListActionInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserListActionInfo) ProtoMessage() {}

func (x *UserListActionInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v1_common_user_lists_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserListActionInfo.ProtoReflect.Descriptor instead.
func (*UserListActionInfo) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v1_common_user_lists_proto_rawDescGZIP(), []int{16}
}

func (m *UserListActionInfo) GetUserListAction() isUserListActionInfo_UserListAction {
	if m != nil {
		return m.UserListAction
	}
	return nil
}

func (x *UserListActionInfo) GetConversionAction() *wrappers.StringValue {
	if x, ok := x.GetUserListAction().(*UserListActionInfo_ConversionAction); ok {
		return x.ConversionAction
	}
	return nil
}

func (x *UserListActionInfo) GetRemarketingAction() *wrappers.StringValue {
	if x, ok := x.GetUserListAction().(*UserListActionInfo_RemarketingAction); ok {
		return x.RemarketingAction
	}
	return nil
}

type isUserListActionInfo_UserListAction interface {
	isUserListActionInfo_UserListAction()
}

type UserListActionInfo_ConversionAction struct {
	// A conversion action that's not generated from remarketing.
	ConversionAction *wrappers.StringValue `protobuf:"bytes,1,opt,name=conversion_action,json=conversionAction,proto3,oneof"`
}

type UserListActionInfo_RemarketingAction struct {
	// A remarketing action.
	RemarketingAction *wrappers.StringValue `protobuf:"bytes,2,opt,name=remarketing_action,json=remarketingAction,proto3,oneof"`
}

func (*UserListActionInfo_ConversionAction) isUserListActionInfo_UserListAction() {}

func (*UserListActionInfo_RemarketingAction) isUserListActionInfo_UserListAction() {}

var File_google_ads_googleads_v1_common_user_lists_proto protoreflect.FileDescriptor

var file_google_ads_googleads_v1_common_user_lists_proto_rawDesc = []byte{
	0x0a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e,
	0x2f, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x6c, 0x69, 0x73, 0x74, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f,
	0x6e, 0x1a, 0x42, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73,
	0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x5f,
	0x75, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x44, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64,
	0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x65,
	0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x6c, 0x69, 0x73, 0x74, 0x5f, 0x63,
	0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x65, 0x64, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x5f, 0x6f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x42, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64,
	0x73, 0x2f, 0x76, 0x31, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x75, 0x73, 0x65, 0x72, 0x5f,
	0x6c, 0x69, 0x73, 0x74, 0x5f, 0x63, 0x72, 0x6d, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x45, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x75,
	0x73, 0x65, 0x72, 0x5f, 0x6c, 0x69, 0x73, 0x74, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x72, 0x75,
	0x6c, 0x65, 0x5f, 0x69, 0x74, 0x65, 0x6d, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x43, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x31, 0x2f,
	0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x6c, 0x69, 0x73, 0x74, 0x5f,
	0x6c, 0x6f, 0x67, 0x69, 0x63, 0x61, 0x6c, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x5f, 0x6f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x47, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64,
	0x73, 0x2f, 0x76, 0x31, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x75, 0x73, 0x65, 0x72, 0x5f,
	0x6c, 0x69, 0x73, 0x74, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x5f, 0x72, 0x75, 0x6c, 0x65,
	0x5f, 0x69, 0x74, 0x65, 0x6d, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x42, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73,
	0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x65, 0x6e,
	0x75, 0x6d, 0x73, 0x2f, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x6c, 0x69, 0x73, 0x74, 0x5f, 0x70, 0x72,
	0x65, 0x70, 0x6f, 0x70, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x37, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76,
	0x31, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x6c, 0x69, 0x73,
	0x74, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x47, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73,
	0x2f, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x6c, 0x69, 0x73, 0x74, 0x5f, 0x73, 0x74, 0x72, 0x69, 0x6e,
	0x67, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x5f, 0x69, 0x74, 0x65, 0x6d, 0x5f, 0x6f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x77, 0x72, 0x61, 0x70,
	0x70, 0x65, 0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x59, 0x0a, 0x13, 0x53, 0x69, 0x6d, 0x69,
	0x6c, 0x61, 0x72, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x12,
	0x42, 0x0a, 0x0e, 0x73, 0x65, 0x65, 0x64, 0x5f, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x6c, 0x69, 0x73,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0c, 0x73, 0x65, 0x65, 0x64, 0x55, 0x73, 0x65, 0x72, 0x4c,
	0x69, 0x73, 0x74, 0x22, 0xd1, 0x02, 0x0a, 0x14, 0x43, 0x72, 0x6d, 0x42, 0x61, 0x73, 0x65, 0x64,
	0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x33, 0x0a, 0x06,
	0x61, 0x70, 0x70, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53,
	0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x61, 0x70, 0x70, 0x49,
	0x64, 0x12, 0x80, 0x01, 0x0a, 0x0f, 0x75, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x6b, 0x65, 0x79,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x58, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x43, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x65, 0x72, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x4b,
	0x65, 0x79, 0x54, 0x79, 0x70, 0x65, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x65, 0x72, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x4b, 0x65,
	0x79, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0d, 0x75, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x4b, 0x65, 0x79,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x80, 0x01, 0x0a, 0x10, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x56, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e,
	0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x72, 0x6d, 0x44, 0x61, 0x74, 0x61, 0x53,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x55, 0x73,
	0x65, 0x72, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x72, 0x6d, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0e, 0x64, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x22, 0xda, 0x01, 0x0a, 0x10, 0x55, 0x73, 0x65, 0x72,
	0x4c, 0x69, 0x73, 0x74, 0x52, 0x75, 0x6c, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x61, 0x0a, 0x09,
	0x72, 0x75, 0x6c, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e,
	0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x75, 0x6c, 0x65, 0x54, 0x79, 0x70, 0x65,
	0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x75, 0x6c,
	0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x08, 0x72, 0x75, 0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x63, 0x0a, 0x10, 0x72, 0x75, 0x6c, 0x65, 0x5f, 0x69, 0x74, 0x65, 0x6d, 0x5f, 0x67, 0x72, 0x6f,
	0x75, 0x70, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x4c,
	0x69, 0x73, 0x74, 0x52, 0x75, 0x6c, 0x65, 0x49, 0x74, 0x65, 0x6d, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0e, 0x72, 0x75, 0x6c, 0x65, 0x49, 0x74, 0x65, 0x6d, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x73, 0x22, 0x70, 0x0a, 0x19, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x73, 0x74,
	0x52, 0x75, 0x6c, 0x65, 0x49, 0x74, 0x65, 0x6d, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x6e, 0x66,
	0x6f, 0x12, 0x53, 0x0a, 0x0a, 0x72, 0x75, 0x6c, 0x65, 0x5f, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x73, 0x74, 0x52,
	0x75, 0x6c, 0x65, 0x49, 0x74, 0x65, 0x6d, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x09, 0x72, 0x75, 0x6c,
	0x65, 0x49, 0x74, 0x65, 0x6d, 0x73, 0x22, 0x87, 0x03, 0x0a, 0x14, 0x55, 0x73, 0x65, 0x72, 0x4c,
	0x69, 0x73, 0x74, 0x52, 0x75, 0x6c, 0x65, 0x49, 0x74, 0x65, 0x6d, 0x49, 0x6e, 0x66, 0x6f, 0x12,
	0x30, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x66, 0x0a, 0x10, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x5f, 0x72, 0x75, 0x6c, 0x65,
	0x5f, 0x69, 0x74, 0x65, 0x6d, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x55, 0x73, 0x65,
	0x72, 0x4c, 0x69, 0x73, 0x74, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x52, 0x75, 0x6c, 0x65, 0x49,
	0x74, 0x65, 0x6d, 0x49, 0x6e, 0x66, 0x6f, 0x48, 0x00, 0x52, 0x0e, 0x6e, 0x75, 0x6d, 0x62, 0x65,
	0x72, 0x52, 0x75, 0x6c, 0x65, 0x49, 0x74, 0x65, 0x6d, 0x12, 0x66, 0x0a, 0x10, 0x73, 0x74, 0x72,
	0x69, 0x6e, 0x67, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x5f, 0x69, 0x74, 0x65, 0x6d, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f,
	0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x74, 0x72,
	0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c, 0x65, 0x49, 0x74, 0x65, 0x6d, 0x49, 0x6e, 0x66, 0x6f, 0x48,
	0x00, 0x52, 0x0e, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c, 0x65, 0x49, 0x74, 0x65,
	0x6d, 0x12, 0x60, 0x0a, 0x0e, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x5f, 0x69,
	0x74, 0x65, 0x6d, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x4c,
	0x69, 0x73, 0x74, 0x44, 0x61, 0x74, 0x65, 0x52, 0x75, 0x6c, 0x65, 0x49, 0x74, 0x65, 0x6d, 0x49,
	0x6e, 0x66, 0x6f, 0x48, 0x00, 0x52, 0x0c, 0x64, 0x61, 0x74, 0x65, 0x52, 0x75, 0x6c, 0x65, 0x49,
	0x74, 0x65, 0x6d, 0x42, 0x0b, 0x0a, 0x09, 0x72, 0x75, 0x6c, 0x65, 0x5f, 0x69, 0x74, 0x65, 0x6d,
	0x22, 0x8b, 0x02, 0x0a, 0x18, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x61, 0x74,
	0x65, 0x52, 0x75, 0x6c, 0x65, 0x49, 0x74, 0x65, 0x6d, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x78, 0x0a,
	0x08, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x5c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e,
	0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x61, 0x74, 0x65, 0x52, 0x75, 0x6c, 0x65,
	0x49, 0x74, 0x65, 0x6d, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x45, 0x6e, 0x75, 0x6d,
	0x2e, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x61, 0x74, 0x65, 0x52, 0x75, 0x6c,
	0x65, 0x49, 0x74, 0x65, 0x6d, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x52, 0x08, 0x6f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x12, 0x32, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x41, 0x0a, 0x0e, 0x6f,
	0x66, 0x66, 0x73, 0x65, 0x74, 0x5f, 0x69, 0x6e, 0x5f, 0x64, 0x61, 0x79, 0x73, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x0c, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x49, 0x6e, 0x44, 0x61, 0x79, 0x73, 0x22, 0xce,
	0x01, 0x0a, 0x1a, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x73, 0x74, 0x4e, 0x75, 0x6d, 0x62, 0x65,
	0x72, 0x52, 0x75, 0x6c, 0x65, 0x49, 0x74, 0x65, 0x6d, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x7c, 0x0a,
	0x08, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x60, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e,
	0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x73, 0x74, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x52, 0x75,
	0x6c, 0x65, 0x49, 0x74, 0x65, 0x6d, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x45, 0x6e,
	0x75, 0x6d, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x73, 0x74, 0x4e, 0x75, 0x6d, 0x62, 0x65,
	0x72, 0x52, 0x75, 0x6c, 0x65, 0x49, 0x74, 0x65, 0x6d, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f,
	0x72, 0x52, 0x08, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x12, 0x32, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75,
	0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22,
	0xce, 0x01, 0x0a, 0x1a, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x74, 0x72, 0x69,
	0x6e, 0x67, 0x52, 0x75, 0x6c, 0x65, 0x49, 0x74, 0x65, 0x6d, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x7c,
	0x0a, 0x08, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x60, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73,
	0x2e, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x52,
	0x75, 0x6c, 0x65, 0x49, 0x74, 0x65, 0x6d, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x45,
	0x6e, 0x75, 0x6d, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x74, 0x72, 0x69,
	0x6e, 0x67, 0x52, 0x75, 0x6c, 0x65, 0x49, 0x74, 0x65, 0x6d, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x6f, 0x72, 0x52, 0x08, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x12, 0x32, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74,
	0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x22, 0xca, 0x02, 0x0a, 0x18, 0x43, 0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x65, 0x64, 0x52, 0x75, 0x6c,
	0x65, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x53, 0x0a,
	0x0c, 0x6c, 0x65, 0x66, 0x74, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x6e, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f,
	0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x75, 0x6c,
	0x65, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0b, 0x6c, 0x65, 0x66, 0x74, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x6e, 0x64, 0x12, 0x55, 0x0a, 0x0d, 0x72, 0x69, 0x67, 0x68, 0x74, 0x5f, 0x6f, 0x70, 0x65, 0x72,
	0x61, 0x6e, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x4c,
	0x69, 0x73, 0x74, 0x52, 0x75, 0x6c, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0c, 0x72, 0x69, 0x67,
	0x68, 0x74, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x6e, 0x64, 0x12, 0x81, 0x01, 0x0a, 0x0d, 0x72, 0x75,
	0x6c, 0x65, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x5c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x65, 0x6e, 0x75, 0x6d,
	0x73, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6d, 0x62, 0x69, 0x6e,
	0x65, 0x64, 0x52, 0x75, 0x6c, 0x65, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x45, 0x6e,
	0x75, 0x6d, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6d, 0x62, 0x69,
	0x6e, 0x65, 0x64, 0x52, 0x75, 0x6c, 0x65, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x52,
	0x0c, 0x72, 0x75, 0x6c, 0x65, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x22, 0xda, 0x01,
	0x0a, 0x1c, 0x44, 0x61, 0x74, 0x65, 0x53, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69, 0x63, 0x52, 0x75,
	0x6c, 0x65, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x44,
	0x0a, 0x04, 0x72, 0x75, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x55, 0x73,
	0x65, 0x72, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x75, 0x6c, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x04,
	0x72, 0x75, 0x6c, 0x65, 0x12, 0x3b, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x64, 0x61,
	0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e,
	0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x44, 0x61, 0x74,
	0x65, 0x12, 0x37, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x44, 0x61, 0x74, 0x65, 0x22, 0x62, 0x0a, 0x1a, 0x45, 0x78,
	0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6c, 0x65, 0x55, 0x73, 0x65, 0x72,
	0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x44, 0x0a, 0x04, 0x72, 0x75, 0x6c, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x73, 0x74,
	0x52, 0x75, 0x6c, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x04, 0x72, 0x75, 0x6c, 0x65, 0x22, 0xab,
	0x04, 0x0a, 0x15, 0x52, 0x75, 0x6c, 0x65, 0x42, 0x61, 0x73, 0x65, 0x64, 0x55, 0x73, 0x65, 0x72,
	0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x8d, 0x01, 0x0a, 0x14, 0x70, 0x72, 0x65,
	0x70, 0x6f, 0x70, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x5a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x73, 0x74,
	0x50, 0x72, 0x65, 0x70, 0x6f, 0x70, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x73, 0x74,
	0x50, 0x72, 0x65, 0x70, 0x6f, 0x70, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x52, 0x13, 0x70, 0x72, 0x65, 0x70, 0x6f, 0x70, 0x75, 0x6c, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x71, 0x0a, 0x17, 0x63, 0x6f, 0x6d, 0x62,
	0x69, 0x6e, 0x65, 0x64, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x5f, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x6c,
	0x69, 0x73, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x43, 0x6f, 0x6d, 0x62, 0x69,
	0x6e, 0x65, 0x64, 0x52, 0x75, 0x6c, 0x65, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x73, 0x74, 0x49,
	0x6e, 0x66, 0x6f, 0x48, 0x00, 0x52, 0x14, 0x63, 0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x65, 0x64, 0x52,
	0x75, 0x6c, 0x65, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x7e, 0x0a, 0x1c, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69, 0x63, 0x5f, 0x72, 0x75, 0x6c,
	0x65, 0x5f, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x6c, 0x69, 0x73, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f, 0x6d, 0x6d,
	0x6f, 0x6e, 0x2e, 0x44, 0x61, 0x74, 0x65, 0x53, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69, 0x63, 0x52,
	0x75, 0x6c, 0x65, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x48,
	0x00, 0x52, 0x18, 0x64, 0x61, 0x74, 0x65, 0x53, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69, 0x63, 0x52,
	0x75, 0x6c, 0x65, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x77, 0x0a, 0x19, 0x65,
	0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x5f, 0x75,
	0x73, 0x65, 0x72, 0x5f, 0x6c, 0x69, 0x73, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e,
	0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6c, 0x65, 0x55, 0x73,
	0x65, 0x72, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x48, 0x00, 0x52, 0x16, 0x65, 0x78,
	0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6c, 0x65, 0x55, 0x73, 0x65, 0x72,
	0x4c, 0x69, 0x73, 0x74, 0x42, 0x16, 0x0a, 0x14, 0x72, 0x75, 0x6c, 0x65, 0x5f, 0x62, 0x61, 0x73,
	0x65, 0x64, 0x5f, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x6c, 0x69, 0x73, 0x74, 0x22, 0x64, 0x0a, 0x13,
	0x4c, 0x6f, 0x67, 0x69, 0x63, 0x61, 0x6c, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x73, 0x74, 0x49,
	0x6e, 0x66, 0x6f, 0x12, 0x4d, 0x0a, 0x05, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f, 0x6d,
	0x6d, 0x6f, 0x6e, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x73, 0x74, 0x4c, 0x6f, 0x67, 0x69,
	0x63, 0x61, 0x6c, 0x52, 0x75, 0x6c, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x05, 0x72, 0x75, 0x6c,
	0x65, 0x73, 0x22, 0xf2, 0x01, 0x0a, 0x17, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x73, 0x74, 0x4c,
	0x6f, 0x67, 0x69, 0x63, 0x61, 0x6c, 0x52, 0x75, 0x6c, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x76,
	0x0a, 0x08, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x5a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73,
	0x2e, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x73, 0x74, 0x4c, 0x6f, 0x67, 0x69, 0x63, 0x61, 0x6c,
	0x52, 0x75, 0x6c, 0x65, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x45, 0x6e, 0x75, 0x6d,
	0x2e, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x73, 0x74, 0x4c, 0x6f, 0x67, 0x69, 0x63, 0x61, 0x6c,
	0x52, 0x75, 0x6c, 0x65, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x52, 0x08, 0x6f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x12, 0x5f, 0x0a, 0x0d, 0x72, 0x75, 0x6c, 0x65, 0x5f, 0x6f,
	0x70, 0x65, 0x72, 0x61, 0x6e, 0x64, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x4c,
	0x6f, 0x67, 0x69, 0x63, 0x61, 0x6c, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x73, 0x74, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x6e, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0c, 0x72, 0x75, 0x6c, 0x65, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x6e, 0x64, 0x73, 0x22, 0x57, 0x0a, 0x1a, 0x4c, 0x6f, 0x67, 0x69, 0x63,
	0x61, 0x6c, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x73, 0x74, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x6e,
	0x64, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x39, 0x0a, 0x09, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x6c, 0x69,
	0x73, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e,
	0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x08, 0x75, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x73, 0x74,
	0x22, 0x61, 0x0a, 0x11, 0x42, 0x61, 0x73, 0x69, 0x63, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x73,
	0x74, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x4c, 0x0a, 0x07, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x73, 0x74,
	0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x07, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x22, 0xc4, 0x01, 0x0a, 0x12, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x73, 0x74,
	0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x4b, 0x0a, 0x11, 0x63, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x48, 0x00, 0x52, 0x10, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4d, 0x0a, 0x12, 0x72, 0x65, 0x6d, 0x61, 0x72,
	0x6b, 0x65, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x48, 0x00, 0x52, 0x11, 0x72, 0x65, 0x6d, 0x61, 0x72, 0x6b, 0x65, 0x74, 0x69, 0x6e, 0x67,
	0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x12, 0x0a, 0x10, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x6c,
	0x69, 0x73, 0x74, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0xe9, 0x01, 0x0a, 0x22, 0x63,
	0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f,
	0x6e, 0x42, 0x0e, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x73, 0x74, 0x73, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x50, 0x01, 0x5a, 0x44, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61,
	0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6d, 0x6d,
	0x6f, 0x6e, 0x3b, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0xa2, 0x02, 0x03, 0x47, 0x41, 0x41, 0xaa,
	0x02, 0x1e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x41, 0x64, 0x73, 0x2e, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x2e, 0x56, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e,
	0xca, 0x02, 0x1e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x41, 0x64, 0x73, 0x5c, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x5c, 0x56, 0x31, 0x5c, 0x43, 0x6f, 0x6d, 0x6d, 0x6f,
	0x6e, 0xea, 0x02, 0x22, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x41, 0x64, 0x73, 0x3a,
	0x3a, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x3a, 0x3a, 0x56, 0x31, 0x3a, 0x3a,
	0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_ads_googleads_v1_common_user_lists_proto_rawDescOnce sync.Once
	file_google_ads_googleads_v1_common_user_lists_proto_rawDescData = file_google_ads_googleads_v1_common_user_lists_proto_rawDesc
)

func file_google_ads_googleads_v1_common_user_lists_proto_rawDescGZIP() []byte {
	file_google_ads_googleads_v1_common_user_lists_proto_rawDescOnce.Do(func() {
		file_google_ads_googleads_v1_common_user_lists_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_ads_googleads_v1_common_user_lists_proto_rawDescData)
	})
	return file_google_ads_googleads_v1_common_user_lists_proto_rawDescData
}

var file_google_ads_googleads_v1_common_user_lists_proto_msgTypes = make([]protoimpl.MessageInfo, 17)
var file_google_ads_googleads_v1_common_user_lists_proto_goTypes = []interface{}{
	(*SimilarUserListInfo)(nil),                                                  // 0: google.ads.googleads.v1.common.SimilarUserListInfo
	(*CrmBasedUserListInfo)(nil),                                                 // 1: google.ads.googleads.v1.common.CrmBasedUserListInfo
	(*UserListRuleInfo)(nil),                                                     // 2: google.ads.googleads.v1.common.UserListRuleInfo
	(*UserListRuleItemGroupInfo)(nil),                                            // 3: google.ads.googleads.v1.common.UserListRuleItemGroupInfo
	(*UserListRuleItemInfo)(nil),                                                 // 4: google.ads.googleads.v1.common.UserListRuleItemInfo
	(*UserListDateRuleItemInfo)(nil),                                             // 5: google.ads.googleads.v1.common.UserListDateRuleItemInfo
	(*UserListNumberRuleItemInfo)(nil),                                           // 6: google.ads.googleads.v1.common.UserListNumberRuleItemInfo
	(*UserListStringRuleItemInfo)(nil),                                           // 7: google.ads.googleads.v1.common.UserListStringRuleItemInfo
	(*CombinedRuleUserListInfo)(nil),                                             // 8: google.ads.googleads.v1.common.CombinedRuleUserListInfo
	(*DateSpecificRuleUserListInfo)(nil),                                         // 9: google.ads.googleads.v1.common.DateSpecificRuleUserListInfo
	(*ExpressionRuleUserListInfo)(nil),                                           // 10: google.ads.googleads.v1.common.ExpressionRuleUserListInfo
	(*RuleBasedUserListInfo)(nil),                                                // 11: google.ads.googleads.v1.common.RuleBasedUserListInfo
	(*LogicalUserListInfo)(nil),                                                  // 12: google.ads.googleads.v1.common.LogicalUserListInfo
	(*UserListLogicalRuleInfo)(nil),                                              // 13: google.ads.googleads.v1.common.UserListLogicalRuleInfo
	(*LogicalUserListOperandInfo)(nil),                                           // 14: google.ads.googleads.v1.common.LogicalUserListOperandInfo
	(*BasicUserListInfo)(nil),                                                    // 15: google.ads.googleads.v1.common.BasicUserListInfo
	(*UserListActionInfo)(nil),                                                   // 16: google.ads.googleads.v1.common.UserListActionInfo
	(*wrappers.StringValue)(nil),                                                 // 17: google.protobuf.StringValue
	(enums.CustomerMatchUploadKeyTypeEnum_CustomerMatchUploadKeyType)(0),         // 18: google.ads.googleads.v1.enums.CustomerMatchUploadKeyTypeEnum.CustomerMatchUploadKeyType
	(enums.UserListCrmDataSourceTypeEnum_UserListCrmDataSourceType)(0),           // 19: google.ads.googleads.v1.enums.UserListCrmDataSourceTypeEnum.UserListCrmDataSourceType
	(enums.UserListRuleTypeEnum_UserListRuleType)(0),                             // 20: google.ads.googleads.v1.enums.UserListRuleTypeEnum.UserListRuleType
	(enums.UserListDateRuleItemOperatorEnum_UserListDateRuleItemOperator)(0),     // 21: google.ads.googleads.v1.enums.UserListDateRuleItemOperatorEnum.UserListDateRuleItemOperator
	(*wrappers.Int64Value)(nil),                                                  // 22: google.protobuf.Int64Value
	(enums.UserListNumberRuleItemOperatorEnum_UserListNumberRuleItemOperator)(0), // 23: google.ads.googleads.v1.enums.UserListNumberRuleItemOperatorEnum.UserListNumberRuleItemOperator
	(*wrappers.DoubleValue)(nil),                                                 // 24: google.protobuf.DoubleValue
	(enums.UserListStringRuleItemOperatorEnum_UserListStringRuleItemOperator)(0), // 25: google.ads.googleads.v1.enums.UserListStringRuleItemOperatorEnum.UserListStringRuleItemOperator
	(enums.UserListCombinedRuleOperatorEnum_UserListCombinedRuleOperator)(0),     // 26: google.ads.googleads.v1.enums.UserListCombinedRuleOperatorEnum.UserListCombinedRuleOperator
	(enums.UserListPrepopulationStatusEnum_UserListPrepopulationStatus)(0),       // 27: google.ads.googleads.v1.enums.UserListPrepopulationStatusEnum.UserListPrepopulationStatus
	(enums.UserListLogicalRuleOperatorEnum_UserListLogicalRuleOperator)(0),       // 28: google.ads.googleads.v1.enums.UserListLogicalRuleOperatorEnum.UserListLogicalRuleOperator
}
var file_google_ads_googleads_v1_common_user_lists_proto_depIdxs = []int32{
	17, // 0: google.ads.googleads.v1.common.SimilarUserListInfo.seed_user_list:type_name -> google.protobuf.StringValue
	17, // 1: google.ads.googleads.v1.common.CrmBasedUserListInfo.app_id:type_name -> google.protobuf.StringValue
	18, // 2: google.ads.googleads.v1.common.CrmBasedUserListInfo.upload_key_type:type_name -> google.ads.googleads.v1.enums.CustomerMatchUploadKeyTypeEnum.CustomerMatchUploadKeyType
	19, // 3: google.ads.googleads.v1.common.CrmBasedUserListInfo.data_source_type:type_name -> google.ads.googleads.v1.enums.UserListCrmDataSourceTypeEnum.UserListCrmDataSourceType
	20, // 4: google.ads.googleads.v1.common.UserListRuleInfo.rule_type:type_name -> google.ads.googleads.v1.enums.UserListRuleTypeEnum.UserListRuleType
	3,  // 5: google.ads.googleads.v1.common.UserListRuleInfo.rule_item_groups:type_name -> google.ads.googleads.v1.common.UserListRuleItemGroupInfo
	4,  // 6: google.ads.googleads.v1.common.UserListRuleItemGroupInfo.rule_items:type_name -> google.ads.googleads.v1.common.UserListRuleItemInfo
	17, // 7: google.ads.googleads.v1.common.UserListRuleItemInfo.name:type_name -> google.protobuf.StringValue
	6,  // 8: google.ads.googleads.v1.common.UserListRuleItemInfo.number_rule_item:type_name -> google.ads.googleads.v1.common.UserListNumberRuleItemInfo
	7,  // 9: google.ads.googleads.v1.common.UserListRuleItemInfo.string_rule_item:type_name -> google.ads.googleads.v1.common.UserListStringRuleItemInfo
	5,  // 10: google.ads.googleads.v1.common.UserListRuleItemInfo.date_rule_item:type_name -> google.ads.googleads.v1.common.UserListDateRuleItemInfo
	21, // 11: google.ads.googleads.v1.common.UserListDateRuleItemInfo.operator:type_name -> google.ads.googleads.v1.enums.UserListDateRuleItemOperatorEnum.UserListDateRuleItemOperator
	17, // 12: google.ads.googleads.v1.common.UserListDateRuleItemInfo.value:type_name -> google.protobuf.StringValue
	22, // 13: google.ads.googleads.v1.common.UserListDateRuleItemInfo.offset_in_days:type_name -> google.protobuf.Int64Value
	23, // 14: google.ads.googleads.v1.common.UserListNumberRuleItemInfo.operator:type_name -> google.ads.googleads.v1.enums.UserListNumberRuleItemOperatorEnum.UserListNumberRuleItemOperator
	24, // 15: google.ads.googleads.v1.common.UserListNumberRuleItemInfo.value:type_name -> google.protobuf.DoubleValue
	25, // 16: google.ads.googleads.v1.common.UserListStringRuleItemInfo.operator:type_name -> google.ads.googleads.v1.enums.UserListStringRuleItemOperatorEnum.UserListStringRuleItemOperator
	17, // 17: google.ads.googleads.v1.common.UserListStringRuleItemInfo.value:type_name -> google.protobuf.StringValue
	2,  // 18: google.ads.googleads.v1.common.CombinedRuleUserListInfo.left_operand:type_name -> google.ads.googleads.v1.common.UserListRuleInfo
	2,  // 19: google.ads.googleads.v1.common.CombinedRuleUserListInfo.right_operand:type_name -> google.ads.googleads.v1.common.UserListRuleInfo
	26, // 20: google.ads.googleads.v1.common.CombinedRuleUserListInfo.rule_operator:type_name -> google.ads.googleads.v1.enums.UserListCombinedRuleOperatorEnum.UserListCombinedRuleOperator
	2,  // 21: google.ads.googleads.v1.common.DateSpecificRuleUserListInfo.rule:type_name -> google.ads.googleads.v1.common.UserListRuleInfo
	17, // 22: google.ads.googleads.v1.common.DateSpecificRuleUserListInfo.start_date:type_name -> google.protobuf.StringValue
	17, // 23: google.ads.googleads.v1.common.DateSpecificRuleUserListInfo.end_date:type_name -> google.protobuf.StringValue
	2,  // 24: google.ads.googleads.v1.common.ExpressionRuleUserListInfo.rule:type_name -> google.ads.googleads.v1.common.UserListRuleInfo
	27, // 25: google.ads.googleads.v1.common.RuleBasedUserListInfo.prepopulation_status:type_name -> google.ads.googleads.v1.enums.UserListPrepopulationStatusEnum.UserListPrepopulationStatus
	8,  // 26: google.ads.googleads.v1.common.RuleBasedUserListInfo.combined_rule_user_list:type_name -> google.ads.googleads.v1.common.CombinedRuleUserListInfo
	9,  // 27: google.ads.googleads.v1.common.RuleBasedUserListInfo.date_specific_rule_user_list:type_name -> google.ads.googleads.v1.common.DateSpecificRuleUserListInfo
	10, // 28: google.ads.googleads.v1.common.RuleBasedUserListInfo.expression_rule_user_list:type_name -> google.ads.googleads.v1.common.ExpressionRuleUserListInfo
	13, // 29: google.ads.googleads.v1.common.LogicalUserListInfo.rules:type_name -> google.ads.googleads.v1.common.UserListLogicalRuleInfo
	28, // 30: google.ads.googleads.v1.common.UserListLogicalRuleInfo.operator:type_name -> google.ads.googleads.v1.enums.UserListLogicalRuleOperatorEnum.UserListLogicalRuleOperator
	14, // 31: google.ads.googleads.v1.common.UserListLogicalRuleInfo.rule_operands:type_name -> google.ads.googleads.v1.common.LogicalUserListOperandInfo
	17, // 32: google.ads.googleads.v1.common.LogicalUserListOperandInfo.user_list:type_name -> google.protobuf.StringValue
	16, // 33: google.ads.googleads.v1.common.BasicUserListInfo.actions:type_name -> google.ads.googleads.v1.common.UserListActionInfo
	17, // 34: google.ads.googleads.v1.common.UserListActionInfo.conversion_action:type_name -> google.protobuf.StringValue
	17, // 35: google.ads.googleads.v1.common.UserListActionInfo.remarketing_action:type_name -> google.protobuf.StringValue
	36, // [36:36] is the sub-list for method output_type
	36, // [36:36] is the sub-list for method input_type
	36, // [36:36] is the sub-list for extension type_name
	36, // [36:36] is the sub-list for extension extendee
	0,  // [0:36] is the sub-list for field type_name
}

func init() { file_google_ads_googleads_v1_common_user_lists_proto_init() }
func file_google_ads_googleads_v1_common_user_lists_proto_init() {
	if File_google_ads_googleads_v1_common_user_lists_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_ads_googleads_v1_common_user_lists_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SimilarUserListInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v1_common_user_lists_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CrmBasedUserListInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v1_common_user_lists_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UserListRuleInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v1_common_user_lists_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UserListRuleItemGroupInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v1_common_user_lists_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UserListRuleItemInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v1_common_user_lists_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UserListDateRuleItemInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v1_common_user_lists_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UserListNumberRuleItemInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v1_common_user_lists_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UserListStringRuleItemInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v1_common_user_lists_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CombinedRuleUserListInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v1_common_user_lists_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DateSpecificRuleUserListInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v1_common_user_lists_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExpressionRuleUserListInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v1_common_user_lists_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RuleBasedUserListInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v1_common_user_lists_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LogicalUserListInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v1_common_user_lists_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UserListLogicalRuleInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v1_common_user_lists_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LogicalUserListOperandInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v1_common_user_lists_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BasicUserListInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v1_common_user_lists_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UserListActionInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_ads_googleads_v1_common_user_lists_proto_msgTypes[4].OneofWrappers = []interface{}{
		(*UserListRuleItemInfo_NumberRuleItem)(nil),
		(*UserListRuleItemInfo_StringRuleItem)(nil),
		(*UserListRuleItemInfo_DateRuleItem)(nil),
	}
	file_google_ads_googleads_v1_common_user_lists_proto_msgTypes[11].OneofWrappers = []interface{}{
		(*RuleBasedUserListInfo_CombinedRuleUserList)(nil),
		(*RuleBasedUserListInfo_DateSpecificRuleUserList)(nil),
		(*RuleBasedUserListInfo_ExpressionRuleUserList)(nil),
	}
	file_google_ads_googleads_v1_common_user_lists_proto_msgTypes[16].OneofWrappers = []interface{}{
		(*UserListActionInfo_ConversionAction)(nil),
		(*UserListActionInfo_RemarketingAction)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_ads_googleads_v1_common_user_lists_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   17,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_ads_googleads_v1_common_user_lists_proto_goTypes,
		DependencyIndexes: file_google_ads_googleads_v1_common_user_lists_proto_depIdxs,
		MessageInfos:      file_google_ads_googleads_v1_common_user_lists_proto_msgTypes,
	}.Build()
	File_google_ads_googleads_v1_common_user_lists_proto = out.File
	file_google_ads_googleads_v1_common_user_lists_proto_rawDesc = nil
	file_google_ads_googleads_v1_common_user_lists_proto_goTypes = nil
	file_google_ads_googleads_v1_common_user_lists_proto_depIdxs = nil
}
