// Copyright 2017 Google Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.22.0
// 	protoc        v3.12.3
// source: google/cloud/runtimeconfig/v1beta1/resources.proto

package runtimeconfig

import (
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	duration "github.com/golang/protobuf/ptypes/duration"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// The `VariableState` describes the last known state of the variable and is
// used during a `variables().watch` call to distinguish the state of the
// variable.
type VariableState int32

const (
	// Default variable state.
	VariableState_VARIABLE_STATE_UNSPECIFIED VariableState = 0
	// The variable was updated, while `variables().watch` was executing.
	VariableState_UPDATED VariableState = 1
	// The variable was deleted, while `variables().watch` was executing.
	VariableState_DELETED VariableState = 2
)

// Enum value maps for VariableState.
var (
	VariableState_name = map[int32]string{
		0: "VARIABLE_STATE_UNSPECIFIED",
		1: "UPDATED",
		2: "DELETED",
	}
	VariableState_value = map[string]int32{
		"VARIABLE_STATE_UNSPECIFIED": 0,
		"UPDATED":                    1,
		"DELETED":                    2,
	}
)

func (x VariableState) Enum() *VariableState {
	p := new(VariableState)
	*p = x
	return p
}

func (x VariableState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (VariableState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_runtimeconfig_v1beta1_resources_proto_enumTypes[0].Descriptor()
}

func (VariableState) Type() protoreflect.EnumType {
	return &file_google_cloud_runtimeconfig_v1beta1_resources_proto_enumTypes[0]
}

func (x VariableState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use VariableState.Descriptor instead.
func (VariableState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_runtimeconfig_v1beta1_resources_proto_rawDescGZIP(), []int{0}
}

// A RuntimeConfig resource is the primary resource in the Cloud RuntimeConfig
// service. A RuntimeConfig resource consists of metadata and a hierarchy of
// variables.
type RuntimeConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of a runtime config. The name must have the format:
	//
	//     projects/[PROJECT_ID]/configs/[CONFIG_NAME]
	//
	// The `[PROJECT_ID]` must be a valid project ID, and `[CONFIG_NAME]` is an
	// arbitrary name that matches RFC 1035 segment specification. The length of
	// `[CONFIG_NAME]` must be less than 64 bytes.
	//
	// You pick the RuntimeConfig resource name, but the server will validate that
	// the name adheres to this format. After you create the resource, you cannot
	// change the resource's name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// An optional description of the RuntimeConfig object.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
}

func (x *RuntimeConfig) Reset() {
	*x = RuntimeConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_runtimeconfig_v1beta1_resources_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RuntimeConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RuntimeConfig) ProtoMessage() {}

func (x *RuntimeConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_runtimeconfig_v1beta1_resources_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RuntimeConfig.ProtoReflect.Descriptor instead.
func (*RuntimeConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_runtimeconfig_v1beta1_resources_proto_rawDescGZIP(), []int{0}
}

func (x *RuntimeConfig) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *RuntimeConfig) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

// Describes a single variable within a RuntimeConfig resource.
// The name denotes the hierarchical variable name. For example,
// `ports/serving_port` is a valid variable name. The variable value is an
// opaque string and only leaf variables can have values (that is, variables
// that do not have any child variables).
type Variable struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the variable resource, in the format:
	//
	//     projects/[PROJECT_ID]/configs/[CONFIG_NAME]/variables/[VARIABLE_NAME]
	//
	// The `[PROJECT_ID]` must be a valid project ID, `[CONFIG_NAME]` must be a
	// valid RuntimeConfig reource and `[VARIABLE_NAME]` follows Unix file system
	// file path naming.
	//
	// The `[VARIABLE_NAME]` can contain ASCII letters, numbers, slashes and
	// dashes. Slashes are used as path element separators and are not part of the
	// `[VARIABLE_NAME]` itself, so `[VARIABLE_NAME]` must contain at least one
	// non-slash character. Multiple slashes are coalesced into single slash
	// character. Each path segment should follow RFC 1035 segment specification.
	// The length of a `[VARIABLE_NAME]` must be less than 256 bytes.
	//
	// Once you create a variable, you cannot change the variable name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The value of the variable. It can be either a binary or a string
	// value. You must specify one of either `value` or `text`. Specifying both
	// will cause the server to return an error.
	//
	// Types that are assignable to Contents:
	//	*Variable_Value
	//	*Variable_Text
	Contents isVariable_Contents `protobuf_oneof:"contents"`
	// [Output Only] The time of the last variable update.
	UpdateTime *timestamp.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// [Ouput only] The current state of the variable. The variable state
	// indicates the outcome of the `variables().watch` call and is visible
	// through the `get` and `list` calls.
	State VariableState `protobuf:"varint,4,opt,name=state,proto3,enum=google.cloud.runtimeconfig.v1beta1.VariableState" json:"state,omitempty"`
}

func (x *Variable) Reset() {
	*x = Variable{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_runtimeconfig_v1beta1_resources_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Variable) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Variable) ProtoMessage() {}

func (x *Variable) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_runtimeconfig_v1beta1_resources_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Variable.ProtoReflect.Descriptor instead.
func (*Variable) Descriptor() ([]byte, []int) {
	return file_google_cloud_runtimeconfig_v1beta1_resources_proto_rawDescGZIP(), []int{1}
}

func (x *Variable) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (m *Variable) GetContents() isVariable_Contents {
	if m != nil {
		return m.Contents
	}
	return nil
}

func (x *Variable) GetValue() []byte {
	if x, ok := x.GetContents().(*Variable_Value); ok {
		return x.Value
	}
	return nil
}

func (x *Variable) GetText() string {
	if x, ok := x.GetContents().(*Variable_Text); ok {
		return x.Text
	}
	return ""
}

func (x *Variable) GetUpdateTime() *timestamp.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Variable) GetState() VariableState {
	if x != nil {
		return x.State
	}
	return VariableState_VARIABLE_STATE_UNSPECIFIED
}

type isVariable_Contents interface {
	isVariable_Contents()
}

type Variable_Value struct {
	// The binary value of the variable. The length of the value must be less
	// than 4096 bytes. Empty values are also accepted. The value must be
	// base64 encoded. Only one of `value` or `text` can be set.
	Value []byte `protobuf:"bytes,2,opt,name=value,proto3,oneof"`
}

type Variable_Text struct {
	// The string value of the variable. The length of the value must be less
	// than 4096 bytes. Empty values are also accepted. For example,
	// `text: "my text value"`. The string must be valid UTF-8.
	Text string `protobuf:"bytes,5,opt,name=text,proto3,oneof"`
}

func (*Variable_Value) isVariable_Contents() {}

func (*Variable_Text) isVariable_Contents() {}

// The condition that a Waiter resource is waiting for.
type EndCondition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The condition oneof holds the available condition types for this
	// EndCondition. Currently, the only available type is Cardinality.
	//
	// Types that are assignable to Condition:
	//	*EndCondition_Cardinality_
	Condition isEndCondition_Condition `protobuf_oneof:"condition"`
}

func (x *EndCondition) Reset() {
	*x = EndCondition{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_runtimeconfig_v1beta1_resources_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EndCondition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EndCondition) ProtoMessage() {}

func (x *EndCondition) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_runtimeconfig_v1beta1_resources_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EndCondition.ProtoReflect.Descriptor instead.
func (*EndCondition) Descriptor() ([]byte, []int) {
	return file_google_cloud_runtimeconfig_v1beta1_resources_proto_rawDescGZIP(), []int{2}
}

func (m *EndCondition) GetCondition() isEndCondition_Condition {
	if m != nil {
		return m.Condition
	}
	return nil
}

func (x *EndCondition) GetCardinality() *EndCondition_Cardinality {
	if x, ok := x.GetCondition().(*EndCondition_Cardinality_); ok {
		return x.Cardinality
	}
	return nil
}

type isEndCondition_Condition interface {
	isEndCondition_Condition()
}

type EndCondition_Cardinality_ struct {
	// The cardinality of the `EndCondition`.
	Cardinality *EndCondition_Cardinality `protobuf:"bytes,1,opt,name=cardinality,proto3,oneof"`
}

func (*EndCondition_Cardinality_) isEndCondition_Condition() {}

// A Waiter resource waits for some end condition within a RuntimeConfig
// resource to be met before it returns. For example, assume you have a
// distributed system where each node writes to a Variable resource indidicating
// the node's readiness as part of the startup process.
//
// You then configure a Waiter resource with the success condition set to wait
// until some number of nodes have checked in. Afterwards, your application
// runs some arbitrary code after the condition has been met and the waiter
// returns successfully.
//
// Once created, a Waiter resource is immutable.
//
// To learn more about using waiters, read the
// [Creating a
// Waiter](/deployment-manager/runtime-configurator/creating-a-waiter)
// documentation.
type Waiter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the Waiter resource, in the format:
	//
	//     projects/[PROJECT_ID]/configs/[CONFIG_NAME]/waiters/[WAITER_NAME]
	//
	// The `[PROJECT_ID]` must be a valid Google Cloud project ID,
	// the `[CONFIG_NAME]` must be a valid RuntimeConfig resource, the
	// `[WAITER_NAME]` must match RFC 1035 segment specification, and the length
	// of `[WAITER_NAME]` must be less than 64 bytes.
	//
	// After you create a Waiter resource, you cannot change the resource name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// [Required] Specifies the timeout of the waiter in seconds, beginning from
	// the instant that `waiters().create` method is called. If this time elapses
	// before the success or failure conditions are met, the waiter fails and sets
	// the `error` code to `DEADLINE_EXCEEDED`.
	Timeout *duration.Duration `protobuf:"bytes,2,opt,name=timeout,proto3" json:"timeout,omitempty"`
	// [Optional] The failure condition of this waiter. If this condition is met,
	// `done` will be set to `true` and the `error` code will be set to `ABORTED`.
	// The failure condition takes precedence over the success condition. If both
	// conditions are met, a failure will be indicated. This value is optional; if
	// no failure condition is set, the only failure scenario will be a timeout.
	Failure *EndCondition `protobuf:"bytes,3,opt,name=failure,proto3" json:"failure,omitempty"`
	// [Required] The success condition. If this condition is met, `done` will be
	// set to `true` and the `error` value will remain unset. The failure
	// condition takes precedence over the success condition. If both conditions
	// are met, a failure will be indicated.
	Success *EndCondition `protobuf:"bytes,4,opt,name=success,proto3" json:"success,omitempty"`
	// [Output Only] The instant at which this Waiter resource was created. Adding
	// the value of `timeout` to this instant yields the timeout deadline for the
	// waiter.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,5,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// [Output Only] If the value is `false`, it means the waiter is still waiting
	// for one of its conditions to be met.
	//
	// If true, the waiter has finished. If the waiter finished due to a timeout
	// or failure, `error` will be set.
	Done bool `protobuf:"varint,6,opt,name=done,proto3" json:"done,omitempty"`
	// [Output Only] If the waiter ended due to a failure or timeout, this value
	// will be set.
	Error *status.Status `protobuf:"bytes,7,opt,name=error,proto3" json:"error,omitempty"`
}

func (x *Waiter) Reset() {
	*x = Waiter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_runtimeconfig_v1beta1_resources_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Waiter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Waiter) ProtoMessage() {}

func (x *Waiter) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_runtimeconfig_v1beta1_resources_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Waiter.ProtoReflect.Descriptor instead.
func (*Waiter) Descriptor() ([]byte, []int) {
	return file_google_cloud_runtimeconfig_v1beta1_resources_proto_rawDescGZIP(), []int{3}
}

func (x *Waiter) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Waiter) GetTimeout() *duration.Duration {
	if x != nil {
		return x.Timeout
	}
	return nil
}

func (x *Waiter) GetFailure() *EndCondition {
	if x != nil {
		return x.Failure
	}
	return nil
}

func (x *Waiter) GetSuccess() *EndCondition {
	if x != nil {
		return x.Success
	}
	return nil
}

func (x *Waiter) GetCreateTime() *timestamp.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Waiter) GetDone() bool {
	if x != nil {
		return x.Done
	}
	return false
}

func (x *Waiter) GetError() *status.Status {
	if x != nil {
		return x.Error
	}
	return nil
}

// A Cardinality condition for the Waiter resource. A cardinality condition is
// met when the number of variables under a specified path prefix reaches a
// predefined number. For example, if you set a Cardinality condition where
// the `path` is set to `/foo` and the number of paths is set to 2, the
// following variables would meet the condition in a RuntimeConfig resource:
//
// + `/foo/variable1 = "value1"`
// + `/foo/variable2 = "value2"`
// + `/bar/variable3 = "value3"`
//
// It would not would not satisify the same condition with the `number` set to
// 3, however, because there is only 2 paths that start with `/foo`.
// Cardinality conditions are recursive; all subtrees under the specific
// path prefix are counted.
type EndCondition_Cardinality struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The root of the variable subtree to monitor. For example, `/foo`.
	Path string `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
	// The number variables under the `path` that must exist to meet this
	// condition. Defaults to 1 if not specified.
	Number int32 `protobuf:"varint,2,opt,name=number,proto3" json:"number,omitempty"`
}

func (x *EndCondition_Cardinality) Reset() {
	*x = EndCondition_Cardinality{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_runtimeconfig_v1beta1_resources_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EndCondition_Cardinality) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EndCondition_Cardinality) ProtoMessage() {}

func (x *EndCondition_Cardinality) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_runtimeconfig_v1beta1_resources_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EndCondition_Cardinality.ProtoReflect.Descriptor instead.
func (*EndCondition_Cardinality) Descriptor() ([]byte, []int) {
	return file_google_cloud_runtimeconfig_v1beta1_resources_proto_rawDescGZIP(), []int{2, 0}
}

func (x *EndCondition_Cardinality) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

func (x *EndCondition_Cardinality) GetNumber() int32 {
	if x != nil {
		return x.Number
	}
	return 0
}

var File_google_cloud_runtimeconfig_v1beta1_resources_proto protoreflect.FileDescriptor

var file_google_cloud_runtimeconfig_v1beta1_resources_proto_rawDesc = []byte{
	0x0a, 0x32, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x72,
	0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x22, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x72, 0x70, 0x63, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x22, 0x45, 0x0a, 0x0d, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xde, 0x01, 0x0a, 0x08, 0x56, 0x61, 0x72, 0x69,
	0x61, 0x62, 0x6c, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x16, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x48, 0x00, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x12, 0x14, 0x0a, 0x04, 0x74, 0x65, 0x78, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00,
	0x52, 0x04, 0x74, 0x65, 0x78, 0x74, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x47, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x42, 0x0a, 0x0a, 0x08,
	0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x22, 0xb8, 0x01, 0x0a, 0x0c, 0x45, 0x6e, 0x64,
	0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x60, 0x0a, 0x0b, 0x63, 0x61, 0x72,
	0x64, 0x69, 0x6e, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x75,
	0x6e, 0x74, 0x69, 0x6d, 0x65, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x45, 0x6e, 0x64, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x43, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x48, 0x00, 0x52, 0x0b,
	0x63, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x1a, 0x39, 0x0a, 0x0b, 0x43,
	0x61, 0x72, 0x64, 0x69, 0x6e, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x61,
	0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x12, 0x16,
	0x0a, 0x06, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x06,
	0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x42, 0x0b, 0x0a, 0x09, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0xe4, 0x02, 0x0a, 0x06, 0x57, 0x61, 0x69, 0x74, 0x65, 0x72, 0x12, 0x12,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x33, 0x0a, 0x07, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x07,
	0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x12, 0x4a, 0x0a, 0x07, 0x66, 0x61, 0x69, 0x6c, 0x75,
	0x72, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x6e,
	0x64, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x66, 0x61, 0x69, 0x6c,
	0x75, 0x72, 0x65, 0x12, 0x4a, 0x0a, 0x07, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x6e, 0x64, 0x43, 0x6f, 0x6e,
	0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x12,
	0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04,
	0x64, 0x6f, 0x6e, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x04, 0x64, 0x6f, 0x6e, 0x65,
	0x12, 0x28, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x2a, 0x49, 0x0a, 0x0d, 0x56, 0x61,
	0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x1e, 0x0a, 0x1a, 0x56,
	0x41, 0x52, 0x49, 0x41, 0x42, 0x4c, 0x45, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x55,
	0x50, 0x44, 0x41, 0x54, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x44, 0x45, 0x4c, 0x45,
	0x54, 0x45, 0x44, 0x10, 0x02, 0x42, 0xc5, 0x01, 0x0a, 0x26, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69,
	0x6d, 0x65, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x50, 0x01, 0x5a, 0x4f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e,
	0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f,
	0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x3b, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0xaa, 0x02, 0x22, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x56, 0x31, 0x42, 0x65, 0x74, 0x61, 0x31, 0xca, 0x02, 0x22, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5c, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x62, 0x06, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_runtimeconfig_v1beta1_resources_proto_rawDescOnce sync.Once
	file_google_cloud_runtimeconfig_v1beta1_resources_proto_rawDescData = file_google_cloud_runtimeconfig_v1beta1_resources_proto_rawDesc
)

func file_google_cloud_runtimeconfig_v1beta1_resources_proto_rawDescGZIP() []byte {
	file_google_cloud_runtimeconfig_v1beta1_resources_proto_rawDescOnce.Do(func() {
		file_google_cloud_runtimeconfig_v1beta1_resources_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_runtimeconfig_v1beta1_resources_proto_rawDescData)
	})
	return file_google_cloud_runtimeconfig_v1beta1_resources_proto_rawDescData
}

var file_google_cloud_runtimeconfig_v1beta1_resources_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_runtimeconfig_v1beta1_resources_proto_msgTypes = make([]protoimpl.MessageInfo, 5)
var file_google_cloud_runtimeconfig_v1beta1_resources_proto_goTypes = []interface{}{
	(VariableState)(0),               // 0: google.cloud.runtimeconfig.v1beta1.VariableState
	(*RuntimeConfig)(nil),            // 1: google.cloud.runtimeconfig.v1beta1.RuntimeConfig
	(*Variable)(nil),                 // 2: google.cloud.runtimeconfig.v1beta1.Variable
	(*EndCondition)(nil),             // 3: google.cloud.runtimeconfig.v1beta1.EndCondition
	(*Waiter)(nil),                   // 4: google.cloud.runtimeconfig.v1beta1.Waiter
	(*EndCondition_Cardinality)(nil), // 5: google.cloud.runtimeconfig.v1beta1.EndCondition.Cardinality
	(*timestamp.Timestamp)(nil),      // 6: google.protobuf.Timestamp
	(*duration.Duration)(nil),        // 7: google.protobuf.Duration
	(*status.Status)(nil),            // 8: google.rpc.Status
}
var file_google_cloud_runtimeconfig_v1beta1_resources_proto_depIdxs = []int32{
	6, // 0: google.cloud.runtimeconfig.v1beta1.Variable.update_time:type_name -> google.protobuf.Timestamp
	0, // 1: google.cloud.runtimeconfig.v1beta1.Variable.state:type_name -> google.cloud.runtimeconfig.v1beta1.VariableState
	5, // 2: google.cloud.runtimeconfig.v1beta1.EndCondition.cardinality:type_name -> google.cloud.runtimeconfig.v1beta1.EndCondition.Cardinality
	7, // 3: google.cloud.runtimeconfig.v1beta1.Waiter.timeout:type_name -> google.protobuf.Duration
	3, // 4: google.cloud.runtimeconfig.v1beta1.Waiter.failure:type_name -> google.cloud.runtimeconfig.v1beta1.EndCondition
	3, // 5: google.cloud.runtimeconfig.v1beta1.Waiter.success:type_name -> google.cloud.runtimeconfig.v1beta1.EndCondition
	6, // 6: google.cloud.runtimeconfig.v1beta1.Waiter.create_time:type_name -> google.protobuf.Timestamp
	8, // 7: google.cloud.runtimeconfig.v1beta1.Waiter.error:type_name -> google.rpc.Status
	8, // [8:8] is the sub-list for method output_type
	8, // [8:8] is the sub-list for method input_type
	8, // [8:8] is the sub-list for extension type_name
	8, // [8:8] is the sub-list for extension extendee
	0, // [0:8] is the sub-list for field type_name
}

func init() { file_google_cloud_runtimeconfig_v1beta1_resources_proto_init() }
func file_google_cloud_runtimeconfig_v1beta1_resources_proto_init() {
	if File_google_cloud_runtimeconfig_v1beta1_resources_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_runtimeconfig_v1beta1_resources_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RuntimeConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_runtimeconfig_v1beta1_resources_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Variable); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_runtimeconfig_v1beta1_resources_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EndCondition); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_runtimeconfig_v1beta1_resources_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Waiter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_runtimeconfig_v1beta1_resources_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EndCondition_Cardinality); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_runtimeconfig_v1beta1_resources_proto_msgTypes[1].OneofWrappers = []interface{}{
		(*Variable_Value)(nil),
		(*Variable_Text)(nil),
	}
	file_google_cloud_runtimeconfig_v1beta1_resources_proto_msgTypes[2].OneofWrappers = []interface{}{
		(*EndCondition_Cardinality_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_runtimeconfig_v1beta1_resources_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   5,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_runtimeconfig_v1beta1_resources_proto_goTypes,
		DependencyIndexes: file_google_cloud_runtimeconfig_v1beta1_resources_proto_depIdxs,
		EnumInfos:         file_google_cloud_runtimeconfig_v1beta1_resources_proto_enumTypes,
		MessageInfos:      file_google_cloud_runtimeconfig_v1beta1_resources_proto_msgTypes,
	}.Build()
	File_google_cloud_runtimeconfig_v1beta1_resources_proto = out.File
	file_google_cloud_runtimeconfig_v1beta1_resources_proto_rawDesc = nil
	file_google_cloud_runtimeconfig_v1beta1_resources_proto_goTypes = nil
	file_google_cloud_runtimeconfig_v1beta1_resources_proto_depIdxs = nil
}
