Release checklist:
 - [ ] Write release notes in NEWS. Get them reviewed and merged
     - [ ] If doing a branched release, also include a PR to merge the NEWS changes into master
 - [ ] Ensure your local copy is up to date with master and your working directory is clean
 - [ ] Ensure you can sign commits and any yubikeys/smartcards are plugged in
 - [ ] Run `./tag_release.sh <vX.Y.z> <git commit hash>`
 - [ ] Push that tag to Github
 - [ ] Run `./build_releases`
 - [ ] Sign the release artifacts by running
```
gpg --local-user 0xCDDE268EBB729EC7! --detach-sign --armor <path to artifact>
```
for each release artifact. Do not try to sign all of them at once by globbing. If you do, gpg will sign the combination of all the release artifacts instead of each one individually.

 - [ ] Create a draft release on Github and upload all the release artifacts and their signatures. Copy and paste the release notes from NEWS here as well.
 - [ ] Publish the release
 - [ ] Vendor the new Ignition version in [mantle](https://github.com/coreos/mantle) (backporting to the `cl` branch if a new 0.x.y release is being cut)

For 0.x.y releases:
 - [ ] [Sync the docs](https://jenkins-container-linux.apps.ci.centos.org/job/os/job/sync-docs/build) using `ignition` for `PROJECT` and the version `X.Y.Z` (not `vX.Y.Z`) for `RELEASE`.
 - [ ] Review then merge the coreos-pages PR generated by the docs sync job.
 - [ ] Build and deploy coreos.com
 - [ ] Bump the Ignition ebuild in [coreos-overlay](https://github.com/coreos/coreos-overlay)

For 2.x.y+ releases:
 - [ ] Create a PR to bump the Ignition spec file in [Fedora](https://src.fedoraproject.org/rpms/ignition).
 - [ ] Once that PR merges to master, merge master into the other relevant branches (e.g. f30) then push those.
 - [ ] On each of those branches (including master) run `fedpkg build`
 - [ ] Once the builds have finished, submit them to [bodhi](https://bodhi.fedoraproject.org/updates/new), filling in:
   - `ignition` for `Packages`
   - Selecting the build(s) that just completed, except for the rawhide one (which gets submitted automatically)
   - Writing brief release notes like "New upstream release. See release notes at `link to NEWS on GH tag`"
   - Leave `Update name` blank
   - `Type`, `Severity` and `Suggestion` can be left as `unspecified` unless it is a security release. In that case select `security` which the appropriate severity.
   - `Stable karma` and `Unstable` karma can be set to `2` and `-1`, respectively.
