// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.22.0
// 	protoc        v3.12.3
// source: google/ads/googleads/v3/common/offline_user_data.proto

package common

import (
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	wrappers "github.com/golang/protobuf/ptypes/wrappers"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Address identifier of offline data.
type OfflineUserAddressInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// First name of the user, which is hashed as SHA-256 after normalized
	// (Lowercase all characters; Remove any extra spaces before, after, and in
	// between).
	HashedFirstName *wrappers.StringValue `protobuf:"bytes,1,opt,name=hashed_first_name,json=hashedFirstName,proto3" json:"hashed_first_name,omitempty"`
	// Last name of the user, which is hashed as SHA-256 after normalized (lower
	// case only and no punctuation).
	HashedLastName *wrappers.StringValue `protobuf:"bytes,2,opt,name=hashed_last_name,json=hashedLastName,proto3" json:"hashed_last_name,omitempty"`
	// City of the address. Only accepted for Store Sales Direct data.
	City *wrappers.StringValue `protobuf:"bytes,3,opt,name=city,proto3" json:"city,omitempty"`
	// State code of the address. Only accepted for Store Sales Direct data.
	State *wrappers.StringValue `protobuf:"bytes,4,opt,name=state,proto3" json:"state,omitempty"`
	// 2-letter country code in ISO-3166-1 alpha-2 of the user's address.
	CountryCode *wrappers.StringValue `protobuf:"bytes,5,opt,name=country_code,json=countryCode,proto3" json:"country_code,omitempty"`
	// Postal code of the user's address.
	PostalCode *wrappers.StringValue `protobuf:"bytes,6,opt,name=postal_code,json=postalCode,proto3" json:"postal_code,omitempty"`
}

func (x *OfflineUserAddressInfo) Reset() {
	*x = OfflineUserAddressInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v3_common_offline_user_data_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OfflineUserAddressInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OfflineUserAddressInfo) ProtoMessage() {}

func (x *OfflineUserAddressInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v3_common_offline_user_data_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OfflineUserAddressInfo.ProtoReflect.Descriptor instead.
func (*OfflineUserAddressInfo) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v3_common_offline_user_data_proto_rawDescGZIP(), []int{0}
}

func (x *OfflineUserAddressInfo) GetHashedFirstName() *wrappers.StringValue {
	if x != nil {
		return x.HashedFirstName
	}
	return nil
}

func (x *OfflineUserAddressInfo) GetHashedLastName() *wrappers.StringValue {
	if x != nil {
		return x.HashedLastName
	}
	return nil
}

func (x *OfflineUserAddressInfo) GetCity() *wrappers.StringValue {
	if x != nil {
		return x.City
	}
	return nil
}

func (x *OfflineUserAddressInfo) GetState() *wrappers.StringValue {
	if x != nil {
		return x.State
	}
	return nil
}

func (x *OfflineUserAddressInfo) GetCountryCode() *wrappers.StringValue {
	if x != nil {
		return x.CountryCode
	}
	return nil
}

func (x *OfflineUserAddressInfo) GetPostalCode() *wrappers.StringValue {
	if x != nil {
		return x.PostalCode
	}
	return nil
}

// Hashed user identifying information.
type UserIdentifier struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Exactly one must be specified.
	//
	// Types that are assignable to Identifier:
	//	*UserIdentifier_HashedEmail
	//	*UserIdentifier_HashedPhoneNumber
	//	*UserIdentifier_MobileId
	//	*UserIdentifier_ThirdPartyUserId
	//	*UserIdentifier_AddressInfo
	Identifier isUserIdentifier_Identifier `protobuf_oneof:"identifier"`
}

func (x *UserIdentifier) Reset() {
	*x = UserIdentifier{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v3_common_offline_user_data_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UserIdentifier) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserIdentifier) ProtoMessage() {}

func (x *UserIdentifier) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v3_common_offline_user_data_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserIdentifier.ProtoReflect.Descriptor instead.
func (*UserIdentifier) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v3_common_offline_user_data_proto_rawDescGZIP(), []int{1}
}

func (m *UserIdentifier) GetIdentifier() isUserIdentifier_Identifier {
	if m != nil {
		return m.Identifier
	}
	return nil
}

func (x *UserIdentifier) GetHashedEmail() *wrappers.StringValue {
	if x, ok := x.GetIdentifier().(*UserIdentifier_HashedEmail); ok {
		return x.HashedEmail
	}
	return nil
}

func (x *UserIdentifier) GetHashedPhoneNumber() *wrappers.StringValue {
	if x, ok := x.GetIdentifier().(*UserIdentifier_HashedPhoneNumber); ok {
		return x.HashedPhoneNumber
	}
	return nil
}

func (x *UserIdentifier) GetMobileId() *wrappers.StringValue {
	if x, ok := x.GetIdentifier().(*UserIdentifier_MobileId); ok {
		return x.MobileId
	}
	return nil
}

func (x *UserIdentifier) GetThirdPartyUserId() *wrappers.StringValue {
	if x, ok := x.GetIdentifier().(*UserIdentifier_ThirdPartyUserId); ok {
		return x.ThirdPartyUserId
	}
	return nil
}

func (x *UserIdentifier) GetAddressInfo() *OfflineUserAddressInfo {
	if x, ok := x.GetIdentifier().(*UserIdentifier_AddressInfo); ok {
		return x.AddressInfo
	}
	return nil
}

type isUserIdentifier_Identifier interface {
	isUserIdentifier_Identifier()
}

type UserIdentifier_HashedEmail struct {
	// Hashed email address using SHA-256 hash function after normalization.
	HashedEmail *wrappers.StringValue `protobuf:"bytes,1,opt,name=hashed_email,json=hashedEmail,proto3,oneof"`
}

type UserIdentifier_HashedPhoneNumber struct {
	// Hashed phone number using SHA-256 hash function after normalization
	// (E164 standard).
	HashedPhoneNumber *wrappers.StringValue `protobuf:"bytes,2,opt,name=hashed_phone_number,json=hashedPhoneNumber,proto3,oneof"`
}

type UserIdentifier_MobileId struct {
	// Mobile device ID (advertising ID/IDFA).
	MobileId *wrappers.StringValue `protobuf:"bytes,3,opt,name=mobile_id,json=mobileId,proto3,oneof"`
}

type UserIdentifier_ThirdPartyUserId struct {
	// Advertiser-assigned user ID for Customer Match upload, or
	// third-party-assigned user ID for SSD.
	ThirdPartyUserId *wrappers.StringValue `protobuf:"bytes,4,opt,name=third_party_user_id,json=thirdPartyUserId,proto3,oneof"`
}

type UserIdentifier_AddressInfo struct {
	// Address information.
	AddressInfo *OfflineUserAddressInfo `protobuf:"bytes,5,opt,name=address_info,json=addressInfo,proto3,oneof"`
}

func (*UserIdentifier_HashedEmail) isUserIdentifier_Identifier() {}

func (*UserIdentifier_HashedPhoneNumber) isUserIdentifier_Identifier() {}

func (*UserIdentifier_MobileId) isUserIdentifier_Identifier() {}

func (*UserIdentifier_ThirdPartyUserId) isUserIdentifier_Identifier() {}

func (*UserIdentifier_AddressInfo) isUserIdentifier_Identifier() {}

// Attribute of the store sales transaction.
type TransactionAttribute struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Timestamp when transaction occurred. Required.
	// The format is "YYYY-MM-DD HH:MM:SS".
	// Examples: "2018-03-05 09:15:00" or "2018-02-01 14:34:30"
	TransactionDateTime *wrappers.StringValue `protobuf:"bytes,1,opt,name=transaction_date_time,json=transactionDateTime,proto3" json:"transaction_date_time,omitempty"`
	// Transaction amount in micros. Required.
	TransactionAmountMicros *wrappers.DoubleValue `protobuf:"bytes,2,opt,name=transaction_amount_micros,json=transactionAmountMicros,proto3" json:"transaction_amount_micros,omitempty"`
	// Transaction currency code. ISO 4217 three-letter code is used. Required.
	CurrencyCode *wrappers.StringValue `protobuf:"bytes,3,opt,name=currency_code,json=currencyCode,proto3" json:"currency_code,omitempty"`
	// The resource name of conversion action to report conversions to.
	// Required.
	ConversionAction *wrappers.StringValue `protobuf:"bytes,4,opt,name=conversion_action,json=conversionAction,proto3" json:"conversion_action,omitempty"`
	// Transaction order id.
	// Accessible to whitelisted customers only.
	OrderId *wrappers.StringValue `protobuf:"bytes,5,opt,name=order_id,json=orderId,proto3" json:"order_id,omitempty"`
	// Store attributes of the transaction.
	// Accessible to whitelisted customers only.
	StoreAttribute *StoreAttribute `protobuf:"bytes,6,opt,name=store_attribute,json=storeAttribute,proto3" json:"store_attribute,omitempty"`
	// Value of the custom variable for each transaction.
	// Accessible to whitelisted customers only.
	CustomValue *wrappers.StringValue `protobuf:"bytes,7,opt,name=custom_value,json=customValue,proto3" json:"custom_value,omitempty"`
}

func (x *TransactionAttribute) Reset() {
	*x = TransactionAttribute{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v3_common_offline_user_data_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TransactionAttribute) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransactionAttribute) ProtoMessage() {}

func (x *TransactionAttribute) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v3_common_offline_user_data_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransactionAttribute.ProtoReflect.Descriptor instead.
func (*TransactionAttribute) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v3_common_offline_user_data_proto_rawDescGZIP(), []int{2}
}

func (x *TransactionAttribute) GetTransactionDateTime() *wrappers.StringValue {
	if x != nil {
		return x.TransactionDateTime
	}
	return nil
}

func (x *TransactionAttribute) GetTransactionAmountMicros() *wrappers.DoubleValue {
	if x != nil {
		return x.TransactionAmountMicros
	}
	return nil
}

func (x *TransactionAttribute) GetCurrencyCode() *wrappers.StringValue {
	if x != nil {
		return x.CurrencyCode
	}
	return nil
}

func (x *TransactionAttribute) GetConversionAction() *wrappers.StringValue {
	if x != nil {
		return x.ConversionAction
	}
	return nil
}

func (x *TransactionAttribute) GetOrderId() *wrappers.StringValue {
	if x != nil {
		return x.OrderId
	}
	return nil
}

func (x *TransactionAttribute) GetStoreAttribute() *StoreAttribute {
	if x != nil {
		return x.StoreAttribute
	}
	return nil
}

func (x *TransactionAttribute) GetCustomValue() *wrappers.StringValue {
	if x != nil {
		return x.CustomValue
	}
	return nil
}

// Store attributes of the transaction.
type StoreAttribute struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Store code from
	// https://support.google.com/business/answer/3370250#storecode
	StoreCode *wrappers.StringValue `protobuf:"bytes,1,opt,name=store_code,json=storeCode,proto3" json:"store_code,omitempty"`
}

func (x *StoreAttribute) Reset() {
	*x = StoreAttribute{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v3_common_offline_user_data_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StoreAttribute) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StoreAttribute) ProtoMessage() {}

func (x *StoreAttribute) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v3_common_offline_user_data_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StoreAttribute.ProtoReflect.Descriptor instead.
func (*StoreAttribute) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v3_common_offline_user_data_proto_rawDescGZIP(), []int{3}
}

func (x *StoreAttribute) GetStoreCode() *wrappers.StringValue {
	if x != nil {
		return x.StoreCode
	}
	return nil
}

// User data holding user identifiers and attributes.
type UserData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// User identification info. Required.
	UserIdentifiers []*UserIdentifier `protobuf:"bytes,1,rep,name=user_identifiers,json=userIdentifiers,proto3" json:"user_identifiers,omitempty"`
	// Additional transactions/attributes associated with the user.
	// Required when updating store sales data.
	TransactionAttribute *TransactionAttribute `protobuf:"bytes,2,opt,name=transaction_attribute,json=transactionAttribute,proto3" json:"transaction_attribute,omitempty"`
}

func (x *UserData) Reset() {
	*x = UserData{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v3_common_offline_user_data_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UserData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserData) ProtoMessage() {}

func (x *UserData) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v3_common_offline_user_data_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserData.ProtoReflect.Descriptor instead.
func (*UserData) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v3_common_offline_user_data_proto_rawDescGZIP(), []int{4}
}

func (x *UserData) GetUserIdentifiers() []*UserIdentifier {
	if x != nil {
		return x.UserIdentifiers
	}
	return nil
}

func (x *UserData) GetTransactionAttribute() *TransactionAttribute {
	if x != nil {
		return x.TransactionAttribute
	}
	return nil
}

// Metadata for customer match user list.
type CustomerMatchUserListMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of remarketing list to update data.
	// Required for job of CUSTOMER_MATCH_USER_LIST type.
	UserList *wrappers.StringValue `protobuf:"bytes,1,opt,name=user_list,json=userList,proto3" json:"user_list,omitempty"`
}

func (x *CustomerMatchUserListMetadata) Reset() {
	*x = CustomerMatchUserListMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v3_common_offline_user_data_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CustomerMatchUserListMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CustomerMatchUserListMetadata) ProtoMessage() {}

func (x *CustomerMatchUserListMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v3_common_offline_user_data_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CustomerMatchUserListMetadata.ProtoReflect.Descriptor instead.
func (*CustomerMatchUserListMetadata) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v3_common_offline_user_data_proto_rawDescGZIP(), []int{5}
}

func (x *CustomerMatchUserListMetadata) GetUserList() *wrappers.StringValue {
	if x != nil {
		return x.UserList
	}
	return nil
}

// Metadata for Store Sales Direct.
type StoreSalesMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This is the fraction of all transactions that are identifiable (i.e.,
	// associated with any form of customer information).
	// Required.
	// The fraction needs to be between 0 and 1 (excluding 0).
	LoyaltyFraction *wrappers.DoubleValue `protobuf:"bytes,1,opt,name=loyalty_fraction,json=loyaltyFraction,proto3" json:"loyalty_fraction,omitempty"`
	// This is the ratio of sales being uploaded compared to the overall sales
	// that can be associated with a customer. Required.
	// The fraction needs to be between 0 and 1 (excluding 0). For example, if you
	// upload half the sales that you are able to associate with a customer, this
	// would be 0.5.
	TransactionUploadFraction *wrappers.DoubleValue `protobuf:"bytes,2,opt,name=transaction_upload_fraction,json=transactionUploadFraction,proto3" json:"transaction_upload_fraction,omitempty"`
	// Name of the store sales custom variable key. A predefined key that
	// can be applied to the transaction and then later used for custom
	// segementation in reporting.
	// Accessible to whitelisted customers only.
	CustomKey *wrappers.StringValue `protobuf:"bytes,4,opt,name=custom_key,json=customKey,proto3" json:"custom_key,omitempty"`
	// Metadata for a third party Store Sales upload.
	ThirdPartyMetadata *StoreSalesThirdPartyMetadata `protobuf:"bytes,3,opt,name=third_party_metadata,json=thirdPartyMetadata,proto3" json:"third_party_metadata,omitempty"`
}

func (x *StoreSalesMetadata) Reset() {
	*x = StoreSalesMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v3_common_offline_user_data_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StoreSalesMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StoreSalesMetadata) ProtoMessage() {}

func (x *StoreSalesMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v3_common_offline_user_data_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StoreSalesMetadata.ProtoReflect.Descriptor instead.
func (*StoreSalesMetadata) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v3_common_offline_user_data_proto_rawDescGZIP(), []int{6}
}

func (x *StoreSalesMetadata) GetLoyaltyFraction() *wrappers.DoubleValue {
	if x != nil {
		return x.LoyaltyFraction
	}
	return nil
}

func (x *StoreSalesMetadata) GetTransactionUploadFraction() *wrappers.DoubleValue {
	if x != nil {
		return x.TransactionUploadFraction
	}
	return nil
}

func (x *StoreSalesMetadata) GetCustomKey() *wrappers.StringValue {
	if x != nil {
		return x.CustomKey
	}
	return nil
}

func (x *StoreSalesMetadata) GetThirdPartyMetadata() *StoreSalesThirdPartyMetadata {
	if x != nil {
		return x.ThirdPartyMetadata
	}
	return nil
}

// Metadata for a third party Store Sales.
// This is a whitelisted only product. Please contact your Google business
// development representative for details on the upload configuration.
type StoreSalesThirdPartyMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Time the advertiser uploaded the data to the partner. Required.
	// The format is "YYYY-MM-DD HH:MM:SS".
	// Examples: "2018-03-05 09:15:00" or "2018-02-01 14:34:30"
	AdvertiserUploadDateTime *wrappers.StringValue `protobuf:"bytes,1,opt,name=advertiser_upload_date_time,json=advertiserUploadDateTime,proto3" json:"advertiser_upload_date_time,omitempty"`
	// The fraction of transactions that are valid. Invalid transactions may
	// include invalid formats or values.
	// Required.
	// The fraction needs to be between 0 and 1 (excluding 0).
	ValidTransactionFraction *wrappers.DoubleValue `protobuf:"bytes,2,opt,name=valid_transaction_fraction,json=validTransactionFraction,proto3" json:"valid_transaction_fraction,omitempty"`
	// The fraction of valid transactions that are matched to a third party
	// assigned user ID on the partner side.
	// Required.
	// The fraction needs to be between 0 and 1 (excluding 0).
	PartnerMatchFraction *wrappers.DoubleValue `protobuf:"bytes,3,opt,name=partner_match_fraction,json=partnerMatchFraction,proto3" json:"partner_match_fraction,omitempty"`
	// The fraction of valid transactions that are uploaded by the partner to
	// Google.
	// Required.
	// The fraction needs to be between 0 and 1 (excluding 0).
	PartnerUploadFraction *wrappers.DoubleValue `protobuf:"bytes,4,opt,name=partner_upload_fraction,json=partnerUploadFraction,proto3" json:"partner_upload_fraction,omitempty"`
	// Version of partner IDs to be used for uploads. Required.
	BridgeMapVersionId *wrappers.StringValue `protobuf:"bytes,5,opt,name=bridge_map_version_id,json=bridgeMapVersionId,proto3" json:"bridge_map_version_id,omitempty"`
	// ID of the third party partner updating the transaction feed.
	PartnerId *wrappers.Int64Value `protobuf:"bytes,6,opt,name=partner_id,json=partnerId,proto3" json:"partner_id,omitempty"`
}

func (x *StoreSalesThirdPartyMetadata) Reset() {
	*x = StoreSalesThirdPartyMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v3_common_offline_user_data_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StoreSalesThirdPartyMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StoreSalesThirdPartyMetadata) ProtoMessage() {}

func (x *StoreSalesThirdPartyMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v3_common_offline_user_data_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StoreSalesThirdPartyMetadata.ProtoReflect.Descriptor instead.
func (*StoreSalesThirdPartyMetadata) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v3_common_offline_user_data_proto_rawDescGZIP(), []int{7}
}

func (x *StoreSalesThirdPartyMetadata) GetAdvertiserUploadDateTime() *wrappers.StringValue {
	if x != nil {
		return x.AdvertiserUploadDateTime
	}
	return nil
}

func (x *StoreSalesThirdPartyMetadata) GetValidTransactionFraction() *wrappers.DoubleValue {
	if x != nil {
		return x.ValidTransactionFraction
	}
	return nil
}

func (x *StoreSalesThirdPartyMetadata) GetPartnerMatchFraction() *wrappers.DoubleValue {
	if x != nil {
		return x.PartnerMatchFraction
	}
	return nil
}

func (x *StoreSalesThirdPartyMetadata) GetPartnerUploadFraction() *wrappers.DoubleValue {
	if x != nil {
		return x.PartnerUploadFraction
	}
	return nil
}

func (x *StoreSalesThirdPartyMetadata) GetBridgeMapVersionId() *wrappers.StringValue {
	if x != nil {
		return x.BridgeMapVersionId
	}
	return nil
}

func (x *StoreSalesThirdPartyMetadata) GetPartnerId() *wrappers.Int64Value {
	if x != nil {
		return x.PartnerId
	}
	return nil
}

var File_google_ads_googleads_v3_common_offline_user_data_proto protoreflect.FileDescriptor

var file_google_ads_googleads_v3_common_offline_user_data_proto_rawDesc = []byte{
	0x0a, 0x36, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x33, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e,
	0x2f, 0x6f, 0x66, 0x66, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x64, 0x61,
	0x74, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76,
	0x33, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65,
	0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x90, 0x03, 0x0a, 0x16, 0x4f, 0x66, 0x66, 0x6c, 0x69,
	0x6e, 0x65, 0x55, 0x73, 0x65, 0x72, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x49, 0x6e, 0x66,
	0x6f, 0x12, 0x48, 0x0a, 0x11, 0x68, 0x61, 0x73, 0x68, 0x65, 0x64, 0x5f, 0x66, 0x69, 0x72, 0x73,
	0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53,
	0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0f, 0x68, 0x61, 0x73, 0x68,
	0x65, 0x64, 0x46, 0x69, 0x72, 0x73, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x46, 0x0a, 0x10, 0x68,
	0x61, 0x73, 0x68, 0x65, 0x64, 0x5f, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x52, 0x0e, 0x68, 0x61, 0x73, 0x68, 0x65, 0x64, 0x4c, 0x61, 0x73, 0x74, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x30, 0x0a, 0x04, 0x63, 0x69, 0x74, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x04, 0x63, 0x69, 0x74, 0x79, 0x12, 0x32, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x3f, 0x0a, 0x0c, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x72, 0x79, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0b, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x72, 0x79, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x3d, 0x0a, 0x0b, 0x70, 0x6f,
	0x73, 0x74, 0x61, 0x6c, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0a, 0x70,
	0x6f, 0x73, 0x74, 0x61, 0x6c, 0x43, 0x6f, 0x64, 0x65, 0x22, 0x9a, 0x03, 0x0a, 0x0e, 0x55, 0x73,
	0x65, 0x72, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x12, 0x41, 0x0a, 0x0c,
	0x68, 0x61, 0x73, 0x68, 0x65, 0x64, 0x5f, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x48, 0x00, 0x52, 0x0b, 0x68, 0x61, 0x73, 0x68, 0x65, 0x64, 0x45, 0x6d, 0x61, 0x69, 0x6c, 0x12,
	0x4e, 0x0a, 0x13, 0x68, 0x61, 0x73, 0x68, 0x65, 0x64, 0x5f, 0x70, 0x68, 0x6f, 0x6e, 0x65, 0x5f,
	0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53,
	0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x48, 0x00, 0x52, 0x11, 0x68, 0x61,
	0x73, 0x68, 0x65, 0x64, 0x50, 0x68, 0x6f, 0x6e, 0x65, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x12,
	0x3b, 0x0a, 0x09, 0x6d, 0x6f, 0x62, 0x69, 0x6c, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x48, 0x00, 0x52, 0x08, 0x6d, 0x6f, 0x62, 0x69, 0x6c, 0x65, 0x49, 0x64, 0x12, 0x4d, 0x0a, 0x13,
	0x74, 0x68, 0x69, 0x72, 0x64, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x79, 0x5f, 0x75, 0x73, 0x65, 0x72,
	0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69,
	0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x48, 0x00, 0x52, 0x10, 0x74, 0x68, 0x69, 0x72, 0x64,
	0x50, 0x61, 0x72, 0x74, 0x79, 0x55, 0x73, 0x65, 0x72, 0x49, 0x64, 0x12, 0x5b, 0x0a, 0x0c, 0x61,
	0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e, 0x63, 0x6f, 0x6d, 0x6d,
	0x6f, 0x6e, 0x2e, 0x4f, 0x66, 0x66, 0x6c, 0x69, 0x6e, 0x65, 0x55, 0x73, 0x65, 0x72, 0x41, 0x64,
	0x64, 0x72, 0x65, 0x73, 0x73, 0x49, 0x6e, 0x66, 0x6f, 0x48, 0x00, 0x52, 0x0b, 0x61, 0x64, 0x64,
	0x72, 0x65, 0x73, 0x73, 0x49, 0x6e, 0x66, 0x6f, 0x42, 0x0c, 0x0a, 0x0a, 0x69, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x22, 0xa3, 0x04, 0x0a, 0x14, 0x54, 0x72, 0x61, 0x6e, 0x73,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x12,
	0x50, 0x0a, 0x15, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x13, 0x74, 0x72,
	0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x58, 0x0a, 0x19, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x61, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x6d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x52, 0x17, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x41,
	0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x4d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x12, 0x41, 0x0a, 0x0d, 0x63,
	0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x0c, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x79, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x49,
	0x0a, 0x11, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69,
	0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x10, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x37, 0x0a, 0x08, 0x6f, 0x72, 0x64,
	0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74,
	0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72,
	0x49, 0x64, 0x12, 0x57, 0x0a, 0x0f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x61, 0x74, 0x74, 0x72,
	0x69, 0x62, 0x75, 0x74, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x53, 0x74, 0x6f,
	0x72, 0x65, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x52, 0x0e, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x12, 0x3f, 0x0a, 0x0c, 0x63,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x0b, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x4d, 0x0a, 0x0e,
	0x53, 0x74, 0x6f, 0x72, 0x65, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x12, 0x3b,
	0x0a, 0x0a, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x09, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x22, 0xd0, 0x01, 0x0a, 0x08,
	0x55, 0x73, 0x65, 0x72, 0x44, 0x61, 0x74, 0x61, 0x12, 0x59, 0x0a, 0x10, 0x75, 0x73, 0x65, 0x72,
	0x5f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e, 0x63, 0x6f, 0x6d,
	0x6d, 0x6f, 0x6e, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69,
	0x65, 0x72, 0x52, 0x0f, 0x75, 0x73, 0x65, 0x72, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69,
	0x65, 0x72, 0x73, 0x12, 0x69, 0x0a, 0x15, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e, 0x63, 0x6f, 0x6d,
	0x6d, 0x6f, 0x6e, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x41,
	0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x52, 0x14, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x22, 0x5a,
	0x0a, 0x1d, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x55,
	0x73, 0x65, 0x72, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12,
	0x39, 0x0a, 0x09, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x6c, 0x69, 0x73, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x08, 0x75, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x73, 0x74, 0x22, 0xe8, 0x02, 0x0a, 0x12, 0x53,
	0x74, 0x6f, 0x72, 0x65, 0x53, 0x61, 0x6c, 0x65, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x12, 0x47, 0x0a, 0x10, 0x6c, 0x6f, 0x79, 0x61, 0x6c, 0x74, 0x79, 0x5f, 0x66, 0x72, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f,
	0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0f, 0x6c, 0x6f, 0x79, 0x61, 0x6c,
	0x74, 0x79, 0x46, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5c, 0x0a, 0x1b, 0x74, 0x72,
	0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x75, 0x70, 0x6c, 0x6f, 0x61, 0x64,
	0x5f, 0x66, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x19, 0x74,
	0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64,
	0x46, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3b, 0x0a, 0x0a, 0x63, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53,
	0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x09, 0x63, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x4b, 0x65, 0x79, 0x12, 0x6e, 0x0a, 0x14, 0x74, 0x68, 0x69, 0x72, 0x64, 0x5f, 0x70,
	0x61, 0x72, 0x74, 0x79, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e, 0x63, 0x6f,
	0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x53, 0x61, 0x6c, 0x65, 0x73, 0x54,
	0x68, 0x69, 0x72, 0x64, 0x50, 0x61, 0x72, 0x74, 0x79, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x52, 0x12, 0x74, 0x68, 0x69, 0x72, 0x64, 0x50, 0x61, 0x72, 0x74, 0x79, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0x8e, 0x04, 0x0a, 0x1c, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x53,
	0x61, 0x6c, 0x65, 0x73, 0x54, 0x68, 0x69, 0x72, 0x64, 0x50, 0x61, 0x72, 0x74, 0x79, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x5b, 0x0a, 0x1b, 0x61, 0x64, 0x76, 0x65, 0x72, 0x74,
	0x69, 0x73, 0x65, 0x72, 0x5f, 0x75, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74,
	0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x18, 0x61, 0x64, 0x76, 0x65, 0x72,
	0x74, 0x69, 0x73, 0x65, 0x72, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x44, 0x61, 0x74, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x5a, 0x0a, 0x1a, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x5f, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x66, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x18, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x54, 0x72, 0x61, 0x6e,
	0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x52, 0x0a, 0x16, 0x70, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68,
	0x5f, 0x66, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x14, 0x70,
	0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x46, 0x72, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x54, 0x0a, 0x17, 0x70, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x5f, 0x75,
	0x70, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x66, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x52, 0x15, 0x70, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x55, 0x70, 0x6c, 0x6f, 0x61,
	0x64, 0x46, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4f, 0x0a, 0x15, 0x62, 0x72, 0x69,
	0x64, 0x67, 0x65, 0x5f, 0x6d, 0x61, 0x70, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f,
	0x69, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e,
	0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x12, 0x62, 0x72, 0x69, 0x64, 0x67, 0x65, 0x4d, 0x61,
	0x70, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x3a, 0x0a, 0x0a, 0x70, 0x61,
	0x72, 0x74, 0x6e, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x09, 0x70, 0x61, 0x72,
	0x74, 0x6e, 0x65, 0x72, 0x49, 0x64, 0x42, 0xef, 0x01, 0x0a, 0x22, 0x63, 0x6f, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x42, 0x14, 0x4f,
	0x66, 0x66, 0x6c, 0x69, 0x6e, 0x65, 0x55, 0x73, 0x65, 0x72, 0x44, 0x61, 0x74, 0x61, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x44, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f,
	0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x61, 0x64, 0x73,
	0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x33, 0x2f, 0x63, 0x6f,
	0x6d, 0x6d, 0x6f, 0x6e, 0x3b, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0xa2, 0x02, 0x03, 0x47, 0x41,
	0x41, 0xaa, 0x02, 0x1e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x41, 0x64, 0x73, 0x2e, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x2e, 0x56, 0x33, 0x2e, 0x43, 0x6f, 0x6d, 0x6d,
	0x6f, 0x6e, 0xca, 0x02, 0x1e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x41, 0x64, 0x73, 0x5c,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x5c, 0x56, 0x33, 0x5c, 0x43, 0x6f, 0x6d,
	0x6d, 0x6f, 0x6e, 0xea, 0x02, 0x22, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x41, 0x64,
	0x73, 0x3a, 0x3a, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x3a, 0x3a, 0x56, 0x33,
	0x3a, 0x3a, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_ads_googleads_v3_common_offline_user_data_proto_rawDescOnce sync.Once
	file_google_ads_googleads_v3_common_offline_user_data_proto_rawDescData = file_google_ads_googleads_v3_common_offline_user_data_proto_rawDesc
)

func file_google_ads_googleads_v3_common_offline_user_data_proto_rawDescGZIP() []byte {
	file_google_ads_googleads_v3_common_offline_user_data_proto_rawDescOnce.Do(func() {
		file_google_ads_googleads_v3_common_offline_user_data_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_ads_googleads_v3_common_offline_user_data_proto_rawDescData)
	})
	return file_google_ads_googleads_v3_common_offline_user_data_proto_rawDescData
}

var file_google_ads_googleads_v3_common_offline_user_data_proto_msgTypes = make([]protoimpl.MessageInfo, 8)
var file_google_ads_googleads_v3_common_offline_user_data_proto_goTypes = []interface{}{
	(*OfflineUserAddressInfo)(nil),        // 0: google.ads.googleads.v3.common.OfflineUserAddressInfo
	(*UserIdentifier)(nil),                // 1: google.ads.googleads.v3.common.UserIdentifier
	(*TransactionAttribute)(nil),          // 2: google.ads.googleads.v3.common.TransactionAttribute
	(*StoreAttribute)(nil),                // 3: google.ads.googleads.v3.common.StoreAttribute
	(*UserData)(nil),                      // 4: google.ads.googleads.v3.common.UserData
	(*CustomerMatchUserListMetadata)(nil), // 5: google.ads.googleads.v3.common.CustomerMatchUserListMetadata
	(*StoreSalesMetadata)(nil),            // 6: google.ads.googleads.v3.common.StoreSalesMetadata
	(*StoreSalesThirdPartyMetadata)(nil),  // 7: google.ads.googleads.v3.common.StoreSalesThirdPartyMetadata
	(*wrappers.StringValue)(nil),          // 8: google.protobuf.StringValue
	(*wrappers.DoubleValue)(nil),          // 9: google.protobuf.DoubleValue
	(*wrappers.Int64Value)(nil),           // 10: google.protobuf.Int64Value
}
var file_google_ads_googleads_v3_common_offline_user_data_proto_depIdxs = []int32{
	8,  // 0: google.ads.googleads.v3.common.OfflineUserAddressInfo.hashed_first_name:type_name -> google.protobuf.StringValue
	8,  // 1: google.ads.googleads.v3.common.OfflineUserAddressInfo.hashed_last_name:type_name -> google.protobuf.StringValue
	8,  // 2: google.ads.googleads.v3.common.OfflineUserAddressInfo.city:type_name -> google.protobuf.StringValue
	8,  // 3: google.ads.googleads.v3.common.OfflineUserAddressInfo.state:type_name -> google.protobuf.StringValue
	8,  // 4: google.ads.googleads.v3.common.OfflineUserAddressInfo.country_code:type_name -> google.protobuf.StringValue
	8,  // 5: google.ads.googleads.v3.common.OfflineUserAddressInfo.postal_code:type_name -> google.protobuf.StringValue
	8,  // 6: google.ads.googleads.v3.common.UserIdentifier.hashed_email:type_name -> google.protobuf.StringValue
	8,  // 7: google.ads.googleads.v3.common.UserIdentifier.hashed_phone_number:type_name -> google.protobuf.StringValue
	8,  // 8: google.ads.googleads.v3.common.UserIdentifier.mobile_id:type_name -> google.protobuf.StringValue
	8,  // 9: google.ads.googleads.v3.common.UserIdentifier.third_party_user_id:type_name -> google.protobuf.StringValue
	0,  // 10: google.ads.googleads.v3.common.UserIdentifier.address_info:type_name -> google.ads.googleads.v3.common.OfflineUserAddressInfo
	8,  // 11: google.ads.googleads.v3.common.TransactionAttribute.transaction_date_time:type_name -> google.protobuf.StringValue
	9,  // 12: google.ads.googleads.v3.common.TransactionAttribute.transaction_amount_micros:type_name -> google.protobuf.DoubleValue
	8,  // 13: google.ads.googleads.v3.common.TransactionAttribute.currency_code:type_name -> google.protobuf.StringValue
	8,  // 14: google.ads.googleads.v3.common.TransactionAttribute.conversion_action:type_name -> google.protobuf.StringValue
	8,  // 15: google.ads.googleads.v3.common.TransactionAttribute.order_id:type_name -> google.protobuf.StringValue
	3,  // 16: google.ads.googleads.v3.common.TransactionAttribute.store_attribute:type_name -> google.ads.googleads.v3.common.StoreAttribute
	8,  // 17: google.ads.googleads.v3.common.TransactionAttribute.custom_value:type_name -> google.protobuf.StringValue
	8,  // 18: google.ads.googleads.v3.common.StoreAttribute.store_code:type_name -> google.protobuf.StringValue
	1,  // 19: google.ads.googleads.v3.common.UserData.user_identifiers:type_name -> google.ads.googleads.v3.common.UserIdentifier
	2,  // 20: google.ads.googleads.v3.common.UserData.transaction_attribute:type_name -> google.ads.googleads.v3.common.TransactionAttribute
	8,  // 21: google.ads.googleads.v3.common.CustomerMatchUserListMetadata.user_list:type_name -> google.protobuf.StringValue
	9,  // 22: google.ads.googleads.v3.common.StoreSalesMetadata.loyalty_fraction:type_name -> google.protobuf.DoubleValue
	9,  // 23: google.ads.googleads.v3.common.StoreSalesMetadata.transaction_upload_fraction:type_name -> google.protobuf.DoubleValue
	8,  // 24: google.ads.googleads.v3.common.StoreSalesMetadata.custom_key:type_name -> google.protobuf.StringValue
	7,  // 25: google.ads.googleads.v3.common.StoreSalesMetadata.third_party_metadata:type_name -> google.ads.googleads.v3.common.StoreSalesThirdPartyMetadata
	8,  // 26: google.ads.googleads.v3.common.StoreSalesThirdPartyMetadata.advertiser_upload_date_time:type_name -> google.protobuf.StringValue
	9,  // 27: google.ads.googleads.v3.common.StoreSalesThirdPartyMetadata.valid_transaction_fraction:type_name -> google.protobuf.DoubleValue
	9,  // 28: google.ads.googleads.v3.common.StoreSalesThirdPartyMetadata.partner_match_fraction:type_name -> google.protobuf.DoubleValue
	9,  // 29: google.ads.googleads.v3.common.StoreSalesThirdPartyMetadata.partner_upload_fraction:type_name -> google.protobuf.DoubleValue
	8,  // 30: google.ads.googleads.v3.common.StoreSalesThirdPartyMetadata.bridge_map_version_id:type_name -> google.protobuf.StringValue
	10, // 31: google.ads.googleads.v3.common.StoreSalesThirdPartyMetadata.partner_id:type_name -> google.protobuf.Int64Value
	32, // [32:32] is the sub-list for method output_type
	32, // [32:32] is the sub-list for method input_type
	32, // [32:32] is the sub-list for extension type_name
	32, // [32:32] is the sub-list for extension extendee
	0,  // [0:32] is the sub-list for field type_name
}

func init() { file_google_ads_googleads_v3_common_offline_user_data_proto_init() }
func file_google_ads_googleads_v3_common_offline_user_data_proto_init() {
	if File_google_ads_googleads_v3_common_offline_user_data_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_ads_googleads_v3_common_offline_user_data_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OfflineUserAddressInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v3_common_offline_user_data_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UserIdentifier); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v3_common_offline_user_data_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TransactionAttribute); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v3_common_offline_user_data_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StoreAttribute); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v3_common_offline_user_data_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UserData); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v3_common_offline_user_data_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CustomerMatchUserListMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v3_common_offline_user_data_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StoreSalesMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v3_common_offline_user_data_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StoreSalesThirdPartyMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_ads_googleads_v3_common_offline_user_data_proto_msgTypes[1].OneofWrappers = []interface{}{
		(*UserIdentifier_HashedEmail)(nil),
		(*UserIdentifier_HashedPhoneNumber)(nil),
		(*UserIdentifier_MobileId)(nil),
		(*UserIdentifier_ThirdPartyUserId)(nil),
		(*UserIdentifier_AddressInfo)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_ads_googleads_v3_common_offline_user_data_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   8,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_ads_googleads_v3_common_offline_user_data_proto_goTypes,
		DependencyIndexes: file_google_ads_googleads_v3_common_offline_user_data_proto_depIdxs,
		MessageInfos:      file_google_ads_googleads_v3_common_offline_user_data_proto_msgTypes,
	}.Build()
	File_google_ads_googleads_v3_common_offline_user_data_proto = out.File
	file_google_ads_googleads_v3_common_offline_user_data_proto_rawDesc = nil
	file_google_ads_googleads_v3_common_offline_user_data_proto_goTypes = nil
	file_google_ads_googleads_v3_common_offline_user_data_proto_depIdxs = nil
}
