// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go_gapic. DO NOT EDIT.

package irm

import (
	"context"
	"fmt"
	"math"
	"net/url"
	"time"

	"github.com/golang/protobuf/proto"
	gax "github.com/googleapis/gax-go/v2"
	"google.golang.org/api/iterator"
	"google.golang.org/api/option"
	gtransport "google.golang.org/api/transport/grpc"
	irmpb "google.golang.org/genproto/googleapis/cloud/irm/v1alpha2"
	"google.golang.org/grpc"
	"google.golang.org/grpc/codes"
	"google.golang.org/grpc/metadata"
)

var newIncidentClientHook clientHook

// IncidentCallOptions contains the retry settings for each method of IncidentClient.
type IncidentCallOptions struct {
	CreateIncident               []gax.CallOption
	GetIncident                  []gax.CallOption
	SearchIncidents              []gax.CallOption
	UpdateIncident               []gax.CallOption
	SearchSimilarIncidents       []gax.CallOption
	CreateAnnotation             []gax.CallOption
	ListAnnotations              []gax.CallOption
	CreateTag                    []gax.CallOption
	DeleteTag                    []gax.CallOption
	ListTags                     []gax.CallOption
	CreateSignal                 []gax.CallOption
	SearchSignals                []gax.CallOption
	LookupSignal                 []gax.CallOption
	GetSignal                    []gax.CallOption
	UpdateSignal                 []gax.CallOption
	EscalateIncident             []gax.CallOption
	CreateArtifact               []gax.CallOption
	ListArtifacts                []gax.CallOption
	UpdateArtifact               []gax.CallOption
	DeleteArtifact               []gax.CallOption
	SendShiftHandoff             []gax.CallOption
	CreateSubscription           []gax.CallOption
	UpdateSubscription           []gax.CallOption
	ListSubscriptions            []gax.CallOption
	DeleteSubscription           []gax.CallOption
	CreateIncidentRoleAssignment []gax.CallOption
	DeleteIncidentRoleAssignment []gax.CallOption
	ListIncidentRoleAssignments  []gax.CallOption
	RequestIncidentRoleHandover  []gax.CallOption
	ConfirmIncidentRoleHandover  []gax.CallOption
	ForceIncidentRoleHandover    []gax.CallOption
	CancelIncidentRoleHandover   []gax.CallOption
}

func defaultIncidentClientOptions() []option.ClientOption {
	return []option.ClientOption{
		option.WithEndpoint("irm.googleapis.com:443"),
		option.WithGRPCDialOption(grpc.WithDisableServiceConfig()),
		option.WithScopes(DefaultAuthScopes()...),
		option.WithGRPCDialOption(grpc.WithDefaultCallOptions(
			grpc.MaxCallRecvMsgSize(math.MaxInt32))),
	}
}

func defaultIncidentCallOptions() *IncidentCallOptions {
	return &IncidentCallOptions{
		CreateIncident: []gax.CallOption{},
		GetIncident: []gax.CallOption{
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.DeadlineExceeded,
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    100 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		SearchIncidents: []gax.CallOption{
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.DeadlineExceeded,
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    100 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		UpdateIncident: []gax.CallOption{},
		SearchSimilarIncidents: []gax.CallOption{
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.DeadlineExceeded,
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    100 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		CreateAnnotation: []gax.CallOption{},
		ListAnnotations: []gax.CallOption{
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.DeadlineExceeded,
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    100 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		CreateTag: []gax.CallOption{},
		DeleteTag: []gax.CallOption{
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.DeadlineExceeded,
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    100 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		ListTags: []gax.CallOption{
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.DeadlineExceeded,
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    100 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		CreateSignal: []gax.CallOption{},
		SearchSignals: []gax.CallOption{
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.DeadlineExceeded,
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    100 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		LookupSignal: []gax.CallOption{
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.DeadlineExceeded,
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    100 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		GetSignal: []gax.CallOption{
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.DeadlineExceeded,
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    100 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		UpdateSignal:     []gax.CallOption{},
		EscalateIncident: []gax.CallOption{},
		CreateArtifact:   []gax.CallOption{},
		ListArtifacts: []gax.CallOption{
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.DeadlineExceeded,
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    100 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		UpdateArtifact: []gax.CallOption{},
		DeleteArtifact: []gax.CallOption{
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.DeadlineExceeded,
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    100 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		SendShiftHandoff:   []gax.CallOption{},
		CreateSubscription: []gax.CallOption{},
		UpdateSubscription: []gax.CallOption{},
		ListSubscriptions: []gax.CallOption{
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.DeadlineExceeded,
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    100 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		DeleteSubscription: []gax.CallOption{
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.DeadlineExceeded,
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    100 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		CreateIncidentRoleAssignment: []gax.CallOption{},
		DeleteIncidentRoleAssignment: []gax.CallOption{
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.DeadlineExceeded,
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    100 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		ListIncidentRoleAssignments: []gax.CallOption{
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.DeadlineExceeded,
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    100 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		RequestIncidentRoleHandover: []gax.CallOption{},
		ConfirmIncidentRoleHandover: []gax.CallOption{},
		ForceIncidentRoleHandover:   []gax.CallOption{},
		CancelIncidentRoleHandover:  []gax.CallOption{},
	}
}

// IncidentClient is a client for interacting with Stackdriver Incident Response & Management API.
//
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type IncidentClient struct {
	// Connection pool of gRPC connections to the service.
	connPool gtransport.ConnPool

	// The gRPC API client.
	incidentClient irmpb.IncidentServiceClient

	// The call options for this service.
	CallOptions *IncidentCallOptions

	// The x-goog-* metadata to be sent with each request.
	xGoogMetadata metadata.MD
}

// NewIncidentClient creates a new incident service client.
//
// The Incident API for Incident Response & Management.
func NewIncidentClient(ctx context.Context, opts ...option.ClientOption) (*IncidentClient, error) {
	clientOpts := defaultIncidentClientOptions()

	if newIncidentClientHook != nil {
		hookOpts, err := newIncidentClientHook(ctx, clientHookParams{})
		if err != nil {
			return nil, err
		}
		clientOpts = append(clientOpts, hookOpts...)
	}

	connPool, err := gtransport.DialPool(ctx, append(clientOpts, opts...)...)
	if err != nil {
		return nil, err
	}
	c := &IncidentClient{
		connPool:    connPool,
		CallOptions: defaultIncidentCallOptions(),

		incidentClient: irmpb.NewIncidentServiceClient(connPool),
	}
	c.setGoogleClientInfo()

	return c, nil
}

// Connection returns a connection to the API service.
//
// Deprecated.
func (c *IncidentClient) Connection() *grpc.ClientConn {
	return c.connPool.Conn()
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *IncidentClient) Close() error {
	return c.connPool.Close()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *IncidentClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", versionGo()}, keyval...)
	kv = append(kv, "gapic", versionClient, "gax", gax.Version, "grpc", grpc.Version)
	c.xGoogMetadata = metadata.Pairs("x-goog-api-client", gax.XGoogHeader(kv...))
}

// CreateIncident creates a new incident.
func (c *IncidentClient) CreateIncident(ctx context.Context, req *irmpb.CreateIncidentRequest, opts ...gax.CallOption) (*irmpb.Incident, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append(c.CallOptions.CreateIncident[0:len(c.CallOptions.CreateIncident):len(c.CallOptions.CreateIncident)], opts...)
	var resp *irmpb.Incident
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.incidentClient.CreateIncident(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

// GetIncident returns an incident by name.
func (c *IncidentClient) GetIncident(ctx context.Context, req *irmpb.GetIncidentRequest, opts ...gax.CallOption) (*irmpb.Incident, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append(c.CallOptions.GetIncident[0:len(c.CallOptions.GetIncident):len(c.CallOptions.GetIncident)], opts...)
	var resp *irmpb.Incident
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.incidentClient.GetIncident(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

// SearchIncidents returns a list of incidents.
// Incidents are ordered by start time, with the most recent incidents first.
func (c *IncidentClient) SearchIncidents(ctx context.Context, req *irmpb.SearchIncidentsRequest, opts ...gax.CallOption) *IncidentIterator {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append(c.CallOptions.SearchIncidents[0:len(c.CallOptions.SearchIncidents):len(c.CallOptions.SearchIncidents)], opts...)
	it := &IncidentIterator{}
	req = proto.Clone(req).(*irmpb.SearchIncidentsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*irmpb.Incident, string, error) {
		var resp *irmpb.SearchIncidentsResponse
		req.PageToken = pageToken
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.incidentClient.SearchIncidents(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.Incidents, resp.NextPageToken, nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}
	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.PageSize)
	it.pageInfo.Token = req.PageToken
	return it
}

// UpdateIncident updates an existing incident.
func (c *IncidentClient) UpdateIncident(ctx context.Context, req *irmpb.UpdateIncidentRequest, opts ...gax.CallOption) (*irmpb.Incident, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "incident.name", url.QueryEscape(req.GetIncident().GetName())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append(c.CallOptions.UpdateIncident[0:len(c.CallOptions.UpdateIncident):len(c.CallOptions.UpdateIncident)], opts...)
	var resp *irmpb.Incident
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.incidentClient.UpdateIncident(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

// SearchSimilarIncidents returns a list of incidents that are “similar” to the specified incident
// or signal. This functionality is provided on a best-effort basis and the
// definition of “similar” is subject to change.
func (c *IncidentClient) SearchSimilarIncidents(ctx context.Context, req *irmpb.SearchSimilarIncidentsRequest, opts ...gax.CallOption) *SearchSimilarIncidentsResponse_ResultIterator {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append(c.CallOptions.SearchSimilarIncidents[0:len(c.CallOptions.SearchSimilarIncidents):len(c.CallOptions.SearchSimilarIncidents)], opts...)
	it := &SearchSimilarIncidentsResponse_ResultIterator{}
	req = proto.Clone(req).(*irmpb.SearchSimilarIncidentsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*irmpb.SearchSimilarIncidentsResponse_Result, string, error) {
		var resp *irmpb.SearchSimilarIncidentsResponse
		req.PageToken = pageToken
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.incidentClient.SearchSimilarIncidents(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.Results, resp.NextPageToken, nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}
	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.PageSize)
	it.pageInfo.Token = req.PageToken
	return it
}

// CreateAnnotation creates an annotation on an existing incident. Only ‘text/plain’ and
// ‘text/markdown’ annotations can be created via this method.
func (c *IncidentClient) CreateAnnotation(ctx context.Context, req *irmpb.CreateAnnotationRequest, opts ...gax.CallOption) (*irmpb.Annotation, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append(c.CallOptions.CreateAnnotation[0:len(c.CallOptions.CreateAnnotation):len(c.CallOptions.CreateAnnotation)], opts...)
	var resp *irmpb.Annotation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.incidentClient.CreateAnnotation(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

// ListAnnotations lists annotations that are part of an incident. No assumptions should be
// made on the content-type of the annotation returned.
func (c *IncidentClient) ListAnnotations(ctx context.Context, req *irmpb.ListAnnotationsRequest, opts ...gax.CallOption) *AnnotationIterator {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append(c.CallOptions.ListAnnotations[0:len(c.CallOptions.ListAnnotations):len(c.CallOptions.ListAnnotations)], opts...)
	it := &AnnotationIterator{}
	req = proto.Clone(req).(*irmpb.ListAnnotationsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*irmpb.Annotation, string, error) {
		var resp *irmpb.ListAnnotationsResponse
		req.PageToken = pageToken
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.incidentClient.ListAnnotations(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.Annotations, resp.NextPageToken, nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}
	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.PageSize)
	it.pageInfo.Token = req.PageToken
	return it
}

// CreateTag creates a tag on an existing incident.
func (c *IncidentClient) CreateTag(ctx context.Context, req *irmpb.CreateTagRequest, opts ...gax.CallOption) (*irmpb.Tag, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append(c.CallOptions.CreateTag[0:len(c.CallOptions.CreateTag):len(c.CallOptions.CreateTag)], opts...)
	var resp *irmpb.Tag
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.incidentClient.CreateTag(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

// DeleteTag deletes an existing tag.
func (c *IncidentClient) DeleteTag(ctx context.Context, req *irmpb.DeleteTagRequest, opts ...gax.CallOption) error {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append(c.CallOptions.DeleteTag[0:len(c.CallOptions.DeleteTag):len(c.CallOptions.DeleteTag)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = c.incidentClient.DeleteTag(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	return err
}

// ListTags lists tags that are part of an incident.
func (c *IncidentClient) ListTags(ctx context.Context, req *irmpb.ListTagsRequest, opts ...gax.CallOption) *TagIterator {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append(c.CallOptions.ListTags[0:len(c.CallOptions.ListTags):len(c.CallOptions.ListTags)], opts...)
	it := &TagIterator{}
	req = proto.Clone(req).(*irmpb.ListTagsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*irmpb.Tag, string, error) {
		var resp *irmpb.ListTagsResponse
		req.PageToken = pageToken
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.incidentClient.ListTags(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.Tags, resp.NextPageToken, nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}
	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.PageSize)
	it.pageInfo.Token = req.PageToken
	return it
}

// CreateSignal creates a new signal.
func (c *IncidentClient) CreateSignal(ctx context.Context, req *irmpb.CreateSignalRequest, opts ...gax.CallOption) (*irmpb.Signal, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append(c.CallOptions.CreateSignal[0:len(c.CallOptions.CreateSignal):len(c.CallOptions.CreateSignal)], opts...)
	var resp *irmpb.Signal
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.incidentClient.CreateSignal(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

// SearchSignals lists signals that are part of an incident.
// Signals are returned in reverse chronological order.
// Note that search should not be relied on for critical functionality.  It
// has lower availability guarantees and might fail to return valid results.
// Returned results might include stale or extraneous entries.
func (c *IncidentClient) SearchSignals(ctx context.Context, req *irmpb.SearchSignalsRequest, opts ...gax.CallOption) *SignalIterator {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append(c.CallOptions.SearchSignals[0:len(c.CallOptions.SearchSignals):len(c.CallOptions.SearchSignals)], opts...)
	it := &SignalIterator{}
	req = proto.Clone(req).(*irmpb.SearchSignalsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*irmpb.Signal, string, error) {
		var resp *irmpb.SearchSignalsResponse
		req.PageToken = pageToken
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.incidentClient.SearchSignals(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.Signals, resp.NextPageToken, nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}
	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.PageSize)
	it.pageInfo.Token = req.PageToken
	return it
}

// LookupSignal finds a signal by other unique IDs.
func (c *IncidentClient) LookupSignal(ctx context.Context, req *irmpb.LookupSignalRequest, opts ...gax.CallOption) (*irmpb.Signal, error) {
	ctx = insertMetadata(ctx, c.xGoogMetadata)
	opts = append(c.CallOptions.LookupSignal[0:len(c.CallOptions.LookupSignal):len(c.CallOptions.LookupSignal)], opts...)
	var resp *irmpb.Signal
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.incidentClient.LookupSignal(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

// GetSignal returns a signal by name.
func (c *IncidentClient) GetSignal(ctx context.Context, req *irmpb.GetSignalRequest, opts ...gax.CallOption) (*irmpb.Signal, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append(c.CallOptions.GetSignal[0:len(c.CallOptions.GetSignal):len(c.CallOptions.GetSignal)], opts...)
	var resp *irmpb.Signal
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.incidentClient.GetSignal(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

// UpdateSignal updates an existing signal (for example, to assign/unassign it to an
// incident).
func (c *IncidentClient) UpdateSignal(ctx context.Context, req *irmpb.UpdateSignalRequest, opts ...gax.CallOption) (*irmpb.Signal, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "signal.name", url.QueryEscape(req.GetSignal().GetName())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append(c.CallOptions.UpdateSignal[0:len(c.CallOptions.UpdateSignal):len(c.CallOptions.UpdateSignal)], opts...)
	var resp *irmpb.Signal
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.incidentClient.UpdateSignal(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

// EscalateIncident escalates an incident.
func (c *IncidentClient) EscalateIncident(ctx context.Context, req *irmpb.EscalateIncidentRequest, opts ...gax.CallOption) (*irmpb.EscalateIncidentResponse, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "incident.name", url.QueryEscape(req.GetIncident().GetName())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append(c.CallOptions.EscalateIncident[0:len(c.CallOptions.EscalateIncident):len(c.CallOptions.EscalateIncident)], opts...)
	var resp *irmpb.EscalateIncidentResponse
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.incidentClient.EscalateIncident(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

// CreateArtifact creates a new artifact.
func (c *IncidentClient) CreateArtifact(ctx context.Context, req *irmpb.CreateArtifactRequest, opts ...gax.CallOption) (*irmpb.Artifact, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append(c.CallOptions.CreateArtifact[0:len(c.CallOptions.CreateArtifact):len(c.CallOptions.CreateArtifact)], opts...)
	var resp *irmpb.Artifact
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.incidentClient.CreateArtifact(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

// ListArtifacts returns a list of artifacts for an incident.
func (c *IncidentClient) ListArtifacts(ctx context.Context, req *irmpb.ListArtifactsRequest, opts ...gax.CallOption) *ArtifactIterator {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append(c.CallOptions.ListArtifacts[0:len(c.CallOptions.ListArtifacts):len(c.CallOptions.ListArtifacts)], opts...)
	it := &ArtifactIterator{}
	req = proto.Clone(req).(*irmpb.ListArtifactsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*irmpb.Artifact, string, error) {
		var resp *irmpb.ListArtifactsResponse
		req.PageToken = pageToken
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.incidentClient.ListArtifacts(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.Artifacts, resp.NextPageToken, nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}
	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.PageSize)
	it.pageInfo.Token = req.PageToken
	return it
}

// UpdateArtifact updates an existing artifact.
func (c *IncidentClient) UpdateArtifact(ctx context.Context, req *irmpb.UpdateArtifactRequest, opts ...gax.CallOption) (*irmpb.Artifact, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "artifact.name", url.QueryEscape(req.GetArtifact().GetName())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append(c.CallOptions.UpdateArtifact[0:len(c.CallOptions.UpdateArtifact):len(c.CallOptions.UpdateArtifact)], opts...)
	var resp *irmpb.Artifact
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.incidentClient.UpdateArtifact(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

// DeleteArtifact deletes an existing artifact.
func (c *IncidentClient) DeleteArtifact(ctx context.Context, req *irmpb.DeleteArtifactRequest, opts ...gax.CallOption) error {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append(c.CallOptions.DeleteArtifact[0:len(c.CallOptions.DeleteArtifact):len(c.CallOptions.DeleteArtifact)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = c.incidentClient.DeleteArtifact(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	return err
}

// SendShiftHandoff sends a summary of the shift for oncall handoff.
func (c *IncidentClient) SendShiftHandoff(ctx context.Context, req *irmpb.SendShiftHandoffRequest, opts ...gax.CallOption) (*irmpb.SendShiftHandoffResponse, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append(c.CallOptions.SendShiftHandoff[0:len(c.CallOptions.SendShiftHandoff):len(c.CallOptions.SendShiftHandoff)], opts...)
	var resp *irmpb.SendShiftHandoffResponse
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.incidentClient.SendShiftHandoff(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

// CreateSubscription creates a new subscription.
// This will fail if:
// a. there are too many (50) subscriptions in the incident already
// b. a subscription using the given channel already exists
func (c *IncidentClient) CreateSubscription(ctx context.Context, req *irmpb.CreateSubscriptionRequest, opts ...gax.CallOption) (*irmpb.Subscription, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append(c.CallOptions.CreateSubscription[0:len(c.CallOptions.CreateSubscription):len(c.CallOptions.CreateSubscription)], opts...)
	var resp *irmpb.Subscription
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.incidentClient.CreateSubscription(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

// UpdateSubscription updates a subscription.
func (c *IncidentClient) UpdateSubscription(ctx context.Context, req *irmpb.UpdateSubscriptionRequest, opts ...gax.CallOption) (*irmpb.Subscription, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "subscription.name", url.QueryEscape(req.GetSubscription().GetName())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append(c.CallOptions.UpdateSubscription[0:len(c.CallOptions.UpdateSubscription):len(c.CallOptions.UpdateSubscription)], opts...)
	var resp *irmpb.Subscription
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.incidentClient.UpdateSubscription(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

// ListSubscriptions returns a list of subscriptions for an incident.
func (c *IncidentClient) ListSubscriptions(ctx context.Context, req *irmpb.ListSubscriptionsRequest, opts ...gax.CallOption) *SubscriptionIterator {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append(c.CallOptions.ListSubscriptions[0:len(c.CallOptions.ListSubscriptions):len(c.CallOptions.ListSubscriptions)], opts...)
	it := &SubscriptionIterator{}
	req = proto.Clone(req).(*irmpb.ListSubscriptionsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*irmpb.Subscription, string, error) {
		var resp *irmpb.ListSubscriptionsResponse
		req.PageToken = pageToken
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.incidentClient.ListSubscriptions(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.Subscriptions, resp.NextPageToken, nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}
	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.PageSize)
	it.pageInfo.Token = req.PageToken
	return it
}

// DeleteSubscription deletes an existing subscription.
func (c *IncidentClient) DeleteSubscription(ctx context.Context, req *irmpb.DeleteSubscriptionRequest, opts ...gax.CallOption) error {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append(c.CallOptions.DeleteSubscription[0:len(c.CallOptions.DeleteSubscription):len(c.CallOptions.DeleteSubscription)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = c.incidentClient.DeleteSubscription(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	return err
}

// CreateIncidentRoleAssignment creates a role assignment on an existing incident. Normally, the user field
// will be set when assigning a role to oneself, and the next field will be
// set when proposing another user as the assignee. Setting the next field
// directly to a user other than oneself is equivalent to proposing and
// force-assigning the role to the user.
func (c *IncidentClient) CreateIncidentRoleAssignment(ctx context.Context, req *irmpb.CreateIncidentRoleAssignmentRequest, opts ...gax.CallOption) (*irmpb.IncidentRoleAssignment, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append(c.CallOptions.CreateIncidentRoleAssignment[0:len(c.CallOptions.CreateIncidentRoleAssignment):len(c.CallOptions.CreateIncidentRoleAssignment)], opts...)
	var resp *irmpb.IncidentRoleAssignment
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.incidentClient.CreateIncidentRoleAssignment(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

// DeleteIncidentRoleAssignment deletes an existing role assignment.
func (c *IncidentClient) DeleteIncidentRoleAssignment(ctx context.Context, req *irmpb.DeleteIncidentRoleAssignmentRequest, opts ...gax.CallOption) error {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append(c.CallOptions.DeleteIncidentRoleAssignment[0:len(c.CallOptions.DeleteIncidentRoleAssignment):len(c.CallOptions.DeleteIncidentRoleAssignment)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = c.incidentClient.DeleteIncidentRoleAssignment(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	return err
}

// ListIncidentRoleAssignments lists role assignments that are part of an incident.
func (c *IncidentClient) ListIncidentRoleAssignments(ctx context.Context, req *irmpb.ListIncidentRoleAssignmentsRequest, opts ...gax.CallOption) *IncidentRoleAssignmentIterator {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append(c.CallOptions.ListIncidentRoleAssignments[0:len(c.CallOptions.ListIncidentRoleAssignments):len(c.CallOptions.ListIncidentRoleAssignments)], opts...)
	it := &IncidentRoleAssignmentIterator{}
	req = proto.Clone(req).(*irmpb.ListIncidentRoleAssignmentsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*irmpb.IncidentRoleAssignment, string, error) {
		var resp *irmpb.ListIncidentRoleAssignmentsResponse
		req.PageToken = pageToken
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.incidentClient.ListIncidentRoleAssignments(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.IncidentRoleAssignments, resp.NextPageToken, nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}
	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.PageSize)
	it.pageInfo.Token = req.PageToken
	return it
}

// RequestIncidentRoleHandover starts a role handover. The proposed assignee will receive an email
// notifying them of the assignment. This will fail if a role handover is
// already pending.
// Handover to an oncall ladder is not permitted. Use
// CreateIncidentRoleAssignment instead.
func (c *IncidentClient) RequestIncidentRoleHandover(ctx context.Context, req *irmpb.RequestIncidentRoleHandoverRequest, opts ...gax.CallOption) (*irmpb.IncidentRoleAssignment, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append(c.CallOptions.RequestIncidentRoleHandover[0:len(c.CallOptions.RequestIncidentRoleHandover):len(c.CallOptions.RequestIncidentRoleHandover)], opts...)
	var resp *irmpb.IncidentRoleAssignment
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.incidentClient.RequestIncidentRoleHandover(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

// ConfirmIncidentRoleHandover confirms a role handover. This will fail if the ‘proposed_assignee’ field
// of the IncidentRoleAssignment is not equal to the ‘new_assignee’ field of
// the request. If the caller is not the new_assignee,
// ForceIncidentRoleHandover should be used instead.
func (c *IncidentClient) ConfirmIncidentRoleHandover(ctx context.Context, req *irmpb.ConfirmIncidentRoleHandoverRequest, opts ...gax.CallOption) (*irmpb.IncidentRoleAssignment, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append(c.CallOptions.ConfirmIncidentRoleHandover[0:len(c.CallOptions.ConfirmIncidentRoleHandover):len(c.CallOptions.ConfirmIncidentRoleHandover)], opts...)
	var resp *irmpb.IncidentRoleAssignment
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.incidentClient.ConfirmIncidentRoleHandover(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

// ForceIncidentRoleHandover forces a role handover. This will fail if the ‘proposed_assignee’ field of
// the IncidentRoleAssignment is not equal to the ‘new_assignee’ field of the
// request. If the caller is the new_assignee, ConfirmIncidentRoleHandover
// should be used instead.
func (c *IncidentClient) ForceIncidentRoleHandover(ctx context.Context, req *irmpb.ForceIncidentRoleHandoverRequest, opts ...gax.CallOption) (*irmpb.IncidentRoleAssignment, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append(c.CallOptions.ForceIncidentRoleHandover[0:len(c.CallOptions.ForceIncidentRoleHandover):len(c.CallOptions.ForceIncidentRoleHandover)], opts...)
	var resp *irmpb.IncidentRoleAssignment
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.incidentClient.ForceIncidentRoleHandover(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

// CancelIncidentRoleHandover cancels a role handover. This will fail if the ‘proposed_assignee’ field of
// the IncidentRoleAssignment is not equal to the ‘new_assignee’ field of the
// request.
func (c *IncidentClient) CancelIncidentRoleHandover(ctx context.Context, req *irmpb.CancelIncidentRoleHandoverRequest, opts ...gax.CallOption) (*irmpb.IncidentRoleAssignment, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append(c.CallOptions.CancelIncidentRoleHandover[0:len(c.CallOptions.CancelIncidentRoleHandover):len(c.CallOptions.CancelIncidentRoleHandover)], opts...)
	var resp *irmpb.IncidentRoleAssignment
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.incidentClient.CancelIncidentRoleHandover(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

// AnnotationIterator manages a stream of *irmpb.Annotation.
type AnnotationIterator struct {
	items    []*irmpb.Annotation
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*irmpb.Annotation, nextPageToken string, err error)
}

// PageInfo supports pagination. See the google.golang.org/api/iterator package for details.
func (it *AnnotationIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *AnnotationIterator) Next() (*irmpb.Annotation, error) {
	var item *irmpb.Annotation
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *AnnotationIterator) bufLen() int {
	return len(it.items)
}

func (it *AnnotationIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// ArtifactIterator manages a stream of *irmpb.Artifact.
type ArtifactIterator struct {
	items    []*irmpb.Artifact
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*irmpb.Artifact, nextPageToken string, err error)
}

// PageInfo supports pagination. See the google.golang.org/api/iterator package for details.
func (it *ArtifactIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *ArtifactIterator) Next() (*irmpb.Artifact, error) {
	var item *irmpb.Artifact
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *ArtifactIterator) bufLen() int {
	return len(it.items)
}

func (it *ArtifactIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// IncidentIterator manages a stream of *irmpb.Incident.
type IncidentIterator struct {
	items    []*irmpb.Incident
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*irmpb.Incident, nextPageToken string, err error)
}

// PageInfo supports pagination. See the google.golang.org/api/iterator package for details.
func (it *IncidentIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *IncidentIterator) Next() (*irmpb.Incident, error) {
	var item *irmpb.Incident
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *IncidentIterator) bufLen() int {
	return len(it.items)
}

func (it *IncidentIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// IncidentRoleAssignmentIterator manages a stream of *irmpb.IncidentRoleAssignment.
type IncidentRoleAssignmentIterator struct {
	items    []*irmpb.IncidentRoleAssignment
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*irmpb.IncidentRoleAssignment, nextPageToken string, err error)
}

// PageInfo supports pagination. See the google.golang.org/api/iterator package for details.
func (it *IncidentRoleAssignmentIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *IncidentRoleAssignmentIterator) Next() (*irmpb.IncidentRoleAssignment, error) {
	var item *irmpb.IncidentRoleAssignment
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *IncidentRoleAssignmentIterator) bufLen() int {
	return len(it.items)
}

func (it *IncidentRoleAssignmentIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// SearchSimilarIncidentsResponse_ResultIterator manages a stream of *irmpb.SearchSimilarIncidentsResponse_Result.
type SearchSimilarIncidentsResponse_ResultIterator struct {
	items    []*irmpb.SearchSimilarIncidentsResponse_Result
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*irmpb.SearchSimilarIncidentsResponse_Result, nextPageToken string, err error)
}

// PageInfo supports pagination. See the google.golang.org/api/iterator package for details.
func (it *SearchSimilarIncidentsResponse_ResultIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *SearchSimilarIncidentsResponse_ResultIterator) Next() (*irmpb.SearchSimilarIncidentsResponse_Result, error) {
	var item *irmpb.SearchSimilarIncidentsResponse_Result
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *SearchSimilarIncidentsResponse_ResultIterator) bufLen() int {
	return len(it.items)
}

func (it *SearchSimilarIncidentsResponse_ResultIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// SignalIterator manages a stream of *irmpb.Signal.
type SignalIterator struct {
	items    []*irmpb.Signal
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*irmpb.Signal, nextPageToken string, err error)
}

// PageInfo supports pagination. See the google.golang.org/api/iterator package for details.
func (it *SignalIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *SignalIterator) Next() (*irmpb.Signal, error) {
	var item *irmpb.Signal
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *SignalIterator) bufLen() int {
	return len(it.items)
}

func (it *SignalIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// SubscriptionIterator manages a stream of *irmpb.Subscription.
type SubscriptionIterator struct {
	items    []*irmpb.Subscription
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*irmpb.Subscription, nextPageToken string, err error)
}

// PageInfo supports pagination. See the google.golang.org/api/iterator package for details.
func (it *SubscriptionIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *SubscriptionIterator) Next() (*irmpb.Subscription, error) {
	var item *irmpb.Subscription
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *SubscriptionIterator) bufLen() int {
	return len(it.items)
}

func (it *SubscriptionIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// TagIterator manages a stream of *irmpb.Tag.
type TagIterator struct {
	items    []*irmpb.Tag
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*irmpb.Tag, nextPageToken string, err error)
}

// PageInfo supports pagination. See the google.golang.org/api/iterator package for details.
func (it *TagIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *TagIterator) Next() (*irmpb.Tag, error) {
	var item *irmpb.Tag
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *TagIterator) bufLen() int {
	return len(it.items)
}

func (it *TagIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}
