// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0
// 	protoc        v3.13.0
// source: google/ads/googleads/v6/common/asset_types.proto

package common

import (
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	enums "google.golang.org/genproto/googleapis/ads/googleads/v6/enums"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// A YouTube asset.
type YoutubeVideoAsset struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// YouTube video id. This is the 11 character string value used in the
	// YouTube video URL.
	YoutubeVideoId *string `protobuf:"bytes,2,opt,name=youtube_video_id,json=youtubeVideoId,proto3,oneof" json:"youtube_video_id,omitempty"`
}

func (x *YoutubeVideoAsset) Reset() {
	*x = YoutubeVideoAsset{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v6_common_asset_types_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *YoutubeVideoAsset) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*YoutubeVideoAsset) ProtoMessage() {}

func (x *YoutubeVideoAsset) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v6_common_asset_types_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use YoutubeVideoAsset.ProtoReflect.Descriptor instead.
func (*YoutubeVideoAsset) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v6_common_asset_types_proto_rawDescGZIP(), []int{0}
}

func (x *YoutubeVideoAsset) GetYoutubeVideoId() string {
	if x != nil && x.YoutubeVideoId != nil {
		return *x.YoutubeVideoId
	}
	return ""
}

// A MediaBundle asset.
type MediaBundleAsset struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Media bundle (ZIP file) asset data. The format of the uploaded ZIP file
	// depends on the ad field where it will be used. For more information on the
	// format, see the documentation of the ad field where you plan on using the
	// MediaBundleAsset. This field is mutate only.
	Data []byte `protobuf:"bytes,2,opt,name=data,proto3,oneof" json:"data,omitempty"`
}

func (x *MediaBundleAsset) Reset() {
	*x = MediaBundleAsset{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v6_common_asset_types_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MediaBundleAsset) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MediaBundleAsset) ProtoMessage() {}

func (x *MediaBundleAsset) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v6_common_asset_types_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MediaBundleAsset.ProtoReflect.Descriptor instead.
func (*MediaBundleAsset) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v6_common_asset_types_proto_rawDescGZIP(), []int{1}
}

func (x *MediaBundleAsset) GetData() []byte {
	if x != nil {
		return x.Data
	}
	return nil
}

// An Image asset.
type ImageAsset struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The raw bytes data of an image. This field is mutate only.
	Data []byte `protobuf:"bytes,5,opt,name=data,proto3,oneof" json:"data,omitempty"`
	// File size of the image asset in bytes.
	FileSize *int64 `protobuf:"varint,6,opt,name=file_size,json=fileSize,proto3,oneof" json:"file_size,omitempty"`
	// MIME type of the image asset.
	MimeType enums.MimeTypeEnum_MimeType `protobuf:"varint,3,opt,name=mime_type,json=mimeType,proto3,enum=google.ads.googleads.v6.enums.MimeTypeEnum_MimeType" json:"mime_type,omitempty"`
	// Metadata for this image at its original size.
	FullSize *ImageDimension `protobuf:"bytes,4,opt,name=full_size,json=fullSize,proto3" json:"full_size,omitempty"`
}

func (x *ImageAsset) Reset() {
	*x = ImageAsset{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v6_common_asset_types_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImageAsset) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImageAsset) ProtoMessage() {}

func (x *ImageAsset) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v6_common_asset_types_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImageAsset.ProtoReflect.Descriptor instead.
func (*ImageAsset) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v6_common_asset_types_proto_rawDescGZIP(), []int{2}
}

func (x *ImageAsset) GetData() []byte {
	if x != nil {
		return x.Data
	}
	return nil
}

func (x *ImageAsset) GetFileSize() int64 {
	if x != nil && x.FileSize != nil {
		return *x.FileSize
	}
	return 0
}

func (x *ImageAsset) GetMimeType() enums.MimeTypeEnum_MimeType {
	if x != nil {
		return x.MimeType
	}
	return enums.MimeTypeEnum_UNSPECIFIED
}

func (x *ImageAsset) GetFullSize() *ImageDimension {
	if x != nil {
		return x.FullSize
	}
	return nil
}

// Metadata for an image at a certain size, either original or resized.
type ImageDimension struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Height of the image.
	HeightPixels *int64 `protobuf:"varint,4,opt,name=height_pixels,json=heightPixels,proto3,oneof" json:"height_pixels,omitempty"`
	// Width of the image.
	WidthPixels *int64 `protobuf:"varint,5,opt,name=width_pixels,json=widthPixels,proto3,oneof" json:"width_pixels,omitempty"`
	// A URL that returns the image with this height and width.
	Url *string `protobuf:"bytes,6,opt,name=url,proto3,oneof" json:"url,omitempty"`
}

func (x *ImageDimension) Reset() {
	*x = ImageDimension{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v6_common_asset_types_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImageDimension) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImageDimension) ProtoMessage() {}

func (x *ImageDimension) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v6_common_asset_types_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImageDimension.ProtoReflect.Descriptor instead.
func (*ImageDimension) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v6_common_asset_types_proto_rawDescGZIP(), []int{3}
}

func (x *ImageDimension) GetHeightPixels() int64 {
	if x != nil && x.HeightPixels != nil {
		return *x.HeightPixels
	}
	return 0
}

func (x *ImageDimension) GetWidthPixels() int64 {
	if x != nil && x.WidthPixels != nil {
		return *x.WidthPixels
	}
	return 0
}

func (x *ImageDimension) GetUrl() string {
	if x != nil && x.Url != nil {
		return *x.Url
	}
	return ""
}

// A Text asset.
type TextAsset struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Text content of the text asset.
	Text *string `protobuf:"bytes,2,opt,name=text,proto3,oneof" json:"text,omitempty"`
}

func (x *TextAsset) Reset() {
	*x = TextAsset{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v6_common_asset_types_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TextAsset) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TextAsset) ProtoMessage() {}

func (x *TextAsset) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v6_common_asset_types_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TextAsset.ProtoReflect.Descriptor instead.
func (*TextAsset) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v6_common_asset_types_proto_rawDescGZIP(), []int{4}
}

func (x *TextAsset) GetText() string {
	if x != nil && x.Text != nil {
		return *x.Text
	}
	return ""
}

// A Lead Form asset.
type LeadFormAsset struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the business being advertised.
	BusinessName string `protobuf:"bytes,10,opt,name=business_name,json=businessName,proto3" json:"business_name,omitempty"`
	// Required. Pre-defined display text that encourages user to expand the form.
	CallToActionType enums.LeadFormCallToActionTypeEnum_LeadFormCallToActionType `protobuf:"varint,17,opt,name=call_to_action_type,json=callToActionType,proto3,enum=google.ads.googleads.v6.enums.LeadFormCallToActionTypeEnum_LeadFormCallToActionType" json:"call_to_action_type,omitempty"`
	// Required. Text giving a clear value proposition of what users expect once they expand
	// the form.
	CallToActionDescription string `protobuf:"bytes,18,opt,name=call_to_action_description,json=callToActionDescription,proto3" json:"call_to_action_description,omitempty"`
	// Required. Headline of the expanded form to describe what the form is asking for or
	// facilitating.
	Headline string `protobuf:"bytes,12,opt,name=headline,proto3" json:"headline,omitempty"`
	// Required. Detailed description of the expanded form to describe what the form is
	// asking for or facilitating.
	Description string `protobuf:"bytes,13,opt,name=description,proto3" json:"description,omitempty"`
	// Required. Link to a page describing the policy on how the collected data is handled
	// by the advertiser/business.
	PrivacyPolicyUrl string `protobuf:"bytes,14,opt,name=privacy_policy_url,json=privacyPolicyUrl,proto3" json:"privacy_policy_url,omitempty"`
	// Headline of text shown after form submission that describes how the
	// advertiser will follow up with the user.
	PostSubmitHeadline *string `protobuf:"bytes,15,opt,name=post_submit_headline,json=postSubmitHeadline,proto3,oneof" json:"post_submit_headline,omitempty"`
	// Detailed description shown after form submission that describes how the
	// advertiser will follow up with the user.
	PostSubmitDescription *string `protobuf:"bytes,16,opt,name=post_submit_description,json=postSubmitDescription,proto3,oneof" json:"post_submit_description,omitempty"`
	// Ordered list of input fields.
	Fields []*LeadFormField `protobuf:"bytes,8,rep,name=fields,proto3" json:"fields,omitempty"`
	// Configured methods for collected lead data to be delivered to advertiser.
	DeliveryMethods []*LeadFormDeliveryMethod `protobuf:"bytes,9,rep,name=delivery_methods,json=deliveryMethods,proto3" json:"delivery_methods,omitempty"`
	// Pre-defined display text that encourages user action after the form is
	// submitted.
	PostSubmitCallToActionType enums.LeadFormPostSubmitCallToActionTypeEnum_LeadFormPostSubmitCallToActionType `protobuf:"varint,19,opt,name=post_submit_call_to_action_type,json=postSubmitCallToActionType,proto3,enum=google.ads.googleads.v6.enums.LeadFormPostSubmitCallToActionTypeEnum_LeadFormPostSubmitCallToActionType" json:"post_submit_call_to_action_type,omitempty"`
	// Asset resource name of the background image. The minimum size is 600x314
	// and the aspect ratio must be 1.91:1 (+-1%).
	BackgroundImageAsset *string `protobuf:"bytes,20,opt,name=background_image_asset,json=backgroundImageAsset,proto3,oneof" json:"background_image_asset,omitempty"`
	// Desired intent for the lead form, e.g. more volume or higher intent.
	DesiredIntent enums.LeadFormDesiredIntentEnum_LeadFormDesiredIntent `protobuf:"varint,21,opt,name=desired_intent,json=desiredIntent,proto3,enum=google.ads.googleads.v6.enums.LeadFormDesiredIntentEnum_LeadFormDesiredIntent" json:"desired_intent,omitempty"`
	// Custom disclosure shown along with Google disclaimer on the lead form.
	// Accessible to allowed customers only.
	CustomDisclosure *string `protobuf:"bytes,22,opt,name=custom_disclosure,json=customDisclosure,proto3,oneof" json:"custom_disclosure,omitempty"`
}

func (x *LeadFormAsset) Reset() {
	*x = LeadFormAsset{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v6_common_asset_types_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LeadFormAsset) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LeadFormAsset) ProtoMessage() {}

func (x *LeadFormAsset) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v6_common_asset_types_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LeadFormAsset.ProtoReflect.Descriptor instead.
func (*LeadFormAsset) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v6_common_asset_types_proto_rawDescGZIP(), []int{5}
}

func (x *LeadFormAsset) GetBusinessName() string {
	if x != nil {
		return x.BusinessName
	}
	return ""
}

func (x *LeadFormAsset) GetCallToActionType() enums.LeadFormCallToActionTypeEnum_LeadFormCallToActionType {
	if x != nil {
		return x.CallToActionType
	}
	return enums.LeadFormCallToActionTypeEnum_UNSPECIFIED
}

func (x *LeadFormAsset) GetCallToActionDescription() string {
	if x != nil {
		return x.CallToActionDescription
	}
	return ""
}

func (x *LeadFormAsset) GetHeadline() string {
	if x != nil {
		return x.Headline
	}
	return ""
}

func (x *LeadFormAsset) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *LeadFormAsset) GetPrivacyPolicyUrl() string {
	if x != nil {
		return x.PrivacyPolicyUrl
	}
	return ""
}

func (x *LeadFormAsset) GetPostSubmitHeadline() string {
	if x != nil && x.PostSubmitHeadline != nil {
		return *x.PostSubmitHeadline
	}
	return ""
}

func (x *LeadFormAsset) GetPostSubmitDescription() string {
	if x != nil && x.PostSubmitDescription != nil {
		return *x.PostSubmitDescription
	}
	return ""
}

func (x *LeadFormAsset) GetFields() []*LeadFormField {
	if x != nil {
		return x.Fields
	}
	return nil
}

func (x *LeadFormAsset) GetDeliveryMethods() []*LeadFormDeliveryMethod {
	if x != nil {
		return x.DeliveryMethods
	}
	return nil
}

func (x *LeadFormAsset) GetPostSubmitCallToActionType() enums.LeadFormPostSubmitCallToActionTypeEnum_LeadFormPostSubmitCallToActionType {
	if x != nil {
		return x.PostSubmitCallToActionType
	}
	return enums.LeadFormPostSubmitCallToActionTypeEnum_UNSPECIFIED
}

func (x *LeadFormAsset) GetBackgroundImageAsset() string {
	if x != nil && x.BackgroundImageAsset != nil {
		return *x.BackgroundImageAsset
	}
	return ""
}

func (x *LeadFormAsset) GetDesiredIntent() enums.LeadFormDesiredIntentEnum_LeadFormDesiredIntent {
	if x != nil {
		return x.DesiredIntent
	}
	return enums.LeadFormDesiredIntentEnum_UNSPECIFIED
}

func (x *LeadFormAsset) GetCustomDisclosure() string {
	if x != nil && x.CustomDisclosure != nil {
		return *x.CustomDisclosure
	}
	return ""
}

// One input field instance within a form.
type LeadFormField struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Describes the input type, which may be a predefined type such as
	// "full name" or a pre-vetted question like "Do you own a car?".
	InputType enums.LeadFormFieldUserInputTypeEnum_LeadFormFieldUserInputType `protobuf:"varint,1,opt,name=input_type,json=inputType,proto3,enum=google.ads.googleads.v6.enums.LeadFormFieldUserInputTypeEnum_LeadFormFieldUserInputType" json:"input_type,omitempty"`
	// Defines answer configuration that this form field accepts. If oneof is not
	// set, this is a free-text answer.
	//
	// Types that are assignable to Answers:
	//	*LeadFormField_SingleChoiceAnswers
	Answers isLeadFormField_Answers `protobuf_oneof:"answers"`
}

func (x *LeadFormField) Reset() {
	*x = LeadFormField{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v6_common_asset_types_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LeadFormField) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LeadFormField) ProtoMessage() {}

func (x *LeadFormField) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v6_common_asset_types_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LeadFormField.ProtoReflect.Descriptor instead.
func (*LeadFormField) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v6_common_asset_types_proto_rawDescGZIP(), []int{6}
}

func (x *LeadFormField) GetInputType() enums.LeadFormFieldUserInputTypeEnum_LeadFormFieldUserInputType {
	if x != nil {
		return x.InputType
	}
	return enums.LeadFormFieldUserInputTypeEnum_UNSPECIFIED
}

func (m *LeadFormField) GetAnswers() isLeadFormField_Answers {
	if m != nil {
		return m.Answers
	}
	return nil
}

func (x *LeadFormField) GetSingleChoiceAnswers() *LeadFormSingleChoiceAnswers {
	if x, ok := x.GetAnswers().(*LeadFormField_SingleChoiceAnswers); ok {
		return x.SingleChoiceAnswers
	}
	return nil
}

type isLeadFormField_Answers interface {
	isLeadFormField_Answers()
}

type LeadFormField_SingleChoiceAnswers struct {
	// Answer configuration for a single choice question. Can be set only for
	// pre-vetted question fields. Minimum of 2 answers required and maximum of
	// 12 allowed.
	SingleChoiceAnswers *LeadFormSingleChoiceAnswers `protobuf:"bytes,2,opt,name=single_choice_answers,json=singleChoiceAnswers,proto3,oneof"`
}

func (*LeadFormField_SingleChoiceAnswers) isLeadFormField_Answers() {}

// Defines possible answers for a single choice question, usually presented as
// a single-choice drop-down list.
type LeadFormSingleChoiceAnswers struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of choices for a single question field. The order of entries defines
	// UI order. Minimum of 2 answers required and maximum of 12 allowed.
	Answers []string `protobuf:"bytes,1,rep,name=answers,proto3" json:"answers,omitempty"`
}

func (x *LeadFormSingleChoiceAnswers) Reset() {
	*x = LeadFormSingleChoiceAnswers{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v6_common_asset_types_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LeadFormSingleChoiceAnswers) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LeadFormSingleChoiceAnswers) ProtoMessage() {}

func (x *LeadFormSingleChoiceAnswers) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v6_common_asset_types_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LeadFormSingleChoiceAnswers.ProtoReflect.Descriptor instead.
func (*LeadFormSingleChoiceAnswers) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v6_common_asset_types_proto_rawDescGZIP(), []int{7}
}

func (x *LeadFormSingleChoiceAnswers) GetAnswers() []string {
	if x != nil {
		return x.Answers
	}
	return nil
}

// A configuration of how leads are delivered to the advertiser.
type LeadFormDeliveryMethod struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Various subtypes of delivery.
	//
	// Types that are assignable to DeliveryDetails:
	//	*LeadFormDeliveryMethod_Webhook
	DeliveryDetails isLeadFormDeliveryMethod_DeliveryDetails `protobuf_oneof:"delivery_details"`
}

func (x *LeadFormDeliveryMethod) Reset() {
	*x = LeadFormDeliveryMethod{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v6_common_asset_types_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LeadFormDeliveryMethod) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LeadFormDeliveryMethod) ProtoMessage() {}

func (x *LeadFormDeliveryMethod) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v6_common_asset_types_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LeadFormDeliveryMethod.ProtoReflect.Descriptor instead.
func (*LeadFormDeliveryMethod) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v6_common_asset_types_proto_rawDescGZIP(), []int{8}
}

func (m *LeadFormDeliveryMethod) GetDeliveryDetails() isLeadFormDeliveryMethod_DeliveryDetails {
	if m != nil {
		return m.DeliveryDetails
	}
	return nil
}

func (x *LeadFormDeliveryMethod) GetWebhook() *WebhookDelivery {
	if x, ok := x.GetDeliveryDetails().(*LeadFormDeliveryMethod_Webhook); ok {
		return x.Webhook
	}
	return nil
}

type isLeadFormDeliveryMethod_DeliveryDetails interface {
	isLeadFormDeliveryMethod_DeliveryDetails()
}

type LeadFormDeliveryMethod_Webhook struct {
	// Webhook method of delivery.
	Webhook *WebhookDelivery `protobuf:"bytes,1,opt,name=webhook,proto3,oneof"`
}

func (*LeadFormDeliveryMethod_Webhook) isLeadFormDeliveryMethod_DeliveryDetails() {}

// Google notifies the advertiser of leads by making HTTP calls to an
// endpoint they specify. The requests contain JSON matching a schema that
// Google publishes as part of form ads documentation.
type WebhookDelivery struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Webhook url specified by advertiser to send the lead.
	AdvertiserWebhookUrl *string `protobuf:"bytes,4,opt,name=advertiser_webhook_url,json=advertiserWebhookUrl,proto3,oneof" json:"advertiser_webhook_url,omitempty"`
	// Anti-spoofing secret set by the advertiser as part of the webhook payload.
	GoogleSecret *string `protobuf:"bytes,5,opt,name=google_secret,json=googleSecret,proto3,oneof" json:"google_secret,omitempty"`
	// The schema version that this delivery instance will use.
	PayloadSchemaVersion *int64 `protobuf:"varint,6,opt,name=payload_schema_version,json=payloadSchemaVersion,proto3,oneof" json:"payload_schema_version,omitempty"`
}

func (x *WebhookDelivery) Reset() {
	*x = WebhookDelivery{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v6_common_asset_types_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WebhookDelivery) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WebhookDelivery) ProtoMessage() {}

func (x *WebhookDelivery) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v6_common_asset_types_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WebhookDelivery.ProtoReflect.Descriptor instead.
func (*WebhookDelivery) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v6_common_asset_types_proto_rawDescGZIP(), []int{9}
}

func (x *WebhookDelivery) GetAdvertiserWebhookUrl() string {
	if x != nil && x.AdvertiserWebhookUrl != nil {
		return *x.AdvertiserWebhookUrl
	}
	return ""
}

func (x *WebhookDelivery) GetGoogleSecret() string {
	if x != nil && x.GoogleSecret != nil {
		return *x.GoogleSecret
	}
	return ""
}

func (x *WebhookDelivery) GetPayloadSchemaVersion() int64 {
	if x != nil && x.PayloadSchemaVersion != nil {
		return *x.PayloadSchemaVersion
	}
	return 0
}

// A Book on Google asset. Used to redirect user to book through Google.
// Book on Google will change the redirect url to book directly through
// Google.
type BookOnGoogleAsset struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *BookOnGoogleAsset) Reset() {
	*x = BookOnGoogleAsset{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v6_common_asset_types_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BookOnGoogleAsset) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BookOnGoogleAsset) ProtoMessage() {}

func (x *BookOnGoogleAsset) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v6_common_asset_types_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BookOnGoogleAsset.ProtoReflect.Descriptor instead.
func (*BookOnGoogleAsset) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v6_common_asset_types_proto_rawDescGZIP(), []int{10}
}

var File_google_ads_googleads_v6_common_asset_types_proto protoreflect.FileDescriptor

var file_google_ads_googleads_v6_common_asset_types_proto_rawDesc = []byte{
	0x0a, 0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x36, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e,
	0x2f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x36, 0x2e, 0x63, 0x6f, 0x6d, 0x6d,
	0x6f, 0x6e, 0x1a, 0x41, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x36, 0x2f, 0x65, 0x6e, 0x75, 0x6d,
	0x73, 0x2f, 0x6c, 0x65, 0x61, 0x64, 0x5f, 0x66, 0x6f, 0x72, 0x6d, 0x5f, 0x63, 0x61, 0x6c, 0x6c,
	0x5f, 0x74, 0x6f, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64,
	0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x36, 0x2f, 0x65,
	0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x6c, 0x65, 0x61, 0x64, 0x5f, 0x66, 0x6f, 0x72, 0x6d, 0x5f, 0x64,
	0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x43, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x36, 0x2f, 0x65, 0x6e, 0x75,
	0x6d, 0x73, 0x2f, 0x6c, 0x65, 0x61, 0x64, 0x5f, 0x66, 0x6f, 0x72, 0x6d, 0x5f, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x5f, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x4d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76,
	0x36, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x6c, 0x65, 0x61, 0x64, 0x5f, 0x66, 0x6f, 0x72,
	0x6d, 0x5f, 0x70, 0x6f, 0x73, 0x74, 0x5f, 0x73, 0x75, 0x62, 0x6d, 0x69, 0x74, 0x5f, 0x63, 0x61,
	0x6c, 0x6c, 0x5f, 0x74, 0x6f, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x36,
	0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x6d, 0x69, 0x6d, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f,
	0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x57, 0x0a, 0x11, 0x59, 0x6f, 0x75, 0x74, 0x75, 0x62, 0x65,
	0x56, 0x69, 0x64, 0x65, 0x6f, 0x41, 0x73, 0x73, 0x65, 0x74, 0x12, 0x2d, 0x0a, 0x10, 0x79, 0x6f,
	0x75, 0x74, 0x75, 0x62, 0x65, 0x5f, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x5f, 0x69, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0e, 0x79, 0x6f, 0x75, 0x74, 0x75, 0x62, 0x65, 0x56,
	0x69, 0x64, 0x65, 0x6f, 0x49, 0x64, 0x88, 0x01, 0x01, 0x42, 0x13, 0x0a, 0x11, 0x5f, 0x79, 0x6f,
	0x75, 0x74, 0x75, 0x62, 0x65, 0x5f, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x5f, 0x69, 0x64, 0x22, 0x34,
	0x0a, 0x10, 0x4d, 0x65, 0x64, 0x69, 0x61, 0x42, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x41, 0x73, 0x73,
	0x65, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x64, 0x61, 0x74, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c,
	0x48, 0x00, 0x52, 0x04, 0x64, 0x61, 0x74, 0x61, 0x88, 0x01, 0x01, 0x42, 0x07, 0x0a, 0x05, 0x5f,
	0x64, 0x61, 0x74, 0x61, 0x22, 0xfe, 0x01, 0x0a, 0x0a, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x41, 0x73,
	0x73, 0x65, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x64, 0x61, 0x74, 0x61, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0c, 0x48, 0x00, 0x52, 0x04, 0x64, 0x61, 0x74, 0x61, 0x88, 0x01, 0x01, 0x12, 0x20, 0x0a, 0x09,
	0x66, 0x69, 0x6c, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x03, 0x48,
	0x01, 0x52, 0x08, 0x66, 0x69, 0x6c, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x88, 0x01, 0x01, 0x12, 0x51,
	0x0a, 0x09, 0x6d, 0x69, 0x6d, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x36, 0x2e, 0x65, 0x6e, 0x75, 0x6d,
	0x73, 0x2e, 0x4d, 0x69, 0x6d, 0x65, 0x54, 0x79, 0x70, 0x65, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x4d,
	0x69, 0x6d, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x08, 0x6d, 0x69, 0x6d, 0x65, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x4b, 0x0a, 0x09, 0x66, 0x75, 0x6c, 0x6c, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x36, 0x2e, 0x63,
	0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x44, 0x69, 0x6d, 0x65, 0x6e,
	0x73, 0x69, 0x6f, 0x6e, 0x52, 0x08, 0x66, 0x75, 0x6c, 0x6c, 0x53, 0x69, 0x7a, 0x65, 0x42, 0x07,
	0x0a, 0x05, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x42, 0x0c, 0x0a, 0x0a, 0x5f, 0x66, 0x69, 0x6c, 0x65,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x22, 0xa4, 0x01, 0x0a, 0x0e, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x44,
	0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x28, 0x0a, 0x0d, 0x68, 0x65, 0x69, 0x67,
	0x68, 0x74, 0x5f, 0x70, 0x69, 0x78, 0x65, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x48,
	0x00, 0x52, 0x0c, 0x68, 0x65, 0x69, 0x67, 0x68, 0x74, 0x50, 0x69, 0x78, 0x65, 0x6c, 0x73, 0x88,
	0x01, 0x01, 0x12, 0x26, 0x0a, 0x0c, 0x77, 0x69, 0x64, 0x74, 0x68, 0x5f, 0x70, 0x69, 0x78, 0x65,
	0x6c, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03, 0x48, 0x01, 0x52, 0x0b, 0x77, 0x69, 0x64, 0x74,
	0x68, 0x50, 0x69, 0x78, 0x65, 0x6c, 0x73, 0x88, 0x01, 0x01, 0x12, 0x15, 0x0a, 0x03, 0x75, 0x72,
	0x6c, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x48, 0x02, 0x52, 0x03, 0x75, 0x72, 0x6c, 0x88, 0x01,
	0x01, 0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x68, 0x65, 0x69, 0x67, 0x68, 0x74, 0x5f, 0x70, 0x69, 0x78,
	0x65, 0x6c, 0x73, 0x42, 0x0f, 0x0a, 0x0d, 0x5f, 0x77, 0x69, 0x64, 0x74, 0x68, 0x5f, 0x70, 0x69,
	0x78, 0x65, 0x6c, 0x73, 0x42, 0x06, 0x0a, 0x04, 0x5f, 0x75, 0x72, 0x6c, 0x22, 0x2d, 0x0a, 0x09,
	0x54, 0x65, 0x78, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x74, 0x65, 0x78,
	0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x04, 0x74, 0x65, 0x78, 0x74, 0x88,
	0x01, 0x01, 0x42, 0x07, 0x0a, 0x05, 0x5f, 0x74, 0x65, 0x78, 0x74, 0x22, 0x99, 0x09, 0x0a, 0x0d,
	0x4c, 0x65, 0x61, 0x64, 0x46, 0x6f, 0x72, 0x6d, 0x41, 0x73, 0x73, 0x65, 0x74, 0x12, 0x28, 0x0a,
	0x0d, 0x62, 0x75, 0x73, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x0a,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x62, 0x75, 0x73, 0x69, 0x6e,
	0x65, 0x73, 0x73, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x88, 0x01, 0x0a, 0x13, 0x63, 0x61, 0x6c, 0x6c,
	0x5f, 0x74, 0x6f, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x11, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x54, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x36, 0x2e,
	0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x4c, 0x65, 0x61, 0x64, 0x46, 0x6f, 0x72, 0x6d, 0x43, 0x61,
	0x6c, 0x6c, 0x54, 0x6f, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x45, 0x6e,
	0x75, 0x6d, 0x2e, 0x4c, 0x65, 0x61, 0x64, 0x46, 0x6f, 0x72, 0x6d, 0x43, 0x61, 0x6c, 0x6c, 0x54,
	0x6f, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x10, 0x63, 0x61, 0x6c, 0x6c, 0x54, 0x6f, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x40, 0x0a, 0x1a, 0x63, 0x61, 0x6c, 0x6c, 0x5f, 0x74, 0x6f, 0x5f, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x12, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x17, 0x63, 0x61, 0x6c,
	0x6c, 0x54, 0x6f, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1f, 0x0a, 0x08, 0x68, 0x65, 0x61, 0x64, 0x6c, 0x69, 0x6e, 0x65,
	0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x68, 0x65, 0x61,
	0x64, 0x6c, 0x69, 0x6e, 0x65, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x31, 0x0a, 0x12,
	0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x75,
	0x72, 0x6c, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x10, 0x70,
	0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x55, 0x72, 0x6c, 0x12,
	0x35, 0x0a, 0x14, 0x70, 0x6f, 0x73, 0x74, 0x5f, 0x73, 0x75, 0x62, 0x6d, 0x69, 0x74, 0x5f, 0x68,
	0x65, 0x61, 0x64, 0x6c, 0x69, 0x6e, 0x65, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52,
	0x12, 0x70, 0x6f, 0x73, 0x74, 0x53, 0x75, 0x62, 0x6d, 0x69, 0x74, 0x48, 0x65, 0x61, 0x64, 0x6c,
	0x69, 0x6e, 0x65, 0x88, 0x01, 0x01, 0x12, 0x3b, 0x0a, 0x17, 0x70, 0x6f, 0x73, 0x74, 0x5f, 0x73,
	0x75, 0x62, 0x6d, 0x69, 0x74, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x10, 0x20, 0x01, 0x28, 0x09, 0x48, 0x01, 0x52, 0x15, 0x70, 0x6f, 0x73, 0x74, 0x53,
	0x75, 0x62, 0x6d, 0x69, 0x74, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x88, 0x01, 0x01, 0x12, 0x45, 0x0a, 0x06, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x18, 0x08, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x36, 0x2e, 0x63, 0x6f,
	0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x4c, 0x65, 0x61, 0x64, 0x46, 0x6f, 0x72, 0x6d, 0x46, 0x69, 0x65,
	0x6c, 0x64, 0x52, 0x06, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x12, 0x61, 0x0a, 0x10, 0x64, 0x65,
	0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x5f, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x73, 0x18, 0x09,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x36, 0x2e, 0x63,
	0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x4c, 0x65, 0x61, 0x64, 0x46, 0x6f, 0x72, 0x6d, 0x44, 0x65,
	0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x52, 0x0f, 0x64, 0x65,
	0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x73, 0x12, 0xad, 0x01,
	0x0a, 0x1f, 0x70, 0x6f, 0x73, 0x74, 0x5f, 0x73, 0x75, 0x62, 0x6d, 0x69, 0x74, 0x5f, 0x63, 0x61,
	0x6c, 0x6c, 0x5f, 0x74, 0x6f, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x13, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x68, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76,
	0x36, 0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x4c, 0x65, 0x61, 0x64, 0x46, 0x6f, 0x72, 0x6d,
	0x50, 0x6f, 0x73, 0x74, 0x53, 0x75, 0x62, 0x6d, 0x69, 0x74, 0x43, 0x61, 0x6c, 0x6c, 0x54, 0x6f,
	0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x4c,
	0x65, 0x61, 0x64, 0x46, 0x6f, 0x72, 0x6d, 0x50, 0x6f, 0x73, 0x74, 0x53, 0x75, 0x62, 0x6d, 0x69,
	0x74, 0x43, 0x61, 0x6c, 0x6c, 0x54, 0x6f, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70,
	0x65, 0x52, 0x1a, 0x70, 0x6f, 0x73, 0x74, 0x53, 0x75, 0x62, 0x6d, 0x69, 0x74, 0x43, 0x61, 0x6c,
	0x6c, 0x54, 0x6f, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x39, 0x0a,
	0x16, 0x62, 0x61, 0x63, 0x6b, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x5f, 0x69, 0x6d, 0x61, 0x67,
	0x65, 0x5f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x18, 0x14, 0x20, 0x01, 0x28, 0x09, 0x48, 0x02, 0x52,
	0x14, 0x62, 0x61, 0x63, 0x6b, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x49, 0x6d, 0x61, 0x67, 0x65,
	0x41, 0x73, 0x73, 0x65, 0x74, 0x88, 0x01, 0x01, 0x12, 0x75, 0x0a, 0x0e, 0x64, 0x65, 0x73, 0x69,
	0x72, 0x65, 0x64, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x15, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x4e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x36, 0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73,
	0x2e, 0x4c, 0x65, 0x61, 0x64, 0x46, 0x6f, 0x72, 0x6d, 0x44, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64,
	0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x4c, 0x65, 0x61, 0x64, 0x46,
	0x6f, 0x72, 0x6d, 0x44, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x52, 0x0d, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12,
	0x30, 0x0a, 0x11, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x64, 0x69, 0x73, 0x63, 0x6c, 0x6f,
	0x73, 0x75, 0x72, 0x65, 0x18, 0x16, 0x20, 0x01, 0x28, 0x09, 0x48, 0x03, 0x52, 0x10, 0x63, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x73, 0x63, 0x6c, 0x6f, 0x73, 0x75, 0x72, 0x65, 0x88, 0x01,
	0x01, 0x42, 0x17, 0x0a, 0x15, 0x5f, 0x70, 0x6f, 0x73, 0x74, 0x5f, 0x73, 0x75, 0x62, 0x6d, 0x69,
	0x74, 0x5f, 0x68, 0x65, 0x61, 0x64, 0x6c, 0x69, 0x6e, 0x65, 0x42, 0x1a, 0x0a, 0x18, 0x5f, 0x70,
	0x6f, 0x73, 0x74, 0x5f, 0x73, 0x75, 0x62, 0x6d, 0x69, 0x74, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x19, 0x0a, 0x17, 0x5f, 0x62, 0x61, 0x63, 0x6b, 0x67,
	0x72, 0x6f, 0x75, 0x6e, 0x64, 0x5f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x61, 0x73, 0x73, 0x65,
	0x74, 0x42, 0x14, 0x0a, 0x12, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x64, 0x69, 0x73,
	0x63, 0x6c, 0x6f, 0x73, 0x75, 0x72, 0x65, 0x22, 0x86, 0x02, 0x0a, 0x0d, 0x4c, 0x65, 0x61, 0x64,
	0x46, 0x6f, 0x72, 0x6d, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x12, 0x77, 0x0a, 0x0a, 0x69, 0x6e, 0x70,
	0x75, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x58, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x36, 0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x4c, 0x65,
	0x61, 0x64, 0x46, 0x6f, 0x72, 0x6d, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x55, 0x73, 0x65, 0x72, 0x49,
	0x6e, 0x70, 0x75, 0x74, 0x54, 0x79, 0x70, 0x65, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x4c, 0x65, 0x61,
	0x64, 0x46, 0x6f, 0x72, 0x6d, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x55, 0x73, 0x65, 0x72, 0x49, 0x6e,
	0x70, 0x75, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x09, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x71, 0x0a, 0x15, 0x73, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x5f, 0x63, 0x68, 0x6f,
	0x69, 0x63, 0x65, 0x5f, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x36, 0x2e, 0x63, 0x6f, 0x6d, 0x6d,
	0x6f, 0x6e, 0x2e, 0x4c, 0x65, 0x61, 0x64, 0x46, 0x6f, 0x72, 0x6d, 0x53, 0x69, 0x6e, 0x67, 0x6c,
	0x65, 0x43, 0x68, 0x6f, 0x69, 0x63, 0x65, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x73, 0x48, 0x00,
	0x52, 0x13, 0x73, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x43, 0x68, 0x6f, 0x69, 0x63, 0x65, 0x41, 0x6e,
	0x73, 0x77, 0x65, 0x72, 0x73, 0x42, 0x09, 0x0a, 0x07, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x73,
	0x22, 0x37, 0x0a, 0x1b, 0x4c, 0x65, 0x61, 0x64, 0x46, 0x6f, 0x72, 0x6d, 0x53, 0x69, 0x6e, 0x67,
	0x6c, 0x65, 0x43, 0x68, 0x6f, 0x69, 0x63, 0x65, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x73, 0x12,
	0x18, 0x0a, 0x07, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x07, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x73, 0x22, 0x79, 0x0a, 0x16, 0x4c, 0x65, 0x61,
	0x64, 0x46, 0x6f, 0x72, 0x6d, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x4d, 0x65, 0x74,
	0x68, 0x6f, 0x64, 0x12, 0x4b, 0x0a, 0x07, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x36, 0x2e, 0x63,
	0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x44, 0x65, 0x6c,
	0x69, 0x76, 0x65, 0x72, 0x79, 0x48, 0x00, 0x52, 0x07, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b,
	0x42, 0x12, 0x0a, 0x10, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x5f, 0x64, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x73, 0x22, 0xf9, 0x01, 0x0a, 0x0f, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b,
	0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x12, 0x39, 0x0a, 0x16, 0x61, 0x64, 0x76, 0x65,
	0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x5f, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x5f, 0x75,
	0x72, 0x6c, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x14, 0x61, 0x64, 0x76, 0x65,
	0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x55, 0x72, 0x6c,
	0x88, 0x01, 0x01, 0x12, 0x28, 0x0a, 0x0d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5f, 0x73, 0x65,
	0x63, 0x72, 0x65, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x48, 0x01, 0x52, 0x0c, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x88, 0x01, 0x01, 0x12, 0x39, 0x0a,
	0x16, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x5f,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x03, 0x48, 0x02, 0x52,
	0x14, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x42, 0x19, 0x0a, 0x17, 0x5f, 0x61, 0x64, 0x76,
	0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x72, 0x5f, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x5f,
	0x75, 0x72, 0x6c, 0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5f, 0x73,
	0x65, 0x63, 0x72, 0x65, 0x74, 0x42, 0x19, 0x0a, 0x17, 0x5f, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61,
	0x64, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x22, 0x13, 0x0a, 0x11, 0x42, 0x6f, 0x6f, 0x6b, 0x4f, 0x6e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x41, 0x73, 0x73, 0x65, 0x74, 0x42, 0xea, 0x01, 0x0a, 0x22, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x64, 0x73, 0x2e, 0x76, 0x36, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x42, 0x0f, 0x41, 0x73,
	0x73, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a,
	0x44, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f,
	0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x36, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x3b, 0x63,
	0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0xa2, 0x02, 0x03, 0x47, 0x41, 0x41, 0xaa, 0x02, 0x1e, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x41, 0x64, 0x73, 0x2e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41,
	0x64, 0x73, 0x2e, 0x56, 0x36, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0xca, 0x02, 0x1e, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x41, 0x64, 0x73, 0x5c, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x41, 0x64, 0x73, 0x5c, 0x56, 0x36, 0x5c, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0xea, 0x02, 0x22,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x41, 0x64, 0x73, 0x3a, 0x3a, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x3a, 0x3a, 0x56, 0x36, 0x3a, 0x3a, 0x43, 0x6f, 0x6d, 0x6d,
	0x6f, 0x6e, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_ads_googleads_v6_common_asset_types_proto_rawDescOnce sync.Once
	file_google_ads_googleads_v6_common_asset_types_proto_rawDescData = file_google_ads_googleads_v6_common_asset_types_proto_rawDesc
)

func file_google_ads_googleads_v6_common_asset_types_proto_rawDescGZIP() []byte {
	file_google_ads_googleads_v6_common_asset_types_proto_rawDescOnce.Do(func() {
		file_google_ads_googleads_v6_common_asset_types_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_ads_googleads_v6_common_asset_types_proto_rawDescData)
	})
	return file_google_ads_googleads_v6_common_asset_types_proto_rawDescData
}

var file_google_ads_googleads_v6_common_asset_types_proto_msgTypes = make([]protoimpl.MessageInfo, 11)
var file_google_ads_googleads_v6_common_asset_types_proto_goTypes = []interface{}{
	(*YoutubeVideoAsset)(nil),           // 0: google.ads.googleads.v6.common.YoutubeVideoAsset
	(*MediaBundleAsset)(nil),            // 1: google.ads.googleads.v6.common.MediaBundleAsset
	(*ImageAsset)(nil),                  // 2: google.ads.googleads.v6.common.ImageAsset
	(*ImageDimension)(nil),              // 3: google.ads.googleads.v6.common.ImageDimension
	(*TextAsset)(nil),                   // 4: google.ads.googleads.v6.common.TextAsset
	(*LeadFormAsset)(nil),               // 5: google.ads.googleads.v6.common.LeadFormAsset
	(*LeadFormField)(nil),               // 6: google.ads.googleads.v6.common.LeadFormField
	(*LeadFormSingleChoiceAnswers)(nil), // 7: google.ads.googleads.v6.common.LeadFormSingleChoiceAnswers
	(*LeadFormDeliveryMethod)(nil),      // 8: google.ads.googleads.v6.common.LeadFormDeliveryMethod
	(*WebhookDelivery)(nil),             // 9: google.ads.googleads.v6.common.WebhookDelivery
	(*BookOnGoogleAsset)(nil),           // 10: google.ads.googleads.v6.common.BookOnGoogleAsset
	(enums.MimeTypeEnum_MimeType)(0),    // 11: google.ads.googleads.v6.enums.MimeTypeEnum.MimeType
	(enums.LeadFormCallToActionTypeEnum_LeadFormCallToActionType)(0),                     // 12: google.ads.googleads.v6.enums.LeadFormCallToActionTypeEnum.LeadFormCallToActionType
	(enums.LeadFormPostSubmitCallToActionTypeEnum_LeadFormPostSubmitCallToActionType)(0), // 13: google.ads.googleads.v6.enums.LeadFormPostSubmitCallToActionTypeEnum.LeadFormPostSubmitCallToActionType
	(enums.LeadFormDesiredIntentEnum_LeadFormDesiredIntent)(0),                           // 14: google.ads.googleads.v6.enums.LeadFormDesiredIntentEnum.LeadFormDesiredIntent
	(enums.LeadFormFieldUserInputTypeEnum_LeadFormFieldUserInputType)(0),                 // 15: google.ads.googleads.v6.enums.LeadFormFieldUserInputTypeEnum.LeadFormFieldUserInputType
}
var file_google_ads_googleads_v6_common_asset_types_proto_depIdxs = []int32{
	11, // 0: google.ads.googleads.v6.common.ImageAsset.mime_type:type_name -> google.ads.googleads.v6.enums.MimeTypeEnum.MimeType
	3,  // 1: google.ads.googleads.v6.common.ImageAsset.full_size:type_name -> google.ads.googleads.v6.common.ImageDimension
	12, // 2: google.ads.googleads.v6.common.LeadFormAsset.call_to_action_type:type_name -> google.ads.googleads.v6.enums.LeadFormCallToActionTypeEnum.LeadFormCallToActionType
	6,  // 3: google.ads.googleads.v6.common.LeadFormAsset.fields:type_name -> google.ads.googleads.v6.common.LeadFormField
	8,  // 4: google.ads.googleads.v6.common.LeadFormAsset.delivery_methods:type_name -> google.ads.googleads.v6.common.LeadFormDeliveryMethod
	13, // 5: google.ads.googleads.v6.common.LeadFormAsset.post_submit_call_to_action_type:type_name -> google.ads.googleads.v6.enums.LeadFormPostSubmitCallToActionTypeEnum.LeadFormPostSubmitCallToActionType
	14, // 6: google.ads.googleads.v6.common.LeadFormAsset.desired_intent:type_name -> google.ads.googleads.v6.enums.LeadFormDesiredIntentEnum.LeadFormDesiredIntent
	15, // 7: google.ads.googleads.v6.common.LeadFormField.input_type:type_name -> google.ads.googleads.v6.enums.LeadFormFieldUserInputTypeEnum.LeadFormFieldUserInputType
	7,  // 8: google.ads.googleads.v6.common.LeadFormField.single_choice_answers:type_name -> google.ads.googleads.v6.common.LeadFormSingleChoiceAnswers
	9,  // 9: google.ads.googleads.v6.common.LeadFormDeliveryMethod.webhook:type_name -> google.ads.googleads.v6.common.WebhookDelivery
	10, // [10:10] is the sub-list for method output_type
	10, // [10:10] is the sub-list for method input_type
	10, // [10:10] is the sub-list for extension type_name
	10, // [10:10] is the sub-list for extension extendee
	0,  // [0:10] is the sub-list for field type_name
}

func init() { file_google_ads_googleads_v6_common_asset_types_proto_init() }
func file_google_ads_googleads_v6_common_asset_types_proto_init() {
	if File_google_ads_googleads_v6_common_asset_types_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_ads_googleads_v6_common_asset_types_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*YoutubeVideoAsset); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v6_common_asset_types_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MediaBundleAsset); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v6_common_asset_types_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImageAsset); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v6_common_asset_types_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImageDimension); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v6_common_asset_types_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TextAsset); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v6_common_asset_types_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LeadFormAsset); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v6_common_asset_types_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LeadFormField); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v6_common_asset_types_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LeadFormSingleChoiceAnswers); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v6_common_asset_types_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LeadFormDeliveryMethod); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v6_common_asset_types_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WebhookDelivery); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v6_common_asset_types_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BookOnGoogleAsset); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_ads_googleads_v6_common_asset_types_proto_msgTypes[0].OneofWrappers = []interface{}{}
	file_google_ads_googleads_v6_common_asset_types_proto_msgTypes[1].OneofWrappers = []interface{}{}
	file_google_ads_googleads_v6_common_asset_types_proto_msgTypes[2].OneofWrappers = []interface{}{}
	file_google_ads_googleads_v6_common_asset_types_proto_msgTypes[3].OneofWrappers = []interface{}{}
	file_google_ads_googleads_v6_common_asset_types_proto_msgTypes[4].OneofWrappers = []interface{}{}
	file_google_ads_googleads_v6_common_asset_types_proto_msgTypes[5].OneofWrappers = []interface{}{}
	file_google_ads_googleads_v6_common_asset_types_proto_msgTypes[6].OneofWrappers = []interface{}{
		(*LeadFormField_SingleChoiceAnswers)(nil),
	}
	file_google_ads_googleads_v6_common_asset_types_proto_msgTypes[8].OneofWrappers = []interface{}{
		(*LeadFormDeliveryMethod_Webhook)(nil),
	}
	file_google_ads_googleads_v6_common_asset_types_proto_msgTypes[9].OneofWrappers = []interface{}{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_ads_googleads_v6_common_asset_types_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   11,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_ads_googleads_v6_common_asset_types_proto_goTypes,
		DependencyIndexes: file_google_ads_googleads_v6_common_asset_types_proto_depIdxs,
		MessageInfos:      file_google_ads_googleads_v6_common_asset_types_proto_msgTypes,
	}.Build()
	File_google_ads_googleads_v6_common_asset_types_proto = out.File
	file_google_ads_googleads_v6_common_asset_types_proto_rawDesc = nil
	file_google_ads_googleads_v6_common_asset_types_proto_goTypes = nil
	file_google_ads_googleads_v6_common_asset_types_proto_depIdxs = nil
}
