// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package resourcegroupstaggingapi

import (
	"fmt"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opDescribeReportCreation = "DescribeReportCreation"

// DescribeReportCreationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeReportCreation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeReportCreation for more information on using the DescribeReportCreation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeReportCreationRequest method.
//    req, resp := client.DescribeReportCreationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resourcegroupstaggingapi-2017-01-26/DescribeReportCreation
func (c *ResourceGroupsTaggingAPI) DescribeReportCreationRequest(input *DescribeReportCreationInput) (req *request.Request, output *DescribeReportCreationOutput) {
	op := &request.Operation{
		Name:       opDescribeReportCreation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeReportCreationInput{}
	}

	output = &DescribeReportCreationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeReportCreation API operation for AWS Resource Groups Tagging API.
//
// Describes the status of the StartReportCreation operation.
//
// You can call this operation only from the organization's master account and
// from the us-east-1 Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Groups Tagging API's
// API operation DescribeReportCreation for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeConstraintViolationException "ConstraintViolationException"
//   The request was denied because performing this operation violates a constraint.
//
//   Some of the reasons in the following list might not apply to this specific
//   operation.
//
//      * You must meet the prerequisites for using tag policies. For information,
//      see Prerequisites and Permissions for Using Tag Policies (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies-prereqs.html)
//      in the AWS Organizations User Guide.
//
//      * You must enable the tag policies service principal (tagpolicies.tag.amazonaws.com)
//      to integrate with AWS Organizations For information, see EnableAWSServiceAccess
//      (http://docs.aws.amazon.com/organizations/latest/APIReference/API_EnableAWSServiceAccess.html).
//
//      * You must have a tag policy attached to the organization root, an OU,
//      or an account.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The request processing failed because of an unknown error, exception, or
//   failure. You can retry the request.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This error indicates one of the following:
//
//      * A parameter is missing.
//
//      * A malformed string was supplied for the request parameter.
//
//      * An out-of-range value was supplied for the request parameter.
//
//      * The target ID is invalid, unsupported, or doesn't exist.
//
//      * You can't access the Amazon S3 bucket for report storage. For more information,
//      see Additional Requirements for Organization-wide Tag Compliance Reports
//      (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies-prereqs.html#bucket-policies-org-report)
//      in the AWS Organizations User Guide.
//
//   * ErrCodeThrottledException "ThrottledException"
//   The request was denied to limit the frequency of submitted requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resourcegroupstaggingapi-2017-01-26/DescribeReportCreation
func (c *ResourceGroupsTaggingAPI) DescribeReportCreation(input *DescribeReportCreationInput) (*DescribeReportCreationOutput, error) {
	req, out := c.DescribeReportCreationRequest(input)
	return out, req.Send()
}

// DescribeReportCreationWithContext is the same as DescribeReportCreation with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeReportCreation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResourceGroupsTaggingAPI) DescribeReportCreationWithContext(ctx aws.Context, input *DescribeReportCreationInput, opts ...request.Option) (*DescribeReportCreationOutput, error) {
	req, out := c.DescribeReportCreationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetComplianceSummary = "GetComplianceSummary"

// GetComplianceSummaryRequest generates a "aws/request.Request" representing the
// client's request for the GetComplianceSummary operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetComplianceSummary for more information on using the GetComplianceSummary
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetComplianceSummaryRequest method.
//    req, resp := client.GetComplianceSummaryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resourcegroupstaggingapi-2017-01-26/GetComplianceSummary
func (c *ResourceGroupsTaggingAPI) GetComplianceSummaryRequest(input *GetComplianceSummaryInput) (req *request.Request, output *GetComplianceSummaryOutput) {
	op := &request.Operation{
		Name:       opGetComplianceSummary,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"PaginationToken"},
			OutputTokens:    []string{"PaginationToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetComplianceSummaryInput{}
	}

	output = &GetComplianceSummaryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetComplianceSummary API operation for AWS Resource Groups Tagging API.
//
// Returns a table that shows counts of resources that are noncompliant with
// their tag policies.
//
// For more information on tag policies, see Tag Policies (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html)
// in the AWS Organizations User Guide.
//
// You can call this operation only from the organization's master account and
// from the us-east-1 Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Groups Tagging API's
// API operation GetComplianceSummary for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeConstraintViolationException "ConstraintViolationException"
//   The request was denied because performing this operation violates a constraint.
//
//   Some of the reasons in the following list might not apply to this specific
//   operation.
//
//      * You must meet the prerequisites for using tag policies. For information,
//      see Prerequisites and Permissions for Using Tag Policies (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies-prereqs.html)
//      in the AWS Organizations User Guide.
//
//      * You must enable the tag policies service principal (tagpolicies.tag.amazonaws.com)
//      to integrate with AWS Organizations For information, see EnableAWSServiceAccess
//      (http://docs.aws.amazon.com/organizations/latest/APIReference/API_EnableAWSServiceAccess.html).
//
//      * You must have a tag policy attached to the organization root, an OU,
//      or an account.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The request processing failed because of an unknown error, exception, or
//   failure. You can retry the request.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This error indicates one of the following:
//
//      * A parameter is missing.
//
//      * A malformed string was supplied for the request parameter.
//
//      * An out-of-range value was supplied for the request parameter.
//
//      * The target ID is invalid, unsupported, or doesn't exist.
//
//      * You can't access the Amazon S3 bucket for report storage. For more information,
//      see Additional Requirements for Organization-wide Tag Compliance Reports
//      (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies-prereqs.html#bucket-policies-org-report)
//      in the AWS Organizations User Guide.
//
//   * ErrCodeThrottledException "ThrottledException"
//   The request was denied to limit the frequency of submitted requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resourcegroupstaggingapi-2017-01-26/GetComplianceSummary
func (c *ResourceGroupsTaggingAPI) GetComplianceSummary(input *GetComplianceSummaryInput) (*GetComplianceSummaryOutput, error) {
	req, out := c.GetComplianceSummaryRequest(input)
	return out, req.Send()
}

// GetComplianceSummaryWithContext is the same as GetComplianceSummary with the addition of
// the ability to pass a context and additional request options.
//
// See GetComplianceSummary for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResourceGroupsTaggingAPI) GetComplianceSummaryWithContext(ctx aws.Context, input *GetComplianceSummaryInput, opts ...request.Option) (*GetComplianceSummaryOutput, error) {
	req, out := c.GetComplianceSummaryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetComplianceSummaryPages iterates over the pages of a GetComplianceSummary operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetComplianceSummary method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetComplianceSummary operation.
//    pageNum := 0
//    err := client.GetComplianceSummaryPages(params,
//        func(page *resourcegroupstaggingapi.GetComplianceSummaryOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ResourceGroupsTaggingAPI) GetComplianceSummaryPages(input *GetComplianceSummaryInput, fn func(*GetComplianceSummaryOutput, bool) bool) error {
	return c.GetComplianceSummaryPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetComplianceSummaryPagesWithContext same as GetComplianceSummaryPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResourceGroupsTaggingAPI) GetComplianceSummaryPagesWithContext(ctx aws.Context, input *GetComplianceSummaryInput, fn func(*GetComplianceSummaryOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetComplianceSummaryInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetComplianceSummaryRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetComplianceSummaryOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetResources = "GetResources"

// GetResourcesRequest generates a "aws/request.Request" representing the
// client's request for the GetResources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetResources for more information on using the GetResources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetResourcesRequest method.
//    req, resp := client.GetResourcesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resourcegroupstaggingapi-2017-01-26/GetResources
func (c *ResourceGroupsTaggingAPI) GetResourcesRequest(input *GetResourcesInput) (req *request.Request, output *GetResourcesOutput) {
	op := &request.Operation{
		Name:       opGetResources,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"PaginationToken"},
			OutputTokens:    []string{"PaginationToken"},
			LimitToken:      "ResourcesPerPage",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetResourcesInput{}
	}

	output = &GetResourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetResources API operation for AWS Resource Groups Tagging API.
//
// Returns all the tagged or previously tagged resources that are located in
// the specified Region for the AWS account.
//
// Depending on what information you want returned, you can also specify the
// following:
//
//    * Filters that specify what tags and resource types you want returned.
//    The response includes all tags that are associated with the requested
//    resources.
//
//    * Information about compliance with the account's effective tag policy.
//    For more information on tag policies, see Tag Policies (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html)
//    in the AWS Organizations User Guide.
//
// You can check the PaginationToken response parameter to determine if a query
// is complete. Queries occasionally return fewer results on a page than allowed.
// The PaginationToken response parameter value is null only when there are
// no more results to display.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Groups Tagging API's
// API operation GetResources for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This error indicates one of the following:
//
//      * A parameter is missing.
//
//      * A malformed string was supplied for the request parameter.
//
//      * An out-of-range value was supplied for the request parameter.
//
//      * The target ID is invalid, unsupported, or doesn't exist.
//
//      * You can't access the Amazon S3 bucket for report storage. For more information,
//      see Additional Requirements for Organization-wide Tag Compliance Reports
//      (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies-prereqs.html#bucket-policies-org-report)
//      in the AWS Organizations User Guide.
//
//   * ErrCodeThrottledException "ThrottledException"
//   The request was denied to limit the frequency of submitted requests.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The request processing failed because of an unknown error, exception, or
//   failure. You can retry the request.
//
//   * ErrCodePaginationTokenExpiredException "PaginationTokenExpiredException"
//   A PaginationToken is valid for a maximum of 15 minutes. Your request was
//   denied because the specified PaginationToken has expired.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resourcegroupstaggingapi-2017-01-26/GetResources
func (c *ResourceGroupsTaggingAPI) GetResources(input *GetResourcesInput) (*GetResourcesOutput, error) {
	req, out := c.GetResourcesRequest(input)
	return out, req.Send()
}

// GetResourcesWithContext is the same as GetResources with the addition of
// the ability to pass a context and additional request options.
//
// See GetResources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResourceGroupsTaggingAPI) GetResourcesWithContext(ctx aws.Context, input *GetResourcesInput, opts ...request.Option) (*GetResourcesOutput, error) {
	req, out := c.GetResourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetResourcesPages iterates over the pages of a GetResources operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetResources method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetResources operation.
//    pageNum := 0
//    err := client.GetResourcesPages(params,
//        func(page *resourcegroupstaggingapi.GetResourcesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ResourceGroupsTaggingAPI) GetResourcesPages(input *GetResourcesInput, fn func(*GetResourcesOutput, bool) bool) error {
	return c.GetResourcesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetResourcesPagesWithContext same as GetResourcesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResourceGroupsTaggingAPI) GetResourcesPagesWithContext(ctx aws.Context, input *GetResourcesInput, fn func(*GetResourcesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetResourcesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetResourcesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetResourcesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetTagKeys = "GetTagKeys"

// GetTagKeysRequest generates a "aws/request.Request" representing the
// client's request for the GetTagKeys operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTagKeys for more information on using the GetTagKeys
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetTagKeysRequest method.
//    req, resp := client.GetTagKeysRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resourcegroupstaggingapi-2017-01-26/GetTagKeys
func (c *ResourceGroupsTaggingAPI) GetTagKeysRequest(input *GetTagKeysInput) (req *request.Request, output *GetTagKeysOutput) {
	op := &request.Operation{
		Name:       opGetTagKeys,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"PaginationToken"},
			OutputTokens:    []string{"PaginationToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetTagKeysInput{}
	}

	output = &GetTagKeysOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTagKeys API operation for AWS Resource Groups Tagging API.
//
// Returns all tag keys in the specified Region for the AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Groups Tagging API's
// API operation GetTagKeys for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This error indicates one of the following:
//
//      * A parameter is missing.
//
//      * A malformed string was supplied for the request parameter.
//
//      * An out-of-range value was supplied for the request parameter.
//
//      * The target ID is invalid, unsupported, or doesn't exist.
//
//      * You can't access the Amazon S3 bucket for report storage. For more information,
//      see Additional Requirements for Organization-wide Tag Compliance Reports
//      (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies-prereqs.html#bucket-policies-org-report)
//      in the AWS Organizations User Guide.
//
//   * ErrCodeThrottledException "ThrottledException"
//   The request was denied to limit the frequency of submitted requests.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The request processing failed because of an unknown error, exception, or
//   failure. You can retry the request.
//
//   * ErrCodePaginationTokenExpiredException "PaginationTokenExpiredException"
//   A PaginationToken is valid for a maximum of 15 minutes. Your request was
//   denied because the specified PaginationToken has expired.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resourcegroupstaggingapi-2017-01-26/GetTagKeys
func (c *ResourceGroupsTaggingAPI) GetTagKeys(input *GetTagKeysInput) (*GetTagKeysOutput, error) {
	req, out := c.GetTagKeysRequest(input)
	return out, req.Send()
}

// GetTagKeysWithContext is the same as GetTagKeys with the addition of
// the ability to pass a context and additional request options.
//
// See GetTagKeys for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResourceGroupsTaggingAPI) GetTagKeysWithContext(ctx aws.Context, input *GetTagKeysInput, opts ...request.Option) (*GetTagKeysOutput, error) {
	req, out := c.GetTagKeysRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetTagKeysPages iterates over the pages of a GetTagKeys operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetTagKeys method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetTagKeys operation.
//    pageNum := 0
//    err := client.GetTagKeysPages(params,
//        func(page *resourcegroupstaggingapi.GetTagKeysOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ResourceGroupsTaggingAPI) GetTagKeysPages(input *GetTagKeysInput, fn func(*GetTagKeysOutput, bool) bool) error {
	return c.GetTagKeysPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetTagKeysPagesWithContext same as GetTagKeysPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResourceGroupsTaggingAPI) GetTagKeysPagesWithContext(ctx aws.Context, input *GetTagKeysInput, fn func(*GetTagKeysOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetTagKeysInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetTagKeysRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetTagKeysOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetTagValues = "GetTagValues"

// GetTagValuesRequest generates a "aws/request.Request" representing the
// client's request for the GetTagValues operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTagValues for more information on using the GetTagValues
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetTagValuesRequest method.
//    req, resp := client.GetTagValuesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resourcegroupstaggingapi-2017-01-26/GetTagValues
func (c *ResourceGroupsTaggingAPI) GetTagValuesRequest(input *GetTagValuesInput) (req *request.Request, output *GetTagValuesOutput) {
	op := &request.Operation{
		Name:       opGetTagValues,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"PaginationToken"},
			OutputTokens:    []string{"PaginationToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetTagValuesInput{}
	}

	output = &GetTagValuesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTagValues API operation for AWS Resource Groups Tagging API.
//
// Returns all tag values for the specified key in the specified Region for
// the AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Groups Tagging API's
// API operation GetTagValues for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This error indicates one of the following:
//
//      * A parameter is missing.
//
//      * A malformed string was supplied for the request parameter.
//
//      * An out-of-range value was supplied for the request parameter.
//
//      * The target ID is invalid, unsupported, or doesn't exist.
//
//      * You can't access the Amazon S3 bucket for report storage. For more information,
//      see Additional Requirements for Organization-wide Tag Compliance Reports
//      (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies-prereqs.html#bucket-policies-org-report)
//      in the AWS Organizations User Guide.
//
//   * ErrCodeThrottledException "ThrottledException"
//   The request was denied to limit the frequency of submitted requests.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The request processing failed because of an unknown error, exception, or
//   failure. You can retry the request.
//
//   * ErrCodePaginationTokenExpiredException "PaginationTokenExpiredException"
//   A PaginationToken is valid for a maximum of 15 minutes. Your request was
//   denied because the specified PaginationToken has expired.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resourcegroupstaggingapi-2017-01-26/GetTagValues
func (c *ResourceGroupsTaggingAPI) GetTagValues(input *GetTagValuesInput) (*GetTagValuesOutput, error) {
	req, out := c.GetTagValuesRequest(input)
	return out, req.Send()
}

// GetTagValuesWithContext is the same as GetTagValues with the addition of
// the ability to pass a context and additional request options.
//
// See GetTagValues for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResourceGroupsTaggingAPI) GetTagValuesWithContext(ctx aws.Context, input *GetTagValuesInput, opts ...request.Option) (*GetTagValuesOutput, error) {
	req, out := c.GetTagValuesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetTagValuesPages iterates over the pages of a GetTagValues operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetTagValues method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetTagValues operation.
//    pageNum := 0
//    err := client.GetTagValuesPages(params,
//        func(page *resourcegroupstaggingapi.GetTagValuesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ResourceGroupsTaggingAPI) GetTagValuesPages(input *GetTagValuesInput, fn func(*GetTagValuesOutput, bool) bool) error {
	return c.GetTagValuesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetTagValuesPagesWithContext same as GetTagValuesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResourceGroupsTaggingAPI) GetTagValuesPagesWithContext(ctx aws.Context, input *GetTagValuesInput, fn func(*GetTagValuesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetTagValuesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetTagValuesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetTagValuesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opStartReportCreation = "StartReportCreation"

// StartReportCreationRequest generates a "aws/request.Request" representing the
// client's request for the StartReportCreation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartReportCreation for more information on using the StartReportCreation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartReportCreationRequest method.
//    req, resp := client.StartReportCreationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resourcegroupstaggingapi-2017-01-26/StartReportCreation
func (c *ResourceGroupsTaggingAPI) StartReportCreationRequest(input *StartReportCreationInput) (req *request.Request, output *StartReportCreationOutput) {
	op := &request.Operation{
		Name:       opStartReportCreation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartReportCreationInput{}
	}

	output = &StartReportCreationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StartReportCreation API operation for AWS Resource Groups Tagging API.
//
// Generates a report that lists all tagged resources in accounts across your
// organization and tells whether each resource is compliant with the effective
// tag policy. Compliance data is refreshed daily.
//
// The generated report is saved to the following location:
//
// s3://example-bucket/AwsTagPolicies/o-exampleorgid/YYYY-MM-ddTHH:mm:ssZ/report.csv
//
// You can call this operation only from the organization's master account and
// from the us-east-1 Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Groups Tagging API's
// API operation StartReportCreation for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeConcurrentModificationException "ConcurrentModificationException"
//   The target of the operation is currently being modified by a different request.
//   Try again later.
//
//   * ErrCodeConstraintViolationException "ConstraintViolationException"
//   The request was denied because performing this operation violates a constraint.
//
//   Some of the reasons in the following list might not apply to this specific
//   operation.
//
//      * You must meet the prerequisites for using tag policies. For information,
//      see Prerequisites and Permissions for Using Tag Policies (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies-prereqs.html)
//      in the AWS Organizations User Guide.
//
//      * You must enable the tag policies service principal (tagpolicies.tag.amazonaws.com)
//      to integrate with AWS Organizations For information, see EnableAWSServiceAccess
//      (http://docs.aws.amazon.com/organizations/latest/APIReference/API_EnableAWSServiceAccess.html).
//
//      * You must have a tag policy attached to the organization root, an OU,
//      or an account.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The request processing failed because of an unknown error, exception, or
//   failure. You can retry the request.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This error indicates one of the following:
//
//      * A parameter is missing.
//
//      * A malformed string was supplied for the request parameter.
//
//      * An out-of-range value was supplied for the request parameter.
//
//      * The target ID is invalid, unsupported, or doesn't exist.
//
//      * You can't access the Amazon S3 bucket for report storage. For more information,
//      see Additional Requirements for Organization-wide Tag Compliance Reports
//      (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies-prereqs.html#bucket-policies-org-report)
//      in the AWS Organizations User Guide.
//
//   * ErrCodeThrottledException "ThrottledException"
//   The request was denied to limit the frequency of submitted requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resourcegroupstaggingapi-2017-01-26/StartReportCreation
func (c *ResourceGroupsTaggingAPI) StartReportCreation(input *StartReportCreationInput) (*StartReportCreationOutput, error) {
	req, out := c.StartReportCreationRequest(input)
	return out, req.Send()
}

// StartReportCreationWithContext is the same as StartReportCreation with the addition of
// the ability to pass a context and additional request options.
//
// See StartReportCreation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResourceGroupsTaggingAPI) StartReportCreationWithContext(ctx aws.Context, input *StartReportCreationInput, opts ...request.Option) (*StartReportCreationOutput, error) {
	req, out := c.StartReportCreationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResources = "TagResources"

// TagResourcesRequest generates a "aws/request.Request" representing the
// client's request for the TagResources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResources for more information on using the TagResources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourcesRequest method.
//    req, resp := client.TagResourcesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resourcegroupstaggingapi-2017-01-26/TagResources
func (c *ResourceGroupsTaggingAPI) TagResourcesRequest(input *TagResourcesInput) (req *request.Request, output *TagResourcesOutput) {
	op := &request.Operation{
		Name:       opTagResources,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourcesInput{}
	}

	output = &TagResourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// TagResources API operation for AWS Resource Groups Tagging API.
//
// Applies one or more tags to the specified resources. Note the following:
//
//    * Not all resources can have tags. For a list of services that support
//    tagging, see this list (http://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/Welcome.html).
//
//    * Each resource can have up to 50 tags. For other limits, see Tag Naming
//    and Usage Conventions (http://docs.aws.amazon.com/general/latest/gr/aws_tagging.html#tag-conventions)
//    in the AWS General Reference.
//
//    * You can only tag resources that are located in the specified Region
//    for the AWS account.
//
//    * To add tags to a resource, you need the necessary permissions for the
//    service that the resource belongs to as well as permissions for adding
//    tags. For more information, see this list (http://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/Welcome.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Groups Tagging API's
// API operation TagResources for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This error indicates one of the following:
//
//      * A parameter is missing.
//
//      * A malformed string was supplied for the request parameter.
//
//      * An out-of-range value was supplied for the request parameter.
//
//      * The target ID is invalid, unsupported, or doesn't exist.
//
//      * You can't access the Amazon S3 bucket for report storage. For more information,
//      see Additional Requirements for Organization-wide Tag Compliance Reports
//      (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies-prereqs.html#bucket-policies-org-report)
//      in the AWS Organizations User Guide.
//
//   * ErrCodeThrottledException "ThrottledException"
//   The request was denied to limit the frequency of submitted requests.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The request processing failed because of an unknown error, exception, or
//   failure. You can retry the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resourcegroupstaggingapi-2017-01-26/TagResources
func (c *ResourceGroupsTaggingAPI) TagResources(input *TagResourcesInput) (*TagResourcesOutput, error) {
	req, out := c.TagResourcesRequest(input)
	return out, req.Send()
}

// TagResourcesWithContext is the same as TagResources with the addition of
// the ability to pass a context and additional request options.
//
// See TagResources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResourceGroupsTaggingAPI) TagResourcesWithContext(ctx aws.Context, input *TagResourcesInput, opts ...request.Option) (*TagResourcesOutput, error) {
	req, out := c.TagResourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResources = "UntagResources"

// UntagResourcesRequest generates a "aws/request.Request" representing the
// client's request for the UntagResources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResources for more information on using the UntagResources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourcesRequest method.
//    req, resp := client.UntagResourcesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resourcegroupstaggingapi-2017-01-26/UntagResources
func (c *ResourceGroupsTaggingAPI) UntagResourcesRequest(input *UntagResourcesInput) (req *request.Request, output *UntagResourcesOutput) {
	op := &request.Operation{
		Name:       opUntagResources,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourcesInput{}
	}

	output = &UntagResourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UntagResources API operation for AWS Resource Groups Tagging API.
//
// Removes the specified tags from the specified resources. When you specify
// a tag key, the action removes both that key and its associated value. The
// operation succeeds even if you attempt to remove tags from a resource that
// were already removed. Note the following:
//
//    * To remove tags from a resource, you need the necessary permissions for
//    the service that the resource belongs to as well as permissions for removing
//    tags. For more information, see this list (http://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/Welcome.html).
//
//    * You can only tag resources that are located in the specified Region
//    for the AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Groups Tagging API's
// API operation UntagResources for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   This error indicates one of the following:
//
//      * A parameter is missing.
//
//      * A malformed string was supplied for the request parameter.
//
//      * An out-of-range value was supplied for the request parameter.
//
//      * The target ID is invalid, unsupported, or doesn't exist.
//
//      * You can't access the Amazon S3 bucket for report storage. For more information,
//      see Additional Requirements for Organization-wide Tag Compliance Reports
//      (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies-prereqs.html#bucket-policies-org-report)
//      in the AWS Organizations User Guide.
//
//   * ErrCodeThrottledException "ThrottledException"
//   The request was denied to limit the frequency of submitted requests.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The request processing failed because of an unknown error, exception, or
//   failure. You can retry the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resourcegroupstaggingapi-2017-01-26/UntagResources
func (c *ResourceGroupsTaggingAPI) UntagResources(input *UntagResourcesInput) (*UntagResourcesOutput, error) {
	req, out := c.UntagResourcesRequest(input)
	return out, req.Send()
}

// UntagResourcesWithContext is the same as UntagResources with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResourceGroupsTaggingAPI) UntagResourcesWithContext(ctx aws.Context, input *UntagResourcesInput, opts ...request.Option) (*UntagResourcesOutput, error) {
	req, out := c.UntagResourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Information that shows whether a resource is compliant with the effective
// tag policy, including details on any noncompliant tag keys.
type ComplianceDetails struct {
	_ struct{} `type:"structure"`

	// Whether a resource is compliant with the effective tag policy.
	ComplianceStatus *bool `type:"boolean"`

	// The tag value is noncompliant with the effective tag policy.
	KeysWithNoncompliantValues []*string `type:"list"`

	// The tag key is noncompliant with the effective tag policy.
	NoncompliantKeys []*string `type:"list"`
}

// String returns the string representation
func (s ComplianceDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ComplianceDetails) GoString() string {
	return s.String()
}

// SetComplianceStatus sets the ComplianceStatus field's value.
func (s *ComplianceDetails) SetComplianceStatus(v bool) *ComplianceDetails {
	s.ComplianceStatus = &v
	return s
}

// SetKeysWithNoncompliantValues sets the KeysWithNoncompliantValues field's value.
func (s *ComplianceDetails) SetKeysWithNoncompliantValues(v []*string) *ComplianceDetails {
	s.KeysWithNoncompliantValues = v
	return s
}

// SetNoncompliantKeys sets the NoncompliantKeys field's value.
func (s *ComplianceDetails) SetNoncompliantKeys(v []*string) *ComplianceDetails {
	s.NoncompliantKeys = v
	return s
}

type DescribeReportCreationInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DescribeReportCreationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeReportCreationInput) GoString() string {
	return s.String()
}

type DescribeReportCreationOutput struct {
	_ struct{} `type:"structure"`

	// Details of the common errors that all operations return.
	ErrorMessage *string `type:"string"`

	// The path to the Amazon S3 bucket where the report was stored on creation.
	S3Location *string `type:"string"`

	// Reports the status of the operation.
	//
	// The operation status can be one of the following:
	//
	//    * RUNNING - Report creation is in progress.
	//
	//    * SUCCEEDED - Report creation is complete. You can open the report from
	//    the Amazon S3 bucket that you specified when you ran StartReportCreation.
	//
	//    * FAILED - Report creation timed out or the Amazon S3 bucket is not accessible.
	//
	//    * NO REPORT - No report was generated in the last 90 days.
	Status *string `type:"string"`
}

// String returns the string representation
func (s DescribeReportCreationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeReportCreationOutput) GoString() string {
	return s.String()
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *DescribeReportCreationOutput) SetErrorMessage(v string) *DescribeReportCreationOutput {
	s.ErrorMessage = &v
	return s
}

// SetS3Location sets the S3Location field's value.
func (s *DescribeReportCreationOutput) SetS3Location(v string) *DescribeReportCreationOutput {
	s.S3Location = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeReportCreationOutput) SetStatus(v string) *DescribeReportCreationOutput {
	s.Status = &v
	return s
}

// Details of the common errors that all actions return.
type FailureInfo struct {
	_ struct{} `type:"structure"`

	// The code of the common error. Valid values include InternalServiceException,
	// InvalidParameterException, and any valid error code returned by the AWS service
	// that hosts the resource that you want to tag.
	ErrorCode *string `type:"string" enum:"ErrorCode"`

	// The message of the common error.
	ErrorMessage *string `type:"string"`

	// The HTTP status code of the common error.
	StatusCode *int64 `type:"integer"`
}

// String returns the string representation
func (s FailureInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FailureInfo) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *FailureInfo) SetErrorCode(v string) *FailureInfo {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *FailureInfo) SetErrorMessage(v string) *FailureInfo {
	s.ErrorMessage = &v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *FailureInfo) SetStatusCode(v int64) *FailureInfo {
	s.StatusCode = &v
	return s
}

type GetComplianceSummaryInput struct {
	_ struct{} `type:"structure"`

	// A list of attributes to group the counts of noncompliant resources by. If
	// supplied, the counts are sorted by those attributes.
	GroupBy []*string `type:"list"`

	// A limit that restricts the number of results that are returned per page.
	MaxResults *int64 `min:"1" type:"integer"`

	// A string that indicates that additional data is available. Leave this value
	// empty for your initial request. If the response includes a PaginationToken,
	// use that string for this value to request an additional page of data.
	PaginationToken *string `type:"string"`

	// A list of Regions to limit the output by. If you use this parameter, the
	// count of returned noncompliant resources includes only resources in the specified
	// Regions.
	RegionFilters []*string `min:"1" type:"list"`

	// The constraints on the resources that you want returned. The format of each
	// resource type is service[:resourceType]. For example, specifying a resource
	// type of ec2 returns all Amazon EC2 resources (which includes EC2 instances).
	// Specifying a resource type of ec2:instance returns only EC2 instances.
	//
	// The string for each service name and resource type is the same as that embedded
	// in a resource's Amazon Resource Name (ARN). Consult the AWS General Reference
	// for the following:
	//
	//    * For a list of service name strings, see AWS Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces).
	//
	//    * For resource type strings, see Example ARNs (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arns-syntax).
	//
	//    * For more information about ARNs, see Amazon Resource Names (ARNs) and
	//    AWS Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
	//
	// You can specify multiple resource types by using an array. The array can
	// include up to 100 items. Note that the length constraint requirement applies
	// to each resource type filter.
	ResourceTypeFilters []*string `type:"list"`

	// A list of tag keys to limit the output by. If you use this parameter, the
	// count of returned noncompliant resources includes only resources that have
	// the specified tag keys.
	TagKeyFilters []*string `min:"1" type:"list"`

	// The target identifiers (usually, specific account IDs) to limit the output
	// by. If you use this parameter, the count of returned noncompliant resources
	// includes only resources with the specified target IDs.
	TargetIdFilters []*string `min:"1" type:"list"`
}

// String returns the string representation
func (s GetComplianceSummaryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetComplianceSummaryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetComplianceSummaryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetComplianceSummaryInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.RegionFilters != nil && len(s.RegionFilters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RegionFilters", 1))
	}
	if s.TagKeyFilters != nil && len(s.TagKeyFilters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKeyFilters", 1))
	}
	if s.TargetIdFilters != nil && len(s.TargetIdFilters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TargetIdFilters", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupBy sets the GroupBy field's value.
func (s *GetComplianceSummaryInput) SetGroupBy(v []*string) *GetComplianceSummaryInput {
	s.GroupBy = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetComplianceSummaryInput) SetMaxResults(v int64) *GetComplianceSummaryInput {
	s.MaxResults = &v
	return s
}

// SetPaginationToken sets the PaginationToken field's value.
func (s *GetComplianceSummaryInput) SetPaginationToken(v string) *GetComplianceSummaryInput {
	s.PaginationToken = &v
	return s
}

// SetRegionFilters sets the RegionFilters field's value.
func (s *GetComplianceSummaryInput) SetRegionFilters(v []*string) *GetComplianceSummaryInput {
	s.RegionFilters = v
	return s
}

// SetResourceTypeFilters sets the ResourceTypeFilters field's value.
func (s *GetComplianceSummaryInput) SetResourceTypeFilters(v []*string) *GetComplianceSummaryInput {
	s.ResourceTypeFilters = v
	return s
}

// SetTagKeyFilters sets the TagKeyFilters field's value.
func (s *GetComplianceSummaryInput) SetTagKeyFilters(v []*string) *GetComplianceSummaryInput {
	s.TagKeyFilters = v
	return s
}

// SetTargetIdFilters sets the TargetIdFilters field's value.
func (s *GetComplianceSummaryInput) SetTargetIdFilters(v []*string) *GetComplianceSummaryInput {
	s.TargetIdFilters = v
	return s
}

type GetComplianceSummaryOutput struct {
	_ struct{} `type:"structure"`

	// A string that indicates that the response contains more data than can be
	// returned in a single response. To receive additional data, specify this string
	// for the PaginationToken value in a subsequent request.
	PaginationToken *string `type:"string"`

	// A table that shows counts of noncompliant resources.
	SummaryList []*Summary `type:"list"`
}

// String returns the string representation
func (s GetComplianceSummaryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetComplianceSummaryOutput) GoString() string {
	return s.String()
}

// SetPaginationToken sets the PaginationToken field's value.
func (s *GetComplianceSummaryOutput) SetPaginationToken(v string) *GetComplianceSummaryOutput {
	s.PaginationToken = &v
	return s
}

// SetSummaryList sets the SummaryList field's value.
func (s *GetComplianceSummaryOutput) SetSummaryList(v []*Summary) *GetComplianceSummaryOutput {
	s.SummaryList = v
	return s
}

type GetResourcesInput struct {
	_ struct{} `type:"structure"`

	// Specifies whether to exclude resources that are compliant with the tag policy.
	// Set this to true if you are interested in retrieving information on noncompliant
	// resources only.
	//
	// You can use this parameter only if the IncludeComplianceDetails parameter
	// is also set to true.
	ExcludeCompliantResources *bool `type:"boolean"`

	// Specifies whether to include details regarding the compliance with the effective
	// tag policy. Set this to true to determine whether resources are compliant
	// with the tag policy and to get details.
	IncludeComplianceDetails *bool `type:"boolean"`

	// A string that indicates that additional data is available. Leave this value
	// empty for your initial request. If the response includes a PaginationToken,
	// use that string for this value to request an additional page of data.
	PaginationToken *string `type:"string"`

	// The constraints on the resources that you want returned. The format of each
	// resource type is service[:resourceType]. For example, specifying a resource
	// type of ec2 returns all Amazon EC2 resources (which includes EC2 instances).
	// Specifying a resource type of ec2:instance returns only EC2 instances.
	//
	// The string for each service name and resource type is the same as that embedded
	// in a resource's Amazon Resource Name (ARN). Consult the AWS General Reference
	// for the following:
	//
	//    * For a list of service name strings, see AWS Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces).
	//
	//    * For resource type strings, see Example ARNs (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arns-syntax).
	//
	//    * For more information about ARNs, see Amazon Resource Names (ARNs) and
	//    AWS Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
	//
	// You can specify multiple resource types by using an array. The array can
	// include up to 100 items. Note that the length constraint requirement applies
	// to each resource type filter.
	ResourceTypeFilters []*string `type:"list"`

	// A limit that restricts the number of resources returned by GetResources in
	// paginated output. You can set ResourcesPerPage to a minimum of 1 item and
	// the maximum of 100 items.
	ResourcesPerPage *int64 `type:"integer"`

	// A list of TagFilters (keys and values). Each TagFilter specified must contain
	// a key with values as optional. A request can include up to 50 keys, and each
	// key can include up to 20 values.
	//
	// Note the following when deciding how to use TagFilters:
	//
	//    * If you do specify a TagFilter, the response returns only those resources
	//    that are currently associated with the specified tag.
	//
	//    * If you don't specify a TagFilter, the response includes all resources
	//    that were ever associated with tags. Resources that currently don't have
	//    associated tags are shown with an empty tag set, like this: "Tags": [].
	//
	//    * If you specify more than one filter in a single request, the response
	//    returns only those resources that satisfy all specified filters.
	//
	//    * If you specify a filter that contains more than one value for a key,
	//    the response returns resources that match any of the specified values
	//    for that key.
	//
	//    * If you don't specify any values for a key, the response returns resources
	//    that are tagged with that key irrespective of the value. For example,
	//    for filters: filter1 = {key1, {value1}}, filter2 = {key2, {value2,value3,value4}}
	//    , filter3 = {key3}: GetResources( {filter1} ) returns resources tagged
	//    with key1=value1 GetResources( {filter2} ) returns resources tagged with
	//    key2=value2 or key2=value3 or key2=value4 GetResources( {filter3} ) returns
	//    resources tagged with any tag containing key3 as its tag key, irrespective
	//    of its value GetResources( {filter1,filter2,filter3} ) returns resources
	//    tagged with ( key1=value1) and ( key2=value2 or key2=value3 or key2=value4)
	//    and (key3, irrespective of the value)
	TagFilters []*TagFilter `type:"list"`

	// AWS recommends using ResourcesPerPage instead of this parameter.
	//
	// A limit that restricts the number of tags (key and value pairs) returned
	// by GetResources in paginated output. A resource with no tags is counted as
	// having one tag (one key and value pair).
	//
	// GetResources does not split a resource and its associated tags across pages.
	// If the specified TagsPerPage would cause such a break, a PaginationToken
	// is returned in place of the affected resource and its tags. Use that token
	// in another request to get the remaining data. For example, if you specify
	// a TagsPerPage of 100 and the account has 22 resources with 10 tags each (meaning
	// that each resource has 10 key and value pairs), the output will consist of
	// three pages. The first page displays the first 10 resources, each with its
	// 10 tags. The second page displays the next 10 resources, each with its 10
	// tags. The third page displays the remaining 2 resources, each with its 10
	// tags.
	//
	// You can set TagsPerPage to a minimum of 100 items and the maximum of 500
	// items.
	TagsPerPage *int64 `type:"integer"`
}

// String returns the string representation
func (s GetResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetResourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetResourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetResourcesInput"}
	if s.TagFilters != nil {
		for i, v := range s.TagFilters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TagFilters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExcludeCompliantResources sets the ExcludeCompliantResources field's value.
func (s *GetResourcesInput) SetExcludeCompliantResources(v bool) *GetResourcesInput {
	s.ExcludeCompliantResources = &v
	return s
}

// SetIncludeComplianceDetails sets the IncludeComplianceDetails field's value.
func (s *GetResourcesInput) SetIncludeComplianceDetails(v bool) *GetResourcesInput {
	s.IncludeComplianceDetails = &v
	return s
}

// SetPaginationToken sets the PaginationToken field's value.
func (s *GetResourcesInput) SetPaginationToken(v string) *GetResourcesInput {
	s.PaginationToken = &v
	return s
}

// SetResourceTypeFilters sets the ResourceTypeFilters field's value.
func (s *GetResourcesInput) SetResourceTypeFilters(v []*string) *GetResourcesInput {
	s.ResourceTypeFilters = v
	return s
}

// SetResourcesPerPage sets the ResourcesPerPage field's value.
func (s *GetResourcesInput) SetResourcesPerPage(v int64) *GetResourcesInput {
	s.ResourcesPerPage = &v
	return s
}

// SetTagFilters sets the TagFilters field's value.
func (s *GetResourcesInput) SetTagFilters(v []*TagFilter) *GetResourcesInput {
	s.TagFilters = v
	return s
}

// SetTagsPerPage sets the TagsPerPage field's value.
func (s *GetResourcesInput) SetTagsPerPage(v int64) *GetResourcesInput {
	s.TagsPerPage = &v
	return s
}

type GetResourcesOutput struct {
	_ struct{} `type:"structure"`

	// A string that indicates that the response contains more data than can be
	// returned in a single response. To receive additional data, specify this string
	// for the PaginationToken value in a subsequent request.
	PaginationToken *string `type:"string"`

	// A list of resource ARNs and the tags (keys and values) associated with each.
	ResourceTagMappingList []*ResourceTagMapping `type:"list"`
}

// String returns the string representation
func (s GetResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetResourcesOutput) GoString() string {
	return s.String()
}

// SetPaginationToken sets the PaginationToken field's value.
func (s *GetResourcesOutput) SetPaginationToken(v string) *GetResourcesOutput {
	s.PaginationToken = &v
	return s
}

// SetResourceTagMappingList sets the ResourceTagMappingList field's value.
func (s *GetResourcesOutput) SetResourceTagMappingList(v []*ResourceTagMapping) *GetResourcesOutput {
	s.ResourceTagMappingList = v
	return s
}

type GetTagKeysInput struct {
	_ struct{} `type:"structure"`

	// A string that indicates that additional data is available. Leave this value
	// empty for your initial request. If the response includes a PaginationToken,
	// use that string for this value to request an additional page of data.
	PaginationToken *string `type:"string"`
}

// String returns the string representation
func (s GetTagKeysInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTagKeysInput) GoString() string {
	return s.String()
}

// SetPaginationToken sets the PaginationToken field's value.
func (s *GetTagKeysInput) SetPaginationToken(v string) *GetTagKeysInput {
	s.PaginationToken = &v
	return s
}

type GetTagKeysOutput struct {
	_ struct{} `type:"structure"`

	// A string that indicates that the response contains more data than can be
	// returned in a single response. To receive additional data, specify this string
	// for the PaginationToken value in a subsequent request.
	PaginationToken *string `type:"string"`

	// A list of all tag keys in the AWS account.
	TagKeys []*string `type:"list"`
}

// String returns the string representation
func (s GetTagKeysOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTagKeysOutput) GoString() string {
	return s.String()
}

// SetPaginationToken sets the PaginationToken field's value.
func (s *GetTagKeysOutput) SetPaginationToken(v string) *GetTagKeysOutput {
	s.PaginationToken = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *GetTagKeysOutput) SetTagKeys(v []*string) *GetTagKeysOutput {
	s.TagKeys = v
	return s
}

type GetTagValuesInput struct {
	_ struct{} `type:"structure"`

	// The key for which you want to list all existing values in the specified Region
	// for the AWS account.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// A string that indicates that additional data is available. Leave this value
	// empty for your initial request. If the response includes a PaginationToken,
	// use that string for this value to request an additional page of data.
	PaginationToken *string `type:"string"`
}

// String returns the string representation
func (s GetTagValuesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTagValuesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTagValuesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTagValuesInput"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *GetTagValuesInput) SetKey(v string) *GetTagValuesInput {
	s.Key = &v
	return s
}

// SetPaginationToken sets the PaginationToken field's value.
func (s *GetTagValuesInput) SetPaginationToken(v string) *GetTagValuesInput {
	s.PaginationToken = &v
	return s
}

type GetTagValuesOutput struct {
	_ struct{} `type:"structure"`

	// A string that indicates that the response contains more data than can be
	// returned in a single response. To receive additional data, specify this string
	// for the PaginationToken value in a subsequent request.
	PaginationToken *string `type:"string"`

	// A list of all tag values for the specified key in the AWS account.
	TagValues []*string `type:"list"`
}

// String returns the string representation
func (s GetTagValuesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTagValuesOutput) GoString() string {
	return s.String()
}

// SetPaginationToken sets the PaginationToken field's value.
func (s *GetTagValuesOutput) SetPaginationToken(v string) *GetTagValuesOutput {
	s.PaginationToken = &v
	return s
}

// SetTagValues sets the TagValues field's value.
func (s *GetTagValuesOutput) SetTagValues(v []*string) *GetTagValuesOutput {
	s.TagValues = v
	return s
}

// A list of resource ARNs and the tags (keys and values) that are associated
// with each.
type ResourceTagMapping struct {
	_ struct{} `type:"structure"`

	// Information that shows whether a resource is compliant with the effective
	// tag policy, including details on any noncompliant tag keys.
	ComplianceDetails *ComplianceDetails `type:"structure"`

	// The ARN of the resource.
	ResourceARN *string `min:"1" type:"string"`

	// The tags that have been applied to one or more AWS resources.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s ResourceTagMapping) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceTagMapping) GoString() string {
	return s.String()
}

// SetComplianceDetails sets the ComplianceDetails field's value.
func (s *ResourceTagMapping) SetComplianceDetails(v *ComplianceDetails) *ResourceTagMapping {
	s.ComplianceDetails = v
	return s
}

// SetResourceARN sets the ResourceARN field's value.
func (s *ResourceTagMapping) SetResourceARN(v string) *ResourceTagMapping {
	s.ResourceARN = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ResourceTagMapping) SetTags(v []*Tag) *ResourceTagMapping {
	s.Tags = v
	return s
}

type StartReportCreationInput struct {
	_ struct{} `type:"structure"`

	// The name of the Amazon S3 bucket where the report will be stored; for example:
	//
	// awsexamplebucket
	//
	// For more information on S3 bucket requirements, including an example bucket
	// policy, see the example S3 bucket policy on this page.
	//
	// S3Bucket is a required field
	S3Bucket *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s StartReportCreationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartReportCreationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartReportCreationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartReportCreationInput"}
	if s.S3Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Bucket"))
	}
	if s.S3Bucket != nil && len(*s.S3Bucket) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("S3Bucket", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3Bucket sets the S3Bucket field's value.
func (s *StartReportCreationInput) SetS3Bucket(v string) *StartReportCreationInput {
	s.S3Bucket = &v
	return s
}

type StartReportCreationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StartReportCreationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartReportCreationOutput) GoString() string {
	return s.String()
}

// A count of noncompliant resources.
type Summary struct {
	_ struct{} `type:"structure"`

	// The timestamp that shows when this summary was generated in this Region.
	LastUpdated *string `type:"string"`

	// The count of noncompliant resources.
	NonCompliantResources *int64 `type:"long"`

	// The AWS Region that the summary applies to.
	Region *string `min:"1" type:"string"`

	// The AWS resource type.
	ResourceType *string `type:"string"`

	// The account identifier or the root identifier of the organization. If you
	// don't know the root ID, you can call the AWS Organizations ListRoots (http://docs.aws.amazon.com/organizations/latest/APIReference/API_ListRoots.html)
	// API.
	TargetId *string `min:"6" type:"string"`

	// Whether the target is an account, an OU, or the organization root.
	TargetIdType *string `type:"string" enum:"TargetIdType"`
}

// String returns the string representation
func (s Summary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Summary) GoString() string {
	return s.String()
}

// SetLastUpdated sets the LastUpdated field's value.
func (s *Summary) SetLastUpdated(v string) *Summary {
	s.LastUpdated = &v
	return s
}

// SetNonCompliantResources sets the NonCompliantResources field's value.
func (s *Summary) SetNonCompliantResources(v int64) *Summary {
	s.NonCompliantResources = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *Summary) SetRegion(v string) *Summary {
	s.Region = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *Summary) SetResourceType(v string) *Summary {
	s.ResourceType = &v
	return s
}

// SetTargetId sets the TargetId field's value.
func (s *Summary) SetTargetId(v string) *Summary {
	s.TargetId = &v
	return s
}

// SetTargetIdType sets the TargetIdType field's value.
func (s *Summary) SetTargetIdType(v string) *Summary {
	s.TargetIdType = &v
	return s
}

// The metadata that you apply to AWS resources to help you categorize and organize
// them. Each tag consists of a key and an optional value, both of which you
// define. For more information, see Tagging AWS Resources (http://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
// in the AWS General Reference.
type Tag struct {
	_ struct{} `type:"structure"`

	// One part of a key-value pair that makes up a tag. A key is a general label
	// that acts like a category for more specific tag values.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The optional part of a key-value pair that make up a tag. A value acts as
	// a descriptor within a tag category (key).
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

// A list of tags (keys and values) that are used to specify the associated
// resources.
type TagFilter struct {
	_ struct{} `type:"structure"`

	// One part of a key-value pair that makes up a tag. A key is a general label
	// that acts like a category for more specific tag values.
	Key *string `min:"1" type:"string"`

	// The optional part of a key-value pair that make up a tag. A value acts as
	// a descriptor within a tag category (key).
	Values []*string `type:"list"`
}

// String returns the string representation
func (s TagFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagFilter"}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *TagFilter) SetKey(v string) *TagFilter {
	s.Key = &v
	return s
}

// SetValues sets the Values field's value.
func (s *TagFilter) SetValues(v []*string) *TagFilter {
	s.Values = v
	return s
}

type TagResourcesInput struct {
	_ struct{} `type:"structure"`

	// A list of ARNs. An ARN (Amazon Resource Name) uniquely identifies a resource.
	// You can specify a minimum of 1 and a maximum of 20 ARNs (resources) to tag.
	// An ARN can be set to a maximum of 1600 characters. For more information,
	// see Amazon Resource Names (ARNs) and AWS Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the AWS General Reference.
	//
	// ResourceARNList is a required field
	ResourceARNList []*string `min:"1" type:"list" required:"true"`

	// The tags that you want to add to the specified resources. A tag consists
	// of a key and a value that you define.
	//
	// Tags is a required field
	Tags map[string]*string `min:"1" type:"map" required:"true"`
}

// String returns the string representation
func (s TagResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourcesInput"}
	if s.ResourceARNList == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARNList"))
	}
	if s.ResourceARNList != nil && len(s.ResourceARNList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARNList", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARNList sets the ResourceARNList field's value.
func (s *TagResourcesInput) SetResourceARNList(v []*string) *TagResourcesInput {
	s.ResourceARNList = v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourcesInput) SetTags(v map[string]*string) *TagResourcesInput {
	s.Tags = v
	return s
}

type TagResourcesOutput struct {
	_ struct{} `type:"structure"`

	// Details of resources that could not be tagged. An error code, status code,
	// and error message are returned for each failed item.
	FailedResourcesMap map[string]*FailureInfo `type:"map"`
}

// String returns the string representation
func (s TagResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourcesOutput) GoString() string {
	return s.String()
}

// SetFailedResourcesMap sets the FailedResourcesMap field's value.
func (s *TagResourcesOutput) SetFailedResourcesMap(v map[string]*FailureInfo) *TagResourcesOutput {
	s.FailedResourcesMap = v
	return s
}

type UntagResourcesInput struct {
	_ struct{} `type:"structure"`

	// A list of ARNs. An ARN (Amazon Resource Name) uniquely identifies a resource.
	// You can specify a minimum of 1 and a maximum of 20 ARNs (resources) to untag.
	// An ARN can be set to a maximum of 1600 characters. For more information,
	// see Amazon Resource Names (ARNs) and AWS Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the AWS General Reference.
	//
	// ResourceARNList is a required field
	ResourceARNList []*string `min:"1" type:"list" required:"true"`

	// A list of the tag keys that you want to remove from the specified resources.
	//
	// TagKeys is a required field
	TagKeys []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s UntagResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourcesInput"}
	if s.ResourceARNList == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARNList"))
	}
	if s.ResourceARNList != nil && len(s.ResourceARNList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARNList", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}
	if s.TagKeys != nil && len(s.TagKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKeys", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARNList sets the ResourceARNList field's value.
func (s *UntagResourcesInput) SetResourceARNList(v []*string) *UntagResourcesInput {
	s.ResourceARNList = v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourcesInput) SetTagKeys(v []*string) *UntagResourcesInput {
	s.TagKeys = v
	return s
}

type UntagResourcesOutput struct {
	_ struct{} `type:"structure"`

	// Details of resources that could not be untagged. An error code, status code,
	// and error message are returned for each failed item.
	FailedResourcesMap map[string]*FailureInfo `type:"map"`
}

// String returns the string representation
func (s UntagResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourcesOutput) GoString() string {
	return s.String()
}

// SetFailedResourcesMap sets the FailedResourcesMap field's value.
func (s *UntagResourcesOutput) SetFailedResourcesMap(v map[string]*FailureInfo) *UntagResourcesOutput {
	s.FailedResourcesMap = v
	return s
}

const (
	// ErrorCodeInternalServiceException is a ErrorCode enum value
	ErrorCodeInternalServiceException = "InternalServiceException"

	// ErrorCodeInvalidParameterException is a ErrorCode enum value
	ErrorCodeInvalidParameterException = "InvalidParameterException"
)

const (
	// GroupByAttributeTargetId is a GroupByAttribute enum value
	GroupByAttributeTargetId = "TARGET_ID"

	// GroupByAttributeRegion is a GroupByAttribute enum value
	GroupByAttributeRegion = "REGION"

	// GroupByAttributeResourceType is a GroupByAttribute enum value
	GroupByAttributeResourceType = "RESOURCE_TYPE"
)

const (
	// TargetIdTypeAccount is a TargetIdType enum value
	TargetIdTypeAccount = "ACCOUNT"

	// TargetIdTypeOu is a TargetIdType enum value
	TargetIdTypeOu = "OU"

	// TargetIdTypeRoot is a TargetIdType enum value
	TargetIdTypeRoot = "ROOT"
)
