package commitmentplansapi

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/preview/machinelearning/mgmt/2016-05-01-preview/commitmentplans"
	"github.com/Azure/go-autorest/autorest"
)

// SkusClientAPI contains the set of methods on the SkusClient type.
type SkusClientAPI interface {
	List(ctx context.Context) (result commitmentplans.SkuListResult, err error)
}

var _ SkusClientAPI = (*commitmentplans.SkusClient)(nil)

// CommitmentAssociationsClientAPI contains the set of methods on the CommitmentAssociationsClient type.
type CommitmentAssociationsClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, commitmentPlanName string, commitmentAssociationName string) (result commitmentplans.CommitmentAssociation, err error)
	List(ctx context.Context, resourceGroupName string, commitmentPlanName string, skipToken string) (result commitmentplans.CommitmentAssociationListResultPage, err error)
	Move(ctx context.Context, resourceGroupName string, commitmentPlanName string, commitmentAssociationName string, movePayload commitmentplans.MoveCommitmentAssociationRequest) (result commitmentplans.CommitmentAssociation, err error)
}

var _ CommitmentAssociationsClientAPI = (*commitmentplans.CommitmentAssociationsClient)(nil)

// ClientAPI contains the set of methods on the Client type.
type ClientAPI interface {
	CreateOrUpdate(ctx context.Context, createOrUpdatePayload commitmentplans.CommitmentPlan, resourceGroupName string, commitmentPlanName string) (result commitmentplans.CommitmentPlan, err error)
	Get(ctx context.Context, resourceGroupName string, commitmentPlanName string) (result commitmentplans.CommitmentPlan, err error)
	List(ctx context.Context, skipToken string) (result commitmentplans.ListResultPage, err error)
	ListInResourceGroup(ctx context.Context, resourceGroupName string, skipToken string) (result commitmentplans.ListResultPage, err error)
	Patch(ctx context.Context, patchPayload commitmentplans.PatchPayload, resourceGroupName string, commitmentPlanName string) (result commitmentplans.CommitmentPlan, err error)
	Remove(ctx context.Context, resourceGroupName string, commitmentPlanName string) (result autorest.Response, err error)
}

var _ ClientAPI = (*commitmentplans.Client)(nil)

// UsageHistoryClientAPI contains the set of methods on the UsageHistoryClient type.
type UsageHistoryClientAPI interface {
	List(ctx context.Context, resourceGroupName string, commitmentPlanName string, skipToken string) (result commitmentplans.PlanUsageHistoryListResultPage, err error)
}

var _ UsageHistoryClientAPI = (*commitmentplans.UsageHistoryClient)(nil)
