// +build go1.9

// Copyright 2018 Microsoft Corporation
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/tools/profileBuilder

package web

import (
	"context"

	original "github.com/Azure/azure-sdk-for-go/services/preview/web/mgmt/2015-08-01-preview/web"
)

type CertificateOrdersClient = original.CertificateOrdersClient
type CertificatesClient = original.CertificatesClient
type ClassicMobileServicesClient = original.ClassicMobileServicesClient

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type BaseClient = original.BaseClient
type ConnectionsClient = original.ConnectionsClient
type DomainsClient = original.DomainsClient
type GlobalClient = original.GlobalClient
type GlobalCertificateOrderClient = original.GlobalCertificateOrderClient
type GlobalDomainRegistrationClient = original.GlobalDomainRegistrationClient
type GlobalResourceGroupsClient = original.GlobalResourceGroupsClient
type HostingEnvironmentsClient = original.HostingEnvironmentsClient
type ManagedApisClient = original.ManagedApisClient
type ManagedHostingEnvironmentsClient = original.ManagedHostingEnvironmentsClient
type AccessControlEntryAction = original.AccessControlEntryAction

const (
	Deny   AccessControlEntryAction = original.Deny
	Permit AccessControlEntryAction = original.Permit
)

type AutoHealActionType = original.AutoHealActionType

const (
	CustomAction AutoHealActionType = original.CustomAction
	LogEvent     AutoHealActionType = original.LogEvent
	Recycle      AutoHealActionType = original.Recycle
)

type AzureResourceType = original.AzureResourceType

const (
	TrafficManager AzureResourceType = original.TrafficManager
	Website        AzureResourceType = original.Website
)

type BackupItemStatus = original.BackupItemStatus

const (
	Created            BackupItemStatus = original.Created
	Deleted            BackupItemStatus = original.Deleted
	DeleteFailed       BackupItemStatus = original.DeleteFailed
	DeleteInProgress   BackupItemStatus = original.DeleteInProgress
	Failed             BackupItemStatus = original.Failed
	InProgress         BackupItemStatus = original.InProgress
	PartiallySucceeded BackupItemStatus = original.PartiallySucceeded
	Skipped            BackupItemStatus = original.Skipped
	Succeeded          BackupItemStatus = original.Succeeded
	TimedOut           BackupItemStatus = original.TimedOut
)

type BackupRestoreOperationType = original.BackupRestoreOperationType

const (
	Clone      BackupRestoreOperationType = original.Clone
	Default    BackupRestoreOperationType = original.Default
	Relocation BackupRestoreOperationType = original.Relocation
)

type BuiltInAuthenticationProvider = original.BuiltInAuthenticationProvider

const (
	AzureActiveDirectory BuiltInAuthenticationProvider = original.AzureActiveDirectory
	Facebook             BuiltInAuthenticationProvider = original.Facebook
	Google               BuiltInAuthenticationProvider = original.Google
	MicrosoftAccount     BuiltInAuthenticationProvider = original.MicrosoftAccount
	Twitter              BuiltInAuthenticationProvider = original.Twitter
)

type CertificateOrderActionType = original.CertificateOrderActionType

const (
	CertificateIssued        CertificateOrderActionType = original.CertificateIssued
	CertificateOrderCanceled CertificateOrderActionType = original.CertificateOrderCanceled
	CertificateOrderCreated  CertificateOrderActionType = original.CertificateOrderCreated
	CertificateRevoked       CertificateOrderActionType = original.CertificateRevoked
	DomainValidationComplete CertificateOrderActionType = original.DomainValidationComplete
	FraudDetected            CertificateOrderActionType = original.FraudDetected
	OrgNameChange            CertificateOrderActionType = original.OrgNameChange
	OrgValidationComplete    CertificateOrderActionType = original.OrgValidationComplete
	SanDrop                  CertificateOrderActionType = original.SanDrop
)

type CertificateOrderStatus = original.CertificateOrderStatus

const (
	Canceled          CertificateOrderStatus = original.Canceled
	Denied            CertificateOrderStatus = original.Denied
	Expired           CertificateOrderStatus = original.Expired
	Issued            CertificateOrderStatus = original.Issued
	NotSubmitted      CertificateOrderStatus = original.NotSubmitted
	Pendingissuance   CertificateOrderStatus = original.Pendingissuance
	PendingRekey      CertificateOrderStatus = original.PendingRekey
	Pendingrevocation CertificateOrderStatus = original.Pendingrevocation
	Revoked           CertificateOrderStatus = original.Revoked
	Unused            CertificateOrderStatus = original.Unused
)

type CertificateProductType = original.CertificateProductType

const (
	StandardDomainValidatedSsl         CertificateProductType = original.StandardDomainValidatedSsl
	StandardDomainValidatedWildCardSsl CertificateProductType = original.StandardDomainValidatedWildCardSsl
)

type Channels = original.Channels

const (
	All          Channels = original.All
	API          Channels = original.API
	Email        Channels = original.Email
	Notification Channels = original.Notification
)

type CloneAbilityResult = original.CloneAbilityResult

const (
	Cloneable          CloneAbilityResult = original.Cloneable
	NotCloneable       CloneAbilityResult = original.NotCloneable
	PartiallyCloneable CloneAbilityResult = original.PartiallyCloneable
)

type ComputeModeOptions = original.ComputeModeOptions

const (
	Dedicated ComputeModeOptions = original.Dedicated
	Dynamic   ComputeModeOptions = original.Dynamic
	Shared    ComputeModeOptions = original.Shared
)

type ConnectionParameterType = original.ConnectionParameterType

const (
	ConnectionParameterTypeArray        ConnectionParameterType = original.ConnectionParameterTypeArray
	ConnectionParameterTypeBool         ConnectionParameterType = original.ConnectionParameterTypeBool
	ConnectionParameterTypeConnection   ConnectionParameterType = original.ConnectionParameterTypeConnection
	ConnectionParameterTypeInt          ConnectionParameterType = original.ConnectionParameterTypeInt
	ConnectionParameterTypeOauthSetting ConnectionParameterType = original.ConnectionParameterTypeOauthSetting
	ConnectionParameterTypeObject       ConnectionParameterType = original.ConnectionParameterTypeObject
	ConnectionParameterTypeSecureobject ConnectionParameterType = original.ConnectionParameterTypeSecureobject
	ConnectionParameterTypeSecurestring ConnectionParameterType = original.ConnectionParameterTypeSecurestring
	ConnectionParameterTypeString       ConnectionParameterType = original.ConnectionParameterTypeString
)

type CustomHostNameDNSRecordType = original.CustomHostNameDNSRecordType

const (
	A     CustomHostNameDNSRecordType = original.A
	CName CustomHostNameDNSRecordType = original.CName
)

type DatabaseServerType = original.DatabaseServerType

const (
	Custom    DatabaseServerType = original.Custom
	MySQL     DatabaseServerType = original.MySQL
	SQLAzure  DatabaseServerType = original.SQLAzure
	SQLServer DatabaseServerType = original.SQLServer
)

type DomainStatus = original.DomainStatus

const (
	DomainStatusActive              DomainStatus = original.DomainStatusActive
	DomainStatusAwaiting            DomainStatus = original.DomainStatusAwaiting
	DomainStatusCancelled           DomainStatus = original.DomainStatusCancelled
	DomainStatusConfiscated         DomainStatus = original.DomainStatusConfiscated
	DomainStatusDisabled            DomainStatus = original.DomainStatusDisabled
	DomainStatusExcluded            DomainStatus = original.DomainStatusExcluded
	DomainStatusExpired             DomainStatus = original.DomainStatusExpired
	DomainStatusFailed              DomainStatus = original.DomainStatusFailed
	DomainStatusHeld                DomainStatus = original.DomainStatusHeld
	DomainStatusJSONConverterFailed DomainStatus = original.DomainStatusJSONConverterFailed
	DomainStatusLocked              DomainStatus = original.DomainStatusLocked
	DomainStatusParked              DomainStatus = original.DomainStatusParked
	DomainStatusPending             DomainStatus = original.DomainStatusPending
	DomainStatusReserved            DomainStatus = original.DomainStatusReserved
	DomainStatusReverted            DomainStatus = original.DomainStatusReverted
	DomainStatusSuspended           DomainStatus = original.DomainStatusSuspended
	DomainStatusTransferred         DomainStatus = original.DomainStatusTransferred
	DomainStatusUnknown             DomainStatus = original.DomainStatusUnknown
	DomainStatusUnlocked            DomainStatus = original.DomainStatusUnlocked
	DomainStatusUnparked            DomainStatus = original.DomainStatusUnparked
	DomainStatusUpdated             DomainStatus = original.DomainStatusUpdated
)

type DomainType = original.DomainType

const (
	Regular     DomainType = original.Regular
	SoftDeleted DomainType = original.SoftDeleted
)

type FrequencyUnit = original.FrequencyUnit

const (
	Day  FrequencyUnit = original.Day
	Hour FrequencyUnit = original.Hour
)

type HostingEnvironmentStatus = original.HostingEnvironmentStatus

const (
	Deleting  HostingEnvironmentStatus = original.Deleting
	Preparing HostingEnvironmentStatus = original.Preparing
	Ready     HostingEnvironmentStatus = original.Ready
	Scaling   HostingEnvironmentStatus = original.Scaling
)

type HostNameType = original.HostNameType

const (
	Managed  HostNameType = original.Managed
	Verified HostNameType = original.Verified
)

type InternalLoadBalancingMode = original.InternalLoadBalancingMode

const (
	None       InternalLoadBalancingMode = original.None
	Publishing InternalLoadBalancingMode = original.Publishing
	Web        InternalLoadBalancingMode = original.Web
)

type KeyVaultSecretStatus = original.KeyVaultSecretStatus

const (
	KeyVaultSecretStatusAzureServiceUnauthorizedToAccessKeyVault KeyVaultSecretStatus = original.KeyVaultSecretStatusAzureServiceUnauthorizedToAccessKeyVault
	KeyVaultSecretStatusCertificateOrderFailed                   KeyVaultSecretStatus = original.KeyVaultSecretStatusCertificateOrderFailed
	KeyVaultSecretStatusInitialized                              KeyVaultSecretStatus = original.KeyVaultSecretStatusInitialized
	KeyVaultSecretStatusKeyVaultDoesNotExist                     KeyVaultSecretStatus = original.KeyVaultSecretStatusKeyVaultDoesNotExist
	KeyVaultSecretStatusKeyVaultSecretDoesNotExist               KeyVaultSecretStatus = original.KeyVaultSecretStatusKeyVaultSecretDoesNotExist
	KeyVaultSecretStatusOperationNotPermittedOnKeyVault          KeyVaultSecretStatus = original.KeyVaultSecretStatusOperationNotPermittedOnKeyVault
	KeyVaultSecretStatusSucceeded                                KeyVaultSecretStatus = original.KeyVaultSecretStatusSucceeded
	KeyVaultSecretStatusUnknown                                  KeyVaultSecretStatus = original.KeyVaultSecretStatusUnknown
	KeyVaultSecretStatusUnknownError                             KeyVaultSecretStatus = original.KeyVaultSecretStatusUnknownError
	KeyVaultSecretStatusWaitingOnCertificateOrder                KeyVaultSecretStatus = original.KeyVaultSecretStatusWaitingOnCertificateOrder
)

type LinkState = original.LinkState

const (
	Authenticated   LinkState = original.Authenticated
	Error           LinkState = original.Error
	Unauthenticated LinkState = original.Unauthenticated
)

type LogLevel = original.LogLevel

const (
	LogLevelError       LogLevel = original.LogLevelError
	LogLevelInformation LogLevel = original.LogLevelInformation
	LogLevelOff         LogLevel = original.LogLevelOff
	LogLevelVerbose     LogLevel = original.LogLevelVerbose
	LogLevelWarning     LogLevel = original.LogLevelWarning
)

type ManagedHostingEnvironmentStatus = original.ManagedHostingEnvironmentStatus

const (
	ManagedHostingEnvironmentStatusDeleting  ManagedHostingEnvironmentStatus = original.ManagedHostingEnvironmentStatusDeleting
	ManagedHostingEnvironmentStatusPreparing ManagedHostingEnvironmentStatus = original.ManagedHostingEnvironmentStatusPreparing
	ManagedHostingEnvironmentStatusReady     ManagedHostingEnvironmentStatus = original.ManagedHostingEnvironmentStatusReady
)

type ManagedPipelineMode = original.ManagedPipelineMode

const (
	Classic    ManagedPipelineMode = original.Classic
	Integrated ManagedPipelineMode = original.Integrated
)

type NotificationLevel = original.NotificationLevel

const (
	Critical            NotificationLevel = original.Critical
	Information         NotificationLevel = original.Information
	NonUrgentSuggestion NotificationLevel = original.NonUrgentSuggestion
	Warning             NotificationLevel = original.Warning
)

type PrincipalType = original.PrincipalType

const (
	PrincipalTypeActiveDirectory  PrincipalType = original.PrincipalTypeActiveDirectory
	PrincipalTypeConnection       PrincipalType = original.PrincipalTypeConnection
	PrincipalTypeMicrosoftAccount PrincipalType = original.PrincipalTypeMicrosoftAccount
)

type ProvisioningState = original.ProvisioningState

const (
	ProvisioningStateCanceled   ProvisioningState = original.ProvisioningStateCanceled
	ProvisioningStateDeleting   ProvisioningState = original.ProvisioningStateDeleting
	ProvisioningStateFailed     ProvisioningState = original.ProvisioningStateFailed
	ProvisioningStateInProgress ProvisioningState = original.ProvisioningStateInProgress
	ProvisioningStateSucceeded  ProvisioningState = original.ProvisioningStateSucceeded
)

type SiteAvailabilityState = original.SiteAvailabilityState

const (
	DisasterRecoveryMode SiteAvailabilityState = original.DisasterRecoveryMode
	Limited              SiteAvailabilityState = original.Limited
	Normal               SiteAvailabilityState = original.Normal
)

type SiteLoadBalancing = original.SiteLoadBalancing

const (
	LeastRequests        SiteLoadBalancing = original.LeastRequests
	LeastResponseTime    SiteLoadBalancing = original.LeastResponseTime
	RequestHash          SiteLoadBalancing = original.RequestHash
	WeightedRoundRobin   SiteLoadBalancing = original.WeightedRoundRobin
	WeightedTotalTraffic SiteLoadBalancing = original.WeightedTotalTraffic
)

type SslState = original.SslState

const (
	Disabled       SslState = original.Disabled
	IPBasedEnabled SslState = original.IPBasedEnabled
	SniEnabled     SslState = original.SniEnabled
)

type StatusOptions = original.StatusOptions

const (
	StatusOptionsPending StatusOptions = original.StatusOptionsPending
	StatusOptionsReady   StatusOptions = original.StatusOptionsReady
)

type UnauthenticatedClientAction = original.UnauthenticatedClientAction

const (
	AllowAnonymous      UnauthenticatedClientAction = original.AllowAnonymous
	RedirectToLoginPage UnauthenticatedClientAction = original.RedirectToLoginPage
)

type UsageState = original.UsageState

const (
	UsageStateExceeded UsageState = original.UsageStateExceeded
	UsageStateNormal   UsageState = original.UsageStateNormal
)

type WorkerSizeOptions = original.WorkerSizeOptions

const (
	WorkerSizeOptionsDefault WorkerSizeOptions = original.WorkerSizeOptionsDefault
	WorkerSizeOptionsLarge   WorkerSizeOptions = original.WorkerSizeOptionsLarge
	WorkerSizeOptionsMedium  WorkerSizeOptions = original.WorkerSizeOptionsMedium
	WorkerSizeOptionsSmall   WorkerSizeOptions = original.WorkerSizeOptionsSmall
)

type Address = original.Address
type AddressResponse = original.AddressResponse
type APIDefinitionInfo = original.APIDefinitionInfo
type APIEntity = original.APIEntity
type APIEntityProperties = original.APIEntityProperties
type APIOAuthSettings = original.APIOAuthSettings
type APIOAuthSettingsParameter = original.APIOAuthSettingsParameter
type APIPolicies = original.APIPolicies
type APIPoliciesProperties = original.APIPoliciesProperties
type ApisCollection = original.ApisCollection
type ApisCollectionIterator = original.ApisCollectionIterator
type ApisCollectionPage = original.ApisCollectionPage
type ApplicationLogsConfig = original.ApplicationLogsConfig
type ArmPlan = original.ArmPlan
type AutoHealActions = original.AutoHealActions
type AutoHealCustomAction = original.AutoHealCustomAction
type AutoHealRules = original.AutoHealRules
type AutoHealTriggers = original.AutoHealTriggers
type AzureBlobStorageApplicationLogsConfig = original.AzureBlobStorageApplicationLogsConfig
type AzureBlobStorageHTTPLogsConfig = original.AzureBlobStorageHTTPLogsConfig
type AzureTableStorageApplicationLogsConfig = original.AzureTableStorageApplicationLogsConfig
type BackendServiceDefinition = original.BackendServiceDefinition
type BackendServiceDefinitionProperties = original.BackendServiceDefinitionProperties
type BackupItem = original.BackupItem
type BackupItemCollection = original.BackupItemCollection
type BackupItemCollectionIterator = original.BackupItemCollectionIterator
type BackupItemCollectionPage = original.BackupItemCollectionPage
type BackupItemProperties = original.BackupItemProperties
type BackupRequest = original.BackupRequest
type BackupRequestProperties = original.BackupRequestProperties
type BackupSchedule = original.BackupSchedule
type Certificate = original.Certificate
type CertificateCollection = original.CertificateCollection
type CertificateCollectionIterator = original.CertificateCollectionIterator
type CertificateCollectionPage = original.CertificateCollectionPage
type CertificateDetails = original.CertificateDetails
type CertificateDetailsProperties = original.CertificateDetailsProperties
type CertificateEmail = original.CertificateEmail
type CertificateEmailProperties = original.CertificateEmailProperties
type CertificateOrder = original.CertificateOrder
type CertificateOrderAction = original.CertificateOrderAction
type CertificateOrderActionProperties = original.CertificateOrderActionProperties
type CertificateOrderCertificate = original.CertificateOrderCertificate
type CertificateOrderCertificateCollection = original.CertificateOrderCertificateCollection
type CertificateOrderCertificateCollectionIterator = original.CertificateOrderCertificateCollectionIterator
type CertificateOrderCertificateCollectionPage = original.CertificateOrderCertificateCollectionPage
type CertificateOrderCertificateProperties = original.CertificateOrderCertificateProperties
type CertificateOrderCollection = original.CertificateOrderCollection
type CertificateOrderCollectionIterator = original.CertificateOrderCollectionIterator
type CertificateOrderCollectionPage = original.CertificateOrderCollectionPage
type CertificateOrderProperties = original.CertificateOrderProperties
type CertificateProperties = original.CertificateProperties
type ClassicMobileService = original.ClassicMobileService
type ClassicMobileServiceCollection = original.ClassicMobileServiceCollection
type ClassicMobileServiceCollectionIterator = original.ClassicMobileServiceCollectionIterator
type ClassicMobileServiceCollectionPage = original.ClassicMobileServiceCollectionPage
type ClassicMobileServiceProperties = original.ClassicMobileServiceProperties
type CloningInfo = original.CloningInfo
type ConfirmConsentCodeInput = original.ConfirmConsentCodeInput
type ConfirmConsentCodeInputProperties = original.ConfirmConsentCodeInputProperties
type Connection = original.Connection
type ConnectionCollection = original.ConnectionCollection
type ConnectionCollectionIterator = original.ConnectionCollectionIterator
type ConnectionCollectionPage = original.ConnectionCollectionPage
type ConnectionError = original.ConnectionError
type ConnectionErrorProperties = original.ConnectionErrorProperties
type ConnectionParameter = original.ConnectionParameter
type ConnectionProperties = original.ConnectionProperties
type ConnectionSecrets = original.ConnectionSecrets
type ConnectionStatus = original.ConnectionStatus
type ConnectionStatusProperties = original.ConnectionStatusProperties
type ConnectionStringDictionary = original.ConnectionStringDictionary
type ConnStringInfo = original.ConnStringInfo
type ConnStringValueTypePair = original.ConnStringValueTypePair
type ConsentLink = original.ConsentLink
type ConsentLinkInput = original.ConsentLinkInput
type ConsentLinkInputParameter = original.ConsentLinkInputParameter
type ConsentLinkInputProperties = original.ConsentLinkInputProperties
type ConsentLinkPayload = original.ConsentLinkPayload
type Contact = original.Contact
type CorsSettings = original.CorsSettings
type CsmMoveResourceEnvelope = original.CsmMoveResourceEnvelope
type CsmPublishingProfileOptions = original.CsmPublishingProfileOptions
type CsmSiteRecoveryEntity = original.CsmSiteRecoveryEntity
type CsmSlotEntity = original.CsmSlotEntity
type CsmUsageQuota = original.CsmUsageQuota
type CsmUsageQuotaCollection = original.CsmUsageQuotaCollection
type CsmUsageQuotaCollectionIterator = original.CsmUsageQuotaCollectionIterator
type CsmUsageQuotaCollectionPage = original.CsmUsageQuotaCollectionPage
type Csr = original.Csr
type CsrProperties = original.CsrProperties
type CustomLoginSettingValue = original.CustomLoginSettingValue
type CustomLoginSettingValueProperties = original.CustomLoginSettingValueProperties
type DatabaseBackupSetting = original.DatabaseBackupSetting
type DeletedSite = original.DeletedSite
type DeletedSiteCollection = original.DeletedSiteCollection
type DeletedSiteCollectionIterator = original.DeletedSiteCollectionIterator
type DeletedSiteCollectionPage = original.DeletedSiteCollectionPage
type DeletedSiteProperties = original.DeletedSiteProperties
type Deployment = original.Deployment
type DeploymentCollection = original.DeploymentCollection
type DeploymentCollectionIterator = original.DeploymentCollectionIterator
type DeploymentCollectionPage = original.DeploymentCollectionPage
type DeploymentProperties = original.DeploymentProperties
type Domain = original.Domain
type DomainAvailablilityCheckResult = original.DomainAvailablilityCheckResult
type DomainCollection = original.DomainCollection
type DomainCollectionIterator = original.DomainCollectionIterator
type DomainCollectionPage = original.DomainCollectionPage
type DomainControlCenterSsoRequest = original.DomainControlCenterSsoRequest
type DomainProperties = original.DomainProperties
type DomainPurchaseConsent = original.DomainPurchaseConsent
type DomainRecommendationSearchParameters = original.DomainRecommendationSearchParameters
type DomainRegistrationInput = original.DomainRegistrationInput
type DomainRegistrationInputProperties = original.DomainRegistrationInputProperties
type EnabledConfig = original.EnabledConfig
type ExpandedParentAPIEntity = original.ExpandedParentAPIEntity
type ExpandedParentAPIEntityProperties = original.ExpandedParentAPIEntityProperties
type Experiments = original.Experiments
type FileSystemApplicationLogsConfig = original.FileSystemApplicationLogsConfig
type FileSystemHTTPLogsConfig = original.FileSystemHTTPLogsConfig
type GeneralAPIInformation = original.GeneralAPIInformation
type GeneralAPIInformationProperties = original.GeneralAPIInformationProperties
type GeoRegion = original.GeoRegion
type GeoRegionCollection = original.GeoRegionCollection
type GeoRegionCollectionIterator = original.GeoRegionCollectionIterator
type GeoRegionCollectionPage = original.GeoRegionCollectionPage
type GeoRegionProperties = original.GeoRegionProperties
type HandlerMapping = original.HandlerMapping
type HostingEnvironment = original.HostingEnvironment
type HostingEnvironmentCollection = original.HostingEnvironmentCollection
type HostingEnvironmentCollectionIterator = original.HostingEnvironmentCollectionIterator
type HostingEnvironmentCollectionPage = original.HostingEnvironmentCollectionPage
type HostingEnvironmentDiagnostics = original.HostingEnvironmentDiagnostics
type HostingEnvironmentProfile = original.HostingEnvironmentProfile
type HostingEnvironmentProperties = original.HostingEnvironmentProperties
type HostingEnvironmentsCreateOrUpdateHostingEnvironmentFuture = original.HostingEnvironmentsCreateOrUpdateHostingEnvironmentFuture
type HostingEnvironmentsCreateOrUpdateMultiRolePoolFuture = original.HostingEnvironmentsCreateOrUpdateMultiRolePoolFuture
type HostingEnvironmentsCreateOrUpdateWorkerPoolFuture = original.HostingEnvironmentsCreateOrUpdateWorkerPoolFuture
type HostingEnvironmentsDeleteHostingEnvironmentFuture = original.HostingEnvironmentsDeleteHostingEnvironmentFuture
type HostingEnvironmentServiceDescriptions = original.HostingEnvironmentServiceDescriptions
type HostingEnvironmentsResumeHostingEnvironmentAllFuture = original.HostingEnvironmentsResumeHostingEnvironmentAllFuture
type HostingEnvironmentsResumeHostingEnvironmentFuture = original.HostingEnvironmentsResumeHostingEnvironmentFuture
type HostingEnvironmentsSuspendHostingEnvironmentAllFuture = original.HostingEnvironmentsSuspendHostingEnvironmentAllFuture
type HostingEnvironmentsSuspendHostingEnvironmentFuture = original.HostingEnvironmentsSuspendHostingEnvironmentFuture
type HostName = original.HostName
type HostNameBinding = original.HostNameBinding
type HostNameBindingCollection = original.HostNameBindingCollection
type HostNameBindingCollectionIterator = original.HostNameBindingCollectionIterator
type HostNameBindingCollectionPage = original.HostNameBindingCollectionPage
type HostNameBindingProperties = original.HostNameBindingProperties
type HostNameSslState = original.HostNameSslState
type HTTPLogsConfig = original.HTTPLogsConfig
type IPSecurityRestriction = original.IPSecurityRestriction
type KeyValuePairStringString = original.KeyValuePairStringString
type ListCertificateEmail = original.ListCertificateEmail
type ListCertificateOrderAction = original.ListCertificateOrderAction
type ListConnectionKeysInput = original.ListConnectionKeysInput
type ListConnectionKeysInputProperties = original.ListConnectionKeysInputProperties
type ListCsr = original.ListCsr
type ListHostingEnvironmentDiagnostics = original.ListHostingEnvironmentDiagnostics
type ListRecommendation = original.ListRecommendation
type ListVnetInfo = original.ListVnetInfo
type ListVnetRoute = original.ListVnetRoute
type LocalizableString = original.LocalizableString
type ManagedHostingEnvironment = original.ManagedHostingEnvironment
type ManagedHostingEnvironmentCollection = original.ManagedHostingEnvironmentCollection
type ManagedHostingEnvironmentCollectionIterator = original.ManagedHostingEnvironmentCollectionIterator
type ManagedHostingEnvironmentCollectionPage = original.ManagedHostingEnvironmentCollectionPage
type ManagedHostingEnvironmentProperties = original.ManagedHostingEnvironmentProperties
type ManagedHostingEnvironmentsCreateOrUpdateManagedHostingEnvironmentFuture = original.ManagedHostingEnvironmentsCreateOrUpdateManagedHostingEnvironmentFuture
type ManagedHostingEnvironmentsDeleteManagedHostingEnvironmentFuture = original.ManagedHostingEnvironmentsDeleteManagedHostingEnvironmentFuture
type MetricAvailabilily = original.MetricAvailabilily
type MetricDefinition = original.MetricDefinition
type MetricDefinitionCollection = original.MetricDefinitionCollection
type MetricDefinitionCollectionIterator = original.MetricDefinitionCollectionIterator
type MetricDefinitionCollectionPage = original.MetricDefinitionCollectionPage
type MetricDefinitionProperties = original.MetricDefinitionProperties
type NameIdentifier = original.NameIdentifier
type NameIdentifierCollection = original.NameIdentifierCollection
type NameIdentifierCollectionIterator = original.NameIdentifierCollectionIterator
type NameIdentifierCollectionPage = original.NameIdentifierCollectionPage
type NameValuePair = original.NameValuePair
type NetworkAccessControlEntry = original.NetworkAccessControlEntry
type NetworkFeatures = original.NetworkFeatures
type NetworkFeaturesProperties = original.NetworkFeaturesProperties
type ParameterCustomLoginSettingValues = original.ParameterCustomLoginSettingValues
type ParameterCustomLoginSettingValuesProperties = original.ParameterCustomLoginSettingValuesProperties
type PremierAddOnRequest = original.PremierAddOnRequest
type RampUpRule = original.RampUpRule
type ReadCloser = original.ReadCloser
type Recommendation = original.Recommendation
type RecommendationRule = original.RecommendationRule
type ReissueCertificateOrderRequest = original.ReissueCertificateOrderRequest
type ReissueCertificateOrderRequestProperties = original.ReissueCertificateOrderRequestProperties
type RelayServiceConnectionEntity = original.RelayServiceConnectionEntity
type RelayServiceConnectionEntityProperties = original.RelayServiceConnectionEntityProperties
type RenewCertificateOrderRequest = original.RenewCertificateOrderRequest
type RenewCertificateOrderRequestProperties = original.RenewCertificateOrderRequestProperties
type RequestsBasedTrigger = original.RequestsBasedTrigger
type Resource = original.Resource
type ResourceMetric = original.ResourceMetric
type ResourceMetricCollection = original.ResourceMetricCollection
type ResourceMetricCollectionIterator = original.ResourceMetricCollectionIterator
type ResourceMetricCollectionPage = original.ResourceMetricCollectionPage
type ResourceMetricName = original.ResourceMetricName
type ResourceMetricValue = original.ResourceMetricValue
type ResourceNameAvailability = original.ResourceNameAvailability
type ResourceNameAvailabilityRequest = original.ResourceNameAvailabilityRequest
type ResponseMessageEnvelopeAPIEntity = original.ResponseMessageEnvelopeAPIEntity
type RestoreRequest = original.RestoreRequest
type RestoreRequestProperties = original.RestoreRequestProperties
type RestoreResponse = original.RestoreResponse
type RestoreResponseProperties = original.RestoreResponseProperties
type RoutingRule = original.RoutingRule
type ServerFarmCollection = original.ServerFarmCollection
type ServerFarmCollectionIterator = original.ServerFarmCollectionIterator
type ServerFarmCollectionPage = original.ServerFarmCollectionPage
type ServerFarmsCreateOrUpdateServerFarmFuture = original.ServerFarmsCreateOrUpdateServerFarmFuture
type ServerFarmWithRichSku = original.ServerFarmWithRichSku
type ServerFarmWithRichSkuProperties = original.ServerFarmWithRichSkuProperties
type SetObject = original.SetObject
type Site = original.Site
type SiteAuthSettings = original.SiteAuthSettings
type SiteCloneability = original.SiteCloneability
type SiteCloneabilityCriterion = original.SiteCloneabilityCriterion
type SiteCollection = original.SiteCollection
type SiteCollectionIterator = original.SiteCollectionIterator
type SiteCollectionPage = original.SiteCollectionPage
type SiteConfig = original.SiteConfig
type SiteConfigProperties = original.SiteConfigProperties
type SiteInstance = original.SiteInstance
type SiteInstanceCollection = original.SiteInstanceCollection
type SiteInstanceCollectionIterator = original.SiteInstanceCollectionIterator
type SiteInstanceCollectionPage = original.SiteInstanceCollectionPage
type SiteInstanceProperties = original.SiteInstanceProperties
type SiteLimits = original.SiteLimits
type SiteLogsConfig = original.SiteLogsConfig
type SiteLogsConfigProperties = original.SiteLogsConfigProperties
type SiteProperties = original.SiteProperties
type SitePropertiesModel = original.SitePropertiesModel
type SitesCreateOrUpdateSiteFuture = original.SitesCreateOrUpdateSiteFuture
type SitesCreateOrUpdateSiteSlotFuture = original.SitesCreateOrUpdateSiteSlotFuture
type SitesListSitePublishingCredentialsFuture = original.SitesListSitePublishingCredentialsFuture
type SitesListSitePublishingCredentialsSlotFuture = original.SitesListSitePublishingCredentialsSlotFuture
type SiteSourceControl = original.SiteSourceControl
type SiteSourceControlProperties = original.SiteSourceControlProperties
type SitesRecoverSiteFuture = original.SitesRecoverSiteFuture
type SitesRecoverSiteSlotFuture = original.SitesRecoverSiteSlotFuture
type SitesRestoreSiteFuture = original.SitesRestoreSiteFuture
type SitesRestoreSiteSlotFuture = original.SitesRestoreSiteSlotFuture
type SitesSwapSlotsSlotFuture = original.SitesSwapSlotsSlotFuture
type SitesSwapSlotWithProductionFuture = original.SitesSwapSlotWithProductionFuture
type SkuCapacity = original.SkuCapacity
type SkuDescription = original.SkuDescription
type SkuInfo = original.SkuInfo
type SkuInfoCollection = original.SkuInfoCollection
type SkuInfoCollectionIterator = original.SkuInfoCollectionIterator
type SkuInfoCollectionPage = original.SkuInfoCollectionPage
type SlotConfigNames = original.SlotConfigNames
type SlotConfigNamesResource = original.SlotConfigNamesResource
type SlotConfigNamesResourceProperties = original.SlotConfigNamesResourceProperties
type SlotDifference = original.SlotDifference
type SlotDifferenceCollection = original.SlotDifferenceCollection
type SlotDifferenceCollectionIterator = original.SlotDifferenceCollectionIterator
type SlotDifferenceCollectionPage = original.SlotDifferenceCollectionPage
type SlotDifferenceProperties = original.SlotDifferenceProperties
type SlowRequestsBasedTrigger = original.SlowRequestsBasedTrigger
type SourceControl = original.SourceControl
type SourceControlCollection = original.SourceControlCollection
type SourceControlCollectionIterator = original.SourceControlCollectionIterator
type SourceControlCollectionPage = original.SourceControlCollectionPage
type SourceControlProperties = original.SourceControlProperties
type StampCapacity = original.StampCapacity
type StampCapacityCollection = original.StampCapacityCollection
type StampCapacityCollectionIterator = original.StampCapacityCollectionIterator
type StampCapacityCollectionPage = original.StampCapacityCollectionPage
type StatusCodesBasedTrigger = original.StatusCodesBasedTrigger
type StringDictionary = original.StringDictionary
type TldLegalAgreement = original.TldLegalAgreement
type TldLegalAgreementCollection = original.TldLegalAgreementCollection
type TldLegalAgreementCollectionIterator = original.TldLegalAgreementCollectionIterator
type TldLegalAgreementCollectionPage = original.TldLegalAgreementCollectionPage
type TopLevelDomain = original.TopLevelDomain
type TopLevelDomainAgreementOption = original.TopLevelDomainAgreementOption
type TopLevelDomainCollection = original.TopLevelDomainCollection
type TopLevelDomainCollectionIterator = original.TopLevelDomainCollectionIterator
type TopLevelDomainCollectionPage = original.TopLevelDomainCollectionPage
type TopLevelDomainProperties = original.TopLevelDomainProperties
type Usage = original.Usage
type UsageCollection = original.UsageCollection
type UsageCollectionIterator = original.UsageCollectionIterator
type UsageCollectionPage = original.UsageCollectionPage
type UsageProperties = original.UsageProperties
type User = original.User
type UserProperties = original.UserProperties
type VirtualApplication = original.VirtualApplication
type VirtualDirectory = original.VirtualDirectory
type VirtualIPMapping = original.VirtualIPMapping
type VirtualNetworkProfile = original.VirtualNetworkProfile
type VnetGateway = original.VnetGateway
type VnetGatewayProperties = original.VnetGatewayProperties
type VnetInfo = original.VnetInfo
type VnetInfoProperties = original.VnetInfoProperties
type VnetRoute = original.VnetRoute
type VnetRouteProperties = original.VnetRouteProperties
type WorkerPool = original.WorkerPool
type WorkerPoolCollection = original.WorkerPoolCollection
type WorkerPoolCollectionIterator = original.WorkerPoolCollectionIterator
type WorkerPoolCollectionPage = original.WorkerPoolCollectionPage
type WorkerPoolProperties = original.WorkerPoolProperties
type ProviderClient = original.ProviderClient
type RecommendationsClient = original.RecommendationsClient
type ServerFarmsClient = original.ServerFarmsClient
type SitesClient = original.SitesClient
type TopLevelDomainsClient = original.TopLevelDomainsClient
type UsageClient = original.UsageClient

func NewCertificateOrdersClient(subscriptionID string) CertificateOrdersClient {
	return original.NewCertificateOrdersClient(subscriptionID)
}
func NewCertificateOrdersClientWithBaseURI(baseURI string, subscriptionID string) CertificateOrdersClient {
	return original.NewCertificateOrdersClientWithBaseURI(baseURI, subscriptionID)
}
func NewCertificatesClient(subscriptionID string) CertificatesClient {
	return original.NewCertificatesClient(subscriptionID)
}
func NewCertificatesClientWithBaseURI(baseURI string, subscriptionID string) CertificatesClient {
	return original.NewCertificatesClientWithBaseURI(baseURI, subscriptionID)
}
func NewClassicMobileServicesClient(subscriptionID string) ClassicMobileServicesClient {
	return original.NewClassicMobileServicesClient(subscriptionID)
}
func NewClassicMobileServicesClientWithBaseURI(baseURI string, subscriptionID string) ClassicMobileServicesClient {
	return original.NewClassicMobileServicesClientWithBaseURI(baseURI, subscriptionID)
}
func New(subscriptionID string) BaseClient {
	return original.New(subscriptionID)
}
func NewWithBaseURI(baseURI string, subscriptionID string) BaseClient {
	return original.NewWithBaseURI(baseURI, subscriptionID)
}
func NewConnectionsClient(subscriptionID string) ConnectionsClient {
	return original.NewConnectionsClient(subscriptionID)
}
func NewConnectionsClientWithBaseURI(baseURI string, subscriptionID string) ConnectionsClient {
	return original.NewConnectionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewDomainsClient(subscriptionID string) DomainsClient {
	return original.NewDomainsClient(subscriptionID)
}
func NewDomainsClientWithBaseURI(baseURI string, subscriptionID string) DomainsClient {
	return original.NewDomainsClientWithBaseURI(baseURI, subscriptionID)
}
func NewGlobalClient(subscriptionID string) GlobalClient {
	return original.NewGlobalClient(subscriptionID)
}
func NewGlobalClientWithBaseURI(baseURI string, subscriptionID string) GlobalClient {
	return original.NewGlobalClientWithBaseURI(baseURI, subscriptionID)
}
func NewGlobalCertificateOrderClient(subscriptionID string) GlobalCertificateOrderClient {
	return original.NewGlobalCertificateOrderClient(subscriptionID)
}
func NewGlobalCertificateOrderClientWithBaseURI(baseURI string, subscriptionID string) GlobalCertificateOrderClient {
	return original.NewGlobalCertificateOrderClientWithBaseURI(baseURI, subscriptionID)
}
func NewGlobalDomainRegistrationClient(subscriptionID string) GlobalDomainRegistrationClient {
	return original.NewGlobalDomainRegistrationClient(subscriptionID)
}
func NewGlobalDomainRegistrationClientWithBaseURI(baseURI string, subscriptionID string) GlobalDomainRegistrationClient {
	return original.NewGlobalDomainRegistrationClientWithBaseURI(baseURI, subscriptionID)
}
func NewGlobalResourceGroupsClient(subscriptionID string) GlobalResourceGroupsClient {
	return original.NewGlobalResourceGroupsClient(subscriptionID)
}
func NewGlobalResourceGroupsClientWithBaseURI(baseURI string, subscriptionID string) GlobalResourceGroupsClient {
	return original.NewGlobalResourceGroupsClientWithBaseURI(baseURI, subscriptionID)
}
func NewHostingEnvironmentsClient(subscriptionID string) HostingEnvironmentsClient {
	return original.NewHostingEnvironmentsClient(subscriptionID)
}
func NewHostingEnvironmentsClientWithBaseURI(baseURI string, subscriptionID string) HostingEnvironmentsClient {
	return original.NewHostingEnvironmentsClientWithBaseURI(baseURI, subscriptionID)
}
func NewManagedApisClient(subscriptionID string) ManagedApisClient {
	return original.NewManagedApisClient(subscriptionID)
}
func NewManagedApisClientWithBaseURI(baseURI string, subscriptionID string) ManagedApisClient {
	return original.NewManagedApisClientWithBaseURI(baseURI, subscriptionID)
}
func NewManagedHostingEnvironmentsClient(subscriptionID string) ManagedHostingEnvironmentsClient {
	return original.NewManagedHostingEnvironmentsClient(subscriptionID)
}
func NewManagedHostingEnvironmentsClientWithBaseURI(baseURI string, subscriptionID string) ManagedHostingEnvironmentsClient {
	return original.NewManagedHostingEnvironmentsClientWithBaseURI(baseURI, subscriptionID)
}
func PossibleAccessControlEntryActionValues() []AccessControlEntryAction {
	return original.PossibleAccessControlEntryActionValues()
}
func PossibleAutoHealActionTypeValues() []AutoHealActionType {
	return original.PossibleAutoHealActionTypeValues()
}
func PossibleAzureResourceTypeValues() []AzureResourceType {
	return original.PossibleAzureResourceTypeValues()
}
func PossibleBackupItemStatusValues() []BackupItemStatus {
	return original.PossibleBackupItemStatusValues()
}
func PossibleBackupRestoreOperationTypeValues() []BackupRestoreOperationType {
	return original.PossibleBackupRestoreOperationTypeValues()
}
func PossibleBuiltInAuthenticationProviderValues() []BuiltInAuthenticationProvider {
	return original.PossibleBuiltInAuthenticationProviderValues()
}
func PossibleCertificateOrderActionTypeValues() []CertificateOrderActionType {
	return original.PossibleCertificateOrderActionTypeValues()
}
func PossibleCertificateOrderStatusValues() []CertificateOrderStatus {
	return original.PossibleCertificateOrderStatusValues()
}
func PossibleCertificateProductTypeValues() []CertificateProductType {
	return original.PossibleCertificateProductTypeValues()
}
func PossibleChannelsValues() []Channels {
	return original.PossibleChannelsValues()
}
func PossibleCloneAbilityResultValues() []CloneAbilityResult {
	return original.PossibleCloneAbilityResultValues()
}
func PossibleComputeModeOptionsValues() []ComputeModeOptions {
	return original.PossibleComputeModeOptionsValues()
}
func PossibleConnectionParameterTypeValues() []ConnectionParameterType {
	return original.PossibleConnectionParameterTypeValues()
}
func PossibleCustomHostNameDNSRecordTypeValues() []CustomHostNameDNSRecordType {
	return original.PossibleCustomHostNameDNSRecordTypeValues()
}
func PossibleDatabaseServerTypeValues() []DatabaseServerType {
	return original.PossibleDatabaseServerTypeValues()
}
func PossibleDomainStatusValues() []DomainStatus {
	return original.PossibleDomainStatusValues()
}
func PossibleDomainTypeValues() []DomainType {
	return original.PossibleDomainTypeValues()
}
func PossibleFrequencyUnitValues() []FrequencyUnit {
	return original.PossibleFrequencyUnitValues()
}
func PossibleHostingEnvironmentStatusValues() []HostingEnvironmentStatus {
	return original.PossibleHostingEnvironmentStatusValues()
}
func PossibleHostNameTypeValues() []HostNameType {
	return original.PossibleHostNameTypeValues()
}
func PossibleInternalLoadBalancingModeValues() []InternalLoadBalancingMode {
	return original.PossibleInternalLoadBalancingModeValues()
}
func PossibleKeyVaultSecretStatusValues() []KeyVaultSecretStatus {
	return original.PossibleKeyVaultSecretStatusValues()
}
func PossibleLinkStateValues() []LinkState {
	return original.PossibleLinkStateValues()
}
func PossibleLogLevelValues() []LogLevel {
	return original.PossibleLogLevelValues()
}
func PossibleManagedHostingEnvironmentStatusValues() []ManagedHostingEnvironmentStatus {
	return original.PossibleManagedHostingEnvironmentStatusValues()
}
func PossibleManagedPipelineModeValues() []ManagedPipelineMode {
	return original.PossibleManagedPipelineModeValues()
}
func PossibleNotificationLevelValues() []NotificationLevel {
	return original.PossibleNotificationLevelValues()
}
func PossiblePrincipalTypeValues() []PrincipalType {
	return original.PossiblePrincipalTypeValues()
}
func PossibleProvisioningStateValues() []ProvisioningState {
	return original.PossibleProvisioningStateValues()
}
func PossibleSiteAvailabilityStateValues() []SiteAvailabilityState {
	return original.PossibleSiteAvailabilityStateValues()
}
func PossibleSiteLoadBalancingValues() []SiteLoadBalancing {
	return original.PossibleSiteLoadBalancingValues()
}
func PossibleSslStateValues() []SslState {
	return original.PossibleSslStateValues()
}
func PossibleStatusOptionsValues() []StatusOptions {
	return original.PossibleStatusOptionsValues()
}
func PossibleUnauthenticatedClientActionValues() []UnauthenticatedClientAction {
	return original.PossibleUnauthenticatedClientActionValues()
}
func PossibleUsageStateValues() []UsageState {
	return original.PossibleUsageStateValues()
}
func PossibleWorkerSizeOptionsValues() []WorkerSizeOptions {
	return original.PossibleWorkerSizeOptionsValues()
}
func NewApisCollectionIterator(page ApisCollectionPage) ApisCollectionIterator {
	return original.NewApisCollectionIterator(page)
}
func NewApisCollectionPage(getNextPage func(context.Context, ApisCollection) (ApisCollection, error)) ApisCollectionPage {
	return original.NewApisCollectionPage(getNextPage)
}
func NewBackupItemCollectionIterator(page BackupItemCollectionPage) BackupItemCollectionIterator {
	return original.NewBackupItemCollectionIterator(page)
}
func NewBackupItemCollectionPage(getNextPage func(context.Context, BackupItemCollection) (BackupItemCollection, error)) BackupItemCollectionPage {
	return original.NewBackupItemCollectionPage(getNextPage)
}
func NewCertificateCollectionIterator(page CertificateCollectionPage) CertificateCollectionIterator {
	return original.NewCertificateCollectionIterator(page)
}
func NewCertificateCollectionPage(getNextPage func(context.Context, CertificateCollection) (CertificateCollection, error)) CertificateCollectionPage {
	return original.NewCertificateCollectionPage(getNextPage)
}
func NewCertificateOrderCertificateCollectionIterator(page CertificateOrderCertificateCollectionPage) CertificateOrderCertificateCollectionIterator {
	return original.NewCertificateOrderCertificateCollectionIterator(page)
}
func NewCertificateOrderCertificateCollectionPage(getNextPage func(context.Context, CertificateOrderCertificateCollection) (CertificateOrderCertificateCollection, error)) CertificateOrderCertificateCollectionPage {
	return original.NewCertificateOrderCertificateCollectionPage(getNextPage)
}
func NewCertificateOrderCollectionIterator(page CertificateOrderCollectionPage) CertificateOrderCollectionIterator {
	return original.NewCertificateOrderCollectionIterator(page)
}
func NewCertificateOrderCollectionPage(getNextPage func(context.Context, CertificateOrderCollection) (CertificateOrderCollection, error)) CertificateOrderCollectionPage {
	return original.NewCertificateOrderCollectionPage(getNextPage)
}
func NewClassicMobileServiceCollectionIterator(page ClassicMobileServiceCollectionPage) ClassicMobileServiceCollectionIterator {
	return original.NewClassicMobileServiceCollectionIterator(page)
}
func NewClassicMobileServiceCollectionPage(getNextPage func(context.Context, ClassicMobileServiceCollection) (ClassicMobileServiceCollection, error)) ClassicMobileServiceCollectionPage {
	return original.NewClassicMobileServiceCollectionPage(getNextPage)
}
func NewConnectionCollectionIterator(page ConnectionCollectionPage) ConnectionCollectionIterator {
	return original.NewConnectionCollectionIterator(page)
}
func NewConnectionCollectionPage(getNextPage func(context.Context, ConnectionCollection) (ConnectionCollection, error)) ConnectionCollectionPage {
	return original.NewConnectionCollectionPage(getNextPage)
}
func NewCsmUsageQuotaCollectionIterator(page CsmUsageQuotaCollectionPage) CsmUsageQuotaCollectionIterator {
	return original.NewCsmUsageQuotaCollectionIterator(page)
}
func NewCsmUsageQuotaCollectionPage(getNextPage func(context.Context, CsmUsageQuotaCollection) (CsmUsageQuotaCollection, error)) CsmUsageQuotaCollectionPage {
	return original.NewCsmUsageQuotaCollectionPage(getNextPage)
}
func NewDeletedSiteCollectionIterator(page DeletedSiteCollectionPage) DeletedSiteCollectionIterator {
	return original.NewDeletedSiteCollectionIterator(page)
}
func NewDeletedSiteCollectionPage(getNextPage func(context.Context, DeletedSiteCollection) (DeletedSiteCollection, error)) DeletedSiteCollectionPage {
	return original.NewDeletedSiteCollectionPage(getNextPage)
}
func NewDeploymentCollectionIterator(page DeploymentCollectionPage) DeploymentCollectionIterator {
	return original.NewDeploymentCollectionIterator(page)
}
func NewDeploymentCollectionPage(getNextPage func(context.Context, DeploymentCollection) (DeploymentCollection, error)) DeploymentCollectionPage {
	return original.NewDeploymentCollectionPage(getNextPage)
}
func NewDomainCollectionIterator(page DomainCollectionPage) DomainCollectionIterator {
	return original.NewDomainCollectionIterator(page)
}
func NewDomainCollectionPage(getNextPage func(context.Context, DomainCollection) (DomainCollection, error)) DomainCollectionPage {
	return original.NewDomainCollectionPage(getNextPage)
}
func NewGeoRegionCollectionIterator(page GeoRegionCollectionPage) GeoRegionCollectionIterator {
	return original.NewGeoRegionCollectionIterator(page)
}
func NewGeoRegionCollectionPage(getNextPage func(context.Context, GeoRegionCollection) (GeoRegionCollection, error)) GeoRegionCollectionPage {
	return original.NewGeoRegionCollectionPage(getNextPage)
}
func NewHostingEnvironmentCollectionIterator(page HostingEnvironmentCollectionPage) HostingEnvironmentCollectionIterator {
	return original.NewHostingEnvironmentCollectionIterator(page)
}
func NewHostingEnvironmentCollectionPage(getNextPage func(context.Context, HostingEnvironmentCollection) (HostingEnvironmentCollection, error)) HostingEnvironmentCollectionPage {
	return original.NewHostingEnvironmentCollectionPage(getNextPage)
}
func NewHostNameBindingCollectionIterator(page HostNameBindingCollectionPage) HostNameBindingCollectionIterator {
	return original.NewHostNameBindingCollectionIterator(page)
}
func NewHostNameBindingCollectionPage(getNextPage func(context.Context, HostNameBindingCollection) (HostNameBindingCollection, error)) HostNameBindingCollectionPage {
	return original.NewHostNameBindingCollectionPage(getNextPage)
}
func NewManagedHostingEnvironmentCollectionIterator(page ManagedHostingEnvironmentCollectionPage) ManagedHostingEnvironmentCollectionIterator {
	return original.NewManagedHostingEnvironmentCollectionIterator(page)
}
func NewManagedHostingEnvironmentCollectionPage(getNextPage func(context.Context, ManagedHostingEnvironmentCollection) (ManagedHostingEnvironmentCollection, error)) ManagedHostingEnvironmentCollectionPage {
	return original.NewManagedHostingEnvironmentCollectionPage(getNextPage)
}
func NewMetricDefinitionCollectionIterator(page MetricDefinitionCollectionPage) MetricDefinitionCollectionIterator {
	return original.NewMetricDefinitionCollectionIterator(page)
}
func NewMetricDefinitionCollectionPage(getNextPage func(context.Context, MetricDefinitionCollection) (MetricDefinitionCollection, error)) MetricDefinitionCollectionPage {
	return original.NewMetricDefinitionCollectionPage(getNextPage)
}
func NewNameIdentifierCollectionIterator(page NameIdentifierCollectionPage) NameIdentifierCollectionIterator {
	return original.NewNameIdentifierCollectionIterator(page)
}
func NewNameIdentifierCollectionPage(getNextPage func(context.Context, NameIdentifierCollection) (NameIdentifierCollection, error)) NameIdentifierCollectionPage {
	return original.NewNameIdentifierCollectionPage(getNextPage)
}
func NewResourceMetricCollectionIterator(page ResourceMetricCollectionPage) ResourceMetricCollectionIterator {
	return original.NewResourceMetricCollectionIterator(page)
}
func NewResourceMetricCollectionPage(getNextPage func(context.Context, ResourceMetricCollection) (ResourceMetricCollection, error)) ResourceMetricCollectionPage {
	return original.NewResourceMetricCollectionPage(getNextPage)
}
func NewServerFarmCollectionIterator(page ServerFarmCollectionPage) ServerFarmCollectionIterator {
	return original.NewServerFarmCollectionIterator(page)
}
func NewServerFarmCollectionPage(getNextPage func(context.Context, ServerFarmCollection) (ServerFarmCollection, error)) ServerFarmCollectionPage {
	return original.NewServerFarmCollectionPage(getNextPage)
}
func NewSiteCollectionIterator(page SiteCollectionPage) SiteCollectionIterator {
	return original.NewSiteCollectionIterator(page)
}
func NewSiteCollectionPage(getNextPage func(context.Context, SiteCollection) (SiteCollection, error)) SiteCollectionPage {
	return original.NewSiteCollectionPage(getNextPage)
}
func NewSiteInstanceCollectionIterator(page SiteInstanceCollectionPage) SiteInstanceCollectionIterator {
	return original.NewSiteInstanceCollectionIterator(page)
}
func NewSiteInstanceCollectionPage(getNextPage func(context.Context, SiteInstanceCollection) (SiteInstanceCollection, error)) SiteInstanceCollectionPage {
	return original.NewSiteInstanceCollectionPage(getNextPage)
}
func NewSkuInfoCollectionIterator(page SkuInfoCollectionPage) SkuInfoCollectionIterator {
	return original.NewSkuInfoCollectionIterator(page)
}
func NewSkuInfoCollectionPage(getNextPage func(context.Context, SkuInfoCollection) (SkuInfoCollection, error)) SkuInfoCollectionPage {
	return original.NewSkuInfoCollectionPage(getNextPage)
}
func NewSlotDifferenceCollectionIterator(page SlotDifferenceCollectionPage) SlotDifferenceCollectionIterator {
	return original.NewSlotDifferenceCollectionIterator(page)
}
func NewSlotDifferenceCollectionPage(getNextPage func(context.Context, SlotDifferenceCollection) (SlotDifferenceCollection, error)) SlotDifferenceCollectionPage {
	return original.NewSlotDifferenceCollectionPage(getNextPage)
}
func NewSourceControlCollectionIterator(page SourceControlCollectionPage) SourceControlCollectionIterator {
	return original.NewSourceControlCollectionIterator(page)
}
func NewSourceControlCollectionPage(getNextPage func(context.Context, SourceControlCollection) (SourceControlCollection, error)) SourceControlCollectionPage {
	return original.NewSourceControlCollectionPage(getNextPage)
}
func NewStampCapacityCollectionIterator(page StampCapacityCollectionPage) StampCapacityCollectionIterator {
	return original.NewStampCapacityCollectionIterator(page)
}
func NewStampCapacityCollectionPage(getNextPage func(context.Context, StampCapacityCollection) (StampCapacityCollection, error)) StampCapacityCollectionPage {
	return original.NewStampCapacityCollectionPage(getNextPage)
}
func NewTldLegalAgreementCollectionIterator(page TldLegalAgreementCollectionPage) TldLegalAgreementCollectionIterator {
	return original.NewTldLegalAgreementCollectionIterator(page)
}
func NewTldLegalAgreementCollectionPage(getNextPage func(context.Context, TldLegalAgreementCollection) (TldLegalAgreementCollection, error)) TldLegalAgreementCollectionPage {
	return original.NewTldLegalAgreementCollectionPage(getNextPage)
}
func NewTopLevelDomainCollectionIterator(page TopLevelDomainCollectionPage) TopLevelDomainCollectionIterator {
	return original.NewTopLevelDomainCollectionIterator(page)
}
func NewTopLevelDomainCollectionPage(getNextPage func(context.Context, TopLevelDomainCollection) (TopLevelDomainCollection, error)) TopLevelDomainCollectionPage {
	return original.NewTopLevelDomainCollectionPage(getNextPage)
}
func NewUsageCollectionIterator(page UsageCollectionPage) UsageCollectionIterator {
	return original.NewUsageCollectionIterator(page)
}
func NewUsageCollectionPage(getNextPage func(context.Context, UsageCollection) (UsageCollection, error)) UsageCollectionPage {
	return original.NewUsageCollectionPage(getNextPage)
}
func NewWorkerPoolCollectionIterator(page WorkerPoolCollectionPage) WorkerPoolCollectionIterator {
	return original.NewWorkerPoolCollectionIterator(page)
}
func NewWorkerPoolCollectionPage(getNextPage func(context.Context, WorkerPoolCollection) (WorkerPoolCollection, error)) WorkerPoolCollectionPage {
	return original.NewWorkerPoolCollectionPage(getNextPage)
}
func NewProviderClient(subscriptionID string) ProviderClient {
	return original.NewProviderClient(subscriptionID)
}
func NewProviderClientWithBaseURI(baseURI string, subscriptionID string) ProviderClient {
	return original.NewProviderClientWithBaseURI(baseURI, subscriptionID)
}
func NewRecommendationsClient(subscriptionID string) RecommendationsClient {
	return original.NewRecommendationsClient(subscriptionID)
}
func NewRecommendationsClientWithBaseURI(baseURI string, subscriptionID string) RecommendationsClient {
	return original.NewRecommendationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewServerFarmsClient(subscriptionID string) ServerFarmsClient {
	return original.NewServerFarmsClient(subscriptionID)
}
func NewServerFarmsClientWithBaseURI(baseURI string, subscriptionID string) ServerFarmsClient {
	return original.NewServerFarmsClientWithBaseURI(baseURI, subscriptionID)
}
func NewSitesClient(subscriptionID string) SitesClient {
	return original.NewSitesClient(subscriptionID)
}
func NewSitesClientWithBaseURI(baseURI string, subscriptionID string) SitesClient {
	return original.NewSitesClientWithBaseURI(baseURI, subscriptionID)
}
func NewTopLevelDomainsClient(subscriptionID string) TopLevelDomainsClient {
	return original.NewTopLevelDomainsClient(subscriptionID)
}
func NewTopLevelDomainsClientWithBaseURI(baseURI string, subscriptionID string) TopLevelDomainsClient {
	return original.NewTopLevelDomainsClientWithBaseURI(baseURI, subscriptionID)
}
func NewUsageClient(subscriptionID string) UsageClient {
	return original.NewUsageClient(subscriptionID)
}
func NewUsageClientWithBaseURI(baseURI string, subscriptionID string) UsageClient {
	return original.NewUsageClientWithBaseURI(baseURI, subscriptionID)
}
func UserAgent() string {
	return original.UserAgent() + " profiles/preview"
}
func Version() string {
	return original.Version()
}
