// +build go1.9

// Copyright 2018 Microsoft Corporation
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/tools/profileBuilder

package storagesync

import (
	"context"

	original "github.com/Azure/azure-sdk-for-go/services/storagesync/mgmt/2018-07-01/storagesync"
)

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type BaseClient = original.BaseClient
type CloudEndpointsClient = original.CloudEndpointsClient
type CloudTiering = original.CloudTiering

const (
	Off CloudTiering = original.Off
	On  CloudTiering = original.On
)

type CloudTiering1 = original.CloudTiering1

const (
	CloudTiering1Off CloudTiering1 = original.CloudTiering1Off
	CloudTiering1On  CloudTiering1 = original.CloudTiering1On
)

type CloudTiering2 = original.CloudTiering2

const (
	CloudTiering2Off CloudTiering2 = original.CloudTiering2Off
	CloudTiering2On  CloudTiering2 = original.CloudTiering2On
)

type NameAvailabilityReason = original.NameAvailabilityReason

const (
	AlreadyExists NameAvailabilityReason = original.AlreadyExists
	Invalid       NameAvailabilityReason = original.Invalid
)

type Operation = original.Operation

const (
	Cancel Operation = original.Cancel
	Do     Operation = original.Do
	Undo   Operation = original.Undo
)

type Reason = original.Reason

const (
	Deleted      Reason = original.Deleted
	Registered   Reason = original.Registered
	Suspended    Reason = original.Suspended
	Unregistered Reason = original.Unregistered
	Warned       Reason = original.Warned
)

type Status = original.Status

const (
	Aborted   Status = original.Aborted
	Active    Status = original.Active
	Expired   Status = original.Expired
	Failed    Status = original.Failed
	Succeeded Status = original.Succeeded
)

type APIError = original.APIError
type AzureEntityResource = original.AzureEntityResource
type BackupRequest = original.BackupRequest
type CheckNameAvailabilityParameters = original.CheckNameAvailabilityParameters
type CheckNameAvailabilityResult = original.CheckNameAvailabilityResult
type CloudEndpoint = original.CloudEndpoint
type CloudEndpointArray = original.CloudEndpointArray
type CloudEndpointCreateParameters = original.CloudEndpointCreateParameters
type CloudEndpointCreateParametersProperties = original.CloudEndpointCreateParametersProperties
type CloudEndpointProperties = original.CloudEndpointProperties
type CloudEndpointsCreateFuture = original.CloudEndpointsCreateFuture
type CloudEndpointsDeleteFuture = original.CloudEndpointsDeleteFuture
type CloudEndpointsPostBackupFuture = original.CloudEndpointsPostBackupFuture
type CloudEndpointsPostRestoreFuture = original.CloudEndpointsPostRestoreFuture
type CloudEndpointsPreBackupFuture = original.CloudEndpointsPreBackupFuture
type CloudEndpointsPreRestoreFuture = original.CloudEndpointsPreRestoreFuture
type Error = original.Error
type ErrorDetails = original.ErrorDetails
type OperationDisplayInfo = original.OperationDisplayInfo
type OperationDisplayResource = original.OperationDisplayResource
type OperationEntity = original.OperationEntity
type OperationEntityListResult = original.OperationEntityListResult
type OperationEntityListResultIterator = original.OperationEntityListResultIterator
type OperationEntityListResultPage = original.OperationEntityListResultPage
type PostBackupResponse = original.PostBackupResponse
type PostBackupResponseProperties = original.PostBackupResponseProperties
type PostRestoreRequest = original.PostRestoreRequest
type PreRestoreRequest = original.PreRestoreRequest
type ProxyResource = original.ProxyResource
type RecallActionParameters = original.RecallActionParameters
type RegisteredServer = original.RegisteredServer
type RegisteredServerArray = original.RegisteredServerArray
type RegisteredServerCreateParameters = original.RegisteredServerCreateParameters
type RegisteredServerCreateParametersProperties = original.RegisteredServerCreateParametersProperties
type RegisteredServerProperties = original.RegisteredServerProperties
type RegisteredServersCreateFuture = original.RegisteredServersCreateFuture
type RegisteredServersDeleteFuture = original.RegisteredServersDeleteFuture
type RegisteredServersTriggerRolloverFuture = original.RegisteredServersTriggerRolloverFuture
type Resource = original.Resource
type ResourcesMoveInfo = original.ResourcesMoveInfo
type RestoreFileSpec = original.RestoreFileSpec
type ServerEndpoint = original.ServerEndpoint
type ServerEndpointArray = original.ServerEndpointArray
type ServerEndpointCreateParameters = original.ServerEndpointCreateParameters
type ServerEndpointCreateParametersProperties = original.ServerEndpointCreateParametersProperties
type ServerEndpointProperties = original.ServerEndpointProperties
type ServerEndpointsCreateFuture = original.ServerEndpointsCreateFuture
type ServerEndpointsDeleteFuture = original.ServerEndpointsDeleteFuture
type ServerEndpointsRecallActionFuture = original.ServerEndpointsRecallActionFuture
type ServerEndpointsUpdateFuture = original.ServerEndpointsUpdateFuture
type ServerEndpointUpdateParameters = original.ServerEndpointUpdateParameters
type ServerEndpointUpdateProperties = original.ServerEndpointUpdateProperties
type Service = original.Service
type ServiceArray = original.ServiceArray
type ServiceCreateParameters = original.ServiceCreateParameters
type ServiceProperties = original.ServiceProperties
type ServiceUpdateParameters = original.ServiceUpdateParameters
type SubscriptionState = original.SubscriptionState
type SyncGroup = original.SyncGroup
type SyncGroupArray = original.SyncGroupArray
type SyncGroupCreateParameters = original.SyncGroupCreateParameters
type SyncGroupProperties = original.SyncGroupProperties
type TrackedResource = original.TrackedResource
type TriggerRolloverRequest = original.TriggerRolloverRequest
type Workflow = original.Workflow
type WorkflowArray = original.WorkflowArray
type WorkflowProperties = original.WorkflowProperties
type OperationsClient = original.OperationsClient
type RegisteredServersClient = original.RegisteredServersClient
type ServerEndpointsClient = original.ServerEndpointsClient
type ServicesClient = original.ServicesClient
type SyncGroupsClient = original.SyncGroupsClient
type WorkflowsClient = original.WorkflowsClient

func New(subscriptionID string) BaseClient {
	return original.New(subscriptionID)
}
func NewWithBaseURI(baseURI string, subscriptionID string) BaseClient {
	return original.NewWithBaseURI(baseURI, subscriptionID)
}
func NewCloudEndpointsClient(subscriptionID string) CloudEndpointsClient {
	return original.NewCloudEndpointsClient(subscriptionID)
}
func NewCloudEndpointsClientWithBaseURI(baseURI string, subscriptionID string) CloudEndpointsClient {
	return original.NewCloudEndpointsClientWithBaseURI(baseURI, subscriptionID)
}
func PossibleCloudTieringValues() []CloudTiering {
	return original.PossibleCloudTieringValues()
}
func PossibleCloudTiering1Values() []CloudTiering1 {
	return original.PossibleCloudTiering1Values()
}
func PossibleCloudTiering2Values() []CloudTiering2 {
	return original.PossibleCloudTiering2Values()
}
func PossibleNameAvailabilityReasonValues() []NameAvailabilityReason {
	return original.PossibleNameAvailabilityReasonValues()
}
func PossibleOperationValues() []Operation {
	return original.PossibleOperationValues()
}
func PossibleReasonValues() []Reason {
	return original.PossibleReasonValues()
}
func PossibleStatusValues() []Status {
	return original.PossibleStatusValues()
}
func NewOperationEntityListResultIterator(page OperationEntityListResultPage) OperationEntityListResultIterator {
	return original.NewOperationEntityListResultIterator(page)
}
func NewOperationEntityListResultPage(getNextPage func(context.Context, OperationEntityListResult) (OperationEntityListResult, error)) OperationEntityListResultPage {
	return original.NewOperationEntityListResultPage(getNextPage)
}
func NewOperationsClient(subscriptionID string) OperationsClient {
	return original.NewOperationsClient(subscriptionID)
}
func NewOperationsClientWithBaseURI(baseURI string, subscriptionID string) OperationsClient {
	return original.NewOperationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewRegisteredServersClient(subscriptionID string) RegisteredServersClient {
	return original.NewRegisteredServersClient(subscriptionID)
}
func NewRegisteredServersClientWithBaseURI(baseURI string, subscriptionID string) RegisteredServersClient {
	return original.NewRegisteredServersClientWithBaseURI(baseURI, subscriptionID)
}
func NewServerEndpointsClient(subscriptionID string) ServerEndpointsClient {
	return original.NewServerEndpointsClient(subscriptionID)
}
func NewServerEndpointsClientWithBaseURI(baseURI string, subscriptionID string) ServerEndpointsClient {
	return original.NewServerEndpointsClientWithBaseURI(baseURI, subscriptionID)
}
func NewServicesClient(subscriptionID string) ServicesClient {
	return original.NewServicesClient(subscriptionID)
}
func NewServicesClientWithBaseURI(baseURI string, subscriptionID string) ServicesClient {
	return original.NewServicesClientWithBaseURI(baseURI, subscriptionID)
}
func NewSyncGroupsClient(subscriptionID string) SyncGroupsClient {
	return original.NewSyncGroupsClient(subscriptionID)
}
func NewSyncGroupsClientWithBaseURI(baseURI string, subscriptionID string) SyncGroupsClient {
	return original.NewSyncGroupsClientWithBaseURI(baseURI, subscriptionID)
}
func UserAgent() string {
	return original.UserAgent() + " profiles/preview"
}
func Version() string {
	return original.Version()
}
func NewWorkflowsClient(subscriptionID string) WorkflowsClient {
	return original.NewWorkflowsClient(subscriptionID)
}
func NewWorkflowsClientWithBaseURI(baseURI string, subscriptionID string) WorkflowsClient {
	return original.NewWorkflowsClientWithBaseURI(baseURI, subscriptionID)
}
