package batch

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"io"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/batch/2017-05-01.5.0/batch"

// AccessScope enumerates the values for access scope.
type AccessScope string

const (
	// Job ...
	Job AccessScope = "job"
)

// PossibleAccessScopeValues returns an array of possible values for the AccessScope const type.
func PossibleAccessScopeValues() []AccessScope {
	return []AccessScope{Job}
}

// AllocationState enumerates the values for allocation state.
type AllocationState string

const (
	// Resizing ...
	Resizing AllocationState = "resizing"
	// Steady ...
	Steady AllocationState = "steady"
	// Stopping ...
	Stopping AllocationState = "stopping"
)

// PossibleAllocationStateValues returns an array of possible values for the AllocationState const type.
func PossibleAllocationStateValues() []AllocationState {
	return []AllocationState{Resizing, Steady, Stopping}
}

// AutoUserScope enumerates the values for auto user scope.
type AutoUserScope string

const (
	// Pool ...
	Pool AutoUserScope = "pool"
	// Task ...
	Task AutoUserScope = "task"
)

// PossibleAutoUserScopeValues returns an array of possible values for the AutoUserScope const type.
func PossibleAutoUserScopeValues() []AutoUserScope {
	return []AutoUserScope{Pool, Task}
}

// CachingType enumerates the values for caching type.
type CachingType string

const (
	// None ...
	None CachingType = "none"
	// ReadOnly ...
	ReadOnly CachingType = "readOnly"
	// ReadWrite ...
	ReadWrite CachingType = "readWrite"
)

// PossibleCachingTypeValues returns an array of possible values for the CachingType const type.
func PossibleCachingTypeValues() []CachingType {
	return []CachingType{None, ReadOnly, ReadWrite}
}

// CertificateFormat enumerates the values for certificate format.
type CertificateFormat string

const (
	// Cer ...
	Cer CertificateFormat = "cer"
	// Pfx ...
	Pfx CertificateFormat = "pfx"
)

// PossibleCertificateFormatValues returns an array of possible values for the CertificateFormat const type.
func PossibleCertificateFormatValues() []CertificateFormat {
	return []CertificateFormat{Cer, Pfx}
}

// CertificateState enumerates the values for certificate state.
type CertificateState string

const (
	// Active ...
	Active CertificateState = "active"
	// DeleteFailed ...
	DeleteFailed CertificateState = "deleteFailed"
	// Deleting ...
	Deleting CertificateState = "deleting"
)

// PossibleCertificateStateValues returns an array of possible values for the CertificateState const type.
func PossibleCertificateStateValues() []CertificateState {
	return []CertificateState{Active, DeleteFailed, Deleting}
}

// CertificateStoreLocation enumerates the values for certificate store location.
type CertificateStoreLocation string

const (
	// CurrentUser ...
	CurrentUser CertificateStoreLocation = "currentUser"
	// LocalMachine ...
	LocalMachine CertificateStoreLocation = "localMachine"
)

// PossibleCertificateStoreLocationValues returns an array of possible values for the CertificateStoreLocation const type.
func PossibleCertificateStoreLocationValues() []CertificateStoreLocation {
	return []CertificateStoreLocation{CurrentUser, LocalMachine}
}

// CertificateVisibility enumerates the values for certificate visibility.
type CertificateVisibility string

const (
	// CertificateVisibilityRemoteUser ...
	CertificateVisibilityRemoteUser CertificateVisibility = "remoteUser"
	// CertificateVisibilityStartTask ...
	CertificateVisibilityStartTask CertificateVisibility = "startTask"
	// CertificateVisibilityTask ...
	CertificateVisibilityTask CertificateVisibility = "task"
)

// PossibleCertificateVisibilityValues returns an array of possible values for the CertificateVisibility const type.
func PossibleCertificateVisibilityValues() []CertificateVisibility {
	return []CertificateVisibility{CertificateVisibilityRemoteUser, CertificateVisibilityStartTask, CertificateVisibilityTask}
}

// ComputeNodeDeallocationOption enumerates the values for compute node deallocation option.
type ComputeNodeDeallocationOption string

const (
	// Requeue ...
	Requeue ComputeNodeDeallocationOption = "requeue"
	// RetainedData ...
	RetainedData ComputeNodeDeallocationOption = "retainedData"
	// TaskCompletion ...
	TaskCompletion ComputeNodeDeallocationOption = "taskCompletion"
	// Terminate ...
	Terminate ComputeNodeDeallocationOption = "terminate"
)

// PossibleComputeNodeDeallocationOptionValues returns an array of possible values for the ComputeNodeDeallocationOption const type.
func PossibleComputeNodeDeallocationOptionValues() []ComputeNodeDeallocationOption {
	return []ComputeNodeDeallocationOption{Requeue, RetainedData, TaskCompletion, Terminate}
}

// ComputeNodeFillType enumerates the values for compute node fill type.
type ComputeNodeFillType string

const (
	// Pack ...
	Pack ComputeNodeFillType = "pack"
	// Spread ...
	Spread ComputeNodeFillType = "spread"
)

// PossibleComputeNodeFillTypeValues returns an array of possible values for the ComputeNodeFillType const type.
func PossibleComputeNodeFillTypeValues() []ComputeNodeFillType {
	return []ComputeNodeFillType{Pack, Spread}
}

// ComputeNodeRebootOption enumerates the values for compute node reboot option.
type ComputeNodeRebootOption string

const (
	// ComputeNodeRebootOptionRequeue ...
	ComputeNodeRebootOptionRequeue ComputeNodeRebootOption = "requeue"
	// ComputeNodeRebootOptionRetainedData ...
	ComputeNodeRebootOptionRetainedData ComputeNodeRebootOption = "retainedData"
	// ComputeNodeRebootOptionTaskCompletion ...
	ComputeNodeRebootOptionTaskCompletion ComputeNodeRebootOption = "taskCompletion"
	// ComputeNodeRebootOptionTerminate ...
	ComputeNodeRebootOptionTerminate ComputeNodeRebootOption = "terminate"
)

// PossibleComputeNodeRebootOptionValues returns an array of possible values for the ComputeNodeRebootOption const type.
func PossibleComputeNodeRebootOptionValues() []ComputeNodeRebootOption {
	return []ComputeNodeRebootOption{ComputeNodeRebootOptionRequeue, ComputeNodeRebootOptionRetainedData, ComputeNodeRebootOptionTaskCompletion, ComputeNodeRebootOptionTerminate}
}

// ComputeNodeReimageOption enumerates the values for compute node reimage option.
type ComputeNodeReimageOption string

const (
	// ComputeNodeReimageOptionRequeue ...
	ComputeNodeReimageOptionRequeue ComputeNodeReimageOption = "requeue"
	// ComputeNodeReimageOptionRetainedData ...
	ComputeNodeReimageOptionRetainedData ComputeNodeReimageOption = "retainedData"
	// ComputeNodeReimageOptionTaskCompletion ...
	ComputeNodeReimageOptionTaskCompletion ComputeNodeReimageOption = "taskCompletion"
	// ComputeNodeReimageOptionTerminate ...
	ComputeNodeReimageOptionTerminate ComputeNodeReimageOption = "terminate"
)

// PossibleComputeNodeReimageOptionValues returns an array of possible values for the ComputeNodeReimageOption const type.
func PossibleComputeNodeReimageOptionValues() []ComputeNodeReimageOption {
	return []ComputeNodeReimageOption{ComputeNodeReimageOptionRequeue, ComputeNodeReimageOptionRetainedData, ComputeNodeReimageOptionTaskCompletion, ComputeNodeReimageOptionTerminate}
}

// ComputeNodeState enumerates the values for compute node state.
type ComputeNodeState string

const (
	// Creating ...
	Creating ComputeNodeState = "creating"
	// Idle ...
	Idle ComputeNodeState = "idle"
	// LeavingPool ...
	LeavingPool ComputeNodeState = "leavingPool"
	// Offline ...
	Offline ComputeNodeState = "offline"
	// Preempted ...
	Preempted ComputeNodeState = "preempted"
	// Rebooting ...
	Rebooting ComputeNodeState = "rebooting"
	// Reimaging ...
	Reimaging ComputeNodeState = "reimaging"
	// Running ...
	Running ComputeNodeState = "running"
	// Starting ...
	Starting ComputeNodeState = "starting"
	// StartTaskFailed ...
	StartTaskFailed ComputeNodeState = "startTaskFailed"
	// Unknown ...
	Unknown ComputeNodeState = "unknown"
	// Unusable ...
	Unusable ComputeNodeState = "unusable"
	// WaitingForStartTask ...
	WaitingForStartTask ComputeNodeState = "waitingForStartTask"
)

// PossibleComputeNodeStateValues returns an array of possible values for the ComputeNodeState const type.
func PossibleComputeNodeStateValues() []ComputeNodeState {
	return []ComputeNodeState{Creating, Idle, LeavingPool, Offline, Preempted, Rebooting, Reimaging, Running, Starting, StartTaskFailed, Unknown, Unusable, WaitingForStartTask}
}

// DependencyAction enumerates the values for dependency action.
type DependencyAction string

const (
	// Block ...
	Block DependencyAction = "block"
	// Satisfy ...
	Satisfy DependencyAction = "satisfy"
)

// PossibleDependencyActionValues returns an array of possible values for the DependencyAction const type.
func PossibleDependencyActionValues() []DependencyAction {
	return []DependencyAction{Block, Satisfy}
}

// DisableComputeNodeSchedulingOption enumerates the values for disable compute node scheduling option.
type DisableComputeNodeSchedulingOption string

const (
	// DisableComputeNodeSchedulingOptionRequeue ...
	DisableComputeNodeSchedulingOptionRequeue DisableComputeNodeSchedulingOption = "requeue"
	// DisableComputeNodeSchedulingOptionTaskCompletion ...
	DisableComputeNodeSchedulingOptionTaskCompletion DisableComputeNodeSchedulingOption = "taskCompletion"
	// DisableComputeNodeSchedulingOptionTerminate ...
	DisableComputeNodeSchedulingOptionTerminate DisableComputeNodeSchedulingOption = "terminate"
)

// PossibleDisableComputeNodeSchedulingOptionValues returns an array of possible values for the DisableComputeNodeSchedulingOption const type.
func PossibleDisableComputeNodeSchedulingOptionValues() []DisableComputeNodeSchedulingOption {
	return []DisableComputeNodeSchedulingOption{DisableComputeNodeSchedulingOptionRequeue, DisableComputeNodeSchedulingOptionTaskCompletion, DisableComputeNodeSchedulingOptionTerminate}
}

// DisableJobOption enumerates the values for disable job option.
type DisableJobOption string

const (
	// DisableJobOptionRequeue ...
	DisableJobOptionRequeue DisableJobOption = "requeue"
	// DisableJobOptionTerminate ...
	DisableJobOptionTerminate DisableJobOption = "terminate"
	// DisableJobOptionWait ...
	DisableJobOptionWait DisableJobOption = "wait"
)

// PossibleDisableJobOptionValues returns an array of possible values for the DisableJobOption const type.
func PossibleDisableJobOptionValues() []DisableJobOption {
	return []DisableJobOption{DisableJobOptionRequeue, DisableJobOptionTerminate, DisableJobOptionWait}
}

// ElevationLevel enumerates the values for elevation level.
type ElevationLevel string

const (
	// Admin ...
	Admin ElevationLevel = "admin"
	// NonAdmin ...
	NonAdmin ElevationLevel = "nonAdmin"
)

// PossibleElevationLevelValues returns an array of possible values for the ElevationLevel const type.
func PossibleElevationLevelValues() []ElevationLevel {
	return []ElevationLevel{Admin, NonAdmin}
}

// ErrorCategory enumerates the values for error category.
type ErrorCategory string

const (
	// ServerError ...
	ServerError ErrorCategory = "serverError"
	// UserError ...
	UserError ErrorCategory = "userError"
)

// PossibleErrorCategoryValues returns an array of possible values for the ErrorCategory const type.
func PossibleErrorCategoryValues() []ErrorCategory {
	return []ErrorCategory{ServerError, UserError}
}

// JobAction enumerates the values for job action.
type JobAction string

const (
	// JobActionDisable ...
	JobActionDisable JobAction = "disable"
	// JobActionNone ...
	JobActionNone JobAction = "none"
	// JobActionTerminate ...
	JobActionTerminate JobAction = "terminate"
)

// PossibleJobActionValues returns an array of possible values for the JobAction const type.
func PossibleJobActionValues() []JobAction {
	return []JobAction{JobActionDisable, JobActionNone, JobActionTerminate}
}

// JobPreparationTaskState enumerates the values for job preparation task state.
type JobPreparationTaskState string

const (
	// JobPreparationTaskStateCompleted ...
	JobPreparationTaskStateCompleted JobPreparationTaskState = "completed"
	// JobPreparationTaskStateRunning ...
	JobPreparationTaskStateRunning JobPreparationTaskState = "running"
)

// PossibleJobPreparationTaskStateValues returns an array of possible values for the JobPreparationTaskState const type.
func PossibleJobPreparationTaskStateValues() []JobPreparationTaskState {
	return []JobPreparationTaskState{JobPreparationTaskStateCompleted, JobPreparationTaskStateRunning}
}

// JobReleaseTaskState enumerates the values for job release task state.
type JobReleaseTaskState string

const (
	// JobReleaseTaskStateCompleted ...
	JobReleaseTaskStateCompleted JobReleaseTaskState = "completed"
	// JobReleaseTaskStateRunning ...
	JobReleaseTaskStateRunning JobReleaseTaskState = "running"
)

// PossibleJobReleaseTaskStateValues returns an array of possible values for the JobReleaseTaskState const type.
func PossibleJobReleaseTaskStateValues() []JobReleaseTaskState {
	return []JobReleaseTaskState{JobReleaseTaskStateCompleted, JobReleaseTaskStateRunning}
}

// JobScheduleState enumerates the values for job schedule state.
type JobScheduleState string

const (
	// JobScheduleStateActive ...
	JobScheduleStateActive JobScheduleState = "active"
	// JobScheduleStateCompleted ...
	JobScheduleStateCompleted JobScheduleState = "completed"
	// JobScheduleStateDeleting ...
	JobScheduleStateDeleting JobScheduleState = "deleting"
	// JobScheduleStateDisabled ...
	JobScheduleStateDisabled JobScheduleState = "disabled"
	// JobScheduleStateTerminating ...
	JobScheduleStateTerminating JobScheduleState = "terminating"
)

// PossibleJobScheduleStateValues returns an array of possible values for the JobScheduleState const type.
func PossibleJobScheduleStateValues() []JobScheduleState {
	return []JobScheduleState{JobScheduleStateActive, JobScheduleStateCompleted, JobScheduleStateDeleting, JobScheduleStateDisabled, JobScheduleStateTerminating}
}

// JobState enumerates the values for job state.
type JobState string

const (
	// JobStateActive ...
	JobStateActive JobState = "active"
	// JobStateCompleted ...
	JobStateCompleted JobState = "completed"
	// JobStateDeleting ...
	JobStateDeleting JobState = "deleting"
	// JobStateDisabled ...
	JobStateDisabled JobState = "disabled"
	// JobStateDisabling ...
	JobStateDisabling JobState = "disabling"
	// JobStateEnabling ...
	JobStateEnabling JobState = "enabling"
	// JobStateTerminating ...
	JobStateTerminating JobState = "terminating"
)

// PossibleJobStateValues returns an array of possible values for the JobState const type.
func PossibleJobStateValues() []JobState {
	return []JobState{JobStateActive, JobStateCompleted, JobStateDeleting, JobStateDisabled, JobStateDisabling, JobStateEnabling, JobStateTerminating}
}

// OnAllTasksComplete enumerates the values for on all tasks complete.
type OnAllTasksComplete string

const (
	// NoAction ...
	NoAction OnAllTasksComplete = "noAction"
	// TerminateJob ...
	TerminateJob OnAllTasksComplete = "terminateJob"
)

// PossibleOnAllTasksCompleteValues returns an array of possible values for the OnAllTasksComplete const type.
func PossibleOnAllTasksCompleteValues() []OnAllTasksComplete {
	return []OnAllTasksComplete{NoAction, TerminateJob}
}

// OnTaskFailure enumerates the values for on task failure.
type OnTaskFailure string

const (
	// OnTaskFailureNoAction ...
	OnTaskFailureNoAction OnTaskFailure = "noAction"
	// OnTaskFailurePerformExitOptionsJobAction ...
	OnTaskFailurePerformExitOptionsJobAction OnTaskFailure = "performExitOptionsJobAction"
)

// PossibleOnTaskFailureValues returns an array of possible values for the OnTaskFailure const type.
func PossibleOnTaskFailureValues() []OnTaskFailure {
	return []OnTaskFailure{OnTaskFailureNoAction, OnTaskFailurePerformExitOptionsJobAction}
}

// OSType enumerates the values for os type.
type OSType string

const (
	// Linux ...
	Linux OSType = "linux"
	// Windows ...
	Windows OSType = "windows"
)

// PossibleOSTypeValues returns an array of possible values for the OSType const type.
func PossibleOSTypeValues() []OSType {
	return []OSType{Linux, Windows}
}

// OutputFileUploadCondition enumerates the values for output file upload condition.
type OutputFileUploadCondition string

const (
	// OutputFileUploadConditionTaskCompletion ...
	OutputFileUploadConditionTaskCompletion OutputFileUploadCondition = "taskCompletion"
	// OutputFileUploadConditionTaskFailure ...
	OutputFileUploadConditionTaskFailure OutputFileUploadCondition = "taskFailure"
	// OutputFileUploadConditionTaskSuccess ...
	OutputFileUploadConditionTaskSuccess OutputFileUploadCondition = "taskSuccess"
)

// PossibleOutputFileUploadConditionValues returns an array of possible values for the OutputFileUploadCondition const type.
func PossibleOutputFileUploadConditionValues() []OutputFileUploadCondition {
	return []OutputFileUploadCondition{OutputFileUploadConditionTaskCompletion, OutputFileUploadConditionTaskFailure, OutputFileUploadConditionTaskSuccess}
}

// PoolLifetimeOption enumerates the values for pool lifetime option.
type PoolLifetimeOption string

const (
	// PoolLifetimeOptionJob ...
	PoolLifetimeOptionJob PoolLifetimeOption = "job"
	// PoolLifetimeOptionJobSchedule ...
	PoolLifetimeOptionJobSchedule PoolLifetimeOption = "jobSchedule"
)

// PossiblePoolLifetimeOptionValues returns an array of possible values for the PoolLifetimeOption const type.
func PossiblePoolLifetimeOptionValues() []PoolLifetimeOption {
	return []PoolLifetimeOption{PoolLifetimeOptionJob, PoolLifetimeOptionJobSchedule}
}

// PoolState enumerates the values for pool state.
type PoolState string

const (
	// PoolStateActive ...
	PoolStateActive PoolState = "active"
	// PoolStateDeleting ...
	PoolStateDeleting PoolState = "deleting"
	// PoolStateUpgrading ...
	PoolStateUpgrading PoolState = "upgrading"
)

// PossiblePoolStateValues returns an array of possible values for the PoolState const type.
func PossiblePoolStateValues() []PoolState {
	return []PoolState{PoolStateActive, PoolStateDeleting, PoolStateUpgrading}
}

// SchedulingState enumerates the values for scheduling state.
type SchedulingState string

const (
	// Disabled ...
	Disabled SchedulingState = "disabled"
	// Enabled ...
	Enabled SchedulingState = "enabled"
)

// PossibleSchedulingStateValues returns an array of possible values for the SchedulingState const type.
func PossibleSchedulingStateValues() []SchedulingState {
	return []SchedulingState{Disabled, Enabled}
}

// StartTaskState enumerates the values for start task state.
type StartTaskState string

const (
	// StartTaskStateCompleted ...
	StartTaskStateCompleted StartTaskState = "completed"
	// StartTaskStateRunning ...
	StartTaskStateRunning StartTaskState = "running"
)

// PossibleStartTaskStateValues returns an array of possible values for the StartTaskState const type.
func PossibleStartTaskStateValues() []StartTaskState {
	return []StartTaskState{StartTaskStateCompleted, StartTaskStateRunning}
}

// SubtaskState enumerates the values for subtask state.
type SubtaskState string

const (
	// SubtaskStateCompleted ...
	SubtaskStateCompleted SubtaskState = "completed"
	// SubtaskStatePreparing ...
	SubtaskStatePreparing SubtaskState = "preparing"
	// SubtaskStateRunning ...
	SubtaskStateRunning SubtaskState = "running"
)

// PossibleSubtaskStateValues returns an array of possible values for the SubtaskState const type.
func PossibleSubtaskStateValues() []SubtaskState {
	return []SubtaskState{SubtaskStateCompleted, SubtaskStatePreparing, SubtaskStateRunning}
}

// TaskAddStatus enumerates the values for task add status.
type TaskAddStatus string

const (
	// TaskAddStatusClientError ...
	TaskAddStatusClientError TaskAddStatus = "clientError"
	// TaskAddStatusServerError ...
	TaskAddStatusServerError TaskAddStatus = "serverError"
	// TaskAddStatusSuccess ...
	TaskAddStatusSuccess TaskAddStatus = "success"
)

// PossibleTaskAddStatusValues returns an array of possible values for the TaskAddStatus const type.
func PossibleTaskAddStatusValues() []TaskAddStatus {
	return []TaskAddStatus{TaskAddStatusClientError, TaskAddStatusServerError, TaskAddStatusSuccess}
}

// TaskExecutionResult enumerates the values for task execution result.
type TaskExecutionResult string

const (
	// Failure ...
	Failure TaskExecutionResult = "failure"
	// Success ...
	Success TaskExecutionResult = "success"
)

// PossibleTaskExecutionResultValues returns an array of possible values for the TaskExecutionResult const type.
func PossibleTaskExecutionResultValues() []TaskExecutionResult {
	return []TaskExecutionResult{Failure, Success}
}

// TaskState enumerates the values for task state.
type TaskState string

const (
	// TaskStateActive ...
	TaskStateActive TaskState = "active"
	// TaskStateCompleted ...
	TaskStateCompleted TaskState = "completed"
	// TaskStatePreparing ...
	TaskStatePreparing TaskState = "preparing"
	// TaskStateRunning ...
	TaskStateRunning TaskState = "running"
)

// PossibleTaskStateValues returns an array of possible values for the TaskState const type.
func PossibleTaskStateValues() []TaskState {
	return []TaskState{TaskStateActive, TaskStateCompleted, TaskStatePreparing, TaskStateRunning}
}

// AccountListNodeAgentSkusResult ...
type AccountListNodeAgentSkusResult struct {
	autorest.Response `json:"-"`
	Value             *[]NodeAgentSku `json:"value,omitempty"`
	OdataNextLink     *string         `json:"odata.nextLink,omitempty"`
}

// AccountListNodeAgentSkusResultIterator provides access to a complete listing of NodeAgentSku values.
type AccountListNodeAgentSkusResultIterator struct {
	i    int
	page AccountListNodeAgentSkusResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AccountListNodeAgentSkusResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AccountListNodeAgentSkusResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AccountListNodeAgentSkusResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AccountListNodeAgentSkusResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AccountListNodeAgentSkusResultIterator) Response() AccountListNodeAgentSkusResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AccountListNodeAgentSkusResultIterator) Value() NodeAgentSku {
	if !iter.page.NotDone() {
		return NodeAgentSku{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AccountListNodeAgentSkusResultIterator type.
func NewAccountListNodeAgentSkusResultIterator(page AccountListNodeAgentSkusResultPage) AccountListNodeAgentSkusResultIterator {
	return AccountListNodeAgentSkusResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (alnasr AccountListNodeAgentSkusResult) IsEmpty() bool {
	return alnasr.Value == nil || len(*alnasr.Value) == 0
}

// accountListNodeAgentSkusResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (alnasr AccountListNodeAgentSkusResult) accountListNodeAgentSkusResultPreparer(ctx context.Context) (*http.Request, error) {
	if alnasr.OdataNextLink == nil || len(to.String(alnasr.OdataNextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(alnasr.OdataNextLink)))
}

// AccountListNodeAgentSkusResultPage contains a page of NodeAgentSku values.
type AccountListNodeAgentSkusResultPage struct {
	fn     func(context.Context, AccountListNodeAgentSkusResult) (AccountListNodeAgentSkusResult, error)
	alnasr AccountListNodeAgentSkusResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AccountListNodeAgentSkusResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AccountListNodeAgentSkusResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.alnasr)
	if err != nil {
		return err
	}
	page.alnasr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AccountListNodeAgentSkusResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AccountListNodeAgentSkusResultPage) NotDone() bool {
	return !page.alnasr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AccountListNodeAgentSkusResultPage) Response() AccountListNodeAgentSkusResult {
	return page.alnasr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AccountListNodeAgentSkusResultPage) Values() []NodeAgentSku {
	if page.alnasr.IsEmpty() {
		return nil
	}
	return *page.alnasr.Value
}

// Creates a new instance of the AccountListNodeAgentSkusResultPage type.
func NewAccountListNodeAgentSkusResultPage(getNextPage func(context.Context, AccountListNodeAgentSkusResult) (AccountListNodeAgentSkusResult, error)) AccountListNodeAgentSkusResultPage {
	return AccountListNodeAgentSkusResultPage{fn: getNextPage}
}

// AffinityInformation ...
type AffinityInformation struct {
	// AffinityID - You can pass the affinityId of a compute node or task to indicate that this task needs to be placed close to the node or task.
	AffinityID *string `json:"affinityId,omitempty"`
}

// ApplicationListResult ...
type ApplicationListResult struct {
	autorest.Response `json:"-"`
	Value             *[]ApplicationSummary `json:"value,omitempty"`
	OdataNextLink     *string               `json:"odata.nextLink,omitempty"`
}

// ApplicationListResultIterator provides access to a complete listing of ApplicationSummary values.
type ApplicationListResultIterator struct {
	i    int
	page ApplicationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ApplicationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ApplicationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ApplicationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ApplicationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ApplicationListResultIterator) Response() ApplicationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ApplicationListResultIterator) Value() ApplicationSummary {
	if !iter.page.NotDone() {
		return ApplicationSummary{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ApplicationListResultIterator type.
func NewApplicationListResultIterator(page ApplicationListResultPage) ApplicationListResultIterator {
	return ApplicationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (alr ApplicationListResult) IsEmpty() bool {
	return alr.Value == nil || len(*alr.Value) == 0
}

// applicationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (alr ApplicationListResult) applicationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if alr.OdataNextLink == nil || len(to.String(alr.OdataNextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(alr.OdataNextLink)))
}

// ApplicationListResultPage contains a page of ApplicationSummary values.
type ApplicationListResultPage struct {
	fn  func(context.Context, ApplicationListResult) (ApplicationListResult, error)
	alr ApplicationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ApplicationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ApplicationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.alr)
	if err != nil {
		return err
	}
	page.alr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ApplicationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ApplicationListResultPage) NotDone() bool {
	return !page.alr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ApplicationListResultPage) Response() ApplicationListResult {
	return page.alr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ApplicationListResultPage) Values() []ApplicationSummary {
	if page.alr.IsEmpty() {
		return nil
	}
	return *page.alr.Value
}

// Creates a new instance of the ApplicationListResultPage type.
func NewApplicationListResultPage(getNextPage func(context.Context, ApplicationListResult) (ApplicationListResult, error)) ApplicationListResultPage {
	return ApplicationListResultPage{fn: getNextPage}
}

// ApplicationPackageReference ...
type ApplicationPackageReference struct {
	ApplicationID *string `json:"applicationId,omitempty"`
	// Version - If this is omitted, and no default version is specified for this application, the request fails with the error code InvalidApplicationPackageReferences. If you are calling the REST API directly, the HTTP status code is 409.
	Version *string `json:"version,omitempty"`
}

// ApplicationSummary ...
type ApplicationSummary struct {
	autorest.Response `json:"-"`
	ID                *string   `json:"id,omitempty"`
	DisplayName       *string   `json:"displayName,omitempty"`
	Versions          *[]string `json:"versions,omitempty"`
}

// AuthenticationTokenSettings ...
type AuthenticationTokenSettings struct {
	// Access - The authentication token grants access to a limited set of Batch service operations. Currently the only supported value for the access property is 'job', which grants access to all operations related to the job which contains the task.
	Access *[]AccessScope `json:"access,omitempty"`
}

// AutoPoolSpecification ...
type AutoPoolSpecification struct {
	// AutoPoolIDPrefix - The Batch service assigns each auto pool a unique identifier on creation. To distinguish between pools created for different purposes, you can specify this element to add a prefix to the id that is assigned. The prefix can be up to 20 characters long.
	AutoPoolIDPrefix *string `json:"autoPoolIdPrefix,omitempty"`
	// PoolLifetimeOption - When the pool lifetime scope is jobSchedule level, the Batch service keeps track of the last autopool created for the job schedule, and deletes that pool when the job schedule completes. Batch will also delete this pool if the user updates the auto pool specification in a way that changes this lifetime. Possible values include: 'PoolLifetimeOptionJobSchedule', 'PoolLifetimeOptionJob'
	PoolLifetimeOption PoolLifetimeOption `json:"poolLifetimeOption,omitempty"`
	// KeepAlive - If false, the Batch service deletes the pool once its lifetime (as determined by the poolLifetimeOption setting) expires; that is, when the job or job schedule completes. If true, the Batch service does not delete the pool automatically. It is up to the user to delete auto pools created with this option.
	KeepAlive *bool              `json:"keepAlive,omitempty"`
	Pool      *PoolSpecification `json:"pool,omitempty"`
}

// AutoScaleRun ...
type AutoScaleRun struct {
	autorest.Response `json:"-"`
	Timestamp         *date.Time `json:"timestamp,omitempty"`
	// Results - Each variable value is returned in the form $variable=value, and variables are separated by semicolons.
	Results *string            `json:"results,omitempty"`
	Error   *AutoScaleRunError `json:"error,omitempty"`
}

// AutoScaleRunError ...
type AutoScaleRunError struct {
	Code    *string          `json:"code,omitempty"`
	Message *string          `json:"message,omitempty"`
	Values  *[]NameValuePair `json:"values,omitempty"`
}

// AutoUserSpecification ...
type AutoUserSpecification struct {
	// Scope - pool - specifies that the task runs as the common auto user account which is created on every node in a pool. task - specifies that the service should create a new user for the task. The default value is task. Possible values include: 'Task', 'Pool'
	Scope AutoUserScope `json:"scope,omitempty"`
	// ElevationLevel - nonAdmin - The auto user is a standard user without elevated access. admin - The auto user is a user with elevated access and operates with full Administrator permissions. The default value is nonAdmin. Possible values include: 'NonAdmin', 'Admin'
	ElevationLevel ElevationLevel `json:"elevationLevel,omitempty"`
}

// Certificate a certificate that can be installed on compute nodes and can be used to authenticate
// operations on the machine.
type Certificate struct {
	autorest.Response   `json:"-"`
	Thumbprint          *string `json:"thumbprint,omitempty"`
	ThumbprintAlgorithm *string `json:"thumbprintAlgorithm,omitempty"`
	URL                 *string `json:"url,omitempty"`
	// State - Possible values include: 'Active', 'Deleting', 'DeleteFailed'
	State               CertificateState `json:"state,omitempty"`
	StateTransitionTime *date.Time       `json:"stateTransitionTime,omitempty"`
	// PreviousState - This property is not set if the certificate is in its initial active state. Possible values include: 'Active', 'Deleting', 'DeleteFailed'
	PreviousState CertificateState `json:"previousState,omitempty"`
	// PreviousStateTransitionTime - This property is not set if the certificate is in its initial Active state.
	PreviousStateTransitionTime *date.Time `json:"previousStateTransitionTime,omitempty"`
	PublicData                  *string    `json:"publicData,omitempty"`
	// DeleteCertificateError - This property is set only if the certificate is in the DeleteFailed state.
	DeleteCertificateError *DeleteCertificateError `json:"deleteCertificateError,omitempty"`
}

// CertificateAddParameter ...
type CertificateAddParameter struct {
	Thumbprint          *string `json:"thumbprint,omitempty"`
	ThumbprintAlgorithm *string `json:"thumbprintAlgorithm,omitempty"`
	Data                *string `json:"data,omitempty"`
	// CertificateFormat - Possible values include: 'Pfx', 'Cer'
	CertificateFormat CertificateFormat `json:"certificateFormat,omitempty"`
	// Password - This is required if the certificate format is pfx. It should be omitted if the certificate format is cer.
	Password *string `json:"password,omitempty"`
}

// CertificateListResult ...
type CertificateListResult struct {
	autorest.Response `json:"-"`
	Value             *[]Certificate `json:"value,omitempty"`
	OdataNextLink     *string        `json:"odata.nextLink,omitempty"`
}

// CertificateListResultIterator provides access to a complete listing of Certificate values.
type CertificateListResultIterator struct {
	i    int
	page CertificateListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *CertificateListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CertificateListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *CertificateListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter CertificateListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter CertificateListResultIterator) Response() CertificateListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter CertificateListResultIterator) Value() Certificate {
	if !iter.page.NotDone() {
		return Certificate{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the CertificateListResultIterator type.
func NewCertificateListResultIterator(page CertificateListResultPage) CertificateListResultIterator {
	return CertificateListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (clr CertificateListResult) IsEmpty() bool {
	return clr.Value == nil || len(*clr.Value) == 0
}

// certificateListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (clr CertificateListResult) certificateListResultPreparer(ctx context.Context) (*http.Request, error) {
	if clr.OdataNextLink == nil || len(to.String(clr.OdataNextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(clr.OdataNextLink)))
}

// CertificateListResultPage contains a page of Certificate values.
type CertificateListResultPage struct {
	fn  func(context.Context, CertificateListResult) (CertificateListResult, error)
	clr CertificateListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *CertificateListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CertificateListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.clr)
	if err != nil {
		return err
	}
	page.clr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *CertificateListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page CertificateListResultPage) NotDone() bool {
	return !page.clr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page CertificateListResultPage) Response() CertificateListResult {
	return page.clr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page CertificateListResultPage) Values() []Certificate {
	if page.clr.IsEmpty() {
		return nil
	}
	return *page.clr.Value
}

// Creates a new instance of the CertificateListResultPage type.
func NewCertificateListResultPage(getNextPage func(context.Context, CertificateListResult) (CertificateListResult, error)) CertificateListResultPage {
	return CertificateListResultPage{fn: getNextPage}
}

// CertificateReference ...
type CertificateReference struct {
	Thumbprint          *string `json:"thumbprint,omitempty"`
	ThumbprintAlgorithm *string `json:"thumbprintAlgorithm,omitempty"`
	// StoreLocation - The default value is currentUser. This property is applicable only for pools configured with Windows nodes (that is, created with cloudServiceConfiguration, or with virtualMachineConfiguration using a Windows image reference). For Linux compute nodes, the certificates are stored in a directory inside the task working directory and an environment variable AZ_BATCH_CERTIFICATES_DIR is supplied to the task to query for this location. For certificates with visibility of 'remoteUser', a 'certs' directory is created in the user's home directory (e.g., /home/{user-name}/certs) and certificates are placed in that directory. Possible values include: 'CurrentUser', 'LocalMachine'
	StoreLocation CertificateStoreLocation `json:"storeLocation,omitempty"`
	// StoreName - The default value is My. This property is applicable only for pools configured with Windows nodes (that is, created with cloudServiceConfiguration, or with virtualMachineConfiguration using a Windows image reference).
	StoreName *string `json:"storeName,omitempty"`
	// Visibility - The default is all accounts.
	Visibility *[]CertificateVisibility `json:"visibility,omitempty"`
}

// CloudJob ...
type CloudJob struct {
	autorest.Response `json:"-"`
	// ID - The ID can contain any combination of alphanumeric characters including hyphens and underscores, and cannot contain more than 64 characters. It is common to use a GUID for the id.
	ID                   *string `json:"id,omitempty"`
	DisplayName          *string `json:"displayName,omitempty"`
	UsesTaskDependencies *bool   `json:"usesTaskDependencies,omitempty"`
	URL                  *string `json:"url,omitempty"`
	// ETag - This is an opaque string. You can use it to detect whether the job has changed between requests. In particular, you can be pass the ETag when updating a job to specify that your changes should take effect only if nobody else has modified the job in the meantime.
	ETag *string `json:"eTag,omitempty"`
	// LastModified - This is the last time at which the job level data, such as the job state or priority, changed. It does not factor in task-level changes such as adding new tasks or tasks changing state.
	LastModified *date.Time `json:"lastModified,omitempty"`
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// State - Possible values include: 'JobStateActive', 'JobStateDisabling', 'JobStateDisabled', 'JobStateEnabling', 'JobStateTerminating', 'JobStateCompleted', 'JobStateDeleting'
	State               JobState   `json:"state,omitempty"`
	StateTransitionTime *date.Time `json:"stateTransitionTime,omitempty"`
	// PreviousState - This property is not set if the job is in its initial Active state. Possible values include: 'JobStateActive', 'JobStateDisabling', 'JobStateDisabled', 'JobStateEnabling', 'JobStateTerminating', 'JobStateCompleted', 'JobStateDeleting'
	PreviousState JobState `json:"previousState,omitempty"`
	// PreviousStateTransitionTime - This property is not set if the job is in its initial Active state.
	PreviousStateTransitionTime *date.Time `json:"previousStateTransitionTime,omitempty"`
	// Priority - Priority values can range from -1000 to 1000, with -1000 being the lowest priority and 1000 being the highest priority. The default value is 0.
	Priority       *int32          `json:"priority,omitempty"`
	Constraints    *JobConstraints `json:"constraints,omitempty"`
	JobManagerTask *JobManagerTask `json:"jobManagerTask,omitempty"`
	// JobPreparationTask - The Job Preparation task is a special task run on each node before any other task of the job.
	JobPreparationTask *JobPreparationTask `json:"jobPreparationTask,omitempty"`
	// JobReleaseTask - The Job Release task is a special task run at the end of the job on each node that has run any other task of the job.
	JobReleaseTask            *JobReleaseTask       `json:"jobReleaseTask,omitempty"`
	CommonEnvironmentSettings *[]EnvironmentSetting `json:"commonEnvironmentSettings,omitempty"`
	PoolInfo                  *PoolInformation      `json:"poolInfo,omitempty"`
	// OnAllTasksComplete - noAction - do nothing. The job remains active unless terminated or disabled by some other means. terminateJob - terminate the job. The job's terminateReason is set to 'AllTasksComplete'. The default is noAction. Possible values include: 'NoAction', 'TerminateJob'
	OnAllTasksComplete OnAllTasksComplete `json:"onAllTasksComplete,omitempty"`
	// OnTaskFailure - noAction - do nothing. performExitOptionsJobAction - take the action associated with the task exit condition in the task's exitConditions collection. (This may still result in no action being taken, if that is what the task specifies.) The default is noAction. Possible values include: 'OnTaskFailureNoAction', 'OnTaskFailurePerformExitOptionsJobAction'
	OnTaskFailure OnTaskFailure `json:"onTaskFailure,omitempty"`
	// Metadata - The Batch service does not assign any meaning to metadata; it is solely for the use of user code.
	Metadata      *[]MetadataItem          `json:"metadata,omitempty"`
	ExecutionInfo *JobExecutionInformation `json:"executionInfo,omitempty"`
	Stats         *JobStatistics           `json:"stats,omitempty"`
}

// CloudJobListPreparationAndReleaseTaskStatusResult ...
type CloudJobListPreparationAndReleaseTaskStatusResult struct {
	autorest.Response `json:"-"`
	Value             *[]JobPreparationAndReleaseTaskExecutionInformation `json:"value,omitempty"`
	OdataNextLink     *string                                             `json:"odata.nextLink,omitempty"`
}

// CloudJobListPreparationAndReleaseTaskStatusResultIterator provides access to a complete listing of
// JobPreparationAndReleaseTaskExecutionInformation values.
type CloudJobListPreparationAndReleaseTaskStatusResultIterator struct {
	i    int
	page CloudJobListPreparationAndReleaseTaskStatusResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *CloudJobListPreparationAndReleaseTaskStatusResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CloudJobListPreparationAndReleaseTaskStatusResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *CloudJobListPreparationAndReleaseTaskStatusResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter CloudJobListPreparationAndReleaseTaskStatusResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter CloudJobListPreparationAndReleaseTaskStatusResultIterator) Response() CloudJobListPreparationAndReleaseTaskStatusResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter CloudJobListPreparationAndReleaseTaskStatusResultIterator) Value() JobPreparationAndReleaseTaskExecutionInformation {
	if !iter.page.NotDone() {
		return JobPreparationAndReleaseTaskExecutionInformation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the CloudJobListPreparationAndReleaseTaskStatusResultIterator type.
func NewCloudJobListPreparationAndReleaseTaskStatusResultIterator(page CloudJobListPreparationAndReleaseTaskStatusResultPage) CloudJobListPreparationAndReleaseTaskStatusResultIterator {
	return CloudJobListPreparationAndReleaseTaskStatusResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (cjlpartsr CloudJobListPreparationAndReleaseTaskStatusResult) IsEmpty() bool {
	return cjlpartsr.Value == nil || len(*cjlpartsr.Value) == 0
}

// cloudJobListPreparationAndReleaseTaskStatusResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (cjlpartsr CloudJobListPreparationAndReleaseTaskStatusResult) cloudJobListPreparationAndReleaseTaskStatusResultPreparer(ctx context.Context) (*http.Request, error) {
	if cjlpartsr.OdataNextLink == nil || len(to.String(cjlpartsr.OdataNextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(cjlpartsr.OdataNextLink)))
}

// CloudJobListPreparationAndReleaseTaskStatusResultPage contains a page of
// JobPreparationAndReleaseTaskExecutionInformation values.
type CloudJobListPreparationAndReleaseTaskStatusResultPage struct {
	fn        func(context.Context, CloudJobListPreparationAndReleaseTaskStatusResult) (CloudJobListPreparationAndReleaseTaskStatusResult, error)
	cjlpartsr CloudJobListPreparationAndReleaseTaskStatusResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *CloudJobListPreparationAndReleaseTaskStatusResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CloudJobListPreparationAndReleaseTaskStatusResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.cjlpartsr)
	if err != nil {
		return err
	}
	page.cjlpartsr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *CloudJobListPreparationAndReleaseTaskStatusResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page CloudJobListPreparationAndReleaseTaskStatusResultPage) NotDone() bool {
	return !page.cjlpartsr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page CloudJobListPreparationAndReleaseTaskStatusResultPage) Response() CloudJobListPreparationAndReleaseTaskStatusResult {
	return page.cjlpartsr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page CloudJobListPreparationAndReleaseTaskStatusResultPage) Values() []JobPreparationAndReleaseTaskExecutionInformation {
	if page.cjlpartsr.IsEmpty() {
		return nil
	}
	return *page.cjlpartsr.Value
}

// Creates a new instance of the CloudJobListPreparationAndReleaseTaskStatusResultPage type.
func NewCloudJobListPreparationAndReleaseTaskStatusResultPage(getNextPage func(context.Context, CloudJobListPreparationAndReleaseTaskStatusResult) (CloudJobListPreparationAndReleaseTaskStatusResult, error)) CloudJobListPreparationAndReleaseTaskStatusResultPage {
	return CloudJobListPreparationAndReleaseTaskStatusResultPage{fn: getNextPage}
}

// CloudJobListResult ...
type CloudJobListResult struct {
	autorest.Response `json:"-"`
	Value             *[]CloudJob `json:"value,omitempty"`
	OdataNextLink     *string     `json:"odata.nextLink,omitempty"`
}

// CloudJobListResultIterator provides access to a complete listing of CloudJob values.
type CloudJobListResultIterator struct {
	i    int
	page CloudJobListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *CloudJobListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CloudJobListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *CloudJobListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter CloudJobListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter CloudJobListResultIterator) Response() CloudJobListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter CloudJobListResultIterator) Value() CloudJob {
	if !iter.page.NotDone() {
		return CloudJob{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the CloudJobListResultIterator type.
func NewCloudJobListResultIterator(page CloudJobListResultPage) CloudJobListResultIterator {
	return CloudJobListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (cjlr CloudJobListResult) IsEmpty() bool {
	return cjlr.Value == nil || len(*cjlr.Value) == 0
}

// cloudJobListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (cjlr CloudJobListResult) cloudJobListResultPreparer(ctx context.Context) (*http.Request, error) {
	if cjlr.OdataNextLink == nil || len(to.String(cjlr.OdataNextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(cjlr.OdataNextLink)))
}

// CloudJobListResultPage contains a page of CloudJob values.
type CloudJobListResultPage struct {
	fn   func(context.Context, CloudJobListResult) (CloudJobListResult, error)
	cjlr CloudJobListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *CloudJobListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CloudJobListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.cjlr)
	if err != nil {
		return err
	}
	page.cjlr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *CloudJobListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page CloudJobListResultPage) NotDone() bool {
	return !page.cjlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page CloudJobListResultPage) Response() CloudJobListResult {
	return page.cjlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page CloudJobListResultPage) Values() []CloudJob {
	if page.cjlr.IsEmpty() {
		return nil
	}
	return *page.cjlr.Value
}

// Creates a new instance of the CloudJobListResultPage type.
func NewCloudJobListResultPage(getNextPage func(context.Context, CloudJobListResult) (CloudJobListResult, error)) CloudJobListResultPage {
	return CloudJobListResultPage{fn: getNextPage}
}

// CloudJobSchedule ...
type CloudJobSchedule struct {
	autorest.Response `json:"-"`
	// ID - It is common to use a GUID for the id.
	ID          *string `json:"id,omitempty"`
	DisplayName *string `json:"displayName,omitempty"`
	URL         *string `json:"url,omitempty"`
	// ETag - This is an opaque string. You can use it to detect whether the job schedule has changed between requests. In particular, you can be pass the ETag with an Update Job Schedule request to specify that your changes should take effect only if nobody else has modified the schedule in the meantime.
	ETag *string `json:"eTag,omitempty"`
	// LastModified - This is the last time at which the schedule level data, such as the job specification or recurrence information, changed. It does not factor in job-level changes such as new jobs being created or jobs changing state.
	LastModified *date.Time `json:"lastModified,omitempty"`
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// State - Possible values include: 'JobScheduleStateActive', 'JobScheduleStateCompleted', 'JobScheduleStateDisabled', 'JobScheduleStateTerminating', 'JobScheduleStateDeleting'
	State               JobScheduleState `json:"state,omitempty"`
	StateTransitionTime *date.Time       `json:"stateTransitionTime,omitempty"`
	// PreviousState - This property is not present if the job schedule is in its initial active state. Possible values include: 'JobScheduleStateActive', 'JobScheduleStateCompleted', 'JobScheduleStateDisabled', 'JobScheduleStateTerminating', 'JobScheduleStateDeleting'
	PreviousState JobScheduleState `json:"previousState,omitempty"`
	// PreviousStateTransitionTime - This property is not present if the job schedule is in its initial active state.
	PreviousStateTransitionTime *date.Time                       `json:"previousStateTransitionTime,omitempty"`
	Schedule                    *Schedule                        `json:"schedule,omitempty"`
	JobSpecification            *JobSpecification                `json:"jobSpecification,omitempty"`
	ExecutionInfo               *JobScheduleExecutionInformation `json:"executionInfo,omitempty"`
	// Metadata - The Batch service does not assign any meaning to metadata; it is solely for the use of user code.
	Metadata *[]MetadataItem        `json:"metadata,omitempty"`
	Stats    *JobScheduleStatistics `json:"stats,omitempty"`
}

// CloudJobScheduleListResult ...
type CloudJobScheduleListResult struct {
	autorest.Response `json:"-"`
	Value             *[]CloudJobSchedule `json:"value,omitempty"`
	OdataNextLink     *string             `json:"odata.nextLink,omitempty"`
}

// CloudJobScheduleListResultIterator provides access to a complete listing of CloudJobSchedule values.
type CloudJobScheduleListResultIterator struct {
	i    int
	page CloudJobScheduleListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *CloudJobScheduleListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CloudJobScheduleListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *CloudJobScheduleListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter CloudJobScheduleListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter CloudJobScheduleListResultIterator) Response() CloudJobScheduleListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter CloudJobScheduleListResultIterator) Value() CloudJobSchedule {
	if !iter.page.NotDone() {
		return CloudJobSchedule{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the CloudJobScheduleListResultIterator type.
func NewCloudJobScheduleListResultIterator(page CloudJobScheduleListResultPage) CloudJobScheduleListResultIterator {
	return CloudJobScheduleListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (cjslr CloudJobScheduleListResult) IsEmpty() bool {
	return cjslr.Value == nil || len(*cjslr.Value) == 0
}

// cloudJobScheduleListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (cjslr CloudJobScheduleListResult) cloudJobScheduleListResultPreparer(ctx context.Context) (*http.Request, error) {
	if cjslr.OdataNextLink == nil || len(to.String(cjslr.OdataNextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(cjslr.OdataNextLink)))
}

// CloudJobScheduleListResultPage contains a page of CloudJobSchedule values.
type CloudJobScheduleListResultPage struct {
	fn    func(context.Context, CloudJobScheduleListResult) (CloudJobScheduleListResult, error)
	cjslr CloudJobScheduleListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *CloudJobScheduleListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CloudJobScheduleListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.cjslr)
	if err != nil {
		return err
	}
	page.cjslr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *CloudJobScheduleListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page CloudJobScheduleListResultPage) NotDone() bool {
	return !page.cjslr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page CloudJobScheduleListResultPage) Response() CloudJobScheduleListResult {
	return page.cjslr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page CloudJobScheduleListResultPage) Values() []CloudJobSchedule {
	if page.cjslr.IsEmpty() {
		return nil
	}
	return *page.cjslr.Value
}

// Creates a new instance of the CloudJobScheduleListResultPage type.
func NewCloudJobScheduleListResultPage(getNextPage func(context.Context, CloudJobScheduleListResult) (CloudJobScheduleListResult, error)) CloudJobScheduleListResultPage {
	return CloudJobScheduleListResultPage{fn: getNextPage}
}

// CloudPool ...
type CloudPool struct {
	autorest.Response `json:"-"`
	// ID - The ID can contain any combination of alphanumeric characters including hyphens and underscores, and cannot contain more than 64 characters. It is common to use a GUID for the id.
	ID *string `json:"id,omitempty"`
	// DisplayName - The display name need not be unique and can contain any Unicode characters up to a maximum length of 1024.
	DisplayName *string `json:"displayName,omitempty"`
	URL         *string `json:"url,omitempty"`
	// ETag - This is an opaque string. You can use it to detect whether the pool has changed between requests. In particular, you can be pass the ETag when updating a pool to specify that your changes should take effect only if nobody else has modified the pool in the meantime.
	ETag *string `json:"eTag,omitempty"`
	// LastModified - This is the last time at which the pool level data, such as the targetDedicatedNodes or enableAutoscale settings, changed. It does not factor in node-level changes such as a compute node changing state.
	LastModified *date.Time `json:"lastModified,omitempty"`
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// State - active - The pool is available to run tasks subject to the availability of compute nodes. deleting - The user has requested that the pool be deleted, but the delete operation has not yet completed. upgrading - The user has requested that the operating system of the pool's nodes be upgraded, but the upgrade operation has not yet completed (that is, some nodes in the pool have not yet been upgraded). While upgrading, the pool may be able to run tasks (with reduced capacity) but this is not guaranteed. Possible values include: 'PoolStateActive', 'PoolStateDeleting', 'PoolStateUpgrading'
	State               PoolState  `json:"state,omitempty"`
	StateTransitionTime *date.Time `json:"stateTransitionTime,omitempty"`
	// AllocationState - steady - The pool is not resizing. There are no changes to the number of nodes in the pool in progress. A pool enters this state when it is created and when no operations are being performed on the pool to change the number of dedicated nodes. resizing - The pool is resizing; that is, compute nodes are being added to or removed from the pool. stopping - The pool was resizing, but the user has requested that the resize be stopped, but the stop request has not yet been completed. Possible values include: 'Steady', 'Resizing', 'Stopping'
	AllocationState               AllocationState `json:"allocationState,omitempty"`
	AllocationStateTransitionTime *date.Time      `json:"allocationStateTransitionTime,omitempty"`
	// VMSize - For information about available sizes of virtual machines for Cloud Services pools (pools created with cloudServiceConfiguration), see Sizes for Cloud Services (http://azure.microsoft.com/documentation/articles/cloud-services-sizes-specs/). Batch supports all Cloud Services VM sizes except ExtraSmall, A1V2 and A2V2. For information about available VM sizes for pools using images from the Virtual Machines Marketplace (pools created with virtualMachineConfiguration) see Sizes for Virtual Machines (Linux) (https://azure.microsoft.com/documentation/articles/virtual-machines-linux-sizes/) or Sizes for Virtual Machines (Windows) (https://azure.microsoft.com/documentation/articles/virtual-machines-windows-sizes/). Batch supports all Azure VM sizes except STANDARD_A0 and those with premium storage (STANDARD_GS, STANDARD_DS, and STANDARD_DSV2 series).
	VMSize *string `json:"vmSize,omitempty"`
	// CloudServiceConfiguration - This property and virtualMachineConfiguration are mutually exclusive and one of the properties must be specified. This property cannot be specified if the Batch account was created with its poolAllocationMode property set to 'UserSubscription'.
	CloudServiceConfiguration *CloudServiceConfiguration `json:"cloudServiceConfiguration,omitempty"`
	// VirtualMachineConfiguration - This property and cloudServiceConfiguration are mutually exclusive and one of the properties must be specified.
	VirtualMachineConfiguration *VirtualMachineConfiguration `json:"virtualMachineConfiguration,omitempty"`
	// ResizeTimeout - This is the timeout for the most recent resize operation. (The initial sizing when the pool is created counts as a resize.) The default value is 15 minutes.
	ResizeTimeout *string `json:"resizeTimeout,omitempty"`
	// ResizeErrors - This property is set only if one or more errors occurred during the last pool resize, and only when the pool allocationState is Steady.
	ResizeErrors          *[]ResizeError `json:"resizeErrors,omitempty"`
	CurrentDedicatedNodes *int32         `json:"currentDedicatedNodes,omitempty"`
	// CurrentLowPriorityNodes - Low-priority compute nodes which have been preempted are included in this count.
	CurrentLowPriorityNodes *int32 `json:"currentLowPriorityNodes,omitempty"`
	TargetDedicatedNodes    *int32 `json:"targetDedicatedNodes,omitempty"`
	TargetLowPriorityNodes  *int32 `json:"targetLowPriorityNodes,omitempty"`
	// EnableAutoScale - If false, at least one of targetDedicateNodes and targetLowPriorityNodes must be specified. If true, the autoScaleFormula property is required and the pool automatically resizes according to the formula. The default value is false.
	EnableAutoScale *bool `json:"enableAutoScale,omitempty"`
	// AutoScaleFormula - This property is set only if the pool automatically scales, i.e. enableAutoScale is true.
	AutoScaleFormula *string `json:"autoScaleFormula,omitempty"`
	// AutoScaleEvaluationInterval - This property is set only if the pool automatically scales, i.e. enableAutoScale is true.
	AutoScaleEvaluationInterval *string `json:"autoScaleEvaluationInterval,omitempty"`
	// AutoScaleRun - This property is set only if the pool automatically scales, i.e. enableAutoScale is true.
	AutoScaleRun *AutoScaleRun `json:"autoScaleRun,omitempty"`
	// EnableInterNodeCommunication - This imposes restrictions on which nodes can be assigned to the pool. Specifying this value can reduce the chance of the requested number of nodes to be allocated in the pool.
	EnableInterNodeCommunication *bool                 `json:"enableInterNodeCommunication,omitempty"`
	NetworkConfiguration         *NetworkConfiguration `json:"networkConfiguration,omitempty"`
	StartTask                    *StartTask            `json:"startTask,omitempty"`
	// CertificateReferences - For Windows compute nodes, the Batch service installs the certificates to the specified certificate store and location. For Linux compute nodes, the certificates are stored in a directory inside the task working directory and an environment variable AZ_BATCH_CERTIFICATES_DIR is supplied to the task to query for this location. For certificates with visibility of 'remoteUser', a 'certs' directory is created in the user's home directory (e.g., /home/{user-name}/certs) and certificates are placed in that directory.
	CertificateReferences        *[]CertificateReference        `json:"certificateReferences,omitempty"`
	ApplicationPackageReferences *[]ApplicationPackageReference `json:"applicationPackageReferences,omitempty"`
	// ApplicationLicenses - The list of application licenses must be a subset of available Batch service application licenses. If a license is requested which is not supported, pool creation will fail.
	ApplicationLicenses  *[]string             `json:"applicationLicenses,omitempty"`
	MaxTasksPerNode      *int32                `json:"maxTasksPerNode,omitempty"`
	TaskSchedulingPolicy *TaskSchedulingPolicy `json:"taskSchedulingPolicy,omitempty"`
	UserAccounts         *[]UserAccount        `json:"userAccounts,omitempty"`
	Metadata             *[]MetadataItem       `json:"metadata,omitempty"`
	Stats                *PoolStatistics       `json:"stats,omitempty"`
}

// CloudPoolListResult ...
type CloudPoolListResult struct {
	autorest.Response `json:"-"`
	Value             *[]CloudPool `json:"value,omitempty"`
	OdataNextLink     *string      `json:"odata.nextLink,omitempty"`
}

// CloudPoolListResultIterator provides access to a complete listing of CloudPool values.
type CloudPoolListResultIterator struct {
	i    int
	page CloudPoolListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *CloudPoolListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CloudPoolListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *CloudPoolListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter CloudPoolListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter CloudPoolListResultIterator) Response() CloudPoolListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter CloudPoolListResultIterator) Value() CloudPool {
	if !iter.page.NotDone() {
		return CloudPool{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the CloudPoolListResultIterator type.
func NewCloudPoolListResultIterator(page CloudPoolListResultPage) CloudPoolListResultIterator {
	return CloudPoolListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (cplr CloudPoolListResult) IsEmpty() bool {
	return cplr.Value == nil || len(*cplr.Value) == 0
}

// cloudPoolListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (cplr CloudPoolListResult) cloudPoolListResultPreparer(ctx context.Context) (*http.Request, error) {
	if cplr.OdataNextLink == nil || len(to.String(cplr.OdataNextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(cplr.OdataNextLink)))
}

// CloudPoolListResultPage contains a page of CloudPool values.
type CloudPoolListResultPage struct {
	fn   func(context.Context, CloudPoolListResult) (CloudPoolListResult, error)
	cplr CloudPoolListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *CloudPoolListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CloudPoolListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.cplr)
	if err != nil {
		return err
	}
	page.cplr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *CloudPoolListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page CloudPoolListResultPage) NotDone() bool {
	return !page.cplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page CloudPoolListResultPage) Response() CloudPoolListResult {
	return page.cplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page CloudPoolListResultPage) Values() []CloudPool {
	if page.cplr.IsEmpty() {
		return nil
	}
	return *page.cplr.Value
}

// Creates a new instance of the CloudPoolListResultPage type.
func NewCloudPoolListResultPage(getNextPage func(context.Context, CloudPoolListResult) (CloudPoolListResult, error)) CloudPoolListResultPage {
	return CloudPoolListResultPage{fn: getNextPage}
}

// CloudServiceConfiguration ...
type CloudServiceConfiguration struct {
	// OsFamily - Possible values are: 2 - OS Family 2, equivalent to Windows Server 2008 R2 SP1. 3 - OS Family 3, equivalent to Windows Server 2012. 4 - OS Family 4, equivalent to Windows Server 2012 R2. 5 - OS Family 5, equivalent to Windows Server 2016. For more information, see Azure Guest OS Releases (https://azure.microsoft.com/documentation/articles/cloud-services-guestos-update-matrix/#releases).
	OsFamily *string `json:"osFamily,omitempty"`
	// TargetOSVersion - The default value is * which specifies the latest operating system version for the specified OS family.
	TargetOSVersion *string `json:"targetOSVersion,omitempty"`
	// CurrentOSVersion - This may differ from targetOSVersion if the pool state is Upgrading. In this case some virtual machines may be on the targetOSVersion and some may be on the currentOSVersion during the upgrade process. Once all virtual machines have upgraded, currentOSVersion is updated to be the same as targetOSVersion.
	CurrentOSVersion *string `json:"currentOSVersion,omitempty"`
}

// CloudTask ...
type CloudTask struct {
	autorest.Response `json:"-"`
	// ID - The ID can contain any combination of alphanumeric characters including hyphens and underscores, and cannot contain more than 64 characters.
	ID *string `json:"id,omitempty"`
	// DisplayName - The display name need not be unique and can contain any Unicode characters up to a maximum length of 1024.
	DisplayName *string `json:"displayName,omitempty"`
	URL         *string `json:"url,omitempty"`
	// ETag - This is an opaque string. You can use it to detect whether the task has changed between requests. In particular, you can be pass the ETag when updating a task to specify that your changes should take effect only if nobody else has modified the task in the meantime.
	ETag         *string    `json:"eTag,omitempty"`
	LastModified *date.Time `json:"lastModified,omitempty"`
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// ExitConditions - How the Batch service should respond when the task completes.
	ExitConditions *ExitConditions `json:"exitConditions,omitempty"`
	// State - Possible values include: 'TaskStateActive', 'TaskStatePreparing', 'TaskStateRunning', 'TaskStateCompleted'
	State               TaskState  `json:"state,omitempty"`
	StateTransitionTime *date.Time `json:"stateTransitionTime,omitempty"`
	// PreviousState - This property is not set if the task is in its initial Active state. Possible values include: 'TaskStateActive', 'TaskStatePreparing', 'TaskStateRunning', 'TaskStateCompleted'
	PreviousState TaskState `json:"previousState,omitempty"`
	// PreviousStateTransitionTime - This property is not set if the task is in its initial Active state.
	PreviousStateTransitionTime *date.Time `json:"previousStateTransitionTime,omitempty"`
	// CommandLine - For multi-instance tasks, the command line is executed as the primary task, after the primary task and all subtasks have finished executing the coordination command line. The command line does not run under a shell, and therefore cannot take advantage of shell features such as environment variable expansion. If you want to take advantage of such features, you should invoke the shell in the command line, for example using "cmd /c MyCommand" in Windows or "/bin/sh -c MyCommand" in Linux.
	CommandLine *string `json:"commandLine,omitempty"`
	// ResourceFiles - For multi-instance tasks, the resource files will only be downloaded to the compute node on which the primary task is executed.
	ResourceFiles *[]ResourceFile `json:"resourceFiles,omitempty"`
	// OutputFiles - For multi-instance tasks, the files will only be uploaded from the compute node on which the primary task is executed.
	OutputFiles         *[]OutputFile         `json:"outputFiles,omitempty"`
	EnvironmentSettings *[]EnvironmentSetting `json:"environmentSettings,omitempty"`
	AffinityInfo        *AffinityInformation  `json:"affinityInfo,omitempty"`
	Constraints         *TaskConstraints      `json:"constraints,omitempty"`
	// UserIdentity - If omitted, the task runs as a non-administrative user unique to the task.
	UserIdentity          *UserIdentity             `json:"userIdentity,omitempty"`
	ExecutionInfo         *TaskExecutionInformation `json:"executionInfo,omitempty"`
	NodeInfo              *ComputeNodeInformation   `json:"nodeInfo,omitempty"`
	MultiInstanceSettings *MultiInstanceSettings    `json:"multiInstanceSettings,omitempty"`
	Stats                 *TaskStatistics           `json:"stats,omitempty"`
	// DependsOn - This task will not be scheduled until all tasks that it depends on have completed successfully. If any of those tasks fail and exhaust their retry counts, this task will never be scheduled.
	DependsOn                    *TaskDependencies              `json:"dependsOn,omitempty"`
	ApplicationPackageReferences *[]ApplicationPackageReference `json:"applicationPackageReferences,omitempty"`
	// AuthenticationTokenSettings - If this property is set, the Batch service provides the task with an authentication token which can be used to authenticate Batch service operations without requiring an account access key. The token is provided via the AZ_BATCH_AUTHENTICATION_TOKEN environment variable. The operations that the task can carry out using the token depend on the settings. For example, a task can request job permissions in order to add other tasks to the job, or check the status of the job or of other tasks under the job.
	AuthenticationTokenSettings *AuthenticationTokenSettings `json:"authenticationTokenSettings,omitempty"`
}

// CloudTaskListResult ...
type CloudTaskListResult struct {
	autorest.Response `json:"-"`
	Value             *[]CloudTask `json:"value,omitempty"`
	OdataNextLink     *string      `json:"odata.nextLink,omitempty"`
}

// CloudTaskListResultIterator provides access to a complete listing of CloudTask values.
type CloudTaskListResultIterator struct {
	i    int
	page CloudTaskListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *CloudTaskListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CloudTaskListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *CloudTaskListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter CloudTaskListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter CloudTaskListResultIterator) Response() CloudTaskListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter CloudTaskListResultIterator) Value() CloudTask {
	if !iter.page.NotDone() {
		return CloudTask{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the CloudTaskListResultIterator type.
func NewCloudTaskListResultIterator(page CloudTaskListResultPage) CloudTaskListResultIterator {
	return CloudTaskListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ctlr CloudTaskListResult) IsEmpty() bool {
	return ctlr.Value == nil || len(*ctlr.Value) == 0
}

// cloudTaskListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ctlr CloudTaskListResult) cloudTaskListResultPreparer(ctx context.Context) (*http.Request, error) {
	if ctlr.OdataNextLink == nil || len(to.String(ctlr.OdataNextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ctlr.OdataNextLink)))
}

// CloudTaskListResultPage contains a page of CloudTask values.
type CloudTaskListResultPage struct {
	fn   func(context.Context, CloudTaskListResult) (CloudTaskListResult, error)
	ctlr CloudTaskListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *CloudTaskListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CloudTaskListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.ctlr)
	if err != nil {
		return err
	}
	page.ctlr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *CloudTaskListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page CloudTaskListResultPage) NotDone() bool {
	return !page.ctlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page CloudTaskListResultPage) Response() CloudTaskListResult {
	return page.ctlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page CloudTaskListResultPage) Values() []CloudTask {
	if page.ctlr.IsEmpty() {
		return nil
	}
	return *page.ctlr.Value
}

// Creates a new instance of the CloudTaskListResultPage type.
func NewCloudTaskListResultPage(getNextPage func(context.Context, CloudTaskListResult) (CloudTaskListResult, error)) CloudTaskListResultPage {
	return CloudTaskListResultPage{fn: getNextPage}
}

// CloudTaskListSubtasksResult ...
type CloudTaskListSubtasksResult struct {
	autorest.Response `json:"-"`
	Value             *[]SubtaskInformation `json:"value,omitempty"`
}

// ComputeNode ...
type ComputeNode struct {
	autorest.Response `json:"-"`
	// ID - Every node that is added to a pool is assigned a unique ID. Whenever a node is removed from a pool, all of its local files are deleted, and the ID is reclaimed and could be reused for new nodes.
	ID  *string `json:"id,omitempty"`
	URL *string `json:"url,omitempty"`
	// State - Possible values include: 'Idle', 'Rebooting', 'Reimaging', 'Running', 'Unusable', 'Creating', 'Starting', 'WaitingForStartTask', 'StartTaskFailed', 'Unknown', 'LeavingPool', 'Offline', 'Preempted'
	State ComputeNodeState `json:"state,omitempty"`
	// SchedulingState - enabled - Tasks can be scheduled on the node. disabled - No new tasks will be scheduled on the node. Tasks already running on the node may still run to completion. All nodes start with scheduling enabled. Possible values include: 'Enabled', 'Disabled'
	SchedulingState     SchedulingState `json:"schedulingState,omitempty"`
	StateTransitionTime *date.Time      `json:"stateTransitionTime,omitempty"`
	// LastBootTime - This property may not be present if the node state is unusable.
	LastBootTime   *date.Time `json:"lastBootTime,omitempty"`
	AllocationTime *date.Time `json:"allocationTime,omitempty"`
	// IPAddress - Every node that is added to a pool is assigned a unique IP address. Whenever a node is removed from a pool, all of its local files are deleted, and the IP address is reclaimed and could be reused for new nodes.
	IPAddress  *string `json:"ipAddress,omitempty"`
	AffinityID *string `json:"affinityId,omitempty"`
	// VMSize - For information about available sizes of virtual machines for Cloud Services pools (pools created with cloudServiceConfiguration), see Sizes for Cloud Services (http://azure.microsoft.com/documentation/articles/cloud-services-sizes-specs/). Batch supports all Cloud Services VM sizes except ExtraSmall, A1V2 and A2V2. For information about available VM sizes for pools using images from the Virtual Machines Marketplace (pools created with virtualMachineConfiguration) see Sizes for Virtual Machines (Linux) (https://azure.microsoft.com/documentation/articles/virtual-machines-linux-sizes/) or Sizes for Virtual Machines (Windows) (https://azure.microsoft.com/documentation/articles/virtual-machines-windows-sizes/). Batch supports all Azure VM sizes except STANDARD_A0 and those with premium storage (STANDARD_GS, STANDARD_DS, and STANDARD_DSV2 series).
	VMSize              *string               `json:"vmSize,omitempty"`
	TotalTasksRun       *int32                `json:"totalTasksRun,omitempty"`
	RunningTasksCount   *int32                `json:"runningTasksCount,omitempty"`
	TotalTasksSucceeded *int32                `json:"totalTasksSucceeded,omitempty"`
	RecentTasks         *[]TaskInformation    `json:"recentTasks,omitempty"`
	StartTask           *StartTask            `json:"startTask,omitempty"`
	StartTaskInfo       *StartTaskInformation `json:"startTaskInfo,omitempty"`
	// CertificateReferences - For Windows compute nodes, the Batch service installs the certificates to the specified certificate store and location. For Linux compute nodes, the certificates are stored in a directory inside the task working directory and an environment variable AZ_BATCH_CERTIFICATES_DIR is supplied to the task to query for this location. For certificates with visibility of 'remoteUser', a 'certs' directory is created in the user's home directory (e.g., /home/{user-name}/certs) and certificates are placed in that directory.
	CertificateReferences *[]CertificateReference `json:"certificateReferences,omitempty"`
	Errors                *[]ComputeNodeError     `json:"errors,omitempty"`
	IsDedicated           *bool                   `json:"isDedicated,omitempty"`
}

// ComputeNodeError ...
type ComputeNodeError struct {
	Code         *string          `json:"code,omitempty"`
	Message      *string          `json:"message,omitempty"`
	ErrorDetails *[]NameValuePair `json:"errorDetails,omitempty"`
}

// ComputeNodeGetRemoteLoginSettingsResult ...
type ComputeNodeGetRemoteLoginSettingsResult struct {
	autorest.Response    `json:"-"`
	RemoteLoginIPAddress *string `json:"remoteLoginIPAddress,omitempty"`
	RemoteLoginPort      *int32  `json:"remoteLoginPort,omitempty"`
}

// ComputeNodeInformation ...
type ComputeNodeInformation struct {
	AffinityID           *string `json:"affinityId,omitempty"`
	NodeURL              *string `json:"nodeUrl,omitempty"`
	PoolID               *string `json:"poolId,omitempty"`
	NodeID               *string `json:"nodeId,omitempty"`
	TaskRootDirectory    *string `json:"taskRootDirectory,omitempty"`
	TaskRootDirectoryURL *string `json:"taskRootDirectoryUrl,omitempty"`
}

// ComputeNodeListResult ...
type ComputeNodeListResult struct {
	autorest.Response `json:"-"`
	Value             *[]ComputeNode `json:"value,omitempty"`
	OdataNextLink     *string        `json:"odata.nextLink,omitempty"`
}

// ComputeNodeListResultIterator provides access to a complete listing of ComputeNode values.
type ComputeNodeListResultIterator struct {
	i    int
	page ComputeNodeListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ComputeNodeListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ComputeNodeListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ComputeNodeListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ComputeNodeListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ComputeNodeListResultIterator) Response() ComputeNodeListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ComputeNodeListResultIterator) Value() ComputeNode {
	if !iter.page.NotDone() {
		return ComputeNode{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ComputeNodeListResultIterator type.
func NewComputeNodeListResultIterator(page ComputeNodeListResultPage) ComputeNodeListResultIterator {
	return ComputeNodeListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (cnlr ComputeNodeListResult) IsEmpty() bool {
	return cnlr.Value == nil || len(*cnlr.Value) == 0
}

// computeNodeListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (cnlr ComputeNodeListResult) computeNodeListResultPreparer(ctx context.Context) (*http.Request, error) {
	if cnlr.OdataNextLink == nil || len(to.String(cnlr.OdataNextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(cnlr.OdataNextLink)))
}

// ComputeNodeListResultPage contains a page of ComputeNode values.
type ComputeNodeListResultPage struct {
	fn   func(context.Context, ComputeNodeListResult) (ComputeNodeListResult, error)
	cnlr ComputeNodeListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ComputeNodeListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ComputeNodeListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.cnlr)
	if err != nil {
		return err
	}
	page.cnlr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ComputeNodeListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ComputeNodeListResultPage) NotDone() bool {
	return !page.cnlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ComputeNodeListResultPage) Response() ComputeNodeListResult {
	return page.cnlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ComputeNodeListResultPage) Values() []ComputeNode {
	if page.cnlr.IsEmpty() {
		return nil
	}
	return *page.cnlr.Value
}

// Creates a new instance of the ComputeNodeListResultPage type.
func NewComputeNodeListResultPage(getNextPage func(context.Context, ComputeNodeListResult) (ComputeNodeListResult, error)) ComputeNodeListResultPage {
	return ComputeNodeListResultPage{fn: getNextPage}
}

// ComputeNodeUser ...
type ComputeNodeUser struct {
	Name *string `json:"name,omitempty"`
	// IsAdmin - The default value is false.
	IsAdmin *bool `json:"isAdmin,omitempty"`
	// ExpiryTime - If omitted, the default is 1 day from the current time. For Linux compute nodes, the expiryTime has a precision up to a day.
	ExpiryTime *date.Time `json:"expiryTime,omitempty"`
	// Password - The password is required for Windows nodes (those created with 'cloudServiceConfiguration', or created with 'virtualMachineConfiguration' using a Windows image reference). For Linux compute nodes, the password can optionally be specified along with the sshPublicKey property.
	Password *string `json:"password,omitempty"`
	// SSHPublicKey - The public key should be compatible with OpenSSH encoding and should be base 64 encoded. This property can be specified only for Linux nodes. If this is specified for a Windows node, then the Batch service rejects the request; if you are calling the REST API directly, the HTTP status code is 400 (Bad Request).
	SSHPublicKey *string `json:"sshPublicKey,omitempty"`
}

// DeleteCertificateError ...
type DeleteCertificateError struct {
	Code    *string `json:"code,omitempty"`
	Message *string `json:"message,omitempty"`
	// Values - This list includes details such as the active pools and nodes referencing this certificate. However, if a large number of resources reference the certificate, the list contains only about the first hundred.
	Values *[]NameValuePair `json:"values,omitempty"`
}

// EnvironmentSetting ...
type EnvironmentSetting struct {
	Name  *string `json:"name,omitempty"`
	Value *string `json:"value,omitempty"`
}

// Error ...
type Error struct {
	Code    *string        `json:"code,omitempty"`
	Message *ErrorMessage  `json:"message,omitempty"`
	Values  *[]ErrorDetail `json:"values,omitempty"`
}

// ErrorDetail ...
type ErrorDetail struct {
	Key   *string `json:"key,omitempty"`
	Value *string `json:"value,omitempty"`
}

// ErrorMessage ...
type ErrorMessage struct {
	Lang  *string `json:"lang,omitempty"`
	Value *string `json:"value,omitempty"`
}

// ExitCodeMapping ...
type ExitCodeMapping struct {
	Code        *int32       `json:"code,omitempty"`
	ExitOptions *ExitOptions `json:"exitOptions,omitempty"`
}

// ExitCodeRangeMapping ...
type ExitCodeRangeMapping struct {
	Start       *int32       `json:"start,omitempty"`
	End         *int32       `json:"end,omitempty"`
	ExitOptions *ExitOptions `json:"exitOptions,omitempty"`
}

// ExitConditions ...
type ExitConditions struct {
	ExitCodes          *[]ExitCodeMapping      `json:"exitCodes,omitempty"`
	ExitCodeRanges     *[]ExitCodeRangeMapping `json:"exitCodeRanges,omitempty"`
	PreProcessingError *ExitOptions            `json:"preProcessingError,omitempty"`
	// FileUploadError - If the task exited with an exit code that was specified via exitCodes or exitCodeRanges, and then encountered a file upload error, then the action specified by the exit code takes precedence.
	FileUploadError *ExitOptions `json:"fileUploadError,omitempty"`
	// Default - This value is used if the task exits with any nonzero exit code not listed in the exitCodes or exitCodeRanges collection, with a pre-processing error if the preProcessingError property is not present, or with a file upload error if the fileUploadError property is not present. If you want non-default behaviour on exit code 0, you must list it explicitly using the exitCodes or exitCodeRanges collection.
	Default *ExitOptions `json:"default,omitempty"`
}

// ExitOptions ...
type ExitOptions struct {
	// JobAction - The default is none for exit code 0 and terminate for all other exit conditions. If the job's onTaskFailed property is noAction, then specify this property returns an error. The add task request fails with an invalid property value error;; if you are calling the REST API directly, the HTTP status code is 400 (Bad Request). Possible values include: 'JobActionNone', 'JobActionDisable', 'JobActionTerminate'
	JobAction JobAction `json:"jobAction,omitempty"`
	// DependencyAction - The default is 'satisfy' for exit code 0, and 'block' for all other exit conditions. If the job's usesTaskDependencies property is set to false, then specifying the dependencyAction property returns an error. The add task request fails with an invalid property value error; if you are calling the REST API directly, the HTTP status code is 400  (Bad Request). Possible values include: 'Satisfy', 'Block'
	DependencyAction DependencyAction `json:"dependencyAction,omitempty"`
}

// FileProperties ...
type FileProperties struct {
	// CreationTime - The creation time is not returned for files on Linux compute nodes.
	CreationTime  *date.Time `json:"creationTime,omitempty"`
	LastModified  *date.Time `json:"lastModified,omitempty"`
	ContentLength *int64     `json:"contentLength,omitempty"`
	ContentType   *string    `json:"contentType,omitempty"`
	// FileMode - The file mode is returned only for files on Linux compute nodes.
	FileMode *string `json:"fileMode,omitempty"`
}

// ImageReference ...
type ImageReference struct {
	// Publisher - For example, Canonical or MicrosoftWindowsServer.
	Publisher *string `json:"publisher,omitempty"`
	// Offer - For example, UbuntuServer or WindowsServer.
	Offer *string `json:"offer,omitempty"`
	// Sku - For example, 14.04.0-LTS or 2012-R2-Datacenter.
	Sku *string `json:"sku,omitempty"`
	// Version - A value of 'latest' can be specified to select the latest version of an image. If omitted, the default is 'latest'.
	Version *string `json:"version,omitempty"`
}

// JobAddParameter ...
type JobAddParameter struct {
	// ID - The ID can contain any combination of alphanumeric characters including hyphens and underscores, and cannot contain more than 64 characters. It is common to use a GUID for the id.
	ID *string `json:"id,omitempty"`
	// DisplayName - The display name need not be unique and can contain any Unicode characters up to a maximum length of 1024.
	DisplayName *string `json:"displayName,omitempty"`
	// Priority - Priority values can range from -1000 to 1000, with -1000 being the lowest priority and 1000 being the highest priority. The default value is 0.
	Priority *int32 `json:"priority,omitempty"`
	// Constraints - The execution constraints for the job.
	Constraints *JobConstraints `json:"constraints,omitempty"`
	// JobManagerTask - If the job does not specify a Job Manager task, the user must explicitly add tasks to the job. If the job does specify a Job Manager task, the Batch service creates the Job Manager task when the job is created, and will try to schedule the Job Manager task before scheduling other tasks in the job. The Job Manager task's typical purpose is to control and/or monitor job execution, for example by deciding what additional tasks to run, determining when the work is complete, etc. (However, a Job Manager task is not restricted to these activities - it is a fully-fledged task in the system and perform whatever actions are required for the job.) For example, a Job Manager task might download a file specified as a parameter, analyze the contents of that file and submit additional tasks based on those contents.
	JobManagerTask *JobManagerTask `json:"jobManagerTask,omitempty"`
	// JobPreparationTask - If a job has a Job Preparation task, the Batch service will run the Job Preparation task on a compute node before starting any tasks of that job on that compute node.
	JobPreparationTask *JobPreparationTask `json:"jobPreparationTask,omitempty"`
	// JobReleaseTask - A Job Release task cannot be specified without also specifying a Job Preparation task for the job. The Batch service runs the Job Release task on the compute nodes that have run the Job Preparation task. The primary purpose of the Job Release task is to undo changes to compute nodes made by the Job Preparation task. Example activities include deleting local files, or shutting down services that were started as part of job preparation.
	JobReleaseTask            *JobReleaseTask       `json:"jobReleaseTask,omitempty"`
	CommonEnvironmentSettings *[]EnvironmentSetting `json:"commonEnvironmentSettings,omitempty"`
	PoolInfo                  *PoolInformation      `json:"poolInfo,omitempty"`
	// OnAllTasksComplete - Note that if a job contains no tasks, then all tasks are considered complete. This option is therefore most commonly used with a Job Manager task; if you want to use automatic job termination without a Job Manager, you should initially set onAllTasksComplete to noAction and update the job properties to set onAllTasksComplete to terminateJob once you have finished adding tasks. Permitted values are: noAction - do nothing. The job remains active unless terminated or disabled by some other means. terminateJob - terminate the job. The job's terminateReason is set to 'AllTasksComplete'. The default is noAction. Possible values include: 'NoAction', 'TerminateJob'
	OnAllTasksComplete OnAllTasksComplete `json:"onAllTasksComplete,omitempty"`
	// OnTaskFailure - noAction - do nothing. performExitOptionsJobAction - take the action associated with the task exit condition in the task's exitConditions collection. (This may still result in no action being taken, if that is what the task specifies.) The default is noAction. Possible values include: 'OnTaskFailureNoAction', 'OnTaskFailurePerformExitOptionsJobAction'
	OnTaskFailure OnTaskFailure `json:"onTaskFailure,omitempty"`
	// Metadata - The Batch service does not assign any meaning to metadata; it is solely for the use of user code.
	Metadata             *[]MetadataItem `json:"metadata,omitempty"`
	UsesTaskDependencies *bool           `json:"usesTaskDependencies,omitempty"`
}

// JobConstraints ...
type JobConstraints struct {
	// MaxWallClockTime - If the job does not complete within the time limit, the Batch service terminates it and any tasks that are still running. In this case, the termination reason will be MaxWallClockTimeExpiry. If this property is not specified, there is no time limit on how long the job may run.
	MaxWallClockTime *string `json:"maxWallClockTime,omitempty"`
	// MaxTaskRetryCount - Note that this value specifically controls the number of retries. The Batch service will try each task once, and may then retry up to this limit. For example, if the maximum retry count is 3, Batch tries a task up to 4 times (one initial try and 3 retries). If the maximum retry count is 0, the Batch service does not retry tasks. If the maximum retry count is -1, the Batch service retries tasks without limit. The default value is 0 (no retries).
	MaxTaskRetryCount *int32 `json:"maxTaskRetryCount,omitempty"`
}

// JobDisableParameter ...
type JobDisableParameter struct {
	// DisableTasks - requeue - Terminate running tasks and requeue them. The tasks will run again when the job is enabled. terminate - Terminate running tasks. The tasks will not run again. wait - Allow currently running tasks to complete. Possible values include: 'DisableJobOptionRequeue', 'DisableJobOptionTerminate', 'DisableJobOptionWait'
	DisableTasks DisableJobOption `json:"disableTasks,omitempty"`
}

// JobExecutionInformation ...
type JobExecutionInformation struct {
	// StartTime - This is the time at which the job was created.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - This property is set only if the job is in the completed state.
	EndTime *date.Time `json:"endTime,omitempty"`
	// PoolID - This element contains the actual pool where the job is assigned. When you get job details from the service, they also contain a poolInfo element, which contains the pool configuration data from when the job was added or updated. That poolInfo element may also contain a poolId element. If it does, the two IDs are the same. If it does not, it means the job ran on an auto pool, and this property contains the id of that auto pool.
	PoolID *string `json:"poolId,omitempty"`
	// SchedulingError - This property is not set if there was no error starting the job.
	SchedulingError *JobSchedulingError `json:"schedulingError,omitempty"`
	// TerminateReason - This property is set only if the job is in the completed state. If the Batch service terminates the job, it sets the reason as follows: JMComplete - the Job Manager task completed, and killJobOnCompletion was set to true. MaxWallClockTimeExpiry - the job reached its maxWallClockTime constraint. TerminateJobSchedule - the job ran as part of a schedule, and the schedule terminated. AllTasksComplete - the job's onAllTasksComplete attribute is set to terminateJob, and all tasks in the job are complete. TaskFailed - the job's onTaskFailure attribute is set to performExitOptionsJobAction, and a task in the job failed with an exit condition that specified a jobAction of terminateJob. Any other string is a user-defined reason specified in a call to the 'Terminate a job' operation.
	TerminateReason *string `json:"terminateReason,omitempty"`
}

// JobManagerTask ...
type JobManagerTask struct {
	// ID - The id can contain any combination of alphanumeric characters including hyphens and underscores and cannot contain more than 64 characters.
	ID *string `json:"id,omitempty"`
	// DisplayName - It need not be unique and can contain any Unicode characters up to a maximum length of 1024.
	DisplayName *string `json:"displayName,omitempty"`
	// CommandLine - The command line does not run under a shell, and therefore cannot take advantage of shell features such as environment variable expansion. If you want to take advantage of such features, you should invoke the shell in the command line, for example using "cmd /c MyCommand" in Windows or "/bin/sh -c MyCommand" in Linux.
	CommandLine *string `json:"commandLine,omitempty"`
	// ResourceFiles - Files listed under this element are located in the task's working directory.
	ResourceFiles       *[]ResourceFile       `json:"resourceFiles,omitempty"`
	OutputFiles         *[]OutputFile         `json:"outputFiles,omitempty"`
	EnvironmentSettings *[]EnvironmentSetting `json:"environmentSettings,omitempty"`
	Constraints         *TaskConstraints      `json:"constraints,omitempty"`
	// KillJobOnCompletion - If true, when the Job Manager task completes, the Batch service marks the job as complete. If any tasks are still running at this time (other than Job Release), those tasks are terminated. If false, the completion of the Job Manager task does not affect the job status. In this case, you should either use the onAllTasksComplete attribute to terminate the job, or have a client or user terminate the job explicitly. An example of this is if the Job Manager creates a set of tasks but then takes no further role in their execution. The default value is true. If you are using the onAllTasksComplete and onTaskFailure attributes to control job lifetime, and using the Job Manager task only to create the tasks for the job (not to monitor progress), then it is important to set killJobOnCompletion to false.
	KillJobOnCompletion *bool `json:"killJobOnCompletion,omitempty"`
	// UserIdentity - If omitted, the task runs as a non-administrative user unique to the task.
	UserIdentity *UserIdentity `json:"userIdentity,omitempty"`
	// RunExclusive - If true, no other tasks will run on the same compute node for as long as the Job Manager is running. If false, other tasks can run simultaneously with the Job Manager on a compute node. The Job Manager task counts normally against the node's concurrent task limit, so this is only relevant if the node allows multiple concurrent tasks. The default value is true.
	RunExclusive *bool `json:"runExclusive,omitempty"`
	// ApplicationPackageReferences - Application packages are downloaded and deployed to a shared directory, not the task directory. Therefore, if a referenced package is already on the compute node, and is up to date, then it is not re-downloaded; the existing copy on the compute node is used. If a referenced application package cannot be installed, for example because the package has been deleted or because download failed, the task fails with a scheduling error. This property is currently not supported on jobs running on pools created using the virtualMachineConfiguration (IaaS) property. If a task specifying applicationPackageReferences runs on such a pool, it fails with a scheduling error with code TaskSchedulingConstraintFailed.
	ApplicationPackageReferences *[]ApplicationPackageReference `json:"applicationPackageReferences,omitempty"`
	// AuthenticationTokenSettings - If this property is set, the Batch service provides the task with an authentication token which can be used to authenticate Batch service operations without requiring an account access key. The token is provided via the AZ_BATCH_AUTHENTICATION_TOKEN environment variable. The operations that the task can carry out using the token depend on the settings. For example, a task can request job permissions in order to add other tasks to the job, or check the status of the job or of other tasks under the job.
	AuthenticationTokenSettings *AuthenticationTokenSettings `json:"authenticationTokenSettings,omitempty"`
	// AllowLowPriorityNode - The default value is false.
	AllowLowPriorityNode *bool `json:"allowLowPriorityNode,omitempty"`
}

// JobPatchParameter ...
type JobPatchParameter struct {
	// Priority - Priority values can range from -1000 to 1000, with -1000 being the lowest priority and 1000 being the highest priority. If omitted, the priority of the job is left unchanged.
	Priority *int32 `json:"priority,omitempty"`
	// OnAllTasksComplete - If omitted, the completion behavior is left unchanged. You may not change the value from terminateJob to noAction - that is, once you have engaged automatic job termination, you cannot turn it off again. If you try to do this, the request fails with an 'invalid property value' error response; if you are calling the REST API directly, the HTTP status code is 400 (Bad Request). Possible values include: 'NoAction', 'TerminateJob'
	OnAllTasksComplete OnAllTasksComplete `json:"onAllTasksComplete,omitempty"`
	// Constraints - If omitted, the existing execution constraints are left unchanged.
	Constraints *JobConstraints `json:"constraints,omitempty"`
	// PoolInfo - You may change the pool for a job only when the job is disabled. The Patch Job call will fail if you include the poolInfo element and the job is not disabled. If you specify an autoPoolSpecification specification in the poolInfo, only the keepAlive property can be updated, and then only if the auto pool has a poolLifetimeOption of job. If omitted, the job continues to run on its current pool.
	PoolInfo *PoolInformation `json:"poolInfo,omitempty"`
	// Metadata - If omitted, the existing job metadata is left unchanged.
	Metadata *[]MetadataItem `json:"metadata,omitempty"`
}

// JobPreparationAndReleaseTaskExecutionInformation ...
type JobPreparationAndReleaseTaskExecutionInformation struct {
	PoolID                          *string                                 `json:"poolId,omitempty"`
	NodeID                          *string                                 `json:"nodeId,omitempty"`
	NodeURL                         *string                                 `json:"nodeUrl,omitempty"`
	JobPreparationTaskExecutionInfo *JobPreparationTaskExecutionInformation `json:"jobPreparationTaskExecutionInfo,omitempty"`
	// JobReleaseTaskExecutionInfo - This property is set only if the Job Release task has run on the node.
	JobReleaseTaskExecutionInfo *JobReleaseTaskExecutionInformation `json:"jobReleaseTaskExecutionInfo,omitempty"`
}

// JobPreparationTask ...
type JobPreparationTask struct {
	// ID - The ID can contain any combination of alphanumeric characters including hyphens and underscores and cannot contain more than 64 characters. If you do not specify this property, the Batch service assigns a default value of 'jobpreparation'. No other task in the job can have the same id as the Job Preparation task. If you try to submit a task with the same id, the Batch service rejects the request with error code TaskIdSameAsJobPreparationTask; if you are calling the REST API directly, the HTTP status code is 409 (Conflict).
	ID *string `json:"id,omitempty"`
	// CommandLine - The command line does not run under a shell, and therefore cannot take advantage of shell features such as environment variable expansion. If you want to take advantage of such features, you should invoke the shell in the command line, for example using "cmd /c MyCommand" in Windows or "/bin/sh -c MyCommand" in Linux.
	CommandLine *string `json:"commandLine,omitempty"`
	// ResourceFiles - Files listed under this element are located in the task's working directory.
	ResourceFiles       *[]ResourceFile       `json:"resourceFiles,omitempty"`
	EnvironmentSettings *[]EnvironmentSetting `json:"environmentSettings,omitempty"`
	Constraints         *TaskConstraints      `json:"constraints,omitempty"`
	// WaitForSuccess - If true and the Job Preparation task fails on a compute node, the Batch service retries the Job Preparation task up to its maximum retry count (as specified in the constraints element). If the task has still not completed successfully after all retries, then the Batch service will not schedule tasks of the job to the compute node. The compute node remains active and eligible to run tasks of other jobs. If false, the Batch service will not wait for the Job Preparation task to complete. In this case, other tasks of the job can start executing on the compute node while the Job Preparation task is still running; and even if the Job Preparation task fails, new tasks will continue to be scheduled on the node. The default value is true.
	WaitForSuccess *bool `json:"waitForSuccess,omitempty"`
	// UserIdentity - If omitted, the task runs as a non-administrative user unique to the task.
	UserIdentity *UserIdentity `json:"userIdentity,omitempty"`
	// RerunOnNodeRebootAfterSuccess - The Job Preparation task is always rerun if a compute node is reimaged, or if the Job Preparation task did not complete (e.g. because the reboot occurred while the task was running). Therefore, you should always write a Job Preparation task to be idempotent and to behave correctly if run multiple times. The default value is true.
	RerunOnNodeRebootAfterSuccess *bool `json:"rerunOnNodeRebootAfterSuccess,omitempty"`
}

// JobPreparationTaskExecutionInformation ...
type JobPreparationTaskExecutionInformation struct {
	// StartTime - Note that every time the task is restarted, this value is updated.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - This property is set only if the task is in the Completed state.
	EndTime *date.Time `json:"endTime,omitempty"`
	// State - running - the task is currently running (including retrying). completed - the task has exited with exit code 0, or the task has exhausted its retry limit, or the Batch service was unable to start the task due to scheduling errors. Possible values include: 'JobPreparationTaskStateRunning', 'JobPreparationTaskStateCompleted'
	State                JobPreparationTaskState `json:"state,omitempty"`
	TaskRootDirectory    *string                 `json:"taskRootDirectory,omitempty"`
	TaskRootDirectoryURL *string                 `json:"taskRootDirectoryUrl,omitempty"`
	// ExitCode - This parameter is returned only if the task is in the completed state. The exit code for a process reflects the specific convention implemented by the application developer for that process. If you use the exit code value to make decisions in your code, be sure that you know the exit code convention used by the application process. Note that the exit code may also be generated by the compute node operating system, such as when a process is forcibly terminated.
	ExitCode *int32 `json:"exitCode,omitempty"`
	// FailureInfo - This property is set only if the task is in the completed state and encountered a failure.
	FailureInfo *TaskFailureInformation `json:"failureInfo,omitempty"`
	RetryCount  *int32                  `json:"retryCount,omitempty"`
	// LastRetryTime - This property is set only if the task was retried (i.e. retryCount is nonzero). If present, this is typically the same as startTime, but may be different if the task has been restarted for reasons other than retry; for example, if the compute node was rebooted during a retry, then the startTime is updated but the lastRetryTime is not.
	LastRetryTime *date.Time `json:"lastRetryTime,omitempty"`
	// Result - If the value is 'failed', then the details of the failure can be found in the failureInfo property. Possible values include: 'Success', 'Failure'
	Result TaskExecutionResult `json:"result,omitempty"`
}

// JobReleaseTask ...
type JobReleaseTask struct {
	// ID - The ID can contain any combination of alphanumeric characters including hyphens and underscores and cannot contain more than 64 characters. If you do not specify this property, the Batch service assigns a default value of 'jobrelease'. No other task in the job can have the same id as the Job Release task. If you try to submit a task with the same id, the Batch service rejects the request with error code TaskIdSameAsJobReleaseTask; if you are calling the REST API directly, the HTTP status code is 409 (Conflict).
	ID *string `json:"id,omitempty"`
	// CommandLine - The command line does not run under a shell, and therefore cannot take advantage of shell features such as environment variable expansion. If you want to take advantage of such features, you should invoke the shell in the command line, for example using "cmd /c MyCommand" in Windows or "/bin/sh -c MyCommand" in Linux.
	CommandLine *string `json:"commandLine,omitempty"`
	// ResourceFiles - Files listed under this element are located in the task's working directory.
	ResourceFiles       *[]ResourceFile       `json:"resourceFiles,omitempty"`
	EnvironmentSettings *[]EnvironmentSetting `json:"environmentSettings,omitempty"`
	MaxWallClockTime    *string               `json:"maxWallClockTime,omitempty"`
	// RetentionTime - The default is infinite, i.e. the task directory will be retained until the compute node is removed or reimaged.
	RetentionTime *string `json:"retentionTime,omitempty"`
	// UserIdentity - If omitted, the task runs as a non-administrative user unique to the task.
	UserIdentity *UserIdentity `json:"userIdentity,omitempty"`
}

// JobReleaseTaskExecutionInformation ...
type JobReleaseTaskExecutionInformation struct {
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - This property is set only if the task is in the Completed state.
	EndTime *date.Time `json:"endTime,omitempty"`
	// State - running - the task is currently running (including retrying). completed - the task has exited, or the Batch service was unable to start the task due to scheduling errors. Possible values include: 'JobReleaseTaskStateRunning', 'JobReleaseTaskStateCompleted'
	State                JobReleaseTaskState `json:"state,omitempty"`
	TaskRootDirectory    *string             `json:"taskRootDirectory,omitempty"`
	TaskRootDirectoryURL *string             `json:"taskRootDirectoryUrl,omitempty"`
	// ExitCode - This parameter is returned only if the task is in the completed state. The exit code for a process reflects the specific convention implemented by the application developer for that process. If you use the exit code value to make decisions in your code, be sure that you know the exit code convention used by the application process. Note that the exit code may also be generated by the compute node operating system, such as when a process is forcibly terminated.
	ExitCode *int32 `json:"exitCode,omitempty"`
	// FailureInfo - This property is set only if the task is in the completed state and encountered a failure.
	FailureInfo *TaskFailureInformation `json:"failureInfo,omitempty"`
	// Result - If the value is 'failed', then the details of the failure can be found in the failureInfo property. Possible values include: 'Success', 'Failure'
	Result TaskExecutionResult `json:"result,omitempty"`
}

// JobScheduleAddParameter ...
type JobScheduleAddParameter struct {
	// ID - The ID can contain any combination of alphanumeric characters including hyphens and underscores, and cannot contain more than 64 characters. The id is case-preserving and case-insensitive (that is, you may not have two ids within an account that differ only by case).
	ID *string `json:"id,omitempty"`
	// DisplayName - The display name need not be unique and can contain any Unicode characters up to a maximum length of 1024.
	DisplayName      *string           `json:"displayName,omitempty"`
	Schedule         *Schedule         `json:"schedule,omitempty"`
	JobSpecification *JobSpecification `json:"jobSpecification,omitempty"`
	// Metadata - The Batch service does not assign any meaning to metadata; it is solely for the use of user code.
	Metadata *[]MetadataItem `json:"metadata,omitempty"`
}

// JobScheduleExecutionInformation ...
type JobScheduleExecutionInformation struct {
	// NextRunTime - This property is meaningful only if the schedule is in the active state when the time comes around. For example, if the schedule is disabled, no job will be created at nextRunTime unless the job is enabled before then.
	NextRunTime *date.Time `json:"nextRunTime,omitempty"`
	// RecentJob - This property is present only if the at least one job has run under the schedule.
	RecentJob *RecentJob `json:"recentJob,omitempty"`
	// EndTime - This property is set only if the job schedule is in the completed state.
	EndTime *date.Time `json:"endTime,omitempty"`
}

// JobSchedulePatchParameter ...
type JobSchedulePatchParameter struct {
	// Schedule - If you do not specify this element, the existing schedule is left unchanged.
	Schedule *Schedule `json:"schedule,omitempty"`
	// JobSpecification - Updates affect only jobs that are started after the update has taken place. Any currently active job continues with the older specification.
	JobSpecification *JobSpecification `json:"jobSpecification,omitempty"`
	// Metadata - If you do not specify this element, existing metadata is left unchanged.
	Metadata *[]MetadataItem `json:"metadata,omitempty"`
}

// JobScheduleStatistics ...
type JobScheduleStatistics struct {
	URL            *string    `json:"url,omitempty"`
	StartTime      *date.Time `json:"startTime,omitempty"`
	LastUpdateTime *date.Time `json:"lastUpdateTime,omitempty"`
	UserCPUTime    *string    `json:"userCPUTime,omitempty"`
	KernelCPUTime  *string    `json:"kernelCPUTime,omitempty"`
	// WallClockTime - The wall clock time is the elapsed time from when the task started running on a compute node to when it finished (or to the last time the statistics were updated, if the task had not finished by then). If a task was retried, this includes the wall clock time of all the task retries.
	WallClockTime     *string  `json:"wallClockTime,omitempty"`
	ReadIOps          *int64   `json:"readIOps,omitempty"`
	WriteIOps         *int64   `json:"writeIOps,omitempty"`
	ReadIOGiB         *float64 `json:"readIOGiB,omitempty"`
	WriteIOGiB        *float64 `json:"writeIOGiB,omitempty"`
	NumSucceededTasks *int64   `json:"numSucceededTasks,omitempty"`
	NumFailedTasks    *int64   `json:"numFailedTasks,omitempty"`
	NumTaskRetries    *int64   `json:"numTaskRetries,omitempty"`
	// WaitTime - This value is only reported in the account lifetime statistics; it is not included in the job statistics.
	WaitTime *string `json:"waitTime,omitempty"`
}

// JobScheduleUpdateParameter ...
type JobScheduleUpdateParameter struct {
	// Schedule - If you do not specify this element, it is equivalent to passing the default schedule: that is, a single job scheduled to run immediately.
	Schedule *Schedule `json:"schedule,omitempty"`
	// JobSpecification - Updates affect only jobs that are started after the update has taken place. Any currently active job continues with the older specification.
	JobSpecification *JobSpecification `json:"jobSpecification,omitempty"`
	// Metadata - If you do not specify this element, it takes the default value of an empty list; in effect, any existing metadata is deleted.
	Metadata *[]MetadataItem `json:"metadata,omitempty"`
}

// JobSchedulingError ...
type JobSchedulingError struct {
	// Category - Possible values include: 'UserError', 'ServerError'
	Category ErrorCategory    `json:"category,omitempty"`
	Code     *string          `json:"code,omitempty"`
	Message  *string          `json:"message,omitempty"`
	Details  *[]NameValuePair `json:"details,omitempty"`
}

// JobSpecification ...
type JobSpecification struct {
	// Priority - Priority values can range from -1000 to 1000, with -1000 being the lowest priority and 1000 being the highest priority. The default value is 0. This priority is used as the default for all jobs under the job schedule. You can update a job's priority after it has been created using by using the update job API.
	Priority *int32 `json:"priority,omitempty"`
	// DisplayName - The name need not be unique and can contain any Unicode characters up to a maximum length of 1024.
	DisplayName          *string `json:"displayName,omitempty"`
	UsesTaskDependencies *bool   `json:"usesTaskDependencies,omitempty"`
	// OnAllTasksComplete - Note that if a job contains no tasks, then all tasks are considered complete. This option is therefore most commonly used with a Job Manager task; if you want to use automatic job termination without a Job Manager, you should initially set onAllTasksComplete to noAction and update the job properties to set onAllTasksComplete to terminateJob once you have finished adding tasks. The default is noAction. Possible values include: 'NoAction', 'TerminateJob'
	OnAllTasksComplete OnAllTasksComplete `json:"onAllTasksComplete,omitempty"`
	// OnTaskFailure - The default is noAction. Possible values include: 'OnTaskFailureNoAction', 'OnTaskFailurePerformExitOptionsJobAction'
	OnTaskFailure OnTaskFailure   `json:"onTaskFailure,omitempty"`
	Constraints   *JobConstraints `json:"constraints,omitempty"`
	// JobManagerTask - If the job does not specify a Job Manager task, the user must explicitly add tasks to the job using the Task API. If the job does specify a Job Manager task, the Batch service creates the Job Manager task when the job is created, and will try to schedule the Job Manager task before scheduling other tasks in the job.
	JobManagerTask *JobManagerTask `json:"jobManagerTask,omitempty"`
	// JobPreparationTask - If a job has a Job Preparation task, the Batch service will run the Job Preparation task on a compute node before starting any tasks of that job on that compute node.
	JobPreparationTask *JobPreparationTask `json:"jobPreparationTask,omitempty"`
	// JobReleaseTask - The primary purpose of the Job Release task is to undo changes to compute nodes made by the Job Preparation task. Example activities include deleting local files, or shutting down services that were started as part of job preparation. A Job Release task cannot be specified without also specifying a Job Preparation task for the job. The Batch service runs the Job Release task on the compute nodes that have run the Job Preparation task.
	JobReleaseTask *JobReleaseTask `json:"jobReleaseTask,omitempty"`
	// CommonEnvironmentSettings - Individual tasks can override an environment setting specified here by specifying the same setting name with a different value.
	CommonEnvironmentSettings *[]EnvironmentSetting `json:"commonEnvironmentSettings,omitempty"`
	PoolInfo                  *PoolInformation      `json:"poolInfo,omitempty"`
	// Metadata - The Batch service does not assign any meaning to metadata; it is solely for the use of user code.
	Metadata *[]MetadataItem `json:"metadata,omitempty"`
}

// JobStatistics ...
type JobStatistics struct {
	autorest.Response `json:"-"`
	URL               *string    `json:"url,omitempty"`
	StartTime         *date.Time `json:"startTime,omitempty"`
	LastUpdateTime    *date.Time `json:"lastUpdateTime,omitempty"`
	UserCPUTime       *string    `json:"userCPUTime,omitempty"`
	KernelCPUTime     *string    `json:"kernelCPUTime,omitempty"`
	WallClockTime     *string    `json:"wallClockTime,omitempty"`
	ReadIOps          *int64     `json:"readIOps,omitempty"`
	WriteIOps         *int64     `json:"writeIOps,omitempty"`
	ReadIOGiB         *float64   `json:"readIOGiB,omitempty"`
	WriteIOGiB        *float64   `json:"writeIOGiB,omitempty"`
	// NumSucceededTasks - A task completes successfully if it returns exit code 0.
	NumSucceededTasks *int64 `json:"numSucceededTasks,omitempty"`
	// NumFailedTasks - A task fails if it exhausts its maximum retry count without returning exit code 0.
	NumFailedTasks *int64 `json:"numFailedTasks,omitempty"`
	NumTaskRetries *int64 `json:"numTaskRetries,omitempty"`
	// WaitTime - The wait time for a task is defined as the elapsed time between the creation of the task and the start of task execution. (If the task is retried due to failures, the wait time is the time to the most recent task execution.) This value is only reported in the account lifetime statistics; it is not included in the job statistics.
	WaitTime *string `json:"waitTime,omitempty"`
}

// JobTerminateParameter ...
type JobTerminateParameter struct {
	TerminateReason *string `json:"terminateReason,omitempty"`
}

// JobUpdateParameter ...
type JobUpdateParameter struct {
	// Priority - Priority values can range from -1000 to 1000, with -1000 being the lowest priority and 1000 being the highest priority. If omitted, it is set to the default value 0.
	Priority *int32 `json:"priority,omitempty"`
	// Constraints - If omitted, the constraints are cleared.
	Constraints *JobConstraints `json:"constraints,omitempty"`
	// PoolInfo - You may change the pool for a job only when the job is disabled. The Update Job call will fail if you include the poolInfo element and the job is not disabled. If you specify an autoPoolSpecification specification in the poolInfo, only the keepAlive property can be updated, and then only if the auto pool has a poolLifetimeOption of job.
	PoolInfo *PoolInformation `json:"poolInfo,omitempty"`
	// Metadata - If omitted, it takes the default value of an empty list; in effect, any existing metadata is deleted.
	Metadata *[]MetadataItem `json:"metadata,omitempty"`
	// OnAllTasksComplete - If omitted, the completion behavior is set to noAction. If the current value is terminateJob, this is an error because a job's completion behavior may not be changed from terminateJob to noAction. Possible values include: 'NoAction', 'TerminateJob'
	OnAllTasksComplete OnAllTasksComplete `json:"onAllTasksComplete,omitempty"`
}

// LinuxUserConfiguration ...
type LinuxUserConfiguration struct {
	// UID - The uid and gid properties must be specified together or not at all. If not specified the underlying operating system picks the uid.
	UID *int32 `json:"uid,omitempty"`
	// Gid - The uid and gid properties must be specified together or not at all. If not specified the underlying operating system picks the gid.
	Gid *int32 `json:"gid,omitempty"`
	// SSHPrivateKey - The private key must not be password protected. The private key is used to automatically configure asymmetric-key based authentication for SSH between nodes in a Linux pool when the pool's enableInterNodeCommunication property is true (it is ignored if enableInterNodeCommunication is false). It does this by placing the key pair into the user's .ssh directory. If not specified, password-less SSH is not configured between nodes (no modification of the user's .ssh directory is done).
	SSHPrivateKey *string `json:"sshPrivateKey,omitempty"`
}

// MetadataItem the Batch service does not assign any meaning to this metadata; it is solely for the use of
// user code.
type MetadataItem struct {
	Name  *string `json:"name,omitempty"`
	Value *string `json:"value,omitempty"`
}

// MultiInstanceSettings multi-instance tasks are commonly used to support MPI tasks.
type MultiInstanceSettings struct {
	NumberOfInstances *int32 `json:"numberOfInstances,omitempty"`
	// CoordinationCommandLine - A typical coordination command line launches a background service and verifies that the service is ready to process inter-node messages.
	CoordinationCommandLine *string `json:"coordinationCommandLine,omitempty"`
	// CommonResourceFiles - The difference between common resource files and task resource files is that common resource files are downloaded for all subtasks including the primary, whereas task resource files are downloaded only for the primary.
	CommonResourceFiles *[]ResourceFile `json:"commonResourceFiles,omitempty"`
}

// NameValuePair ...
type NameValuePair struct {
	Name  *string `json:"name,omitempty"`
	Value *string `json:"value,omitempty"`
}

// NetworkConfiguration the network configuration for a pool.
type NetworkConfiguration struct {
	// SubnetID - The virtual network must be in the same region and subscription as the Azure Batch account. The specified subnet should have enough free IP addresses to accommodate the number of nodes in the pool. If the subnet doesn't have enough free IP addresses, the pool will partially allocate compute nodes, and a resize error will occur. The Batch service principal, named 'Microsoft Azure Batch' or 'MicrosoftAzureBatch', must have the 'Classic Virtual Machine Contributor' Role-Based Access Control (RBAC) role for the specified VNet. The specified subnet must allow communication from the Azure Batch service to be able to schedule tasks on the compute nodes. This can be verified by checking if the specified VNet has any associated Network Security Groups (NSG). If communication to the compute nodes in the specified subnet is denied by an NSG, then the Batch service will set the state of the compute nodes to unusable. For pools created via virtualMachineConfiguration the Batch account must have poolAllocationMode userSubscription in order to use a VNet.
	SubnetID *string `json:"subnetId,omitempty"`
}

// NodeAgentSku the Batch node agent is a program that runs on each node in the pool, and provides the
// command-and-control interface between the node and the Batch service. There are different
// implementations of the node agent, known as SKUs, for different operating systems.
type NodeAgentSku struct {
	ID *string `json:"id,omitempty"`
	// VerifiedImageReferences - This collection is not exhaustive (the node agent may be compatible with other images).
	VerifiedImageReferences *[]ImageReference `json:"verifiedImageReferences,omitempty"`
	// OsType - Possible values include: 'Linux', 'Windows'
	OsType OSType `json:"osType,omitempty"`
}

// NodeDisableSchedulingParameter ...
type NodeDisableSchedulingParameter struct {
	// NodeDisableSchedulingOption - The default value is requeue. Possible values include: 'DisableComputeNodeSchedulingOptionRequeue', 'DisableComputeNodeSchedulingOptionTerminate', 'DisableComputeNodeSchedulingOptionTaskCompletion'
	NodeDisableSchedulingOption DisableComputeNodeSchedulingOption `json:"nodeDisableSchedulingOption,omitempty"`
}

// NodeFile ...
type NodeFile struct {
	Name        *string         `json:"name,omitempty"`
	URL         *string         `json:"url,omitempty"`
	IsDirectory *bool           `json:"isDirectory,omitempty"`
	Properties  *FileProperties `json:"properties,omitempty"`
}

// NodeFileListResult ...
type NodeFileListResult struct {
	autorest.Response `json:"-"`
	Value             *[]NodeFile `json:"value,omitempty"`
	OdataNextLink     *string     `json:"odata.nextLink,omitempty"`
}

// NodeFileListResultIterator provides access to a complete listing of NodeFile values.
type NodeFileListResultIterator struct {
	i    int
	page NodeFileListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *NodeFileListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/NodeFileListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *NodeFileListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter NodeFileListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter NodeFileListResultIterator) Response() NodeFileListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter NodeFileListResultIterator) Value() NodeFile {
	if !iter.page.NotDone() {
		return NodeFile{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the NodeFileListResultIterator type.
func NewNodeFileListResultIterator(page NodeFileListResultPage) NodeFileListResultIterator {
	return NodeFileListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (nflr NodeFileListResult) IsEmpty() bool {
	return nflr.Value == nil || len(*nflr.Value) == 0
}

// nodeFileListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (nflr NodeFileListResult) nodeFileListResultPreparer(ctx context.Context) (*http.Request, error) {
	if nflr.OdataNextLink == nil || len(to.String(nflr.OdataNextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(nflr.OdataNextLink)))
}

// NodeFileListResultPage contains a page of NodeFile values.
type NodeFileListResultPage struct {
	fn   func(context.Context, NodeFileListResult) (NodeFileListResult, error)
	nflr NodeFileListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *NodeFileListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/NodeFileListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.nflr)
	if err != nil {
		return err
	}
	page.nflr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *NodeFileListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page NodeFileListResultPage) NotDone() bool {
	return !page.nflr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page NodeFileListResultPage) Response() NodeFileListResult {
	return page.nflr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page NodeFileListResultPage) Values() []NodeFile {
	if page.nflr.IsEmpty() {
		return nil
	}
	return *page.nflr.Value
}

// Creates a new instance of the NodeFileListResultPage type.
func NewNodeFileListResultPage(getNextPage func(context.Context, NodeFileListResult) (NodeFileListResult, error)) NodeFileListResultPage {
	return NodeFileListResultPage{fn: getNextPage}
}

// NodeRebootParameter ...
type NodeRebootParameter struct {
	// NodeRebootOption - The default value is requeue. Possible values include: 'ComputeNodeRebootOptionRequeue', 'ComputeNodeRebootOptionTerminate', 'ComputeNodeRebootOptionTaskCompletion', 'ComputeNodeRebootOptionRetainedData'
	NodeRebootOption ComputeNodeRebootOption `json:"nodeRebootOption,omitempty"`
}

// NodeReimageParameter ...
type NodeReimageParameter struct {
	// NodeReimageOption - The default value is requeue. Possible values include: 'ComputeNodeReimageOptionRequeue', 'ComputeNodeReimageOptionTerminate', 'ComputeNodeReimageOptionTaskCompletion', 'ComputeNodeReimageOptionRetainedData'
	NodeReimageOption ComputeNodeReimageOption `json:"nodeReimageOption,omitempty"`
}

// NodeRemoveParameter ...
type NodeRemoveParameter struct {
	NodeList *[]string `json:"nodeList,omitempty"`
	// ResizeTimeout - The default value is 15 minutes. The minimum value is 5 minutes. If you specify a value less than 5 minutes, the Batch service returns an error; if you are calling the REST API directly, the HTTP status code is 400 (Bad Request).
	ResizeTimeout *string `json:"resizeTimeout,omitempty"`
	// NodeDeallocationOption - The default value is requeue. Possible values include: 'Requeue', 'Terminate', 'TaskCompletion', 'RetainedData'
	NodeDeallocationOption ComputeNodeDeallocationOption `json:"nodeDeallocationOption,omitempty"`
}

// NodeUpdateUserParameter ...
type NodeUpdateUserParameter struct {
	// Password - The password is required for Windows nodes (those created with 'cloudServiceConfiguration', or created with 'virtualMachineConfiguration' using a Windows image reference). For Linux compute nodes, the password can optionally be specified along with the sshPublicKey property. If omitted, any existing password is removed.
	Password *string `json:"password,omitempty"`
	// ExpiryTime - If omitted, the default is 1 day from the current time. For Linux compute nodes, the expiryTime has a precision up to a day.
	ExpiryTime *date.Time `json:"expiryTime,omitempty"`
	// SSHPublicKey - The public key should be compatible with OpenSSH encoding and should be base 64 encoded. This property can be specified only for Linux nodes. If this is specified for a Windows node, then the Batch service rejects the request; if you are calling the REST API directly, the HTTP status code is 400 (Bad Request). If omitted, any existing SSH public key is removed.
	SSHPublicKey *string `json:"sshPublicKey,omitempty"`
}

// OSDisk ...
type OSDisk struct {
	// ImageUris - All the VHDs must be identical and must reside in an Azure Storage account within the same subscription and same region as the Batch account. For best performance, it is recommended that each VHD resides in a separate Azure Storage account. Each VHD can serve upto 20 Windows compute nodes or 40 Linux compute nodes. You must supply enough VHD URIs to satisfy the 'targetDedicated' property of the pool. If you do not supply enough VHD URIs, the pool will partially allocate compute nodes, and a resize error will occur.
	ImageUris *[]string `json:"imageUris,omitempty"`
	// Caching - none - The caching mode for the disk is not enabled. readOnly - The caching mode for the disk is read only. readWrite - The caching mode for the disk is read and write. The default value for caching is none. For information about the caching options see: https://blogs.msdn.microsoft.com/windowsazurestorage/2012/06/27/exploring-windows-azure-drives-disks-and-images/. Possible values include: 'None', 'ReadOnly', 'ReadWrite'
	Caching CachingType `json:"caching,omitempty"`
}

// OutputFile ...
type OutputFile struct {
	// FilePattern - Both relative and absolute paths are supported. Relative paths are relative to the task working directory. For wildcards, use * to match any character and ** to match any directory. For example, **\*.txt matches any file ending in .txt in the task working directory or any subdirectory. Note that \ and / are treated interchangeably and mapped to the correct directory separator on the compute node operating system.
	FilePattern   *string                  `json:"filePattern,omitempty"`
	Destination   *OutputFileDestination   `json:"destination,omitempty"`
	UploadOptions *OutputFileUploadOptions `json:"uploadOptions,omitempty"`
}

// OutputFileBlobContainerDestination ...
type OutputFileBlobContainerDestination struct {
	// Path - If filePattern refers to a specific file (i.e. contains no wildcards), then path is the name of the blob to which to upload that file. If filePattern contains one or more wildcards (and therefore may match multiple files), then path is the name of the blob virtual directory (which is prepended to each blob name) to which to upload the file(s). If omitted, file(s) are uploaded to the root of the container with a blob name matching their file name.
	Path *string `json:"path,omitempty"`
	// ContainerURL - The URL must include a Shared Access Signature (SAS) granting write permissions to the container.
	ContainerURL *string `json:"containerUrl,omitempty"`
}

// OutputFileDestination ...
type OutputFileDestination struct {
	Container *OutputFileBlobContainerDestination `json:"container,omitempty"`
}

// OutputFileUploadOptions ...
type OutputFileUploadOptions struct {
	// UploadCondition - The default is taskCompletion. Possible values include: 'OutputFileUploadConditionTaskSuccess', 'OutputFileUploadConditionTaskFailure', 'OutputFileUploadConditionTaskCompletion'
	UploadCondition OutputFileUploadCondition `json:"uploadCondition,omitempty"`
}

// PoolAddParameter ...
type PoolAddParameter struct {
	// ID - The ID can contain any combination of alphanumeric characters including hyphens and underscores, and cannot contain more than 64 characters. The ID is case-preserving and case-insensitive (that is, you may not have two pool IDs within an account that differ only by case).
	ID *string `json:"id,omitempty"`
	// DisplayName - The display name need not be unique and can contain any Unicode characters up to a maximum length of 1024.
	DisplayName *string `json:"displayName,omitempty"`
	// VMSize - For information about available sizes of virtual machines for Cloud Services pools (pools created with cloudServiceConfiguration), see Sizes for Cloud Services (http://azure.microsoft.com/documentation/articles/cloud-services-sizes-specs/). Batch supports all Cloud Services VM sizes except ExtraSmall, A1V2 and A2V2. For information about available VM sizes for pools using images from the Virtual Machines Marketplace (pools created with virtualMachineConfiguration) see Sizes for Virtual Machines (Linux) (https://azure.microsoft.com/documentation/articles/virtual-machines-linux-sizes/) or Sizes for Virtual Machines (Windows) (https://azure.microsoft.com/documentation/articles/virtual-machines-windows-sizes/). Batch supports all Azure VM sizes except STANDARD_A0 and those with premium storage (STANDARD_GS, STANDARD_DS, and STANDARD_DSV2 series).
	VMSize *string `json:"vmSize,omitempty"`
	// CloudServiceConfiguration - This property and virtualMachineConfiguration are mutually exclusive and one of the properties must be specified. This property cannot be specified if the Batch account was created with its poolAllocationMode property set to 'UserSubscription'.
	CloudServiceConfiguration *CloudServiceConfiguration `json:"cloudServiceConfiguration,omitempty"`
	// VirtualMachineConfiguration - This property and cloudServiceConfiguration are mutually exclusive and one of the properties must be specified.
	VirtualMachineConfiguration *VirtualMachineConfiguration `json:"virtualMachineConfiguration,omitempty"`
	// ResizeTimeout - This timeout applies only to manual scaling; it has no effect when enableAutoScale is set to true. The default value is 15 minutes. The minimum value is 5 minutes. If you specify a value less than 5 minutes, the Batch service returns an error; if you are calling the REST API directly, the HTTP status code is 400 (Bad Request).
	ResizeTimeout *string `json:"resizeTimeout,omitempty"`
	// TargetDedicatedNodes - This property must not be specified if enableAutoScale is set to true. If enableAutoScale is set to false, then you must set either targetDedicatedNodes, targetLowPriorityNodes, or both.
	TargetDedicatedNodes *int32 `json:"targetDedicatedNodes,omitempty"`
	// TargetLowPriorityNodes - This property must not be specified if enableAutoScale is set to true. If enableAutoScale is set to false, then you must set either targetDedicatedNodes, targetLowPriorityNodes, or both.
	TargetLowPriorityNodes *int32 `json:"targetLowPriorityNodes,omitempty"`
	// EnableAutoScale - If false, at least one of targetDedicateNodes and targetLowPriorityNodes must be specified. If true, the autoScaleFormula property is required and the pool automatically resizes according to the formula. The default value is false.
	EnableAutoScale *bool `json:"enableAutoScale,omitempty"`
	// AutoScaleFormula - This property must not be specified if enableAutoScale is set to false. It is required if enableAutoScale is set to true. The formula is checked for validity before the pool is created. If the formula is not valid, the Batch service rejects the request with detailed error information. For more information about specifying this formula, see 'Automatically scale compute nodes in an Azure Batch pool' (https://azure.microsoft.com/documentation/articles/batch-automatic-scaling/).
	AutoScaleFormula *string `json:"autoScaleFormula,omitempty"`
	// AutoScaleEvaluationInterval - The default value is 15 minutes. The minimum and maximum value are 5 minutes and 168 hours respectively. If you specify a value less than 5 minutes or greater than 168 hours, the Batch service returns an error; if you are calling the REST API directly, the HTTP status code is 400 (Bad Request).
	AutoScaleEvaluationInterval *string `json:"autoScaleEvaluationInterval,omitempty"`
	// EnableInterNodeCommunication - Enabling inter-node communication limits the maximum size of the pool due to deployment restrictions on the nodes of the pool. This may result in the pool not reaching its desired size. The default value is false.
	EnableInterNodeCommunication *bool                 `json:"enableInterNodeCommunication,omitempty"`
	NetworkConfiguration         *NetworkConfiguration `json:"networkConfiguration,omitempty"`
	// StartTask - The task runs when the node is added to the pool or when the node is restarted.
	StartTask *StartTask `json:"startTask,omitempty"`
	// CertificateReferences - For Windows compute nodes, the Batch service installs the certificates to the specified certificate store and location. For Linux compute nodes, the certificates are stored in a directory inside the task working directory and an environment variable AZ_BATCH_CERTIFICATES_DIR is supplied to the task to query for this location. For certificates with visibility of 'remoteUser', a 'certs' directory is created in the user's home directory (e.g., /home/{user-name}/certs) and certificates are placed in that directory.
	CertificateReferences *[]CertificateReference `json:"certificateReferences,omitempty"`
	// ApplicationPackageReferences - This property is currently not supported on pools created using the virtualMachineConfiguration (IaaS) property.
	ApplicationPackageReferences *[]ApplicationPackageReference `json:"applicationPackageReferences,omitempty"`
	// ApplicationLicenses - The list of application licenses must be a subset of available Batch service application licenses. If a license is requested which is not supported, pool creation will fail.
	ApplicationLicenses *[]string `json:"applicationLicenses,omitempty"`
	// MaxTasksPerNode - The default value is 1. The maximum value of this setting depends on the size of the compute nodes in the pool (the vmSize setting).
	MaxTasksPerNode      *int32                `json:"maxTasksPerNode,omitempty"`
	TaskSchedulingPolicy *TaskSchedulingPolicy `json:"taskSchedulingPolicy,omitempty"`
	UserAccounts         *[]UserAccount        `json:"userAccounts,omitempty"`
	// Metadata - The Batch service does not assign any meaning to metadata; it is solely for the use of user code.
	Metadata *[]MetadataItem `json:"metadata,omitempty"`
}

// PoolEnableAutoScaleParameter ...
type PoolEnableAutoScaleParameter struct {
	// AutoScaleFormula - The formula is checked for validity before it is applied to the pool. If the formula is not valid, the Batch service rejects the request with detailed error information. For more information about specifying this formula, see Automatically scale compute nodes in an Azure Batch pool (https://azure.microsoft.com/en-us/documentation/articles/batch-automatic-scaling).
	AutoScaleFormula *string `json:"autoScaleFormula,omitempty"`
	// AutoScaleEvaluationInterval - The default value is 15 minutes. The minimum and maximum value are 5 minutes and 168 hours respectively. If you specify a value less than 5 minutes or greater than 168 hours, the Batch service rejects the request with an invalid property value error; if you are calling the REST API directly, the HTTP status code is 400 (Bad Request). If you specify a new interval, then the existing autoscale evaluation schedule will be stopped and a new autoscale evaluation schedule will be started, with its starting time being the time when this request was issued.
	AutoScaleEvaluationInterval *string `json:"autoScaleEvaluationInterval,omitempty"`
}

// PoolEvaluateAutoScaleParameter ...
type PoolEvaluateAutoScaleParameter struct {
	// AutoScaleFormula - The formula is validated and its results calculated, but it is not applied to the pool. To apply the formula to the pool, 'Enable automatic scaling on a pool'. For more information about specifying this formula, see Automatically scale compute nodes in an Azure Batch pool (https://azure.microsoft.com/en-us/documentation/articles/batch-automatic-scaling).
	AutoScaleFormula *string `json:"autoScaleFormula,omitempty"`
}

// PoolInformation ...
type PoolInformation struct {
	// PoolID - You must ensure that the pool referenced by this property exists. If the pool does not exist at the time the Batch service tries to schedule a job, no tasks for the job will run until you create a pool with that id. Note that the Batch service will not reject the job request; it will simply not run tasks until the pool exists. You must specify either the pool ID or the auto pool specification, but not both.
	PoolID *string `json:"poolId,omitempty"`
	// AutoPoolSpecification - If auto pool creation fails, the Batch service moves the job to a completed state, and the pool creation error is set in the job's scheduling error property. The Batch service manages the lifetime (both creation and, unless keepAlive is specified, deletion) of the auto pool. Any user actions that affect the lifetime of the auto pool while the job is active will result in unexpected behavior. You must specify either the pool ID or the auto pool specification, but not both.
	AutoPoolSpecification *AutoPoolSpecification `json:"autoPoolSpecification,omitempty"`
}

// PoolListUsageMetricsResult ...
type PoolListUsageMetricsResult struct {
	autorest.Response `json:"-"`
	Value             *[]PoolUsageMetrics `json:"value,omitempty"`
	OdataNextLink     *string             `json:"odata.nextLink,omitempty"`
}

// PoolListUsageMetricsResultIterator provides access to a complete listing of PoolUsageMetrics values.
type PoolListUsageMetricsResultIterator struct {
	i    int
	page PoolListUsageMetricsResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PoolListUsageMetricsResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PoolListUsageMetricsResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PoolListUsageMetricsResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PoolListUsageMetricsResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PoolListUsageMetricsResultIterator) Response() PoolListUsageMetricsResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PoolListUsageMetricsResultIterator) Value() PoolUsageMetrics {
	if !iter.page.NotDone() {
		return PoolUsageMetrics{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PoolListUsageMetricsResultIterator type.
func NewPoolListUsageMetricsResultIterator(page PoolListUsageMetricsResultPage) PoolListUsageMetricsResultIterator {
	return PoolListUsageMetricsResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (plumr PoolListUsageMetricsResult) IsEmpty() bool {
	return plumr.Value == nil || len(*plumr.Value) == 0
}

// poolListUsageMetricsResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (plumr PoolListUsageMetricsResult) poolListUsageMetricsResultPreparer(ctx context.Context) (*http.Request, error) {
	if plumr.OdataNextLink == nil || len(to.String(plumr.OdataNextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(plumr.OdataNextLink)))
}

// PoolListUsageMetricsResultPage contains a page of PoolUsageMetrics values.
type PoolListUsageMetricsResultPage struct {
	fn    func(context.Context, PoolListUsageMetricsResult) (PoolListUsageMetricsResult, error)
	plumr PoolListUsageMetricsResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PoolListUsageMetricsResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PoolListUsageMetricsResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.plumr)
	if err != nil {
		return err
	}
	page.plumr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PoolListUsageMetricsResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PoolListUsageMetricsResultPage) NotDone() bool {
	return !page.plumr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PoolListUsageMetricsResultPage) Response() PoolListUsageMetricsResult {
	return page.plumr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PoolListUsageMetricsResultPage) Values() []PoolUsageMetrics {
	if page.plumr.IsEmpty() {
		return nil
	}
	return *page.plumr.Value
}

// Creates a new instance of the PoolListUsageMetricsResultPage type.
func NewPoolListUsageMetricsResultPage(getNextPage func(context.Context, PoolListUsageMetricsResult) (PoolListUsageMetricsResult, error)) PoolListUsageMetricsResultPage {
	return PoolListUsageMetricsResultPage{fn: getNextPage}
}

// PoolPatchParameter ...
type PoolPatchParameter struct {
	// StartTask - If omitted, any existing start task is left unchanged.
	StartTask *StartTask `json:"startTask,omitempty"`
	// CertificateReferences - If omitted, any existing certificate references are left unchanged. For Windows compute nodes, the Batch service installs the certificates to the specified certificate store and location. For Linux compute nodes, the certificates are stored in a directory inside the task working directory and an environment variable AZ_BATCH_CERTIFICATES_DIR is supplied to the task to query for this location. For certificates with visibility of 'remoteUser', a 'certs' directory is created in the user's home directory (e.g., /home/{user-name}/certs) and certificates are placed in that directory.
	CertificateReferences *[]CertificateReference `json:"certificateReferences,omitempty"`
	// ApplicationPackageReferences - Changes to application package references affect all new compute nodes joining the pool, but do not affect compute nodes that are already in the pool until they are rebooted or reimaged. If this element is present, it replaces any existing application package references. If you specify an empty collection, then all application package references are removed from the pool. If omitted, any existing application package references are left unchanged.
	ApplicationPackageReferences *[]ApplicationPackageReference `json:"applicationPackageReferences,omitempty"`
	// Metadata - If this element is present, it replaces any existing metadata configured on the pool. If you specify an empty collection, any metadata is removed from the pool. If omitted, any existing metadata is left unchanged.
	Metadata *[]MetadataItem `json:"metadata,omitempty"`
}

// PoolResizeParameter ...
type PoolResizeParameter struct {
	TargetDedicatedNodes   *int32 `json:"targetDedicatedNodes,omitempty"`
	TargetLowPriorityNodes *int32 `json:"targetLowPriorityNodes,omitempty"`
	// ResizeTimeout - The default value is 15 minutes. The minimum value is 5 minutes. If you specify a value less than 5 minutes, the Batch service returns an error; if you are calling the REST API directly, the HTTP status code is 400 (Bad Request).
	ResizeTimeout *string `json:"resizeTimeout,omitempty"`
	// NodeDeallocationOption - The default value is requeue. Possible values include: 'Requeue', 'Terminate', 'TaskCompletion', 'RetainedData'
	NodeDeallocationOption ComputeNodeDeallocationOption `json:"nodeDeallocationOption,omitempty"`
}

// PoolSpecification ...
type PoolSpecification struct {
	// DisplayName - The display name need not be unique and can contain any Unicode characters up to a maximum length of 1024.
	DisplayName *string `json:"displayName,omitempty"`
	// VMSize - For information about available sizes of virtual machines for Cloud Services pools (pools created with cloudServiceConfiguration), see Sizes for Cloud Services (http://azure.microsoft.com/documentation/articles/cloud-services-sizes-specs/). Batch supports all Cloud Services VM sizes except ExtraSmall, A1V2 and A2V2. For information about available VM sizes for pools using images from the Virtual Machines Marketplace (pools created with virtualMachineConfiguration) see Sizes for Virtual Machines (Linux) (https://azure.microsoft.com/documentation/articles/virtual-machines-linux-sizes/) or Sizes for Virtual Machines (Windows) (https://azure.microsoft.com/documentation/articles/virtual-machines-windows-sizes/). Batch supports all Azure VM sizes except STANDARD_A0 and those with premium storage (STANDARD_GS, STANDARD_DS, and STANDARD_DSV2 series).
	VMSize *string `json:"vmSize,omitempty"`
	// CloudServiceConfiguration - This property must be specified if the pool needs to be created with Azure PaaS VMs. This property and virtualMachineConfiguration are mutually exclusive and one of the properties must be specified. If neither is specified then the Batch service returns an error; if you are calling the REST API directly, the HTTP status code is 400 (Bad Request). This property cannot be specified if the Batch account was created with its poolAllocationMode property set to 'UserSubscription'.
	CloudServiceConfiguration *CloudServiceConfiguration `json:"cloudServiceConfiguration,omitempty"`
	// VirtualMachineConfiguration - This property must be specified if the pool needs to be created with Azure IaaS VMs. This property and cloudServiceConfiguration are mutually exclusive and one of the properties must be specified. If neither is specified then the Batch service returns an error; if you are calling the REST API directly, the HTTP status code is 400 (Bad Request).
	VirtualMachineConfiguration *VirtualMachineConfiguration `json:"virtualMachineConfiguration,omitempty"`
	// MaxTasksPerNode - The default value is 1. The maximum value of this setting depends on the size of the compute nodes in the pool (the vmSize setting).
	MaxTasksPerNode *int32 `json:"maxTasksPerNode,omitempty"`
	// TaskSchedulingPolicy - How tasks are distributed among compute nodes in the pool.
	TaskSchedulingPolicy *TaskSchedulingPolicy `json:"taskSchedulingPolicy,omitempty"`
	// ResizeTimeout - This timeout applies only to manual scaling; it has no effect when enableAutoScale is set to true. The default value is 15 minutes. The minimum value is 5 minutes. If you specify a value less than 5 minutes, the Batch service rejects the request with an error; if you are calling the REST API directly, the HTTP status code is 400 (Bad Request).
	ResizeTimeout *string `json:"resizeTimeout,omitempty"`
	// TargetDedicatedNodes - This property must not be specified if enableAutoScale is set to true. If enableAutoScale is set to false, then you must set either targetDedicatedNodes, targetLowPriorityNodes, or both.
	TargetDedicatedNodes *int32 `json:"targetDedicatedNodes,omitempty"`
	// TargetLowPriorityNodes - This property must not be specified if enableAutoScale is set to true. If enableAutoScale is set to false, then you must set either targetDedicatedNodes, targetLowPriorityNodes, or both.
	TargetLowPriorityNodes *int32 `json:"targetLowPriorityNodes,omitempty"`
	// EnableAutoScale - If false, at least one of targetDedicateNodes and targetLowPriorityNodes must be specified. If true, the autoScaleFormula element is required. The pool automatically resizes according to the formula. The default value is false.
	EnableAutoScale *bool `json:"enableAutoScale,omitempty"`
	// AutoScaleFormula - This property must not be specified if enableAutoScale is set to false. It is required if enableAutoScale is set to true. The formula is checked for validity before the pool is created. If the formula is not valid, the Batch service rejects the request with detailed error information.
	AutoScaleFormula *string `json:"autoScaleFormula,omitempty"`
	// AutoScaleEvaluationInterval - The default value is 15 minutes. The minimum and maximum value are 5 minutes and 168 hours respectively. If you specify a value less than 5 minutes or greater than 168 hours, the Batch service rejects the request with an invalid property value error; if you are calling the REST API directly, the HTTP status code is 400 (Bad Request).
	AutoScaleEvaluationInterval *string `json:"autoScaleEvaluationInterval,omitempty"`
	// EnableInterNodeCommunication - Enabling inter-node communication limits the maximum size of the pool due to deployment restrictions on the nodes of the pool. This may result in the pool not reaching its desired size. The default value is false.
	EnableInterNodeCommunication *bool                 `json:"enableInterNodeCommunication,omitempty"`
	NetworkConfiguration         *NetworkConfiguration `json:"networkConfiguration,omitempty"`
	StartTask                    *StartTask            `json:"startTask,omitempty"`
	// CertificateReferences - For Windows compute nodes, the Batch service installs the certificates to the specified certificate store and location. For Linux compute nodes, the certificates are stored in a directory inside the task working directory and an environment variable AZ_BATCH_CERTIFICATES_DIR is supplied to the task to query for this location. For certificates with visibility of 'remoteUser', a 'certs' directory is created in the user's home directory (e.g., /home/{user-name}/certs) and certificates are placed in that directory.
	CertificateReferences *[]CertificateReference `json:"certificateReferences,omitempty"`
	// ApplicationPackageReferences - This property is currently not supported on auto pools created with the virtualMachineConfiguration (IaaS) property.
	ApplicationPackageReferences *[]ApplicationPackageReference `json:"applicationPackageReferences,omitempty"`
	// ApplicationLicenses - The list of application licenses must be a subset of available Batch service application licenses. If a license is requested which is not supported, pool creation will fail.
	ApplicationLicenses *[]string      `json:"applicationLicenses,omitempty"`
	UserAccounts        *[]UserAccount `json:"userAccounts,omitempty"`
	// Metadata - The Batch service does not assign any meaning to metadata; it is solely for the use of user code.
	Metadata *[]MetadataItem `json:"metadata,omitempty"`
}

// PoolStatistics ...
type PoolStatistics struct {
	autorest.Response `json:"-"`
	URL               *string             `json:"url,omitempty"`
	StartTime         *date.Time          `json:"startTime,omitempty"`
	LastUpdateTime    *date.Time          `json:"lastUpdateTime,omitempty"`
	UsageStats        *UsageStatistics    `json:"usageStats,omitempty"`
	ResourceStats     *ResourceStatistics `json:"resourceStats,omitempty"`
}

// PoolUpdatePropertiesParameter ...
type PoolUpdatePropertiesParameter struct {
	// StartTask - If this element is present, it overwrites any existing start task. If omitted, any existing start task is removed from the pool.
	StartTask *StartTask `json:"startTask,omitempty"`
	// CertificateReferences - If you specify an empty collection, any existing certificate references are removed from the pool. For Windows compute nodes, the Batch service installs the certificates to the specified certificate store and location. For Linux compute nodes, the certificates are stored in a directory inside the task working directory and an environment variable AZ_BATCH_CERTIFICATES_DIR is supplied to the task to query for this location. For certificates with visibility of 'remoteUser', a 'certs' directory is created in the user's home directory (e.g., /home/{user-name}/certs) and certificates are placed in that directory.
	CertificateReferences *[]CertificateReference `json:"certificateReferences,omitempty"`
	// ApplicationPackageReferences - Changes to application package references affect all new compute nodes joining the pool, but do not affect compute nodes that are already in the pool until they are rebooted or reimaged. The list replaces any existing application package references. If omitted, or if you specify an empty collection, any existing application packages references are removed from the pool.
	ApplicationPackageReferences *[]ApplicationPackageReference `json:"applicationPackageReferences,omitempty"`
	// Metadata - This list replaces any existing metadata configured on the pool. If omitted, or if you specify an empty collection, any existing metadata is removed from the pool.
	Metadata *[]MetadataItem `json:"metadata,omitempty"`
}

// PoolUpgradeOSParameter ...
type PoolUpgradeOSParameter struct {
	TargetOSVersion *string `json:"targetOSVersion,omitempty"`
}

// PoolUsageMetrics ...
type PoolUsageMetrics struct {
	PoolID    *string    `json:"poolId,omitempty"`
	StartTime *date.Time `json:"startTime,omitempty"`
	EndTime   *date.Time `json:"endTime,omitempty"`
	// VMSize - For information about available sizes of virtual machines for Cloud Services pools (pools created with cloudServiceConfiguration), see Sizes for Cloud Services (http://azure.microsoft.com/documentation/articles/cloud-services-sizes-specs/). Batch supports all Cloud Services VM sizes except ExtraSmall, A1V2 and A2V2. For information about available VM sizes for pools using images from the Virtual Machines Marketplace (pools created with virtualMachineConfiguration) see Sizes for Virtual Machines (Linux) (https://azure.microsoft.com/documentation/articles/virtual-machines-linux-sizes/) or Sizes for Virtual Machines (Windows) (https://azure.microsoft.com/documentation/articles/virtual-machines-windows-sizes/). Batch supports all Azure VM sizes except STANDARD_A0 and those with premium storage (STANDARD_GS, STANDARD_DS, and STANDARD_DSV2 series).
	VMSize         *string  `json:"vmSize,omitempty"`
	TotalCoreHours *float64 `json:"totalCoreHours,omitempty"`
	DataIngressGiB *float64 `json:"dataIngressGiB,omitempty"`
	DataEgressGiB  *float64 `json:"dataEgressGiB,omitempty"`
}

// ReadCloser ...
type ReadCloser struct {
	autorest.Response `json:"-"`
	Value             *io.ReadCloser `json:"value,omitempty"`
}

// RecentJob ...
type RecentJob struct {
	ID  *string `json:"id,omitempty"`
	URL *string `json:"url,omitempty"`
}

// ResizeError ...
type ResizeError struct {
	Code    *string          `json:"code,omitempty"`
	Message *string          `json:"message,omitempty"`
	Values  *[]NameValuePair `json:"values,omitempty"`
}

// ResourceFile ...
type ResourceFile struct {
	// BlobSource - This URL must be readable using anonymous access; that is, the Batch service does not present any credentials when downloading the blob. There are two ways to get such a URL for a blob in Azure storage: include a Shared Access Signature (SAS) granting read permissions on the blob, or set the ACL for the blob or its container to allow public access.
	BlobSource *string `json:"blobSource,omitempty"`
	FilePath   *string `json:"filePath,omitempty"`
	// FileMode - This property applies only to files being downloaded to Linux compute nodes. It will be ignored if it is specified for a resourceFile which will be downloaded to a Windows node. If this property is not specified for a Linux node, then a default value of 0770 is applied to the file.
	FileMode *string `json:"fileMode,omitempty"`
}

// ResourceStatistics ...
type ResourceStatistics struct {
	StartTime        *date.Time `json:"startTime,omitempty"`
	LastUpdateTime   *date.Time `json:"lastUpdateTime,omitempty"`
	AvgCPUPercentage *float64   `json:"avgCPUPercentage,omitempty"`
	AvgMemoryGiB     *float64   `json:"avgMemoryGiB,omitempty"`
	PeakMemoryGiB    *float64   `json:"peakMemoryGiB,omitempty"`
	AvgDiskGiB       *float64   `json:"avgDiskGiB,omitempty"`
	PeakDiskGiB      *float64   `json:"peakDiskGiB,omitempty"`
	DiskReadIOps     *int64     `json:"diskReadIOps,omitempty"`
	DiskWriteIOps    *int64     `json:"diskWriteIOps,omitempty"`
	DiskReadGiB      *float64   `json:"diskReadGiB,omitempty"`
	DiskWriteGiB     *float64   `json:"diskWriteGiB,omitempty"`
	NetworkReadGiB   *float64   `json:"networkReadGiB,omitempty"`
	NetworkWriteGiB  *float64   `json:"networkWriteGiB,omitempty"`
}

// Schedule ...
type Schedule struct {
	// DoNotRunUntil - If you do not specify a doNotRunUntil time, the schedule becomes ready to create jobs immediately.
	DoNotRunUntil *date.Time `json:"doNotRunUntil,omitempty"`
	// DoNotRunAfter - If you do not specify a doNotRunAfter time, and you are creating a recurring job schedule, the job schedule will remain active until you explicitly terminate it.
	DoNotRunAfter *date.Time `json:"doNotRunAfter,omitempty"`
	// StartWindow - If a job is not created within the startWindow interval, then the 'opportunity' is lost; no job will be created until the next recurrence of the schedule. If the schedule is recurring, and the startWindow is longer than the recurrence interval, then this is equivalent to an infinite startWindow, because the job that is 'due' in one recurrenceInterval is not carried forward into the next recurrence interval. The default is infinite. The minimum value is 1 minute. If you specify a lower value, the Batch service rejects the schedule with an error; if you are calling the REST API directly, the HTTP status code is 400 (Bad Request).
	StartWindow *string `json:"startWindow,omitempty"`
	// RecurrenceInterval - Because a job schedule can have at most one active job under it at any given time, if it is time to create a new job under a job schedule, but the previous job is still running, the Batch service will not create the new job until the previous job finishes. If the previous job does not finish within the startWindow period of the new recurrenceInterval, then no new job will be scheduled for that interval. For recurring jobs, you should normally specify a jobManagerTask in the jobSpecification. If you do not use jobManagerTask, you will need an external process to monitor when jobs are created, add tasks to the jobs and terminate the jobs ready for the next recurrence. The default is that the schedule does not recur: one job is created, within the startWindow after the doNotRunUntil time, and the schedule is complete as soon as that job finishes. The minimum value is 1 minute. If you specify a lower value, the Batch service rejects the schedule with an error; if you are calling the REST API directly, the HTTP status code is 400 (Bad Request).
	RecurrenceInterval *string `json:"recurrenceInterval,omitempty"`
}

// StartTask ...
type StartTask struct {
	// CommandLine - The command line does not run under a shell, and therefore cannot take advantage of shell features such as environment variable expansion. If you want to take advantage of such features, you should invoke the shell in the command line, for example using "cmd /c MyCommand" in Windows or "/bin/sh -c MyCommand" in Linux.
	CommandLine         *string               `json:"commandLine,omitempty"`
	ResourceFiles       *[]ResourceFile       `json:"resourceFiles,omitempty"`
	EnvironmentSettings *[]EnvironmentSetting `json:"environmentSettings,omitempty"`
	// UserIdentity - If omitted, the task runs as a non-administrative user unique to the task.
	UserIdentity *UserIdentity `json:"userIdentity,omitempty"`
	// MaxTaskRetryCount - The Batch service retries a task if its exit code is nonzero. Note that this value specifically controls the number of retries. The Batch service will try the task once, and may then retry up to this limit. For example, if the maximum retry count is 3, Batch tries the task up to 4 times (one initial try and 3 retries). If the maximum retry count is 0, the Batch service does not retry the task. If the maximum retry count is -1, the Batch service retries the task without limit.
	MaxTaskRetryCount *int32 `json:"maxTaskRetryCount,omitempty"`
	// WaitForSuccess - If true and the start task fails on a compute node, the Batch service retries the start task up to its maximum retry count (maxTaskRetryCount). If the task has still not completed successfully after all retries, then the Batch service marks the compute node unusable, and will not schedule tasks to it. This condition can be detected via the node state and scheduling error detail. If false, the Batch service will not wait for the start task to complete. In this case, other tasks can start executing on the compute node while the start task is still running; and even if the start task fails, new tasks will continue to be scheduled on the node. The default is false.
	WaitForSuccess *bool `json:"waitForSuccess,omitempty"`
}

// StartTaskInformation ...
type StartTaskInformation struct {
	// State - running - The start task is currently running. completed - The start task has exited with exit code 0, or the start task has failed and the retry limit has reached, or the start task process did not run due to scheduling errors. Possible values include: 'StartTaskStateRunning', 'StartTaskStateCompleted'
	State StartTaskState `json:"state,omitempty"`
	// StartTime - This value is reset every time the task is restarted or retried (that is, this is the most recent time at which the start task started running).
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - This is the end time of the most recent run of the start task, if that run has completed (even if that run failed and a retry is pending). This element is not present if the start task is currently running.
	EndTime *date.Time `json:"endTime,omitempty"`
	// ExitCode - This property is set only if the start task is in the completed state. In general, the exit code for a process reflects the specific convention implemented by the application developer for that process. If you use the exit code value to make decisions in your code, be sure that you know the exit code convention used by the application process. However, if the Batch service terminates the start task (due to timeout, or user termination via the API) you may see an operating system-defined exit code.
	ExitCode *int32 `json:"exitCode,omitempty"`
	// FailureInfo - This property is set only if the task is in the completed state and encountered a failure.
	FailureInfo *TaskFailureInformation `json:"failureInfo,omitempty"`
	// RetryCount - The number of times the task has been retried by the Batch service. Task application failures (non-zero exit code) are retried, pre-processing errors (the task could not be run) and file upload errors are not retried. The Batch service will retry the task up to the limit specified by the constraints.
	RetryCount *int32 `json:"retryCount,omitempty"`
	// LastRetryTime - This element is present only if the task was retried (i.e. retryCount is nonzero). If present, this is typically the same as startTime, but may be different if the task has been restarted for reasons other than retry; for example, if the compute node was rebooted during a retry, then the startTime is updated but the lastRetryTime is not.
	LastRetryTime *date.Time `json:"lastRetryTime,omitempty"`
	// Result - If the value is 'failed', then the details of the failure can be found in the failureInfo property. Possible values include: 'Success', 'Failure'
	Result TaskExecutionResult `json:"result,omitempty"`
}

// SubtaskInformation ...
type SubtaskInformation struct {
	ID        *int32                  `json:"id,omitempty"`
	NodeInfo  *ComputeNodeInformation `json:"nodeInfo,omitempty"`
	StartTime *date.Time              `json:"startTime,omitempty"`
	// EndTime - This property is set only if the subtask is in the Completed state.
	EndTime *date.Time `json:"endTime,omitempty"`
	// ExitCode - This property is set only if the subtask is in the completed state. In general, the exit code for a process reflects the specific convention implemented by the application developer for that process. If you use the exit code value to make decisions in your code, be sure that you know the exit code convention used by the application process. However, if the Batch service terminates the subtask (due to timeout, or user termination via the API) you may see an operating system-defined exit code.
	ExitCode *int32 `json:"exitCode,omitempty"`
	// FailureInfo - This property is set only if the task is in the completed state and encountered a failure.
	FailureInfo *TaskFailureInformation `json:"failureInfo,omitempty"`
	// State - Possible values include: 'SubtaskStatePreparing', 'SubtaskStateRunning', 'SubtaskStateCompleted'
	State               SubtaskState `json:"state,omitempty"`
	StateTransitionTime *date.Time   `json:"stateTransitionTime,omitempty"`
	// PreviousState - This property is not set if the subtask is in its initial running state. Possible values include: 'SubtaskStatePreparing', 'SubtaskStateRunning', 'SubtaskStateCompleted'
	PreviousState SubtaskState `json:"previousState,omitempty"`
	// PreviousStateTransitionTime - This property is not set if the subtask is in its initial running state.
	PreviousStateTransitionTime *date.Time `json:"previousStateTransitionTime,omitempty"`
	// Result - If the value is 'failed', then the details of the failure can be found in the failureInfo property. Possible values include: 'Success', 'Failure'
	Result TaskExecutionResult `json:"result,omitempty"`
}

// TaskAddCollectionParameter ...
type TaskAddCollectionParameter struct {
	Value *[]TaskAddParameter `json:"value,omitempty"`
}

// TaskAddCollectionResult ...
type TaskAddCollectionResult struct {
	autorest.Response `json:"-"`
	Value             *[]TaskAddResult `json:"value,omitempty"`
}

// TaskAddParameter ...
type TaskAddParameter struct {
	// ID - The ID can contain any combination of alphanumeric characters including hyphens and underscores, and cannot contain more than 64 characters. The ID is case-preserving and case-insensitive (that is, you may not have two IDs within a job that differ only by case).
	ID *string `json:"id,omitempty"`
	// DisplayName - The display name need not be unique and can contain any Unicode characters up to a maximum length of 1024.
	DisplayName *string `json:"displayName,omitempty"`
	// CommandLine - For multi-instance tasks, the command line is executed as the primary task, after the primary task and all subtasks have finished executing the coordination command line. The command line does not run under a shell, and therefore cannot take advantage of shell features such as environment variable expansion. If you want to take advantage of such features, you should invoke the shell in the command line, for example using "cmd /c MyCommand" in Windows or "/bin/sh -c MyCommand" in Linux.
	CommandLine *string `json:"commandLine,omitempty"`
	// ExitConditions - How the Batch service should respond when the task completes.
	ExitConditions *ExitConditions `json:"exitConditions,omitempty"`
	// ResourceFiles - For multi-instance tasks, the resource files will only be downloaded to the compute node on which the primary task is executed.
	ResourceFiles *[]ResourceFile `json:"resourceFiles,omitempty"`
	// OutputFiles - For multi-instance tasks, the files will only be uploaded from the compute node on which the primary task is executed.
	OutputFiles         *[]OutputFile         `json:"outputFiles,omitempty"`
	EnvironmentSettings *[]EnvironmentSetting `json:"environmentSettings,omitempty"`
	AffinityInfo        *AffinityInformation  `json:"affinityInfo,omitempty"`
	// Constraints - If you do not specify constraints, the maxTaskRetryCount is the maxTaskRetryCount specified for the job, and the maxWallClockTime and retentionTime are infinite.
	Constraints *TaskConstraints `json:"constraints,omitempty"`
	// UserIdentity - If omitted, the task runs as a non-administrative user unique to the task.
	UserIdentity          *UserIdentity          `json:"userIdentity,omitempty"`
	MultiInstanceSettings *MultiInstanceSettings `json:"multiInstanceSettings,omitempty"`
	// DependsOn - This task will not be scheduled until all tasks that it depends on have completed successfully. If any of those tasks fail and exhaust their retry counts, this task will never be scheduled. If the job does not have usesTaskDependencies set to true, and this element is present, the request fails with error code TaskDependenciesNotSpecifiedOnJob.
	DependsOn                    *TaskDependencies              `json:"dependsOn,omitempty"`
	ApplicationPackageReferences *[]ApplicationPackageReference `json:"applicationPackageReferences,omitempty"`
	// AuthenticationTokenSettings - If this property is set, the Batch service provides the task with an authentication token which can be used to authenticate Batch service operations without requiring an account access key. The token is provided via the AZ_BATCH_AUTHENTICATION_TOKEN environment variable. The operations that the task can carry out using the token depend on the settings. For example, a task can request job permissions in order to add other tasks to the job, or check the status of the job or of other tasks under the job.
	AuthenticationTokenSettings *AuthenticationTokenSettings `json:"authenticationTokenSettings,omitempty"`
}

// TaskAddResult ...
type TaskAddResult struct {
	// Status - Possible values include: 'TaskAddStatusSuccess', 'TaskAddStatusClientError', 'TaskAddStatusServerError'
	Status       TaskAddStatus `json:"status,omitempty"`
	TaskID       *string       `json:"taskId,omitempty"`
	ETag         *string       `json:"eTag,omitempty"`
	LastModified *date.Time    `json:"lastModified,omitempty"`
	Location     *string       `json:"location,omitempty"`
	Error        *Error        `json:"error,omitempty"`
}

// TaskConstraints ...
type TaskConstraints struct {
	// MaxWallClockTime - If this is not specified, there is no time limit on how long the task may run.
	MaxWallClockTime *string `json:"maxWallClockTime,omitempty"`
	// RetentionTime - The default is infinite, i.e. the task directory will be retained until the compute node is removed or reimaged.
	RetentionTime *string `json:"retentionTime,omitempty"`
	// MaxTaskRetryCount - Note that this value specifically controls the number of retries. The Batch service will try the task once, and may then retry up to this limit. For example, if the maximum retry count is 3, Batch tries the task up to 4 times (one initial try and 3 retries). If the maximum retry count is 0, the Batch service does not retry the task. If the maximum retry count is -1, the Batch service retries the task without limit.
	MaxTaskRetryCount *int32 `json:"maxTaskRetryCount,omitempty"`
}

// TaskDependencies ...
type TaskDependencies struct {
	TaskIds      *[]string      `json:"taskIds,omitempty"`
	TaskIDRanges *[]TaskIDRange `json:"taskIdRanges,omitempty"`
}

// TaskExecutionInformation ...
type TaskExecutionInformation struct {
	// StartTime - 'Running' corresponds to the running state, so if the task specifies resource files or application packages, then the start time reflects the time at which the task started downloading or deploying these. If the task has been restarted or retried, this is the most recent time at which the task started running. This property is present only for tasks that are in the running or completed state.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - This property is set only if the task is in the Completed state.
	EndTime *date.Time `json:"endTime,omitempty"`
	// ExitCode - This property is set only if the task is in the completed state. In general, the exit code for a process reflects the specific convention implemented by the application developer for that process. If you use the exit code value to make decisions in your code, be sure that you know the exit code convention used by the application process. However, if the Batch service terminates the task (due to timeout, or user termination via the API) you may see an operating system-defined exit code.
	ExitCode *int32 `json:"exitCode,omitempty"`
	// FailureInfo - This property is set only if the task is in the completed state and encountered a failure.
	FailureInfo *TaskFailureInformation `json:"failureInfo,omitempty"`
	// RetryCount - The number of times the task has been retried by the Batch service. Task application failures (non-zero exit code) are retried, pre-processing errors (the task could not be run) and file upload errors are not retried. The Batch service will retry the task up to the limit specified by the constraints.
	RetryCount *int32 `json:"retryCount,omitempty"`
	// LastRetryTime - This element is present only if the task was retried (i.e. retryCount is nonzero). If present, this is typically the same as startTime, but may be different if the task has been restarted for reasons other than retry; for example, if the compute node was rebooted during a retry, then the startTime is updated but the lastRetryTime is not.
	LastRetryTime *date.Time `json:"lastRetryTime,omitempty"`
	// RequeueCount - When the user removes nodes from a pool (by resizing/shrinking the pool) or when the job is being disabled, the user can specify that running tasks on the nodes be requeued for execution. This count tracks how many times the task has been requeued for these reasons.
	RequeueCount *int32 `json:"requeueCount,omitempty"`
	// LastRequeueTime - This property is set only if the requeueCount is nonzero.
	LastRequeueTime *date.Time `json:"lastRequeueTime,omitempty"`
	// Result - If the value is 'failed', then the details of the failure can be found in the failureInfo property. Possible values include: 'Success', 'Failure'
	Result TaskExecutionResult `json:"result,omitempty"`
}

// TaskFailureInformation ...
type TaskFailureInformation struct {
	// Category - Possible values include: 'UserError', 'ServerError'
	Category ErrorCategory    `json:"category,omitempty"`
	Code     *string          `json:"code,omitempty"`
	Message  *string          `json:"message,omitempty"`
	Details  *[]NameValuePair `json:"details,omitempty"`
}

// TaskIDRange the start and end of the range are inclusive. For example, if a range has start 9 and end
// 12, then it represents tasks '9', '10', '11' and '12'.
type TaskIDRange struct {
	Start *int32 `json:"start,omitempty"`
	End   *int32 `json:"end,omitempty"`
}

// TaskInformation ...
type TaskInformation struct {
	TaskURL   *string `json:"taskUrl,omitempty"`
	JobID     *string `json:"jobId,omitempty"`
	TaskID    *string `json:"taskId,omitempty"`
	SubtaskID *int32  `json:"subtaskId,omitempty"`
	// TaskState - Possible values include: 'TaskStateActive', 'TaskStatePreparing', 'TaskStateRunning', 'TaskStateCompleted'
	TaskState     TaskState                 `json:"taskState,omitempty"`
	ExecutionInfo *TaskExecutionInformation `json:"executionInfo,omitempty"`
}

// TaskSchedulingPolicy ...
type TaskSchedulingPolicy struct {
	// NodeFillType - Possible values include: 'Spread', 'Pack'
	NodeFillType ComputeNodeFillType `json:"nodeFillType,omitempty"`
}

// TaskStatistics ...
type TaskStatistics struct {
	URL            *string    `json:"url,omitempty"`
	StartTime      *date.Time `json:"startTime,omitempty"`
	LastUpdateTime *date.Time `json:"lastUpdateTime,omitempty"`
	UserCPUTime    *string    `json:"userCPUTime,omitempty"`
	KernelCPUTime  *string    `json:"kernelCPUTime,omitempty"`
	// WallClockTime - The wall clock time is the elapsed time from when the task started running on a compute node to when it finished (or to the last time the statistics were updated, if the task had not finished by then). If the task was retried, this includes the wall clock time of all the task retries.
	WallClockTime *string  `json:"wallClockTime,omitempty"`
	ReadIOps      *int64   `json:"readIOps,omitempty"`
	WriteIOps     *int64   `json:"writeIOps,omitempty"`
	ReadIOGiB     *float64 `json:"readIOGiB,omitempty"`
	WriteIOGiB    *float64 `json:"writeIOGiB,omitempty"`
	WaitTime      *string  `json:"waitTime,omitempty"`
}

// TaskUpdateParameter ...
type TaskUpdateParameter struct {
	// Constraints - If omitted, the task is given the default constraints.
	Constraints *TaskConstraints `json:"constraints,omitempty"`
}

// UsageStatistics ...
type UsageStatistics struct {
	StartTime         *date.Time `json:"startTime,omitempty"`
	LastUpdateTime    *date.Time `json:"lastUpdateTime,omitempty"`
	DedicatedCoreTime *string    `json:"dedicatedCoreTime,omitempty"`
}

// UserAccount ...
type UserAccount struct {
	Name     *string `json:"name,omitempty"`
	Password *string `json:"password,omitempty"`
	// ElevationLevel - nonAdmin - The auto user is a standard user without elevated access. admin - The auto user is a user with elevated access and operates with full Administrator permissions. The default value is nonAdmin. Possible values include: 'NonAdmin', 'Admin'
	ElevationLevel ElevationLevel `json:"elevationLevel,omitempty"`
	// LinuxUserConfiguration - This property is ignored if specified on a Windows pool. If not specified, the user is created with the default options.
	LinuxUserConfiguration *LinuxUserConfiguration `json:"linuxUserConfiguration,omitempty"`
}

// UserIdentity specify either the userName or autoUser property, but not both.
type UserIdentity struct {
	// UserName - The userName and autoUser properties are mutually exclusive; you must specify one but not both.
	UserName *string `json:"username,omitempty"`
	// AutoUser - The userName and autoUser properties are mutually exclusive; you must specify one but not both.
	AutoUser *AutoUserSpecification `json:"autoUser,omitempty"`
}

// VirtualMachineConfiguration ...
type VirtualMachineConfiguration struct {
	// ImageReference - This property and osDisk are mutually exclusive and one of the properties must be specified.
	ImageReference *ImageReference `json:"imageReference,omitempty"`
	// OsDisk - This property can be specified only if the Batch account was created with its poolAllocationMode property set to 'UserSubscription'. This property and imageReference are mutually exclusive and one of the properties must be specified.
	OsDisk *OSDisk `json:"osDisk,omitempty"`
	// NodeAgentSKUID - The Batch node agent is a program that runs on each node in the pool, and provides the command-and-control interface between the node and the Batch service. There are different implementations of the node agent, known as SKUs, for different operating systems. You must specify a node agent SKU which matches the selected image reference. To get the list of supported node agent SKUs along with their list of verified image references, see the 'List supported node agent SKUs' operation.
	NodeAgentSKUID *string `json:"nodeAgentSKUId,omitempty"`
	// WindowsConfiguration - This property must not be specified if the imageReference or osDisk property specifies a Linux OS image.
	WindowsConfiguration *WindowsConfiguration `json:"windowsConfiguration,omitempty"`
}

// WindowsConfiguration ...
type WindowsConfiguration struct {
	// EnableAutomaticUpdates - If omitted, the default value is true.
	EnableAutomaticUpdates *bool `json:"enableAutomaticUpdates,omitempty"`
}
