package eventhub

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/eventhub/mgmt/2017-04-01/eventhub"

// AccessRights enumerates the values for access rights.
type AccessRights string

const (
	// Listen ...
	Listen AccessRights = "Listen"
	// Manage ...
	Manage AccessRights = "Manage"
	// Send ...
	Send AccessRights = "Send"
)

// PossibleAccessRightsValues returns an array of possible values for the AccessRights const type.
func PossibleAccessRightsValues() []AccessRights {
	return []AccessRights{Listen, Manage, Send}
}

// EncodingCaptureDescription enumerates the values for encoding capture description.
type EncodingCaptureDescription string

const (
	// Avro ...
	Avro EncodingCaptureDescription = "Avro"
	// AvroDeflate ...
	AvroDeflate EncodingCaptureDescription = "AvroDeflate"
)

// PossibleEncodingCaptureDescriptionValues returns an array of possible values for the EncodingCaptureDescription const type.
func PossibleEncodingCaptureDescriptionValues() []EncodingCaptureDescription {
	return []EncodingCaptureDescription{Avro, AvroDeflate}
}

// EntityStatus enumerates the values for entity status.
type EntityStatus string

const (
	// Active ...
	Active EntityStatus = "Active"
	// Creating ...
	Creating EntityStatus = "Creating"
	// Deleting ...
	Deleting EntityStatus = "Deleting"
	// Disabled ...
	Disabled EntityStatus = "Disabled"
	// ReceiveDisabled ...
	ReceiveDisabled EntityStatus = "ReceiveDisabled"
	// Renaming ...
	Renaming EntityStatus = "Renaming"
	// Restoring ...
	Restoring EntityStatus = "Restoring"
	// SendDisabled ...
	SendDisabled EntityStatus = "SendDisabled"
	// Unknown ...
	Unknown EntityStatus = "Unknown"
)

// PossibleEntityStatusValues returns an array of possible values for the EntityStatus const type.
func PossibleEntityStatusValues() []EntityStatus {
	return []EntityStatus{Active, Creating, Deleting, Disabled, ReceiveDisabled, Renaming, Restoring, SendDisabled, Unknown}
}

// KeyType enumerates the values for key type.
type KeyType string

const (
	// PrimaryKey ...
	PrimaryKey KeyType = "PrimaryKey"
	// SecondaryKey ...
	SecondaryKey KeyType = "SecondaryKey"
)

// PossibleKeyTypeValues returns an array of possible values for the KeyType const type.
func PossibleKeyTypeValues() []KeyType {
	return []KeyType{PrimaryKey, SecondaryKey}
}

// ProvisioningStateDR enumerates the values for provisioning state dr.
type ProvisioningStateDR string

const (
	// Accepted ...
	Accepted ProvisioningStateDR = "Accepted"
	// Failed ...
	Failed ProvisioningStateDR = "Failed"
	// Succeeded ...
	Succeeded ProvisioningStateDR = "Succeeded"
)

// PossibleProvisioningStateDRValues returns an array of possible values for the ProvisioningStateDR const type.
func PossibleProvisioningStateDRValues() []ProvisioningStateDR {
	return []ProvisioningStateDR{Accepted, Failed, Succeeded}
}

// RoleDisasterRecovery enumerates the values for role disaster recovery.
type RoleDisasterRecovery string

const (
	// Primary ...
	Primary RoleDisasterRecovery = "Primary"
	// PrimaryNotReplicating ...
	PrimaryNotReplicating RoleDisasterRecovery = "PrimaryNotReplicating"
	// Secondary ...
	Secondary RoleDisasterRecovery = "Secondary"
)

// PossibleRoleDisasterRecoveryValues returns an array of possible values for the RoleDisasterRecovery const type.
func PossibleRoleDisasterRecoveryValues() []RoleDisasterRecovery {
	return []RoleDisasterRecovery{Primary, PrimaryNotReplicating, Secondary}
}

// SkuName enumerates the values for sku name.
type SkuName string

const (
	// Basic ...
	Basic SkuName = "Basic"
	// Standard ...
	Standard SkuName = "Standard"
)

// PossibleSkuNameValues returns an array of possible values for the SkuName const type.
func PossibleSkuNameValues() []SkuName {
	return []SkuName{Basic, Standard}
}

// SkuTier enumerates the values for sku tier.
type SkuTier string

const (
	// SkuTierBasic ...
	SkuTierBasic SkuTier = "Basic"
	// SkuTierStandard ...
	SkuTierStandard SkuTier = "Standard"
)

// PossibleSkuTierValues returns an array of possible values for the SkuTier const type.
func PossibleSkuTierValues() []SkuTier {
	return []SkuTier{SkuTierBasic, SkuTierStandard}
}

// UnavailableReason enumerates the values for unavailable reason.
type UnavailableReason string

const (
	// InvalidName ...
	InvalidName UnavailableReason = "InvalidName"
	// NameInLockdown ...
	NameInLockdown UnavailableReason = "NameInLockdown"
	// NameInUse ...
	NameInUse UnavailableReason = "NameInUse"
	// None ...
	None UnavailableReason = "None"
	// SubscriptionIsDisabled ...
	SubscriptionIsDisabled UnavailableReason = "SubscriptionIsDisabled"
	// TooManyNamespaceInCurrentSubscription ...
	TooManyNamespaceInCurrentSubscription UnavailableReason = "TooManyNamespaceInCurrentSubscription"
)

// PossibleUnavailableReasonValues returns an array of possible values for the UnavailableReason const type.
func PossibleUnavailableReasonValues() []UnavailableReason {
	return []UnavailableReason{InvalidName, NameInLockdown, NameInUse, None, SubscriptionIsDisabled, TooManyNamespaceInCurrentSubscription}
}

// AccessKeys namespace/EventHub Connection String
type AccessKeys struct {
	autorest.Response `json:"-"`
	// PrimaryConnectionString - Primary connection string of the created namespace AuthorizationRule.
	PrimaryConnectionString *string `json:"primaryConnectionString,omitempty"`
	// SecondaryConnectionString - Secondary connection string of the created namespace AuthorizationRule.
	SecondaryConnectionString *string `json:"secondaryConnectionString,omitempty"`
	// AliasPrimaryConnectionString - Primary connection string of the alias if GEO DR is enabled
	AliasPrimaryConnectionString *string `json:"aliasPrimaryConnectionString,omitempty"`
	// AliasSecondaryConnectionString - Secondary  connection string of the alias if GEO DR is enabled
	AliasSecondaryConnectionString *string `json:"aliasSecondaryConnectionString,omitempty"`
	// PrimaryKey - A base64-encoded 256-bit primary key for signing and validating the SAS token.
	PrimaryKey *string `json:"primaryKey,omitempty"`
	// SecondaryKey - A base64-encoded 256-bit primary key for signing and validating the SAS token.
	SecondaryKey *string `json:"secondaryKey,omitempty"`
	// KeyName - A string that describes the AuthorizationRule.
	KeyName *string `json:"keyName,omitempty"`
}

// ArmDisasterRecovery single item in List or Get Alias(Disaster Recovery configuration) operation
type ArmDisasterRecovery struct {
	autorest.Response `json:"-"`
	// ArmDisasterRecoveryProperties - Properties required to the Create Or Update Alias(Disaster Recovery configurations)
	*ArmDisasterRecoveryProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ArmDisasterRecovery.
func (adr ArmDisasterRecovery) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if adr.ArmDisasterRecoveryProperties != nil {
		objectMap["properties"] = adr.ArmDisasterRecoveryProperties
	}
	if adr.ID != nil {
		objectMap["id"] = adr.ID
	}
	if adr.Name != nil {
		objectMap["name"] = adr.Name
	}
	if adr.Type != nil {
		objectMap["type"] = adr.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ArmDisasterRecovery struct.
func (adr *ArmDisasterRecovery) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var armDisasterRecoveryProperties ArmDisasterRecoveryProperties
				err = json.Unmarshal(*v, &armDisasterRecoveryProperties)
				if err != nil {
					return err
				}
				adr.ArmDisasterRecoveryProperties = &armDisasterRecoveryProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				adr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				adr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				adr.Type = &typeVar
			}
		}
	}

	return nil
}

// ArmDisasterRecoveryListResult the result of the List Alias(Disaster Recovery configuration) operation.
type ArmDisasterRecoveryListResult struct {
	autorest.Response `json:"-"`
	// Value - List of Alias(Disaster Recovery configurations)
	Value *[]ArmDisasterRecovery `json:"value,omitempty"`
	// NextLink - Link to the next set of results. Not empty if Value contains incomplete list of Alias(Disaster Recovery configuration)
	NextLink *string `json:"nextLink,omitempty"`
}

// ArmDisasterRecoveryListResultIterator provides access to a complete listing of ArmDisasterRecovery
// values.
type ArmDisasterRecoveryListResultIterator struct {
	i    int
	page ArmDisasterRecoveryListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ArmDisasterRecoveryListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ArmDisasterRecoveryListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ArmDisasterRecoveryListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ArmDisasterRecoveryListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ArmDisasterRecoveryListResultIterator) Response() ArmDisasterRecoveryListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ArmDisasterRecoveryListResultIterator) Value() ArmDisasterRecovery {
	if !iter.page.NotDone() {
		return ArmDisasterRecovery{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ArmDisasterRecoveryListResultIterator type.
func NewArmDisasterRecoveryListResultIterator(page ArmDisasterRecoveryListResultPage) ArmDisasterRecoveryListResultIterator {
	return ArmDisasterRecoveryListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (adrlr ArmDisasterRecoveryListResult) IsEmpty() bool {
	return adrlr.Value == nil || len(*adrlr.Value) == 0
}

// armDisasterRecoveryListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (adrlr ArmDisasterRecoveryListResult) armDisasterRecoveryListResultPreparer(ctx context.Context) (*http.Request, error) {
	if adrlr.NextLink == nil || len(to.String(adrlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(adrlr.NextLink)))
}

// ArmDisasterRecoveryListResultPage contains a page of ArmDisasterRecovery values.
type ArmDisasterRecoveryListResultPage struct {
	fn    func(context.Context, ArmDisasterRecoveryListResult) (ArmDisasterRecoveryListResult, error)
	adrlr ArmDisasterRecoveryListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ArmDisasterRecoveryListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ArmDisasterRecoveryListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.adrlr)
	if err != nil {
		return err
	}
	page.adrlr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ArmDisasterRecoveryListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ArmDisasterRecoveryListResultPage) NotDone() bool {
	return !page.adrlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ArmDisasterRecoveryListResultPage) Response() ArmDisasterRecoveryListResult {
	return page.adrlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ArmDisasterRecoveryListResultPage) Values() []ArmDisasterRecovery {
	if page.adrlr.IsEmpty() {
		return nil
	}
	return *page.adrlr.Value
}

// Creates a new instance of the ArmDisasterRecoveryListResultPage type.
func NewArmDisasterRecoveryListResultPage(getNextPage func(context.Context, ArmDisasterRecoveryListResult) (ArmDisasterRecoveryListResult, error)) ArmDisasterRecoveryListResultPage {
	return ArmDisasterRecoveryListResultPage{fn: getNextPage}
}

// ArmDisasterRecoveryProperties properties required to the Create Or Update Alias(Disaster Recovery
// configurations)
type ArmDisasterRecoveryProperties struct {
	// ProvisioningState - Provisioning state of the Alias(Disaster Recovery configuration) - possible values 'Accepted' or 'Succeeded' or 'Failed'. Possible values include: 'Accepted', 'Succeeded', 'Failed'
	ProvisioningState ProvisioningStateDR `json:"provisioningState,omitempty"`
	// PartnerNamespace - ARM Id of the Primary/Secondary eventhub namespace name, which is part of GEO DR pairing
	PartnerNamespace *string `json:"partnerNamespace,omitempty"`
	// AlternateName - Alternate name specified when alias and namespace names are same.
	AlternateName *string `json:"alternateName,omitempty"`
	// Role - role of namespace in GEO DR - possible values 'Primary' or 'PrimaryNotReplicating' or 'Secondary'. Possible values include: 'Primary', 'PrimaryNotReplicating', 'Secondary'
	Role RoleDisasterRecovery `json:"role,omitempty"`
	// PendingReplicationOperationsCount - Number of entities pending to be replicated.
	PendingReplicationOperationsCount *int64 `json:"pendingReplicationOperationsCount,omitempty"`
}

// AuthorizationRule single item in a List or Get AuthorizationRule operation
type AuthorizationRule struct {
	autorest.Response `json:"-"`
	// AuthorizationRuleProperties - Properties supplied to create or update AuthorizationRule
	*AuthorizationRuleProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AuthorizationRule.
func (ar AuthorizationRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ar.AuthorizationRuleProperties != nil {
		objectMap["properties"] = ar.AuthorizationRuleProperties
	}
	if ar.ID != nil {
		objectMap["id"] = ar.ID
	}
	if ar.Name != nil {
		objectMap["name"] = ar.Name
	}
	if ar.Type != nil {
		objectMap["type"] = ar.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AuthorizationRule struct.
func (ar *AuthorizationRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var authorizationRuleProperties AuthorizationRuleProperties
				err = json.Unmarshal(*v, &authorizationRuleProperties)
				if err != nil {
					return err
				}
				ar.AuthorizationRuleProperties = &authorizationRuleProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ar.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ar.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ar.Type = &typeVar
			}
		}
	}

	return nil
}

// AuthorizationRuleListResult the response from the List namespace operation.
type AuthorizationRuleListResult struct {
	autorest.Response `json:"-"`
	// Value - Result of the List Authorization Rules operation.
	Value *[]AuthorizationRule `json:"value,omitempty"`
	// NextLink - Link to the next set of results. Not empty if Value contains an incomplete list of Authorization Rules
	NextLink *string `json:"nextLink,omitempty"`
}

// AuthorizationRuleListResultIterator provides access to a complete listing of AuthorizationRule values.
type AuthorizationRuleListResultIterator struct {
	i    int
	page AuthorizationRuleListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AuthorizationRuleListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AuthorizationRuleListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AuthorizationRuleListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AuthorizationRuleListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AuthorizationRuleListResultIterator) Response() AuthorizationRuleListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AuthorizationRuleListResultIterator) Value() AuthorizationRule {
	if !iter.page.NotDone() {
		return AuthorizationRule{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AuthorizationRuleListResultIterator type.
func NewAuthorizationRuleListResultIterator(page AuthorizationRuleListResultPage) AuthorizationRuleListResultIterator {
	return AuthorizationRuleListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (arlr AuthorizationRuleListResult) IsEmpty() bool {
	return arlr.Value == nil || len(*arlr.Value) == 0
}

// authorizationRuleListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (arlr AuthorizationRuleListResult) authorizationRuleListResultPreparer(ctx context.Context) (*http.Request, error) {
	if arlr.NextLink == nil || len(to.String(arlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(arlr.NextLink)))
}

// AuthorizationRuleListResultPage contains a page of AuthorizationRule values.
type AuthorizationRuleListResultPage struct {
	fn   func(context.Context, AuthorizationRuleListResult) (AuthorizationRuleListResult, error)
	arlr AuthorizationRuleListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AuthorizationRuleListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AuthorizationRuleListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.arlr)
	if err != nil {
		return err
	}
	page.arlr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AuthorizationRuleListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AuthorizationRuleListResultPage) NotDone() bool {
	return !page.arlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AuthorizationRuleListResultPage) Response() AuthorizationRuleListResult {
	return page.arlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AuthorizationRuleListResultPage) Values() []AuthorizationRule {
	if page.arlr.IsEmpty() {
		return nil
	}
	return *page.arlr.Value
}

// Creates a new instance of the AuthorizationRuleListResultPage type.
func NewAuthorizationRuleListResultPage(getNextPage func(context.Context, AuthorizationRuleListResult) (AuthorizationRuleListResult, error)) AuthorizationRuleListResultPage {
	return AuthorizationRuleListResultPage{fn: getNextPage}
}

// AuthorizationRuleProperties properties supplied to create or update AuthorizationRule
type AuthorizationRuleProperties struct {
	// Rights - The rights associated with the rule.
	Rights *[]AccessRights `json:"rights,omitempty"`
}

// CaptureDescription properties to configure capture description for eventhub
type CaptureDescription struct {
	// Enabled - A value that indicates whether capture description is enabled.
	Enabled *bool `json:"enabled,omitempty"`
	// Encoding - Enumerates the possible values for the encoding format of capture description. Note: 'AvroDeflate' will be deprecated in New API Version. Possible values include: 'Avro', 'AvroDeflate'
	Encoding EncodingCaptureDescription `json:"encoding,omitempty"`
	// IntervalInSeconds - The time window allows you to set the frequency with which the capture to Azure Blobs will happen, value should between 60 to 900 seconds
	IntervalInSeconds *int32 `json:"intervalInSeconds,omitempty"`
	// SizeLimitInBytes - The size window defines the amount of data built up in your Event Hub before an capture operation, value should be between 10485760 to 524288000 bytes
	SizeLimitInBytes *int32 `json:"sizeLimitInBytes,omitempty"`
	// Destination - Properties of Destination where capture will be stored. (Storage Account, Blob Names)
	Destination *Destination `json:"destination,omitempty"`
}

// CheckNameAvailabilityParameter parameter supplied to check Namespace name availability operation
type CheckNameAvailabilityParameter struct {
	// Name - Name to check the namespace name availability
	Name *string `json:"name,omitempty"`
}

// CheckNameAvailabilityResult the Result of the CheckNameAvailability operation
type CheckNameAvailabilityResult struct {
	autorest.Response `json:"-"`
	// Message - The detailed info regarding the reason associated with the Namespace.
	Message *string `json:"message,omitempty"`
	// NameAvailable - Value indicating Namespace is availability, true if the Namespace is available; otherwise, false.
	NameAvailable *bool `json:"nameAvailable,omitempty"`
	// Reason - The reason for unavailability of a Namespace. Possible values include: 'None', 'InvalidName', 'SubscriptionIsDisabled', 'NameInUse', 'NameInLockdown', 'TooManyNamespaceInCurrentSubscription'
	Reason UnavailableReason `json:"reason,omitempty"`
}

// ConsumerGroup single item in List or Get Consumer group operation
type ConsumerGroup struct {
	autorest.Response `json:"-"`
	// ConsumerGroupProperties - Single item in List or Get Consumer group operation
	*ConsumerGroupProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ConsumerGroup.
func (cg ConsumerGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cg.ConsumerGroupProperties != nil {
		objectMap["properties"] = cg.ConsumerGroupProperties
	}
	if cg.ID != nil {
		objectMap["id"] = cg.ID
	}
	if cg.Name != nil {
		objectMap["name"] = cg.Name
	}
	if cg.Type != nil {
		objectMap["type"] = cg.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ConsumerGroup struct.
func (cg *ConsumerGroup) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var consumerGroupProperties ConsumerGroupProperties
				err = json.Unmarshal(*v, &consumerGroupProperties)
				if err != nil {
					return err
				}
				cg.ConsumerGroupProperties = &consumerGroupProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				cg.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cg.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cg.Type = &typeVar
			}
		}
	}

	return nil
}

// ConsumerGroupListResult the result to the List Consumer Group operation.
type ConsumerGroupListResult struct {
	autorest.Response `json:"-"`
	// Value - Result of the List Consumer Group operation.
	Value *[]ConsumerGroup `json:"value,omitempty"`
	// NextLink - Link to the next set of results. Not empty if Value contains incomplete list of Consumer Group
	NextLink *string `json:"nextLink,omitempty"`
}

// ConsumerGroupListResultIterator provides access to a complete listing of ConsumerGroup values.
type ConsumerGroupListResultIterator struct {
	i    int
	page ConsumerGroupListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ConsumerGroupListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ConsumerGroupListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ConsumerGroupListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ConsumerGroupListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ConsumerGroupListResultIterator) Response() ConsumerGroupListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ConsumerGroupListResultIterator) Value() ConsumerGroup {
	if !iter.page.NotDone() {
		return ConsumerGroup{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ConsumerGroupListResultIterator type.
func NewConsumerGroupListResultIterator(page ConsumerGroupListResultPage) ConsumerGroupListResultIterator {
	return ConsumerGroupListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (cglr ConsumerGroupListResult) IsEmpty() bool {
	return cglr.Value == nil || len(*cglr.Value) == 0
}

// consumerGroupListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (cglr ConsumerGroupListResult) consumerGroupListResultPreparer(ctx context.Context) (*http.Request, error) {
	if cglr.NextLink == nil || len(to.String(cglr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(cglr.NextLink)))
}

// ConsumerGroupListResultPage contains a page of ConsumerGroup values.
type ConsumerGroupListResultPage struct {
	fn   func(context.Context, ConsumerGroupListResult) (ConsumerGroupListResult, error)
	cglr ConsumerGroupListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ConsumerGroupListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ConsumerGroupListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.cglr)
	if err != nil {
		return err
	}
	page.cglr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ConsumerGroupListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ConsumerGroupListResultPage) NotDone() bool {
	return !page.cglr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ConsumerGroupListResultPage) Response() ConsumerGroupListResult {
	return page.cglr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ConsumerGroupListResultPage) Values() []ConsumerGroup {
	if page.cglr.IsEmpty() {
		return nil
	}
	return *page.cglr.Value
}

// Creates a new instance of the ConsumerGroupListResultPage type.
func NewConsumerGroupListResultPage(getNextPage func(context.Context, ConsumerGroupListResult) (ConsumerGroupListResult, error)) ConsumerGroupListResultPage {
	return ConsumerGroupListResultPage{fn: getNextPage}
}

// ConsumerGroupProperties single item in List or Get Consumer group operation
type ConsumerGroupProperties struct {
	// CreatedAt - Exact time the message was created.
	CreatedAt *date.Time `json:"createdAt,omitempty"`
	// UpdatedAt - The exact time the message was updated.
	UpdatedAt *date.Time `json:"updatedAt,omitempty"`
	// UserMetadata - User Metadata is a placeholder to store user-defined string data with maximum length 1024. e.g. it can be used to store descriptive data, such as list of teams and their contact information also user-defined configuration settings can be stored.
	UserMetadata *string `json:"userMetadata,omitempty"`
}

// Destination capture storage details for capture description
type Destination struct {
	// Name - Name for capture destination
	Name *string `json:"name,omitempty"`
	// DestinationProperties - Properties describing the storage account, blob container and archive name format for capture destination
	*DestinationProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for Destination.
func (d Destination) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if d.Name != nil {
		objectMap["name"] = d.Name
	}
	if d.DestinationProperties != nil {
		objectMap["properties"] = d.DestinationProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Destination struct.
func (d *Destination) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				d.Name = &name
			}
		case "properties":
			if v != nil {
				var destinationProperties DestinationProperties
				err = json.Unmarshal(*v, &destinationProperties)
				if err != nil {
					return err
				}
				d.DestinationProperties = &destinationProperties
			}
		}
	}

	return nil
}

// DestinationProperties properties describing the storage account, blob container and archive name format
// for capture destination
type DestinationProperties struct {
	// StorageAccountResourceID - Resource id of the storage account to be used to create the blobs
	StorageAccountResourceID *string `json:"storageAccountResourceId,omitempty"`
	// BlobContainer - Blob container Name
	BlobContainer *string `json:"blobContainer,omitempty"`
	// ArchiveNameFormat - Blob naming convention for archive, e.g. {Namespace}/{EventHub}/{PartitionId}/{Year}/{Month}/{Day}/{Hour}/{Minute}/{Second}. Here all the parameters (Namespace,EventHub .. etc) are mandatory irrespective of order
	ArchiveNameFormat *string `json:"archiveNameFormat,omitempty"`
}

// EHNamespace single Namespace item in List or Get Operation
type EHNamespace struct {
	autorest.Response `json:"-"`
	// Sku - Properties of sku resource
	Sku *Sku `json:"sku,omitempty"`
	// EHNamespaceProperties - Namespace properties supplied for create namespace operation.
	*EHNamespaceProperties `json:"properties,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for EHNamespace.
func (en EHNamespace) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if en.Sku != nil {
		objectMap["sku"] = en.Sku
	}
	if en.EHNamespaceProperties != nil {
		objectMap["properties"] = en.EHNamespaceProperties
	}
	if en.Location != nil {
		objectMap["location"] = en.Location
	}
	if en.Tags != nil {
		objectMap["tags"] = en.Tags
	}
	if en.ID != nil {
		objectMap["id"] = en.ID
	}
	if en.Name != nil {
		objectMap["name"] = en.Name
	}
	if en.Type != nil {
		objectMap["type"] = en.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for EHNamespace struct.
func (en *EHNamespace) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				en.Sku = &sku
			}
		case "properties":
			if v != nil {
				var eHNamespaceProperties EHNamespaceProperties
				err = json.Unmarshal(*v, &eHNamespaceProperties)
				if err != nil {
					return err
				}
				en.EHNamespaceProperties = &eHNamespaceProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				en.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				en.Tags = tags
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				en.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				en.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				en.Type = &typeVar
			}
		}
	}

	return nil
}

// EHNamespaceListResult the response of the List Namespace operation
type EHNamespaceListResult struct {
	autorest.Response `json:"-"`
	// Value - Result of the List Namespace operation
	Value *[]EHNamespace `json:"value,omitempty"`
	// NextLink - Link to the next set of results. Not empty if Value contains incomplete list of namespaces.
	NextLink *string `json:"nextLink,omitempty"`
}

// EHNamespaceListResultIterator provides access to a complete listing of EHNamespace values.
type EHNamespaceListResultIterator struct {
	i    int
	page EHNamespaceListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *EHNamespaceListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EHNamespaceListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *EHNamespaceListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter EHNamespaceListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter EHNamespaceListResultIterator) Response() EHNamespaceListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter EHNamespaceListResultIterator) Value() EHNamespace {
	if !iter.page.NotDone() {
		return EHNamespace{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the EHNamespaceListResultIterator type.
func NewEHNamespaceListResultIterator(page EHNamespaceListResultPage) EHNamespaceListResultIterator {
	return EHNamespaceListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (enlr EHNamespaceListResult) IsEmpty() bool {
	return enlr.Value == nil || len(*enlr.Value) == 0
}

// eHNamespaceListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (enlr EHNamespaceListResult) eHNamespaceListResultPreparer(ctx context.Context) (*http.Request, error) {
	if enlr.NextLink == nil || len(to.String(enlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(enlr.NextLink)))
}

// EHNamespaceListResultPage contains a page of EHNamespace values.
type EHNamespaceListResultPage struct {
	fn   func(context.Context, EHNamespaceListResult) (EHNamespaceListResult, error)
	enlr EHNamespaceListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *EHNamespaceListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EHNamespaceListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.enlr)
	if err != nil {
		return err
	}
	page.enlr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *EHNamespaceListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page EHNamespaceListResultPage) NotDone() bool {
	return !page.enlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page EHNamespaceListResultPage) Response() EHNamespaceListResult {
	return page.enlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page EHNamespaceListResultPage) Values() []EHNamespace {
	if page.enlr.IsEmpty() {
		return nil
	}
	return *page.enlr.Value
}

// Creates a new instance of the EHNamespaceListResultPage type.
func NewEHNamespaceListResultPage(getNextPage func(context.Context, EHNamespaceListResult) (EHNamespaceListResult, error)) EHNamespaceListResultPage {
	return EHNamespaceListResultPage{fn: getNextPage}
}

// EHNamespaceProperties namespace properties supplied for create namespace operation.
type EHNamespaceProperties struct {
	// ProvisioningState - Provisioning state of the Namespace.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// CreatedAt - The time the Namespace was created.
	CreatedAt *date.Time `json:"createdAt,omitempty"`
	// UpdatedAt - The time the Namespace was updated.
	UpdatedAt *date.Time `json:"updatedAt,omitempty"`
	// ServiceBusEndpoint - Endpoint you can use to perform Service Bus operations.
	ServiceBusEndpoint *string `json:"serviceBusEndpoint,omitempty"`
	// MetricID - Identifier for Azure Insights metrics.
	MetricID *string `json:"metricId,omitempty"`
	// IsAutoInflateEnabled - Value that indicates whether AutoInflate is enabled for eventhub namespace.
	IsAutoInflateEnabled *bool `json:"isAutoInflateEnabled,omitempty"`
	// MaximumThroughputUnits - Upper limit of throughput units when AutoInflate is enabled, value should be within 0 to 20 throughput units. ( '0' if AutoInflateEnabled = true)
	MaximumThroughputUnits *int32 `json:"maximumThroughputUnits,omitempty"`
	// KafkaEnabled - Value that indicates whether Kafka is enabled for eventhub namespace.
	KafkaEnabled *bool `json:"kafkaEnabled,omitempty"`
}

// ErrorResponse error response indicates EventHub service is not able to process the incoming request. The
// reason is provided in the error message.
type ErrorResponse struct {
	// Code - Error code.
	Code *string `json:"code,omitempty"`
	// Message - Error message indicating why the operation failed.
	Message *string `json:"message,omitempty"`
}

// ListResult the result of the List EventHubs operation.
type ListResult struct {
	autorest.Response `json:"-"`
	// Value - Result of the List EventHubs operation.
	Value *[]Model `json:"value,omitempty"`
	// NextLink - Link to the next set of results. Not empty if Value contains incomplete list of EventHubs.
	NextLink *string `json:"nextLink,omitempty"`
}

// ListResultIterator provides access to a complete listing of Model values.
type ListResultIterator struct {
	i    int
	page ListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ListResultIterator) Response() ListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ListResultIterator) Value() Model {
	if !iter.page.NotDone() {
		return Model{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ListResultIterator type.
func NewListResultIterator(page ListResultPage) ListResultIterator {
	return ListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (lr ListResult) IsEmpty() bool {
	return lr.Value == nil || len(*lr.Value) == 0
}

// listResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lr ListResult) listResultPreparer(ctx context.Context) (*http.Request, error) {
	if lr.NextLink == nil || len(to.String(lr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lr.NextLink)))
}

// ListResultPage contains a page of Model values.
type ListResultPage struct {
	fn func(context.Context, ListResult) (ListResult, error)
	lr ListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.lr)
	if err != nil {
		return err
	}
	page.lr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ListResultPage) NotDone() bool {
	return !page.lr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ListResultPage) Response() ListResult {
	return page.lr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ListResultPage) Values() []Model {
	if page.lr.IsEmpty() {
		return nil
	}
	return *page.lr.Value
}

// Creates a new instance of the ListResultPage type.
func NewListResultPage(getNextPage func(context.Context, ListResult) (ListResult, error)) ListResultPage {
	return ListResultPage{fn: getNextPage}
}

// MessagingPlan messaging Plan for the namespace
type MessagingPlan struct {
	autorest.Response        `json:"-"`
	*MessagingPlanProperties `json:"properties,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for MessagingPlan.
func (mp MessagingPlan) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mp.MessagingPlanProperties != nil {
		objectMap["properties"] = mp.MessagingPlanProperties
	}
	if mp.Location != nil {
		objectMap["location"] = mp.Location
	}
	if mp.Tags != nil {
		objectMap["tags"] = mp.Tags
	}
	if mp.ID != nil {
		objectMap["id"] = mp.ID
	}
	if mp.Name != nil {
		objectMap["name"] = mp.Name
	}
	if mp.Type != nil {
		objectMap["type"] = mp.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for MessagingPlan struct.
func (mp *MessagingPlan) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var messagingPlanProperties MessagingPlanProperties
				err = json.Unmarshal(*v, &messagingPlanProperties)
				if err != nil {
					return err
				}
				mp.MessagingPlanProperties = &messagingPlanProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				mp.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				mp.Tags = tags
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mp.Type = &typeVar
			}
		}
	}

	return nil
}

// MessagingPlanProperties ...
type MessagingPlanProperties struct {
	// Sku - Sku type
	Sku *int32 `json:"sku,omitempty"`
	// SelectedEventHubUnit - Selected event hub unit
	SelectedEventHubUnit *int32 `json:"selectedEventHubUnit,omitempty"`
	// UpdatedAt - The exact time the messaging plan was updated.
	UpdatedAt *date.Time `json:"updatedAt,omitempty"`
	// Revision - revision number
	Revision *int64 `json:"revision,omitempty"`
}

// MessagingRegions messaging Region
type MessagingRegions struct {
	Properties *MessagingRegionsProperties `json:"properties,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for MessagingRegions.
func (mr MessagingRegions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mr.Properties != nil {
		objectMap["properties"] = mr.Properties
	}
	if mr.Location != nil {
		objectMap["location"] = mr.Location
	}
	if mr.Tags != nil {
		objectMap["tags"] = mr.Tags
	}
	if mr.ID != nil {
		objectMap["id"] = mr.ID
	}
	if mr.Name != nil {
		objectMap["name"] = mr.Name
	}
	if mr.Type != nil {
		objectMap["type"] = mr.Type
	}
	return json.Marshal(objectMap)
}

// MessagingRegionsListResult the response of the List MessagingRegions operation.
type MessagingRegionsListResult struct {
	autorest.Response `json:"-"`
	// Value - Result of the List MessagingRegions type.
	Value *[]MessagingRegions `json:"value,omitempty"`
	// NextLink - Link to the next set of results. Not empty if Value contains incomplete list of MessagingRegions.
	NextLink *string `json:"nextLink,omitempty"`
}

// MessagingRegionsListResultIterator provides access to a complete listing of MessagingRegions values.
type MessagingRegionsListResultIterator struct {
	i    int
	page MessagingRegionsListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *MessagingRegionsListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MessagingRegionsListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *MessagingRegionsListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter MessagingRegionsListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter MessagingRegionsListResultIterator) Response() MessagingRegionsListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter MessagingRegionsListResultIterator) Value() MessagingRegions {
	if !iter.page.NotDone() {
		return MessagingRegions{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the MessagingRegionsListResultIterator type.
func NewMessagingRegionsListResultIterator(page MessagingRegionsListResultPage) MessagingRegionsListResultIterator {
	return MessagingRegionsListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (mrlr MessagingRegionsListResult) IsEmpty() bool {
	return mrlr.Value == nil || len(*mrlr.Value) == 0
}

// messagingRegionsListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (mrlr MessagingRegionsListResult) messagingRegionsListResultPreparer(ctx context.Context) (*http.Request, error) {
	if mrlr.NextLink == nil || len(to.String(mrlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(mrlr.NextLink)))
}

// MessagingRegionsListResultPage contains a page of MessagingRegions values.
type MessagingRegionsListResultPage struct {
	fn   func(context.Context, MessagingRegionsListResult) (MessagingRegionsListResult, error)
	mrlr MessagingRegionsListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *MessagingRegionsListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MessagingRegionsListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.mrlr)
	if err != nil {
		return err
	}
	page.mrlr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *MessagingRegionsListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page MessagingRegionsListResultPage) NotDone() bool {
	return !page.mrlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page MessagingRegionsListResultPage) Response() MessagingRegionsListResult {
	return page.mrlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page MessagingRegionsListResultPage) Values() []MessagingRegions {
	if page.mrlr.IsEmpty() {
		return nil
	}
	return *page.mrlr.Value
}

// Creates a new instance of the MessagingRegionsListResultPage type.
func NewMessagingRegionsListResultPage(getNextPage func(context.Context, MessagingRegionsListResult) (MessagingRegionsListResult, error)) MessagingRegionsListResultPage {
	return MessagingRegionsListResultPage{fn: getNextPage}
}

// MessagingRegionsProperties ...
type MessagingRegionsProperties struct {
	// Code - Region code
	Code *string `json:"code,omitempty"`
	// FullName - Full name of the region
	FullName *string `json:"fullName,omitempty"`
}

// Model single item in List or Get Event Hub operation
type Model struct {
	autorest.Response `json:"-"`
	// Properties - Properties supplied to the Create Or Update Event Hub operation.
	*Properties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Model.
func (mVar Model) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mVar.Properties != nil {
		objectMap["properties"] = mVar.Properties
	}
	if mVar.ID != nil {
		objectMap["id"] = mVar.ID
	}
	if mVar.Name != nil {
		objectMap["name"] = mVar.Name
	}
	if mVar.Type != nil {
		objectMap["type"] = mVar.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Model struct.
func (mVar *Model) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var properties Properties
				err = json.Unmarshal(*v, &properties)
				if err != nil {
					return err
				}
				mVar.Properties = &properties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mVar.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mVar.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mVar.Type = &typeVar
			}
		}
	}

	return nil
}

// NamespacesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type NamespacesCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *NamespacesCreateOrUpdateFuture) Result(client NamespacesClient) (en EHNamespace, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "eventhub.NamespacesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("eventhub.NamespacesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if en.Response.Response, err = future.GetResult(sender); err == nil && en.Response.Response.StatusCode != http.StatusNoContent {
		en, err = client.CreateOrUpdateResponder(en.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "eventhub.NamespacesCreateOrUpdateFuture", "Result", en.Response.Response, "Failure responding to request")
		}
	}
	return
}

// NamespacesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type NamespacesDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *NamespacesDeleteFuture) Result(client NamespacesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "eventhub.NamespacesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("eventhub.NamespacesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// Operation a Event Hub REST API operation
type Operation struct {
	// Name - Operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`
	// Display - The object that represents the operation.
	Display *OperationDisplay `json:"display,omitempty"`
}

// OperationDisplay the object that represents the operation.
type OperationDisplay struct {
	// Provider - Service provider: Microsoft.EventHub
	Provider *string `json:"provider,omitempty"`
	// Resource - Resource on which the operation is performed: Invoice, etc.
	Resource *string `json:"resource,omitempty"`
	// Operation - Operation type: Read, write, delete, etc.
	Operation *string `json:"operation,omitempty"`
}

// OperationListResult result of the request to list Event Hub operations. It contains a list of operations
// and a URL link to get the next set of results.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - List of Event Hub operations supported by the Microsoft.EventHub resource provider.
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationListResultIterator provides access to a complete listing of Operation values.
type OperationListResultIterator struct {
	i    int
	page OperationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListResultIterator) Response() OperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListResultIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListResultIterator type.
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return OperationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OperationListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// operationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationListResult) operationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if olr.NextLink == nil || len(to.String(olr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OperationListResultPage contains a page of Operation values.
type OperationListResultPage struct {
	fn  func(context.Context, OperationListResult) (OperationListResult, error)
	olr OperationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.olr)
	if err != nil {
		return err
	}
	page.olr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListResultPage) Response() OperationListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListResultPage) Values() []Operation {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// Creates a new instance of the OperationListResultPage type.
func NewOperationListResultPage(getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return OperationListResultPage{fn: getNextPage}
}

// Properties properties supplied to the Create Or Update Event Hub operation.
type Properties struct {
	// PartitionIds - Current number of shards on the Event Hub.
	PartitionIds *[]string `json:"partitionIds,omitempty"`
	// CreatedAt - Exact time the Event Hub was created.
	CreatedAt *date.Time `json:"createdAt,omitempty"`
	// UpdatedAt - The exact time the message was updated.
	UpdatedAt *date.Time `json:"updatedAt,omitempty"`
	// MessageRetentionInDays - Number of days to retain the events for this Event Hub, value should be 1 to 7 days
	MessageRetentionInDays *int64 `json:"messageRetentionInDays,omitempty"`
	// PartitionCount - Number of partitions created for the Event Hub, allowed values are from 1 to 32 partitions.
	PartitionCount *int64 `json:"partitionCount,omitempty"`
	// Status - Enumerates the possible values for the status of the Event Hub. Possible values include: 'Active', 'Disabled', 'Restoring', 'SendDisabled', 'ReceiveDisabled', 'Creating', 'Deleting', 'Renaming', 'Unknown'
	Status EntityStatus `json:"status,omitempty"`
	// CaptureDescription - Properties of capture description
	CaptureDescription *CaptureDescription `json:"captureDescription,omitempty"`
}

// RegenerateAccessKeyParameters parameters supplied to the Regenerate Authorization Rule operation,
// specifies which key needs to be reset.
type RegenerateAccessKeyParameters struct {
	// KeyType - The access key to regenerate. Possible values include: 'PrimaryKey', 'SecondaryKey'
	KeyType KeyType `json:"keyType,omitempty"`
	// Key - Optional, if the key value provided, is set for KeyType or autogenerated Key value set for keyType
	Key *string `json:"key,omitempty"`
}

// Resource the Resource definition
type Resource struct {
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
}

// Sku SKU parameters supplied to the create namespace operation
type Sku struct {
	// Name - Name of this SKU. Possible values include: 'Basic', 'Standard'
	Name SkuName `json:"name,omitempty"`
	// Tier - The billing tier of this particular SKU. Possible values include: 'SkuTierBasic', 'SkuTierStandard'
	Tier SkuTier `json:"tier,omitempty"`
	// Capacity - The Event Hubs throughput units, value should be 0 to 20 throughput units.
	Capacity *int32 `json:"capacity,omitempty"`
}

// TrackedResource definition of Resource
type TrackedResource struct {
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TrackedResource.
func (tr TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Location != nil {
		objectMap["location"] = tr.Location
	}
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	if tr.ID != nil {
		objectMap["id"] = tr.ID
	}
	if tr.Name != nil {
		objectMap["name"] = tr.Name
	}
	if tr.Type != nil {
		objectMap["type"] = tr.Type
	}
	return json.Marshal(objectMap)
}
