package webapi

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/web/mgmt/2018-02-01/web"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
)

// BaseClientAPI contains the set of methods on the BaseClient type.
type BaseClientAPI interface {
	CheckNameAvailability(ctx context.Context, request web.ResourceNameAvailabilityRequest) (result web.ResourceNameAvailability, err error)
	GetPublishingUser(ctx context.Context) (result web.User, err error)
	GetSourceControl(ctx context.Context, sourceControlType string) (result web.SourceControl, err error)
	GetSubscriptionDeploymentLocations(ctx context.Context) (result web.DeploymentLocations, err error)
	ListBillingMeters(ctx context.Context, billingLocation string, osType string) (result web.BillingMeterCollectionPage, err error)
	ListGeoRegions(ctx context.Context, sku web.SkuName, linuxWorkersEnabled *bool, xenonWorkersEnabled *bool, linuxDynamicWorkersEnabled *bool) (result web.GeoRegionCollectionPage, err error)
	ListPremierAddOnOffers(ctx context.Context) (result web.PremierAddOnOfferCollectionPage, err error)
	ListSiteIdentifiersAssignedToHostName(ctx context.Context, nameIdentifier web.NameIdentifier) (result web.IdentifierCollectionPage, err error)
	ListSkus(ctx context.Context) (result web.SkuInfos, err error)
	ListSourceControls(ctx context.Context) (result web.SourceControlCollectionPage, err error)
	Move(ctx context.Context, resourceGroupName string, moveResourceEnvelope web.CsmMoveResourceEnvelope) (result autorest.Response, err error)
	UpdatePublishingUser(ctx context.Context, userDetails web.User) (result web.User, err error)
	UpdateSourceControl(ctx context.Context, sourceControlType string, requestMessage web.SourceControl) (result web.SourceControl, err error)
	Validate(ctx context.Context, resourceGroupName string, validateRequest web.ValidateRequest) (result web.ValidateResponse, err error)
	ValidateMove(ctx context.Context, resourceGroupName string, moveResourceEnvelope web.CsmMoveResourceEnvelope) (result autorest.Response, err error)
	VerifyHostingEnvironmentVnet(ctx context.Context, parameters web.VnetParameters) (result web.VnetValidationFailureDetails, err error)
}

var _ BaseClientAPI = (*web.BaseClient)(nil)

// AppServiceCertificateOrdersClientAPI contains the set of methods on the AppServiceCertificateOrdersClient type.
type AppServiceCertificateOrdersClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, certificateOrderName string, certificateDistinguishedName web.AppServiceCertificateOrder) (result web.AppServiceCertificateOrdersCreateOrUpdateFuture, err error)
	CreateOrUpdateCertificate(ctx context.Context, resourceGroupName string, certificateOrderName string, name string, keyVaultCertificate web.AppServiceCertificateResource) (result web.AppServiceCertificateOrdersCreateOrUpdateCertificateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, certificateOrderName string) (result autorest.Response, err error)
	DeleteCertificate(ctx context.Context, resourceGroupName string, certificateOrderName string, name string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, certificateOrderName string) (result web.AppServiceCertificateOrder, err error)
	GetCertificate(ctx context.Context, resourceGroupName string, certificateOrderName string, name string) (result web.AppServiceCertificateResource, err error)
	List(ctx context.Context) (result web.AppServiceCertificateOrderCollectionPage, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string) (result web.AppServiceCertificateOrderCollectionPage, err error)
	ListCertificates(ctx context.Context, resourceGroupName string, certificateOrderName string) (result web.AppServiceCertificateCollectionPage, err error)
	Reissue(ctx context.Context, resourceGroupName string, certificateOrderName string, reissueCertificateOrderRequest web.ReissueCertificateOrderRequest) (result autorest.Response, err error)
	Renew(ctx context.Context, resourceGroupName string, certificateOrderName string, renewCertificateOrderRequest web.RenewCertificateOrderRequest) (result autorest.Response, err error)
	ResendEmail(ctx context.Context, resourceGroupName string, certificateOrderName string) (result autorest.Response, err error)
	ResendRequestEmails(ctx context.Context, resourceGroupName string, certificateOrderName string, nameIdentifier web.NameIdentifier) (result autorest.Response, err error)
	RetrieveCertificateActions(ctx context.Context, resourceGroupName string, name string) (result web.ListCertificateOrderAction, err error)
	RetrieveCertificateEmailHistory(ctx context.Context, resourceGroupName string, name string) (result web.ListCertificateEmail, err error)
	RetrieveSiteSeal(ctx context.Context, resourceGroupName string, certificateOrderName string, siteSealRequest web.SiteSealRequest) (result web.SiteSeal, err error)
	Update(ctx context.Context, resourceGroupName string, certificateOrderName string, certificateDistinguishedName web.AppServiceCertificateOrderPatchResource) (result web.AppServiceCertificateOrder, err error)
	UpdateCertificate(ctx context.Context, resourceGroupName string, certificateOrderName string, name string, keyVaultCertificate web.AppServiceCertificatePatchResource) (result web.AppServiceCertificateResource, err error)
	ValidatePurchaseInformation(ctx context.Context, appServiceCertificateOrder web.AppServiceCertificateOrder) (result autorest.Response, err error)
	VerifyDomainOwnership(ctx context.Context, resourceGroupName string, certificateOrderName string) (result autorest.Response, err error)
}

var _ AppServiceCertificateOrdersClientAPI = (*web.AppServiceCertificateOrdersClient)(nil)

// CertificateRegistrationProviderClientAPI contains the set of methods on the CertificateRegistrationProviderClient type.
type CertificateRegistrationProviderClientAPI interface {
	ListOperations(ctx context.Context) (result web.CsmOperationCollectionPage, err error)
}

var _ CertificateRegistrationProviderClientAPI = (*web.CertificateRegistrationProviderClient)(nil)

// DomainsClientAPI contains the set of methods on the DomainsClient type.
type DomainsClientAPI interface {
	CheckAvailability(ctx context.Context, identifier web.NameIdentifier) (result web.DomainAvailablilityCheckResult, err error)
	CreateOrUpdate(ctx context.Context, resourceGroupName string, domainName string, domain web.Domain) (result web.DomainsCreateOrUpdateFuture, err error)
	CreateOrUpdateOwnershipIdentifier(ctx context.Context, resourceGroupName string, domainName string, name string, domainOwnershipIdentifier web.DomainOwnershipIdentifier) (result web.DomainOwnershipIdentifier, err error)
	Delete(ctx context.Context, resourceGroupName string, domainName string, forceHardDeleteDomain *bool) (result autorest.Response, err error)
	DeleteOwnershipIdentifier(ctx context.Context, resourceGroupName string, domainName string, name string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, domainName string) (result web.Domain, err error)
	GetControlCenterSsoRequest(ctx context.Context) (result web.DomainControlCenterSsoRequest, err error)
	GetOwnershipIdentifier(ctx context.Context, resourceGroupName string, domainName string, name string) (result web.DomainOwnershipIdentifier, err error)
	List(ctx context.Context) (result web.DomainCollectionPage, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string) (result web.DomainCollectionPage, err error)
	ListOwnershipIdentifiers(ctx context.Context, resourceGroupName string, domainName string) (result web.DomainOwnershipIdentifierCollectionPage, err error)
	ListRecommendations(ctx context.Context, parameters web.DomainRecommendationSearchParameters) (result web.NameIdentifierCollectionPage, err error)
	Renew(ctx context.Context, resourceGroupName string, domainName string) (result autorest.Response, err error)
	Update(ctx context.Context, resourceGroupName string, domainName string, domain web.DomainPatchResource) (result web.Domain, err error)
	UpdateOwnershipIdentifier(ctx context.Context, resourceGroupName string, domainName string, name string, domainOwnershipIdentifier web.DomainOwnershipIdentifier) (result web.DomainOwnershipIdentifier, err error)
}

var _ DomainsClientAPI = (*web.DomainsClient)(nil)

// TopLevelDomainsClientAPI contains the set of methods on the TopLevelDomainsClient type.
type TopLevelDomainsClientAPI interface {
	Get(ctx context.Context, name string) (result web.TopLevelDomain, err error)
	List(ctx context.Context) (result web.TopLevelDomainCollectionPage, err error)
	ListAgreements(ctx context.Context, name string, agreementOption web.TopLevelDomainAgreementOption) (result web.TldLegalAgreementCollectionPage, err error)
}

var _ TopLevelDomainsClientAPI = (*web.TopLevelDomainsClient)(nil)

// DomainRegistrationProviderClientAPI contains the set of methods on the DomainRegistrationProviderClient type.
type DomainRegistrationProviderClientAPI interface {
	ListOperations(ctx context.Context) (result web.CsmOperationCollectionPage, err error)
}

var _ DomainRegistrationProviderClientAPI = (*web.DomainRegistrationProviderClient)(nil)

// CertificatesClientAPI contains the set of methods on the CertificatesClient type.
type CertificatesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, name string, certificateEnvelope web.Certificate) (result web.Certificate, err error)
	Delete(ctx context.Context, resourceGroupName string, name string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, name string) (result web.Certificate, err error)
	List(ctx context.Context) (result web.CertificateCollectionPage, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string) (result web.CertificateCollectionPage, err error)
	Update(ctx context.Context, resourceGroupName string, name string, certificateEnvelope web.CertificatePatchResource) (result web.Certificate, err error)
}

var _ CertificatesClientAPI = (*web.CertificatesClient)(nil)

// DeletedWebAppsClientAPI contains the set of methods on the DeletedWebAppsClient type.
type DeletedWebAppsClientAPI interface {
	List(ctx context.Context) (result web.DeletedWebAppCollectionPage, err error)
}

var _ DeletedWebAppsClientAPI = (*web.DeletedWebAppsClient)(nil)

// DiagnosticsClientAPI contains the set of methods on the DiagnosticsClient type.
type DiagnosticsClientAPI interface {
	ExecuteSiteAnalysis(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string, analysisName string, startTime *date.Time, endTime *date.Time, timeGrain string) (result web.DiagnosticAnalysis, err error)
	ExecuteSiteAnalysisSlot(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string, analysisName string, slot string, startTime *date.Time, endTime *date.Time, timeGrain string) (result web.DiagnosticAnalysis, err error)
	ExecuteSiteDetector(ctx context.Context, resourceGroupName string, siteName string, detectorName string, diagnosticCategory string, startTime *date.Time, endTime *date.Time, timeGrain string) (result web.DiagnosticDetectorResponse, err error)
	ExecuteSiteDetectorSlot(ctx context.Context, resourceGroupName string, siteName string, detectorName string, diagnosticCategory string, slot string, startTime *date.Time, endTime *date.Time, timeGrain string) (result web.DiagnosticDetectorResponse, err error)
	GetHostingEnvironmentDetectorResponse(ctx context.Context, resourceGroupName string, name string, detectorName string, startTime *date.Time, endTime *date.Time, timeGrain string) (result web.DetectorResponse, err error)
	GetSiteAnalysis(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string, analysisName string) (result web.DiagnosticAnalysis, err error)
	GetSiteAnalysisSlot(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string, analysisName string, slot string) (result web.DiagnosticAnalysis, err error)
	GetSiteDetector(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string, detectorName string) (result web.DiagnosticDetectorCollectionPage, err error)
	GetSiteDetectorResponse(ctx context.Context, resourceGroupName string, siteName string, detectorName string, startTime *date.Time, endTime *date.Time, timeGrain string) (result web.DetectorResponse, err error)
	GetSiteDetectorResponseSlot(ctx context.Context, resourceGroupName string, siteName string, detectorName string, slot string, startTime *date.Time, endTime *date.Time, timeGrain string) (result web.DetectorResponse, err error)
	GetSiteDetectorSlot(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string, detectorName string, slot string) (result web.DiagnosticDetectorCollectionPage, err error)
	GetSiteDiagnosticCategory(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string) (result web.DiagnosticCategory, err error)
	GetSiteDiagnosticCategorySlot(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string, slot string) (result web.DiagnosticCategory, err error)
	ListHostingEnvironmentDetectorResponses(ctx context.Context, resourceGroupName string, name string) (result web.DetectorResponseCollectionPage, err error)
	ListSiteAnalyses(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string) (result web.DiagnosticAnalysisCollectionPage, err error)
	ListSiteAnalysesSlot(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string, slot string) (result web.DiagnosticAnalysisCollectionPage, err error)
	ListSiteDetectorResponses(ctx context.Context, resourceGroupName string, siteName string) (result web.DetectorResponseCollectionPage, err error)
	ListSiteDetectorResponsesSlot(ctx context.Context, resourceGroupName string, siteName string, slot string) (result web.DetectorResponseCollectionPage, err error)
	ListSiteDetectors(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string) (result web.DiagnosticDetectorCollectionPage, err error)
	ListSiteDetectorsSlot(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string, slot string) (result web.DiagnosticDetectorCollectionPage, err error)
	ListSiteDiagnosticCategories(ctx context.Context, resourceGroupName string, siteName string) (result web.DiagnosticCategoryCollectionPage, err error)
	ListSiteDiagnosticCategoriesSlot(ctx context.Context, resourceGroupName string, siteName string, slot string) (result web.DiagnosticCategoryCollectionPage, err error)
}

var _ DiagnosticsClientAPI = (*web.DiagnosticsClient)(nil)

// ProviderClientAPI contains the set of methods on the ProviderClient type.
type ProviderClientAPI interface {
	GetAvailableStacks(ctx context.Context, osTypeSelected string) (result web.ApplicationStackCollectionPage, err error)
	GetAvailableStacksOnPrem(ctx context.Context, osTypeSelected string) (result web.ApplicationStackCollectionPage, err error)
	ListOperations(ctx context.Context) (result web.CsmOperationCollectionPage, err error)
}

var _ ProviderClientAPI = (*web.ProviderClient)(nil)

// RecommendationsClientAPI contains the set of methods on the RecommendationsClient type.
type RecommendationsClientAPI interface {
	DisableAllForWebApp(ctx context.Context, resourceGroupName string, siteName string) (result autorest.Response, err error)
	DisableRecommendationForSite(ctx context.Context, resourceGroupName string, siteName string, name string) (result autorest.Response, err error)
	DisableRecommendationForSubscription(ctx context.Context, name string) (result autorest.Response, err error)
	GetRuleDetailsByWebApp(ctx context.Context, resourceGroupName string, siteName string, name string, updateSeen *bool, recommendationID string) (result web.RecommendationRule, err error)
	List(ctx context.Context, featured *bool, filter string) (result web.RecommendationCollectionPage, err error)
	ListHistoryForWebApp(ctx context.Context, resourceGroupName string, siteName string, expiredOnly *bool, filter string) (result web.RecommendationCollectionPage, err error)
	ListRecommendedRulesForWebApp(ctx context.Context, resourceGroupName string, siteName string, featured *bool, filter string) (result web.RecommendationCollectionPage, err error)
	ResetAllFilters(ctx context.Context) (result autorest.Response, err error)
	ResetAllFiltersForWebApp(ctx context.Context, resourceGroupName string, siteName string) (result autorest.Response, err error)
}

var _ RecommendationsClientAPI = (*web.RecommendationsClient)(nil)

// AppsClientAPI contains the set of methods on the AppsClient type.
type AppsClientAPI interface {
	AddPremierAddOn(ctx context.Context, resourceGroupName string, name string, premierAddOnName string, premierAddOn web.PremierAddOn) (result web.PremierAddOn, err error)
	AddPremierAddOnSlot(ctx context.Context, resourceGroupName string, name string, premierAddOnName string, premierAddOn web.PremierAddOn, slot string) (result web.PremierAddOn, err error)
	AnalyzeCustomHostname(ctx context.Context, resourceGroupName string, name string, hostName string) (result web.CustomHostnameAnalysisResult, err error)
	AnalyzeCustomHostnameSlot(ctx context.Context, resourceGroupName string, name string, slot string, hostName string) (result web.CustomHostnameAnalysisResult, err error)
	ApplySlotConfigToProduction(ctx context.Context, resourceGroupName string, name string, slotSwapEntity web.CsmSlotEntity) (result autorest.Response, err error)
	ApplySlotConfigurationSlot(ctx context.Context, resourceGroupName string, name string, slotSwapEntity web.CsmSlotEntity, slot string) (result autorest.Response, err error)
	Backup(ctx context.Context, resourceGroupName string, name string, request web.BackupRequest) (result web.BackupItem, err error)
	BackupSlot(ctx context.Context, resourceGroupName string, name string, request web.BackupRequest, slot string) (result web.BackupItem, err error)
	CreateDeployment(ctx context.Context, resourceGroupName string, name string, ID string, deployment web.Deployment) (result web.Deployment, err error)
	CreateDeploymentSlot(ctx context.Context, resourceGroupName string, name string, ID string, slot string, deployment web.Deployment) (result web.Deployment, err error)
	CreateFunction(ctx context.Context, resourceGroupName string, name string, functionName string, functionEnvelope web.FunctionEnvelope) (result web.AppsCreateFunctionFuture, err error)
	CreateInstanceFunctionSlot(ctx context.Context, resourceGroupName string, name string, functionName string, slot string, functionEnvelope web.FunctionEnvelope) (result web.AppsCreateInstanceFunctionSlotFuture, err error)
	CreateInstanceMSDeployOperation(ctx context.Context, resourceGroupName string, name string, instanceID string, mSDeploy web.MSDeploy) (result web.AppsCreateInstanceMSDeployOperationFuture, err error)
	CreateInstanceMSDeployOperationSlot(ctx context.Context, resourceGroupName string, name string, slot string, instanceID string, mSDeploy web.MSDeploy) (result web.AppsCreateInstanceMSDeployOperationSlotFuture, err error)
	CreateMSDeployOperation(ctx context.Context, resourceGroupName string, name string, mSDeploy web.MSDeploy) (result web.AppsCreateMSDeployOperationFuture, err error)
	CreateMSDeployOperationSlot(ctx context.Context, resourceGroupName string, name string, slot string, mSDeploy web.MSDeploy) (result web.AppsCreateMSDeployOperationSlotFuture, err error)
	CreateOrUpdate(ctx context.Context, resourceGroupName string, name string, siteEnvelope web.Site) (result web.AppsCreateOrUpdateFuture, err error)
	CreateOrUpdateConfiguration(ctx context.Context, resourceGroupName string, name string, siteConfig web.SiteConfigResource) (result web.SiteConfigResource, err error)
	CreateOrUpdateConfigurationSlot(ctx context.Context, resourceGroupName string, name string, siteConfig web.SiteConfigResource, slot string) (result web.SiteConfigResource, err error)
	CreateOrUpdateDomainOwnershipIdentifier(ctx context.Context, resourceGroupName string, name string, domainOwnershipIdentifierName string, domainOwnershipIdentifier web.Identifier) (result web.Identifier, err error)
	CreateOrUpdateDomainOwnershipIdentifierSlot(ctx context.Context, resourceGroupName string, name string, domainOwnershipIdentifierName string, domainOwnershipIdentifier web.Identifier, slot string) (result web.Identifier, err error)
	CreateOrUpdateHostNameBinding(ctx context.Context, resourceGroupName string, name string, hostName string, hostNameBinding web.HostNameBinding) (result web.HostNameBinding, err error)
	CreateOrUpdateHostNameBindingSlot(ctx context.Context, resourceGroupName string, name string, hostName string, hostNameBinding web.HostNameBinding, slot string) (result web.HostNameBinding, err error)
	CreateOrUpdateHybridConnection(ctx context.Context, resourceGroupName string, name string, namespaceName string, relayName string, connectionEnvelope web.HybridConnection) (result web.HybridConnection, err error)
	CreateOrUpdateHybridConnectionSlot(ctx context.Context, resourceGroupName string, name string, namespaceName string, relayName string, connectionEnvelope web.HybridConnection, slot string) (result web.HybridConnection, err error)
	CreateOrUpdatePublicCertificate(ctx context.Context, resourceGroupName string, name string, publicCertificateName string, publicCertificate web.PublicCertificate) (result web.PublicCertificate, err error)
	CreateOrUpdatePublicCertificateSlot(ctx context.Context, resourceGroupName string, name string, publicCertificateName string, publicCertificate web.PublicCertificate, slot string) (result web.PublicCertificate, err error)
	CreateOrUpdateRelayServiceConnection(ctx context.Context, resourceGroupName string, name string, entityName string, connectionEnvelope web.RelayServiceConnectionEntity) (result web.RelayServiceConnectionEntity, err error)
	CreateOrUpdateRelayServiceConnectionSlot(ctx context.Context, resourceGroupName string, name string, entityName string, connectionEnvelope web.RelayServiceConnectionEntity, slot string) (result web.RelayServiceConnectionEntity, err error)
	CreateOrUpdateSlot(ctx context.Context, resourceGroupName string, name string, siteEnvelope web.Site, slot string) (result web.AppsCreateOrUpdateSlotFuture, err error)
	CreateOrUpdateSourceControl(ctx context.Context, resourceGroupName string, name string, siteSourceControl web.SiteSourceControl) (result web.AppsCreateOrUpdateSourceControlFuture, err error)
	CreateOrUpdateSourceControlSlot(ctx context.Context, resourceGroupName string, name string, siteSourceControl web.SiteSourceControl, slot string) (result web.AppsCreateOrUpdateSourceControlSlotFuture, err error)
	CreateOrUpdateSwiftVirtualNetworkConnection(ctx context.Context, resourceGroupName string, name string, connectionEnvelope web.SwiftVirtualNetwork) (result web.SwiftVirtualNetwork, err error)
	CreateOrUpdateSwiftVirtualNetworkConnectionSlot(ctx context.Context, resourceGroupName string, name string, connectionEnvelope web.SwiftVirtualNetwork, slot string) (result web.SwiftVirtualNetwork, err error)
	CreateOrUpdateVnetConnection(ctx context.Context, resourceGroupName string, name string, vnetName string, connectionEnvelope web.VnetInfo) (result web.VnetInfo, err error)
	CreateOrUpdateVnetConnectionGateway(ctx context.Context, resourceGroupName string, name string, vnetName string, gatewayName string, connectionEnvelope web.VnetGateway) (result web.VnetGateway, err error)
	CreateOrUpdateVnetConnectionGatewaySlot(ctx context.Context, resourceGroupName string, name string, vnetName string, gatewayName string, connectionEnvelope web.VnetGateway, slot string) (result web.VnetGateway, err error)
	CreateOrUpdateVnetConnectionSlot(ctx context.Context, resourceGroupName string, name string, vnetName string, connectionEnvelope web.VnetInfo, slot string) (result web.VnetInfo, err error)
	Delete(ctx context.Context, resourceGroupName string, name string, deleteMetrics *bool, deleteEmptyServerFarm *bool) (result autorest.Response, err error)
	DeleteBackup(ctx context.Context, resourceGroupName string, name string, backupID string) (result autorest.Response, err error)
	DeleteBackupConfiguration(ctx context.Context, resourceGroupName string, name string) (result autorest.Response, err error)
	DeleteBackupConfigurationSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result autorest.Response, err error)
	DeleteBackupSlot(ctx context.Context, resourceGroupName string, name string, backupID string, slot string) (result autorest.Response, err error)
	DeleteContinuousWebJob(ctx context.Context, resourceGroupName string, name string, webJobName string) (result autorest.Response, err error)
	DeleteContinuousWebJobSlot(ctx context.Context, resourceGroupName string, name string, webJobName string, slot string) (result autorest.Response, err error)
	DeleteDeployment(ctx context.Context, resourceGroupName string, name string, ID string) (result autorest.Response, err error)
	DeleteDeploymentSlot(ctx context.Context, resourceGroupName string, name string, ID string, slot string) (result autorest.Response, err error)
	DeleteDomainOwnershipIdentifier(ctx context.Context, resourceGroupName string, name string, domainOwnershipIdentifierName string) (result autorest.Response, err error)
	DeleteDomainOwnershipIdentifierSlot(ctx context.Context, resourceGroupName string, name string, domainOwnershipIdentifierName string, slot string) (result autorest.Response, err error)
	DeleteFunction(ctx context.Context, resourceGroupName string, name string, functionName string) (result autorest.Response, err error)
	DeleteHostNameBinding(ctx context.Context, resourceGroupName string, name string, hostName string) (result autorest.Response, err error)
	DeleteHostNameBindingSlot(ctx context.Context, resourceGroupName string, name string, slot string, hostName string) (result autorest.Response, err error)
	DeleteHybridConnection(ctx context.Context, resourceGroupName string, name string, namespaceName string, relayName string) (result autorest.Response, err error)
	DeleteHybridConnectionSlot(ctx context.Context, resourceGroupName string, name string, namespaceName string, relayName string, slot string) (result autorest.Response, err error)
	DeleteInstanceFunctionSlot(ctx context.Context, resourceGroupName string, name string, functionName string, slot string) (result autorest.Response, err error)
	DeleteInstanceProcess(ctx context.Context, resourceGroupName string, name string, processID string, instanceID string) (result autorest.Response, err error)
	DeleteInstanceProcessSlot(ctx context.Context, resourceGroupName string, name string, processID string, slot string, instanceID string) (result autorest.Response, err error)
	DeletePremierAddOn(ctx context.Context, resourceGroupName string, name string, premierAddOnName string) (result autorest.Response, err error)
	DeletePremierAddOnSlot(ctx context.Context, resourceGroupName string, name string, premierAddOnName string, slot string) (result autorest.Response, err error)
	DeleteProcess(ctx context.Context, resourceGroupName string, name string, processID string) (result autorest.Response, err error)
	DeleteProcessSlot(ctx context.Context, resourceGroupName string, name string, processID string, slot string) (result autorest.Response, err error)
	DeletePublicCertificate(ctx context.Context, resourceGroupName string, name string, publicCertificateName string) (result autorest.Response, err error)
	DeletePublicCertificateSlot(ctx context.Context, resourceGroupName string, name string, slot string, publicCertificateName string) (result autorest.Response, err error)
	DeleteRelayServiceConnection(ctx context.Context, resourceGroupName string, name string, entityName string) (result autorest.Response, err error)
	DeleteRelayServiceConnectionSlot(ctx context.Context, resourceGroupName string, name string, entityName string, slot string) (result autorest.Response, err error)
	DeleteSiteExtension(ctx context.Context, resourceGroupName string, name string, siteExtensionID string) (result autorest.Response, err error)
	DeleteSiteExtensionSlot(ctx context.Context, resourceGroupName string, name string, siteExtensionID string, slot string) (result autorest.Response, err error)
	DeleteSlot(ctx context.Context, resourceGroupName string, name string, slot string, deleteMetrics *bool, deleteEmptyServerFarm *bool) (result autorest.Response, err error)
	DeleteSourceControl(ctx context.Context, resourceGroupName string, name string) (result autorest.Response, err error)
	DeleteSourceControlSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result autorest.Response, err error)
	DeleteSwiftVirtualNetwork(ctx context.Context, resourceGroupName string, name string) (result autorest.Response, err error)
	DeleteSwiftVirtualNetworkSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result autorest.Response, err error)
	DeleteTriggeredWebJob(ctx context.Context, resourceGroupName string, name string, webJobName string) (result autorest.Response, err error)
	DeleteTriggeredWebJobSlot(ctx context.Context, resourceGroupName string, name string, webJobName string, slot string) (result autorest.Response, err error)
	DeleteVnetConnection(ctx context.Context, resourceGroupName string, name string, vnetName string) (result autorest.Response, err error)
	DeleteVnetConnectionSlot(ctx context.Context, resourceGroupName string, name string, vnetName string, slot string) (result autorest.Response, err error)
	DiscoverBackup(ctx context.Context, resourceGroupName string, name string, request web.RestoreRequest) (result web.RestoreRequest, err error)
	DiscoverBackupSlot(ctx context.Context, resourceGroupName string, name string, request web.RestoreRequest, slot string) (result web.RestoreRequest, err error)
	GenerateNewSitePublishingPassword(ctx context.Context, resourceGroupName string, name string) (result autorest.Response, err error)
	GenerateNewSitePublishingPasswordSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, name string) (result web.Site, err error)
	GetAuthSettings(ctx context.Context, resourceGroupName string, name string) (result web.SiteAuthSettings, err error)
	GetAuthSettingsSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.SiteAuthSettings, err error)
	GetBackupConfiguration(ctx context.Context, resourceGroupName string, name string) (result web.BackupRequest, err error)
	GetBackupConfigurationSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.BackupRequest, err error)
	GetBackupStatus(ctx context.Context, resourceGroupName string, name string, backupID string) (result web.BackupItem, err error)
	GetBackupStatusSlot(ctx context.Context, resourceGroupName string, name string, backupID string, slot string) (result web.BackupItem, err error)
	GetConfiguration(ctx context.Context, resourceGroupName string, name string) (result web.SiteConfigResource, err error)
	GetConfigurationSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.SiteConfigResource, err error)
	GetConfigurationSnapshot(ctx context.Context, resourceGroupName string, name string, snapshotID string) (result web.SiteConfigResource, err error)
	GetConfigurationSnapshotSlot(ctx context.Context, resourceGroupName string, name string, snapshotID string, slot string) (result web.SiteConfigResource, err error)
	GetContainerLogsZip(ctx context.Context, resourceGroupName string, name string) (result web.ReadCloser, err error)
	GetContainerLogsZipSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.ReadCloser, err error)
	GetContinuousWebJob(ctx context.Context, resourceGroupName string, name string, webJobName string) (result web.ContinuousWebJob, err error)
	GetContinuousWebJobSlot(ctx context.Context, resourceGroupName string, name string, webJobName string, slot string) (result web.ContinuousWebJob, err error)
	GetDeployment(ctx context.Context, resourceGroupName string, name string, ID string) (result web.Deployment, err error)
	GetDeploymentSlot(ctx context.Context, resourceGroupName string, name string, ID string, slot string) (result web.Deployment, err error)
	GetDiagnosticLogsConfiguration(ctx context.Context, resourceGroupName string, name string) (result web.SiteLogsConfig, err error)
	GetDiagnosticLogsConfigurationSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.SiteLogsConfig, err error)
	GetDomainOwnershipIdentifier(ctx context.Context, resourceGroupName string, name string, domainOwnershipIdentifierName string) (result web.Identifier, err error)
	GetDomainOwnershipIdentifierSlot(ctx context.Context, resourceGroupName string, name string, domainOwnershipIdentifierName string, slot string) (result web.Identifier, err error)
	GetFunction(ctx context.Context, resourceGroupName string, name string, functionName string) (result web.FunctionEnvelope, err error)
	GetFunctionsAdminToken(ctx context.Context, resourceGroupName string, name string) (result web.String, err error)
	GetFunctionsAdminTokenSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.String, err error)
	GetHostNameBinding(ctx context.Context, resourceGroupName string, name string, hostName string) (result web.HostNameBinding, err error)
	GetHostNameBindingSlot(ctx context.Context, resourceGroupName string, name string, slot string, hostName string) (result web.HostNameBinding, err error)
	GetHybridConnection(ctx context.Context, resourceGroupName string, name string, namespaceName string, relayName string) (result web.HybridConnection, err error)
	GetHybridConnectionSlot(ctx context.Context, resourceGroupName string, name string, namespaceName string, relayName string, slot string) (result web.HybridConnection, err error)
	GetInstanceFunctionSlot(ctx context.Context, resourceGroupName string, name string, functionName string, slot string) (result web.FunctionEnvelope, err error)
	GetInstanceMSDeployLog(ctx context.Context, resourceGroupName string, name string, instanceID string) (result web.MSDeployLog, err error)
	GetInstanceMSDeployLogSlot(ctx context.Context, resourceGroupName string, name string, slot string, instanceID string) (result web.MSDeployLog, err error)
	GetInstanceMsDeployStatus(ctx context.Context, resourceGroupName string, name string, instanceID string) (result web.MSDeployStatus, err error)
	GetInstanceMsDeployStatusSlot(ctx context.Context, resourceGroupName string, name string, slot string, instanceID string) (result web.MSDeployStatus, err error)
	GetInstanceProcess(ctx context.Context, resourceGroupName string, name string, processID string, instanceID string) (result web.ProcessInfo, err error)
	GetInstanceProcessDump(ctx context.Context, resourceGroupName string, name string, processID string, instanceID string) (result web.ReadCloser, err error)
	GetInstanceProcessDumpSlot(ctx context.Context, resourceGroupName string, name string, processID string, slot string, instanceID string) (result web.ReadCloser, err error)
	GetInstanceProcessModule(ctx context.Context, resourceGroupName string, name string, processID string, baseAddress string, instanceID string) (result web.ProcessModuleInfo, err error)
	GetInstanceProcessModuleSlot(ctx context.Context, resourceGroupName string, name string, processID string, baseAddress string, slot string, instanceID string) (result web.ProcessModuleInfo, err error)
	GetInstanceProcessSlot(ctx context.Context, resourceGroupName string, name string, processID string, slot string, instanceID string) (result web.ProcessInfo, err error)
	GetInstanceProcessThread(ctx context.Context, resourceGroupName string, name string, processID string, threadID string, instanceID string) (result web.ProcessThreadInfo, err error)
	GetInstanceProcessThreadSlot(ctx context.Context, resourceGroupName string, name string, processID string, threadID string, slot string, instanceID string) (result web.ProcessThreadInfo, err error)
	GetMigrateMySQLStatus(ctx context.Context, resourceGroupName string, name string) (result web.MigrateMySQLStatus, err error)
	GetMigrateMySQLStatusSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.MigrateMySQLStatus, err error)
	GetMSDeployLog(ctx context.Context, resourceGroupName string, name string) (result web.MSDeployLog, err error)
	GetMSDeployLogSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.MSDeployLog, err error)
	GetMSDeployStatus(ctx context.Context, resourceGroupName string, name string) (result web.MSDeployStatus, err error)
	GetMSDeployStatusSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.MSDeployStatus, err error)
	GetNetworkTraceOperation(ctx context.Context, resourceGroupName string, name string, operationID string) (result web.ListNetworkTrace, err error)
	GetNetworkTraceOperationSlot(ctx context.Context, resourceGroupName string, name string, operationID string, slot string) (result web.ListNetworkTrace, err error)
	GetNetworkTraceOperationSlotV2(ctx context.Context, resourceGroupName string, name string, operationID string, slot string) (result web.ListNetworkTrace, err error)
	GetNetworkTraceOperationV2(ctx context.Context, resourceGroupName string, name string, operationID string) (result web.ListNetworkTrace, err error)
	GetNetworkTraces(ctx context.Context, resourceGroupName string, name string, operationID string) (result web.ListNetworkTrace, err error)
	GetNetworkTracesSlot(ctx context.Context, resourceGroupName string, name string, operationID string, slot string) (result web.ListNetworkTrace, err error)
	GetNetworkTracesSlotV2(ctx context.Context, resourceGroupName string, name string, operationID string, slot string) (result web.ListNetworkTrace, err error)
	GetNetworkTracesV2(ctx context.Context, resourceGroupName string, name string, operationID string) (result web.ListNetworkTrace, err error)
	GetPremierAddOn(ctx context.Context, resourceGroupName string, name string, premierAddOnName string) (result web.PremierAddOn, err error)
	GetPremierAddOnSlot(ctx context.Context, resourceGroupName string, name string, premierAddOnName string, slot string) (result web.PremierAddOn, err error)
	GetPrivateAccess(ctx context.Context, resourceGroupName string, name string) (result web.PrivateAccess, err error)
	GetPrivateAccessSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.PrivateAccess, err error)
	GetProcess(ctx context.Context, resourceGroupName string, name string, processID string) (result web.ProcessInfo, err error)
	GetProcessDump(ctx context.Context, resourceGroupName string, name string, processID string) (result web.ReadCloser, err error)
	GetProcessDumpSlot(ctx context.Context, resourceGroupName string, name string, processID string, slot string) (result web.ReadCloser, err error)
	GetProcessModule(ctx context.Context, resourceGroupName string, name string, processID string, baseAddress string) (result web.ProcessModuleInfo, err error)
	GetProcessModuleSlot(ctx context.Context, resourceGroupName string, name string, processID string, baseAddress string, slot string) (result web.ProcessModuleInfo, err error)
	GetProcessSlot(ctx context.Context, resourceGroupName string, name string, processID string, slot string) (result web.ProcessInfo, err error)
	GetProcessThread(ctx context.Context, resourceGroupName string, name string, processID string, threadID string) (result web.ProcessThreadInfo, err error)
	GetProcessThreadSlot(ctx context.Context, resourceGroupName string, name string, processID string, threadID string, slot string) (result web.ProcessThreadInfo, err error)
	GetPublicCertificate(ctx context.Context, resourceGroupName string, name string, publicCertificateName string) (result web.PublicCertificate, err error)
	GetPublicCertificateSlot(ctx context.Context, resourceGroupName string, name string, slot string, publicCertificateName string) (result web.PublicCertificate, err error)
	GetRelayServiceConnection(ctx context.Context, resourceGroupName string, name string, entityName string) (result web.RelayServiceConnectionEntity, err error)
	GetRelayServiceConnectionSlot(ctx context.Context, resourceGroupName string, name string, entityName string, slot string) (result web.RelayServiceConnectionEntity, err error)
	GetSiteExtension(ctx context.Context, resourceGroupName string, name string, siteExtensionID string) (result web.SiteExtensionInfo, err error)
	GetSiteExtensionSlot(ctx context.Context, resourceGroupName string, name string, siteExtensionID string, slot string) (result web.SiteExtensionInfo, err error)
	GetSitePhpErrorLogFlag(ctx context.Context, resourceGroupName string, name string) (result web.SitePhpErrorLogFlag, err error)
	GetSitePhpErrorLogFlagSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.SitePhpErrorLogFlag, err error)
	GetSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.Site, err error)
	GetSourceControl(ctx context.Context, resourceGroupName string, name string) (result web.SiteSourceControl, err error)
	GetSourceControlSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.SiteSourceControl, err error)
	GetSwiftVirtualNetworkConnection(ctx context.Context, resourceGroupName string, name string) (result web.SwiftVirtualNetwork, err error)
	GetSwiftVirtualNetworkConnectionSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.SwiftVirtualNetwork, err error)
	GetTriggeredWebJob(ctx context.Context, resourceGroupName string, name string, webJobName string) (result web.TriggeredWebJob, err error)
	GetTriggeredWebJobHistory(ctx context.Context, resourceGroupName string, name string, webJobName string, ID string) (result web.TriggeredJobHistory, err error)
	GetTriggeredWebJobHistorySlot(ctx context.Context, resourceGroupName string, name string, webJobName string, ID string, slot string) (result web.TriggeredJobHistory, err error)
	GetTriggeredWebJobSlot(ctx context.Context, resourceGroupName string, name string, webJobName string, slot string) (result web.TriggeredWebJob, err error)
	GetVnetConnection(ctx context.Context, resourceGroupName string, name string, vnetName string) (result web.VnetInfo, err error)
	GetVnetConnectionGateway(ctx context.Context, resourceGroupName string, name string, vnetName string, gatewayName string) (result web.VnetGateway, err error)
	GetVnetConnectionGatewaySlot(ctx context.Context, resourceGroupName string, name string, vnetName string, gatewayName string, slot string) (result web.VnetGateway, err error)
	GetVnetConnectionSlot(ctx context.Context, resourceGroupName string, name string, vnetName string, slot string) (result web.VnetInfo, err error)
	GetWebJob(ctx context.Context, resourceGroupName string, name string, webJobName string) (result web.Job, err error)
	GetWebJobSlot(ctx context.Context, resourceGroupName string, name string, webJobName string, slot string) (result web.Job, err error)
	GetWebSiteContainerLogs(ctx context.Context, resourceGroupName string, name string) (result web.ReadCloser, err error)
	GetWebSiteContainerLogsSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.ReadCloser, err error)
	InstallSiteExtension(ctx context.Context, resourceGroupName string, name string, siteExtensionID string) (result web.AppsInstallSiteExtensionFuture, err error)
	InstallSiteExtensionSlot(ctx context.Context, resourceGroupName string, name string, siteExtensionID string, slot string) (result web.AppsInstallSiteExtensionSlotFuture, err error)
	IsCloneable(ctx context.Context, resourceGroupName string, name string) (result web.SiteCloneability, err error)
	IsCloneableSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.SiteCloneability, err error)
	List(ctx context.Context) (result web.AppCollectionPage, err error)
	ListApplicationSettings(ctx context.Context, resourceGroupName string, name string) (result web.StringDictionary, err error)
	ListApplicationSettingsSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.StringDictionary, err error)
	ListAzureStorageAccounts(ctx context.Context, resourceGroupName string, name string) (result web.AzureStoragePropertyDictionaryResource, err error)
	ListAzureStorageAccountsSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.AzureStoragePropertyDictionaryResource, err error)
	ListBackups(ctx context.Context, resourceGroupName string, name string) (result web.BackupItemCollectionPage, err error)
	ListBackupsSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.BackupItemCollectionPage, err error)
	ListBackupStatusSecrets(ctx context.Context, resourceGroupName string, name string, backupID string, request web.BackupRequest) (result web.BackupItem, err error)
	ListBackupStatusSecretsSlot(ctx context.Context, resourceGroupName string, name string, backupID string, request web.BackupRequest, slot string) (result web.BackupItem, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string, includeSlots *bool) (result web.AppCollectionPage, err error)
	ListConfigurations(ctx context.Context, resourceGroupName string, name string) (result web.SiteConfigResourceCollectionPage, err error)
	ListConfigurationSnapshotInfo(ctx context.Context, resourceGroupName string, name string) (result web.SiteConfigurationSnapshotInfoCollectionPage, err error)
	ListConfigurationSnapshotInfoSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.SiteConfigurationSnapshotInfoCollectionPage, err error)
	ListConfigurationsSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.SiteConfigResourceCollectionPage, err error)
	ListConnectionStrings(ctx context.Context, resourceGroupName string, name string) (result web.ConnectionStringDictionary, err error)
	ListConnectionStringsSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.ConnectionStringDictionary, err error)
	ListContinuousWebJobs(ctx context.Context, resourceGroupName string, name string) (result web.ContinuousWebJobCollectionPage, err error)
	ListContinuousWebJobsSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.ContinuousWebJobCollectionPage, err error)
	ListDeploymentLog(ctx context.Context, resourceGroupName string, name string, ID string) (result web.Deployment, err error)
	ListDeploymentLogSlot(ctx context.Context, resourceGroupName string, name string, ID string, slot string) (result web.Deployment, err error)
	ListDeployments(ctx context.Context, resourceGroupName string, name string) (result web.DeploymentCollectionPage, err error)
	ListDeploymentsSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.DeploymentCollectionPage, err error)
	ListDomainOwnershipIdentifiers(ctx context.Context, resourceGroupName string, name string) (result web.IdentifierCollectionPage, err error)
	ListDomainOwnershipIdentifiersSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.IdentifierCollectionPage, err error)
	ListFunctions(ctx context.Context, resourceGroupName string, name string) (result web.FunctionEnvelopeCollectionPage, err error)
	ListFunctionSecrets(ctx context.Context, resourceGroupName string, name string, functionName string) (result web.FunctionSecrets, err error)
	ListFunctionSecretsSlot(ctx context.Context, resourceGroupName string, name string, functionName string, slot string) (result web.FunctionSecrets, err error)
	ListHostNameBindings(ctx context.Context, resourceGroupName string, name string) (result web.HostNameBindingCollectionPage, err error)
	ListHostNameBindingsSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.HostNameBindingCollectionPage, err error)
	ListHybridConnectionKeys(ctx context.Context, resourceGroupName string, name string, namespaceName string, relayName string) (result web.HybridConnectionKey, err error)
	ListHybridConnectionKeysSlot(ctx context.Context, resourceGroupName string, name string, namespaceName string, relayName string, slot string) (result web.HybridConnectionKey, err error)
	ListHybridConnections(ctx context.Context, resourceGroupName string, name string) (result web.HybridConnection, err error)
	ListHybridConnectionsSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.HybridConnection, err error)
	ListInstanceFunctionsSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.FunctionEnvelopeCollectionPage, err error)
	ListInstanceIdentifiers(ctx context.Context, resourceGroupName string, name string) (result web.AppInstanceCollectionPage, err error)
	ListInstanceIdentifiersSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.AppInstanceCollectionPage, err error)
	ListInstanceProcesses(ctx context.Context, resourceGroupName string, name string, instanceID string) (result web.ProcessInfoCollectionPage, err error)
	ListInstanceProcessesSlot(ctx context.Context, resourceGroupName string, name string, slot string, instanceID string) (result web.ProcessInfoCollectionPage, err error)
	ListInstanceProcessModules(ctx context.Context, resourceGroupName string, name string, processID string, instanceID string) (result web.ProcessModuleInfoCollectionPage, err error)
	ListInstanceProcessModulesSlot(ctx context.Context, resourceGroupName string, name string, processID string, slot string, instanceID string) (result web.ProcessModuleInfoCollectionPage, err error)
	ListInstanceProcessThreads(ctx context.Context, resourceGroupName string, name string, processID string, instanceID string) (result web.ProcessThreadInfoCollectionPage, err error)
	ListInstanceProcessThreadsSlot(ctx context.Context, resourceGroupName string, name string, processID string, slot string, instanceID string) (result web.ProcessThreadInfoCollectionPage, err error)
	ListMetadata(ctx context.Context, resourceGroupName string, name string) (result web.StringDictionary, err error)
	ListMetadataSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.StringDictionary, err error)
	ListMetricDefinitions(ctx context.Context, resourceGroupName string, name string) (result web.ResourceMetricDefinitionCollectionPage, err error)
	ListMetricDefinitionsSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.ResourceMetricDefinitionCollectionPage, err error)
	ListMetrics(ctx context.Context, resourceGroupName string, name string, details *bool, filter string) (result web.ResourceMetricCollectionPage, err error)
	ListMetricsSlot(ctx context.Context, resourceGroupName string, name string, slot string, details *bool, filter string) (result web.ResourceMetricCollectionPage, err error)
	ListNetworkFeatures(ctx context.Context, resourceGroupName string, name string, view string) (result web.NetworkFeatures, err error)
	ListNetworkFeaturesSlot(ctx context.Context, resourceGroupName string, name string, view string, slot string) (result web.NetworkFeatures, err error)
	ListPerfMonCounters(ctx context.Context, resourceGroupName string, name string, filter string) (result web.PerfMonCounterCollectionPage, err error)
	ListPerfMonCountersSlot(ctx context.Context, resourceGroupName string, name string, slot string, filter string) (result web.PerfMonCounterCollectionPage, err error)
	ListPremierAddOns(ctx context.Context, resourceGroupName string, name string) (result web.PremierAddOn, err error)
	ListPremierAddOnsSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.PremierAddOn, err error)
	ListProcesses(ctx context.Context, resourceGroupName string, name string) (result web.ProcessInfoCollectionPage, err error)
	ListProcessesSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.ProcessInfoCollectionPage, err error)
	ListProcessModules(ctx context.Context, resourceGroupName string, name string, processID string) (result web.ProcessModuleInfoCollectionPage, err error)
	ListProcessModulesSlot(ctx context.Context, resourceGroupName string, name string, processID string, slot string) (result web.ProcessModuleInfoCollectionPage, err error)
	ListProcessThreads(ctx context.Context, resourceGroupName string, name string, processID string) (result web.ProcessThreadInfoCollectionPage, err error)
	ListProcessThreadsSlot(ctx context.Context, resourceGroupName string, name string, processID string, slot string) (result web.ProcessThreadInfoCollectionPage, err error)
	ListPublicCertificates(ctx context.Context, resourceGroupName string, name string) (result web.PublicCertificateCollectionPage, err error)
	ListPublicCertificatesSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.PublicCertificateCollectionPage, err error)
	ListPublishingCredentials(ctx context.Context, resourceGroupName string, name string) (result web.AppsListPublishingCredentialsFuture, err error)
	ListPublishingCredentialsSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.AppsListPublishingCredentialsSlotFuture, err error)
	ListPublishingProfileXMLWithSecrets(ctx context.Context, resourceGroupName string, name string, publishingProfileOptions web.CsmPublishingProfileOptions) (result web.ReadCloser, err error)
	ListPublishingProfileXMLWithSecretsSlot(ctx context.Context, resourceGroupName string, name string, publishingProfileOptions web.CsmPublishingProfileOptions, slot string) (result web.ReadCloser, err error)
	ListRelayServiceConnections(ctx context.Context, resourceGroupName string, name string) (result web.RelayServiceConnectionEntity, err error)
	ListRelayServiceConnectionsSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.RelayServiceConnectionEntity, err error)
	ListSiteExtensions(ctx context.Context, resourceGroupName string, name string) (result web.SiteExtensionInfoCollectionPage, err error)
	ListSiteExtensionsSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.SiteExtensionInfoCollectionPage, err error)
	ListSitePushSettings(ctx context.Context, resourceGroupName string, name string) (result web.PushSettings, err error)
	ListSitePushSettingsSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.PushSettings, err error)
	ListSlotConfigurationNames(ctx context.Context, resourceGroupName string, name string) (result web.SlotConfigNamesResource, err error)
	ListSlotDifferencesFromProduction(ctx context.Context, resourceGroupName string, name string, slotSwapEntity web.CsmSlotEntity) (result web.SlotDifferenceCollectionPage, err error)
	ListSlotDifferencesSlot(ctx context.Context, resourceGroupName string, name string, slotSwapEntity web.CsmSlotEntity, slot string) (result web.SlotDifferenceCollectionPage, err error)
	ListSlots(ctx context.Context, resourceGroupName string, name string) (result web.AppCollectionPage, err error)
	ListSnapshots(ctx context.Context, resourceGroupName string, name string) (result web.SnapshotCollectionPage, err error)
	ListSnapshotsFromDRSecondary(ctx context.Context, resourceGroupName string, name string) (result web.SnapshotCollectionPage, err error)
	ListSnapshotsFromDRSecondarySlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.SnapshotCollectionPage, err error)
	ListSnapshotsSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.SnapshotCollectionPage, err error)
	ListSyncFunctionTriggers(ctx context.Context, resourceGroupName string, name string) (result web.FunctionSecrets, err error)
	ListSyncFunctionTriggersSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.FunctionSecrets, err error)
	ListTriggeredWebJobHistory(ctx context.Context, resourceGroupName string, name string, webJobName string) (result web.TriggeredJobHistoryCollectionPage, err error)
	ListTriggeredWebJobHistorySlot(ctx context.Context, resourceGroupName string, name string, webJobName string, slot string) (result web.TriggeredJobHistoryCollectionPage, err error)
	ListTriggeredWebJobs(ctx context.Context, resourceGroupName string, name string) (result web.TriggeredWebJobCollectionPage, err error)
	ListTriggeredWebJobsSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.TriggeredWebJobCollectionPage, err error)
	ListUsages(ctx context.Context, resourceGroupName string, name string, filter string) (result web.CsmUsageQuotaCollectionPage, err error)
	ListUsagesSlot(ctx context.Context, resourceGroupName string, name string, slot string, filter string) (result web.CsmUsageQuotaCollectionPage, err error)
	ListVnetConnections(ctx context.Context, resourceGroupName string, name string) (result web.ListVnetInfo, err error)
	ListVnetConnectionsSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.ListVnetInfo, err error)
	ListWebJobs(ctx context.Context, resourceGroupName string, name string) (result web.JobCollectionPage, err error)
	ListWebJobsSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.JobCollectionPage, err error)
	MigrateMySQL(ctx context.Context, resourceGroupName string, name string, migrationRequestEnvelope web.MigrateMySQLRequest) (result web.AppsMigrateMySQLFuture, err error)
	MigrateStorage(ctx context.Context, subscriptionName string, resourceGroupName string, name string, migrationOptions web.StorageMigrationOptions) (result web.AppsMigrateStorageFuture, err error)
	PutPrivateAccessVnet(ctx context.Context, resourceGroupName string, name string, access web.PrivateAccess) (result web.PrivateAccess, err error)
	PutPrivateAccessVnetSlot(ctx context.Context, resourceGroupName string, name string, access web.PrivateAccess, slot string) (result web.PrivateAccess, err error)
	RecoverSiteConfigurationSnapshot(ctx context.Context, resourceGroupName string, name string, snapshotID string) (result autorest.Response, err error)
	RecoverSiteConfigurationSnapshotSlot(ctx context.Context, resourceGroupName string, name string, snapshotID string, slot string) (result autorest.Response, err error)
	ResetProductionSlotConfig(ctx context.Context, resourceGroupName string, name string) (result autorest.Response, err error)
	ResetSlotConfigurationSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result autorest.Response, err error)
	Restart(ctx context.Context, resourceGroupName string, name string, softRestart *bool, synchronous *bool) (result autorest.Response, err error)
	RestartSlot(ctx context.Context, resourceGroupName string, name string, slot string, softRestart *bool, synchronous *bool) (result autorest.Response, err error)
	Restore(ctx context.Context, resourceGroupName string, name string, backupID string, request web.RestoreRequest) (result web.AppsRestoreFuture, err error)
	RestoreFromBackupBlob(ctx context.Context, resourceGroupName string, name string, request web.RestoreRequest) (result web.AppsRestoreFromBackupBlobFuture, err error)
	RestoreFromBackupBlobSlot(ctx context.Context, resourceGroupName string, name string, request web.RestoreRequest, slot string) (result web.AppsRestoreFromBackupBlobSlotFuture, err error)
	RestoreFromDeletedApp(ctx context.Context, resourceGroupName string, name string, restoreRequest web.DeletedAppRestoreRequest) (result web.AppsRestoreFromDeletedAppFuture, err error)
	RestoreFromDeletedAppSlot(ctx context.Context, resourceGroupName string, name string, restoreRequest web.DeletedAppRestoreRequest, slot string) (result web.AppsRestoreFromDeletedAppSlotFuture, err error)
	RestoreSlot(ctx context.Context, resourceGroupName string, name string, backupID string, request web.RestoreRequest, slot string) (result web.AppsRestoreSlotFuture, err error)
	RestoreSnapshot(ctx context.Context, resourceGroupName string, name string, restoreRequest web.SnapshotRestoreRequest) (result web.AppsRestoreSnapshotFuture, err error)
	RestoreSnapshotSlot(ctx context.Context, resourceGroupName string, name string, restoreRequest web.SnapshotRestoreRequest, slot string) (result web.AppsRestoreSnapshotSlotFuture, err error)
	RunTriggeredWebJob(ctx context.Context, resourceGroupName string, name string, webJobName string) (result autorest.Response, err error)
	RunTriggeredWebJobSlot(ctx context.Context, resourceGroupName string, name string, webJobName string, slot string) (result autorest.Response, err error)
	Start(ctx context.Context, resourceGroupName string, name string) (result autorest.Response, err error)
	StartContinuousWebJob(ctx context.Context, resourceGroupName string, name string, webJobName string) (result autorest.Response, err error)
	StartContinuousWebJobSlot(ctx context.Context, resourceGroupName string, name string, webJobName string, slot string) (result autorest.Response, err error)
	StartNetworkTrace(ctx context.Context, resourceGroupName string, name string, durationInSeconds *int32, maxFrameLength *int32, sasURL string) (result web.AppsStartNetworkTraceFuture, err error)
	StartNetworkTraceSlot(ctx context.Context, resourceGroupName string, name string, slot string, durationInSeconds *int32, maxFrameLength *int32, sasURL string) (result web.AppsStartNetworkTraceSlotFuture, err error)
	StartSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result autorest.Response, err error)
	StartWebSiteNetworkTrace(ctx context.Context, resourceGroupName string, name string, durationInSeconds *int32, maxFrameLength *int32, sasURL string) (result web.String, err error)
	StartWebSiteNetworkTraceOperation(ctx context.Context, resourceGroupName string, name string, durationInSeconds *int32, maxFrameLength *int32, sasURL string) (result web.AppsStartWebSiteNetworkTraceOperationFuture, err error)
	StartWebSiteNetworkTraceOperationSlot(ctx context.Context, resourceGroupName string, name string, slot string, durationInSeconds *int32, maxFrameLength *int32, sasURL string) (result web.AppsStartWebSiteNetworkTraceOperationSlotFuture, err error)
	StartWebSiteNetworkTraceSlot(ctx context.Context, resourceGroupName string, name string, slot string, durationInSeconds *int32, maxFrameLength *int32, sasURL string) (result web.String, err error)
	Stop(ctx context.Context, resourceGroupName string, name string) (result autorest.Response, err error)
	StopContinuousWebJob(ctx context.Context, resourceGroupName string, name string, webJobName string) (result autorest.Response, err error)
	StopContinuousWebJobSlot(ctx context.Context, resourceGroupName string, name string, webJobName string, slot string) (result autorest.Response, err error)
	StopNetworkTrace(ctx context.Context, resourceGroupName string, name string) (result autorest.Response, err error)
	StopNetworkTraceSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result autorest.Response, err error)
	StopSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result autorest.Response, err error)
	StopWebSiteNetworkTrace(ctx context.Context, resourceGroupName string, name string) (result autorest.Response, err error)
	StopWebSiteNetworkTraceSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result autorest.Response, err error)
	SwapSlotSlot(ctx context.Context, resourceGroupName string, name string, slotSwapEntity web.CsmSlotEntity, slot string) (result web.AppsSwapSlotSlotFuture, err error)
	SwapSlotWithProduction(ctx context.Context, resourceGroupName string, name string, slotSwapEntity web.CsmSlotEntity) (result web.AppsSwapSlotWithProductionFuture, err error)
	SyncFunctionTriggers(ctx context.Context, resourceGroupName string, name string) (result autorest.Response, err error)
	SyncFunctionTriggersSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result autorest.Response, err error)
	SyncRepository(ctx context.Context, resourceGroupName string, name string) (result autorest.Response, err error)
	SyncRepositorySlot(ctx context.Context, resourceGroupName string, name string, slot string) (result autorest.Response, err error)
	Update(ctx context.Context, resourceGroupName string, name string, siteEnvelope web.SitePatchResource) (result web.Site, err error)
	UpdateApplicationSettings(ctx context.Context, resourceGroupName string, name string, appSettings web.StringDictionary) (result web.StringDictionary, err error)
	UpdateApplicationSettingsSlot(ctx context.Context, resourceGroupName string, name string, appSettings web.StringDictionary, slot string) (result web.StringDictionary, err error)
	UpdateAuthSettings(ctx context.Context, resourceGroupName string, name string, siteAuthSettings web.SiteAuthSettings) (result web.SiteAuthSettings, err error)
	UpdateAuthSettingsSlot(ctx context.Context, resourceGroupName string, name string, siteAuthSettings web.SiteAuthSettings, slot string) (result web.SiteAuthSettings, err error)
	UpdateAzureStorageAccounts(ctx context.Context, resourceGroupName string, name string, azureStorageAccounts web.AzureStoragePropertyDictionaryResource) (result web.AzureStoragePropertyDictionaryResource, err error)
	UpdateAzureStorageAccountsSlot(ctx context.Context, resourceGroupName string, name string, azureStorageAccounts web.AzureStoragePropertyDictionaryResource, slot string) (result web.AzureStoragePropertyDictionaryResource, err error)
	UpdateBackupConfiguration(ctx context.Context, resourceGroupName string, name string, request web.BackupRequest) (result web.BackupRequest, err error)
	UpdateBackupConfigurationSlot(ctx context.Context, resourceGroupName string, name string, request web.BackupRequest, slot string) (result web.BackupRequest, err error)
	UpdateConfiguration(ctx context.Context, resourceGroupName string, name string, siteConfig web.SiteConfigResource) (result web.SiteConfigResource, err error)
	UpdateConfigurationSlot(ctx context.Context, resourceGroupName string, name string, siteConfig web.SiteConfigResource, slot string) (result web.SiteConfigResource, err error)
	UpdateConnectionStrings(ctx context.Context, resourceGroupName string, name string, connectionStrings web.ConnectionStringDictionary) (result web.ConnectionStringDictionary, err error)
	UpdateConnectionStringsSlot(ctx context.Context, resourceGroupName string, name string, connectionStrings web.ConnectionStringDictionary, slot string) (result web.ConnectionStringDictionary, err error)
	UpdateDiagnosticLogsConfig(ctx context.Context, resourceGroupName string, name string, siteLogsConfig web.SiteLogsConfig) (result web.SiteLogsConfig, err error)
	UpdateDiagnosticLogsConfigSlot(ctx context.Context, resourceGroupName string, name string, siteLogsConfig web.SiteLogsConfig, slot string) (result web.SiteLogsConfig, err error)
	UpdateDomainOwnershipIdentifier(ctx context.Context, resourceGroupName string, name string, domainOwnershipIdentifierName string, domainOwnershipIdentifier web.Identifier) (result web.Identifier, err error)
	UpdateDomainOwnershipIdentifierSlot(ctx context.Context, resourceGroupName string, name string, domainOwnershipIdentifierName string, domainOwnershipIdentifier web.Identifier, slot string) (result web.Identifier, err error)
	UpdateHybridConnection(ctx context.Context, resourceGroupName string, name string, namespaceName string, relayName string, connectionEnvelope web.HybridConnection) (result web.HybridConnection, err error)
	UpdateHybridConnectionSlot(ctx context.Context, resourceGroupName string, name string, namespaceName string, relayName string, connectionEnvelope web.HybridConnection, slot string) (result web.HybridConnection, err error)
	UpdateMetadata(ctx context.Context, resourceGroupName string, name string, metadata web.StringDictionary) (result web.StringDictionary, err error)
	UpdateMetadataSlot(ctx context.Context, resourceGroupName string, name string, metadata web.StringDictionary, slot string) (result web.StringDictionary, err error)
	UpdatePremierAddOn(ctx context.Context, resourceGroupName string, name string, premierAddOnName string, premierAddOn web.PremierAddOnPatchResource) (result web.PremierAddOn, err error)
	UpdatePremierAddOnSlot(ctx context.Context, resourceGroupName string, name string, premierAddOnName string, premierAddOn web.PremierAddOnPatchResource, slot string) (result web.PremierAddOn, err error)
	UpdateRelayServiceConnection(ctx context.Context, resourceGroupName string, name string, entityName string, connectionEnvelope web.RelayServiceConnectionEntity) (result web.RelayServiceConnectionEntity, err error)
	UpdateRelayServiceConnectionSlot(ctx context.Context, resourceGroupName string, name string, entityName string, connectionEnvelope web.RelayServiceConnectionEntity, slot string) (result web.RelayServiceConnectionEntity, err error)
	UpdateSitePushSettings(ctx context.Context, resourceGroupName string, name string, pushSettings web.PushSettings) (result web.PushSettings, err error)
	UpdateSitePushSettingsSlot(ctx context.Context, resourceGroupName string, name string, pushSettings web.PushSettings, slot string) (result web.PushSettings, err error)
	UpdateSlot(ctx context.Context, resourceGroupName string, name string, siteEnvelope web.SitePatchResource, slot string) (result web.Site, err error)
	UpdateSlotConfigurationNames(ctx context.Context, resourceGroupName string, name string, slotConfigNames web.SlotConfigNamesResource) (result web.SlotConfigNamesResource, err error)
	UpdateSourceControl(ctx context.Context, resourceGroupName string, name string, siteSourceControl web.SiteSourceControl) (result web.SiteSourceControl, err error)
	UpdateSourceControlSlot(ctx context.Context, resourceGroupName string, name string, siteSourceControl web.SiteSourceControl, slot string) (result web.SiteSourceControl, err error)
	UpdateSwiftVirtualNetworkConnection(ctx context.Context, resourceGroupName string, name string, connectionEnvelope web.SwiftVirtualNetwork) (result web.SwiftVirtualNetwork, err error)
	UpdateSwiftVirtualNetworkConnectionSlot(ctx context.Context, resourceGroupName string, name string, connectionEnvelope web.SwiftVirtualNetwork, slot string) (result web.SwiftVirtualNetwork, err error)
	UpdateVnetConnection(ctx context.Context, resourceGroupName string, name string, vnetName string, connectionEnvelope web.VnetInfo) (result web.VnetInfo, err error)
	UpdateVnetConnectionGateway(ctx context.Context, resourceGroupName string, name string, vnetName string, gatewayName string, connectionEnvelope web.VnetGateway) (result web.VnetGateway, err error)
	UpdateVnetConnectionGatewaySlot(ctx context.Context, resourceGroupName string, name string, vnetName string, gatewayName string, connectionEnvelope web.VnetGateway, slot string) (result web.VnetGateway, err error)
	UpdateVnetConnectionSlot(ctx context.Context, resourceGroupName string, name string, vnetName string, connectionEnvelope web.VnetInfo, slot string) (result web.VnetInfo, err error)
}

var _ AppsClientAPI = (*web.AppsClient)(nil)

// AppServiceEnvironmentsClientAPI contains the set of methods on the AppServiceEnvironmentsClient type.
type AppServiceEnvironmentsClientAPI interface {
	ChangeVnet(ctx context.Context, resourceGroupName string, name string, vnetInfo web.VirtualNetworkProfile) (result web.AppServiceEnvironmentsChangeVnetFuture, err error)
	CreateOrUpdate(ctx context.Context, resourceGroupName string, name string, hostingEnvironmentEnvelope web.AppServiceEnvironmentResource) (result web.AppServiceEnvironmentsCreateOrUpdateFuture, err error)
	CreateOrUpdateMultiRolePool(ctx context.Context, resourceGroupName string, name string, multiRolePoolEnvelope web.WorkerPoolResource) (result web.AppServiceEnvironmentsCreateOrUpdateMultiRolePoolFuture, err error)
	CreateOrUpdateWorkerPool(ctx context.Context, resourceGroupName string, name string, workerPoolName string, workerPoolEnvelope web.WorkerPoolResource) (result web.AppServiceEnvironmentsCreateOrUpdateWorkerPoolFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, name string, forceDelete *bool) (result web.AppServiceEnvironmentsDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, name string) (result web.AppServiceEnvironmentResource, err error)
	GetDiagnosticsItem(ctx context.Context, resourceGroupName string, name string, diagnosticsName string) (result web.HostingEnvironmentDiagnostics, err error)
	GetMultiRolePool(ctx context.Context, resourceGroupName string, name string) (result web.WorkerPoolResource, err error)
	GetWorkerPool(ctx context.Context, resourceGroupName string, name string, workerPoolName string) (result web.WorkerPoolResource, err error)
	List(ctx context.Context) (result web.AppServiceEnvironmentCollectionPage, err error)
	ListAppServicePlans(ctx context.Context, resourceGroupName string, name string) (result web.AppServicePlanCollectionPage, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string) (result web.AppServiceEnvironmentCollectionPage, err error)
	ListCapacities(ctx context.Context, resourceGroupName string, name string) (result web.StampCapacityCollectionPage, err error)
	ListDiagnostics(ctx context.Context, resourceGroupName string, name string) (result web.ListHostingEnvironmentDiagnostics, err error)
	ListMetricDefinitions(ctx context.Context, resourceGroupName string, name string) (result web.MetricDefinition, err error)
	ListMetrics(ctx context.Context, resourceGroupName string, name string, details *bool, filter string) (result web.ResourceMetricCollectionPage, err error)
	ListMultiRoleMetricDefinitions(ctx context.Context, resourceGroupName string, name string) (result web.ResourceMetricDefinitionCollectionPage, err error)
	ListMultiRoleMetrics(ctx context.Context, resourceGroupName string, name string, startTime string, endTime string, timeGrain string, details *bool, filter string) (result web.ResourceMetricCollectionPage, err error)
	ListMultiRolePoolInstanceMetricDefinitions(ctx context.Context, resourceGroupName string, name string, instance string) (result web.ResourceMetricDefinitionCollectionPage, err error)
	ListMultiRolePoolInstanceMetrics(ctx context.Context, resourceGroupName string, name string, instance string, details *bool) (result web.ResourceMetricCollectionPage, err error)
	ListMultiRolePools(ctx context.Context, resourceGroupName string, name string) (result web.WorkerPoolCollectionPage, err error)
	ListMultiRolePoolSkus(ctx context.Context, resourceGroupName string, name string) (result web.SkuInfoCollectionPage, err error)
	ListMultiRoleUsages(ctx context.Context, resourceGroupName string, name string) (result web.UsageCollectionPage, err error)
	ListOperations(ctx context.Context, resourceGroupName string, name string) (result web.ListOperation, err error)
	ListUsages(ctx context.Context, resourceGroupName string, name string, filter string) (result web.CsmUsageQuotaCollectionPage, err error)
	ListVips(ctx context.Context, resourceGroupName string, name string) (result web.AddressResponse, err error)
	ListWebApps(ctx context.Context, resourceGroupName string, name string, propertiesToInclude string) (result web.AppCollectionPage, err error)
	ListWebWorkerMetricDefinitions(ctx context.Context, resourceGroupName string, name string, workerPoolName string) (result web.ResourceMetricDefinitionCollectionPage, err error)
	ListWebWorkerMetrics(ctx context.Context, resourceGroupName string, name string, workerPoolName string, details *bool, filter string) (result web.ResourceMetricCollectionPage, err error)
	ListWebWorkerUsages(ctx context.Context, resourceGroupName string, name string, workerPoolName string) (result web.UsageCollectionPage, err error)
	ListWorkerPoolInstanceMetricDefinitions(ctx context.Context, resourceGroupName string, name string, workerPoolName string, instance string) (result web.ResourceMetricDefinitionCollectionPage, err error)
	ListWorkerPoolInstanceMetrics(ctx context.Context, resourceGroupName string, name string, workerPoolName string, instance string, details *bool, filter string) (result web.ResourceMetricCollectionPage, err error)
	ListWorkerPools(ctx context.Context, resourceGroupName string, name string) (result web.WorkerPoolCollectionPage, err error)
	ListWorkerPoolSkus(ctx context.Context, resourceGroupName string, name string, workerPoolName string) (result web.SkuInfoCollectionPage, err error)
	Reboot(ctx context.Context, resourceGroupName string, name string) (result autorest.Response, err error)
	Resume(ctx context.Context, resourceGroupName string, name string) (result web.AppServiceEnvironmentsResumeFuture, err error)
	Suspend(ctx context.Context, resourceGroupName string, name string) (result web.AppServiceEnvironmentsSuspendFuture, err error)
	Update(ctx context.Context, resourceGroupName string, name string, hostingEnvironmentEnvelope web.AppServiceEnvironmentPatchResource) (result web.AppServiceEnvironmentResource, err error)
	UpdateMultiRolePool(ctx context.Context, resourceGroupName string, name string, multiRolePoolEnvelope web.WorkerPoolResource) (result web.WorkerPoolResource, err error)
	UpdateWorkerPool(ctx context.Context, resourceGroupName string, name string, workerPoolName string, workerPoolEnvelope web.WorkerPoolResource) (result web.WorkerPoolResource, err error)
}

var _ AppServiceEnvironmentsClientAPI = (*web.AppServiceEnvironmentsClient)(nil)

// AppServicePlansClientAPI contains the set of methods on the AppServicePlansClient type.
type AppServicePlansClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, name string, appServicePlan web.AppServicePlan) (result web.AppServicePlansCreateOrUpdateFuture, err error)
	CreateOrUpdateVnetRoute(ctx context.Context, resourceGroupName string, name string, vnetName string, routeName string, route web.VnetRoute) (result web.VnetRoute, err error)
	Delete(ctx context.Context, resourceGroupName string, name string) (result autorest.Response, err error)
	DeleteHybridConnection(ctx context.Context, resourceGroupName string, name string, namespaceName string, relayName string) (result autorest.Response, err error)
	DeleteVnetRoute(ctx context.Context, resourceGroupName string, name string, vnetName string, routeName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, name string) (result web.AppServicePlan, err error)
	GetHybridConnection(ctx context.Context, resourceGroupName string, name string, namespaceName string, relayName string) (result web.HybridConnection, err error)
	GetHybridConnectionPlanLimit(ctx context.Context, resourceGroupName string, name string) (result web.HybridConnectionLimits, err error)
	GetRouteForVnet(ctx context.Context, resourceGroupName string, name string, vnetName string, routeName string) (result web.ListVnetRoute, err error)
	GetServerFarmSkus(ctx context.Context, resourceGroupName string, name string) (result web.SetObject, err error)
	GetVnetFromServerFarm(ctx context.Context, resourceGroupName string, name string, vnetName string) (result web.VnetInfo, err error)
	GetVnetGateway(ctx context.Context, resourceGroupName string, name string, vnetName string, gatewayName string) (result web.VnetGateway, err error)
	List(ctx context.Context, detailed *bool) (result web.AppServicePlanCollectionPage, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string) (result web.AppServicePlanCollectionPage, err error)
	ListCapabilities(ctx context.Context, resourceGroupName string, name string) (result web.ListCapability, err error)
	ListHybridConnectionKeys(ctx context.Context, resourceGroupName string, name string, namespaceName string, relayName string) (result web.HybridConnectionKey, err error)
	ListHybridConnections(ctx context.Context, resourceGroupName string, name string) (result web.HybridConnectionCollectionPage, err error)
	ListMetricDefintions(ctx context.Context, resourceGroupName string, name string) (result web.ResourceMetricDefinitionCollectionPage, err error)
	ListMetrics(ctx context.Context, resourceGroupName string, name string, details *bool, filter string) (result web.ResourceMetricCollectionPage, err error)
	ListRoutesForVnet(ctx context.Context, resourceGroupName string, name string, vnetName string) (result web.ListVnetRoute, err error)
	ListUsages(ctx context.Context, resourceGroupName string, name string, filter string) (result web.CsmUsageQuotaCollectionPage, err error)
	ListVnets(ctx context.Context, resourceGroupName string, name string) (result web.ListVnetInfo, err error)
	ListWebApps(ctx context.Context, resourceGroupName string, name string, skipToken string, filter string, top string) (result web.AppCollectionPage, err error)
	ListWebAppsByHybridConnection(ctx context.Context, resourceGroupName string, name string, namespaceName string, relayName string) (result web.ResourceCollectionPage, err error)
	RebootWorker(ctx context.Context, resourceGroupName string, name string, workerName string) (result autorest.Response, err error)
	RestartWebApps(ctx context.Context, resourceGroupName string, name string, softRestart *bool) (result autorest.Response, err error)
	Update(ctx context.Context, resourceGroupName string, name string, appServicePlan web.AppServicePlanPatchResource) (result web.AppServicePlan, err error)
	UpdateVnetGateway(ctx context.Context, resourceGroupName string, name string, vnetName string, gatewayName string, connectionEnvelope web.VnetGateway) (result web.VnetGateway, err error)
	UpdateVnetRoute(ctx context.Context, resourceGroupName string, name string, vnetName string, routeName string, route web.VnetRoute) (result web.VnetRoute, err error)
}

var _ AppServicePlansClientAPI = (*web.AppServicePlansClient)(nil)

// ResourceHealthMetadataClientAPI contains the set of methods on the ResourceHealthMetadataClient type.
type ResourceHealthMetadataClientAPI interface {
	GetBySite(ctx context.Context, resourceGroupName string, name string) (result web.ResourceHealthMetadata, err error)
	GetBySiteSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.ResourceHealthMetadata, err error)
	List(ctx context.Context) (result web.ResourceHealthMetadataCollectionPage, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string) (result web.ResourceHealthMetadataCollectionPage, err error)
	ListBySite(ctx context.Context, resourceGroupName string, name string) (result web.ResourceHealthMetadataCollectionPage, err error)
	ListBySiteSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.ResourceHealthMetadataCollectionPage, err error)
}

var _ ResourceHealthMetadataClientAPI = (*web.ResourceHealthMetadataClient)(nil)
