// Code generated by protoc-gen-go. DO NOT EDIT.
// source: github.com/kubernetes-csi/csi-proxy/client/api/system/v1alpha1/api.proto

package v1alpha1

import (
	context "context"
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// https://docs.microsoft.com/en-us/windows/win32/api/winsvc/ns-winsvc-service_status#members
type ServiceStatus int32

const (
	ServiceStatus_UNKNOWN          ServiceStatus = 0
	ServiceStatus_STOPPED          ServiceStatus = 1
	ServiceStatus_START_PENDING    ServiceStatus = 2
	ServiceStatus_STOP_PENDING     ServiceStatus = 3
	ServiceStatus_RUNNING          ServiceStatus = 4
	ServiceStatus_CONTINUE_PENDING ServiceStatus = 5
	ServiceStatus_PAUSE_PENDING    ServiceStatus = 6
	ServiceStatus_PAUSED           ServiceStatus = 7
)

var ServiceStatus_name = map[int32]string{
	0: "UNKNOWN",
	1: "STOPPED",
	2: "START_PENDING",
	3: "STOP_PENDING",
	4: "RUNNING",
	5: "CONTINUE_PENDING",
	6: "PAUSE_PENDING",
	7: "PAUSED",
}

var ServiceStatus_value = map[string]int32{
	"UNKNOWN":          0,
	"STOPPED":          1,
	"START_PENDING":    2,
	"STOP_PENDING":     3,
	"RUNNING":          4,
	"CONTINUE_PENDING": 5,
	"PAUSE_PENDING":    6,
	"PAUSED":           7,
}

func (x ServiceStatus) String() string {
	return proto.EnumName(ServiceStatus_name, int32(x))
}

func (ServiceStatus) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_4066a9d4a9264c6f, []int{0}
}

// https://docs.microsoft.com/en-us/windows/win32/api/winsvc/nf-winsvc-changeserviceconfiga
type StartType int32

const (
	StartType_BOOT      StartType = 0
	StartType_SYSTEM    StartType = 1
	StartType_AUTOMATIC StartType = 2
	StartType_MANUAL    StartType = 3
	StartType_DISABLED  StartType = 4
)

var StartType_name = map[int32]string{
	0: "BOOT",
	1: "SYSTEM",
	2: "AUTOMATIC",
	3: "MANUAL",
	4: "DISABLED",
}

var StartType_value = map[string]int32{
	"BOOT":      0,
	"SYSTEM":    1,
	"AUTOMATIC": 2,
	"MANUAL":    3,
	"DISABLED":  4,
}

func (x StartType) String() string {
	return proto.EnumName(StartType_name, int32(x))
}

func (StartType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_4066a9d4a9264c6f, []int{1}
}

type GetBIOSSerialNumberRequest struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetBIOSSerialNumberRequest) Reset()         { *m = GetBIOSSerialNumberRequest{} }
func (m *GetBIOSSerialNumberRequest) String() string { return proto.CompactTextString(m) }
func (*GetBIOSSerialNumberRequest) ProtoMessage()    {}
func (*GetBIOSSerialNumberRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_4066a9d4a9264c6f, []int{0}
}

func (m *GetBIOSSerialNumberRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetBIOSSerialNumberRequest.Unmarshal(m, b)
}
func (m *GetBIOSSerialNumberRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetBIOSSerialNumberRequest.Marshal(b, m, deterministic)
}
func (m *GetBIOSSerialNumberRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetBIOSSerialNumberRequest.Merge(m, src)
}
func (m *GetBIOSSerialNumberRequest) XXX_Size() int {
	return xxx_messageInfo_GetBIOSSerialNumberRequest.Size(m)
}
func (m *GetBIOSSerialNumberRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetBIOSSerialNumberRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetBIOSSerialNumberRequest proto.InternalMessageInfo

type GetBIOSSerialNumberResponse struct {
	// Serial number
	SerialNumber         string   `protobuf:"bytes,1,opt,name=serial_number,json=serialNumber,proto3" json:"serial_number,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetBIOSSerialNumberResponse) Reset()         { *m = GetBIOSSerialNumberResponse{} }
func (m *GetBIOSSerialNumberResponse) String() string { return proto.CompactTextString(m) }
func (*GetBIOSSerialNumberResponse) ProtoMessage()    {}
func (*GetBIOSSerialNumberResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_4066a9d4a9264c6f, []int{1}
}

func (m *GetBIOSSerialNumberResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetBIOSSerialNumberResponse.Unmarshal(m, b)
}
func (m *GetBIOSSerialNumberResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetBIOSSerialNumberResponse.Marshal(b, m, deterministic)
}
func (m *GetBIOSSerialNumberResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetBIOSSerialNumberResponse.Merge(m, src)
}
func (m *GetBIOSSerialNumberResponse) XXX_Size() int {
	return xxx_messageInfo_GetBIOSSerialNumberResponse.Size(m)
}
func (m *GetBIOSSerialNumberResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetBIOSSerialNumberResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetBIOSSerialNumberResponse proto.InternalMessageInfo

func (m *GetBIOSSerialNumberResponse) GetSerialNumber() string {
	if m != nil {
		return m.SerialNumber
	}
	return ""
}

type StartServiceRequest struct {
	// Service name (as listed in System\CCS\Services keys)
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StartServiceRequest) Reset()         { *m = StartServiceRequest{} }
func (m *StartServiceRequest) String() string { return proto.CompactTextString(m) }
func (*StartServiceRequest) ProtoMessage()    {}
func (*StartServiceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_4066a9d4a9264c6f, []int{2}
}

func (m *StartServiceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StartServiceRequest.Unmarshal(m, b)
}
func (m *StartServiceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StartServiceRequest.Marshal(b, m, deterministic)
}
func (m *StartServiceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StartServiceRequest.Merge(m, src)
}
func (m *StartServiceRequest) XXX_Size() int {
	return xxx_messageInfo_StartServiceRequest.Size(m)
}
func (m *StartServiceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StartServiceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StartServiceRequest proto.InternalMessageInfo

func (m *StartServiceRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

type StartServiceResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StartServiceResponse) Reset()         { *m = StartServiceResponse{} }
func (m *StartServiceResponse) String() string { return proto.CompactTextString(m) }
func (*StartServiceResponse) ProtoMessage()    {}
func (*StartServiceResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_4066a9d4a9264c6f, []int{3}
}

func (m *StartServiceResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StartServiceResponse.Unmarshal(m, b)
}
func (m *StartServiceResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StartServiceResponse.Marshal(b, m, deterministic)
}
func (m *StartServiceResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StartServiceResponse.Merge(m, src)
}
func (m *StartServiceResponse) XXX_Size() int {
	return xxx_messageInfo_StartServiceResponse.Size(m)
}
func (m *StartServiceResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_StartServiceResponse.DiscardUnknown(m)
}

var xxx_messageInfo_StartServiceResponse proto.InternalMessageInfo

type StopServiceRequest struct {
	// Service name (as listed in System\CCS\Services keys)
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Forces stopping of services that has dependant services
	Force                bool     `protobuf:"varint,2,opt,name=force,proto3" json:"force,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StopServiceRequest) Reset()         { *m = StopServiceRequest{} }
func (m *StopServiceRequest) String() string { return proto.CompactTextString(m) }
func (*StopServiceRequest) ProtoMessage()    {}
func (*StopServiceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_4066a9d4a9264c6f, []int{4}
}

func (m *StopServiceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StopServiceRequest.Unmarshal(m, b)
}
func (m *StopServiceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StopServiceRequest.Marshal(b, m, deterministic)
}
func (m *StopServiceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StopServiceRequest.Merge(m, src)
}
func (m *StopServiceRequest) XXX_Size() int {
	return xxx_messageInfo_StopServiceRequest.Size(m)
}
func (m *StopServiceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StopServiceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StopServiceRequest proto.InternalMessageInfo

func (m *StopServiceRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *StopServiceRequest) GetForce() bool {
	if m != nil {
		return m.Force
	}
	return false
}

type StopServiceResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StopServiceResponse) Reset()         { *m = StopServiceResponse{} }
func (m *StopServiceResponse) String() string { return proto.CompactTextString(m) }
func (*StopServiceResponse) ProtoMessage()    {}
func (*StopServiceResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_4066a9d4a9264c6f, []int{5}
}

func (m *StopServiceResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StopServiceResponse.Unmarshal(m, b)
}
func (m *StopServiceResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StopServiceResponse.Marshal(b, m, deterministic)
}
func (m *StopServiceResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StopServiceResponse.Merge(m, src)
}
func (m *StopServiceResponse) XXX_Size() int {
	return xxx_messageInfo_StopServiceResponse.Size(m)
}
func (m *StopServiceResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_StopServiceResponse.DiscardUnknown(m)
}

var xxx_messageInfo_StopServiceResponse proto.InternalMessageInfo

type GetServiceRequest struct {
	// Service name (as listed in System\CCS\Services keys)
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetServiceRequest) Reset()         { *m = GetServiceRequest{} }
func (m *GetServiceRequest) String() string { return proto.CompactTextString(m) }
func (*GetServiceRequest) ProtoMessage()    {}
func (*GetServiceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_4066a9d4a9264c6f, []int{6}
}

func (m *GetServiceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetServiceRequest.Unmarshal(m, b)
}
func (m *GetServiceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetServiceRequest.Marshal(b, m, deterministic)
}
func (m *GetServiceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetServiceRequest.Merge(m, src)
}
func (m *GetServiceRequest) XXX_Size() int {
	return xxx_messageInfo_GetServiceRequest.Size(m)
}
func (m *GetServiceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetServiceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetServiceRequest proto.InternalMessageInfo

func (m *GetServiceRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

type GetServiceResponse struct {
	// Service display name
	DisplayName string `protobuf:"bytes,1,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Service start type.
	// Used to control whether a service will start on boot, and if so on which
	// boot phase.
	StartType StartType `protobuf:"varint,2,opt,name=start_type,json=startType,proto3,enum=v1alpha1.StartType" json:"start_type,omitempty"`
	// Service status, e.g. stopped, running, paused
	Status               ServiceStatus `protobuf:"varint,3,opt,name=status,proto3,enum=v1alpha1.ServiceStatus" json:"status,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *GetServiceResponse) Reset()         { *m = GetServiceResponse{} }
func (m *GetServiceResponse) String() string { return proto.CompactTextString(m) }
func (*GetServiceResponse) ProtoMessage()    {}
func (*GetServiceResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_4066a9d4a9264c6f, []int{7}
}

func (m *GetServiceResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetServiceResponse.Unmarshal(m, b)
}
func (m *GetServiceResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetServiceResponse.Marshal(b, m, deterministic)
}
func (m *GetServiceResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetServiceResponse.Merge(m, src)
}
func (m *GetServiceResponse) XXX_Size() int {
	return xxx_messageInfo_GetServiceResponse.Size(m)
}
func (m *GetServiceResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetServiceResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetServiceResponse proto.InternalMessageInfo

func (m *GetServiceResponse) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *GetServiceResponse) GetStartType() StartType {
	if m != nil {
		return m.StartType
	}
	return StartType_BOOT
}

func (m *GetServiceResponse) GetStatus() ServiceStatus {
	if m != nil {
		return m.Status
	}
	return ServiceStatus_UNKNOWN
}

func init() {
	proto.RegisterEnum("v1alpha1.ServiceStatus", ServiceStatus_name, ServiceStatus_value)
	proto.RegisterEnum("v1alpha1.StartType", StartType_name, StartType_value)
	proto.RegisterType((*GetBIOSSerialNumberRequest)(nil), "v1alpha1.GetBIOSSerialNumberRequest")
	proto.RegisterType((*GetBIOSSerialNumberResponse)(nil), "v1alpha1.GetBIOSSerialNumberResponse")
	proto.RegisterType((*StartServiceRequest)(nil), "v1alpha1.StartServiceRequest")
	proto.RegisterType((*StartServiceResponse)(nil), "v1alpha1.StartServiceResponse")
	proto.RegisterType((*StopServiceRequest)(nil), "v1alpha1.StopServiceRequest")
	proto.RegisterType((*StopServiceResponse)(nil), "v1alpha1.StopServiceResponse")
	proto.RegisterType((*GetServiceRequest)(nil), "v1alpha1.GetServiceRequest")
	proto.RegisterType((*GetServiceResponse)(nil), "v1alpha1.GetServiceResponse")
}

func init() {
	proto.RegisterFile("github.com/kubernetes-csi/csi-proxy/client/api/system/v1alpha1/api.proto", fileDescriptor_4066a9d4a9264c6f)
}

var fileDescriptor_4066a9d4a9264c6f = []byte{
	// 553 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x54, 0x61, 0x6f, 0xd2, 0x40,
	0x18, 0x5e, 0x81, 0x31, 0x78, 0x01, 0xd3, 0x1d, 0xa8, 0x84, 0x31, 0x33, 0xab, 0xc6, 0xb9, 0x64,
	0x34, 0xc3, 0xef, 0x8b, 0x65, 0x10, 0xac, 0xc2, 0x95, 0xf4, 0xda, 0x18, 0xfd, 0x42, 0x4a, 0x77,
	0xba, 0x46, 0xa0, 0xb5, 0x77, 0x2c, 0xf2, 0x2f, 0xfc, 0x01, 0xfe, 0x30, 0x7f, 0x8e, 0xb9, 0x52,
	0xa0, 0x10, 0xc8, 0x4c, 0xfc, 0x76, 0xef, 0xf3, 0x3c, 0xef, 0xd3, 0xf7, 0xbd, 0x3e, 0x39, 0x78,
	0xff, 0xcd, 0xe3, 0x77, 0xb3, 0x51, 0xc3, 0xf5, 0x27, 0xea, 0xf7, 0xd9, 0x88, 0x86, 0x53, 0xca,
	0x29, 0xbb, 0x74, 0x99, 0xa7, 0xba, 0xcc, 0xbb, 0x0c, 0x42, 0xff, 0xe7, 0x5c, 0x75, 0xc7, 0x1e,
	0x9d, 0x72, 0xd5, 0x09, 0x3c, 0x95, 0xcd, 0x19, 0xa7, 0x13, 0xf5, 0xfe, 0xca, 0x19, 0x07, 0x77,
	0xce, 0x95, 0xc0, 0x1a, 0x41, 0xe8, 0x73, 0x1f, 0xe5, 0x96, 0x98, 0x52, 0x87, 0x5a, 0x97, 0xf2,
	0x96, 0x6e, 0x10, 0x42, 0x43, 0xcf, 0x19, 0xe3, 0xd9, 0x64, 0x44, 0x43, 0x93, 0xfe, 0x98, 0x51,
	0xc6, 0x95, 0x16, 0x9c, 0xec, 0x64, 0x59, 0xe0, 0x4f, 0x19, 0x45, 0x2f, 0xa0, 0xc4, 0x22, 0x7c,
	0x38, 0x8d, 0x88, 0xaa, 0x74, 0x26, 0x9d, 0xe7, 0xcd, 0x22, 0x4b, 0x88, 0x95, 0x37, 0x50, 0x26,
	0xdc, 0x09, 0x39, 0xa1, 0xe1, 0xbd, 0xe7, 0xd2, 0xd8, 0x1a, 0x21, 0xc8, 0x4c, 0x9d, 0x09, 0x8d,
	0x5b, 0xa2, 0xb3, 0xf2, 0x04, 0x2a, 0x9b, 0xd2, 0xc5, 0x77, 0x94, 0x6b, 0x40, 0x84, 0xfb, 0xc1,
	0xc3, 0x0e, 0xa8, 0x02, 0x87, 0x5f, 0xfd, 0xd0, 0xa5, 0xd5, 0xd4, 0x99, 0x74, 0x9e, 0x33, 0x17,
	0x85, 0xf2, 0x58, 0x8c, 0x90, 0xe8, 0x8f, 0x6d, 0x5f, 0xc3, 0x71, 0x97, 0xfe, 0xcb, 0x5c, 0xbf,
	0x25, 0x40, 0x49, 0x65, 0xbc, 0xfe, 0x73, 0x28, 0xde, 0x7a, 0x2c, 0x18, 0x3b, 0xf3, 0x61, 0xa2,
	0xa5, 0x10, 0x63, 0x58, 0xcc, 0xd3, 0x04, 0x60, 0x62, 0xa3, 0x21, 0x9f, 0x07, 0x8b, 0xa1, 0x1e,
	0x35, 0xcb, 0x8d, 0xe5, 0xed, 0x37, 0xa2, 0x6d, 0xad, 0x79, 0x40, 0xcd, 0x3c, 0x5b, 0x1e, 0x91,
	0x0a, 0x59, 0xc6, 0x1d, 0x3e, 0x63, 0xd5, 0x74, 0xa4, 0x7f, 0x9a, 0xd0, 0x2f, 0x26, 0x20, 0x11,
	0x6d, 0xc6, 0xb2, 0x8b, 0x5f, 0x12, 0x94, 0x36, 0x18, 0x54, 0x80, 0x23, 0x1b, 0x7f, 0xc4, 0xc6,
	0x27, 0x2c, 0x1f, 0x88, 0x82, 0x58, 0xc6, 0x60, 0xd0, 0x69, 0xcb, 0x12, 0x3a, 0x86, 0x12, 0xb1,
	0x34, 0xd3, 0x1a, 0x0e, 0x3a, 0xb8, 0xad, 0xe3, 0xae, 0x9c, 0x42, 0x32, 0x14, 0x05, 0xbf, 0x42,
	0xd2, 0xa2, 0xc3, 0xb4, 0x31, 0x16, 0x45, 0x06, 0x55, 0x40, 0xbe, 0x31, 0xb0, 0xa5, 0x63, 0xbb,
	0xb3, 0x92, 0x1c, 0x0a, 0x9f, 0x81, 0x66, 0x93, 0x35, 0x94, 0x45, 0x00, 0xd9, 0x08, 0x6a, 0xcb,
	0x47, 0x17, 0x1f, 0x20, 0xbf, 0xda, 0x0d, 0xe5, 0x20, 0xd3, 0x32, 0x0c, 0x4b, 0x3e, 0x10, 0x12,
	0xf2, 0x99, 0x58, 0x9d, 0xbe, 0x2c, 0xa1, 0x12, 0xe4, 0x35, 0xdb, 0x32, 0xfa, 0x9a, 0xa5, 0xdf,
	0xc8, 0x29, 0x41, 0xf5, 0x35, 0x6c, 0x6b, 0x3d, 0x39, 0x8d, 0x8a, 0x90, 0x6b, 0xeb, 0x44, 0x6b,
	0xf5, 0x3a, 0x6d, 0x39, 0xd3, 0xfc, 0x93, 0x82, 0x2c, 0x89, 0xa2, 0x8c, 0x6e, 0xa1, 0xbc, 0x23,
	0x8f, 0xe8, 0xe5, 0xfa, 0x86, 0xf6, 0x87, 0xb9, 0xf6, 0xea, 0x01, 0x55, 0x9c, 0x8a, 0x03, 0x64,
	0x40, 0x31, 0x19, 0x43, 0x74, 0xba, 0xf5, 0xc3, 0x36, 0x13, 0x53, 0x7b, 0xb6, 0x8f, 0x5e, 0x19,
	0xf6, 0xa0, 0x90, 0xc8, 0x1f, 0xaa, 0x27, 0x1b, 0xb6, 0x63, 0x5d, 0x3b, 0xdd, 0xc3, 0xae, 0xdc,
	0x74, 0x80, 0x75, 0x18, 0xd1, 0xc9, 0xc6, 0x56, 0x5b, 0x5e, 0xf5, 0xdd, 0xe4, 0xd2, 0xaa, 0xf5,
	0xee, 0xcb, 0xf5, 0xff, 0xbd, 0x29, 0xa3, 0x6c, 0xf4, 0xa0, 0xbc, 0xfd, 0x1b, 0x00, 0x00, 0xff,
	0xff, 0x4d, 0x70, 0x16, 0x4a, 0x9c, 0x04, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// SystemClient is the client API for System service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type SystemClient interface {
	// GetBIOSSerialNumber returns the device's serial number
	GetBIOSSerialNumber(ctx context.Context, in *GetBIOSSerialNumberRequest, opts ...grpc.CallOption) (*GetBIOSSerialNumberResponse, error)
	// StartService starts a Windows service
	// NOTE: This method affects global node state and should only be used
	//       with consideration to other CSI drivers that run concurrently.
	StartService(ctx context.Context, in *StartServiceRequest, opts ...grpc.CallOption) (*StartServiceResponse, error)
	// StopService stops a Windows service
	// NOTE: This method affects global node state and should only be used
	//       with consideration to other CSI drivers that run concurrently.
	StopService(ctx context.Context, in *StopServiceRequest, opts ...grpc.CallOption) (*StopServiceResponse, error)
	// GetService queries a Windows service state
	GetService(ctx context.Context, in *GetServiceRequest, opts ...grpc.CallOption) (*GetServiceResponse, error)
}

type systemClient struct {
	cc grpc.ClientConnInterface
}

func NewSystemClient(cc grpc.ClientConnInterface) SystemClient {
	return &systemClient{cc}
}

func (c *systemClient) GetBIOSSerialNumber(ctx context.Context, in *GetBIOSSerialNumberRequest, opts ...grpc.CallOption) (*GetBIOSSerialNumberResponse, error) {
	out := new(GetBIOSSerialNumberResponse)
	err := c.cc.Invoke(ctx, "/v1alpha1.System/GetBIOSSerialNumber", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *systemClient) StartService(ctx context.Context, in *StartServiceRequest, opts ...grpc.CallOption) (*StartServiceResponse, error) {
	out := new(StartServiceResponse)
	err := c.cc.Invoke(ctx, "/v1alpha1.System/StartService", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *systemClient) StopService(ctx context.Context, in *StopServiceRequest, opts ...grpc.CallOption) (*StopServiceResponse, error) {
	out := new(StopServiceResponse)
	err := c.cc.Invoke(ctx, "/v1alpha1.System/StopService", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *systemClient) GetService(ctx context.Context, in *GetServiceRequest, opts ...grpc.CallOption) (*GetServiceResponse, error) {
	out := new(GetServiceResponse)
	err := c.cc.Invoke(ctx, "/v1alpha1.System/GetService", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SystemServer is the server API for System service.
type SystemServer interface {
	// GetBIOSSerialNumber returns the device's serial number
	GetBIOSSerialNumber(context.Context, *GetBIOSSerialNumberRequest) (*GetBIOSSerialNumberResponse, error)
	// StartService starts a Windows service
	// NOTE: This method affects global node state and should only be used
	//       with consideration to other CSI drivers that run concurrently.
	StartService(context.Context, *StartServiceRequest) (*StartServiceResponse, error)
	// StopService stops a Windows service
	// NOTE: This method affects global node state and should only be used
	//       with consideration to other CSI drivers that run concurrently.
	StopService(context.Context, *StopServiceRequest) (*StopServiceResponse, error)
	// GetService queries a Windows service state
	GetService(context.Context, *GetServiceRequest) (*GetServiceResponse, error)
}

// UnimplementedSystemServer can be embedded to have forward compatible implementations.
type UnimplementedSystemServer struct {
}

func (*UnimplementedSystemServer) GetBIOSSerialNumber(ctx context.Context, req *GetBIOSSerialNumberRequest) (*GetBIOSSerialNumberResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetBIOSSerialNumber not implemented")
}
func (*UnimplementedSystemServer) StartService(ctx context.Context, req *StartServiceRequest) (*StartServiceResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StartService not implemented")
}
func (*UnimplementedSystemServer) StopService(ctx context.Context, req *StopServiceRequest) (*StopServiceResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StopService not implemented")
}
func (*UnimplementedSystemServer) GetService(ctx context.Context, req *GetServiceRequest) (*GetServiceResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetService not implemented")
}

func RegisterSystemServer(s *grpc.Server, srv SystemServer) {
	s.RegisterService(&_System_serviceDesc, srv)
}

func _System_GetBIOSSerialNumber_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetBIOSSerialNumberRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SystemServer).GetBIOSSerialNumber(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1alpha1.System/GetBIOSSerialNumber",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SystemServer).GetBIOSSerialNumber(ctx, req.(*GetBIOSSerialNumberRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _System_StartService_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StartServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SystemServer).StartService(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1alpha1.System/StartService",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SystemServer).StartService(ctx, req.(*StartServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _System_StopService_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StopServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SystemServer).StopService(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1alpha1.System/StopService",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SystemServer).StopService(ctx, req.(*StopServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _System_GetService_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SystemServer).GetService(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1alpha1.System/GetService",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SystemServer).GetService(ctx, req.(*GetServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _System_serviceDesc = grpc.ServiceDesc{
	ServiceName: "v1alpha1.System",
	HandlerType: (*SystemServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetBIOSSerialNumber",
			Handler:    _System_GetBIOSSerialNumber_Handler,
		},
		{
			MethodName: "StartService",
			Handler:    _System_StartService_Handler,
		},
		{
			MethodName: "StopService",
			Handler:    _System_StopService_Handler,
		},
		{
			MethodName: "GetService",
			Handler:    _System_GetService_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "github.com/kubernetes-csi/csi-proxy/client/api/system/v1alpha1/api.proto",
}
