<!-- markdownlint-disable MD034 -->
# vSphere CSI Driver - v1.0.3 release

## New Feature

- There is no new feature released in v1.0.3.  v1.0.3 is the patch release to fix some critical issues observed in [v1.0.2](v1.0.2.md) release.

## Other Notable Changes

- Idempotent create volume using in-memory map to store long-running VC tasks. [#531](https://github.com/kubernetes-sigs/vsphere-csi-driver/pull/531)
- Fixed detach/delete race. [#532](https://github.com/kubernetes-sigs/vsphere-csi-driver/pull/532)
- Fixed Metadata syncer container to prevent physical volume deletion from the datastore. [#574](https://github.com/kubernetes-sigs/vsphere-csi-driver/pull/574)
- Used empty dir for the Unix domain socket. [#532](https://github.com/kubernetes-sigs/vsphere-csi-driver/pull/532)

## Deployment files

- https://github.com/kubernetes-sigs/vsphere-csi-driver/tree/master/manifests/v1.0.3

## Kubernetes Release

- Minimum: 1.14
- Maximum: 1.16

## Supported sidecar containers versions

- csi-provisioner - v1.2.2
- csi-attacher - v1.1.1
- livenessprob - v1.1.0
- csi-node-driver-registrar - v1.1.0

## Known Issues

### vSphere CSI Driver issues

1. Deleting PV before deleting PVC, leaves orphan volume on the datastore.
   - Impact: Orphan volumes remain on the datastore, and admin needs to delete those volumes manually using `govc` command.
   - Upstream issue is tracked at: https://github.com/kubernetes-csi/external-provisioner/issues/546
   - Workaround:
     - No workaround. User should not attempt to delete PV which is bound to PVC. User should only delete a PV if they know that the underlying volume in the storage system is gone.
     - If user has accidentally left orphan volumes on the datastore by not following the guideline, and if user has captured the volume handles or First Class Disk IDs of deleted PVs, storage admin can help delete those volumes using `govc disk.rm <volume-handle/FCD ID>` command.
