// Copyright © 2021 The Knative Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package source

import (
	"github.com/maximilien/kn-source-pkg/pkg/types"
	"github.com/spf13/cobra"
)

// NewListCommand as the root group command
func NewListCommand(knSourceParams *types.KnSourceParams) *cobra.Command {
	listCmd := &cobra.Command{
		Use:     "list NAME [flags]",
		Short:   "list {{.Name}} source",
		Example: "{{.ListExample}}",
	}
	return listCmd
}
