/*
Copyright 2020 The Knative Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	"context"
	"time"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
	v1alpha1 "knative.dev/eventing/pkg/apis/configs/v1alpha1"
	scheme "knative.dev/eventing/pkg/client/clientset/versioned/scheme"
)

// ConfigMapPropagationsGetter has a method to return a ConfigMapPropagationInterface.
// A group's client should implement this interface.
type ConfigMapPropagationsGetter interface {
	ConfigMapPropagations(namespace string) ConfigMapPropagationInterface
}

// ConfigMapPropagationInterface has methods to work with ConfigMapPropagation resources.
type ConfigMapPropagationInterface interface {
	Create(ctx context.Context, configMapPropagation *v1alpha1.ConfigMapPropagation, opts v1.CreateOptions) (*v1alpha1.ConfigMapPropagation, error)
	Update(ctx context.Context, configMapPropagation *v1alpha1.ConfigMapPropagation, opts v1.UpdateOptions) (*v1alpha1.ConfigMapPropagation, error)
	UpdateStatus(ctx context.Context, configMapPropagation *v1alpha1.ConfigMapPropagation, opts v1.UpdateOptions) (*v1alpha1.ConfigMapPropagation, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1alpha1.ConfigMapPropagation, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1alpha1.ConfigMapPropagationList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.ConfigMapPropagation, err error)
	ConfigMapPropagationExpansion
}

// configMapPropagations implements ConfigMapPropagationInterface
type configMapPropagations struct {
	client rest.Interface
	ns     string
}

// newConfigMapPropagations returns a ConfigMapPropagations
func newConfigMapPropagations(c *ConfigsV1alpha1Client, namespace string) *configMapPropagations {
	return &configMapPropagations{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the configMapPropagation, and returns the corresponding configMapPropagation object, and an error if there is any.
func (c *configMapPropagations) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha1.ConfigMapPropagation, err error) {
	result = &v1alpha1.ConfigMapPropagation{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("configmappropagations").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of ConfigMapPropagations that match those selectors.
func (c *configMapPropagations) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha1.ConfigMapPropagationList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1alpha1.ConfigMapPropagationList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("configmappropagations").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested configMapPropagations.
func (c *configMapPropagations) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("configmappropagations").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a configMapPropagation and creates it.  Returns the server's representation of the configMapPropagation, and an error, if there is any.
func (c *configMapPropagations) Create(ctx context.Context, configMapPropagation *v1alpha1.ConfigMapPropagation, opts v1.CreateOptions) (result *v1alpha1.ConfigMapPropagation, err error) {
	result = &v1alpha1.ConfigMapPropagation{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("configmappropagations").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(configMapPropagation).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a configMapPropagation and updates it. Returns the server's representation of the configMapPropagation, and an error, if there is any.
func (c *configMapPropagations) Update(ctx context.Context, configMapPropagation *v1alpha1.ConfigMapPropagation, opts v1.UpdateOptions) (result *v1alpha1.ConfigMapPropagation, err error) {
	result = &v1alpha1.ConfigMapPropagation{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("configmappropagations").
		Name(configMapPropagation.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(configMapPropagation).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *configMapPropagations) UpdateStatus(ctx context.Context, configMapPropagation *v1alpha1.ConfigMapPropagation, opts v1.UpdateOptions) (result *v1alpha1.ConfigMapPropagation, err error) {
	result = &v1alpha1.ConfigMapPropagation{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("configmappropagations").
		Name(configMapPropagation.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(configMapPropagation).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the configMapPropagation and deletes it. Returns an error if one occurs.
func (c *configMapPropagations) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("configmappropagations").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *configMapPropagations) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("configmappropagations").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched configMapPropagation.
func (c *configMapPropagations) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.ConfigMapPropagation, err error) {
	result = &v1alpha1.ConfigMapPropagation{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("configmappropagations").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
