// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"

	configv1 "github.com/openshift/api/config/v1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeDNSs implements DNSInterface
type FakeDNSs struct {
	Fake *FakeConfigV1
}

var dnssResource = schema.GroupVersionResource{Group: "config.openshift.io", Version: "v1", Resource: "dnss"}

var dnssKind = schema.GroupVersionKind{Group: "config.openshift.io", Version: "v1", Kind: "DNS"}

// Get takes name of the dNS, and returns the corresponding dNS object, and an error if there is any.
func (c *FakeDNSs) Get(ctx context.Context, name string, options v1.GetOptions) (result *configv1.DNS, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootGetAction(dnssResource, name), &configv1.DNS{})
	if obj == nil {
		return nil, err
	}
	return obj.(*configv1.DNS), err
}

// List takes label and field selectors, and returns the list of DNSs that match those selectors.
func (c *FakeDNSs) List(ctx context.Context, opts v1.ListOptions) (result *configv1.DNSList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootListAction(dnssResource, dnssKind, opts), &configv1.DNSList{})
	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &configv1.DNSList{ListMeta: obj.(*configv1.DNSList).ListMeta}
	for _, item := range obj.(*configv1.DNSList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested dNSs.
func (c *FakeDNSs) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewRootWatchAction(dnssResource, opts))
}

// Create takes the representation of a dNS and creates it.  Returns the server's representation of the dNS, and an error, if there is any.
func (c *FakeDNSs) Create(ctx context.Context, dNS *configv1.DNS, opts v1.CreateOptions) (result *configv1.DNS, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootCreateAction(dnssResource, dNS), &configv1.DNS{})
	if obj == nil {
		return nil, err
	}
	return obj.(*configv1.DNS), err
}

// Update takes the representation of a dNS and updates it. Returns the server's representation of the dNS, and an error, if there is any.
func (c *FakeDNSs) Update(ctx context.Context, dNS *configv1.DNS, opts v1.UpdateOptions) (result *configv1.DNS, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootUpdateAction(dnssResource, dNS), &configv1.DNS{})
	if obj == nil {
		return nil, err
	}
	return obj.(*configv1.DNS), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeDNSs) UpdateStatus(ctx context.Context, dNS *configv1.DNS, opts v1.UpdateOptions) (*configv1.DNS, error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootUpdateSubresourceAction(dnssResource, "status", dNS), &configv1.DNS{})
	if obj == nil {
		return nil, err
	}
	return obj.(*configv1.DNS), err
}

// Delete takes name of the dNS and deletes it. Returns an error if one occurs.
func (c *FakeDNSs) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewRootDeleteAction(dnssResource, name), &configv1.DNS{})
	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeDNSs) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	action := testing.NewRootDeleteCollectionAction(dnssResource, listOpts)

	_, err := c.Fake.Invokes(action, &configv1.DNSList{})
	return err
}

// Patch applies the patch and returns the patched dNS.
func (c *FakeDNSs) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *configv1.DNS, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootPatchSubresourceAction(dnssResource, name, pt, data, subresources...), &configv1.DNS{})
	if obj == nil {
		return nil, err
	}
	return obj.(*configv1.DNS), err
}
