// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: google/api/expr/v1alpha1/checked.proto

package google_api_expr_v1alpha1

import (
	fmt "fmt"
	proto "github.com/gogo/protobuf/proto"
	types "github.com/gogo/protobuf/types"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

// CEL primitive types.
type Type_PrimitiveType int32

const (
	// Unspecified type.
	Type_PRIMITIVE_TYPE_UNSPECIFIED Type_PrimitiveType = 0
	// Boolean type.
	Type_BOOL Type_PrimitiveType = 1
	// Int64 type.
	//
	// Proto-based integer values are widened to int64.
	Type_INT64 Type_PrimitiveType = 2
	// Uint64 type.
	//
	// Proto-based unsigned integer values are widened to uint64.
	Type_UINT64 Type_PrimitiveType = 3
	// Double type.
	//
	// Proto-based float values are widened to double values.
	Type_DOUBLE Type_PrimitiveType = 4
	// String type.
	Type_STRING Type_PrimitiveType = 5
	// Bytes type.
	Type_BYTES Type_PrimitiveType = 6
)

var Type_PrimitiveType_name = map[int32]string{
	0: "PRIMITIVE_TYPE_UNSPECIFIED",
	1: "BOOL",
	2: "INT64",
	3: "UINT64",
	4: "DOUBLE",
	5: "STRING",
	6: "BYTES",
}

var Type_PrimitiveType_value = map[string]int32{
	"PRIMITIVE_TYPE_UNSPECIFIED": 0,
	"BOOL":                       1,
	"INT64":                      2,
	"UINT64":                     3,
	"DOUBLE":                     4,
	"STRING":                     5,
	"BYTES":                      6,
}

func (x Type_PrimitiveType) String() string {
	return proto.EnumName(Type_PrimitiveType_name, int32(x))
}

func (Type_PrimitiveType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_30a741de3e790389, []int{1, 0}
}

// Well-known protobuf types treated with first-class support in CEL.
type Type_WellKnownType int32

const (
	// Unspecified type.
	Type_WELL_KNOWN_TYPE_UNSPECIFIED Type_WellKnownType = 0
	// Well-known protobuf.Any type.
	//
	// Any types are a polymorphic message type. During type-checking they are
	// treated like `DYN` types, but at runtime they are resolved to a specific
	// message type specified at evaluation time.
	Type_ANY Type_WellKnownType = 1
	// Well-known protobuf.Timestamp type, internally referenced as `timestamp`.
	Type_TIMESTAMP Type_WellKnownType = 2
	// Well-known protobuf.Duration type, internally referenced as `duration`.
	Type_DURATION Type_WellKnownType = 3
)

var Type_WellKnownType_name = map[int32]string{
	0: "WELL_KNOWN_TYPE_UNSPECIFIED",
	1: "ANY",
	2: "TIMESTAMP",
	3: "DURATION",
}

var Type_WellKnownType_value = map[string]int32{
	"WELL_KNOWN_TYPE_UNSPECIFIED": 0,
	"ANY":                         1,
	"TIMESTAMP":                   2,
	"DURATION":                    3,
}

func (x Type_WellKnownType) String() string {
	return proto.EnumName(Type_WellKnownType_name, int32(x))
}

func (Type_WellKnownType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_30a741de3e790389, []int{1, 1}
}

// A CEL expression which has been successfully type checked.
type CheckedExpr struct {
	// A map from expression ids to resolved references.
	//
	// The following entries are in this table:
	//
	// - An Ident or Select expression is represented here if it resolves to a
	//   declaration. For instance, if `a.b.c` is represented by
	//   `select(select(id(a), b), c)`, and `a.b` resolves to a declaration,
	//   while `c` is a field selection, then the reference is attached to the
	//   nested select expression (but not to the id or or the outer select).
	//   In turn, if `a` resolves to a declaration and `b.c` are field selections,
	//   the reference is attached to the ident expression.
	// - Every Call expression has an entry here, identifying the function being
	//   called.
	// - Every CreateStruct expression for a message has an entry, identifying
	//   the message.
	ReferenceMap map[int64]*Reference `protobuf:"bytes,2,rep,name=reference_map,json=referenceMap,proto3" json:"reference_map,omitempty" protobuf_key:"varint,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// A map from expression ids to types.
	//
	// Every expression node which has a type different than DYN has a mapping
	// here. If an expression has type DYN, it is omitted from this map to save
	// space.
	TypeMap map[int64]*Type `protobuf:"bytes,3,rep,name=type_map,json=typeMap,proto3" json:"type_map,omitempty" protobuf_key:"varint,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The source info derived from input that generated the parsed `expr` and
	// any optimizations made during the type-checking pass.
	SourceInfo *SourceInfo `protobuf:"bytes,5,opt,name=source_info,json=sourceInfo,proto3" json:"source_info,omitempty"`
	// The checked expression. Semantically equivalent to the parsed `expr`, but
	// may have structural differences.
	Expr *Expr `protobuf:"bytes,4,opt,name=expr,proto3" json:"expr,omitempty"`
}

func (m *CheckedExpr) Reset()         { *m = CheckedExpr{} }
func (m *CheckedExpr) String() string { return proto.CompactTextString(m) }
func (*CheckedExpr) ProtoMessage()    {}
func (*CheckedExpr) Descriptor() ([]byte, []int) {
	return fileDescriptor_30a741de3e790389, []int{0}
}
func (m *CheckedExpr) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CheckedExpr) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CheckedExpr.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CheckedExpr) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CheckedExpr.Merge(m, src)
}
func (m *CheckedExpr) XXX_Size() int {
	return m.Size()
}
func (m *CheckedExpr) XXX_DiscardUnknown() {
	xxx_messageInfo_CheckedExpr.DiscardUnknown(m)
}

var xxx_messageInfo_CheckedExpr proto.InternalMessageInfo

func (m *CheckedExpr) GetReferenceMap() map[int64]*Reference {
	if m != nil {
		return m.ReferenceMap
	}
	return nil
}

func (m *CheckedExpr) GetTypeMap() map[int64]*Type {
	if m != nil {
		return m.TypeMap
	}
	return nil
}

func (m *CheckedExpr) GetSourceInfo() *SourceInfo {
	if m != nil {
		return m.SourceInfo
	}
	return nil
}

func (m *CheckedExpr) GetExpr() *Expr {
	if m != nil {
		return m.Expr
	}
	return nil
}

// Represents a CEL type.
type Type struct {
	// The kind of type.
	//
	// Types that are valid to be assigned to TypeKind:
	//	*Type_Dyn
	//	*Type_Null
	//	*Type_Primitive
	//	*Type_Wrapper
	//	*Type_WellKnown
	//	*Type_ListType_
	//	*Type_MapType_
	//	*Type_Function
	//	*Type_MessageType
	//	*Type_TypeParam
	//	*Type_Type
	//	*Type_Error
	//	*Type_AbstractType_
	TypeKind isType_TypeKind `protobuf_oneof:"type_kind"`
}

func (m *Type) Reset()         { *m = Type{} }
func (m *Type) String() string { return proto.CompactTextString(m) }
func (*Type) ProtoMessage()    {}
func (*Type) Descriptor() ([]byte, []int) {
	return fileDescriptor_30a741de3e790389, []int{1}
}
func (m *Type) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Type) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Type.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Type) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Type.Merge(m, src)
}
func (m *Type) XXX_Size() int {
	return m.Size()
}
func (m *Type) XXX_DiscardUnknown() {
	xxx_messageInfo_Type.DiscardUnknown(m)
}

var xxx_messageInfo_Type proto.InternalMessageInfo

type isType_TypeKind interface {
	isType_TypeKind()
	MarshalTo([]byte) (int, error)
	Size() int
}

type Type_Dyn struct {
	Dyn *types.Empty `protobuf:"bytes,1,opt,name=dyn,proto3,oneof"`
}
type Type_Null struct {
	Null types.NullValue `protobuf:"varint,2,opt,name=null,proto3,enum=google.protobuf.NullValue,oneof"`
}
type Type_Primitive struct {
	Primitive Type_PrimitiveType `protobuf:"varint,3,opt,name=primitive,proto3,enum=google.api.expr.v1alpha1.Type_PrimitiveType,oneof"`
}
type Type_Wrapper struct {
	Wrapper Type_PrimitiveType `protobuf:"varint,4,opt,name=wrapper,proto3,enum=google.api.expr.v1alpha1.Type_PrimitiveType,oneof"`
}
type Type_WellKnown struct {
	WellKnown Type_WellKnownType `protobuf:"varint,5,opt,name=well_known,json=wellKnown,proto3,enum=google.api.expr.v1alpha1.Type_WellKnownType,oneof"`
}
type Type_ListType_ struct {
	ListType *Type_ListType `protobuf:"bytes,6,opt,name=list_type,json=listType,proto3,oneof"`
}
type Type_MapType_ struct {
	MapType *Type_MapType `protobuf:"bytes,7,opt,name=map_type,json=mapType,proto3,oneof"`
}
type Type_Function struct {
	Function *Type_FunctionType `protobuf:"bytes,8,opt,name=function,proto3,oneof"`
}
type Type_MessageType struct {
	MessageType string `protobuf:"bytes,9,opt,name=message_type,json=messageType,proto3,oneof"`
}
type Type_TypeParam struct {
	TypeParam string `protobuf:"bytes,10,opt,name=type_param,json=typeParam,proto3,oneof"`
}
type Type_Type struct {
	Type *Type `protobuf:"bytes,11,opt,name=type,proto3,oneof"`
}
type Type_Error struct {
	Error *types.Empty `protobuf:"bytes,12,opt,name=error,proto3,oneof"`
}
type Type_AbstractType_ struct {
	AbstractType *Type_AbstractType `protobuf:"bytes,14,opt,name=abstract_type,json=abstractType,proto3,oneof"`
}

func (*Type_Dyn) isType_TypeKind()           {}
func (*Type_Null) isType_TypeKind()          {}
func (*Type_Primitive) isType_TypeKind()     {}
func (*Type_Wrapper) isType_TypeKind()       {}
func (*Type_WellKnown) isType_TypeKind()     {}
func (*Type_ListType_) isType_TypeKind()     {}
func (*Type_MapType_) isType_TypeKind()      {}
func (*Type_Function) isType_TypeKind()      {}
func (*Type_MessageType) isType_TypeKind()   {}
func (*Type_TypeParam) isType_TypeKind()     {}
func (*Type_Type) isType_TypeKind()          {}
func (*Type_Error) isType_TypeKind()         {}
func (*Type_AbstractType_) isType_TypeKind() {}

func (m *Type) GetTypeKind() isType_TypeKind {
	if m != nil {
		return m.TypeKind
	}
	return nil
}

func (m *Type) GetDyn() *types.Empty {
	if x, ok := m.GetTypeKind().(*Type_Dyn); ok {
		return x.Dyn
	}
	return nil
}

func (m *Type) GetNull() types.NullValue {
	if x, ok := m.GetTypeKind().(*Type_Null); ok {
		return x.Null
	}
	return types.NullValue_NULL_VALUE
}

func (m *Type) GetPrimitive() Type_PrimitiveType {
	if x, ok := m.GetTypeKind().(*Type_Primitive); ok {
		return x.Primitive
	}
	return Type_PRIMITIVE_TYPE_UNSPECIFIED
}

func (m *Type) GetWrapper() Type_PrimitiveType {
	if x, ok := m.GetTypeKind().(*Type_Wrapper); ok {
		return x.Wrapper
	}
	return Type_PRIMITIVE_TYPE_UNSPECIFIED
}

func (m *Type) GetWellKnown() Type_WellKnownType {
	if x, ok := m.GetTypeKind().(*Type_WellKnown); ok {
		return x.WellKnown
	}
	return Type_WELL_KNOWN_TYPE_UNSPECIFIED
}

func (m *Type) GetListType() *Type_ListType {
	if x, ok := m.GetTypeKind().(*Type_ListType_); ok {
		return x.ListType
	}
	return nil
}

func (m *Type) GetMapType() *Type_MapType {
	if x, ok := m.GetTypeKind().(*Type_MapType_); ok {
		return x.MapType
	}
	return nil
}

func (m *Type) GetFunction() *Type_FunctionType {
	if x, ok := m.GetTypeKind().(*Type_Function); ok {
		return x.Function
	}
	return nil
}

func (m *Type) GetMessageType() string {
	if x, ok := m.GetTypeKind().(*Type_MessageType); ok {
		return x.MessageType
	}
	return ""
}

func (m *Type) GetTypeParam() string {
	if x, ok := m.GetTypeKind().(*Type_TypeParam); ok {
		return x.TypeParam
	}
	return ""
}

func (m *Type) GetType() *Type {
	if x, ok := m.GetTypeKind().(*Type_Type); ok {
		return x.Type
	}
	return nil
}

func (m *Type) GetError() *types.Empty {
	if x, ok := m.GetTypeKind().(*Type_Error); ok {
		return x.Error
	}
	return nil
}

func (m *Type) GetAbstractType() *Type_AbstractType {
	if x, ok := m.GetTypeKind().(*Type_AbstractType_); ok {
		return x.AbstractType
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Type) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Type_Dyn)(nil),
		(*Type_Null)(nil),
		(*Type_Primitive)(nil),
		(*Type_Wrapper)(nil),
		(*Type_WellKnown)(nil),
		(*Type_ListType_)(nil),
		(*Type_MapType_)(nil),
		(*Type_Function)(nil),
		(*Type_MessageType)(nil),
		(*Type_TypeParam)(nil),
		(*Type_Type)(nil),
		(*Type_Error)(nil),
		(*Type_AbstractType_)(nil),
	}
}

// List type with typed elements, e.g. `list<example.proto.MyMessage>`.
type Type_ListType struct {
	// The element type.
	ElemType *Type `protobuf:"bytes,1,opt,name=elem_type,json=elemType,proto3" json:"elem_type,omitempty"`
}

func (m *Type_ListType) Reset()         { *m = Type_ListType{} }
func (m *Type_ListType) String() string { return proto.CompactTextString(m) }
func (*Type_ListType) ProtoMessage()    {}
func (*Type_ListType) Descriptor() ([]byte, []int) {
	return fileDescriptor_30a741de3e790389, []int{1, 0}
}
func (m *Type_ListType) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Type_ListType) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Type_ListType.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Type_ListType) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Type_ListType.Merge(m, src)
}
func (m *Type_ListType) XXX_Size() int {
	return m.Size()
}
func (m *Type_ListType) XXX_DiscardUnknown() {
	xxx_messageInfo_Type_ListType.DiscardUnknown(m)
}

var xxx_messageInfo_Type_ListType proto.InternalMessageInfo

func (m *Type_ListType) GetElemType() *Type {
	if m != nil {
		return m.ElemType
	}
	return nil
}

// Map type with parameterized key and value types, e.g. `map<string, int>`.
type Type_MapType struct {
	// The type of the key.
	KeyType *Type `protobuf:"bytes,1,opt,name=key_type,json=keyType,proto3" json:"key_type,omitempty"`
	// The type of the value.
	ValueType *Type `protobuf:"bytes,2,opt,name=value_type,json=valueType,proto3" json:"value_type,omitempty"`
}

func (m *Type_MapType) Reset()         { *m = Type_MapType{} }
func (m *Type_MapType) String() string { return proto.CompactTextString(m) }
func (*Type_MapType) ProtoMessage()    {}
func (*Type_MapType) Descriptor() ([]byte, []int) {
	return fileDescriptor_30a741de3e790389, []int{1, 1}
}
func (m *Type_MapType) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Type_MapType) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Type_MapType.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Type_MapType) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Type_MapType.Merge(m, src)
}
func (m *Type_MapType) XXX_Size() int {
	return m.Size()
}
func (m *Type_MapType) XXX_DiscardUnknown() {
	xxx_messageInfo_Type_MapType.DiscardUnknown(m)
}

var xxx_messageInfo_Type_MapType proto.InternalMessageInfo

func (m *Type_MapType) GetKeyType() *Type {
	if m != nil {
		return m.KeyType
	}
	return nil
}

func (m *Type_MapType) GetValueType() *Type {
	if m != nil {
		return m.ValueType
	}
	return nil
}

// Function type with result and arg types.
type Type_FunctionType struct {
	// Result type of the function.
	ResultType *Type `protobuf:"bytes,1,opt,name=result_type,json=resultType,proto3" json:"result_type,omitempty"`
	// Argument types of the function.
	ArgTypes []*Type `protobuf:"bytes,2,rep,name=arg_types,json=argTypes,proto3" json:"arg_types,omitempty"`
}

func (m *Type_FunctionType) Reset()         { *m = Type_FunctionType{} }
func (m *Type_FunctionType) String() string { return proto.CompactTextString(m) }
func (*Type_FunctionType) ProtoMessage()    {}
func (*Type_FunctionType) Descriptor() ([]byte, []int) {
	return fileDescriptor_30a741de3e790389, []int{1, 2}
}
func (m *Type_FunctionType) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Type_FunctionType) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Type_FunctionType.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Type_FunctionType) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Type_FunctionType.Merge(m, src)
}
func (m *Type_FunctionType) XXX_Size() int {
	return m.Size()
}
func (m *Type_FunctionType) XXX_DiscardUnknown() {
	xxx_messageInfo_Type_FunctionType.DiscardUnknown(m)
}

var xxx_messageInfo_Type_FunctionType proto.InternalMessageInfo

func (m *Type_FunctionType) GetResultType() *Type {
	if m != nil {
		return m.ResultType
	}
	return nil
}

func (m *Type_FunctionType) GetArgTypes() []*Type {
	if m != nil {
		return m.ArgTypes
	}
	return nil
}

// Application defined abstract type.
type Type_AbstractType struct {
	// The fully qualified name of this abstract type.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Parameter types for this abstract type.
	ParameterTypes []*Type `protobuf:"bytes,2,rep,name=parameter_types,json=parameterTypes,proto3" json:"parameter_types,omitempty"`
}

func (m *Type_AbstractType) Reset()         { *m = Type_AbstractType{} }
func (m *Type_AbstractType) String() string { return proto.CompactTextString(m) }
func (*Type_AbstractType) ProtoMessage()    {}
func (*Type_AbstractType) Descriptor() ([]byte, []int) {
	return fileDescriptor_30a741de3e790389, []int{1, 3}
}
func (m *Type_AbstractType) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Type_AbstractType) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Type_AbstractType.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Type_AbstractType) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Type_AbstractType.Merge(m, src)
}
func (m *Type_AbstractType) XXX_Size() int {
	return m.Size()
}
func (m *Type_AbstractType) XXX_DiscardUnknown() {
	xxx_messageInfo_Type_AbstractType.DiscardUnknown(m)
}

var xxx_messageInfo_Type_AbstractType proto.InternalMessageInfo

func (m *Type_AbstractType) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Type_AbstractType) GetParameterTypes() []*Type {
	if m != nil {
		return m.ParameterTypes
	}
	return nil
}

// Represents a declaration of a named value or function.
//
// A declaration is part of the contract between the expression, the agent
// evaluating that expression, and the caller requesting evaluation.
type Decl struct {
	// The fully qualified name of the declaration.
	//
	// Declarations are organized in containers and this represents the full path
	// to the declaration in its container, as in `google.api.expr.Decl`.
	//
	// Declarations used as
	// [FunctionDecl.Overload][google.api.expr.v1alpha1.Decl.FunctionDecl.Overload]
	// parameters may or may not have a name depending on whether the overload is
	// function declaration or a function definition containing a result
	// [Expr][google.api.expr.v1alpha1.Expr].
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The declaration kind.
	//
	// Types that are valid to be assigned to DeclKind:
	//	*Decl_Ident
	//	*Decl_Function
	DeclKind isDecl_DeclKind `protobuf_oneof:"decl_kind"`
}

func (m *Decl) Reset()         { *m = Decl{} }
func (m *Decl) String() string { return proto.CompactTextString(m) }
func (*Decl) ProtoMessage()    {}
func (*Decl) Descriptor() ([]byte, []int) {
	return fileDescriptor_30a741de3e790389, []int{2}
}
func (m *Decl) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Decl) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Decl.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Decl) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Decl.Merge(m, src)
}
func (m *Decl) XXX_Size() int {
	return m.Size()
}
func (m *Decl) XXX_DiscardUnknown() {
	xxx_messageInfo_Decl.DiscardUnknown(m)
}

var xxx_messageInfo_Decl proto.InternalMessageInfo

type isDecl_DeclKind interface {
	isDecl_DeclKind()
	MarshalTo([]byte) (int, error)
	Size() int
}

type Decl_Ident struct {
	Ident *Decl_IdentDecl `protobuf:"bytes,2,opt,name=ident,proto3,oneof"`
}
type Decl_Function struct {
	Function *Decl_FunctionDecl `protobuf:"bytes,3,opt,name=function,proto3,oneof"`
}

func (*Decl_Ident) isDecl_DeclKind()    {}
func (*Decl_Function) isDecl_DeclKind() {}

func (m *Decl) GetDeclKind() isDecl_DeclKind {
	if m != nil {
		return m.DeclKind
	}
	return nil
}

func (m *Decl) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Decl) GetIdent() *Decl_IdentDecl {
	if x, ok := m.GetDeclKind().(*Decl_Ident); ok {
		return x.Ident
	}
	return nil
}

func (m *Decl) GetFunction() *Decl_FunctionDecl {
	if x, ok := m.GetDeclKind().(*Decl_Function); ok {
		return x.Function
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Decl) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Decl_Ident)(nil),
		(*Decl_Function)(nil),
	}
}

// Identifier declaration which specifies its type and optional `Expr` value.
//
// An identifier without a value is a declaration that must be provided at
// evaluation time. An identifier with a value should resolve to a constant,
// but may be used in conjunction with other identifiers bound at evaluation
// time.
type Decl_IdentDecl struct {
	// Required. The type of the identifier.
	Type *Type `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	// The constant value of the identifier. If not specified, the identifier
	// must be supplied at evaluation time.
	Value *Constant `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	// Documentation string for the identifier.
	Doc string `protobuf:"bytes,3,opt,name=doc,proto3" json:"doc,omitempty"`
}

func (m *Decl_IdentDecl) Reset()         { *m = Decl_IdentDecl{} }
func (m *Decl_IdentDecl) String() string { return proto.CompactTextString(m) }
func (*Decl_IdentDecl) ProtoMessage()    {}
func (*Decl_IdentDecl) Descriptor() ([]byte, []int) {
	return fileDescriptor_30a741de3e790389, []int{2, 0}
}
func (m *Decl_IdentDecl) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Decl_IdentDecl) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Decl_IdentDecl.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Decl_IdentDecl) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Decl_IdentDecl.Merge(m, src)
}
func (m *Decl_IdentDecl) XXX_Size() int {
	return m.Size()
}
func (m *Decl_IdentDecl) XXX_DiscardUnknown() {
	xxx_messageInfo_Decl_IdentDecl.DiscardUnknown(m)
}

var xxx_messageInfo_Decl_IdentDecl proto.InternalMessageInfo

func (m *Decl_IdentDecl) GetType() *Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (m *Decl_IdentDecl) GetValue() *Constant {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *Decl_IdentDecl) GetDoc() string {
	if m != nil {
		return m.Doc
	}
	return ""
}

// Function declaration specifies one or more overloads which indicate the
// function's parameter types and return type, and may optionally specify a
// function definition in terms of CEL expressions.
//
// Functions have no observable side-effects (there may be side-effects like
// logging which are not observable from CEL).
type Decl_FunctionDecl struct {
	// Required. List of function overloads, must contain at least one overload.
	Overloads []*Decl_FunctionDecl_Overload `protobuf:"bytes,1,rep,name=overloads,proto3" json:"overloads,omitempty"`
}

func (m *Decl_FunctionDecl) Reset()         { *m = Decl_FunctionDecl{} }
func (m *Decl_FunctionDecl) String() string { return proto.CompactTextString(m) }
func (*Decl_FunctionDecl) ProtoMessage()    {}
func (*Decl_FunctionDecl) Descriptor() ([]byte, []int) {
	return fileDescriptor_30a741de3e790389, []int{2, 1}
}
func (m *Decl_FunctionDecl) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Decl_FunctionDecl) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Decl_FunctionDecl.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Decl_FunctionDecl) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Decl_FunctionDecl.Merge(m, src)
}
func (m *Decl_FunctionDecl) XXX_Size() int {
	return m.Size()
}
func (m *Decl_FunctionDecl) XXX_DiscardUnknown() {
	xxx_messageInfo_Decl_FunctionDecl.DiscardUnknown(m)
}

var xxx_messageInfo_Decl_FunctionDecl proto.InternalMessageInfo

func (m *Decl_FunctionDecl) GetOverloads() []*Decl_FunctionDecl_Overload {
	if m != nil {
		return m.Overloads
	}
	return nil
}

// An overload indicates a function's parameter types and return type, and
// may optionally include a function body described in terms of
// [Expr][google.api.expr.v1alpha1.Expr] values.
//
// Functions overloads are declared in either a function or method
// call-style. For methods, the `params[0]` is the expected type of the
// target receiver.
//
// Overloads must have non-overlapping argument types after erasure of all
// parameterized type variables (similar as type erasure in Java).
type Decl_FunctionDecl_Overload struct {
	// Required. Globally unique overload name of the function which reflects
	// the function name and argument types.
	//
	// This will be used by a [Reference][google.api.expr.v1alpha1.Reference]
	// to indicate the `overload_id` that was resolved for the function
	// `name`.
	OverloadId string `protobuf:"bytes,1,opt,name=overload_id,json=overloadId,proto3" json:"overload_id,omitempty"`
	// List of function parameter [Type][google.api.expr.v1alpha1.Type]
	// values.
	//
	// Param types are disjoint after generic type parameters have been
	// replaced with the type `DYN`. Since the `DYN` type is compatible with
	// any other type, this means that if `A` is a type parameter, the
	// function types `int<A>` and `int<int>` are not disjoint. Likewise,
	// `map<string, string>` is not disjoint from `map<K, V>`.
	//
	// When the `result_type` of a function is a generic type param, the
	// type param name also appears as the `type` of on at least one params.
	Params []*Type `protobuf:"bytes,2,rep,name=params,proto3" json:"params,omitempty"`
	// The type param names associated with the function declaration.
	//
	// For example, `function ex<K,V>(K key, map<K, V> map) : V` would yield
	// the type params of `K, V`.
	TypeParams []string `protobuf:"bytes,3,rep,name=type_params,json=typeParams,proto3" json:"type_params,omitempty"`
	// Required. The result type of the function. For example, the operator
	// `string.isEmpty()` would have `result_type` of `kind: BOOL`.
	ResultType *Type `protobuf:"bytes,4,opt,name=result_type,json=resultType,proto3" json:"result_type,omitempty"`
	// Whether the function is to be used in a method call-style `x.f(...)`
	// of a function call-style `f(x, ...)`.
	//
	// For methods, the first parameter declaration, `params[0]` is the
	// expected type of the target receiver.
	IsInstanceFunction bool `protobuf:"varint,5,opt,name=is_instance_function,json=isInstanceFunction,proto3" json:"is_instance_function,omitempty"`
	// Documentation string for the overload.
	Doc string `protobuf:"bytes,6,opt,name=doc,proto3" json:"doc,omitempty"`
}

func (m *Decl_FunctionDecl_Overload) Reset()         { *m = Decl_FunctionDecl_Overload{} }
func (m *Decl_FunctionDecl_Overload) String() string { return proto.CompactTextString(m) }
func (*Decl_FunctionDecl_Overload) ProtoMessage()    {}
func (*Decl_FunctionDecl_Overload) Descriptor() ([]byte, []int) {
	return fileDescriptor_30a741de3e790389, []int{2, 1, 0}
}
func (m *Decl_FunctionDecl_Overload) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Decl_FunctionDecl_Overload) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Decl_FunctionDecl_Overload.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Decl_FunctionDecl_Overload) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Decl_FunctionDecl_Overload.Merge(m, src)
}
func (m *Decl_FunctionDecl_Overload) XXX_Size() int {
	return m.Size()
}
func (m *Decl_FunctionDecl_Overload) XXX_DiscardUnknown() {
	xxx_messageInfo_Decl_FunctionDecl_Overload.DiscardUnknown(m)
}

var xxx_messageInfo_Decl_FunctionDecl_Overload proto.InternalMessageInfo

func (m *Decl_FunctionDecl_Overload) GetOverloadId() string {
	if m != nil {
		return m.OverloadId
	}
	return ""
}

func (m *Decl_FunctionDecl_Overload) GetParams() []*Type {
	if m != nil {
		return m.Params
	}
	return nil
}

func (m *Decl_FunctionDecl_Overload) GetTypeParams() []string {
	if m != nil {
		return m.TypeParams
	}
	return nil
}

func (m *Decl_FunctionDecl_Overload) GetResultType() *Type {
	if m != nil {
		return m.ResultType
	}
	return nil
}

func (m *Decl_FunctionDecl_Overload) GetIsInstanceFunction() bool {
	if m != nil {
		return m.IsInstanceFunction
	}
	return false
}

func (m *Decl_FunctionDecl_Overload) GetDoc() string {
	if m != nil {
		return m.Doc
	}
	return ""
}

// Describes a resolved reference to a declaration.
type Reference struct {
	// The fully qualified name of the declaration.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// For references to functions, this is a list of `Overload.overload_id`
	// values which match according to typing rules.
	//
	// If the list has more than one element, overload resolution among the
	// presented candidates must happen at runtime because of dynamic types. The
	// type checker attempts to narrow down this list as much as possible.
	//
	// Empty if this is not a reference to a
	// [Decl.FunctionDecl][google.api.expr.v1alpha1.Decl.FunctionDecl].
	OverloadId []string `protobuf:"bytes,3,rep,name=overload_id,json=overloadId,proto3" json:"overload_id,omitempty"`
	// For references to constants, this may contain the value of the
	// constant if known at compile time.
	Value *Constant `protobuf:"bytes,4,opt,name=value,proto3" json:"value,omitempty"`
}

func (m *Reference) Reset()         { *m = Reference{} }
func (m *Reference) String() string { return proto.CompactTextString(m) }
func (*Reference) ProtoMessage()    {}
func (*Reference) Descriptor() ([]byte, []int) {
	return fileDescriptor_30a741de3e790389, []int{3}
}
func (m *Reference) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Reference) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Reference.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Reference) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Reference.Merge(m, src)
}
func (m *Reference) XXX_Size() int {
	return m.Size()
}
func (m *Reference) XXX_DiscardUnknown() {
	xxx_messageInfo_Reference.DiscardUnknown(m)
}

var xxx_messageInfo_Reference proto.InternalMessageInfo

func (m *Reference) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Reference) GetOverloadId() []string {
	if m != nil {
		return m.OverloadId
	}
	return nil
}

func (m *Reference) GetValue() *Constant {
	if m != nil {
		return m.Value
	}
	return nil
}

func init() {
	proto.RegisterEnum("google.api.expr.v1alpha1.Type_PrimitiveType", Type_PrimitiveType_name, Type_PrimitiveType_value)
	proto.RegisterEnum("google.api.expr.v1alpha1.Type_WellKnownType", Type_WellKnownType_name, Type_WellKnownType_value)
	proto.RegisterType((*CheckedExpr)(nil), "google.api.expr.v1alpha1.CheckedExpr")
	proto.RegisterMapType((map[int64]*Reference)(nil), "google.api.expr.v1alpha1.CheckedExpr.ReferenceMapEntry")
	proto.RegisterMapType((map[int64]*Type)(nil), "google.api.expr.v1alpha1.CheckedExpr.TypeMapEntry")
	proto.RegisterType((*Type)(nil), "google.api.expr.v1alpha1.Type")
	proto.RegisterType((*Type_ListType)(nil), "google.api.expr.v1alpha1.Type.ListType")
	proto.RegisterType((*Type_MapType)(nil), "google.api.expr.v1alpha1.Type.MapType")
	proto.RegisterType((*Type_FunctionType)(nil), "google.api.expr.v1alpha1.Type.FunctionType")
	proto.RegisterType((*Type_AbstractType)(nil), "google.api.expr.v1alpha1.Type.AbstractType")
	proto.RegisterType((*Decl)(nil), "google.api.expr.v1alpha1.Decl")
	proto.RegisterType((*Decl_IdentDecl)(nil), "google.api.expr.v1alpha1.Decl.IdentDecl")
	proto.RegisterType((*Decl_FunctionDecl)(nil), "google.api.expr.v1alpha1.Decl.FunctionDecl")
	proto.RegisterType((*Decl_FunctionDecl_Overload)(nil), "google.api.expr.v1alpha1.Decl.FunctionDecl.Overload")
	proto.RegisterType((*Reference)(nil), "google.api.expr.v1alpha1.Reference")
}

func init() {
	proto.RegisterFile("google/api/expr/v1alpha1/checked.proto", fileDescriptor_30a741de3e790389)
}

var fileDescriptor_30a741de3e790389 = []byte{
	// 1146 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x56, 0xcf, 0x6f, 0xe3, 0x44,
	0x14, 0x8e, 0x13, 0x27, 0xb1, 0x9f, 0xd3, 0x12, 0x46, 0x08, 0x59, 0xde, 0x55, 0x5a, 0x65, 0x61,
	0xa9, 0x00, 0xb9, 0xbb, 0xa1, 0x5a, 0x76, 0x41, 0x08, 0x9a, 0xd6, 0x6d, 0xad, 0xcd, 0x2f, 0xb9,
	0x69, 0xab, 0x22, 0x24, 0x6b, 0xea, 0x4c, 0xbb, 0x56, 0x1c, 0xdb, 0xb2, 0x9d, 0xb6, 0xe1, 0xca,
	0x09, 0xc1, 0x81, 0xff, 0x85, 0x7f, 0x62, 0x8f, 0x7b, 0xe4, 0x88, 0xda, 0x3b, 0x57, 0x38, 0xa2,
	0x19, 0xdb, 0x69, 0xda, 0x6d, 0x9a, 0xe4, 0xf6, 0x3c, 0xf3, 0x7d, 0xdf, 0xbc, 0x79, 0xf3, 0xbd,
	0x19, 0xc3, 0xd3, 0x33, 0xcf, 0x3b, 0x73, 0xc8, 0x3a, 0xf6, 0xed, 0x75, 0x72, 0xe9, 0x07, 0xeb,
	0xe7, 0xcf, 0xb1, 0xe3, 0xbf, 0xc1, 0xcf, 0xd7, 0xad, 0x37, 0xc4, 0xea, 0x93, 0x9e, 0xea, 0x07,
	0x5e, 0xe4, 0x21, 0x39, 0xc6, 0xa9, 0xd8, 0xb7, 0x55, 0x8a, 0x53, 0x53, 0x9c, 0xf2, 0xe9, 0x54,
	0x85, 0x70, 0xe4, 0x46, 0xf8, 0x32, 0x16, 0x50, 0x1e, 0x25, 0x30, 0xf6, 0x75, 0x32, 0x3c, 0x5d,
	0x27, 0x03, 0x3f, 0x1a, 0x25, 0x93, 0x8f, 0xef, 0x4e, 0x86, 0x51, 0x30, 0xb4, 0xa2, 0x78, 0xb6,
	0xfa, 0x6f, 0x0e, 0xa4, 0xad, 0x38, 0x1b, 0xed, 0xd2, 0x0f, 0xd0, 0x4f, 0xb0, 0x14, 0x90, 0x53,
	0x12, 0x10, 0xd7, 0x22, 0xe6, 0x00, 0xfb, 0x72, 0x76, 0x35, 0xb7, 0x26, 0xd5, 0xbe, 0x56, 0xa7,
	0xe5, 0xa8, 0x4e, 0xb0, 0x55, 0x23, 0xa5, 0x36, 0xb1, 0xaf, 0xb9, 0x51, 0x30, 0x32, 0x4a, 0xc1,
	0xc4, 0x10, 0x6a, 0x82, 0x10, 0x8d, 0xfc, 0x58, 0x38, 0xc7, 0x84, 0x6b, 0xf3, 0x09, 0x77, 0x47,
	0xfe, 0x8d, 0x66, 0x31, 0x8a, 0xbf, 0x90, 0x06, 0x52, 0xe8, 0x0d, 0x03, 0x8b, 0x98, 0xb6, 0x7b,
	0xea, 0xc9, 0xf9, 0x55, 0x6e, 0x4d, 0xaa, 0x7d, 0x32, 0x5d, 0x71, 0x9f, 0x81, 0x75, 0xf7, 0xd4,
	0x33, 0x20, 0x1c, 0xc7, 0xa8, 0x06, 0x3c, 0xc5, 0xc9, 0x3c, 0xe3, 0x57, 0xa6, 0xf3, 0x69, 0x2a,
	0x06, 0xc3, 0x2a, 0x3d, 0xf8, 0xf0, 0xbd, 0xcd, 0xa2, 0x32, 0xe4, 0xfa, 0x64, 0x24, 0x73, 0xab,
	0xdc, 0x5a, 0xce, 0xa0, 0x21, 0x7a, 0x05, 0xf9, 0x73, 0xec, 0x0c, 0x89, 0x9c, 0x65, 0xda, 0x4f,
	0xa6, 0x6b, 0x8f, 0xd5, 0x8c, 0x98, 0xf1, 0x4d, 0xf6, 0x25, 0xa7, 0xfc, 0x08, 0xa5, 0xc9, 0x9d,
	0xdf, 0xb3, 0xc0, 0xc6, 0xed, 0x05, 0x1e, 0x48, 0x9e, 0x0a, 0x4d, 0x68, 0x57, 0xdf, 0x4a, 0xc0,
	0xd3, 0x31, 0xf4, 0x39, 0xe4, 0x7a, 0x23, 0x97, 0x89, 0x4a, 0xb5, 0x8f, 0x53, 0x81, 0xd4, 0x2e,
	0xaa, 0x46, 0xbd, 0xb4, 0x97, 0x31, 0x28, 0x08, 0x3d, 0x03, 0xde, 0x1d, 0x3a, 0x0e, 0x5b, 0x6d,
	0xb9, 0xa6, 0xbc, 0x07, 0x6e, 0x0d, 0x1d, 0xe7, 0x90, 0x2e, 0xb1, 0x97, 0x31, 0x18, 0x12, 0x35,
	0x40, 0xf4, 0x03, 0x7b, 0x60, 0x47, 0xf6, 0x39, 0x91, 0x73, 0x8c, 0xf6, 0xe5, 0xc3, 0x49, 0xaa,
	0x9d, 0x14, 0x4f, 0xbf, 0xf6, 0x32, 0xc6, 0x8d, 0x00, 0xda, 0x83, 0xe2, 0x45, 0x80, 0x7d, 0x9f,
	0xc4, 0xa7, 0xb5, 0xb8, 0x56, 0x4a, 0x47, 0x4d, 0x80, 0x0b, 0xe2, 0x38, 0x66, 0xdf, 0xf5, 0x2e,
	0x5c, 0x66, 0x9d, 0xd9, 0x62, 0x47, 0xc4, 0x71, 0x5e, 0x53, 0x7c, 0x9a, 0xd8, 0x45, 0x3a, 0x80,
	0x76, 0x40, 0x74, 0xec, 0x30, 0x32, 0xa9, 0x35, 0xe5, 0x02, 0x2b, 0xe5, 0x67, 0x33, 0xd4, 0x1a,
	0x76, 0x18, 0x25, 0x42, 0x82, 0x93, 0xc4, 0x68, 0x0b, 0x84, 0x01, 0xf6, 0x63, 0x99, 0x22, 0x93,
	0x79, 0x3a, 0x43, 0xa6, 0x89, 0xfd, 0x74, 0x6f, 0x83, 0x38, 0x44, 0x3a, 0x08, 0xa7, 0x43, 0xd7,
	0x8a, 0x6c, 0xcf, 0x95, 0x05, 0x26, 0xf2, 0xc5, 0x0c, 0x91, 0x9d, 0x04, 0x9e, 0xe6, 0x93, 0xd2,
	0xd1, 0x13, 0x28, 0x0d, 0x48, 0x18, 0xe2, 0x33, 0x12, 0xe7, 0x24, 0xae, 0x72, 0x6b, 0xe2, 0x5e,
	0xc6, 0x90, 0x92, 0x51, 0xb6, 0xde, 0x0a, 0x00, 0x6b, 0x6b, 0x1f, 0x07, 0x78, 0x20, 0x43, 0x02,
	0x11, 0xe9, 0x58, 0x87, 0x0e, 0xa1, 0x0d, 0xe0, 0x19, 0x5b, 0x9a, 0xc7, 0xa4, 0xd4, 0x3a, 0x14,
	0x8d, 0x54, 0xc8, 0x93, 0x20, 0xf0, 0x02, 0xb9, 0x34, 0xc3, 0x9a, 0x31, 0x0c, 0x19, 0xb0, 0x84,
	0x4f, 0xc2, 0x28, 0xc0, 0x56, 0x72, 0x0e, 0xcb, 0x73, 0xed, 0x7d, 0x33, 0xe1, 0x24, 0x6b, 0x97,
	0xf0, 0xc4, 0xb7, 0xb2, 0x0b, 0x42, 0x7a, 0x4e, 0xe8, 0x5b, 0x10, 0x89, 0x43, 0x06, 0xb1, 0x36,
	0x37, 0x57, 0xbf, 0x09, 0x94, 0xc0, 0x84, 0x7e, 0xe1, 0xa0, 0x98, 0x1c, 0x15, 0x7a, 0x05, 0x42,
	0x9f, 0x8c, 0x16, 0xd1, 0x29, 0xf6, 0xc9, 0x88, 0x51, 0xbf, 0x03, 0x60, 0x2d, 0x1c, 0x93, 0xe7,
	0x6b, 0x7a, 0x91, 0x31, 0x58, 0x16, 0xbf, 0x73, 0x50, 0x9a, 0x3c, 0x6b, 0xf4, 0x3d, 0x48, 0x01,
	0x09, 0x87, 0x4e, 0xb4, 0x48, 0x36, 0x10, 0x53, 0xd2, 0xa2, 0xe0, 0xe0, 0x8c, 0xb1, 0xc3, 0xe4,
	0xb1, 0x98, 0x59, 0x14, 0x1c, 0x9c, 0xd1, 0x20, 0x54, 0xfa, 0x50, 0x9a, 0xac, 0x3e, 0x42, 0xc0,
	0xbb, 0x78, 0x10, 0xa7, 0x21, 0x1a, 0x2c, 0x46, 0xbb, 0xf0, 0x01, 0xf3, 0x15, 0x89, 0x48, 0xb0,
	0xd0, 0x32, 0xcb, 0x63, 0x1a, 0x5b, 0xac, 0x1a, 0xc2, 0xd2, 0xad, 0xdb, 0x00, 0x55, 0x40, 0xe9,
	0x18, 0x7a, 0x53, 0xef, 0xea, 0x87, 0x9a, 0xd9, 0x3d, 0xee, 0x68, 0xe6, 0x41, 0x6b, 0xbf, 0xa3,
	0x6d, 0xe9, 0x3b, 0xba, 0xb6, 0x5d, 0xce, 0x20, 0x01, 0xf8, 0x7a, 0xbb, 0xdd, 0x28, 0x73, 0x48,
	0x84, 0xbc, 0xde, 0xea, 0xbe, 0xd8, 0x28, 0x67, 0x11, 0x40, 0xe1, 0x20, 0x8e, 0x73, 0x34, 0xde,
	0x6e, 0x1f, 0xd4, 0x1b, 0x5a, 0x99, 0xa7, 0xf1, 0x7e, 0xd7, 0xd0, 0x5b, 0xbb, 0xe5, 0x3c, 0x85,
	0xd7, 0x8f, 0xbb, 0xda, 0x7e, 0xb9, 0x50, 0x3d, 0x84, 0xa5, 0x5b, 0xb7, 0x06, 0x5a, 0x81, 0x47,
	0x47, 0x5a, 0xa3, 0x61, 0xbe, 0x6e, 0xb5, 0x8f, 0x5a, 0xf7, 0xad, 0x5a, 0x84, 0xdc, 0x66, 0xeb,
	0xb8, 0xcc, 0xa1, 0x25, 0x10, 0xbb, 0x7a, 0x53, 0xdb, 0xef, 0x6e, 0x36, 0x3b, 0xe5, 0x2c, 0x2a,
	0x81, 0xb0, 0x7d, 0x60, 0x6c, 0x76, 0xf5, 0x76, 0xab, 0x9c, 0xab, 0x4b, 0xc0, 0xda, 0xcb, 0xec,
	0xdb, 0x6e, 0xaf, 0xfa, 0x67, 0x1e, 0xf8, 0x6d, 0x62, 0x39, 0xf7, 0xd6, 0xef, 0x07, 0xc8, 0xdb,
	0x3d, 0xe2, 0x46, 0x89, 0x59, 0xd6, 0xa6, 0x57, 0x8d, 0x4a, 0xa8, 0x3a, 0xc5, 0xd2, 0x88, 0xf6,
	0x15, 0x23, 0xde, 0xba, 0x4e, 0x72, 0xb3, 0x5a, 0x8a, 0x89, 0xa4, 0x16, 0x4b, 0x74, 0xc6, 0x74,
	0xe5, 0x37, 0x0e, 0xc4, 0xf1, 0x0a, 0xf4, 0xe1, 0x5d, 0xc0, 0x75, 0xf1, 0xa5, 0xf0, 0xf2, 0xf6,
	0x83, 0x57, 0x7d, 0xe0, 0xff, 0xc1, 0x73, 0xc3, 0x08, 0xbb, 0x51, 0xf2, 0xe8, 0xd1, 0xc7, 0xb3,
	0xe7, 0x59, 0x6c, 0x07, 0xa2, 0x41, 0x43, 0xe5, 0x9f, 0xec, 0x4d, 0x37, 0xb0, 0x84, 0x0c, 0x10,
	0xbd, 0x73, 0x12, 0x38, 0x1e, 0xee, 0x85, 0x32, 0xc7, 0x5c, 0xb6, 0xb1, 0xc0, 0x56, 0xd5, 0x76,
	0x42, 0x36, 0x6e, 0x64, 0x94, 0x5f, 0xb3, 0x20, 0xa4, 0xe3, 0x68, 0x05, 0xa4, 0x74, 0xc6, 0xb4,
	0x7b, 0xc9, 0x39, 0x41, 0x3a, 0xa4, 0xf7, 0xd0, 0x0b, 0x28, 0x30, 0xdb, 0xce, 0x6b, 0xf2, 0x04,
	0x4d, 0x85, 0x6f, 0xae, 0xe0, 0x90, 0xfd, 0x5c, 0x89, 0x06, 0x8c, 0x6f, 0xe0, 0xf0, 0x6e, 0xa3,
	0xf3, 0x0b, 0x37, 0xfa, 0x33, 0xf8, 0xc8, 0x0e, 0x4d, 0x9b, 0xd5, 0xd4, 0x22, 0xe6, 0xd8, 0x11,
	0xf4, 0xe9, 0x14, 0x0c, 0x64, 0x87, 0x7a, 0x32, 0x95, 0x56, 0x24, 0x2d, 0x78, 0x61, 0x5c, 0x70,
	0xea, 0xda, 0x1e, 0xb1, 0x9c, 0xd8, 0xb5, 0x3f, 0x83, 0x38, 0xfe, 0xe9, 0xb9, 0xd7, 0xb9, 0x77,
	0x8a, 0x95, 0xec, 0x69, 0xa2, 0x58, 0x63, 0x2f, 0xf0, 0x0b, 0x7a, 0xa1, 0xbe, 0xf3, 0xf6, 0xaa,
	0xc2, 0xbd, 0xbb, 0xaa, 0x70, 0x7f, 0x5f, 0x55, 0xb8, 0x3f, 0xae, 0x2b, 0x99, 0x77, 0xd7, 0x95,
	0xcc, 0x5f, 0xd7, 0x95, 0x0c, 0x3c, 0xb6, 0xbc, 0xc1, 0x54, 0x9d, 0xba, 0x48, 0x8f, 0xb9, 0x43,
	0xdf, 0x9f, 0x0e, 0xf7, 0x1f, 0xc7, 0x9d, 0x14, 0xd8, 0x5b, 0xf4, 0xd5, 0xff, 0x01, 0x00, 0x00,
	0xff, 0xff, 0xe2, 0x5d, 0xaa, 0xbe, 0xeb, 0x0b, 0x00, 0x00,
}

func (m *CheckedExpr) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CheckedExpr) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CheckedExpr) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.SourceInfo != nil {
		{
			size, err := m.SourceInfo.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintChecked(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if m.Expr != nil {
		{
			size, err := m.Expr.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintChecked(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if len(m.TypeMap) > 0 {
		for k := range m.TypeMap {
			v := m.TypeMap[k]
			baseI := i
			if v != nil {
				{
					size, err := v.MarshalToSizedBuffer(dAtA[:i])
					if err != nil {
						return 0, err
					}
					i -= size
					i = encodeVarintChecked(dAtA, i, uint64(size))
				}
				i--
				dAtA[i] = 0x12
			}
			i = encodeVarintChecked(dAtA, i, uint64(k))
			i--
			dAtA[i] = 0x8
			i = encodeVarintChecked(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.ReferenceMap) > 0 {
		for k := range m.ReferenceMap {
			v := m.ReferenceMap[k]
			baseI := i
			if v != nil {
				{
					size, err := v.MarshalToSizedBuffer(dAtA[:i])
					if err != nil {
						return 0, err
					}
					i -= size
					i = encodeVarintChecked(dAtA, i, uint64(size))
				}
				i--
				dAtA[i] = 0x12
			}
			i = encodeVarintChecked(dAtA, i, uint64(k))
			i--
			dAtA[i] = 0x8
			i = encodeVarintChecked(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x12
		}
	}
	return len(dAtA) - i, nil
}

func (m *Type) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Type) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Type) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.TypeKind != nil {
		{
			size := m.TypeKind.Size()
			i -= size
			if _, err := m.TypeKind.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	return len(dAtA) - i, nil
}

func (m *Type_Dyn) MarshalTo(dAtA []byte) (int, error) {
	return m.MarshalToSizedBuffer(dAtA[:m.Size()])
}

func (m *Type_Dyn) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Dyn != nil {
		{
			size, err := m.Dyn.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintChecked(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}
func (m *Type_Null) MarshalTo(dAtA []byte) (int, error) {
	return m.MarshalToSizedBuffer(dAtA[:m.Size()])
}

func (m *Type_Null) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i = encodeVarintChecked(dAtA, i, uint64(m.Null))
	i--
	dAtA[i] = 0x10
	return len(dAtA) - i, nil
}
func (m *Type_Primitive) MarshalTo(dAtA []byte) (int, error) {
	return m.MarshalToSizedBuffer(dAtA[:m.Size()])
}

func (m *Type_Primitive) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i = encodeVarintChecked(dAtA, i, uint64(m.Primitive))
	i--
	dAtA[i] = 0x18
	return len(dAtA) - i, nil
}
func (m *Type_Wrapper) MarshalTo(dAtA []byte) (int, error) {
	return m.MarshalToSizedBuffer(dAtA[:m.Size()])
}

func (m *Type_Wrapper) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i = encodeVarintChecked(dAtA, i, uint64(m.Wrapper))
	i--
	dAtA[i] = 0x20
	return len(dAtA) - i, nil
}
func (m *Type_WellKnown) MarshalTo(dAtA []byte) (int, error) {
	return m.MarshalToSizedBuffer(dAtA[:m.Size()])
}

func (m *Type_WellKnown) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i = encodeVarintChecked(dAtA, i, uint64(m.WellKnown))
	i--
	dAtA[i] = 0x28
	return len(dAtA) - i, nil
}
func (m *Type_ListType_) MarshalTo(dAtA []byte) (int, error) {
	return m.MarshalToSizedBuffer(dAtA[:m.Size()])
}

func (m *Type_ListType_) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.ListType != nil {
		{
			size, err := m.ListType.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintChecked(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	return len(dAtA) - i, nil
}
func (m *Type_MapType_) MarshalTo(dAtA []byte) (int, error) {
	return m.MarshalToSizedBuffer(dAtA[:m.Size()])
}

func (m *Type_MapType_) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.MapType != nil {
		{
			size, err := m.MapType.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintChecked(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	return len(dAtA) - i, nil
}
func (m *Type_Function) MarshalTo(dAtA []byte) (int, error) {
	return m.MarshalToSizedBuffer(dAtA[:m.Size()])
}

func (m *Type_Function) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Function != nil {
		{
			size, err := m.Function.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintChecked(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x42
	}
	return len(dAtA) - i, nil
}
func (m *Type_MessageType) MarshalTo(dAtA []byte) (int, error) {
	return m.MarshalToSizedBuffer(dAtA[:m.Size()])
}

func (m *Type_MessageType) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i -= len(m.MessageType)
	copy(dAtA[i:], m.MessageType)
	i = encodeVarintChecked(dAtA, i, uint64(len(m.MessageType)))
	i--
	dAtA[i] = 0x4a
	return len(dAtA) - i, nil
}
func (m *Type_TypeParam) MarshalTo(dAtA []byte) (int, error) {
	return m.MarshalToSizedBuffer(dAtA[:m.Size()])
}

func (m *Type_TypeParam) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i -= len(m.TypeParam)
	copy(dAtA[i:], m.TypeParam)
	i = encodeVarintChecked(dAtA, i, uint64(len(m.TypeParam)))
	i--
	dAtA[i] = 0x52
	return len(dAtA) - i, nil
}
func (m *Type_Type) MarshalTo(dAtA []byte) (int, error) {
	return m.MarshalToSizedBuffer(dAtA[:m.Size()])
}

func (m *Type_Type) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Type != nil {
		{
			size, err := m.Type.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintChecked(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x5a
	}
	return len(dAtA) - i, nil
}
func (m *Type_Error) MarshalTo(dAtA []byte) (int, error) {
	return m.MarshalToSizedBuffer(dAtA[:m.Size()])
}

func (m *Type_Error) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Error != nil {
		{
			size, err := m.Error.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintChecked(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x62
	}
	return len(dAtA) - i, nil
}
func (m *Type_AbstractType_) MarshalTo(dAtA []byte) (int, error) {
	return m.MarshalToSizedBuffer(dAtA[:m.Size()])
}

func (m *Type_AbstractType_) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.AbstractType != nil {
		{
			size, err := m.AbstractType.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintChecked(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x72
	}
	return len(dAtA) - i, nil
}
func (m *Type_ListType) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Type_ListType) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Type_ListType) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.ElemType != nil {
		{
			size, err := m.ElemType.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintChecked(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Type_MapType) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Type_MapType) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Type_MapType) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.ValueType != nil {
		{
			size, err := m.ValueType.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintChecked(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.KeyType != nil {
		{
			size, err := m.KeyType.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintChecked(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Type_FunctionType) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Type_FunctionType) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Type_FunctionType) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.ArgTypes) > 0 {
		for iNdEx := len(m.ArgTypes) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.ArgTypes[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintChecked(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.ResultType != nil {
		{
			size, err := m.ResultType.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintChecked(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Type_AbstractType) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Type_AbstractType) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Type_AbstractType) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.ParameterTypes) > 0 {
		for iNdEx := len(m.ParameterTypes) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.ParameterTypes[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintChecked(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintChecked(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Decl) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Decl) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Decl) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.DeclKind != nil {
		{
			size := m.DeclKind.Size()
			i -= size
			if _, err := m.DeclKind.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintChecked(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Decl_Ident) MarshalTo(dAtA []byte) (int, error) {
	return m.MarshalToSizedBuffer(dAtA[:m.Size()])
}

func (m *Decl_Ident) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Ident != nil {
		{
			size, err := m.Ident.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintChecked(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	return len(dAtA) - i, nil
}
func (m *Decl_Function) MarshalTo(dAtA []byte) (int, error) {
	return m.MarshalToSizedBuffer(dAtA[:m.Size()])
}

func (m *Decl_Function) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Function != nil {
		{
			size, err := m.Function.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintChecked(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	return len(dAtA) - i, nil
}
func (m *Decl_IdentDecl) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Decl_IdentDecl) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Decl_IdentDecl) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Doc) > 0 {
		i -= len(m.Doc)
		copy(dAtA[i:], m.Doc)
		i = encodeVarintChecked(dAtA, i, uint64(len(m.Doc)))
		i--
		dAtA[i] = 0x1a
	}
	if m.Value != nil {
		{
			size, err := m.Value.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintChecked(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Type != nil {
		{
			size, err := m.Type.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintChecked(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Decl_FunctionDecl) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Decl_FunctionDecl) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Decl_FunctionDecl) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Overloads) > 0 {
		for iNdEx := len(m.Overloads) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Overloads[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintChecked(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *Decl_FunctionDecl_Overload) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Decl_FunctionDecl_Overload) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Decl_FunctionDecl_Overload) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Doc) > 0 {
		i -= len(m.Doc)
		copy(dAtA[i:], m.Doc)
		i = encodeVarintChecked(dAtA, i, uint64(len(m.Doc)))
		i--
		dAtA[i] = 0x32
	}
	if m.IsInstanceFunction {
		i--
		if m.IsInstanceFunction {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x28
	}
	if m.ResultType != nil {
		{
			size, err := m.ResultType.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintChecked(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if len(m.TypeParams) > 0 {
		for iNdEx := len(m.TypeParams) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.TypeParams[iNdEx])
			copy(dAtA[i:], m.TypeParams[iNdEx])
			i = encodeVarintChecked(dAtA, i, uint64(len(m.TypeParams[iNdEx])))
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.Params) > 0 {
		for iNdEx := len(m.Params) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Params[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintChecked(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.OverloadId) > 0 {
		i -= len(m.OverloadId)
		copy(dAtA[i:], m.OverloadId)
		i = encodeVarintChecked(dAtA, i, uint64(len(m.OverloadId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Reference) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Reference) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Reference) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Value != nil {
		{
			size, err := m.Value.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintChecked(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if len(m.OverloadId) > 0 {
		for iNdEx := len(m.OverloadId) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.OverloadId[iNdEx])
			copy(dAtA[i:], m.OverloadId[iNdEx])
			i = encodeVarintChecked(dAtA, i, uint64(len(m.OverloadId[iNdEx])))
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintChecked(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintChecked(dAtA []byte, offset int, v uint64) int {
	offset -= sovChecked(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *CheckedExpr) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.ReferenceMap) > 0 {
		for k, v := range m.ReferenceMap {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovChecked(uint64(l))
			}
			mapEntrySize := 1 + sovChecked(uint64(k)) + l
			n += mapEntrySize + 1 + sovChecked(uint64(mapEntrySize))
		}
	}
	if len(m.TypeMap) > 0 {
		for k, v := range m.TypeMap {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovChecked(uint64(l))
			}
			mapEntrySize := 1 + sovChecked(uint64(k)) + l
			n += mapEntrySize + 1 + sovChecked(uint64(mapEntrySize))
		}
	}
	if m.Expr != nil {
		l = m.Expr.Size()
		n += 1 + l + sovChecked(uint64(l))
	}
	if m.SourceInfo != nil {
		l = m.SourceInfo.Size()
		n += 1 + l + sovChecked(uint64(l))
	}
	return n
}

func (m *Type) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.TypeKind != nil {
		n += m.TypeKind.Size()
	}
	return n
}

func (m *Type_Dyn) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Dyn != nil {
		l = m.Dyn.Size()
		n += 1 + l + sovChecked(uint64(l))
	}
	return n
}
func (m *Type_Null) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 1 + sovChecked(uint64(m.Null))
	return n
}
func (m *Type_Primitive) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 1 + sovChecked(uint64(m.Primitive))
	return n
}
func (m *Type_Wrapper) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 1 + sovChecked(uint64(m.Wrapper))
	return n
}
func (m *Type_WellKnown) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 1 + sovChecked(uint64(m.WellKnown))
	return n
}
func (m *Type_ListType_) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ListType != nil {
		l = m.ListType.Size()
		n += 1 + l + sovChecked(uint64(l))
	}
	return n
}
func (m *Type_MapType_) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.MapType != nil {
		l = m.MapType.Size()
		n += 1 + l + sovChecked(uint64(l))
	}
	return n
}
func (m *Type_Function) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Function != nil {
		l = m.Function.Size()
		n += 1 + l + sovChecked(uint64(l))
	}
	return n
}
func (m *Type_MessageType) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.MessageType)
	n += 1 + l + sovChecked(uint64(l))
	return n
}
func (m *Type_TypeParam) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.TypeParam)
	n += 1 + l + sovChecked(uint64(l))
	return n
}
func (m *Type_Type) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Type != nil {
		l = m.Type.Size()
		n += 1 + l + sovChecked(uint64(l))
	}
	return n
}
func (m *Type_Error) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Error != nil {
		l = m.Error.Size()
		n += 1 + l + sovChecked(uint64(l))
	}
	return n
}
func (m *Type_AbstractType_) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.AbstractType != nil {
		l = m.AbstractType.Size()
		n += 1 + l + sovChecked(uint64(l))
	}
	return n
}
func (m *Type_ListType) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ElemType != nil {
		l = m.ElemType.Size()
		n += 1 + l + sovChecked(uint64(l))
	}
	return n
}

func (m *Type_MapType) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.KeyType != nil {
		l = m.KeyType.Size()
		n += 1 + l + sovChecked(uint64(l))
	}
	if m.ValueType != nil {
		l = m.ValueType.Size()
		n += 1 + l + sovChecked(uint64(l))
	}
	return n
}

func (m *Type_FunctionType) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ResultType != nil {
		l = m.ResultType.Size()
		n += 1 + l + sovChecked(uint64(l))
	}
	if len(m.ArgTypes) > 0 {
		for _, e := range m.ArgTypes {
			l = e.Size()
			n += 1 + l + sovChecked(uint64(l))
		}
	}
	return n
}

func (m *Type_AbstractType) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovChecked(uint64(l))
	}
	if len(m.ParameterTypes) > 0 {
		for _, e := range m.ParameterTypes {
			l = e.Size()
			n += 1 + l + sovChecked(uint64(l))
		}
	}
	return n
}

func (m *Decl) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovChecked(uint64(l))
	}
	if m.DeclKind != nil {
		n += m.DeclKind.Size()
	}
	return n
}

func (m *Decl_Ident) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Ident != nil {
		l = m.Ident.Size()
		n += 1 + l + sovChecked(uint64(l))
	}
	return n
}
func (m *Decl_Function) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Function != nil {
		l = m.Function.Size()
		n += 1 + l + sovChecked(uint64(l))
	}
	return n
}
func (m *Decl_IdentDecl) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Type != nil {
		l = m.Type.Size()
		n += 1 + l + sovChecked(uint64(l))
	}
	if m.Value != nil {
		l = m.Value.Size()
		n += 1 + l + sovChecked(uint64(l))
	}
	l = len(m.Doc)
	if l > 0 {
		n += 1 + l + sovChecked(uint64(l))
	}
	return n
}

func (m *Decl_FunctionDecl) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Overloads) > 0 {
		for _, e := range m.Overloads {
			l = e.Size()
			n += 1 + l + sovChecked(uint64(l))
		}
	}
	return n
}

func (m *Decl_FunctionDecl_Overload) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.OverloadId)
	if l > 0 {
		n += 1 + l + sovChecked(uint64(l))
	}
	if len(m.Params) > 0 {
		for _, e := range m.Params {
			l = e.Size()
			n += 1 + l + sovChecked(uint64(l))
		}
	}
	if len(m.TypeParams) > 0 {
		for _, s := range m.TypeParams {
			l = len(s)
			n += 1 + l + sovChecked(uint64(l))
		}
	}
	if m.ResultType != nil {
		l = m.ResultType.Size()
		n += 1 + l + sovChecked(uint64(l))
	}
	if m.IsInstanceFunction {
		n += 2
	}
	l = len(m.Doc)
	if l > 0 {
		n += 1 + l + sovChecked(uint64(l))
	}
	return n
}

func (m *Reference) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovChecked(uint64(l))
	}
	if len(m.OverloadId) > 0 {
		for _, s := range m.OverloadId {
			l = len(s)
			n += 1 + l + sovChecked(uint64(l))
		}
	}
	if m.Value != nil {
		l = m.Value.Size()
		n += 1 + l + sovChecked(uint64(l))
	}
	return n
}

func sovChecked(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozChecked(x uint64) (n int) {
	return sovChecked(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *CheckedExpr) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowChecked
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CheckedExpr: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CheckedExpr: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReferenceMap", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecked
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthChecked
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthChecked
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ReferenceMap == nil {
				m.ReferenceMap = make(map[int64]*Reference)
			}
			var mapkey int64
			var mapvalue *Reference
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowChecked
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowChecked
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapkey |= int64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowChecked
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthChecked
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthChecked
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &Reference{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipChecked(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthChecked
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.ReferenceMap[mapkey] = mapvalue
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TypeMap", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecked
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthChecked
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthChecked
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TypeMap == nil {
				m.TypeMap = make(map[int64]*Type)
			}
			var mapkey int64
			var mapvalue *Type
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowChecked
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowChecked
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapkey |= int64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowChecked
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthChecked
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthChecked
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &Type{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipChecked(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthChecked
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.TypeMap[mapkey] = mapvalue
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Expr", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecked
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthChecked
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthChecked
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Expr == nil {
				m.Expr = &Expr{}
			}
			if err := m.Expr.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecked
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthChecked
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthChecked
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SourceInfo == nil {
				m.SourceInfo = &SourceInfo{}
			}
			if err := m.SourceInfo.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipChecked(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthChecked
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthChecked
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Type) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowChecked
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Type: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Type: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Dyn", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecked
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthChecked
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthChecked
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &types.Empty{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.TypeKind = &Type_Dyn{v}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Null", wireType)
			}
			var v types.NullValue
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecked
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= types.NullValue(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.TypeKind = &Type_Null{v}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Primitive", wireType)
			}
			var v Type_PrimitiveType
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecked
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= Type_PrimitiveType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.TypeKind = &Type_Primitive{v}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Wrapper", wireType)
			}
			var v Type_PrimitiveType
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecked
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= Type_PrimitiveType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.TypeKind = &Type_Wrapper{v}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field WellKnown", wireType)
			}
			var v Type_WellKnownType
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecked
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= Type_WellKnownType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.TypeKind = &Type_WellKnown{v}
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ListType", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecked
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthChecked
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthChecked
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Type_ListType{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.TypeKind = &Type_ListType_{v}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MapType", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecked
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthChecked
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthChecked
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Type_MapType{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.TypeKind = &Type_MapType_{v}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Function", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecked
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthChecked
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthChecked
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Type_FunctionType{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.TypeKind = &Type_Function{v}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MessageType", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecked
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthChecked
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthChecked
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TypeKind = &Type_MessageType{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TypeParam", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecked
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthChecked
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthChecked
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TypeKind = &Type_TypeParam{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecked
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthChecked
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthChecked
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Type{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.TypeKind = &Type_Type{v}
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecked
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthChecked
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthChecked
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &types.Empty{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.TypeKind = &Type_Error{v}
			iNdEx = postIndex
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AbstractType", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecked
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthChecked
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthChecked
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Type_AbstractType{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.TypeKind = &Type_AbstractType_{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipChecked(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthChecked
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthChecked
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Type_ListType) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowChecked
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListType: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListType: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ElemType", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecked
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthChecked
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthChecked
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ElemType == nil {
				m.ElemType = &Type{}
			}
			if err := m.ElemType.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipChecked(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthChecked
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthChecked
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Type_MapType) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowChecked
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MapType: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MapType: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field KeyType", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecked
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthChecked
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthChecked
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.KeyType == nil {
				m.KeyType = &Type{}
			}
			if err := m.KeyType.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ValueType", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecked
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthChecked
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthChecked
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ValueType == nil {
				m.ValueType = &Type{}
			}
			if err := m.ValueType.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipChecked(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthChecked
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthChecked
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Type_FunctionType) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowChecked
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: FunctionType: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: FunctionType: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResultType", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecked
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthChecked
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthChecked
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ResultType == nil {
				m.ResultType = &Type{}
			}
			if err := m.ResultType.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ArgTypes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecked
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthChecked
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthChecked
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ArgTypes = append(m.ArgTypes, &Type{})
			if err := m.ArgTypes[len(m.ArgTypes)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipChecked(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthChecked
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthChecked
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Type_AbstractType) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowChecked
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AbstractType: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AbstractType: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecked
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthChecked
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthChecked
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ParameterTypes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecked
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthChecked
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthChecked
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ParameterTypes = append(m.ParameterTypes, &Type{})
			if err := m.ParameterTypes[len(m.ParameterTypes)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipChecked(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthChecked
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthChecked
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Decl) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowChecked
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Decl: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Decl: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecked
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthChecked
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthChecked
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ident", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecked
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthChecked
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthChecked
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Decl_IdentDecl{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.DeclKind = &Decl_Ident{v}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Function", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecked
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthChecked
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthChecked
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Decl_FunctionDecl{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.DeclKind = &Decl_Function{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipChecked(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthChecked
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthChecked
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Decl_IdentDecl) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowChecked
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: IdentDecl: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: IdentDecl: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecked
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthChecked
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthChecked
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Type == nil {
				m.Type = &Type{}
			}
			if err := m.Type.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecked
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthChecked
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthChecked
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Value == nil {
				m.Value = &Constant{}
			}
			if err := m.Value.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Doc", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecked
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthChecked
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthChecked
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Doc = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipChecked(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthChecked
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthChecked
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Decl_FunctionDecl) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowChecked
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: FunctionDecl: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: FunctionDecl: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Overloads", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecked
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthChecked
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthChecked
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Overloads = append(m.Overloads, &Decl_FunctionDecl_Overload{})
			if err := m.Overloads[len(m.Overloads)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipChecked(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthChecked
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthChecked
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Decl_FunctionDecl_Overload) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowChecked
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Overload: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Overload: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OverloadId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecked
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthChecked
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthChecked
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OverloadId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Params", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecked
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthChecked
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthChecked
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Params = append(m.Params, &Type{})
			if err := m.Params[len(m.Params)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TypeParams", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecked
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthChecked
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthChecked
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TypeParams = append(m.TypeParams, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResultType", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecked
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthChecked
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthChecked
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ResultType == nil {
				m.ResultType = &Type{}
			}
			if err := m.ResultType.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsInstanceFunction", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecked
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsInstanceFunction = bool(v != 0)
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Doc", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecked
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthChecked
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthChecked
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Doc = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipChecked(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthChecked
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthChecked
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Reference) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowChecked
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Reference: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Reference: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecked
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthChecked
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthChecked
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OverloadId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecked
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthChecked
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthChecked
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OverloadId = append(m.OverloadId, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecked
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthChecked
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthChecked
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Value == nil {
				m.Value = &Constant{}
			}
			if err := m.Value.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipChecked(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthChecked
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthChecked
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipChecked(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowChecked
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowChecked
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowChecked
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthChecked
			}
			iNdEx += length
			if iNdEx < 0 {
				return 0, ErrInvalidLengthChecked
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowChecked
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipChecked(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
				if iNdEx < 0 {
					return 0, ErrInvalidLengthChecked
				}
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthChecked = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowChecked   = fmt.Errorf("proto: integer overflow")
)
