// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: google/api/expr/v1alpha1/conformance_service.proto

package google_api_expr_v1alpha1

import (
	context "context"
	fmt "fmt"
	proto "github.com/gogo/protobuf/proto"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	io "io"
	rpc "istio.io/gogo-genproto/googleapis/google/rpc"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

// Severities of issues.
type IssueDetails_Severity int32

const (
	// An unspecified severity.
	IssueDetails_SEVERITY_UNSPECIFIED IssueDetails_Severity = 0
	// Deprecation issue for statements and method that may no longer be
	// supported or maintained.
	IssueDetails_DEPRECATION IssueDetails_Severity = 1
	// Warnings such as: unused variables.
	IssueDetails_WARNING IssueDetails_Severity = 2
	// Errors such as: unmatched curly braces or variable redefinition.
	IssueDetails_ERROR IssueDetails_Severity = 3
)

var IssueDetails_Severity_name = map[int32]string{
	0: "SEVERITY_UNSPECIFIED",
	1: "DEPRECATION",
	2: "WARNING",
	3: "ERROR",
}

var IssueDetails_Severity_value = map[string]int32{
	"SEVERITY_UNSPECIFIED": 0,
	"DEPRECATION":          1,
	"WARNING":              2,
	"ERROR":                3,
}

func (x IssueDetails_Severity) String() string {
	return proto.EnumName(IssueDetails_Severity_name, int32(x))
}

func (IssueDetails_Severity) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_b3ca1183e6ceae83, []int{6, 0}
}

// Request message for the Parse method.
type ParseRequest struct {
	// Required. Source text in CEL syntax.
	CelSource string `protobuf:"bytes,1,opt,name=cel_source,json=celSource,proto3" json:"cel_source,omitempty"`
	// Tag for version of CEL syntax, for future use.
	SyntaxVersion string `protobuf:"bytes,2,opt,name=syntax_version,json=syntaxVersion,proto3" json:"syntax_version,omitempty"`
	// File or resource for source text, used in
	// [SourceInfo][google.api.expr.v1alpha1.SourceInfo].
	SourceLocation string `protobuf:"bytes,3,opt,name=source_location,json=sourceLocation,proto3" json:"source_location,omitempty"`
	// Prevent macro expansion.  See "Macros" in Language Defiinition.
	DisableMacros bool `protobuf:"varint,4,opt,name=disable_macros,json=disableMacros,proto3" json:"disable_macros,omitempty"`
}

func (m *ParseRequest) Reset()         { *m = ParseRequest{} }
func (m *ParseRequest) String() string { return proto.CompactTextString(m) }
func (*ParseRequest) ProtoMessage()    {}
func (*ParseRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b3ca1183e6ceae83, []int{0}
}
func (m *ParseRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ParseRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ParseRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ParseRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ParseRequest.Merge(m, src)
}
func (m *ParseRequest) XXX_Size() int {
	return m.Size()
}
func (m *ParseRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ParseRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ParseRequest proto.InternalMessageInfo

func (m *ParseRequest) GetCelSource() string {
	if m != nil {
		return m.CelSource
	}
	return ""
}

func (m *ParseRequest) GetSyntaxVersion() string {
	if m != nil {
		return m.SyntaxVersion
	}
	return ""
}

func (m *ParseRequest) GetSourceLocation() string {
	if m != nil {
		return m.SourceLocation
	}
	return ""
}

func (m *ParseRequest) GetDisableMacros() bool {
	if m != nil {
		return m.DisableMacros
	}
	return false
}

// Response message for the Parse method.
type ParseResponse struct {
	// The parsed representation, or unset if parsing failed.
	ParsedExpr *ParsedExpr `protobuf:"bytes,1,opt,name=parsed_expr,json=parsedExpr,proto3" json:"parsed_expr,omitempty"`
	// Any number of issues with [StatusDetails][] as the details.
	Issues []*rpc.Status `protobuf:"bytes,2,rep,name=issues,proto3" json:"issues,omitempty"`
}

func (m *ParseResponse) Reset()         { *m = ParseResponse{} }
func (m *ParseResponse) String() string { return proto.CompactTextString(m) }
func (*ParseResponse) ProtoMessage()    {}
func (*ParseResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_b3ca1183e6ceae83, []int{1}
}
func (m *ParseResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ParseResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ParseResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ParseResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ParseResponse.Merge(m, src)
}
func (m *ParseResponse) XXX_Size() int {
	return m.Size()
}
func (m *ParseResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ParseResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ParseResponse proto.InternalMessageInfo

func (m *ParseResponse) GetParsedExpr() *ParsedExpr {
	if m != nil {
		return m.ParsedExpr
	}
	return nil
}

func (m *ParseResponse) GetIssues() []*rpc.Status {
	if m != nil {
		return m.Issues
	}
	return nil
}

// Request message for the Check method.
type CheckRequest struct {
	// Required. The parsed representation of the CEL program.
	ParsedExpr *ParsedExpr `protobuf:"bytes,1,opt,name=parsed_expr,json=parsedExpr,proto3" json:"parsed_expr,omitempty"`
	// Declarations of types for external variables and functions.
	// Required if program uses external variables or functions
	// not in the default environment.
	TypeEnv []*Decl `protobuf:"bytes,2,rep,name=type_env,json=typeEnv,proto3" json:"type_env,omitempty"`
	// The protocol buffer context.  See "Name Resolution" in the
	// Language Definition.
	Container string `protobuf:"bytes,3,opt,name=container,proto3" json:"container,omitempty"`
	// If true, use only the declarations in
	// [type_env][google.api.expr.v1alpha1.CheckRequest.type_env].  If false
	// (default), add declarations for the standard definitions to the type
	// environment.  See "Standard Definitions" in the Language Definition.
	NoStdEnv bool `protobuf:"varint,4,opt,name=no_std_env,json=noStdEnv,proto3" json:"no_std_env,omitempty"`
}

func (m *CheckRequest) Reset()         { *m = CheckRequest{} }
func (m *CheckRequest) String() string { return proto.CompactTextString(m) }
func (*CheckRequest) ProtoMessage()    {}
func (*CheckRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b3ca1183e6ceae83, []int{2}
}
func (m *CheckRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CheckRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CheckRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CheckRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CheckRequest.Merge(m, src)
}
func (m *CheckRequest) XXX_Size() int {
	return m.Size()
}
func (m *CheckRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CheckRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CheckRequest proto.InternalMessageInfo

func (m *CheckRequest) GetParsedExpr() *ParsedExpr {
	if m != nil {
		return m.ParsedExpr
	}
	return nil
}

func (m *CheckRequest) GetTypeEnv() []*Decl {
	if m != nil {
		return m.TypeEnv
	}
	return nil
}

func (m *CheckRequest) GetContainer() string {
	if m != nil {
		return m.Container
	}
	return ""
}

func (m *CheckRequest) GetNoStdEnv() bool {
	if m != nil {
		return m.NoStdEnv
	}
	return false
}

// Response message for the Check method.
type CheckResponse struct {
	// The annotated representation, or unset if checking failed.
	CheckedExpr *CheckedExpr `protobuf:"bytes,1,opt,name=checked_expr,json=checkedExpr,proto3" json:"checked_expr,omitempty"`
	// Any number of issues with [StatusDetails][] as the details.
	Issues []*rpc.Status `protobuf:"bytes,2,rep,name=issues,proto3" json:"issues,omitempty"`
}

func (m *CheckResponse) Reset()         { *m = CheckResponse{} }
func (m *CheckResponse) String() string { return proto.CompactTextString(m) }
func (*CheckResponse) ProtoMessage()    {}
func (*CheckResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_b3ca1183e6ceae83, []int{3}
}
func (m *CheckResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CheckResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CheckResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CheckResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CheckResponse.Merge(m, src)
}
func (m *CheckResponse) XXX_Size() int {
	return m.Size()
}
func (m *CheckResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CheckResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CheckResponse proto.InternalMessageInfo

func (m *CheckResponse) GetCheckedExpr() *CheckedExpr {
	if m != nil {
		return m.CheckedExpr
	}
	return nil
}

func (m *CheckResponse) GetIssues() []*rpc.Status {
	if m != nil {
		return m.Issues
	}
	return nil
}

// Request message for the Eval method.
type EvalRequest struct {
	// Required. Either the parsed or annotated representation of the CEL program.
	//
	// Types that are valid to be assigned to ExprKind:
	//	*EvalRequest_ParsedExpr
	//	*EvalRequest_CheckedExpr
	ExprKind isEvalRequest_ExprKind `protobuf_oneof:"expr_kind"`
	// Bindings for the external variables.  The types SHOULD be compatible
	// with the type environment in
	// [CheckRequest][google.api.expr.v1alpha1.CheckRequest], if checked.
	Bindings map[string]*ExprValue `protobuf:"bytes,3,rep,name=bindings,proto3" json:"bindings,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// SHOULD be the same container as used in
	// [CheckRequest][google.api.expr.v1alpha1.CheckRequest], if checked.
	Container string `protobuf:"bytes,4,opt,name=container,proto3" json:"container,omitempty"`
}

func (m *EvalRequest) Reset()         { *m = EvalRequest{} }
func (m *EvalRequest) String() string { return proto.CompactTextString(m) }
func (*EvalRequest) ProtoMessage()    {}
func (*EvalRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b3ca1183e6ceae83, []int{4}
}
func (m *EvalRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *EvalRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_EvalRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *EvalRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EvalRequest.Merge(m, src)
}
func (m *EvalRequest) XXX_Size() int {
	return m.Size()
}
func (m *EvalRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_EvalRequest.DiscardUnknown(m)
}

var xxx_messageInfo_EvalRequest proto.InternalMessageInfo

type isEvalRequest_ExprKind interface {
	isEvalRequest_ExprKind()
	MarshalTo([]byte) (int, error)
	Size() int
}

type EvalRequest_ParsedExpr struct {
	ParsedExpr *ParsedExpr `protobuf:"bytes,1,opt,name=parsed_expr,json=parsedExpr,proto3,oneof"`
}
type EvalRequest_CheckedExpr struct {
	CheckedExpr *CheckedExpr `protobuf:"bytes,2,opt,name=checked_expr,json=checkedExpr,proto3,oneof"`
}

func (*EvalRequest_ParsedExpr) isEvalRequest_ExprKind()  {}
func (*EvalRequest_CheckedExpr) isEvalRequest_ExprKind() {}

func (m *EvalRequest) GetExprKind() isEvalRequest_ExprKind {
	if m != nil {
		return m.ExprKind
	}
	return nil
}

func (m *EvalRequest) GetParsedExpr() *ParsedExpr {
	if x, ok := m.GetExprKind().(*EvalRequest_ParsedExpr); ok {
		return x.ParsedExpr
	}
	return nil
}

func (m *EvalRequest) GetCheckedExpr() *CheckedExpr {
	if x, ok := m.GetExprKind().(*EvalRequest_CheckedExpr); ok {
		return x.CheckedExpr
	}
	return nil
}

func (m *EvalRequest) GetBindings() map[string]*ExprValue {
	if m != nil {
		return m.Bindings
	}
	return nil
}

func (m *EvalRequest) GetContainer() string {
	if m != nil {
		return m.Container
	}
	return ""
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*EvalRequest) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*EvalRequest_ParsedExpr)(nil),
		(*EvalRequest_CheckedExpr)(nil),
	}
}

// Response message for the Eval method.
type EvalResponse struct {
	// The execution result, or unset if execution couldn't start.
	Result *ExprValue `protobuf:"bytes,1,opt,name=result,proto3" json:"result,omitempty"`
	// Any number of issues with [StatusDetails][] as the details.
	// Note that CEL execution errors are reified into
	// [ExprValue][google.api.expr.v1alpha1.ExprValue]. Nevertheless, we'll allow
	// out-of-band issues to be raised, which also makes the replies more regular.
	Issues []*rpc.Status `protobuf:"bytes,2,rep,name=issues,proto3" json:"issues,omitempty"`
}

func (m *EvalResponse) Reset()         { *m = EvalResponse{} }
func (m *EvalResponse) String() string { return proto.CompactTextString(m) }
func (*EvalResponse) ProtoMessage()    {}
func (*EvalResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_b3ca1183e6ceae83, []int{5}
}
func (m *EvalResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *EvalResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_EvalResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *EvalResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EvalResponse.Merge(m, src)
}
func (m *EvalResponse) XXX_Size() int {
	return m.Size()
}
func (m *EvalResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_EvalResponse.DiscardUnknown(m)
}

var xxx_messageInfo_EvalResponse proto.InternalMessageInfo

func (m *EvalResponse) GetResult() *ExprValue {
	if m != nil {
		return m.Result
	}
	return nil
}

func (m *EvalResponse) GetIssues() []*rpc.Status {
	if m != nil {
		return m.Issues
	}
	return nil
}

// Warnings or errors in service execution are represented by
// [google.rpc.Status][google.rpc.Status] messages, with the following message
// in the details field.
type IssueDetails struct {
	// The severity of the issue.
	Severity IssueDetails_Severity `protobuf:"varint,1,opt,name=severity,proto3,enum=google.api.expr.v1alpha1.IssueDetails_Severity" json:"severity,omitempty"`
	// Position in the source, if known.
	Position *SourcePosition `protobuf:"bytes,2,opt,name=position,proto3" json:"position,omitempty"`
	// Expression ID from [Expr][google.api.expr.v1alpha1.Expr], 0 if unknown.
	Id int64 `protobuf:"varint,3,opt,name=id,proto3" json:"id,omitempty"`
}

func (m *IssueDetails) Reset()         { *m = IssueDetails{} }
func (m *IssueDetails) String() string { return proto.CompactTextString(m) }
func (*IssueDetails) ProtoMessage()    {}
func (*IssueDetails) Descriptor() ([]byte, []int) {
	return fileDescriptor_b3ca1183e6ceae83, []int{6}
}
func (m *IssueDetails) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *IssueDetails) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_IssueDetails.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *IssueDetails) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IssueDetails.Merge(m, src)
}
func (m *IssueDetails) XXX_Size() int {
	return m.Size()
}
func (m *IssueDetails) XXX_DiscardUnknown() {
	xxx_messageInfo_IssueDetails.DiscardUnknown(m)
}

var xxx_messageInfo_IssueDetails proto.InternalMessageInfo

func (m *IssueDetails) GetSeverity() IssueDetails_Severity {
	if m != nil {
		return m.Severity
	}
	return IssueDetails_SEVERITY_UNSPECIFIED
}

func (m *IssueDetails) GetPosition() *SourcePosition {
	if m != nil {
		return m.Position
	}
	return nil
}

func (m *IssueDetails) GetId() int64 {
	if m != nil {
		return m.Id
	}
	return 0
}

func init() {
	proto.RegisterEnum("google.api.expr.v1alpha1.IssueDetails_Severity", IssueDetails_Severity_name, IssueDetails_Severity_value)
	proto.RegisterType((*ParseRequest)(nil), "google.api.expr.v1alpha1.ParseRequest")
	proto.RegisterType((*ParseResponse)(nil), "google.api.expr.v1alpha1.ParseResponse")
	proto.RegisterType((*CheckRequest)(nil), "google.api.expr.v1alpha1.CheckRequest")
	proto.RegisterType((*CheckResponse)(nil), "google.api.expr.v1alpha1.CheckResponse")
	proto.RegisterType((*EvalRequest)(nil), "google.api.expr.v1alpha1.EvalRequest")
	proto.RegisterMapType((map[string]*ExprValue)(nil), "google.api.expr.v1alpha1.EvalRequest.BindingsEntry")
	proto.RegisterType((*EvalResponse)(nil), "google.api.expr.v1alpha1.EvalResponse")
	proto.RegisterType((*IssueDetails)(nil), "google.api.expr.v1alpha1.IssueDetails")
}

func init() {
	proto.RegisterFile("google/api/expr/v1alpha1/conformance_service.proto", fileDescriptor_b3ca1183e6ceae83)
}

var fileDescriptor_b3ca1183e6ceae83 = []byte{
	// 812 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x55, 0xcf, 0x6f, 0xe3, 0x44,
	0x18, 0xb5, 0x9d, 0xb6, 0x9b, 0x7c, 0x4e, 0xba, 0xd1, 0x08, 0x69, 0xa3, 0xa8, 0x44, 0x95, 0x97,
	0x76, 0x2b, 0x0e, 0x8e, 0x36, 0x7b, 0x61, 0xe1, 0xb4, 0x4d, 0xcc, 0x36, 0xc0, 0xb6, 0xd1, 0xa4,
	0x74, 0x05, 0x17, 0x33, 0xb5, 0x87, 0xae, 0x55, 0x77, 0xc6, 0xcc, 0x38, 0x26, 0xb9, 0x21, 0x24,
	0xee, 0xfc, 0x11, 0xf0, 0xbf, 0x70, 0xe0, 0xb0, 0x47, 0x8e, 0xa8, 0xfd, 0x27, 0x38, 0x22, 0x7b,
	0x26, 0x69, 0xb2, 0xc8, 0xfd, 0x81, 0xf6, 0x36, 0xf9, 0xf2, 0xde, 0xf3, 0xf7, 0xde, 0x7c, 0x33,
	0x03, 0xbd, 0x33, 0xce, 0xcf, 0x62, 0xda, 0x25, 0x49, 0xd4, 0xa5, 0xd3, 0x44, 0x74, 0xb3, 0xa7,
	0x24, 0x4e, 0xde, 0x90, 0xa7, 0xdd, 0x80, 0xb3, 0xef, 0xb9, 0xb8, 0x20, 0x2c, 0xa0, 0xbe, 0xa4,
	0x22, 0x8b, 0x02, 0xea, 0x26, 0x82, 0xa7, 0x1c, 0xb5, 0x14, 0xc7, 0x25, 0x49, 0xe4, 0xe6, 0x1c,
	0x77, 0xce, 0x69, 0xef, 0x96, 0xab, 0xbd, 0xa1, 0xc1, 0x39, 0x0d, 0x95, 0x42, 0xfb, 0x71, 0x29,
	0x8e, 0x66, 0x24, 0xd6, 0xa0, 0x9d, 0x52, 0x90, 0x9c, 0xb1, 0x94, 0x4c, 0x35, 0xec, 0x91, 0x86,
	0x89, 0x24, 0xe8, 0xca, 0x94, 0xa4, 0x13, 0xa9, 0xfe, 0x70, 0x7e, 0x33, 0xa1, 0x3e, 0x22, 0x42,
	0x52, 0x4c, 0x7f, 0x98, 0x50, 0x99, 0xa2, 0x0f, 0x01, 0x02, 0x1a, 0xfb, 0x92, 0x4f, 0x44, 0x40,
	0x5b, 0xe6, 0xb6, 0xb9, 0x57, 0xc3, 0xb5, 0x80, 0xc6, 0xe3, 0xa2, 0x80, 0x76, 0x60, 0x53, 0x09,
	0xfb, 0x19, 0x15, 0x32, 0xe2, 0xac, 0x65, 0x15, 0x90, 0x86, 0xaa, 0x9e, 0xa8, 0x22, 0x7a, 0x02,
	0x0f, 0x95, 0x82, 0x1f, 0xf3, 0x80, 0xa4, 0x39, 0xae, 0x52, 0xe0, 0x36, 0x55, 0xf9, 0x2b, 0x5d,
	0xcd, 0xf5, 0xc2, 0x48, 0x92, 0xd3, 0x98, 0xfa, 0x17, 0x24, 0x10, 0x5c, 0xb6, 0xd6, 0xb6, 0xcd,
	0xbd, 0x2a, 0x6e, 0xe8, 0xea, 0xab, 0xa2, 0xe8, 0xfc, 0x6c, 0x42, 0x43, 0xb7, 0x29, 0x13, 0xce,
	0x24, 0x45, 0x1e, 0xd8, 0x49, 0x5e, 0x08, 0xfd, 0xdc, 0x76, 0xd1, 0xa8, 0xdd, 0xfb, 0xc8, 0x2d,
	0x4b, 0xdd, 0x2d, 0xd8, 0xa1, 0x37, 0x4d, 0x04, 0x86, 0x64, 0xb1, 0x46, 0x1f, 0xc3, 0x46, 0x24,
	0xe5, 0x84, 0xca, 0x96, 0xb5, 0x5d, 0xd9, 0xb3, 0x7b, 0x68, 0xae, 0x20, 0x92, 0xc0, 0x1d, 0x17,
	0x49, 0x61, 0x8d, 0x70, 0xfe, 0x34, 0xa1, 0xde, 0xcf, 0xb7, 0x68, 0x9e, 0xd5, 0x7b, 0xea, 0xe1,
	0x39, 0x54, 0xd3, 0x59, 0x42, 0x7d, 0xca, 0x32, 0xdd, 0x45, 0xa7, 0x5c, 0x63, 0x40, 0x83, 0x18,
	0x3f, 0xc8, 0xf1, 0x1e, 0xcb, 0xd0, 0x16, 0xd4, 0x02, 0xce, 0x52, 0x12, 0x31, 0x2a, 0x74, 0xc2,
	0xd7, 0x05, 0xb4, 0x05, 0xc0, 0xb8, 0x2f, 0xd3, 0xb0, 0x90, 0x56, 0xc1, 0x56, 0x19, 0x1f, 0xa7,
	0xa1, 0xc7, 0x32, 0xe7, 0x17, 0x13, 0x1a, 0xda, 0x8e, 0xce, 0xf4, 0x00, 0xea, 0x7a, 0x04, 0x97,
	0x0d, 0xed, 0x94, 0x37, 0xd3, 0x57, 0xe8, 0xc2, 0x91, 0x1d, 0x5c, 0xff, 0xb8, 0x57, 0xac, 0x3f,
	0x55, 0xc0, 0xf6, 0x32, 0x12, 0xcf, 0x53, 0x7d, 0xf9, 0xbf, 0x53, 0x3d, 0x30, 0x56, 0x72, 0xfd,
	0xe2, 0x1d, 0x3b, 0xd6, 0x3d, 0xec, 0x1c, 0x18, 0xab, 0x86, 0x8e, 0xa0, 0x7a, 0x1a, 0xb1, 0x30,
	0x62, 0x67, 0xb2, 0x55, 0x29, 0x2c, 0x3d, 0x2b, 0xd7, 0x59, 0x72, 0xe3, 0xee, 0x6b, 0x96, 0xc7,
	0x52, 0x31, 0xc3, 0x0b, 0x91, 0xd5, 0x9d, 0x5b, 0x7b, 0x67, 0xe7, 0xda, 0xdf, 0x41, 0x63, 0x85,
	0x88, 0x9a, 0x50, 0x39, 0xa7, 0x33, 0x7d, 0x1e, 0xf3, 0x25, 0x7a, 0x0e, 0xeb, 0x19, 0x89, 0x27,
	0x54, 0xdb, 0x7a, 0x7c, 0x43, 0x3b, 0xd3, 0x44, 0x9c, 0xe4, 0x50, 0xac, 0x18, 0x9f, 0x5a, 0x9f,
	0x98, 0xfb, 0x36, 0xd4, 0x72, 0x94, 0x7f, 0x1e, 0xb1, 0xd0, 0xf9, 0x11, 0xea, 0xaa, 0x67, 0x3d,
	0x08, 0x9f, 0xc1, 0x86, 0xa0, 0x72, 0x12, 0xa7, 0x3a, 0xfd, 0x3b, 0x89, 0x6b, 0xca, 0xfd, 0xf6,
	0xde, 0x82, 0xfa, 0x30, 0x5f, 0x0e, 0x68, 0x4a, 0xa2, 0x58, 0xa2, 0x2f, 0xa1, 0x2a, 0x69, 0x46,
	0x45, 0x94, 0x2a, 0xb3, 0x9b, 0xbd, 0x6e, 0xf9, 0xb7, 0x97, 0x99, 0xee, 0x58, 0xd3, 0xf0, 0x42,
	0x00, 0x0d, 0xa0, 0x9a, 0x70, 0x19, 0xa5, 0xf3, 0x6b, 0xca, 0xee, 0xed, 0x95, 0x8b, 0xa9, 0x0b,
	0x6e, 0xa4, 0xf1, 0x78, 0xc1, 0x44, 0x9b, 0x60, 0x45, 0x61, 0x71, 0xb8, 0x2a, 0xd8, 0x8a, 0x42,
	0xe7, 0x15, 0x54, 0xe7, 0xdf, 0x42, 0x2d, 0xf8, 0x60, 0xec, 0x9d, 0x78, 0x78, 0x78, 0xfc, 0x8d,
	0xff, 0xf5, 0xe1, 0x78, 0xe4, 0xf5, 0x87, 0x9f, 0x0f, 0xbd, 0x41, 0xd3, 0x40, 0x0f, 0xc1, 0x1e,
	0x78, 0x23, 0xec, 0xf5, 0x5f, 0x1c, 0x0f, 0x8f, 0x0e, 0x9b, 0x26, 0xb2, 0xe1, 0xc1, 0xeb, 0x17,
	0xf8, 0x70, 0x78, 0xf8, 0xb2, 0x69, 0xa1, 0x1a, 0xac, 0x7b, 0x18, 0x1f, 0xe1, 0x66, 0xa5, 0xf7,
	0xbb, 0x05, 0xa8, 0x7f, 0xfd, 0x8c, 0x8c, 0xd5, 0x2b, 0x82, 0xbe, 0x85, 0xf5, 0x62, 0xb0, 0xd1,
	0xee, 0x2d, 0x93, 0xaf, 0x07, 0xad, 0xfd, 0xe4, 0x56, 0x9c, 0xda, 0x5c, 0xc7, 0xc8, 0xb5, 0x8b,
	0x51, 0xbf, 0x49, 0x7b, 0xf9, 0xa2, 0xbb, 0x49, 0x7b, 0xe5, 0x06, 0x71, 0x0c, 0xf4, 0x1a, 0xd6,
	0xf2, 0x51, 0x42, 0x3b, 0x77, 0x3a, 0x1e, 0xed, 0xdd, 0xdb, 0x60, 0x73, 0xe1, 0xfd, 0xe3, 0x3f,
	0x2e, 0x3b, 0xe6, 0xdb, 0xcb, 0x8e, 0xf9, 0xf7, 0x65, 0xc7, 0xfc, 0xf5, 0xaa, 0x63, 0xbc, 0xbd,
	0xea, 0x18, 0x7f, 0x5d, 0x75, 0x0c, 0xd8, 0x0a, 0xf8, 0x45, 0xa9, 0xcc, 0xfe, 0xa3, 0xff, 0x86,
	0x3b, 0xca, 0x9f, 0xbe, 0x91, 0xf9, 0x8f, 0x69, 0x9e, 0x6e, 0x14, 0xcf, 0xe0, 0xb3, 0x7f, 0x03,
	0x00, 0x00, 0xff, 0xff, 0x86, 0x2a, 0xe6, 0x52, 0xe3, 0x07, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// ConformanceServiceClient is the client API for ConformanceService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ConformanceServiceClient interface {
	// Transforms CEL source text into a parsed representation.
	Parse(ctx context.Context, in *ParseRequest, opts ...grpc.CallOption) (*ParseResponse, error)
	// Runs static checks on a parsed CEL representation and return
	// an annotated representation, or a set of issues.
	Check(ctx context.Context, in *CheckRequest, opts ...grpc.CallOption) (*CheckResponse, error)
	// Evaluates a parsed or annotation CEL representation given
	// values of external bindings.
	Eval(ctx context.Context, in *EvalRequest, opts ...grpc.CallOption) (*EvalResponse, error)
}

type conformanceServiceClient struct {
	cc *grpc.ClientConn
}

func NewConformanceServiceClient(cc *grpc.ClientConn) ConformanceServiceClient {
	return &conformanceServiceClient{cc}
}

func (c *conformanceServiceClient) Parse(ctx context.Context, in *ParseRequest, opts ...grpc.CallOption) (*ParseResponse, error) {
	out := new(ParseResponse)
	err := c.cc.Invoke(ctx, "/google.api.expr.v1alpha1.ConformanceService/Parse", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conformanceServiceClient) Check(ctx context.Context, in *CheckRequest, opts ...grpc.CallOption) (*CheckResponse, error) {
	out := new(CheckResponse)
	err := c.cc.Invoke(ctx, "/google.api.expr.v1alpha1.ConformanceService/Check", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conformanceServiceClient) Eval(ctx context.Context, in *EvalRequest, opts ...grpc.CallOption) (*EvalResponse, error) {
	out := new(EvalResponse)
	err := c.cc.Invoke(ctx, "/google.api.expr.v1alpha1.ConformanceService/Eval", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ConformanceServiceServer is the server API for ConformanceService service.
type ConformanceServiceServer interface {
	// Transforms CEL source text into a parsed representation.
	Parse(context.Context, *ParseRequest) (*ParseResponse, error)
	// Runs static checks on a parsed CEL representation and return
	// an annotated representation, or a set of issues.
	Check(context.Context, *CheckRequest) (*CheckResponse, error)
	// Evaluates a parsed or annotation CEL representation given
	// values of external bindings.
	Eval(context.Context, *EvalRequest) (*EvalResponse, error)
}

// UnimplementedConformanceServiceServer can be embedded to have forward compatible implementations.
type UnimplementedConformanceServiceServer struct {
}

func (*UnimplementedConformanceServiceServer) Parse(ctx context.Context, req *ParseRequest) (*ParseResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Parse not implemented")
}
func (*UnimplementedConformanceServiceServer) Check(ctx context.Context, req *CheckRequest) (*CheckResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Check not implemented")
}
func (*UnimplementedConformanceServiceServer) Eval(ctx context.Context, req *EvalRequest) (*EvalResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Eval not implemented")
}

func RegisterConformanceServiceServer(s *grpc.Server, srv ConformanceServiceServer) {
	s.RegisterService(&_ConformanceService_serviceDesc, srv)
}

func _ConformanceService_Parse_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ParseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConformanceServiceServer).Parse(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.expr.v1alpha1.ConformanceService/Parse",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConformanceServiceServer).Parse(ctx, req.(*ParseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConformanceService_Check_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CheckRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConformanceServiceServer).Check(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.expr.v1alpha1.ConformanceService/Check",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConformanceServiceServer).Check(ctx, req.(*CheckRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConformanceService_Eval_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(EvalRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConformanceServiceServer).Eval(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.expr.v1alpha1.ConformanceService/Eval",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConformanceServiceServer).Eval(ctx, req.(*EvalRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ConformanceService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.api.expr.v1alpha1.ConformanceService",
	HandlerType: (*ConformanceServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Parse",
			Handler:    _ConformanceService_Parse_Handler,
		},
		{
			MethodName: "Check",
			Handler:    _ConformanceService_Check_Handler,
		},
		{
			MethodName: "Eval",
			Handler:    _ConformanceService_Eval_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/api/expr/v1alpha1/conformance_service.proto",
}

func (m *ParseRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ParseRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ParseRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.DisableMacros {
		i--
		if m.DisableMacros {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x20
	}
	if len(m.SourceLocation) > 0 {
		i -= len(m.SourceLocation)
		copy(dAtA[i:], m.SourceLocation)
		i = encodeVarintConformanceService(dAtA, i, uint64(len(m.SourceLocation)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.SyntaxVersion) > 0 {
		i -= len(m.SyntaxVersion)
		copy(dAtA[i:], m.SyntaxVersion)
		i = encodeVarintConformanceService(dAtA, i, uint64(len(m.SyntaxVersion)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.CelSource) > 0 {
		i -= len(m.CelSource)
		copy(dAtA[i:], m.CelSource)
		i = encodeVarintConformanceService(dAtA, i, uint64(len(m.CelSource)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ParseResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ParseResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ParseResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Issues) > 0 {
		for iNdEx := len(m.Issues) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Issues[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintConformanceService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.ParsedExpr != nil {
		{
			size, err := m.ParsedExpr.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintConformanceService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CheckRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CheckRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CheckRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.NoStdEnv {
		i--
		if m.NoStdEnv {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x20
	}
	if len(m.Container) > 0 {
		i -= len(m.Container)
		copy(dAtA[i:], m.Container)
		i = encodeVarintConformanceService(dAtA, i, uint64(len(m.Container)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.TypeEnv) > 0 {
		for iNdEx := len(m.TypeEnv) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.TypeEnv[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintConformanceService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.ParsedExpr != nil {
		{
			size, err := m.ParsedExpr.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintConformanceService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CheckResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CheckResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CheckResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Issues) > 0 {
		for iNdEx := len(m.Issues) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Issues[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintConformanceService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.CheckedExpr != nil {
		{
			size, err := m.CheckedExpr.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintConformanceService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *EvalRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EvalRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *EvalRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Container) > 0 {
		i -= len(m.Container)
		copy(dAtA[i:], m.Container)
		i = encodeVarintConformanceService(dAtA, i, uint64(len(m.Container)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Bindings) > 0 {
		for k := range m.Bindings {
			v := m.Bindings[k]
			baseI := i
			if v != nil {
				{
					size, err := v.MarshalToSizedBuffer(dAtA[:i])
					if err != nil {
						return 0, err
					}
					i -= size
					i = encodeVarintConformanceService(dAtA, i, uint64(size))
				}
				i--
				dAtA[i] = 0x12
			}
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintConformanceService(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintConformanceService(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x1a
		}
	}
	if m.ExprKind != nil {
		{
			size := m.ExprKind.Size()
			i -= size
			if _, err := m.ExprKind.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	return len(dAtA) - i, nil
}

func (m *EvalRequest_ParsedExpr) MarshalTo(dAtA []byte) (int, error) {
	return m.MarshalToSizedBuffer(dAtA[:m.Size()])
}

func (m *EvalRequest_ParsedExpr) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.ParsedExpr != nil {
		{
			size, err := m.ParsedExpr.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintConformanceService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}
func (m *EvalRequest_CheckedExpr) MarshalTo(dAtA []byte) (int, error) {
	return m.MarshalToSizedBuffer(dAtA[:m.Size()])
}

func (m *EvalRequest_CheckedExpr) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.CheckedExpr != nil {
		{
			size, err := m.CheckedExpr.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintConformanceService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	return len(dAtA) - i, nil
}
func (m *EvalResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EvalResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *EvalResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Issues) > 0 {
		for iNdEx := len(m.Issues) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Issues[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintConformanceService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.Result != nil {
		{
			size, err := m.Result.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintConformanceService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *IssueDetails) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *IssueDetails) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *IssueDetails) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Id != 0 {
		i = encodeVarintConformanceService(dAtA, i, uint64(m.Id))
		i--
		dAtA[i] = 0x18
	}
	if m.Position != nil {
		{
			size, err := m.Position.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintConformanceService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Severity != 0 {
		i = encodeVarintConformanceService(dAtA, i, uint64(m.Severity))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func encodeVarintConformanceService(dAtA []byte, offset int, v uint64) int {
	offset -= sovConformanceService(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *ParseRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.CelSource)
	if l > 0 {
		n += 1 + l + sovConformanceService(uint64(l))
	}
	l = len(m.SyntaxVersion)
	if l > 0 {
		n += 1 + l + sovConformanceService(uint64(l))
	}
	l = len(m.SourceLocation)
	if l > 0 {
		n += 1 + l + sovConformanceService(uint64(l))
	}
	if m.DisableMacros {
		n += 2
	}
	return n
}

func (m *ParseResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ParsedExpr != nil {
		l = m.ParsedExpr.Size()
		n += 1 + l + sovConformanceService(uint64(l))
	}
	if len(m.Issues) > 0 {
		for _, e := range m.Issues {
			l = e.Size()
			n += 1 + l + sovConformanceService(uint64(l))
		}
	}
	return n
}

func (m *CheckRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ParsedExpr != nil {
		l = m.ParsedExpr.Size()
		n += 1 + l + sovConformanceService(uint64(l))
	}
	if len(m.TypeEnv) > 0 {
		for _, e := range m.TypeEnv {
			l = e.Size()
			n += 1 + l + sovConformanceService(uint64(l))
		}
	}
	l = len(m.Container)
	if l > 0 {
		n += 1 + l + sovConformanceService(uint64(l))
	}
	if m.NoStdEnv {
		n += 2
	}
	return n
}

func (m *CheckResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.CheckedExpr != nil {
		l = m.CheckedExpr.Size()
		n += 1 + l + sovConformanceService(uint64(l))
	}
	if len(m.Issues) > 0 {
		for _, e := range m.Issues {
			l = e.Size()
			n += 1 + l + sovConformanceService(uint64(l))
		}
	}
	return n
}

func (m *EvalRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ExprKind != nil {
		n += m.ExprKind.Size()
	}
	if len(m.Bindings) > 0 {
		for k, v := range m.Bindings {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovConformanceService(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovConformanceService(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovConformanceService(uint64(mapEntrySize))
		}
	}
	l = len(m.Container)
	if l > 0 {
		n += 1 + l + sovConformanceService(uint64(l))
	}
	return n
}

func (m *EvalRequest_ParsedExpr) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ParsedExpr != nil {
		l = m.ParsedExpr.Size()
		n += 1 + l + sovConformanceService(uint64(l))
	}
	return n
}
func (m *EvalRequest_CheckedExpr) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.CheckedExpr != nil {
		l = m.CheckedExpr.Size()
		n += 1 + l + sovConformanceService(uint64(l))
	}
	return n
}
func (m *EvalResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Result != nil {
		l = m.Result.Size()
		n += 1 + l + sovConformanceService(uint64(l))
	}
	if len(m.Issues) > 0 {
		for _, e := range m.Issues {
			l = e.Size()
			n += 1 + l + sovConformanceService(uint64(l))
		}
	}
	return n
}

func (m *IssueDetails) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Severity != 0 {
		n += 1 + sovConformanceService(uint64(m.Severity))
	}
	if m.Position != nil {
		l = m.Position.Size()
		n += 1 + l + sovConformanceService(uint64(l))
	}
	if m.Id != 0 {
		n += 1 + sovConformanceService(uint64(m.Id))
	}
	return n
}

func sovConformanceService(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozConformanceService(x uint64) (n int) {
	return sovConformanceService(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *ParseRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConformanceService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ParseRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ParseRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CelSource", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConformanceService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConformanceService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConformanceService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CelSource = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SyntaxVersion", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConformanceService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConformanceService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConformanceService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SyntaxVersion = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceLocation", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConformanceService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConformanceService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConformanceService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SourceLocation = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DisableMacros", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConformanceService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.DisableMacros = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipConformanceService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthConformanceService
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthConformanceService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ParseResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConformanceService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ParseResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ParseResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ParsedExpr", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConformanceService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConformanceService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConformanceService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ParsedExpr == nil {
				m.ParsedExpr = &ParsedExpr{}
			}
			if err := m.ParsedExpr.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Issues", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConformanceService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConformanceService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConformanceService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Issues = append(m.Issues, &rpc.Status{})
			if err := m.Issues[len(m.Issues)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipConformanceService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthConformanceService
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthConformanceService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CheckRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConformanceService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CheckRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CheckRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ParsedExpr", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConformanceService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConformanceService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConformanceService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ParsedExpr == nil {
				m.ParsedExpr = &ParsedExpr{}
			}
			if err := m.ParsedExpr.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TypeEnv", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConformanceService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConformanceService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConformanceService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TypeEnv = append(m.TypeEnv, &Decl{})
			if err := m.TypeEnv[len(m.TypeEnv)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Container", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConformanceService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConformanceService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConformanceService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Container = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NoStdEnv", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConformanceService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.NoStdEnv = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipConformanceService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthConformanceService
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthConformanceService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CheckResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConformanceService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CheckResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CheckResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CheckedExpr", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConformanceService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConformanceService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConformanceService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CheckedExpr == nil {
				m.CheckedExpr = &CheckedExpr{}
			}
			if err := m.CheckedExpr.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Issues", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConformanceService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConformanceService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConformanceService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Issues = append(m.Issues, &rpc.Status{})
			if err := m.Issues[len(m.Issues)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipConformanceService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthConformanceService
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthConformanceService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EvalRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConformanceService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: EvalRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: EvalRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ParsedExpr", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConformanceService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConformanceService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConformanceService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ParsedExpr{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.ExprKind = &EvalRequest_ParsedExpr{v}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CheckedExpr", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConformanceService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConformanceService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConformanceService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &CheckedExpr{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.ExprKind = &EvalRequest_CheckedExpr{v}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Bindings", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConformanceService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConformanceService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConformanceService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Bindings == nil {
				m.Bindings = make(map[string]*ExprValue)
			}
			var mapkey string
			var mapvalue *ExprValue
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowConformanceService
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConformanceService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthConformanceService
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthConformanceService
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConformanceService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthConformanceService
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthConformanceService
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &ExprValue{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipConformanceService(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthConformanceService
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Bindings[mapkey] = mapvalue
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Container", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConformanceService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConformanceService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConformanceService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Container = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipConformanceService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthConformanceService
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthConformanceService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EvalResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConformanceService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: EvalResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: EvalResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Result", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConformanceService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConformanceService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConformanceService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Result == nil {
				m.Result = &ExprValue{}
			}
			if err := m.Result.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Issues", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConformanceService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConformanceService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConformanceService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Issues = append(m.Issues, &rpc.Status{})
			if err := m.Issues[len(m.Issues)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipConformanceService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthConformanceService
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthConformanceService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *IssueDetails) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConformanceService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: IssueDetails: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: IssueDetails: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Severity", wireType)
			}
			m.Severity = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConformanceService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Severity |= IssueDetails_Severity(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Position", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConformanceService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConformanceService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConformanceService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Position == nil {
				m.Position = &SourcePosition{}
			}
			if err := m.Position.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			m.Id = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConformanceService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Id |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipConformanceService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthConformanceService
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthConformanceService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipConformanceService(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowConformanceService
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowConformanceService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowConformanceService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthConformanceService
			}
			iNdEx += length
			if iNdEx < 0 {
				return 0, ErrInvalidLengthConformanceService
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowConformanceService
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipConformanceService(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
				if iNdEx < 0 {
					return 0, ErrInvalidLengthConformanceService
				}
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthConformanceService = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowConformanceService   = fmt.Errorf("proto: integer overflow")
)
