// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: google/api/expr/v1alpha1/syntax.proto

package google_api_expr_v1alpha1

import (
	encoding_binary "encoding/binary"
	fmt "fmt"
	proto "github.com/gogo/protobuf/proto"
	types "github.com/gogo/protobuf/types"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

// An expression together with source information as returned by the parser.
type ParsedExpr struct {
	// The parsed expression.
	Expr *Expr `protobuf:"bytes,2,opt,name=expr,proto3" json:"expr,omitempty"`
	// The source info derived from input that generated the parsed `expr`.
	SourceInfo *SourceInfo `protobuf:"bytes,3,opt,name=source_info,json=sourceInfo,proto3" json:"source_info,omitempty"`
}

func (m *ParsedExpr) Reset()         { *m = ParsedExpr{} }
func (m *ParsedExpr) String() string { return proto.CompactTextString(m) }
func (*ParsedExpr) ProtoMessage()    {}
func (*ParsedExpr) Descriptor() ([]byte, []int) {
	return fileDescriptor_d4e2be48009c83cb, []int{0}
}
func (m *ParsedExpr) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ParsedExpr) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ParsedExpr.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ParsedExpr) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ParsedExpr.Merge(m, src)
}
func (m *ParsedExpr) XXX_Size() int {
	return m.Size()
}
func (m *ParsedExpr) XXX_DiscardUnknown() {
	xxx_messageInfo_ParsedExpr.DiscardUnknown(m)
}

var xxx_messageInfo_ParsedExpr proto.InternalMessageInfo

func (m *ParsedExpr) GetExpr() *Expr {
	if m != nil {
		return m.Expr
	}
	return nil
}

func (m *ParsedExpr) GetSourceInfo() *SourceInfo {
	if m != nil {
		return m.SourceInfo
	}
	return nil
}

// An abstract representation of a common expression.
//
// Expressions are abstractly represented as a collection of identifiers,
// select statements, function calls, literals, and comprehensions. All
// operators with the exception of the '.' operator are modelled as function
// calls. This makes it easy to represent new operators into the existing AST.
//
// All references within expressions must resolve to a
// [Decl][google.api.expr.v1alpha1.Decl] provided at type-check for an
// expression to be valid. A reference may either be a bare identifier `name` or
// a qualified identifier `google.api.name`. References may either refer to a
// value or a function declaration.
//
// For example, the expression `google.api.name.startsWith('expr')` references
// the declaration `google.api.name` within a
// [Expr.Select][google.api.expr.v1alpha1.Expr.Select] expression, and the
// function declaration `startsWith`.
type Expr struct {
	// Required. An id assigned to this node by the parser which is unique in a
	// given expression tree. This is used to associate type information and other
	// attributes to a node in the parse tree.
	Id int64 `protobuf:"varint,2,opt,name=id,proto3" json:"id,omitempty"`
	// Required. Variants of expressions.
	//
	// Types that are valid to be assigned to ExprKind:
	//	*Expr_ConstExpr
	//	*Expr_IdentExpr
	//	*Expr_SelectExpr
	//	*Expr_CallExpr
	//	*Expr_ListExpr
	//	*Expr_StructExpr
	//	*Expr_ComprehensionExpr
	ExprKind isExpr_ExprKind `protobuf_oneof:"expr_kind"`
}

func (m *Expr) Reset()         { *m = Expr{} }
func (m *Expr) String() string { return proto.CompactTextString(m) }
func (*Expr) ProtoMessage()    {}
func (*Expr) Descriptor() ([]byte, []int) {
	return fileDescriptor_d4e2be48009c83cb, []int{1}
}
func (m *Expr) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Expr) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Expr.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Expr) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Expr.Merge(m, src)
}
func (m *Expr) XXX_Size() int {
	return m.Size()
}
func (m *Expr) XXX_DiscardUnknown() {
	xxx_messageInfo_Expr.DiscardUnknown(m)
}

var xxx_messageInfo_Expr proto.InternalMessageInfo

type isExpr_ExprKind interface {
	isExpr_ExprKind()
	MarshalTo([]byte) (int, error)
	Size() int
}

type Expr_ConstExpr struct {
	ConstExpr *Constant `protobuf:"bytes,3,opt,name=const_expr,json=constExpr,proto3,oneof"`
}
type Expr_IdentExpr struct {
	IdentExpr *Expr_Ident `protobuf:"bytes,4,opt,name=ident_expr,json=identExpr,proto3,oneof"`
}
type Expr_SelectExpr struct {
	SelectExpr *Expr_Select `protobuf:"bytes,5,opt,name=select_expr,json=selectExpr,proto3,oneof"`
}
type Expr_CallExpr struct {
	CallExpr *Expr_Call `protobuf:"bytes,6,opt,name=call_expr,json=callExpr,proto3,oneof"`
}
type Expr_ListExpr struct {
	ListExpr *Expr_CreateList `protobuf:"bytes,7,opt,name=list_expr,json=listExpr,proto3,oneof"`
}
type Expr_StructExpr struct {
	StructExpr *Expr_CreateStruct `protobuf:"bytes,8,opt,name=struct_expr,json=structExpr,proto3,oneof"`
}
type Expr_ComprehensionExpr struct {
	ComprehensionExpr *Expr_Comprehension `protobuf:"bytes,9,opt,name=comprehension_expr,json=comprehensionExpr,proto3,oneof"`
}

func (*Expr_ConstExpr) isExpr_ExprKind()         {}
func (*Expr_IdentExpr) isExpr_ExprKind()         {}
func (*Expr_SelectExpr) isExpr_ExprKind()        {}
func (*Expr_CallExpr) isExpr_ExprKind()          {}
func (*Expr_ListExpr) isExpr_ExprKind()          {}
func (*Expr_StructExpr) isExpr_ExprKind()        {}
func (*Expr_ComprehensionExpr) isExpr_ExprKind() {}

func (m *Expr) GetExprKind() isExpr_ExprKind {
	if m != nil {
		return m.ExprKind
	}
	return nil
}

func (m *Expr) GetId() int64 {
	if m != nil {
		return m.Id
	}
	return 0
}

func (m *Expr) GetConstExpr() *Constant {
	if x, ok := m.GetExprKind().(*Expr_ConstExpr); ok {
		return x.ConstExpr
	}
	return nil
}

func (m *Expr) GetIdentExpr() *Expr_Ident {
	if x, ok := m.GetExprKind().(*Expr_IdentExpr); ok {
		return x.IdentExpr
	}
	return nil
}

func (m *Expr) GetSelectExpr() *Expr_Select {
	if x, ok := m.GetExprKind().(*Expr_SelectExpr); ok {
		return x.SelectExpr
	}
	return nil
}

func (m *Expr) GetCallExpr() *Expr_Call {
	if x, ok := m.GetExprKind().(*Expr_CallExpr); ok {
		return x.CallExpr
	}
	return nil
}

func (m *Expr) GetListExpr() *Expr_CreateList {
	if x, ok := m.GetExprKind().(*Expr_ListExpr); ok {
		return x.ListExpr
	}
	return nil
}

func (m *Expr) GetStructExpr() *Expr_CreateStruct {
	if x, ok := m.GetExprKind().(*Expr_StructExpr); ok {
		return x.StructExpr
	}
	return nil
}

func (m *Expr) GetComprehensionExpr() *Expr_Comprehension {
	if x, ok := m.GetExprKind().(*Expr_ComprehensionExpr); ok {
		return x.ComprehensionExpr
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Expr) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Expr_ConstExpr)(nil),
		(*Expr_IdentExpr)(nil),
		(*Expr_SelectExpr)(nil),
		(*Expr_CallExpr)(nil),
		(*Expr_ListExpr)(nil),
		(*Expr_StructExpr)(nil),
		(*Expr_ComprehensionExpr)(nil),
	}
}

// An identifier expression. e.g. `request`.
type Expr_Ident struct {
	// Required. Holds a single, unqualified identifier, possibly preceded by a
	// '.'.
	//
	// Qualified names are represented by the
	// [Expr.Select][google.api.expr.v1alpha1.Expr.Select] expression.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (m *Expr_Ident) Reset()         { *m = Expr_Ident{} }
func (m *Expr_Ident) String() string { return proto.CompactTextString(m) }
func (*Expr_Ident) ProtoMessage()    {}
func (*Expr_Ident) Descriptor() ([]byte, []int) {
	return fileDescriptor_d4e2be48009c83cb, []int{1, 0}
}
func (m *Expr_Ident) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Expr_Ident) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Expr_Ident.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Expr_Ident) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Expr_Ident.Merge(m, src)
}
func (m *Expr_Ident) XXX_Size() int {
	return m.Size()
}
func (m *Expr_Ident) XXX_DiscardUnknown() {
	xxx_messageInfo_Expr_Ident.DiscardUnknown(m)
}

var xxx_messageInfo_Expr_Ident proto.InternalMessageInfo

func (m *Expr_Ident) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// A field selection expression. e.g. `request.auth`.
type Expr_Select struct {
	// Required. The target of the selection expression.
	//
	// For example, in the select expression `request.auth`, the `request`
	// portion of the expression is the `operand`.
	Operand *Expr `protobuf:"bytes,1,opt,name=operand,proto3" json:"operand,omitempty"`
	// Required. The name of the field to select.
	//
	// For example, in the select expression `request.auth`, the `auth` portion
	// of the expression would be the `field`.
	Field string `protobuf:"bytes,2,opt,name=field,proto3" json:"field,omitempty"`
	// Whether the select is to be interpreted as a field presence test.
	//
	// This results from the macro `has(request.auth)`.
	TestOnly bool `protobuf:"varint,3,opt,name=test_only,json=testOnly,proto3" json:"test_only,omitempty"`
}

func (m *Expr_Select) Reset()         { *m = Expr_Select{} }
func (m *Expr_Select) String() string { return proto.CompactTextString(m) }
func (*Expr_Select) ProtoMessage()    {}
func (*Expr_Select) Descriptor() ([]byte, []int) {
	return fileDescriptor_d4e2be48009c83cb, []int{1, 1}
}
func (m *Expr_Select) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Expr_Select) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Expr_Select.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Expr_Select) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Expr_Select.Merge(m, src)
}
func (m *Expr_Select) XXX_Size() int {
	return m.Size()
}
func (m *Expr_Select) XXX_DiscardUnknown() {
	xxx_messageInfo_Expr_Select.DiscardUnknown(m)
}

var xxx_messageInfo_Expr_Select proto.InternalMessageInfo

func (m *Expr_Select) GetOperand() *Expr {
	if m != nil {
		return m.Operand
	}
	return nil
}

func (m *Expr_Select) GetField() string {
	if m != nil {
		return m.Field
	}
	return ""
}

func (m *Expr_Select) GetTestOnly() bool {
	if m != nil {
		return m.TestOnly
	}
	return false
}

// A call expression, including calls to predefined functions and operators.
//
// For example, `value == 10`, `size(map_value)`.
type Expr_Call struct {
	// The target of an method call-style expression. For example, `x` in
	// `x.f()`.
	Target *Expr `protobuf:"bytes,1,opt,name=target,proto3" json:"target,omitempty"`
	// Required. The name of the function or method being called.
	Function string `protobuf:"bytes,2,opt,name=function,proto3" json:"function,omitempty"`
	// The arguments.
	Args []*Expr `protobuf:"bytes,3,rep,name=args,proto3" json:"args,omitempty"`
}

func (m *Expr_Call) Reset()         { *m = Expr_Call{} }
func (m *Expr_Call) String() string { return proto.CompactTextString(m) }
func (*Expr_Call) ProtoMessage()    {}
func (*Expr_Call) Descriptor() ([]byte, []int) {
	return fileDescriptor_d4e2be48009c83cb, []int{1, 2}
}
func (m *Expr_Call) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Expr_Call) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Expr_Call.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Expr_Call) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Expr_Call.Merge(m, src)
}
func (m *Expr_Call) XXX_Size() int {
	return m.Size()
}
func (m *Expr_Call) XXX_DiscardUnknown() {
	xxx_messageInfo_Expr_Call.DiscardUnknown(m)
}

var xxx_messageInfo_Expr_Call proto.InternalMessageInfo

func (m *Expr_Call) GetTarget() *Expr {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *Expr_Call) GetFunction() string {
	if m != nil {
		return m.Function
	}
	return ""
}

func (m *Expr_Call) GetArgs() []*Expr {
	if m != nil {
		return m.Args
	}
	return nil
}

// A list creation expression.
//
// Lists may either be homogenous, e.g. `[1, 2, 3]`, or heterogenous, e.g.
// `dyn([1, 'hello', 2.0])`
type Expr_CreateList struct {
	// The elements part of the list.
	Elements []*Expr `protobuf:"bytes,1,rep,name=elements,proto3" json:"elements,omitempty"`
}

func (m *Expr_CreateList) Reset()         { *m = Expr_CreateList{} }
func (m *Expr_CreateList) String() string { return proto.CompactTextString(m) }
func (*Expr_CreateList) ProtoMessage()    {}
func (*Expr_CreateList) Descriptor() ([]byte, []int) {
	return fileDescriptor_d4e2be48009c83cb, []int{1, 3}
}
func (m *Expr_CreateList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Expr_CreateList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Expr_CreateList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Expr_CreateList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Expr_CreateList.Merge(m, src)
}
func (m *Expr_CreateList) XXX_Size() int {
	return m.Size()
}
func (m *Expr_CreateList) XXX_DiscardUnknown() {
	xxx_messageInfo_Expr_CreateList.DiscardUnknown(m)
}

var xxx_messageInfo_Expr_CreateList proto.InternalMessageInfo

func (m *Expr_CreateList) GetElements() []*Expr {
	if m != nil {
		return m.Elements
	}
	return nil
}

// A map or message creation expression.
//
// Maps are constructed as `{'key_name': 'value'}`. Message construction is
// similar, but prefixed with a type name and composed of field ids:
// `types.MyType{field_id: 'value'}`.
type Expr_CreateStruct struct {
	// The type name of the message to be created, empty when creating map
	// literals.
	MessageName string `protobuf:"bytes,1,opt,name=message_name,json=messageName,proto3" json:"message_name,omitempty"`
	// The entries in the creation expression.
	Entries []*Expr_CreateStruct_Entry `protobuf:"bytes,2,rep,name=entries,proto3" json:"entries,omitempty"`
}

func (m *Expr_CreateStruct) Reset()         { *m = Expr_CreateStruct{} }
func (m *Expr_CreateStruct) String() string { return proto.CompactTextString(m) }
func (*Expr_CreateStruct) ProtoMessage()    {}
func (*Expr_CreateStruct) Descriptor() ([]byte, []int) {
	return fileDescriptor_d4e2be48009c83cb, []int{1, 4}
}
func (m *Expr_CreateStruct) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Expr_CreateStruct) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Expr_CreateStruct.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Expr_CreateStruct) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Expr_CreateStruct.Merge(m, src)
}
func (m *Expr_CreateStruct) XXX_Size() int {
	return m.Size()
}
func (m *Expr_CreateStruct) XXX_DiscardUnknown() {
	xxx_messageInfo_Expr_CreateStruct.DiscardUnknown(m)
}

var xxx_messageInfo_Expr_CreateStruct proto.InternalMessageInfo

func (m *Expr_CreateStruct) GetMessageName() string {
	if m != nil {
		return m.MessageName
	}
	return ""
}

func (m *Expr_CreateStruct) GetEntries() []*Expr_CreateStruct_Entry {
	if m != nil {
		return m.Entries
	}
	return nil
}

// Represents an entry.
type Expr_CreateStruct_Entry struct {
	// Required. An id assigned to this node by the parser which is unique
	// in a given expression tree. This is used to associate type
	// information and other attributes to the node.
	Id int64 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	// The `Entry` key kinds.
	//
	// Types that are valid to be assigned to KeyKind:
	//	*Expr_CreateStruct_Entry_FieldKey
	//	*Expr_CreateStruct_Entry_MapKey
	KeyKind isExpr_CreateStruct_Entry_KeyKind `protobuf_oneof:"key_kind"`
	// Required. The value assigned to the key.
	Value *Expr `protobuf:"bytes,4,opt,name=value,proto3" json:"value,omitempty"`
}

func (m *Expr_CreateStruct_Entry) Reset()         { *m = Expr_CreateStruct_Entry{} }
func (m *Expr_CreateStruct_Entry) String() string { return proto.CompactTextString(m) }
func (*Expr_CreateStruct_Entry) ProtoMessage()    {}
func (*Expr_CreateStruct_Entry) Descriptor() ([]byte, []int) {
	return fileDescriptor_d4e2be48009c83cb, []int{1, 4, 0}
}
func (m *Expr_CreateStruct_Entry) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Expr_CreateStruct_Entry) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Expr_CreateStruct_Entry.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Expr_CreateStruct_Entry) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Expr_CreateStruct_Entry.Merge(m, src)
}
func (m *Expr_CreateStruct_Entry) XXX_Size() int {
	return m.Size()
}
func (m *Expr_CreateStruct_Entry) XXX_DiscardUnknown() {
	xxx_messageInfo_Expr_CreateStruct_Entry.DiscardUnknown(m)
}

var xxx_messageInfo_Expr_CreateStruct_Entry proto.InternalMessageInfo

type isExpr_CreateStruct_Entry_KeyKind interface {
	isExpr_CreateStruct_Entry_KeyKind()
	MarshalTo([]byte) (int, error)
	Size() int
}

type Expr_CreateStruct_Entry_FieldKey struct {
	FieldKey string `protobuf:"bytes,2,opt,name=field_key,json=fieldKey,proto3,oneof"`
}
type Expr_CreateStruct_Entry_MapKey struct {
	MapKey *Expr `protobuf:"bytes,3,opt,name=map_key,json=mapKey,proto3,oneof"`
}

func (*Expr_CreateStruct_Entry_FieldKey) isExpr_CreateStruct_Entry_KeyKind() {}
func (*Expr_CreateStruct_Entry_MapKey) isExpr_CreateStruct_Entry_KeyKind()   {}

func (m *Expr_CreateStruct_Entry) GetKeyKind() isExpr_CreateStruct_Entry_KeyKind {
	if m != nil {
		return m.KeyKind
	}
	return nil
}

func (m *Expr_CreateStruct_Entry) GetId() int64 {
	if m != nil {
		return m.Id
	}
	return 0
}

func (m *Expr_CreateStruct_Entry) GetFieldKey() string {
	if x, ok := m.GetKeyKind().(*Expr_CreateStruct_Entry_FieldKey); ok {
		return x.FieldKey
	}
	return ""
}

func (m *Expr_CreateStruct_Entry) GetMapKey() *Expr {
	if x, ok := m.GetKeyKind().(*Expr_CreateStruct_Entry_MapKey); ok {
		return x.MapKey
	}
	return nil
}

func (m *Expr_CreateStruct_Entry) GetValue() *Expr {
	if m != nil {
		return m.Value
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Expr_CreateStruct_Entry) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Expr_CreateStruct_Entry_FieldKey)(nil),
		(*Expr_CreateStruct_Entry_MapKey)(nil),
	}
}

// A comprehension expression applied to a list or map.
//
// Comprehensions are not part of the core syntax, but enabled with macros.
// A macro matches a specific call signature within a parsed AST and replaces
// the call with an alternate AST block. Macro expansion happens at parse
// time.
//
// The following macros are supported within CEL:
//
// Aggregate type macros may be applied to all elements in a list or all keys
// in a map:
//
// *  `all`, `exists`, `exists_one` -  test a predicate expression against
//    the inputs and return `true` if the predicate is satisfied for all,
//    any, or only one value `list.all(x, x < 10)`.
// *  `filter` - test a predicate expression against the inputs and return
//    the subset of elements which satisfy the predicate:
//    `payments.filter(p, p > 1000)`.
// *  `map` - apply an expression to all elements in the input and return the
//    output aggregate type: `[1, 2, 3].map(i, i * i)`.
//
// The `has(m.x)` macro tests whether the property `x` is present in struct
// `m`. The semantics of this macro depend on the type of `m`. For proto2
// messages `has(m.x)` is defined as 'defined, but not set`. For proto3, the
// macro tests whether the property is set to its default. For map and struct
// types, the macro tests whether the property `x` is defined on `m`.
type Expr_Comprehension struct {
	// The name of the iteration variable.
	IterVar string `protobuf:"bytes,1,opt,name=iter_var,json=iterVar,proto3" json:"iter_var,omitempty"`
	// The range over which var iterates.
	IterRange *Expr `protobuf:"bytes,2,opt,name=iter_range,json=iterRange,proto3" json:"iter_range,omitempty"`
	// The name of the variable used for accumulation of the result.
	AccuVar string `protobuf:"bytes,3,opt,name=accu_var,json=accuVar,proto3" json:"accu_var,omitempty"`
	// The initial value of the accumulator.
	AccuInit *Expr `protobuf:"bytes,4,opt,name=accu_init,json=accuInit,proto3" json:"accu_init,omitempty"`
	// An expression which can contain iter_var and accu_var.
	//
	// Returns false when the result has been computed and may be used as
	// a hint to short-circuit the remainder of the comprehension.
	LoopCondition *Expr `protobuf:"bytes,5,opt,name=loop_condition,json=loopCondition,proto3" json:"loop_condition,omitempty"`
	// An expression which can contain iter_var and accu_var.
	//
	// Computes the next value of accu_var.
	LoopStep *Expr `protobuf:"bytes,6,opt,name=loop_step,json=loopStep,proto3" json:"loop_step,omitempty"`
	// An expression which can contain accu_var.
	//
	// Computes the result.
	Result *Expr `protobuf:"bytes,7,opt,name=result,proto3" json:"result,omitempty"`
}

func (m *Expr_Comprehension) Reset()         { *m = Expr_Comprehension{} }
func (m *Expr_Comprehension) String() string { return proto.CompactTextString(m) }
func (*Expr_Comprehension) ProtoMessage()    {}
func (*Expr_Comprehension) Descriptor() ([]byte, []int) {
	return fileDescriptor_d4e2be48009c83cb, []int{1, 5}
}
func (m *Expr_Comprehension) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Expr_Comprehension) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Expr_Comprehension.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Expr_Comprehension) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Expr_Comprehension.Merge(m, src)
}
func (m *Expr_Comprehension) XXX_Size() int {
	return m.Size()
}
func (m *Expr_Comprehension) XXX_DiscardUnknown() {
	xxx_messageInfo_Expr_Comprehension.DiscardUnknown(m)
}

var xxx_messageInfo_Expr_Comprehension proto.InternalMessageInfo

func (m *Expr_Comprehension) GetIterVar() string {
	if m != nil {
		return m.IterVar
	}
	return ""
}

func (m *Expr_Comprehension) GetIterRange() *Expr {
	if m != nil {
		return m.IterRange
	}
	return nil
}

func (m *Expr_Comprehension) GetAccuVar() string {
	if m != nil {
		return m.AccuVar
	}
	return ""
}

func (m *Expr_Comprehension) GetAccuInit() *Expr {
	if m != nil {
		return m.AccuInit
	}
	return nil
}

func (m *Expr_Comprehension) GetLoopCondition() *Expr {
	if m != nil {
		return m.LoopCondition
	}
	return nil
}

func (m *Expr_Comprehension) GetLoopStep() *Expr {
	if m != nil {
		return m.LoopStep
	}
	return nil
}

func (m *Expr_Comprehension) GetResult() *Expr {
	if m != nil {
		return m.Result
	}
	return nil
}

// Represents a primitive literal.
//
// Named 'Constant' here for backwards compatibility.
//
// This is similar as the primitives supported in the well-known type
// `google.protobuf.Value`, but richer so it can represent CEL's full range of
// primitives.
//
// Lists and structs are not included as constants as these aggregate types may
// contain [Expr][google.api.expr.v1alpha1.Expr] elements which require
// evaluation and are thus not constant.
//
// Examples of literals include: `"hello"`, `b'bytes'`, `1u`, `4.2`, `-2`,
// `true`, `null`.
type Constant struct {
	// Required. The valid constant kinds.
	//
	// Types that are valid to be assigned to ConstantKind:
	//	*Constant_NullValue
	//	*Constant_BoolValue
	//	*Constant_Int64Value
	//	*Constant_Uint64Value
	//	*Constant_DoubleValue
	//	*Constant_StringValue
	//	*Constant_BytesValue
	//	*Constant_DurationValue
	//	*Constant_TimestampValue
	ConstantKind isConstant_ConstantKind `protobuf_oneof:"constant_kind"`
}

func (m *Constant) Reset()         { *m = Constant{} }
func (m *Constant) String() string { return proto.CompactTextString(m) }
func (*Constant) ProtoMessage()    {}
func (*Constant) Descriptor() ([]byte, []int) {
	return fileDescriptor_d4e2be48009c83cb, []int{2}
}
func (m *Constant) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Constant) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Constant.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Constant) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Constant.Merge(m, src)
}
func (m *Constant) XXX_Size() int {
	return m.Size()
}
func (m *Constant) XXX_DiscardUnknown() {
	xxx_messageInfo_Constant.DiscardUnknown(m)
}

var xxx_messageInfo_Constant proto.InternalMessageInfo

type isConstant_ConstantKind interface {
	isConstant_ConstantKind()
	MarshalTo([]byte) (int, error)
	Size() int
}

type Constant_NullValue struct {
	NullValue types.NullValue `protobuf:"varint,1,opt,name=null_value,json=nullValue,proto3,enum=google.protobuf.NullValue,oneof"`
}
type Constant_BoolValue struct {
	BoolValue bool `protobuf:"varint,2,opt,name=bool_value,json=boolValue,proto3,oneof"`
}
type Constant_Int64Value struct {
	Int64Value int64 `protobuf:"varint,3,opt,name=int64_value,json=int64Value,proto3,oneof"`
}
type Constant_Uint64Value struct {
	Uint64Value uint64 `protobuf:"varint,4,opt,name=uint64_value,json=uint64Value,proto3,oneof"`
}
type Constant_DoubleValue struct {
	DoubleValue float64 `protobuf:"fixed64,5,opt,name=double_value,json=doubleValue,proto3,oneof"`
}
type Constant_StringValue struct {
	StringValue string `protobuf:"bytes,6,opt,name=string_value,json=stringValue,proto3,oneof"`
}
type Constant_BytesValue struct {
	BytesValue []byte `protobuf:"bytes,7,opt,name=bytes_value,json=bytesValue,proto3,oneof"`
}
type Constant_DurationValue struct {
	DurationValue *types.Duration `protobuf:"bytes,8,opt,name=duration_value,json=durationValue,proto3,oneof"`
}
type Constant_TimestampValue struct {
	TimestampValue *types.Timestamp `protobuf:"bytes,9,opt,name=timestamp_value,json=timestampValue,proto3,oneof"`
}

func (*Constant_NullValue) isConstant_ConstantKind()      {}
func (*Constant_BoolValue) isConstant_ConstantKind()      {}
func (*Constant_Int64Value) isConstant_ConstantKind()     {}
func (*Constant_Uint64Value) isConstant_ConstantKind()    {}
func (*Constant_DoubleValue) isConstant_ConstantKind()    {}
func (*Constant_StringValue) isConstant_ConstantKind()    {}
func (*Constant_BytesValue) isConstant_ConstantKind()     {}
func (*Constant_DurationValue) isConstant_ConstantKind()  {}
func (*Constant_TimestampValue) isConstant_ConstantKind() {}

func (m *Constant) GetConstantKind() isConstant_ConstantKind {
	if m != nil {
		return m.ConstantKind
	}
	return nil
}

func (m *Constant) GetNullValue() types.NullValue {
	if x, ok := m.GetConstantKind().(*Constant_NullValue); ok {
		return x.NullValue
	}
	return types.NullValue_NULL_VALUE
}

func (m *Constant) GetBoolValue() bool {
	if x, ok := m.GetConstantKind().(*Constant_BoolValue); ok {
		return x.BoolValue
	}
	return false
}

func (m *Constant) GetInt64Value() int64 {
	if x, ok := m.GetConstantKind().(*Constant_Int64Value); ok {
		return x.Int64Value
	}
	return 0
}

func (m *Constant) GetUint64Value() uint64 {
	if x, ok := m.GetConstantKind().(*Constant_Uint64Value); ok {
		return x.Uint64Value
	}
	return 0
}

func (m *Constant) GetDoubleValue() float64 {
	if x, ok := m.GetConstantKind().(*Constant_DoubleValue); ok {
		return x.DoubleValue
	}
	return 0
}

func (m *Constant) GetStringValue() string {
	if x, ok := m.GetConstantKind().(*Constant_StringValue); ok {
		return x.StringValue
	}
	return ""
}

func (m *Constant) GetBytesValue() []byte {
	if x, ok := m.GetConstantKind().(*Constant_BytesValue); ok {
		return x.BytesValue
	}
	return nil
}

// Deprecated: Do not use.
func (m *Constant) GetDurationValue() *types.Duration {
	if x, ok := m.GetConstantKind().(*Constant_DurationValue); ok {
		return x.DurationValue
	}
	return nil
}

// Deprecated: Do not use.
func (m *Constant) GetTimestampValue() *types.Timestamp {
	if x, ok := m.GetConstantKind().(*Constant_TimestampValue); ok {
		return x.TimestampValue
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Constant) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Constant_NullValue)(nil),
		(*Constant_BoolValue)(nil),
		(*Constant_Int64Value)(nil),
		(*Constant_Uint64Value)(nil),
		(*Constant_DoubleValue)(nil),
		(*Constant_StringValue)(nil),
		(*Constant_BytesValue)(nil),
		(*Constant_DurationValue)(nil),
		(*Constant_TimestampValue)(nil),
	}
}

// Source information collected at parse time.
type SourceInfo struct {
	// The syntax version of the source, e.g. `cel1`.
	SyntaxVersion string `protobuf:"bytes,1,opt,name=syntax_version,json=syntaxVersion,proto3" json:"syntax_version,omitempty"`
	// The location name. All position information attached to an expression is
	// relative to this location.
	//
	// The location could be a file, UI element, or similar. For example,
	// `acme/app/AnvilPolicy.cel`.
	Location string `protobuf:"bytes,2,opt,name=location,proto3" json:"location,omitempty"`
	// Monotonically increasing list of character offsets where newlines appear.
	//
	// The line number of a given position is the index `i` where for a given
	// `id` the `line_offsets[i] < id_positions[id] < line_offsets[i+1]`. The
	// column may be derivd from `id_positions[id] - line_offsets[i]`.
	LineOffsets []int32 `protobuf:"varint,3,rep,packed,name=line_offsets,json=lineOffsets,proto3" json:"line_offsets,omitempty"`
	// A map from the parse node id (e.g. `Expr.id`) to the character offset
	// within source.
	Positions map[int64]int32 `protobuf:"bytes,4,rep,name=positions,proto3" json:"positions,omitempty" protobuf_key:"varint,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
}

func (m *SourceInfo) Reset()         { *m = SourceInfo{} }
func (m *SourceInfo) String() string { return proto.CompactTextString(m) }
func (*SourceInfo) ProtoMessage()    {}
func (*SourceInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_d4e2be48009c83cb, []int{3}
}
func (m *SourceInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SourceInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SourceInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SourceInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SourceInfo.Merge(m, src)
}
func (m *SourceInfo) XXX_Size() int {
	return m.Size()
}
func (m *SourceInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_SourceInfo.DiscardUnknown(m)
}

var xxx_messageInfo_SourceInfo proto.InternalMessageInfo

func (m *SourceInfo) GetSyntaxVersion() string {
	if m != nil {
		return m.SyntaxVersion
	}
	return ""
}

func (m *SourceInfo) GetLocation() string {
	if m != nil {
		return m.Location
	}
	return ""
}

func (m *SourceInfo) GetLineOffsets() []int32 {
	if m != nil {
		return m.LineOffsets
	}
	return nil
}

func (m *SourceInfo) GetPositions() map[int64]int32 {
	if m != nil {
		return m.Positions
	}
	return nil
}

// A specific position in source.
type SourcePosition struct {
	// The soucre location name (e.g. file name).
	Location string `protobuf:"bytes,1,opt,name=location,proto3" json:"location,omitempty"`
	// The character offset.
	Offset int32 `protobuf:"varint,2,opt,name=offset,proto3" json:"offset,omitempty"`
	// The 1-based index of the starting line in the source text
	// where the issue occurs, or 0 if unknown.
	Line int32 `protobuf:"varint,3,opt,name=line,proto3" json:"line,omitempty"`
	// The 0-based index of the starting position within the line of source text
	// where the issue occurs.  Only meaningful if line is nonzero.
	Column int32 `protobuf:"varint,4,opt,name=column,proto3" json:"column,omitempty"`
}

func (m *SourcePosition) Reset()         { *m = SourcePosition{} }
func (m *SourcePosition) String() string { return proto.CompactTextString(m) }
func (*SourcePosition) ProtoMessage()    {}
func (*SourcePosition) Descriptor() ([]byte, []int) {
	return fileDescriptor_d4e2be48009c83cb, []int{4}
}
func (m *SourcePosition) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SourcePosition) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SourcePosition.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SourcePosition) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SourcePosition.Merge(m, src)
}
func (m *SourcePosition) XXX_Size() int {
	return m.Size()
}
func (m *SourcePosition) XXX_DiscardUnknown() {
	xxx_messageInfo_SourcePosition.DiscardUnknown(m)
}

var xxx_messageInfo_SourcePosition proto.InternalMessageInfo

func (m *SourcePosition) GetLocation() string {
	if m != nil {
		return m.Location
	}
	return ""
}

func (m *SourcePosition) GetOffset() int32 {
	if m != nil {
		return m.Offset
	}
	return 0
}

func (m *SourcePosition) GetLine() int32 {
	if m != nil {
		return m.Line
	}
	return 0
}

func (m *SourcePosition) GetColumn() int32 {
	if m != nil {
		return m.Column
	}
	return 0
}

func init() {
	proto.RegisterType((*ParsedExpr)(nil), "google.api.expr.v1alpha1.ParsedExpr")
	proto.RegisterType((*Expr)(nil), "google.api.expr.v1alpha1.Expr")
	proto.RegisterType((*Expr_Ident)(nil), "google.api.expr.v1alpha1.Expr.Ident")
	proto.RegisterType((*Expr_Select)(nil), "google.api.expr.v1alpha1.Expr.Select")
	proto.RegisterType((*Expr_Call)(nil), "google.api.expr.v1alpha1.Expr.Call")
	proto.RegisterType((*Expr_CreateList)(nil), "google.api.expr.v1alpha1.Expr.CreateList")
	proto.RegisterType((*Expr_CreateStruct)(nil), "google.api.expr.v1alpha1.Expr.CreateStruct")
	proto.RegisterType((*Expr_CreateStruct_Entry)(nil), "google.api.expr.v1alpha1.Expr.CreateStruct.Entry")
	proto.RegisterType((*Expr_Comprehension)(nil), "google.api.expr.v1alpha1.Expr.Comprehension")
	proto.RegisterType((*Constant)(nil), "google.api.expr.v1alpha1.Constant")
	proto.RegisterType((*SourceInfo)(nil), "google.api.expr.v1alpha1.SourceInfo")
	proto.RegisterMapType((map[int64]int32)(nil), "google.api.expr.v1alpha1.SourceInfo.PositionsEntry")
	proto.RegisterType((*SourcePosition)(nil), "google.api.expr.v1alpha1.SourcePosition")
}

func init() {
	proto.RegisterFile("google/api/expr/v1alpha1/syntax.proto", fileDescriptor_d4e2be48009c83cb)
}

var fileDescriptor_d4e2be48009c83cb = []byte{
	// 1139 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x56, 0x4d, 0x6f, 0x1b, 0x37,
	0x13, 0xd6, 0xea, 0xcb, 0xda, 0x91, 0xad, 0xbc, 0x2f, 0x51, 0x14, 0xca, 0x26, 0x55, 0x12, 0xa7,
	0x01, 0x52, 0xb4, 0x90, 0x91, 0x0f, 0x04, 0x69, 0xd2, 0x5e, 0xe4, 0xba, 0x90, 0x91, 0x22, 0x71,
	0xd7, 0x85, 0x6f, 0x85, 0x40, 0xaf, 0x28, 0x65, 0x61, 0x8a, 0x5c, 0x2c, 0xb9, 0x86, 0x75, 0xee,
	0xa1, 0xb7, 0xa2, 0xff, 0xa5, 0xfd, 0x03, 0xbd, 0xf5, 0x98, 0x63, 0x0f, 0x3d, 0x14, 0xf6, 0x9f,
	0xe8, 0xa5, 0x40, 0x31, 0x43, 0xae, 0xfc, 0x11, 0x18, 0x52, 0x6f, 0xe4, 0xf0, 0x79, 0x1e, 0x0e,
	0x67, 0x86, 0x43, 0xc2, 0x83, 0xa9, 0xd6, 0x53, 0x29, 0xb6, 0x78, 0x96, 0x6e, 0x89, 0x93, 0x2c,
	0xdf, 0x3a, 0x7e, 0xc4, 0x65, 0xf6, 0x96, 0x3f, 0xda, 0x32, 0x73, 0x65, 0xf9, 0x49, 0x3f, 0xcb,
	0xb5, 0xd5, 0xac, 0xeb, 0x60, 0x7d, 0x9e, 0xa5, 0x7d, 0x84, 0xf5, 0x4b, 0x58, 0xd4, 0xf3, 0x02,
	0x84, 0x3b, 0x2c, 0x26, 0x5b, 0xe3, 0x22, 0xe7, 0x36, 0xd5, 0xca, 0x31, 0xa3, 0xdb, 0x57, 0xd7,
	0x8d, 0xcd, 0x8b, 0xc4, 0xfa, 0xd5, 0x3b, 0x57, 0x57, 0x6d, 0x3a, 0x13, 0xc6, 0xf2, 0x59, 0xe6,
	0x00, 0x9b, 0x3f, 0x06, 0x00, 0x7b, 0x3c, 0x37, 0x62, 0xbc, 0x73, 0x92, 0xe5, 0xec, 0x31, 0xd4,
	0x71, 0xfb, 0x6e, 0xf5, 0x6e, 0xf0, 0xb0, 0xfd, 0xb8, 0xd7, 0xbf, 0xce, 0xad, 0x3e, 0xa2, 0x63,
	0xc2, 0xb2, 0x1d, 0x68, 0x1b, 0x5d, 0xe4, 0x89, 0x18, 0xa5, 0x6a, 0xa2, 0xbb, 0x35, 0xa2, 0x7e,
	0x7c, 0x3d, 0x75, 0x9f, 0xc0, 0xbb, 0x6a, 0xa2, 0x63, 0x30, 0x8b, 0xf1, 0xe6, 0x9f, 0xeb, 0x50,
	0x27, 0x1f, 0x3a, 0x50, 0x4d, 0xc7, 0xe4, 0x41, 0x2d, 0xae, 0xa6, 0x63, 0xb6, 0x0d, 0x90, 0x68,
	0x65, 0xec, 0x88, 0x3c, 0x73, 0xf2, 0x9b, 0xd7, 0xcb, 0x6f, 0x23, 0x96, 0x2b, 0x3b, 0xac, 0xc4,
	0x21, 0xf1, 0x76, 0x9c, 0x93, 0x90, 0x8e, 0x85, 0xf2, 0x22, 0xf5, 0x65, 0x3e, 0x22, 0xa7, 0xbf,
	0x8b, 0x04, 0x94, 0x21, 0x26, 0xc9, 0x0c, 0xa1, 0x6d, 0x84, 0x14, 0x89, 0xd7, 0x69, 0x90, 0xce,
	0x83, 0x25, 0x3a, 0xfb, 0xc4, 0x18, 0x56, 0x62, 0x70, 0x5c, 0x52, 0x1a, 0x40, 0x98, 0x70, 0x29,
	0x9d, 0x4e, 0x93, 0x74, 0xee, 0x2f, 0xd1, 0xd9, 0xe6, 0x52, 0x0e, 0x2b, 0x71, 0x0b, 0x79, 0xde,
	0x9b, 0x50, 0xa6, 0x65, 0x60, 0xd6, 0x48, 0xe3, 0x93, 0x65, 0x1a, 0xb9, 0xe0, 0x56, 0x7c, 0x93,
	0x1a, 0xf4, 0xa7, 0x85, 0x6c, 0x52, 0x7a, 0x0d, 0x6d, 0x57, 0x37, 0x4e, 0xab, 0x45, 0x5a, 0x9f,
	0xae, 0xa4, 0xb5, 0x4f, 0x3c, 0x3a, 0x1d, 0x8d, 0x48, 0xef, 0x7b, 0x60, 0x89, 0x9e, 0x65, 0xb9,
	0x78, 0x2b, 0x94, 0x49, 0xb5, 0x72, 0xb2, 0x21, 0xc9, 0x7e, 0xb6, 0x4c, 0xf6, 0x22, 0x71, 0x58,
	0x89, 0xff, 0x7f, 0x49, 0x09, 0x21, 0xd1, 0x2d, 0x68, 0x50, 0x72, 0x18, 0x83, 0xba, 0xe2, 0x33,
	0xd1, 0x0d, 0xee, 0x06, 0x0f, 0xc3, 0x98, 0xc6, 0x51, 0x01, 0x4d, 0x17, 0x71, 0xf6, 0x1c, 0xd6,
	0x74, 0x26, 0x72, 0xae, 0xc6, 0x04, 0x58, 0x5e, 0xd0, 0x25, 0x9c, 0x7d, 0x00, 0x8d, 0x49, 0x2a,
	0xa4, 0x2b, 0xc3, 0x30, 0x76, 0x13, 0x76, 0x0b, 0x42, 0x2b, 0x8c, 0x1d, 0x69, 0x25, 0xe7, 0x54,
	0x88, 0xad, 0xb8, 0x85, 0x86, 0x37, 0x4a, 0xce, 0xa3, 0x9f, 0x02, 0xa8, 0x63, 0x86, 0xd8, 0x33,
	0x68, 0x5a, 0x9e, 0x4f, 0x85, 0x5d, 0x71, 0x53, 0x8f, 0x66, 0x11, 0xb4, 0x26, 0x85, 0x4a, 0xf0,
	0x6e, 0xfb, 0x6d, 0x17, 0x73, 0xbc, 0x97, 0x3c, 0x9f, 0x9a, 0x6e, 0xed, 0x6e, 0x6d, 0x95, 0x7b,
	0x89, 0xd8, 0x68, 0x08, 0x70, 0x9e, 0x6d, 0xf6, 0x02, 0x5a, 0x42, 0x8a, 0x99, 0x50, 0xd6, 0x74,
	0x83, 0x95, 0x54, 0x16, 0xf8, 0xe8, 0xd7, 0x2a, 0xac, 0x5f, 0x4c, 0x36, 0xbb, 0x07, 0xeb, 0x33,
	0x61, 0x0c, 0x9f, 0x8a, 0xd1, 0x85, 0xf0, 0xb7, 0xbd, 0xed, 0x35, 0x9f, 0x09, 0xf6, 0x0a, 0xd6,
	0x84, 0xb2, 0x79, 0x2a, 0x4c, 0xb7, 0x4a, 0xdb, 0x3d, 0xfa, 0x0f, 0xd5, 0xd4, 0xdf, 0x51, 0x36,
	0x9f, 0xc7, 0xa5, 0x42, 0xf4, 0x4b, 0x00, 0x0d, 0x32, 0xf9, 0xe6, 0x10, 0x2c, 0x9a, 0xc3, 0x47,
	0x10, 0x52, 0x6e, 0x46, 0x47, 0x62, 0xee, 0xa2, 0x86, 0x75, 0x4d, 0xa6, 0x57, 0x62, 0xce, 0x3e,
	0x87, 0xb5, 0x19, 0xcf, 0x68, 0xb1, 0xb6, 0x4a, 0x32, 0x86, 0x95, 0xb8, 0x39, 0xe3, 0x19, 0x52,
	0x9f, 0x42, 0xe3, 0x98, 0xcb, 0x42, 0xf8, 0x66, 0xb1, 0x2c, 0x5a, 0x0e, 0x3c, 0x00, 0x68, 0x1d,
	0x89, 0xf9, 0xe8, 0x28, 0x55, 0xe3, 0xe8, 0x9f, 0x2a, 0x6c, 0x5c, 0x2a, 0x66, 0x76, 0x13, 0x5a,
	0xa9, 0x15, 0xf9, 0xe8, 0x98, 0xe7, 0x3e, 0x66, 0x6b, 0x38, 0x3f, 0xe0, 0x39, 0xfb, 0x12, 0x80,
	0x96, 0x72, 0xae, 0xa6, 0x62, 0xc5, 0xfe, 0x1b, 0x22, 0x23, 0x46, 0x02, 0x2a, 0xf3, 0x24, 0x29,
	0x48, 0xb9, 0xe6, 0x94, 0x71, 0x8e, 0xca, 0x2f, 0x21, 0xa4, 0xa5, 0x54, 0xa5, 0x76, 0xc5, 0xc3,
	0x90, 0xd6, 0xae, 0x4a, 0x2d, 0xdb, 0x81, 0x8e, 0xd4, 0x3a, 0x1b, 0x25, 0x5a, 0x8d, 0x53, 0x2a,
	0xcd, 0xc6, 0x4a, 0x0a, 0x1b, 0xc8, 0xda, 0x2e, 0x49, 0xe8, 0x03, 0xc9, 0x18, 0x2b, 0x32, 0xdf,
	0xed, 0x96, 0xfa, 0x80, 0x84, 0x7d, 0x2b, 0x32, 0xbc, 0x50, 0xb9, 0x30, 0x85, 0xb4, 0xbe, 0xc7,
	0x2d, 0xbd, 0x50, 0x0e, 0x3d, 0x68, 0x43, 0x88, 0xab, 0x94, 0x8c, 0xcd, 0xdf, 0x6a, 0xd0, 0x2a,
	0x9f, 0x06, 0xf6, 0x12, 0x40, 0x15, 0x52, 0x8e, 0x5c, 0x82, 0x31, 0x13, 0x9d, 0xc7, 0x51, 0xa9,
	0x5a, 0xbe, 0x95, 0xfd, 0xd7, 0x85, 0x94, 0x07, 0x88, 0xc0, 0x37, 0x40, 0x95, 0x13, 0x76, 0x07,
	0xe0, 0x50, 0xeb, 0x92, 0x8c, 0x99, 0x6a, 0x21, 0x00, 0x6d, 0x0e, 0x70, 0x0f, 0xda, 0xa9, 0xb2,
	0xcf, 0x9e, 0x7a, 0x04, 0xa6, 0xa3, 0x86, 0xfd, 0x91, 0x8c, 0x0e, 0x72, 0x1f, 0xd6, 0x8b, 0x8b,
	0x18, 0x4c, 0x4b, 0x7d, 0x58, 0x89, 0xdb, 0xc5, 0x65, 0xd0, 0x58, 0x17, 0x87, 0x52, 0x78, 0x10,
	0x46, 0x3e, 0x40, 0x90, 0xb3, 0x2e, 0x40, 0xc6, 0xe6, 0xa9, 0x9a, 0x7a, 0x50, 0xd3, 0xdf, 0x81,
	0xb6, 0xb3, 0x2e, 0x3c, 0x3a, 0x9c, 0x5b, 0x61, 0x3c, 0x06, 0xc3, 0xb8, 0x8e, 0x1e, 0x91, 0xd1,
	0x41, 0xbe, 0x86, 0x4e, 0xf9, 0xb3, 0xf0, 0x28, 0xf7, 0x08, 0xdc, 0x7c, 0x2f, 0x2c, 0x5f, 0x79,
	0xd8, 0xa0, 0xda, 0x45, 0x6f, 0x36, 0x4a, 0x9a, 0xd3, 0xd9, 0x85, 0x1b, 0x8b, 0x3f, 0x86, 0x17,
	0x72, 0x6d, 0xff, 0xfd, 0xf8, 0x7e, 0x57, 0xe2, 0xbc, 0x52, 0x67, 0x41, 0x24, 0xa9, 0xc1, 0x0d,
	0xd8, 0x48, 0x7c, 0xc6, 0x5c, 0x0e, 0x7f, 0xa8, 0x02, 0x9c, 0xff, 0x1e, 0xd8, 0x03, 0xe8, 0xb8,
	0x4f, 0xd4, 0xe8, 0x58, 0xe4, 0x78, 0xbf, 0xfc, 0x9d, 0xda, 0x70, 0xd6, 0x03, 0x67, 0xc4, 0xbe,
	0x2a, 0x75, 0xc2, 0x2f, 0xf6, 0xd5, 0x72, 0x8e, 0x8d, 0x4c, 0xa6, 0x4a, 0x8c, 0xf4, 0x64, 0x62,
	0x84, 0x75, 0xfd, 0xb5, 0x11, 0xb7, 0xd1, 0xf6, 0xc6, 0x99, 0xd8, 0xb7, 0x10, 0x66, 0xda, 0x50,
	0x19, 0x9b, 0x6e, 0x9d, 0x5a, 0xd9, 0x93, 0x55, 0x3e, 0x37, 0xfd, 0xbd, 0x92, 0xe5, 0x9a, 0xd9,
	0xb9, 0x4a, 0xf4, 0x05, 0x74, 0x2e, 0x2f, 0xb2, 0xff, 0x41, 0x0d, 0x7b, 0x94, 0xeb, 0x6b, 0x38,
	0xc4, 0x17, 0xe8, 0xbc, 0xc0, 0x1a, 0xbe, 0xbd, 0xbc, 0xa8, 0x3e, 0x0f, 0x36, 0x33, 0xe8, 0xb8,
	0x5d, 0x4a, 0x8d, 0x4b, 0x27, 0x0c, 0xae, 0x9c, 0xf0, 0x43, 0x68, 0xba, 0xc3, 0x79, 0x21, 0x3f,
	0xc3, 0x97, 0x13, 0x4f, 0x49, 0xd5, 0xd9, 0x88, 0x69, 0x8c, 0xd8, 0x44, 0xcb, 0x62, 0xa6, 0xa8,
	0x1e, 0x1b, 0xb1, 0x9f, 0x0d, 0x86, 0xbf, 0x9f, 0xf6, 0x82, 0x77, 0xa7, 0xbd, 0xe0, 0xaf, 0xd3,
	0x5e, 0xf0, 0xf3, 0x59, 0xaf, 0xf2, 0xee, 0xac, 0x57, 0xf9, 0xe3, 0xac, 0x57, 0x81, 0xdb, 0x89,
	0x9e, 0x5d, 0x1b, 0x8c, 0x41, 0x7b, 0x9f, 0x12, 0xb1, 0x87, 0x09, 0xdf, 0x0b, 0xfe, 0x0e, 0x82,
	0xc3, 0x26, 0x25, 0xff, 0xc9, 0xbf, 0x01, 0x00, 0x00, 0xff, 0xff, 0xf6, 0x9b, 0xdc, 0xdb, 0x17,
	0x0b, 0x00, 0x00,
}

func (m *ParsedExpr) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ParsedExpr) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ParsedExpr) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.SourceInfo != nil {
		{
			size, err := m.SourceInfo.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSyntax(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.Expr != nil {
		{
			size, err := m.Expr.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSyntax(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	return len(dAtA) - i, nil
}

func (m *Expr) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Expr) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Expr) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.ExprKind != nil {
		{
			size := m.ExprKind.Size()
			i -= size
			if _, err := m.ExprKind.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	if m.Id != 0 {
		i = encodeVarintSyntax(dAtA, i, uint64(m.Id))
		i--
		dAtA[i] = 0x10
	}
	return len(dAtA) - i, nil
}

func (m *Expr_ConstExpr) MarshalTo(dAtA []byte) (int, error) {
	return m.MarshalToSizedBuffer(dAtA[:m.Size()])
}

func (m *Expr_ConstExpr) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.ConstExpr != nil {
		{
			size, err := m.ConstExpr.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSyntax(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	return len(dAtA) - i, nil
}
func (m *Expr_IdentExpr) MarshalTo(dAtA []byte) (int, error) {
	return m.MarshalToSizedBuffer(dAtA[:m.Size()])
}

func (m *Expr_IdentExpr) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.IdentExpr != nil {
		{
			size, err := m.IdentExpr.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSyntax(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	return len(dAtA) - i, nil
}
func (m *Expr_SelectExpr) MarshalTo(dAtA []byte) (int, error) {
	return m.MarshalToSizedBuffer(dAtA[:m.Size()])
}

func (m *Expr_SelectExpr) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.SelectExpr != nil {
		{
			size, err := m.SelectExpr.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSyntax(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	return len(dAtA) - i, nil
}
func (m *Expr_CallExpr) MarshalTo(dAtA []byte) (int, error) {
	return m.MarshalToSizedBuffer(dAtA[:m.Size()])
}

func (m *Expr_CallExpr) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.CallExpr != nil {
		{
			size, err := m.CallExpr.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSyntax(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	return len(dAtA) - i, nil
}
func (m *Expr_ListExpr) MarshalTo(dAtA []byte) (int, error) {
	return m.MarshalToSizedBuffer(dAtA[:m.Size()])
}

func (m *Expr_ListExpr) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.ListExpr != nil {
		{
			size, err := m.ListExpr.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSyntax(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	return len(dAtA) - i, nil
}
func (m *Expr_StructExpr) MarshalTo(dAtA []byte) (int, error) {
	return m.MarshalToSizedBuffer(dAtA[:m.Size()])
}

func (m *Expr_StructExpr) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.StructExpr != nil {
		{
			size, err := m.StructExpr.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSyntax(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x42
	}
	return len(dAtA) - i, nil
}
func (m *Expr_ComprehensionExpr) MarshalTo(dAtA []byte) (int, error) {
	return m.MarshalToSizedBuffer(dAtA[:m.Size()])
}

func (m *Expr_ComprehensionExpr) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.ComprehensionExpr != nil {
		{
			size, err := m.ComprehensionExpr.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSyntax(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x4a
	}
	return len(dAtA) - i, nil
}
func (m *Expr_Ident) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Expr_Ident) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Expr_Ident) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintSyntax(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Expr_Select) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Expr_Select) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Expr_Select) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.TestOnly {
		i--
		if m.TestOnly {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x18
	}
	if len(m.Field) > 0 {
		i -= len(m.Field)
		copy(dAtA[i:], m.Field)
		i = encodeVarintSyntax(dAtA, i, uint64(len(m.Field)))
		i--
		dAtA[i] = 0x12
	}
	if m.Operand != nil {
		{
			size, err := m.Operand.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSyntax(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Expr_Call) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Expr_Call) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Expr_Call) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Args) > 0 {
		for iNdEx := len(m.Args) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Args[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintSyntax(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.Function) > 0 {
		i -= len(m.Function)
		copy(dAtA[i:], m.Function)
		i = encodeVarintSyntax(dAtA, i, uint64(len(m.Function)))
		i--
		dAtA[i] = 0x12
	}
	if m.Target != nil {
		{
			size, err := m.Target.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSyntax(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Expr_CreateList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Expr_CreateList) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Expr_CreateList) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Elements) > 0 {
		for iNdEx := len(m.Elements) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Elements[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintSyntax(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *Expr_CreateStruct) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Expr_CreateStruct) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Expr_CreateStruct) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Entries) > 0 {
		for iNdEx := len(m.Entries) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Entries[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintSyntax(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.MessageName) > 0 {
		i -= len(m.MessageName)
		copy(dAtA[i:], m.MessageName)
		i = encodeVarintSyntax(dAtA, i, uint64(len(m.MessageName)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Expr_CreateStruct_Entry) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Expr_CreateStruct_Entry) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Expr_CreateStruct_Entry) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Value != nil {
		{
			size, err := m.Value.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSyntax(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if m.KeyKind != nil {
		{
			size := m.KeyKind.Size()
			i -= size
			if _, err := m.KeyKind.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	if m.Id != 0 {
		i = encodeVarintSyntax(dAtA, i, uint64(m.Id))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *Expr_CreateStruct_Entry_FieldKey) MarshalTo(dAtA []byte) (int, error) {
	return m.MarshalToSizedBuffer(dAtA[:m.Size()])
}

func (m *Expr_CreateStruct_Entry_FieldKey) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i -= len(m.FieldKey)
	copy(dAtA[i:], m.FieldKey)
	i = encodeVarintSyntax(dAtA, i, uint64(len(m.FieldKey)))
	i--
	dAtA[i] = 0x12
	return len(dAtA) - i, nil
}
func (m *Expr_CreateStruct_Entry_MapKey) MarshalTo(dAtA []byte) (int, error) {
	return m.MarshalToSizedBuffer(dAtA[:m.Size()])
}

func (m *Expr_CreateStruct_Entry_MapKey) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.MapKey != nil {
		{
			size, err := m.MapKey.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSyntax(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	return len(dAtA) - i, nil
}
func (m *Expr_Comprehension) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Expr_Comprehension) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Expr_Comprehension) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Result != nil {
		{
			size, err := m.Result.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSyntax(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	if m.LoopStep != nil {
		{
			size, err := m.LoopStep.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSyntax(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	if m.LoopCondition != nil {
		{
			size, err := m.LoopCondition.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSyntax(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if m.AccuInit != nil {
		{
			size, err := m.AccuInit.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSyntax(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if len(m.AccuVar) > 0 {
		i -= len(m.AccuVar)
		copy(dAtA[i:], m.AccuVar)
		i = encodeVarintSyntax(dAtA, i, uint64(len(m.AccuVar)))
		i--
		dAtA[i] = 0x1a
	}
	if m.IterRange != nil {
		{
			size, err := m.IterRange.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSyntax(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.IterVar) > 0 {
		i -= len(m.IterVar)
		copy(dAtA[i:], m.IterVar)
		i = encodeVarintSyntax(dAtA, i, uint64(len(m.IterVar)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Constant) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Constant) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Constant) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.ConstantKind != nil {
		{
			size := m.ConstantKind.Size()
			i -= size
			if _, err := m.ConstantKind.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	return len(dAtA) - i, nil
}

func (m *Constant_NullValue) MarshalTo(dAtA []byte) (int, error) {
	return m.MarshalToSizedBuffer(dAtA[:m.Size()])
}

func (m *Constant_NullValue) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i = encodeVarintSyntax(dAtA, i, uint64(m.NullValue))
	i--
	dAtA[i] = 0x8
	return len(dAtA) - i, nil
}
func (m *Constant_BoolValue) MarshalTo(dAtA []byte) (int, error) {
	return m.MarshalToSizedBuffer(dAtA[:m.Size()])
}

func (m *Constant_BoolValue) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i--
	if m.BoolValue {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i--
	dAtA[i] = 0x10
	return len(dAtA) - i, nil
}
func (m *Constant_Int64Value) MarshalTo(dAtA []byte) (int, error) {
	return m.MarshalToSizedBuffer(dAtA[:m.Size()])
}

func (m *Constant_Int64Value) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i = encodeVarintSyntax(dAtA, i, uint64(m.Int64Value))
	i--
	dAtA[i] = 0x18
	return len(dAtA) - i, nil
}
func (m *Constant_Uint64Value) MarshalTo(dAtA []byte) (int, error) {
	return m.MarshalToSizedBuffer(dAtA[:m.Size()])
}

func (m *Constant_Uint64Value) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i = encodeVarintSyntax(dAtA, i, uint64(m.Uint64Value))
	i--
	dAtA[i] = 0x20
	return len(dAtA) - i, nil
}
func (m *Constant_DoubleValue) MarshalTo(dAtA []byte) (int, error) {
	return m.MarshalToSizedBuffer(dAtA[:m.Size()])
}

func (m *Constant_DoubleValue) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i -= 8
	encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.DoubleValue))))
	i--
	dAtA[i] = 0x29
	return len(dAtA) - i, nil
}
func (m *Constant_StringValue) MarshalTo(dAtA []byte) (int, error) {
	return m.MarshalToSizedBuffer(dAtA[:m.Size()])
}

func (m *Constant_StringValue) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i -= len(m.StringValue)
	copy(dAtA[i:], m.StringValue)
	i = encodeVarintSyntax(dAtA, i, uint64(len(m.StringValue)))
	i--
	dAtA[i] = 0x32
	return len(dAtA) - i, nil
}
func (m *Constant_BytesValue) MarshalTo(dAtA []byte) (int, error) {
	return m.MarshalToSizedBuffer(dAtA[:m.Size()])
}

func (m *Constant_BytesValue) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.BytesValue != nil {
		i -= len(m.BytesValue)
		copy(dAtA[i:], m.BytesValue)
		i = encodeVarintSyntax(dAtA, i, uint64(len(m.BytesValue)))
		i--
		dAtA[i] = 0x3a
	}
	return len(dAtA) - i, nil
}
func (m *Constant_DurationValue) MarshalTo(dAtA []byte) (int, error) {
	return m.MarshalToSizedBuffer(dAtA[:m.Size()])
}

func (m *Constant_DurationValue) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.DurationValue != nil {
		{
			size, err := m.DurationValue.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSyntax(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x42
	}
	return len(dAtA) - i, nil
}
func (m *Constant_TimestampValue) MarshalTo(dAtA []byte) (int, error) {
	return m.MarshalToSizedBuffer(dAtA[:m.Size()])
}

func (m *Constant_TimestampValue) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.TimestampValue != nil {
		{
			size, err := m.TimestampValue.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSyntax(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x4a
	}
	return len(dAtA) - i, nil
}
func (m *SourceInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SourceInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SourceInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Positions) > 0 {
		for k := range m.Positions {
			v := m.Positions[k]
			baseI := i
			i = encodeVarintSyntax(dAtA, i, uint64(v))
			i--
			dAtA[i] = 0x10
			i = encodeVarintSyntax(dAtA, i, uint64(k))
			i--
			dAtA[i] = 0x8
			i = encodeVarintSyntax(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x22
		}
	}
	if len(m.LineOffsets) > 0 {
		dAtA22 := make([]byte, len(m.LineOffsets)*10)
		var j21 int
		for _, num1 := range m.LineOffsets {
			num := uint64(num1)
			for num >= 1<<7 {
				dAtA22[j21] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j21++
			}
			dAtA22[j21] = uint8(num)
			j21++
		}
		i -= j21
		copy(dAtA[i:], dAtA22[:j21])
		i = encodeVarintSyntax(dAtA, i, uint64(j21))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Location) > 0 {
		i -= len(m.Location)
		copy(dAtA[i:], m.Location)
		i = encodeVarintSyntax(dAtA, i, uint64(len(m.Location)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.SyntaxVersion) > 0 {
		i -= len(m.SyntaxVersion)
		copy(dAtA[i:], m.SyntaxVersion)
		i = encodeVarintSyntax(dAtA, i, uint64(len(m.SyntaxVersion)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *SourcePosition) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SourcePosition) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SourcePosition) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Column != 0 {
		i = encodeVarintSyntax(dAtA, i, uint64(m.Column))
		i--
		dAtA[i] = 0x20
	}
	if m.Line != 0 {
		i = encodeVarintSyntax(dAtA, i, uint64(m.Line))
		i--
		dAtA[i] = 0x18
	}
	if m.Offset != 0 {
		i = encodeVarintSyntax(dAtA, i, uint64(m.Offset))
		i--
		dAtA[i] = 0x10
	}
	if len(m.Location) > 0 {
		i -= len(m.Location)
		copy(dAtA[i:], m.Location)
		i = encodeVarintSyntax(dAtA, i, uint64(len(m.Location)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintSyntax(dAtA []byte, offset int, v uint64) int {
	offset -= sovSyntax(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *ParsedExpr) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Expr != nil {
		l = m.Expr.Size()
		n += 1 + l + sovSyntax(uint64(l))
	}
	if m.SourceInfo != nil {
		l = m.SourceInfo.Size()
		n += 1 + l + sovSyntax(uint64(l))
	}
	return n
}

func (m *Expr) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Id != 0 {
		n += 1 + sovSyntax(uint64(m.Id))
	}
	if m.ExprKind != nil {
		n += m.ExprKind.Size()
	}
	return n
}

func (m *Expr_ConstExpr) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ConstExpr != nil {
		l = m.ConstExpr.Size()
		n += 1 + l + sovSyntax(uint64(l))
	}
	return n
}
func (m *Expr_IdentExpr) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.IdentExpr != nil {
		l = m.IdentExpr.Size()
		n += 1 + l + sovSyntax(uint64(l))
	}
	return n
}
func (m *Expr_SelectExpr) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.SelectExpr != nil {
		l = m.SelectExpr.Size()
		n += 1 + l + sovSyntax(uint64(l))
	}
	return n
}
func (m *Expr_CallExpr) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.CallExpr != nil {
		l = m.CallExpr.Size()
		n += 1 + l + sovSyntax(uint64(l))
	}
	return n
}
func (m *Expr_ListExpr) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ListExpr != nil {
		l = m.ListExpr.Size()
		n += 1 + l + sovSyntax(uint64(l))
	}
	return n
}
func (m *Expr_StructExpr) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.StructExpr != nil {
		l = m.StructExpr.Size()
		n += 1 + l + sovSyntax(uint64(l))
	}
	return n
}
func (m *Expr_ComprehensionExpr) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ComprehensionExpr != nil {
		l = m.ComprehensionExpr.Size()
		n += 1 + l + sovSyntax(uint64(l))
	}
	return n
}
func (m *Expr_Ident) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovSyntax(uint64(l))
	}
	return n
}

func (m *Expr_Select) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Operand != nil {
		l = m.Operand.Size()
		n += 1 + l + sovSyntax(uint64(l))
	}
	l = len(m.Field)
	if l > 0 {
		n += 1 + l + sovSyntax(uint64(l))
	}
	if m.TestOnly {
		n += 2
	}
	return n
}

func (m *Expr_Call) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Target != nil {
		l = m.Target.Size()
		n += 1 + l + sovSyntax(uint64(l))
	}
	l = len(m.Function)
	if l > 0 {
		n += 1 + l + sovSyntax(uint64(l))
	}
	if len(m.Args) > 0 {
		for _, e := range m.Args {
			l = e.Size()
			n += 1 + l + sovSyntax(uint64(l))
		}
	}
	return n
}

func (m *Expr_CreateList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Elements) > 0 {
		for _, e := range m.Elements {
			l = e.Size()
			n += 1 + l + sovSyntax(uint64(l))
		}
	}
	return n
}

func (m *Expr_CreateStruct) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.MessageName)
	if l > 0 {
		n += 1 + l + sovSyntax(uint64(l))
	}
	if len(m.Entries) > 0 {
		for _, e := range m.Entries {
			l = e.Size()
			n += 1 + l + sovSyntax(uint64(l))
		}
	}
	return n
}

func (m *Expr_CreateStruct_Entry) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Id != 0 {
		n += 1 + sovSyntax(uint64(m.Id))
	}
	if m.KeyKind != nil {
		n += m.KeyKind.Size()
	}
	if m.Value != nil {
		l = m.Value.Size()
		n += 1 + l + sovSyntax(uint64(l))
	}
	return n
}

func (m *Expr_CreateStruct_Entry_FieldKey) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.FieldKey)
	n += 1 + l + sovSyntax(uint64(l))
	return n
}
func (m *Expr_CreateStruct_Entry_MapKey) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.MapKey != nil {
		l = m.MapKey.Size()
		n += 1 + l + sovSyntax(uint64(l))
	}
	return n
}
func (m *Expr_Comprehension) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.IterVar)
	if l > 0 {
		n += 1 + l + sovSyntax(uint64(l))
	}
	if m.IterRange != nil {
		l = m.IterRange.Size()
		n += 1 + l + sovSyntax(uint64(l))
	}
	l = len(m.AccuVar)
	if l > 0 {
		n += 1 + l + sovSyntax(uint64(l))
	}
	if m.AccuInit != nil {
		l = m.AccuInit.Size()
		n += 1 + l + sovSyntax(uint64(l))
	}
	if m.LoopCondition != nil {
		l = m.LoopCondition.Size()
		n += 1 + l + sovSyntax(uint64(l))
	}
	if m.LoopStep != nil {
		l = m.LoopStep.Size()
		n += 1 + l + sovSyntax(uint64(l))
	}
	if m.Result != nil {
		l = m.Result.Size()
		n += 1 + l + sovSyntax(uint64(l))
	}
	return n
}

func (m *Constant) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ConstantKind != nil {
		n += m.ConstantKind.Size()
	}
	return n
}

func (m *Constant_NullValue) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 1 + sovSyntax(uint64(m.NullValue))
	return n
}
func (m *Constant_BoolValue) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 2
	return n
}
func (m *Constant_Int64Value) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 1 + sovSyntax(uint64(m.Int64Value))
	return n
}
func (m *Constant_Uint64Value) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 1 + sovSyntax(uint64(m.Uint64Value))
	return n
}
func (m *Constant_DoubleValue) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 9
	return n
}
func (m *Constant_StringValue) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.StringValue)
	n += 1 + l + sovSyntax(uint64(l))
	return n
}
func (m *Constant_BytesValue) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.BytesValue != nil {
		l = len(m.BytesValue)
		n += 1 + l + sovSyntax(uint64(l))
	}
	return n
}
func (m *Constant_DurationValue) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.DurationValue != nil {
		l = m.DurationValue.Size()
		n += 1 + l + sovSyntax(uint64(l))
	}
	return n
}
func (m *Constant_TimestampValue) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.TimestampValue != nil {
		l = m.TimestampValue.Size()
		n += 1 + l + sovSyntax(uint64(l))
	}
	return n
}
func (m *SourceInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.SyntaxVersion)
	if l > 0 {
		n += 1 + l + sovSyntax(uint64(l))
	}
	l = len(m.Location)
	if l > 0 {
		n += 1 + l + sovSyntax(uint64(l))
	}
	if len(m.LineOffsets) > 0 {
		l = 0
		for _, e := range m.LineOffsets {
			l += sovSyntax(uint64(e))
		}
		n += 1 + sovSyntax(uint64(l)) + l
	}
	if len(m.Positions) > 0 {
		for k, v := range m.Positions {
			_ = k
			_ = v
			mapEntrySize := 1 + sovSyntax(uint64(k)) + 1 + sovSyntax(uint64(v))
			n += mapEntrySize + 1 + sovSyntax(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *SourcePosition) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Location)
	if l > 0 {
		n += 1 + l + sovSyntax(uint64(l))
	}
	if m.Offset != 0 {
		n += 1 + sovSyntax(uint64(m.Offset))
	}
	if m.Line != 0 {
		n += 1 + sovSyntax(uint64(m.Line))
	}
	if m.Column != 0 {
		n += 1 + sovSyntax(uint64(m.Column))
	}
	return n
}

func sovSyntax(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozSyntax(x uint64) (n int) {
	return sovSyntax(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *ParsedExpr) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSyntax
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ParsedExpr: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ParsedExpr: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Expr", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSyntax
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSyntax
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSyntax
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Expr == nil {
				m.Expr = &Expr{}
			}
			if err := m.Expr.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSyntax
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSyntax
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSyntax
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SourceInfo == nil {
				m.SourceInfo = &SourceInfo{}
			}
			if err := m.SourceInfo.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSyntax(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSyntax
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthSyntax
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Expr) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSyntax
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Expr: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Expr: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			m.Id = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSyntax
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Id |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConstExpr", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSyntax
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSyntax
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSyntax
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Constant{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.ExprKind = &Expr_ConstExpr{v}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IdentExpr", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSyntax
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSyntax
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSyntax
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Expr_Ident{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.ExprKind = &Expr_IdentExpr{v}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SelectExpr", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSyntax
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSyntax
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSyntax
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Expr_Select{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.ExprKind = &Expr_SelectExpr{v}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CallExpr", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSyntax
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSyntax
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSyntax
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Expr_Call{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.ExprKind = &Expr_CallExpr{v}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ListExpr", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSyntax
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSyntax
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSyntax
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Expr_CreateList{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.ExprKind = &Expr_ListExpr{v}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StructExpr", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSyntax
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSyntax
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSyntax
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Expr_CreateStruct{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.ExprKind = &Expr_StructExpr{v}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ComprehensionExpr", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSyntax
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSyntax
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSyntax
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Expr_Comprehension{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.ExprKind = &Expr_ComprehensionExpr{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSyntax(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSyntax
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthSyntax
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Expr_Ident) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSyntax
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Ident: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Ident: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSyntax
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSyntax
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSyntax
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSyntax(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSyntax
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthSyntax
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Expr_Select) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSyntax
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Select: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Select: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Operand", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSyntax
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSyntax
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSyntax
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Operand == nil {
				m.Operand = &Expr{}
			}
			if err := m.Operand.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Field", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSyntax
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSyntax
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSyntax
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Field = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TestOnly", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSyntax
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.TestOnly = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipSyntax(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSyntax
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthSyntax
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Expr_Call) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSyntax
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Call: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Call: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Target", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSyntax
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSyntax
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSyntax
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Target == nil {
				m.Target = &Expr{}
			}
			if err := m.Target.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Function", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSyntax
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSyntax
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSyntax
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Function = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Args", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSyntax
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSyntax
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSyntax
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Args = append(m.Args, &Expr{})
			if err := m.Args[len(m.Args)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSyntax(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSyntax
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthSyntax
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Expr_CreateList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSyntax
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CreateList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CreateList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Elements", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSyntax
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSyntax
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSyntax
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Elements = append(m.Elements, &Expr{})
			if err := m.Elements[len(m.Elements)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSyntax(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSyntax
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthSyntax
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Expr_CreateStruct) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSyntax
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CreateStruct: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CreateStruct: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MessageName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSyntax
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSyntax
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSyntax
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.MessageName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Entries", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSyntax
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSyntax
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSyntax
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Entries = append(m.Entries, &Expr_CreateStruct_Entry{})
			if err := m.Entries[len(m.Entries)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSyntax(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSyntax
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthSyntax
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Expr_CreateStruct_Entry) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSyntax
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Entry: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Entry: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			m.Id = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSyntax
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Id |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FieldKey", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSyntax
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSyntax
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSyntax
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.KeyKind = &Expr_CreateStruct_Entry_FieldKey{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MapKey", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSyntax
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSyntax
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSyntax
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Expr{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.KeyKind = &Expr_CreateStruct_Entry_MapKey{v}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSyntax
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSyntax
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSyntax
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Value == nil {
				m.Value = &Expr{}
			}
			if err := m.Value.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSyntax(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSyntax
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthSyntax
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Expr_Comprehension) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSyntax
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Comprehension: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Comprehension: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IterVar", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSyntax
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSyntax
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSyntax
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.IterVar = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IterRange", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSyntax
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSyntax
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSyntax
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.IterRange == nil {
				m.IterRange = &Expr{}
			}
			if err := m.IterRange.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AccuVar", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSyntax
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSyntax
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSyntax
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AccuVar = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AccuInit", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSyntax
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSyntax
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSyntax
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AccuInit == nil {
				m.AccuInit = &Expr{}
			}
			if err := m.AccuInit.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LoopCondition", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSyntax
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSyntax
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSyntax
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LoopCondition == nil {
				m.LoopCondition = &Expr{}
			}
			if err := m.LoopCondition.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LoopStep", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSyntax
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSyntax
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSyntax
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LoopStep == nil {
				m.LoopStep = &Expr{}
			}
			if err := m.LoopStep.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Result", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSyntax
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSyntax
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSyntax
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Result == nil {
				m.Result = &Expr{}
			}
			if err := m.Result.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSyntax(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSyntax
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthSyntax
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Constant) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSyntax
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Constant: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Constant: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NullValue", wireType)
			}
			var v types.NullValue
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSyntax
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= types.NullValue(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ConstantKind = &Constant_NullValue{v}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field BoolValue", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSyntax
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.ConstantKind = &Constant_BoolValue{b}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Int64Value", wireType)
			}
			var v int64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSyntax
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ConstantKind = &Constant_Int64Value{v}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Uint64Value", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSyntax
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ConstantKind = &Constant_Uint64Value{v}
		case 5:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field DoubleValue", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.ConstantKind = &Constant_DoubleValue{float64(math.Float64frombits(v))}
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StringValue", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSyntax
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSyntax
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSyntax
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ConstantKind = &Constant_StringValue{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BytesValue", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSyntax
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthSyntax
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthSyntax
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := make([]byte, postIndex-iNdEx)
			copy(v, dAtA[iNdEx:postIndex])
			m.ConstantKind = &Constant_BytesValue{v}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DurationValue", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSyntax
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSyntax
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSyntax
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &types.Duration{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.ConstantKind = &Constant_DurationValue{v}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimestampValue", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSyntax
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSyntax
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSyntax
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &types.Timestamp{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.ConstantKind = &Constant_TimestampValue{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSyntax(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSyntax
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthSyntax
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SourceInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSyntax
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SourceInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SourceInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SyntaxVersion", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSyntax
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSyntax
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSyntax
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SyntaxVersion = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Location", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSyntax
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSyntax
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSyntax
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Location = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType == 0 {
				var v int32
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowSyntax
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= int32(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.LineOffsets = append(m.LineOffsets, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowSyntax
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthSyntax
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthSyntax
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				var count int
				for _, integer := range dAtA[iNdEx:postIndex] {
					if integer < 128 {
						count++
					}
				}
				elementCount = count
				if elementCount != 0 && len(m.LineOffsets) == 0 {
					m.LineOffsets = make([]int32, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v int32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowSyntax
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= int32(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.LineOffsets = append(m.LineOffsets, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field LineOffsets", wireType)
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Positions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSyntax
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSyntax
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSyntax
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Positions == nil {
				m.Positions = make(map[int64]int32)
			}
			var mapkey int64
			var mapvalue int32
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowSyntax
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowSyntax
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapkey |= int64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else if fieldNum == 2 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowSyntax
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapvalue |= int32(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipSyntax(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthSyntax
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Positions[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSyntax(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSyntax
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthSyntax
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SourcePosition) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSyntax
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SourcePosition: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SourcePosition: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Location", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSyntax
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSyntax
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSyntax
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Location = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Offset", wireType)
			}
			m.Offset = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSyntax
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Offset |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Line", wireType)
			}
			m.Line = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSyntax
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Line |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Column", wireType)
			}
			m.Column = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSyntax
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Column |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipSyntax(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSyntax
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthSyntax
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipSyntax(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowSyntax
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowSyntax
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowSyntax
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthSyntax
			}
			iNdEx += length
			if iNdEx < 0 {
				return 0, ErrInvalidLengthSyntax
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowSyntax
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipSyntax(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
				if iNdEx < 0 {
					return 0, ErrInvalidLengthSyntax
				}
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthSyntax = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowSyntax   = fmt.Errorf("proto: integer overflow")
)
