// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: k8s.io/api/core/v1/generated.proto

package k8s_io_api_core_v1

import (
	bytes "bytes"
	fmt "fmt"
	proto "github.com/gogo/protobuf/proto"
	github_com_gogo_protobuf_sortkeys "github.com/gogo/protobuf/sortkeys"
	io "io"
	resource "istio.io/gogo-genproto/k8s.io/apimachinery/pkg/api/resource"
	v1 "istio.io/gogo-genproto/k8s.io/apimachinery/pkg/apis/meta/v1"
	runtime "istio.io/gogo-genproto/k8s.io/apimachinery/pkg/runtime"
	_ "istio.io/gogo-genproto/k8s.io/apimachinery/pkg/runtime/schema"
	intstr "istio.io/gogo-genproto/k8s.io/apimachinery/pkg/util/intstr"
	math "math"
	math_bits "math/bits"
	reflect "reflect"
	strings "strings"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

// Represents a Persistent Disk resource in AWS.
//
// An AWS EBS disk must exist before mounting to a container. The disk
// must also be in the same AWS zone as the kubelet. An AWS EBS disk
// can only be mounted as read/write once. AWS EBS volumes support
// ownership management and SELinux relabeling.
type AWSElasticBlockStoreVolumeSource struct {
	// Unique ID of the persistent disk resource in AWS (Amazon EBS volume).
	// More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
	VolumeID string `protobuf:"bytes,1,opt,name=volumeID" json:"volumeID"`
	// Filesystem type of the volume that you want to mount.
	// Tip: Ensure that the filesystem type is supported by the host operating system.
	// Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
	// More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
	// TODO: how do we prevent errors in the filesystem from compromising the machine
	// +optional
	FsType string `protobuf:"bytes,2,opt,name=fsType" json:"fsType"`
	// The partition in the volume that you want to mount.
	// If omitted, the default is to mount by volume name.
	// Examples: For volume /dev/sda1, you specify the partition as "1".
	// Similarly, the volume partition for /dev/sda is "0" (or you can leave the property empty).
	// +optional
	Partition int32 `protobuf:"varint,3,opt,name=partition" json:"partition"`
	// Specify "true" to force and set the ReadOnly property in VolumeMounts to "true".
	// If omitted, the default is "false".
	// More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
	// +optional
	ReadOnly bool `protobuf:"varint,4,opt,name=readOnly" json:"readOnly"`
}

func (m *AWSElasticBlockStoreVolumeSource) Reset()      { *m = AWSElasticBlockStoreVolumeSource{} }
func (*AWSElasticBlockStoreVolumeSource) ProtoMessage() {}
func (*AWSElasticBlockStoreVolumeSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{0}
}
func (m *AWSElasticBlockStoreVolumeSource) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AWSElasticBlockStoreVolumeSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AWSElasticBlockStoreVolumeSource.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AWSElasticBlockStoreVolumeSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AWSElasticBlockStoreVolumeSource.Merge(m, src)
}
func (m *AWSElasticBlockStoreVolumeSource) XXX_Size() int {
	return m.Size()
}
func (m *AWSElasticBlockStoreVolumeSource) XXX_DiscardUnknown() {
	xxx_messageInfo_AWSElasticBlockStoreVolumeSource.DiscardUnknown(m)
}

var xxx_messageInfo_AWSElasticBlockStoreVolumeSource proto.InternalMessageInfo

func (m *AWSElasticBlockStoreVolumeSource) GetVolumeID() string {
	if m != nil {
		return m.VolumeID
	}
	return ""
}

func (m *AWSElasticBlockStoreVolumeSource) GetFsType() string {
	if m != nil {
		return m.FsType
	}
	return ""
}

func (m *AWSElasticBlockStoreVolumeSource) GetPartition() int32 {
	if m != nil {
		return m.Partition
	}
	return 0
}

func (m *AWSElasticBlockStoreVolumeSource) GetReadOnly() bool {
	if m != nil {
		return m.ReadOnly
	}
	return false
}

// Affinity is a group of affinity scheduling rules.
type Affinity struct {
	// Describes node affinity scheduling rules for the pod.
	// +optional
	NodeAffinity *NodeAffinity `protobuf:"bytes,1,opt,name=nodeAffinity" json:"nodeAffinity,omitempty"`
	// Describes pod affinity scheduling rules (e.g. co-locate this pod in the same node, zone, etc. as some other pod(s)).
	// +optional
	PodAffinity *PodAffinity `protobuf:"bytes,2,opt,name=podAffinity" json:"podAffinity,omitempty"`
	// Describes pod anti-affinity scheduling rules (e.g. avoid putting this pod in the same node, zone, etc. as some other pod(s)).
	// +optional
	PodAntiAffinity *PodAntiAffinity `protobuf:"bytes,3,opt,name=podAntiAffinity" json:"podAntiAffinity,omitempty"`
}

func (m *Affinity) Reset()      { *m = Affinity{} }
func (*Affinity) ProtoMessage() {}
func (*Affinity) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{1}
}
func (m *Affinity) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Affinity) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Affinity.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Affinity) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Affinity.Merge(m, src)
}
func (m *Affinity) XXX_Size() int {
	return m.Size()
}
func (m *Affinity) XXX_DiscardUnknown() {
	xxx_messageInfo_Affinity.DiscardUnknown(m)
}

var xxx_messageInfo_Affinity proto.InternalMessageInfo

func (m *Affinity) GetNodeAffinity() *NodeAffinity {
	if m != nil {
		return m.NodeAffinity
	}
	return nil
}

func (m *Affinity) GetPodAffinity() *PodAffinity {
	if m != nil {
		return m.PodAffinity
	}
	return nil
}

func (m *Affinity) GetPodAntiAffinity() *PodAntiAffinity {
	if m != nil {
		return m.PodAntiAffinity
	}
	return nil
}

// AttachedVolume describes a volume attached to a node
type AttachedVolume struct {
	// Name of the attached volume
	Name string `protobuf:"bytes,1,opt,name=name" json:"name"`
	// DevicePath represents the device path where the volume should be available
	DevicePath string `protobuf:"bytes,2,opt,name=devicePath" json:"devicePath"`
}

func (m *AttachedVolume) Reset()      { *m = AttachedVolume{} }
func (*AttachedVolume) ProtoMessage() {}
func (*AttachedVolume) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{2}
}
func (m *AttachedVolume) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AttachedVolume) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AttachedVolume.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AttachedVolume) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AttachedVolume.Merge(m, src)
}
func (m *AttachedVolume) XXX_Size() int {
	return m.Size()
}
func (m *AttachedVolume) XXX_DiscardUnknown() {
	xxx_messageInfo_AttachedVolume.DiscardUnknown(m)
}

var xxx_messageInfo_AttachedVolume proto.InternalMessageInfo

func (m *AttachedVolume) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *AttachedVolume) GetDevicePath() string {
	if m != nil {
		return m.DevicePath
	}
	return ""
}

// AvoidPods describes pods that should avoid this node. This is the value for a
// Node annotation with key scheduler.alpha.kubernetes.io/preferAvoidPods and
// will eventually become a field of NodeStatus.
type AvoidPods struct {
	// Bounded-sized list of signatures of pods that should avoid this node, sorted
	// in timestamp order from oldest to newest. Size of the slice is unspecified.
	// +optional
	PreferAvoidPods []*PreferAvoidPodsEntry `protobuf:"bytes,1,rep,name=preferAvoidPods" json:"preferAvoidPods,omitempty"`
}

func (m *AvoidPods) Reset()      { *m = AvoidPods{} }
func (*AvoidPods) ProtoMessage() {}
func (*AvoidPods) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{3}
}
func (m *AvoidPods) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AvoidPods) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AvoidPods.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AvoidPods) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AvoidPods.Merge(m, src)
}
func (m *AvoidPods) XXX_Size() int {
	return m.Size()
}
func (m *AvoidPods) XXX_DiscardUnknown() {
	xxx_messageInfo_AvoidPods.DiscardUnknown(m)
}

var xxx_messageInfo_AvoidPods proto.InternalMessageInfo

func (m *AvoidPods) GetPreferAvoidPods() []*PreferAvoidPodsEntry {
	if m != nil {
		return m.PreferAvoidPods
	}
	return nil
}

// AzureDisk represents an Azure Data Disk mount on the host and bind mount to the pod.
type AzureDiskVolumeSource struct {
	// The Name of the data disk in the blob storage
	DiskName string `protobuf:"bytes,1,opt,name=diskName" json:"diskName"`
	// The URI the data disk in the blob storage
	DiskURI string `protobuf:"bytes,2,opt,name=diskURI" json:"diskURI"`
	// Host Caching mode: None, Read Only, Read Write.
	// +optional
	CachingMode string `protobuf:"bytes,3,opt,name=cachingMode" json:"cachingMode"`
	// Filesystem type to mount.
	// Must be a filesystem type supported by the host operating system.
	// Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
	// +optional
	FsType string `protobuf:"bytes,4,opt,name=fsType" json:"fsType"`
	// Defaults to false (read/write). ReadOnly here will force
	// the ReadOnly setting in VolumeMounts.
	// +optional
	ReadOnly bool `protobuf:"varint,5,opt,name=readOnly" json:"readOnly"`
	// Expected values Shared: multiple blob disks per storage account  Dedicated: single blob disk per storage account  Managed: azure managed data disk (only in managed availability set). defaults to shared
	Kind string `protobuf:"bytes,6,opt,name=kind" json:"kind"`
}

func (m *AzureDiskVolumeSource) Reset()      { *m = AzureDiskVolumeSource{} }
func (*AzureDiskVolumeSource) ProtoMessage() {}
func (*AzureDiskVolumeSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{4}
}
func (m *AzureDiskVolumeSource) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AzureDiskVolumeSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AzureDiskVolumeSource.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AzureDiskVolumeSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AzureDiskVolumeSource.Merge(m, src)
}
func (m *AzureDiskVolumeSource) XXX_Size() int {
	return m.Size()
}
func (m *AzureDiskVolumeSource) XXX_DiscardUnknown() {
	xxx_messageInfo_AzureDiskVolumeSource.DiscardUnknown(m)
}

var xxx_messageInfo_AzureDiskVolumeSource proto.InternalMessageInfo

func (m *AzureDiskVolumeSource) GetDiskName() string {
	if m != nil {
		return m.DiskName
	}
	return ""
}

func (m *AzureDiskVolumeSource) GetDiskURI() string {
	if m != nil {
		return m.DiskURI
	}
	return ""
}

func (m *AzureDiskVolumeSource) GetCachingMode() string {
	if m != nil {
		return m.CachingMode
	}
	return ""
}

func (m *AzureDiskVolumeSource) GetFsType() string {
	if m != nil {
		return m.FsType
	}
	return ""
}

func (m *AzureDiskVolumeSource) GetReadOnly() bool {
	if m != nil {
		return m.ReadOnly
	}
	return false
}

func (m *AzureDiskVolumeSource) GetKind() string {
	if m != nil {
		return m.Kind
	}
	return ""
}

// AzureFile represents an Azure File Service mount on the host and bind mount to the pod.
type AzureFilePersistentVolumeSource struct {
	// the name of secret that contains Azure Storage Account Name and Key
	SecretName string `protobuf:"bytes,1,opt,name=secretName" json:"secretName"`
	// Share Name
	ShareName string `protobuf:"bytes,2,opt,name=shareName" json:"shareName"`
	// Defaults to false (read/write). ReadOnly here will force
	// the ReadOnly setting in VolumeMounts.
	// +optional
	ReadOnly bool `protobuf:"varint,3,opt,name=readOnly" json:"readOnly"`
	// the namespace of the secret that contains Azure Storage Account Name and Key
	// default is the same as the Pod
	// +optional
	SecretNamespace string `protobuf:"bytes,4,opt,name=secretNamespace" json:"secretNamespace"`
}

func (m *AzureFilePersistentVolumeSource) Reset()      { *m = AzureFilePersistentVolumeSource{} }
func (*AzureFilePersistentVolumeSource) ProtoMessage() {}
func (*AzureFilePersistentVolumeSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{5}
}
func (m *AzureFilePersistentVolumeSource) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AzureFilePersistentVolumeSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AzureFilePersistentVolumeSource.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AzureFilePersistentVolumeSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AzureFilePersistentVolumeSource.Merge(m, src)
}
func (m *AzureFilePersistentVolumeSource) XXX_Size() int {
	return m.Size()
}
func (m *AzureFilePersistentVolumeSource) XXX_DiscardUnknown() {
	xxx_messageInfo_AzureFilePersistentVolumeSource.DiscardUnknown(m)
}

var xxx_messageInfo_AzureFilePersistentVolumeSource proto.InternalMessageInfo

func (m *AzureFilePersistentVolumeSource) GetSecretName() string {
	if m != nil {
		return m.SecretName
	}
	return ""
}

func (m *AzureFilePersistentVolumeSource) GetShareName() string {
	if m != nil {
		return m.ShareName
	}
	return ""
}

func (m *AzureFilePersistentVolumeSource) GetReadOnly() bool {
	if m != nil {
		return m.ReadOnly
	}
	return false
}

func (m *AzureFilePersistentVolumeSource) GetSecretNamespace() string {
	if m != nil {
		return m.SecretNamespace
	}
	return ""
}

// AzureFile represents an Azure File Service mount on the host and bind mount to the pod.
type AzureFileVolumeSource struct {
	// the name of secret that contains Azure Storage Account Name and Key
	SecretName string `protobuf:"bytes,1,opt,name=secretName" json:"secretName"`
	// Share Name
	ShareName string `protobuf:"bytes,2,opt,name=shareName" json:"shareName"`
	// Defaults to false (read/write). ReadOnly here will force
	// the ReadOnly setting in VolumeMounts.
	// +optional
	ReadOnly bool `protobuf:"varint,3,opt,name=readOnly" json:"readOnly"`
}

func (m *AzureFileVolumeSource) Reset()      { *m = AzureFileVolumeSource{} }
func (*AzureFileVolumeSource) ProtoMessage() {}
func (*AzureFileVolumeSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{6}
}
func (m *AzureFileVolumeSource) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AzureFileVolumeSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AzureFileVolumeSource.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AzureFileVolumeSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AzureFileVolumeSource.Merge(m, src)
}
func (m *AzureFileVolumeSource) XXX_Size() int {
	return m.Size()
}
func (m *AzureFileVolumeSource) XXX_DiscardUnknown() {
	xxx_messageInfo_AzureFileVolumeSource.DiscardUnknown(m)
}

var xxx_messageInfo_AzureFileVolumeSource proto.InternalMessageInfo

func (m *AzureFileVolumeSource) GetSecretName() string {
	if m != nil {
		return m.SecretName
	}
	return ""
}

func (m *AzureFileVolumeSource) GetShareName() string {
	if m != nil {
		return m.ShareName
	}
	return ""
}

func (m *AzureFileVolumeSource) GetReadOnly() bool {
	if m != nil {
		return m.ReadOnly
	}
	return false
}

// Binding ties one object to another; for example, a pod is bound to a node by a scheduler.
// Deprecated in 1.7, please use the bindings subresource of pods instead.
type Binding struct {
	// Standard object's metadata.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
	// +optional
	Metadata *v1.ObjectMeta `protobuf:"bytes,1,opt,name=metadata" json:"metadata,omitempty"`
	// The target object that you want to bind to the standard object.
	Target *ObjectReference `protobuf:"bytes,2,opt,name=target" json:"target,omitempty"`
}

func (m *Binding) Reset()      { *m = Binding{} }
func (*Binding) ProtoMessage() {}
func (*Binding) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{7}
}
func (m *Binding) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Binding) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Binding.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Binding) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Binding.Merge(m, src)
}
func (m *Binding) XXX_Size() int {
	return m.Size()
}
func (m *Binding) XXX_DiscardUnknown() {
	xxx_messageInfo_Binding.DiscardUnknown(m)
}

var xxx_messageInfo_Binding proto.InternalMessageInfo

func (m *Binding) GetMetadata() *v1.ObjectMeta {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *Binding) GetTarget() *ObjectReference {
	if m != nil {
		return m.Target
	}
	return nil
}

// Represents storage that is managed by an external CSI volume driver (Beta feature)
type CSIPersistentVolumeSource struct {
	// Driver is the name of the driver to use for this volume.
	// Required.
	Driver string `protobuf:"bytes,1,opt,name=driver" json:"driver"`
	// VolumeHandle is the unique volume name returned by the CSI volume
	// plugin’s CreateVolume to refer to the volume on all subsequent calls.
	// Required.
	VolumeHandle string `protobuf:"bytes,2,opt,name=volumeHandle" json:"volumeHandle"`
	// Optional: The value to pass to ControllerPublishVolumeRequest.
	// Defaults to false (read/write).
	// +optional
	ReadOnly bool `protobuf:"varint,3,opt,name=readOnly" json:"readOnly"`
	// Filesystem type to mount.
	// Must be a filesystem type supported by the host operating system.
	// Ex. "ext4", "xfs", "ntfs".
	// +optional
	FsType string `protobuf:"bytes,4,opt,name=fsType" json:"fsType"`
	// Attributes of the volume to publish.
	// +optional
	VolumeAttributes map[string]string `protobuf:"bytes,5,rep,name=volumeAttributes" json:"volumeAttributes,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// ControllerPublishSecretRef is a reference to the secret object containing
	// sensitive information to pass to the CSI driver to complete the CSI
	// ControllerPublishVolume and ControllerUnpublishVolume calls.
	// This field is optional, and may be empty if no secret is required. If the
	// secret object contains more than one secret, all secrets are passed.
	// +optional
	ControllerPublishSecretRef *SecretReference `protobuf:"bytes,6,opt,name=controllerPublishSecretRef" json:"controllerPublishSecretRef,omitempty"`
	// NodeStageSecretRef is a reference to the secret object containing sensitive
	// information to pass to the CSI driver to complete the CSI NodeStageVolume
	// and NodeStageVolume and NodeUnstageVolume calls.
	// This field is optional, and may be empty if no secret is required. If the
	// secret object contains more than one secret, all secrets are passed.
	// +optional
	NodeStageSecretRef *SecretReference `protobuf:"bytes,7,opt,name=nodeStageSecretRef" json:"nodeStageSecretRef,omitempty"`
	// NodePublishSecretRef is a reference to the secret object containing
	// sensitive information to pass to the CSI driver to complete the CSI
	// NodePublishVolume and NodeUnpublishVolume calls.
	// This field is optional, and may be empty if no secret is required. If the
	// secret object contains more than one secret, all secrets are passed.
	// +optional
	NodePublishSecretRef *SecretReference `protobuf:"bytes,8,opt,name=nodePublishSecretRef" json:"nodePublishSecretRef,omitempty"`
	// ControllerExpandSecretRef is a reference to the secret object containing
	// sensitive information to pass to the CSI driver to complete the CSI
	// ControllerExpandVolume call.
	// This is an alpha field and requires enabling ExpandCSIVolumes feature gate.
	// This field is optional, and may be empty if no secret is required. If the
	// secret object contains more than one secret, all secrets are passed.
	// +optional
	ControllerExpandSecretRef *SecretReference `protobuf:"bytes,9,opt,name=controllerExpandSecretRef" json:"controllerExpandSecretRef,omitempty"`
}

func (m *CSIPersistentVolumeSource) Reset()      { *m = CSIPersistentVolumeSource{} }
func (*CSIPersistentVolumeSource) ProtoMessage() {}
func (*CSIPersistentVolumeSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{8}
}
func (m *CSIPersistentVolumeSource) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CSIPersistentVolumeSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CSIPersistentVolumeSource.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CSIPersistentVolumeSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CSIPersistentVolumeSource.Merge(m, src)
}
func (m *CSIPersistentVolumeSource) XXX_Size() int {
	return m.Size()
}
func (m *CSIPersistentVolumeSource) XXX_DiscardUnknown() {
	xxx_messageInfo_CSIPersistentVolumeSource.DiscardUnknown(m)
}

var xxx_messageInfo_CSIPersistentVolumeSource proto.InternalMessageInfo

func (m *CSIPersistentVolumeSource) GetDriver() string {
	if m != nil {
		return m.Driver
	}
	return ""
}

func (m *CSIPersistentVolumeSource) GetVolumeHandle() string {
	if m != nil {
		return m.VolumeHandle
	}
	return ""
}

func (m *CSIPersistentVolumeSource) GetReadOnly() bool {
	if m != nil {
		return m.ReadOnly
	}
	return false
}

func (m *CSIPersistentVolumeSource) GetFsType() string {
	if m != nil {
		return m.FsType
	}
	return ""
}

func (m *CSIPersistentVolumeSource) GetVolumeAttributes() map[string]string {
	if m != nil {
		return m.VolumeAttributes
	}
	return nil
}

func (m *CSIPersistentVolumeSource) GetControllerPublishSecretRef() *SecretReference {
	if m != nil {
		return m.ControllerPublishSecretRef
	}
	return nil
}

func (m *CSIPersistentVolumeSource) GetNodeStageSecretRef() *SecretReference {
	if m != nil {
		return m.NodeStageSecretRef
	}
	return nil
}

func (m *CSIPersistentVolumeSource) GetNodePublishSecretRef() *SecretReference {
	if m != nil {
		return m.NodePublishSecretRef
	}
	return nil
}

func (m *CSIPersistentVolumeSource) GetControllerExpandSecretRef() *SecretReference {
	if m != nil {
		return m.ControllerExpandSecretRef
	}
	return nil
}

// Represents a source location of a volume to mount, managed by an external CSI driver
type CSIVolumeSource struct {
	// Driver is the name of the CSI driver that handles this volume.
	// Consult with your admin for the correct name as registered in the cluster.
	Driver string `protobuf:"bytes,1,opt,name=driver" json:"driver"`
	// Specifies a read-only configuration for the volume.
	// Defaults to false (read/write).
	// +optional
	ReadOnly bool `protobuf:"varint,2,opt,name=readOnly" json:"readOnly"`
	// Filesystem type to mount. Ex. "ext4", "xfs", "ntfs".
	// If not provided, the empty value is passed to the associated CSI driver
	// which will determine the default filesystem to apply.
	// +optional
	FsType string `protobuf:"bytes,3,opt,name=fsType" json:"fsType"`
	// VolumeAttributes stores driver-specific properties that are passed to the CSI
	// driver. Consult your driver's documentation for supported values.
	// +optional
	VolumeAttributes map[string]string `protobuf:"bytes,4,rep,name=volumeAttributes" json:"volumeAttributes,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// NodePublishSecretRef is a reference to the secret object containing
	// sensitive information to pass to the CSI driver to complete the CSI
	// NodePublishVolume and NodeUnpublishVolume calls.
	// This field is optional, and  may be empty if no secret is required. If the
	// secret object contains more than one secret, all secret references are passed.
	// +optional
	NodePublishSecretRef *LocalObjectReference `protobuf:"bytes,5,opt,name=nodePublishSecretRef" json:"nodePublishSecretRef,omitempty"`
}

func (m *CSIVolumeSource) Reset()      { *m = CSIVolumeSource{} }
func (*CSIVolumeSource) ProtoMessage() {}
func (*CSIVolumeSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{9}
}
func (m *CSIVolumeSource) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CSIVolumeSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CSIVolumeSource.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CSIVolumeSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CSIVolumeSource.Merge(m, src)
}
func (m *CSIVolumeSource) XXX_Size() int {
	return m.Size()
}
func (m *CSIVolumeSource) XXX_DiscardUnknown() {
	xxx_messageInfo_CSIVolumeSource.DiscardUnknown(m)
}

var xxx_messageInfo_CSIVolumeSource proto.InternalMessageInfo

func (m *CSIVolumeSource) GetDriver() string {
	if m != nil {
		return m.Driver
	}
	return ""
}

func (m *CSIVolumeSource) GetReadOnly() bool {
	if m != nil {
		return m.ReadOnly
	}
	return false
}

func (m *CSIVolumeSource) GetFsType() string {
	if m != nil {
		return m.FsType
	}
	return ""
}

func (m *CSIVolumeSource) GetVolumeAttributes() map[string]string {
	if m != nil {
		return m.VolumeAttributes
	}
	return nil
}

func (m *CSIVolumeSource) GetNodePublishSecretRef() *LocalObjectReference {
	if m != nil {
		return m.NodePublishSecretRef
	}
	return nil
}

// Adds and removes POSIX capabilities from running containers.
type Capabilities struct {
	// Added capabilities
	// +optional
	Add []string `protobuf:"bytes,1,rep,name=add" json:"add,omitempty"`
	// Removed capabilities
	// +optional
	Drop []string `protobuf:"bytes,2,rep,name=drop" json:"drop,omitempty"`
}

func (m *Capabilities) Reset()      { *m = Capabilities{} }
func (*Capabilities) ProtoMessage() {}
func (*Capabilities) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{10}
}
func (m *Capabilities) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Capabilities) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Capabilities.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Capabilities) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Capabilities.Merge(m, src)
}
func (m *Capabilities) XXX_Size() int {
	return m.Size()
}
func (m *Capabilities) XXX_DiscardUnknown() {
	xxx_messageInfo_Capabilities.DiscardUnknown(m)
}

var xxx_messageInfo_Capabilities proto.InternalMessageInfo

func (m *Capabilities) GetAdd() []string {
	if m != nil {
		return m.Add
	}
	return nil
}

func (m *Capabilities) GetDrop() []string {
	if m != nil {
		return m.Drop
	}
	return nil
}

// Represents a Ceph Filesystem mount that lasts the lifetime of a pod
// Cephfs volumes do not support ownership management or SELinux relabeling.
type CephFSPersistentVolumeSource struct {
	// Required: Monitors is a collection of Ceph monitors
	// More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
	Monitors []string `protobuf:"bytes,1,rep,name=monitors" json:"monitors,omitempty"`
	// Optional: Used as the mounted root, rather than the full Ceph tree, default is /
	// +optional
	Path string `protobuf:"bytes,2,opt,name=path" json:"path"`
	// Optional: User is the rados user name, default is admin
	// More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
	// +optional
	User string `protobuf:"bytes,3,opt,name=user" json:"user"`
	// Optional: SecretFile is the path to key ring for User, default is /etc/ceph/user.secret
	// More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
	// +optional
	SecretFile string `protobuf:"bytes,4,opt,name=secretFile" json:"secretFile"`
	// Optional: SecretRef is reference to the authentication secret for User, default is empty.
	// More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
	// +optional
	SecretRef *SecretReference `protobuf:"bytes,5,opt,name=secretRef" json:"secretRef,omitempty"`
	// Optional: Defaults to false (read/write). ReadOnly here will force
	// the ReadOnly setting in VolumeMounts.
	// More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
	// +optional
	ReadOnly bool `protobuf:"varint,6,opt,name=readOnly" json:"readOnly"`
}

func (m *CephFSPersistentVolumeSource) Reset()      { *m = CephFSPersistentVolumeSource{} }
func (*CephFSPersistentVolumeSource) ProtoMessage() {}
func (*CephFSPersistentVolumeSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{11}
}
func (m *CephFSPersistentVolumeSource) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CephFSPersistentVolumeSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CephFSPersistentVolumeSource.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CephFSPersistentVolumeSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CephFSPersistentVolumeSource.Merge(m, src)
}
func (m *CephFSPersistentVolumeSource) XXX_Size() int {
	return m.Size()
}
func (m *CephFSPersistentVolumeSource) XXX_DiscardUnknown() {
	xxx_messageInfo_CephFSPersistentVolumeSource.DiscardUnknown(m)
}

var xxx_messageInfo_CephFSPersistentVolumeSource proto.InternalMessageInfo

func (m *CephFSPersistentVolumeSource) GetMonitors() []string {
	if m != nil {
		return m.Monitors
	}
	return nil
}

func (m *CephFSPersistentVolumeSource) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

func (m *CephFSPersistentVolumeSource) GetUser() string {
	if m != nil {
		return m.User
	}
	return ""
}

func (m *CephFSPersistentVolumeSource) GetSecretFile() string {
	if m != nil {
		return m.SecretFile
	}
	return ""
}

func (m *CephFSPersistentVolumeSource) GetSecretRef() *SecretReference {
	if m != nil {
		return m.SecretRef
	}
	return nil
}

func (m *CephFSPersistentVolumeSource) GetReadOnly() bool {
	if m != nil {
		return m.ReadOnly
	}
	return false
}

// Represents a Ceph Filesystem mount that lasts the lifetime of a pod
// Cephfs volumes do not support ownership management or SELinux relabeling.
type CephFSVolumeSource struct {
	// Required: Monitors is a collection of Ceph monitors
	// More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
	Monitors []string `protobuf:"bytes,1,rep,name=monitors" json:"monitors,omitempty"`
	// Optional: Used as the mounted root, rather than the full Ceph tree, default is /
	// +optional
	Path string `protobuf:"bytes,2,opt,name=path" json:"path"`
	// Optional: User is the rados user name, default is admin
	// More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
	// +optional
	User string `protobuf:"bytes,3,opt,name=user" json:"user"`
	// Optional: SecretFile is the path to key ring for User, default is /etc/ceph/user.secret
	// More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
	// +optional
	SecretFile string `protobuf:"bytes,4,opt,name=secretFile" json:"secretFile"`
	// Optional: SecretRef is reference to the authentication secret for User, default is empty.
	// More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
	// +optional
	SecretRef *LocalObjectReference `protobuf:"bytes,5,opt,name=secretRef" json:"secretRef,omitempty"`
	// Optional: Defaults to false (read/write). ReadOnly here will force
	// the ReadOnly setting in VolumeMounts.
	// More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
	// +optional
	ReadOnly bool `protobuf:"varint,6,opt,name=readOnly" json:"readOnly"`
}

func (m *CephFSVolumeSource) Reset()      { *m = CephFSVolumeSource{} }
func (*CephFSVolumeSource) ProtoMessage() {}
func (*CephFSVolumeSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{12}
}
func (m *CephFSVolumeSource) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CephFSVolumeSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CephFSVolumeSource.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CephFSVolumeSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CephFSVolumeSource.Merge(m, src)
}
func (m *CephFSVolumeSource) XXX_Size() int {
	return m.Size()
}
func (m *CephFSVolumeSource) XXX_DiscardUnknown() {
	xxx_messageInfo_CephFSVolumeSource.DiscardUnknown(m)
}

var xxx_messageInfo_CephFSVolumeSource proto.InternalMessageInfo

func (m *CephFSVolumeSource) GetMonitors() []string {
	if m != nil {
		return m.Monitors
	}
	return nil
}

func (m *CephFSVolumeSource) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

func (m *CephFSVolumeSource) GetUser() string {
	if m != nil {
		return m.User
	}
	return ""
}

func (m *CephFSVolumeSource) GetSecretFile() string {
	if m != nil {
		return m.SecretFile
	}
	return ""
}

func (m *CephFSVolumeSource) GetSecretRef() *LocalObjectReference {
	if m != nil {
		return m.SecretRef
	}
	return nil
}

func (m *CephFSVolumeSource) GetReadOnly() bool {
	if m != nil {
		return m.ReadOnly
	}
	return false
}

// Represents a cinder volume resource in Openstack.
// A Cinder volume must exist before mounting to a container.
// The volume must also be in the same region as the kubelet.
// Cinder volumes support ownership management and SELinux relabeling.
type CinderPersistentVolumeSource struct {
	// volume id used to identify the volume in cinder.
	// More info: https://examples.k8s.io/mysql-cinder-pd/README.md
	VolumeID string `protobuf:"bytes,1,opt,name=volumeID" json:"volumeID"`
	// Filesystem type to mount.
	// Must be a filesystem type supported by the host operating system.
	// Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
	// More info: https://examples.k8s.io/mysql-cinder-pd/README.md
	// +optional
	FsType string `protobuf:"bytes,2,opt,name=fsType" json:"fsType"`
	// Optional: Defaults to false (read/write). ReadOnly here will force
	// the ReadOnly setting in VolumeMounts.
	// More info: https://examples.k8s.io/mysql-cinder-pd/README.md
	// +optional
	ReadOnly bool `protobuf:"varint,3,opt,name=readOnly" json:"readOnly"`
	// Optional: points to a secret object containing parameters used to connect
	// to OpenStack.
	// +optional
	SecretRef *SecretReference `protobuf:"bytes,4,opt,name=secretRef" json:"secretRef,omitempty"`
}

func (m *CinderPersistentVolumeSource) Reset()      { *m = CinderPersistentVolumeSource{} }
func (*CinderPersistentVolumeSource) ProtoMessage() {}
func (*CinderPersistentVolumeSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{13}
}
func (m *CinderPersistentVolumeSource) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CinderPersistentVolumeSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CinderPersistentVolumeSource.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CinderPersistentVolumeSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CinderPersistentVolumeSource.Merge(m, src)
}
func (m *CinderPersistentVolumeSource) XXX_Size() int {
	return m.Size()
}
func (m *CinderPersistentVolumeSource) XXX_DiscardUnknown() {
	xxx_messageInfo_CinderPersistentVolumeSource.DiscardUnknown(m)
}

var xxx_messageInfo_CinderPersistentVolumeSource proto.InternalMessageInfo

func (m *CinderPersistentVolumeSource) GetVolumeID() string {
	if m != nil {
		return m.VolumeID
	}
	return ""
}

func (m *CinderPersistentVolumeSource) GetFsType() string {
	if m != nil {
		return m.FsType
	}
	return ""
}

func (m *CinderPersistentVolumeSource) GetReadOnly() bool {
	if m != nil {
		return m.ReadOnly
	}
	return false
}

func (m *CinderPersistentVolumeSource) GetSecretRef() *SecretReference {
	if m != nil {
		return m.SecretRef
	}
	return nil
}

// Represents a cinder volume resource in Openstack.
// A Cinder volume must exist before mounting to a container.
// The volume must also be in the same region as the kubelet.
// Cinder volumes support ownership management and SELinux relabeling.
type CinderVolumeSource struct {
	// volume id used to identify the volume in cinder.
	// More info: https://examples.k8s.io/mysql-cinder-pd/README.md
	VolumeID string `protobuf:"bytes,1,opt,name=volumeID" json:"volumeID"`
	// Filesystem type to mount.
	// Must be a filesystem type supported by the host operating system.
	// Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
	// More info: https://examples.k8s.io/mysql-cinder-pd/README.md
	// +optional
	FsType string `protobuf:"bytes,2,opt,name=fsType" json:"fsType"`
	// Optional: Defaults to false (read/write). ReadOnly here will force
	// the ReadOnly setting in VolumeMounts.
	// More info: https://examples.k8s.io/mysql-cinder-pd/README.md
	// +optional
	ReadOnly bool `protobuf:"varint,3,opt,name=readOnly" json:"readOnly"`
	// Optional: points to a secret object containing parameters used to connect
	// to OpenStack.
	// +optional
	SecretRef *LocalObjectReference `protobuf:"bytes,4,opt,name=secretRef" json:"secretRef,omitempty"`
}

func (m *CinderVolumeSource) Reset()      { *m = CinderVolumeSource{} }
func (*CinderVolumeSource) ProtoMessage() {}
func (*CinderVolumeSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{14}
}
func (m *CinderVolumeSource) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CinderVolumeSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CinderVolumeSource.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CinderVolumeSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CinderVolumeSource.Merge(m, src)
}
func (m *CinderVolumeSource) XXX_Size() int {
	return m.Size()
}
func (m *CinderVolumeSource) XXX_DiscardUnknown() {
	xxx_messageInfo_CinderVolumeSource.DiscardUnknown(m)
}

var xxx_messageInfo_CinderVolumeSource proto.InternalMessageInfo

func (m *CinderVolumeSource) GetVolumeID() string {
	if m != nil {
		return m.VolumeID
	}
	return ""
}

func (m *CinderVolumeSource) GetFsType() string {
	if m != nil {
		return m.FsType
	}
	return ""
}

func (m *CinderVolumeSource) GetReadOnly() bool {
	if m != nil {
		return m.ReadOnly
	}
	return false
}

func (m *CinderVolumeSource) GetSecretRef() *LocalObjectReference {
	if m != nil {
		return m.SecretRef
	}
	return nil
}

// ClientIPConfig represents the configurations of Client IP based session affinity.
type ClientIPConfig struct {
	// timeoutSeconds specifies the seconds of ClientIP type session sticky time.
	// The value must be >0 && <=86400(for 1 day) if ServiceAffinity == "ClientIP".
	// Default value is 10800(for 3 hours).
	// +optional
	TimeoutSeconds int32 `protobuf:"varint,1,opt,name=timeoutSeconds" json:"timeoutSeconds"`
}

func (m *ClientIPConfig) Reset()      { *m = ClientIPConfig{} }
func (*ClientIPConfig) ProtoMessage() {}
func (*ClientIPConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{15}
}
func (m *ClientIPConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ClientIPConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ClientIPConfig.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ClientIPConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ClientIPConfig.Merge(m, src)
}
func (m *ClientIPConfig) XXX_Size() int {
	return m.Size()
}
func (m *ClientIPConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_ClientIPConfig.DiscardUnknown(m)
}

var xxx_messageInfo_ClientIPConfig proto.InternalMessageInfo

func (m *ClientIPConfig) GetTimeoutSeconds() int32 {
	if m != nil {
		return m.TimeoutSeconds
	}
	return 0
}

// Information about the condition of a component.
type ComponentCondition struct {
	// Type of condition for a component.
	// Valid value: "Healthy"
	Type string `protobuf:"bytes,1,opt,name=type" json:"type"`
	// Status of the condition for a component.
	// Valid values for "Healthy": "True", "False", or "Unknown".
	Status string `protobuf:"bytes,2,opt,name=status" json:"status"`
	// Message about the condition for a component.
	// For example, information about a health check.
	// +optional
	Message string `protobuf:"bytes,3,opt,name=message" json:"message"`
	// Condition error code for a component.
	// For example, a health check error code.
	// +optional
	Error string `protobuf:"bytes,4,opt,name=error" json:"error"`
}

func (m *ComponentCondition) Reset()      { *m = ComponentCondition{} }
func (*ComponentCondition) ProtoMessage() {}
func (*ComponentCondition) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{16}
}
func (m *ComponentCondition) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ComponentCondition) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ComponentCondition.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ComponentCondition) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ComponentCondition.Merge(m, src)
}
func (m *ComponentCondition) XXX_Size() int {
	return m.Size()
}
func (m *ComponentCondition) XXX_DiscardUnknown() {
	xxx_messageInfo_ComponentCondition.DiscardUnknown(m)
}

var xxx_messageInfo_ComponentCondition proto.InternalMessageInfo

func (m *ComponentCondition) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *ComponentCondition) GetStatus() string {
	if m != nil {
		return m.Status
	}
	return ""
}

func (m *ComponentCondition) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

func (m *ComponentCondition) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

// ComponentStatus (and ComponentStatusList) holds the cluster validation info.
type ComponentStatus struct {
	// Standard object's metadata.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
	// +optional
	Metadata *v1.ObjectMeta `protobuf:"bytes,1,opt,name=metadata" json:"metadata,omitempty"`
	// List of component conditions observed
	// +optional
	// +patchMergeKey=type
	// +patchStrategy=merge
	Conditions []*ComponentCondition `protobuf:"bytes,2,rep,name=conditions" json:"conditions,omitempty"`
}

func (m *ComponentStatus) Reset()      { *m = ComponentStatus{} }
func (*ComponentStatus) ProtoMessage() {}
func (*ComponentStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{17}
}
func (m *ComponentStatus) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ComponentStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ComponentStatus.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ComponentStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ComponentStatus.Merge(m, src)
}
func (m *ComponentStatus) XXX_Size() int {
	return m.Size()
}
func (m *ComponentStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_ComponentStatus.DiscardUnknown(m)
}

var xxx_messageInfo_ComponentStatus proto.InternalMessageInfo

func (m *ComponentStatus) GetMetadata() *v1.ObjectMeta {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *ComponentStatus) GetConditions() []*ComponentCondition {
	if m != nil {
		return m.Conditions
	}
	return nil
}

// Status of all the conditions for the component as a list of ComponentStatus objects.
type ComponentStatusList struct {
	// Standard list metadata.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds
	// +optional
	Metadata *v1.ListMeta `protobuf:"bytes,1,opt,name=metadata" json:"metadata,omitempty"`
	// List of ComponentStatus objects.
	Items []*ComponentStatus `protobuf:"bytes,2,rep,name=items" json:"items,omitempty"`
}

func (m *ComponentStatusList) Reset()      { *m = ComponentStatusList{} }
func (*ComponentStatusList) ProtoMessage() {}
func (*ComponentStatusList) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{18}
}
func (m *ComponentStatusList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ComponentStatusList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ComponentStatusList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ComponentStatusList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ComponentStatusList.Merge(m, src)
}
func (m *ComponentStatusList) XXX_Size() int {
	return m.Size()
}
func (m *ComponentStatusList) XXX_DiscardUnknown() {
	xxx_messageInfo_ComponentStatusList.DiscardUnknown(m)
}

var xxx_messageInfo_ComponentStatusList proto.InternalMessageInfo

func (m *ComponentStatusList) GetMetadata() *v1.ListMeta {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *ComponentStatusList) GetItems() []*ComponentStatus {
	if m != nil {
		return m.Items
	}
	return nil
}

// ConfigMap holds configuration data for pods to consume.
type ConfigMap struct {
	// Standard object's metadata.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
	// +optional
	Metadata *v1.ObjectMeta `protobuf:"bytes,1,opt,name=metadata" json:"metadata,omitempty"`
	// Data contains the configuration data.
	// Each key must consist of alphanumeric characters, '-', '_' or '.'.
	// Values with non-UTF-8 byte sequences must use the BinaryData field.
	// The keys stored in Data must not overlap with the keys in
	// the BinaryData field, this is enforced during validation process.
	// +optional
	Data map[string]string `protobuf:"bytes,2,rep,name=data" json:"data,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// BinaryData contains the binary data.
	// Each key must consist of alphanumeric characters, '-', '_' or '.'.
	// BinaryData can contain byte sequences that are not in the UTF-8 range.
	// The keys stored in BinaryData must not overlap with the ones in
	// the Data field, this is enforced during validation process.
	// Using this field will require 1.10+ apiserver and
	// kubelet.
	// +optional
	BinaryData map[string][]byte `protobuf:"bytes,3,rep,name=binaryData" json:"binaryData,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *ConfigMap) Reset()      { *m = ConfigMap{} }
func (*ConfigMap) ProtoMessage() {}
func (*ConfigMap) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{19}
}
func (m *ConfigMap) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ConfigMap) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ConfigMap.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ConfigMap) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ConfigMap.Merge(m, src)
}
func (m *ConfigMap) XXX_Size() int {
	return m.Size()
}
func (m *ConfigMap) XXX_DiscardUnknown() {
	xxx_messageInfo_ConfigMap.DiscardUnknown(m)
}

var xxx_messageInfo_ConfigMap proto.InternalMessageInfo

func (m *ConfigMap) GetMetadata() *v1.ObjectMeta {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *ConfigMap) GetData() map[string]string {
	if m != nil {
		return m.Data
	}
	return nil
}

func (m *ConfigMap) GetBinaryData() map[string][]byte {
	if m != nil {
		return m.BinaryData
	}
	return nil
}

// ConfigMapEnvSource selects a ConfigMap to populate the environment
// variables with.
//
// The contents of the target ConfigMap's Data field will represent the
// key-value pairs as environment variables.
type ConfigMapEnvSource struct {
	// The ConfigMap to select from.
	LocalObjectReference *LocalObjectReference `protobuf:"bytes,1,opt,name=localObjectReference" json:"localObjectReference,omitempty"`
	// Specify whether the ConfigMap must be defined
	// +optional
	Optional bool `protobuf:"varint,2,opt,name=optional" json:"optional"`
}

func (m *ConfigMapEnvSource) Reset()      { *m = ConfigMapEnvSource{} }
func (*ConfigMapEnvSource) ProtoMessage() {}
func (*ConfigMapEnvSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{20}
}
func (m *ConfigMapEnvSource) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ConfigMapEnvSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ConfigMapEnvSource.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ConfigMapEnvSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ConfigMapEnvSource.Merge(m, src)
}
func (m *ConfigMapEnvSource) XXX_Size() int {
	return m.Size()
}
func (m *ConfigMapEnvSource) XXX_DiscardUnknown() {
	xxx_messageInfo_ConfigMapEnvSource.DiscardUnknown(m)
}

var xxx_messageInfo_ConfigMapEnvSource proto.InternalMessageInfo

func (m *ConfigMapEnvSource) GetLocalObjectReference() *LocalObjectReference {
	if m != nil {
		return m.LocalObjectReference
	}
	return nil
}

func (m *ConfigMapEnvSource) GetOptional() bool {
	if m != nil {
		return m.Optional
	}
	return false
}

// Selects a key from a ConfigMap.
type ConfigMapKeySelector struct {
	// The ConfigMap to select from.
	LocalObjectReference *LocalObjectReference `protobuf:"bytes,1,opt,name=localObjectReference" json:"localObjectReference,omitempty"`
	// The key to select.
	Key string `protobuf:"bytes,2,opt,name=key" json:"key"`
	// Specify whether the ConfigMap or its key must be defined
	// +optional
	Optional bool `protobuf:"varint,3,opt,name=optional" json:"optional"`
}

func (m *ConfigMapKeySelector) Reset()      { *m = ConfigMapKeySelector{} }
func (*ConfigMapKeySelector) ProtoMessage() {}
func (*ConfigMapKeySelector) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{21}
}
func (m *ConfigMapKeySelector) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ConfigMapKeySelector) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ConfigMapKeySelector.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ConfigMapKeySelector) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ConfigMapKeySelector.Merge(m, src)
}
func (m *ConfigMapKeySelector) XXX_Size() int {
	return m.Size()
}
func (m *ConfigMapKeySelector) XXX_DiscardUnknown() {
	xxx_messageInfo_ConfigMapKeySelector.DiscardUnknown(m)
}

var xxx_messageInfo_ConfigMapKeySelector proto.InternalMessageInfo

func (m *ConfigMapKeySelector) GetLocalObjectReference() *LocalObjectReference {
	if m != nil {
		return m.LocalObjectReference
	}
	return nil
}

func (m *ConfigMapKeySelector) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

func (m *ConfigMapKeySelector) GetOptional() bool {
	if m != nil {
		return m.Optional
	}
	return false
}

// ConfigMapList is a resource containing a list of ConfigMap objects.
type ConfigMapList struct {
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
	// +optional
	Metadata *v1.ListMeta `protobuf:"bytes,1,opt,name=metadata" json:"metadata,omitempty"`
	// Items is the list of ConfigMaps.
	Items []*ConfigMap `protobuf:"bytes,2,rep,name=items" json:"items,omitempty"`
}

func (m *ConfigMapList) Reset()      { *m = ConfigMapList{} }
func (*ConfigMapList) ProtoMessage() {}
func (*ConfigMapList) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{22}
}
func (m *ConfigMapList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ConfigMapList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ConfigMapList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ConfigMapList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ConfigMapList.Merge(m, src)
}
func (m *ConfigMapList) XXX_Size() int {
	return m.Size()
}
func (m *ConfigMapList) XXX_DiscardUnknown() {
	xxx_messageInfo_ConfigMapList.DiscardUnknown(m)
}

var xxx_messageInfo_ConfigMapList proto.InternalMessageInfo

func (m *ConfigMapList) GetMetadata() *v1.ListMeta {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *ConfigMapList) GetItems() []*ConfigMap {
	if m != nil {
		return m.Items
	}
	return nil
}

// ConfigMapNodeConfigSource contains the information to reference a ConfigMap as a config source for the Node.
type ConfigMapNodeConfigSource struct {
	// Namespace is the metadata.namespace of the referenced ConfigMap.
	// This field is required in all cases.
	Namespace string `protobuf:"bytes,1,opt,name=namespace" json:"namespace"`
	// Name is the metadata.name of the referenced ConfigMap.
	// This field is required in all cases.
	Name string `protobuf:"bytes,2,opt,name=name" json:"name"`
	// UID is the metadata.UID of the referenced ConfigMap.
	// This field is forbidden in Node.Spec, and required in Node.Status.
	// +optional
	Uid string `protobuf:"bytes,3,opt,name=uid" json:"uid"`
	// ResourceVersion is the metadata.ResourceVersion of the referenced ConfigMap.
	// This field is forbidden in Node.Spec, and required in Node.Status.
	// +optional
	ResourceVersion string `protobuf:"bytes,4,opt,name=resourceVersion" json:"resourceVersion"`
	// KubeletConfigKey declares which key of the referenced ConfigMap corresponds to the KubeletConfiguration structure
	// This field is required in all cases.
	KubeletConfigKey string `protobuf:"bytes,5,opt,name=kubeletConfigKey" json:"kubeletConfigKey"`
}

func (m *ConfigMapNodeConfigSource) Reset()      { *m = ConfigMapNodeConfigSource{} }
func (*ConfigMapNodeConfigSource) ProtoMessage() {}
func (*ConfigMapNodeConfigSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{23}
}
func (m *ConfigMapNodeConfigSource) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ConfigMapNodeConfigSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ConfigMapNodeConfigSource.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ConfigMapNodeConfigSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ConfigMapNodeConfigSource.Merge(m, src)
}
func (m *ConfigMapNodeConfigSource) XXX_Size() int {
	return m.Size()
}
func (m *ConfigMapNodeConfigSource) XXX_DiscardUnknown() {
	xxx_messageInfo_ConfigMapNodeConfigSource.DiscardUnknown(m)
}

var xxx_messageInfo_ConfigMapNodeConfigSource proto.InternalMessageInfo

func (m *ConfigMapNodeConfigSource) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *ConfigMapNodeConfigSource) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ConfigMapNodeConfigSource) GetUid() string {
	if m != nil {
		return m.Uid
	}
	return ""
}

func (m *ConfigMapNodeConfigSource) GetResourceVersion() string {
	if m != nil {
		return m.ResourceVersion
	}
	return ""
}

func (m *ConfigMapNodeConfigSource) GetKubeletConfigKey() string {
	if m != nil {
		return m.KubeletConfigKey
	}
	return ""
}

// Adapts a ConfigMap into a projected volume.
//
// The contents of the target ConfigMap's Data field will be presented in a
// projected volume as files using the keys in the Data field as the file names,
// unless the items element is populated with specific mappings of keys to paths.
// Note that this is identical to a configmap volume source without the default
// mode.
type ConfigMapProjection struct {
	LocalObjectReference *LocalObjectReference `protobuf:"bytes,1,opt,name=localObjectReference" json:"localObjectReference,omitempty"`
	// If unspecified, each key-value pair in the Data field of the referenced
	// ConfigMap will be projected into the volume as a file whose name is the
	// key and content is the value. If specified, the listed keys will be
	// projected into the specified paths, and unlisted keys will not be
	// present. If a key is specified which is not present in the ConfigMap,
	// the volume setup will error unless it is marked optional. Paths must be
	// relative and may not contain the '..' path or start with '..'.
	// +optional
	Items []*KeyToPath `protobuf:"bytes,2,rep,name=items" json:"items,omitempty"`
	// Specify whether the ConfigMap or its keys must be defined
	// +optional
	Optional bool `protobuf:"varint,4,opt,name=optional" json:"optional"`
}

func (m *ConfigMapProjection) Reset()      { *m = ConfigMapProjection{} }
func (*ConfigMapProjection) ProtoMessage() {}
func (*ConfigMapProjection) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{24}
}
func (m *ConfigMapProjection) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ConfigMapProjection) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ConfigMapProjection.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ConfigMapProjection) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ConfigMapProjection.Merge(m, src)
}
func (m *ConfigMapProjection) XXX_Size() int {
	return m.Size()
}
func (m *ConfigMapProjection) XXX_DiscardUnknown() {
	xxx_messageInfo_ConfigMapProjection.DiscardUnknown(m)
}

var xxx_messageInfo_ConfigMapProjection proto.InternalMessageInfo

func (m *ConfigMapProjection) GetLocalObjectReference() *LocalObjectReference {
	if m != nil {
		return m.LocalObjectReference
	}
	return nil
}

func (m *ConfigMapProjection) GetItems() []*KeyToPath {
	if m != nil {
		return m.Items
	}
	return nil
}

func (m *ConfigMapProjection) GetOptional() bool {
	if m != nil {
		return m.Optional
	}
	return false
}

// Adapts a ConfigMap into a volume.
//
// The contents of the target ConfigMap's Data field will be presented in a
// volume as files using the keys in the Data field as the file names, unless
// the items element is populated with specific mappings of keys to paths.
// ConfigMap volumes support ownership management and SELinux relabeling.
type ConfigMapVolumeSource struct {
	LocalObjectReference *LocalObjectReference `protobuf:"bytes,1,opt,name=localObjectReference" json:"localObjectReference,omitempty"`
	// If unspecified, each key-value pair in the Data field of the referenced
	// ConfigMap will be projected into the volume as a file whose name is the
	// key and content is the value. If specified, the listed keys will be
	// projected into the specified paths, and unlisted keys will not be
	// present. If a key is specified which is not present in the ConfigMap,
	// the volume setup will error unless it is marked optional. Paths must be
	// relative and may not contain the '..' path or start with '..'.
	// +optional
	Items []*KeyToPath `protobuf:"bytes,2,rep,name=items" json:"items,omitempty"`
	// Optional: mode bits to use on created files by default. Must be a
	// value between 0 and 0777. Defaults to 0644.
	// Directories within the path are not affected by this setting.
	// This might be in conflict with other options that affect the file
	// mode, like fsGroup, and the result can be other mode bits set.
	// +optional
	DefaultMode int32 `protobuf:"varint,3,opt,name=defaultMode" json:"defaultMode"`
	// Specify whether the ConfigMap or its keys must be defined
	// +optional
	Optional bool `protobuf:"varint,4,opt,name=optional" json:"optional"`
}

func (m *ConfigMapVolumeSource) Reset()      { *m = ConfigMapVolumeSource{} }
func (*ConfigMapVolumeSource) ProtoMessage() {}
func (*ConfigMapVolumeSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{25}
}
func (m *ConfigMapVolumeSource) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ConfigMapVolumeSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ConfigMapVolumeSource.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ConfigMapVolumeSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ConfigMapVolumeSource.Merge(m, src)
}
func (m *ConfigMapVolumeSource) XXX_Size() int {
	return m.Size()
}
func (m *ConfigMapVolumeSource) XXX_DiscardUnknown() {
	xxx_messageInfo_ConfigMapVolumeSource.DiscardUnknown(m)
}

var xxx_messageInfo_ConfigMapVolumeSource proto.InternalMessageInfo

func (m *ConfigMapVolumeSource) GetLocalObjectReference() *LocalObjectReference {
	if m != nil {
		return m.LocalObjectReference
	}
	return nil
}

func (m *ConfigMapVolumeSource) GetItems() []*KeyToPath {
	if m != nil {
		return m.Items
	}
	return nil
}

func (m *ConfigMapVolumeSource) GetDefaultMode() int32 {
	if m != nil {
		return m.DefaultMode
	}
	return 0
}

func (m *ConfigMapVolumeSource) GetOptional() bool {
	if m != nil {
		return m.Optional
	}
	return false
}

// A single application container that you want to run within a pod.
type Container struct {
	// Name of the container specified as a DNS_LABEL.
	// Each container in a pod must have a unique name (DNS_LABEL).
	// Cannot be updated.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name"`
	// Docker image name.
	// More info: https://kubernetes.io/docs/concepts/containers/images
	// This field is optional to allow higher level config management to default or override
	// container images in workload controllers like Deployments and StatefulSets.
	// +optional
	Image string `protobuf:"bytes,2,opt,name=image" json:"image"`
	// Entrypoint array. Not executed within a shell.
	// The docker image's ENTRYPOINT is used if this is not provided.
	// Variable references $(VAR_NAME) are expanded using the container's environment. If a variable
	// cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax
	// can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded,
	// regardless of whether the variable exists or not.
	// Cannot be updated.
	// More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
	// +optional
	Command []string `protobuf:"bytes,3,rep,name=command" json:"command,omitempty"`
	// Arguments to the entrypoint.
	// The docker image's CMD is used if this is not provided.
	// Variable references $(VAR_NAME) are expanded using the container's environment. If a variable
	// cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax
	// can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded,
	// regardless of whether the variable exists or not.
	// Cannot be updated.
	// More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
	// +optional
	Args []string `protobuf:"bytes,4,rep,name=args" json:"args,omitempty"`
	// Container's working directory.
	// If not specified, the container runtime's default will be used, which
	// might be configured in the container image.
	// Cannot be updated.
	// +optional
	WorkingDir string `protobuf:"bytes,5,opt,name=workingDir" json:"workingDir"`
	// List of ports to expose from the container. Exposing a port here gives
	// the system additional information about the network connections a
	// container uses, but is primarily informational. Not specifying a port here
	// DOES NOT prevent that port from being exposed. Any port which is
	// listening on the default "0.0.0.0" address inside a container will be
	// accessible from the network.
	// Cannot be updated.
	// +optional
	// +patchMergeKey=containerPort
	// +patchStrategy=merge
	// +listType=map
	// +listMapKey=containerPort
	// +listMapKey=protocol
	Ports []*ContainerPort `protobuf:"bytes,6,rep,name=ports" json:"ports,omitempty"`
	// List of sources to populate environment variables in the container.
	// The keys defined within a source must be a C_IDENTIFIER. All invalid keys
	// will be reported as an event when the container is starting. When a key exists in multiple
	// sources, the value associated with the last source will take precedence.
	// Values defined by an Env with a duplicate key will take precedence.
	// Cannot be updated.
	// +optional
	EnvFrom []*EnvFromSource `protobuf:"bytes,19,rep,name=envFrom" json:"envFrom,omitempty"`
	// List of environment variables to set in the container.
	// Cannot be updated.
	// +optional
	// +patchMergeKey=name
	// +patchStrategy=merge
	Env []*EnvVar `protobuf:"bytes,7,rep,name=env" json:"env,omitempty"`
	// Compute Resources required by this container.
	// Cannot be updated.
	// More info: https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
	// +optional
	Resources *ResourceRequirements `protobuf:"bytes,8,opt,name=resources" json:"resources,omitempty"`
	// Pod volumes to mount into the container's filesystem.
	// Cannot be updated.
	// +optional
	// +patchMergeKey=mountPath
	// +patchStrategy=merge
	VolumeMounts []*VolumeMount `protobuf:"bytes,9,rep,name=volumeMounts" json:"volumeMounts,omitempty"`
	// volumeDevices is the list of block devices to be used by the container.
	// This is a beta feature.
	// +patchMergeKey=devicePath
	// +patchStrategy=merge
	// +optional
	VolumeDevices []*VolumeDevice `protobuf:"bytes,21,rep,name=volumeDevices" json:"volumeDevices,omitempty"`
	// Periodic probe of container liveness.
	// Container will be restarted if the probe fails.
	// Cannot be updated.
	// More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
	// +optional
	LivenessProbe *Probe `protobuf:"bytes,10,opt,name=livenessProbe" json:"livenessProbe,omitempty"`
	// Periodic probe of container service readiness.
	// Container will be removed from service endpoints if the probe fails.
	// Cannot be updated.
	// More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
	// +optional
	ReadinessProbe *Probe `protobuf:"bytes,11,opt,name=readinessProbe" json:"readinessProbe,omitempty"`
	// Actions that the management system should take in response to container lifecycle events.
	// Cannot be updated.
	// +optional
	Lifecycle *Lifecycle `protobuf:"bytes,12,opt,name=lifecycle" json:"lifecycle,omitempty"`
	// Optional: Path at which the file to which the container's termination message
	// will be written is mounted into the container's filesystem.
	// Message written is intended to be brief final status, such as an assertion failure message.
	// Will be truncated by the node if greater than 4096 bytes. The total message length across
	// all containers will be limited to 12kb.
	// Defaults to /dev/termination-log.
	// Cannot be updated.
	// +optional
	TerminationMessagePath string `protobuf:"bytes,13,opt,name=terminationMessagePath" json:"terminationMessagePath"`
	// Indicate how the termination message should be populated. File will use the contents of
	// terminationMessagePath to populate the container status message on both success and failure.
	// FallbackToLogsOnError will use the last chunk of container log output if the termination
	// message file is empty and the container exited with an error.
	// The log output is limited to 2048 bytes or 80 lines, whichever is smaller.
	// Defaults to File.
	// Cannot be updated.
	// +optional
	TerminationMessagePolicy string `protobuf:"bytes,20,opt,name=terminationMessagePolicy" json:"terminationMessagePolicy"`
	// Image pull policy.
	// One of Always, Never, IfNotPresent.
	// Defaults to Always if :latest tag is specified, or IfNotPresent otherwise.
	// Cannot be updated.
	// More info: https://kubernetes.io/docs/concepts/containers/images#updating-images
	// +optional
	ImagePullPolicy string `protobuf:"bytes,14,opt,name=imagePullPolicy" json:"imagePullPolicy"`
	// Security options the pod should run with.
	// More info: https://kubernetes.io/docs/concepts/policy/security-context/
	// More info: https://kubernetes.io/docs/tasks/configure-pod-container/security-context/
	// +optional
	SecurityContext *SecurityContext `protobuf:"bytes,15,opt,name=securityContext" json:"securityContext,omitempty"`
	// Whether this container should allocate a buffer for stdin in the container runtime. If this
	// is not set, reads from stdin in the container will always result in EOF.
	// Default is false.
	// +optional
	Stdin bool `protobuf:"varint,16,opt,name=stdin" json:"stdin"`
	// Whether the container runtime should close the stdin channel after it has been opened by
	// a single attach. When stdin is true the stdin stream will remain open across multiple attach
	// sessions. If stdinOnce is set to true, stdin is opened on container start, is empty until the
	// first client attaches to stdin, and then remains open and accepts data until the client disconnects,
	// at which time stdin is closed and remains closed until the container is restarted. If this
	// flag is false, a container processes that reads from stdin will never receive an EOF.
	// Default is false
	// +optional
	StdinOnce bool `protobuf:"varint,17,opt,name=stdinOnce" json:"stdinOnce"`
	// Whether this container should allocate a TTY for itself, also requires 'stdin' to be true.
	// Default is false.
	// +optional
	Tty bool `protobuf:"varint,18,opt,name=tty" json:"tty"`
}

func (m *Container) Reset()      { *m = Container{} }
func (*Container) ProtoMessage() {}
func (*Container) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{26}
}
func (m *Container) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Container) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Container.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Container) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Container.Merge(m, src)
}
func (m *Container) XXX_Size() int {
	return m.Size()
}
func (m *Container) XXX_DiscardUnknown() {
	xxx_messageInfo_Container.DiscardUnknown(m)
}

var xxx_messageInfo_Container proto.InternalMessageInfo

func (m *Container) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Container) GetImage() string {
	if m != nil {
		return m.Image
	}
	return ""
}

func (m *Container) GetCommand() []string {
	if m != nil {
		return m.Command
	}
	return nil
}

func (m *Container) GetArgs() []string {
	if m != nil {
		return m.Args
	}
	return nil
}

func (m *Container) GetWorkingDir() string {
	if m != nil {
		return m.WorkingDir
	}
	return ""
}

func (m *Container) GetPorts() []*ContainerPort {
	if m != nil {
		return m.Ports
	}
	return nil
}

func (m *Container) GetEnvFrom() []*EnvFromSource {
	if m != nil {
		return m.EnvFrom
	}
	return nil
}

func (m *Container) GetEnv() []*EnvVar {
	if m != nil {
		return m.Env
	}
	return nil
}

func (m *Container) GetResources() *ResourceRequirements {
	if m != nil {
		return m.Resources
	}
	return nil
}

func (m *Container) GetVolumeMounts() []*VolumeMount {
	if m != nil {
		return m.VolumeMounts
	}
	return nil
}

func (m *Container) GetVolumeDevices() []*VolumeDevice {
	if m != nil {
		return m.VolumeDevices
	}
	return nil
}

func (m *Container) GetLivenessProbe() *Probe {
	if m != nil {
		return m.LivenessProbe
	}
	return nil
}

func (m *Container) GetReadinessProbe() *Probe {
	if m != nil {
		return m.ReadinessProbe
	}
	return nil
}

func (m *Container) GetLifecycle() *Lifecycle {
	if m != nil {
		return m.Lifecycle
	}
	return nil
}

func (m *Container) GetTerminationMessagePath() string {
	if m != nil {
		return m.TerminationMessagePath
	}
	return ""
}

func (m *Container) GetTerminationMessagePolicy() string {
	if m != nil {
		return m.TerminationMessagePolicy
	}
	return ""
}

func (m *Container) GetImagePullPolicy() string {
	if m != nil {
		return m.ImagePullPolicy
	}
	return ""
}

func (m *Container) GetSecurityContext() *SecurityContext {
	if m != nil {
		return m.SecurityContext
	}
	return nil
}

func (m *Container) GetStdin() bool {
	if m != nil {
		return m.Stdin
	}
	return false
}

func (m *Container) GetStdinOnce() bool {
	if m != nil {
		return m.StdinOnce
	}
	return false
}

func (m *Container) GetTty() bool {
	if m != nil {
		return m.Tty
	}
	return false
}

// Describe a container image
type ContainerImage struct {
	// Names by which this image is known.
	// e.g. ["k8s.gcr.io/hyperkube:v1.0.7", "dockerhub.io/google_containers/hyperkube:v1.0.7"]
	Names []string `protobuf:"bytes,1,rep,name=names" json:"names,omitempty"`
	// The size of the image in bytes.
	// +optional
	SizeBytes int64 `protobuf:"varint,2,opt,name=sizeBytes" json:"sizeBytes"`
}

func (m *ContainerImage) Reset()      { *m = ContainerImage{} }
func (*ContainerImage) ProtoMessage() {}
func (*ContainerImage) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{27}
}
func (m *ContainerImage) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ContainerImage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ContainerImage.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ContainerImage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ContainerImage.Merge(m, src)
}
func (m *ContainerImage) XXX_Size() int {
	return m.Size()
}
func (m *ContainerImage) XXX_DiscardUnknown() {
	xxx_messageInfo_ContainerImage.DiscardUnknown(m)
}

var xxx_messageInfo_ContainerImage proto.InternalMessageInfo

func (m *ContainerImage) GetNames() []string {
	if m != nil {
		return m.Names
	}
	return nil
}

func (m *ContainerImage) GetSizeBytes() int64 {
	if m != nil {
		return m.SizeBytes
	}
	return 0
}

// ContainerPort represents a network port in a single container.
type ContainerPort struct {
	// If specified, this must be an IANA_SVC_NAME and unique within the pod. Each
	// named port in a pod must have a unique name. Name for the port that can be
	// referred to by services.
	// +optional
	Name string `protobuf:"bytes,1,opt,name=name" json:"name"`
	// Number of port to expose on the host.
	// If specified, this must be a valid port number, 0 < x < 65536.
	// If HostNetwork is specified, this must match ContainerPort.
	// Most containers do not need this.
	// +optional
	HostPort int32 `protobuf:"varint,2,opt,name=hostPort" json:"hostPort"`
	// Number of port to expose on the pod's IP address.
	// This must be a valid port number, 0 < x < 65536.
	ContainerPort int32 `protobuf:"varint,3,opt,name=containerPort" json:"containerPort"`
	// Protocol for port. Must be UDP, TCP, or SCTP.
	// Defaults to "TCP".
	// +optional
	Protocol string `protobuf:"bytes,4,opt,name=protocol" json:"protocol"`
	// What host IP to bind the external port to.
	// +optional
	HostIP string `protobuf:"bytes,5,opt,name=hostIP" json:"hostIP"`
}

func (m *ContainerPort) Reset()      { *m = ContainerPort{} }
func (*ContainerPort) ProtoMessage() {}
func (*ContainerPort) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{28}
}
func (m *ContainerPort) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ContainerPort) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ContainerPort.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ContainerPort) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ContainerPort.Merge(m, src)
}
func (m *ContainerPort) XXX_Size() int {
	return m.Size()
}
func (m *ContainerPort) XXX_DiscardUnknown() {
	xxx_messageInfo_ContainerPort.DiscardUnknown(m)
}

var xxx_messageInfo_ContainerPort proto.InternalMessageInfo

func (m *ContainerPort) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ContainerPort) GetHostPort() int32 {
	if m != nil {
		return m.HostPort
	}
	return 0
}

func (m *ContainerPort) GetContainerPort() int32 {
	if m != nil {
		return m.ContainerPort
	}
	return 0
}

func (m *ContainerPort) GetProtocol() string {
	if m != nil {
		return m.Protocol
	}
	return ""
}

func (m *ContainerPort) GetHostIP() string {
	if m != nil {
		return m.HostIP
	}
	return ""
}

// ContainerState holds a possible state of container.
// Only one of its members may be specified.
// If none of them is specified, the default one is ContainerStateWaiting.
type ContainerState struct {
	// Details about a waiting container
	// +optional
	Waiting *ContainerStateWaiting `protobuf:"bytes,1,opt,name=waiting" json:"waiting,omitempty"`
	// Details about a running container
	// +optional
	Running *ContainerStateRunning `protobuf:"bytes,2,opt,name=running" json:"running,omitempty"`
	// Details about a terminated container
	// +optional
	Terminated *ContainerStateTerminated `protobuf:"bytes,3,opt,name=terminated" json:"terminated,omitempty"`
}

func (m *ContainerState) Reset()      { *m = ContainerState{} }
func (*ContainerState) ProtoMessage() {}
func (*ContainerState) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{29}
}
func (m *ContainerState) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ContainerState) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ContainerState.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ContainerState) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ContainerState.Merge(m, src)
}
func (m *ContainerState) XXX_Size() int {
	return m.Size()
}
func (m *ContainerState) XXX_DiscardUnknown() {
	xxx_messageInfo_ContainerState.DiscardUnknown(m)
}

var xxx_messageInfo_ContainerState proto.InternalMessageInfo

func (m *ContainerState) GetWaiting() *ContainerStateWaiting {
	if m != nil {
		return m.Waiting
	}
	return nil
}

func (m *ContainerState) GetRunning() *ContainerStateRunning {
	if m != nil {
		return m.Running
	}
	return nil
}

func (m *ContainerState) GetTerminated() *ContainerStateTerminated {
	if m != nil {
		return m.Terminated
	}
	return nil
}

// ContainerStateRunning is a running state of a container.
type ContainerStateRunning struct {
	// Time at which the container was last (re-)started
	// +optional
	StartedAt *v1.Time `protobuf:"bytes,1,opt,name=startedAt" json:"startedAt,omitempty"`
}

func (m *ContainerStateRunning) Reset()      { *m = ContainerStateRunning{} }
func (*ContainerStateRunning) ProtoMessage() {}
func (*ContainerStateRunning) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{30}
}
func (m *ContainerStateRunning) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ContainerStateRunning) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ContainerStateRunning.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ContainerStateRunning) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ContainerStateRunning.Merge(m, src)
}
func (m *ContainerStateRunning) XXX_Size() int {
	return m.Size()
}
func (m *ContainerStateRunning) XXX_DiscardUnknown() {
	xxx_messageInfo_ContainerStateRunning.DiscardUnknown(m)
}

var xxx_messageInfo_ContainerStateRunning proto.InternalMessageInfo

func (m *ContainerStateRunning) GetStartedAt() *v1.Time {
	if m != nil {
		return m.StartedAt
	}
	return nil
}

// ContainerStateTerminated is a terminated state of a container.
type ContainerStateTerminated struct {
	// Exit status from the last termination of the container
	ExitCode int32 `protobuf:"varint,1,opt,name=exitCode" json:"exitCode"`
	// Signal from the last termination of the container
	// +optional
	Signal int32 `protobuf:"varint,2,opt,name=signal" json:"signal"`
	// (brief) reason from the last termination of the container
	// +optional
	Reason string `protobuf:"bytes,3,opt,name=reason" json:"reason"`
	// Message regarding the last termination of the container
	// +optional
	Message string `protobuf:"bytes,4,opt,name=message" json:"message"`
	// Time at which previous execution of the container started
	// +optional
	StartedAt *v1.Time `protobuf:"bytes,5,opt,name=startedAt" json:"startedAt,omitempty"`
	// Time at which the container last terminated
	// +optional
	FinishedAt *v1.Time `protobuf:"bytes,6,opt,name=finishedAt" json:"finishedAt,omitempty"`
	// Container's ID in the format 'docker://<container_id>'
	// +optional
	ContainerID string `protobuf:"bytes,7,opt,name=containerID" json:"containerID"`
}

func (m *ContainerStateTerminated) Reset()      { *m = ContainerStateTerminated{} }
func (*ContainerStateTerminated) ProtoMessage() {}
func (*ContainerStateTerminated) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{31}
}
func (m *ContainerStateTerminated) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ContainerStateTerminated) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ContainerStateTerminated.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ContainerStateTerminated) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ContainerStateTerminated.Merge(m, src)
}
func (m *ContainerStateTerminated) XXX_Size() int {
	return m.Size()
}
func (m *ContainerStateTerminated) XXX_DiscardUnknown() {
	xxx_messageInfo_ContainerStateTerminated.DiscardUnknown(m)
}

var xxx_messageInfo_ContainerStateTerminated proto.InternalMessageInfo

func (m *ContainerStateTerminated) GetExitCode() int32 {
	if m != nil {
		return m.ExitCode
	}
	return 0
}

func (m *ContainerStateTerminated) GetSignal() int32 {
	if m != nil {
		return m.Signal
	}
	return 0
}

func (m *ContainerStateTerminated) GetReason() string {
	if m != nil {
		return m.Reason
	}
	return ""
}

func (m *ContainerStateTerminated) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

func (m *ContainerStateTerminated) GetStartedAt() *v1.Time {
	if m != nil {
		return m.StartedAt
	}
	return nil
}

func (m *ContainerStateTerminated) GetFinishedAt() *v1.Time {
	if m != nil {
		return m.FinishedAt
	}
	return nil
}

func (m *ContainerStateTerminated) GetContainerID() string {
	if m != nil {
		return m.ContainerID
	}
	return ""
}

// ContainerStateWaiting is a waiting state of a container.
type ContainerStateWaiting struct {
	// (brief) reason the container is not yet running.
	// +optional
	Reason string `protobuf:"bytes,1,opt,name=reason" json:"reason"`
	// Message regarding why the container is not yet running.
	// +optional
	Message string `protobuf:"bytes,2,opt,name=message" json:"message"`
}

func (m *ContainerStateWaiting) Reset()      { *m = ContainerStateWaiting{} }
func (*ContainerStateWaiting) ProtoMessage() {}
func (*ContainerStateWaiting) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{32}
}
func (m *ContainerStateWaiting) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ContainerStateWaiting) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ContainerStateWaiting.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ContainerStateWaiting) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ContainerStateWaiting.Merge(m, src)
}
func (m *ContainerStateWaiting) XXX_Size() int {
	return m.Size()
}
func (m *ContainerStateWaiting) XXX_DiscardUnknown() {
	xxx_messageInfo_ContainerStateWaiting.DiscardUnknown(m)
}

var xxx_messageInfo_ContainerStateWaiting proto.InternalMessageInfo

func (m *ContainerStateWaiting) GetReason() string {
	if m != nil {
		return m.Reason
	}
	return ""
}

func (m *ContainerStateWaiting) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

// ContainerStatus contains details for the current status of this container.
type ContainerStatus struct {
	// This must be a DNS_LABEL. Each container in a pod must have a unique name.
	// Cannot be updated.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name"`
	// Details about the container's current condition.
	// +optional
	State *ContainerState `protobuf:"bytes,2,opt,name=state" json:"state,omitempty"`
	// Details about the container's last termination condition.
	// +optional
	LastState *ContainerState `protobuf:"bytes,3,opt,name=lastState" json:"lastState,omitempty"`
	// Specifies whether the container has passed its readiness probe.
	Ready bool `protobuf:"varint,4,opt,name=ready" json:"ready"`
	// The number of times the container has been restarted, currently based on
	// the number of dead containers that have not yet been removed.
	// Note that this is calculated from dead containers. But those containers are subject to
	// garbage collection. This value will get capped at 5 by GC.
	RestartCount int32 `protobuf:"varint,5,opt,name=restartCount" json:"restartCount"`
	// The image the container is running.
	// More info: https://kubernetes.io/docs/concepts/containers/images
	// TODO(dchen1107): Which image the container is running with?
	Image string `protobuf:"bytes,6,opt,name=image" json:"image"`
	// ImageID of the container's image.
	ImageID string `protobuf:"bytes,7,opt,name=imageID" json:"imageID"`
	// Container's ID in the format 'docker://<container_id>'.
	// +optional
	ContainerID string `protobuf:"bytes,8,opt,name=containerID" json:"containerID"`
}

func (m *ContainerStatus) Reset()      { *m = ContainerStatus{} }
func (*ContainerStatus) ProtoMessage() {}
func (*ContainerStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{33}
}
func (m *ContainerStatus) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ContainerStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ContainerStatus.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ContainerStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ContainerStatus.Merge(m, src)
}
func (m *ContainerStatus) XXX_Size() int {
	return m.Size()
}
func (m *ContainerStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_ContainerStatus.DiscardUnknown(m)
}

var xxx_messageInfo_ContainerStatus proto.InternalMessageInfo

func (m *ContainerStatus) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ContainerStatus) GetState() *ContainerState {
	if m != nil {
		return m.State
	}
	return nil
}

func (m *ContainerStatus) GetLastState() *ContainerState {
	if m != nil {
		return m.LastState
	}
	return nil
}

func (m *ContainerStatus) GetReady() bool {
	if m != nil {
		return m.Ready
	}
	return false
}

func (m *ContainerStatus) GetRestartCount() int32 {
	if m != nil {
		return m.RestartCount
	}
	return 0
}

func (m *ContainerStatus) GetImage() string {
	if m != nil {
		return m.Image
	}
	return ""
}

func (m *ContainerStatus) GetImageID() string {
	if m != nil {
		return m.ImageID
	}
	return ""
}

func (m *ContainerStatus) GetContainerID() string {
	if m != nil {
		return m.ContainerID
	}
	return ""
}

// DaemonEndpoint contains information about a single Daemon endpoint.
type DaemonEndpoint struct {
	// Port number of the given endpoint.
	Port int32 `protobuf:"varint,1,opt,name=Port" json:"Port"`
}

func (m *DaemonEndpoint) Reset()      { *m = DaemonEndpoint{} }
func (*DaemonEndpoint) ProtoMessage() {}
func (*DaemonEndpoint) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{34}
}
func (m *DaemonEndpoint) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DaemonEndpoint) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DaemonEndpoint.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DaemonEndpoint) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DaemonEndpoint.Merge(m, src)
}
func (m *DaemonEndpoint) XXX_Size() int {
	return m.Size()
}
func (m *DaemonEndpoint) XXX_DiscardUnknown() {
	xxx_messageInfo_DaemonEndpoint.DiscardUnknown(m)
}

var xxx_messageInfo_DaemonEndpoint proto.InternalMessageInfo

func (m *DaemonEndpoint) GetPort() int32 {
	if m != nil {
		return m.Port
	}
	return 0
}

// Represents downward API info for projecting into a projected volume.
// Note that this is identical to a downwardAPI volume source without the default
// mode.
type DownwardAPIProjection struct {
	// Items is a list of DownwardAPIVolume file
	// +optional
	Items []*DownwardAPIVolumeFile `protobuf:"bytes,1,rep,name=items" json:"items,omitempty"`
}

func (m *DownwardAPIProjection) Reset()      { *m = DownwardAPIProjection{} }
func (*DownwardAPIProjection) ProtoMessage() {}
func (*DownwardAPIProjection) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{35}
}
func (m *DownwardAPIProjection) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DownwardAPIProjection) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DownwardAPIProjection.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DownwardAPIProjection) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DownwardAPIProjection.Merge(m, src)
}
func (m *DownwardAPIProjection) XXX_Size() int {
	return m.Size()
}
func (m *DownwardAPIProjection) XXX_DiscardUnknown() {
	xxx_messageInfo_DownwardAPIProjection.DiscardUnknown(m)
}

var xxx_messageInfo_DownwardAPIProjection proto.InternalMessageInfo

func (m *DownwardAPIProjection) GetItems() []*DownwardAPIVolumeFile {
	if m != nil {
		return m.Items
	}
	return nil
}

// DownwardAPIVolumeFile represents information to create the file containing the pod field
type DownwardAPIVolumeFile struct {
	// Required: Path is  the relative path name of the file to be created. Must not be absolute or contain the '..' path. Must be utf-8 encoded. The first item of the relative path must not start with '..'
	Path string `protobuf:"bytes,1,opt,name=path" json:"path"`
	// Required: Selects a field of the pod: only annotations, labels, name and namespace are supported.
	// +optional
	FieldRef *ObjectFieldSelector `protobuf:"bytes,2,opt,name=fieldRef" json:"fieldRef,omitempty"`
	// Selects a resource of the container: only resources limits and requests
	// (limits.cpu, limits.memory, requests.cpu and requests.memory) are currently supported.
	// +optional
	ResourceFieldRef *ResourceFieldSelector `protobuf:"bytes,3,opt,name=resourceFieldRef" json:"resourceFieldRef,omitempty"`
	// Optional: mode bits to use on this file, must be a value between 0
	// and 0777. If not specified, the volume defaultMode will be used.
	// This might be in conflict with other options that affect the file
	// mode, like fsGroup, and the result can be other mode bits set.
	// +optional
	Mode int32 `protobuf:"varint,4,opt,name=mode" json:"mode"`
}

func (m *DownwardAPIVolumeFile) Reset()      { *m = DownwardAPIVolumeFile{} }
func (*DownwardAPIVolumeFile) ProtoMessage() {}
func (*DownwardAPIVolumeFile) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{36}
}
func (m *DownwardAPIVolumeFile) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DownwardAPIVolumeFile) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DownwardAPIVolumeFile.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DownwardAPIVolumeFile) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DownwardAPIVolumeFile.Merge(m, src)
}
func (m *DownwardAPIVolumeFile) XXX_Size() int {
	return m.Size()
}
func (m *DownwardAPIVolumeFile) XXX_DiscardUnknown() {
	xxx_messageInfo_DownwardAPIVolumeFile.DiscardUnknown(m)
}

var xxx_messageInfo_DownwardAPIVolumeFile proto.InternalMessageInfo

func (m *DownwardAPIVolumeFile) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

func (m *DownwardAPIVolumeFile) GetFieldRef() *ObjectFieldSelector {
	if m != nil {
		return m.FieldRef
	}
	return nil
}

func (m *DownwardAPIVolumeFile) GetResourceFieldRef() *ResourceFieldSelector {
	if m != nil {
		return m.ResourceFieldRef
	}
	return nil
}

func (m *DownwardAPIVolumeFile) GetMode() int32 {
	if m != nil {
		return m.Mode
	}
	return 0
}

// DownwardAPIVolumeSource represents a volume containing downward API info.
// Downward API volumes support ownership management and SELinux relabeling.
type DownwardAPIVolumeSource struct {
	// Items is a list of downward API volume file
	// +optional
	Items []*DownwardAPIVolumeFile `protobuf:"bytes,1,rep,name=items" json:"items,omitempty"`
	// Optional: mode bits to use on created files by default. Must be a
	// value between 0 and 0777. Defaults to 0644.
	// Directories within the path are not affected by this setting.
	// This might be in conflict with other options that affect the file
	// mode, like fsGroup, and the result can be other mode bits set.
	// +optional
	DefaultMode int32 `protobuf:"varint,2,opt,name=defaultMode" json:"defaultMode"`
}

func (m *DownwardAPIVolumeSource) Reset()      { *m = DownwardAPIVolumeSource{} }
func (*DownwardAPIVolumeSource) ProtoMessage() {}
func (*DownwardAPIVolumeSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{37}
}
func (m *DownwardAPIVolumeSource) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DownwardAPIVolumeSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DownwardAPIVolumeSource.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DownwardAPIVolumeSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DownwardAPIVolumeSource.Merge(m, src)
}
func (m *DownwardAPIVolumeSource) XXX_Size() int {
	return m.Size()
}
func (m *DownwardAPIVolumeSource) XXX_DiscardUnknown() {
	xxx_messageInfo_DownwardAPIVolumeSource.DiscardUnknown(m)
}

var xxx_messageInfo_DownwardAPIVolumeSource proto.InternalMessageInfo

func (m *DownwardAPIVolumeSource) GetItems() []*DownwardAPIVolumeFile {
	if m != nil {
		return m.Items
	}
	return nil
}

func (m *DownwardAPIVolumeSource) GetDefaultMode() int32 {
	if m != nil {
		return m.DefaultMode
	}
	return 0
}

// Represents an empty directory for a pod.
// Empty directory volumes support ownership management and SELinux relabeling.
type EmptyDirVolumeSource struct {
	// What type of storage medium should back this directory.
	// The default is "" which means to use the node's default medium.
	// Must be an empty string (default) or Memory.
	// More info: https://kubernetes.io/docs/concepts/storage/volumes#emptydir
	// +optional
	Medium string `protobuf:"bytes,1,opt,name=medium" json:"medium"`
	// Total amount of local storage required for this EmptyDir volume.
	// The size limit is also applicable for memory medium.
	// The maximum usage on memory medium EmptyDir would be the minimum value between
	// the SizeLimit specified here and the sum of memory limits of all containers in a pod.
	// The default is nil which means that the limit is undefined.
	// More info: http://kubernetes.io/docs/user-guide/volumes#emptydir
	// +optional
	SizeLimit *resource.Quantity `protobuf:"bytes,2,opt,name=sizeLimit" json:"sizeLimit,omitempty"`
}

func (m *EmptyDirVolumeSource) Reset()      { *m = EmptyDirVolumeSource{} }
func (*EmptyDirVolumeSource) ProtoMessage() {}
func (*EmptyDirVolumeSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{38}
}
func (m *EmptyDirVolumeSource) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *EmptyDirVolumeSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_EmptyDirVolumeSource.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *EmptyDirVolumeSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EmptyDirVolumeSource.Merge(m, src)
}
func (m *EmptyDirVolumeSource) XXX_Size() int {
	return m.Size()
}
func (m *EmptyDirVolumeSource) XXX_DiscardUnknown() {
	xxx_messageInfo_EmptyDirVolumeSource.DiscardUnknown(m)
}

var xxx_messageInfo_EmptyDirVolumeSource proto.InternalMessageInfo

func (m *EmptyDirVolumeSource) GetMedium() string {
	if m != nil {
		return m.Medium
	}
	return ""
}

func (m *EmptyDirVolumeSource) GetSizeLimit() *resource.Quantity {
	if m != nil {
		return m.SizeLimit
	}
	return nil
}

// EndpointAddress is a tuple that describes single IP address.
type EndpointAddress struct {
	// The IP of this endpoint.
	// May not be loopback (127.0.0.0/8), link-local (169.254.0.0/16),
	// or link-local multicast ((224.0.0.0/24).
	// IPv6 is also accepted but not fully supported on all platforms. Also, certain
	// kubernetes components, like kube-proxy, are not IPv6 ready.
	// TODO: This should allow hostname or IP, See #4447.
	Ip string `protobuf:"bytes,1,opt,name=ip" json:"ip"`
	// The Hostname of this endpoint
	// +optional
	Hostname string `protobuf:"bytes,3,opt,name=hostname" json:"hostname"`
	// Optional: Node hosting this endpoint. This can be used to determine endpoints local to a node.
	// +optional
	NodeName string `protobuf:"bytes,4,opt,name=nodeName" json:"nodeName"`
	// Reference to object providing the endpoint.
	// +optional
	TargetRef *ObjectReference `protobuf:"bytes,2,opt,name=targetRef" json:"targetRef,omitempty"`
}

func (m *EndpointAddress) Reset()      { *m = EndpointAddress{} }
func (*EndpointAddress) ProtoMessage() {}
func (*EndpointAddress) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{39}
}
func (m *EndpointAddress) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *EndpointAddress) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_EndpointAddress.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *EndpointAddress) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EndpointAddress.Merge(m, src)
}
func (m *EndpointAddress) XXX_Size() int {
	return m.Size()
}
func (m *EndpointAddress) XXX_DiscardUnknown() {
	xxx_messageInfo_EndpointAddress.DiscardUnknown(m)
}

var xxx_messageInfo_EndpointAddress proto.InternalMessageInfo

func (m *EndpointAddress) GetIp() string {
	if m != nil {
		return m.Ip
	}
	return ""
}

func (m *EndpointAddress) GetHostname() string {
	if m != nil {
		return m.Hostname
	}
	return ""
}

func (m *EndpointAddress) GetNodeName() string {
	if m != nil {
		return m.NodeName
	}
	return ""
}

func (m *EndpointAddress) GetTargetRef() *ObjectReference {
	if m != nil {
		return m.TargetRef
	}
	return nil
}

// EndpointPort is a tuple that describes a single port.
type EndpointPort struct {
	// The name of this port.  This must match the 'name' field in the
	// corresponding ServicePort.
	// Must be a DNS_LABEL.
	// Optional only if one port is defined.
	// +optional
	Name string `protobuf:"bytes,1,opt,name=name" json:"name"`
	// The port number of the endpoint.
	Port int32 `protobuf:"varint,2,opt,name=port" json:"port"`
	// The IP protocol for this port.
	// Must be UDP, TCP, or SCTP.
	// Default is TCP.
	// +optional
	Protocol string `protobuf:"bytes,3,opt,name=protocol" json:"protocol"`
}

func (m *EndpointPort) Reset()      { *m = EndpointPort{} }
func (*EndpointPort) ProtoMessage() {}
func (*EndpointPort) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{40}
}
func (m *EndpointPort) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *EndpointPort) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_EndpointPort.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *EndpointPort) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EndpointPort.Merge(m, src)
}
func (m *EndpointPort) XXX_Size() int {
	return m.Size()
}
func (m *EndpointPort) XXX_DiscardUnknown() {
	xxx_messageInfo_EndpointPort.DiscardUnknown(m)
}

var xxx_messageInfo_EndpointPort proto.InternalMessageInfo

func (m *EndpointPort) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *EndpointPort) GetPort() int32 {
	if m != nil {
		return m.Port
	}
	return 0
}

func (m *EndpointPort) GetProtocol() string {
	if m != nil {
		return m.Protocol
	}
	return ""
}

// EndpointSubset is a group of addresses with a common set of ports. The
// expanded set of endpoints is the Cartesian product of Addresses x Ports.
// For example, given:
//   {
//     Addresses: [{"ip": "10.10.1.1"}, {"ip": "10.10.2.2"}],
//     Ports:     [{"name": "a", "port": 8675}, {"name": "b", "port": 309}]
//   }
// The resulting set of endpoints can be viewed as:
//     a: [ 10.10.1.1:8675, 10.10.2.2:8675 ],
//     b: [ 10.10.1.1:309, 10.10.2.2:309 ]
type EndpointSubset struct {
	// IP addresses which offer the related ports that are marked as ready. These endpoints
	// should be considered safe for load balancers and clients to utilize.
	// +optional
	Addresses []*EndpointAddress `protobuf:"bytes,1,rep,name=addresses" json:"addresses,omitempty"`
	// IP addresses which offer the related ports but are not currently marked as ready
	// because they have not yet finished starting, have recently failed a readiness check,
	// or have recently failed a liveness check.
	// +optional
	NotReadyAddresses []*EndpointAddress `protobuf:"bytes,2,rep,name=notReadyAddresses" json:"notReadyAddresses,omitempty"`
	// Port numbers available on the related IP addresses.
	// +optional
	Ports []*EndpointPort `protobuf:"bytes,3,rep,name=ports" json:"ports,omitempty"`
}

func (m *EndpointSubset) Reset()      { *m = EndpointSubset{} }
func (*EndpointSubset) ProtoMessage() {}
func (*EndpointSubset) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{41}
}
func (m *EndpointSubset) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *EndpointSubset) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_EndpointSubset.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *EndpointSubset) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EndpointSubset.Merge(m, src)
}
func (m *EndpointSubset) XXX_Size() int {
	return m.Size()
}
func (m *EndpointSubset) XXX_DiscardUnknown() {
	xxx_messageInfo_EndpointSubset.DiscardUnknown(m)
}

var xxx_messageInfo_EndpointSubset proto.InternalMessageInfo

func (m *EndpointSubset) GetAddresses() []*EndpointAddress {
	if m != nil {
		return m.Addresses
	}
	return nil
}

func (m *EndpointSubset) GetNotReadyAddresses() []*EndpointAddress {
	if m != nil {
		return m.NotReadyAddresses
	}
	return nil
}

func (m *EndpointSubset) GetPorts() []*EndpointPort {
	if m != nil {
		return m.Ports
	}
	return nil
}

// Endpoints is a collection of endpoints that implement the actual service. Example:
//   Name: "mysvc",
//   Subsets: [
//     {
//       Addresses: [{"ip": "10.10.1.1"}, {"ip": "10.10.2.2"}],
//       Ports: [{"name": "a", "port": 8675}, {"name": "b", "port": 309}]
//     },
//     {
//       Addresses: [{"ip": "10.10.3.3"}],
//       Ports: [{"name": "a", "port": 93}, {"name": "b", "port": 76}]
//     },
//  ]
type Endpoints struct {
	// Standard object's metadata.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
	// +optional
	Metadata *v1.ObjectMeta `protobuf:"bytes,1,opt,name=metadata" json:"metadata,omitempty"`
	// The set of all endpoints is the union of all subsets. Addresses are placed into
	// subsets according to the IPs they share. A single address with multiple ports,
	// some of which are ready and some of which are not (because they come from
	// different containers) will result in the address being displayed in different
	// subsets for the different ports. No address will appear in both Addresses and
	// NotReadyAddresses in the same subset.
	// Sets of addresses and ports that comprise a service.
	// +optional
	Subsets []*EndpointSubset `protobuf:"bytes,2,rep,name=subsets" json:"subsets,omitempty"`
}

func (m *Endpoints) Reset()      { *m = Endpoints{} }
func (*Endpoints) ProtoMessage() {}
func (*Endpoints) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{42}
}
func (m *Endpoints) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Endpoints) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Endpoints.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Endpoints) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Endpoints.Merge(m, src)
}
func (m *Endpoints) XXX_Size() int {
	return m.Size()
}
func (m *Endpoints) XXX_DiscardUnknown() {
	xxx_messageInfo_Endpoints.DiscardUnknown(m)
}

var xxx_messageInfo_Endpoints proto.InternalMessageInfo

func (m *Endpoints) GetMetadata() *v1.ObjectMeta {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *Endpoints) GetSubsets() []*EndpointSubset {
	if m != nil {
		return m.Subsets
	}
	return nil
}

// EndpointsList is a list of endpoints.
type EndpointsList struct {
	// Standard list metadata.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds
	// +optional
	Metadata *v1.ListMeta `protobuf:"bytes,1,opt,name=metadata" json:"metadata,omitempty"`
	// List of endpoints.
	Items []*Endpoints `protobuf:"bytes,2,rep,name=items" json:"items,omitempty"`
}

func (m *EndpointsList) Reset()      { *m = EndpointsList{} }
func (*EndpointsList) ProtoMessage() {}
func (*EndpointsList) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{43}
}
func (m *EndpointsList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *EndpointsList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_EndpointsList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *EndpointsList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EndpointsList.Merge(m, src)
}
func (m *EndpointsList) XXX_Size() int {
	return m.Size()
}
func (m *EndpointsList) XXX_DiscardUnknown() {
	xxx_messageInfo_EndpointsList.DiscardUnknown(m)
}

var xxx_messageInfo_EndpointsList proto.InternalMessageInfo

func (m *EndpointsList) GetMetadata() *v1.ListMeta {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *EndpointsList) GetItems() []*Endpoints {
	if m != nil {
		return m.Items
	}
	return nil
}

// EnvFromSource represents the source of a set of ConfigMaps
type EnvFromSource struct {
	// An optional identifier to prepend to each key in the ConfigMap. Must be a C_IDENTIFIER.
	// +optional
	Prefix string `protobuf:"bytes,1,opt,name=prefix" json:"prefix"`
	// The ConfigMap to select from
	// +optional
	ConfigMapRef *ConfigMapEnvSource `protobuf:"bytes,2,opt,name=configMapRef" json:"configMapRef,omitempty"`
	// The Secret to select from
	// +optional
	SecretRef *SecretEnvSource `protobuf:"bytes,3,opt,name=secretRef" json:"secretRef,omitempty"`
}

func (m *EnvFromSource) Reset()      { *m = EnvFromSource{} }
func (*EnvFromSource) ProtoMessage() {}
func (*EnvFromSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{44}
}
func (m *EnvFromSource) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *EnvFromSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_EnvFromSource.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *EnvFromSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EnvFromSource.Merge(m, src)
}
func (m *EnvFromSource) XXX_Size() int {
	return m.Size()
}
func (m *EnvFromSource) XXX_DiscardUnknown() {
	xxx_messageInfo_EnvFromSource.DiscardUnknown(m)
}

var xxx_messageInfo_EnvFromSource proto.InternalMessageInfo

func (m *EnvFromSource) GetPrefix() string {
	if m != nil {
		return m.Prefix
	}
	return ""
}

func (m *EnvFromSource) GetConfigMapRef() *ConfigMapEnvSource {
	if m != nil {
		return m.ConfigMapRef
	}
	return nil
}

func (m *EnvFromSource) GetSecretRef() *SecretEnvSource {
	if m != nil {
		return m.SecretRef
	}
	return nil
}

// EnvVar represents an environment variable present in a Container.
type EnvVar struct {
	// Name of the environment variable. Must be a C_IDENTIFIER.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name"`
	// Variable references $(VAR_NAME) are expanded
	// using the previous defined environment variables in the container and
	// any service environment variables. If a variable cannot be resolved,
	// the reference in the input string will be unchanged. The $(VAR_NAME)
	// syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped
	// references will never be expanded, regardless of whether the variable
	// exists or not.
	// Defaults to "".
	// +optional
	Value string `protobuf:"bytes,2,opt,name=value" json:"value"`
	// Source for the environment variable's value. Cannot be used if value is not empty.
	// +optional
	ValueFrom *EnvVarSource `protobuf:"bytes,3,opt,name=valueFrom" json:"valueFrom,omitempty"`
}

func (m *EnvVar) Reset()      { *m = EnvVar{} }
func (*EnvVar) ProtoMessage() {}
func (*EnvVar) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{45}
}
func (m *EnvVar) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *EnvVar) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_EnvVar.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *EnvVar) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EnvVar.Merge(m, src)
}
func (m *EnvVar) XXX_Size() int {
	return m.Size()
}
func (m *EnvVar) XXX_DiscardUnknown() {
	xxx_messageInfo_EnvVar.DiscardUnknown(m)
}

var xxx_messageInfo_EnvVar proto.InternalMessageInfo

func (m *EnvVar) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *EnvVar) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

func (m *EnvVar) GetValueFrom() *EnvVarSource {
	if m != nil {
		return m.ValueFrom
	}
	return nil
}

// EnvVarSource represents a source for the value of an EnvVar.
type EnvVarSource struct {
	// Selects a field of the pod: supports metadata.name, metadata.namespace, metadata.labels, metadata.annotations,
	// spec.nodeName, spec.serviceAccountName, status.hostIP, status.podIP.
	// +optional
	FieldRef *ObjectFieldSelector `protobuf:"bytes,1,opt,name=fieldRef" json:"fieldRef,omitempty"`
	// Selects a resource of the container: only resources limits and requests
	// (limits.cpu, limits.memory, limits.ephemeral-storage, requests.cpu, requests.memory and requests.ephemeral-storage) are currently supported.
	// +optional
	ResourceFieldRef *ResourceFieldSelector `protobuf:"bytes,2,opt,name=resourceFieldRef" json:"resourceFieldRef,omitempty"`
	// Selects a key of a ConfigMap.
	// +optional
	ConfigMapKeyRef *ConfigMapKeySelector `protobuf:"bytes,3,opt,name=configMapKeyRef" json:"configMapKeyRef,omitempty"`
	// Selects a key of a secret in the pod's namespace
	// +optional
	SecretKeyRef *SecretKeySelector `protobuf:"bytes,4,opt,name=secretKeyRef" json:"secretKeyRef,omitempty"`
}

func (m *EnvVarSource) Reset()      { *m = EnvVarSource{} }
func (*EnvVarSource) ProtoMessage() {}
func (*EnvVarSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{46}
}
func (m *EnvVarSource) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *EnvVarSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_EnvVarSource.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *EnvVarSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EnvVarSource.Merge(m, src)
}
func (m *EnvVarSource) XXX_Size() int {
	return m.Size()
}
func (m *EnvVarSource) XXX_DiscardUnknown() {
	xxx_messageInfo_EnvVarSource.DiscardUnknown(m)
}

var xxx_messageInfo_EnvVarSource proto.InternalMessageInfo

func (m *EnvVarSource) GetFieldRef() *ObjectFieldSelector {
	if m != nil {
		return m.FieldRef
	}
	return nil
}

func (m *EnvVarSource) GetResourceFieldRef() *ResourceFieldSelector {
	if m != nil {
		return m.ResourceFieldRef
	}
	return nil
}

func (m *EnvVarSource) GetConfigMapKeyRef() *ConfigMapKeySelector {
	if m != nil {
		return m.ConfigMapKeyRef
	}
	return nil
}

func (m *EnvVarSource) GetSecretKeyRef() *SecretKeySelector {
	if m != nil {
		return m.SecretKeyRef
	}
	return nil
}

// An EphemeralContainer is a special type of container which doesn't come with any resource
// or scheduling guarantees but can be added to a pod that has already been created. They are
// intended for user-initiated activities such as troubleshooting a running pod.
// Ephemeral containers will not be restarted when they exit, and they will be killed if the
// pod is removed or restarted. If an ephemeral container causes a pod to exceed its resource
// allocation, the pod may be evicted.
// Ephemeral containers are added via a pod's ephemeralcontainers subresource and will appear
// in the pod spec once added. No fields in EphemeralContainer may be changed once added.
// This is an alpha feature enabled by the EphemeralContainers feature flag.
type EphemeralContainer struct {
	EphemeralContainerCommon *EphemeralContainerCommon `protobuf:"bytes,1,opt,name=ephemeralContainerCommon" json:"ephemeralContainerCommon,omitempty"`
	// If set, the name of the container from PodSpec that this ephemeral container targets.
	// The ephemeral container will be run in the namespaces (IPC, PID, etc) of this container.
	// If not set then the ephemeral container is run in whatever namespaces are shared
	// for the pod. Note that the container runtime must support this feature.
	// +optional
	TargetContainerName string `protobuf:"bytes,2,opt,name=targetContainerName" json:"targetContainerName"`
}

func (m *EphemeralContainer) Reset()      { *m = EphemeralContainer{} }
func (*EphemeralContainer) ProtoMessage() {}
func (*EphemeralContainer) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{47}
}
func (m *EphemeralContainer) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *EphemeralContainer) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_EphemeralContainer.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *EphemeralContainer) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EphemeralContainer.Merge(m, src)
}
func (m *EphemeralContainer) XXX_Size() int {
	return m.Size()
}
func (m *EphemeralContainer) XXX_DiscardUnknown() {
	xxx_messageInfo_EphemeralContainer.DiscardUnknown(m)
}

var xxx_messageInfo_EphemeralContainer proto.InternalMessageInfo

func (m *EphemeralContainer) GetEphemeralContainerCommon() *EphemeralContainerCommon {
	if m != nil {
		return m.EphemeralContainerCommon
	}
	return nil
}

func (m *EphemeralContainer) GetTargetContainerName() string {
	if m != nil {
		return m.TargetContainerName
	}
	return ""
}

type EphemeralContainerCommon struct {
	// Name of the ephemeral container specified as a DNS_LABEL.
	// This name must be unique among all containers, init containers and ephemeral containers.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name"`
	// Docker image name.
	// More info: https://kubernetes.io/docs/concepts/containers/images
	Image string `protobuf:"bytes,2,opt,name=image" json:"image"`
	// Entrypoint array. Not executed within a shell.
	// The docker image's ENTRYPOINT is used if this is not provided.
	// Variable references $(VAR_NAME) are expanded using the container's environment. If a variable
	// cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax
	// can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded,
	// regardless of whether the variable exists or not.
	// Cannot be updated.
	// More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
	// +optional
	Command []string `protobuf:"bytes,3,rep,name=command" json:"command,omitempty"`
	// Arguments to the entrypoint.
	// The docker image's CMD is used if this is not provided.
	// Variable references $(VAR_NAME) are expanded using the container's environment. If a variable
	// cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax
	// can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded,
	// regardless of whether the variable exists or not.
	// Cannot be updated.
	// More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
	// +optional
	Args []string `protobuf:"bytes,4,rep,name=args" json:"args,omitempty"`
	// Container's working directory.
	// If not specified, the container runtime's default will be used, which
	// might be configured in the container image.
	// Cannot be updated.
	// +optional
	WorkingDir string `protobuf:"bytes,5,opt,name=workingDir" json:"workingDir"`
	// Ports are not allowed for ephemeral containers.
	Ports []*ContainerPort `protobuf:"bytes,6,rep,name=ports" json:"ports,omitempty"`
	// List of sources to populate environment variables in the container.
	// The keys defined within a source must be a C_IDENTIFIER. All invalid keys
	// will be reported as an event when the container is starting. When a key exists in multiple
	// sources, the value associated with the last source will take precedence.
	// Values defined by an Env with a duplicate key will take precedence.
	// Cannot be updated.
	// +optional
	EnvFrom []*EnvFromSource `protobuf:"bytes,19,rep,name=envFrom" json:"envFrom,omitempty"`
	// List of environment variables to set in the container.
	// Cannot be updated.
	// +optional
	// +patchMergeKey=name
	// +patchStrategy=merge
	Env []*EnvVar `protobuf:"bytes,7,rep,name=env" json:"env,omitempty"`
	// Resources are not allowed for ephemeral containers. Ephemeral containers use spare resources
	// already allocated to the pod.
	// +optional
	Resources *ResourceRequirements `protobuf:"bytes,8,opt,name=resources" json:"resources,omitempty"`
	// Pod volumes to mount into the container's filesystem.
	// Cannot be updated.
	// +optional
	// +patchMergeKey=mountPath
	// +patchStrategy=merge
	VolumeMounts []*VolumeMount `protobuf:"bytes,9,rep,name=volumeMounts" json:"volumeMounts,omitempty"`
	// volumeDevices is the list of block devices to be used by the container.
	// This is a beta feature.
	// +patchMergeKey=devicePath
	// +patchStrategy=merge
	// +optional
	VolumeDevices []*VolumeDevice `protobuf:"bytes,21,rep,name=volumeDevices" json:"volumeDevices,omitempty"`
	// Probes are not allowed for ephemeral containers.
	// +optional
	LivenessProbe *Probe `protobuf:"bytes,10,opt,name=livenessProbe" json:"livenessProbe,omitempty"`
	// Probes are not allowed for ephemeral containers.
	// +optional
	ReadinessProbe *Probe `protobuf:"bytes,11,opt,name=readinessProbe" json:"readinessProbe,omitempty"`
	// Lifecycle is not allowed for ephemeral containers.
	// +optional
	Lifecycle *Lifecycle `protobuf:"bytes,12,opt,name=lifecycle" json:"lifecycle,omitempty"`
	// Optional: Path at which the file to which the container's termination message
	// will be written is mounted into the container's filesystem.
	// Message written is intended to be brief final status, such as an assertion failure message.
	// Will be truncated by the node if greater than 4096 bytes. The total message length across
	// all containers will be limited to 12kb.
	// Defaults to /dev/termination-log.
	// Cannot be updated.
	// +optional
	TerminationMessagePath string `protobuf:"bytes,13,opt,name=terminationMessagePath" json:"terminationMessagePath"`
	// Indicate how the termination message should be populated. File will use the contents of
	// terminationMessagePath to populate the container status message on both success and failure.
	// FallbackToLogsOnError will use the last chunk of container log output if the termination
	// message file is empty and the container exited with an error.
	// The log output is limited to 2048 bytes or 80 lines, whichever is smaller.
	// Defaults to File.
	// Cannot be updated.
	// +optional
	TerminationMessagePolicy string `protobuf:"bytes,20,opt,name=terminationMessagePolicy" json:"terminationMessagePolicy"`
	// Image pull policy.
	// One of Always, Never, IfNotPresent.
	// Defaults to Always if :latest tag is specified, or IfNotPresent otherwise.
	// Cannot be updated.
	// More info: https://kubernetes.io/docs/concepts/containers/images#updating-images
	// +optional
	ImagePullPolicy string `protobuf:"bytes,14,opt,name=imagePullPolicy" json:"imagePullPolicy"`
	// SecurityContext is not allowed for ephemeral containers.
	// +optional
	SecurityContext *SecurityContext `protobuf:"bytes,15,opt,name=securityContext" json:"securityContext,omitempty"`
	// Whether this container should allocate a buffer for stdin in the container runtime. If this
	// is not set, reads from stdin in the container will always result in EOF.
	// Default is false.
	// +optional
	Stdin bool `protobuf:"varint,16,opt,name=stdin" json:"stdin"`
	// Whether the container runtime should close the stdin channel after it has been opened by
	// a single attach. When stdin is true the stdin stream will remain open across multiple attach
	// sessions. If stdinOnce is set to true, stdin is opened on container start, is empty until the
	// first client attaches to stdin, and then remains open and accepts data until the client disconnects,
	// at which time stdin is closed and remains closed until the container is restarted. If this
	// flag is false, a container processes that reads from stdin will never receive an EOF.
	// Default is false
	// +optional
	StdinOnce bool `protobuf:"varint,17,opt,name=stdinOnce" json:"stdinOnce"`
	// Whether this container should allocate a TTY for itself, also requires 'stdin' to be true.
	// Default is false.
	// +optional
	Tty bool `protobuf:"varint,18,opt,name=tty" json:"tty"`
}

func (m *EphemeralContainerCommon) Reset()      { *m = EphemeralContainerCommon{} }
func (*EphemeralContainerCommon) ProtoMessage() {}
func (*EphemeralContainerCommon) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{48}
}
func (m *EphemeralContainerCommon) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *EphemeralContainerCommon) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_EphemeralContainerCommon.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *EphemeralContainerCommon) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EphemeralContainerCommon.Merge(m, src)
}
func (m *EphemeralContainerCommon) XXX_Size() int {
	return m.Size()
}
func (m *EphemeralContainerCommon) XXX_DiscardUnknown() {
	xxx_messageInfo_EphemeralContainerCommon.DiscardUnknown(m)
}

var xxx_messageInfo_EphemeralContainerCommon proto.InternalMessageInfo

func (m *EphemeralContainerCommon) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *EphemeralContainerCommon) GetImage() string {
	if m != nil {
		return m.Image
	}
	return ""
}

func (m *EphemeralContainerCommon) GetCommand() []string {
	if m != nil {
		return m.Command
	}
	return nil
}

func (m *EphemeralContainerCommon) GetArgs() []string {
	if m != nil {
		return m.Args
	}
	return nil
}

func (m *EphemeralContainerCommon) GetWorkingDir() string {
	if m != nil {
		return m.WorkingDir
	}
	return ""
}

func (m *EphemeralContainerCommon) GetPorts() []*ContainerPort {
	if m != nil {
		return m.Ports
	}
	return nil
}

func (m *EphemeralContainerCommon) GetEnvFrom() []*EnvFromSource {
	if m != nil {
		return m.EnvFrom
	}
	return nil
}

func (m *EphemeralContainerCommon) GetEnv() []*EnvVar {
	if m != nil {
		return m.Env
	}
	return nil
}

func (m *EphemeralContainerCommon) GetResources() *ResourceRequirements {
	if m != nil {
		return m.Resources
	}
	return nil
}

func (m *EphemeralContainerCommon) GetVolumeMounts() []*VolumeMount {
	if m != nil {
		return m.VolumeMounts
	}
	return nil
}

func (m *EphemeralContainerCommon) GetVolumeDevices() []*VolumeDevice {
	if m != nil {
		return m.VolumeDevices
	}
	return nil
}

func (m *EphemeralContainerCommon) GetLivenessProbe() *Probe {
	if m != nil {
		return m.LivenessProbe
	}
	return nil
}

func (m *EphemeralContainerCommon) GetReadinessProbe() *Probe {
	if m != nil {
		return m.ReadinessProbe
	}
	return nil
}

func (m *EphemeralContainerCommon) GetLifecycle() *Lifecycle {
	if m != nil {
		return m.Lifecycle
	}
	return nil
}

func (m *EphemeralContainerCommon) GetTerminationMessagePath() string {
	if m != nil {
		return m.TerminationMessagePath
	}
	return ""
}

func (m *EphemeralContainerCommon) GetTerminationMessagePolicy() string {
	if m != nil {
		return m.TerminationMessagePolicy
	}
	return ""
}

func (m *EphemeralContainerCommon) GetImagePullPolicy() string {
	if m != nil {
		return m.ImagePullPolicy
	}
	return ""
}

func (m *EphemeralContainerCommon) GetSecurityContext() *SecurityContext {
	if m != nil {
		return m.SecurityContext
	}
	return nil
}

func (m *EphemeralContainerCommon) GetStdin() bool {
	if m != nil {
		return m.Stdin
	}
	return false
}

func (m *EphemeralContainerCommon) GetStdinOnce() bool {
	if m != nil {
		return m.StdinOnce
	}
	return false
}

func (m *EphemeralContainerCommon) GetTty() bool {
	if m != nil {
		return m.Tty
	}
	return false
}

// A list of ephemeral containers used in API operations
type EphemeralContainers struct {
	// +optional
	Metadata *v1.ObjectMeta `protobuf:"bytes,1,opt,name=metadata" json:"metadata,omitempty"`
	// The new set of ephemeral containers to use for a pod.
	// +patchMergeKey=name
	// +patchStrategy=merge
	EphemeralContainers []*EphemeralContainer `protobuf:"bytes,2,rep,name=ephemeralContainers" json:"ephemeralContainers,omitempty"`
}

func (m *EphemeralContainers) Reset()      { *m = EphemeralContainers{} }
func (*EphemeralContainers) ProtoMessage() {}
func (*EphemeralContainers) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{49}
}
func (m *EphemeralContainers) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *EphemeralContainers) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_EphemeralContainers.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *EphemeralContainers) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EphemeralContainers.Merge(m, src)
}
func (m *EphemeralContainers) XXX_Size() int {
	return m.Size()
}
func (m *EphemeralContainers) XXX_DiscardUnknown() {
	xxx_messageInfo_EphemeralContainers.DiscardUnknown(m)
}

var xxx_messageInfo_EphemeralContainers proto.InternalMessageInfo

func (m *EphemeralContainers) GetMetadata() *v1.ObjectMeta {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *EphemeralContainers) GetEphemeralContainers() []*EphemeralContainer {
	if m != nil {
		return m.EphemeralContainers
	}
	return nil
}

// Event is a report of an event somewhere in the cluster.
type Event struct {
	// Standard object's metadata.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
	Metadata *v1.ObjectMeta `protobuf:"bytes,1,opt,name=metadata" json:"metadata,omitempty"`
	// The object that this event is about.
	InvolvedObject *ObjectReference `protobuf:"bytes,2,opt,name=involvedObject" json:"involvedObject,omitempty"`
	// This should be a short, machine understandable string that gives the reason
	// for the transition into the object's current status.
	// TODO: provide exact specification for format.
	// +optional
	Reason string `protobuf:"bytes,3,opt,name=reason" json:"reason"`
	// A human-readable description of the status of this operation.
	// TODO: decide on maximum length.
	// +optional
	Message string `protobuf:"bytes,4,opt,name=message" json:"message"`
	// The component reporting this event. Should be a short machine understandable string.
	// +optional
	Source *EventSource `protobuf:"bytes,5,opt,name=source" json:"source,omitempty"`
	// The time at which the event was first recorded. (Time of server receipt is in TypeMeta.)
	// +optional
	FirstTimestamp *v1.Time `protobuf:"bytes,6,opt,name=firstTimestamp" json:"firstTimestamp,omitempty"`
	// The time at which the most recent occurrence of this event was recorded.
	// +optional
	LastTimestamp *v1.Time `protobuf:"bytes,7,opt,name=lastTimestamp" json:"lastTimestamp,omitempty"`
	// The number of times this event has occurred.
	// +optional
	Count int32 `protobuf:"varint,8,opt,name=count" json:"count"`
	// Type of this event (Normal, Warning), new types could be added in the future
	// +optional
	Type string `protobuf:"bytes,9,opt,name=type" json:"type"`
	// Time when this Event was first observed.
	// +optional
	EventTime *v1.MicroTime `protobuf:"bytes,10,opt,name=eventTime" json:"eventTime,omitempty"`
	// Data about the Event series this event represents or nil if it's a singleton Event.
	// +optional
	Series *EventSeries `protobuf:"bytes,11,opt,name=series" json:"series,omitempty"`
	// What action was taken/failed regarding to the Regarding object.
	// +optional
	Action string `protobuf:"bytes,12,opt,name=action" json:"action"`
	// Optional secondary object for more complex actions.
	// +optional
	Related *ObjectReference `protobuf:"bytes,13,opt,name=related" json:"related,omitempty"`
	// Name of the controller that emitted this Event, e.g. `kubernetes.io/kubelet`.
	// +optional
	ReportingComponent string `protobuf:"bytes,14,opt,name=reportingComponent" json:"reportingComponent"`
	// ID of the controller instance, e.g. `kubelet-xyzf`.
	// +optional
	ReportingInstance string `protobuf:"bytes,15,opt,name=reportingInstance" json:"reportingInstance"`
}

func (m *Event) Reset()      { *m = Event{} }
func (*Event) ProtoMessage() {}
func (*Event) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{50}
}
func (m *Event) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Event) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Event.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Event) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Event.Merge(m, src)
}
func (m *Event) XXX_Size() int {
	return m.Size()
}
func (m *Event) XXX_DiscardUnknown() {
	xxx_messageInfo_Event.DiscardUnknown(m)
}

var xxx_messageInfo_Event proto.InternalMessageInfo

func (m *Event) GetMetadata() *v1.ObjectMeta {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *Event) GetInvolvedObject() *ObjectReference {
	if m != nil {
		return m.InvolvedObject
	}
	return nil
}

func (m *Event) GetReason() string {
	if m != nil {
		return m.Reason
	}
	return ""
}

func (m *Event) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

func (m *Event) GetSource() *EventSource {
	if m != nil {
		return m.Source
	}
	return nil
}

func (m *Event) GetFirstTimestamp() *v1.Time {
	if m != nil {
		return m.FirstTimestamp
	}
	return nil
}

func (m *Event) GetLastTimestamp() *v1.Time {
	if m != nil {
		return m.LastTimestamp
	}
	return nil
}

func (m *Event) GetCount() int32 {
	if m != nil {
		return m.Count
	}
	return 0
}

func (m *Event) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *Event) GetEventTime() *v1.MicroTime {
	if m != nil {
		return m.EventTime
	}
	return nil
}

func (m *Event) GetSeries() *EventSeries {
	if m != nil {
		return m.Series
	}
	return nil
}

func (m *Event) GetAction() string {
	if m != nil {
		return m.Action
	}
	return ""
}

func (m *Event) GetRelated() *ObjectReference {
	if m != nil {
		return m.Related
	}
	return nil
}

func (m *Event) GetReportingComponent() string {
	if m != nil {
		return m.ReportingComponent
	}
	return ""
}

func (m *Event) GetReportingInstance() string {
	if m != nil {
		return m.ReportingInstance
	}
	return ""
}

// EventList is a list of events.
type EventList struct {
	// Standard list metadata.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds
	// +optional
	Metadata *v1.ListMeta `protobuf:"bytes,1,opt,name=metadata" json:"metadata,omitempty"`
	// List of events
	Items []*Event `protobuf:"bytes,2,rep,name=items" json:"items,omitempty"`
}

func (m *EventList) Reset()      { *m = EventList{} }
func (*EventList) ProtoMessage() {}
func (*EventList) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{51}
}
func (m *EventList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *EventList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_EventList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *EventList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EventList.Merge(m, src)
}
func (m *EventList) XXX_Size() int {
	return m.Size()
}
func (m *EventList) XXX_DiscardUnknown() {
	xxx_messageInfo_EventList.DiscardUnknown(m)
}

var xxx_messageInfo_EventList proto.InternalMessageInfo

func (m *EventList) GetMetadata() *v1.ListMeta {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *EventList) GetItems() []*Event {
	if m != nil {
		return m.Items
	}
	return nil
}

// EventSeries contain information on series of events, i.e. thing that was/is happening
// continuously for some time.
type EventSeries struct {
	// Number of occurrences in this series up to the last heartbeat time
	Count int32 `protobuf:"varint,1,opt,name=count" json:"count"`
	// Time of the last occurrence observed
	LastObservedTime *v1.MicroTime `protobuf:"bytes,2,opt,name=lastObservedTime" json:"lastObservedTime,omitempty"`
	// State of this Series: Ongoing or Finished
	// Deprecated. Planned removal for 1.18
	State string `protobuf:"bytes,3,opt,name=state" json:"state"`
}

func (m *EventSeries) Reset()      { *m = EventSeries{} }
func (*EventSeries) ProtoMessage() {}
func (*EventSeries) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{52}
}
func (m *EventSeries) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *EventSeries) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_EventSeries.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *EventSeries) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EventSeries.Merge(m, src)
}
func (m *EventSeries) XXX_Size() int {
	return m.Size()
}
func (m *EventSeries) XXX_DiscardUnknown() {
	xxx_messageInfo_EventSeries.DiscardUnknown(m)
}

var xxx_messageInfo_EventSeries proto.InternalMessageInfo

func (m *EventSeries) GetCount() int32 {
	if m != nil {
		return m.Count
	}
	return 0
}

func (m *EventSeries) GetLastObservedTime() *v1.MicroTime {
	if m != nil {
		return m.LastObservedTime
	}
	return nil
}

func (m *EventSeries) GetState() string {
	if m != nil {
		return m.State
	}
	return ""
}

// EventSource contains information for an event.
type EventSource struct {
	// Component from which the event is generated.
	// +optional
	Component string `protobuf:"bytes,1,opt,name=component" json:"component"`
	// Node name on which the event is generated.
	// +optional
	Host string `protobuf:"bytes,2,opt,name=host" json:"host"`
}

func (m *EventSource) Reset()      { *m = EventSource{} }
func (*EventSource) ProtoMessage() {}
func (*EventSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{53}
}
func (m *EventSource) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *EventSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_EventSource.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *EventSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EventSource.Merge(m, src)
}
func (m *EventSource) XXX_Size() int {
	return m.Size()
}
func (m *EventSource) XXX_DiscardUnknown() {
	xxx_messageInfo_EventSource.DiscardUnknown(m)
}

var xxx_messageInfo_EventSource proto.InternalMessageInfo

func (m *EventSource) GetComponent() string {
	if m != nil {
		return m.Component
	}
	return ""
}

func (m *EventSource) GetHost() string {
	if m != nil {
		return m.Host
	}
	return ""
}

// ExecAction describes a "run in container" action.
type ExecAction struct {
	// Command is the command line to execute inside the container, the working directory for the
	// command  is root ('/') in the container's filesystem. The command is simply exec'd, it is
	// not run inside a shell, so traditional shell instructions ('|', etc) won't work. To use
	// a shell, you need to explicitly call out to that shell.
	// Exit status of 0 is treated as live/healthy and non-zero is unhealthy.
	// +optional
	Command []string `protobuf:"bytes,1,rep,name=command" json:"command,omitempty"`
}

func (m *ExecAction) Reset()      { *m = ExecAction{} }
func (*ExecAction) ProtoMessage() {}
func (*ExecAction) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{54}
}
func (m *ExecAction) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ExecAction) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ExecAction.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ExecAction) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExecAction.Merge(m, src)
}
func (m *ExecAction) XXX_Size() int {
	return m.Size()
}
func (m *ExecAction) XXX_DiscardUnknown() {
	xxx_messageInfo_ExecAction.DiscardUnknown(m)
}

var xxx_messageInfo_ExecAction proto.InternalMessageInfo

func (m *ExecAction) GetCommand() []string {
	if m != nil {
		return m.Command
	}
	return nil
}

// Represents a Fibre Channel volume.
// Fibre Channel volumes can only be mounted as read/write once.
// Fibre Channel volumes support ownership management and SELinux relabeling.
type FCVolumeSource struct {
	// Optional: FC target worldwide names (WWNs)
	// +optional
	TargetWWNs []string `protobuf:"bytes,1,rep,name=targetWWNs" json:"targetWWNs,omitempty"`
	// Optional: FC target lun number
	// +optional
	Lun int32 `protobuf:"varint,2,opt,name=lun" json:"lun"`
	// Filesystem type to mount.
	// Must be a filesystem type supported by the host operating system.
	// Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
	// TODO: how do we prevent errors in the filesystem from compromising the machine
	// +optional
	FsType string `protobuf:"bytes,3,opt,name=fsType" json:"fsType"`
	// Optional: Defaults to false (read/write). ReadOnly here will force
	// the ReadOnly setting in VolumeMounts.
	// +optional
	ReadOnly bool `protobuf:"varint,4,opt,name=readOnly" json:"readOnly"`
	// Optional: FC volume world wide identifiers (wwids)
	// Either wwids or combination of targetWWNs and lun must be set, but not both simultaneously.
	// +optional
	Wwids []string `protobuf:"bytes,5,rep,name=wwids" json:"wwids,omitempty"`
}

func (m *FCVolumeSource) Reset()      { *m = FCVolumeSource{} }
func (*FCVolumeSource) ProtoMessage() {}
func (*FCVolumeSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{55}
}
func (m *FCVolumeSource) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *FCVolumeSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_FCVolumeSource.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *FCVolumeSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FCVolumeSource.Merge(m, src)
}
func (m *FCVolumeSource) XXX_Size() int {
	return m.Size()
}
func (m *FCVolumeSource) XXX_DiscardUnknown() {
	xxx_messageInfo_FCVolumeSource.DiscardUnknown(m)
}

var xxx_messageInfo_FCVolumeSource proto.InternalMessageInfo

func (m *FCVolumeSource) GetTargetWWNs() []string {
	if m != nil {
		return m.TargetWWNs
	}
	return nil
}

func (m *FCVolumeSource) GetLun() int32 {
	if m != nil {
		return m.Lun
	}
	return 0
}

func (m *FCVolumeSource) GetFsType() string {
	if m != nil {
		return m.FsType
	}
	return ""
}

func (m *FCVolumeSource) GetReadOnly() bool {
	if m != nil {
		return m.ReadOnly
	}
	return false
}

func (m *FCVolumeSource) GetWwids() []string {
	if m != nil {
		return m.Wwids
	}
	return nil
}

// FlexPersistentVolumeSource represents a generic persistent volume resource that is
// provisioned/attached using an exec based plugin.
type FlexPersistentVolumeSource struct {
	// Driver is the name of the driver to use for this volume.
	Driver string `protobuf:"bytes,1,opt,name=driver" json:"driver"`
	// Filesystem type to mount.
	// Must be a filesystem type supported by the host operating system.
	// Ex. "ext4", "xfs", "ntfs". The default filesystem depends on FlexVolume script.
	// +optional
	FsType string `protobuf:"bytes,2,opt,name=fsType" json:"fsType"`
	// Optional: SecretRef is reference to the secret object containing
	// sensitive information to pass to the plugin scripts. This may be
	// empty if no secret object is specified. If the secret object
	// contains more than one secret, all secrets are passed to the plugin
	// scripts.
	// +optional
	SecretRef *SecretReference `protobuf:"bytes,3,opt,name=secretRef" json:"secretRef,omitempty"`
	// Optional: Defaults to false (read/write). ReadOnly here will force
	// the ReadOnly setting in VolumeMounts.
	// +optional
	ReadOnly bool `protobuf:"varint,4,opt,name=readOnly" json:"readOnly"`
	// Optional: Extra command options if any.
	// +optional
	Options map[string]string `protobuf:"bytes,5,rep,name=options" json:"options,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *FlexPersistentVolumeSource) Reset()      { *m = FlexPersistentVolumeSource{} }
func (*FlexPersistentVolumeSource) ProtoMessage() {}
func (*FlexPersistentVolumeSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{56}
}
func (m *FlexPersistentVolumeSource) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *FlexPersistentVolumeSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_FlexPersistentVolumeSource.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *FlexPersistentVolumeSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FlexPersistentVolumeSource.Merge(m, src)
}
func (m *FlexPersistentVolumeSource) XXX_Size() int {
	return m.Size()
}
func (m *FlexPersistentVolumeSource) XXX_DiscardUnknown() {
	xxx_messageInfo_FlexPersistentVolumeSource.DiscardUnknown(m)
}

var xxx_messageInfo_FlexPersistentVolumeSource proto.InternalMessageInfo

func (m *FlexPersistentVolumeSource) GetDriver() string {
	if m != nil {
		return m.Driver
	}
	return ""
}

func (m *FlexPersistentVolumeSource) GetFsType() string {
	if m != nil {
		return m.FsType
	}
	return ""
}

func (m *FlexPersistentVolumeSource) GetSecretRef() *SecretReference {
	if m != nil {
		return m.SecretRef
	}
	return nil
}

func (m *FlexPersistentVolumeSource) GetReadOnly() bool {
	if m != nil {
		return m.ReadOnly
	}
	return false
}

func (m *FlexPersistentVolumeSource) GetOptions() map[string]string {
	if m != nil {
		return m.Options
	}
	return nil
}

// FlexVolume represents a generic volume resource that is
// provisioned/attached using an exec based plugin.
type FlexVolumeSource struct {
	// Driver is the name of the driver to use for this volume.
	Driver string `protobuf:"bytes,1,opt,name=driver" json:"driver"`
	// Filesystem type to mount.
	// Must be a filesystem type supported by the host operating system.
	// Ex. "ext4", "xfs", "ntfs". The default filesystem depends on FlexVolume script.
	// +optional
	FsType string `protobuf:"bytes,2,opt,name=fsType" json:"fsType"`
	// Optional: SecretRef is reference to the secret object containing
	// sensitive information to pass to the plugin scripts. This may be
	// empty if no secret object is specified. If the secret object
	// contains more than one secret, all secrets are passed to the plugin
	// scripts.
	// +optional
	SecretRef *LocalObjectReference `protobuf:"bytes,3,opt,name=secretRef" json:"secretRef,omitempty"`
	// Optional: Defaults to false (read/write). ReadOnly here will force
	// the ReadOnly setting in VolumeMounts.
	// +optional
	ReadOnly bool `protobuf:"varint,4,opt,name=readOnly" json:"readOnly"`
	// Optional: Extra command options if any.
	// +optional
	Options map[string]string `protobuf:"bytes,5,rep,name=options" json:"options,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *FlexVolumeSource) Reset()      { *m = FlexVolumeSource{} }
func (*FlexVolumeSource) ProtoMessage() {}
func (*FlexVolumeSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{57}
}
func (m *FlexVolumeSource) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *FlexVolumeSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_FlexVolumeSource.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *FlexVolumeSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FlexVolumeSource.Merge(m, src)
}
func (m *FlexVolumeSource) XXX_Size() int {
	return m.Size()
}
func (m *FlexVolumeSource) XXX_DiscardUnknown() {
	xxx_messageInfo_FlexVolumeSource.DiscardUnknown(m)
}

var xxx_messageInfo_FlexVolumeSource proto.InternalMessageInfo

func (m *FlexVolumeSource) GetDriver() string {
	if m != nil {
		return m.Driver
	}
	return ""
}

func (m *FlexVolumeSource) GetFsType() string {
	if m != nil {
		return m.FsType
	}
	return ""
}

func (m *FlexVolumeSource) GetSecretRef() *LocalObjectReference {
	if m != nil {
		return m.SecretRef
	}
	return nil
}

func (m *FlexVolumeSource) GetReadOnly() bool {
	if m != nil {
		return m.ReadOnly
	}
	return false
}

func (m *FlexVolumeSource) GetOptions() map[string]string {
	if m != nil {
		return m.Options
	}
	return nil
}

// Represents a Flocker volume mounted by the Flocker agent.
// One and only one of datasetName and datasetUUID should be set.
// Flocker volumes do not support ownership management or SELinux relabeling.
type FlockerVolumeSource struct {
	// Name of the dataset stored as metadata -> name on the dataset for Flocker
	// should be considered as deprecated
	// +optional
	DatasetName string `protobuf:"bytes,1,opt,name=datasetName" json:"datasetName"`
	// UUID of the dataset. This is unique identifier of a Flocker dataset
	// +optional
	DatasetUUID string `protobuf:"bytes,2,opt,name=datasetUUID" json:"datasetUUID"`
}

func (m *FlockerVolumeSource) Reset()      { *m = FlockerVolumeSource{} }
func (*FlockerVolumeSource) ProtoMessage() {}
func (*FlockerVolumeSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{58}
}
func (m *FlockerVolumeSource) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *FlockerVolumeSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_FlockerVolumeSource.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *FlockerVolumeSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FlockerVolumeSource.Merge(m, src)
}
func (m *FlockerVolumeSource) XXX_Size() int {
	return m.Size()
}
func (m *FlockerVolumeSource) XXX_DiscardUnknown() {
	xxx_messageInfo_FlockerVolumeSource.DiscardUnknown(m)
}

var xxx_messageInfo_FlockerVolumeSource proto.InternalMessageInfo

func (m *FlockerVolumeSource) GetDatasetName() string {
	if m != nil {
		return m.DatasetName
	}
	return ""
}

func (m *FlockerVolumeSource) GetDatasetUUID() string {
	if m != nil {
		return m.DatasetUUID
	}
	return ""
}

// Represents a Persistent Disk resource in Google Compute Engine.
//
// A GCE PD must exist before mounting to a container. The disk must
// also be in the same GCE project and zone as the kubelet. A GCE PD
// can only be mounted as read/write once or read-only many times. GCE
// PDs support ownership management and SELinux relabeling.
type GCEPersistentDiskVolumeSource struct {
	// Unique name of the PD resource in GCE. Used to identify the disk in GCE.
	// More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
	PdName string `protobuf:"bytes,1,opt,name=pdName" json:"pdName"`
	// Filesystem type of the volume that you want to mount.
	// Tip: Ensure that the filesystem type is supported by the host operating system.
	// Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
	// More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
	// TODO: how do we prevent errors in the filesystem from compromising the machine
	// +optional
	FsType string `protobuf:"bytes,2,opt,name=fsType" json:"fsType"`
	// The partition in the volume that you want to mount.
	// If omitted, the default is to mount by volume name.
	// Examples: For volume /dev/sda1, you specify the partition as "1".
	// Similarly, the volume partition for /dev/sda is "0" (or you can leave the property empty).
	// More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
	// +optional
	Partition int32 `protobuf:"varint,3,opt,name=partition" json:"partition"`
	// ReadOnly here will force the ReadOnly setting in VolumeMounts.
	// Defaults to false.
	// More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
	// +optional
	ReadOnly bool `protobuf:"varint,4,opt,name=readOnly" json:"readOnly"`
}

func (m *GCEPersistentDiskVolumeSource) Reset()      { *m = GCEPersistentDiskVolumeSource{} }
func (*GCEPersistentDiskVolumeSource) ProtoMessage() {}
func (*GCEPersistentDiskVolumeSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{59}
}
func (m *GCEPersistentDiskVolumeSource) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GCEPersistentDiskVolumeSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GCEPersistentDiskVolumeSource.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GCEPersistentDiskVolumeSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GCEPersistentDiskVolumeSource.Merge(m, src)
}
func (m *GCEPersistentDiskVolumeSource) XXX_Size() int {
	return m.Size()
}
func (m *GCEPersistentDiskVolumeSource) XXX_DiscardUnknown() {
	xxx_messageInfo_GCEPersistentDiskVolumeSource.DiscardUnknown(m)
}

var xxx_messageInfo_GCEPersistentDiskVolumeSource proto.InternalMessageInfo

func (m *GCEPersistentDiskVolumeSource) GetPdName() string {
	if m != nil {
		return m.PdName
	}
	return ""
}

func (m *GCEPersistentDiskVolumeSource) GetFsType() string {
	if m != nil {
		return m.FsType
	}
	return ""
}

func (m *GCEPersistentDiskVolumeSource) GetPartition() int32 {
	if m != nil {
		return m.Partition
	}
	return 0
}

func (m *GCEPersistentDiskVolumeSource) GetReadOnly() bool {
	if m != nil {
		return m.ReadOnly
	}
	return false
}

// Represents a volume that is populated with the contents of a git repository.
// Git repo volumes do not support ownership management.
// Git repo volumes support SELinux relabeling.
//
// DEPRECATED: GitRepo is deprecated. To provision a container with a git repo, mount an
// EmptyDir into an InitContainer that clones the repo using git, then mount the EmptyDir
// into the Pod's container.
type GitRepoVolumeSource struct {
	// Repository URL
	Repository string `protobuf:"bytes,1,opt,name=repository" json:"repository"`
	// Commit hash for the specified revision.
	// +optional
	Revision string `protobuf:"bytes,2,opt,name=revision" json:"revision"`
	// Target directory name.
	// Must not contain or start with '..'.  If '.' is supplied, the volume directory will be the
	// git repository.  Otherwise, if specified, the volume will contain the git repository in
	// the subdirectory with the given name.
	// +optional
	Directory string `protobuf:"bytes,3,opt,name=directory" json:"directory"`
}

func (m *GitRepoVolumeSource) Reset()      { *m = GitRepoVolumeSource{} }
func (*GitRepoVolumeSource) ProtoMessage() {}
func (*GitRepoVolumeSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{60}
}
func (m *GitRepoVolumeSource) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GitRepoVolumeSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GitRepoVolumeSource.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GitRepoVolumeSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GitRepoVolumeSource.Merge(m, src)
}
func (m *GitRepoVolumeSource) XXX_Size() int {
	return m.Size()
}
func (m *GitRepoVolumeSource) XXX_DiscardUnknown() {
	xxx_messageInfo_GitRepoVolumeSource.DiscardUnknown(m)
}

var xxx_messageInfo_GitRepoVolumeSource proto.InternalMessageInfo

func (m *GitRepoVolumeSource) GetRepository() string {
	if m != nil {
		return m.Repository
	}
	return ""
}

func (m *GitRepoVolumeSource) GetRevision() string {
	if m != nil {
		return m.Revision
	}
	return ""
}

func (m *GitRepoVolumeSource) GetDirectory() string {
	if m != nil {
		return m.Directory
	}
	return ""
}

// Represents a Glusterfs mount that lasts the lifetime of a pod.
// Glusterfs volumes do not support ownership management or SELinux relabeling.
type GlusterfsPersistentVolumeSource struct {
	// EndpointsName is the endpoint name that details Glusterfs topology.
	// More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
	Endpoints string `protobuf:"bytes,1,opt,name=endpoints" json:"endpoints"`
	// Path is the Glusterfs volume path.
	// More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
	Path string `protobuf:"bytes,2,opt,name=path" json:"path"`
	// ReadOnly here will force the Glusterfs volume to be mounted with read-only permissions.
	// Defaults to false.
	// More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
	// +optional
	ReadOnly bool `protobuf:"varint,3,opt,name=readOnly" json:"readOnly"`
	// EndpointsNamespace is the namespace that contains Glusterfs endpoint.
	// If this field is empty, the EndpointNamespace defaults to the same namespace as the bound PVC.
	// More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
	// +optional
	EndpointsNamespace string `protobuf:"bytes,4,opt,name=endpointsNamespace" json:"endpointsNamespace"`
}

func (m *GlusterfsPersistentVolumeSource) Reset()      { *m = GlusterfsPersistentVolumeSource{} }
func (*GlusterfsPersistentVolumeSource) ProtoMessage() {}
func (*GlusterfsPersistentVolumeSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{61}
}
func (m *GlusterfsPersistentVolumeSource) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GlusterfsPersistentVolumeSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GlusterfsPersistentVolumeSource.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GlusterfsPersistentVolumeSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GlusterfsPersistentVolumeSource.Merge(m, src)
}
func (m *GlusterfsPersistentVolumeSource) XXX_Size() int {
	return m.Size()
}
func (m *GlusterfsPersistentVolumeSource) XXX_DiscardUnknown() {
	xxx_messageInfo_GlusterfsPersistentVolumeSource.DiscardUnknown(m)
}

var xxx_messageInfo_GlusterfsPersistentVolumeSource proto.InternalMessageInfo

func (m *GlusterfsPersistentVolumeSource) GetEndpoints() string {
	if m != nil {
		return m.Endpoints
	}
	return ""
}

func (m *GlusterfsPersistentVolumeSource) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

func (m *GlusterfsPersistentVolumeSource) GetReadOnly() bool {
	if m != nil {
		return m.ReadOnly
	}
	return false
}

func (m *GlusterfsPersistentVolumeSource) GetEndpointsNamespace() string {
	if m != nil {
		return m.EndpointsNamespace
	}
	return ""
}

// Represents a Glusterfs mount that lasts the lifetime of a pod.
// Glusterfs volumes do not support ownership management or SELinux relabeling.
type GlusterfsVolumeSource struct {
	// EndpointsName is the endpoint name that details Glusterfs topology.
	// More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
	Endpoints string `protobuf:"bytes,1,opt,name=endpoints" json:"endpoints"`
	// Path is the Glusterfs volume path.
	// More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
	Path string `protobuf:"bytes,2,opt,name=path" json:"path"`
	// ReadOnly here will force the Glusterfs volume to be mounted with read-only permissions.
	// Defaults to false.
	// More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
	// +optional
	ReadOnly bool `protobuf:"varint,3,opt,name=readOnly" json:"readOnly"`
}

func (m *GlusterfsVolumeSource) Reset()      { *m = GlusterfsVolumeSource{} }
func (*GlusterfsVolumeSource) ProtoMessage() {}
func (*GlusterfsVolumeSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{62}
}
func (m *GlusterfsVolumeSource) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GlusterfsVolumeSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GlusterfsVolumeSource.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GlusterfsVolumeSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GlusterfsVolumeSource.Merge(m, src)
}
func (m *GlusterfsVolumeSource) XXX_Size() int {
	return m.Size()
}
func (m *GlusterfsVolumeSource) XXX_DiscardUnknown() {
	xxx_messageInfo_GlusterfsVolumeSource.DiscardUnknown(m)
}

var xxx_messageInfo_GlusterfsVolumeSource proto.InternalMessageInfo

func (m *GlusterfsVolumeSource) GetEndpoints() string {
	if m != nil {
		return m.Endpoints
	}
	return ""
}

func (m *GlusterfsVolumeSource) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

func (m *GlusterfsVolumeSource) GetReadOnly() bool {
	if m != nil {
		return m.ReadOnly
	}
	return false
}

// HTTPGetAction describes an action based on HTTP Get requests.
type HTTPGetAction struct {
	// Path to access on the HTTP server.
	// +optional
	Path string `protobuf:"bytes,1,opt,name=path" json:"path"`
	// Name or number of the port to access on the container.
	// Number must be in the range 1 to 65535.
	// Name must be an IANA_SVC_NAME.
	Port *intstr.IntOrString `protobuf:"bytes,2,opt,name=port" json:"port,omitempty"`
	// Host name to connect to, defaults to the pod IP. You probably want to set
	// "Host" in httpHeaders instead.
	// +optional
	Host string `protobuf:"bytes,3,opt,name=host" json:"host"`
	// Scheme to use for connecting to the host.
	// Defaults to HTTP.
	// +optional
	Scheme string `protobuf:"bytes,4,opt,name=scheme" json:"scheme"`
	// Custom headers to set in the request. HTTP allows repeated headers.
	// +optional
	HttpHeaders []*HTTPHeader `protobuf:"bytes,5,rep,name=httpHeaders" json:"httpHeaders,omitempty"`
}

func (m *HTTPGetAction) Reset()      { *m = HTTPGetAction{} }
func (*HTTPGetAction) ProtoMessage() {}
func (*HTTPGetAction) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{63}
}
func (m *HTTPGetAction) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HTTPGetAction) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_HTTPGetAction.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *HTTPGetAction) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HTTPGetAction.Merge(m, src)
}
func (m *HTTPGetAction) XXX_Size() int {
	return m.Size()
}
func (m *HTTPGetAction) XXX_DiscardUnknown() {
	xxx_messageInfo_HTTPGetAction.DiscardUnknown(m)
}

var xxx_messageInfo_HTTPGetAction proto.InternalMessageInfo

func (m *HTTPGetAction) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

func (m *HTTPGetAction) GetPort() *intstr.IntOrString {
	if m != nil {
		return m.Port
	}
	return nil
}

func (m *HTTPGetAction) GetHost() string {
	if m != nil {
		return m.Host
	}
	return ""
}

func (m *HTTPGetAction) GetScheme() string {
	if m != nil {
		return m.Scheme
	}
	return ""
}

func (m *HTTPGetAction) GetHttpHeaders() []*HTTPHeader {
	if m != nil {
		return m.HttpHeaders
	}
	return nil
}

// HTTPHeader describes a custom header to be used in HTTP probes
type HTTPHeader struct {
	// The header field name
	Name string `protobuf:"bytes,1,opt,name=name" json:"name"`
	// The header field value
	Value string `protobuf:"bytes,2,opt,name=value" json:"value"`
}

func (m *HTTPHeader) Reset()      { *m = HTTPHeader{} }
func (*HTTPHeader) ProtoMessage() {}
func (*HTTPHeader) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{64}
}
func (m *HTTPHeader) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HTTPHeader) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_HTTPHeader.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *HTTPHeader) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HTTPHeader.Merge(m, src)
}
func (m *HTTPHeader) XXX_Size() int {
	return m.Size()
}
func (m *HTTPHeader) XXX_DiscardUnknown() {
	xxx_messageInfo_HTTPHeader.DiscardUnknown(m)
}

var xxx_messageInfo_HTTPHeader proto.InternalMessageInfo

func (m *HTTPHeader) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *HTTPHeader) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

// Handler defines a specific action that should be taken
// TODO: pass structured data to these actions, and document that data here.
type Handler struct {
	// One and only one of the following should be specified.
	// Exec specifies the action to take.
	// +optional
	Exec *ExecAction `protobuf:"bytes,1,opt,name=exec" json:"exec,omitempty"`
	// HTTPGet specifies the http request to perform.
	// +optional
	HttpGet *HTTPGetAction `protobuf:"bytes,2,opt,name=httpGet" json:"httpGet,omitempty"`
	// TCPSocket specifies an action involving a TCP port.
	// TCP hooks not yet supported
	// TODO: implement a realistic TCP lifecycle hook
	// +optional
	TcpSocket *TCPSocketAction `protobuf:"bytes,3,opt,name=tcpSocket" json:"tcpSocket,omitempty"`
}

func (m *Handler) Reset()      { *m = Handler{} }
func (*Handler) ProtoMessage() {}
func (*Handler) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{65}
}
func (m *Handler) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Handler) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Handler.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Handler) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Handler.Merge(m, src)
}
func (m *Handler) XXX_Size() int {
	return m.Size()
}
func (m *Handler) XXX_DiscardUnknown() {
	xxx_messageInfo_Handler.DiscardUnknown(m)
}

var xxx_messageInfo_Handler proto.InternalMessageInfo

func (m *Handler) GetExec() *ExecAction {
	if m != nil {
		return m.Exec
	}
	return nil
}

func (m *Handler) GetHttpGet() *HTTPGetAction {
	if m != nil {
		return m.HttpGet
	}
	return nil
}

func (m *Handler) GetTcpSocket() *TCPSocketAction {
	if m != nil {
		return m.TcpSocket
	}
	return nil
}

// HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the
// pod's hosts file.
type HostAlias struct {
	// IP address of the host file entry.
	Ip string `protobuf:"bytes,1,opt,name=ip" json:"ip"`
	// Hostnames for the above IP address.
	Hostnames []string `protobuf:"bytes,2,rep,name=hostnames" json:"hostnames,omitempty"`
}

func (m *HostAlias) Reset()      { *m = HostAlias{} }
func (*HostAlias) ProtoMessage() {}
func (*HostAlias) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{66}
}
func (m *HostAlias) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HostAlias) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_HostAlias.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *HostAlias) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HostAlias.Merge(m, src)
}
func (m *HostAlias) XXX_Size() int {
	return m.Size()
}
func (m *HostAlias) XXX_DiscardUnknown() {
	xxx_messageInfo_HostAlias.DiscardUnknown(m)
}

var xxx_messageInfo_HostAlias proto.InternalMessageInfo

func (m *HostAlias) GetIp() string {
	if m != nil {
		return m.Ip
	}
	return ""
}

func (m *HostAlias) GetHostnames() []string {
	if m != nil {
		return m.Hostnames
	}
	return nil
}

// Represents a host path mapped into a pod.
// Host path volumes do not support ownership management or SELinux relabeling.
type HostPathVolumeSource struct {
	// Path of the directory on the host.
	// If the path is a symlink, it will follow the link to the real path.
	// More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath
	Path string `protobuf:"bytes,1,opt,name=path" json:"path"`
	// Type for HostPath Volume
	// Defaults to ""
	// More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath
	// +optional
	Type string `protobuf:"bytes,2,opt,name=type" json:"type"`
}

func (m *HostPathVolumeSource) Reset()      { *m = HostPathVolumeSource{} }
func (*HostPathVolumeSource) ProtoMessage() {}
func (*HostPathVolumeSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{67}
}
func (m *HostPathVolumeSource) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HostPathVolumeSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_HostPathVolumeSource.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *HostPathVolumeSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HostPathVolumeSource.Merge(m, src)
}
func (m *HostPathVolumeSource) XXX_Size() int {
	return m.Size()
}
func (m *HostPathVolumeSource) XXX_DiscardUnknown() {
	xxx_messageInfo_HostPathVolumeSource.DiscardUnknown(m)
}

var xxx_messageInfo_HostPathVolumeSource proto.InternalMessageInfo

func (m *HostPathVolumeSource) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

func (m *HostPathVolumeSource) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

// ISCSIPersistentVolumeSource represents an ISCSI disk.
// ISCSI volumes can only be mounted as read/write once.
// ISCSI volumes support ownership management and SELinux relabeling.
type ISCSIPersistentVolumeSource struct {
	// iSCSI Target Portal. The Portal is either an IP or ip_addr:port if the port
	// is other than default (typically TCP ports 860 and 3260).
	TargetPortal string `protobuf:"bytes,1,opt,name=targetPortal" json:"targetPortal"`
	// Target iSCSI Qualified Name.
	Iqn string `protobuf:"bytes,2,opt,name=iqn" json:"iqn"`
	// iSCSI Target Lun number.
	Lun int32 `protobuf:"varint,3,opt,name=lun" json:"lun"`
	// iSCSI Interface Name that uses an iSCSI transport.
	// Defaults to 'default' (tcp).
	// +optional
	IscsiInterface string `protobuf:"bytes,4,opt,name=iscsiInterface" json:"iscsiInterface"`
	// Filesystem type of the volume that you want to mount.
	// Tip: Ensure that the filesystem type is supported by the host operating system.
	// Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
	// More info: https://kubernetes.io/docs/concepts/storage/volumes#iscsi
	// TODO: how do we prevent errors in the filesystem from compromising the machine
	// +optional
	FsType string `protobuf:"bytes,5,opt,name=fsType" json:"fsType"`
	// ReadOnly here will force the ReadOnly setting in VolumeMounts.
	// Defaults to false.
	// +optional
	ReadOnly bool `protobuf:"varint,6,opt,name=readOnly" json:"readOnly"`
	// iSCSI Target Portal List. The Portal is either an IP or ip_addr:port if the port
	// is other than default (typically TCP ports 860 and 3260).
	// +optional
	Portals []string `protobuf:"bytes,7,rep,name=portals" json:"portals,omitempty"`
	// whether support iSCSI Discovery CHAP authentication
	// +optional
	ChapAuthDiscovery bool `protobuf:"varint,8,opt,name=chapAuthDiscovery" json:"chapAuthDiscovery"`
	// whether support iSCSI Session CHAP authentication
	// +optional
	ChapAuthSession bool `protobuf:"varint,11,opt,name=chapAuthSession" json:"chapAuthSession"`
	// CHAP Secret for iSCSI target and initiator authentication
	// +optional
	SecretRef *SecretReference `protobuf:"bytes,10,opt,name=secretRef" json:"secretRef,omitempty"`
	// Custom iSCSI Initiator Name.
	// If initiatorName is specified with iscsiInterface simultaneously, new iSCSI interface
	// <target portal>:<volume name> will be created for the connection.
	// +optional
	InitiatorName string `protobuf:"bytes,12,opt,name=initiatorName" json:"initiatorName"`
}

func (m *ISCSIPersistentVolumeSource) Reset()      { *m = ISCSIPersistentVolumeSource{} }
func (*ISCSIPersistentVolumeSource) ProtoMessage() {}
func (*ISCSIPersistentVolumeSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{68}
}
func (m *ISCSIPersistentVolumeSource) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ISCSIPersistentVolumeSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ISCSIPersistentVolumeSource.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ISCSIPersistentVolumeSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ISCSIPersistentVolumeSource.Merge(m, src)
}
func (m *ISCSIPersistentVolumeSource) XXX_Size() int {
	return m.Size()
}
func (m *ISCSIPersistentVolumeSource) XXX_DiscardUnknown() {
	xxx_messageInfo_ISCSIPersistentVolumeSource.DiscardUnknown(m)
}

var xxx_messageInfo_ISCSIPersistentVolumeSource proto.InternalMessageInfo

func (m *ISCSIPersistentVolumeSource) GetTargetPortal() string {
	if m != nil {
		return m.TargetPortal
	}
	return ""
}

func (m *ISCSIPersistentVolumeSource) GetIqn() string {
	if m != nil {
		return m.Iqn
	}
	return ""
}

func (m *ISCSIPersistentVolumeSource) GetLun() int32 {
	if m != nil {
		return m.Lun
	}
	return 0
}

func (m *ISCSIPersistentVolumeSource) GetIscsiInterface() string {
	if m != nil {
		return m.IscsiInterface
	}
	return ""
}

func (m *ISCSIPersistentVolumeSource) GetFsType() string {
	if m != nil {
		return m.FsType
	}
	return ""
}

func (m *ISCSIPersistentVolumeSource) GetReadOnly() bool {
	if m != nil {
		return m.ReadOnly
	}
	return false
}

func (m *ISCSIPersistentVolumeSource) GetPortals() []string {
	if m != nil {
		return m.Portals
	}
	return nil
}

func (m *ISCSIPersistentVolumeSource) GetChapAuthDiscovery() bool {
	if m != nil {
		return m.ChapAuthDiscovery
	}
	return false
}

func (m *ISCSIPersistentVolumeSource) GetChapAuthSession() bool {
	if m != nil {
		return m.ChapAuthSession
	}
	return false
}

func (m *ISCSIPersistentVolumeSource) GetSecretRef() *SecretReference {
	if m != nil {
		return m.SecretRef
	}
	return nil
}

func (m *ISCSIPersistentVolumeSource) GetInitiatorName() string {
	if m != nil {
		return m.InitiatorName
	}
	return ""
}

// Represents an ISCSI disk.
// ISCSI volumes can only be mounted as read/write once.
// ISCSI volumes support ownership management and SELinux relabeling.
type ISCSIVolumeSource struct {
	// iSCSI Target Portal. The Portal is either an IP or ip_addr:port if the port
	// is other than default (typically TCP ports 860 and 3260).
	TargetPortal string `protobuf:"bytes,1,opt,name=targetPortal" json:"targetPortal"`
	// Target iSCSI Qualified Name.
	Iqn string `protobuf:"bytes,2,opt,name=iqn" json:"iqn"`
	// iSCSI Target Lun number.
	Lun int32 `protobuf:"varint,3,opt,name=lun" json:"lun"`
	// iSCSI Interface Name that uses an iSCSI transport.
	// Defaults to 'default' (tcp).
	// +optional
	IscsiInterface string `protobuf:"bytes,4,opt,name=iscsiInterface" json:"iscsiInterface"`
	// Filesystem type of the volume that you want to mount.
	// Tip: Ensure that the filesystem type is supported by the host operating system.
	// Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
	// More info: https://kubernetes.io/docs/concepts/storage/volumes#iscsi
	// TODO: how do we prevent errors in the filesystem from compromising the machine
	// +optional
	FsType string `protobuf:"bytes,5,opt,name=fsType" json:"fsType"`
	// ReadOnly here will force the ReadOnly setting in VolumeMounts.
	// Defaults to false.
	// +optional
	ReadOnly bool `protobuf:"varint,6,opt,name=readOnly" json:"readOnly"`
	// iSCSI Target Portal List. The portal is either an IP or ip_addr:port if the port
	// is other than default (typically TCP ports 860 and 3260).
	// +optional
	Portals []string `protobuf:"bytes,7,rep,name=portals" json:"portals,omitempty"`
	// whether support iSCSI Discovery CHAP authentication
	// +optional
	ChapAuthDiscovery bool `protobuf:"varint,8,opt,name=chapAuthDiscovery" json:"chapAuthDiscovery"`
	// whether support iSCSI Session CHAP authentication
	// +optional
	ChapAuthSession bool `protobuf:"varint,11,opt,name=chapAuthSession" json:"chapAuthSession"`
	// CHAP Secret for iSCSI target and initiator authentication
	// +optional
	SecretRef *LocalObjectReference `protobuf:"bytes,10,opt,name=secretRef" json:"secretRef,omitempty"`
	// Custom iSCSI Initiator Name.
	// If initiatorName is specified with iscsiInterface simultaneously, new iSCSI interface
	// <target portal>:<volume name> will be created for the connection.
	// +optional
	InitiatorName string `protobuf:"bytes,12,opt,name=initiatorName" json:"initiatorName"`
}

func (m *ISCSIVolumeSource) Reset()      { *m = ISCSIVolumeSource{} }
func (*ISCSIVolumeSource) ProtoMessage() {}
func (*ISCSIVolumeSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{69}
}
func (m *ISCSIVolumeSource) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ISCSIVolumeSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ISCSIVolumeSource.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ISCSIVolumeSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ISCSIVolumeSource.Merge(m, src)
}
func (m *ISCSIVolumeSource) XXX_Size() int {
	return m.Size()
}
func (m *ISCSIVolumeSource) XXX_DiscardUnknown() {
	xxx_messageInfo_ISCSIVolumeSource.DiscardUnknown(m)
}

var xxx_messageInfo_ISCSIVolumeSource proto.InternalMessageInfo

func (m *ISCSIVolumeSource) GetTargetPortal() string {
	if m != nil {
		return m.TargetPortal
	}
	return ""
}

func (m *ISCSIVolumeSource) GetIqn() string {
	if m != nil {
		return m.Iqn
	}
	return ""
}

func (m *ISCSIVolumeSource) GetLun() int32 {
	if m != nil {
		return m.Lun
	}
	return 0
}

func (m *ISCSIVolumeSource) GetIscsiInterface() string {
	if m != nil {
		return m.IscsiInterface
	}
	return ""
}

func (m *ISCSIVolumeSource) GetFsType() string {
	if m != nil {
		return m.FsType
	}
	return ""
}

func (m *ISCSIVolumeSource) GetReadOnly() bool {
	if m != nil {
		return m.ReadOnly
	}
	return false
}

func (m *ISCSIVolumeSource) GetPortals() []string {
	if m != nil {
		return m.Portals
	}
	return nil
}

func (m *ISCSIVolumeSource) GetChapAuthDiscovery() bool {
	if m != nil {
		return m.ChapAuthDiscovery
	}
	return false
}

func (m *ISCSIVolumeSource) GetChapAuthSession() bool {
	if m != nil {
		return m.ChapAuthSession
	}
	return false
}

func (m *ISCSIVolumeSource) GetSecretRef() *LocalObjectReference {
	if m != nil {
		return m.SecretRef
	}
	return nil
}

func (m *ISCSIVolumeSource) GetInitiatorName() string {
	if m != nil {
		return m.InitiatorName
	}
	return ""
}

// Maps a string key to a path within a volume.
type KeyToPath struct {
	// The key to project.
	Key string `protobuf:"bytes,1,opt,name=key" json:"key"`
	// The relative path of the file to map the key to.
	// May not be an absolute path.
	// May not contain the path element '..'.
	// May not start with the string '..'.
	Path string `protobuf:"bytes,2,opt,name=path" json:"path"`
	// Optional: mode bits to use on this file, must be a value between 0
	// and 0777. If not specified, the volume defaultMode will be used.
	// This might be in conflict with other options that affect the file
	// mode, like fsGroup, and the result can be other mode bits set.
	// +optional
	Mode int32 `protobuf:"varint,3,opt,name=mode" json:"mode"`
}

func (m *KeyToPath) Reset()      { *m = KeyToPath{} }
func (*KeyToPath) ProtoMessage() {}
func (*KeyToPath) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{70}
}
func (m *KeyToPath) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *KeyToPath) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_KeyToPath.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *KeyToPath) XXX_Merge(src proto.Message) {
	xxx_messageInfo_KeyToPath.Merge(m, src)
}
func (m *KeyToPath) XXX_Size() int {
	return m.Size()
}
func (m *KeyToPath) XXX_DiscardUnknown() {
	xxx_messageInfo_KeyToPath.DiscardUnknown(m)
}

var xxx_messageInfo_KeyToPath proto.InternalMessageInfo

func (m *KeyToPath) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

func (m *KeyToPath) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

func (m *KeyToPath) GetMode() int32 {
	if m != nil {
		return m.Mode
	}
	return 0
}

// Lifecycle describes actions that the management system should take in response to container lifecycle
// events. For the PostStart and PreStop lifecycle handlers, management of the container blocks
// until the action is complete, unless the container process fails, in which case the handler is aborted.
type Lifecycle struct {
	// PostStart is called immediately after a container is created. If the handler fails,
	// the container is terminated and restarted according to its restart policy.
	// Other management of the container blocks until the hook completes.
	// More info: https://kubernetes.io/docs/concepts/containers/container-lifecycle-hooks/#container-hooks
	// +optional
	PostStart *Handler `protobuf:"bytes,1,opt,name=postStart" json:"postStart,omitempty"`
	// PreStop is called immediately before a container is terminated due to an
	// API request or management event such as liveness probe failure,
	// preemption, resource contention, etc. The handler is not called if the
	// container crashes or exits. The reason for termination is passed to the
	// handler. The Pod's termination grace period countdown begins before the
	// PreStop hooked is executed. Regardless of the outcome of the handler, the
	// container will eventually terminate within the Pod's termination grace
	// period. Other management of the container blocks until the hook completes
	// or until the termination grace period is reached.
	// More info: https://kubernetes.io/docs/concepts/containers/container-lifecycle-hooks/#container-hooks
	// +optional
	PreStop *Handler `protobuf:"bytes,2,opt,name=preStop" json:"preStop,omitempty"`
}

func (m *Lifecycle) Reset()      { *m = Lifecycle{} }
func (*Lifecycle) ProtoMessage() {}
func (*Lifecycle) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{71}
}
func (m *Lifecycle) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Lifecycle) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Lifecycle.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Lifecycle) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Lifecycle.Merge(m, src)
}
func (m *Lifecycle) XXX_Size() int {
	return m.Size()
}
func (m *Lifecycle) XXX_DiscardUnknown() {
	xxx_messageInfo_Lifecycle.DiscardUnknown(m)
}

var xxx_messageInfo_Lifecycle proto.InternalMessageInfo

func (m *Lifecycle) GetPostStart() *Handler {
	if m != nil {
		return m.PostStart
	}
	return nil
}

func (m *Lifecycle) GetPreStop() *Handler {
	if m != nil {
		return m.PreStop
	}
	return nil
}

// LimitRange sets resource usage limits for each kind of resource in a Namespace.
type LimitRange struct {
	// Standard object's metadata.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
	// +optional
	Metadata *v1.ObjectMeta `protobuf:"bytes,1,opt,name=metadata" json:"metadata,omitempty"`
	// Spec defines the limits enforced.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status
	// +optional
	Spec *LimitRangeSpec `protobuf:"bytes,2,opt,name=spec" json:"spec,omitempty"`
}

func (m *LimitRange) Reset()      { *m = LimitRange{} }
func (*LimitRange) ProtoMessage() {}
func (*LimitRange) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{72}
}
func (m *LimitRange) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LimitRange) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_LimitRange.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *LimitRange) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LimitRange.Merge(m, src)
}
func (m *LimitRange) XXX_Size() int {
	return m.Size()
}
func (m *LimitRange) XXX_DiscardUnknown() {
	xxx_messageInfo_LimitRange.DiscardUnknown(m)
}

var xxx_messageInfo_LimitRange proto.InternalMessageInfo

func (m *LimitRange) GetMetadata() *v1.ObjectMeta {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *LimitRange) GetSpec() *LimitRangeSpec {
	if m != nil {
		return m.Spec
	}
	return nil
}

// LimitRangeItem defines a min/max usage limit for any resource that matches on kind.
type LimitRangeItem struct {
	// Type of resource that this limit applies to.
	// +optional
	Type string `protobuf:"bytes,1,opt,name=type" json:"type"`
	// Max usage constraints on this kind by resource name.
	// +optional
	Max map[string]*resource.Quantity `protobuf:"bytes,2,rep,name=max" json:"max,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Min usage constraints on this kind by resource name.
	// +optional
	Min map[string]*resource.Quantity `protobuf:"bytes,3,rep,name=min" json:"min,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Default resource requirement limit value by resource name if resource limit is omitted.
	// +optional
	Default map[string]*resource.Quantity `protobuf:"bytes,4,rep,name=default" json:"default,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// DefaultRequest is the default resource requirement request value by resource name if resource request is omitted.
	// +optional
	DefaultRequest map[string]*resource.Quantity `protobuf:"bytes,5,rep,name=defaultRequest" json:"defaultRequest,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// MaxLimitRequestRatio if specified, the named resource must have a request and limit that are both non-zero where limit divided by request is less than or equal to the enumerated value; this represents the max burst for the named resource.
	// +optional
	MaxLimitRequestRatio map[string]*resource.Quantity `protobuf:"bytes,6,rep,name=maxLimitRequestRatio" json:"maxLimitRequestRatio,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *LimitRangeItem) Reset()      { *m = LimitRangeItem{} }
func (*LimitRangeItem) ProtoMessage() {}
func (*LimitRangeItem) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{73}
}
func (m *LimitRangeItem) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LimitRangeItem) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_LimitRangeItem.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *LimitRangeItem) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LimitRangeItem.Merge(m, src)
}
func (m *LimitRangeItem) XXX_Size() int {
	return m.Size()
}
func (m *LimitRangeItem) XXX_DiscardUnknown() {
	xxx_messageInfo_LimitRangeItem.DiscardUnknown(m)
}

var xxx_messageInfo_LimitRangeItem proto.InternalMessageInfo

func (m *LimitRangeItem) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *LimitRangeItem) GetMax() map[string]*resource.Quantity {
	if m != nil {
		return m.Max
	}
	return nil
}

func (m *LimitRangeItem) GetMin() map[string]*resource.Quantity {
	if m != nil {
		return m.Min
	}
	return nil
}

func (m *LimitRangeItem) GetDefault() map[string]*resource.Quantity {
	if m != nil {
		return m.Default
	}
	return nil
}

func (m *LimitRangeItem) GetDefaultRequest() map[string]*resource.Quantity {
	if m != nil {
		return m.DefaultRequest
	}
	return nil
}

func (m *LimitRangeItem) GetMaxLimitRequestRatio() map[string]*resource.Quantity {
	if m != nil {
		return m.MaxLimitRequestRatio
	}
	return nil
}

// LimitRangeList is a list of LimitRange items.
type LimitRangeList struct {
	// Standard list metadata.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds
	// +optional
	Metadata *v1.ListMeta `protobuf:"bytes,1,opt,name=metadata" json:"metadata,omitempty"`
	// Items is a list of LimitRange objects.
	// More info: https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
	Items []*LimitRange `protobuf:"bytes,2,rep,name=items" json:"items,omitempty"`
}

func (m *LimitRangeList) Reset()      { *m = LimitRangeList{} }
func (*LimitRangeList) ProtoMessage() {}
func (*LimitRangeList) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{74}
}
func (m *LimitRangeList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LimitRangeList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_LimitRangeList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *LimitRangeList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LimitRangeList.Merge(m, src)
}
func (m *LimitRangeList) XXX_Size() int {
	return m.Size()
}
func (m *LimitRangeList) XXX_DiscardUnknown() {
	xxx_messageInfo_LimitRangeList.DiscardUnknown(m)
}

var xxx_messageInfo_LimitRangeList proto.InternalMessageInfo

func (m *LimitRangeList) GetMetadata() *v1.ListMeta {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *LimitRangeList) GetItems() []*LimitRange {
	if m != nil {
		return m.Items
	}
	return nil
}

// LimitRangeSpec defines a min/max usage limit for resources that match on kind.
type LimitRangeSpec struct {
	// Limits is the list of LimitRangeItem objects that are enforced.
	Limits []*LimitRangeItem `protobuf:"bytes,1,rep,name=limits" json:"limits,omitempty"`
}

func (m *LimitRangeSpec) Reset()      { *m = LimitRangeSpec{} }
func (*LimitRangeSpec) ProtoMessage() {}
func (*LimitRangeSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{75}
}
func (m *LimitRangeSpec) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LimitRangeSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_LimitRangeSpec.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *LimitRangeSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LimitRangeSpec.Merge(m, src)
}
func (m *LimitRangeSpec) XXX_Size() int {
	return m.Size()
}
func (m *LimitRangeSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_LimitRangeSpec.DiscardUnknown(m)
}

var xxx_messageInfo_LimitRangeSpec proto.InternalMessageInfo

func (m *LimitRangeSpec) GetLimits() []*LimitRangeItem {
	if m != nil {
		return m.Limits
	}
	return nil
}

// List holds a list of objects, which may not be known by the server.
type List struct {
	// Standard list metadata.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds
	// +optional
	Metadata *v1.ListMeta `protobuf:"bytes,1,opt,name=metadata" json:"metadata,omitempty"`
	// List of objects
	Items []*runtime.RawExtension `protobuf:"bytes,2,rep,name=items" json:"items,omitempty"`
}

func (m *List) Reset()      { *m = List{} }
func (*List) ProtoMessage() {}
func (*List) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{76}
}
func (m *List) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *List) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_List.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *List) XXX_Merge(src proto.Message) {
	xxx_messageInfo_List.Merge(m, src)
}
func (m *List) XXX_Size() int {
	return m.Size()
}
func (m *List) XXX_DiscardUnknown() {
	xxx_messageInfo_List.DiscardUnknown(m)
}

var xxx_messageInfo_List proto.InternalMessageInfo

func (m *List) GetMetadata() *v1.ListMeta {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *List) GetItems() []*runtime.RawExtension {
	if m != nil {
		return m.Items
	}
	return nil
}

// LoadBalancerIngress represents the status of a load-balancer ingress point:
// traffic intended for the service should be sent to an ingress point.
type LoadBalancerIngress struct {
	// IP is set for load-balancer ingress points that are IP based
	// (typically GCE or OpenStack load-balancers)
	// +optional
	Ip string `protobuf:"bytes,1,opt,name=ip" json:"ip"`
	// Hostname is set for load-balancer ingress points that are DNS based
	// (typically AWS load-balancers)
	// +optional
	Hostname string `protobuf:"bytes,2,opt,name=hostname" json:"hostname"`
}

func (m *LoadBalancerIngress) Reset()      { *m = LoadBalancerIngress{} }
func (*LoadBalancerIngress) ProtoMessage() {}
func (*LoadBalancerIngress) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{77}
}
func (m *LoadBalancerIngress) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LoadBalancerIngress) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_LoadBalancerIngress.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *LoadBalancerIngress) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LoadBalancerIngress.Merge(m, src)
}
func (m *LoadBalancerIngress) XXX_Size() int {
	return m.Size()
}
func (m *LoadBalancerIngress) XXX_DiscardUnknown() {
	xxx_messageInfo_LoadBalancerIngress.DiscardUnknown(m)
}

var xxx_messageInfo_LoadBalancerIngress proto.InternalMessageInfo

func (m *LoadBalancerIngress) GetIp() string {
	if m != nil {
		return m.Ip
	}
	return ""
}

func (m *LoadBalancerIngress) GetHostname() string {
	if m != nil {
		return m.Hostname
	}
	return ""
}

// LoadBalancerStatus represents the status of a load-balancer.
type LoadBalancerStatus struct {
	// Ingress is a list containing ingress points for the load-balancer.
	// Traffic intended for the service should be sent to these ingress points.
	// +optional
	Ingress []*LoadBalancerIngress `protobuf:"bytes,1,rep,name=ingress" json:"ingress,omitempty"`
}

func (m *LoadBalancerStatus) Reset()      { *m = LoadBalancerStatus{} }
func (*LoadBalancerStatus) ProtoMessage() {}
func (*LoadBalancerStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{78}
}
func (m *LoadBalancerStatus) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LoadBalancerStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_LoadBalancerStatus.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *LoadBalancerStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LoadBalancerStatus.Merge(m, src)
}
func (m *LoadBalancerStatus) XXX_Size() int {
	return m.Size()
}
func (m *LoadBalancerStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_LoadBalancerStatus.DiscardUnknown(m)
}

var xxx_messageInfo_LoadBalancerStatus proto.InternalMessageInfo

func (m *LoadBalancerStatus) GetIngress() []*LoadBalancerIngress {
	if m != nil {
		return m.Ingress
	}
	return nil
}

// LocalObjectReference contains enough information to let you locate the
// referenced object inside the same namespace.
type LocalObjectReference struct {
	// Name of the referent.
	// More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
	// TODO: Add other useful fields. apiVersion, kind, uid?
	// +optional
	Name string `protobuf:"bytes,1,opt,name=name" json:"name"`
}

func (m *LocalObjectReference) Reset()      { *m = LocalObjectReference{} }
func (*LocalObjectReference) ProtoMessage() {}
func (*LocalObjectReference) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{79}
}
func (m *LocalObjectReference) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LocalObjectReference) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_LocalObjectReference.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *LocalObjectReference) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LocalObjectReference.Merge(m, src)
}
func (m *LocalObjectReference) XXX_Size() int {
	return m.Size()
}
func (m *LocalObjectReference) XXX_DiscardUnknown() {
	xxx_messageInfo_LocalObjectReference.DiscardUnknown(m)
}

var xxx_messageInfo_LocalObjectReference proto.InternalMessageInfo

func (m *LocalObjectReference) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Local represents directly-attached storage with node affinity (Beta feature)
type LocalVolumeSource struct {
	// The full path to the volume on the node.
	// It can be either a directory or block device (disk, partition, ...).
	Path string `protobuf:"bytes,1,opt,name=path" json:"path"`
	// Filesystem type to mount.
	// It applies only when the Path is a block device.
	// Must be a filesystem type supported by the host operating system.
	// Ex. "ext4", "xfs", "ntfs". The default value is to auto-select a fileystem if unspecified.
	// +optional
	FsType string `protobuf:"bytes,2,opt,name=fsType" json:"fsType"`
}

func (m *LocalVolumeSource) Reset()      { *m = LocalVolumeSource{} }
func (*LocalVolumeSource) ProtoMessage() {}
func (*LocalVolumeSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{80}
}
func (m *LocalVolumeSource) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LocalVolumeSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_LocalVolumeSource.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *LocalVolumeSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LocalVolumeSource.Merge(m, src)
}
func (m *LocalVolumeSource) XXX_Size() int {
	return m.Size()
}
func (m *LocalVolumeSource) XXX_DiscardUnknown() {
	xxx_messageInfo_LocalVolumeSource.DiscardUnknown(m)
}

var xxx_messageInfo_LocalVolumeSource proto.InternalMessageInfo

func (m *LocalVolumeSource) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

func (m *LocalVolumeSource) GetFsType() string {
	if m != nil {
		return m.FsType
	}
	return ""
}

// Represents an NFS mount that lasts the lifetime of a pod.
// NFS volumes do not support ownership management or SELinux relabeling.
type NFSVolumeSource struct {
	// Server is the hostname or IP address of the NFS server.
	// More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs
	Server string `protobuf:"bytes,1,opt,name=server" json:"server"`
	// Path that is exported by the NFS server.
	// More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs
	Path string `protobuf:"bytes,2,opt,name=path" json:"path"`
	// ReadOnly here will force
	// the NFS export to be mounted with read-only permissions.
	// Defaults to false.
	// More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs
	// +optional
	ReadOnly bool `protobuf:"varint,3,opt,name=readOnly" json:"readOnly"`
}

func (m *NFSVolumeSource) Reset()      { *m = NFSVolumeSource{} }
func (*NFSVolumeSource) ProtoMessage() {}
func (*NFSVolumeSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{81}
}
func (m *NFSVolumeSource) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NFSVolumeSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NFSVolumeSource.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NFSVolumeSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NFSVolumeSource.Merge(m, src)
}
func (m *NFSVolumeSource) XXX_Size() int {
	return m.Size()
}
func (m *NFSVolumeSource) XXX_DiscardUnknown() {
	xxx_messageInfo_NFSVolumeSource.DiscardUnknown(m)
}

var xxx_messageInfo_NFSVolumeSource proto.InternalMessageInfo

func (m *NFSVolumeSource) GetServer() string {
	if m != nil {
		return m.Server
	}
	return ""
}

func (m *NFSVolumeSource) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

func (m *NFSVolumeSource) GetReadOnly() bool {
	if m != nil {
		return m.ReadOnly
	}
	return false
}

// Namespace provides a scope for Names.
// Use of multiple namespaces is optional.
type Namespace struct {
	// Standard object's metadata.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
	// +optional
	Metadata *v1.ObjectMeta `protobuf:"bytes,1,opt,name=metadata" json:"metadata,omitempty"`
	// Spec defines the behavior of the Namespace.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status
	// +optional
	Spec *NamespaceSpec `protobuf:"bytes,2,opt,name=spec" json:"spec,omitempty"`
	// Status describes the current status of a Namespace.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status
	// +optional
	Status *NamespaceStatus `protobuf:"bytes,3,opt,name=status" json:"status,omitempty"`
}

func (m *Namespace) Reset()      { *m = Namespace{} }
func (*Namespace) ProtoMessage() {}
func (*Namespace) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{82}
}
func (m *Namespace) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Namespace) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Namespace.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Namespace) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Namespace.Merge(m, src)
}
func (m *Namespace) XXX_Size() int {
	return m.Size()
}
func (m *Namespace) XXX_DiscardUnknown() {
	xxx_messageInfo_Namespace.DiscardUnknown(m)
}

var xxx_messageInfo_Namespace proto.InternalMessageInfo

func (m *Namespace) GetMetadata() *v1.ObjectMeta {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *Namespace) GetSpec() *NamespaceSpec {
	if m != nil {
		return m.Spec
	}
	return nil
}

func (m *Namespace) GetStatus() *NamespaceStatus {
	if m != nil {
		return m.Status
	}
	return nil
}

// NamespaceList is a list of Namespaces.
type NamespaceList struct {
	// Standard list metadata.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds
	// +optional
	Metadata *v1.ListMeta `protobuf:"bytes,1,opt,name=metadata" json:"metadata,omitempty"`
	// Items is the list of Namespace objects in the list.
	// More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/namespaces/
	Items []*Namespace `protobuf:"bytes,2,rep,name=items" json:"items,omitempty"`
}

func (m *NamespaceList) Reset()      { *m = NamespaceList{} }
func (*NamespaceList) ProtoMessage() {}
func (*NamespaceList) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{83}
}
func (m *NamespaceList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NamespaceList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NamespaceList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NamespaceList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NamespaceList.Merge(m, src)
}
func (m *NamespaceList) XXX_Size() int {
	return m.Size()
}
func (m *NamespaceList) XXX_DiscardUnknown() {
	xxx_messageInfo_NamespaceList.DiscardUnknown(m)
}

var xxx_messageInfo_NamespaceList proto.InternalMessageInfo

func (m *NamespaceList) GetMetadata() *v1.ListMeta {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *NamespaceList) GetItems() []*Namespace {
	if m != nil {
		return m.Items
	}
	return nil
}

// NamespaceSpec describes the attributes on a Namespace.
type NamespaceSpec struct {
	// Finalizers is an opaque list of values that must be empty to permanently remove object from storage.
	// More info: https://kubernetes.io/docs/tasks/administer-cluster/namespaces/
	// +optional
	Finalizers []string `protobuf:"bytes,1,rep,name=finalizers" json:"finalizers,omitempty"`
}

func (m *NamespaceSpec) Reset()      { *m = NamespaceSpec{} }
func (*NamespaceSpec) ProtoMessage() {}
func (*NamespaceSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{84}
}
func (m *NamespaceSpec) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NamespaceSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NamespaceSpec.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NamespaceSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NamespaceSpec.Merge(m, src)
}
func (m *NamespaceSpec) XXX_Size() int {
	return m.Size()
}
func (m *NamespaceSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_NamespaceSpec.DiscardUnknown(m)
}

var xxx_messageInfo_NamespaceSpec proto.InternalMessageInfo

func (m *NamespaceSpec) GetFinalizers() []string {
	if m != nil {
		return m.Finalizers
	}
	return nil
}

// NamespaceStatus is information about the current status of a Namespace.
type NamespaceStatus struct {
	// Phase is the current lifecycle phase of the namespace.
	// More info: https://kubernetes.io/docs/tasks/administer-cluster/namespaces/
	// +optional
	Phase string `protobuf:"bytes,1,opt,name=phase" json:"phase"`
}

func (m *NamespaceStatus) Reset()      { *m = NamespaceStatus{} }
func (*NamespaceStatus) ProtoMessage() {}
func (*NamespaceStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{85}
}
func (m *NamespaceStatus) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NamespaceStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NamespaceStatus.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NamespaceStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NamespaceStatus.Merge(m, src)
}
func (m *NamespaceStatus) XXX_Size() int {
	return m.Size()
}
func (m *NamespaceStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_NamespaceStatus.DiscardUnknown(m)
}

var xxx_messageInfo_NamespaceStatus proto.InternalMessageInfo

func (m *NamespaceStatus) GetPhase() string {
	if m != nil {
		return m.Phase
	}
	return ""
}

// Node is a worker node in Kubernetes.
// Each node will have a unique identifier in the cache (i.e. in etcd).
type Node struct {
	// Standard object's metadata.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
	// +optional
	Metadata *v1.ObjectMeta `protobuf:"bytes,1,opt,name=metadata" json:"metadata,omitempty"`
	// Spec defines the behavior of a node.
	// https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status
	// +optional
	Spec *NodeSpec `protobuf:"bytes,2,opt,name=spec" json:"spec,omitempty"`
	// Most recently observed status of the node.
	// Populated by the system.
	// Read-only.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status
	// +optional
	Status *NodeStatus `protobuf:"bytes,3,opt,name=status" json:"status,omitempty"`
}

func (m *Node) Reset()      { *m = Node{} }
func (*Node) ProtoMessage() {}
func (*Node) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{86}
}
func (m *Node) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Node) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Node.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Node) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Node.Merge(m, src)
}
func (m *Node) XXX_Size() int {
	return m.Size()
}
func (m *Node) XXX_DiscardUnknown() {
	xxx_messageInfo_Node.DiscardUnknown(m)
}

var xxx_messageInfo_Node proto.InternalMessageInfo

func (m *Node) GetMetadata() *v1.ObjectMeta {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *Node) GetSpec() *NodeSpec {
	if m != nil {
		return m.Spec
	}
	return nil
}

func (m *Node) GetStatus() *NodeStatus {
	if m != nil {
		return m.Status
	}
	return nil
}

// NodeAddress contains information for the node's address.
type NodeAddress struct {
	// Node address type, one of Hostname, ExternalIP or InternalIP.
	Type string `protobuf:"bytes,1,opt,name=type" json:"type"`
	// The node address.
	Address string `protobuf:"bytes,2,opt,name=address" json:"address"`
}

func (m *NodeAddress) Reset()      { *m = NodeAddress{} }
func (*NodeAddress) ProtoMessage() {}
func (*NodeAddress) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{87}
}
func (m *NodeAddress) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NodeAddress) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NodeAddress.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NodeAddress) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NodeAddress.Merge(m, src)
}
func (m *NodeAddress) XXX_Size() int {
	return m.Size()
}
func (m *NodeAddress) XXX_DiscardUnknown() {
	xxx_messageInfo_NodeAddress.DiscardUnknown(m)
}

var xxx_messageInfo_NodeAddress proto.InternalMessageInfo

func (m *NodeAddress) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *NodeAddress) GetAddress() string {
	if m != nil {
		return m.Address
	}
	return ""
}

// Node affinity is a group of node affinity scheduling rules.
type NodeAffinity struct {
	// If the affinity requirements specified by this field are not met at
	// scheduling time, the pod will not be scheduled onto the node.
	// If the affinity requirements specified by this field cease to be met
	// at some point during pod execution (e.g. due to an update), the system
	// may or may not try to eventually evict the pod from its node.
	// +optional
	RequiredDuringSchedulingIgnoredDuringExecution *NodeSelector `protobuf:"bytes,1,opt,name=requiredDuringSchedulingIgnoredDuringExecution" json:"requiredDuringSchedulingIgnoredDuringExecution,omitempty"`
	// The scheduler will prefer to schedule pods to nodes that satisfy
	// the affinity expressions specified by this field, but it may choose
	// a node that violates one or more of the expressions. The node that is
	// most preferred is the one with the greatest sum of weights, i.e.
	// for each node that meets all of the scheduling requirements (resource
	// request, requiredDuringScheduling affinity expressions, etc.),
	// compute a sum by iterating through the elements of this field and adding
	// "weight" to the sum if the node matches the corresponding matchExpressions; the
	// node(s) with the highest sum are the most preferred.
	// +optional
	PreferredDuringSchedulingIgnoredDuringExecution []*PreferredSchedulingTerm `protobuf:"bytes,2,rep,name=preferredDuringSchedulingIgnoredDuringExecution" json:"preferredDuringSchedulingIgnoredDuringExecution,omitempty"`
}

func (m *NodeAffinity) Reset()      { *m = NodeAffinity{} }
func (*NodeAffinity) ProtoMessage() {}
func (*NodeAffinity) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{88}
}
func (m *NodeAffinity) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NodeAffinity) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NodeAffinity.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NodeAffinity) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NodeAffinity.Merge(m, src)
}
func (m *NodeAffinity) XXX_Size() int {
	return m.Size()
}
func (m *NodeAffinity) XXX_DiscardUnknown() {
	xxx_messageInfo_NodeAffinity.DiscardUnknown(m)
}

var xxx_messageInfo_NodeAffinity proto.InternalMessageInfo

func (m *NodeAffinity) GetRequiredDuringSchedulingIgnoredDuringExecution() *NodeSelector {
	if m != nil {
		return m.RequiredDuringSchedulingIgnoredDuringExecution
	}
	return nil
}

func (m *NodeAffinity) GetPreferredDuringSchedulingIgnoredDuringExecution() []*PreferredSchedulingTerm {
	if m != nil {
		return m.PreferredDuringSchedulingIgnoredDuringExecution
	}
	return nil
}

// NodeCondition contains condition information for a node.
type NodeCondition struct {
	// Type of node condition.
	Type string `protobuf:"bytes,1,opt,name=type" json:"type"`
	// Status of the condition, one of True, False, Unknown.
	Status string `protobuf:"bytes,2,opt,name=status" json:"status"`
	// Last time we got an update on a given condition.
	// +optional
	LastHeartbeatTime *v1.Time `protobuf:"bytes,3,opt,name=lastHeartbeatTime" json:"lastHeartbeatTime,omitempty"`
	// Last time the condition transit from one status to another.
	// +optional
	LastTransitionTime *v1.Time `protobuf:"bytes,4,opt,name=lastTransitionTime" json:"lastTransitionTime,omitempty"`
	// (brief) reason for the condition's last transition.
	// +optional
	Reason string `protobuf:"bytes,5,opt,name=reason" json:"reason"`
	// Human readable message indicating details about last transition.
	// +optional
	Message string `protobuf:"bytes,6,opt,name=message" json:"message"`
}

func (m *NodeCondition) Reset()      { *m = NodeCondition{} }
func (*NodeCondition) ProtoMessage() {}
func (*NodeCondition) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{89}
}
func (m *NodeCondition) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NodeCondition) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NodeCondition.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NodeCondition) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NodeCondition.Merge(m, src)
}
func (m *NodeCondition) XXX_Size() int {
	return m.Size()
}
func (m *NodeCondition) XXX_DiscardUnknown() {
	xxx_messageInfo_NodeCondition.DiscardUnknown(m)
}

var xxx_messageInfo_NodeCondition proto.InternalMessageInfo

func (m *NodeCondition) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *NodeCondition) GetStatus() string {
	if m != nil {
		return m.Status
	}
	return ""
}

func (m *NodeCondition) GetLastHeartbeatTime() *v1.Time {
	if m != nil {
		return m.LastHeartbeatTime
	}
	return nil
}

func (m *NodeCondition) GetLastTransitionTime() *v1.Time {
	if m != nil {
		return m.LastTransitionTime
	}
	return nil
}

func (m *NodeCondition) GetReason() string {
	if m != nil {
		return m.Reason
	}
	return ""
}

func (m *NodeCondition) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

// NodeConfigSource specifies a source of node configuration. Exactly one subfield (excluding metadata) must be non-nil.
type NodeConfigSource struct {
	// ConfigMap is a reference to a Node's ConfigMap
	ConfigMap *ConfigMapNodeConfigSource `protobuf:"bytes,2,opt,name=configMap" json:"configMap,omitempty"`
}

func (m *NodeConfigSource) Reset()      { *m = NodeConfigSource{} }
func (*NodeConfigSource) ProtoMessage() {}
func (*NodeConfigSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{90}
}
func (m *NodeConfigSource) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NodeConfigSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NodeConfigSource.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NodeConfigSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NodeConfigSource.Merge(m, src)
}
func (m *NodeConfigSource) XXX_Size() int {
	return m.Size()
}
func (m *NodeConfigSource) XXX_DiscardUnknown() {
	xxx_messageInfo_NodeConfigSource.DiscardUnknown(m)
}

var xxx_messageInfo_NodeConfigSource proto.InternalMessageInfo

func (m *NodeConfigSource) GetConfigMap() *ConfigMapNodeConfigSource {
	if m != nil {
		return m.ConfigMap
	}
	return nil
}

// NodeConfigStatus describes the status of the config assigned by Node.Spec.ConfigSource.
type NodeConfigStatus struct {
	// Assigned reports the checkpointed config the node will try to use.
	// When Node.Spec.ConfigSource is updated, the node checkpoints the associated
	// config payload to local disk, along with a record indicating intended
	// config. The node refers to this record to choose its config checkpoint, and
	// reports this record in Assigned. Assigned only updates in the status after
	// the record has been checkpointed to disk. When the Kubelet is restarted,
	// it tries to make the Assigned config the Active config by loading and
	// validating the checkpointed payload identified by Assigned.
	// +optional
	Assigned *NodeConfigSource `protobuf:"bytes,1,opt,name=assigned" json:"assigned,omitempty"`
	// Active reports the checkpointed config the node is actively using.
	// Active will represent either the current version of the Assigned config,
	// or the current LastKnownGood config, depending on whether attempting to use the
	// Assigned config results in an error.
	// +optional
	Active *NodeConfigSource `protobuf:"bytes,2,opt,name=active" json:"active,omitempty"`
	// LastKnownGood reports the checkpointed config the node will fall back to
	// when it encounters an error attempting to use the Assigned config.
	// The Assigned config becomes the LastKnownGood config when the node determines
	// that the Assigned config is stable and correct.
	// This is currently implemented as a 10-minute soak period starting when the local
	// record of Assigned config is updated. If the Assigned config is Active at the end
	// of this period, it becomes the LastKnownGood. Note that if Spec.ConfigSource is
	// reset to nil (use local defaults), the LastKnownGood is also immediately reset to nil,
	// because the local default config is always assumed good.
	// You should not make assumptions about the node's method of determining config stability
	// and correctness, as this may change or become configurable in the future.
	// +optional
	LastKnownGood *NodeConfigSource `protobuf:"bytes,3,opt,name=lastKnownGood" json:"lastKnownGood,omitempty"`
	// Error describes any problems reconciling the Spec.ConfigSource to the Active config.
	// Errors may occur, for example, attempting to checkpoint Spec.ConfigSource to the local Assigned
	// record, attempting to checkpoint the payload associated with Spec.ConfigSource, attempting
	// to load or validate the Assigned config, etc.
	// Errors may occur at different points while syncing config. Earlier errors (e.g. download or
	// checkpointing errors) will not result in a rollback to LastKnownGood, and may resolve across
	// Kubelet retries. Later errors (e.g. loading or validating a checkpointed config) will result in
	// a rollback to LastKnownGood. In the latter case, it is usually possible to resolve the error
	// by fixing the config assigned in Spec.ConfigSource.
	// You can find additional information for debugging by searching the error message in the Kubelet log.
	// Error is a human-readable description of the error state; machines can check whether or not Error
	// is empty, but should not rely on the stability of the Error text across Kubelet versions.
	// +optional
	Error string `protobuf:"bytes,4,opt,name=error" json:"error"`
}

func (m *NodeConfigStatus) Reset()      { *m = NodeConfigStatus{} }
func (*NodeConfigStatus) ProtoMessage() {}
func (*NodeConfigStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{91}
}
func (m *NodeConfigStatus) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NodeConfigStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NodeConfigStatus.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NodeConfigStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NodeConfigStatus.Merge(m, src)
}
func (m *NodeConfigStatus) XXX_Size() int {
	return m.Size()
}
func (m *NodeConfigStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_NodeConfigStatus.DiscardUnknown(m)
}

var xxx_messageInfo_NodeConfigStatus proto.InternalMessageInfo

func (m *NodeConfigStatus) GetAssigned() *NodeConfigSource {
	if m != nil {
		return m.Assigned
	}
	return nil
}

func (m *NodeConfigStatus) GetActive() *NodeConfigSource {
	if m != nil {
		return m.Active
	}
	return nil
}

func (m *NodeConfigStatus) GetLastKnownGood() *NodeConfigSource {
	if m != nil {
		return m.LastKnownGood
	}
	return nil
}

func (m *NodeConfigStatus) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

// NodeDaemonEndpoints lists ports opened by daemons running on the Node.
type NodeDaemonEndpoints struct {
	// Endpoint on which Kubelet is listening.
	// +optional
	KubeletEndpoint *DaemonEndpoint `protobuf:"bytes,1,opt,name=kubeletEndpoint" json:"kubeletEndpoint,omitempty"`
}

func (m *NodeDaemonEndpoints) Reset()      { *m = NodeDaemonEndpoints{} }
func (*NodeDaemonEndpoints) ProtoMessage() {}
func (*NodeDaemonEndpoints) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{92}
}
func (m *NodeDaemonEndpoints) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NodeDaemonEndpoints) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NodeDaemonEndpoints.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NodeDaemonEndpoints) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NodeDaemonEndpoints.Merge(m, src)
}
func (m *NodeDaemonEndpoints) XXX_Size() int {
	return m.Size()
}
func (m *NodeDaemonEndpoints) XXX_DiscardUnknown() {
	xxx_messageInfo_NodeDaemonEndpoints.DiscardUnknown(m)
}

var xxx_messageInfo_NodeDaemonEndpoints proto.InternalMessageInfo

func (m *NodeDaemonEndpoints) GetKubeletEndpoint() *DaemonEndpoint {
	if m != nil {
		return m.KubeletEndpoint
	}
	return nil
}

// NodeList is the whole list of all Nodes which have been registered with master.
type NodeList struct {
	// Standard list metadata.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds
	// +optional
	Metadata *v1.ListMeta `protobuf:"bytes,1,opt,name=metadata" json:"metadata,omitempty"`
	// List of nodes
	Items []*Node `protobuf:"bytes,2,rep,name=items" json:"items,omitempty"`
}

func (m *NodeList) Reset()      { *m = NodeList{} }
func (*NodeList) ProtoMessage() {}
func (*NodeList) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{93}
}
func (m *NodeList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NodeList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NodeList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NodeList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NodeList.Merge(m, src)
}
func (m *NodeList) XXX_Size() int {
	return m.Size()
}
func (m *NodeList) XXX_DiscardUnknown() {
	xxx_messageInfo_NodeList.DiscardUnknown(m)
}

var xxx_messageInfo_NodeList proto.InternalMessageInfo

func (m *NodeList) GetMetadata() *v1.ListMeta {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *NodeList) GetItems() []*Node {
	if m != nil {
		return m.Items
	}
	return nil
}

// NodeProxyOptions is the query options to a Node's proxy call.
type NodeProxyOptions struct {
	// Path is the URL path to use for the current proxy request to node.
	// +optional
	Path string `protobuf:"bytes,1,opt,name=path" json:"path"`
}

func (m *NodeProxyOptions) Reset()      { *m = NodeProxyOptions{} }
func (*NodeProxyOptions) ProtoMessage() {}
func (*NodeProxyOptions) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{94}
}
func (m *NodeProxyOptions) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NodeProxyOptions) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NodeProxyOptions.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NodeProxyOptions) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NodeProxyOptions.Merge(m, src)
}
func (m *NodeProxyOptions) XXX_Size() int {
	return m.Size()
}
func (m *NodeProxyOptions) XXX_DiscardUnknown() {
	xxx_messageInfo_NodeProxyOptions.DiscardUnknown(m)
}

var xxx_messageInfo_NodeProxyOptions proto.InternalMessageInfo

func (m *NodeProxyOptions) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

// NodeResources is an object for conveying resource information about a node.
// see http://releases.k8s.io/HEAD/docs/design/resources.md for more details.
type NodeResources struct {
	// Capacity represents the available resources of a node
	Capacity map[string]*resource.Quantity `protobuf:"bytes,1,rep,name=capacity" json:"capacity,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *NodeResources) Reset()      { *m = NodeResources{} }
func (*NodeResources) ProtoMessage() {}
func (*NodeResources) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{95}
}
func (m *NodeResources) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NodeResources) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NodeResources.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NodeResources) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NodeResources.Merge(m, src)
}
func (m *NodeResources) XXX_Size() int {
	return m.Size()
}
func (m *NodeResources) XXX_DiscardUnknown() {
	xxx_messageInfo_NodeResources.DiscardUnknown(m)
}

var xxx_messageInfo_NodeResources proto.InternalMessageInfo

func (m *NodeResources) GetCapacity() map[string]*resource.Quantity {
	if m != nil {
		return m.Capacity
	}
	return nil
}

// A node selector represents the union of the results of one or more label queries
// over a set of nodes; that is, it represents the OR of the selectors represented
// by the node selector terms.
type NodeSelector struct {
	// Required. A list of node selector terms. The terms are ORed.
	NodeSelectorTerms []*NodeSelectorTerm `protobuf:"bytes,1,rep,name=nodeSelectorTerms" json:"nodeSelectorTerms,omitempty"`
}

func (m *NodeSelector) Reset()      { *m = NodeSelector{} }
func (*NodeSelector) ProtoMessage() {}
func (*NodeSelector) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{96}
}
func (m *NodeSelector) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NodeSelector) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NodeSelector.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NodeSelector) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NodeSelector.Merge(m, src)
}
func (m *NodeSelector) XXX_Size() int {
	return m.Size()
}
func (m *NodeSelector) XXX_DiscardUnknown() {
	xxx_messageInfo_NodeSelector.DiscardUnknown(m)
}

var xxx_messageInfo_NodeSelector proto.InternalMessageInfo

func (m *NodeSelector) GetNodeSelectorTerms() []*NodeSelectorTerm {
	if m != nil {
		return m.NodeSelectorTerms
	}
	return nil
}

// A node selector requirement is a selector that contains values, a key, and an operator
// that relates the key and values.
type NodeSelectorRequirement struct {
	// The label key that the selector applies to.
	Key string `protobuf:"bytes,1,opt,name=key" json:"key"`
	// Represents a key's relationship to a set of values.
	// Valid operators are In, NotIn, Exists, DoesNotExist. Gt, and Lt.
	Operator string `protobuf:"bytes,2,opt,name=operator" json:"operator"`
	// An array of string values. If the operator is In or NotIn,
	// the values array must be non-empty. If the operator is Exists or DoesNotExist,
	// the values array must be empty. If the operator is Gt or Lt, the values
	// array must have a single element, which will be interpreted as an integer.
	// This array is replaced during a strategic merge patch.
	// +optional
	Values []string `protobuf:"bytes,3,rep,name=values" json:"values,omitempty"`
}

func (m *NodeSelectorRequirement) Reset()      { *m = NodeSelectorRequirement{} }
func (*NodeSelectorRequirement) ProtoMessage() {}
func (*NodeSelectorRequirement) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{97}
}
func (m *NodeSelectorRequirement) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NodeSelectorRequirement) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NodeSelectorRequirement.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NodeSelectorRequirement) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NodeSelectorRequirement.Merge(m, src)
}
func (m *NodeSelectorRequirement) XXX_Size() int {
	return m.Size()
}
func (m *NodeSelectorRequirement) XXX_DiscardUnknown() {
	xxx_messageInfo_NodeSelectorRequirement.DiscardUnknown(m)
}

var xxx_messageInfo_NodeSelectorRequirement proto.InternalMessageInfo

func (m *NodeSelectorRequirement) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

func (m *NodeSelectorRequirement) GetOperator() string {
	if m != nil {
		return m.Operator
	}
	return ""
}

func (m *NodeSelectorRequirement) GetValues() []string {
	if m != nil {
		return m.Values
	}
	return nil
}

// A null or empty node selector term matches no objects. The requirements of
// them are ANDed.
// The TopologySelectorTerm type implements a subset of the NodeSelectorTerm.
type NodeSelectorTerm struct {
	// A list of node selector requirements by node's labels.
	// +optional
	MatchExpressions []*NodeSelectorRequirement `protobuf:"bytes,1,rep,name=matchExpressions" json:"matchExpressions,omitempty"`
	// A list of node selector requirements by node's fields.
	// +optional
	MatchFields []*NodeSelectorRequirement `protobuf:"bytes,2,rep,name=matchFields" json:"matchFields,omitempty"`
}

func (m *NodeSelectorTerm) Reset()      { *m = NodeSelectorTerm{} }
func (*NodeSelectorTerm) ProtoMessage() {}
func (*NodeSelectorTerm) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{98}
}
func (m *NodeSelectorTerm) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NodeSelectorTerm) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NodeSelectorTerm.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NodeSelectorTerm) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NodeSelectorTerm.Merge(m, src)
}
func (m *NodeSelectorTerm) XXX_Size() int {
	return m.Size()
}
func (m *NodeSelectorTerm) XXX_DiscardUnknown() {
	xxx_messageInfo_NodeSelectorTerm.DiscardUnknown(m)
}

var xxx_messageInfo_NodeSelectorTerm proto.InternalMessageInfo

func (m *NodeSelectorTerm) GetMatchExpressions() []*NodeSelectorRequirement {
	if m != nil {
		return m.MatchExpressions
	}
	return nil
}

func (m *NodeSelectorTerm) GetMatchFields() []*NodeSelectorRequirement {
	if m != nil {
		return m.MatchFields
	}
	return nil
}

// NodeSpec describes the attributes that a node is created with.
type NodeSpec struct {
	// PodCIDR represents the pod IP range assigned to the node.
	// +optional
	PodCIDR string `protobuf:"bytes,1,opt,name=podCIDR" json:"podCIDR"`
	// podCIDRs represents the IP ranges assigned to the node for usage by Pods on that node. If this
	// field is specified, the 0th entry must match the podCIDR field. It may contain at most 1 value for
	// each of IPv4 and IPv6.
	// +optional
	// +patchStrategy=merge
	PodCIDRs []string `protobuf:"bytes,7,rep,name=podCIDRs" json:"podCIDRs,omitempty"`
	// ID of the node assigned by the cloud provider in the format: <ProviderName>://<ProviderSpecificNodeID>
	// +optional
	ProviderID string `protobuf:"bytes,3,opt,name=providerID" json:"providerID"`
	// Unschedulable controls node schedulability of new pods. By default, node is schedulable.
	// More info: https://kubernetes.io/docs/concepts/nodes/node/#manual-node-administration
	// +optional
	Unschedulable bool `protobuf:"varint,4,opt,name=unschedulable" json:"unschedulable"`
	// If specified, the node's taints.
	// +optional
	Taints []*Taint `protobuf:"bytes,5,rep,name=taints" json:"taints,omitempty"`
	// If specified, the source to get node configuration from
	// The DynamicKubeletConfig feature gate must be enabled for the Kubelet to use this field
	// +optional
	ConfigSource *NodeConfigSource `protobuf:"bytes,6,opt,name=configSource" json:"configSource,omitempty"`
	// Deprecated. Not all kubelets will set this field. Remove field after 1.13.
	// see: https://issues.k8s.io/61966
	// +optional
	ExternalID string `protobuf:"bytes,2,opt,name=externalID" json:"externalID"`
}

func (m *NodeSpec) Reset()      { *m = NodeSpec{} }
func (*NodeSpec) ProtoMessage() {}
func (*NodeSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{99}
}
func (m *NodeSpec) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NodeSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NodeSpec.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NodeSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NodeSpec.Merge(m, src)
}
func (m *NodeSpec) XXX_Size() int {
	return m.Size()
}
func (m *NodeSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_NodeSpec.DiscardUnknown(m)
}

var xxx_messageInfo_NodeSpec proto.InternalMessageInfo

func (m *NodeSpec) GetPodCIDR() string {
	if m != nil {
		return m.PodCIDR
	}
	return ""
}

func (m *NodeSpec) GetPodCIDRs() []string {
	if m != nil {
		return m.PodCIDRs
	}
	return nil
}

func (m *NodeSpec) GetProviderID() string {
	if m != nil {
		return m.ProviderID
	}
	return ""
}

func (m *NodeSpec) GetUnschedulable() bool {
	if m != nil {
		return m.Unschedulable
	}
	return false
}

func (m *NodeSpec) GetTaints() []*Taint {
	if m != nil {
		return m.Taints
	}
	return nil
}

func (m *NodeSpec) GetConfigSource() *NodeConfigSource {
	if m != nil {
		return m.ConfigSource
	}
	return nil
}

func (m *NodeSpec) GetExternalID() string {
	if m != nil {
		return m.ExternalID
	}
	return ""
}

// NodeStatus is information about the current status of a node.
type NodeStatus struct {
	// Capacity represents the total resources of a node.
	// More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#capacity
	// +optional
	Capacity map[string]*resource.Quantity `protobuf:"bytes,1,rep,name=capacity" json:"capacity,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Allocatable represents the resources of a node that are available for scheduling.
	// Defaults to Capacity.
	// +optional
	Allocatable map[string]*resource.Quantity `protobuf:"bytes,2,rep,name=allocatable" json:"allocatable,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// NodePhase is the recently observed lifecycle phase of the node.
	// More info: https://kubernetes.io/docs/concepts/nodes/node/#phase
	// The field is never populated, and now is deprecated.
	// +optional
	Phase string `protobuf:"bytes,3,opt,name=phase" json:"phase"`
	// Conditions is an array of current observed node conditions.
	// More info: https://kubernetes.io/docs/concepts/nodes/node/#condition
	// +optional
	// +patchMergeKey=type
	// +patchStrategy=merge
	Conditions []*NodeCondition `protobuf:"bytes,4,rep,name=conditions" json:"conditions,omitempty"`
	// List of addresses reachable to the node.
	// Queried from cloud provider, if available.
	// More info: https://kubernetes.io/docs/concepts/nodes/node/#addresses
	// Note: This field is declared as mergeable, but the merge key is not sufficiently
	// unique, which can cause data corruption when it is merged. Callers should instead
	// use a full-replacement patch. See http://pr.k8s.io/79391 for an example.
	// +optional
	// +patchMergeKey=type
	// +patchStrategy=merge
	Addresses []*NodeAddress `protobuf:"bytes,5,rep,name=addresses" json:"addresses,omitempty"`
	// Endpoints of daemons running on the Node.
	// +optional
	DaemonEndpoints *NodeDaemonEndpoints `protobuf:"bytes,6,opt,name=daemonEndpoints" json:"daemonEndpoints,omitempty"`
	// Set of ids/uuids to uniquely identify the node.
	// More info: https://kubernetes.io/docs/concepts/nodes/node/#info
	// +optional
	NodeInfo *NodeSystemInfo `protobuf:"bytes,7,opt,name=nodeInfo" json:"nodeInfo,omitempty"`
	// List of container images on this node
	// +optional
	Images []*ContainerImage `protobuf:"bytes,8,rep,name=images" json:"images,omitempty"`
	// List of attachable volumes in use (mounted) by the node.
	// +optional
	VolumesInUse []string `protobuf:"bytes,9,rep,name=volumesInUse" json:"volumesInUse,omitempty"`
	// List of volumes that are attached to the node.
	// +optional
	VolumesAttached []*AttachedVolume `protobuf:"bytes,10,rep,name=volumesAttached" json:"volumesAttached,omitempty"`
	// Status of the config assigned to the node via the dynamic Kubelet config feature.
	// +optional
	Config *NodeConfigStatus `protobuf:"bytes,11,opt,name=config" json:"config,omitempty"`
}

func (m *NodeStatus) Reset()      { *m = NodeStatus{} }
func (*NodeStatus) ProtoMessage() {}
func (*NodeStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{100}
}
func (m *NodeStatus) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NodeStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NodeStatus.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NodeStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NodeStatus.Merge(m, src)
}
func (m *NodeStatus) XXX_Size() int {
	return m.Size()
}
func (m *NodeStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_NodeStatus.DiscardUnknown(m)
}

var xxx_messageInfo_NodeStatus proto.InternalMessageInfo

func (m *NodeStatus) GetCapacity() map[string]*resource.Quantity {
	if m != nil {
		return m.Capacity
	}
	return nil
}

func (m *NodeStatus) GetAllocatable() map[string]*resource.Quantity {
	if m != nil {
		return m.Allocatable
	}
	return nil
}

func (m *NodeStatus) GetPhase() string {
	if m != nil {
		return m.Phase
	}
	return ""
}

func (m *NodeStatus) GetConditions() []*NodeCondition {
	if m != nil {
		return m.Conditions
	}
	return nil
}

func (m *NodeStatus) GetAddresses() []*NodeAddress {
	if m != nil {
		return m.Addresses
	}
	return nil
}

func (m *NodeStatus) GetDaemonEndpoints() *NodeDaemonEndpoints {
	if m != nil {
		return m.DaemonEndpoints
	}
	return nil
}

func (m *NodeStatus) GetNodeInfo() *NodeSystemInfo {
	if m != nil {
		return m.NodeInfo
	}
	return nil
}

func (m *NodeStatus) GetImages() []*ContainerImage {
	if m != nil {
		return m.Images
	}
	return nil
}

func (m *NodeStatus) GetVolumesInUse() []string {
	if m != nil {
		return m.VolumesInUse
	}
	return nil
}

func (m *NodeStatus) GetVolumesAttached() []*AttachedVolume {
	if m != nil {
		return m.VolumesAttached
	}
	return nil
}

func (m *NodeStatus) GetConfig() *NodeConfigStatus {
	if m != nil {
		return m.Config
	}
	return nil
}

// NodeSystemInfo is a set of ids/uuids to uniquely identify the node.
type NodeSystemInfo struct {
	// MachineID reported by the node. For unique machine identification
	// in the cluster this field is preferred. Learn more from man(5)
	// machine-id: http://man7.org/linux/man-pages/man5/machine-id.5.html
	MachineID string `protobuf:"bytes,1,opt,name=machineID" json:"machineID"`
	// SystemUUID reported by the node. For unique machine identification
	// MachineID is preferred. This field is specific to Red Hat hosts
	// https://access.redhat.com/documentation/en-US/Red_Hat_Subscription_Management/1/html/RHSM/getting-system-uuid.html
	SystemUUID string `protobuf:"bytes,2,opt,name=systemUUID" json:"systemUUID"`
	// Boot ID reported by the node.
	BootID string `protobuf:"bytes,3,opt,name=bootID" json:"bootID"`
	// Kernel Version reported by the node from 'uname -r' (e.g. 3.16.0-0.bpo.4-amd64).
	KernelVersion string `protobuf:"bytes,4,opt,name=kernelVersion" json:"kernelVersion"`
	// OS Image reported by the node from /etc/os-release (e.g. Debian GNU/Linux 7 (wheezy)).
	OsImage string `protobuf:"bytes,5,opt,name=osImage" json:"osImage"`
	// ContainerRuntime Version reported by the node through runtime remote API (e.g. docker://1.5.0).
	ContainerRuntimeVersion string `protobuf:"bytes,6,opt,name=containerRuntimeVersion" json:"containerRuntimeVersion"`
	// Kubelet Version reported by the node.
	KubeletVersion string `protobuf:"bytes,7,opt,name=kubeletVersion" json:"kubeletVersion"`
	// KubeProxy Version reported by the node.
	KubeProxyVersion string `protobuf:"bytes,8,opt,name=kubeProxyVersion" json:"kubeProxyVersion"`
	// The Operating System reported by the node
	OperatingSystem string `protobuf:"bytes,9,opt,name=operatingSystem" json:"operatingSystem"`
	// The Architecture reported by the node
	Architecture string `protobuf:"bytes,10,opt,name=architecture" json:"architecture"`
}

func (m *NodeSystemInfo) Reset()      { *m = NodeSystemInfo{} }
func (*NodeSystemInfo) ProtoMessage() {}
func (*NodeSystemInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{101}
}
func (m *NodeSystemInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NodeSystemInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NodeSystemInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NodeSystemInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NodeSystemInfo.Merge(m, src)
}
func (m *NodeSystemInfo) XXX_Size() int {
	return m.Size()
}
func (m *NodeSystemInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_NodeSystemInfo.DiscardUnknown(m)
}

var xxx_messageInfo_NodeSystemInfo proto.InternalMessageInfo

func (m *NodeSystemInfo) GetMachineID() string {
	if m != nil {
		return m.MachineID
	}
	return ""
}

func (m *NodeSystemInfo) GetSystemUUID() string {
	if m != nil {
		return m.SystemUUID
	}
	return ""
}

func (m *NodeSystemInfo) GetBootID() string {
	if m != nil {
		return m.BootID
	}
	return ""
}

func (m *NodeSystemInfo) GetKernelVersion() string {
	if m != nil {
		return m.KernelVersion
	}
	return ""
}

func (m *NodeSystemInfo) GetOsImage() string {
	if m != nil {
		return m.OsImage
	}
	return ""
}

func (m *NodeSystemInfo) GetContainerRuntimeVersion() string {
	if m != nil {
		return m.ContainerRuntimeVersion
	}
	return ""
}

func (m *NodeSystemInfo) GetKubeletVersion() string {
	if m != nil {
		return m.KubeletVersion
	}
	return ""
}

func (m *NodeSystemInfo) GetKubeProxyVersion() string {
	if m != nil {
		return m.KubeProxyVersion
	}
	return ""
}

func (m *NodeSystemInfo) GetOperatingSystem() string {
	if m != nil {
		return m.OperatingSystem
	}
	return ""
}

func (m *NodeSystemInfo) GetArchitecture() string {
	if m != nil {
		return m.Architecture
	}
	return ""
}

// ObjectFieldSelector selects an APIVersioned field of an object.
type ObjectFieldSelector struct {
	// Version of the schema the FieldPath is written in terms of, defaults to "v1".
	// +optional
	ApiVersion string `protobuf:"bytes,1,opt,name=apiVersion" json:"apiVersion"`
	// Path of the field to select in the specified API version.
	FieldPath string `protobuf:"bytes,2,opt,name=fieldPath" json:"fieldPath"`
}

func (m *ObjectFieldSelector) Reset()      { *m = ObjectFieldSelector{} }
func (*ObjectFieldSelector) ProtoMessage() {}
func (*ObjectFieldSelector) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{102}
}
func (m *ObjectFieldSelector) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ObjectFieldSelector) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ObjectFieldSelector.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ObjectFieldSelector) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ObjectFieldSelector.Merge(m, src)
}
func (m *ObjectFieldSelector) XXX_Size() int {
	return m.Size()
}
func (m *ObjectFieldSelector) XXX_DiscardUnknown() {
	xxx_messageInfo_ObjectFieldSelector.DiscardUnknown(m)
}

var xxx_messageInfo_ObjectFieldSelector proto.InternalMessageInfo

func (m *ObjectFieldSelector) GetApiVersion() string {
	if m != nil {
		return m.ApiVersion
	}
	return ""
}

func (m *ObjectFieldSelector) GetFieldPath() string {
	if m != nil {
		return m.FieldPath
	}
	return ""
}

// ObjectReference contains enough information to let you inspect or modify the referred object.
// +k8s:deepcopy-gen:interfaces=k8s.io/apimachinery/pkg/runtime.Object
type ObjectReference struct {
	// Kind of the referent.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds
	// +optional
	Kind string `protobuf:"bytes,1,opt,name=kind" json:"kind"`
	// Namespace of the referent.
	// More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/namespaces/
	// +optional
	Namespace string `protobuf:"bytes,2,opt,name=namespace" json:"namespace"`
	// Name of the referent.
	// More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
	// +optional
	Name string `protobuf:"bytes,3,opt,name=name" json:"name"`
	// UID of the referent.
	// More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#uids
	// +optional
	Uid string `protobuf:"bytes,4,opt,name=uid" json:"uid"`
	// API version of the referent.
	// +optional
	ApiVersion string `protobuf:"bytes,5,opt,name=apiVersion" json:"apiVersion"`
	// Specific resourceVersion to which this reference is made, if any.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#concurrency-control-and-consistency
	// +optional
	ResourceVersion string `protobuf:"bytes,6,opt,name=resourceVersion" json:"resourceVersion"`
	// If referring to a piece of an object instead of an entire object, this string
	// should contain a valid JSON/Go field access statement, such as desiredState.manifest.containers[2].
	// For example, if the object reference is to a container within a pod, this would take on a value like:
	// "spec.containers{name}" (where "name" refers to the name of the container that triggered
	// the event) or if no container name is specified "spec.containers[2]" (container with
	// index 2 in this pod). This syntax is chosen only to have some well-defined way of
	// referencing a part of an object.
	// TODO: this design is not final and this field is subject to change in the future.
	// +optional
	FieldPath string `protobuf:"bytes,7,opt,name=fieldPath" json:"fieldPath"`
}

func (m *ObjectReference) Reset()      { *m = ObjectReference{} }
func (*ObjectReference) ProtoMessage() {}
func (*ObjectReference) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{103}
}
func (m *ObjectReference) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ObjectReference) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ObjectReference.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ObjectReference) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ObjectReference.Merge(m, src)
}
func (m *ObjectReference) XXX_Size() int {
	return m.Size()
}
func (m *ObjectReference) XXX_DiscardUnknown() {
	xxx_messageInfo_ObjectReference.DiscardUnknown(m)
}

var xxx_messageInfo_ObjectReference proto.InternalMessageInfo

func (m *ObjectReference) GetKind() string {
	if m != nil {
		return m.Kind
	}
	return ""
}

func (m *ObjectReference) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *ObjectReference) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ObjectReference) GetUid() string {
	if m != nil {
		return m.Uid
	}
	return ""
}

func (m *ObjectReference) GetApiVersion() string {
	if m != nil {
		return m.ApiVersion
	}
	return ""
}

func (m *ObjectReference) GetResourceVersion() string {
	if m != nil {
		return m.ResourceVersion
	}
	return ""
}

func (m *ObjectReference) GetFieldPath() string {
	if m != nil {
		return m.FieldPath
	}
	return ""
}

// PersistentVolume (PV) is a storage resource provisioned by an administrator.
// It is analogous to a node.
// More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes
type PersistentVolume struct {
	// Standard object's metadata.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
	// +optional
	Metadata *v1.ObjectMeta `protobuf:"bytes,1,opt,name=metadata" json:"metadata,omitempty"`
	// Spec defines a specification of a persistent volume owned by the cluster.
	// Provisioned by an administrator.
	// More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistent-volumes
	// +optional
	Spec *PersistentVolumeSpec `protobuf:"bytes,2,opt,name=spec" json:"spec,omitempty"`
	// Status represents the current information/status for the persistent volume.
	// Populated by the system.
	// Read-only.
	// More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistent-volumes
	// +optional
	Status *PersistentVolumeStatus `protobuf:"bytes,3,opt,name=status" json:"status,omitempty"`
}

func (m *PersistentVolume) Reset()      { *m = PersistentVolume{} }
func (*PersistentVolume) ProtoMessage() {}
func (*PersistentVolume) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{104}
}
func (m *PersistentVolume) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PersistentVolume) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PersistentVolume.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PersistentVolume) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PersistentVolume.Merge(m, src)
}
func (m *PersistentVolume) XXX_Size() int {
	return m.Size()
}
func (m *PersistentVolume) XXX_DiscardUnknown() {
	xxx_messageInfo_PersistentVolume.DiscardUnknown(m)
}

var xxx_messageInfo_PersistentVolume proto.InternalMessageInfo

func (m *PersistentVolume) GetMetadata() *v1.ObjectMeta {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *PersistentVolume) GetSpec() *PersistentVolumeSpec {
	if m != nil {
		return m.Spec
	}
	return nil
}

func (m *PersistentVolume) GetStatus() *PersistentVolumeStatus {
	if m != nil {
		return m.Status
	}
	return nil
}

// PersistentVolumeClaim is a user's request for and claim to a persistent volume
type PersistentVolumeClaim struct {
	// Standard object's metadata.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
	// +optional
	Metadata *v1.ObjectMeta `protobuf:"bytes,1,opt,name=metadata" json:"metadata,omitempty"`
	// Spec defines the desired characteristics of a volume requested by a pod author.
	// More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims
	// +optional
	Spec *PersistentVolumeClaimSpec `protobuf:"bytes,2,opt,name=spec" json:"spec,omitempty"`
	// Status represents the current information/status of a persistent volume claim.
	// Read-only.
	// More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims
	// +optional
	Status *PersistentVolumeClaimStatus `protobuf:"bytes,3,opt,name=status" json:"status,omitempty"`
}

func (m *PersistentVolumeClaim) Reset()      { *m = PersistentVolumeClaim{} }
func (*PersistentVolumeClaim) ProtoMessage() {}
func (*PersistentVolumeClaim) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{105}
}
func (m *PersistentVolumeClaim) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PersistentVolumeClaim) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PersistentVolumeClaim.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PersistentVolumeClaim) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PersistentVolumeClaim.Merge(m, src)
}
func (m *PersistentVolumeClaim) XXX_Size() int {
	return m.Size()
}
func (m *PersistentVolumeClaim) XXX_DiscardUnknown() {
	xxx_messageInfo_PersistentVolumeClaim.DiscardUnknown(m)
}

var xxx_messageInfo_PersistentVolumeClaim proto.InternalMessageInfo

func (m *PersistentVolumeClaim) GetMetadata() *v1.ObjectMeta {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *PersistentVolumeClaim) GetSpec() *PersistentVolumeClaimSpec {
	if m != nil {
		return m.Spec
	}
	return nil
}

func (m *PersistentVolumeClaim) GetStatus() *PersistentVolumeClaimStatus {
	if m != nil {
		return m.Status
	}
	return nil
}

// PersistentVolumeClaimCondition contails details about state of pvc
type PersistentVolumeClaimCondition struct {
	Type   string `protobuf:"bytes,1,opt,name=type" json:"type"`
	Status string `protobuf:"bytes,2,opt,name=status" json:"status"`
	// Last time we probed the condition.
	// +optional
	LastProbeTime *v1.Time `protobuf:"bytes,3,opt,name=lastProbeTime" json:"lastProbeTime,omitempty"`
	// Last time the condition transitioned from one status to another.
	// +optional
	LastTransitionTime *v1.Time `protobuf:"bytes,4,opt,name=lastTransitionTime" json:"lastTransitionTime,omitempty"`
	// Unique, this should be a short, machine understandable string that gives the reason
	// for condition's last transition. If it reports "ResizeStarted" that means the underlying
	// persistent volume is being resized.
	// +optional
	Reason string `protobuf:"bytes,5,opt,name=reason" json:"reason"`
	// Human-readable message indicating details about last transition.
	// +optional
	Message string `protobuf:"bytes,6,opt,name=message" json:"message"`
}

func (m *PersistentVolumeClaimCondition) Reset()      { *m = PersistentVolumeClaimCondition{} }
func (*PersistentVolumeClaimCondition) ProtoMessage() {}
func (*PersistentVolumeClaimCondition) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{106}
}
func (m *PersistentVolumeClaimCondition) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PersistentVolumeClaimCondition) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PersistentVolumeClaimCondition.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PersistentVolumeClaimCondition) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PersistentVolumeClaimCondition.Merge(m, src)
}
func (m *PersistentVolumeClaimCondition) XXX_Size() int {
	return m.Size()
}
func (m *PersistentVolumeClaimCondition) XXX_DiscardUnknown() {
	xxx_messageInfo_PersistentVolumeClaimCondition.DiscardUnknown(m)
}

var xxx_messageInfo_PersistentVolumeClaimCondition proto.InternalMessageInfo

func (m *PersistentVolumeClaimCondition) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *PersistentVolumeClaimCondition) GetStatus() string {
	if m != nil {
		return m.Status
	}
	return ""
}

func (m *PersistentVolumeClaimCondition) GetLastProbeTime() *v1.Time {
	if m != nil {
		return m.LastProbeTime
	}
	return nil
}

func (m *PersistentVolumeClaimCondition) GetLastTransitionTime() *v1.Time {
	if m != nil {
		return m.LastTransitionTime
	}
	return nil
}

func (m *PersistentVolumeClaimCondition) GetReason() string {
	if m != nil {
		return m.Reason
	}
	return ""
}

func (m *PersistentVolumeClaimCondition) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

// PersistentVolumeClaimList is a list of PersistentVolumeClaim items.
type PersistentVolumeClaimList struct {
	// Standard list metadata.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds
	// +optional
	Metadata *v1.ListMeta `protobuf:"bytes,1,opt,name=metadata" json:"metadata,omitempty"`
	// A list of persistent volume claims.
	// More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims
	Items []*PersistentVolumeClaim `protobuf:"bytes,2,rep,name=items" json:"items,omitempty"`
}

func (m *PersistentVolumeClaimList) Reset()      { *m = PersistentVolumeClaimList{} }
func (*PersistentVolumeClaimList) ProtoMessage() {}
func (*PersistentVolumeClaimList) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{107}
}
func (m *PersistentVolumeClaimList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PersistentVolumeClaimList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PersistentVolumeClaimList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PersistentVolumeClaimList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PersistentVolumeClaimList.Merge(m, src)
}
func (m *PersistentVolumeClaimList) XXX_Size() int {
	return m.Size()
}
func (m *PersistentVolumeClaimList) XXX_DiscardUnknown() {
	xxx_messageInfo_PersistentVolumeClaimList.DiscardUnknown(m)
}

var xxx_messageInfo_PersistentVolumeClaimList proto.InternalMessageInfo

func (m *PersistentVolumeClaimList) GetMetadata() *v1.ListMeta {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *PersistentVolumeClaimList) GetItems() []*PersistentVolumeClaim {
	if m != nil {
		return m.Items
	}
	return nil
}

// PersistentVolumeClaimSpec describes the common attributes of storage devices
// and allows a Source for provider-specific attributes
type PersistentVolumeClaimSpec struct {
	// AccessModes contains the desired access modes the volume should have.
	// More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes-1
	// +optional
	AccessModes []string `protobuf:"bytes,1,rep,name=accessModes" json:"accessModes,omitempty"`
	// A label query over volumes to consider for binding.
	// +optional
	Selector *v1.LabelSelector `protobuf:"bytes,4,opt,name=selector" json:"selector,omitempty"`
	// Resources represents the minimum resources the volume should have.
	// More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources
	// +optional
	Resources *ResourceRequirements `protobuf:"bytes,2,opt,name=resources" json:"resources,omitempty"`
	// VolumeName is the binding reference to the PersistentVolume backing this claim.
	// +optional
	VolumeName string `protobuf:"bytes,3,opt,name=volumeName" json:"volumeName"`
	// Name of the StorageClass required by the claim.
	// More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#class-1
	// +optional
	StorageClassName string `protobuf:"bytes,5,opt,name=storageClassName" json:"storageClassName"`
	// volumeMode defines what type of volume is required by the claim.
	// Value of Filesystem is implied when not included in claim spec.
	// This is a beta feature.
	// +optional
	VolumeMode string `protobuf:"bytes,6,opt,name=volumeMode" json:"volumeMode"`
	// This field requires the VolumeSnapshotDataSource alpha feature gate to be
	// enabled and currently VolumeSnapshot is the only supported data source.
	// If the provisioner can support VolumeSnapshot data source, it will create
	// a new volume and data will be restored to the volume at the same time.
	// If the provisioner does not support VolumeSnapshot data source, volume will
	// not be created and the failure will be reported as an event.
	// In the future, we plan to support more data source types and the behavior
	// of the provisioner may change.
	// +optional
	DataSource *TypedLocalObjectReference `protobuf:"bytes,7,opt,name=dataSource" json:"dataSource,omitempty"`
}

func (m *PersistentVolumeClaimSpec) Reset()      { *m = PersistentVolumeClaimSpec{} }
func (*PersistentVolumeClaimSpec) ProtoMessage() {}
func (*PersistentVolumeClaimSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{108}
}
func (m *PersistentVolumeClaimSpec) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PersistentVolumeClaimSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PersistentVolumeClaimSpec.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PersistentVolumeClaimSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PersistentVolumeClaimSpec.Merge(m, src)
}
func (m *PersistentVolumeClaimSpec) XXX_Size() int {
	return m.Size()
}
func (m *PersistentVolumeClaimSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_PersistentVolumeClaimSpec.DiscardUnknown(m)
}

var xxx_messageInfo_PersistentVolumeClaimSpec proto.InternalMessageInfo

func (m *PersistentVolumeClaimSpec) GetAccessModes() []string {
	if m != nil {
		return m.AccessModes
	}
	return nil
}

func (m *PersistentVolumeClaimSpec) GetSelector() *v1.LabelSelector {
	if m != nil {
		return m.Selector
	}
	return nil
}

func (m *PersistentVolumeClaimSpec) GetResources() *ResourceRequirements {
	if m != nil {
		return m.Resources
	}
	return nil
}

func (m *PersistentVolumeClaimSpec) GetVolumeName() string {
	if m != nil {
		return m.VolumeName
	}
	return ""
}

func (m *PersistentVolumeClaimSpec) GetStorageClassName() string {
	if m != nil {
		return m.StorageClassName
	}
	return ""
}

func (m *PersistentVolumeClaimSpec) GetVolumeMode() string {
	if m != nil {
		return m.VolumeMode
	}
	return ""
}

func (m *PersistentVolumeClaimSpec) GetDataSource() *TypedLocalObjectReference {
	if m != nil {
		return m.DataSource
	}
	return nil
}

// PersistentVolumeClaimStatus is the current status of a persistent volume claim.
type PersistentVolumeClaimStatus struct {
	// Phase represents the current phase of PersistentVolumeClaim.
	// +optional
	Phase string `protobuf:"bytes,1,opt,name=phase" json:"phase"`
	// AccessModes contains the actual access modes the volume backing the PVC has.
	// More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes-1
	// +optional
	AccessModes []string `protobuf:"bytes,2,rep,name=accessModes" json:"accessModes,omitempty"`
	// Represents the actual resources of the underlying volume.
	// +optional
	Capacity map[string]*resource.Quantity `protobuf:"bytes,3,rep,name=capacity" json:"capacity,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Current Condition of persistent volume claim. If underlying persistent volume is being
	// resized then the Condition will be set to 'ResizeStarted'.
	// +optional
	// +patchMergeKey=type
	// +patchStrategy=merge
	Conditions []*PersistentVolumeClaimCondition `protobuf:"bytes,4,rep,name=conditions" json:"conditions,omitempty"`
}

func (m *PersistentVolumeClaimStatus) Reset()      { *m = PersistentVolumeClaimStatus{} }
func (*PersistentVolumeClaimStatus) ProtoMessage() {}
func (*PersistentVolumeClaimStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{109}
}
func (m *PersistentVolumeClaimStatus) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PersistentVolumeClaimStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PersistentVolumeClaimStatus.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PersistentVolumeClaimStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PersistentVolumeClaimStatus.Merge(m, src)
}
func (m *PersistentVolumeClaimStatus) XXX_Size() int {
	return m.Size()
}
func (m *PersistentVolumeClaimStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_PersistentVolumeClaimStatus.DiscardUnknown(m)
}

var xxx_messageInfo_PersistentVolumeClaimStatus proto.InternalMessageInfo

func (m *PersistentVolumeClaimStatus) GetPhase() string {
	if m != nil {
		return m.Phase
	}
	return ""
}

func (m *PersistentVolumeClaimStatus) GetAccessModes() []string {
	if m != nil {
		return m.AccessModes
	}
	return nil
}

func (m *PersistentVolumeClaimStatus) GetCapacity() map[string]*resource.Quantity {
	if m != nil {
		return m.Capacity
	}
	return nil
}

func (m *PersistentVolumeClaimStatus) GetConditions() []*PersistentVolumeClaimCondition {
	if m != nil {
		return m.Conditions
	}
	return nil
}

// PersistentVolumeClaimVolumeSource references the user's PVC in the same namespace.
// This volume finds the bound PV and mounts that volume for the pod. A
// PersistentVolumeClaimVolumeSource is, essentially, a wrapper around another
// type of volume that is owned by someone else (the system).
type PersistentVolumeClaimVolumeSource struct {
	// ClaimName is the name of a PersistentVolumeClaim in the same namespace as the pod using this volume.
	// More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims
	ClaimName string `protobuf:"bytes,1,opt,name=claimName" json:"claimName"`
	// Will force the ReadOnly setting in VolumeMounts.
	// Default false.
	// +optional
	ReadOnly bool `protobuf:"varint,2,opt,name=readOnly" json:"readOnly"`
}

func (m *PersistentVolumeClaimVolumeSource) Reset()      { *m = PersistentVolumeClaimVolumeSource{} }
func (*PersistentVolumeClaimVolumeSource) ProtoMessage() {}
func (*PersistentVolumeClaimVolumeSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{110}
}
func (m *PersistentVolumeClaimVolumeSource) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PersistentVolumeClaimVolumeSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PersistentVolumeClaimVolumeSource.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PersistentVolumeClaimVolumeSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PersistentVolumeClaimVolumeSource.Merge(m, src)
}
func (m *PersistentVolumeClaimVolumeSource) XXX_Size() int {
	return m.Size()
}
func (m *PersistentVolumeClaimVolumeSource) XXX_DiscardUnknown() {
	xxx_messageInfo_PersistentVolumeClaimVolumeSource.DiscardUnknown(m)
}

var xxx_messageInfo_PersistentVolumeClaimVolumeSource proto.InternalMessageInfo

func (m *PersistentVolumeClaimVolumeSource) GetClaimName() string {
	if m != nil {
		return m.ClaimName
	}
	return ""
}

func (m *PersistentVolumeClaimVolumeSource) GetReadOnly() bool {
	if m != nil {
		return m.ReadOnly
	}
	return false
}

// PersistentVolumeList is a list of PersistentVolume items.
type PersistentVolumeList struct {
	// Standard list metadata.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds
	// +optional
	Metadata *v1.ListMeta `protobuf:"bytes,1,opt,name=metadata" json:"metadata,omitempty"`
	// List of persistent volumes.
	// More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes
	Items []*PersistentVolume `protobuf:"bytes,2,rep,name=items" json:"items,omitempty"`
}

func (m *PersistentVolumeList) Reset()      { *m = PersistentVolumeList{} }
func (*PersistentVolumeList) ProtoMessage() {}
func (*PersistentVolumeList) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{111}
}
func (m *PersistentVolumeList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PersistentVolumeList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PersistentVolumeList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PersistentVolumeList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PersistentVolumeList.Merge(m, src)
}
func (m *PersistentVolumeList) XXX_Size() int {
	return m.Size()
}
func (m *PersistentVolumeList) XXX_DiscardUnknown() {
	xxx_messageInfo_PersistentVolumeList.DiscardUnknown(m)
}

var xxx_messageInfo_PersistentVolumeList proto.InternalMessageInfo

func (m *PersistentVolumeList) GetMetadata() *v1.ListMeta {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *PersistentVolumeList) GetItems() []*PersistentVolume {
	if m != nil {
		return m.Items
	}
	return nil
}

// PersistentVolumeSource is similar to VolumeSource but meant for the
// administrator who creates PVs. Exactly one of its members must be set.
type PersistentVolumeSource struct {
	// GCEPersistentDisk represents a GCE Disk resource that is attached to a
	// kubelet's host machine and then exposed to the pod. Provisioned by an admin.
	// More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
	// +optional
	GcePersistentDisk *GCEPersistentDiskVolumeSource `protobuf:"bytes,1,opt,name=gcePersistentDisk" json:"gcePersistentDisk,omitempty"`
	// AWSElasticBlockStore represents an AWS Disk resource that is attached to a
	// kubelet's host machine and then exposed to the pod.
	// More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
	// +optional
	AwsElasticBlockStore *AWSElasticBlockStoreVolumeSource `protobuf:"bytes,2,opt,name=awsElasticBlockStore" json:"awsElasticBlockStore,omitempty"`
	// HostPath represents a directory on the host.
	// Provisioned by a developer or tester.
	// This is useful for single-node development and testing only!
	// On-host storage is not supported in any way and WILL NOT WORK in a multi-node cluster.
	// More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath
	// +optional
	HostPath *HostPathVolumeSource `protobuf:"bytes,3,opt,name=hostPath" json:"hostPath,omitempty"`
	// Glusterfs represents a Glusterfs volume that is attached to a host and
	// exposed to the pod. Provisioned by an admin.
	// More info: https://examples.k8s.io/volumes/glusterfs/README.md
	// +optional
	Glusterfs *GlusterfsPersistentVolumeSource `protobuf:"bytes,4,opt,name=glusterfs" json:"glusterfs,omitempty"`
	// NFS represents an NFS mount on the host. Provisioned by an admin.
	// More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs
	// +optional
	Nfs *NFSVolumeSource `protobuf:"bytes,5,opt,name=nfs" json:"nfs,omitempty"`
	// RBD represents a Rados Block Device mount on the host that shares a pod's lifetime.
	// More info: https://examples.k8s.io/volumes/rbd/README.md
	// +optional
	Rbd *RBDPersistentVolumeSource `protobuf:"bytes,6,opt,name=rbd" json:"rbd,omitempty"`
	// ISCSI represents an ISCSI Disk resource that is attached to a
	// kubelet's host machine and then exposed to the pod. Provisioned by an admin.
	// +optional
	Iscsi *ISCSIPersistentVolumeSource `protobuf:"bytes,7,opt,name=iscsi" json:"iscsi,omitempty"`
	// Cinder represents a cinder volume attached and mounted on kubelets host machine.
	// More info: https://examples.k8s.io/mysql-cinder-pd/README.md
	// +optional
	Cinder *CinderPersistentVolumeSource `protobuf:"bytes,8,opt,name=cinder" json:"cinder,omitempty"`
	// CephFS represents a Ceph FS mount on the host that shares a pod's lifetime
	// +optional
	Cephfs *CephFSPersistentVolumeSource `protobuf:"bytes,9,opt,name=cephfs" json:"cephfs,omitempty"`
	// FC represents a Fibre Channel resource that is attached to a kubelet's host machine and then exposed to the pod.
	// +optional
	Fc *FCVolumeSource `protobuf:"bytes,10,opt,name=fc" json:"fc,omitempty"`
	// Flocker represents a Flocker volume attached to a kubelet's host machine and exposed to the pod for its usage. This depends on the Flocker control service being running
	// +optional
	Flocker *FlockerVolumeSource `protobuf:"bytes,11,opt,name=flocker" json:"flocker,omitempty"`
	// FlexVolume represents a generic volume resource that is
	// provisioned/attached using an exec based plugin.
	// +optional
	FlexVolume *FlexPersistentVolumeSource `protobuf:"bytes,12,opt,name=flexVolume" json:"flexVolume,omitempty"`
	// AzureFile represents an Azure File Service mount on the host and bind mount to the pod.
	// +optional
	AzureFile *AzureFilePersistentVolumeSource `protobuf:"bytes,13,opt,name=azureFile" json:"azureFile,omitempty"`
	// VsphereVolume represents a vSphere volume attached and mounted on kubelets host machine
	// +optional
	VsphereVolume *VsphereVirtualDiskVolumeSource `protobuf:"bytes,14,opt,name=vsphereVolume" json:"vsphereVolume,omitempty"`
	// Quobyte represents a Quobyte mount on the host that shares a pod's lifetime
	// +optional
	Quobyte *QuobyteVolumeSource `protobuf:"bytes,15,opt,name=quobyte" json:"quobyte,omitempty"`
	// AzureDisk represents an Azure Data Disk mount on the host and bind mount to the pod.
	// +optional
	AzureDisk *AzureDiskVolumeSource `protobuf:"bytes,16,opt,name=azureDisk" json:"azureDisk,omitempty"`
	// PhotonPersistentDisk represents a PhotonController persistent disk attached and mounted on kubelets host machine
	PhotonPersistentDisk *PhotonPersistentDiskVolumeSource `protobuf:"bytes,17,opt,name=photonPersistentDisk" json:"photonPersistentDisk,omitempty"`
	// PortworxVolume represents a portworx volume attached and mounted on kubelets host machine
	// +optional
	PortworxVolume *PortworxVolumeSource `protobuf:"bytes,18,opt,name=portworxVolume" json:"portworxVolume,omitempty"`
	// ScaleIO represents a ScaleIO persistent volume attached and mounted on Kubernetes nodes.
	// +optional
	ScaleIO *ScaleIOPersistentVolumeSource `protobuf:"bytes,19,opt,name=scaleIO" json:"scaleIO,omitempty"`
	// Local represents directly-attached storage with node affinity
	// +optional
	Local *LocalVolumeSource `protobuf:"bytes,20,opt,name=local" json:"local,omitempty"`
	// StorageOS represents a StorageOS volume that is attached to the kubelet's host machine and mounted into the pod
	// More info: https://examples.k8s.io/volumes/storageos/README.md
	// +optional
	Storageos *StorageOSPersistentVolumeSource `protobuf:"bytes,21,opt,name=storageos" json:"storageos,omitempty"`
	// CSI represents storage that is handled by an external CSI driver (Beta feature).
	// +optional
	Csi *CSIPersistentVolumeSource `protobuf:"bytes,22,opt,name=csi" json:"csi,omitempty"`
}

func (m *PersistentVolumeSource) Reset()      { *m = PersistentVolumeSource{} }
func (*PersistentVolumeSource) ProtoMessage() {}
func (*PersistentVolumeSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{112}
}
func (m *PersistentVolumeSource) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PersistentVolumeSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PersistentVolumeSource.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PersistentVolumeSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PersistentVolumeSource.Merge(m, src)
}
func (m *PersistentVolumeSource) XXX_Size() int {
	return m.Size()
}
func (m *PersistentVolumeSource) XXX_DiscardUnknown() {
	xxx_messageInfo_PersistentVolumeSource.DiscardUnknown(m)
}

var xxx_messageInfo_PersistentVolumeSource proto.InternalMessageInfo

func (m *PersistentVolumeSource) GetGcePersistentDisk() *GCEPersistentDiskVolumeSource {
	if m != nil {
		return m.GcePersistentDisk
	}
	return nil
}

func (m *PersistentVolumeSource) GetAwsElasticBlockStore() *AWSElasticBlockStoreVolumeSource {
	if m != nil {
		return m.AwsElasticBlockStore
	}
	return nil
}

func (m *PersistentVolumeSource) GetHostPath() *HostPathVolumeSource {
	if m != nil {
		return m.HostPath
	}
	return nil
}

func (m *PersistentVolumeSource) GetGlusterfs() *GlusterfsPersistentVolumeSource {
	if m != nil {
		return m.Glusterfs
	}
	return nil
}

func (m *PersistentVolumeSource) GetNfs() *NFSVolumeSource {
	if m != nil {
		return m.Nfs
	}
	return nil
}

func (m *PersistentVolumeSource) GetRbd() *RBDPersistentVolumeSource {
	if m != nil {
		return m.Rbd
	}
	return nil
}

func (m *PersistentVolumeSource) GetIscsi() *ISCSIPersistentVolumeSource {
	if m != nil {
		return m.Iscsi
	}
	return nil
}

func (m *PersistentVolumeSource) GetCinder() *CinderPersistentVolumeSource {
	if m != nil {
		return m.Cinder
	}
	return nil
}

func (m *PersistentVolumeSource) GetCephfs() *CephFSPersistentVolumeSource {
	if m != nil {
		return m.Cephfs
	}
	return nil
}

func (m *PersistentVolumeSource) GetFc() *FCVolumeSource {
	if m != nil {
		return m.Fc
	}
	return nil
}

func (m *PersistentVolumeSource) GetFlocker() *FlockerVolumeSource {
	if m != nil {
		return m.Flocker
	}
	return nil
}

func (m *PersistentVolumeSource) GetFlexVolume() *FlexPersistentVolumeSource {
	if m != nil {
		return m.FlexVolume
	}
	return nil
}

func (m *PersistentVolumeSource) GetAzureFile() *AzureFilePersistentVolumeSource {
	if m != nil {
		return m.AzureFile
	}
	return nil
}

func (m *PersistentVolumeSource) GetVsphereVolume() *VsphereVirtualDiskVolumeSource {
	if m != nil {
		return m.VsphereVolume
	}
	return nil
}

func (m *PersistentVolumeSource) GetQuobyte() *QuobyteVolumeSource {
	if m != nil {
		return m.Quobyte
	}
	return nil
}

func (m *PersistentVolumeSource) GetAzureDisk() *AzureDiskVolumeSource {
	if m != nil {
		return m.AzureDisk
	}
	return nil
}

func (m *PersistentVolumeSource) GetPhotonPersistentDisk() *PhotonPersistentDiskVolumeSource {
	if m != nil {
		return m.PhotonPersistentDisk
	}
	return nil
}

func (m *PersistentVolumeSource) GetPortworxVolume() *PortworxVolumeSource {
	if m != nil {
		return m.PortworxVolume
	}
	return nil
}

func (m *PersistentVolumeSource) GetScaleIO() *ScaleIOPersistentVolumeSource {
	if m != nil {
		return m.ScaleIO
	}
	return nil
}

func (m *PersistentVolumeSource) GetLocal() *LocalVolumeSource {
	if m != nil {
		return m.Local
	}
	return nil
}

func (m *PersistentVolumeSource) GetStorageos() *StorageOSPersistentVolumeSource {
	if m != nil {
		return m.Storageos
	}
	return nil
}

func (m *PersistentVolumeSource) GetCsi() *CSIPersistentVolumeSource {
	if m != nil {
		return m.Csi
	}
	return nil
}

// PersistentVolumeSpec is the specification of a persistent volume.
type PersistentVolumeSpec struct {
	// A description of the persistent volume's resources and capacity.
	// More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#capacity
	// +optional
	Capacity map[string]*resource.Quantity `protobuf:"bytes,1,rep,name=capacity" json:"capacity,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// The actual volume backing the persistent volume.
	PersistentVolumeSource *PersistentVolumeSource `protobuf:"bytes,2,opt,name=persistentVolumeSource" json:"persistentVolumeSource,omitempty"`
	// AccessModes contains all ways the volume can be mounted.
	// More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes
	// +optional
	AccessModes []string `protobuf:"bytes,3,rep,name=accessModes" json:"accessModes,omitempty"`
	// ClaimRef is part of a bi-directional binding between PersistentVolume and PersistentVolumeClaim.
	// Expected to be non-nil when bound.
	// claim.VolumeName is the authoritative bind between PV and PVC.
	// More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#binding
	// +optional
	ClaimRef *ObjectReference `protobuf:"bytes,4,opt,name=claimRef" json:"claimRef,omitempty"`
	// What happens to a persistent volume when released from its claim.
	// Valid options are Retain (default for manually created PersistentVolumes), Delete (default
	// for dynamically provisioned PersistentVolumes), and Recycle (deprecated).
	// Recycle must be supported by the volume plugin underlying this PersistentVolume.
	// More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#reclaiming
	// +optional
	PersistentVolumeReclaimPolicy string `protobuf:"bytes,5,opt,name=persistentVolumeReclaimPolicy" json:"persistentVolumeReclaimPolicy"`
	// Name of StorageClass to which this persistent volume belongs. Empty value
	// means that this volume does not belong to any StorageClass.
	// +optional
	StorageClassName string `protobuf:"bytes,6,opt,name=storageClassName" json:"storageClassName"`
	// A list of mount options, e.g. ["ro", "soft"]. Not validated - mount will
	// simply fail if one is invalid.
	// More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes/#mount-options
	// +optional
	MountOptions []string `protobuf:"bytes,7,rep,name=mountOptions" json:"mountOptions,omitempty"`
	// volumeMode defines if a volume is intended to be used with a formatted filesystem
	// or to remain in raw block state. Value of Filesystem is implied when not included in spec.
	// This is a beta feature.
	// +optional
	VolumeMode string `protobuf:"bytes,8,opt,name=volumeMode" json:"volumeMode"`
	// NodeAffinity defines constraints that limit what nodes this volume can be accessed from.
	// This field influences the scheduling of pods that use this volume.
	// +optional
	NodeAffinity *VolumeNodeAffinity `protobuf:"bytes,9,opt,name=nodeAffinity" json:"nodeAffinity,omitempty"`
}

func (m *PersistentVolumeSpec) Reset()      { *m = PersistentVolumeSpec{} }
func (*PersistentVolumeSpec) ProtoMessage() {}
func (*PersistentVolumeSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{113}
}
func (m *PersistentVolumeSpec) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PersistentVolumeSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PersistentVolumeSpec.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PersistentVolumeSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PersistentVolumeSpec.Merge(m, src)
}
func (m *PersistentVolumeSpec) XXX_Size() int {
	return m.Size()
}
func (m *PersistentVolumeSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_PersistentVolumeSpec.DiscardUnknown(m)
}

var xxx_messageInfo_PersistentVolumeSpec proto.InternalMessageInfo

func (m *PersistentVolumeSpec) GetCapacity() map[string]*resource.Quantity {
	if m != nil {
		return m.Capacity
	}
	return nil
}

func (m *PersistentVolumeSpec) GetPersistentVolumeSource() *PersistentVolumeSource {
	if m != nil {
		return m.PersistentVolumeSource
	}
	return nil
}

func (m *PersistentVolumeSpec) GetAccessModes() []string {
	if m != nil {
		return m.AccessModes
	}
	return nil
}

func (m *PersistentVolumeSpec) GetClaimRef() *ObjectReference {
	if m != nil {
		return m.ClaimRef
	}
	return nil
}

func (m *PersistentVolumeSpec) GetPersistentVolumeReclaimPolicy() string {
	if m != nil {
		return m.PersistentVolumeReclaimPolicy
	}
	return ""
}

func (m *PersistentVolumeSpec) GetStorageClassName() string {
	if m != nil {
		return m.StorageClassName
	}
	return ""
}

func (m *PersistentVolumeSpec) GetMountOptions() []string {
	if m != nil {
		return m.MountOptions
	}
	return nil
}

func (m *PersistentVolumeSpec) GetVolumeMode() string {
	if m != nil {
		return m.VolumeMode
	}
	return ""
}

func (m *PersistentVolumeSpec) GetNodeAffinity() *VolumeNodeAffinity {
	if m != nil {
		return m.NodeAffinity
	}
	return nil
}

// PersistentVolumeStatus is the current status of a persistent volume.
type PersistentVolumeStatus struct {
	// Phase indicates if a volume is available, bound to a claim, or released by a claim.
	// More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#phase
	// +optional
	Phase string `protobuf:"bytes,1,opt,name=phase" json:"phase"`
	// A human-readable message indicating details about why the volume is in this state.
	// +optional
	Message string `protobuf:"bytes,2,opt,name=message" json:"message"`
	// Reason is a brief CamelCase string that describes any failure and is meant
	// for machine parsing and tidy display in the CLI.
	// +optional
	Reason string `protobuf:"bytes,3,opt,name=reason" json:"reason"`
}

func (m *PersistentVolumeStatus) Reset()      { *m = PersistentVolumeStatus{} }
func (*PersistentVolumeStatus) ProtoMessage() {}
func (*PersistentVolumeStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{114}
}
func (m *PersistentVolumeStatus) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PersistentVolumeStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PersistentVolumeStatus.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PersistentVolumeStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PersistentVolumeStatus.Merge(m, src)
}
func (m *PersistentVolumeStatus) XXX_Size() int {
	return m.Size()
}
func (m *PersistentVolumeStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_PersistentVolumeStatus.DiscardUnknown(m)
}

var xxx_messageInfo_PersistentVolumeStatus proto.InternalMessageInfo

func (m *PersistentVolumeStatus) GetPhase() string {
	if m != nil {
		return m.Phase
	}
	return ""
}

func (m *PersistentVolumeStatus) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

func (m *PersistentVolumeStatus) GetReason() string {
	if m != nil {
		return m.Reason
	}
	return ""
}

// Represents a Photon Controller persistent disk resource.
type PhotonPersistentDiskVolumeSource struct {
	// ID that identifies Photon Controller persistent disk
	PdID string `protobuf:"bytes,1,opt,name=pdID" json:"pdID"`
	// Filesystem type to mount.
	// Must be a filesystem type supported by the host operating system.
	// Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
	FsType string `protobuf:"bytes,2,opt,name=fsType" json:"fsType"`
}

func (m *PhotonPersistentDiskVolumeSource) Reset()      { *m = PhotonPersistentDiskVolumeSource{} }
func (*PhotonPersistentDiskVolumeSource) ProtoMessage() {}
func (*PhotonPersistentDiskVolumeSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{115}
}
func (m *PhotonPersistentDiskVolumeSource) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PhotonPersistentDiskVolumeSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PhotonPersistentDiskVolumeSource.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PhotonPersistentDiskVolumeSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PhotonPersistentDiskVolumeSource.Merge(m, src)
}
func (m *PhotonPersistentDiskVolumeSource) XXX_Size() int {
	return m.Size()
}
func (m *PhotonPersistentDiskVolumeSource) XXX_DiscardUnknown() {
	xxx_messageInfo_PhotonPersistentDiskVolumeSource.DiscardUnknown(m)
}

var xxx_messageInfo_PhotonPersistentDiskVolumeSource proto.InternalMessageInfo

func (m *PhotonPersistentDiskVolumeSource) GetPdID() string {
	if m != nil {
		return m.PdID
	}
	return ""
}

func (m *PhotonPersistentDiskVolumeSource) GetFsType() string {
	if m != nil {
		return m.FsType
	}
	return ""
}

// Pod is a collection of containers that can run on a host. This resource is created
// by clients and scheduled onto hosts.
type Pod struct {
	// Standard object's metadata.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
	// +optional
	Metadata *v1.ObjectMeta `protobuf:"bytes,1,opt,name=metadata" json:"metadata,omitempty"`
	// Specification of the desired behavior of the pod.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status
	// +optional
	Spec *PodSpec `protobuf:"bytes,2,opt,name=spec" json:"spec,omitempty"`
	// Most recently observed status of the pod.
	// This data may not be up to date.
	// Populated by the system.
	// Read-only.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status
	// +optional
	Status *PodStatus `protobuf:"bytes,3,opt,name=status" json:"status,omitempty"`
}

func (m *Pod) Reset()      { *m = Pod{} }
func (*Pod) ProtoMessage() {}
func (*Pod) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{116}
}
func (m *Pod) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Pod) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Pod.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Pod) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Pod.Merge(m, src)
}
func (m *Pod) XXX_Size() int {
	return m.Size()
}
func (m *Pod) XXX_DiscardUnknown() {
	xxx_messageInfo_Pod.DiscardUnknown(m)
}

var xxx_messageInfo_Pod proto.InternalMessageInfo

func (m *Pod) GetMetadata() *v1.ObjectMeta {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *Pod) GetSpec() *PodSpec {
	if m != nil {
		return m.Spec
	}
	return nil
}

func (m *Pod) GetStatus() *PodStatus {
	if m != nil {
		return m.Status
	}
	return nil
}

// Pod affinity is a group of inter pod affinity scheduling rules.
type PodAffinity struct {
	// If the affinity requirements specified by this field are not met at
	// scheduling time, the pod will not be scheduled onto the node.
	// If the affinity requirements specified by this field cease to be met
	// at some point during pod execution (e.g. due to a pod label update), the
	// system may or may not try to eventually evict the pod from its node.
	// When there are multiple elements, the lists of nodes corresponding to each
	// podAffinityTerm are intersected, i.e. all terms must be satisfied.
	// +optional
	RequiredDuringSchedulingIgnoredDuringExecution []*PodAffinityTerm `protobuf:"bytes,1,rep,name=requiredDuringSchedulingIgnoredDuringExecution" json:"requiredDuringSchedulingIgnoredDuringExecution,omitempty"`
	// The scheduler will prefer to schedule pods to nodes that satisfy
	// the affinity expressions specified by this field, but it may choose
	// a node that violates one or more of the expressions. The node that is
	// most preferred is the one with the greatest sum of weights, i.e.
	// for each node that meets all of the scheduling requirements (resource
	// request, requiredDuringScheduling affinity expressions, etc.),
	// compute a sum by iterating through the elements of this field and adding
	// "weight" to the sum if the node has pods which matches the corresponding podAffinityTerm; the
	// node(s) with the highest sum are the most preferred.
	// +optional
	PreferredDuringSchedulingIgnoredDuringExecution []*WeightedPodAffinityTerm `protobuf:"bytes,2,rep,name=preferredDuringSchedulingIgnoredDuringExecution" json:"preferredDuringSchedulingIgnoredDuringExecution,omitempty"`
}

func (m *PodAffinity) Reset()      { *m = PodAffinity{} }
func (*PodAffinity) ProtoMessage() {}
func (*PodAffinity) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{117}
}
func (m *PodAffinity) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PodAffinity) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PodAffinity.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PodAffinity) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PodAffinity.Merge(m, src)
}
func (m *PodAffinity) XXX_Size() int {
	return m.Size()
}
func (m *PodAffinity) XXX_DiscardUnknown() {
	xxx_messageInfo_PodAffinity.DiscardUnknown(m)
}

var xxx_messageInfo_PodAffinity proto.InternalMessageInfo

func (m *PodAffinity) GetRequiredDuringSchedulingIgnoredDuringExecution() []*PodAffinityTerm {
	if m != nil {
		return m.RequiredDuringSchedulingIgnoredDuringExecution
	}
	return nil
}

func (m *PodAffinity) GetPreferredDuringSchedulingIgnoredDuringExecution() []*WeightedPodAffinityTerm {
	if m != nil {
		return m.PreferredDuringSchedulingIgnoredDuringExecution
	}
	return nil
}

// Defines a set of pods (namely those matching the labelSelector
// relative to the given namespace(s)) that this pod should be
// co-located (affinity) or not co-located (anti-affinity) with,
// where co-located is defined as running on a node whose value of
// the label with key <topologyKey> matches that of any node on which
// a pod of the set of pods is running
type PodAffinityTerm struct {
	// A label query over a set of resources, in this case pods.
	// +optional
	LabelSelector *v1.LabelSelector `protobuf:"bytes,1,opt,name=labelSelector" json:"labelSelector,omitempty"`
	// namespaces specifies which namespaces the labelSelector applies to (matches against);
	// null or empty list means "this pod's namespace"
	// +optional
	Namespaces []string `protobuf:"bytes,2,rep,name=namespaces" json:"namespaces,omitempty"`
	// This pod should be co-located (affinity) or not co-located (anti-affinity) with the pods matching
	// the labelSelector in the specified namespaces, where co-located is defined as running on a node
	// whose value of the label with key topologyKey matches that of any node on which any of the
	// selected pods is running.
	// Empty topologyKey is not allowed.
	TopologyKey string `protobuf:"bytes,3,opt,name=topologyKey" json:"topologyKey"`
}

func (m *PodAffinityTerm) Reset()      { *m = PodAffinityTerm{} }
func (*PodAffinityTerm) ProtoMessage() {}
func (*PodAffinityTerm) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{118}
}
func (m *PodAffinityTerm) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PodAffinityTerm) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PodAffinityTerm.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PodAffinityTerm) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PodAffinityTerm.Merge(m, src)
}
func (m *PodAffinityTerm) XXX_Size() int {
	return m.Size()
}
func (m *PodAffinityTerm) XXX_DiscardUnknown() {
	xxx_messageInfo_PodAffinityTerm.DiscardUnknown(m)
}

var xxx_messageInfo_PodAffinityTerm proto.InternalMessageInfo

func (m *PodAffinityTerm) GetLabelSelector() *v1.LabelSelector {
	if m != nil {
		return m.LabelSelector
	}
	return nil
}

func (m *PodAffinityTerm) GetNamespaces() []string {
	if m != nil {
		return m.Namespaces
	}
	return nil
}

func (m *PodAffinityTerm) GetTopologyKey() string {
	if m != nil {
		return m.TopologyKey
	}
	return ""
}

// Pod anti affinity is a group of inter pod anti affinity scheduling rules.
type PodAntiAffinity struct {
	// If the anti-affinity requirements specified by this field are not met at
	// scheduling time, the pod will not be scheduled onto the node.
	// If the anti-affinity requirements specified by this field cease to be met
	// at some point during pod execution (e.g. due to a pod label update), the
	// system may or may not try to eventually evict the pod from its node.
	// When there are multiple elements, the lists of nodes corresponding to each
	// podAffinityTerm are intersected, i.e. all terms must be satisfied.
	// +optional
	RequiredDuringSchedulingIgnoredDuringExecution []*PodAffinityTerm `protobuf:"bytes,1,rep,name=requiredDuringSchedulingIgnoredDuringExecution" json:"requiredDuringSchedulingIgnoredDuringExecution,omitempty"`
	// The scheduler will prefer to schedule pods to nodes that satisfy
	// the anti-affinity expressions specified by this field, but it may choose
	// a node that violates one or more of the expressions. The node that is
	// most preferred is the one with the greatest sum of weights, i.e.
	// for each node that meets all of the scheduling requirements (resource
	// request, requiredDuringScheduling anti-affinity expressions, etc.),
	// compute a sum by iterating through the elements of this field and adding
	// "weight" to the sum if the node has pods which matches the corresponding podAffinityTerm; the
	// node(s) with the highest sum are the most preferred.
	// +optional
	PreferredDuringSchedulingIgnoredDuringExecution []*WeightedPodAffinityTerm `protobuf:"bytes,2,rep,name=preferredDuringSchedulingIgnoredDuringExecution" json:"preferredDuringSchedulingIgnoredDuringExecution,omitempty"`
}

func (m *PodAntiAffinity) Reset()      { *m = PodAntiAffinity{} }
func (*PodAntiAffinity) ProtoMessage() {}
func (*PodAntiAffinity) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{119}
}
func (m *PodAntiAffinity) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PodAntiAffinity) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PodAntiAffinity.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PodAntiAffinity) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PodAntiAffinity.Merge(m, src)
}
func (m *PodAntiAffinity) XXX_Size() int {
	return m.Size()
}
func (m *PodAntiAffinity) XXX_DiscardUnknown() {
	xxx_messageInfo_PodAntiAffinity.DiscardUnknown(m)
}

var xxx_messageInfo_PodAntiAffinity proto.InternalMessageInfo

func (m *PodAntiAffinity) GetRequiredDuringSchedulingIgnoredDuringExecution() []*PodAffinityTerm {
	if m != nil {
		return m.RequiredDuringSchedulingIgnoredDuringExecution
	}
	return nil
}

func (m *PodAntiAffinity) GetPreferredDuringSchedulingIgnoredDuringExecution() []*WeightedPodAffinityTerm {
	if m != nil {
		return m.PreferredDuringSchedulingIgnoredDuringExecution
	}
	return nil
}

// PodAttachOptions is the query options to a Pod's remote attach call.
// ---
// TODO: merge w/ PodExecOptions below for stdin, stdout, etc
// and also when we cut V2, we should export a "StreamOptions" or somesuch that contains Stdin, Stdout, Stder and TTY
type PodAttachOptions struct {
	// Stdin if true, redirects the standard input stream of the pod for this call.
	// Defaults to false.
	// +optional
	Stdin bool `protobuf:"varint,1,opt,name=stdin" json:"stdin"`
	// Stdout if true indicates that stdout is to be redirected for the attach call.
	// Defaults to true.
	// +optional
	Stdout bool `protobuf:"varint,2,opt,name=stdout" json:"stdout"`
	// Stderr if true indicates that stderr is to be redirected for the attach call.
	// Defaults to true.
	// +optional
	Stderr bool `protobuf:"varint,3,opt,name=stderr" json:"stderr"`
	// TTY if true indicates that a tty will be allocated for the attach call.
	// This is passed through the container runtime so the tty
	// is allocated on the worker node by the container runtime.
	// Defaults to false.
	// +optional
	Tty bool `protobuf:"varint,4,opt,name=tty" json:"tty"`
	// The container in which to execute the command.
	// Defaults to only container if there is only one container in the pod.
	// +optional
	Container string `protobuf:"bytes,5,opt,name=container" json:"container"`
}

func (m *PodAttachOptions) Reset()      { *m = PodAttachOptions{} }
func (*PodAttachOptions) ProtoMessage() {}
func (*PodAttachOptions) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{120}
}
func (m *PodAttachOptions) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PodAttachOptions) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PodAttachOptions.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PodAttachOptions) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PodAttachOptions.Merge(m, src)
}
func (m *PodAttachOptions) XXX_Size() int {
	return m.Size()
}
func (m *PodAttachOptions) XXX_DiscardUnknown() {
	xxx_messageInfo_PodAttachOptions.DiscardUnknown(m)
}

var xxx_messageInfo_PodAttachOptions proto.InternalMessageInfo

func (m *PodAttachOptions) GetStdin() bool {
	if m != nil {
		return m.Stdin
	}
	return false
}

func (m *PodAttachOptions) GetStdout() bool {
	if m != nil {
		return m.Stdout
	}
	return false
}

func (m *PodAttachOptions) GetStderr() bool {
	if m != nil {
		return m.Stderr
	}
	return false
}

func (m *PodAttachOptions) GetTty() bool {
	if m != nil {
		return m.Tty
	}
	return false
}

func (m *PodAttachOptions) GetContainer() string {
	if m != nil {
		return m.Container
	}
	return ""
}

// PodCondition contains details for the current condition of this pod.
type PodCondition struct {
	// Type is the type of the condition.
	// More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#pod-conditions
	Type string `protobuf:"bytes,1,opt,name=type" json:"type"`
	// Status is the status of the condition.
	// Can be True, False, Unknown.
	// More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#pod-conditions
	Status string `protobuf:"bytes,2,opt,name=status" json:"status"`
	// Last time we probed the condition.
	// +optional
	LastProbeTime *v1.Time `protobuf:"bytes,3,opt,name=lastProbeTime" json:"lastProbeTime,omitempty"`
	// Last time the condition transitioned from one status to another.
	// +optional
	LastTransitionTime *v1.Time `protobuf:"bytes,4,opt,name=lastTransitionTime" json:"lastTransitionTime,omitempty"`
	// Unique, one-word, CamelCase reason for the condition's last transition.
	// +optional
	Reason string `protobuf:"bytes,5,opt,name=reason" json:"reason"`
	// Human-readable message indicating details about last transition.
	// +optional
	Message string `protobuf:"bytes,6,opt,name=message" json:"message"`
}

func (m *PodCondition) Reset()      { *m = PodCondition{} }
func (*PodCondition) ProtoMessage() {}
func (*PodCondition) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{121}
}
func (m *PodCondition) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PodCondition) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PodCondition.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PodCondition) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PodCondition.Merge(m, src)
}
func (m *PodCondition) XXX_Size() int {
	return m.Size()
}
func (m *PodCondition) XXX_DiscardUnknown() {
	xxx_messageInfo_PodCondition.DiscardUnknown(m)
}

var xxx_messageInfo_PodCondition proto.InternalMessageInfo

func (m *PodCondition) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *PodCondition) GetStatus() string {
	if m != nil {
		return m.Status
	}
	return ""
}

func (m *PodCondition) GetLastProbeTime() *v1.Time {
	if m != nil {
		return m.LastProbeTime
	}
	return nil
}

func (m *PodCondition) GetLastTransitionTime() *v1.Time {
	if m != nil {
		return m.LastTransitionTime
	}
	return nil
}

func (m *PodCondition) GetReason() string {
	if m != nil {
		return m.Reason
	}
	return ""
}

func (m *PodCondition) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

// PodDNSConfig defines the DNS parameters of a pod in addition to
// those generated from DNSPolicy.
type PodDNSConfig struct {
	// A list of DNS name server IP addresses.
	// This will be appended to the base nameservers generated from DNSPolicy.
	// Duplicated nameservers will be removed.
	// +optional
	Nameservers []string `protobuf:"bytes,1,rep,name=nameservers" json:"nameservers,omitempty"`
	// A list of DNS search domains for host-name lookup.
	// This will be appended to the base search paths generated from DNSPolicy.
	// Duplicated search paths will be removed.
	// +optional
	Searches []string `protobuf:"bytes,2,rep,name=searches" json:"searches,omitempty"`
	// A list of DNS resolver options.
	// This will be merged with the base options generated from DNSPolicy.
	// Duplicated entries will be removed. Resolution options given in Options
	// will override those that appear in the base DNSPolicy.
	// +optional
	Options []*PodDNSConfigOption `protobuf:"bytes,3,rep,name=options" json:"options,omitempty"`
}

func (m *PodDNSConfig) Reset()      { *m = PodDNSConfig{} }
func (*PodDNSConfig) ProtoMessage() {}
func (*PodDNSConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{122}
}
func (m *PodDNSConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PodDNSConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PodDNSConfig.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PodDNSConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PodDNSConfig.Merge(m, src)
}
func (m *PodDNSConfig) XXX_Size() int {
	return m.Size()
}
func (m *PodDNSConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_PodDNSConfig.DiscardUnknown(m)
}

var xxx_messageInfo_PodDNSConfig proto.InternalMessageInfo

func (m *PodDNSConfig) GetNameservers() []string {
	if m != nil {
		return m.Nameservers
	}
	return nil
}

func (m *PodDNSConfig) GetSearches() []string {
	if m != nil {
		return m.Searches
	}
	return nil
}

func (m *PodDNSConfig) GetOptions() []*PodDNSConfigOption {
	if m != nil {
		return m.Options
	}
	return nil
}

// PodDNSConfigOption defines DNS resolver options of a pod.
type PodDNSConfigOption struct {
	// Required.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name"`
	// +optional
	Value string `protobuf:"bytes,2,opt,name=value" json:"value"`
}

func (m *PodDNSConfigOption) Reset()      { *m = PodDNSConfigOption{} }
func (*PodDNSConfigOption) ProtoMessage() {}
func (*PodDNSConfigOption) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{123}
}
func (m *PodDNSConfigOption) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PodDNSConfigOption) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PodDNSConfigOption.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PodDNSConfigOption) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PodDNSConfigOption.Merge(m, src)
}
func (m *PodDNSConfigOption) XXX_Size() int {
	return m.Size()
}
func (m *PodDNSConfigOption) XXX_DiscardUnknown() {
	xxx_messageInfo_PodDNSConfigOption.DiscardUnknown(m)
}

var xxx_messageInfo_PodDNSConfigOption proto.InternalMessageInfo

func (m *PodDNSConfigOption) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *PodDNSConfigOption) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

// PodExecOptions is the query options to a Pod's remote exec call.
// ---
// TODO: This is largely identical to PodAttachOptions above, make sure they stay in sync and see about merging
// and also when we cut V2, we should export a "StreamOptions" or somesuch that contains Stdin, Stdout, Stder and TTY
type PodExecOptions struct {
	// Redirect the standard input stream of the pod for this call.
	// Defaults to false.
	// +optional
	Stdin bool `protobuf:"varint,1,opt,name=stdin" json:"stdin"`
	// Redirect the standard output stream of the pod for this call.
	// Defaults to true.
	// +optional
	Stdout bool `protobuf:"varint,2,opt,name=stdout" json:"stdout"`
	// Redirect the standard error stream of the pod for this call.
	// Defaults to true.
	// +optional
	Stderr bool `protobuf:"varint,3,opt,name=stderr" json:"stderr"`
	// TTY if true indicates that a tty will be allocated for the exec call.
	// Defaults to false.
	// +optional
	Tty bool `protobuf:"varint,4,opt,name=tty" json:"tty"`
	// Container in which to execute the command.
	// Defaults to only container if there is only one container in the pod.
	// +optional
	Container string `protobuf:"bytes,5,opt,name=container" json:"container"`
	// Command is the remote command to execute. argv array. Not executed within a shell.
	Command []string `protobuf:"bytes,6,rep,name=command" json:"command,omitempty"`
}

func (m *PodExecOptions) Reset()      { *m = PodExecOptions{} }
func (*PodExecOptions) ProtoMessage() {}
func (*PodExecOptions) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{124}
}
func (m *PodExecOptions) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PodExecOptions) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PodExecOptions.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PodExecOptions) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PodExecOptions.Merge(m, src)
}
func (m *PodExecOptions) XXX_Size() int {
	return m.Size()
}
func (m *PodExecOptions) XXX_DiscardUnknown() {
	xxx_messageInfo_PodExecOptions.DiscardUnknown(m)
}

var xxx_messageInfo_PodExecOptions proto.InternalMessageInfo

func (m *PodExecOptions) GetStdin() bool {
	if m != nil {
		return m.Stdin
	}
	return false
}

func (m *PodExecOptions) GetStdout() bool {
	if m != nil {
		return m.Stdout
	}
	return false
}

func (m *PodExecOptions) GetStderr() bool {
	if m != nil {
		return m.Stderr
	}
	return false
}

func (m *PodExecOptions) GetTty() bool {
	if m != nil {
		return m.Tty
	}
	return false
}

func (m *PodExecOptions) GetContainer() string {
	if m != nil {
		return m.Container
	}
	return ""
}

func (m *PodExecOptions) GetCommand() []string {
	if m != nil {
		return m.Command
	}
	return nil
}

// IP address information for entries in the (plural) PodIPs field.
// Each entry includes:
//    IP: An IP address allocated to the pod. Routable at least within the cluster.
type PodIP struct {
	// ip is an IP address (IPv4 or IPv6) assigned to the pod
	Ip string `protobuf:"bytes,1,opt,name=ip" json:"ip"`
}

func (m *PodIP) Reset()      { *m = PodIP{} }
func (*PodIP) ProtoMessage() {}
func (*PodIP) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{125}
}
func (m *PodIP) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PodIP) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PodIP.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PodIP) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PodIP.Merge(m, src)
}
func (m *PodIP) XXX_Size() int {
	return m.Size()
}
func (m *PodIP) XXX_DiscardUnknown() {
	xxx_messageInfo_PodIP.DiscardUnknown(m)
}

var xxx_messageInfo_PodIP proto.InternalMessageInfo

func (m *PodIP) GetIp() string {
	if m != nil {
		return m.Ip
	}
	return ""
}

// PodList is a list of Pods.
type PodList struct {
	// Standard list metadata.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds
	// +optional
	Metadata *v1.ListMeta `protobuf:"bytes,1,opt,name=metadata" json:"metadata,omitempty"`
	// List of pods.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md
	Items []*Pod `protobuf:"bytes,2,rep,name=items" json:"items,omitempty"`
}

func (m *PodList) Reset()      { *m = PodList{} }
func (*PodList) ProtoMessage() {}
func (*PodList) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{126}
}
func (m *PodList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PodList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PodList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PodList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PodList.Merge(m, src)
}
func (m *PodList) XXX_Size() int {
	return m.Size()
}
func (m *PodList) XXX_DiscardUnknown() {
	xxx_messageInfo_PodList.DiscardUnknown(m)
}

var xxx_messageInfo_PodList proto.InternalMessageInfo

func (m *PodList) GetMetadata() *v1.ListMeta {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *PodList) GetItems() []*Pod {
	if m != nil {
		return m.Items
	}
	return nil
}

// PodLogOptions is the query options for a Pod's logs REST call.
type PodLogOptions struct {
	// The container for which to stream logs. Defaults to only container if there is one container in the pod.
	// +optional
	Container string `protobuf:"bytes,1,opt,name=container" json:"container"`
	// Follow the log stream of the pod. Defaults to false.
	// +optional
	Follow bool `protobuf:"varint,2,opt,name=follow" json:"follow"`
	// Return previous terminated container logs. Defaults to false.
	// +optional
	Previous bool `protobuf:"varint,3,opt,name=previous" json:"previous"`
	// A relative time in seconds before the current time from which to show logs. If this value
	// precedes the time a pod was started, only logs since the pod start will be returned.
	// If this value is in the future, no logs will be returned.
	// Only one of sinceSeconds or sinceTime may be specified.
	// +optional
	SinceSeconds int64 `protobuf:"varint,4,opt,name=sinceSeconds" json:"sinceSeconds"`
	// An RFC3339 timestamp from which to show logs. If this value
	// precedes the time a pod was started, only logs since the pod start will be returned.
	// If this value is in the future, no logs will be returned.
	// Only one of sinceSeconds or sinceTime may be specified.
	// +optional
	SinceTime *v1.Time `protobuf:"bytes,5,opt,name=sinceTime" json:"sinceTime,omitempty"`
	// If true, add an RFC3339 or RFC3339Nano timestamp at the beginning of every line
	// of log output. Defaults to false.
	// +optional
	Timestamps bool `protobuf:"varint,6,opt,name=timestamps" json:"timestamps"`
	// If set, the number of lines from the end of the logs to show. If not specified,
	// logs are shown from the creation of the container or sinceSeconds or sinceTime
	// +optional
	TailLines int64 `protobuf:"varint,7,opt,name=tailLines" json:"tailLines"`
	// If set, the number of bytes to read from the server before terminating the
	// log output. This may not display a complete final line of logging, and may return
	// slightly more or slightly less than the specified limit.
	// +optional
	LimitBytes int64 `protobuf:"varint,8,opt,name=limitBytes" json:"limitBytes"`
}

func (m *PodLogOptions) Reset()      { *m = PodLogOptions{} }
func (*PodLogOptions) ProtoMessage() {}
func (*PodLogOptions) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{127}
}
func (m *PodLogOptions) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PodLogOptions) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PodLogOptions.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PodLogOptions) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PodLogOptions.Merge(m, src)
}
func (m *PodLogOptions) XXX_Size() int {
	return m.Size()
}
func (m *PodLogOptions) XXX_DiscardUnknown() {
	xxx_messageInfo_PodLogOptions.DiscardUnknown(m)
}

var xxx_messageInfo_PodLogOptions proto.InternalMessageInfo

func (m *PodLogOptions) GetContainer() string {
	if m != nil {
		return m.Container
	}
	return ""
}

func (m *PodLogOptions) GetFollow() bool {
	if m != nil {
		return m.Follow
	}
	return false
}

func (m *PodLogOptions) GetPrevious() bool {
	if m != nil {
		return m.Previous
	}
	return false
}

func (m *PodLogOptions) GetSinceSeconds() int64 {
	if m != nil {
		return m.SinceSeconds
	}
	return 0
}

func (m *PodLogOptions) GetSinceTime() *v1.Time {
	if m != nil {
		return m.SinceTime
	}
	return nil
}

func (m *PodLogOptions) GetTimestamps() bool {
	if m != nil {
		return m.Timestamps
	}
	return false
}

func (m *PodLogOptions) GetTailLines() int64 {
	if m != nil {
		return m.TailLines
	}
	return 0
}

func (m *PodLogOptions) GetLimitBytes() int64 {
	if m != nil {
		return m.LimitBytes
	}
	return 0
}

// PodPortForwardOptions is the query options to a Pod's port forward call
// when using WebSockets.
// The `port` query parameter must specify the port or
// ports (comma separated) to forward over.
// Port forwarding over SPDY does not use these options. It requires the port
// to be passed in the `port` header as part of request.
type PodPortForwardOptions struct {
	// List of ports to forward
	// Required when using WebSockets
	// +optional
	Ports []int32 `protobuf:"varint,1,rep,name=ports" json:"ports,omitempty"`
}

func (m *PodPortForwardOptions) Reset()      { *m = PodPortForwardOptions{} }
func (*PodPortForwardOptions) ProtoMessage() {}
func (*PodPortForwardOptions) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{128}
}
func (m *PodPortForwardOptions) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PodPortForwardOptions) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PodPortForwardOptions.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PodPortForwardOptions) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PodPortForwardOptions.Merge(m, src)
}
func (m *PodPortForwardOptions) XXX_Size() int {
	return m.Size()
}
func (m *PodPortForwardOptions) XXX_DiscardUnknown() {
	xxx_messageInfo_PodPortForwardOptions.DiscardUnknown(m)
}

var xxx_messageInfo_PodPortForwardOptions proto.InternalMessageInfo

func (m *PodPortForwardOptions) GetPorts() []int32 {
	if m != nil {
		return m.Ports
	}
	return nil
}

// PodProxyOptions is the query options to a Pod's proxy call.
type PodProxyOptions struct {
	// Path is the URL path to use for the current proxy request to pod.
	// +optional
	Path string `protobuf:"bytes,1,opt,name=path" json:"path"`
}

func (m *PodProxyOptions) Reset()      { *m = PodProxyOptions{} }
func (*PodProxyOptions) ProtoMessage() {}
func (*PodProxyOptions) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{129}
}
func (m *PodProxyOptions) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PodProxyOptions) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PodProxyOptions.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PodProxyOptions) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PodProxyOptions.Merge(m, src)
}
func (m *PodProxyOptions) XXX_Size() int {
	return m.Size()
}
func (m *PodProxyOptions) XXX_DiscardUnknown() {
	xxx_messageInfo_PodProxyOptions.DiscardUnknown(m)
}

var xxx_messageInfo_PodProxyOptions proto.InternalMessageInfo

func (m *PodProxyOptions) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

// PodReadinessGate contains the reference to a pod condition
type PodReadinessGate struct {
	// ConditionType refers to a condition in the pod's condition list with matching type.
	ConditionType string `protobuf:"bytes,1,opt,name=conditionType" json:"conditionType"`
}

func (m *PodReadinessGate) Reset()      { *m = PodReadinessGate{} }
func (*PodReadinessGate) ProtoMessage() {}
func (*PodReadinessGate) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{130}
}
func (m *PodReadinessGate) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PodReadinessGate) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PodReadinessGate.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PodReadinessGate) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PodReadinessGate.Merge(m, src)
}
func (m *PodReadinessGate) XXX_Size() int {
	return m.Size()
}
func (m *PodReadinessGate) XXX_DiscardUnknown() {
	xxx_messageInfo_PodReadinessGate.DiscardUnknown(m)
}

var xxx_messageInfo_PodReadinessGate proto.InternalMessageInfo

func (m *PodReadinessGate) GetConditionType() string {
	if m != nil {
		return m.ConditionType
	}
	return ""
}

// PodSecurityContext holds pod-level security attributes and common container settings.
// Some fields are also present in container.securityContext.  Field values of
// container.securityContext take precedence over field values of PodSecurityContext.
type PodSecurityContext struct {
	// The SELinux context to be applied to all containers.
	// If unspecified, the container runtime will allocate a random SELinux context for each
	// container.  May also be set in SecurityContext.  If set in
	// both SecurityContext and PodSecurityContext, the value specified in SecurityContext
	// takes precedence for that container.
	// +optional
	SeLinuxOptions *SELinuxOptions `protobuf:"bytes,1,opt,name=seLinuxOptions" json:"seLinuxOptions,omitempty"`
	// The Windows specific settings applied to all containers.
	// If unspecified, the options within a container's SecurityContext will be used.
	// If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.
	// +optional
	WindowsOptions *WindowsSecurityContextOptions `protobuf:"bytes,8,opt,name=windowsOptions" json:"windowsOptions,omitempty"`
	// The UID to run the entrypoint of the container process.
	// Defaults to user specified in image metadata if unspecified.
	// May also be set in SecurityContext.  If set in both SecurityContext and
	// PodSecurityContext, the value specified in SecurityContext takes precedence
	// for that container.
	// +optional
	RunAsUser int64 `protobuf:"varint,2,opt,name=runAsUser" json:"runAsUser"`
	// The GID to run the entrypoint of the container process.
	// Uses runtime default if unset.
	// May also be set in SecurityContext.  If set in both SecurityContext and
	// PodSecurityContext, the value specified in SecurityContext takes precedence
	// for that container.
	// +optional
	RunAsGroup int64 `protobuf:"varint,6,opt,name=runAsGroup" json:"runAsGroup"`
	// Indicates that the container must run as a non-root user.
	// If true, the Kubelet will validate the image at runtime to ensure that it
	// does not run as UID 0 (root) and fail to start the container if it does.
	// If unset or false, no such validation will be performed.
	// May also be set in SecurityContext.  If set in both SecurityContext and
	// PodSecurityContext, the value specified in SecurityContext takes precedence.
	// +optional
	RunAsNonRoot bool `protobuf:"varint,3,opt,name=runAsNonRoot" json:"runAsNonRoot"`
	// A list of groups applied to the first process run in each container, in addition
	// to the container's primary GID.  If unspecified, no groups will be added to
	// any container.
	// +optional
	SupplementalGroups []int64 `protobuf:"varint,4,rep,name=supplementalGroups" json:"supplementalGroups,omitempty"`
	// A special supplemental group that applies to all containers in a pod.
	// Some volume types allow the Kubelet to change the ownership of that volume
	// to be owned by the pod:
	//
	// 1. The owning GID will be the FSGroup
	// 2. The setgid bit is set (new files created in the volume will be owned by FSGroup)
	// 3. The permission bits are OR'd with rw-rw----
	//
	// If unset, the Kubelet will not modify the ownership and permissions of any volume.
	// +optional
	FsGroup int64 `protobuf:"varint,5,opt,name=fsGroup" json:"fsGroup"`
	// Sysctls hold a list of namespaced sysctls used for the pod. Pods with unsupported
	// sysctls (by the container runtime) might fail to launch.
	// +optional
	Sysctls []*Sysctl `protobuf:"bytes,7,rep,name=sysctls" json:"sysctls,omitempty"`
}

func (m *PodSecurityContext) Reset()      { *m = PodSecurityContext{} }
func (*PodSecurityContext) ProtoMessage() {}
func (*PodSecurityContext) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{131}
}
func (m *PodSecurityContext) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PodSecurityContext) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PodSecurityContext.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PodSecurityContext) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PodSecurityContext.Merge(m, src)
}
func (m *PodSecurityContext) XXX_Size() int {
	return m.Size()
}
func (m *PodSecurityContext) XXX_DiscardUnknown() {
	xxx_messageInfo_PodSecurityContext.DiscardUnknown(m)
}

var xxx_messageInfo_PodSecurityContext proto.InternalMessageInfo

func (m *PodSecurityContext) GetSeLinuxOptions() *SELinuxOptions {
	if m != nil {
		return m.SeLinuxOptions
	}
	return nil
}

func (m *PodSecurityContext) GetWindowsOptions() *WindowsSecurityContextOptions {
	if m != nil {
		return m.WindowsOptions
	}
	return nil
}

func (m *PodSecurityContext) GetRunAsUser() int64 {
	if m != nil {
		return m.RunAsUser
	}
	return 0
}

func (m *PodSecurityContext) GetRunAsGroup() int64 {
	if m != nil {
		return m.RunAsGroup
	}
	return 0
}

func (m *PodSecurityContext) GetRunAsNonRoot() bool {
	if m != nil {
		return m.RunAsNonRoot
	}
	return false
}

func (m *PodSecurityContext) GetSupplementalGroups() []int64 {
	if m != nil {
		return m.SupplementalGroups
	}
	return nil
}

func (m *PodSecurityContext) GetFsGroup() int64 {
	if m != nil {
		return m.FsGroup
	}
	return 0
}

func (m *PodSecurityContext) GetSysctls() []*Sysctl {
	if m != nil {
		return m.Sysctls
	}
	return nil
}

// Describes the class of pods that should avoid this node.
// Exactly one field should be set.
type PodSignature struct {
	// Reference to controller whose pods should avoid this node.
	// +optional
	PodController *v1.OwnerReference `protobuf:"bytes,1,opt,name=podController" json:"podController,omitempty"`
}

func (m *PodSignature) Reset()      { *m = PodSignature{} }
func (*PodSignature) ProtoMessage() {}
func (*PodSignature) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{132}
}
func (m *PodSignature) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PodSignature) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PodSignature.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PodSignature) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PodSignature.Merge(m, src)
}
func (m *PodSignature) XXX_Size() int {
	return m.Size()
}
func (m *PodSignature) XXX_DiscardUnknown() {
	xxx_messageInfo_PodSignature.DiscardUnknown(m)
}

var xxx_messageInfo_PodSignature proto.InternalMessageInfo

func (m *PodSignature) GetPodController() *v1.OwnerReference {
	if m != nil {
		return m.PodController
	}
	return nil
}

// PodSpec is a description of a pod.
type PodSpec struct {
	// List of volumes that can be mounted by containers belonging to the pod.
	// More info: https://kubernetes.io/docs/concepts/storage/volumes
	// +optional
	// +patchMergeKey=name
	// +patchStrategy=merge,retainKeys
	Volumes []*Volume `protobuf:"bytes,1,rep,name=volumes" json:"volumes,omitempty"`
	// List of initialization containers belonging to the pod.
	// Init containers are executed in order prior to containers being started. If any
	// init container fails, the pod is considered to have failed and is handled according
	// to its restartPolicy. The name for an init container or normal container must be
	// unique among all containers.
	// Init containers may not have Lifecycle actions, Readiness probes, or Liveness probes.
	// The resourceRequirements of an init container are taken into account during scheduling
	// by finding the highest request/limit for each resource type, and then using the max of
	// of that value or the sum of the normal containers. Limits are applied to init containers
	// in a similar fashion.
	// Init containers cannot currently be added or removed.
	// Cannot be updated.
	// More info: https://kubernetes.io/docs/concepts/workloads/pods/init-containers/
	// +patchMergeKey=name
	// +patchStrategy=merge
	InitContainers []*Container `protobuf:"bytes,20,rep,name=initContainers" json:"initContainers,omitempty"`
	// List of containers belonging to the pod.
	// Containers cannot currently be added or removed.
	// There must be at least one container in a Pod.
	// Cannot be updated.
	// +patchMergeKey=name
	// +patchStrategy=merge
	Containers []*Container `protobuf:"bytes,2,rep,name=containers" json:"containers,omitempty"`
	// EphemeralContainers is the list of ephemeral containers that run in this pod. Ephemeral containers
	// are added to an existing pod as a result of a user-initiated action such as troubleshooting.
	// This list is read-only in the pod spec. It may not be specified in a create or modified in an
	// update of a pod or pod template.
	// To add an ephemeral container use the pod's ephemeralcontainers subresource, which allows update
	// using the EphemeralContainers kind.
	// This field is alpha-level and is only honored by servers that enable the EphemeralContainers feature.
	// +optional
	// +patchMergeKey=name
	// +patchStrategy=merge
	EphemeralContainers []*EphemeralContainer `protobuf:"bytes,34,rep,name=ephemeralContainers" json:"ephemeralContainers,omitempty"`
	// Restart policy for all containers within the pod.
	// One of Always, OnFailure, Never.
	// Default to Always.
	// More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle/#restart-policy
	// +optional
	RestartPolicy string `protobuf:"bytes,3,opt,name=restartPolicy" json:"restartPolicy"`
	// Optional duration in seconds the pod needs to terminate gracefully. May be decreased in delete request.
	// Value must be non-negative integer. The value zero indicates delete immediately.
	// If this value is nil, the default grace period will be used instead.
	// The grace period is the duration in seconds after the processes running in the pod are sent
	// a termination signal and the time when the processes are forcibly halted with a kill signal.
	// Set this value longer than the expected cleanup time for your process.
	// Defaults to 30 seconds.
	// +optional
	TerminationGracePeriodSeconds int64 `protobuf:"varint,4,opt,name=terminationGracePeriodSeconds" json:"terminationGracePeriodSeconds"`
	// Optional duration in seconds the pod may be active on the node relative to
	// StartTime before the system will actively try to mark it failed and kill associated containers.
	// Value must be a positive integer.
	// +optional
	ActiveDeadlineSeconds int64 `protobuf:"varint,5,opt,name=activeDeadlineSeconds" json:"activeDeadlineSeconds"`
	// Set DNS policy for the pod.
	// Defaults to "ClusterFirst".
	// Valid values are 'ClusterFirstWithHostNet', 'ClusterFirst', 'Default' or 'None'.
	// DNS parameters given in DNSConfig will be merged with the policy selected with DNSPolicy.
	// To have DNS options set along with hostNetwork, you have to specify DNS policy
	// explicitly to 'ClusterFirstWithHostNet'.
	// +optional
	DnsPolicy string `protobuf:"bytes,6,opt,name=dnsPolicy" json:"dnsPolicy"`
	// NodeSelector is a selector which must be true for the pod to fit on a node.
	// Selector which must match a node's labels for the pod to be scheduled on that node.
	// More info: https://kubernetes.io/docs/concepts/configuration/assign-pod-node/
	// +optional
	NodeSelector map[string]string `protobuf:"bytes,7,rep,name=nodeSelector" json:"nodeSelector,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// ServiceAccountName is the name of the ServiceAccount to use to run this pod.
	// More info: https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/
	// +optional
	ServiceAccountName string `protobuf:"bytes,8,opt,name=serviceAccountName" json:"serviceAccountName"`
	// DeprecatedServiceAccount is a depreciated alias for ServiceAccountName.
	// Deprecated: Use serviceAccountName instead.
	// +k8s:conversion-gen=false
	// +optional
	ServiceAccount string `protobuf:"bytes,9,opt,name=serviceAccount" json:"serviceAccount"`
	// AutomountServiceAccountToken indicates whether a service account token should be automatically mounted.
	// +optional
	AutomountServiceAccountToken bool `protobuf:"varint,21,opt,name=automountServiceAccountToken" json:"automountServiceAccountToken"`
	// NodeName is a request to schedule this pod onto a specific node. If it is non-empty,
	// the scheduler simply schedules this pod onto that node, assuming that it fits resource
	// requirements.
	// +optional
	NodeName string `protobuf:"bytes,10,opt,name=nodeName" json:"nodeName"`
	// Host networking requested for this pod. Use the host's network namespace.
	// If this option is set, the ports that will be used must be specified.
	// Default to false.
	// +k8s:conversion-gen=false
	// +optional
	HostNetwork bool `protobuf:"varint,11,opt,name=hostNetwork" json:"hostNetwork"`
	// Use the host's pid namespace.
	// Optional: Default to false.
	// +k8s:conversion-gen=false
	// +optional
	HostPID bool `protobuf:"varint,12,opt,name=hostPID" json:"hostPID"`
	// Use the host's ipc namespace.
	// Optional: Default to false.
	// +k8s:conversion-gen=false
	// +optional
	HostIPC bool `protobuf:"varint,13,opt,name=hostIPC" json:"hostIPC"`
	// Share a single process namespace between all of the containers in a pod.
	// When this is set containers will be able to view and signal processes from other containers
	// in the same pod, and the first process in each container will not be assigned PID 1.
	// HostPID and ShareProcessNamespace cannot both be set.
	// Optional: Default to false.
	// This field is beta-level and may be disabled with the PodShareProcessNamespace feature.
	// +k8s:conversion-gen=false
	// +optional
	ShareProcessNamespace bool `protobuf:"varint,27,opt,name=shareProcessNamespace" json:"shareProcessNamespace"`
	// SecurityContext holds pod-level security attributes and common container settings.
	// Optional: Defaults to empty.  See type description for default values of each field.
	// +optional
	SecurityContext *PodSecurityContext `protobuf:"bytes,14,opt,name=securityContext" json:"securityContext,omitempty"`
	// ImagePullSecrets is an optional list of references to secrets in the same namespace to use for pulling any of the images used by this PodSpec.
	// If specified, these secrets will be passed to individual puller implementations for them to use. For example,
	// in the case of docker, only DockerConfig type secrets are honored.
	// More info: https://kubernetes.io/docs/concepts/containers/images#specifying-imagepullsecrets-on-a-pod
	// +optional
	// +patchMergeKey=name
	// +patchStrategy=merge
	ImagePullSecrets []*LocalObjectReference `protobuf:"bytes,15,rep,name=imagePullSecrets" json:"imagePullSecrets,omitempty"`
	// Specifies the hostname of the Pod
	// If not specified, the pod's hostname will be set to a system-defined value.
	// +optional
	Hostname string `protobuf:"bytes,16,opt,name=hostname" json:"hostname"`
	// If specified, the fully qualified Pod hostname will be "<hostname>.<subdomain>.<pod namespace>.svc.<cluster domain>".
	// If not specified, the pod will not have a domainname at all.
	// +optional
	Subdomain string `protobuf:"bytes,17,opt,name=subdomain" json:"subdomain"`
	// If specified, the pod's scheduling constraints
	// +optional
	Affinity *Affinity `protobuf:"bytes,18,opt,name=affinity" json:"affinity,omitempty"`
	// If specified, the pod will be dispatched by specified scheduler.
	// If not specified, the pod will be dispatched by default scheduler.
	// +optional
	SchedulerName string `protobuf:"bytes,19,opt,name=schedulerName" json:"schedulerName"`
	// If specified, the pod's tolerations.
	// +optional
	Tolerations []*Toleration `protobuf:"bytes,22,rep,name=tolerations" json:"tolerations,omitempty"`
	// HostAliases is an optional list of hosts and IPs that will be injected into the pod's hosts
	// file if specified. This is only valid for non-hostNetwork pods.
	// +optional
	// +patchMergeKey=ip
	// +patchStrategy=merge
	HostAliases []*HostAlias `protobuf:"bytes,23,rep,name=hostAliases" json:"hostAliases,omitempty"`
	// If specified, indicates the pod's priority. "system-node-critical" and
	// "system-cluster-critical" are two special keywords which indicate the
	// highest priorities with the former being the highest priority. Any other
	// name must be defined by creating a PriorityClass object with that name.
	// If not specified, the pod priority will be default or zero if there is no
	// default.
	// +optional
	PriorityClassName string `protobuf:"bytes,24,opt,name=priorityClassName" json:"priorityClassName"`
	// The priority value. Various system components use this field to find the
	// priority of the pod. When Priority Admission Controller is enabled, it
	// prevents users from setting this field. The admission controller populates
	// this field from PriorityClassName.
	// The higher the value, the higher the priority.
	// +optional
	Priority int32 `protobuf:"varint,25,opt,name=priority" json:"priority"`
	// Specifies the DNS parameters of a pod.
	// Parameters specified here will be merged to the generated DNS
	// configuration based on DNSPolicy.
	// +optional
	DnsConfig *PodDNSConfig `protobuf:"bytes,26,opt,name=dnsConfig" json:"dnsConfig,omitempty"`
	// If specified, all readiness gates will be evaluated for pod readiness.
	// A pod is ready when all its containers are ready AND
	// all conditions specified in the readiness gates have status equal to "True"
	// More info: https://git.k8s.io/enhancements/keps/sig-network/0007-pod-ready%2B%2B.md
	// +optional
	ReadinessGates []*PodReadinessGate `protobuf:"bytes,28,rep,name=readinessGates" json:"readinessGates,omitempty"`
	// RuntimeClassName refers to a RuntimeClass object in the node.k8s.io group, which should be used
	// to run this pod.  If no RuntimeClass resource matches the named class, the pod will not be run.
	// If unset or empty, the "legacy" RuntimeClass will be used, which is an implicit class with an
	// empty definition that uses the default runtime handler.
	// More info: https://git.k8s.io/enhancements/keps/sig-node/runtime-class.md
	// This is a beta feature as of Kubernetes v1.14.
	// +optional
	RuntimeClassName string `protobuf:"bytes,29,opt,name=runtimeClassName" json:"runtimeClassName"`
	// EnableServiceLinks indicates whether information about services should be injected into pod's
	// environment variables, matching the syntax of Docker links.
	// Optional: Defaults to true.
	// +optional
	EnableServiceLinks bool `protobuf:"varint,30,opt,name=enableServiceLinks" json:"enableServiceLinks"`
	// PreemptionPolicy is the Policy for preempting pods with lower priority.
	// One of Never, PreemptLowerPriority.
	// Defaults to PreemptLowerPriority if unset.
	// This field is alpha-level and is only honored by servers that enable the NonPreemptingPriority feature.
	// +optional
	PreemptionPolicy string `protobuf:"bytes,31,opt,name=preemptionPolicy" json:"preemptionPolicy"`
	// Overhead represents the resource overhead associated with running a pod for a given RuntimeClass.
	// This field will be autopopulated at admission time by the RuntimeClass admission controller. If
	// the RuntimeClass admission controller is enabled, overhead must not be set in Pod create requests.
	// The RuntimeClass admission controller will reject Pod create requests which have the overhead already
	// set. If RuntimeClass is configured and selected in the PodSpec, Overhead will be set to the value
	// defined in the corresponding RuntimeClass, otherwise it will remain unset and treated as zero.
	// More info: https://git.k8s.io/enhancements/keps/sig-node/20190226-pod-overhead.md
	// This field is alpha-level as of Kubernetes v1.16, and is only honored by servers that enable the PodOverhead feature.
	// +optional
	Overhead map[string]*resource.Quantity `protobuf:"bytes,32,rep,name=overhead" json:"overhead,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// TopologySpreadConstraints describes how a group of pods ought to spread across topology
	// domains. Scheduler will schedule pods in a way which abides by the constraints.
	// This field is alpha-level and is only honored by clusters that enables the EvenPodsSpread
	// feature.
	// All topologySpreadConstraints are ANDed.
	// +optional
	// +patchMergeKey=topologyKey
	// +patchStrategy=merge
	// +listType=map
	// +listMapKey=topologyKey
	// +listMapKey=whenUnsatisfiable
	TopologySpreadConstraints []*TopologySpreadConstraint `protobuf:"bytes,33,rep,name=topologySpreadConstraints" json:"topologySpreadConstraints,omitempty"`
}

func (m *PodSpec) Reset()      { *m = PodSpec{} }
func (*PodSpec) ProtoMessage() {}
func (*PodSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{133}
}
func (m *PodSpec) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PodSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PodSpec.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PodSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PodSpec.Merge(m, src)
}
func (m *PodSpec) XXX_Size() int {
	return m.Size()
}
func (m *PodSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_PodSpec.DiscardUnknown(m)
}

var xxx_messageInfo_PodSpec proto.InternalMessageInfo

func (m *PodSpec) GetVolumes() []*Volume {
	if m != nil {
		return m.Volumes
	}
	return nil
}

func (m *PodSpec) GetInitContainers() []*Container {
	if m != nil {
		return m.InitContainers
	}
	return nil
}

func (m *PodSpec) GetContainers() []*Container {
	if m != nil {
		return m.Containers
	}
	return nil
}

func (m *PodSpec) GetEphemeralContainers() []*EphemeralContainer {
	if m != nil {
		return m.EphemeralContainers
	}
	return nil
}

func (m *PodSpec) GetRestartPolicy() string {
	if m != nil {
		return m.RestartPolicy
	}
	return ""
}

func (m *PodSpec) GetTerminationGracePeriodSeconds() int64 {
	if m != nil {
		return m.TerminationGracePeriodSeconds
	}
	return 0
}

func (m *PodSpec) GetActiveDeadlineSeconds() int64 {
	if m != nil {
		return m.ActiveDeadlineSeconds
	}
	return 0
}

func (m *PodSpec) GetDnsPolicy() string {
	if m != nil {
		return m.DnsPolicy
	}
	return ""
}

func (m *PodSpec) GetNodeSelector() map[string]string {
	if m != nil {
		return m.NodeSelector
	}
	return nil
}

func (m *PodSpec) GetServiceAccountName() string {
	if m != nil {
		return m.ServiceAccountName
	}
	return ""
}

func (m *PodSpec) GetServiceAccount() string {
	if m != nil {
		return m.ServiceAccount
	}
	return ""
}

func (m *PodSpec) GetAutomountServiceAccountToken() bool {
	if m != nil {
		return m.AutomountServiceAccountToken
	}
	return false
}

func (m *PodSpec) GetNodeName() string {
	if m != nil {
		return m.NodeName
	}
	return ""
}

func (m *PodSpec) GetHostNetwork() bool {
	if m != nil {
		return m.HostNetwork
	}
	return false
}

func (m *PodSpec) GetHostPID() bool {
	if m != nil {
		return m.HostPID
	}
	return false
}

func (m *PodSpec) GetHostIPC() bool {
	if m != nil {
		return m.HostIPC
	}
	return false
}

func (m *PodSpec) GetShareProcessNamespace() bool {
	if m != nil {
		return m.ShareProcessNamespace
	}
	return false
}

func (m *PodSpec) GetSecurityContext() *PodSecurityContext {
	if m != nil {
		return m.SecurityContext
	}
	return nil
}

func (m *PodSpec) GetImagePullSecrets() []*LocalObjectReference {
	if m != nil {
		return m.ImagePullSecrets
	}
	return nil
}

func (m *PodSpec) GetHostname() string {
	if m != nil {
		return m.Hostname
	}
	return ""
}

func (m *PodSpec) GetSubdomain() string {
	if m != nil {
		return m.Subdomain
	}
	return ""
}

func (m *PodSpec) GetAffinity() *Affinity {
	if m != nil {
		return m.Affinity
	}
	return nil
}

func (m *PodSpec) GetSchedulerName() string {
	if m != nil {
		return m.SchedulerName
	}
	return ""
}

func (m *PodSpec) GetTolerations() []*Toleration {
	if m != nil {
		return m.Tolerations
	}
	return nil
}

func (m *PodSpec) GetHostAliases() []*HostAlias {
	if m != nil {
		return m.HostAliases
	}
	return nil
}

func (m *PodSpec) GetPriorityClassName() string {
	if m != nil {
		return m.PriorityClassName
	}
	return ""
}

func (m *PodSpec) GetPriority() int32 {
	if m != nil {
		return m.Priority
	}
	return 0
}

func (m *PodSpec) GetDnsConfig() *PodDNSConfig {
	if m != nil {
		return m.DnsConfig
	}
	return nil
}

func (m *PodSpec) GetReadinessGates() []*PodReadinessGate {
	if m != nil {
		return m.ReadinessGates
	}
	return nil
}

func (m *PodSpec) GetRuntimeClassName() string {
	if m != nil {
		return m.RuntimeClassName
	}
	return ""
}

func (m *PodSpec) GetEnableServiceLinks() bool {
	if m != nil {
		return m.EnableServiceLinks
	}
	return false
}

func (m *PodSpec) GetPreemptionPolicy() string {
	if m != nil {
		return m.PreemptionPolicy
	}
	return ""
}

func (m *PodSpec) GetOverhead() map[string]*resource.Quantity {
	if m != nil {
		return m.Overhead
	}
	return nil
}

func (m *PodSpec) GetTopologySpreadConstraints() []*TopologySpreadConstraint {
	if m != nil {
		return m.TopologySpreadConstraints
	}
	return nil
}

// PodStatus represents information about the status of a pod. Status may trail the actual
// state of a system, especially if the node that hosts the pod cannot contact the control
// plane.
type PodStatus struct {
	// The phase of a Pod is a simple, high-level summary of where the Pod is in its lifecycle.
	// The conditions array, the reason and message fields, and the individual container status
	// arrays contain more detail about the pod's status.
	// There are five possible phase values:
	//
	// Pending: The pod has been accepted by the Kubernetes system, but one or more of the
	// container images has not been created. This includes time before being scheduled as
	// well as time spent downloading images over the network, which could take a while.
	// Running: The pod has been bound to a node, and all of the containers have been created.
	// At least one container is still running, or is in the process of starting or restarting.
	// Succeeded: All containers in the pod have terminated in success, and will not be restarted.
	// Failed: All containers in the pod have terminated, and at least one container has
	// terminated in failure. The container either exited with non-zero status or was terminated
	// by the system.
	// Unknown: For some reason the state of the pod could not be obtained, typically due to an
	// error in communicating with the host of the pod.
	//
	// More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#pod-phase
	// +optional
	Phase string `protobuf:"bytes,1,opt,name=phase" json:"phase"`
	// Current service state of pod.
	// More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#pod-conditions
	// +optional
	// +patchMergeKey=type
	// +patchStrategy=merge
	Conditions []*PodCondition `protobuf:"bytes,2,rep,name=conditions" json:"conditions,omitempty"`
	// A human readable message indicating details about why the pod is in this condition.
	// +optional
	Message string `protobuf:"bytes,3,opt,name=message" json:"message"`
	// A brief CamelCase message indicating details about why the pod is in this state.
	// e.g. 'Evicted'
	// +optional
	Reason string `protobuf:"bytes,4,opt,name=reason" json:"reason"`
	// nominatedNodeName is set only when this pod preempts other pods on the node, but it cannot be
	// scheduled right away as preemption victims receive their graceful termination periods.
	// This field does not guarantee that the pod will be scheduled on this node. Scheduler may decide
	// to place the pod elsewhere if other nodes become available sooner. Scheduler may also decide to
	// give the resources on this node to a higher priority pod that is created after preemption.
	// As a result, this field may be different than PodSpec.nodeName when the pod is
	// scheduled.
	// +optional
	NominatedNodeName string `protobuf:"bytes,11,opt,name=nominatedNodeName" json:"nominatedNodeName"`
	// IP address of the host to which the pod is assigned. Empty if not yet scheduled.
	// +optional
	HostIP string `protobuf:"bytes,5,opt,name=hostIP" json:"hostIP"`
	// IP address allocated to the pod. Routable at least within the cluster.
	// Empty if not yet allocated.
	// +optional
	PodIP string `protobuf:"bytes,6,opt,name=podIP" json:"podIP"`
	// podIPs holds the IP addresses allocated to the pod. If this field is specified, the 0th entry must
	// match the podIP field. Pods may be allocated at most 1 value for each of IPv4 and IPv6. This list
	// is empty if no IPs have been allocated yet.
	// +optional
	// +patchStrategy=merge
	// +patchMergeKey=ip
	PodIPs []*PodIP `protobuf:"bytes,12,rep,name=podIPs" json:"podIPs,omitempty"`
	// RFC 3339 date and time at which the object was acknowledged by the Kubelet.
	// This is before the Kubelet pulled the container image(s) for the pod.
	// +optional
	StartTime *v1.Time `protobuf:"bytes,7,opt,name=startTime" json:"startTime,omitempty"`
	// The list has one entry per init container in the manifest. The most recent successful
	// init container will have ready = true, the most recently started container will have
	// startTime set.
	// More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#pod-and-container-status
	InitContainerStatuses []*ContainerStatus `protobuf:"bytes,10,rep,name=initContainerStatuses" json:"initContainerStatuses,omitempty"`
	// The list has one entry per container in the manifest. Each entry is currently the output
	// of `docker inspect`.
	// More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#pod-and-container-status
	// +optional
	ContainerStatuses []*ContainerStatus `protobuf:"bytes,8,rep,name=containerStatuses" json:"containerStatuses,omitempty"`
	// The Quality of Service (QOS) classification assigned to the pod based on resource requirements
	// See PodQOSClass type for available QOS classes
	// More info: https://git.k8s.io/community/contributors/design-proposals/node/resource-qos.md
	// +optional
	QosClass string `protobuf:"bytes,9,opt,name=qosClass" json:"qosClass"`
	// Status for any ephemeral containers that running in this pod.
	// This field is alpha-level and is only honored by servers that enable the EphemeralContainers feature.
	// +optional
	EphemeralContainerStatuses []*ContainerStatus `protobuf:"bytes,13,rep,name=ephemeralContainerStatuses" json:"ephemeralContainerStatuses,omitempty"`
}

func (m *PodStatus) Reset()      { *m = PodStatus{} }
func (*PodStatus) ProtoMessage() {}
func (*PodStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{134}
}
func (m *PodStatus) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PodStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PodStatus.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PodStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PodStatus.Merge(m, src)
}
func (m *PodStatus) XXX_Size() int {
	return m.Size()
}
func (m *PodStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_PodStatus.DiscardUnknown(m)
}

var xxx_messageInfo_PodStatus proto.InternalMessageInfo

func (m *PodStatus) GetPhase() string {
	if m != nil {
		return m.Phase
	}
	return ""
}

func (m *PodStatus) GetConditions() []*PodCondition {
	if m != nil {
		return m.Conditions
	}
	return nil
}

func (m *PodStatus) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

func (m *PodStatus) GetReason() string {
	if m != nil {
		return m.Reason
	}
	return ""
}

func (m *PodStatus) GetNominatedNodeName() string {
	if m != nil {
		return m.NominatedNodeName
	}
	return ""
}

func (m *PodStatus) GetHostIP() string {
	if m != nil {
		return m.HostIP
	}
	return ""
}

func (m *PodStatus) GetPodIP() string {
	if m != nil {
		return m.PodIP
	}
	return ""
}

func (m *PodStatus) GetPodIPs() []*PodIP {
	if m != nil {
		return m.PodIPs
	}
	return nil
}

func (m *PodStatus) GetStartTime() *v1.Time {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *PodStatus) GetInitContainerStatuses() []*ContainerStatus {
	if m != nil {
		return m.InitContainerStatuses
	}
	return nil
}

func (m *PodStatus) GetContainerStatuses() []*ContainerStatus {
	if m != nil {
		return m.ContainerStatuses
	}
	return nil
}

func (m *PodStatus) GetQosClass() string {
	if m != nil {
		return m.QosClass
	}
	return ""
}

func (m *PodStatus) GetEphemeralContainerStatuses() []*ContainerStatus {
	if m != nil {
		return m.EphemeralContainerStatuses
	}
	return nil
}

// PodStatusResult is a wrapper for PodStatus returned by kubelet that can be encode/decoded
type PodStatusResult struct {
	// Standard object's metadata.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
	// +optional
	Metadata *v1.ObjectMeta `protobuf:"bytes,1,opt,name=metadata" json:"metadata,omitempty"`
	// Most recently observed status of the pod.
	// This data may not be up to date.
	// Populated by the system.
	// Read-only.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status
	// +optional
	Status *PodStatus `protobuf:"bytes,2,opt,name=status" json:"status,omitempty"`
}

func (m *PodStatusResult) Reset()      { *m = PodStatusResult{} }
func (*PodStatusResult) ProtoMessage() {}
func (*PodStatusResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{135}
}
func (m *PodStatusResult) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PodStatusResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PodStatusResult.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PodStatusResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PodStatusResult.Merge(m, src)
}
func (m *PodStatusResult) XXX_Size() int {
	return m.Size()
}
func (m *PodStatusResult) XXX_DiscardUnknown() {
	xxx_messageInfo_PodStatusResult.DiscardUnknown(m)
}

var xxx_messageInfo_PodStatusResult proto.InternalMessageInfo

func (m *PodStatusResult) GetMetadata() *v1.ObjectMeta {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *PodStatusResult) GetStatus() *PodStatus {
	if m != nil {
		return m.Status
	}
	return nil
}

// PodTemplate describes a template for creating copies of a predefined pod.
type PodTemplate struct {
	// Standard object's metadata.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
	// +optional
	Metadata *v1.ObjectMeta `protobuf:"bytes,1,opt,name=metadata" json:"metadata,omitempty"`
	// Template defines the pods that will be created from this pod template.
	// https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status
	// +optional
	Template *PodTemplateSpec `protobuf:"bytes,2,opt,name=template" json:"template,omitempty"`
}

func (m *PodTemplate) Reset()      { *m = PodTemplate{} }
func (*PodTemplate) ProtoMessage() {}
func (*PodTemplate) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{136}
}
func (m *PodTemplate) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PodTemplate) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PodTemplate.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PodTemplate) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PodTemplate.Merge(m, src)
}
func (m *PodTemplate) XXX_Size() int {
	return m.Size()
}
func (m *PodTemplate) XXX_DiscardUnknown() {
	xxx_messageInfo_PodTemplate.DiscardUnknown(m)
}

var xxx_messageInfo_PodTemplate proto.InternalMessageInfo

func (m *PodTemplate) GetMetadata() *v1.ObjectMeta {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *PodTemplate) GetTemplate() *PodTemplateSpec {
	if m != nil {
		return m.Template
	}
	return nil
}

// PodTemplateList is a list of PodTemplates.
type PodTemplateList struct {
	// Standard list metadata.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds
	// +optional
	Metadata *v1.ListMeta `protobuf:"bytes,1,opt,name=metadata" json:"metadata,omitempty"`
	// List of pod templates
	Items []*PodTemplate `protobuf:"bytes,2,rep,name=items" json:"items,omitempty"`
}

func (m *PodTemplateList) Reset()      { *m = PodTemplateList{} }
func (*PodTemplateList) ProtoMessage() {}
func (*PodTemplateList) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{137}
}
func (m *PodTemplateList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PodTemplateList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PodTemplateList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PodTemplateList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PodTemplateList.Merge(m, src)
}
func (m *PodTemplateList) XXX_Size() int {
	return m.Size()
}
func (m *PodTemplateList) XXX_DiscardUnknown() {
	xxx_messageInfo_PodTemplateList.DiscardUnknown(m)
}

var xxx_messageInfo_PodTemplateList proto.InternalMessageInfo

func (m *PodTemplateList) GetMetadata() *v1.ListMeta {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *PodTemplateList) GetItems() []*PodTemplate {
	if m != nil {
		return m.Items
	}
	return nil
}

// PodTemplateSpec describes the data a pod should have when created from a template
type PodTemplateSpec struct {
	// Standard object's metadata.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
	// +optional
	Metadata *v1.ObjectMeta `protobuf:"bytes,1,opt,name=metadata" json:"metadata,omitempty"`
	// Specification of the desired behavior of the pod.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status
	// +optional
	Spec *PodSpec `protobuf:"bytes,2,opt,name=spec" json:"spec,omitempty"`
}

func (m *PodTemplateSpec) Reset()      { *m = PodTemplateSpec{} }
func (*PodTemplateSpec) ProtoMessage() {}
func (*PodTemplateSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{138}
}
func (m *PodTemplateSpec) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PodTemplateSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PodTemplateSpec.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PodTemplateSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PodTemplateSpec.Merge(m, src)
}
func (m *PodTemplateSpec) XXX_Size() int {
	return m.Size()
}
func (m *PodTemplateSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_PodTemplateSpec.DiscardUnknown(m)
}

var xxx_messageInfo_PodTemplateSpec proto.InternalMessageInfo

func (m *PodTemplateSpec) GetMetadata() *v1.ObjectMeta {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *PodTemplateSpec) GetSpec() *PodSpec {
	if m != nil {
		return m.Spec
	}
	return nil
}

// PortworxVolumeSource represents a Portworx volume resource.
type PortworxVolumeSource struct {
	// VolumeID uniquely identifies a Portworx volume
	VolumeID string `protobuf:"bytes,1,opt,name=volumeID" json:"volumeID"`
	// FSType represents the filesystem type to mount
	// Must be a filesystem type supported by the host operating system.
	// Ex. "ext4", "xfs". Implicitly inferred to be "ext4" if unspecified.
	FsType string `protobuf:"bytes,2,opt,name=fsType" json:"fsType"`
	// Defaults to false (read/write). ReadOnly here will force
	// the ReadOnly setting in VolumeMounts.
	// +optional
	ReadOnly bool `protobuf:"varint,3,opt,name=readOnly" json:"readOnly"`
}

func (m *PortworxVolumeSource) Reset()      { *m = PortworxVolumeSource{} }
func (*PortworxVolumeSource) ProtoMessage() {}
func (*PortworxVolumeSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{139}
}
func (m *PortworxVolumeSource) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PortworxVolumeSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PortworxVolumeSource.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PortworxVolumeSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PortworxVolumeSource.Merge(m, src)
}
func (m *PortworxVolumeSource) XXX_Size() int {
	return m.Size()
}
func (m *PortworxVolumeSource) XXX_DiscardUnknown() {
	xxx_messageInfo_PortworxVolumeSource.DiscardUnknown(m)
}

var xxx_messageInfo_PortworxVolumeSource proto.InternalMessageInfo

func (m *PortworxVolumeSource) GetVolumeID() string {
	if m != nil {
		return m.VolumeID
	}
	return ""
}

func (m *PortworxVolumeSource) GetFsType() string {
	if m != nil {
		return m.FsType
	}
	return ""
}

func (m *PortworxVolumeSource) GetReadOnly() bool {
	if m != nil {
		return m.ReadOnly
	}
	return false
}

// Preconditions must be fulfilled before an operation (update, delete, etc.) is carried out.
// +k8s:openapi-gen=false
type Preconditions struct {
	// Specifies the target UID.
	// +optional
	Uid string `protobuf:"bytes,1,opt,name=uid" json:"uid"`
}

func (m *Preconditions) Reset()      { *m = Preconditions{} }
func (*Preconditions) ProtoMessage() {}
func (*Preconditions) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{140}
}
func (m *Preconditions) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Preconditions) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Preconditions.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Preconditions) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Preconditions.Merge(m, src)
}
func (m *Preconditions) XXX_Size() int {
	return m.Size()
}
func (m *Preconditions) XXX_DiscardUnknown() {
	xxx_messageInfo_Preconditions.DiscardUnknown(m)
}

var xxx_messageInfo_Preconditions proto.InternalMessageInfo

func (m *Preconditions) GetUid() string {
	if m != nil {
		return m.Uid
	}
	return ""
}

// Describes a class of pods that should avoid this node.
type PreferAvoidPodsEntry struct {
	// The class of pods.
	PodSignature *PodSignature `protobuf:"bytes,1,opt,name=podSignature" json:"podSignature,omitempty"`
	// Time at which this entry was added to the list.
	// +optional
	EvictionTime *v1.Time `protobuf:"bytes,2,opt,name=evictionTime" json:"evictionTime,omitempty"`
	// (brief) reason why this entry was added to the list.
	// +optional
	Reason string `protobuf:"bytes,3,opt,name=reason" json:"reason"`
	// Human readable message indicating why this entry was added to the list.
	// +optional
	Message string `protobuf:"bytes,4,opt,name=message" json:"message"`
}

func (m *PreferAvoidPodsEntry) Reset()      { *m = PreferAvoidPodsEntry{} }
func (*PreferAvoidPodsEntry) ProtoMessage() {}
func (*PreferAvoidPodsEntry) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{141}
}
func (m *PreferAvoidPodsEntry) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PreferAvoidPodsEntry) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PreferAvoidPodsEntry.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PreferAvoidPodsEntry) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PreferAvoidPodsEntry.Merge(m, src)
}
func (m *PreferAvoidPodsEntry) XXX_Size() int {
	return m.Size()
}
func (m *PreferAvoidPodsEntry) XXX_DiscardUnknown() {
	xxx_messageInfo_PreferAvoidPodsEntry.DiscardUnknown(m)
}

var xxx_messageInfo_PreferAvoidPodsEntry proto.InternalMessageInfo

func (m *PreferAvoidPodsEntry) GetPodSignature() *PodSignature {
	if m != nil {
		return m.PodSignature
	}
	return nil
}

func (m *PreferAvoidPodsEntry) GetEvictionTime() *v1.Time {
	if m != nil {
		return m.EvictionTime
	}
	return nil
}

func (m *PreferAvoidPodsEntry) GetReason() string {
	if m != nil {
		return m.Reason
	}
	return ""
}

func (m *PreferAvoidPodsEntry) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

// An empty preferred scheduling term matches all objects with implicit weight 0
// (i.e. it's a no-op). A null preferred scheduling term matches no objects (i.e. is also a no-op).
type PreferredSchedulingTerm struct {
	// Weight associated with matching the corresponding nodeSelectorTerm, in the range 1-100.
	Weight int32 `protobuf:"varint,1,opt,name=weight" json:"weight"`
	// A node selector term, associated with the corresponding weight.
	Preference *NodeSelectorTerm `protobuf:"bytes,2,opt,name=preference" json:"preference,omitempty"`
}

func (m *PreferredSchedulingTerm) Reset()      { *m = PreferredSchedulingTerm{} }
func (*PreferredSchedulingTerm) ProtoMessage() {}
func (*PreferredSchedulingTerm) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{142}
}
func (m *PreferredSchedulingTerm) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PreferredSchedulingTerm) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PreferredSchedulingTerm.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PreferredSchedulingTerm) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PreferredSchedulingTerm.Merge(m, src)
}
func (m *PreferredSchedulingTerm) XXX_Size() int {
	return m.Size()
}
func (m *PreferredSchedulingTerm) XXX_DiscardUnknown() {
	xxx_messageInfo_PreferredSchedulingTerm.DiscardUnknown(m)
}

var xxx_messageInfo_PreferredSchedulingTerm proto.InternalMessageInfo

func (m *PreferredSchedulingTerm) GetWeight() int32 {
	if m != nil {
		return m.Weight
	}
	return 0
}

func (m *PreferredSchedulingTerm) GetPreference() *NodeSelectorTerm {
	if m != nil {
		return m.Preference
	}
	return nil
}

// Probe describes a health check to be performed against a container to determine whether it is
// alive or ready to receive traffic.
type Probe struct {
	// The action taken to determine the health of a container
	Handler *Handler `protobuf:"bytes,1,opt,name=handler" json:"handler,omitempty"`
	// Number of seconds after the container has started before liveness probes are initiated.
	// More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
	// +optional
	InitialDelaySeconds int32 `protobuf:"varint,2,opt,name=initialDelaySeconds" json:"initialDelaySeconds"`
	// Number of seconds after which the probe times out.
	// Defaults to 1 second. Minimum value is 1.
	// More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
	// +optional
	TimeoutSeconds int32 `protobuf:"varint,3,opt,name=timeoutSeconds" json:"timeoutSeconds"`
	// How often (in seconds) to perform the probe.
	// Default to 10 seconds. Minimum value is 1.
	// +optional
	PeriodSeconds int32 `protobuf:"varint,4,opt,name=periodSeconds" json:"periodSeconds"`
	// Minimum consecutive successes for the probe to be considered successful after having failed.
	// Defaults to 1. Must be 1 for liveness. Minimum value is 1.
	// +optional
	SuccessThreshold int32 `protobuf:"varint,5,opt,name=successThreshold" json:"successThreshold"`
	// Minimum consecutive failures for the probe to be considered failed after having succeeded.
	// Defaults to 3. Minimum value is 1.
	// +optional
	FailureThreshold int32 `protobuf:"varint,6,opt,name=failureThreshold" json:"failureThreshold"`
}

func (m *Probe) Reset()      { *m = Probe{} }
func (*Probe) ProtoMessage() {}
func (*Probe) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{143}
}
func (m *Probe) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Probe) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Probe.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Probe) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Probe.Merge(m, src)
}
func (m *Probe) XXX_Size() int {
	return m.Size()
}
func (m *Probe) XXX_DiscardUnknown() {
	xxx_messageInfo_Probe.DiscardUnknown(m)
}

var xxx_messageInfo_Probe proto.InternalMessageInfo

func (m *Probe) GetHandler() *Handler {
	if m != nil {
		return m.Handler
	}
	return nil
}

func (m *Probe) GetInitialDelaySeconds() int32 {
	if m != nil {
		return m.InitialDelaySeconds
	}
	return 0
}

func (m *Probe) GetTimeoutSeconds() int32 {
	if m != nil {
		return m.TimeoutSeconds
	}
	return 0
}

func (m *Probe) GetPeriodSeconds() int32 {
	if m != nil {
		return m.PeriodSeconds
	}
	return 0
}

func (m *Probe) GetSuccessThreshold() int32 {
	if m != nil {
		return m.SuccessThreshold
	}
	return 0
}

func (m *Probe) GetFailureThreshold() int32 {
	if m != nil {
		return m.FailureThreshold
	}
	return 0
}

// Represents a projected volume source
type ProjectedVolumeSource struct {
	// list of volume projections
	Sources []*VolumeProjection `protobuf:"bytes,1,rep,name=sources" json:"sources,omitempty"`
	// Mode bits to use on created files by default. Must be a value between
	// 0 and 0777.
	// Directories within the path are not affected by this setting.
	// This might be in conflict with other options that affect the file
	// mode, like fsGroup, and the result can be other mode bits set.
	// +optional
	DefaultMode int32 `protobuf:"varint,2,opt,name=defaultMode" json:"defaultMode"`
}

func (m *ProjectedVolumeSource) Reset()      { *m = ProjectedVolumeSource{} }
func (*ProjectedVolumeSource) ProtoMessage() {}
func (*ProjectedVolumeSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{144}
}
func (m *ProjectedVolumeSource) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ProjectedVolumeSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ProjectedVolumeSource.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ProjectedVolumeSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProjectedVolumeSource.Merge(m, src)
}
func (m *ProjectedVolumeSource) XXX_Size() int {
	return m.Size()
}
func (m *ProjectedVolumeSource) XXX_DiscardUnknown() {
	xxx_messageInfo_ProjectedVolumeSource.DiscardUnknown(m)
}

var xxx_messageInfo_ProjectedVolumeSource proto.InternalMessageInfo

func (m *ProjectedVolumeSource) GetSources() []*VolumeProjection {
	if m != nil {
		return m.Sources
	}
	return nil
}

func (m *ProjectedVolumeSource) GetDefaultMode() int32 {
	if m != nil {
		return m.DefaultMode
	}
	return 0
}

// Represents a Quobyte mount that lasts the lifetime of a pod.
// Quobyte volumes do not support ownership management or SELinux relabeling.
type QuobyteVolumeSource struct {
	// Registry represents a single or multiple Quobyte Registry services
	// specified as a string as host:port pair (multiple entries are separated with commas)
	// which acts as the central registry for volumes
	Registry string `protobuf:"bytes,1,opt,name=registry" json:"registry"`
	// Volume is a string that references an already created Quobyte volume by name.
	Volume string `protobuf:"bytes,2,opt,name=volume" json:"volume"`
	// ReadOnly here will force the Quobyte volume to be mounted with read-only permissions.
	// Defaults to false.
	// +optional
	ReadOnly bool `protobuf:"varint,3,opt,name=readOnly" json:"readOnly"`
	// User to map volume access to
	// Defaults to serivceaccount user
	// +optional
	User string `protobuf:"bytes,4,opt,name=user" json:"user"`
	// Group to map volume access to
	// Default is no group
	// +optional
	Group string `protobuf:"bytes,5,opt,name=group" json:"group"`
	// Tenant owning the given Quobyte volume in the Backend
	// Used with dynamically provisioned Quobyte volumes, value is set by the plugin
	// +optional
	Tenant string `protobuf:"bytes,6,opt,name=tenant" json:"tenant"`
}

func (m *QuobyteVolumeSource) Reset()      { *m = QuobyteVolumeSource{} }
func (*QuobyteVolumeSource) ProtoMessage() {}
func (*QuobyteVolumeSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{145}
}
func (m *QuobyteVolumeSource) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *QuobyteVolumeSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_QuobyteVolumeSource.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *QuobyteVolumeSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QuobyteVolumeSource.Merge(m, src)
}
func (m *QuobyteVolumeSource) XXX_Size() int {
	return m.Size()
}
func (m *QuobyteVolumeSource) XXX_DiscardUnknown() {
	xxx_messageInfo_QuobyteVolumeSource.DiscardUnknown(m)
}

var xxx_messageInfo_QuobyteVolumeSource proto.InternalMessageInfo

func (m *QuobyteVolumeSource) GetRegistry() string {
	if m != nil {
		return m.Registry
	}
	return ""
}

func (m *QuobyteVolumeSource) GetVolume() string {
	if m != nil {
		return m.Volume
	}
	return ""
}

func (m *QuobyteVolumeSource) GetReadOnly() bool {
	if m != nil {
		return m.ReadOnly
	}
	return false
}

func (m *QuobyteVolumeSource) GetUser() string {
	if m != nil {
		return m.User
	}
	return ""
}

func (m *QuobyteVolumeSource) GetGroup() string {
	if m != nil {
		return m.Group
	}
	return ""
}

func (m *QuobyteVolumeSource) GetTenant() string {
	if m != nil {
		return m.Tenant
	}
	return ""
}

// Represents a Rados Block Device mount that lasts the lifetime of a pod.
// RBD volumes support ownership management and SELinux relabeling.
type RBDPersistentVolumeSource struct {
	// A collection of Ceph monitors.
	// More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
	Monitors []string `protobuf:"bytes,1,rep,name=monitors" json:"monitors,omitempty"`
	// The rados image name.
	// More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
	Image string `protobuf:"bytes,2,opt,name=image" json:"image"`
	// Filesystem type of the volume that you want to mount.
	// Tip: Ensure that the filesystem type is supported by the host operating system.
	// Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
	// More info: https://kubernetes.io/docs/concepts/storage/volumes#rbd
	// TODO: how do we prevent errors in the filesystem from compromising the machine
	// +optional
	FsType string `protobuf:"bytes,3,opt,name=fsType" json:"fsType"`
	// The rados pool name.
	// Default is rbd.
	// More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
	// +optional
	Pool string `protobuf:"bytes,4,opt,name=pool" json:"pool"`
	// The rados user name.
	// Default is admin.
	// More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
	// +optional
	User string `protobuf:"bytes,5,opt,name=user" json:"user"`
	// Keyring is the path to key ring for RBDUser.
	// Default is /etc/ceph/keyring.
	// More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
	// +optional
	Keyring string `protobuf:"bytes,6,opt,name=keyring" json:"keyring"`
	// SecretRef is name of the authentication secret for RBDUser. If provided
	// overrides keyring.
	// Default is nil.
	// More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
	// +optional
	SecretRef *SecretReference `protobuf:"bytes,7,opt,name=secretRef" json:"secretRef,omitempty"`
	// ReadOnly here will force the ReadOnly setting in VolumeMounts.
	// Defaults to false.
	// More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
	// +optional
	ReadOnly bool `protobuf:"varint,8,opt,name=readOnly" json:"readOnly"`
}

func (m *RBDPersistentVolumeSource) Reset()      { *m = RBDPersistentVolumeSource{} }
func (*RBDPersistentVolumeSource) ProtoMessage() {}
func (*RBDPersistentVolumeSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{146}
}
func (m *RBDPersistentVolumeSource) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RBDPersistentVolumeSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RBDPersistentVolumeSource.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RBDPersistentVolumeSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RBDPersistentVolumeSource.Merge(m, src)
}
func (m *RBDPersistentVolumeSource) XXX_Size() int {
	return m.Size()
}
func (m *RBDPersistentVolumeSource) XXX_DiscardUnknown() {
	xxx_messageInfo_RBDPersistentVolumeSource.DiscardUnknown(m)
}

var xxx_messageInfo_RBDPersistentVolumeSource proto.InternalMessageInfo

func (m *RBDPersistentVolumeSource) GetMonitors() []string {
	if m != nil {
		return m.Monitors
	}
	return nil
}

func (m *RBDPersistentVolumeSource) GetImage() string {
	if m != nil {
		return m.Image
	}
	return ""
}

func (m *RBDPersistentVolumeSource) GetFsType() string {
	if m != nil {
		return m.FsType
	}
	return ""
}

func (m *RBDPersistentVolumeSource) GetPool() string {
	if m != nil {
		return m.Pool
	}
	return ""
}

func (m *RBDPersistentVolumeSource) GetUser() string {
	if m != nil {
		return m.User
	}
	return ""
}

func (m *RBDPersistentVolumeSource) GetKeyring() string {
	if m != nil {
		return m.Keyring
	}
	return ""
}

func (m *RBDPersistentVolumeSource) GetSecretRef() *SecretReference {
	if m != nil {
		return m.SecretRef
	}
	return nil
}

func (m *RBDPersistentVolumeSource) GetReadOnly() bool {
	if m != nil {
		return m.ReadOnly
	}
	return false
}

// Represents a Rados Block Device mount that lasts the lifetime of a pod.
// RBD volumes support ownership management and SELinux relabeling.
type RBDVolumeSource struct {
	// A collection of Ceph monitors.
	// More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
	Monitors []string `protobuf:"bytes,1,rep,name=monitors" json:"monitors,omitempty"`
	// The rados image name.
	// More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
	Image string `protobuf:"bytes,2,opt,name=image" json:"image"`
	// Filesystem type of the volume that you want to mount.
	// Tip: Ensure that the filesystem type is supported by the host operating system.
	// Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
	// More info: https://kubernetes.io/docs/concepts/storage/volumes#rbd
	// TODO: how do we prevent errors in the filesystem from compromising the machine
	// +optional
	FsType string `protobuf:"bytes,3,opt,name=fsType" json:"fsType"`
	// The rados pool name.
	// Default is rbd.
	// More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
	// +optional
	Pool string `protobuf:"bytes,4,opt,name=pool" json:"pool"`
	// The rados user name.
	// Default is admin.
	// More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
	// +optional
	User string `protobuf:"bytes,5,opt,name=user" json:"user"`
	// Keyring is the path to key ring for RBDUser.
	// Default is /etc/ceph/keyring.
	// More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
	// +optional
	Keyring string `protobuf:"bytes,6,opt,name=keyring" json:"keyring"`
	// SecretRef is name of the authentication secret for RBDUser. If provided
	// overrides keyring.
	// Default is nil.
	// More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
	// +optional
	SecretRef *LocalObjectReference `protobuf:"bytes,7,opt,name=secretRef" json:"secretRef,omitempty"`
	// ReadOnly here will force the ReadOnly setting in VolumeMounts.
	// Defaults to false.
	// More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
	// +optional
	ReadOnly bool `protobuf:"varint,8,opt,name=readOnly" json:"readOnly"`
}

func (m *RBDVolumeSource) Reset()      { *m = RBDVolumeSource{} }
func (*RBDVolumeSource) ProtoMessage() {}
func (*RBDVolumeSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{147}
}
func (m *RBDVolumeSource) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RBDVolumeSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RBDVolumeSource.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RBDVolumeSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RBDVolumeSource.Merge(m, src)
}
func (m *RBDVolumeSource) XXX_Size() int {
	return m.Size()
}
func (m *RBDVolumeSource) XXX_DiscardUnknown() {
	xxx_messageInfo_RBDVolumeSource.DiscardUnknown(m)
}

var xxx_messageInfo_RBDVolumeSource proto.InternalMessageInfo

func (m *RBDVolumeSource) GetMonitors() []string {
	if m != nil {
		return m.Monitors
	}
	return nil
}

func (m *RBDVolumeSource) GetImage() string {
	if m != nil {
		return m.Image
	}
	return ""
}

func (m *RBDVolumeSource) GetFsType() string {
	if m != nil {
		return m.FsType
	}
	return ""
}

func (m *RBDVolumeSource) GetPool() string {
	if m != nil {
		return m.Pool
	}
	return ""
}

func (m *RBDVolumeSource) GetUser() string {
	if m != nil {
		return m.User
	}
	return ""
}

func (m *RBDVolumeSource) GetKeyring() string {
	if m != nil {
		return m.Keyring
	}
	return ""
}

func (m *RBDVolumeSource) GetSecretRef() *LocalObjectReference {
	if m != nil {
		return m.SecretRef
	}
	return nil
}

func (m *RBDVolumeSource) GetReadOnly() bool {
	if m != nil {
		return m.ReadOnly
	}
	return false
}

// RangeAllocation is not a public type.
type RangeAllocation struct {
	// Standard object's metadata.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
	// +optional
	Metadata *v1.ObjectMeta `protobuf:"bytes,1,opt,name=metadata" json:"metadata,omitempty"`
	// Range is string that identifies the range represented by 'data'.
	Range string `protobuf:"bytes,2,opt,name=range" json:"range"`
	// Data is a bit array containing all allocated addresses in the previous segment.
	Data []byte `protobuf:"bytes,3,opt,name=data" json:"data"`
}

func (m *RangeAllocation) Reset()      { *m = RangeAllocation{} }
func (*RangeAllocation) ProtoMessage() {}
func (*RangeAllocation) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{148}
}
func (m *RangeAllocation) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RangeAllocation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RangeAllocation.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RangeAllocation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RangeAllocation.Merge(m, src)
}
func (m *RangeAllocation) XXX_Size() int {
	return m.Size()
}
func (m *RangeAllocation) XXX_DiscardUnknown() {
	xxx_messageInfo_RangeAllocation.DiscardUnknown(m)
}

var xxx_messageInfo_RangeAllocation proto.InternalMessageInfo

func (m *RangeAllocation) GetMetadata() *v1.ObjectMeta {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *RangeAllocation) GetRange() string {
	if m != nil {
		return m.Range
	}
	return ""
}

func (m *RangeAllocation) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

// ReplicationController represents the configuration of a replication controller.
type ReplicationController struct {
	// If the Labels of a ReplicationController are empty, they are defaulted to
	// be the same as the Pod(s) that the replication controller manages.
	// Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
	// +optional
	Metadata *v1.ObjectMeta `protobuf:"bytes,1,opt,name=metadata" json:"metadata,omitempty"`
	// Spec defines the specification of the desired behavior of the replication controller.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status
	// +optional
	Spec *ReplicationControllerSpec `protobuf:"bytes,2,opt,name=spec" json:"spec,omitempty"`
	// Status is the most recently observed status of the replication controller.
	// This data may be out of date by some window of time.
	// Populated by the system.
	// Read-only.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status
	// +optional
	Status *ReplicationControllerStatus `protobuf:"bytes,3,opt,name=status" json:"status,omitempty"`
}

func (m *ReplicationController) Reset()      { *m = ReplicationController{} }
func (*ReplicationController) ProtoMessage() {}
func (*ReplicationController) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{149}
}
func (m *ReplicationController) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ReplicationController) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ReplicationController.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ReplicationController) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReplicationController.Merge(m, src)
}
func (m *ReplicationController) XXX_Size() int {
	return m.Size()
}
func (m *ReplicationController) XXX_DiscardUnknown() {
	xxx_messageInfo_ReplicationController.DiscardUnknown(m)
}

var xxx_messageInfo_ReplicationController proto.InternalMessageInfo

func (m *ReplicationController) GetMetadata() *v1.ObjectMeta {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *ReplicationController) GetSpec() *ReplicationControllerSpec {
	if m != nil {
		return m.Spec
	}
	return nil
}

func (m *ReplicationController) GetStatus() *ReplicationControllerStatus {
	if m != nil {
		return m.Status
	}
	return nil
}

// ReplicationControllerCondition describes the state of a replication controller at a certain point.
type ReplicationControllerCondition struct {
	// Type of replication controller condition.
	Type string `protobuf:"bytes,1,opt,name=type" json:"type"`
	// Status of the condition, one of True, False, Unknown.
	Status string `protobuf:"bytes,2,opt,name=status" json:"status"`
	// The last time the condition transitioned from one status to another.
	// +optional
	LastTransitionTime *v1.Time `protobuf:"bytes,3,opt,name=lastTransitionTime" json:"lastTransitionTime,omitempty"`
	// The reason for the condition's last transition.
	// +optional
	Reason string `protobuf:"bytes,4,opt,name=reason" json:"reason"`
	// A human readable message indicating details about the transition.
	// +optional
	Message string `protobuf:"bytes,5,opt,name=message" json:"message"`
}

func (m *ReplicationControllerCondition) Reset()      { *m = ReplicationControllerCondition{} }
func (*ReplicationControllerCondition) ProtoMessage() {}
func (*ReplicationControllerCondition) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{150}
}
func (m *ReplicationControllerCondition) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ReplicationControllerCondition) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ReplicationControllerCondition.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ReplicationControllerCondition) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReplicationControllerCondition.Merge(m, src)
}
func (m *ReplicationControllerCondition) XXX_Size() int {
	return m.Size()
}
func (m *ReplicationControllerCondition) XXX_DiscardUnknown() {
	xxx_messageInfo_ReplicationControllerCondition.DiscardUnknown(m)
}

var xxx_messageInfo_ReplicationControllerCondition proto.InternalMessageInfo

func (m *ReplicationControllerCondition) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *ReplicationControllerCondition) GetStatus() string {
	if m != nil {
		return m.Status
	}
	return ""
}

func (m *ReplicationControllerCondition) GetLastTransitionTime() *v1.Time {
	if m != nil {
		return m.LastTransitionTime
	}
	return nil
}

func (m *ReplicationControllerCondition) GetReason() string {
	if m != nil {
		return m.Reason
	}
	return ""
}

func (m *ReplicationControllerCondition) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

// ReplicationControllerList is a collection of replication controllers.
type ReplicationControllerList struct {
	// Standard list metadata.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds
	// +optional
	Metadata *v1.ListMeta `protobuf:"bytes,1,opt,name=metadata" json:"metadata,omitempty"`
	// List of replication controllers.
	// More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller
	Items []*ReplicationController `protobuf:"bytes,2,rep,name=items" json:"items,omitempty"`
}

func (m *ReplicationControllerList) Reset()      { *m = ReplicationControllerList{} }
func (*ReplicationControllerList) ProtoMessage() {}
func (*ReplicationControllerList) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{151}
}
func (m *ReplicationControllerList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ReplicationControllerList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ReplicationControllerList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ReplicationControllerList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReplicationControllerList.Merge(m, src)
}
func (m *ReplicationControllerList) XXX_Size() int {
	return m.Size()
}
func (m *ReplicationControllerList) XXX_DiscardUnknown() {
	xxx_messageInfo_ReplicationControllerList.DiscardUnknown(m)
}

var xxx_messageInfo_ReplicationControllerList proto.InternalMessageInfo

func (m *ReplicationControllerList) GetMetadata() *v1.ListMeta {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *ReplicationControllerList) GetItems() []*ReplicationController {
	if m != nil {
		return m.Items
	}
	return nil
}

// ReplicationControllerSpec is the specification of a replication controller.
type ReplicationControllerSpec struct {
	// Replicas is the number of desired replicas.
	// This is a pointer to distinguish between explicit zero and unspecified.
	// Defaults to 1.
	// More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#what-is-a-replicationcontroller
	// +optional
	Replicas int32 `protobuf:"varint,1,opt,name=replicas" json:"replicas"`
	// Minimum number of seconds for which a newly created pod should be ready
	// without any of its container crashing, for it to be considered available.
	// Defaults to 0 (pod will be considered available as soon as it is ready)
	// +optional
	MinReadySeconds int32 `protobuf:"varint,4,opt,name=minReadySeconds" json:"minReadySeconds"`
	// Selector is a label query over pods that should match the Replicas count.
	// If Selector is empty, it is defaulted to the labels present on the Pod template.
	// Label keys and values that must match in order to be controlled by this replication
	// controller, if empty defaulted to labels on Pod template.
	// More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
	// +optional
	Selector map[string]string `protobuf:"bytes,2,rep,name=selector" json:"selector,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Template is the object that describes the pod that will be created if
	// insufficient replicas are detected. This takes precedence over a TemplateRef.
	// More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#pod-template
	// +optional
	Template *PodTemplateSpec `protobuf:"bytes,3,opt,name=template" json:"template,omitempty"`
}

func (m *ReplicationControllerSpec) Reset()      { *m = ReplicationControllerSpec{} }
func (*ReplicationControllerSpec) ProtoMessage() {}
func (*ReplicationControllerSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{152}
}
func (m *ReplicationControllerSpec) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ReplicationControllerSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ReplicationControllerSpec.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ReplicationControllerSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReplicationControllerSpec.Merge(m, src)
}
func (m *ReplicationControllerSpec) XXX_Size() int {
	return m.Size()
}
func (m *ReplicationControllerSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_ReplicationControllerSpec.DiscardUnknown(m)
}

var xxx_messageInfo_ReplicationControllerSpec proto.InternalMessageInfo

func (m *ReplicationControllerSpec) GetReplicas() int32 {
	if m != nil {
		return m.Replicas
	}
	return 0
}

func (m *ReplicationControllerSpec) GetMinReadySeconds() int32 {
	if m != nil {
		return m.MinReadySeconds
	}
	return 0
}

func (m *ReplicationControllerSpec) GetSelector() map[string]string {
	if m != nil {
		return m.Selector
	}
	return nil
}

func (m *ReplicationControllerSpec) GetTemplate() *PodTemplateSpec {
	if m != nil {
		return m.Template
	}
	return nil
}

// ReplicationControllerStatus represents the current status of a replication
// controller.
type ReplicationControllerStatus struct {
	// Replicas is the most recently oberved number of replicas.
	// More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#what-is-a-replicationcontroller
	Replicas int32 `protobuf:"varint,1,opt,name=replicas" json:"replicas"`
	// The number of pods that have labels matching the labels of the pod template of the replication controller.
	// +optional
	FullyLabeledReplicas int32 `protobuf:"varint,2,opt,name=fullyLabeledReplicas" json:"fullyLabeledReplicas"`
	// The number of ready replicas for this replication controller.
	// +optional
	ReadyReplicas int32 `protobuf:"varint,4,opt,name=readyReplicas" json:"readyReplicas"`
	// The number of available replicas (ready for at least minReadySeconds) for this replication controller.
	// +optional
	AvailableReplicas int32 `protobuf:"varint,5,opt,name=availableReplicas" json:"availableReplicas"`
	// ObservedGeneration reflects the generation of the most recently observed replication controller.
	// +optional
	ObservedGeneration int64 `protobuf:"varint,3,opt,name=observedGeneration" json:"observedGeneration"`
	// Represents the latest available observations of a replication controller's current state.
	// +optional
	// +patchMergeKey=type
	// +patchStrategy=merge
	Conditions []*ReplicationControllerCondition `protobuf:"bytes,6,rep,name=conditions" json:"conditions,omitempty"`
}

func (m *ReplicationControllerStatus) Reset()      { *m = ReplicationControllerStatus{} }
func (*ReplicationControllerStatus) ProtoMessage() {}
func (*ReplicationControllerStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{153}
}
func (m *ReplicationControllerStatus) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ReplicationControllerStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ReplicationControllerStatus.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ReplicationControllerStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReplicationControllerStatus.Merge(m, src)
}
func (m *ReplicationControllerStatus) XXX_Size() int {
	return m.Size()
}
func (m *ReplicationControllerStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_ReplicationControllerStatus.DiscardUnknown(m)
}

var xxx_messageInfo_ReplicationControllerStatus proto.InternalMessageInfo

func (m *ReplicationControllerStatus) GetReplicas() int32 {
	if m != nil {
		return m.Replicas
	}
	return 0
}

func (m *ReplicationControllerStatus) GetFullyLabeledReplicas() int32 {
	if m != nil {
		return m.FullyLabeledReplicas
	}
	return 0
}

func (m *ReplicationControllerStatus) GetReadyReplicas() int32 {
	if m != nil {
		return m.ReadyReplicas
	}
	return 0
}

func (m *ReplicationControllerStatus) GetAvailableReplicas() int32 {
	if m != nil {
		return m.AvailableReplicas
	}
	return 0
}

func (m *ReplicationControllerStatus) GetObservedGeneration() int64 {
	if m != nil {
		return m.ObservedGeneration
	}
	return 0
}

func (m *ReplicationControllerStatus) GetConditions() []*ReplicationControllerCondition {
	if m != nil {
		return m.Conditions
	}
	return nil
}

// ResourceFieldSelector represents container resources (cpu, memory) and their output format
type ResourceFieldSelector struct {
	// Container name: required for volumes, optional for env vars
	// +optional
	ContainerName string `protobuf:"bytes,1,opt,name=containerName" json:"containerName"`
	// Required: resource to select
	Resource string `protobuf:"bytes,2,opt,name=resource" json:"resource"`
	// Specifies the output format of the exposed resources, defaults to "1"
	// +optional
	Divisor *resource.Quantity `protobuf:"bytes,3,opt,name=divisor" json:"divisor,omitempty"`
}

func (m *ResourceFieldSelector) Reset()      { *m = ResourceFieldSelector{} }
func (*ResourceFieldSelector) ProtoMessage() {}
func (*ResourceFieldSelector) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{154}
}
func (m *ResourceFieldSelector) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ResourceFieldSelector) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ResourceFieldSelector.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ResourceFieldSelector) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResourceFieldSelector.Merge(m, src)
}
func (m *ResourceFieldSelector) XXX_Size() int {
	return m.Size()
}
func (m *ResourceFieldSelector) XXX_DiscardUnknown() {
	xxx_messageInfo_ResourceFieldSelector.DiscardUnknown(m)
}

var xxx_messageInfo_ResourceFieldSelector proto.InternalMessageInfo

func (m *ResourceFieldSelector) GetContainerName() string {
	if m != nil {
		return m.ContainerName
	}
	return ""
}

func (m *ResourceFieldSelector) GetResource() string {
	if m != nil {
		return m.Resource
	}
	return ""
}

func (m *ResourceFieldSelector) GetDivisor() *resource.Quantity {
	if m != nil {
		return m.Divisor
	}
	return nil
}

// ResourceQuota sets aggregate quota restrictions enforced per namespace
type ResourceQuota struct {
	// Standard object's metadata.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
	// +optional
	Metadata *v1.ObjectMeta `protobuf:"bytes,1,opt,name=metadata" json:"metadata,omitempty"`
	// Spec defines the desired quota.
	// https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status
	// +optional
	Spec *ResourceQuotaSpec `protobuf:"bytes,2,opt,name=spec" json:"spec,omitempty"`
	// Status defines the actual enforced quota and its current usage.
	// https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status
	// +optional
	Status *ResourceQuotaStatus `protobuf:"bytes,3,opt,name=status" json:"status,omitempty"`
}

func (m *ResourceQuota) Reset()      { *m = ResourceQuota{} }
func (*ResourceQuota) ProtoMessage() {}
func (*ResourceQuota) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{155}
}
func (m *ResourceQuota) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ResourceQuota) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ResourceQuota.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ResourceQuota) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResourceQuota.Merge(m, src)
}
func (m *ResourceQuota) XXX_Size() int {
	return m.Size()
}
func (m *ResourceQuota) XXX_DiscardUnknown() {
	xxx_messageInfo_ResourceQuota.DiscardUnknown(m)
}

var xxx_messageInfo_ResourceQuota proto.InternalMessageInfo

func (m *ResourceQuota) GetMetadata() *v1.ObjectMeta {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *ResourceQuota) GetSpec() *ResourceQuotaSpec {
	if m != nil {
		return m.Spec
	}
	return nil
}

func (m *ResourceQuota) GetStatus() *ResourceQuotaStatus {
	if m != nil {
		return m.Status
	}
	return nil
}

// ResourceQuotaList is a list of ResourceQuota items.
type ResourceQuotaList struct {
	// Standard list metadata.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds
	// +optional
	Metadata *v1.ListMeta `protobuf:"bytes,1,opt,name=metadata" json:"metadata,omitempty"`
	// Items is a list of ResourceQuota objects.
	// More info: https://kubernetes.io/docs/concepts/policy/resource-quotas/
	Items []*ResourceQuota `protobuf:"bytes,2,rep,name=items" json:"items,omitempty"`
}

func (m *ResourceQuotaList) Reset()      { *m = ResourceQuotaList{} }
func (*ResourceQuotaList) ProtoMessage() {}
func (*ResourceQuotaList) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{156}
}
func (m *ResourceQuotaList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ResourceQuotaList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ResourceQuotaList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ResourceQuotaList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResourceQuotaList.Merge(m, src)
}
func (m *ResourceQuotaList) XXX_Size() int {
	return m.Size()
}
func (m *ResourceQuotaList) XXX_DiscardUnknown() {
	xxx_messageInfo_ResourceQuotaList.DiscardUnknown(m)
}

var xxx_messageInfo_ResourceQuotaList proto.InternalMessageInfo

func (m *ResourceQuotaList) GetMetadata() *v1.ListMeta {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *ResourceQuotaList) GetItems() []*ResourceQuota {
	if m != nil {
		return m.Items
	}
	return nil
}

// ResourceQuotaSpec defines the desired hard limits to enforce for Quota.
type ResourceQuotaSpec struct {
	// hard is the set of desired hard limits for each named resource.
	// More info: https://kubernetes.io/docs/concepts/policy/resource-quotas/
	// +optional
	Hard map[string]*resource.Quantity `protobuf:"bytes,1,rep,name=hard" json:"hard,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// A collection of filters that must match each object tracked by a quota.
	// If not specified, the quota matches all objects.
	// +optional
	Scopes []string `protobuf:"bytes,2,rep,name=scopes" json:"scopes,omitempty"`
	// scopeSelector is also a collection of filters like scopes that must match each object tracked by a quota
	// but expressed using ScopeSelectorOperator in combination with possible values.
	// For a resource to match, both scopes AND scopeSelector (if specified in spec), must be matched.
	// +optional
	ScopeSelector *ScopeSelector `protobuf:"bytes,3,opt,name=scopeSelector" json:"scopeSelector,omitempty"`
}

func (m *ResourceQuotaSpec) Reset()      { *m = ResourceQuotaSpec{} }
func (*ResourceQuotaSpec) ProtoMessage() {}
func (*ResourceQuotaSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{157}
}
func (m *ResourceQuotaSpec) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ResourceQuotaSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ResourceQuotaSpec.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ResourceQuotaSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResourceQuotaSpec.Merge(m, src)
}
func (m *ResourceQuotaSpec) XXX_Size() int {
	return m.Size()
}
func (m *ResourceQuotaSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_ResourceQuotaSpec.DiscardUnknown(m)
}

var xxx_messageInfo_ResourceQuotaSpec proto.InternalMessageInfo

func (m *ResourceQuotaSpec) GetHard() map[string]*resource.Quantity {
	if m != nil {
		return m.Hard
	}
	return nil
}

func (m *ResourceQuotaSpec) GetScopes() []string {
	if m != nil {
		return m.Scopes
	}
	return nil
}

func (m *ResourceQuotaSpec) GetScopeSelector() *ScopeSelector {
	if m != nil {
		return m.ScopeSelector
	}
	return nil
}

// ResourceQuotaStatus defines the enforced hard limits and observed use.
type ResourceQuotaStatus struct {
	// Hard is the set of enforced hard limits for each named resource.
	// More info: https://kubernetes.io/docs/concepts/policy/resource-quotas/
	// +optional
	Hard map[string]*resource.Quantity `protobuf:"bytes,1,rep,name=hard" json:"hard,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Used is the current observed total usage of the resource in the namespace.
	// +optional
	Used map[string]*resource.Quantity `protobuf:"bytes,2,rep,name=used" json:"used,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *ResourceQuotaStatus) Reset()      { *m = ResourceQuotaStatus{} }
func (*ResourceQuotaStatus) ProtoMessage() {}
func (*ResourceQuotaStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{158}
}
func (m *ResourceQuotaStatus) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ResourceQuotaStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ResourceQuotaStatus.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ResourceQuotaStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResourceQuotaStatus.Merge(m, src)
}
func (m *ResourceQuotaStatus) XXX_Size() int {
	return m.Size()
}
func (m *ResourceQuotaStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_ResourceQuotaStatus.DiscardUnknown(m)
}

var xxx_messageInfo_ResourceQuotaStatus proto.InternalMessageInfo

func (m *ResourceQuotaStatus) GetHard() map[string]*resource.Quantity {
	if m != nil {
		return m.Hard
	}
	return nil
}

func (m *ResourceQuotaStatus) GetUsed() map[string]*resource.Quantity {
	if m != nil {
		return m.Used
	}
	return nil
}

// ResourceRequirements describes the compute resource requirements.
type ResourceRequirements struct {
	// Limits describes the maximum amount of compute resources allowed.
	// More info: https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
	// +optional
	Limits map[string]*resource.Quantity `protobuf:"bytes,1,rep,name=limits" json:"limits,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Requests describes the minimum amount of compute resources required.
	// If Requests is omitted for a container, it defaults to Limits if that is explicitly specified,
	// otherwise to an implementation-defined value.
	// More info: https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
	// +optional
	Requests map[string]*resource.Quantity `protobuf:"bytes,2,rep,name=requests" json:"requests,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *ResourceRequirements) Reset()      { *m = ResourceRequirements{} }
func (*ResourceRequirements) ProtoMessage() {}
func (*ResourceRequirements) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{159}
}
func (m *ResourceRequirements) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ResourceRequirements) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ResourceRequirements.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ResourceRequirements) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResourceRequirements.Merge(m, src)
}
func (m *ResourceRequirements) XXX_Size() int {
	return m.Size()
}
func (m *ResourceRequirements) XXX_DiscardUnknown() {
	xxx_messageInfo_ResourceRequirements.DiscardUnknown(m)
}

var xxx_messageInfo_ResourceRequirements proto.InternalMessageInfo

func (m *ResourceRequirements) GetLimits() map[string]*resource.Quantity {
	if m != nil {
		return m.Limits
	}
	return nil
}

func (m *ResourceRequirements) GetRequests() map[string]*resource.Quantity {
	if m != nil {
		return m.Requests
	}
	return nil
}

// SELinuxOptions are the labels to be applied to the container
type SELinuxOptions struct {
	// User is a SELinux user label that applies to the container.
	// +optional
	User string `protobuf:"bytes,1,opt,name=user" json:"user"`
	// Role is a SELinux role label that applies to the container.
	// +optional
	Role string `protobuf:"bytes,2,opt,name=role" json:"role"`
	// Type is a SELinux type label that applies to the container.
	// +optional
	Type string `protobuf:"bytes,3,opt,name=type" json:"type"`
	// Level is SELinux level label that applies to the container.
	// +optional
	Level string `protobuf:"bytes,4,opt,name=level" json:"level"`
}

func (m *SELinuxOptions) Reset()      { *m = SELinuxOptions{} }
func (*SELinuxOptions) ProtoMessage() {}
func (*SELinuxOptions) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{160}
}
func (m *SELinuxOptions) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SELinuxOptions) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SELinuxOptions.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SELinuxOptions) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SELinuxOptions.Merge(m, src)
}
func (m *SELinuxOptions) XXX_Size() int {
	return m.Size()
}
func (m *SELinuxOptions) XXX_DiscardUnknown() {
	xxx_messageInfo_SELinuxOptions.DiscardUnknown(m)
}

var xxx_messageInfo_SELinuxOptions proto.InternalMessageInfo

func (m *SELinuxOptions) GetUser() string {
	if m != nil {
		return m.User
	}
	return ""
}

func (m *SELinuxOptions) GetRole() string {
	if m != nil {
		return m.Role
	}
	return ""
}

func (m *SELinuxOptions) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *SELinuxOptions) GetLevel() string {
	if m != nil {
		return m.Level
	}
	return ""
}

// ScaleIOPersistentVolumeSource represents a persistent ScaleIO volume
type ScaleIOPersistentVolumeSource struct {
	// The host address of the ScaleIO API Gateway.
	Gateway string `protobuf:"bytes,1,opt,name=gateway" json:"gateway"`
	// The name of the storage system as configured in ScaleIO.
	System string `protobuf:"bytes,2,opt,name=system" json:"system"`
	// SecretRef references to the secret for ScaleIO user and other
	// sensitive information. If this is not provided, Login operation will fail.
	SecretRef *SecretReference `protobuf:"bytes,3,opt,name=secretRef" json:"secretRef,omitempty"`
	// Flag to enable/disable SSL communication with Gateway, default false
	// +optional
	SslEnabled bool `protobuf:"varint,4,opt,name=sslEnabled" json:"sslEnabled"`
	// The name of the ScaleIO Protection Domain for the configured storage.
	// +optional
	ProtectionDomain string `protobuf:"bytes,5,opt,name=protectionDomain" json:"protectionDomain"`
	// The ScaleIO Storage Pool associated with the protection domain.
	// +optional
	StoragePool string `protobuf:"bytes,6,opt,name=storagePool" json:"storagePool"`
	// Indicates whether the storage for a volume should be ThickProvisioned or ThinProvisioned.
	// Default is ThinProvisioned.
	// +optional
	StorageMode string `protobuf:"bytes,7,opt,name=storageMode" json:"storageMode"`
	// The name of a volume already created in the ScaleIO system
	// that is associated with this volume source.
	VolumeName string `protobuf:"bytes,8,opt,name=volumeName" json:"volumeName"`
	// Filesystem type to mount.
	// Must be a filesystem type supported by the host operating system.
	// Ex. "ext4", "xfs", "ntfs".
	// Default is "xfs"
	// +optional
	FsType string `protobuf:"bytes,9,opt,name=fsType" json:"fsType"`
	// Defaults to false (read/write). ReadOnly here will force
	// the ReadOnly setting in VolumeMounts.
	// +optional
	ReadOnly bool `protobuf:"varint,10,opt,name=readOnly" json:"readOnly"`
}

func (m *ScaleIOPersistentVolumeSource) Reset()      { *m = ScaleIOPersistentVolumeSource{} }
func (*ScaleIOPersistentVolumeSource) ProtoMessage() {}
func (*ScaleIOPersistentVolumeSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{161}
}
func (m *ScaleIOPersistentVolumeSource) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ScaleIOPersistentVolumeSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ScaleIOPersistentVolumeSource.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ScaleIOPersistentVolumeSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ScaleIOPersistentVolumeSource.Merge(m, src)
}
func (m *ScaleIOPersistentVolumeSource) XXX_Size() int {
	return m.Size()
}
func (m *ScaleIOPersistentVolumeSource) XXX_DiscardUnknown() {
	xxx_messageInfo_ScaleIOPersistentVolumeSource.DiscardUnknown(m)
}

var xxx_messageInfo_ScaleIOPersistentVolumeSource proto.InternalMessageInfo

func (m *ScaleIOPersistentVolumeSource) GetGateway() string {
	if m != nil {
		return m.Gateway
	}
	return ""
}

func (m *ScaleIOPersistentVolumeSource) GetSystem() string {
	if m != nil {
		return m.System
	}
	return ""
}

func (m *ScaleIOPersistentVolumeSource) GetSecretRef() *SecretReference {
	if m != nil {
		return m.SecretRef
	}
	return nil
}

func (m *ScaleIOPersistentVolumeSource) GetSslEnabled() bool {
	if m != nil {
		return m.SslEnabled
	}
	return false
}

func (m *ScaleIOPersistentVolumeSource) GetProtectionDomain() string {
	if m != nil {
		return m.ProtectionDomain
	}
	return ""
}

func (m *ScaleIOPersistentVolumeSource) GetStoragePool() string {
	if m != nil {
		return m.StoragePool
	}
	return ""
}

func (m *ScaleIOPersistentVolumeSource) GetStorageMode() string {
	if m != nil {
		return m.StorageMode
	}
	return ""
}

func (m *ScaleIOPersistentVolumeSource) GetVolumeName() string {
	if m != nil {
		return m.VolumeName
	}
	return ""
}

func (m *ScaleIOPersistentVolumeSource) GetFsType() string {
	if m != nil {
		return m.FsType
	}
	return ""
}

func (m *ScaleIOPersistentVolumeSource) GetReadOnly() bool {
	if m != nil {
		return m.ReadOnly
	}
	return false
}

// ScaleIOVolumeSource represents a persistent ScaleIO volume
type ScaleIOVolumeSource struct {
	// The host address of the ScaleIO API Gateway.
	Gateway string `protobuf:"bytes,1,opt,name=gateway" json:"gateway"`
	// The name of the storage system as configured in ScaleIO.
	System string `protobuf:"bytes,2,opt,name=system" json:"system"`
	// SecretRef references to the secret for ScaleIO user and other
	// sensitive information. If this is not provided, Login operation will fail.
	SecretRef *LocalObjectReference `protobuf:"bytes,3,opt,name=secretRef" json:"secretRef,omitempty"`
	// Flag to enable/disable SSL communication with Gateway, default false
	// +optional
	SslEnabled bool `protobuf:"varint,4,opt,name=sslEnabled" json:"sslEnabled"`
	// The name of the ScaleIO Protection Domain for the configured storage.
	// +optional
	ProtectionDomain string `protobuf:"bytes,5,opt,name=protectionDomain" json:"protectionDomain"`
	// The ScaleIO Storage Pool associated with the protection domain.
	// +optional
	StoragePool string `protobuf:"bytes,6,opt,name=storagePool" json:"storagePool"`
	// Indicates whether the storage for a volume should be ThickProvisioned or ThinProvisioned.
	// Default is ThinProvisioned.
	// +optional
	StorageMode string `protobuf:"bytes,7,opt,name=storageMode" json:"storageMode"`
	// The name of a volume already created in the ScaleIO system
	// that is associated with this volume source.
	VolumeName string `protobuf:"bytes,8,opt,name=volumeName" json:"volumeName"`
	// Filesystem type to mount.
	// Must be a filesystem type supported by the host operating system.
	// Ex. "ext4", "xfs", "ntfs".
	// Default is "xfs".
	// +optional
	FsType string `protobuf:"bytes,9,opt,name=fsType" json:"fsType"`
	// Defaults to false (read/write). ReadOnly here will force
	// the ReadOnly setting in VolumeMounts.
	// +optional
	ReadOnly bool `protobuf:"varint,10,opt,name=readOnly" json:"readOnly"`
}

func (m *ScaleIOVolumeSource) Reset()      { *m = ScaleIOVolumeSource{} }
func (*ScaleIOVolumeSource) ProtoMessage() {}
func (*ScaleIOVolumeSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{162}
}
func (m *ScaleIOVolumeSource) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ScaleIOVolumeSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ScaleIOVolumeSource.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ScaleIOVolumeSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ScaleIOVolumeSource.Merge(m, src)
}
func (m *ScaleIOVolumeSource) XXX_Size() int {
	return m.Size()
}
func (m *ScaleIOVolumeSource) XXX_DiscardUnknown() {
	xxx_messageInfo_ScaleIOVolumeSource.DiscardUnknown(m)
}

var xxx_messageInfo_ScaleIOVolumeSource proto.InternalMessageInfo

func (m *ScaleIOVolumeSource) GetGateway() string {
	if m != nil {
		return m.Gateway
	}
	return ""
}

func (m *ScaleIOVolumeSource) GetSystem() string {
	if m != nil {
		return m.System
	}
	return ""
}

func (m *ScaleIOVolumeSource) GetSecretRef() *LocalObjectReference {
	if m != nil {
		return m.SecretRef
	}
	return nil
}

func (m *ScaleIOVolumeSource) GetSslEnabled() bool {
	if m != nil {
		return m.SslEnabled
	}
	return false
}

func (m *ScaleIOVolumeSource) GetProtectionDomain() string {
	if m != nil {
		return m.ProtectionDomain
	}
	return ""
}

func (m *ScaleIOVolumeSource) GetStoragePool() string {
	if m != nil {
		return m.StoragePool
	}
	return ""
}

func (m *ScaleIOVolumeSource) GetStorageMode() string {
	if m != nil {
		return m.StorageMode
	}
	return ""
}

func (m *ScaleIOVolumeSource) GetVolumeName() string {
	if m != nil {
		return m.VolumeName
	}
	return ""
}

func (m *ScaleIOVolumeSource) GetFsType() string {
	if m != nil {
		return m.FsType
	}
	return ""
}

func (m *ScaleIOVolumeSource) GetReadOnly() bool {
	if m != nil {
		return m.ReadOnly
	}
	return false
}

// A scope selector represents the AND of the selectors represented
// by the scoped-resource selector requirements.
type ScopeSelector struct {
	// A list of scope selector requirements by scope of the resources.
	// +optional
	MatchExpressions []*ScopedResourceSelectorRequirement `protobuf:"bytes,1,rep,name=matchExpressions" json:"matchExpressions,omitempty"`
}

func (m *ScopeSelector) Reset()      { *m = ScopeSelector{} }
func (*ScopeSelector) ProtoMessage() {}
func (*ScopeSelector) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{163}
}
func (m *ScopeSelector) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ScopeSelector) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ScopeSelector.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ScopeSelector) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ScopeSelector.Merge(m, src)
}
func (m *ScopeSelector) XXX_Size() int {
	return m.Size()
}
func (m *ScopeSelector) XXX_DiscardUnknown() {
	xxx_messageInfo_ScopeSelector.DiscardUnknown(m)
}

var xxx_messageInfo_ScopeSelector proto.InternalMessageInfo

func (m *ScopeSelector) GetMatchExpressions() []*ScopedResourceSelectorRequirement {
	if m != nil {
		return m.MatchExpressions
	}
	return nil
}

// A scoped-resource selector requirement is a selector that contains values, a scope name, and an operator
// that relates the scope name and values.
type ScopedResourceSelectorRequirement struct {
	// The name of the scope that the selector applies to.
	ScopeName string `protobuf:"bytes,1,opt,name=scopeName" json:"scopeName"`
	// Represents a scope's relationship to a set of values.
	// Valid operators are In, NotIn, Exists, DoesNotExist.
	Operator string `protobuf:"bytes,2,opt,name=operator" json:"operator"`
	// An array of string values. If the operator is In or NotIn,
	// the values array must be non-empty. If the operator is Exists or DoesNotExist,
	// the values array must be empty.
	// This array is replaced during a strategic merge patch.
	// +optional
	Values []string `protobuf:"bytes,3,rep,name=values" json:"values,omitempty"`
}

func (m *ScopedResourceSelectorRequirement) Reset()      { *m = ScopedResourceSelectorRequirement{} }
func (*ScopedResourceSelectorRequirement) ProtoMessage() {}
func (*ScopedResourceSelectorRequirement) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{164}
}
func (m *ScopedResourceSelectorRequirement) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ScopedResourceSelectorRequirement) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ScopedResourceSelectorRequirement.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ScopedResourceSelectorRequirement) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ScopedResourceSelectorRequirement.Merge(m, src)
}
func (m *ScopedResourceSelectorRequirement) XXX_Size() int {
	return m.Size()
}
func (m *ScopedResourceSelectorRequirement) XXX_DiscardUnknown() {
	xxx_messageInfo_ScopedResourceSelectorRequirement.DiscardUnknown(m)
}

var xxx_messageInfo_ScopedResourceSelectorRequirement proto.InternalMessageInfo

func (m *ScopedResourceSelectorRequirement) GetScopeName() string {
	if m != nil {
		return m.ScopeName
	}
	return ""
}

func (m *ScopedResourceSelectorRequirement) GetOperator() string {
	if m != nil {
		return m.Operator
	}
	return ""
}

func (m *ScopedResourceSelectorRequirement) GetValues() []string {
	if m != nil {
		return m.Values
	}
	return nil
}

// Secret holds secret data of a certain type. The total bytes of the values in
// the Data field must be less than MaxSecretSize bytes.
type Secret struct {
	// Standard object's metadata.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
	// +optional
	Metadata *v1.ObjectMeta `protobuf:"bytes,1,opt,name=metadata" json:"metadata,omitempty"`
	// Data contains the secret data. Each key must consist of alphanumeric
	// characters, '-', '_' or '.'. The serialized form of the secret data is a
	// base64 encoded string, representing the arbitrary (possibly non-string)
	// data value here. Described in https://tools.ietf.org/html/rfc4648#section-4
	// +optional
	Data map[string][]byte `protobuf:"bytes,2,rep,name=data" json:"data,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// stringData allows specifying non-binary secret data in string form.
	// It is provided as a write-only convenience method.
	// All keys and values are merged into the data field on write, overwriting any existing values.
	// It is never output when reading from the API.
	// +k8s:conversion-gen=false
	// +optional
	StringData map[string]string `protobuf:"bytes,4,rep,name=stringData" json:"stringData,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Used to facilitate programmatic handling of secret data.
	// +optional
	Type string `protobuf:"bytes,3,opt,name=type" json:"type"`
}

func (m *Secret) Reset()      { *m = Secret{} }
func (*Secret) ProtoMessage() {}
func (*Secret) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{165}
}
func (m *Secret) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Secret) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Secret.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Secret) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Secret.Merge(m, src)
}
func (m *Secret) XXX_Size() int {
	return m.Size()
}
func (m *Secret) XXX_DiscardUnknown() {
	xxx_messageInfo_Secret.DiscardUnknown(m)
}

var xxx_messageInfo_Secret proto.InternalMessageInfo

func (m *Secret) GetMetadata() *v1.ObjectMeta {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *Secret) GetData() map[string][]byte {
	if m != nil {
		return m.Data
	}
	return nil
}

func (m *Secret) GetStringData() map[string]string {
	if m != nil {
		return m.StringData
	}
	return nil
}

func (m *Secret) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

// SecretEnvSource selects a Secret to populate the environment
// variables with.
//
// The contents of the target Secret's Data field will represent the
// key-value pairs as environment variables.
type SecretEnvSource struct {
	// The Secret to select from.
	LocalObjectReference *LocalObjectReference `protobuf:"bytes,1,opt,name=localObjectReference" json:"localObjectReference,omitempty"`
	// Specify whether the Secret must be defined
	// +optional
	Optional bool `protobuf:"varint,2,opt,name=optional" json:"optional"`
}

func (m *SecretEnvSource) Reset()      { *m = SecretEnvSource{} }
func (*SecretEnvSource) ProtoMessage() {}
func (*SecretEnvSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{166}
}
func (m *SecretEnvSource) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SecretEnvSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SecretEnvSource.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SecretEnvSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SecretEnvSource.Merge(m, src)
}
func (m *SecretEnvSource) XXX_Size() int {
	return m.Size()
}
func (m *SecretEnvSource) XXX_DiscardUnknown() {
	xxx_messageInfo_SecretEnvSource.DiscardUnknown(m)
}

var xxx_messageInfo_SecretEnvSource proto.InternalMessageInfo

func (m *SecretEnvSource) GetLocalObjectReference() *LocalObjectReference {
	if m != nil {
		return m.LocalObjectReference
	}
	return nil
}

func (m *SecretEnvSource) GetOptional() bool {
	if m != nil {
		return m.Optional
	}
	return false
}

// SecretKeySelector selects a key of a Secret.
type SecretKeySelector struct {
	// The name of the secret in the pod's namespace to select from.
	LocalObjectReference *LocalObjectReference `protobuf:"bytes,1,opt,name=localObjectReference" json:"localObjectReference,omitempty"`
	// The key of the secret to select from.  Must be a valid secret key.
	Key string `protobuf:"bytes,2,opt,name=key" json:"key"`
	// Specify whether the Secret or its key must be defined
	// +optional
	Optional bool `protobuf:"varint,3,opt,name=optional" json:"optional"`
}

func (m *SecretKeySelector) Reset()      { *m = SecretKeySelector{} }
func (*SecretKeySelector) ProtoMessage() {}
func (*SecretKeySelector) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{167}
}
func (m *SecretKeySelector) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SecretKeySelector) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SecretKeySelector.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SecretKeySelector) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SecretKeySelector.Merge(m, src)
}
func (m *SecretKeySelector) XXX_Size() int {
	return m.Size()
}
func (m *SecretKeySelector) XXX_DiscardUnknown() {
	xxx_messageInfo_SecretKeySelector.DiscardUnknown(m)
}

var xxx_messageInfo_SecretKeySelector proto.InternalMessageInfo

func (m *SecretKeySelector) GetLocalObjectReference() *LocalObjectReference {
	if m != nil {
		return m.LocalObjectReference
	}
	return nil
}

func (m *SecretKeySelector) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

func (m *SecretKeySelector) GetOptional() bool {
	if m != nil {
		return m.Optional
	}
	return false
}

// SecretList is a list of Secret.
type SecretList struct {
	// Standard list metadata.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds
	// +optional
	Metadata *v1.ListMeta `protobuf:"bytes,1,opt,name=metadata" json:"metadata,omitempty"`
	// Items is a list of secret objects.
	// More info: https://kubernetes.io/docs/concepts/configuration/secret
	Items []*Secret `protobuf:"bytes,2,rep,name=items" json:"items,omitempty"`
}

func (m *SecretList) Reset()      { *m = SecretList{} }
func (*SecretList) ProtoMessage() {}
func (*SecretList) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{168}
}
func (m *SecretList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SecretList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SecretList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SecretList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SecretList.Merge(m, src)
}
func (m *SecretList) XXX_Size() int {
	return m.Size()
}
func (m *SecretList) XXX_DiscardUnknown() {
	xxx_messageInfo_SecretList.DiscardUnknown(m)
}

var xxx_messageInfo_SecretList proto.InternalMessageInfo

func (m *SecretList) GetMetadata() *v1.ListMeta {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *SecretList) GetItems() []*Secret {
	if m != nil {
		return m.Items
	}
	return nil
}

// Adapts a secret into a projected volume.
//
// The contents of the target Secret's Data field will be presented in a
// projected volume as files using the keys in the Data field as the file names.
// Note that this is identical to a secret volume source without the default
// mode.
type SecretProjection struct {
	LocalObjectReference *LocalObjectReference `protobuf:"bytes,1,opt,name=localObjectReference" json:"localObjectReference,omitempty"`
	// If unspecified, each key-value pair in the Data field of the referenced
	// Secret will be projected into the volume as a file whose name is the
	// key and content is the value. If specified, the listed keys will be
	// projected into the specified paths, and unlisted keys will not be
	// present. If a key is specified which is not present in the Secret,
	// the volume setup will error unless it is marked optional. Paths must be
	// relative and may not contain the '..' path or start with '..'.
	// +optional
	Items []*KeyToPath `protobuf:"bytes,2,rep,name=items" json:"items,omitempty"`
	// Specify whether the Secret or its key must be defined
	// +optional
	Optional bool `protobuf:"varint,4,opt,name=optional" json:"optional"`
}

func (m *SecretProjection) Reset()      { *m = SecretProjection{} }
func (*SecretProjection) ProtoMessage() {}
func (*SecretProjection) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{169}
}
func (m *SecretProjection) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SecretProjection) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SecretProjection.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SecretProjection) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SecretProjection.Merge(m, src)
}
func (m *SecretProjection) XXX_Size() int {
	return m.Size()
}
func (m *SecretProjection) XXX_DiscardUnknown() {
	xxx_messageInfo_SecretProjection.DiscardUnknown(m)
}

var xxx_messageInfo_SecretProjection proto.InternalMessageInfo

func (m *SecretProjection) GetLocalObjectReference() *LocalObjectReference {
	if m != nil {
		return m.LocalObjectReference
	}
	return nil
}

func (m *SecretProjection) GetItems() []*KeyToPath {
	if m != nil {
		return m.Items
	}
	return nil
}

func (m *SecretProjection) GetOptional() bool {
	if m != nil {
		return m.Optional
	}
	return false
}

// SecretReference represents a Secret Reference. It has enough information to retrieve secret
// in any namespace
type SecretReference struct {
	// Name is unique within a namespace to reference a secret resource.
	// +optional
	Name string `protobuf:"bytes,1,opt,name=name" json:"name"`
	// Namespace defines the space within which the secret name must be unique.
	// +optional
	Namespace string `protobuf:"bytes,2,opt,name=namespace" json:"namespace"`
}

func (m *SecretReference) Reset()      { *m = SecretReference{} }
func (*SecretReference) ProtoMessage() {}
func (*SecretReference) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{170}
}
func (m *SecretReference) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SecretReference) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SecretReference.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SecretReference) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SecretReference.Merge(m, src)
}
func (m *SecretReference) XXX_Size() int {
	return m.Size()
}
func (m *SecretReference) XXX_DiscardUnknown() {
	xxx_messageInfo_SecretReference.DiscardUnknown(m)
}

var xxx_messageInfo_SecretReference proto.InternalMessageInfo

func (m *SecretReference) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *SecretReference) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

// Adapts a Secret into a volume.
//
// The contents of the target Secret's Data field will be presented in a volume
// as files using the keys in the Data field as the file names.
// Secret volumes support ownership management and SELinux relabeling.
type SecretVolumeSource struct {
	// Name of the secret in the pod's namespace to use.
	// More info: https://kubernetes.io/docs/concepts/storage/volumes#secret
	// +optional
	SecretName string `protobuf:"bytes,1,opt,name=secretName" json:"secretName"`
	// If unspecified, each key-value pair in the Data field of the referenced
	// Secret will be projected into the volume as a file whose name is the
	// key and content is the value. If specified, the listed keys will be
	// projected into the specified paths, and unlisted keys will not be
	// present. If a key is specified which is not present in the Secret,
	// the volume setup will error unless it is marked optional. Paths must be
	// relative and may not contain the '..' path or start with '..'.
	// +optional
	Items []*KeyToPath `protobuf:"bytes,2,rep,name=items" json:"items,omitempty"`
	// Optional: mode bits to use on created files by default. Must be a
	// value between 0 and 0777. Defaults to 0644.
	// Directories within the path are not affected by this setting.
	// This might be in conflict with other options that affect the file
	// mode, like fsGroup, and the result can be other mode bits set.
	// +optional
	DefaultMode int32 `protobuf:"varint,3,opt,name=defaultMode" json:"defaultMode"`
	// Specify whether the Secret or its keys must be defined
	// +optional
	Optional bool `protobuf:"varint,4,opt,name=optional" json:"optional"`
}

func (m *SecretVolumeSource) Reset()      { *m = SecretVolumeSource{} }
func (*SecretVolumeSource) ProtoMessage() {}
func (*SecretVolumeSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{171}
}
func (m *SecretVolumeSource) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SecretVolumeSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SecretVolumeSource.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SecretVolumeSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SecretVolumeSource.Merge(m, src)
}
func (m *SecretVolumeSource) XXX_Size() int {
	return m.Size()
}
func (m *SecretVolumeSource) XXX_DiscardUnknown() {
	xxx_messageInfo_SecretVolumeSource.DiscardUnknown(m)
}

var xxx_messageInfo_SecretVolumeSource proto.InternalMessageInfo

func (m *SecretVolumeSource) GetSecretName() string {
	if m != nil {
		return m.SecretName
	}
	return ""
}

func (m *SecretVolumeSource) GetItems() []*KeyToPath {
	if m != nil {
		return m.Items
	}
	return nil
}

func (m *SecretVolumeSource) GetDefaultMode() int32 {
	if m != nil {
		return m.DefaultMode
	}
	return 0
}

func (m *SecretVolumeSource) GetOptional() bool {
	if m != nil {
		return m.Optional
	}
	return false
}

// SecurityContext holds security configuration that will be applied to a container.
// Some fields are present in both SecurityContext and PodSecurityContext.  When both
// are set, the values in SecurityContext take precedence.
type SecurityContext struct {
	// The capabilities to add/drop when running containers.
	// Defaults to the default set of capabilities granted by the container runtime.
	// +optional
	Capabilities *Capabilities `protobuf:"bytes,1,opt,name=capabilities" json:"capabilities,omitempty"`
	// Run container in privileged mode.
	// Processes in privileged containers are essentially equivalent to root on the host.
	// Defaults to false.
	// +optional
	Privileged bool `protobuf:"varint,2,opt,name=privileged" json:"privileged"`
	// The SELinux context to be applied to the container.
	// If unspecified, the container runtime will allocate a random SELinux context for each
	// container.  May also be set in PodSecurityContext.  If set in both SecurityContext and
	// PodSecurityContext, the value specified in SecurityContext takes precedence.
	// +optional
	SeLinuxOptions *SELinuxOptions `protobuf:"bytes,3,opt,name=seLinuxOptions" json:"seLinuxOptions,omitempty"`
	// The Windows specific settings applied to all containers.
	// If unspecified, the options from the PodSecurityContext will be used.
	// If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.
	// +optional
	WindowsOptions *WindowsSecurityContextOptions `protobuf:"bytes,10,opt,name=windowsOptions" json:"windowsOptions,omitempty"`
	// The UID to run the entrypoint of the container process.
	// Defaults to user specified in image metadata if unspecified.
	// May also be set in PodSecurityContext.  If set in both SecurityContext and
	// PodSecurityContext, the value specified in SecurityContext takes precedence.
	// +optional
	RunAsUser int64 `protobuf:"varint,4,opt,name=runAsUser" json:"runAsUser"`
	// The GID to run the entrypoint of the container process.
	// Uses runtime default if unset.
	// May also be set in PodSecurityContext.  If set in both SecurityContext and
	// PodSecurityContext, the value specified in SecurityContext takes precedence.
	// +optional
	RunAsGroup int64 `protobuf:"varint,8,opt,name=runAsGroup" json:"runAsGroup"`
	// Indicates that the container must run as a non-root user.
	// If true, the Kubelet will validate the image at runtime to ensure that it
	// does not run as UID 0 (root) and fail to start the container if it does.
	// If unset or false, no such validation will be performed.
	// May also be set in PodSecurityContext.  If set in both SecurityContext and
	// PodSecurityContext, the value specified in SecurityContext takes precedence.
	// +optional
	RunAsNonRoot bool `protobuf:"varint,5,opt,name=runAsNonRoot" json:"runAsNonRoot"`
	// Whether this container has a read-only root filesystem.
	// Default is false.
	// +optional
	ReadOnlyRootFilesystem bool `protobuf:"varint,6,opt,name=readOnlyRootFilesystem" json:"readOnlyRootFilesystem"`
	// AllowPrivilegeEscalation controls whether a process can gain more
	// privileges than its parent process. This bool directly controls if
	// the no_new_privs flag will be set on the container process.
	// AllowPrivilegeEscalation is true always when the container is:
	// 1) run as Privileged
	// 2) has CAP_SYS_ADMIN
	// +optional
	AllowPrivilegeEscalation bool `protobuf:"varint,7,opt,name=allowPrivilegeEscalation" json:"allowPrivilegeEscalation"`
	// procMount denotes the type of proc mount to use for the containers.
	// The default is DefaultProcMount which uses the container runtime defaults for
	// readonly paths and masked paths.
	// This requires the ProcMountType feature flag to be enabled.
	// +optional
	ProcMount string `protobuf:"bytes,9,opt,name=procMount" json:"procMount"`
}

func (m *SecurityContext) Reset()      { *m = SecurityContext{} }
func (*SecurityContext) ProtoMessage() {}
func (*SecurityContext) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{172}
}
func (m *SecurityContext) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SecurityContext) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SecurityContext.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SecurityContext) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SecurityContext.Merge(m, src)
}
func (m *SecurityContext) XXX_Size() int {
	return m.Size()
}
func (m *SecurityContext) XXX_DiscardUnknown() {
	xxx_messageInfo_SecurityContext.DiscardUnknown(m)
}

var xxx_messageInfo_SecurityContext proto.InternalMessageInfo

func (m *SecurityContext) GetCapabilities() *Capabilities {
	if m != nil {
		return m.Capabilities
	}
	return nil
}

func (m *SecurityContext) GetPrivileged() bool {
	if m != nil {
		return m.Privileged
	}
	return false
}

func (m *SecurityContext) GetSeLinuxOptions() *SELinuxOptions {
	if m != nil {
		return m.SeLinuxOptions
	}
	return nil
}

func (m *SecurityContext) GetWindowsOptions() *WindowsSecurityContextOptions {
	if m != nil {
		return m.WindowsOptions
	}
	return nil
}

func (m *SecurityContext) GetRunAsUser() int64 {
	if m != nil {
		return m.RunAsUser
	}
	return 0
}

func (m *SecurityContext) GetRunAsGroup() int64 {
	if m != nil {
		return m.RunAsGroup
	}
	return 0
}

func (m *SecurityContext) GetRunAsNonRoot() bool {
	if m != nil {
		return m.RunAsNonRoot
	}
	return false
}

func (m *SecurityContext) GetReadOnlyRootFilesystem() bool {
	if m != nil {
		return m.ReadOnlyRootFilesystem
	}
	return false
}

func (m *SecurityContext) GetAllowPrivilegeEscalation() bool {
	if m != nil {
		return m.AllowPrivilegeEscalation
	}
	return false
}

func (m *SecurityContext) GetProcMount() string {
	if m != nil {
		return m.ProcMount
	}
	return ""
}

// SerializedReference is a reference to serialized object.
type SerializedReference struct {
	// The reference to an object in the system.
	// +optional
	Reference *ObjectReference `protobuf:"bytes,1,opt,name=reference" json:"reference,omitempty"`
}

func (m *SerializedReference) Reset()      { *m = SerializedReference{} }
func (*SerializedReference) ProtoMessage() {}
func (*SerializedReference) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{173}
}
func (m *SerializedReference) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SerializedReference) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SerializedReference.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SerializedReference) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SerializedReference.Merge(m, src)
}
func (m *SerializedReference) XXX_Size() int {
	return m.Size()
}
func (m *SerializedReference) XXX_DiscardUnknown() {
	xxx_messageInfo_SerializedReference.DiscardUnknown(m)
}

var xxx_messageInfo_SerializedReference proto.InternalMessageInfo

func (m *SerializedReference) GetReference() *ObjectReference {
	if m != nil {
		return m.Reference
	}
	return nil
}

// Service is a named abstraction of software service (for example, mysql) consisting of local port
// (for example 3306) that the proxy listens on, and the selector that determines which pods
// will answer requests sent through the proxy.
type Service struct {
	// Standard object's metadata.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
	// +optional
	Metadata *v1.ObjectMeta `protobuf:"bytes,1,opt,name=metadata" json:"metadata,omitempty"`
	// Spec defines the behavior of a service.
	// https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status
	// +optional
	Spec *ServiceSpec `protobuf:"bytes,2,opt,name=spec" json:"spec,omitempty"`
	// Most recently observed status of the service.
	// Populated by the system.
	// Read-only.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status
	// +optional
	Status *ServiceStatus `protobuf:"bytes,3,opt,name=status" json:"status,omitempty"`
}

func (m *Service) Reset()      { *m = Service{} }
func (*Service) ProtoMessage() {}
func (*Service) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{174}
}
func (m *Service) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Service) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Service.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Service) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Service.Merge(m, src)
}
func (m *Service) XXX_Size() int {
	return m.Size()
}
func (m *Service) XXX_DiscardUnknown() {
	xxx_messageInfo_Service.DiscardUnknown(m)
}

var xxx_messageInfo_Service proto.InternalMessageInfo

func (m *Service) GetMetadata() *v1.ObjectMeta {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *Service) GetSpec() *ServiceSpec {
	if m != nil {
		return m.Spec
	}
	return nil
}

func (m *Service) GetStatus() *ServiceStatus {
	if m != nil {
		return m.Status
	}
	return nil
}

// ServiceAccount binds together:
// * a name, understood by users, and perhaps by peripheral systems, for an identity
// * a principal that can be authenticated and authorized
// * a set of secrets
type ServiceAccount struct {
	// Standard object's metadata.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
	// +optional
	Metadata *v1.ObjectMeta `protobuf:"bytes,1,opt,name=metadata" json:"metadata,omitempty"`
	// Secrets is the list of secrets allowed to be used by pods running using this ServiceAccount.
	// More info: https://kubernetes.io/docs/concepts/configuration/secret
	// +optional
	// +patchMergeKey=name
	// +patchStrategy=merge
	Secrets []*ObjectReference `protobuf:"bytes,2,rep,name=secrets" json:"secrets,omitempty"`
	// ImagePullSecrets is a list of references to secrets in the same namespace to use for pulling any images
	// in pods that reference this ServiceAccount. ImagePullSecrets are distinct from Secrets because Secrets
	// can be mounted in the pod, but ImagePullSecrets are only accessed by the kubelet.
	// More info: https://kubernetes.io/docs/concepts/containers/images/#specifying-imagepullsecrets-on-a-pod
	// +optional
	ImagePullSecrets []*LocalObjectReference `protobuf:"bytes,3,rep,name=imagePullSecrets" json:"imagePullSecrets,omitempty"`
	// AutomountServiceAccountToken indicates whether pods running as this service account should have an API token automatically mounted.
	// Can be overridden at the pod level.
	// +optional
	AutomountServiceAccountToken bool `protobuf:"varint,4,opt,name=automountServiceAccountToken" json:"automountServiceAccountToken"`
}

func (m *ServiceAccount) Reset()      { *m = ServiceAccount{} }
func (*ServiceAccount) ProtoMessage() {}
func (*ServiceAccount) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{175}
}
func (m *ServiceAccount) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ServiceAccount) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ServiceAccount.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ServiceAccount) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ServiceAccount.Merge(m, src)
}
func (m *ServiceAccount) XXX_Size() int {
	return m.Size()
}
func (m *ServiceAccount) XXX_DiscardUnknown() {
	xxx_messageInfo_ServiceAccount.DiscardUnknown(m)
}

var xxx_messageInfo_ServiceAccount proto.InternalMessageInfo

func (m *ServiceAccount) GetMetadata() *v1.ObjectMeta {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *ServiceAccount) GetSecrets() []*ObjectReference {
	if m != nil {
		return m.Secrets
	}
	return nil
}

func (m *ServiceAccount) GetImagePullSecrets() []*LocalObjectReference {
	if m != nil {
		return m.ImagePullSecrets
	}
	return nil
}

func (m *ServiceAccount) GetAutomountServiceAccountToken() bool {
	if m != nil {
		return m.AutomountServiceAccountToken
	}
	return false
}

// ServiceAccountList is a list of ServiceAccount objects
type ServiceAccountList struct {
	// Standard list metadata.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds
	// +optional
	Metadata *v1.ListMeta `protobuf:"bytes,1,opt,name=metadata" json:"metadata,omitempty"`
	// List of ServiceAccounts.
	// More info: https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/
	Items []*ServiceAccount `protobuf:"bytes,2,rep,name=items" json:"items,omitempty"`
}

func (m *ServiceAccountList) Reset()      { *m = ServiceAccountList{} }
func (*ServiceAccountList) ProtoMessage() {}
func (*ServiceAccountList) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{176}
}
func (m *ServiceAccountList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ServiceAccountList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ServiceAccountList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ServiceAccountList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ServiceAccountList.Merge(m, src)
}
func (m *ServiceAccountList) XXX_Size() int {
	return m.Size()
}
func (m *ServiceAccountList) XXX_DiscardUnknown() {
	xxx_messageInfo_ServiceAccountList.DiscardUnknown(m)
}

var xxx_messageInfo_ServiceAccountList proto.InternalMessageInfo

func (m *ServiceAccountList) GetMetadata() *v1.ListMeta {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *ServiceAccountList) GetItems() []*ServiceAccount {
	if m != nil {
		return m.Items
	}
	return nil
}

// ServiceAccountTokenProjection represents a projected service account token
// volume. This projection can be used to insert a service account token into
// the pods runtime filesystem for use against APIs (Kubernetes API Server or
// otherwise).
type ServiceAccountTokenProjection struct {
	// Audience is the intended audience of the token. A recipient of a token
	// must identify itself with an identifier specified in the audience of the
	// token, and otherwise should reject the token. The audience defaults to the
	// identifier of the apiserver.
	// +optional
	Audience string `protobuf:"bytes,1,opt,name=audience" json:"audience"`
	// ExpirationSeconds is the requested duration of validity of the service
	// account token. As the token approaches expiration, the kubelet volume
	// plugin will proactively rotate the service account token. The kubelet will
	// start trying to rotate the token if the token is older than 80 percent of
	// its time to live or if the token is older than 24 hours.Defaults to 1 hour
	// and must be at least 10 minutes.
	// +optional
	ExpirationSeconds int64 `protobuf:"varint,2,opt,name=expirationSeconds" json:"expirationSeconds"`
	// Path is the path relative to the mount point of the file to project the
	// token into.
	Path string `protobuf:"bytes,3,opt,name=path" json:"path"`
}

func (m *ServiceAccountTokenProjection) Reset()      { *m = ServiceAccountTokenProjection{} }
func (*ServiceAccountTokenProjection) ProtoMessage() {}
func (*ServiceAccountTokenProjection) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{177}
}
func (m *ServiceAccountTokenProjection) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ServiceAccountTokenProjection) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ServiceAccountTokenProjection.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ServiceAccountTokenProjection) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ServiceAccountTokenProjection.Merge(m, src)
}
func (m *ServiceAccountTokenProjection) XXX_Size() int {
	return m.Size()
}
func (m *ServiceAccountTokenProjection) XXX_DiscardUnknown() {
	xxx_messageInfo_ServiceAccountTokenProjection.DiscardUnknown(m)
}

var xxx_messageInfo_ServiceAccountTokenProjection proto.InternalMessageInfo

func (m *ServiceAccountTokenProjection) GetAudience() string {
	if m != nil {
		return m.Audience
	}
	return ""
}

func (m *ServiceAccountTokenProjection) GetExpirationSeconds() int64 {
	if m != nil {
		return m.ExpirationSeconds
	}
	return 0
}

func (m *ServiceAccountTokenProjection) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

// ServiceList holds a list of services.
type ServiceList struct {
	// Standard list metadata.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds
	// +optional
	Metadata *v1.ListMeta `protobuf:"bytes,1,opt,name=metadata" json:"metadata,omitempty"`
	// List of services
	Items []*Service `protobuf:"bytes,2,rep,name=items" json:"items,omitempty"`
}

func (m *ServiceList) Reset()      { *m = ServiceList{} }
func (*ServiceList) ProtoMessage() {}
func (*ServiceList) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{178}
}
func (m *ServiceList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ServiceList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ServiceList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ServiceList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ServiceList.Merge(m, src)
}
func (m *ServiceList) XXX_Size() int {
	return m.Size()
}
func (m *ServiceList) XXX_DiscardUnknown() {
	xxx_messageInfo_ServiceList.DiscardUnknown(m)
}

var xxx_messageInfo_ServiceList proto.InternalMessageInfo

func (m *ServiceList) GetMetadata() *v1.ListMeta {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *ServiceList) GetItems() []*Service {
	if m != nil {
		return m.Items
	}
	return nil
}

// ServicePort contains information on service's port.
type ServicePort struct {
	// The name of this port within the service. This must be a DNS_LABEL.
	// All ports within a ServiceSpec must have unique names. When considering
	// the endpoints for a Service, this must match the 'name' field in the
	// EndpointPort.
	// Optional if only one ServicePort is defined on this service.
	// +optional
	Name string `protobuf:"bytes,1,opt,name=name" json:"name"`
	// The IP protocol for this port. Supports "TCP", "UDP", and "SCTP".
	// Default is TCP.
	// +optional
	Protocol string `protobuf:"bytes,2,opt,name=protocol" json:"protocol"`
	// The port that will be exposed by this service.
	Port int32 `protobuf:"varint,3,opt,name=port" json:"port"`
	// Number or name of the port to access on the pods targeted by the service.
	// Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
	// If this is a string, it will be looked up as a named port in the
	// target Pod's container ports. If this is not specified, the value
	// of the 'port' field is used (an identity map).
	// This field is ignored for services with clusterIP=None, and should be
	// omitted or set equal to the 'port' field.
	// More info: https://kubernetes.io/docs/concepts/services-networking/service/#defining-a-service
	// +optional
	TargetPort *intstr.IntOrString `protobuf:"bytes,4,opt,name=targetPort" json:"targetPort,omitempty"`
	// The port on each node on which this service is exposed when type=NodePort or LoadBalancer.
	// Usually assigned by the system. If specified, it will be allocated to the service
	// if unused or else creation of the service will fail.
	// Default is to auto-allocate a port if the ServiceType of this Service requires one.
	// More info: https://kubernetes.io/docs/concepts/services-networking/service/#type-nodeport
	// +optional
	NodePort int32 `protobuf:"varint,5,opt,name=nodePort" json:"nodePort"`
}

func (m *ServicePort) Reset()      { *m = ServicePort{} }
func (*ServicePort) ProtoMessage() {}
func (*ServicePort) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{179}
}
func (m *ServicePort) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ServicePort) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ServicePort.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ServicePort) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ServicePort.Merge(m, src)
}
func (m *ServicePort) XXX_Size() int {
	return m.Size()
}
func (m *ServicePort) XXX_DiscardUnknown() {
	xxx_messageInfo_ServicePort.DiscardUnknown(m)
}

var xxx_messageInfo_ServicePort proto.InternalMessageInfo

func (m *ServicePort) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ServicePort) GetProtocol() string {
	if m != nil {
		return m.Protocol
	}
	return ""
}

func (m *ServicePort) GetPort() int32 {
	if m != nil {
		return m.Port
	}
	return 0
}

func (m *ServicePort) GetTargetPort() *intstr.IntOrString {
	if m != nil {
		return m.TargetPort
	}
	return nil
}

func (m *ServicePort) GetNodePort() int32 {
	if m != nil {
		return m.NodePort
	}
	return 0
}

// ServiceProxyOptions is the query options to a Service's proxy call.
type ServiceProxyOptions struct {
	// Path is the part of URLs that include service endpoints, suffixes,
	// and parameters to use for the current proxy request to service.
	// For example, the whole request URL is
	// http://localhost/api/v1/namespaces/kube-system/services/elasticsearch-logging/_search?q=user:kimchy.
	// Path is _search?q=user:kimchy.
	// +optional
	Path string `protobuf:"bytes,1,opt,name=path" json:"path"`
}

func (m *ServiceProxyOptions) Reset()      { *m = ServiceProxyOptions{} }
func (*ServiceProxyOptions) ProtoMessage() {}
func (*ServiceProxyOptions) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{180}
}
func (m *ServiceProxyOptions) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ServiceProxyOptions) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ServiceProxyOptions.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ServiceProxyOptions) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ServiceProxyOptions.Merge(m, src)
}
func (m *ServiceProxyOptions) XXX_Size() int {
	return m.Size()
}
func (m *ServiceProxyOptions) XXX_DiscardUnknown() {
	xxx_messageInfo_ServiceProxyOptions.DiscardUnknown(m)
}

var xxx_messageInfo_ServiceProxyOptions proto.InternalMessageInfo

func (m *ServiceProxyOptions) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

// ServiceSpec describes the attributes that a user creates on a service.
type ServiceSpec struct {
	// The list of ports that are exposed by this service.
	// More info: https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies
	// +patchMergeKey=port
	// +patchStrategy=merge
	// +listType=map
	// +listMapKey=port
	// +listMapKey=protocol
	Ports []*ServicePort `protobuf:"bytes,1,rep,name=ports" json:"ports,omitempty"`
	// Route service traffic to pods with label keys and values matching this
	// selector. If empty or not present, the service is assumed to have an
	// external process managing its endpoints, which Kubernetes will not
	// modify. Only applies to types ClusterIP, NodePort, and LoadBalancer.
	// Ignored if type is ExternalName.
	// More info: https://kubernetes.io/docs/concepts/services-networking/service/
	// +optional
	Selector map[string]string `protobuf:"bytes,2,rep,name=selector" json:"selector,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// clusterIP is the IP address of the service and is usually assigned
	// randomly by the master. If an address is specified manually and is not in
	// use by others, it will be allocated to the service; otherwise, creation
	// of the service will fail. This field can not be changed through updates.
	// Valid values are "None", empty string (""), or a valid IP address. "None"
	// can be specified for headless services when proxying is not required.
	// Only applies to types ClusterIP, NodePort, and LoadBalancer. Ignored if
	// type is ExternalName.
	// More info: https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies
	// +optional
	ClusterIP string `protobuf:"bytes,3,opt,name=clusterIP" json:"clusterIP"`
	// type determines how the Service is exposed. Defaults to ClusterIP. Valid
	// options are ExternalName, ClusterIP, NodePort, and LoadBalancer.
	// "ExternalName" maps to the specified externalName.
	// "ClusterIP" allocates a cluster-internal IP address for load-balancing to
	// endpoints. Endpoints are determined by the selector or if that is not
	// specified, by manual construction of an Endpoints object. If clusterIP is
	// "None", no virtual IP is allocated and the endpoints are published as a
	// set of endpoints rather than a stable IP.
	// "NodePort" builds on ClusterIP and allocates a port on every node which
	// routes to the clusterIP.
	// "LoadBalancer" builds on NodePort and creates an
	// external load-balancer (if supported in the current cloud) which routes
	// to the clusterIP.
	// More info: https://kubernetes.io/docs/concepts/services-networking/service/#publishing-services-service-types
	// +optional
	Type string `protobuf:"bytes,4,opt,name=type" json:"type"`
	// externalIPs is a list of IP addresses for which nodes in the cluster
	// will also accept traffic for this service.  These IPs are not managed by
	// Kubernetes.  The user is responsible for ensuring that traffic arrives
	// at a node with this IP.  A common example is external load-balancers
	// that are not part of the Kubernetes system.
	// +optional
	ExternalIPs []string `protobuf:"bytes,5,rep,name=externalIPs" json:"externalIPs,omitempty"`
	// Supports "ClientIP" and "None". Used to maintain session affinity.
	// Enable client IP based session affinity.
	// Must be ClientIP or None.
	// Defaults to None.
	// More info: https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies
	// +optional
	SessionAffinity string `protobuf:"bytes,7,opt,name=sessionAffinity" json:"sessionAffinity"`
	// Only applies to Service Type: LoadBalancer
	// LoadBalancer will get created with the IP specified in this field.
	// This feature depends on whether the underlying cloud-provider supports specifying
	// the loadBalancerIP when a load balancer is created.
	// This field will be ignored if the cloud-provider does not support the feature.
	// +optional
	LoadBalancerIP string `protobuf:"bytes,8,opt,name=loadBalancerIP" json:"loadBalancerIP"`
	// If specified and supported by the platform, this will restrict traffic through the cloud-provider
	// load-balancer will be restricted to the specified client IPs. This field will be ignored if the
	// cloud-provider does not support the feature."
	// More info: https://kubernetes.io/docs/tasks/access-application-cluster/configure-cloud-provider-firewall/
	// +optional
	LoadBalancerSourceRanges []string `protobuf:"bytes,9,rep,name=loadBalancerSourceRanges" json:"loadBalancerSourceRanges,omitempty"`
	// externalName is the external reference that kubedns or equivalent will
	// return as a CNAME record for this service. No proxying will be involved.
	// Must be a valid RFC-1123 hostname (https://tools.ietf.org/html/rfc1123)
	// and requires Type to be ExternalName.
	// +optional
	ExternalName string `protobuf:"bytes,10,opt,name=externalName" json:"externalName"`
	// externalTrafficPolicy denotes if this Service desires to route external
	// traffic to node-local or cluster-wide endpoints. "Local" preserves the
	// client source IP and avoids a second hop for LoadBalancer and Nodeport
	// type services, but risks potentially imbalanced traffic spreading.
	// "Cluster" obscures the client source IP and may cause a second hop to
	// another node, but should have good overall load-spreading.
	// +optional
	ExternalTrafficPolicy string `protobuf:"bytes,11,opt,name=externalTrafficPolicy" json:"externalTrafficPolicy"`
	// healthCheckNodePort specifies the healthcheck nodePort for the service.
	// If not specified, HealthCheckNodePort is created by the service api
	// backend with the allocated nodePort. Will use user-specified nodePort value
	// if specified by the client. Only effects when Type is set to LoadBalancer
	// and ExternalTrafficPolicy is set to Local.
	// +optional
	HealthCheckNodePort int32 `protobuf:"varint,12,opt,name=healthCheckNodePort" json:"healthCheckNodePort"`
	// publishNotReadyAddresses, when set to true, indicates that DNS implementations
	// must publish the notReadyAddresses of subsets for the Endpoints associated with
	// the Service. The default value is false.
	// The primary use case for setting this field is to use a StatefulSet's Headless Service
	// to propagate SRV records for its Pods without respect to their readiness for purpose
	// of peer discovery.
	// +optional
	PublishNotReadyAddresses bool `protobuf:"varint,13,opt,name=publishNotReadyAddresses" json:"publishNotReadyAddresses"`
	// sessionAffinityConfig contains the configurations of session affinity.
	// +optional
	SessionAffinityConfig *SessionAffinityConfig `protobuf:"bytes,14,opt,name=sessionAffinityConfig" json:"sessionAffinityConfig,omitempty"`
	// ipFamily specifies whether this Service has a preference for a particular IP family (e.g. IPv4 vs.
	// IPv6).  If a specific IP family is requested, the clusterIP field will be allocated from that family, if it is
	// available in the cluster.  If no IP family is requested, the cluster's primary IP family will be used.
	// Other IP fields (loadBalancerIP, loadBalancerSourceRanges, externalIPs) and controllers which
	// allocate external load-balancers should use the same IP family.  Endpoints for this Service will be of
	// this family.  This field is immutable after creation. Assigning a ServiceIPFamily not available in the
	// cluster (e.g. IPv6 in IPv4 only cluster) is an error condition and will fail during clusterIP assignment.
	// +optional
	IpFamily string `protobuf:"bytes,15,opt,name=ipFamily" json:"ipFamily"`
}

func (m *ServiceSpec) Reset()      { *m = ServiceSpec{} }
func (*ServiceSpec) ProtoMessage() {}
func (*ServiceSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{181}
}
func (m *ServiceSpec) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ServiceSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ServiceSpec.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ServiceSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ServiceSpec.Merge(m, src)
}
func (m *ServiceSpec) XXX_Size() int {
	return m.Size()
}
func (m *ServiceSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_ServiceSpec.DiscardUnknown(m)
}

var xxx_messageInfo_ServiceSpec proto.InternalMessageInfo

func (m *ServiceSpec) GetPorts() []*ServicePort {
	if m != nil {
		return m.Ports
	}
	return nil
}

func (m *ServiceSpec) GetSelector() map[string]string {
	if m != nil {
		return m.Selector
	}
	return nil
}

func (m *ServiceSpec) GetClusterIP() string {
	if m != nil {
		return m.ClusterIP
	}
	return ""
}

func (m *ServiceSpec) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *ServiceSpec) GetExternalIPs() []string {
	if m != nil {
		return m.ExternalIPs
	}
	return nil
}

func (m *ServiceSpec) GetSessionAffinity() string {
	if m != nil {
		return m.SessionAffinity
	}
	return ""
}

func (m *ServiceSpec) GetLoadBalancerIP() string {
	if m != nil {
		return m.LoadBalancerIP
	}
	return ""
}

func (m *ServiceSpec) GetLoadBalancerSourceRanges() []string {
	if m != nil {
		return m.LoadBalancerSourceRanges
	}
	return nil
}

func (m *ServiceSpec) GetExternalName() string {
	if m != nil {
		return m.ExternalName
	}
	return ""
}

func (m *ServiceSpec) GetExternalTrafficPolicy() string {
	if m != nil {
		return m.ExternalTrafficPolicy
	}
	return ""
}

func (m *ServiceSpec) GetHealthCheckNodePort() int32 {
	if m != nil {
		return m.HealthCheckNodePort
	}
	return 0
}

func (m *ServiceSpec) GetPublishNotReadyAddresses() bool {
	if m != nil {
		return m.PublishNotReadyAddresses
	}
	return false
}

func (m *ServiceSpec) GetSessionAffinityConfig() *SessionAffinityConfig {
	if m != nil {
		return m.SessionAffinityConfig
	}
	return nil
}

func (m *ServiceSpec) GetIpFamily() string {
	if m != nil {
		return m.IpFamily
	}
	return ""
}

// ServiceStatus represents the current status of a service.
type ServiceStatus struct {
	// LoadBalancer contains the current status of the load-balancer,
	// if one is present.
	// +optional
	LoadBalancer *LoadBalancerStatus `protobuf:"bytes,1,opt,name=loadBalancer" json:"loadBalancer,omitempty"`
}

func (m *ServiceStatus) Reset()      { *m = ServiceStatus{} }
func (*ServiceStatus) ProtoMessage() {}
func (*ServiceStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{182}
}
func (m *ServiceStatus) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ServiceStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ServiceStatus.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ServiceStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ServiceStatus.Merge(m, src)
}
func (m *ServiceStatus) XXX_Size() int {
	return m.Size()
}
func (m *ServiceStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_ServiceStatus.DiscardUnknown(m)
}

var xxx_messageInfo_ServiceStatus proto.InternalMessageInfo

func (m *ServiceStatus) GetLoadBalancer() *LoadBalancerStatus {
	if m != nil {
		return m.LoadBalancer
	}
	return nil
}

// SessionAffinityConfig represents the configurations of session affinity.
type SessionAffinityConfig struct {
	// clientIP contains the configurations of Client IP based session affinity.
	// +optional
	ClientIP *ClientIPConfig `protobuf:"bytes,1,opt,name=clientIP" json:"clientIP,omitempty"`
}

func (m *SessionAffinityConfig) Reset()      { *m = SessionAffinityConfig{} }
func (*SessionAffinityConfig) ProtoMessage() {}
func (*SessionAffinityConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{183}
}
func (m *SessionAffinityConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SessionAffinityConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SessionAffinityConfig.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SessionAffinityConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SessionAffinityConfig.Merge(m, src)
}
func (m *SessionAffinityConfig) XXX_Size() int {
	return m.Size()
}
func (m *SessionAffinityConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_SessionAffinityConfig.DiscardUnknown(m)
}

var xxx_messageInfo_SessionAffinityConfig proto.InternalMessageInfo

func (m *SessionAffinityConfig) GetClientIP() *ClientIPConfig {
	if m != nil {
		return m.ClientIP
	}
	return nil
}

// Represents a StorageOS persistent volume resource.
type StorageOSPersistentVolumeSource struct {
	// VolumeName is the human-readable name of the StorageOS volume.  Volume
	// names are only unique within a namespace.
	VolumeName string `protobuf:"bytes,1,opt,name=volumeName" json:"volumeName"`
	// VolumeNamespace specifies the scope of the volume within StorageOS.  If no
	// namespace is specified then the Pod's namespace will be used.  This allows the
	// Kubernetes name scoping to be mirrored within StorageOS for tighter integration.
	// Set VolumeName to any name to override the default behaviour.
	// Set to "default" if you are not using namespaces within StorageOS.
	// Namespaces that do not pre-exist within StorageOS will be created.
	// +optional
	VolumeNamespace string `protobuf:"bytes,2,opt,name=volumeNamespace" json:"volumeNamespace"`
	// Filesystem type to mount.
	// Must be a filesystem type supported by the host operating system.
	// Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
	// +optional
	FsType string `protobuf:"bytes,3,opt,name=fsType" json:"fsType"`
	// Defaults to false (read/write). ReadOnly here will force
	// the ReadOnly setting in VolumeMounts.
	// +optional
	ReadOnly bool `protobuf:"varint,4,opt,name=readOnly" json:"readOnly"`
	// SecretRef specifies the secret to use for obtaining the StorageOS API
	// credentials.  If not specified, default values will be attempted.
	// +optional
	SecretRef *ObjectReference `protobuf:"bytes,5,opt,name=secretRef" json:"secretRef,omitempty"`
}

func (m *StorageOSPersistentVolumeSource) Reset()      { *m = StorageOSPersistentVolumeSource{} }
func (*StorageOSPersistentVolumeSource) ProtoMessage() {}
func (*StorageOSPersistentVolumeSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{184}
}
func (m *StorageOSPersistentVolumeSource) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *StorageOSPersistentVolumeSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_StorageOSPersistentVolumeSource.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *StorageOSPersistentVolumeSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StorageOSPersistentVolumeSource.Merge(m, src)
}
func (m *StorageOSPersistentVolumeSource) XXX_Size() int {
	return m.Size()
}
func (m *StorageOSPersistentVolumeSource) XXX_DiscardUnknown() {
	xxx_messageInfo_StorageOSPersistentVolumeSource.DiscardUnknown(m)
}

var xxx_messageInfo_StorageOSPersistentVolumeSource proto.InternalMessageInfo

func (m *StorageOSPersistentVolumeSource) GetVolumeName() string {
	if m != nil {
		return m.VolumeName
	}
	return ""
}

func (m *StorageOSPersistentVolumeSource) GetVolumeNamespace() string {
	if m != nil {
		return m.VolumeNamespace
	}
	return ""
}

func (m *StorageOSPersistentVolumeSource) GetFsType() string {
	if m != nil {
		return m.FsType
	}
	return ""
}

func (m *StorageOSPersistentVolumeSource) GetReadOnly() bool {
	if m != nil {
		return m.ReadOnly
	}
	return false
}

func (m *StorageOSPersistentVolumeSource) GetSecretRef() *ObjectReference {
	if m != nil {
		return m.SecretRef
	}
	return nil
}

// Represents a StorageOS persistent volume resource.
type StorageOSVolumeSource struct {
	// VolumeName is the human-readable name of the StorageOS volume.  Volume
	// names are only unique within a namespace.
	VolumeName string `protobuf:"bytes,1,opt,name=volumeName" json:"volumeName"`
	// VolumeNamespace specifies the scope of the volume within StorageOS.  If no
	// namespace is specified then the Pod's namespace will be used.  This allows the
	// Kubernetes name scoping to be mirrored within StorageOS for tighter integration.
	// Set VolumeName to any name to override the default behaviour.
	// Set to "default" if you are not using namespaces within StorageOS.
	// Namespaces that do not pre-exist within StorageOS will be created.
	// +optional
	VolumeNamespace string `protobuf:"bytes,2,opt,name=volumeNamespace" json:"volumeNamespace"`
	// Filesystem type to mount.
	// Must be a filesystem type supported by the host operating system.
	// Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
	// +optional
	FsType string `protobuf:"bytes,3,opt,name=fsType" json:"fsType"`
	// Defaults to false (read/write). ReadOnly here will force
	// the ReadOnly setting in VolumeMounts.
	// +optional
	ReadOnly bool `protobuf:"varint,4,opt,name=readOnly" json:"readOnly"`
	// SecretRef specifies the secret to use for obtaining the StorageOS API
	// credentials.  If not specified, default values will be attempted.
	// +optional
	SecretRef *LocalObjectReference `protobuf:"bytes,5,opt,name=secretRef" json:"secretRef,omitempty"`
}

func (m *StorageOSVolumeSource) Reset()      { *m = StorageOSVolumeSource{} }
func (*StorageOSVolumeSource) ProtoMessage() {}
func (*StorageOSVolumeSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{185}
}
func (m *StorageOSVolumeSource) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *StorageOSVolumeSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_StorageOSVolumeSource.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *StorageOSVolumeSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StorageOSVolumeSource.Merge(m, src)
}
func (m *StorageOSVolumeSource) XXX_Size() int {
	return m.Size()
}
func (m *StorageOSVolumeSource) XXX_DiscardUnknown() {
	xxx_messageInfo_StorageOSVolumeSource.DiscardUnknown(m)
}

var xxx_messageInfo_StorageOSVolumeSource proto.InternalMessageInfo

func (m *StorageOSVolumeSource) GetVolumeName() string {
	if m != nil {
		return m.VolumeName
	}
	return ""
}

func (m *StorageOSVolumeSource) GetVolumeNamespace() string {
	if m != nil {
		return m.VolumeNamespace
	}
	return ""
}

func (m *StorageOSVolumeSource) GetFsType() string {
	if m != nil {
		return m.FsType
	}
	return ""
}

func (m *StorageOSVolumeSource) GetReadOnly() bool {
	if m != nil {
		return m.ReadOnly
	}
	return false
}

func (m *StorageOSVolumeSource) GetSecretRef() *LocalObjectReference {
	if m != nil {
		return m.SecretRef
	}
	return nil
}

// Sysctl defines a kernel parameter to be set
type Sysctl struct {
	// Name of a property to set
	Name string `protobuf:"bytes,1,opt,name=name" json:"name"`
	// Value of a property to set
	Value string `protobuf:"bytes,2,opt,name=value" json:"value"`
}

func (m *Sysctl) Reset()      { *m = Sysctl{} }
func (*Sysctl) ProtoMessage() {}
func (*Sysctl) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{186}
}
func (m *Sysctl) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Sysctl) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Sysctl.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Sysctl) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Sysctl.Merge(m, src)
}
func (m *Sysctl) XXX_Size() int {
	return m.Size()
}
func (m *Sysctl) XXX_DiscardUnknown() {
	xxx_messageInfo_Sysctl.DiscardUnknown(m)
}

var xxx_messageInfo_Sysctl proto.InternalMessageInfo

func (m *Sysctl) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Sysctl) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

// TCPSocketAction describes an action based on opening a socket
type TCPSocketAction struct {
	// Number or name of the port to access on the container.
	// Number must be in the range 1 to 65535.
	// Name must be an IANA_SVC_NAME.
	Port *intstr.IntOrString `protobuf:"bytes,1,opt,name=port" json:"port,omitempty"`
	// Optional: Host name to connect to, defaults to the pod IP.
	// +optional
	Host string `protobuf:"bytes,2,opt,name=host" json:"host"`
}

func (m *TCPSocketAction) Reset()      { *m = TCPSocketAction{} }
func (*TCPSocketAction) ProtoMessage() {}
func (*TCPSocketAction) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{187}
}
func (m *TCPSocketAction) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TCPSocketAction) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TCPSocketAction.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *TCPSocketAction) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TCPSocketAction.Merge(m, src)
}
func (m *TCPSocketAction) XXX_Size() int {
	return m.Size()
}
func (m *TCPSocketAction) XXX_DiscardUnknown() {
	xxx_messageInfo_TCPSocketAction.DiscardUnknown(m)
}

var xxx_messageInfo_TCPSocketAction proto.InternalMessageInfo

func (m *TCPSocketAction) GetPort() *intstr.IntOrString {
	if m != nil {
		return m.Port
	}
	return nil
}

func (m *TCPSocketAction) GetHost() string {
	if m != nil {
		return m.Host
	}
	return ""
}

// The node this Taint is attached to has the "effect" on
// any pod that does not tolerate the Taint.
type Taint struct {
	// Required. The taint key to be applied to a node.
	Key string `protobuf:"bytes,1,opt,name=key" json:"key"`
	// Required. The taint value corresponding to the taint key.
	// +optional
	Value string `protobuf:"bytes,2,opt,name=value" json:"value"`
	// Required. The effect of the taint on pods
	// that do not tolerate the taint.
	// Valid effects are NoSchedule, PreferNoSchedule and NoExecute.
	Effect string `protobuf:"bytes,3,opt,name=effect" json:"effect"`
	// TimeAdded represents the time at which the taint was added.
	// It is only written for NoExecute taints.
	// +optional
	TimeAdded *v1.Time `protobuf:"bytes,4,opt,name=timeAdded" json:"timeAdded,omitempty"`
}

func (m *Taint) Reset()      { *m = Taint{} }
func (*Taint) ProtoMessage() {}
func (*Taint) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{188}
}
func (m *Taint) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Taint) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Taint.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Taint) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Taint.Merge(m, src)
}
func (m *Taint) XXX_Size() int {
	return m.Size()
}
func (m *Taint) XXX_DiscardUnknown() {
	xxx_messageInfo_Taint.DiscardUnknown(m)
}

var xxx_messageInfo_Taint proto.InternalMessageInfo

func (m *Taint) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

func (m *Taint) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

func (m *Taint) GetEffect() string {
	if m != nil {
		return m.Effect
	}
	return ""
}

func (m *Taint) GetTimeAdded() *v1.Time {
	if m != nil {
		return m.TimeAdded
	}
	return nil
}

// The pod this Toleration is attached to tolerates any taint that matches
// the triple <key,value,effect> using the matching operator <operator>.
type Toleration struct {
	// Key is the taint key that the toleration applies to. Empty means match all taint keys.
	// If the key is empty, operator must be Exists; this combination means to match all values and all keys.
	// +optional
	Key string `protobuf:"bytes,1,opt,name=key" json:"key"`
	// Operator represents a key's relationship to the value.
	// Valid operators are Exists and Equal. Defaults to Equal.
	// Exists is equivalent to wildcard for value, so that a pod can
	// tolerate all taints of a particular category.
	// +optional
	Operator string `protobuf:"bytes,2,opt,name=operator" json:"operator"`
	// Value is the taint value the toleration matches to.
	// If the operator is Exists, the value should be empty, otherwise just a regular string.
	// +optional
	Value string `protobuf:"bytes,3,opt,name=value" json:"value"`
	// Effect indicates the taint effect to match. Empty means match all taint effects.
	// When specified, allowed values are NoSchedule, PreferNoSchedule and NoExecute.
	// +optional
	Effect string `protobuf:"bytes,4,opt,name=effect" json:"effect"`
	// TolerationSeconds represents the period of time the toleration (which must be
	// of effect NoExecute, otherwise this field is ignored) tolerates the taint. By default,
	// it is not set, which means tolerate the taint forever (do not evict). Zero and
	// negative values will be treated as 0 (evict immediately) by the system.
	// +optional
	TolerationSeconds int64 `protobuf:"varint,5,opt,name=tolerationSeconds" json:"tolerationSeconds"`
}

func (m *Toleration) Reset()      { *m = Toleration{} }
func (*Toleration) ProtoMessage() {}
func (*Toleration) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{189}
}
func (m *Toleration) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Toleration) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Toleration.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Toleration) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Toleration.Merge(m, src)
}
func (m *Toleration) XXX_Size() int {
	return m.Size()
}
func (m *Toleration) XXX_DiscardUnknown() {
	xxx_messageInfo_Toleration.DiscardUnknown(m)
}

var xxx_messageInfo_Toleration proto.InternalMessageInfo

func (m *Toleration) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

func (m *Toleration) GetOperator() string {
	if m != nil {
		return m.Operator
	}
	return ""
}

func (m *Toleration) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

func (m *Toleration) GetEffect() string {
	if m != nil {
		return m.Effect
	}
	return ""
}

func (m *Toleration) GetTolerationSeconds() int64 {
	if m != nil {
		return m.TolerationSeconds
	}
	return 0
}

// A topology selector requirement is a selector that matches given label.
// This is an alpha feature and may change in the future.
type TopologySelectorLabelRequirement struct {
	// The label key that the selector applies to.
	Key string `protobuf:"bytes,1,opt,name=key" json:"key"`
	// An array of string values. One value must match the label to be selected.
	// Each entry in Values is ORed.
	Values []string `protobuf:"bytes,2,rep,name=values" json:"values,omitempty"`
}

func (m *TopologySelectorLabelRequirement) Reset()      { *m = TopologySelectorLabelRequirement{} }
func (*TopologySelectorLabelRequirement) ProtoMessage() {}
func (*TopologySelectorLabelRequirement) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{190}
}
func (m *TopologySelectorLabelRequirement) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TopologySelectorLabelRequirement) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TopologySelectorLabelRequirement.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *TopologySelectorLabelRequirement) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TopologySelectorLabelRequirement.Merge(m, src)
}
func (m *TopologySelectorLabelRequirement) XXX_Size() int {
	return m.Size()
}
func (m *TopologySelectorLabelRequirement) XXX_DiscardUnknown() {
	xxx_messageInfo_TopologySelectorLabelRequirement.DiscardUnknown(m)
}

var xxx_messageInfo_TopologySelectorLabelRequirement proto.InternalMessageInfo

func (m *TopologySelectorLabelRequirement) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

func (m *TopologySelectorLabelRequirement) GetValues() []string {
	if m != nil {
		return m.Values
	}
	return nil
}

// A topology selector term represents the result of label queries.
// A null or empty topology selector term matches no objects.
// The requirements of them are ANDed.
// It provides a subset of functionality as NodeSelectorTerm.
// This is an alpha feature and may change in the future.
type TopologySelectorTerm struct {
	// A list of topology selector requirements by labels.
	// +optional
	MatchLabelExpressions []*TopologySelectorLabelRequirement `protobuf:"bytes,1,rep,name=matchLabelExpressions" json:"matchLabelExpressions,omitempty"`
}

func (m *TopologySelectorTerm) Reset()      { *m = TopologySelectorTerm{} }
func (*TopologySelectorTerm) ProtoMessage() {}
func (*TopologySelectorTerm) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{191}
}
func (m *TopologySelectorTerm) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TopologySelectorTerm) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TopologySelectorTerm.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *TopologySelectorTerm) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TopologySelectorTerm.Merge(m, src)
}
func (m *TopologySelectorTerm) XXX_Size() int {
	return m.Size()
}
func (m *TopologySelectorTerm) XXX_DiscardUnknown() {
	xxx_messageInfo_TopologySelectorTerm.DiscardUnknown(m)
}

var xxx_messageInfo_TopologySelectorTerm proto.InternalMessageInfo

func (m *TopologySelectorTerm) GetMatchLabelExpressions() []*TopologySelectorLabelRequirement {
	if m != nil {
		return m.MatchLabelExpressions
	}
	return nil
}

// TopologySpreadConstraint specifies how to spread matching pods among the given topology.
type TopologySpreadConstraint struct {
	// MaxSkew describes the degree to which pods may be unevenly distributed.
	// It's the maximum permitted difference between the number of matching pods in
	// any two topology domains of a given topology type.
	// For example, in a 3-zone cluster, MaxSkew is set to 1, and pods with the same
	// labelSelector spread as 1/1/0:
	// +-------+-------+-------+
	// | zone1 | zone2 | zone3 |
	// +-------+-------+-------+
	// |   P   |   P   |       |
	// +-------+-------+-------+
	// - if MaxSkew is 1, incoming pod can only be scheduled to zone3 to become 1/1/1;
	// scheduling it onto zone1(zone2) would make the ActualSkew(2-0) on zone1(zone2)
	// violate MaxSkew(1).
	// - if MaxSkew is 2, incoming pod can be scheduled onto any zone.
	// It's a required field. Default value is 1 and 0 is not allowed.
	MaxSkew int32 `protobuf:"varint,1,opt,name=maxSkew" json:"maxSkew"`
	// TopologyKey is the key of node labels. Nodes that have a label with this key
	// and identical values are considered to be in the same topology.
	// We consider each <key, value> as a "bucket", and try to put balanced number
	// of pods into each bucket.
	// It's a required field.
	TopologyKey string `protobuf:"bytes,2,opt,name=topologyKey" json:"topologyKey"`
	// WhenUnsatisfiable indicates how to deal with a pod if it doesn't satisfy
	// the spread constraint.
	// - DoNotSchedule (default) tells the scheduler not to schedule it
	// - ScheduleAnyway tells the scheduler to still schedule it
	// It's considered as "Unsatisfiable" if and only if placing incoming pod on any
	// topology violates "MaxSkew".
	// For example, in a 3-zone cluster, MaxSkew is set to 1, and pods with the same
	// labelSelector spread as 3/1/1:
	// +-------+-------+-------+
	// | zone1 | zone2 | zone3 |
	// +-------+-------+-------+
	// | P P P |   P   |   P   |
	// +-------+-------+-------+
	// If WhenUnsatisfiable is set to DoNotSchedule, incoming pod can only be scheduled
	// to zone2(zone3) to become 3/2/1(3/1/2) as ActualSkew(2-1) on zone2(zone3) satisfies
	// MaxSkew(1). In other words, the cluster can still be imbalanced, but scheduler
	// won't make it *more* imbalanced.
	// It's a required field.
	WhenUnsatisfiable string `protobuf:"bytes,3,opt,name=whenUnsatisfiable" json:"whenUnsatisfiable"`
	// LabelSelector is used to find matching pods.
	// Pods that match this label selector are counted to determine the number of pods
	// in their corresponding topology domain.
	// +optional
	LabelSelector *v1.LabelSelector `protobuf:"bytes,4,opt,name=labelSelector" json:"labelSelector,omitempty"`
}

func (m *TopologySpreadConstraint) Reset()      { *m = TopologySpreadConstraint{} }
func (*TopologySpreadConstraint) ProtoMessage() {}
func (*TopologySpreadConstraint) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{192}
}
func (m *TopologySpreadConstraint) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TopologySpreadConstraint) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TopologySpreadConstraint.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *TopologySpreadConstraint) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TopologySpreadConstraint.Merge(m, src)
}
func (m *TopologySpreadConstraint) XXX_Size() int {
	return m.Size()
}
func (m *TopologySpreadConstraint) XXX_DiscardUnknown() {
	xxx_messageInfo_TopologySpreadConstraint.DiscardUnknown(m)
}

var xxx_messageInfo_TopologySpreadConstraint proto.InternalMessageInfo

func (m *TopologySpreadConstraint) GetMaxSkew() int32 {
	if m != nil {
		return m.MaxSkew
	}
	return 0
}

func (m *TopologySpreadConstraint) GetTopologyKey() string {
	if m != nil {
		return m.TopologyKey
	}
	return ""
}

func (m *TopologySpreadConstraint) GetWhenUnsatisfiable() string {
	if m != nil {
		return m.WhenUnsatisfiable
	}
	return ""
}

func (m *TopologySpreadConstraint) GetLabelSelector() *v1.LabelSelector {
	if m != nil {
		return m.LabelSelector
	}
	return nil
}

// TypedLocalObjectReference contains enough information to let you locate the
// typed referenced object inside the same namespace.
type TypedLocalObjectReference struct {
	// APIGroup is the group for the resource being referenced.
	// If APIGroup is not specified, the specified Kind must be in the core API group.
	// For any other third-party types, APIGroup is required.
	// +optional
	ApiGroup string `protobuf:"bytes,1,opt,name=apiGroup" json:"apiGroup"`
	// Kind is the type of resource being referenced
	Kind string `protobuf:"bytes,2,opt,name=kind" json:"kind"`
	// Name is the name of resource being referenced
	Name string `protobuf:"bytes,3,opt,name=name" json:"name"`
}

func (m *TypedLocalObjectReference) Reset()      { *m = TypedLocalObjectReference{} }
func (*TypedLocalObjectReference) ProtoMessage() {}
func (*TypedLocalObjectReference) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{193}
}
func (m *TypedLocalObjectReference) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TypedLocalObjectReference) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TypedLocalObjectReference.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *TypedLocalObjectReference) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TypedLocalObjectReference.Merge(m, src)
}
func (m *TypedLocalObjectReference) XXX_Size() int {
	return m.Size()
}
func (m *TypedLocalObjectReference) XXX_DiscardUnknown() {
	xxx_messageInfo_TypedLocalObjectReference.DiscardUnknown(m)
}

var xxx_messageInfo_TypedLocalObjectReference proto.InternalMessageInfo

func (m *TypedLocalObjectReference) GetApiGroup() string {
	if m != nil {
		return m.ApiGroup
	}
	return ""
}

func (m *TypedLocalObjectReference) GetKind() string {
	if m != nil {
		return m.Kind
	}
	return ""
}

func (m *TypedLocalObjectReference) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Volume represents a named volume in a pod that may be accessed by any container in the pod.
type Volume struct {
	// Volume's name.
	// Must be a DNS_LABEL and unique within the pod.
	// More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
	Name string `protobuf:"bytes,1,opt,name=name" json:"name"`
	// VolumeSource represents the location and type of the mounted volume.
	// If not specified, the Volume is implied to be an EmptyDir.
	// This implied behavior is deprecated and will be removed in a future version.
	VolumeSource *VolumeSource `protobuf:"bytes,2,opt,name=volumeSource" json:"volumeSource,omitempty"`
}

func (m *Volume) Reset()      { *m = Volume{} }
func (*Volume) ProtoMessage() {}
func (*Volume) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{194}
}
func (m *Volume) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Volume) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Volume.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Volume) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Volume.Merge(m, src)
}
func (m *Volume) XXX_Size() int {
	return m.Size()
}
func (m *Volume) XXX_DiscardUnknown() {
	xxx_messageInfo_Volume.DiscardUnknown(m)
}

var xxx_messageInfo_Volume proto.InternalMessageInfo

func (m *Volume) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Volume) GetVolumeSource() *VolumeSource {
	if m != nil {
		return m.VolumeSource
	}
	return nil
}

// volumeDevice describes a mapping of a raw block device within a container.
type VolumeDevice struct {
	// name must match the name of a persistentVolumeClaim in the pod
	Name string `protobuf:"bytes,1,opt,name=name" json:"name"`
	// devicePath is the path inside of the container that the device will be mapped to.
	DevicePath string `protobuf:"bytes,2,opt,name=devicePath" json:"devicePath"`
}

func (m *VolumeDevice) Reset()      { *m = VolumeDevice{} }
func (*VolumeDevice) ProtoMessage() {}
func (*VolumeDevice) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{195}
}
func (m *VolumeDevice) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *VolumeDevice) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_VolumeDevice.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *VolumeDevice) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VolumeDevice.Merge(m, src)
}
func (m *VolumeDevice) XXX_Size() int {
	return m.Size()
}
func (m *VolumeDevice) XXX_DiscardUnknown() {
	xxx_messageInfo_VolumeDevice.DiscardUnknown(m)
}

var xxx_messageInfo_VolumeDevice proto.InternalMessageInfo

func (m *VolumeDevice) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *VolumeDevice) GetDevicePath() string {
	if m != nil {
		return m.DevicePath
	}
	return ""
}

// VolumeMount describes a mounting of a Volume within a container.
type VolumeMount struct {
	// This must match the Name of a Volume.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name"`
	// Mounted read-only if true, read-write otherwise (false or unspecified).
	// Defaults to false.
	// +optional
	ReadOnly bool `protobuf:"varint,2,opt,name=readOnly" json:"readOnly"`
	// Path within the container at which the volume should be mounted.  Must
	// not contain ':'.
	MountPath string `protobuf:"bytes,3,opt,name=mountPath" json:"mountPath"`
	// Path within the volume from which the container's volume should be mounted.
	// Defaults to "" (volume's root).
	// +optional
	SubPath string `protobuf:"bytes,4,opt,name=subPath" json:"subPath"`
	// mountPropagation determines how mounts are propagated from the host
	// to container and the other way around.
	// When not set, MountPropagationNone is used.
	// This field is beta in 1.10.
	// +optional
	MountPropagation string `protobuf:"bytes,5,opt,name=mountPropagation" json:"mountPropagation"`
	// Expanded path within the volume from which the container's volume should be mounted.
	// Behaves similarly to SubPath but environment variable references $(VAR_NAME) are expanded using the container's environment.
	// Defaults to "" (volume's root).
	// SubPathExpr and SubPath are mutually exclusive.
	// This field is beta in 1.15.
	// +optional
	SubPathExpr string `protobuf:"bytes,6,opt,name=subPathExpr" json:"subPathExpr"`
}

func (m *VolumeMount) Reset()      { *m = VolumeMount{} }
func (*VolumeMount) ProtoMessage() {}
func (*VolumeMount) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{196}
}
func (m *VolumeMount) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *VolumeMount) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_VolumeMount.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *VolumeMount) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VolumeMount.Merge(m, src)
}
func (m *VolumeMount) XXX_Size() int {
	return m.Size()
}
func (m *VolumeMount) XXX_DiscardUnknown() {
	xxx_messageInfo_VolumeMount.DiscardUnknown(m)
}

var xxx_messageInfo_VolumeMount proto.InternalMessageInfo

func (m *VolumeMount) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *VolumeMount) GetReadOnly() bool {
	if m != nil {
		return m.ReadOnly
	}
	return false
}

func (m *VolumeMount) GetMountPath() string {
	if m != nil {
		return m.MountPath
	}
	return ""
}

func (m *VolumeMount) GetSubPath() string {
	if m != nil {
		return m.SubPath
	}
	return ""
}

func (m *VolumeMount) GetMountPropagation() string {
	if m != nil {
		return m.MountPropagation
	}
	return ""
}

func (m *VolumeMount) GetSubPathExpr() string {
	if m != nil {
		return m.SubPathExpr
	}
	return ""
}

// VolumeNodeAffinity defines constraints that limit what nodes this volume can be accessed from.
type VolumeNodeAffinity struct {
	// Required specifies hard node constraints that must be met.
	Required *NodeSelector `protobuf:"bytes,1,opt,name=required" json:"required,omitempty"`
}

func (m *VolumeNodeAffinity) Reset()      { *m = VolumeNodeAffinity{} }
func (*VolumeNodeAffinity) ProtoMessage() {}
func (*VolumeNodeAffinity) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{197}
}
func (m *VolumeNodeAffinity) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *VolumeNodeAffinity) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_VolumeNodeAffinity.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *VolumeNodeAffinity) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VolumeNodeAffinity.Merge(m, src)
}
func (m *VolumeNodeAffinity) XXX_Size() int {
	return m.Size()
}
func (m *VolumeNodeAffinity) XXX_DiscardUnknown() {
	xxx_messageInfo_VolumeNodeAffinity.DiscardUnknown(m)
}

var xxx_messageInfo_VolumeNodeAffinity proto.InternalMessageInfo

func (m *VolumeNodeAffinity) GetRequired() *NodeSelector {
	if m != nil {
		return m.Required
	}
	return nil
}

// Projection that may be projected along with other supported volume types
type VolumeProjection struct {
	// information about the secret data to project
	// +optional
	Secret *SecretProjection `protobuf:"bytes,1,opt,name=secret" json:"secret,omitempty"`
	// information about the downwardAPI data to project
	// +optional
	DownwardAPI *DownwardAPIProjection `protobuf:"bytes,2,opt,name=downwardAPI" json:"downwardAPI,omitempty"`
	// information about the configMap data to project
	// +optional
	ConfigMap *ConfigMapProjection `protobuf:"bytes,3,opt,name=configMap" json:"configMap,omitempty"`
	// information about the serviceAccountToken data to project
	// +optional
	ServiceAccountToken *ServiceAccountTokenProjection `protobuf:"bytes,4,opt,name=serviceAccountToken" json:"serviceAccountToken,omitempty"`
}

func (m *VolumeProjection) Reset()      { *m = VolumeProjection{} }
func (*VolumeProjection) ProtoMessage() {}
func (*VolumeProjection) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{198}
}
func (m *VolumeProjection) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *VolumeProjection) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_VolumeProjection.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *VolumeProjection) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VolumeProjection.Merge(m, src)
}
func (m *VolumeProjection) XXX_Size() int {
	return m.Size()
}
func (m *VolumeProjection) XXX_DiscardUnknown() {
	xxx_messageInfo_VolumeProjection.DiscardUnknown(m)
}

var xxx_messageInfo_VolumeProjection proto.InternalMessageInfo

func (m *VolumeProjection) GetSecret() *SecretProjection {
	if m != nil {
		return m.Secret
	}
	return nil
}

func (m *VolumeProjection) GetDownwardAPI() *DownwardAPIProjection {
	if m != nil {
		return m.DownwardAPI
	}
	return nil
}

func (m *VolumeProjection) GetConfigMap() *ConfigMapProjection {
	if m != nil {
		return m.ConfigMap
	}
	return nil
}

func (m *VolumeProjection) GetServiceAccountToken() *ServiceAccountTokenProjection {
	if m != nil {
		return m.ServiceAccountToken
	}
	return nil
}

// Represents the source of a volume to mount.
// Only one of its members may be specified.
type VolumeSource struct {
	// HostPath represents a pre-existing file or directory on the host
	// machine that is directly exposed to the container. This is generally
	// used for system agents or other privileged things that are allowed
	// to see the host machine. Most containers will NOT need this.
	// More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath
	// ---
	// TODO(jonesdl) We need to restrict who can use host directory mounts and who can/can not
	// mount host directories as read/write.
	// +optional
	HostPath *HostPathVolumeSource `protobuf:"bytes,1,opt,name=hostPath" json:"hostPath,omitempty"`
	// EmptyDir represents a temporary directory that shares a pod's lifetime.
	// More info: https://kubernetes.io/docs/concepts/storage/volumes#emptydir
	// +optional
	EmptyDir *EmptyDirVolumeSource `protobuf:"bytes,2,opt,name=emptyDir" json:"emptyDir,omitempty"`
	// GCEPersistentDisk represents a GCE Disk resource that is attached to a
	// kubelet's host machine and then exposed to the pod.
	// More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
	// +optional
	GcePersistentDisk *GCEPersistentDiskVolumeSource `protobuf:"bytes,3,opt,name=gcePersistentDisk" json:"gcePersistentDisk,omitempty"`
	// AWSElasticBlockStore represents an AWS Disk resource that is attached to a
	// kubelet's host machine and then exposed to the pod.
	// More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
	// +optional
	AwsElasticBlockStore *AWSElasticBlockStoreVolumeSource `protobuf:"bytes,4,opt,name=awsElasticBlockStore" json:"awsElasticBlockStore,omitempty"`
	// GitRepo represents a git repository at a particular revision.
	// DEPRECATED: GitRepo is deprecated. To provision a container with a git repo, mount an
	// EmptyDir into an InitContainer that clones the repo using git, then mount the EmptyDir
	// into the Pod's container.
	// +optional
	GitRepo *GitRepoVolumeSource `protobuf:"bytes,5,opt,name=gitRepo" json:"gitRepo,omitempty"`
	// Secret represents a secret that should populate this volume.
	// More info: https://kubernetes.io/docs/concepts/storage/volumes#secret
	// +optional
	Secret *SecretVolumeSource `protobuf:"bytes,6,opt,name=secret" json:"secret,omitempty"`
	// NFS represents an NFS mount on the host that shares a pod's lifetime
	// More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs
	// +optional
	Nfs *NFSVolumeSource `protobuf:"bytes,7,opt,name=nfs" json:"nfs,omitempty"`
	// ISCSI represents an ISCSI Disk resource that is attached to a
	// kubelet's host machine and then exposed to the pod.
	// More info: https://examples.k8s.io/volumes/iscsi/README.md
	// +optional
	Iscsi *ISCSIVolumeSource `protobuf:"bytes,8,opt,name=iscsi" json:"iscsi,omitempty"`
	// Glusterfs represents a Glusterfs mount on the host that shares a pod's lifetime.
	// More info: https://examples.k8s.io/volumes/glusterfs/README.md
	// +optional
	Glusterfs *GlusterfsVolumeSource `protobuf:"bytes,9,opt,name=glusterfs" json:"glusterfs,omitempty"`
	// PersistentVolumeClaimVolumeSource represents a reference to a
	// PersistentVolumeClaim in the same namespace.
	// More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims
	// +optional
	PersistentVolumeClaim *PersistentVolumeClaimVolumeSource `protobuf:"bytes,10,opt,name=persistentVolumeClaim" json:"persistentVolumeClaim,omitempty"`
	// RBD represents a Rados Block Device mount on the host that shares a pod's lifetime.
	// More info: https://examples.k8s.io/volumes/rbd/README.md
	// +optional
	Rbd *RBDVolumeSource `protobuf:"bytes,11,opt,name=rbd" json:"rbd,omitempty"`
	// FlexVolume represents a generic volume resource that is
	// provisioned/attached using an exec based plugin.
	// +optional
	FlexVolume *FlexVolumeSource `protobuf:"bytes,12,opt,name=flexVolume" json:"flexVolume,omitempty"`
	// Cinder represents a cinder volume attached and mounted on kubelets host machine.
	// More info: https://examples.k8s.io/mysql-cinder-pd/README.md
	// +optional
	Cinder *CinderVolumeSource `protobuf:"bytes,13,opt,name=cinder" json:"cinder,omitempty"`
	// CephFS represents a Ceph FS mount on the host that shares a pod's lifetime
	// +optional
	Cephfs *CephFSVolumeSource `protobuf:"bytes,14,opt,name=cephfs" json:"cephfs,omitempty"`
	// Flocker represents a Flocker volume attached to a kubelet's host machine. This depends on the Flocker control service being running
	// +optional
	Flocker *FlockerVolumeSource `protobuf:"bytes,15,opt,name=flocker" json:"flocker,omitempty"`
	// DownwardAPI represents downward API about the pod that should populate this volume
	// +optional
	DownwardAPI *DownwardAPIVolumeSource `protobuf:"bytes,16,opt,name=downwardAPI" json:"downwardAPI,omitempty"`
	// FC represents a Fibre Channel resource that is attached to a kubelet's host machine and then exposed to the pod.
	// +optional
	Fc *FCVolumeSource `protobuf:"bytes,17,opt,name=fc" json:"fc,omitempty"`
	// AzureFile represents an Azure File Service mount on the host and bind mount to the pod.
	// +optional
	AzureFile *AzureFileVolumeSource `protobuf:"bytes,18,opt,name=azureFile" json:"azureFile,omitempty"`
	// ConfigMap represents a configMap that should populate this volume
	// +optional
	ConfigMap *ConfigMapVolumeSource `protobuf:"bytes,19,opt,name=configMap" json:"configMap,omitempty"`
	// VsphereVolume represents a vSphere volume attached and mounted on kubelets host machine
	// +optional
	VsphereVolume *VsphereVirtualDiskVolumeSource `protobuf:"bytes,20,opt,name=vsphereVolume" json:"vsphereVolume,omitempty"`
	// Quobyte represents a Quobyte mount on the host that shares a pod's lifetime
	// +optional
	Quobyte *QuobyteVolumeSource `protobuf:"bytes,21,opt,name=quobyte" json:"quobyte,omitempty"`
	// AzureDisk represents an Azure Data Disk mount on the host and bind mount to the pod.
	// +optional
	AzureDisk *AzureDiskVolumeSource `protobuf:"bytes,22,opt,name=azureDisk" json:"azureDisk,omitempty"`
	// PhotonPersistentDisk represents a PhotonController persistent disk attached and mounted on kubelets host machine
	PhotonPersistentDisk *PhotonPersistentDiskVolumeSource `protobuf:"bytes,23,opt,name=photonPersistentDisk" json:"photonPersistentDisk,omitempty"`
	// Items for all in one resources secrets, configmaps, and downward API
	Projected *ProjectedVolumeSource `protobuf:"bytes,26,opt,name=projected" json:"projected,omitempty"`
	// PortworxVolume represents a portworx volume attached and mounted on kubelets host machine
	// +optional
	PortworxVolume *PortworxVolumeSource `protobuf:"bytes,24,opt,name=portworxVolume" json:"portworxVolume,omitempty"`
	// ScaleIO represents a ScaleIO persistent volume attached and mounted on Kubernetes nodes.
	// +optional
	ScaleIO *ScaleIOVolumeSource `protobuf:"bytes,25,opt,name=scaleIO" json:"scaleIO,omitempty"`
	// StorageOS represents a StorageOS volume attached and mounted on Kubernetes nodes.
	// +optional
	Storageos *StorageOSVolumeSource `protobuf:"bytes,27,opt,name=storageos" json:"storageos,omitempty"`
	// CSI (Container Storage Interface) represents storage that is handled by an external CSI driver (Alpha feature).
	// +optional
	Csi *CSIVolumeSource `protobuf:"bytes,28,opt,name=csi" json:"csi,omitempty"`
}

func (m *VolumeSource) Reset()      { *m = VolumeSource{} }
func (*VolumeSource) ProtoMessage() {}
func (*VolumeSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{199}
}
func (m *VolumeSource) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *VolumeSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_VolumeSource.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *VolumeSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VolumeSource.Merge(m, src)
}
func (m *VolumeSource) XXX_Size() int {
	return m.Size()
}
func (m *VolumeSource) XXX_DiscardUnknown() {
	xxx_messageInfo_VolumeSource.DiscardUnknown(m)
}

var xxx_messageInfo_VolumeSource proto.InternalMessageInfo

func (m *VolumeSource) GetHostPath() *HostPathVolumeSource {
	if m != nil {
		return m.HostPath
	}
	return nil
}

func (m *VolumeSource) GetEmptyDir() *EmptyDirVolumeSource {
	if m != nil {
		return m.EmptyDir
	}
	return nil
}

func (m *VolumeSource) GetGcePersistentDisk() *GCEPersistentDiskVolumeSource {
	if m != nil {
		return m.GcePersistentDisk
	}
	return nil
}

func (m *VolumeSource) GetAwsElasticBlockStore() *AWSElasticBlockStoreVolumeSource {
	if m != nil {
		return m.AwsElasticBlockStore
	}
	return nil
}

func (m *VolumeSource) GetGitRepo() *GitRepoVolumeSource {
	if m != nil {
		return m.GitRepo
	}
	return nil
}

func (m *VolumeSource) GetSecret() *SecretVolumeSource {
	if m != nil {
		return m.Secret
	}
	return nil
}

func (m *VolumeSource) GetNfs() *NFSVolumeSource {
	if m != nil {
		return m.Nfs
	}
	return nil
}

func (m *VolumeSource) GetIscsi() *ISCSIVolumeSource {
	if m != nil {
		return m.Iscsi
	}
	return nil
}

func (m *VolumeSource) GetGlusterfs() *GlusterfsVolumeSource {
	if m != nil {
		return m.Glusterfs
	}
	return nil
}

func (m *VolumeSource) GetPersistentVolumeClaim() *PersistentVolumeClaimVolumeSource {
	if m != nil {
		return m.PersistentVolumeClaim
	}
	return nil
}

func (m *VolumeSource) GetRbd() *RBDVolumeSource {
	if m != nil {
		return m.Rbd
	}
	return nil
}

func (m *VolumeSource) GetFlexVolume() *FlexVolumeSource {
	if m != nil {
		return m.FlexVolume
	}
	return nil
}

func (m *VolumeSource) GetCinder() *CinderVolumeSource {
	if m != nil {
		return m.Cinder
	}
	return nil
}

func (m *VolumeSource) GetCephfs() *CephFSVolumeSource {
	if m != nil {
		return m.Cephfs
	}
	return nil
}

func (m *VolumeSource) GetFlocker() *FlockerVolumeSource {
	if m != nil {
		return m.Flocker
	}
	return nil
}

func (m *VolumeSource) GetDownwardAPI() *DownwardAPIVolumeSource {
	if m != nil {
		return m.DownwardAPI
	}
	return nil
}

func (m *VolumeSource) GetFc() *FCVolumeSource {
	if m != nil {
		return m.Fc
	}
	return nil
}

func (m *VolumeSource) GetAzureFile() *AzureFileVolumeSource {
	if m != nil {
		return m.AzureFile
	}
	return nil
}

func (m *VolumeSource) GetConfigMap() *ConfigMapVolumeSource {
	if m != nil {
		return m.ConfigMap
	}
	return nil
}

func (m *VolumeSource) GetVsphereVolume() *VsphereVirtualDiskVolumeSource {
	if m != nil {
		return m.VsphereVolume
	}
	return nil
}

func (m *VolumeSource) GetQuobyte() *QuobyteVolumeSource {
	if m != nil {
		return m.Quobyte
	}
	return nil
}

func (m *VolumeSource) GetAzureDisk() *AzureDiskVolumeSource {
	if m != nil {
		return m.AzureDisk
	}
	return nil
}

func (m *VolumeSource) GetPhotonPersistentDisk() *PhotonPersistentDiskVolumeSource {
	if m != nil {
		return m.PhotonPersistentDisk
	}
	return nil
}

func (m *VolumeSource) GetProjected() *ProjectedVolumeSource {
	if m != nil {
		return m.Projected
	}
	return nil
}

func (m *VolumeSource) GetPortworxVolume() *PortworxVolumeSource {
	if m != nil {
		return m.PortworxVolume
	}
	return nil
}

func (m *VolumeSource) GetScaleIO() *ScaleIOVolumeSource {
	if m != nil {
		return m.ScaleIO
	}
	return nil
}

func (m *VolumeSource) GetStorageos() *StorageOSVolumeSource {
	if m != nil {
		return m.Storageos
	}
	return nil
}

func (m *VolumeSource) GetCsi() *CSIVolumeSource {
	if m != nil {
		return m.Csi
	}
	return nil
}

// Represents a vSphere volume resource.
type VsphereVirtualDiskVolumeSource struct {
	// Path that identifies vSphere volume vmdk
	VolumePath string `protobuf:"bytes,1,opt,name=volumePath" json:"volumePath"`
	// Filesystem type to mount.
	// Must be a filesystem type supported by the host operating system.
	// Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
	// +optional
	FsType string `protobuf:"bytes,2,opt,name=fsType" json:"fsType"`
	// Storage Policy Based Management (SPBM) profile name.
	// +optional
	StoragePolicyName string `protobuf:"bytes,3,opt,name=storagePolicyName" json:"storagePolicyName"`
	// Storage Policy Based Management (SPBM) profile ID associated with the StoragePolicyName.
	// +optional
	StoragePolicyID string `protobuf:"bytes,4,opt,name=storagePolicyID" json:"storagePolicyID"`
}

func (m *VsphereVirtualDiskVolumeSource) Reset()      { *m = VsphereVirtualDiskVolumeSource{} }
func (*VsphereVirtualDiskVolumeSource) ProtoMessage() {}
func (*VsphereVirtualDiskVolumeSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{200}
}
func (m *VsphereVirtualDiskVolumeSource) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *VsphereVirtualDiskVolumeSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_VsphereVirtualDiskVolumeSource.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *VsphereVirtualDiskVolumeSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VsphereVirtualDiskVolumeSource.Merge(m, src)
}
func (m *VsphereVirtualDiskVolumeSource) XXX_Size() int {
	return m.Size()
}
func (m *VsphereVirtualDiskVolumeSource) XXX_DiscardUnknown() {
	xxx_messageInfo_VsphereVirtualDiskVolumeSource.DiscardUnknown(m)
}

var xxx_messageInfo_VsphereVirtualDiskVolumeSource proto.InternalMessageInfo

func (m *VsphereVirtualDiskVolumeSource) GetVolumePath() string {
	if m != nil {
		return m.VolumePath
	}
	return ""
}

func (m *VsphereVirtualDiskVolumeSource) GetFsType() string {
	if m != nil {
		return m.FsType
	}
	return ""
}

func (m *VsphereVirtualDiskVolumeSource) GetStoragePolicyName() string {
	if m != nil {
		return m.StoragePolicyName
	}
	return ""
}

func (m *VsphereVirtualDiskVolumeSource) GetStoragePolicyID() string {
	if m != nil {
		return m.StoragePolicyID
	}
	return ""
}

// The weights of all of the matched WeightedPodAffinityTerm fields are added per-node to find the most preferred node(s)
type WeightedPodAffinityTerm struct {
	// weight associated with matching the corresponding podAffinityTerm,
	// in the range 1-100.
	Weight int32 `protobuf:"varint,1,opt,name=weight" json:"weight"`
	// Required. A pod affinity term, associated with the corresponding weight.
	PodAffinityTerm *PodAffinityTerm `protobuf:"bytes,2,opt,name=podAffinityTerm" json:"podAffinityTerm,omitempty"`
}

func (m *WeightedPodAffinityTerm) Reset()      { *m = WeightedPodAffinityTerm{} }
func (*WeightedPodAffinityTerm) ProtoMessage() {}
func (*WeightedPodAffinityTerm) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{201}
}
func (m *WeightedPodAffinityTerm) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *WeightedPodAffinityTerm) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_WeightedPodAffinityTerm.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *WeightedPodAffinityTerm) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WeightedPodAffinityTerm.Merge(m, src)
}
func (m *WeightedPodAffinityTerm) XXX_Size() int {
	return m.Size()
}
func (m *WeightedPodAffinityTerm) XXX_DiscardUnknown() {
	xxx_messageInfo_WeightedPodAffinityTerm.DiscardUnknown(m)
}

var xxx_messageInfo_WeightedPodAffinityTerm proto.InternalMessageInfo

func (m *WeightedPodAffinityTerm) GetWeight() int32 {
	if m != nil {
		return m.Weight
	}
	return 0
}

func (m *WeightedPodAffinityTerm) GetPodAffinityTerm() *PodAffinityTerm {
	if m != nil {
		return m.PodAffinityTerm
	}
	return nil
}

// WindowsSecurityContextOptions contain Windows-specific options and credentials.
type WindowsSecurityContextOptions struct {
	// GMSACredentialSpecName is the name of the GMSA credential spec to use.
	// This field is alpha-level and is only honored by servers that enable the WindowsGMSA feature flag.
	// +optional
	GmsaCredentialSpecName string `protobuf:"bytes,1,opt,name=gmsaCredentialSpecName" json:"gmsaCredentialSpecName"`
	// GMSACredentialSpec is where the GMSA admission webhook
	// (https://github.com/kubernetes-sigs/windows-gmsa) inlines the contents of the
	// GMSA credential spec named by the GMSACredentialSpecName field.
	// This field is alpha-level and is only honored by servers that enable the WindowsGMSA feature flag.
	// +optional
	GmsaCredentialSpec string `protobuf:"bytes,2,opt,name=gmsaCredentialSpec" json:"gmsaCredentialSpec"`
	// The UserName in Windows to run the entrypoint of the container process.
	// Defaults to the user specified in image metadata if unspecified.
	// May also be set in PodSecurityContext. If set in both SecurityContext and
	// PodSecurityContext, the value specified in SecurityContext takes precedence.
	// This field is alpha-level and it is only honored by servers that enable the WindowsRunAsUserName feature flag.
	// +optional
	RunAsUserName string `protobuf:"bytes,3,opt,name=runAsUserName" json:"runAsUserName"`
}

func (m *WindowsSecurityContextOptions) Reset()      { *m = WindowsSecurityContextOptions{} }
func (*WindowsSecurityContextOptions) ProtoMessage() {}
func (*WindowsSecurityContextOptions) Descriptor() ([]byte, []int) {
	return fileDescriptor_6c07b07c062484ab, []int{202}
}
func (m *WindowsSecurityContextOptions) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *WindowsSecurityContextOptions) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_WindowsSecurityContextOptions.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *WindowsSecurityContextOptions) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WindowsSecurityContextOptions.Merge(m, src)
}
func (m *WindowsSecurityContextOptions) XXX_Size() int {
	return m.Size()
}
func (m *WindowsSecurityContextOptions) XXX_DiscardUnknown() {
	xxx_messageInfo_WindowsSecurityContextOptions.DiscardUnknown(m)
}

var xxx_messageInfo_WindowsSecurityContextOptions proto.InternalMessageInfo

func (m *WindowsSecurityContextOptions) GetGmsaCredentialSpecName() string {
	if m != nil {
		return m.GmsaCredentialSpecName
	}
	return ""
}

func (m *WindowsSecurityContextOptions) GetGmsaCredentialSpec() string {
	if m != nil {
		return m.GmsaCredentialSpec
	}
	return ""
}

func (m *WindowsSecurityContextOptions) GetRunAsUserName() string {
	if m != nil {
		return m.RunAsUserName
	}
	return ""
}

func init() {
	proto.RegisterType((*AWSElasticBlockStoreVolumeSource)(nil), "k8s.io.api.core.v1.AWSElasticBlockStoreVolumeSource")
	proto.RegisterType((*Affinity)(nil), "k8s.io.api.core.v1.Affinity")
	proto.RegisterType((*AttachedVolume)(nil), "k8s.io.api.core.v1.AttachedVolume")
	proto.RegisterType((*AvoidPods)(nil), "k8s.io.api.core.v1.AvoidPods")
	proto.RegisterType((*AzureDiskVolumeSource)(nil), "k8s.io.api.core.v1.AzureDiskVolumeSource")
	proto.RegisterType((*AzureFilePersistentVolumeSource)(nil), "k8s.io.api.core.v1.AzureFilePersistentVolumeSource")
	proto.RegisterType((*AzureFileVolumeSource)(nil), "k8s.io.api.core.v1.AzureFileVolumeSource")
	proto.RegisterType((*Binding)(nil), "k8s.io.api.core.v1.Binding")
	proto.RegisterType((*CSIPersistentVolumeSource)(nil), "k8s.io.api.core.v1.CSIPersistentVolumeSource")
	proto.RegisterMapType((map[string]string)(nil), "k8s.io.api.core.v1.CSIPersistentVolumeSource.VolumeAttributesEntry")
	proto.RegisterType((*CSIVolumeSource)(nil), "k8s.io.api.core.v1.CSIVolumeSource")
	proto.RegisterMapType((map[string]string)(nil), "k8s.io.api.core.v1.CSIVolumeSource.VolumeAttributesEntry")
	proto.RegisterType((*Capabilities)(nil), "k8s.io.api.core.v1.Capabilities")
	proto.RegisterType((*CephFSPersistentVolumeSource)(nil), "k8s.io.api.core.v1.CephFSPersistentVolumeSource")
	proto.RegisterType((*CephFSVolumeSource)(nil), "k8s.io.api.core.v1.CephFSVolumeSource")
	proto.RegisterType((*CinderPersistentVolumeSource)(nil), "k8s.io.api.core.v1.CinderPersistentVolumeSource")
	proto.RegisterType((*CinderVolumeSource)(nil), "k8s.io.api.core.v1.CinderVolumeSource")
	proto.RegisterType((*ClientIPConfig)(nil), "k8s.io.api.core.v1.ClientIPConfig")
	proto.RegisterType((*ComponentCondition)(nil), "k8s.io.api.core.v1.ComponentCondition")
	proto.RegisterType((*ComponentStatus)(nil), "k8s.io.api.core.v1.ComponentStatus")
	proto.RegisterType((*ComponentStatusList)(nil), "k8s.io.api.core.v1.ComponentStatusList")
	proto.RegisterType((*ConfigMap)(nil), "k8s.io.api.core.v1.ConfigMap")
	proto.RegisterMapType((map[string][]byte)(nil), "k8s.io.api.core.v1.ConfigMap.BinaryDataEntry")
	proto.RegisterMapType((map[string]string)(nil), "k8s.io.api.core.v1.ConfigMap.DataEntry")
	proto.RegisterType((*ConfigMapEnvSource)(nil), "k8s.io.api.core.v1.ConfigMapEnvSource")
	proto.RegisterType((*ConfigMapKeySelector)(nil), "k8s.io.api.core.v1.ConfigMapKeySelector")
	proto.RegisterType((*ConfigMapList)(nil), "k8s.io.api.core.v1.ConfigMapList")
	proto.RegisterType((*ConfigMapNodeConfigSource)(nil), "k8s.io.api.core.v1.ConfigMapNodeConfigSource")
	proto.RegisterType((*ConfigMapProjection)(nil), "k8s.io.api.core.v1.ConfigMapProjection")
	proto.RegisterType((*ConfigMapVolumeSource)(nil), "k8s.io.api.core.v1.ConfigMapVolumeSource")
	proto.RegisterType((*Container)(nil), "k8s.io.api.core.v1.Container")
	proto.RegisterType((*ContainerImage)(nil), "k8s.io.api.core.v1.ContainerImage")
	proto.RegisterType((*ContainerPort)(nil), "k8s.io.api.core.v1.ContainerPort")
	proto.RegisterType((*ContainerState)(nil), "k8s.io.api.core.v1.ContainerState")
	proto.RegisterType((*ContainerStateRunning)(nil), "k8s.io.api.core.v1.ContainerStateRunning")
	proto.RegisterType((*ContainerStateTerminated)(nil), "k8s.io.api.core.v1.ContainerStateTerminated")
	proto.RegisterType((*ContainerStateWaiting)(nil), "k8s.io.api.core.v1.ContainerStateWaiting")
	proto.RegisterType((*ContainerStatus)(nil), "k8s.io.api.core.v1.ContainerStatus")
	proto.RegisterType((*DaemonEndpoint)(nil), "k8s.io.api.core.v1.DaemonEndpoint")
	proto.RegisterType((*DownwardAPIProjection)(nil), "k8s.io.api.core.v1.DownwardAPIProjection")
	proto.RegisterType((*DownwardAPIVolumeFile)(nil), "k8s.io.api.core.v1.DownwardAPIVolumeFile")
	proto.RegisterType((*DownwardAPIVolumeSource)(nil), "k8s.io.api.core.v1.DownwardAPIVolumeSource")
	proto.RegisterType((*EmptyDirVolumeSource)(nil), "k8s.io.api.core.v1.EmptyDirVolumeSource")
	proto.RegisterType((*EndpointAddress)(nil), "k8s.io.api.core.v1.EndpointAddress")
	proto.RegisterType((*EndpointPort)(nil), "k8s.io.api.core.v1.EndpointPort")
	proto.RegisterType((*EndpointSubset)(nil), "k8s.io.api.core.v1.EndpointSubset")
	proto.RegisterType((*Endpoints)(nil), "k8s.io.api.core.v1.Endpoints")
	proto.RegisterType((*EndpointsList)(nil), "k8s.io.api.core.v1.EndpointsList")
	proto.RegisterType((*EnvFromSource)(nil), "k8s.io.api.core.v1.EnvFromSource")
	proto.RegisterType((*EnvVar)(nil), "k8s.io.api.core.v1.EnvVar")
	proto.RegisterType((*EnvVarSource)(nil), "k8s.io.api.core.v1.EnvVarSource")
	proto.RegisterType((*EphemeralContainer)(nil), "k8s.io.api.core.v1.EphemeralContainer")
	proto.RegisterType((*EphemeralContainerCommon)(nil), "k8s.io.api.core.v1.EphemeralContainerCommon")
	proto.RegisterType((*EphemeralContainers)(nil), "k8s.io.api.core.v1.EphemeralContainers")
	proto.RegisterType((*Event)(nil), "k8s.io.api.core.v1.Event")
	proto.RegisterType((*EventList)(nil), "k8s.io.api.core.v1.EventList")
	proto.RegisterType((*EventSeries)(nil), "k8s.io.api.core.v1.EventSeries")
	proto.RegisterType((*EventSource)(nil), "k8s.io.api.core.v1.EventSource")
	proto.RegisterType((*ExecAction)(nil), "k8s.io.api.core.v1.ExecAction")
	proto.RegisterType((*FCVolumeSource)(nil), "k8s.io.api.core.v1.FCVolumeSource")
	proto.RegisterType((*FlexPersistentVolumeSource)(nil), "k8s.io.api.core.v1.FlexPersistentVolumeSource")
	proto.RegisterMapType((map[string]string)(nil), "k8s.io.api.core.v1.FlexPersistentVolumeSource.OptionsEntry")
	proto.RegisterType((*FlexVolumeSource)(nil), "k8s.io.api.core.v1.FlexVolumeSource")
	proto.RegisterMapType((map[string]string)(nil), "k8s.io.api.core.v1.FlexVolumeSource.OptionsEntry")
	proto.RegisterType((*FlockerVolumeSource)(nil), "k8s.io.api.core.v1.FlockerVolumeSource")
	proto.RegisterType((*GCEPersistentDiskVolumeSource)(nil), "k8s.io.api.core.v1.GCEPersistentDiskVolumeSource")
	proto.RegisterType((*GitRepoVolumeSource)(nil), "k8s.io.api.core.v1.GitRepoVolumeSource")
	proto.RegisterType((*GlusterfsPersistentVolumeSource)(nil), "k8s.io.api.core.v1.GlusterfsPersistentVolumeSource")
	proto.RegisterType((*GlusterfsVolumeSource)(nil), "k8s.io.api.core.v1.GlusterfsVolumeSource")
	proto.RegisterType((*HTTPGetAction)(nil), "k8s.io.api.core.v1.HTTPGetAction")
	proto.RegisterType((*HTTPHeader)(nil), "k8s.io.api.core.v1.HTTPHeader")
	proto.RegisterType((*Handler)(nil), "k8s.io.api.core.v1.Handler")
	proto.RegisterType((*HostAlias)(nil), "k8s.io.api.core.v1.HostAlias")
	proto.RegisterType((*HostPathVolumeSource)(nil), "k8s.io.api.core.v1.HostPathVolumeSource")
	proto.RegisterType((*ISCSIPersistentVolumeSource)(nil), "k8s.io.api.core.v1.ISCSIPersistentVolumeSource")
	proto.RegisterType((*ISCSIVolumeSource)(nil), "k8s.io.api.core.v1.ISCSIVolumeSource")
	proto.RegisterType((*KeyToPath)(nil), "k8s.io.api.core.v1.KeyToPath")
	proto.RegisterType((*Lifecycle)(nil), "k8s.io.api.core.v1.Lifecycle")
	proto.RegisterType((*LimitRange)(nil), "k8s.io.api.core.v1.LimitRange")
	proto.RegisterType((*LimitRangeItem)(nil), "k8s.io.api.core.v1.LimitRangeItem")
	proto.RegisterMapType((map[string]*resource.Quantity)(nil), "k8s.io.api.core.v1.LimitRangeItem.DefaultEntry")
	proto.RegisterMapType((map[string]*resource.Quantity)(nil), "k8s.io.api.core.v1.LimitRangeItem.DefaultRequestEntry")
	proto.RegisterMapType((map[string]*resource.Quantity)(nil), "k8s.io.api.core.v1.LimitRangeItem.MaxEntry")
	proto.RegisterMapType((map[string]*resource.Quantity)(nil), "k8s.io.api.core.v1.LimitRangeItem.MaxLimitRequestRatioEntry")
	proto.RegisterMapType((map[string]*resource.Quantity)(nil), "k8s.io.api.core.v1.LimitRangeItem.MinEntry")
	proto.RegisterType((*LimitRangeList)(nil), "k8s.io.api.core.v1.LimitRangeList")
	proto.RegisterType((*LimitRangeSpec)(nil), "k8s.io.api.core.v1.LimitRangeSpec")
	proto.RegisterType((*List)(nil), "k8s.io.api.core.v1.List")
	proto.RegisterType((*LoadBalancerIngress)(nil), "k8s.io.api.core.v1.LoadBalancerIngress")
	proto.RegisterType((*LoadBalancerStatus)(nil), "k8s.io.api.core.v1.LoadBalancerStatus")
	proto.RegisterType((*LocalObjectReference)(nil), "k8s.io.api.core.v1.LocalObjectReference")
	proto.RegisterType((*LocalVolumeSource)(nil), "k8s.io.api.core.v1.LocalVolumeSource")
	proto.RegisterType((*NFSVolumeSource)(nil), "k8s.io.api.core.v1.NFSVolumeSource")
	proto.RegisterType((*Namespace)(nil), "k8s.io.api.core.v1.Namespace")
	proto.RegisterType((*NamespaceList)(nil), "k8s.io.api.core.v1.NamespaceList")
	proto.RegisterType((*NamespaceSpec)(nil), "k8s.io.api.core.v1.NamespaceSpec")
	proto.RegisterType((*NamespaceStatus)(nil), "k8s.io.api.core.v1.NamespaceStatus")
	proto.RegisterType((*Node)(nil), "k8s.io.api.core.v1.Node")
	proto.RegisterType((*NodeAddress)(nil), "k8s.io.api.core.v1.NodeAddress")
	proto.RegisterType((*NodeAffinity)(nil), "k8s.io.api.core.v1.NodeAffinity")
	proto.RegisterType((*NodeCondition)(nil), "k8s.io.api.core.v1.NodeCondition")
	proto.RegisterType((*NodeConfigSource)(nil), "k8s.io.api.core.v1.NodeConfigSource")
	proto.RegisterType((*NodeConfigStatus)(nil), "k8s.io.api.core.v1.NodeConfigStatus")
	proto.RegisterType((*NodeDaemonEndpoints)(nil), "k8s.io.api.core.v1.NodeDaemonEndpoints")
	proto.RegisterType((*NodeList)(nil), "k8s.io.api.core.v1.NodeList")
	proto.RegisterType((*NodeProxyOptions)(nil), "k8s.io.api.core.v1.NodeProxyOptions")
	proto.RegisterType((*NodeResources)(nil), "k8s.io.api.core.v1.NodeResources")
	proto.RegisterMapType((map[string]*resource.Quantity)(nil), "k8s.io.api.core.v1.NodeResources.CapacityEntry")
	proto.RegisterType((*NodeSelector)(nil), "k8s.io.api.core.v1.NodeSelector")
	proto.RegisterType((*NodeSelectorRequirement)(nil), "k8s.io.api.core.v1.NodeSelectorRequirement")
	proto.RegisterType((*NodeSelectorTerm)(nil), "k8s.io.api.core.v1.NodeSelectorTerm")
	proto.RegisterType((*NodeSpec)(nil), "k8s.io.api.core.v1.NodeSpec")
	proto.RegisterType((*NodeStatus)(nil), "k8s.io.api.core.v1.NodeStatus")
	proto.RegisterMapType((map[string]*resource.Quantity)(nil), "k8s.io.api.core.v1.NodeStatus.AllocatableEntry")
	proto.RegisterMapType((map[string]*resource.Quantity)(nil), "k8s.io.api.core.v1.NodeStatus.CapacityEntry")
	proto.RegisterType((*NodeSystemInfo)(nil), "k8s.io.api.core.v1.NodeSystemInfo")
	proto.RegisterType((*ObjectFieldSelector)(nil), "k8s.io.api.core.v1.ObjectFieldSelector")
	proto.RegisterType((*ObjectReference)(nil), "k8s.io.api.core.v1.ObjectReference")
	proto.RegisterType((*PersistentVolume)(nil), "k8s.io.api.core.v1.PersistentVolume")
	proto.RegisterType((*PersistentVolumeClaim)(nil), "k8s.io.api.core.v1.PersistentVolumeClaim")
	proto.RegisterType((*PersistentVolumeClaimCondition)(nil), "k8s.io.api.core.v1.PersistentVolumeClaimCondition")
	proto.RegisterType((*PersistentVolumeClaimList)(nil), "k8s.io.api.core.v1.PersistentVolumeClaimList")
	proto.RegisterType((*PersistentVolumeClaimSpec)(nil), "k8s.io.api.core.v1.PersistentVolumeClaimSpec")
	proto.RegisterType((*PersistentVolumeClaimStatus)(nil), "k8s.io.api.core.v1.PersistentVolumeClaimStatus")
	proto.RegisterMapType((map[string]*resource.Quantity)(nil), "k8s.io.api.core.v1.PersistentVolumeClaimStatus.CapacityEntry")
	proto.RegisterType((*PersistentVolumeClaimVolumeSource)(nil), "k8s.io.api.core.v1.PersistentVolumeClaimVolumeSource")
	proto.RegisterType((*PersistentVolumeList)(nil), "k8s.io.api.core.v1.PersistentVolumeList")
	proto.RegisterType((*PersistentVolumeSource)(nil), "k8s.io.api.core.v1.PersistentVolumeSource")
	proto.RegisterType((*PersistentVolumeSpec)(nil), "k8s.io.api.core.v1.PersistentVolumeSpec")
	proto.RegisterMapType((map[string]*resource.Quantity)(nil), "k8s.io.api.core.v1.PersistentVolumeSpec.CapacityEntry")
	proto.RegisterType((*PersistentVolumeStatus)(nil), "k8s.io.api.core.v1.PersistentVolumeStatus")
	proto.RegisterType((*PhotonPersistentDiskVolumeSource)(nil), "k8s.io.api.core.v1.PhotonPersistentDiskVolumeSource")
	proto.RegisterType((*Pod)(nil), "k8s.io.api.core.v1.Pod")
	proto.RegisterType((*PodAffinity)(nil), "k8s.io.api.core.v1.PodAffinity")
	proto.RegisterType((*PodAffinityTerm)(nil), "k8s.io.api.core.v1.PodAffinityTerm")
	proto.RegisterType((*PodAntiAffinity)(nil), "k8s.io.api.core.v1.PodAntiAffinity")
	proto.RegisterType((*PodAttachOptions)(nil), "k8s.io.api.core.v1.PodAttachOptions")
	proto.RegisterType((*PodCondition)(nil), "k8s.io.api.core.v1.PodCondition")
	proto.RegisterType((*PodDNSConfig)(nil), "k8s.io.api.core.v1.PodDNSConfig")
	proto.RegisterType((*PodDNSConfigOption)(nil), "k8s.io.api.core.v1.PodDNSConfigOption")
	proto.RegisterType((*PodExecOptions)(nil), "k8s.io.api.core.v1.PodExecOptions")
	proto.RegisterType((*PodIP)(nil), "k8s.io.api.core.v1.PodIP")
	proto.RegisterType((*PodList)(nil), "k8s.io.api.core.v1.PodList")
	proto.RegisterType((*PodLogOptions)(nil), "k8s.io.api.core.v1.PodLogOptions")
	proto.RegisterType((*PodPortForwardOptions)(nil), "k8s.io.api.core.v1.PodPortForwardOptions")
	proto.RegisterType((*PodProxyOptions)(nil), "k8s.io.api.core.v1.PodProxyOptions")
	proto.RegisterType((*PodReadinessGate)(nil), "k8s.io.api.core.v1.PodReadinessGate")
	proto.RegisterType((*PodSecurityContext)(nil), "k8s.io.api.core.v1.PodSecurityContext")
	proto.RegisterType((*PodSignature)(nil), "k8s.io.api.core.v1.PodSignature")
	proto.RegisterType((*PodSpec)(nil), "k8s.io.api.core.v1.PodSpec")
	proto.RegisterMapType((map[string]string)(nil), "k8s.io.api.core.v1.PodSpec.NodeSelectorEntry")
	proto.RegisterMapType((map[string]*resource.Quantity)(nil), "k8s.io.api.core.v1.PodSpec.OverheadEntry")
	proto.RegisterType((*PodStatus)(nil), "k8s.io.api.core.v1.PodStatus")
	proto.RegisterType((*PodStatusResult)(nil), "k8s.io.api.core.v1.PodStatusResult")
	proto.RegisterType((*PodTemplate)(nil), "k8s.io.api.core.v1.PodTemplate")
	proto.RegisterType((*PodTemplateList)(nil), "k8s.io.api.core.v1.PodTemplateList")
	proto.RegisterType((*PodTemplateSpec)(nil), "k8s.io.api.core.v1.PodTemplateSpec")
	proto.RegisterType((*PortworxVolumeSource)(nil), "k8s.io.api.core.v1.PortworxVolumeSource")
	proto.RegisterType((*Preconditions)(nil), "k8s.io.api.core.v1.Preconditions")
	proto.RegisterType((*PreferAvoidPodsEntry)(nil), "k8s.io.api.core.v1.PreferAvoidPodsEntry")
	proto.RegisterType((*PreferredSchedulingTerm)(nil), "k8s.io.api.core.v1.PreferredSchedulingTerm")
	proto.RegisterType((*Probe)(nil), "k8s.io.api.core.v1.Probe")
	proto.RegisterType((*ProjectedVolumeSource)(nil), "k8s.io.api.core.v1.ProjectedVolumeSource")
	proto.RegisterType((*QuobyteVolumeSource)(nil), "k8s.io.api.core.v1.QuobyteVolumeSource")
	proto.RegisterType((*RBDPersistentVolumeSource)(nil), "k8s.io.api.core.v1.RBDPersistentVolumeSource")
	proto.RegisterType((*RBDVolumeSource)(nil), "k8s.io.api.core.v1.RBDVolumeSource")
	proto.RegisterType((*RangeAllocation)(nil), "k8s.io.api.core.v1.RangeAllocation")
	proto.RegisterType((*ReplicationController)(nil), "k8s.io.api.core.v1.ReplicationController")
	proto.RegisterType((*ReplicationControllerCondition)(nil), "k8s.io.api.core.v1.ReplicationControllerCondition")
	proto.RegisterType((*ReplicationControllerList)(nil), "k8s.io.api.core.v1.ReplicationControllerList")
	proto.RegisterType((*ReplicationControllerSpec)(nil), "k8s.io.api.core.v1.ReplicationControllerSpec")
	proto.RegisterMapType((map[string]string)(nil), "k8s.io.api.core.v1.ReplicationControllerSpec.SelectorEntry")
	proto.RegisterType((*ReplicationControllerStatus)(nil), "k8s.io.api.core.v1.ReplicationControllerStatus")
	proto.RegisterType((*ResourceFieldSelector)(nil), "k8s.io.api.core.v1.ResourceFieldSelector")
	proto.RegisterType((*ResourceQuota)(nil), "k8s.io.api.core.v1.ResourceQuota")
	proto.RegisterType((*ResourceQuotaList)(nil), "k8s.io.api.core.v1.ResourceQuotaList")
	proto.RegisterType((*ResourceQuotaSpec)(nil), "k8s.io.api.core.v1.ResourceQuotaSpec")
	proto.RegisterMapType((map[string]*resource.Quantity)(nil), "k8s.io.api.core.v1.ResourceQuotaSpec.HardEntry")
	proto.RegisterType((*ResourceQuotaStatus)(nil), "k8s.io.api.core.v1.ResourceQuotaStatus")
	proto.RegisterMapType((map[string]*resource.Quantity)(nil), "k8s.io.api.core.v1.ResourceQuotaStatus.HardEntry")
	proto.RegisterMapType((map[string]*resource.Quantity)(nil), "k8s.io.api.core.v1.ResourceQuotaStatus.UsedEntry")
	proto.RegisterType((*ResourceRequirements)(nil), "k8s.io.api.core.v1.ResourceRequirements")
	proto.RegisterMapType((map[string]*resource.Quantity)(nil), "k8s.io.api.core.v1.ResourceRequirements.LimitsEntry")
	proto.RegisterMapType((map[string]*resource.Quantity)(nil), "k8s.io.api.core.v1.ResourceRequirements.RequestsEntry")
	proto.RegisterType((*SELinuxOptions)(nil), "k8s.io.api.core.v1.SELinuxOptions")
	proto.RegisterType((*ScaleIOPersistentVolumeSource)(nil), "k8s.io.api.core.v1.ScaleIOPersistentVolumeSource")
	proto.RegisterType((*ScaleIOVolumeSource)(nil), "k8s.io.api.core.v1.ScaleIOVolumeSource")
	proto.RegisterType((*ScopeSelector)(nil), "k8s.io.api.core.v1.ScopeSelector")
	proto.RegisterType((*ScopedResourceSelectorRequirement)(nil), "k8s.io.api.core.v1.ScopedResourceSelectorRequirement")
	proto.RegisterType((*Secret)(nil), "k8s.io.api.core.v1.Secret")
	proto.RegisterMapType((map[string][]byte)(nil), "k8s.io.api.core.v1.Secret.DataEntry")
	proto.RegisterMapType((map[string]string)(nil), "k8s.io.api.core.v1.Secret.StringDataEntry")
	proto.RegisterType((*SecretEnvSource)(nil), "k8s.io.api.core.v1.SecretEnvSource")
	proto.RegisterType((*SecretKeySelector)(nil), "k8s.io.api.core.v1.SecretKeySelector")
	proto.RegisterType((*SecretList)(nil), "k8s.io.api.core.v1.SecretList")
	proto.RegisterType((*SecretProjection)(nil), "k8s.io.api.core.v1.SecretProjection")
	proto.RegisterType((*SecretReference)(nil), "k8s.io.api.core.v1.SecretReference")
	proto.RegisterType((*SecretVolumeSource)(nil), "k8s.io.api.core.v1.SecretVolumeSource")
	proto.RegisterType((*SecurityContext)(nil), "k8s.io.api.core.v1.SecurityContext")
	proto.RegisterType((*SerializedReference)(nil), "k8s.io.api.core.v1.SerializedReference")
	proto.RegisterType((*Service)(nil), "k8s.io.api.core.v1.Service")
	proto.RegisterType((*ServiceAccount)(nil), "k8s.io.api.core.v1.ServiceAccount")
	proto.RegisterType((*ServiceAccountList)(nil), "k8s.io.api.core.v1.ServiceAccountList")
	proto.RegisterType((*ServiceAccountTokenProjection)(nil), "k8s.io.api.core.v1.ServiceAccountTokenProjection")
	proto.RegisterType((*ServiceList)(nil), "k8s.io.api.core.v1.ServiceList")
	proto.RegisterType((*ServicePort)(nil), "k8s.io.api.core.v1.ServicePort")
	proto.RegisterType((*ServiceProxyOptions)(nil), "k8s.io.api.core.v1.ServiceProxyOptions")
	proto.RegisterType((*ServiceSpec)(nil), "k8s.io.api.core.v1.ServiceSpec")
	proto.RegisterMapType((map[string]string)(nil), "k8s.io.api.core.v1.ServiceSpec.SelectorEntry")
	proto.RegisterType((*ServiceStatus)(nil), "k8s.io.api.core.v1.ServiceStatus")
	proto.RegisterType((*SessionAffinityConfig)(nil), "k8s.io.api.core.v1.SessionAffinityConfig")
	proto.RegisterType((*StorageOSPersistentVolumeSource)(nil), "k8s.io.api.core.v1.StorageOSPersistentVolumeSource")
	proto.RegisterType((*StorageOSVolumeSource)(nil), "k8s.io.api.core.v1.StorageOSVolumeSource")
	proto.RegisterType((*Sysctl)(nil), "k8s.io.api.core.v1.Sysctl")
	proto.RegisterType((*TCPSocketAction)(nil), "k8s.io.api.core.v1.TCPSocketAction")
	proto.RegisterType((*Taint)(nil), "k8s.io.api.core.v1.Taint")
	proto.RegisterType((*Toleration)(nil), "k8s.io.api.core.v1.Toleration")
	proto.RegisterType((*TopologySelectorLabelRequirement)(nil), "k8s.io.api.core.v1.TopologySelectorLabelRequirement")
	proto.RegisterType((*TopologySelectorTerm)(nil), "k8s.io.api.core.v1.TopologySelectorTerm")
	proto.RegisterType((*TopologySpreadConstraint)(nil), "k8s.io.api.core.v1.TopologySpreadConstraint")
	proto.RegisterType((*TypedLocalObjectReference)(nil), "k8s.io.api.core.v1.TypedLocalObjectReference")
	proto.RegisterType((*Volume)(nil), "k8s.io.api.core.v1.Volume")
	proto.RegisterType((*VolumeDevice)(nil), "k8s.io.api.core.v1.VolumeDevice")
	proto.RegisterType((*VolumeMount)(nil), "k8s.io.api.core.v1.VolumeMount")
	proto.RegisterType((*VolumeNodeAffinity)(nil), "k8s.io.api.core.v1.VolumeNodeAffinity")
	proto.RegisterType((*VolumeProjection)(nil), "k8s.io.api.core.v1.VolumeProjection")
	proto.RegisterType((*VolumeSource)(nil), "k8s.io.api.core.v1.VolumeSource")
	proto.RegisterType((*VsphereVirtualDiskVolumeSource)(nil), "k8s.io.api.core.v1.VsphereVirtualDiskVolumeSource")
	proto.RegisterType((*WeightedPodAffinityTerm)(nil), "k8s.io.api.core.v1.WeightedPodAffinityTerm")
	proto.RegisterType((*WindowsSecurityContextOptions)(nil), "k8s.io.api.core.v1.WindowsSecurityContextOptions")
}

func init() {
	proto.RegisterFile("k8s.io/api/core/v1/generated.proto", fileDescriptor_6c07b07c062484ab)
}

var fileDescriptor_6c07b07c062484ab = []byte{
	// 10267 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xec, 0x7d, 0x5b, 0x8c, 0x24, 0xd7,
	0x75, 0x18, 0xab, 0x7b, 0x66, 0xba, 0xfb, 0xcc, 0xfb, 0xce, 0xec, 0xb2, 0x77, 0xb8, 0x1c, 0x2e,
	0x4b, 0xeb, 0xe5, 0x9a, 0x22, 0x67, 0xc9, 0xd5, 0x72, 0x45, 0xf1, 0xb1, 0xe4, 0xec, 0xbc, 0x76,
	0xf6, 0xd9, 0xac, 0xd9, 0xe5, 0x52, 0xb6, 0x10, 0xa2, 0xa6, 0xea, 0xce, 0x4c, 0x69, 0xaa, 0xab,
	0x7a, 0xab, 0xaa, 0xe7, 0x21, 0x40, 0x49, 0xe4, 0x24, 0x82, 0x10, 0x07, 0x89, 0x12, 0x48, 0x71,
	0x10, 0x08, 0x06, 0x12, 0x23, 0x8e, 0x9c, 0x00, 0x36, 0x92, 0x48, 0x51, 0x12, 0x5b, 0xca, 0x47,
	0x0c, 0x58, 0x4e, 0x20, 0x44, 0x49, 0x80, 0xc4, 0x81, 0x03, 0x23, 0xa2, 0x3e, 0xec, 0xe4, 0xcb,
	0x0e, 0xec, 0x8f, 0x38, 0x08, 0x60, 0xdc, 0x57, 0xd5, 0xbd, 0xf5, 0xea, 0x9e, 0x99, 0xe6, 0x52,
	0x06, 0xf8, 0xd7, 0x7d, 0xee, 0x3d, 0xa7, 0xee, 0xf3, 0xdc, 0x73, 0xce, 0x3d, 0xe7, 0x5c, 0xd0,
	0x77, 0x5f, 0x0d, 0x17, 0x1c, 0xff, 0x92, 0xd9, 0x71, 0x2e, 0x59, 0x7e, 0x80, 0x2f, 0xed, 0xbd,
	0x7c, 0x69, 0x1b, 0x7b, 0x38, 0x30, 0x23, 0x6c, 0x2f, 0x74, 0x02, 0x3f, 0xf2, 0x11, 0x62, 0x75,
	0x16, 0xcc, 0x8e, 0xb3, 0x40, 0xea, 0x2c, 0xec, 0xbd, 0x3c, 0x77, 0x25, 0xc1, 0x6b, 0x9b, 0xd6,
	0x8e, 0xe3, 0xe1, 0xe0, 0xf0, 0x52, 0x67, 0x77, 0x9b, 0x12, 0x0a, 0x70, 0xe8, 0x77, 0x03, 0x0b,
	0xa7, 0x29, 0x95, 0x62, 0x85, 0x97, 0xda, 0x38, 0x32, 0x73, 0xbe, 0x3f, 0x77, 0xa9, 0x08, 0x2b,
	0xe8, 0x7a, 0x91, 0xd3, 0xce, 0x7e, 0xe6, 0x6a, 0x2f, 0x84, 0xd0, 0xda, 0xc1, 0x6d, 0x33, 0x83,
	0xf7, 0xa9, 0x22, 0xbc, 0x6e, 0xe4, 0xb8, 0x97, 0x1c, 0x2f, 0x0a, 0xa3, 0x20, 0x8d, 0xa4, 0x7f,
	0x53, 0x83, 0x73, 0x8b, 0x0f, 0x37, 0x56, 0x5c, 0x33, 0x8c, 0x1c, 0xeb, 0xba, 0xeb, 0x5b, 0xbb,
	0x1b, 0x91, 0x1f, 0xe0, 0x77, 0x7d, 0xb7, 0xdb, 0xc6, 0x1b, 0x74, 0x20, 0xd0, 0x39, 0xa8, 0xef,
	0xd1, 0xff, 0xeb, 0xcb, 0x4d, 0xed, 0x9c, 0x76, 0xb1, 0x71, 0x7d, 0xe8, 0xfb, 0xbf, 0xf7, 0xcc,
	0x13, 0x46, 0x0c, 0x45, 0x67, 0x61, 0x64, 0x2b, 0xbc, 0x7f, 0xd8, 0xc1, 0xcd, 0x8a, 0x54, 0xce,
	0x61, 0x48, 0x87, 0x46, 0xc7, 0x0c, 0x22, 0x27, 0x72, 0x7c, 0xaf, 0x59, 0x3d, 0xa7, 0x5d, 0x1c,
	0xe6, 0x15, 0x12, 0x30, 0xf9, 0x46, 0x80, 0x4d, 0xfb, 0x9e, 0xe7, 0x1e, 0x36, 0x87, 0xce, 0x69,
	0x17, 0xeb, 0xe2, 0x1b, 0x02, 0xaa, 0x7f, 0xa0, 0x41, 0x7d, 0x71, 0x6b, 0xcb, 0xf1, 0x9c, 0xe8,
	0x10, 0x2d, 0xc3, 0x98, 0xe7, 0xdb, 0x58, 0xfc, 0xa7, 0xcd, 0x1a, 0xbd, 0x7c, 0x6e, 0x21, 0x3b,
	0xd9, 0x0b, 0x77, 0xa5, 0x7a, 0x86, 0x82, 0x85, 0x16, 0x61, 0xb4, 0xe3, 0xdb, 0x31, 0x91, 0x0a,
	0x25, 0xf2, 0x4c, 0x1e, 0x91, 0x56, 0x52, 0xcd, 0x90, 0x71, 0xd0, 0x1d, 0x98, 0x24, 0x7f, 0xbd,
	0xc8, 0x89, 0xc9, 0x54, 0x29, 0x99, 0x4f, 0x14, 0x91, 0x91, 0xaa, 0x1a, 0x69, 0x5c, 0xbd, 0x05,
	0x13, 0x8b, 0x51, 0x64, 0x5a, 0x3b, 0xd8, 0x66, 0x53, 0x80, 0x9a, 0x30, 0xe4, 0x99, 0x6d, 0xac,
	0x0c, 0x3c, 0x85, 0xa0, 0xf3, 0x00, 0x36, 0xde, 0x73, 0x2c, 0xdc, 0x32, 0xa3, 0x1d, 0x65, 0xe0,
	0x25, 0xb8, 0xfe, 0x3e, 0x34, 0x16, 0xf7, 0x7c, 0xc7, 0x6e, 0xf9, 0x76, 0x88, 0x0c, 0x98, 0xec,
	0x04, 0x78, 0x0b, 0x07, 0x31, 0xa8, 0xa9, 0x9d, 0xab, 0x5e, 0x1c, 0xbd, 0x7c, 0x31, 0xb7, 0xb5,
	0x6a, 0xd5, 0x15, 0x2f, 0x0a, 0x48, 0x93, 0x55, 0xa8, 0xfe, 0xbb, 0x1a, 0x9c, 0x5a, 0xfc, 0x42,
	0x37, 0xc0, 0xcb, 0x4e, 0xb8, 0x9b, 0x5e, 0x37, 0xb6, 0x13, 0xee, 0xde, 0x4d, 0x37, 0x3f, 0x86,
	0xa2, 0x79, 0xa8, 0x91, 0xdf, 0x0f, 0x8c, 0x75, 0xa5, 0xfd, 0x02, 0x88, 0x2e, 0xc0, 0xa8, 0x45,
	0xd7, 0xf2, 0xf6, 0x1d, 0xdf, 0xc6, 0x74, 0x64, 0x45, 0x1d, 0xb9, 0x40, 0x5a, 0x7f, 0x43, 0x39,
	0xeb, 0x4f, 0x5e, 0x5b, 0xc3, 0x79, 0x6b, 0x8b, 0x0c, 0xf2, 0xae, 0xe3, 0xd9, 0xcd, 0x11, 0x79,
	0x90, 0x09, 0x44, 0xff, 0xae, 0x06, 0xcf, 0xd0, 0xde, 0xad, 0x3a, 0x2e, 0x6e, 0xe1, 0x20, 0x74,
	0xc2, 0x08, 0x7b, 0x91, 0xd2, 0xcf, 0xf3, 0x00, 0x21, 0xb6, 0x02, 0x1c, 0x65, 0x7a, 0x2a, 0xc1,
	0xc9, 0x2e, 0x08, 0x77, 0xcc, 0x00, 0xd3, 0x4a, 0x72, 0x6f, 0x13, 0xb0, 0xd2, 0xd2, 0x6a, 0x6e,
	0x4b, 0x17, 0x60, 0x32, 0xa1, 0x19, 0x76, 0x4c, 0x4b, 0xed, 0x72, 0xba, 0x50, 0xff, 0x2b, 0x62,
	0x76, 0x48, 0xfb, 0x3f, 0xaa, 0x56, 0xeb, 0x5f, 0xd3, 0xa0, 0x76, 0xdd, 0xf1, 0x6c, 0xc7, 0xdb,
	0x46, 0xb7, 0xa1, 0x4e, 0x78, 0xa5, 0x6d, 0x46, 0x26, 0xdf, 0xb6, 0x2f, 0x49, 0x8b, 0x2f, 0x66,
	0x5d, 0x0b, 0x9d, 0xdd, 0x6d, 0x02, 0x08, 0x17, 0x48, 0x6d, 0xb2, 0x1c, 0xef, 0x6d, 0x7e, 0x1e,
	0x5b, 0xd1, 0x1d, 0x1c, 0x99, 0x46, 0x4c, 0x01, 0xbd, 0x0e, 0x23, 0x91, 0x19, 0x6c, 0xe3, 0x88,
	0xef, 0xde, 0xdc, 0x6d, 0xc7, 0x30, 0x0d, 0xb2, 0x6e, 0xb1, 0x67, 0x61, 0x83, 0xa3, 0xe8, 0xbf,
	0x3b, 0x0c, 0x67, 0x96, 0x36, 0xd6, 0x0b, 0xa6, 0xf5, 0x2c, 0x8c, 0xd8, 0x81, 0xb3, 0x87, 0x03,
	0x65, 0x70, 0x38, 0x0c, 0x5d, 0x84, 0x31, 0xc6, 0xfe, 0x6e, 0x98, 0x9e, 0xed, 0xaa, 0x63, 0xa3,
	0x94, 0xf4, 0x31, 0xa9, 0xe5, 0xcb, 0xd7, 0x87, 0x29, 0x46, 0x6f, 0x31, 0x8a, 0x02, 0x67, 0xb3,
	0x1b, 0xe1, 0xb0, 0x39, 0x4c, 0x77, 0xed, 0x52, 0x5e, 0x67, 0x0b, 0x3b, 0xb4, 0xf0, 0x6e, 0x8a,
	0x0a, 0xdb, 0xd0, 0x19, 0xe2, 0xc8, 0x82, 0x39, 0xcb, 0xf7, 0xa2, 0xc0, 0x77, 0x5d, 0x1c, 0xb4,
	0xba, 0x9b, 0xae, 0x13, 0xee, 0x6c, 0xd0, 0x25, 0x61, 0xe0, 0x2d, 0xba, 0x47, 0x0a, 0xc6, 0x39,
	0xae, 0xc4, 0xc7, 0xb9, 0x84, 0x0c, 0xda, 0x00, 0x44, 0x78, 0xf1, 0x46, 0x64, 0x6e, 0xe3, 0x84,
	0x78, 0xad, 0x7f, 0xe2, 0x39, 0xe8, 0xe8, 0x21, 0xcc, 0x12, 0x68, 0xa6, 0xcd, 0xf5, 0xfe, 0xc9,
	0xe6, 0x12, 0x40, 0x26, 0x9c, 0x49, 0xfa, 0xb2, 0x72, 0xd0, 0x31, 0x3d, 0x3b, 0xa1, 0xde, 0xe8,
	0x9f, 0x7a, 0x31, 0x95, 0xb9, 0x7b, 0x70, 0x2a, 0x77, 0x82, 0xd0, 0x69, 0xa8, 0xee, 0xe2, 0x43,
	0x65, 0x11, 0x12, 0x00, 0x9a, 0x83, 0xe1, 0x3d, 0xd3, 0xed, 0xaa, 0x4b, 0x8f, 0x81, 0x5e, 0xab,
	0xbc, 0xaa, 0xe9, 0x7f, 0xad, 0x0a, 0x93, 0x4b, 0x1b, 0xeb, 0x47, 0x58, 0xd3, 0xf2, 0x4a, 0xad,
	0xf4, 0x58, 0xa9, 0xd5, 0x9c, 0x95, 0x8a, 0x73, 0x56, 0xea, 0x10, 0x5d, 0xa9, 0x9f, 0x29, 0x58,
	0xa9, 0xc7, 0x5a, 0x9f, 0x9f, 0x2b, 0x98, 0xe5, 0x61, 0x3a, 0x0f, 0xb9, 0x47, 0xd9, 0x6d, 0xdf,
	0x32, 0xdd, 0x34, 0x1b, 0xc8, 0xa5, 0x32, 0xf8, 0x79, 0xb8, 0x02, 0x63, 0x4b, 0x66, 0xc7, 0xdc,
	0x74, 0x5c, 0x27, 0x72, 0x70, 0x88, 0xa6, 0xa0, 0x6a, 0xda, 0x36, 0x3d, 0x78, 0x1b, 0x06, 0xf9,
	0x89, 0x10, 0x0c, 0xd9, 0x81, 0xdf, 0x69, 0x56, 0x28, 0x88, 0xfe, 0xd6, 0xff, 0xaf, 0x06, 0x67,
	0x97, 0x70, 0x67, 0x67, 0x75, 0xa3, 0x80, 0x3d, 0xcd, 0x41, 0xbd, 0xed, 0x7b, 0x4e, 0xe4, 0x07,
	0x21, 0xa7, 0x15, 0xff, 0x27, 0xe7, 0x59, 0x27, 0x2d, 0x14, 0x50, 0x08, 0x29, 0xe9, 0x86, 0x38,
	0x50, 0xa6, 0x8f, 0x42, 0x92, 0xf3, 0x80, 0x9c, 0x14, 0x0a, 0x23, 0x92, 0xe0, 0x68, 0x11, 0x1a,
	0x61, 0x6a, 0xc0, 0xfb, 0x5a, 0xf8, 0x09, 0x96, 0xb2, 0xca, 0x46, 0x72, 0x8f, 0x8b, 0x3f, 0xd6,
	0x00, 0xb1, 0xbe, 0xff, 0x04, 0xf4, 0x78, 0x35, 0xdb, 0xe3, 0xfe, 0x97, 0xd8, 0x91, 0xba, 0xfd,
	0xef, 0xc8, 0x94, 0x3b, 0x9e, 0x8d, 0x83, 0x82, 0x29, 0x3f, 0xa9, 0x20, 0xde, 0xfb, 0x24, 0x52,
	0xa6, 0x77, 0xe8, 0x38, 0xd3, 0xab, 0x7f, 0x8f, 0x4c, 0x1e, 0xed, 0xc5, 0x63, 0x6e, 0xfb, 0x6a,
	0xb6, 0xed, 0xc7, 0x99, 0x28, 0xfd, 0x1a, 0x4c, 0x2c, 0xb9, 0x0e, 0xf6, 0xa2, 0xf5, 0xd6, 0x92,
	0xef, 0x6d, 0x39, 0xdb, 0xe8, 0x05, 0x98, 0x20, 0x9a, 0x97, 0xdf, 0x8d, 0x36, 0xb0, 0xe5, 0x7b,
	0x54, 0x6a, 0x4e, 0xb4, 0x98, 0x54, 0x99, 0xfe, 0x15, 0x32, 0x00, 0x7e, 0xbb, 0xe3, 0x7b, 0xd8,
	0x8b, 0x96, 0x7c, 0xcf, 0x66, 0x1a, 0x4e, 0x13, 0x86, 0x22, 0xd2, 0x39, 0x45, 0x90, 0x27, 0x10,
	0xd2, 0xf1, 0x30, 0x32, 0xa3, 0x6e, 0xa8, 0x76, 0x9c, 0xc1, 0x88, 0x8c, 0xdc, 0xc6, 0x61, 0x68,
	0x6e, 0xab, 0x3c, 0x57, 0x00, 0x09, 0xfb, 0xc1, 0x41, 0xe0, 0x07, 0xca, 0x02, 0x66, 0x20, 0xfd,
	0x1f, 0x6b, 0x30, 0x19, 0x37, 0x65, 0x83, 0xd1, 0x1b, 0xac, 0xfc, 0xb5, 0x0a, 0x60, 0x89, 0x2e,
	0x86, 0x94, 0x81, 0x8d, 0x5e, 0xbe, 0x90, 0xcb, 0xec, 0x33, 0x23, 0x62, 0x48, 0x98, 0xfa, 0x37,
	0x34, 0x98, 0x49, 0xb5, 0xf4, 0xb6, 0x13, 0x46, 0xe8, 0x66, 0xa6, 0xb5, 0x0b, 0xfd, 0xb5, 0x96,
	0x60, 0xa7, 0xda, 0xfa, 0x19, 0x18, 0x76, 0x22, 0xdc, 0x16, 0xcd, 0xfc, 0x44, 0x69, 0x33, 0x59,
	0x1b, 0x0c, 0x86, 0xa1, 0xff, 0x49, 0x05, 0x1a, 0x6c, 0x31, 0xdc, 0x31, 0x3b, 0x03, 0x17, 0x61,
	0x87, 0x28, 0x25, 0xd6, 0xaa, 0xe7, 0xf2, 0x5b, 0xc5, 0x3f, 0xbd, 0xb0, 0x6c, 0x46, 0x26, 0x3b,
	0x17, 0x29, 0x12, 0xba, 0x03, 0xb0, 0xe9, 0x78, 0x66, 0x70, 0x48, 0x0a, 0x9a, 0x55, 0x4a, 0xe2,
	0xc5, 0x72, 0x12, 0xd7, 0xe3, 0xfa, 0x8c, 0x90, 0x44, 0x60, 0x6e, 0x09, 0x1a, 0x71, 0xc1, 0x71,
	0x0f, 0xbc, 0xb9, 0x75, 0x98, 0x4c, 0x7d, 0xa3, 0x3f, 0x52, 0x63, 0xd9, 0xb3, 0xf3, 0x6b, 0x74,
	0x2f, 0xf1, 0x96, 0xaf, 0x78, 0x7b, 0x9c, 0x99, 0x7c, 0x0e, 0x66, 0xdd, 0x9c, 0x5d, 0xcc, 0x27,
	0xe3, 0x08, 0x12, 0x40, 0x1e, 0x15, 0xc2, 0x6a, 0xfc, 0x0e, 0x59, 0x96, 0xa6, 0xab, 0x8a, 0x41,
	0x02, 0xaa, 0xff, 0xaa, 0x06, 0xb3, 0x71, 0xb3, 0x6e, 0xe1, 0xc3, 0x0d, 0xec, 0x62, 0x2b, 0xf2,
	0x83, 0x0f, 0xb9, 0x61, 0x7c, 0x14, 0x2b, 0xe9, 0x51, 0x94, 0x1b, 0x5c, 0xcd, 0x6d, 0xf0, 0x57,
	0x35, 0x18, 0x8f, 0x1b, 0x3c, 0xf0, 0x8d, 0xf5, 0x29, 0x75, 0x63, 0x3d, 0x5d, 0xba, 0xfe, 0xc4,
	0x96, 0xfa, 0x2f, 0x1a, 0x9c, 0x89, 0x81, 0x77, 0x7d, 0x1b, 0xb3, 0x3f, 0x7c, 0x86, 0x75, 0x68,
	0x78, 0xb1, 0x86, 0x2b, 0x2f, 0x9b, 0x04, 0x1c, 0x9b, 0x46, 0x2a, 0x19, 0xd3, 0xc8, 0x69, 0xa8,
	0x76, 0x1d, 0x5b, 0xe1, 0x97, 0x04, 0x40, 0xb4, 0x67, 0x61, 0xde, 0x7b, 0x97, 0x1c, 0xb1, 0xbe,
	0xa7, 0x6a, 0xcf, 0xa9, 0x42, 0xf4, 0x12, 0x4c, 0xed, 0x76, 0x37, 0xb1, 0x8b, 0x23, 0xd6, 0xb8,
	0x5b, 0x98, 0x59, 0x10, 0x04, 0x42, 0xa6, 0x54, 0xff, 0xf7, 0x94, 0x8f, 0xf1, 0x5e, 0xb5, 0x02,
	0x9f, 0x4c, 0x20, 0xa1, 0xf4, 0xe1, 0x2e, 0x8c, 0x7e, 0x26, 0xe0, 0x16, 0x3e, 0xbc, 0xef, 0xb7,
	0xcc, 0x68, 0x87, 0x4f, 0x80, 0xb2, 0x6a, 0x86, 0x72, 0x57, 0xcd, 0x1f, 0x6b, 0x70, 0x2a, 0xee,
	0x8c, 0x72, 0x9a, 0xff, 0x04, 0x76, 0xe7, 0x02, 0x8c, 0xda, 0x78, 0xcb, 0xec, 0xba, 0x51, 0x6c,
	0x2b, 0x12, 0x27, 0xb4, 0x5c, 0xd0, 0x47, 0xb7, 0x7f, 0xb9, 0x4e, 0x99, 0x7d, 0x64, 0x92, 0x1d,
	0x50, 0x62, 0x80, 0x9b, 0x83, 0x61, 0xa7, 0x4d, 0xce, 0x65, 0x85, 0x0f, 0x52, 0x10, 0x6a, 0x42,
	0xcd, 0xf2, 0xdb, 0x6d, 0xd3, 0xb3, 0x29, 0x53, 0x6e, 0x18, 0xe2, 0x2f, 0x11, 0xf6, 0xcd, 0x60,
	0x9b, 0x29, 0x46, 0x0d, 0x83, 0xfe, 0x26, 0x92, 0xe8, 0xbe, 0x1f, 0xec, 0x3a, 0xde, 0xf6, 0xb2,
	0x13, 0x28, 0x2b, 0x4c, 0x82, 0xa3, 0x4f, 0xc3, 0x70, 0xc7, 0x0f, 0xa2, 0xb0, 0x39, 0x42, 0x87,
	0xe5, 0xd9, 0x82, 0x6d, 0xc6, 0xda, 0xdd, 0xf2, 0x83, 0xc8, 0x60, 0xf5, 0xd1, 0xeb, 0x50, 0xc3,
	0xde, 0xde, 0x6a, 0xe0, 0xb7, 0x9b, 0x33, 0xc5, 0xa8, 0x2b, 0xac, 0x0a, 0x9b, 0x61, 0x43, 0x60,
	0xa0, 0x17, 0xa0, 0x8a, 0xbd, 0xbd, 0x66, 0x8d, 0x22, 0xce, 0x15, 0x20, 0xbe, 0x6b, 0x06, 0x06,
	0xa9, 0x46, 0x84, 0x30, 0xb1, 0x89, 0x42, 0xae, 0x76, 0xe7, 0xae, 0x06, 0x83, 0x57, 0x32, 0xf0,
	0xa3, 0xae, 0x13, 0xe0, 0x36, 0xf6, 0xa2, 0xd0, 0x48, 0x50, 0xd1, 0x92, 0x30, 0xaf, 0xdc, 0xf1,
	0xbb, 0x5e, 0x14, 0x36, 0x1b, 0xf4, 0xf3, 0xb9, 0xb6, 0xd9, 0x77, 0x93, 0x7a, 0x86, 0x82, 0x84,
	0x56, 0x61, 0x9c, 0xfd, 0x5f, 0xa6, 0xf6, 0xd0, 0xb0, 0x79, 0x8a, 0x52, 0x39, 0x57, 0x4c, 0x85,
	0x55, 0x34, 0x54, 0x34, 0xf4, 0x16, 0x8c, 0xbb, 0xce, 0x1e, 0xf6, 0x70, 0x18, 0xb6, 0x02, 0x7f,
	0x13, 0x37, 0x81, 0x76, 0xec, 0x4c, 0xbe, 0xd1, 0xd4, 0xdf, 0xc4, 0x86, 0x5a, 0x1f, 0x2d, 0xc2,
	0x04, 0x11, 0x53, 0x9d, 0x84, 0xc2, 0x68, 0x2f, 0x0a, 0x29, 0x04, 0xf4, 0x3a, 0x34, 0x5c, 0x67,
	0x0b, 0x5b, 0x87, 0x96, 0x8b, 0x9b, 0x63, 0x14, 0x3b, 0x77, 0x5f, 0xdc, 0x16, 0x95, 0x8c, 0xa4,
	0x3e, 0x7a, 0x03, 0x4e, 0x47, 0x38, 0x68, 0x3b, 0x9e, 0x49, 0x96, 0xf8, 0x1d, 0x26, 0x39, 0x52,
	0xb3, 0xf1, 0xb8, 0xb4, 0xd6, 0x0a, 0xea, 0xa0, 0xb7, 0xa1, 0x99, 0x53, 0xe2, 0xbb, 0x8e, 0x75,
	0xd8, 0x9c, 0x95, 0xf0, 0x0b, 0x6b, 0x11, 0xbe, 0x4b, 0xb7, 0x45, 0xab, 0xeb, 0xba, 0x1c, 0x71,
	0x42, 0xe6, 0xbb, 0xa9, 0x42, 0x74, 0x87, 0x5a, 0x39, 0xbb, 0x81, 0x13, 0x1d, 0x92, 0x05, 0x8d,
	0x0f, 0xa2, 0xe6, 0x64, 0xa9, 0x32, 0x22, 0x57, 0x35, 0xd2, 0xb8, 0x64, 0xa3, 0x86, 0x91, 0xed,
	0x78, 0xcd, 0x29, 0x69, 0xbf, 0x33, 0x10, 0x35, 0x70, 0x92, 0x1f, 0xf7, 0x08, 0xfb, 0x9a, 0x96,
	0xca, 0x13, 0x30, 0x39, 0x4e, 0xa2, 0xe8, 0xb0, 0x89, 0xa4, 0x52, 0x02, 0xd0, 0x6f, 0xc2, 0x44,
	0xbc, 0xdf, 0xd6, 0xe9, 0xb6, 0x9f, 0x85, 0x61, 0x7a, 0x3e, 0x71, 0xfd, 0x94, 0xfd, 0xa1, 0xdf,
	0x70, 0xbe, 0x80, 0xaf, 0x1f, 0x46, 0x98, 0xc9, 0xf8, 0xd5, 0xf8, 0x1b, 0x02, 0xac, 0x7f, 0x87,
	0x9d, 0xd0, 0xc9, 0xe6, 0x2d, 0x61, 0x3c, 0xe7, 0xa0, 0xbe, 0xe3, 0x87, 0x11, 0xa9, 0x45, 0xc9,
	0x09, 0x3e, 0x17, 0x43, 0xd1, 0xf3, 0x30, 0x6e, 0xc9, 0xc4, 0x14, 0x76, 0xa8, 0x16, 0x11, 0x6a,
	0xf4, 0x32, 0xc8, 0xf2, 0x5d, 0xe5, 0x34, 0x8c, 0xa1, 0x44, 0x41, 0x21, 0x94, 0xd7, 0x5b, 0x0a,
	0x6b, 0xe2, 0x30, 0xfd, 0x0f, 0x34, 0x69, 0x18, 0x88, 0xd8, 0x8c, 0xd1, 0x12, 0xd4, 0xf6, 0x4d,
	0x27, 0x72, 0xbc, 0x6d, 0x7e, 0x22, 0xfc, 0x74, 0x29, 0xaf, 0xa2, 0x48, 0x0f, 0x19, 0x82, 0x21,
	0x30, 0x09, 0x91, 0xa0, 0xeb, 0x79, 0x84, 0x48, 0xa5, 0x5f, 0x22, 0x06, 0x43, 0x30, 0x04, 0x26,
	0xba, 0x0d, 0x20, 0x56, 0x25, 0xb6, 0xf9, 0xd5, 0xcc, 0x0b, 0xbd, 0xe9, 0xdc, 0x8f, 0x71, 0x0c,
	0x09, 0x5f, 0x37, 0xe9, 0x79, 0x98, 0xfd, 0x1e, 0xba, 0x41, 0x56, 0x91, 0x19, 0x44, 0xd8, 0x5e,
	0x8c, 0x78, 0x97, 0x9f, 0xef, 0x4f, 0x9c, 0xba, 0xef, 0xb4, 0x89, 0xf6, 0x29, 0x90, 0xf5, 0xff,
	0x5a, 0x81, 0x66, 0x51, 0x5b, 0xc8, 0x54, 0xe1, 0x03, 0x27, 0x5a, 0x22, 0x07, 0x9c, 0xac, 0x82,
	0xc6, 0x50, 0xaa, 0x4b, 0x3a, 0xdb, 0x42, 0x72, 0x1d, 0x8e, 0x75, 0x49, 0x0a, 0x23, 0xa5, 0x01,
	0x36, 0x43, 0x7e, 0x0d, 0x17, 0x4f, 0x24, 0x83, 0xc9, 0x9a, 0xe6, 0x50, 0x9e, 0xa6, 0xa9, 0x74,
	0x72, 0xf8, 0x04, 0x9d, 0x44, 0x37, 0x01, 0xb6, 0x1c, 0xcf, 0x09, 0x77, 0x28, 0xa9, 0x91, 0x23,
	0x93, 0x92, 0xb0, 0xe9, 0x1d, 0x51, 0xbc, 0x09, 0x97, 0xa9, 0x05, 0x39, 0xb9, 0x23, 0x4a, 0x0a,
	0xf4, 0x07, 0xe9, 0xb9, 0xe3, 0x0b, 0x4e, 0x1a, 0x14, 0xad, 0x7c, 0x50, 0x2a, 0x39, 0x83, 0xa2,
	0xff, 0xa7, 0x0a, 0x51, 0xb1, 0x25, 0xba, 0xdd, 0xb0, 0x64, 0xe7, 0xbe, 0x4a, 0x38, 0x91, 0x19,
	0x61, 0xbe, 0xa2, 0xf5, 0x3e, 0x56, 0x34, 0x43, 0x40, 0x6f, 0x43, 0xc3, 0x35, 0x43, 0xaa, 0x96,
	0x62, 0xbe, 0x8e, 0xfb, 0xc1, 0x4e, 0x90, 0x08, 0x17, 0x24, 0x67, 0x8a, 0x7a, 0xbf, 0xca, 0x40,
	0xe8, 0x22, 0x8c, 0x05, 0x98, 0xce, 0xcf, 0x12, 0x39, 0x3a, 0xe9, 0xec, 0x8a, 0xc5, 0xa3, 0x94,
	0x24, 0x42, 0xcf, 0x48, 0x56, 0xe8, 0x99, 0x87, 0x1a, 0xfd, 0x91, 0x9a, 0x06, 0x01, 0x4c, 0x4f,
	0x55, 0xbd, 0x68, 0xaa, 0x9e, 0x87, 0x89, 0x65, 0x13, 0xb7, 0x7d, 0x6f, 0xc5, 0xb3, 0x3b, 0xbe,
	0xe3, 0x51, 0x5e, 0x48, 0xd9, 0x98, 0xbc, 0xe8, 0x29, 0x44, 0x7f, 0x0f, 0x4e, 0x2d, 0xfb, 0xfb,
	0xde, 0xbe, 0x19, 0xd8, 0x8b, 0xad, 0x75, 0x49, 0xe2, 0x7e, 0x4b, 0x08, 0x91, 0xec, 0x86, 0x33,
	0x97, 0x79, 0x48, 0x98, 0xec, 0xfc, 0x5f, 0x75, 0x5c, 0x2c, 0x14, 0x94, 0xdf, 0xd7, 0x14, 0xd2,
	0x49, 0x85, 0xd8, 0xd8, 0xa8, 0x65, 0x8c, 0x8d, 0x4b, 0x50, 0xdf, 0x72, 0xb0, 0x6b, 0x1b, 0x78,
	0x8b, 0x4f, 0xf1, 0x73, 0xc5, 0x17, 0x52, 0xab, 0xa4, 0xa6, 0x50, 0x1d, 0x8d, 0x18, 0x11, 0x3d,
	0x80, 0x29, 0x21, 0x08, 0xad, 0x0a, 0x62, 0xd5, 0x62, 0x0e, 0x68, 0xc8, 0x75, 0x63, 0x72, 0x19,
	0x12, 0xa4, 0xd5, 0x6d, 0xc2, 0x38, 0x86, 0xe4, 0x31, 0x24, 0x10, 0xfd, 0xe7, 0x34, 0x78, 0x32,
	0xd3, 0x53, 0x2e, 0xe9, 0x9f, 0x74, 0x18, 0xd3, 0x72, 0x79, 0xa5, 0x40, 0x2e, 0x27, 0x8d, 0x98,
	0x5d, 0x69, 0x77, 0xa2, 0xc3, 0x65, 0x27, 0x48, 0xdf, 0x59, 0xb4, 0xb1, 0xed, 0x74, 0xdb, 0xea,
	0xfe, 0x64, 0x30, 0x74, 0x9b, 0x9d, 0xad, 0xb7, 0x9d, 0xb6, 0x23, 0xee, 0x00, 0x4b, 0x15, 0xd9,
	0x05, 0x31, 0x2e, 0x0b, 0xef, 0x74, 0x4d, 0x2f, 0x72, 0xa2, 0x43, 0x23, 0x21, 0x40, 0x14, 0xfb,
	0x49, 0xb1, 0xe8, 0x16, 0x6d, 0x3b, 0xc0, 0x61, 0x88, 0x66, 0xa1, 0xe2, 0x74, 0x94, 0x6f, 0x57,
	0x9c, 0x8e, 0x38, 0x83, 0xe9, 0x3e, 0x97, 0x99, 0x69, 0x0c, 0x25, 0x35, 0x3c, 0xdf, 0x66, 0x37,
	0xa7, 0xca, 0xb9, 0x2a, 0xa0, 0x68, 0x11, 0x1a, 0xec, 0x26, 0x32, 0x59, 0x2e, 0x7d, 0xdd, 0x5f,
	0x26, 0x58, 0xba, 0x0d, 0x63, 0xa2, 0xbd, 0x3d, 0x84, 0x06, 0xb2, 0x68, 0xd3, 0x02, 0x03, 0x85,
	0x28, 0x02, 0x40, 0x35, 0x4f, 0x00, 0xd0, 0x7f, 0x4f, 0x83, 0x09, 0xf1, 0x99, 0x8d, 0xee, 0x66,
	0x88, 0x23, 0xd2, 0x76, 0x93, 0x0d, 0x10, 0x16, 0x6b, 0xe3, 0x13, 0xf9, 0xca, 0x81, 0x32, 0x9a,
	0x46, 0x82, 0x85, 0xde, 0x81, 0x69, 0xcf, 0x8f, 0x0c, 0xc2, 0x80, 0x16, 0x63, 0x52, 0x95, 0xfe,
	0x49, 0x65, 0xb1, 0xd1, 0x55, 0xa1, 0x22, 0x55, 0x8b, 0x25, 0x7d, 0x79, 0xbc, 0xb8, 0x86, 0xa4,
	0xff, 0x82, 0x06, 0x0d, 0x01, 0x1f, 0xb4, 0x89, 0xf4, 0x0d, 0xa8, 0x85, 0x74, 0xcc, 0x44, 0xe7,
	0xf4, 0xb2, 0x56, 0xb1, 0xe1, 0x35, 0x04, 0x0a, 0xb5, 0xdc, 0xc4, 0x2d, 0xfb, 0x48, 0x2c, 0x37,
	0xf1, 0xd7, 0x05, 0x63, 0xfc, 0x0d, 0xda, 0x24, 0x49, 0x59, 0x24, 0x5b, 0xb4, 0x13, 0xe0, 0x2d,
	0xe7, 0x40, 0xdd, 0xa2, 0x0c, 0x86, 0x6e, 0xc2, 0x98, 0x15, 0x5b, 0x7f, 0xe2, 0x95, 0x7e, 0xa1,
	0xd4, 0x4a, 0x14, 0xdb, 0xfa, 0x0c, 0x05, 0x57, 0xbd, 0xa0, 0xa8, 0xf6, 0xba, 0xa0, 0x48, 0xa8,
	0x48, 0xf6, 0xfd, 0xbf, 0x08, 0x23, 0x4c, 0x63, 0x2d, 0x57, 0xed, 0x8b, 0x4c, 0x9c, 0xe8, 0x1a,
	0x34, 0xe8, 0x0f, 0xaa, 0x4f, 0x57, 0x8b, 0x1d, 0x8f, 0xd8, 0x47, 0xc4, 0xf7, 0x63, 0x14, 0xfd,
	0xb7, 0x2b, 0x64, 0xcf, 0x26, 0x65, 0xca, 0xa1, 0xa1, 0x0d, 0xf2, 0xd0, 0xa8, 0x9c, 0xfc, 0xd0,
	0x30, 0x60, 0xd2, 0x92, 0x0c, 0x9d, 0xc9, 0xa8, 0x5f, 0x2c, 0x9d, 0x3e, 0xc9, 0x26, 0x6a, 0xa4,
	0x09, 0xa0, 0x75, 0x18, 0x63, 0xb3, 0xc1, 0x09, 0xb2, 0xbb, 0x9a, 0x9f, 0x2a, 0x9e, 0x46, 0x99,
	0x9a, 0x82, 0xaa, 0xff, 0x4b, 0x0d, 0xd0, 0x4a, 0x67, 0x07, 0xb7, 0x71, 0x60, 0xba, 0x89, 0xcd,
	0x66, 0x07, 0x9a, 0x38, 0x03, 0x5d, 0xf2, 0xdb, 0x6d, 0x2e, 0xe4, 0x15, 0xe8, 0x00, 0x2b, 0x05,
	0x38, 0x46, 0x21, 0x35, 0x74, 0x15, 0x66, 0x18, 0x33, 0x8e, 0x0b, 0x32, 0x9e, 0x32, 0x79, 0x15,
	0xf4, 0x6f, 0xd7, 0xa1, 0x59, 0xf4, 0xb9, 0x8f, 0x4d, 0x4e, 0x1f, 0x9b, 0x9c, 0x3e, 0x36, 0x39,
	0x7d, 0x6c, 0x72, 0xca, 0x33, 0x39, 0x7d, 0x57, 0x83, 0x99, 0x2c, 0xdf, 0x18, 0xb4, 0xc8, 0xf2,
	0x1e, 0xcc, 0x64, 0x39, 0x5e, 0xe9, 0xf5, 0x6e, 0xb6, 0x4d, 0x46, 0x1e, 0x09, 0xfd, 0x37, 0x47,
	0x60, 0x78, 0x65, 0x0f, 0x7b, 0xd1, 0x80, 0x5b, 0x7c, 0x0b, 0x26, 0x1c, 0x6f, 0xcf, 0x77, 0xf7,
	0xb0, 0xcd, 0xca, 0x8f, 0x22, 0x4f, 0xa7, 0x50, 0x4f, 0x68, 0x26, 0xf9, 0x34, 0x8c, 0x30, 0x96,
	0xc2, 0x6d, 0x24, 0xb9, 0x1c, 0x84, 0x8e, 0x01, 0xe7, 0x7b, 0xbc, 0x3a, 0x32, 0x60, 0x62, 0xcb,
	0x09, 0xc2, 0xe8, 0xbe, 0xd3, 0x26, 0x1a, 0x77, 0xbb, 0x73, 0x0c, 0xcb, 0x48, 0x8a, 0x02, 0x6a,
	0xc1, 0xb8, 0x6b, 0xca, 0x24, 0x6b, 0x47, 0x26, 0xa9, 0x12, 0x20, 0x2b, 0xdb, 0xa2, 0x36, 0x82,
	0xba, 0xa4, 0x48, 0x30, 0x50, 0xec, 0xe3, 0xd0, 0xc8, 0xf8, 0x38, 0xdc, 0x81, 0x06, 0x26, 0x5d,
	0x26, 0x74, 0x38, 0x2f, 0xbb, 0xd4, 0x5f, 0x1b, 0xee, 0x38, 0x56, 0xe0, 0x33, 0x03, 0x52, 0x4c,
	0x81, 0x8e, 0x31, 0x0e, 0x1c, 0x1c, 0x72, 0xae, 0x56, 0x32, 0xc6, 0xb4, 0x9a, 0xc1, 0xab, 0x93,
	0xa9, 0x35, 0xa9, 0x7d, 0x80, 0x32, 0xb4, 0x78, 0x6a, 0x19, 0x0c, 0xbd, 0x09, 0xb5, 0x00, 0xbb,
	0xd4, 0x54, 0x38, 0xde, 0xff, 0xf2, 0x11, 0x38, 0xe8, 0x0a, 0xa0, 0x00, 0x93, 0xf3, 0xcf, 0xf1,
	0xb6, 0x63, 0x47, 0x02, 0x85, 0xed, 0xe4, 0x94, 0xa3, 0xcb, 0x30, 0x1d, 0x43, 0xd7, 0xbd, 0x30,
	0x32, 0x09, 0x5b, 0x98, 0x94, 0x90, 0xb2, 0xc5, 0xfa, 0x57, 0x88, 0xbe, 0x42, 0xba, 0x37, 0x70,
	0x8d, 0xe0, 0x92, 0xaa, 0x11, 0x9c, 0x29, 0x1c, 0x58, 0xa1, 0x0d, 0xfc, 0x43, 0x0d, 0x46, 0xa5,
	0x91, 0x4e, 0xd6, 0x87, 0x96, 0x5d, 0x1f, 0x3f, 0x0b, 0x53, 0x64, 0x31, 0xdd, 0xdb, 0x0c, 0x71,
	0xb0, 0x87, 0x6d, 0xba, 0x18, 0x2a, 0xc7, 0x5b, 0x0c, 0x19, 0x42, 0x8c, 0xe5, 0x0a, 0xeb, 0x58,
	0x23, 0x61, 0xb9, 0x66, 0x84, 0xf5, 0x5b, 0xa2, 0x8d, 0xf1, 0xed, 0xb2, 0x15, 0xcf, 0x8f, 0x72,
	0xbb, 0x1c, 0x83, 0xc9, 0x5a, 0x26, 0xaa, 0xbc, 0x7a, 0xbb, 0x4c, 0x20, 0xfa, 0x05, 0x80, 0x95,
	0x03, 0x6c, 0x2d, 0x5a, 0xdc, 0xaf, 0x27, 0x16, 0xbb, 0x34, 0x45, 0xec, 0xd2, 0x7f, 0x51, 0x83,
	0x89, 0xd5, 0x25, 0xc5, 0x96, 0x31, 0x0f, 0xc0, 0xa4, 0xc1, 0x87, 0x0f, 0xef, 0x8a, 0x4b, 0x02,
	0x09, 0x42, 0xd8, 0xbe, 0xdb, 0xf5, 0x14, 0x1d, 0x9d, 0x00, 0x7a, 0xf8, 0x5d, 0xf6, 0x0c, 0x9e,
	0x40, 0xb3, 0x30, 0xbc, 0xbf, 0xef, 0xd8, 0xcc, 0x71, 0xb8, 0x61, 0xb0, 0x3f, 0xfa, 0xff, 0xa8,
	0xc0, 0xdc, 0xaa, 0x8b, 0x0f, 0x8e, 0xe5, 0x00, 0x5d, 0xee, 0xae, 0x75, 0x34, 0x3d, 0xad, 0xa7,
	0xc3, 0x5c, 0x7e, 0xaf, 0x1e, 0x40, 0x8d, 0x5d, 0xda, 0x0a, 0x87, 0xe8, 0xd7, 0xf3, 0x3e, 0x51,
	0xdc, 0xc3, 0x85, 0x7b, 0x0c, 0x9b, 0xf9, 0xc1, 0x08, 0x5a, 0x73, 0xab, 0x30, 0x26, 0x17, 0x1c,
	0xdb, 0xf1, 0xf3, 0x07, 0x15, 0x98, 0x22, 0x1f, 0x1f, 0xd8, 0xa0, 0xae, 0x66, 0x07, 0xf5, 0xc4,
	0xae, 0x88, 0xf9, 0x23, 0x7b, 0x2b, 0x3d, 0xb2, 0x2f, 0x17, 0x8d, 0xec, 0x63, 0x1c, 0x4f, 0x0c,
	0x33, 0xab, 0xae, 0x6f, 0xed, 0xa6, 0x3c, 0x0b, 0x2f, 0xc0, 0x28, 0xe1, 0x5c, 0x61, 0x4e, 0x24,
	0x83, 0x5c, 0x20, 0xd5, 0x7b, 0xf0, 0x60, 0x7d, 0x59, 0xf9, 0x88, 0x5c, 0xa0, 0xff, 0x03, 0x0d,
	0x9e, 0x5e, 0x5b, 0x5a, 0x49, 0x96, 0x4c, 0x26, 0xb0, 0xe5, 0x2c, 0x8c, 0x74, 0xec, 0xcc, 0xc7,
	0x38, 0xec, 0xb1, 0x04, 0x43, 0x7d, 0x49, 0x83, 0x99, 0x35, 0x27, 0x32, 0x70, 0xc7, 0x4f, 0x07,
	0x75, 0x90, 0xc3, 0x22, 0x74, 0x22, 0x3f, 0x50, 0x47, 0x58, 0x82, 0x33, 0xfa, 0x7b, 0x0e, 0xf5,
	0x7f, 0x91, 0xdb, 0x18, 0x43, 0x49, 0x2b, 0x6d, 0x27, 0xa0, 0x1a, 0xf7, 0xa1, 0xc2, 0x72, 0x12,
	0xb0, 0xfe, 0x1d, 0x0d, 0x9e, 0x59, 0x73, 0xbb, 0x61, 0x84, 0x83, 0xad, 0xb0, 0x80, 0x85, 0xe8,
	0xd0, 0xc0, 0xc2, 0x7c, 0xa4, 0x32, 0xda, 0x18, 0x5c, 0xe2, 0xba, 0xdb, 0xdb, 0xe7, 0xf3, 0x0a,
	0xa0, 0x98, 0x50, 0x7e, 0x44, 0x4c, 0x4e, 0xb9, 0xbe, 0x0f, 0xa7, 0xe2, 0x86, 0x3f, 0xce, 0xe6,
	0xea, 0xff, 0x4b, 0x83, 0xf1, 0x1b, 0xf7, 0xef, 0xb7, 0xd6, 0x70, 0x14, 0x9f, 0x1e, 0x45, 0x57,
	0x09, 0xcb, 0x92, 0xbd, 0xb6, 0x4c, 0x36, 0xee, 0x46, 0x8e, 0xbb, 0xc0, 0xc2, 0xfb, 0x16, 0xd6,
	0xbd, 0xe8, 0x5e, 0xb0, 0x11, 0x05, 0x8e, 0xb7, 0xcd, 0x6d, 0xbb, 0xe2, 0x14, 0xab, 0xa6, 0x4f,
	0x31, 0x7a, 0x53, 0x68, 0x11, 0x01, 0x5d, 0x0d, 0x3a, 0x61, 0x30, 0xf4, 0x36, 0x8c, 0xee, 0x44,
	0x51, 0xe7, 0x06, 0x36, 0x6d, 0x22, 0xf9, 0x33, 0x26, 0x30, 0x9f, 0xc7, 0x04, 0x48, 0x7f, 0x58,
	0x35, 0x43, 0x46, 0xd1, 0xaf, 0x03, 0x24, 0x45, 0xc7, 0x33, 0xb5, 0x11, 0x6d, 0xa7, 0xc6, 0xa2,
	0x68, 0x02, 0x74, 0x19, 0x86, 0xf0, 0x01, 0xb6, 0xb8, 0x80, 0x93, 0xdb, 0x94, 0xe4, 0x54, 0x36,
	0x68, 0x5d, 0xf4, 0x3a, 0xd4, 0x48, 0x93, 0xd6, 0xe2, 0xf0, 0xa0, 0x67, 0x8b, 0x7a, 0x10, 0xcf,
	0x88, 0x21, 0x30, 0xa8, 0x75, 0xde, 0xea, 0x6c, 0x10, 0x86, 0x13, 0x95, 0x1d, 0x61, 0xf7, 0x97,
	0x5a, 0xac, 0x12, 0x27, 0x90, 0x60, 0xe9, 0x6f, 0x41, 0xe3, 0x86, 0x1f, 0x46, 0x8b, 0xae, 0x63,
	0x16, 0xdd, 0x23, 0x9c, 0x85, 0x86, 0xb8, 0x31, 0x08, 0x79, 0x00, 0x40, 0x02, 0xd0, 0x6f, 0xc2,
	0x2c, 0x21, 0x40, 0x74, 0x62, 0x65, 0xa1, 0x16, 0x2f, 0x1b, 0x21, 0x82, 0x57, 0xd2, 0x22, 0xb8,
	0xfe, 0x9f, 0xab, 0xf0, 0xd4, 0xfa, 0x46, 0x71, 0xbc, 0xd3, 0x45, 0x18, 0x63, 0x92, 0x48, 0xcb,
	0x0f, 0x22, 0xd3, 0x55, 0x68, 0x2b, 0x25, 0x84, 0x81, 0x3b, 0x8f, 0x54, 0xd6, 0x41, 0x00, 0x42,
	0x7a, 0xa9, 0xa6, 0xa5, 0x97, 0x17, 0x60, 0xc2, 0x09, 0xad, 0xd0, 0x59, 0xf7, 0xc8, 0x96, 0x4b,
	0xef, 0xd0, 0x54, 0x99, 0xc4, 0x3f, 0x87, 0x7b, 0xc8, 0x3a, 0x23, 0x05, 0xc1, 0x7c, 0xb5, 0x0e,
	0x6d, 0x67, 0x48, 0x2d, 0x48, 0x0d, 0x43, 0xfc, 0x25, 0x92, 0xb6, 0xb5, 0x63, 0x76, 0x16, 0xbb,
	0xd1, 0xce, 0xb2, 0x13, 0x5a, 0xfe, 0x1e, 0x0e, 0x0e, 0xa9, 0x1a, 0x23, 0x88, 0x64, 0x8b, 0xd1,
	0x02, 0x4c, 0x0a, 0xe0, 0x06, 0x0e, 0x29, 0xcb, 0x1c, 0x95, 0x30, 0xd2, 0x85, 0xaa, 0xe0, 0x03,
	0xc7, 0x12, 0x7c, 0x9e, 0x87, 0x71, 0xc7, 0x73, 0x22, 0xc7, 0x8c, 0x7c, 0x66, 0x4d, 0x94, 0x55,
	0x15, 0xb5, 0x48, 0xff, 0x41, 0x15, 0xa6, 0xe9, 0xa4, 0x7e, 0x3c, 0x95, 0x03, 0x9f, 0xca, 0xd5,
	0xec, 0x54, 0x1e, 0x4b, 0xdc, 0x3a, 0xca, 0x7c, 0x3e, 0x84, 0x46, 0xec, 0xd9, 0x58, 0x28, 0x28,
	0x95, 0x06, 0xbb, 0xb4, 0xd3, 0xde, 0x8f, 0xec, 0x8e, 0xf7, 0x8b, 0xd0, 0x88, 0xed, 0x74, 0xe8,
	0x33, 0xd0, 0xe8, 0xf8, 0xd4, 0x2f, 0x20, 0x10, 0xee, 0x2a, 0x4f, 0xe5, 0x72, 0x46, 0xc6, 0x7b,
	0x8d, 0xa4, 0x36, 0x7a, 0x05, 0x6a, 0x9d, 0x00, 0x6f, 0x44, 0x34, 0x5c, 0xa9, 0x27, 0xa2, 0xa8,
	0xab, 0xff, 0x1d, 0x0d, 0x80, 0x5e, 0xb1, 0x1a, 0xa6, 0xb7, 0x8d, 0x07, 0x6c, 0xfc, 0xb9, 0x0a,
	0x43, 0x61, 0x07, 0x5b, 0x65, 0x4e, 0x15, 0xc9, 0xb7, 0x37, 0x3a, 0xd8, 0x32, 0x68, 0x7d, 0xfd,
	0xe7, 0xeb, 0x30, 0x91, 0x14, 0xac, 0x47, 0xb8, 0x5d, 0x12, 0xa5, 0xf1, 0x26, 0x54, 0xdb, 0xe6,
	0x01, 0x57, 0x8b, 0x3f, 0x59, 0xfe, 0x0d, 0x42, 0x6a, 0xe1, 0x8e, 0x79, 0xc0, 0x04, 0x61, 0x82,
	0x47, 0xd1, 0x1d, 0x8f, 0xdf, 0x4b, 0xf6, 0x85, 0xee, 0x78, 0x02, 0xdd, 0xf1, 0xd0, 0x3a, 0xd4,
	0xf8, 0x65, 0x39, 0x8f, 0xa8, 0xbb, 0xd4, 0x07, 0x89, 0x65, 0x86, 0xc1, 0xc5, 0x71, 0x8e, 0x8f,
	0xfe, 0x02, 0x4c, 0xf0, 0x9f, 0x06, 0x7e, 0xd4, 0xc5, 0x61, 0xc4, 0x4f, 0xf7, 0xab, 0xfd, 0x53,
	0xe4, 0x88, 0x8c, 0x70, 0x8a, 0x1a, 0xea, 0xc0, 0x6c, 0xdb, 0x3c, 0x60, 0x88, 0x0c, 0x64, 0x98,
	0x91, 0xe3, 0xf3, 0x2b, 0x84, 0x37, 0xfa, 0x1b, 0xb9, 0x0c, 0x3a, 0xfb, 0x56, 0x2e, 0xe5, 0x39,
	0x17, 0xea, 0x62, 0xb0, 0x0b, 0xf7, 0xcc, 0xb2, 0x2c, 0x66, 0x1c, 0xdd, 0x47, 0x40, 0x0a, 0x6f,
	0x20, 0x5f, 0xe3, 0x73, 0xf3, 0x18, 0xbe, 0xd6, 0x81, 0x31, 0x79, 0x1a, 0x1f, 0xc3, 0x17, 0xf7,
	0x61, 0x26, 0x67, 0x9a, 0x1f, 0xc3, 0x87, 0xbf, 0x08, 0x67, 0x0a, 0x67, 0xfe, 0xc3, 0xff, 0x3c,
	0x61, 0x51, 0x12, 0x37, 0x18, 0xb8, 0x61, 0xed, 0x8a, 0x6a, 0x58, 0x9b, 0x2f, 0xdf, 0x07, 0xc2,
	0xba, 0x76, 0x5b, 0x6e, 0x13, 0x61, 0x5d, 0xe8, 0x35, 0x18, 0x71, 0x09, 0x44, 0x78, 0x5d, 0xe8,
	0xbd, 0x37, 0x94, 0xc1, 0x31, 0xf4, 0x5f, 0xd0, 0x60, 0x68, 0xe0, 0x1d, 0x5b, 0x52, 0x3b, 0xf6,
	0x62, 0x21, 0x21, 0x9e, 0xc0, 0x64, 0xc1, 0x30, 0xf7, 0x57, 0x0e, 0x22, 0xec, 0x91, 0x43, 0x56,
	0xf4, 0xf3, 0x0e, 0xcc, 0xdc, 0xf6, 0x4d, 0xfb, 0xba, 0xe9, 0x9a, 0x9e, 0x85, 0x83, 0x75, 0x6f,
	0xbb, 0x4f, 0xdf, 0x9b, 0x4a, 0x9e, 0xef, 0x8d, 0xfe, 0x10, 0x90, 0x4c, 0x8e, 0xfb, 0xe5, 0x2d,
	0x42, 0xcd, 0x61, 0x84, 0xf9, 0xd8, 0x3d, 0x97, 0x7f, 0x9c, 0x67, 0xda, 0x61, 0x08, 0x3c, 0xfd,
	0x25, 0x98, 0xcd, 0x3b, 0xee, 0x8b, 0xf5, 0x1b, 0xfd, 0x16, 0x4c, 0x53, 0x8c, 0x3e, 0xe5, 0xf7,
	0x52, 0xeb, 0x81, 0xbe, 0x0b, 0x93, 0x77, 0x53, 0x51, 0xb1, 0x67, 0xa9, 0x29, 0x3c, 0x63, 0x50,
	0x62, 0xb0, 0x13, 0x69, 0xab, 0x3f, 0xd0, 0xa0, 0x11, 0x2b, 0xcd, 0x03, 0x3e, 0xb2, 0x5f, 0x51,
	0x8e, 0xec, 0x5c, 0xb5, 0x2c, 0xfe, 0x74, 0x72, 0x62, 0xa3, 0xd7, 0xe3, 0x50, 0xc9, 0x12, 0x85,
	0x2c, 0x41, 0x64, 0x31, 0x7c, 0x1c, 0x85, 0xba, 0xd2, 0xc4, 0x65, 0x1f, 0x89, 0x2b, 0x4d, 0xfc,
	0x75, 0xb1, 0xec, 0x2f, 0x49, 0x2d, 0xa2, 0xbb, 0x7b, 0x9e, 0x7a, 0xc6, 0x9a, 0xae, 0xf3, 0x05,
	0x1c, 0x47, 0x39, 0x4b, 0x10, 0xfd, 0x45, 0x98, 0x4c, 0x75, 0x8f, 0x28, 0xd0, 0x9d, 0x1d, 0x33,
	0x54, 0xd7, 0x1e, 0x03, 0xe9, 0xdf, 0xd3, 0x60, 0xe8, 0xae, 0x6f, 0x0f, 0x7a, 0xf6, 0x5e, 0x52,
	0x66, 0xef, 0x6c, 0x51, 0xda, 0x1d, 0x69, 0xe2, 0xae, 0xa6, 0x26, 0x6e, 0xbe, 0x10, 0x47, 0x9d,
	0xb3, 0x35, 0x18, 0xa5, 0x09, 0x7c, 0xb8, 0x2f, 0x5e, 0xb1, 0x78, 0x36, 0x0f, 0x35, 0xee, 0x59,
	0xa6, 0xfa, 0xe9, 0x72, 0xa0, 0xfe, 0xcf, 0x2a, 0x30, 0x26, 0xa7, 0x02, 0x42, 0x5f, 0xd1, 0x60,
	0x21, 0x60, 0xae, 0x00, 0xf6, 0x72, 0x37, 0x70, 0xbc, 0xed, 0x0d, 0x6b, 0x07, 0xdb, 0x5d, 0xd7,
	0xf1, 0xb6, 0xd7, 0xb7, 0x3d, 0x3f, 0x06, 0xaf, 0x1c, 0x60, 0xab, 0x4b, 0xcd, 0x75, 0x3d, 0xb2,
	0x0c, 0xc5, 0x3e, 0x2a, 0x47, 0xa4, 0x8b, 0xbe, 0xae, 0xc1, 0x25, 0x96, 0x56, 0xa7, 0xff, 0xb6,
	0x94, 0xc8, 0xa1, 0x2d, 0x41, 0x2a, 0x21, 0x72, 0x1f, 0x07, 0x6d, 0xe3, 0xa8, 0xdf, 0xd0, 0x7f,
	0xbd, 0x02, 0xe3, 0x3c, 0x32, 0xef, 0x84, 0x41, 0xcc, 0xef, 0xc1, 0xb4, 0x6b, 0x86, 0xd1, 0x0d,
	0x6c, 0x06, 0xd1, 0x26, 0x36, 0xd9, 0x35, 0x60, 0xf5, 0xc8, 0x57, 0x91, 0x59, 0x22, 0xe8, 0x67,
	0x00, 0xd1, 0xfb, 0xc9, 0xc0, 0xf4, 0x42, 0xda, 0x46, 0x4a, 0x7a, 0xe8, 0xc8, 0xa4, 0x73, 0xa8,
	0x48, 0xf7, 0xc0, 0xc3, 0xe5, 0xf7, 0xc0, 0x23, 0x79, 0x9e, 0xe1, 0xef, 0xc3, 0x54, 0x26, 0xac,
	0xf1, 0x16, 0x34, 0x62, 0x6f, 0x28, 0xbe, 0x7b, 0xca, 0xa3, 0x75, 0xd3, 0x14, 0x8c, 0x04, 0x5f,
	0xff, 0x53, 0x4d, 0xf9, 0x02, 0x1b, 0xe9, 0xb7, 0xa1, 0x6e, 0x86, 0xa1, 0xb3, 0xed, 0x61, 0x9b,
	0xaf, 0xd7, 0xf3, 0x45, 0xeb, 0x55, 0xa1, 0x1b, 0x63, 0xa1, 0x37, 0xd8, 0x15, 0xe9, 0x9e, 0x10,
	0xa9, 0xfa, 0xc3, 0xe7, 0x38, 0xe8, 0x26, 0xbb, 0x70, 0xbe, 0xe5, 0xf9, 0xfb, 0xde, 0x9a, 0xef,
	0x8b, 0x98, 0x8b, 0xfe, 0x88, 0xa8, 0xa8, 0xa5, 0xa1, 0xed, 0x16, 0xcc, 0x10, 0x74, 0xd5, 0x4f,
	0x3c, 0x44, 0xb7, 0x61, 0x92, 0xc7, 0x64, 0x0a, 0x18, 0x1f, 0x85, 0x5c, 0x31, 0x49, 0xc5, 0x36,
	0xd2, 0xa8, 0xfa, 0x97, 0x35, 0xa8, 0x93, 0xaf, 0x0c, 0xfc, 0xb0, 0x58, 0x50, 0x0f, 0x8b, 0x66,
	0xd1, 0xe8, 0x88, 0x73, 0xe2, 0x05, 0x36, 0xd3, 0xad, 0xc0, 0x3f, 0x38, 0xe4, 0x77, 0x29, 0xc5,
	0x32, 0x84, 0xfe, 0x1f, 0x35, 0xb6, 0x6f, 0x8d, 0xd8, 0xb7, 0xe9, 0x16, 0xd4, 0x2d, 0xb3, 0x63,
	0x5a, 0x2c, 0x57, 0x5a, 0xa1, 0xfe, 0xa8, 0x20, 0x2d, 0x2c, 0x71, 0x0c, 0xa6, 0x7a, 0xc5, 0x04,
	0xe6, 0x1e, 0xc1, 0xb8, 0x52, 0xf4, 0x18, 0x64, 0xf3, 0x4d, 0xc6, 0xbc, 0xe3, 0x38, 0x6b, 0x03,
	0xa6, 0x3d, 0xe9, 0x3f, 0x61, 0x6f, 0x42, 0xa6, 0x3b, 0xdf, 0x8b, 0x3d, 0x53, 0x5e, 0x98, 0x45,
	0xd7, 0x77, 0xe1, 0x49, 0x85, 0x8b, 0x27, 0x6e, 0x62, 0x85, 0x1d, 0xa4, 0xb1, 0xa4, 0x38, 0x30,
	0x23, 0x3f, 0x50, 0x05, 0x51, 0x01, 0x45, 0xa7, 0x61, 0x84, 0xf6, 0x22, 0xe4, 0x3e, 0x79, 0xfc,
	0x9f, 0xfe, 0x6f, 0xf8, 0xde, 0x95, 0x9b, 0x80, 0x1e, 0xc2, 0x54, 0xdb, 0x8c, 0xac, 0x9d, 0x95,
	0x83, 0x4e, 0xc0, 0x6c, 0x50, 0xa2, 0x53, 0x9f, 0xec, 0x79, 0xe6, 0x24, 0xad, 0x35, 0x32, 0x44,
	0xd0, 0x1d, 0x18, 0xa5, 0x30, 0xea, 0xd6, 0x19, 0x96, 0x9d, 0x1d, 0x45, 0x34, 0x65, 0x7c, 0x72,
	0x2e, 0xd4, 0xc5, 0xf9, 0x4e, 0xd8, 0x60, 0xc7, 0xb7, 0x97, 0xd6, 0x97, 0x0d, 0x65, 0x7c, 0x04,
	0x10, 0xcd, 0x41, 0x9d, 0xff, 0x14, 0x46, 0xbc, 0xf8, 0x3f, 0x3a, 0x0f, 0xd0, 0x09, 0xfc, 0x3d,
	0xc7, 0xa6, 0xf1, 0x20, 0xf2, 0x1d, 0x85, 0x04, 0x47, 0xcf, 0xc3, 0x78, 0xd7, 0x0b, 0xd9, 0x61,
	0x65, 0x6e, 0xf2, 0x54, 0x2d, 0x42, 0x5c, 0x55, 0x8b, 0xd0, 0xcb, 0x30, 0x12, 0x99, 0xf4, 0xfa,
	0x66, 0xb8, 0xd8, 0x7f, 0xe1, 0x3e, 0xa9, 0x61, 0xf0, 0x8a, 0xe8, 0x86, 0x70, 0x4f, 0x66, 0x4c,
	0x88, 0x3b, 0xdd, 0xf4, 0xc7, 0xb0, 0x14, 0x4c, 0xd2, 0x1d, 0x7c, 0x10, 0xe1, 0xc0, 0x33, 0xdd,
	0xd4, 0x05, 0xa3, 0x04, 0xd7, 0x7f, 0xad, 0x06, 0x90, 0x48, 0x3a, 0xe8, 0x46, 0x66, 0x6b, 0xbe,
	0x50, 0x2e, 0x1b, 0x15, 0xed, 0x4b, 0xf4, 0x0e, 0x8c, 0x9a, 0xae, 0xeb, 0x5b, 0x66, 0x44, 0x47,
	0xa9, 0x52, 0xbe, 0xcf, 0x39, 0xb1, 0xc5, 0x04, 0x83, 0xd1, 0x93, 0x69, 0x24, 0xb2, 0x65, 0x35,
	0x23, 0x5b, 0xa2, 0x45, 0x25, 0xf5, 0xc7, 0x50, 0xb1, 0x97, 0xa7, 0x22, 0x42, 0xc8, 0x59, 0x3f,
	0xd0, 0x9b, 0x72, 0x10, 0xc1, 0x70, 0xb1, 0xbf, 0xa5, 0x24, 0x02, 0xaa, 0x01, 0x04, 0x93, 0xb6,
	0xca, 0xff, 0xf9, 0xe4, 0x3d, 0x57, 0x44, 0x24, 0x75, 0x5c, 0x18, 0x69, 0x7c, 0x74, 0x8d, 0x05,
	0x6d, 0xac, 0x7b, 0x5b, 0x3e, 0x77, 0x95, 0xd2, 0x0b, 0x07, 0xf0, 0x30, 0x8c, 0x70, 0x9b, 0xd4,
	0x34, 0x62, 0x1c, 0xa2, 0x9d, 0x53, 0xcf, 0xc2, 0xb0, 0x59, 0x2f, 0xd6, 0xce, 0xd5, 0xa0, 0x51,
	0x83, 0x63, 0x20, 0x5d, 0x38, 0xa0, 0x86, 0xeb, 0xde, 0x83, 0x10, 0x53, 0x07, 0xd4, 0x86, 0xa1,
	0xc0, 0xc8, 0xf9, 0xc6, 0xff, 0x8b, 0x3c, 0x91, 0x4d, 0x28, 0xfe, 0x90, 0x9a, 0x4b, 0xd2, 0x48,
	0xa3, 0x92, 0xa3, 0x9e, 0x2d, 0x60, 0xee, 0x46, 0xd5, 0x6b, 0xd1, 0x73, 0xd9, 0x9c, 0xe1, 0x7c,
	0x04, 0xe7, 0xc0, 0x5c, 0x04, 0x53, 0xe9, 0x05, 0xfb, 0x18, 0x4e, 0x9f, 0xef, 0x55, 0x61, 0x42,
	0x9d, 0x71, 0xa4, 0x43, 0x83, 0x13, 0x49, 0xe5, 0x33, 0x4a, 0xc0, 0x34, 0xbf, 0x14, 0xc5, 0xc8,
	0xf8, 0x1b, 0x48, 0x70, 0x22, 0x64, 0x6e, 0xfa, 0x7e, 0x94, 0xe2, 0x7f, 0x1c, 0x46, 0x78, 0xdf,
	0x2e, 0x0e, 0x3c, 0xec, 0xe6, 0xe5, 0xab, 0x50, 0x8b, 0x08, 0x27, 0xf6, 0x43, 0xba, 0xa4, 0x14,
	0x79, 0x55, 0x00, 0xd1, 0x35, 0x78, 0x32, 0x8e, 0xb2, 0x33, 0x98, 0x2d, 0x46, 0x50, 0x95, 0x05,
	0xd8, 0xa2, 0x4a, 0xe8, 0x05, 0x98, 0xe0, 0x02, 0x92, 0x40, 0x93, 0xa3, 0xfc, 0x52, 0x65, 0x22,
	0x77, 0x06, 0x15, 0x59, 0x44, 0xfd, 0x7a, 0x3a, 0x77, 0x86, 0x5c, 0x8a, 0x16, 0x60, 0x92, 0x9d,
	0x9b, 0x44, 0x37, 0xa1, 0x03, 0xa4, 0x38, 0x12, 0xa6, 0x0b, 0xd1, 0x45, 0x18, 0x33, 0x03, 0x6b,
	0xc7, 0x89, 0xb0, 0x15, 0x75, 0x03, 0xe6, 0x56, 0x18, 0xdf, 0x72, 0xc9, 0x25, 0xfa, 0xfb, 0x30,
	0x93, 0x13, 0x3d, 0x41, 0x26, 0xc8, 0xec, 0x38, 0xa2, 0x71, 0x8a, 0xb7, 0x44, 0x02, 0x27, 0x53,
	0x4d, 0xa3, 0x2c, 0x32, 0x69, 0x56, 0x13, 0xb0, 0xfe, 0xff, 0x34, 0x98, 0xcc, 0x31, 0x09, 0xd1,
	0xa4, 0xa2, 0x5a, 0x3a, 0xa9, 0xa8, 0x9a, 0xdc, 0xa4, 0x52, 0x9e, 0xdc, 0xa4, 0x5a, 0x94, 0xdc,
	0x64, 0x28, 0x9d, 0xdc, 0x44, 0xed, 0xcd, 0x70, 0x41, 0x6f, 0x72, 0x52, 0xa0, 0x8c, 0x94, 0xa5,
	0x40, 0x51, 0x7a, 0x5f, 0xcb, 0xef, 0xfd, 0x07, 0x1a, 0x4c, 0xa5, 0x2f, 0x95, 0x07, 0x1e, 0x44,
	0x25, 0x5b, 0x1c, 0xf2, 0xd3, 0xd5, 0xa6, 0xaf, 0xb5, 0x13, 0xeb, 0xc3, 0xf5, 0x94, 0xf5, 0xe1,
	0xf9, 0xbe, 0xf0, 0x55, 0x4b, 0xc4, 0x1f, 0x69, 0x70, 0x2a, 0x5d, 0x65, 0xc9, 0x35, 0x9d, 0xf6,
	0x80, 0x7b, 0xba, 0xa8, 0xf4, 0xf4, 0xc5, 0x7e, 0x5a, 0x4a, 0x9b, 0x21, 0x75, 0x77, 0x2d, 0xd5,
	0xdd, 0x4b, 0xfd, 0x13, 0x51, 0xfb, 0xfc, 0x9b, 0x15, 0x98, 0xcf, 0xad, 0x77, 0x72, 0x8b, 0x00,
	0x77, 0x4c, 0xa6, 0x91, 0x06, 0xc7, 0xb4, 0x06, 0xa8, 0x04, 0x7e, 0x82, 0x2d, 0x01, 0xdf, 0xd4,
	0xe0, 0x4c, 0xee, 0x30, 0x0e, 0x5c, 0xaf, 0x7c, 0x4b, 0xd5, 0x2b, 0x7f, 0xba, 0xef, 0x89, 0x17,
	0x8a, 0xe6, 0x2f, 0x55, 0x0b, 0x9a, 0x4a, 0x65, 0xfd, 0x73, 0x30, 0x6a, 0x5a, 0x16, 0x0e, 0xc3,
	0x3b, 0xbe, 0x1d, 0x27, 0xb9, 0x90, 0x41, 0xe8, 0x1e, 0xd4, 0x43, 0xce, 0x5e, 0xf9, 0xd0, 0x7f,
	0xaa, 0xcf, 0xce, 0x98, 0x9b, 0xd8, 0x4d, 0xe2, 0xda, 0x04, 0x11, 0x35, 0xba, 0xa7, 0x72, 0xfc,
	0xe8, 0x9e, 0xf3, 0x00, 0x4c, 0xfa, 0xb9, 0x9b, 0xe6, 0xaa, 0x12, 0x9c, 0x1c, 0x5a, 0x61, 0xe4,
	0x07, 0xe6, 0x36, 0xe9, 0x74, 0x48, 0x5d, 0xc6, 0xd4, 0x84, 0x4f, 0xe9, 0xd2, 0x84, 0x2e, 0x8d,
	0x6e, 0x1e, 0xc9, 0xd2, 0xa5, 0x49, 0x87, 0xee, 0x00, 0x90, 0xf9, 0xe1, 0x1a, 0x46, 0xad, 0x78,
	0x6b, 0xdf, 0x3f, 0xec, 0x60, 0x3b, 0xd7, 0xa1, 0x40, 0x22, 0xa0, 0xff, 0xff, 0x0a, 0x3c, 0x55,
	0xb2, 0x7f, 0xcb, 0x4c, 0xc2, 0xe9, 0x39, 0xac, 0x64, 0xe7, 0xf0, 0xb3, 0x92, 0x46, 0xc2, 0xee,
	0xab, 0xdf, 0x3c, 0x22, 0x03, 0x29, 0x54, 0x51, 0x8c, 0x1c, 0x9d, 0xe1, 0x72, 0xdf, 0xc4, 0x73,
	0x95, 0x88, 0x8f, 0xc2, 0x1c, 0xe1, 0xc0, 0xb3, 0xb9, 0x0d, 0x4c, 0x3b, 0x13, 0x5a, 0x04, 0x98,
	0x71, 0x14, 0x4d, 0xc0, 0xbd, 0x33, 0xee, 0xea, 0xbf, 0xa8, 0xc1, 0x6c, 0xfa, 0x5b, 0x03, 0x67,
	0x1b, 0xaf, 0xa9, 0x6c, 0xe3, 0x7c, 0x3f, 0x33, 0x22, 0x38, 0xc6, 0xaf, 0x8c, 0xc3, 0xe9, 0x02,
	0x8f, 0xb2, 0xf7, 0x61, 0x7a, 0xdb, 0xc2, 0xaa, 0x23, 0x2d, 0x6f, 0x6b, 0xae, 0x3f, 0x71, 0xa9,
	0xd7, 0xad, 0x91, 0xa5, 0x85, 0x76, 0x60, 0xd6, 0xdc, 0x0f, 0x33, 0xaf, 0x17, 0xf0, 0x09, 0xbe,
	0x92, 0xab, 0x12, 0xf5, 0x78, 0xed, 0xc0, 0xc8, 0xa5, 0x88, 0x96, 0x79, 0xca, 0x1d, 0x22, 0x05,
	0x95, 0x78, 0x5e, 0xe7, 0x39, 0xeb, 0x19, 0x31, 0x26, 0x7a, 0x07, 0x1a, 0xdb, 0xc2, 0xf1, 0x34,
	0x87, 0x3d, 0x26, 0x03, 0x51, 0xee, 0x56, 0x6b, 0x24, 0x54, 0xd0, 0x2b, 0x50, 0xf5, 0xb6, 0xc2,
	0xb2, 0x54, 0xbc, 0xa9, 0x0b, 0x43, 0x83, 0xd4, 0x47, 0x6f, 0x41, 0x35, 0xd8, 0xb4, 0xb9, 0xba,
	0x9c, 0xcb, 0x89, 0x8c, 0xeb, 0xcb, 0x05, 0x5f, 0x27, 0x98, 0x68, 0x05, 0x86, 0xa9, 0xb3, 0x17,
	0x67, 0x66, 0xb9, 0x22, 0x46, 0x89, 0xb7, 0xa1, 0xc1, 0xb0, 0xd1, 0x0d, 0x18, 0xb1, 0x68, 0xb2,
	0x58, 0x1e, 0xb9, 0xf9, 0x52, 0xae, 0xbe, 0x5c, 0x92, 0x14, 0xd7, 0xe0, 0xf8, 0x94, 0x12, 0xee,
	0xec, 0x6c, 0x85, 0x3c, 0x1f, 0x77, 0x3e, 0xa5, 0x92, 0x8c, 0xca, 0x06, 0xc7, 0x47, 0x97, 0xa1,
	0xb2, 0x65, 0x71, 0x87, 0xaf, 0x5c, 0xb5, 0x5a, 0x0d, 0xea, 0x30, 0x2a, 0x5b, 0x16, 0x5a, 0x84,
	0xda, 0x16, 0xf3, 0x4d, 0xe7, 0xaa, 0xf4, 0x73, 0xf9, 0x0e, 0xf3, 0x19, 0xf7, 0x75, 0x43, 0xe0,
	0xa1, 0xbb, 0x00, 0x5b, 0xb1, 0x43, 0x3d, 0x8f, 0xb7, 0x5c, 0x38, 0x5a, 0x40, 0x83, 0x21, 0x51,
	0x20, 0x8b, 0xcd, 0x14, 0x99, 0xff, 0x79, 0x38, 0x53, 0xee, 0x62, 0xeb, 0xf1, 0xbc, 0x81, 0x91,
	0x50, 0x41, 0xef, 0xc1, 0xf8, 0x5e, 0xd8, 0xd9, 0xc1, 0x62, 0xcb, 0xd0, 0xd8, 0xa6, 0x02, 0x0e,
	0xfe, 0x2e, 0xaf, 0xe8, 0x04, 0x51, 0xd7, 0x74, 0x33, 0xbb, 0x59, 0x25, 0x44, 0xc6, 0xef, 0x51,
	0xd7, 0xdf, 0x3c, 0x8c, 0x30, 0x0f, 0xbb, 0xcc, 0x1d, 0xbf, 0x77, 0x58, 0x15, 0x75, 0xfc, 0x38,
	0x1e, 0x5a, 0xe3, 0xfd, 0xa5, 0x5c, 0x66, 0xaa, 0x38, 0xf4, 0x3d, 0xf7, 0xb1, 0x0a, 0x23, 0xc1,
	0x25, 0x5c, 0xa5, 0xb3, 0xe3, 0x47, 0xbe, 0x97, 0xe2, 0x5c, 0xd3, 0xc5, 0x5c, 0xa5, 0x95, 0x53,
	0x5f, 0xe5, 0x2a, 0x79, 0x14, 0x51, 0x0b, 0x26, 0x3a, 0x7e, 0x10, 0xed, 0xfb, 0x81, 0x98, 0x76,
	0x54, 0xa2, 0xdf, 0x28, 0x35, 0x39, 0xdd, 0x14, 0x3e, 0xba, 0x05, 0xb5, 0xd0, 0x32, 0x5d, 0xbc,
	0x7e, 0xaf, 0x39, 0x53, 0xcc, 0x68, 0x37, 0x58, 0x95, 0x82, 0x09, 0x17, 0x14, 0xd0, 0xeb, 0x30,
	0x4c, 0xf3, 0x33, 0xd2, 0x90, 0xdb, 0x82, 0x08, 0xfd, 0x8c, 0x6f, 0x83, 0xc1, 0x70, 0xc8, 0xf2,
	0xe3, 0xc2, 0x92, 0x1f, 0x36, 0x4f, 0x15, 0x2f, 0xbf, 0x0d, 0x56, 0xe9, 0x5e, 0xd1, 0xae, 0x4c,
	0xa8, 0x10, 0xa6, 0x45, 0x38, 0xce, 0xe9, 0x92, 0x7b, 0xb3, 0x42, 0x7e, 0x43, 0x30, 0xf5, 0x7f,
	0x35, 0x9c, 0x3d, 0x4c, 0xa9, 0x60, 0x6b, 0x64, 0x8c, 0xb0, 0x57, 0xfb, 0x55, 0x31, 0x0b, 0x65,
	0x9d, 0x4d, 0x38, 0xdd, 0xc9, 0x6d, 0x0b, 0x3f, 0x9e, 0xfa, 0x53, 0x42, 0x59, 0xeb, 0x0b, 0x28,
	0xa5, 0x85, 0xb9, 0x6a, 0x56, 0x98, 0x7b, 0x0b, 0xea, 0x54, 0xdc, 0xe8, 0x91, 0xd0, 0x3b, 0x2d,
	0x6d, 0xc6, 0x48, 0xe8, 0x26, 0x3c, 0x9d, 0xfe, 0xb8, 0x81, 0x69, 0x29, 0x0f, 0xab, 0x96, 0xe5,
	0xe3, 0xf2, 0xaa, 0xb9, 0xe2, 0xf5, 0x48, 0xa9, 0x78, 0xad, 0xc3, 0x58, 0xdb, 0xef, 0x7a, 0x11,
	0xbf, 0xf4, 0xe2, 0x37, 0x08, 0x0a, 0x2c, 0x25, 0x82, 0xd7, 0x0b, 0x44, 0xf0, 0x9b, 0xa9, 0x27,
	0x83, 0x1a, 0xc5, 0x59, 0x48, 0x58, 0xd3, 0x8b, 0x1f, 0x0e, 0xfa, 0x28, 0x44, 0xce, 0x20, 0x47,
	0xca, 0xea, 0x2d, 0xec, 0xf7, 0xc8, 0x5e, 0x56, 0x1e, 0xe9, 0xac, 0xff, 0x0c, 0x9c, 0xeb, 0xc5,
	0xd8, 0xe8, 0x2d, 0xa4, 0x9d, 0xb2, 0x81, 0x52, 0x48, 0x0f, 0x4f, 0xa6, 0x5f, 0xd7, 0xa0, 0xda,
	0xf2, 0xed, 0x01, 0x1b, 0x4f, 0x2e, 0x29, 0xc6, 0x93, 0xa7, 0x0a, 0xde, 0x60, 0x92, 0x4c, 0x25,
	0xaf, 0xa4, 0x4c, 0x25, 0x4f, 0x17, 0xa1, 0xa8, 0x86, 0x91, 0x7f, 0x51, 0x81, 0x51, 0xe9, 0x4d,
	0x28, 0xf4, 0xf3, 0xc7, 0x71, 0x26, 0xa9, 0x96, 0x3d, 0x13, 0xc5, 0x29, 0xd3, 0xcb, 0xca, 0x8f,
	0xd8, 0x9f, 0xe4, 0x21, 0x76, 0xb6, 0x77, 0x22, 0x6c, 0xa7, 0x9b, 0x75, 0x64, 0x7f, 0x92, 0x6f,
	0x69, 0x30, 0x99, 0x22, 0x82, 0x3e, 0x0b, 0xe3, 0xae, 0xac, 0xfa, 0xf3, 0x45, 0x70, 0x2c, 0xab,
	0x81, 0x4a, 0x09, 0xcd, 0x03, 0xc4, 0xf6, 0x54, 0xa1, 0xe8, 0x4a, 0x10, 0x74, 0x01, 0x46, 0x23,
	0xbf, 0xe3, 0xbb, 0xfe, 0xf6, 0xe1, 0x2d, 0xac, 0x86, 0xb9, 0xc9, 0x05, 0xfa, 0x77, 0x2a, 0xac,
	0xd9, 0xd2, 0x43, 0x5d, 0x1f, 0x4f, 0x78, 0x5f, 0x13, 0xfe, 0xcb, 0x1a, 0x4c, 0x11, 0x22, 0xf4,
	0xbe, 0x49, 0xb0, 0xeb, 0x38, 0x35, 0x86, 0x96, 0x4d, 0x8d, 0x41, 0x6d, 0x86, 0xb6, 0xdf, 0x8d,
	0x14, 0x6d, 0x98, 0xc3, 0x78, 0x29, 0x0e, 0x02, 0xc5, 0x61, 0x91, 0xc3, 0x44, 0xca, 0x8c, 0xa1,
	0x54, 0xca, 0x0c, 0x16, 0xec, 0xcd, 0x6f, 0x34, 0x94, 0xc3, 0x2a, 0x01, 0xeb, 0xff, 0xbc, 0x02,
	0x63, 0x2d, 0xdf, 0xfe, 0xd8, 0xac, 0x79, 0x14, 0xb3, 0xe6, 0xdf, 0xd4, 0xe8, 0xa0, 0x2d, 0xdf,
	0xdd, 0xe0, 0xef, 0x64, 0x9c, 0x83, 0x51, 0xba, 0xbd, 0xa8, 0xeb, 0x69, 0x6c, 0x1e, 0x94, 0x40,
	0x68, 0x0e, 0xea, 0x21, 0x36, 0x03, 0x6b, 0x27, 0xde, 0x90, 0xf1, 0x7f, 0xf4, 0x76, 0x12, 0x73,
	0x5c, 0x2d, 0x4e, 0x34, 0x22, 0x7f, 0x90, 0xad, 0xa8, 0x38, 0xd0, 0x58, 0xbf, 0x09, 0x28, 0x5b,
	0x7c, 0xcc, 0xd0, 0xc3, 0xef, 0x69, 0x30, 0xd1, 0xf2, 0x6d, 0xb2, 0x96, 0x7f, 0x82, 0x17, 0xae,
	0x9c, 0x7d, 0x60, 0x44, 0xcd, 0x3e, 0xf0, 0x34, 0x0c, 0xb7, 0x7c, 0x7b, 0xbd, 0x95, 0xef, 0x43,
	0xad, 0xff, 0x55, 0x0d, 0x6a, 0x2d, 0xdf, 0x1e, 0xb8, 0x29, 0xe9, 0x45, 0xd5, 0x94, 0xf4, 0x64,
	0xc1, 0x1c, 0x0a, 0xeb, 0xd1, 0x7f, 0xab, 0xc0, 0x38, 0x69, 0x86, 0xbf, 0x2d, 0x46, 0x59, 0xe9,
	0xb5, 0x96, 0xdf, 0x6b, 0x22, 0x5a, 0xf8, 0xae, 0xeb, 0xef, 0xab, 0xa3, 0xcd, 0x60, 0x2c, 0x9f,
	0x21, 0xde, 0x73, 0x7c, 0x7e, 0xaa, 0xd7, 0x93, 0x7c, 0x86, 0x0c, 0x8a, 0x2e, 0xc2, 0x58, 0xe8,
	0x78, 0x16, 0x16, 0xcf, 0xb9, 0x0c, 0x49, 0x39, 0x99, 0x95, 0x12, 0x9a, 0xf3, 0x96, 0xfc, 0xa7,
	0x9b, 0xee, 0x38, 0x39, 0x6f, 0x05, 0x32, 0x91, 0x52, 0x23, 0x91, 0x44, 0x25, 0x54, 0xe2, 0xdd,
	0x24, 0x38, 0xe9, 0x7d, 0x64, 0x3a, 0xee, 0x6d, 0xc7, 0xc3, 0x21, 0x35, 0xad, 0xc4, 0xa9, 0xa2,
	0x63, 0x30, 0xa1, 0x44, 0xfd, 0xf9, 0x59, 0x3e, 0xe9, 0xba, 0x54, 0x49, 0x82, 0xeb, 0x2f, 0xc2,
	0xa9, 0x96, 0x6f, 0x13, 0xa5, 0x71, 0xd5, 0x0f, 0xf6, 0xcd, 0xc0, 0x16, 0x03, 0x3c, 0x2b, 0x72,
	0x7a, 0x91, 0xfd, 0x39, 0x2c, 0x32, 0x20, 0x7e, 0x92, 0x9e, 0x71, 0x7d, 0x3a, 0x98, 0x5d, 0xa3,
	0x6c, 0xdd, 0x10, 0xe9, 0xa2, 0xd6, 0xcc, 0x08, 0xf3, 0x94, 0xd3, 0x8c, 0x7d, 0xde, 0x4f, 0xb3,
	0x4e, 0xb5, 0x48, 0xff, 0x76, 0x95, 0xee, 0xd4, 0x54, 0x16, 0x25, 0x74, 0x13, 0x26, 0x42, 0x7c,
	0xdb, 0xf1, 0xba, 0x07, 0x42, 0xdc, 0x2f, 0xf1, 0xdd, 0xdb, 0x58, 0x91, 0x6b, 0x1a, 0x29, 0x4c,
	0xf4, 0x59, 0x98, 0xd8, 0x77, 0x3c, 0xdb, 0xdf, 0x0f, 0x05, 0xad, 0x7a, 0xb1, 0x3e, 0xfc, 0x90,
	0xd5, 0x4c, 0xb5, 0x27, 0x26, 0xad, 0x12, 0x22, 0x73, 0x14, 0x74, 0xbd, 0xc5, 0xf0, 0x41, 0x88,
	0x03, 0x35, 0x9d, 0x77, 0x0c, 0xa6, 0x81, 0xf8, 0xe4, 0xcf, 0x5a, 0xe0, 0x77, 0x59, 0x1e, 0x9f,
	0x78, 0x8e, 0x12, 0x38, 0x4d, 0xbb, 0x4b, 0xfe, 0xdd, 0xf5, 0x3d, 0xc3, 0xf7, 0x23, 0x65, 0xb5,
	0x2a, 0x25, 0x68, 0x01, 0x50, 0xd8, 0xed, 0x74, 0x5c, 0x7a, 0xb1, 0x61, 0xba, 0x14, 0x9d, 0x19,
	0xd0, 0xab, 0x46, 0x4e, 0x09, 0xe1, 0xdd, 0x5b, 0xfc, 0xe3, 0xc3, 0xd2, 0xc7, 0x05, 0x10, 0x5d,
	0x81, 0x5a, 0x78, 0x18, 0x5a, 0x11, 0x8f, 0xac, 0x2c, 0x48, 0xb3, 0xb6, 0x41, 0xab, 0x18, 0xa2,
	0xaa, 0xfe, 0x79, 0xca, 0xf0, 0x37, 0x9c, 0x6d, 0xcf, 0x8c, 0xba, 0x01, 0x39, 0x9b, 0xc6, 0x3b,
	0xf4, 0xd4, 0xe4, 0x6f, 0xda, 0xf1, 0xf9, 0xba, 0xd2, 0xa7, 0x04, 0xbf, 0xef, 0xe1, 0x20, 0x51,
	0x39, 0x55, 0x52, 0xfa, 0x97, 0xa7, 0x29, 0x83, 0xa2, 0xea, 0xf9, 0x15, 0xa8, 0x71, 0xd7, 0x15,
	0x2e, 0x45, 0xcd, 0x15, 0xab, 0x6d, 0x86, 0xa8, 0x8a, 0x56, 0x60, 0x82, 0xc8, 0x2e, 0x52, 0x02,
	0xab, 0xd9, 0xd2, 0xf7, 0x49, 0xb8, 0xd3, 0x43, 0x0a, 0x09, 0xbd, 0x49, 0xef, 0x2c, 0xd4, 0x1c,
	0x58, 0x3d, 0x48, 0x48, 0x08, 0x45, 0xb9, 0xb4, 0xf4, 0x13, 0xe7, 0xd2, 0x22, 0x3b, 0x8e, 0xa7,
	0x66, 0xe6, 0x9a, 0xb8, 0x2c, 0xc1, 0xaa, 0x45, 0x44, 0x8b, 0x97, 0x52, 0xa5, 0xad, 0x05, 0x26,
	0xb5, 0xa5, 0x3b, 0x74, 0x0f, 0x66, 0x58, 0x60, 0x79, 0x55, 0xf4, 0x1a, 0x9c, 0x62, 0xce, 0xbe,
	0xcb, 0xd8, 0xb4, 0x5d, 0xc7, 0x8b, 0xd9, 0xa8, 0xbc, 0xd2, 0xf2, 0xab, 0xd0, 0xc4, 0x12, 0x5e,
	0xc8, 0xdb, 0x3b, 0xa2, 0x24, 0x96, 0x10, 0x60, 0xf4, 0x0e, 0xd3, 0xd4, 0x63, 0x8d, 0xa0, 0x56,
	0xfc, 0xaa, 0x11, 0x5f, 0x20, 0x8a, 0xdb, 0x22, 0xb3, 0xc3, 0x28, 0x24, 0xd0, 0x15, 0x40, 0x44,
	0x04, 0x71, 0x2c, 0xbc, 0x68, 0xd1, 0x54, 0x44, 0xd4, 0xf4, 0x20, 0x9b, 0x0a, 0x72, 0xca, 0xd1,
	0x0b, 0x84, 0x1f, 0xc9, 0x50, 0xc5, 0x1f, 0x25, 0x55, 0x86, 0x6e, 0xc0, 0x59, 0xb3, 0x1b, 0xf9,
	0xd4, 0x34, 0xb1, 0xa1, 0x14, 0xdd, 0xf7, 0x77, 0xb1, 0x47, 0x6d, 0x60, 0x62, 0x73, 0x97, 0xd6,
	0x54, 0x32, 0x07, 0x43, 0x6e, 0xe6, 0xe0, 0x0b, 0x30, 0xba, 0xe3, 0x87, 0xd1, 0x5d, 0x1c, 0xed,
	0xfb, 0xc1, 0xae, 0x12, 0xc6, 0x2c, 0x17, 0x10, 0x36, 0x40, 0x2f, 0x1f, 0xd6, 0x97, 0xa9, 0x41,
	0x59, 0xd4, 0x11, 0x40, 0x51, 0xbe, 0xde, 0x5a, 0xa2, 0x16, 0x62, 0xa5, 0x7c, 0xbd, 0xb5, 0x44,
	0xa6, 0x9a, 0xbe, 0xf3, 0xda, 0x0a, 0x7c, 0x0b, 0x87, 0x52, 0x8a, 0x8d, 0xa7, 0xa4, 0xda, 0xf9,
	0x55, 0x50, 0x2b, 0x9b, 0x51, 0x6f, 0xa2, 0xd8, 0xe6, 0x92, 0x3d, 0x0e, 0xb2, 0x49, 0xf5, 0xee,
	0xc3, 0x54, 0x9c, 0xb6, 0x8f, 0xc5, 0xcf, 0x87, 0xcd, 0xc9, 0xe2, 0xf7, 0x8b, 0x73, 0xaf, 0x51,
	0x33, 0x14, 0x94, 0x68, 0xb2, 0xa9, 0xdc, 0x4c, 0xce, 0x3a, 0x34, 0xc2, 0xee, 0xa6, 0xed, 0xb7,
	0x4d, 0xc7, 0xa3, 0x56, 0xe0, 0xe4, 0x11, 0x5c, 0x01, 0x46, 0xaf, 0x42, 0xdd, 0x14, 0xa6, 0x25,
	0x54, 0x1c, 0x16, 0x13, 0x1b, 0x94, 0xe2, 0xda, 0x64, 0x1b, 0x73, 0x0f, 0x56, 0x9e, 0x3c, 0x74,
	0x46, 0xde, 0xc6, 0x4a, 0x11, 0x7a, 0x9b, 0xa8, 0xac, 0x2e, 0x75, 0x83, 0x22, 0x47, 0xda, 0xe9,
	0xe2, 0x50, 0xc2, 0xfb, 0x71, 0x35, 0x43, 0x46, 0x41, 0x6f, 0xb1, 0x95, 0x43, 0x53, 0x52, 0xe0,
	0xb0, 0xf9, 0x64, 0x31, 0x3b, 0x8b, 0x33, 0x57, 0x18, 0x32, 0x06, 0xba, 0x0c, 0xd3, 0x9d, 0xc0,
	0xf1, 0xe9, 0xbc, 0xc4, 0x46, 0xbc, 0xa6, 0x9c, 0xae, 0x2c, 0x53, 0xcc, 0x24, 0x32, 0x06, 0x6c,
	0x9e, 0x91, 0xdf, 0x2d, 0x10, 0x50, 0x74, 0x8d, 0xf2, 0x05, 0x26, 0xb7, 0x37, 0xe7, 0x8a, 0xe3,
	0x6c, 0x64, 0xf9, 0xde, 0x48, 0x50, 0xd0, 0x6d, 0x29, 0xdd, 0x25, 0x11, 0x47, 0xc2, 0xe6, 0xd9,
	0x92, 0xab, 0xcc, 0x94, 0xec, 0x62, 0xa4, 0x70, 0xd1, 0x4b, 0x30, 0xc5, 0x83, 0x15, 0x93, 0x2e,
	0x3e, 0x2d, 0xdb, 0x29, 0xd3, 0xa5, 0x2c, 0x11, 0x8d, 0xb9, 0xe9, 0x62, 0xbe, 0x9f, 0x6f, 0x3b,
	0xde, 0x6e, 0xd8, 0x9c, 0x97, 0x76, 0x49, 0x4e, 0x39, 0xf9, 0x4e, 0x27, 0xc0, 0xb8, 0x4d, 0x05,
	0x0b, 0xce, 0x14, 0x9f, 0x91, 0xbf, 0x93, 0x2e, 0x45, 0x2b, 0x50, 0xf7, 0xf7, 0x70, 0xb0, 0x83,
	0x4d, 0xbb, 0x79, 0xae, 0xc4, 0xc7, 0x83, 0xf3, 0xc5, 0x7b, 0xbc, 0x2e, 0xb7, 0x4d, 0x0b, 0x54,
	0xf4, 0x79, 0x38, 0x23, 0x2c, 0x1c, 0x1b, 0x1d, 0xd2, 0xf9, 0x25, 0xdf, 0x0b, 0xa3, 0x80, 0x79,
	0x4e, 0x3f, 0x5b, 0xec, 0x85, 0x7c, 0xbf, 0x00, 0xc9, 0x28, 0x26, 0x37, 0x77, 0x0b, 0xa6, 0x33,
	0xec, 0xf9, 0xd8, 0x6f, 0xcb, 0x3d, 0x82, 0x71, 0xa5, 0x4f, 0x8f, 0xc1, 0xf2, 0xfa, 0x5b, 0xc3,
	0xd0, 0x88, 0x2d, 0x80, 0xa5, 0xd6, 0xd6, 0xb7, 0x73, 0x1e, 0x43, 0x2c, 0x5a, 0xc5, 0xf9, 0x0e,
	0xd1, 0xbd, 0x1e, 0x7b, 0x4c, 0x14, 0xf6, 0xa1, 0x1c, 0x85, 0xfd, 0x32, 0x4c, 0x7b, 0x3e, 0x7f,
	0x2b, 0xe4, 0xae, 0x38, 0x40, 0x46, 0xe5, 0xad, 0x99, 0x29, 0x2e, 0x7f, 0xdb, 0x85, 0xf6, 0x96,
	0x28, 0x91, 0xea, 0x6b, 0x0f, 0x14, 0x84, 0x5e, 0x86, 0x11, 0xfa, 0x23, 0x6c, 0x8e, 0x15, 0xbb,
	0xda, 0x53, 0x15, 0xd4, 0xe0, 0x15, 0xe3, 0x17, 0x44, 0xa8, 0x36, 0x55, 0x3b, 0xe6, 0x0b, 0x22,
	0x54, 0x9b, 0xfa, 0x2c, 0x9c, 0x52, 0xc4, 0x34, 0x36, 0x3b, 0x38, 0xe4, 0xde, 0xd0, 0x9f, 0xe8,
	0xf9, 0x34, 0x46, 0x37, 0x34, 0xf2, 0x29, 0xa0, 0x77, 0x60, 0xda, 0xca, 0x90, 0xad, 0xf7, 0x4f,
	0x36, 0x8b, 0x4d, 0xf8, 0xdf, 0x23, 0x3f, 0xa4, 0xdc, 0x42, 0x11, 0x21, 0x62, 0x28, 0xb2, 0x60,
	0x2e, 0x2b, 0xe2, 0xc5, 0x5f, 0x1f, 0xef, 0xff, 0xeb, 0x25, 0x64, 0xf4, 0xbf, 0xcb, 0xec, 0xaf,
	0xbc, 0x26, 0x0e, 0xbb, 0x6e, 0x34, 0xf0, 0xb0, 0x5e, 0xd9, 0x38, 0xd6, 0xb7, 0x39, 0xfd, 0x1b,
	0x1a, 0x35, 0xa7, 0xdf, 0xc7, 0xed, 0x8e, 0x4b, 0x74, 0xc9, 0xc1, 0x36, 0xea, 0x2d, 0xa8, 0x47,
	0x9c, 0x72, 0x59, 0x56, 0x58, 0xa9, 0x01, 0xf4, 0x82, 0x20, 0x46, 0xd2, 0xbf, 0xc6, 0xc6, 0x4d,
	0x94, 0x0e, 0xdc, 0x66, 0xf2, 0x8a, 0x6a, 0x33, 0x79, 0xa6, 0x47, 0xeb, 0x84, 0xed, 0xe4, 0xab,
	0x6a, 0xb3, 0xa8, 0xa6, 0xf4, 0xd1, 0x5e, 0xa7, 0xe8, 0x07, 0x30, 0x9b, 0x77, 0x4d, 0xfd, 0xe1,
	0xbf, 0xfe, 0xab, 0x3f, 0x07, 0xe3, 0xad, 0x00, 0x4b, 0xac, 0x94, 0xbb, 0x49, 0x6b, 0x29, 0x37,
	0x69, 0xfd, 0x7f, 0x6b, 0x30, 0xcb, 0x22, 0x64, 0x17, 0xf7, 0x7c, 0xc7, 0x6e, 0xf9, 0x36, 0x4f,
	0x4b, 0xb8, 0x0c, 0x63, 0x1d, 0x49, 0xb9, 0x2d, 0x8b, 0xf6, 0x95, 0x95, 0x60, 0x43, 0xc1, 0x42,
	0x77, 0x61, 0x0c, 0xef, 0x39, 0x56, 0x6c, 0xa8, 0xad, 0x1c, 0x99, 0xcb, 0x29, 0xf8, 0x27, 0xcb,
	0x45, 0xac, 0x7f, 0x11, 0x9e, 0x2c, 0x88, 0x06, 0x26, 0x84, 0xf7, 0xa9, 0x9d, 0x5f, 0x49, 0xd4,
	0xca, 0x61, 0x68, 0x19, 0x80, 0x19, 0xfb, 0xe9, 0xb3, 0x8e, 0x3d, 0x02, 0x41, 0x95, 0xc8, 0x3a,
	0x09, 0x4f, 0xff, 0x56, 0x05, 0x86, 0x59, 0x2e, 0xf1, 0x57, 0xa0, 0xb6, 0xc3, 0x72, 0x02, 0xf5,
	0x93, 0x6f, 0x48, 0xd4, 0x45, 0x57, 0x61, 0x86, 0xe5, 0x47, 0x72, 0x97, 0xb1, 0x6b, 0x1e, 0x0a,
	0x45, 0x53, 0xce, 0x8f, 0x9a, 0x57, 0x21, 0xe7, 0xc5, 0xe6, 0x6a, 0xf1, 0x8b, 0xcd, 0x44, 0x02,
	0xef, 0x64, 0x94, 0xe1, 0xf8, 0xb5, 0x34, 0xa5, 0x88, 0x5e, 0x61, 0x77, 0xe9, 0xfd, 0xfa, 0xfd,
	0x9d, 0x00, 0x87, 0x3b, 0xbe, 0x6b, 0x2b, 0xaf, 0x25, 0x65, 0x4a, 0x09, 0xc6, 0x96, 0xe9, 0xb8,
	0xdd, 0x00, 0x27, 0x18, 0x23, 0x32, 0x46, 0xba, 0x54, 0xff, 0x4b, 0x70, 0x8a, 0x3f, 0x64, 0x24,
	0x42, 0x77, 0xf8, 0x36, 0xba, 0x06, 0x35, 0xe1, 0x0a, 0x5b, 0x12, 0xec, 0xc8, 0x50, 0x92, 0xa7,
	0x90, 0x0c, 0x81, 0xd4, 0xf7, 0x5b, 0x3c, 0xff, 0x41, 0x83, 0x99, 0x1c, 0x5f, 0x1b, 0xb6, 0x0d,
	0xb7, 0x9d, 0x30, 0x4a, 0x25, 0x97, 0x8c, 0xa1, 0x64, 0x55, 0xb1, 0x2d, 0xad, 0x6e, 0x63, 0x06,
	0xeb, 0x23, 0xa1, 0xa3, 0x78, 0xad, 0x7d, 0x28, 0xf3, 0x5a, 0xfb, 0x1c, 0x0c, 0x6f, 0xc7, 0xf6,
	0xac, 0x58, 0x14, 0xa1, 0x20, 0xf2, 0xd5, 0x08, 0x7b, 0xa6, 0x17, 0x29, 0x72, 0x0a, 0x87, 0xe9,
	0xff, 0xa4, 0x02, 0x67, 0x0a, 0xbd, 0xd9, 0x4a, 0x5f, 0x95, 0x2f, 0x7b, 0x6e, 0xa1, 0x3c, 0x25,
	0x2f, 0x7d, 0x6d, 0x27, 0xf5, 0xa0, 0x1e, 0x85, 0xc4, 0x3d, 0x1c, 0xce, 0xf4, 0x70, 0x1e, 0x6a,
	0xbb, 0xf8, 0x30, 0x70, 0xbc, 0x6d, 0xf5, 0xbe, 0x85, 0x03, 0xd5, 0xd4, 0x72, 0xb5, 0x13, 0xe7,
	0xd4, 0xad, 0xe7, 0xf2, 0xd1, 0x7f, 0x54, 0x81, 0x49, 0xe3, 0xfa, 0xf2, 0x9f, 0xd3, 0x21, 0x5a,
	0xcd, 0x0e, 0xd1, 0x89, 0x33, 0xe4, 0xe6, 0x8f, 0xd3, 0xd7, 0x35, 0x98, 0xa4, 0x09, 0x76, 0x78,
	0x3c, 0x9a, 0xe3, 0x7b, 0x03, 0x3e, 0x7c, 0xe7, 0x60, 0x38, 0x20, 0x1f, 0x50, 0x47, 0x96, 0x82,
	0xc8, 0x08, 0xd9, 0xec, 0xc1, 0xef, 0xe4, 0xd9, 0x6c, 0x0a, 0xa1, 0x61, 0x2a, 0x06, 0xee, 0xb8,
	0x0e, 0x6b, 0x53, 0x62, 0x50, 0x7d, 0xfc, 0x61, 0x2a, 0xb9, 0xcd, 0x38, 0x6a, 0x98, 0x4a, 0x3e,
	0x11, 0x55, 0x7c, 0xfc, 0x3f, 0x1a, 0xcc, 0xe7, 0xd6, 0x3b, 0xf9, 0x7d, 0x6e, 0xfe, 0xed, 0x6b,
	0x75, 0xc0, 0xb7, 0xaf, 0x43, 0xe5, 0x47, 0xfb, 0x70, 0x51, 0x50, 0x49, 0x6e, 0xa7, 0x3f, 0x92,
	0xa0, 0x92, 0xdc, 0x96, 0x08, 0x41, 0xf5, 0x87, 0x95, 0x82, 0xa6, 0xf2, 0xa0, 0x92, 0x7a, 0xc0,
	0x0a, 0x43, 0xf5, 0x51, 0x4b, 0x01, 0x45, 0x0b, 0x30, 0xd9, 0x76, 0x3c, 0xfa, 0xd4, 0x57, 0xde,
	0x09, 0x9d, 0x2e, 0x44, 0x0f, 0xa5, 0x20, 0x94, 0x4a, 0x71, 0x62, 0xf0, 0xc2, 0x26, 0x2d, 0xa8,
	0xa6, 0xe4, 0x24, 0x18, 0x45, 0xd6, 0x24, 0xaa, 0xc7, 0xd0, 0x24, 0xe6, 0xd6, 0x60, 0x7c, 0x20,
	0x76, 0x10, 0xfd, 0xc7, 0x15, 0x78, 0xaa, 0x64, 0x6b, 0xf4, 0x31, 0xa8, 0xaf, 0xc2, 0xec, 0x56,
	0xd7, 0x75, 0x0f, 0xa9, 0x0b, 0x0d, 0xb6, 0x0d, 0x51, 0x5b, 0x16, 0x0a, 0x72, 0x6b, 0xb0, 0x7b,
	0x07, 0xd3, 0x3e, 0x8c, 0x51, 0x14, 0x71, 0x49, 0x29, 0x42, 0x97, 0x61, 0xda, 0xdc, 0x33, 0x1d,
	0x1a, 0x9c, 0x1f, 0xd7, 0x97, 0xe5, 0xa5, 0x6c, 0x31, 0xba, 0x02, 0xc8, 0xe7, 0x89, 0xfd, 0xd7,
	0xb0, 0xc7, 0x2d, 0x97, 0x74, 0xbc, 0xc5, 0xe5, 0x42, 0x4e, 0x79, 0x2a, 0xb4, 0x64, 0xa4, 0x38,
	0xb4, 0xa4, 0x9c, 0x53, 0xc8, 0xe6, 0x18, 0xfd, 0xd7, 0x28, 0x33, 0xcd, 0x79, 0x29, 0x4b, 0x79,
	0x60, 0x37, 0x13, 0xe0, 0xa1, 0x16, 0xb1, 0xb9, 0x08, 0x13, 0xd7, 0x4f, 0x49, 0x6a, 0xe2, 0x2f,
	0x7f, 0xdc, 0x80, 0x9a, 0xed, 0xec, 0x39, 0xa1, 0x1f, 0xf0, 0x65, 0x75, 0x54, 0x73, 0x95, 0x40,
	0xd7, 0xff, 0xbb, 0x06, 0xe3, 0xa2, 0xc5, 0xef, 0x74, 0xfd, 0xc8, 0x1c, 0x30, 0xdb, 0xff, 0x8c,
	0xc2, 0xf6, 0x7f, 0xaa, 0x2c, 0x12, 0x8b, 0x7e, 0x5e, 0x62, 0xf7, 0x6f, 0xa5, 0xd8, 0xfd, 0x73,
	0xbd, 0x91, 0x55, 0x36, 0xff, 0xf7, 0x34, 0x98, 0x56, 0xca, 0x07, 0xce, 0xe9, 0x3e, 0xad, 0x72,
	0xba, 0x67, 0x7b, 0xb6, 0x50, 0x70, 0xb8, 0x6f, 0x56, 0x52, 0x4d, 0xa3, 0x9c, 0x6d, 0x09, 0x86,
	0x76, 0xcc, 0xc0, 0x2e, 0xcb, 0xb8, 0x92, 0x41, 0x5a, 0xb8, 0x61, 0x06, 0xdc, 0x5c, 0x4b, 0x91,
	0xd1, 0x69, 0x18, 0x09, 0x2d, 0xbf, 0x13, 0x3b, 0xcc, 0xf0, 0x7f, 0x68, 0x0d, 0xc6, 0xe9, 0xaf,
	0xf8, 0x9a, 0xac, 0x5a, 0x9c, 0x4a, 0x6d, 0x43, 0xae, 0x68, 0xa8, 0x78, 0x73, 0x6d, 0x68, 0xc4,
	0xdf, 0x7c, 0x0c, 0xe6, 0xd4, 0x2f, 0x55, 0x61, 0x26, 0x67, 0x96, 0xd1, 0x8a, 0x32, 0x58, 0x2f,
	0xf7, 0xb9, 0x38, 0x32, 0xc3, 0xb5, 0x42, 0x65, 0x47, 0x9b, 0xcf, 0x60, 0xdf, 0x64, 0x1e, 0x84,
	0x58, 0x90, 0x21, 0xe8, 0x8f, 0x79, 0x50, 0xc8, 0xe7, 0xe2, 0x16, 0x3c, 0x86, 0x39, 0xf8, 0x46,
	0x15, 0x66, 0xf3, 0x02, 0x26, 0xd1, 0xed, 0x54, 0x72, 0xc9, 0x2b, 0xfd, 0x86, 0x5a, 0xb2, 0x8c,
	0x93, 0xfc, 0xe5, 0x07, 0x4e, 0x03, 0x19, 0x84, 0xf1, 0xd1, 0x44, 0x9e, 0x62, 0x47, 0x5d, 0xed,
	0x9b, 0x1e, 0xcf, 0x00, 0xca, 0x29, 0xc6, 0x74, 0xe6, 0x7c, 0x18, 0x95, 0x3e, 0xf5, 0x18, 0xa6,
	0xe6, 0x11, 0x61, 0xa8, 0x52, 0x5b, 0x1e, 0xc3, 0xf4, 0x7c, 0x01, 0x26, 0x54, 0xef, 0x96, 0x58,
	0x23, 0xd2, 0x32, 0x1a, 0x51, 0x13, 0x86, 0x02, 0xdf, 0x4d, 0xe5, 0x7b, 0x27, 0x90, 0x58, 0xe4,
	0xad, 0x66, 0x44, 0xde, 0x39, 0x18, 0x76, 0xf1, 0x1e, 0x56, 0x55, 0x2f, 0x06, 0xd2, 0x7f, 0xb5,
	0x0a, 0x4f, 0x97, 0x86, 0x87, 0x10, 0xc1, 0x74, 0xdb, 0x8c, 0xf0, 0xbe, 0xa9, 0x8e, 0x81, 0x00,
	0x52, 0x81, 0x9a, 0x65, 0x6f, 0x50, 0x05, 0x6a, 0x96, 0xb4, 0x61, 0x00, 0x0f, 0xc3, 0x9c, 0x07,
	0x08, 0x43, 0x77, 0x85, 0x5e, 0xa7, 0xd9, 0x8a, 0xdb, 0x9c, 0x04, 0x67, 0x77, 0x6b, 0x7e, 0xc4,
	0x4c, 0x20, 0xcb, 0xec, 0xee, 0x76, 0x58, 0xbd, 0x5b, 0x53, 0x4b, 0xd1, 0x05, 0x18, 0xe5, 0xf1,
	0x07, 0x2d, 0xa2, 0x97, 0xca, 0x0a, 0xa6, 0x5c, 0x20, 0xd5, 0xa3, 0x56, 0x94, 0x5a, 0x4e, 0x3d,
	0x1a, 0x71, 0xa0, 0x86, 0x1c, 0xd7, 0x0b, 0x42, 0x8e, 0x13, 0x25, 0xb9, 0xd1, 0xc3, 0xf0, 0x09,
	0xb9, 0x8a, 0xe8, 0xaf, 0x54, 0x61, 0x86, 0x4f, 0xd8, 0x00, 0xa7, 0x69, 0x50, 0x4f, 0xcd, 0x7c,
	0x3c, 0x57, 0xf2, 0x5c, 0x05, 0x30, 0xae, 0x1c, 0xc5, 0xc8, 0x2c, 0xcc, 0xf8, 0xf5, 0x4a, 0xe1,
	0x39, 0x6e, 0x0b, 0x7e, 0xd9, 0x57, 0xee, 0x2f, 0xfd, 0x4b, 0x1a, 0x3c, 0xdb, 0x13, 0x8f, 0xba,
	0x38, 0x90, 0x4a, 0xd9, 0x60, 0xe5, 0x18, 0x7c, 0x82, 0x6c, 0x67, 0x5f, 0xae, 0xc2, 0x08, 0xdb,
	0xd0, 0x03, 0x16, 0x47, 0x5f, 0xe5, 0x76, 0x90, 0x92, 0xb8, 0x65, 0xf6, 0xdd, 0x85, 0x65, 0x33,
	0x32, 0xf9, 0x01, 0x4f, 0x31, 0x6f, 0x02, 0x84, 0xf4, 0xa1, 0x14, 0x52, 0xc0, 0x23, 0xd1, 0x9f,
	0x2f, 0xc1, 0xdf, 0x88, 0x2b, 0x33, 0x2a, 0x12, 0x76, 0x31, 0xa7, 0x9d, 0x5b, 0x82, 0x46, 0x8c,
	0xd2, 0x9f, 0xae, 0x37, 0x96, 0xbd, 0xf3, 0x5e, 0x87, 0xc9, 0xd4, 0xd7, 0x8f, 0xad, 0x36, 0xfe,
	0x6d, 0x0d, 0x26, 0x53, 0x4f, 0x23, 0xa3, 0xcf, 0xc1, 0xac, 0x9b, 0xb3, 0x8b, 0xf9, 0xec, 0xf4,
	0xbf, 0xeb, 0x73, 0xa9, 0xb0, 0x45, 0x43, 0x36, 0xae, 0xe9, 0xaa, 0x11, 0xee, 0x02, 0xaa, 0xff,
	0x53, 0x0d, 0xa6, 0x33, 0xef, 0xfc, 0x7e, 0xc8, 0xad, 0xe2, 0xe3, 0x57, 0xc9, 0x4d, 0xe8, 0xc7,
	0x5b, 0x5b, 0xcd, 0x6d, 0xed, 0x5f, 0xd7, 0x00, 0x58, 0x6b, 0x07, 0xae, 0x7d, 0xbc, 0xa4, 0x6a,
	0x1f, 0x73, 0x25, 0xc7, 0x22, 0x57, 0x3b, 0x7e, 0x4b, 0x83, 0x29, 0x06, 0x49, 0xac, 0xfd, 0x1f,
	0xf2, 0xc8, 0xf5, 0x93, 0xe6, 0x38, 0x7e, 0xc1, 0x82, 0xb7, 0x53, 0x19, 0xd6, 0xa1, 0xdc, 0x61,
	0xbd, 0x27, 0xd6, 0x65, 0x1f, 0x29, 0xb5, 0xfb, 0xc9, 0x9f, 0xa4, 0xff, 0x6b, 0x0d, 0x10, 0xa3,
	0x98, 0x7e, 0x20, 0x8b, 0x1d, 0x4e, 0x19, 0x46, 0x27, 0xc1, 0x8f, 0xd7, 0xc9, 0xd4, 0xe5, 0x4a,
	0xb5, 0xe0, 0x72, 0xa5, 0x8f, 0xc1, 0xf8, 0x8d, 0x21, 0x3a, 0x1a, 0x8a, 0xef, 0xdb, 0x32, 0x8c,
	0x59, 0x66, 0xc7, 0xdc, 0x74, 0x5c, 0x27, 0x72, 0x70, 0x58, 0x76, 0x3b, 0xb9, 0x24, 0xd5, 0x33,
	0x14, 0x2c, 0x96, 0x70, 0xd1, 0xd9, 0x73, 0x5c, 0xbc, 0x4d, 0x75, 0x24, 0xe9, 0x38, 0x4e, 0xe0,
	0x39, 0x7e, 0xd8, 0xd5, 0x01, 0xfa, 0x61, 0xc3, 0x87, 0xe2, 0x87, 0x3d, 0xd4, 0x8f, 0x1f, 0x76,
	0xbd, 0x4f, 0x3f, 0xec, 0xe1, 0x42, 0x3f, 0xec, 0x37, 0xe0, 0xb4, 0x38, 0xcd, 0xc9, 0xff, 0x55,
	0xc7, 0xc5, 0x5c, 0x8a, 0x92, 0x3d, 0xfa, 0x0b, 0xea, 0xa0, 0xb7, 0xa1, 0x69, 0xba, 0xae, 0xbf,
	0xdf, 0x12, 0x63, 0xbd, 0x12, 0x5a, 0xa6, 0xcb, 0xec, 0x5b, 0x35, 0x09, 0xbf, 0xb0, 0x16, 0x7d,
	0x3e, 0x2e, 0xf0, 0xad, 0x3b, 0x19, 0x6f, 0xd4, 0x04, 0xac, 0xbf, 0x07, 0x33, 0x1b, 0x38, 0x70,
	0x68, 0xca, 0x70, 0x3b, 0xd9, 0x4f, 0x8b, 0xd0, 0x08, 0x52, 0xcc, 0xa0, 0xaf, 0x50, 0xe0, 0x04,
	0x8b, 0xf0, 0x9b, 0x1a, 0x77, 0x60, 0x1b, 0xf0, 0x41, 0xfe, 0x29, 0xc5, 0xae, 0xf4, 0x4c, 0x3e,
	0xeb, 0xa3, 0x1f, 0x96, 0x2c, 0x4a, 0x9f, 0x49, 0x59, 0x94, 0x9e, 0x2d, 0x43, 0x53, 0x6d, 0x49,
	0xdf, 0xad, 0xc0, 0x84, 0xea, 0x7a, 0x3b, 0xe0, 0x0e, 0xbd, 0x09, 0xb5, 0x90, 0xbb, 0xa8, 0x56,
	0x8a, 0xbd, 0x77, 0x32, 0x4f, 0xc9, 0x72, 0x9c, 0x5c, 0x57, 0xd7, 0xea, 0x89, 0x5d, 0x5d, 0x7b,
	0xb9, 0x28, 0x0f, 0xf5, 0xeb, 0xa2, 0xac, 0xff, 0x7d, 0xca, 0x5e, 0x65, 0xf8, 0xc0, 0x8f, 0xc3,
	0x57, 0x55, 0x26, 0xac, 0x97, 0x4c, 0x2e, 0x6f, 0x82, 0x38, 0x16, 0xff, 0x96, 0x06, 0x4f, 0xe7,
	0x34, 0x5a, 0x3a, 0x23, 0xcf, 0x41, 0xdd, 0xec, 0xda, 0x4e, 0xbc, 0x15, 0x62, 0x51, 0x56, 0x40,
	0xd1, 0x65, 0x98, 0xc6, 0x07, 0x1d, 0x87, 0x19, 0x97, 0x65, 0xbf, 0x03, 0xc1, 0x3f, 0xb2, 0xc5,
	0x71, 0xc0, 0x4c, 0x35, 0x13, 0x30, 0xf3, 0x37, 0x34, 0x18, 0x8d, 0x3d, 0x3f, 0x07, 0x3c, 0x4e,
	0x2f, 0xab, 0xe3, 0xf4, 0x54, 0xc9, 0x38, 0xc5, 0x51, 0x57, 0x49, 0x73, 0x5a, 0xfc, 0x95, 0xc0,
	0x82, 0xa3, 0x96, 0x7a, 0xee, 0xfa, 0x91, 0x6f, 0xf9, 0xae, 0x2a, 0xf3, 0x0b, 0x28, 0xbb, 0xc6,
	0x0d, 0x22, 0xf5, 0xc9, 0x29, 0xfa, 0xf6, 0x60, 0x4b, 0x3c, 0x76, 0x4b, 0xbe, 0xc1, 0x23, 0x16,
	0x8f, 0xfe, 0x8e, 0xa1, 0x44, 0x43, 0x38, 0xc6, 0x53, 0x7a, 0xf2, 0x25, 0x42, 0x0c, 0xd5, 0x2f,
	0x51, 0xde, 0x47, 0x3b, 0xd6, 0x5f, 0x28, 0xd3, 0xb7, 0x47, 0xe2, 0xa1, 0xd8, 0x60, 0x01, 0xe1,
	0x52, 0x74, 0x54, 0x39, 0x27, 0x22, 0x1f, 0xe4, 0xe1, 0x53, 0x68, 0x3d, 0x73, 0xe5, 0xf4, 0x62,
	0x0f, 0x1e, 0x56, 0x78, 0xc9, 0x44, 0xf3, 0x46, 0xd1, 0xf4, 0x3e, 0xeb, 0x2d, 0xf5, 0xed, 0xcd,
	0x18, 0x1c, 0x6b, 0x1c, 0x43, 0x19, 0xdb, 0xce, 0x39, 0x18, 0x8d, 0x73, 0x0d, 0xb7, 0xc4, 0x7b,
	0xbf, 0x32, 0x08, 0x2d, 0xc0, 0x64, 0xc8, 0x94, 0xc3, 0x38, 0x17, 0x82, 0xac, 0x16, 0xa7, 0x0b,
	0xd1, 0x0b, 0x30, 0xe1, 0xca, 0x4f, 0xa2, 0xb4, 0x14, 0xf5, 0x38, 0x55, 0x86, 0x5e, 0x83, 0xa6,
	0x0c, 0xe1, 0xf9, 0x2b, 0x4c, 0x6f, 0x1b, 0x87, 0x3c, 0xa1, 0x6d, 0x61, 0x39, 0x39, 0x86, 0x45,
	0x43, 0x33, 0xb1, 0x0f, 0x4a, 0x09, 0x7a, 0x0d, 0x4e, 0x89, 0xff, 0xf7, 0x03, 0x73, 0x6b, 0xcb,
	0xb1, 0xb8, 0xf7, 0xb4, 0xec, 0xed, 0x9a, 0x5f, 0x05, 0x5d, 0x85, 0x99, 0x1d, 0x6c, 0xba, 0xd1,
	0xce, 0xd2, 0x0e, 0xb6, 0x76, 0xef, 0x8a, 0xf5, 0x34, 0x26, 0xfb, 0x14, 0xe5, 0x54, 0x20, 0x87,
	0x77, 0xa7, 0xbb, 0xe9, 0x3a, 0xe1, 0xce, 0x5d, 0x3f, 0xa2, 0xf7, 0x8d, 0x8b, 0x71, 0xee, 0x62,
	0x39, 0x78, 0xa2, 0xb0, 0x16, 0x7a, 0x1f, 0x4e, 0xa5, 0x06, 0x97, 0x3b, 0xbc, 0x4f, 0x14, 0x67,
	0xab, 0xd9, 0xc8, 0x43, 0x30, 0xf2, 0xe9, 0x90, 0xfd, 0xe1, 0x74, 0x56, 0xcd, 0xb6, 0xe3, 0x1e,
	0x2a, 0x2f, 0x88, 0xc7, 0xd0, 0xc1, 0x5d, 0x40, 0xfe, 0x2c, 0x21, 0x24, 0x9d, 0xac, 0xe8, 0x26,
	0x8c, 0xc9, 0x13, 0xcb, 0xd9, 0xda, 0x85, 0x5e, 0x2f, 0xec, 0xf0, 0x73, 0x59, 0xc1, 0xd5, 0x1f,
	0xc2, 0xa9, 0xdc, 0x7e, 0xa3, 0x6b, 0x50, 0xb7, 0x5c, 0x07, 0x7b, 0xd1, 0x7a, 0xab, 0x2c, 0x36,
	0x70, 0x89, 0xd7, 0xe1, 0xa3, 0x15, 0xe3, 0xe8, 0x7f, 0xaa, 0xc1, 0x33, 0x3d, 0x12, 0xce, 0xa4,
	0x4c, 0x41, 0x5a, 0x81, 0x29, 0x68, 0x41, 0x24, 0x62, 0xbe, 0x9b, 0xab, 0x89, 0xa4, 0x0b, 0x4f,
	0xfc, 0x82, 0xb7, 0x62, 0x37, 0x1d, 0x3e, 0x82, 0xf4, 0x16, 0x63, 0xe9, 0x7f, 0xa2, 0xc1, 0xa9,
	0xb8, 0xf3, 0x7f, 0x0e, 0xba, 0xbc, 0x9a, 0xed, 0xf2, 0x71, 0x6c, 0x90, 0xfa, 0x35, 0x18, 0x61,
	0x81, 0x8c, 0xc7, 0x0c, 0x05, 0x7f, 0x04, 0x93, 0xa9, 0x37, 0x5e, 0xe3, 0xc7, 0x79, 0xb5, 0x81,
	0x3c, 0xce, 0x9b, 0x7d, 0x62, 0xfe, 0x97, 0x34, 0x18, 0xa6, 0x59, 0xea, 0x8f, 0xb3, 0x3f, 0xc9,
	0xc0, 0xe3, 0xad, 0x2d, 0x6c, 0xa9, 0xcf, 0xfe, 0x72, 0x18, 0xba, 0x01, 0x8d, 0xc8, 0x69, 0xe3,
	0x45, 0xdb, 0xe6, 0x16, 0xd9, 0x23, 0x3a, 0xe1, 0xc7, 0xc8, 0xfa, 0xb7, 0x34, 0x80, 0x24, 0xce,
	0xe8, 0x04, 0xaf, 0x24, 0xc4, 0x9d, 0xa9, 0x96, 0x75, 0x66, 0x28, 0xa7, 0x33, 0x97, 0x61, 0x3a,
	0x89, 0x6e, 0xca, 0x8b, 0x43, 0xcc, 0x16, 0xeb, 0x06, 0x9c, 0x8b, 0xe3, 0x58, 0x38, 0x2f, 0xa4,
	0x2e, 0x0e, 0xfd, 0xbc, 0xf8, 0x90, 0x58, 0x38, 0x2b, 0x8a, 0x85, 0xf3, 0xe7, 0x34, 0x98, 0x4d,
	0x13, 0xa5, 0x6e, 0xb6, 0x9f, 0x87, 0x53, 0xd4, 0x24, 0x4b, 0xbf, 0x90, 0x35, 0xf3, 0x5e, 0x29,
	0x8d, 0xb2, 0x29, 0x68, 0x9d, 0x91, 0x4f, 0x52, 0xff, 0x23, 0x0d, 0x9a, 0x45, 0x11, 0x3a, 0xd4,
	0x9f, 0xc8, 0x3c, 0xd8, 0xd8, 0xc5, 0xfb, 0x8a, 0x43, 0x88, 0x00, 0xa6, 0xb3, 0xa1, 0x54, 0x0a,
	0xb2, 0xa1, 0x90, 0x11, 0xdf, 0xdf, 0xc1, 0xde, 0x03, 0x2f, 0x34, 0x23, 0x27, 0xdc, 0x72, 0xe8,
	0x5b, 0x03, 0xf2, 0xbc, 0x65, 0x8b, 0xb3, 0x49, 0x5e, 0x86, 0x06, 0x95, 0xe4, 0x45, 0x7f, 0x04,
	0x67, 0x0a, 0x73, 0xa6, 0x52, 0x31, 0xbf, 0xe3, 0x30, 0xdd, 0x5f, 0x15, 0xf3, 0x39, 0x34, 0x4e,
	0xd2, 0x5d, 0xc9, 0x24, 0xe9, 0x2e, 0x4c, 0xc0, 0xad, 0xef, 0xc0, 0x08, 0xcf, 0xb6, 0x56, 0xcc,
	0x4f, 0x96, 0x45, 0x2e, 0x7f, 0x25, 0xe5, 0xd7, 0xb9, 0x62, 0x77, 0x5d, 0xf1, 0xa0, 0x84, 0x8c,
	0xa5, 0xdf, 0x85, 0x31, 0x56, 0xba, 0x8c, 0xa9, 0xce, 0x5d, 0xfc, 0xbd, 0xf3, 0x00, 0x36, 0xad,
	0x93, 0xc9, 0x52, 0x2e, 0xc1, 0xf5, 0xdf, 0xd7, 0x60, 0xf4, 0x5d, 0x9e, 0x12, 0x8b, 0xa8, 0xbc,
	0xa5, 0x72, 0x7f, 0x79, 0x62, 0x52, 0x9a, 0x01, 0x9f, 0x10, 0x69, 0xa5, 0x35, 0x9e, 0x04, 0x4c,
	0xd6, 0x5c, 0xd8, 0xdd, 0xa4, 0x35, 0x14, 0xf7, 0x74, 0x0e, 0x44, 0x2f, 0xc1, 0x14, 0xab, 0x1c,
	0xf8, 0x1d, 0x73, 0x9b, 0xd9, 0x41, 0x94, 0x7b, 0x9f, 0x74, 0x29, 0xbd, 0xcf, 0x61, 0xc8, 0x64,
	0xe1, 0xa7, 0xee, 0x7d, 0x92, 0x02, 0xdd, 0x00, 0x94, 0xcd, 0xe2, 0x85, 0xde, 0x60, 0x17, 0xd2,
	0x4e, 0x10, 0x3f, 0x8e, 0xd4, 0xfb, 0x31, 0xaf, 0x18, 0x43, 0xff, 0xed, 0x0a, 0x4c, 0xa5, 0x7d,
	0xab, 0xd1, 0x1b, 0x30, 0xc2, 0x4e, 0x9a, 0xb2, 0xd7, 0x96, 0xd2, 0x36, 0x5a, 0x83, 0xe3, 0xa0,
	0x5b, 0x30, 0x6a, 0xfb, 0xfb, 0xde, 0xbe, 0x19, 0xd8, 0x8b, 0xad, 0x75, 0xbe, 0x4a, 0x72, 0xe5,
	0xc0, 0xe5, 0xa4, 0x9a, 0x44, 0x47, 0xc6, 0x46, 0x2b, 0xf2, 0xe3, 0x52, 0x25, 0x3e, 0x36, 0xf1,
	0xe3, 0x52, 0x12, 0xa1, 0x04, 0x13, 0x59, 0x30, 0x13, 0x16, 0xd8, 0x06, 0x8a, 0xd2, 0x09, 0x96,
	0xe9, 0xda, 0x46, 0x1e, 0x35, 0xfd, 0xeb, 0x53, 0x62, 0x69, 0x73, 0x11, 0x44, 0x4e, 0xb0, 0xaa,
	0x1d, 0x3b, 0xc1, 0xea, 0x32, 0xd4, 0x71, 0xbb, 0x13, 0x1d, 0x2e, 0x3b, 0x41, 0x59, 0xb2, 0xe8,
	0x15, 0x5e, 0x47, 0xa5, 0x22, 0x30, 0xf3, 0xf3, 0xd6, 0x56, 0x1f, 0x43, 0xde, 0xda, 0xa1, 0x81,
	0xe7, 0xad, 0x5d, 0x84, 0xda, 0xb6, 0x13, 0x19, 0xb8, 0xe3, 0x73, 0x09, 0x2a, 0x77, 0x45, 0xac,
	0xb1, 0x2a, 0x6a, 0x16, 0x48, 0x8e, 0x87, 0xae, 0xc5, 0x2b, 0x7c, 0xa4, 0x58, 0xa4, 0xcf, 0x9a,
	0xda, 0xe3, 0x35, 0xce, 0x33, 0xd4, 0xd6, 0x8e, 0x98, 0xa1, 0xf6, 0x75, 0x91, 0x60, 0xb6, 0x5e,
	0xec, 0x6a, 0x96, 0x79, 0xf9, 0x5c, 0xa4, 0x95, 0x5d, 0x93, 0x13, 0xed, 0x36, 0x8a, 0x77, 0x55,
	0x9c, 0x68, 0xb7, 0x28, 0xbd, 0xee, 0x2e, 0x9c, 0xea, 0xe4, 0x65, 0x7a, 0xe6, 0x56, 0xec, 0x57,
	0xfa, 0xce, 0x5d, 0xad, 0x7c, 0x20, 0x9f, 0x26, 0x19, 0xa9, 0x60, 0xd3, 0xe6, 0x09, 0x64, 0x3f,
	0x51, 0x90, 0x94, 0x37, 0x9b, 0x8a, 0x77, 0x39, 0x27, 0x71, 0xec, 0xf9, 0xa2, 0xc4, 0xb1, 0x85,
	0xe9, 0x62, 0xaf, 0xc5, 0x99, 0x78, 0xc7, 0x8b, 0xa7, 0x99, 0x65, 0xe2, 0xcd, 0xcd, 0xbf, 0x7b,
	0x2d, 0xce, 0xbf, 0x5b, 0x12, 0xe5, 0xcf, 0xf2, 0xef, 0xe6, 0x66, 0xdd, 0x95, 0x32, 0xe8, 0x4e,
	0x1e, 0x33, 0x83, 0xee, 0x1d, 0x95, 0x9b, 0xb2, 0x1c, 0xb0, 0x9f, 0xec, 0xc1, 0x4d, 0x15, 0x52,
	0x0a, 0x3f, 0x65, 0x79, 0x80, 0xa7, 0x8f, 0x94, 0x07, 0x78, 0x4d, 0x4e, 0xba, 0x8b, 0x7a, 0x24,
	0xa1, 0x25, 0x95, 0x8a, 0x52, 0xed, 0xae, 0xc9, 0xcc, 0x7c, 0xa6, 0x98, 0x50, 0xcc, 0xcc, 0x55,
	0x42, 0x09, 0x3b, 0xcf, 0xe4, 0xec, 0x9d, 0xfd, 0x10, 0x72, 0xf6, 0x9e, 0x1a, 0x44, 0xce, 0xde,
	0xd3, 0x1f, 0x42, 0xce, 0xde, 0x27, 0x07, 0x9e, 0xb3, 0x77, 0x8d, 0xde, 0xc0, 0xb0, 0xe0, 0x2c,
	0x9e, 0xa9, 0x20, 0x3f, 0x04, 0x3f, 0x2f, 0x82, 0xcb, 0x48, 0x70, 0x73, 0x92, 0xff, 0x36, 0x4f,
	0x98, 0xfc, 0x77, 0x31, 0x49, 0xfe, 0x7b, 0xa6, 0x78, 0x42, 0x72, 0x9c, 0x85, 0x92, 0x94, 0xbf,
	0x6b, 0x72, 0xd6, 0xde, 0xa7, 0x4a, 0xcc, 0x52, 0x79, 0x76, 0x04, 0x39, 0x57, 0xef, 0x2b, 0x2c,
	0x57, 0xef, 0xd9, 0x62, 0x5e, 0x96, 0x66, 0xdd, 0x34, 0x43, 0xef, 0xf7, 0x35, 0x98, 0x2f, 0x5f,
	0x85, 0x89, 0xb1, 0xa2, 0x95, 0xb6, 0xe8, 0x4a, 0xf0, 0x1e, 0xf1, 0xa4, 0x97, 0x61, 0x3a, 0xf6,
	0x12, 0x72, 0x1d, 0xeb, 0x30, 0xf3, 0x28, 0x44, 0xb6, 0x98, 0xda, 0x4d, 0x65, 0xe0, 0xfa, 0xb2,
	0x22, 0xd4, 0xa6, 0x0b, 0xf5, 0x2f, 0x6b, 0xf0, 0x64, 0x41, 0x26, 0xc5, 0x1e, 0xc1, 0x97, 0x77,
	0x60, 0xb2, 0xa3, 0x22, 0xf4, 0x88, 0x5b, 0x56, 0xb2, 0x34, 0xa6, 0x71, 0xf5, 0x7f, 0xab, 0xc1,
	0xd3, 0xa5, 0x37, 0xab, 0xe8, 0x0d, 0x38, 0xbd, 0xdd, 0x0e, 0xcd, 0xa5, 0x00, 0xdb, 0xd8, 0x8b,
	0x1c, 0xd3, 0xdd, 0xe8, 0x60, 0x2b, 0x63, 0x0b, 0x2a, 0xa8, 0x83, 0xae, 0x00, 0xca, 0x96, 0x28,
	0xc3, 0x9e, 0x53, 0x4e, 0xa3, 0x08, 0xc4, 0x35, 0x6d, 0x66, 0xf8, 0xd5, 0xa2, 0xeb, 0x57, 0x7e,
	0xf8, 0xa3, 0xf9, 0x27, 0x7e, 0xe7, 0x47, 0xf3, 0x4f, 0xfc, 0xe1, 0x8f, 0xe6, 0xb5, 0xbf, 0xfc,
	0xc1, 0xbc, 0xf6, 0xcd, 0x0f, 0xe6, 0xb5, 0xef, 0x7f, 0x30, 0xaf, 0xfd, 0xf0, 0x83, 0x79, 0xed,
	0x7f, 0x7e, 0x30, 0xaf, 0xfd, 0xc1, 0x07, 0xf3, 0x4f, 0xfc, 0xe1, 0x07, 0xf3, 0xda, 0x57, 0x7f,
	0x3c, 0xff, 0xc4, 0x0f, 0x7f, 0x3c, 0xff, 0xc4, 0xef, 0xfc, 0x78, 0xfe, 0x89, 0x3f, 0x0b, 0x00,
	0x00, 0xff, 0xff, 0xd5, 0x52, 0x36, 0x9f, 0x1f, 0xc2, 0x00, 0x00,
}

func (this *AWSElasticBlockStoreVolumeSource) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*AWSElasticBlockStoreVolumeSource)
	if !ok {
		that2, ok := that.(AWSElasticBlockStoreVolumeSource)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.VolumeID != that1.VolumeID {
		return false
	}
	if this.FsType != that1.FsType {
		return false
	}
	if this.Partition != that1.Partition {
		return false
	}
	if this.ReadOnly != that1.ReadOnly {
		return false
	}
	return true
}
func (this *Affinity) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Affinity)
	if !ok {
		that2, ok := that.(Affinity)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.NodeAffinity.Equal(that1.NodeAffinity) {
		return false
	}
	if !this.PodAffinity.Equal(that1.PodAffinity) {
		return false
	}
	if !this.PodAntiAffinity.Equal(that1.PodAntiAffinity) {
		return false
	}
	return true
}
func (this *AttachedVolume) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*AttachedVolume)
	if !ok {
		that2, ok := that.(AttachedVolume)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if this.DevicePath != that1.DevicePath {
		return false
	}
	return true
}
func (this *AvoidPods) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*AvoidPods)
	if !ok {
		that2, ok := that.(AvoidPods)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.PreferAvoidPods) != len(that1.PreferAvoidPods) {
		return false
	}
	for i := range this.PreferAvoidPods {
		if !this.PreferAvoidPods[i].Equal(that1.PreferAvoidPods[i]) {
			return false
		}
	}
	return true
}
func (this *AzureDiskVolumeSource) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*AzureDiskVolumeSource)
	if !ok {
		that2, ok := that.(AzureDiskVolumeSource)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.DiskName != that1.DiskName {
		return false
	}
	if this.DiskURI != that1.DiskURI {
		return false
	}
	if this.CachingMode != that1.CachingMode {
		return false
	}
	if this.FsType != that1.FsType {
		return false
	}
	if this.ReadOnly != that1.ReadOnly {
		return false
	}
	if this.Kind != that1.Kind {
		return false
	}
	return true
}
func (this *AzureFilePersistentVolumeSource) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*AzureFilePersistentVolumeSource)
	if !ok {
		that2, ok := that.(AzureFilePersistentVolumeSource)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.SecretName != that1.SecretName {
		return false
	}
	if this.ShareName != that1.ShareName {
		return false
	}
	if this.ReadOnly != that1.ReadOnly {
		return false
	}
	if this.SecretNamespace != that1.SecretNamespace {
		return false
	}
	return true
}
func (this *AzureFileVolumeSource) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*AzureFileVolumeSource)
	if !ok {
		that2, ok := that.(AzureFileVolumeSource)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.SecretName != that1.SecretName {
		return false
	}
	if this.ShareName != that1.ShareName {
		return false
	}
	if this.ReadOnly != that1.ReadOnly {
		return false
	}
	return true
}
func (this *Binding) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Binding)
	if !ok {
		that2, ok := that.(Binding)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Metadata.Equal(that1.Metadata) {
		return false
	}
	if !this.Target.Equal(that1.Target) {
		return false
	}
	return true
}
func (this *CSIPersistentVolumeSource) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*CSIPersistentVolumeSource)
	if !ok {
		that2, ok := that.(CSIPersistentVolumeSource)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Driver != that1.Driver {
		return false
	}
	if this.VolumeHandle != that1.VolumeHandle {
		return false
	}
	if this.ReadOnly != that1.ReadOnly {
		return false
	}
	if this.FsType != that1.FsType {
		return false
	}
	if len(this.VolumeAttributes) != len(that1.VolumeAttributes) {
		return false
	}
	for i := range this.VolumeAttributes {
		if this.VolumeAttributes[i] != that1.VolumeAttributes[i] {
			return false
		}
	}
	if !this.ControllerPublishSecretRef.Equal(that1.ControllerPublishSecretRef) {
		return false
	}
	if !this.NodeStageSecretRef.Equal(that1.NodeStageSecretRef) {
		return false
	}
	if !this.NodePublishSecretRef.Equal(that1.NodePublishSecretRef) {
		return false
	}
	if !this.ControllerExpandSecretRef.Equal(that1.ControllerExpandSecretRef) {
		return false
	}
	return true
}
func (this *CSIVolumeSource) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*CSIVolumeSource)
	if !ok {
		that2, ok := that.(CSIVolumeSource)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Driver != that1.Driver {
		return false
	}
	if this.ReadOnly != that1.ReadOnly {
		return false
	}
	if this.FsType != that1.FsType {
		return false
	}
	if len(this.VolumeAttributes) != len(that1.VolumeAttributes) {
		return false
	}
	for i := range this.VolumeAttributes {
		if this.VolumeAttributes[i] != that1.VolumeAttributes[i] {
			return false
		}
	}
	if !this.NodePublishSecretRef.Equal(that1.NodePublishSecretRef) {
		return false
	}
	return true
}
func (this *Capabilities) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Capabilities)
	if !ok {
		that2, ok := that.(Capabilities)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.Add) != len(that1.Add) {
		return false
	}
	for i := range this.Add {
		if this.Add[i] != that1.Add[i] {
			return false
		}
	}
	if len(this.Drop) != len(that1.Drop) {
		return false
	}
	for i := range this.Drop {
		if this.Drop[i] != that1.Drop[i] {
			return false
		}
	}
	return true
}
func (this *CephFSPersistentVolumeSource) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*CephFSPersistentVolumeSource)
	if !ok {
		that2, ok := that.(CephFSPersistentVolumeSource)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.Monitors) != len(that1.Monitors) {
		return false
	}
	for i := range this.Monitors {
		if this.Monitors[i] != that1.Monitors[i] {
			return false
		}
	}
	if this.Path != that1.Path {
		return false
	}
	if this.User != that1.User {
		return false
	}
	if this.SecretFile != that1.SecretFile {
		return false
	}
	if !this.SecretRef.Equal(that1.SecretRef) {
		return false
	}
	if this.ReadOnly != that1.ReadOnly {
		return false
	}
	return true
}
func (this *CephFSVolumeSource) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*CephFSVolumeSource)
	if !ok {
		that2, ok := that.(CephFSVolumeSource)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.Monitors) != len(that1.Monitors) {
		return false
	}
	for i := range this.Monitors {
		if this.Monitors[i] != that1.Monitors[i] {
			return false
		}
	}
	if this.Path != that1.Path {
		return false
	}
	if this.User != that1.User {
		return false
	}
	if this.SecretFile != that1.SecretFile {
		return false
	}
	if !this.SecretRef.Equal(that1.SecretRef) {
		return false
	}
	if this.ReadOnly != that1.ReadOnly {
		return false
	}
	return true
}
func (this *CinderPersistentVolumeSource) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*CinderPersistentVolumeSource)
	if !ok {
		that2, ok := that.(CinderPersistentVolumeSource)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.VolumeID != that1.VolumeID {
		return false
	}
	if this.FsType != that1.FsType {
		return false
	}
	if this.ReadOnly != that1.ReadOnly {
		return false
	}
	if !this.SecretRef.Equal(that1.SecretRef) {
		return false
	}
	return true
}
func (this *CinderVolumeSource) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*CinderVolumeSource)
	if !ok {
		that2, ok := that.(CinderVolumeSource)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.VolumeID != that1.VolumeID {
		return false
	}
	if this.FsType != that1.FsType {
		return false
	}
	if this.ReadOnly != that1.ReadOnly {
		return false
	}
	if !this.SecretRef.Equal(that1.SecretRef) {
		return false
	}
	return true
}
func (this *ClientIPConfig) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ClientIPConfig)
	if !ok {
		that2, ok := that.(ClientIPConfig)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.TimeoutSeconds != that1.TimeoutSeconds {
		return false
	}
	return true
}
func (this *ComponentCondition) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ComponentCondition)
	if !ok {
		that2, ok := that.(ComponentCondition)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Type != that1.Type {
		return false
	}
	if this.Status != that1.Status {
		return false
	}
	if this.Message != that1.Message {
		return false
	}
	if this.Error != that1.Error {
		return false
	}
	return true
}
func (this *ComponentStatus) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ComponentStatus)
	if !ok {
		that2, ok := that.(ComponentStatus)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Metadata.Equal(that1.Metadata) {
		return false
	}
	if len(this.Conditions) != len(that1.Conditions) {
		return false
	}
	for i := range this.Conditions {
		if !this.Conditions[i].Equal(that1.Conditions[i]) {
			return false
		}
	}
	return true
}
func (this *ComponentStatusList) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ComponentStatusList)
	if !ok {
		that2, ok := that.(ComponentStatusList)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Metadata.Equal(that1.Metadata) {
		return false
	}
	if len(this.Items) != len(that1.Items) {
		return false
	}
	for i := range this.Items {
		if !this.Items[i].Equal(that1.Items[i]) {
			return false
		}
	}
	return true
}
func (this *ConfigMap) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ConfigMap)
	if !ok {
		that2, ok := that.(ConfigMap)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Metadata.Equal(that1.Metadata) {
		return false
	}
	if len(this.Data) != len(that1.Data) {
		return false
	}
	for i := range this.Data {
		if this.Data[i] != that1.Data[i] {
			return false
		}
	}
	if len(this.BinaryData) != len(that1.BinaryData) {
		return false
	}
	for i := range this.BinaryData {
		if !bytes.Equal(this.BinaryData[i], that1.BinaryData[i]) {
			return false
		}
	}
	return true
}
func (this *ConfigMapEnvSource) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ConfigMapEnvSource)
	if !ok {
		that2, ok := that.(ConfigMapEnvSource)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.LocalObjectReference.Equal(that1.LocalObjectReference) {
		return false
	}
	if this.Optional != that1.Optional {
		return false
	}
	return true
}
func (this *ConfigMapKeySelector) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ConfigMapKeySelector)
	if !ok {
		that2, ok := that.(ConfigMapKeySelector)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.LocalObjectReference.Equal(that1.LocalObjectReference) {
		return false
	}
	if this.Key != that1.Key {
		return false
	}
	if this.Optional != that1.Optional {
		return false
	}
	return true
}
func (this *ConfigMapList) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ConfigMapList)
	if !ok {
		that2, ok := that.(ConfigMapList)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Metadata.Equal(that1.Metadata) {
		return false
	}
	if len(this.Items) != len(that1.Items) {
		return false
	}
	for i := range this.Items {
		if !this.Items[i].Equal(that1.Items[i]) {
			return false
		}
	}
	return true
}
func (this *ConfigMapNodeConfigSource) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ConfigMapNodeConfigSource)
	if !ok {
		that2, ok := that.(ConfigMapNodeConfigSource)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Namespace != that1.Namespace {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if this.Uid != that1.Uid {
		return false
	}
	if this.ResourceVersion != that1.ResourceVersion {
		return false
	}
	if this.KubeletConfigKey != that1.KubeletConfigKey {
		return false
	}
	return true
}
func (this *ConfigMapProjection) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ConfigMapProjection)
	if !ok {
		that2, ok := that.(ConfigMapProjection)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.LocalObjectReference.Equal(that1.LocalObjectReference) {
		return false
	}
	if len(this.Items) != len(that1.Items) {
		return false
	}
	for i := range this.Items {
		if !this.Items[i].Equal(that1.Items[i]) {
			return false
		}
	}
	if this.Optional != that1.Optional {
		return false
	}
	return true
}
func (this *ConfigMapVolumeSource) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ConfigMapVolumeSource)
	if !ok {
		that2, ok := that.(ConfigMapVolumeSource)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.LocalObjectReference.Equal(that1.LocalObjectReference) {
		return false
	}
	if len(this.Items) != len(that1.Items) {
		return false
	}
	for i := range this.Items {
		if !this.Items[i].Equal(that1.Items[i]) {
			return false
		}
	}
	if this.DefaultMode != that1.DefaultMode {
		return false
	}
	if this.Optional != that1.Optional {
		return false
	}
	return true
}
func (this *Container) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Container)
	if !ok {
		that2, ok := that.(Container)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if this.Image != that1.Image {
		return false
	}
	if len(this.Command) != len(that1.Command) {
		return false
	}
	for i := range this.Command {
		if this.Command[i] != that1.Command[i] {
			return false
		}
	}
	if len(this.Args) != len(that1.Args) {
		return false
	}
	for i := range this.Args {
		if this.Args[i] != that1.Args[i] {
			return false
		}
	}
	if this.WorkingDir != that1.WorkingDir {
		return false
	}
	if len(this.Ports) != len(that1.Ports) {
		return false
	}
	for i := range this.Ports {
		if !this.Ports[i].Equal(that1.Ports[i]) {
			return false
		}
	}
	if len(this.EnvFrom) != len(that1.EnvFrom) {
		return false
	}
	for i := range this.EnvFrom {
		if !this.EnvFrom[i].Equal(that1.EnvFrom[i]) {
			return false
		}
	}
	if len(this.Env) != len(that1.Env) {
		return false
	}
	for i := range this.Env {
		if !this.Env[i].Equal(that1.Env[i]) {
			return false
		}
	}
	if !this.Resources.Equal(that1.Resources) {
		return false
	}
	if len(this.VolumeMounts) != len(that1.VolumeMounts) {
		return false
	}
	for i := range this.VolumeMounts {
		if !this.VolumeMounts[i].Equal(that1.VolumeMounts[i]) {
			return false
		}
	}
	if len(this.VolumeDevices) != len(that1.VolumeDevices) {
		return false
	}
	for i := range this.VolumeDevices {
		if !this.VolumeDevices[i].Equal(that1.VolumeDevices[i]) {
			return false
		}
	}
	if !this.LivenessProbe.Equal(that1.LivenessProbe) {
		return false
	}
	if !this.ReadinessProbe.Equal(that1.ReadinessProbe) {
		return false
	}
	if !this.Lifecycle.Equal(that1.Lifecycle) {
		return false
	}
	if this.TerminationMessagePath != that1.TerminationMessagePath {
		return false
	}
	if this.TerminationMessagePolicy != that1.TerminationMessagePolicy {
		return false
	}
	if this.ImagePullPolicy != that1.ImagePullPolicy {
		return false
	}
	if !this.SecurityContext.Equal(that1.SecurityContext) {
		return false
	}
	if this.Stdin != that1.Stdin {
		return false
	}
	if this.StdinOnce != that1.StdinOnce {
		return false
	}
	if this.Tty != that1.Tty {
		return false
	}
	return true
}
func (this *ContainerImage) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ContainerImage)
	if !ok {
		that2, ok := that.(ContainerImage)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.Names) != len(that1.Names) {
		return false
	}
	for i := range this.Names {
		if this.Names[i] != that1.Names[i] {
			return false
		}
	}
	if this.SizeBytes != that1.SizeBytes {
		return false
	}
	return true
}
func (this *ContainerPort) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ContainerPort)
	if !ok {
		that2, ok := that.(ContainerPort)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if this.HostPort != that1.HostPort {
		return false
	}
	if this.ContainerPort != that1.ContainerPort {
		return false
	}
	if this.Protocol != that1.Protocol {
		return false
	}
	if this.HostIP != that1.HostIP {
		return false
	}
	return true
}
func (this *ContainerState) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ContainerState)
	if !ok {
		that2, ok := that.(ContainerState)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Waiting.Equal(that1.Waiting) {
		return false
	}
	if !this.Running.Equal(that1.Running) {
		return false
	}
	if !this.Terminated.Equal(that1.Terminated) {
		return false
	}
	return true
}
func (this *ContainerStateRunning) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ContainerStateRunning)
	if !ok {
		that2, ok := that.(ContainerStateRunning)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.StartedAt.Equal(that1.StartedAt) {
		return false
	}
	return true
}
func (this *ContainerStateTerminated) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ContainerStateTerminated)
	if !ok {
		that2, ok := that.(ContainerStateTerminated)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.ExitCode != that1.ExitCode {
		return false
	}
	if this.Signal != that1.Signal {
		return false
	}
	if this.Reason != that1.Reason {
		return false
	}
	if this.Message != that1.Message {
		return false
	}
	if !this.StartedAt.Equal(that1.StartedAt) {
		return false
	}
	if !this.FinishedAt.Equal(that1.FinishedAt) {
		return false
	}
	if this.ContainerID != that1.ContainerID {
		return false
	}
	return true
}
func (this *ContainerStateWaiting) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ContainerStateWaiting)
	if !ok {
		that2, ok := that.(ContainerStateWaiting)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Reason != that1.Reason {
		return false
	}
	if this.Message != that1.Message {
		return false
	}
	return true
}
func (this *ContainerStatus) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ContainerStatus)
	if !ok {
		that2, ok := that.(ContainerStatus)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if !this.State.Equal(that1.State) {
		return false
	}
	if !this.LastState.Equal(that1.LastState) {
		return false
	}
	if this.Ready != that1.Ready {
		return false
	}
	if this.RestartCount != that1.RestartCount {
		return false
	}
	if this.Image != that1.Image {
		return false
	}
	if this.ImageID != that1.ImageID {
		return false
	}
	if this.ContainerID != that1.ContainerID {
		return false
	}
	return true
}
func (this *DaemonEndpoint) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*DaemonEndpoint)
	if !ok {
		that2, ok := that.(DaemonEndpoint)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Port != that1.Port {
		return false
	}
	return true
}
func (this *DownwardAPIProjection) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*DownwardAPIProjection)
	if !ok {
		that2, ok := that.(DownwardAPIProjection)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.Items) != len(that1.Items) {
		return false
	}
	for i := range this.Items {
		if !this.Items[i].Equal(that1.Items[i]) {
			return false
		}
	}
	return true
}
func (this *DownwardAPIVolumeFile) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*DownwardAPIVolumeFile)
	if !ok {
		that2, ok := that.(DownwardAPIVolumeFile)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Path != that1.Path {
		return false
	}
	if !this.FieldRef.Equal(that1.FieldRef) {
		return false
	}
	if !this.ResourceFieldRef.Equal(that1.ResourceFieldRef) {
		return false
	}
	if this.Mode != that1.Mode {
		return false
	}
	return true
}
func (this *DownwardAPIVolumeSource) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*DownwardAPIVolumeSource)
	if !ok {
		that2, ok := that.(DownwardAPIVolumeSource)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.Items) != len(that1.Items) {
		return false
	}
	for i := range this.Items {
		if !this.Items[i].Equal(that1.Items[i]) {
			return false
		}
	}
	if this.DefaultMode != that1.DefaultMode {
		return false
	}
	return true
}
func (this *EmptyDirVolumeSource) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*EmptyDirVolumeSource)
	if !ok {
		that2, ok := that.(EmptyDirVolumeSource)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Medium != that1.Medium {
		return false
	}
	if !this.SizeLimit.Equal(that1.SizeLimit) {
		return false
	}
	return true
}
func (this *EndpointAddress) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*EndpointAddress)
	if !ok {
		that2, ok := that.(EndpointAddress)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Ip != that1.Ip {
		return false
	}
	if this.Hostname != that1.Hostname {
		return false
	}
	if this.NodeName != that1.NodeName {
		return false
	}
	if !this.TargetRef.Equal(that1.TargetRef) {
		return false
	}
	return true
}
func (this *EndpointPort) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*EndpointPort)
	if !ok {
		that2, ok := that.(EndpointPort)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if this.Port != that1.Port {
		return false
	}
	if this.Protocol != that1.Protocol {
		return false
	}
	return true
}
func (this *EndpointSubset) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*EndpointSubset)
	if !ok {
		that2, ok := that.(EndpointSubset)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.Addresses) != len(that1.Addresses) {
		return false
	}
	for i := range this.Addresses {
		if !this.Addresses[i].Equal(that1.Addresses[i]) {
			return false
		}
	}
	if len(this.NotReadyAddresses) != len(that1.NotReadyAddresses) {
		return false
	}
	for i := range this.NotReadyAddresses {
		if !this.NotReadyAddresses[i].Equal(that1.NotReadyAddresses[i]) {
			return false
		}
	}
	if len(this.Ports) != len(that1.Ports) {
		return false
	}
	for i := range this.Ports {
		if !this.Ports[i].Equal(that1.Ports[i]) {
			return false
		}
	}
	return true
}
func (this *Endpoints) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Endpoints)
	if !ok {
		that2, ok := that.(Endpoints)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Metadata.Equal(that1.Metadata) {
		return false
	}
	if len(this.Subsets) != len(that1.Subsets) {
		return false
	}
	for i := range this.Subsets {
		if !this.Subsets[i].Equal(that1.Subsets[i]) {
			return false
		}
	}
	return true
}
func (this *EndpointsList) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*EndpointsList)
	if !ok {
		that2, ok := that.(EndpointsList)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Metadata.Equal(that1.Metadata) {
		return false
	}
	if len(this.Items) != len(that1.Items) {
		return false
	}
	for i := range this.Items {
		if !this.Items[i].Equal(that1.Items[i]) {
			return false
		}
	}
	return true
}
func (this *EnvFromSource) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*EnvFromSource)
	if !ok {
		that2, ok := that.(EnvFromSource)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Prefix != that1.Prefix {
		return false
	}
	if !this.ConfigMapRef.Equal(that1.ConfigMapRef) {
		return false
	}
	if !this.SecretRef.Equal(that1.SecretRef) {
		return false
	}
	return true
}
func (this *EnvVar) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*EnvVar)
	if !ok {
		that2, ok := that.(EnvVar)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if this.Value != that1.Value {
		return false
	}
	if !this.ValueFrom.Equal(that1.ValueFrom) {
		return false
	}
	return true
}
func (this *EnvVarSource) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*EnvVarSource)
	if !ok {
		that2, ok := that.(EnvVarSource)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.FieldRef.Equal(that1.FieldRef) {
		return false
	}
	if !this.ResourceFieldRef.Equal(that1.ResourceFieldRef) {
		return false
	}
	if !this.ConfigMapKeyRef.Equal(that1.ConfigMapKeyRef) {
		return false
	}
	if !this.SecretKeyRef.Equal(that1.SecretKeyRef) {
		return false
	}
	return true
}
func (this *EphemeralContainer) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*EphemeralContainer)
	if !ok {
		that2, ok := that.(EphemeralContainer)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.EphemeralContainerCommon.Equal(that1.EphemeralContainerCommon) {
		return false
	}
	if this.TargetContainerName != that1.TargetContainerName {
		return false
	}
	return true
}
func (this *EphemeralContainerCommon) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*EphemeralContainerCommon)
	if !ok {
		that2, ok := that.(EphemeralContainerCommon)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if this.Image != that1.Image {
		return false
	}
	if len(this.Command) != len(that1.Command) {
		return false
	}
	for i := range this.Command {
		if this.Command[i] != that1.Command[i] {
			return false
		}
	}
	if len(this.Args) != len(that1.Args) {
		return false
	}
	for i := range this.Args {
		if this.Args[i] != that1.Args[i] {
			return false
		}
	}
	if this.WorkingDir != that1.WorkingDir {
		return false
	}
	if len(this.Ports) != len(that1.Ports) {
		return false
	}
	for i := range this.Ports {
		if !this.Ports[i].Equal(that1.Ports[i]) {
			return false
		}
	}
	if len(this.EnvFrom) != len(that1.EnvFrom) {
		return false
	}
	for i := range this.EnvFrom {
		if !this.EnvFrom[i].Equal(that1.EnvFrom[i]) {
			return false
		}
	}
	if len(this.Env) != len(that1.Env) {
		return false
	}
	for i := range this.Env {
		if !this.Env[i].Equal(that1.Env[i]) {
			return false
		}
	}
	if !this.Resources.Equal(that1.Resources) {
		return false
	}
	if len(this.VolumeMounts) != len(that1.VolumeMounts) {
		return false
	}
	for i := range this.VolumeMounts {
		if !this.VolumeMounts[i].Equal(that1.VolumeMounts[i]) {
			return false
		}
	}
	if len(this.VolumeDevices) != len(that1.VolumeDevices) {
		return false
	}
	for i := range this.VolumeDevices {
		if !this.VolumeDevices[i].Equal(that1.VolumeDevices[i]) {
			return false
		}
	}
	if !this.LivenessProbe.Equal(that1.LivenessProbe) {
		return false
	}
	if !this.ReadinessProbe.Equal(that1.ReadinessProbe) {
		return false
	}
	if !this.Lifecycle.Equal(that1.Lifecycle) {
		return false
	}
	if this.TerminationMessagePath != that1.TerminationMessagePath {
		return false
	}
	if this.TerminationMessagePolicy != that1.TerminationMessagePolicy {
		return false
	}
	if this.ImagePullPolicy != that1.ImagePullPolicy {
		return false
	}
	if !this.SecurityContext.Equal(that1.SecurityContext) {
		return false
	}
	if this.Stdin != that1.Stdin {
		return false
	}
	if this.StdinOnce != that1.StdinOnce {
		return false
	}
	if this.Tty != that1.Tty {
		return false
	}
	return true
}
func (this *EphemeralContainers) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*EphemeralContainers)
	if !ok {
		that2, ok := that.(EphemeralContainers)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Metadata.Equal(that1.Metadata) {
		return false
	}
	if len(this.EphemeralContainers) != len(that1.EphemeralContainers) {
		return false
	}
	for i := range this.EphemeralContainers {
		if !this.EphemeralContainers[i].Equal(that1.EphemeralContainers[i]) {
			return false
		}
	}
	return true
}
func (this *Event) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Event)
	if !ok {
		that2, ok := that.(Event)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Metadata.Equal(that1.Metadata) {
		return false
	}
	if !this.InvolvedObject.Equal(that1.InvolvedObject) {
		return false
	}
	if this.Reason != that1.Reason {
		return false
	}
	if this.Message != that1.Message {
		return false
	}
	if !this.Source.Equal(that1.Source) {
		return false
	}
	if !this.FirstTimestamp.Equal(that1.FirstTimestamp) {
		return false
	}
	if !this.LastTimestamp.Equal(that1.LastTimestamp) {
		return false
	}
	if this.Count != that1.Count {
		return false
	}
	if this.Type != that1.Type {
		return false
	}
	if !this.EventTime.Equal(that1.EventTime) {
		return false
	}
	if !this.Series.Equal(that1.Series) {
		return false
	}
	if this.Action != that1.Action {
		return false
	}
	if !this.Related.Equal(that1.Related) {
		return false
	}
	if this.ReportingComponent != that1.ReportingComponent {
		return false
	}
	if this.ReportingInstance != that1.ReportingInstance {
		return false
	}
	return true
}
func (this *EventList) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*EventList)
	if !ok {
		that2, ok := that.(EventList)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Metadata.Equal(that1.Metadata) {
		return false
	}
	if len(this.Items) != len(that1.Items) {
		return false
	}
	for i := range this.Items {
		if !this.Items[i].Equal(that1.Items[i]) {
			return false
		}
	}
	return true
}
func (this *EventSeries) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*EventSeries)
	if !ok {
		that2, ok := that.(EventSeries)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Count != that1.Count {
		return false
	}
	if !this.LastObservedTime.Equal(that1.LastObservedTime) {
		return false
	}
	if this.State != that1.State {
		return false
	}
	return true
}
func (this *EventSource) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*EventSource)
	if !ok {
		that2, ok := that.(EventSource)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Component != that1.Component {
		return false
	}
	if this.Host != that1.Host {
		return false
	}
	return true
}
func (this *ExecAction) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ExecAction)
	if !ok {
		that2, ok := that.(ExecAction)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.Command) != len(that1.Command) {
		return false
	}
	for i := range this.Command {
		if this.Command[i] != that1.Command[i] {
			return false
		}
	}
	return true
}
func (this *FCVolumeSource) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*FCVolumeSource)
	if !ok {
		that2, ok := that.(FCVolumeSource)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.TargetWWNs) != len(that1.TargetWWNs) {
		return false
	}
	for i := range this.TargetWWNs {
		if this.TargetWWNs[i] != that1.TargetWWNs[i] {
			return false
		}
	}
	if this.Lun != that1.Lun {
		return false
	}
	if this.FsType != that1.FsType {
		return false
	}
	if this.ReadOnly != that1.ReadOnly {
		return false
	}
	if len(this.Wwids) != len(that1.Wwids) {
		return false
	}
	for i := range this.Wwids {
		if this.Wwids[i] != that1.Wwids[i] {
			return false
		}
	}
	return true
}
func (this *FlexPersistentVolumeSource) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*FlexPersistentVolumeSource)
	if !ok {
		that2, ok := that.(FlexPersistentVolumeSource)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Driver != that1.Driver {
		return false
	}
	if this.FsType != that1.FsType {
		return false
	}
	if !this.SecretRef.Equal(that1.SecretRef) {
		return false
	}
	if this.ReadOnly != that1.ReadOnly {
		return false
	}
	if len(this.Options) != len(that1.Options) {
		return false
	}
	for i := range this.Options {
		if this.Options[i] != that1.Options[i] {
			return false
		}
	}
	return true
}
func (this *FlexVolumeSource) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*FlexVolumeSource)
	if !ok {
		that2, ok := that.(FlexVolumeSource)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Driver != that1.Driver {
		return false
	}
	if this.FsType != that1.FsType {
		return false
	}
	if !this.SecretRef.Equal(that1.SecretRef) {
		return false
	}
	if this.ReadOnly != that1.ReadOnly {
		return false
	}
	if len(this.Options) != len(that1.Options) {
		return false
	}
	for i := range this.Options {
		if this.Options[i] != that1.Options[i] {
			return false
		}
	}
	return true
}
func (this *FlockerVolumeSource) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*FlockerVolumeSource)
	if !ok {
		that2, ok := that.(FlockerVolumeSource)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.DatasetName != that1.DatasetName {
		return false
	}
	if this.DatasetUUID != that1.DatasetUUID {
		return false
	}
	return true
}
func (this *GCEPersistentDiskVolumeSource) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*GCEPersistentDiskVolumeSource)
	if !ok {
		that2, ok := that.(GCEPersistentDiskVolumeSource)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.PdName != that1.PdName {
		return false
	}
	if this.FsType != that1.FsType {
		return false
	}
	if this.Partition != that1.Partition {
		return false
	}
	if this.ReadOnly != that1.ReadOnly {
		return false
	}
	return true
}
func (this *GitRepoVolumeSource) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*GitRepoVolumeSource)
	if !ok {
		that2, ok := that.(GitRepoVolumeSource)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Repository != that1.Repository {
		return false
	}
	if this.Revision != that1.Revision {
		return false
	}
	if this.Directory != that1.Directory {
		return false
	}
	return true
}
func (this *GlusterfsPersistentVolumeSource) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*GlusterfsPersistentVolumeSource)
	if !ok {
		that2, ok := that.(GlusterfsPersistentVolumeSource)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Endpoints != that1.Endpoints {
		return false
	}
	if this.Path != that1.Path {
		return false
	}
	if this.ReadOnly != that1.ReadOnly {
		return false
	}
	if this.EndpointsNamespace != that1.EndpointsNamespace {
		return false
	}
	return true
}
func (this *GlusterfsVolumeSource) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*GlusterfsVolumeSource)
	if !ok {
		that2, ok := that.(GlusterfsVolumeSource)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Endpoints != that1.Endpoints {
		return false
	}
	if this.Path != that1.Path {
		return false
	}
	if this.ReadOnly != that1.ReadOnly {
		return false
	}
	return true
}
func (this *HTTPGetAction) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*HTTPGetAction)
	if !ok {
		that2, ok := that.(HTTPGetAction)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Path != that1.Path {
		return false
	}
	if !this.Port.Equal(that1.Port) {
		return false
	}
	if this.Host != that1.Host {
		return false
	}
	if this.Scheme != that1.Scheme {
		return false
	}
	if len(this.HttpHeaders) != len(that1.HttpHeaders) {
		return false
	}
	for i := range this.HttpHeaders {
		if !this.HttpHeaders[i].Equal(that1.HttpHeaders[i]) {
			return false
		}
	}
	return true
}
func (this *HTTPHeader) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*HTTPHeader)
	if !ok {
		that2, ok := that.(HTTPHeader)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if this.Value != that1.Value {
		return false
	}
	return true
}
func (this *Handler) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Handler)
	if !ok {
		that2, ok := that.(Handler)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Exec.Equal(that1.Exec) {
		return false
	}
	if !this.HttpGet.Equal(that1.HttpGet) {
		return false
	}
	if !this.TcpSocket.Equal(that1.TcpSocket) {
		return false
	}
	return true
}
func (this *HostAlias) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*HostAlias)
	if !ok {
		that2, ok := that.(HostAlias)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Ip != that1.Ip {
		return false
	}
	if len(this.Hostnames) != len(that1.Hostnames) {
		return false
	}
	for i := range this.Hostnames {
		if this.Hostnames[i] != that1.Hostnames[i] {
			return false
		}
	}
	return true
}
func (this *HostPathVolumeSource) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*HostPathVolumeSource)
	if !ok {
		that2, ok := that.(HostPathVolumeSource)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Path != that1.Path {
		return false
	}
	if this.Type != that1.Type {
		return false
	}
	return true
}
func (this *ISCSIPersistentVolumeSource) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ISCSIPersistentVolumeSource)
	if !ok {
		that2, ok := that.(ISCSIPersistentVolumeSource)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.TargetPortal != that1.TargetPortal {
		return false
	}
	if this.Iqn != that1.Iqn {
		return false
	}
	if this.Lun != that1.Lun {
		return false
	}
	if this.IscsiInterface != that1.IscsiInterface {
		return false
	}
	if this.FsType != that1.FsType {
		return false
	}
	if this.ReadOnly != that1.ReadOnly {
		return false
	}
	if len(this.Portals) != len(that1.Portals) {
		return false
	}
	for i := range this.Portals {
		if this.Portals[i] != that1.Portals[i] {
			return false
		}
	}
	if this.ChapAuthDiscovery != that1.ChapAuthDiscovery {
		return false
	}
	if this.ChapAuthSession != that1.ChapAuthSession {
		return false
	}
	if !this.SecretRef.Equal(that1.SecretRef) {
		return false
	}
	if this.InitiatorName != that1.InitiatorName {
		return false
	}
	return true
}
func (this *ISCSIVolumeSource) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ISCSIVolumeSource)
	if !ok {
		that2, ok := that.(ISCSIVolumeSource)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.TargetPortal != that1.TargetPortal {
		return false
	}
	if this.Iqn != that1.Iqn {
		return false
	}
	if this.Lun != that1.Lun {
		return false
	}
	if this.IscsiInterface != that1.IscsiInterface {
		return false
	}
	if this.FsType != that1.FsType {
		return false
	}
	if this.ReadOnly != that1.ReadOnly {
		return false
	}
	if len(this.Portals) != len(that1.Portals) {
		return false
	}
	for i := range this.Portals {
		if this.Portals[i] != that1.Portals[i] {
			return false
		}
	}
	if this.ChapAuthDiscovery != that1.ChapAuthDiscovery {
		return false
	}
	if this.ChapAuthSession != that1.ChapAuthSession {
		return false
	}
	if !this.SecretRef.Equal(that1.SecretRef) {
		return false
	}
	if this.InitiatorName != that1.InitiatorName {
		return false
	}
	return true
}
func (this *KeyToPath) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*KeyToPath)
	if !ok {
		that2, ok := that.(KeyToPath)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Key != that1.Key {
		return false
	}
	if this.Path != that1.Path {
		return false
	}
	if this.Mode != that1.Mode {
		return false
	}
	return true
}
func (this *Lifecycle) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Lifecycle)
	if !ok {
		that2, ok := that.(Lifecycle)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.PostStart.Equal(that1.PostStart) {
		return false
	}
	if !this.PreStop.Equal(that1.PreStop) {
		return false
	}
	return true
}
func (this *LimitRange) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*LimitRange)
	if !ok {
		that2, ok := that.(LimitRange)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Metadata.Equal(that1.Metadata) {
		return false
	}
	if !this.Spec.Equal(that1.Spec) {
		return false
	}
	return true
}
func (this *LimitRangeItem) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*LimitRangeItem)
	if !ok {
		that2, ok := that.(LimitRangeItem)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Type != that1.Type {
		return false
	}
	if len(this.Max) != len(that1.Max) {
		return false
	}
	for i := range this.Max {
		if !this.Max[i].Equal(that1.Max[i]) {
			return false
		}
	}
	if len(this.Min) != len(that1.Min) {
		return false
	}
	for i := range this.Min {
		if !this.Min[i].Equal(that1.Min[i]) {
			return false
		}
	}
	if len(this.Default) != len(that1.Default) {
		return false
	}
	for i := range this.Default {
		if !this.Default[i].Equal(that1.Default[i]) {
			return false
		}
	}
	if len(this.DefaultRequest) != len(that1.DefaultRequest) {
		return false
	}
	for i := range this.DefaultRequest {
		if !this.DefaultRequest[i].Equal(that1.DefaultRequest[i]) {
			return false
		}
	}
	if len(this.MaxLimitRequestRatio) != len(that1.MaxLimitRequestRatio) {
		return false
	}
	for i := range this.MaxLimitRequestRatio {
		if !this.MaxLimitRequestRatio[i].Equal(that1.MaxLimitRequestRatio[i]) {
			return false
		}
	}
	return true
}
func (this *LimitRangeList) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*LimitRangeList)
	if !ok {
		that2, ok := that.(LimitRangeList)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Metadata.Equal(that1.Metadata) {
		return false
	}
	if len(this.Items) != len(that1.Items) {
		return false
	}
	for i := range this.Items {
		if !this.Items[i].Equal(that1.Items[i]) {
			return false
		}
	}
	return true
}
func (this *LimitRangeSpec) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*LimitRangeSpec)
	if !ok {
		that2, ok := that.(LimitRangeSpec)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.Limits) != len(that1.Limits) {
		return false
	}
	for i := range this.Limits {
		if !this.Limits[i].Equal(that1.Limits[i]) {
			return false
		}
	}
	return true
}
func (this *List) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*List)
	if !ok {
		that2, ok := that.(List)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Metadata.Equal(that1.Metadata) {
		return false
	}
	if len(this.Items) != len(that1.Items) {
		return false
	}
	for i := range this.Items {
		if !this.Items[i].Equal(that1.Items[i]) {
			return false
		}
	}
	return true
}
func (this *LoadBalancerIngress) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*LoadBalancerIngress)
	if !ok {
		that2, ok := that.(LoadBalancerIngress)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Ip != that1.Ip {
		return false
	}
	if this.Hostname != that1.Hostname {
		return false
	}
	return true
}
func (this *LoadBalancerStatus) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*LoadBalancerStatus)
	if !ok {
		that2, ok := that.(LoadBalancerStatus)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.Ingress) != len(that1.Ingress) {
		return false
	}
	for i := range this.Ingress {
		if !this.Ingress[i].Equal(that1.Ingress[i]) {
			return false
		}
	}
	return true
}
func (this *LocalObjectReference) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*LocalObjectReference)
	if !ok {
		that2, ok := that.(LocalObjectReference)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	return true
}
func (this *LocalVolumeSource) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*LocalVolumeSource)
	if !ok {
		that2, ok := that.(LocalVolumeSource)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Path != that1.Path {
		return false
	}
	if this.FsType != that1.FsType {
		return false
	}
	return true
}
func (this *NFSVolumeSource) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*NFSVolumeSource)
	if !ok {
		that2, ok := that.(NFSVolumeSource)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Server != that1.Server {
		return false
	}
	if this.Path != that1.Path {
		return false
	}
	if this.ReadOnly != that1.ReadOnly {
		return false
	}
	return true
}
func (this *Namespace) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Namespace)
	if !ok {
		that2, ok := that.(Namespace)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Metadata.Equal(that1.Metadata) {
		return false
	}
	if !this.Spec.Equal(that1.Spec) {
		return false
	}
	if !this.Status.Equal(that1.Status) {
		return false
	}
	return true
}
func (this *NamespaceList) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*NamespaceList)
	if !ok {
		that2, ok := that.(NamespaceList)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Metadata.Equal(that1.Metadata) {
		return false
	}
	if len(this.Items) != len(that1.Items) {
		return false
	}
	for i := range this.Items {
		if !this.Items[i].Equal(that1.Items[i]) {
			return false
		}
	}
	return true
}
func (this *NamespaceSpec) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*NamespaceSpec)
	if !ok {
		that2, ok := that.(NamespaceSpec)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.Finalizers) != len(that1.Finalizers) {
		return false
	}
	for i := range this.Finalizers {
		if this.Finalizers[i] != that1.Finalizers[i] {
			return false
		}
	}
	return true
}
func (this *NamespaceStatus) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*NamespaceStatus)
	if !ok {
		that2, ok := that.(NamespaceStatus)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Phase != that1.Phase {
		return false
	}
	return true
}
func (this *Node) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Node)
	if !ok {
		that2, ok := that.(Node)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Metadata.Equal(that1.Metadata) {
		return false
	}
	if !this.Spec.Equal(that1.Spec) {
		return false
	}
	if !this.Status.Equal(that1.Status) {
		return false
	}
	return true
}
func (this *NodeAddress) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*NodeAddress)
	if !ok {
		that2, ok := that.(NodeAddress)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Type != that1.Type {
		return false
	}
	if this.Address != that1.Address {
		return false
	}
	return true
}
func (this *NodeAffinity) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*NodeAffinity)
	if !ok {
		that2, ok := that.(NodeAffinity)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RequiredDuringSchedulingIgnoredDuringExecution.Equal(that1.RequiredDuringSchedulingIgnoredDuringExecution) {
		return false
	}
	if len(this.PreferredDuringSchedulingIgnoredDuringExecution) != len(that1.PreferredDuringSchedulingIgnoredDuringExecution) {
		return false
	}
	for i := range this.PreferredDuringSchedulingIgnoredDuringExecution {
		if !this.PreferredDuringSchedulingIgnoredDuringExecution[i].Equal(that1.PreferredDuringSchedulingIgnoredDuringExecution[i]) {
			return false
		}
	}
	return true
}
func (this *NodeCondition) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*NodeCondition)
	if !ok {
		that2, ok := that.(NodeCondition)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Type != that1.Type {
		return false
	}
	if this.Status != that1.Status {
		return false
	}
	if !this.LastHeartbeatTime.Equal(that1.LastHeartbeatTime) {
		return false
	}
	if !this.LastTransitionTime.Equal(that1.LastTransitionTime) {
		return false
	}
	if this.Reason != that1.Reason {
		return false
	}
	if this.Message != that1.Message {
		return false
	}
	return true
}
func (this *NodeConfigSource) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*NodeConfigSource)
	if !ok {
		that2, ok := that.(NodeConfigSource)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.ConfigMap.Equal(that1.ConfigMap) {
		return false
	}
	return true
}
func (this *NodeConfigStatus) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*NodeConfigStatus)
	if !ok {
		that2, ok := that.(NodeConfigStatus)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Assigned.Equal(that1.Assigned) {
		return false
	}
	if !this.Active.Equal(that1.Active) {
		return false
	}
	if !this.LastKnownGood.Equal(that1.LastKnownGood) {
		return false
	}
	if this.Error != that1.Error {
		return false
	}
	return true
}
func (this *NodeDaemonEndpoints) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*NodeDaemonEndpoints)
	if !ok {
		that2, ok := that.(NodeDaemonEndpoints)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.KubeletEndpoint.Equal(that1.KubeletEndpoint) {
		return false
	}
	return true
}
func (this *NodeList) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*NodeList)
	if !ok {
		that2, ok := that.(NodeList)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Metadata.Equal(that1.Metadata) {
		return false
	}
	if len(this.Items) != len(that1.Items) {
		return false
	}
	for i := range this.Items {
		if !this.Items[i].Equal(that1.Items[i]) {
			return false
		}
	}
	return true
}
func (this *NodeProxyOptions) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*NodeProxyOptions)
	if !ok {
		that2, ok := that.(NodeProxyOptions)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Path != that1.Path {
		return false
	}
	return true
}
func (this *NodeResources) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*NodeResources)
	if !ok {
		that2, ok := that.(NodeResources)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.Capacity) != len(that1.Capacity) {
		return false
	}
	for i := range this.Capacity {
		if !this.Capacity[i].Equal(that1.Capacity[i]) {
			return false
		}
	}
	return true
}
func (this *NodeSelector) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*NodeSelector)
	if !ok {
		that2, ok := that.(NodeSelector)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.NodeSelectorTerms) != len(that1.NodeSelectorTerms) {
		return false
	}
	for i := range this.NodeSelectorTerms {
		if !this.NodeSelectorTerms[i].Equal(that1.NodeSelectorTerms[i]) {
			return false
		}
	}
	return true
}
func (this *NodeSelectorRequirement) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*NodeSelectorRequirement)
	if !ok {
		that2, ok := that.(NodeSelectorRequirement)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Key != that1.Key {
		return false
	}
	if this.Operator != that1.Operator {
		return false
	}
	if len(this.Values) != len(that1.Values) {
		return false
	}
	for i := range this.Values {
		if this.Values[i] != that1.Values[i] {
			return false
		}
	}
	return true
}
func (this *NodeSelectorTerm) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*NodeSelectorTerm)
	if !ok {
		that2, ok := that.(NodeSelectorTerm)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.MatchExpressions) != len(that1.MatchExpressions) {
		return false
	}
	for i := range this.MatchExpressions {
		if !this.MatchExpressions[i].Equal(that1.MatchExpressions[i]) {
			return false
		}
	}
	if len(this.MatchFields) != len(that1.MatchFields) {
		return false
	}
	for i := range this.MatchFields {
		if !this.MatchFields[i].Equal(that1.MatchFields[i]) {
			return false
		}
	}
	return true
}
func (this *NodeSpec) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*NodeSpec)
	if !ok {
		that2, ok := that.(NodeSpec)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.PodCIDR != that1.PodCIDR {
		return false
	}
	if len(this.PodCIDRs) != len(that1.PodCIDRs) {
		return false
	}
	for i := range this.PodCIDRs {
		if this.PodCIDRs[i] != that1.PodCIDRs[i] {
			return false
		}
	}
	if this.ProviderID != that1.ProviderID {
		return false
	}
	if this.Unschedulable != that1.Unschedulable {
		return false
	}
	if len(this.Taints) != len(that1.Taints) {
		return false
	}
	for i := range this.Taints {
		if !this.Taints[i].Equal(that1.Taints[i]) {
			return false
		}
	}
	if !this.ConfigSource.Equal(that1.ConfigSource) {
		return false
	}
	if this.ExternalID != that1.ExternalID {
		return false
	}
	return true
}
func (this *NodeStatus) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*NodeStatus)
	if !ok {
		that2, ok := that.(NodeStatus)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.Capacity) != len(that1.Capacity) {
		return false
	}
	for i := range this.Capacity {
		if !this.Capacity[i].Equal(that1.Capacity[i]) {
			return false
		}
	}
	if len(this.Allocatable) != len(that1.Allocatable) {
		return false
	}
	for i := range this.Allocatable {
		if !this.Allocatable[i].Equal(that1.Allocatable[i]) {
			return false
		}
	}
	if this.Phase != that1.Phase {
		return false
	}
	if len(this.Conditions) != len(that1.Conditions) {
		return false
	}
	for i := range this.Conditions {
		if !this.Conditions[i].Equal(that1.Conditions[i]) {
			return false
		}
	}
	if len(this.Addresses) != len(that1.Addresses) {
		return false
	}
	for i := range this.Addresses {
		if !this.Addresses[i].Equal(that1.Addresses[i]) {
			return false
		}
	}
	if !this.DaemonEndpoints.Equal(that1.DaemonEndpoints) {
		return false
	}
	if !this.NodeInfo.Equal(that1.NodeInfo) {
		return false
	}
	if len(this.Images) != len(that1.Images) {
		return false
	}
	for i := range this.Images {
		if !this.Images[i].Equal(that1.Images[i]) {
			return false
		}
	}
	if len(this.VolumesInUse) != len(that1.VolumesInUse) {
		return false
	}
	for i := range this.VolumesInUse {
		if this.VolumesInUse[i] != that1.VolumesInUse[i] {
			return false
		}
	}
	if len(this.VolumesAttached) != len(that1.VolumesAttached) {
		return false
	}
	for i := range this.VolumesAttached {
		if !this.VolumesAttached[i].Equal(that1.VolumesAttached[i]) {
			return false
		}
	}
	if !this.Config.Equal(that1.Config) {
		return false
	}
	return true
}
func (this *NodeSystemInfo) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*NodeSystemInfo)
	if !ok {
		that2, ok := that.(NodeSystemInfo)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.MachineID != that1.MachineID {
		return false
	}
	if this.SystemUUID != that1.SystemUUID {
		return false
	}
	if this.BootID != that1.BootID {
		return false
	}
	if this.KernelVersion != that1.KernelVersion {
		return false
	}
	if this.OsImage != that1.OsImage {
		return false
	}
	if this.ContainerRuntimeVersion != that1.ContainerRuntimeVersion {
		return false
	}
	if this.KubeletVersion != that1.KubeletVersion {
		return false
	}
	if this.KubeProxyVersion != that1.KubeProxyVersion {
		return false
	}
	if this.OperatingSystem != that1.OperatingSystem {
		return false
	}
	if this.Architecture != that1.Architecture {
		return false
	}
	return true
}
func (this *ObjectFieldSelector) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ObjectFieldSelector)
	if !ok {
		that2, ok := that.(ObjectFieldSelector)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.ApiVersion != that1.ApiVersion {
		return false
	}
	if this.FieldPath != that1.FieldPath {
		return false
	}
	return true
}
func (this *ObjectReference) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ObjectReference)
	if !ok {
		that2, ok := that.(ObjectReference)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Kind != that1.Kind {
		return false
	}
	if this.Namespace != that1.Namespace {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if this.Uid != that1.Uid {
		return false
	}
	if this.ApiVersion != that1.ApiVersion {
		return false
	}
	if this.ResourceVersion != that1.ResourceVersion {
		return false
	}
	if this.FieldPath != that1.FieldPath {
		return false
	}
	return true
}
func (this *PersistentVolume) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PersistentVolume)
	if !ok {
		that2, ok := that.(PersistentVolume)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Metadata.Equal(that1.Metadata) {
		return false
	}
	if !this.Spec.Equal(that1.Spec) {
		return false
	}
	if !this.Status.Equal(that1.Status) {
		return false
	}
	return true
}
func (this *PersistentVolumeClaim) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PersistentVolumeClaim)
	if !ok {
		that2, ok := that.(PersistentVolumeClaim)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Metadata.Equal(that1.Metadata) {
		return false
	}
	if !this.Spec.Equal(that1.Spec) {
		return false
	}
	if !this.Status.Equal(that1.Status) {
		return false
	}
	return true
}
func (this *PersistentVolumeClaimCondition) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PersistentVolumeClaimCondition)
	if !ok {
		that2, ok := that.(PersistentVolumeClaimCondition)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Type != that1.Type {
		return false
	}
	if this.Status != that1.Status {
		return false
	}
	if !this.LastProbeTime.Equal(that1.LastProbeTime) {
		return false
	}
	if !this.LastTransitionTime.Equal(that1.LastTransitionTime) {
		return false
	}
	if this.Reason != that1.Reason {
		return false
	}
	if this.Message != that1.Message {
		return false
	}
	return true
}
func (this *PersistentVolumeClaimList) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PersistentVolumeClaimList)
	if !ok {
		that2, ok := that.(PersistentVolumeClaimList)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Metadata.Equal(that1.Metadata) {
		return false
	}
	if len(this.Items) != len(that1.Items) {
		return false
	}
	for i := range this.Items {
		if !this.Items[i].Equal(that1.Items[i]) {
			return false
		}
	}
	return true
}
func (this *PersistentVolumeClaimSpec) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PersistentVolumeClaimSpec)
	if !ok {
		that2, ok := that.(PersistentVolumeClaimSpec)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.AccessModes) != len(that1.AccessModes) {
		return false
	}
	for i := range this.AccessModes {
		if this.AccessModes[i] != that1.AccessModes[i] {
			return false
		}
	}
	if !this.Selector.Equal(that1.Selector) {
		return false
	}
	if !this.Resources.Equal(that1.Resources) {
		return false
	}
	if this.VolumeName != that1.VolumeName {
		return false
	}
	if this.StorageClassName != that1.StorageClassName {
		return false
	}
	if this.VolumeMode != that1.VolumeMode {
		return false
	}
	if !this.DataSource.Equal(that1.DataSource) {
		return false
	}
	return true
}
func (this *PersistentVolumeClaimStatus) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PersistentVolumeClaimStatus)
	if !ok {
		that2, ok := that.(PersistentVolumeClaimStatus)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Phase != that1.Phase {
		return false
	}
	if len(this.AccessModes) != len(that1.AccessModes) {
		return false
	}
	for i := range this.AccessModes {
		if this.AccessModes[i] != that1.AccessModes[i] {
			return false
		}
	}
	if len(this.Capacity) != len(that1.Capacity) {
		return false
	}
	for i := range this.Capacity {
		if !this.Capacity[i].Equal(that1.Capacity[i]) {
			return false
		}
	}
	if len(this.Conditions) != len(that1.Conditions) {
		return false
	}
	for i := range this.Conditions {
		if !this.Conditions[i].Equal(that1.Conditions[i]) {
			return false
		}
	}
	return true
}
func (this *PersistentVolumeClaimVolumeSource) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PersistentVolumeClaimVolumeSource)
	if !ok {
		that2, ok := that.(PersistentVolumeClaimVolumeSource)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.ClaimName != that1.ClaimName {
		return false
	}
	if this.ReadOnly != that1.ReadOnly {
		return false
	}
	return true
}
func (this *PersistentVolumeList) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PersistentVolumeList)
	if !ok {
		that2, ok := that.(PersistentVolumeList)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Metadata.Equal(that1.Metadata) {
		return false
	}
	if len(this.Items) != len(that1.Items) {
		return false
	}
	for i := range this.Items {
		if !this.Items[i].Equal(that1.Items[i]) {
			return false
		}
	}
	return true
}
func (this *PersistentVolumeSource) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PersistentVolumeSource)
	if !ok {
		that2, ok := that.(PersistentVolumeSource)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.GcePersistentDisk.Equal(that1.GcePersistentDisk) {
		return false
	}
	if !this.AwsElasticBlockStore.Equal(that1.AwsElasticBlockStore) {
		return false
	}
	if !this.HostPath.Equal(that1.HostPath) {
		return false
	}
	if !this.Glusterfs.Equal(that1.Glusterfs) {
		return false
	}
	if !this.Nfs.Equal(that1.Nfs) {
		return false
	}
	if !this.Rbd.Equal(that1.Rbd) {
		return false
	}
	if !this.Iscsi.Equal(that1.Iscsi) {
		return false
	}
	if !this.Cinder.Equal(that1.Cinder) {
		return false
	}
	if !this.Cephfs.Equal(that1.Cephfs) {
		return false
	}
	if !this.Fc.Equal(that1.Fc) {
		return false
	}
	if !this.Flocker.Equal(that1.Flocker) {
		return false
	}
	if !this.FlexVolume.Equal(that1.FlexVolume) {
		return false
	}
	if !this.AzureFile.Equal(that1.AzureFile) {
		return false
	}
	if !this.VsphereVolume.Equal(that1.VsphereVolume) {
		return false
	}
	if !this.Quobyte.Equal(that1.Quobyte) {
		return false
	}
	if !this.AzureDisk.Equal(that1.AzureDisk) {
		return false
	}
	if !this.PhotonPersistentDisk.Equal(that1.PhotonPersistentDisk) {
		return false
	}
	if !this.PortworxVolume.Equal(that1.PortworxVolume) {
		return false
	}
	if !this.ScaleIO.Equal(that1.ScaleIO) {
		return false
	}
	if !this.Local.Equal(that1.Local) {
		return false
	}
	if !this.Storageos.Equal(that1.Storageos) {
		return false
	}
	if !this.Csi.Equal(that1.Csi) {
		return false
	}
	return true
}
func (this *PersistentVolumeSpec) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PersistentVolumeSpec)
	if !ok {
		that2, ok := that.(PersistentVolumeSpec)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.Capacity) != len(that1.Capacity) {
		return false
	}
	for i := range this.Capacity {
		if !this.Capacity[i].Equal(that1.Capacity[i]) {
			return false
		}
	}
	if !this.PersistentVolumeSource.Equal(that1.PersistentVolumeSource) {
		return false
	}
	if len(this.AccessModes) != len(that1.AccessModes) {
		return false
	}
	for i := range this.AccessModes {
		if this.AccessModes[i] != that1.AccessModes[i] {
			return false
		}
	}
	if !this.ClaimRef.Equal(that1.ClaimRef) {
		return false
	}
	if this.PersistentVolumeReclaimPolicy != that1.PersistentVolumeReclaimPolicy {
		return false
	}
	if this.StorageClassName != that1.StorageClassName {
		return false
	}
	if len(this.MountOptions) != len(that1.MountOptions) {
		return false
	}
	for i := range this.MountOptions {
		if this.MountOptions[i] != that1.MountOptions[i] {
			return false
		}
	}
	if this.VolumeMode != that1.VolumeMode {
		return false
	}
	if !this.NodeAffinity.Equal(that1.NodeAffinity) {
		return false
	}
	return true
}
func (this *PersistentVolumeStatus) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PersistentVolumeStatus)
	if !ok {
		that2, ok := that.(PersistentVolumeStatus)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Phase != that1.Phase {
		return false
	}
	if this.Message != that1.Message {
		return false
	}
	if this.Reason != that1.Reason {
		return false
	}
	return true
}
func (this *PhotonPersistentDiskVolumeSource) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PhotonPersistentDiskVolumeSource)
	if !ok {
		that2, ok := that.(PhotonPersistentDiskVolumeSource)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.PdID != that1.PdID {
		return false
	}
	if this.FsType != that1.FsType {
		return false
	}
	return true
}
func (this *Pod) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Pod)
	if !ok {
		that2, ok := that.(Pod)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Metadata.Equal(that1.Metadata) {
		return false
	}
	if !this.Spec.Equal(that1.Spec) {
		return false
	}
	if !this.Status.Equal(that1.Status) {
		return false
	}
	return true
}
func (this *PodAffinity) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PodAffinity)
	if !ok {
		that2, ok := that.(PodAffinity)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.RequiredDuringSchedulingIgnoredDuringExecution) != len(that1.RequiredDuringSchedulingIgnoredDuringExecution) {
		return false
	}
	for i := range this.RequiredDuringSchedulingIgnoredDuringExecution {
		if !this.RequiredDuringSchedulingIgnoredDuringExecution[i].Equal(that1.RequiredDuringSchedulingIgnoredDuringExecution[i]) {
			return false
		}
	}
	if len(this.PreferredDuringSchedulingIgnoredDuringExecution) != len(that1.PreferredDuringSchedulingIgnoredDuringExecution) {
		return false
	}
	for i := range this.PreferredDuringSchedulingIgnoredDuringExecution {
		if !this.PreferredDuringSchedulingIgnoredDuringExecution[i].Equal(that1.PreferredDuringSchedulingIgnoredDuringExecution[i]) {
			return false
		}
	}
	return true
}
func (this *PodAffinityTerm) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PodAffinityTerm)
	if !ok {
		that2, ok := that.(PodAffinityTerm)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.LabelSelector.Equal(that1.LabelSelector) {
		return false
	}
	if len(this.Namespaces) != len(that1.Namespaces) {
		return false
	}
	for i := range this.Namespaces {
		if this.Namespaces[i] != that1.Namespaces[i] {
			return false
		}
	}
	if this.TopologyKey != that1.TopologyKey {
		return false
	}
	return true
}
func (this *PodAntiAffinity) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PodAntiAffinity)
	if !ok {
		that2, ok := that.(PodAntiAffinity)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.RequiredDuringSchedulingIgnoredDuringExecution) != len(that1.RequiredDuringSchedulingIgnoredDuringExecution) {
		return false
	}
	for i := range this.RequiredDuringSchedulingIgnoredDuringExecution {
		if !this.RequiredDuringSchedulingIgnoredDuringExecution[i].Equal(that1.RequiredDuringSchedulingIgnoredDuringExecution[i]) {
			return false
		}
	}
	if len(this.PreferredDuringSchedulingIgnoredDuringExecution) != len(that1.PreferredDuringSchedulingIgnoredDuringExecution) {
		return false
	}
	for i := range this.PreferredDuringSchedulingIgnoredDuringExecution {
		if !this.PreferredDuringSchedulingIgnoredDuringExecution[i].Equal(that1.PreferredDuringSchedulingIgnoredDuringExecution[i]) {
			return false
		}
	}
	return true
}
func (this *PodAttachOptions) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PodAttachOptions)
	if !ok {
		that2, ok := that.(PodAttachOptions)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Stdin != that1.Stdin {
		return false
	}
	if this.Stdout != that1.Stdout {
		return false
	}
	if this.Stderr != that1.Stderr {
		return false
	}
	if this.Tty != that1.Tty {
		return false
	}
	if this.Container != that1.Container {
		return false
	}
	return true
}
func (this *PodCondition) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PodCondition)
	if !ok {
		that2, ok := that.(PodCondition)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Type != that1.Type {
		return false
	}
	if this.Status != that1.Status {
		return false
	}
	if !this.LastProbeTime.Equal(that1.LastProbeTime) {
		return false
	}
	if !this.LastTransitionTime.Equal(that1.LastTransitionTime) {
		return false
	}
	if this.Reason != that1.Reason {
		return false
	}
	if this.Message != that1.Message {
		return false
	}
	return true
}
func (this *PodDNSConfig) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PodDNSConfig)
	if !ok {
		that2, ok := that.(PodDNSConfig)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.Nameservers) != len(that1.Nameservers) {
		return false
	}
	for i := range this.Nameservers {
		if this.Nameservers[i] != that1.Nameservers[i] {
			return false
		}
	}
	if len(this.Searches) != len(that1.Searches) {
		return false
	}
	for i := range this.Searches {
		if this.Searches[i] != that1.Searches[i] {
			return false
		}
	}
	if len(this.Options) != len(that1.Options) {
		return false
	}
	for i := range this.Options {
		if !this.Options[i].Equal(that1.Options[i]) {
			return false
		}
	}
	return true
}
func (this *PodDNSConfigOption) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PodDNSConfigOption)
	if !ok {
		that2, ok := that.(PodDNSConfigOption)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if this.Value != that1.Value {
		return false
	}
	return true
}
func (this *PodExecOptions) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PodExecOptions)
	if !ok {
		that2, ok := that.(PodExecOptions)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Stdin != that1.Stdin {
		return false
	}
	if this.Stdout != that1.Stdout {
		return false
	}
	if this.Stderr != that1.Stderr {
		return false
	}
	if this.Tty != that1.Tty {
		return false
	}
	if this.Container != that1.Container {
		return false
	}
	if len(this.Command) != len(that1.Command) {
		return false
	}
	for i := range this.Command {
		if this.Command[i] != that1.Command[i] {
			return false
		}
	}
	return true
}
func (this *PodIP) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PodIP)
	if !ok {
		that2, ok := that.(PodIP)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Ip != that1.Ip {
		return false
	}
	return true
}
func (this *PodList) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PodList)
	if !ok {
		that2, ok := that.(PodList)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Metadata.Equal(that1.Metadata) {
		return false
	}
	if len(this.Items) != len(that1.Items) {
		return false
	}
	for i := range this.Items {
		if !this.Items[i].Equal(that1.Items[i]) {
			return false
		}
	}
	return true
}
func (this *PodLogOptions) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PodLogOptions)
	if !ok {
		that2, ok := that.(PodLogOptions)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Container != that1.Container {
		return false
	}
	if this.Follow != that1.Follow {
		return false
	}
	if this.Previous != that1.Previous {
		return false
	}
	if this.SinceSeconds != that1.SinceSeconds {
		return false
	}
	if !this.SinceTime.Equal(that1.SinceTime) {
		return false
	}
	if this.Timestamps != that1.Timestamps {
		return false
	}
	if this.TailLines != that1.TailLines {
		return false
	}
	if this.LimitBytes != that1.LimitBytes {
		return false
	}
	return true
}
func (this *PodPortForwardOptions) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PodPortForwardOptions)
	if !ok {
		that2, ok := that.(PodPortForwardOptions)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.Ports) != len(that1.Ports) {
		return false
	}
	for i := range this.Ports {
		if this.Ports[i] != that1.Ports[i] {
			return false
		}
	}
	return true
}
func (this *PodProxyOptions) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PodProxyOptions)
	if !ok {
		that2, ok := that.(PodProxyOptions)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Path != that1.Path {
		return false
	}
	return true
}
func (this *PodReadinessGate) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PodReadinessGate)
	if !ok {
		that2, ok := that.(PodReadinessGate)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.ConditionType != that1.ConditionType {
		return false
	}
	return true
}
func (this *PodSecurityContext) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PodSecurityContext)
	if !ok {
		that2, ok := that.(PodSecurityContext)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.SeLinuxOptions.Equal(that1.SeLinuxOptions) {
		return false
	}
	if !this.WindowsOptions.Equal(that1.WindowsOptions) {
		return false
	}
	if this.RunAsUser != that1.RunAsUser {
		return false
	}
	if this.RunAsGroup != that1.RunAsGroup {
		return false
	}
	if this.RunAsNonRoot != that1.RunAsNonRoot {
		return false
	}
	if len(this.SupplementalGroups) != len(that1.SupplementalGroups) {
		return false
	}
	for i := range this.SupplementalGroups {
		if this.SupplementalGroups[i] != that1.SupplementalGroups[i] {
			return false
		}
	}
	if this.FsGroup != that1.FsGroup {
		return false
	}
	if len(this.Sysctls) != len(that1.Sysctls) {
		return false
	}
	for i := range this.Sysctls {
		if !this.Sysctls[i].Equal(that1.Sysctls[i]) {
			return false
		}
	}
	return true
}
func (this *PodSignature) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PodSignature)
	if !ok {
		that2, ok := that.(PodSignature)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.PodController.Equal(that1.PodController) {
		return false
	}
	return true
}
func (this *PodSpec) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PodSpec)
	if !ok {
		that2, ok := that.(PodSpec)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.Volumes) != len(that1.Volumes) {
		return false
	}
	for i := range this.Volumes {
		if !this.Volumes[i].Equal(that1.Volumes[i]) {
			return false
		}
	}
	if len(this.InitContainers) != len(that1.InitContainers) {
		return false
	}
	for i := range this.InitContainers {
		if !this.InitContainers[i].Equal(that1.InitContainers[i]) {
			return false
		}
	}
	if len(this.Containers) != len(that1.Containers) {
		return false
	}
	for i := range this.Containers {
		if !this.Containers[i].Equal(that1.Containers[i]) {
			return false
		}
	}
	if len(this.EphemeralContainers) != len(that1.EphemeralContainers) {
		return false
	}
	for i := range this.EphemeralContainers {
		if !this.EphemeralContainers[i].Equal(that1.EphemeralContainers[i]) {
			return false
		}
	}
	if this.RestartPolicy != that1.RestartPolicy {
		return false
	}
	if this.TerminationGracePeriodSeconds != that1.TerminationGracePeriodSeconds {
		return false
	}
	if this.ActiveDeadlineSeconds != that1.ActiveDeadlineSeconds {
		return false
	}
	if this.DnsPolicy != that1.DnsPolicy {
		return false
	}
	if len(this.NodeSelector) != len(that1.NodeSelector) {
		return false
	}
	for i := range this.NodeSelector {
		if this.NodeSelector[i] != that1.NodeSelector[i] {
			return false
		}
	}
	if this.ServiceAccountName != that1.ServiceAccountName {
		return false
	}
	if this.ServiceAccount != that1.ServiceAccount {
		return false
	}
	if this.AutomountServiceAccountToken != that1.AutomountServiceAccountToken {
		return false
	}
	if this.NodeName != that1.NodeName {
		return false
	}
	if this.HostNetwork != that1.HostNetwork {
		return false
	}
	if this.HostPID != that1.HostPID {
		return false
	}
	if this.HostIPC != that1.HostIPC {
		return false
	}
	if this.ShareProcessNamespace != that1.ShareProcessNamespace {
		return false
	}
	if !this.SecurityContext.Equal(that1.SecurityContext) {
		return false
	}
	if len(this.ImagePullSecrets) != len(that1.ImagePullSecrets) {
		return false
	}
	for i := range this.ImagePullSecrets {
		if !this.ImagePullSecrets[i].Equal(that1.ImagePullSecrets[i]) {
			return false
		}
	}
	if this.Hostname != that1.Hostname {
		return false
	}
	if this.Subdomain != that1.Subdomain {
		return false
	}
	if !this.Affinity.Equal(that1.Affinity) {
		return false
	}
	if this.SchedulerName != that1.SchedulerName {
		return false
	}
	if len(this.Tolerations) != len(that1.Tolerations) {
		return false
	}
	for i := range this.Tolerations {
		if !this.Tolerations[i].Equal(that1.Tolerations[i]) {
			return false
		}
	}
	if len(this.HostAliases) != len(that1.HostAliases) {
		return false
	}
	for i := range this.HostAliases {
		if !this.HostAliases[i].Equal(that1.HostAliases[i]) {
			return false
		}
	}
	if this.PriorityClassName != that1.PriorityClassName {
		return false
	}
	if this.Priority != that1.Priority {
		return false
	}
	if !this.DnsConfig.Equal(that1.DnsConfig) {
		return false
	}
	if len(this.ReadinessGates) != len(that1.ReadinessGates) {
		return false
	}
	for i := range this.ReadinessGates {
		if !this.ReadinessGates[i].Equal(that1.ReadinessGates[i]) {
			return false
		}
	}
	if this.RuntimeClassName != that1.RuntimeClassName {
		return false
	}
	if this.EnableServiceLinks != that1.EnableServiceLinks {
		return false
	}
	if this.PreemptionPolicy != that1.PreemptionPolicy {
		return false
	}
	if len(this.Overhead) != len(that1.Overhead) {
		return false
	}
	for i := range this.Overhead {
		if !this.Overhead[i].Equal(that1.Overhead[i]) {
			return false
		}
	}
	if len(this.TopologySpreadConstraints) != len(that1.TopologySpreadConstraints) {
		return false
	}
	for i := range this.TopologySpreadConstraints {
		if !this.TopologySpreadConstraints[i].Equal(that1.TopologySpreadConstraints[i]) {
			return false
		}
	}
	return true
}
func (this *PodStatus) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PodStatus)
	if !ok {
		that2, ok := that.(PodStatus)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Phase != that1.Phase {
		return false
	}
	if len(this.Conditions) != len(that1.Conditions) {
		return false
	}
	for i := range this.Conditions {
		if !this.Conditions[i].Equal(that1.Conditions[i]) {
			return false
		}
	}
	if this.Message != that1.Message {
		return false
	}
	if this.Reason != that1.Reason {
		return false
	}
	if this.NominatedNodeName != that1.NominatedNodeName {
		return false
	}
	if this.HostIP != that1.HostIP {
		return false
	}
	if this.PodIP != that1.PodIP {
		return false
	}
	if len(this.PodIPs) != len(that1.PodIPs) {
		return false
	}
	for i := range this.PodIPs {
		if !this.PodIPs[i].Equal(that1.PodIPs[i]) {
			return false
		}
	}
	if !this.StartTime.Equal(that1.StartTime) {
		return false
	}
	if len(this.InitContainerStatuses) != len(that1.InitContainerStatuses) {
		return false
	}
	for i := range this.InitContainerStatuses {
		if !this.InitContainerStatuses[i].Equal(that1.InitContainerStatuses[i]) {
			return false
		}
	}
	if len(this.ContainerStatuses) != len(that1.ContainerStatuses) {
		return false
	}
	for i := range this.ContainerStatuses {
		if !this.ContainerStatuses[i].Equal(that1.ContainerStatuses[i]) {
			return false
		}
	}
	if this.QosClass != that1.QosClass {
		return false
	}
	if len(this.EphemeralContainerStatuses) != len(that1.EphemeralContainerStatuses) {
		return false
	}
	for i := range this.EphemeralContainerStatuses {
		if !this.EphemeralContainerStatuses[i].Equal(that1.EphemeralContainerStatuses[i]) {
			return false
		}
	}
	return true
}
func (this *PodStatusResult) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PodStatusResult)
	if !ok {
		that2, ok := that.(PodStatusResult)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Metadata.Equal(that1.Metadata) {
		return false
	}
	if !this.Status.Equal(that1.Status) {
		return false
	}
	return true
}
func (this *PodTemplate) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PodTemplate)
	if !ok {
		that2, ok := that.(PodTemplate)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Metadata.Equal(that1.Metadata) {
		return false
	}
	if !this.Template.Equal(that1.Template) {
		return false
	}
	return true
}
func (this *PodTemplateList) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PodTemplateList)
	if !ok {
		that2, ok := that.(PodTemplateList)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Metadata.Equal(that1.Metadata) {
		return false
	}
	if len(this.Items) != len(that1.Items) {
		return false
	}
	for i := range this.Items {
		if !this.Items[i].Equal(that1.Items[i]) {
			return false
		}
	}
	return true
}
func (this *PodTemplateSpec) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PodTemplateSpec)
	if !ok {
		that2, ok := that.(PodTemplateSpec)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Metadata.Equal(that1.Metadata) {
		return false
	}
	if !this.Spec.Equal(that1.Spec) {
		return false
	}
	return true
}
func (this *PortworxVolumeSource) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PortworxVolumeSource)
	if !ok {
		that2, ok := that.(PortworxVolumeSource)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.VolumeID != that1.VolumeID {
		return false
	}
	if this.FsType != that1.FsType {
		return false
	}
	if this.ReadOnly != that1.ReadOnly {
		return false
	}
	return true
}
func (this *Preconditions) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Preconditions)
	if !ok {
		that2, ok := that.(Preconditions)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Uid != that1.Uid {
		return false
	}
	return true
}
func (this *PreferAvoidPodsEntry) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PreferAvoidPodsEntry)
	if !ok {
		that2, ok := that.(PreferAvoidPodsEntry)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.PodSignature.Equal(that1.PodSignature) {
		return false
	}
	if !this.EvictionTime.Equal(that1.EvictionTime) {
		return false
	}
	if this.Reason != that1.Reason {
		return false
	}
	if this.Message != that1.Message {
		return false
	}
	return true
}
func (this *PreferredSchedulingTerm) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PreferredSchedulingTerm)
	if !ok {
		that2, ok := that.(PreferredSchedulingTerm)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Weight != that1.Weight {
		return false
	}
	if !this.Preference.Equal(that1.Preference) {
		return false
	}
	return true
}
func (this *Probe) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Probe)
	if !ok {
		that2, ok := that.(Probe)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Handler.Equal(that1.Handler) {
		return false
	}
	if this.InitialDelaySeconds != that1.InitialDelaySeconds {
		return false
	}
	if this.TimeoutSeconds != that1.TimeoutSeconds {
		return false
	}
	if this.PeriodSeconds != that1.PeriodSeconds {
		return false
	}
	if this.SuccessThreshold != that1.SuccessThreshold {
		return false
	}
	if this.FailureThreshold != that1.FailureThreshold {
		return false
	}
	return true
}
func (this *ProjectedVolumeSource) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ProjectedVolumeSource)
	if !ok {
		that2, ok := that.(ProjectedVolumeSource)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.Sources) != len(that1.Sources) {
		return false
	}
	for i := range this.Sources {
		if !this.Sources[i].Equal(that1.Sources[i]) {
			return false
		}
	}
	if this.DefaultMode != that1.DefaultMode {
		return false
	}
	return true
}
func (this *QuobyteVolumeSource) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*QuobyteVolumeSource)
	if !ok {
		that2, ok := that.(QuobyteVolumeSource)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Registry != that1.Registry {
		return false
	}
	if this.Volume != that1.Volume {
		return false
	}
	if this.ReadOnly != that1.ReadOnly {
		return false
	}
	if this.User != that1.User {
		return false
	}
	if this.Group != that1.Group {
		return false
	}
	if this.Tenant != that1.Tenant {
		return false
	}
	return true
}
func (this *RBDPersistentVolumeSource) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RBDPersistentVolumeSource)
	if !ok {
		that2, ok := that.(RBDPersistentVolumeSource)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.Monitors) != len(that1.Monitors) {
		return false
	}
	for i := range this.Monitors {
		if this.Monitors[i] != that1.Monitors[i] {
			return false
		}
	}
	if this.Image != that1.Image {
		return false
	}
	if this.FsType != that1.FsType {
		return false
	}
	if this.Pool != that1.Pool {
		return false
	}
	if this.User != that1.User {
		return false
	}
	if this.Keyring != that1.Keyring {
		return false
	}
	if !this.SecretRef.Equal(that1.SecretRef) {
		return false
	}
	if this.ReadOnly != that1.ReadOnly {
		return false
	}
	return true
}
func (this *RBDVolumeSource) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RBDVolumeSource)
	if !ok {
		that2, ok := that.(RBDVolumeSource)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.Monitors) != len(that1.Monitors) {
		return false
	}
	for i := range this.Monitors {
		if this.Monitors[i] != that1.Monitors[i] {
			return false
		}
	}
	if this.Image != that1.Image {
		return false
	}
	if this.FsType != that1.FsType {
		return false
	}
	if this.Pool != that1.Pool {
		return false
	}
	if this.User != that1.User {
		return false
	}
	if this.Keyring != that1.Keyring {
		return false
	}
	if !this.SecretRef.Equal(that1.SecretRef) {
		return false
	}
	if this.ReadOnly != that1.ReadOnly {
		return false
	}
	return true
}
func (this *RangeAllocation) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RangeAllocation)
	if !ok {
		that2, ok := that.(RangeAllocation)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Metadata.Equal(that1.Metadata) {
		return false
	}
	if this.Range != that1.Range {
		return false
	}
	if !bytes.Equal(this.Data, that1.Data) {
		return false
	}
	return true
}
func (this *ReplicationController) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ReplicationController)
	if !ok {
		that2, ok := that.(ReplicationController)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Metadata.Equal(that1.Metadata) {
		return false
	}
	if !this.Spec.Equal(that1.Spec) {
		return false
	}
	if !this.Status.Equal(that1.Status) {
		return false
	}
	return true
}
func (this *ReplicationControllerCondition) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ReplicationControllerCondition)
	if !ok {
		that2, ok := that.(ReplicationControllerCondition)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Type != that1.Type {
		return false
	}
	if this.Status != that1.Status {
		return false
	}
	if !this.LastTransitionTime.Equal(that1.LastTransitionTime) {
		return false
	}
	if this.Reason != that1.Reason {
		return false
	}
	if this.Message != that1.Message {
		return false
	}
	return true
}
func (this *ReplicationControllerList) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ReplicationControllerList)
	if !ok {
		that2, ok := that.(ReplicationControllerList)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Metadata.Equal(that1.Metadata) {
		return false
	}
	if len(this.Items) != len(that1.Items) {
		return false
	}
	for i := range this.Items {
		if !this.Items[i].Equal(that1.Items[i]) {
			return false
		}
	}
	return true
}
func (this *ReplicationControllerSpec) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ReplicationControllerSpec)
	if !ok {
		that2, ok := that.(ReplicationControllerSpec)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Replicas != that1.Replicas {
		return false
	}
	if this.MinReadySeconds != that1.MinReadySeconds {
		return false
	}
	if len(this.Selector) != len(that1.Selector) {
		return false
	}
	for i := range this.Selector {
		if this.Selector[i] != that1.Selector[i] {
			return false
		}
	}
	if !this.Template.Equal(that1.Template) {
		return false
	}
	return true
}
func (this *ReplicationControllerStatus) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ReplicationControllerStatus)
	if !ok {
		that2, ok := that.(ReplicationControllerStatus)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Replicas != that1.Replicas {
		return false
	}
	if this.FullyLabeledReplicas != that1.FullyLabeledReplicas {
		return false
	}
	if this.ReadyReplicas != that1.ReadyReplicas {
		return false
	}
	if this.AvailableReplicas != that1.AvailableReplicas {
		return false
	}
	if this.ObservedGeneration != that1.ObservedGeneration {
		return false
	}
	if len(this.Conditions) != len(that1.Conditions) {
		return false
	}
	for i := range this.Conditions {
		if !this.Conditions[i].Equal(that1.Conditions[i]) {
			return false
		}
	}
	return true
}
func (this *ResourceFieldSelector) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ResourceFieldSelector)
	if !ok {
		that2, ok := that.(ResourceFieldSelector)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.ContainerName != that1.ContainerName {
		return false
	}
	if this.Resource != that1.Resource {
		return false
	}
	if !this.Divisor.Equal(that1.Divisor) {
		return false
	}
	return true
}
func (this *ResourceQuota) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ResourceQuota)
	if !ok {
		that2, ok := that.(ResourceQuota)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Metadata.Equal(that1.Metadata) {
		return false
	}
	if !this.Spec.Equal(that1.Spec) {
		return false
	}
	if !this.Status.Equal(that1.Status) {
		return false
	}
	return true
}
func (this *ResourceQuotaList) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ResourceQuotaList)
	if !ok {
		that2, ok := that.(ResourceQuotaList)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Metadata.Equal(that1.Metadata) {
		return false
	}
	if len(this.Items) != len(that1.Items) {
		return false
	}
	for i := range this.Items {
		if !this.Items[i].Equal(that1.Items[i]) {
			return false
		}
	}
	return true
}
func (this *ResourceQuotaSpec) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ResourceQuotaSpec)
	if !ok {
		that2, ok := that.(ResourceQuotaSpec)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.Hard) != len(that1.Hard) {
		return false
	}
	for i := range this.Hard {
		if !this.Hard[i].Equal(that1.Hard[i]) {
			return false
		}
	}
	if len(this.Scopes) != len(that1.Scopes) {
		return false
	}
	for i := range this.Scopes {
		if this.Scopes[i] != that1.Scopes[i] {
			return false
		}
	}
	if !this.ScopeSelector.Equal(that1.ScopeSelector) {
		return false
	}
	return true
}
func (this *ResourceQuotaStatus) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ResourceQuotaStatus)
	if !ok {
		that2, ok := that.(ResourceQuotaStatus)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.Hard) != len(that1.Hard) {
		return false
	}
	for i := range this.Hard {
		if !this.Hard[i].Equal(that1.Hard[i]) {
			return false
		}
	}
	if len(this.Used) != len(that1.Used) {
		return false
	}
	for i := range this.Used {
		if !this.Used[i].Equal(that1.Used[i]) {
			return false
		}
	}
	return true
}
func (this *ResourceRequirements) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ResourceRequirements)
	if !ok {
		that2, ok := that.(ResourceRequirements)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.Limits) != len(that1.Limits) {
		return false
	}
	for i := range this.Limits {
		if !this.Limits[i].Equal(that1.Limits[i]) {
			return false
		}
	}
	if len(this.Requests) != len(that1.Requests) {
		return false
	}
	for i := range this.Requests {
		if !this.Requests[i].Equal(that1.Requests[i]) {
			return false
		}
	}
	return true
}
func (this *SELinuxOptions) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*SELinuxOptions)
	if !ok {
		that2, ok := that.(SELinuxOptions)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.User != that1.User {
		return false
	}
	if this.Role != that1.Role {
		return false
	}
	if this.Type != that1.Type {
		return false
	}
	if this.Level != that1.Level {
		return false
	}
	return true
}
func (this *ScaleIOPersistentVolumeSource) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ScaleIOPersistentVolumeSource)
	if !ok {
		that2, ok := that.(ScaleIOPersistentVolumeSource)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Gateway != that1.Gateway {
		return false
	}
	if this.System != that1.System {
		return false
	}
	if !this.SecretRef.Equal(that1.SecretRef) {
		return false
	}
	if this.SslEnabled != that1.SslEnabled {
		return false
	}
	if this.ProtectionDomain != that1.ProtectionDomain {
		return false
	}
	if this.StoragePool != that1.StoragePool {
		return false
	}
	if this.StorageMode != that1.StorageMode {
		return false
	}
	if this.VolumeName != that1.VolumeName {
		return false
	}
	if this.FsType != that1.FsType {
		return false
	}
	if this.ReadOnly != that1.ReadOnly {
		return false
	}
	return true
}
func (this *ScaleIOVolumeSource) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ScaleIOVolumeSource)
	if !ok {
		that2, ok := that.(ScaleIOVolumeSource)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Gateway != that1.Gateway {
		return false
	}
	if this.System != that1.System {
		return false
	}
	if !this.SecretRef.Equal(that1.SecretRef) {
		return false
	}
	if this.SslEnabled != that1.SslEnabled {
		return false
	}
	if this.ProtectionDomain != that1.ProtectionDomain {
		return false
	}
	if this.StoragePool != that1.StoragePool {
		return false
	}
	if this.StorageMode != that1.StorageMode {
		return false
	}
	if this.VolumeName != that1.VolumeName {
		return false
	}
	if this.FsType != that1.FsType {
		return false
	}
	if this.ReadOnly != that1.ReadOnly {
		return false
	}
	return true
}
func (this *ScopeSelector) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ScopeSelector)
	if !ok {
		that2, ok := that.(ScopeSelector)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.MatchExpressions) != len(that1.MatchExpressions) {
		return false
	}
	for i := range this.MatchExpressions {
		if !this.MatchExpressions[i].Equal(that1.MatchExpressions[i]) {
			return false
		}
	}
	return true
}
func (this *ScopedResourceSelectorRequirement) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ScopedResourceSelectorRequirement)
	if !ok {
		that2, ok := that.(ScopedResourceSelectorRequirement)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.ScopeName != that1.ScopeName {
		return false
	}
	if this.Operator != that1.Operator {
		return false
	}
	if len(this.Values) != len(that1.Values) {
		return false
	}
	for i := range this.Values {
		if this.Values[i] != that1.Values[i] {
			return false
		}
	}
	return true
}
func (this *Secret) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Secret)
	if !ok {
		that2, ok := that.(Secret)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Metadata.Equal(that1.Metadata) {
		return false
	}
	if len(this.Data) != len(that1.Data) {
		return false
	}
	for i := range this.Data {
		if !bytes.Equal(this.Data[i], that1.Data[i]) {
			return false
		}
	}
	if len(this.StringData) != len(that1.StringData) {
		return false
	}
	for i := range this.StringData {
		if this.StringData[i] != that1.StringData[i] {
			return false
		}
	}
	if this.Type != that1.Type {
		return false
	}
	return true
}
func (this *SecretEnvSource) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*SecretEnvSource)
	if !ok {
		that2, ok := that.(SecretEnvSource)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.LocalObjectReference.Equal(that1.LocalObjectReference) {
		return false
	}
	if this.Optional != that1.Optional {
		return false
	}
	return true
}
func (this *SecretKeySelector) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*SecretKeySelector)
	if !ok {
		that2, ok := that.(SecretKeySelector)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.LocalObjectReference.Equal(that1.LocalObjectReference) {
		return false
	}
	if this.Key != that1.Key {
		return false
	}
	if this.Optional != that1.Optional {
		return false
	}
	return true
}
func (this *SecretList) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*SecretList)
	if !ok {
		that2, ok := that.(SecretList)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Metadata.Equal(that1.Metadata) {
		return false
	}
	if len(this.Items) != len(that1.Items) {
		return false
	}
	for i := range this.Items {
		if !this.Items[i].Equal(that1.Items[i]) {
			return false
		}
	}
	return true
}
func (this *SecretProjection) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*SecretProjection)
	if !ok {
		that2, ok := that.(SecretProjection)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.LocalObjectReference.Equal(that1.LocalObjectReference) {
		return false
	}
	if len(this.Items) != len(that1.Items) {
		return false
	}
	for i := range this.Items {
		if !this.Items[i].Equal(that1.Items[i]) {
			return false
		}
	}
	if this.Optional != that1.Optional {
		return false
	}
	return true
}
func (this *SecretReference) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*SecretReference)
	if !ok {
		that2, ok := that.(SecretReference)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if this.Namespace != that1.Namespace {
		return false
	}
	return true
}
func (this *SecretVolumeSource) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*SecretVolumeSource)
	if !ok {
		that2, ok := that.(SecretVolumeSource)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.SecretName != that1.SecretName {
		return false
	}
	if len(this.Items) != len(that1.Items) {
		return false
	}
	for i := range this.Items {
		if !this.Items[i].Equal(that1.Items[i]) {
			return false
		}
	}
	if this.DefaultMode != that1.DefaultMode {
		return false
	}
	if this.Optional != that1.Optional {
		return false
	}
	return true
}
func (this *SecurityContext) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*SecurityContext)
	if !ok {
		that2, ok := that.(SecurityContext)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Capabilities.Equal(that1.Capabilities) {
		return false
	}
	if this.Privileged != that1.Privileged {
		return false
	}
	if !this.SeLinuxOptions.Equal(that1.SeLinuxOptions) {
		return false
	}
	if !this.WindowsOptions.Equal(that1.WindowsOptions) {
		return false
	}
	if this.RunAsUser != that1.RunAsUser {
		return false
	}
	if this.RunAsGroup != that1.RunAsGroup {
		return false
	}
	if this.RunAsNonRoot != that1.RunAsNonRoot {
		return false
	}
	if this.ReadOnlyRootFilesystem != that1.ReadOnlyRootFilesystem {
		return false
	}
	if this.AllowPrivilegeEscalation != that1.AllowPrivilegeEscalation {
		return false
	}
	if this.ProcMount != that1.ProcMount {
		return false
	}
	return true
}
func (this *SerializedReference) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*SerializedReference)
	if !ok {
		that2, ok := that.(SerializedReference)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Reference.Equal(that1.Reference) {
		return false
	}
	return true
}
func (this *Service) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Service)
	if !ok {
		that2, ok := that.(Service)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Metadata.Equal(that1.Metadata) {
		return false
	}
	if !this.Spec.Equal(that1.Spec) {
		return false
	}
	if !this.Status.Equal(that1.Status) {
		return false
	}
	return true
}
func (this *ServiceAccount) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ServiceAccount)
	if !ok {
		that2, ok := that.(ServiceAccount)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Metadata.Equal(that1.Metadata) {
		return false
	}
	if len(this.Secrets) != len(that1.Secrets) {
		return false
	}
	for i := range this.Secrets {
		if !this.Secrets[i].Equal(that1.Secrets[i]) {
			return false
		}
	}
	if len(this.ImagePullSecrets) != len(that1.ImagePullSecrets) {
		return false
	}
	for i := range this.ImagePullSecrets {
		if !this.ImagePullSecrets[i].Equal(that1.ImagePullSecrets[i]) {
			return false
		}
	}
	if this.AutomountServiceAccountToken != that1.AutomountServiceAccountToken {
		return false
	}
	return true
}
func (this *ServiceAccountList) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ServiceAccountList)
	if !ok {
		that2, ok := that.(ServiceAccountList)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Metadata.Equal(that1.Metadata) {
		return false
	}
	if len(this.Items) != len(that1.Items) {
		return false
	}
	for i := range this.Items {
		if !this.Items[i].Equal(that1.Items[i]) {
			return false
		}
	}
	return true
}
func (this *ServiceAccountTokenProjection) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ServiceAccountTokenProjection)
	if !ok {
		that2, ok := that.(ServiceAccountTokenProjection)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Audience != that1.Audience {
		return false
	}
	if this.ExpirationSeconds != that1.ExpirationSeconds {
		return false
	}
	if this.Path != that1.Path {
		return false
	}
	return true
}
func (this *ServiceList) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ServiceList)
	if !ok {
		that2, ok := that.(ServiceList)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Metadata.Equal(that1.Metadata) {
		return false
	}
	if len(this.Items) != len(that1.Items) {
		return false
	}
	for i := range this.Items {
		if !this.Items[i].Equal(that1.Items[i]) {
			return false
		}
	}
	return true
}
func (this *ServicePort) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ServicePort)
	if !ok {
		that2, ok := that.(ServicePort)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if this.Protocol != that1.Protocol {
		return false
	}
	if this.Port != that1.Port {
		return false
	}
	if !this.TargetPort.Equal(that1.TargetPort) {
		return false
	}
	if this.NodePort != that1.NodePort {
		return false
	}
	return true
}
func (this *ServiceProxyOptions) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ServiceProxyOptions)
	if !ok {
		that2, ok := that.(ServiceProxyOptions)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Path != that1.Path {
		return false
	}
	return true
}
func (this *ServiceSpec) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ServiceSpec)
	if !ok {
		that2, ok := that.(ServiceSpec)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.Ports) != len(that1.Ports) {
		return false
	}
	for i := range this.Ports {
		if !this.Ports[i].Equal(that1.Ports[i]) {
			return false
		}
	}
	if len(this.Selector) != len(that1.Selector) {
		return false
	}
	for i := range this.Selector {
		if this.Selector[i] != that1.Selector[i] {
			return false
		}
	}
	if this.ClusterIP != that1.ClusterIP {
		return false
	}
	if this.Type != that1.Type {
		return false
	}
	if len(this.ExternalIPs) != len(that1.ExternalIPs) {
		return false
	}
	for i := range this.ExternalIPs {
		if this.ExternalIPs[i] != that1.ExternalIPs[i] {
			return false
		}
	}
	if this.SessionAffinity != that1.SessionAffinity {
		return false
	}
	if this.LoadBalancerIP != that1.LoadBalancerIP {
		return false
	}
	if len(this.LoadBalancerSourceRanges) != len(that1.LoadBalancerSourceRanges) {
		return false
	}
	for i := range this.LoadBalancerSourceRanges {
		if this.LoadBalancerSourceRanges[i] != that1.LoadBalancerSourceRanges[i] {
			return false
		}
	}
	if this.ExternalName != that1.ExternalName {
		return false
	}
	if this.ExternalTrafficPolicy != that1.ExternalTrafficPolicy {
		return false
	}
	if this.HealthCheckNodePort != that1.HealthCheckNodePort {
		return false
	}
	if this.PublishNotReadyAddresses != that1.PublishNotReadyAddresses {
		return false
	}
	if !this.SessionAffinityConfig.Equal(that1.SessionAffinityConfig) {
		return false
	}
	if this.IpFamily != that1.IpFamily {
		return false
	}
	return true
}
func (this *ServiceStatus) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ServiceStatus)
	if !ok {
		that2, ok := that.(ServiceStatus)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.LoadBalancer.Equal(that1.LoadBalancer) {
		return false
	}
	return true
}
func (this *SessionAffinityConfig) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*SessionAffinityConfig)
	if !ok {
		that2, ok := that.(SessionAffinityConfig)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.ClientIP.Equal(that1.ClientIP) {
		return false
	}
	return true
}
func (this *StorageOSPersistentVolumeSource) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*StorageOSPersistentVolumeSource)
	if !ok {
		that2, ok := that.(StorageOSPersistentVolumeSource)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.VolumeName != that1.VolumeName {
		return false
	}
	if this.VolumeNamespace != that1.VolumeNamespace {
		return false
	}
	if this.FsType != that1.FsType {
		return false
	}
	if this.ReadOnly != that1.ReadOnly {
		return false
	}
	if !this.SecretRef.Equal(that1.SecretRef) {
		return false
	}
	return true
}
func (this *StorageOSVolumeSource) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*StorageOSVolumeSource)
	if !ok {
		that2, ok := that.(StorageOSVolumeSource)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.VolumeName != that1.VolumeName {
		return false
	}
	if this.VolumeNamespace != that1.VolumeNamespace {
		return false
	}
	if this.FsType != that1.FsType {
		return false
	}
	if this.ReadOnly != that1.ReadOnly {
		return false
	}
	if !this.SecretRef.Equal(that1.SecretRef) {
		return false
	}
	return true
}
func (this *Sysctl) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Sysctl)
	if !ok {
		that2, ok := that.(Sysctl)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if this.Value != that1.Value {
		return false
	}
	return true
}
func (this *TCPSocketAction) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*TCPSocketAction)
	if !ok {
		that2, ok := that.(TCPSocketAction)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Port.Equal(that1.Port) {
		return false
	}
	if this.Host != that1.Host {
		return false
	}
	return true
}
func (this *Taint) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Taint)
	if !ok {
		that2, ok := that.(Taint)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Key != that1.Key {
		return false
	}
	if this.Value != that1.Value {
		return false
	}
	if this.Effect != that1.Effect {
		return false
	}
	if !this.TimeAdded.Equal(that1.TimeAdded) {
		return false
	}
	return true
}
func (this *Toleration) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Toleration)
	if !ok {
		that2, ok := that.(Toleration)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Key != that1.Key {
		return false
	}
	if this.Operator != that1.Operator {
		return false
	}
	if this.Value != that1.Value {
		return false
	}
	if this.Effect != that1.Effect {
		return false
	}
	if this.TolerationSeconds != that1.TolerationSeconds {
		return false
	}
	return true
}
func (this *TopologySelectorLabelRequirement) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*TopologySelectorLabelRequirement)
	if !ok {
		that2, ok := that.(TopologySelectorLabelRequirement)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Key != that1.Key {
		return false
	}
	if len(this.Values) != len(that1.Values) {
		return false
	}
	for i := range this.Values {
		if this.Values[i] != that1.Values[i] {
			return false
		}
	}
	return true
}
func (this *TopologySelectorTerm) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*TopologySelectorTerm)
	if !ok {
		that2, ok := that.(TopologySelectorTerm)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.MatchLabelExpressions) != len(that1.MatchLabelExpressions) {
		return false
	}
	for i := range this.MatchLabelExpressions {
		if !this.MatchLabelExpressions[i].Equal(that1.MatchLabelExpressions[i]) {
			return false
		}
	}
	return true
}
func (this *TopologySpreadConstraint) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*TopologySpreadConstraint)
	if !ok {
		that2, ok := that.(TopologySpreadConstraint)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.MaxSkew != that1.MaxSkew {
		return false
	}
	if this.TopologyKey != that1.TopologyKey {
		return false
	}
	if this.WhenUnsatisfiable != that1.WhenUnsatisfiable {
		return false
	}
	if !this.LabelSelector.Equal(that1.LabelSelector) {
		return false
	}
	return true
}
func (this *TypedLocalObjectReference) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*TypedLocalObjectReference)
	if !ok {
		that2, ok := that.(TypedLocalObjectReference)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.ApiGroup != that1.ApiGroup {
		return false
	}
	if this.Kind != that1.Kind {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	return true
}
func (this *Volume) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Volume)
	if !ok {
		that2, ok := that.(Volume)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if !this.VolumeSource.Equal(that1.VolumeSource) {
		return false
	}
	return true
}
func (this *VolumeDevice) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*VolumeDevice)
	if !ok {
		that2, ok := that.(VolumeDevice)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if this.DevicePath != that1.DevicePath {
		return false
	}
	return true
}
func (this *VolumeMount) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*VolumeMount)
	if !ok {
		that2, ok := that.(VolumeMount)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if this.ReadOnly != that1.ReadOnly {
		return false
	}
	if this.MountPath != that1.MountPath {
		return false
	}
	if this.SubPath != that1.SubPath {
		return false
	}
	if this.MountPropagation != that1.MountPropagation {
		return false
	}
	if this.SubPathExpr != that1.SubPathExpr {
		return false
	}
	return true
}
func (this *VolumeNodeAffinity) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*VolumeNodeAffinity)
	if !ok {
		that2, ok := that.(VolumeNodeAffinity)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Required.Equal(that1.Required) {
		return false
	}
	return true
}
func (this *VolumeProjection) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*VolumeProjection)
	if !ok {
		that2, ok := that.(VolumeProjection)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Secret.Equal(that1.Secret) {
		return false
	}
	if !this.DownwardAPI.Equal(that1.DownwardAPI) {
		return false
	}
	if !this.ConfigMap.Equal(that1.ConfigMap) {
		return false
	}
	if !this.ServiceAccountToken.Equal(that1.ServiceAccountToken) {
		return false
	}
	return true
}
func (this *VolumeSource) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*VolumeSource)
	if !ok {
		that2, ok := that.(VolumeSource)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.HostPath.Equal(that1.HostPath) {
		return false
	}
	if !this.EmptyDir.Equal(that1.EmptyDir) {
		return false
	}
	if !this.GcePersistentDisk.Equal(that1.GcePersistentDisk) {
		return false
	}
	if !this.AwsElasticBlockStore.Equal(that1.AwsElasticBlockStore) {
		return false
	}
	if !this.GitRepo.Equal(that1.GitRepo) {
		return false
	}
	if !this.Secret.Equal(that1.Secret) {
		return false
	}
	if !this.Nfs.Equal(that1.Nfs) {
		return false
	}
	if !this.Iscsi.Equal(that1.Iscsi) {
		return false
	}
	if !this.Glusterfs.Equal(that1.Glusterfs) {
		return false
	}
	if !this.PersistentVolumeClaim.Equal(that1.PersistentVolumeClaim) {
		return false
	}
	if !this.Rbd.Equal(that1.Rbd) {
		return false
	}
	if !this.FlexVolume.Equal(that1.FlexVolume) {
		return false
	}
	if !this.Cinder.Equal(that1.Cinder) {
		return false
	}
	if !this.Cephfs.Equal(that1.Cephfs) {
		return false
	}
	if !this.Flocker.Equal(that1.Flocker) {
		return false
	}
	if !this.DownwardAPI.Equal(that1.DownwardAPI) {
		return false
	}
	if !this.Fc.Equal(that1.Fc) {
		return false
	}
	if !this.AzureFile.Equal(that1.AzureFile) {
		return false
	}
	if !this.ConfigMap.Equal(that1.ConfigMap) {
		return false
	}
	if !this.VsphereVolume.Equal(that1.VsphereVolume) {
		return false
	}
	if !this.Quobyte.Equal(that1.Quobyte) {
		return false
	}
	if !this.AzureDisk.Equal(that1.AzureDisk) {
		return false
	}
	if !this.PhotonPersistentDisk.Equal(that1.PhotonPersistentDisk) {
		return false
	}
	if !this.Projected.Equal(that1.Projected) {
		return false
	}
	if !this.PortworxVolume.Equal(that1.PortworxVolume) {
		return false
	}
	if !this.ScaleIO.Equal(that1.ScaleIO) {
		return false
	}
	if !this.Storageos.Equal(that1.Storageos) {
		return false
	}
	if !this.Csi.Equal(that1.Csi) {
		return false
	}
	return true
}
func (this *VsphereVirtualDiskVolumeSource) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*VsphereVirtualDiskVolumeSource)
	if !ok {
		that2, ok := that.(VsphereVirtualDiskVolumeSource)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.VolumePath != that1.VolumePath {
		return false
	}
	if this.FsType != that1.FsType {
		return false
	}
	if this.StoragePolicyName != that1.StoragePolicyName {
		return false
	}
	if this.StoragePolicyID != that1.StoragePolicyID {
		return false
	}
	return true
}
func (this *WeightedPodAffinityTerm) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*WeightedPodAffinityTerm)
	if !ok {
		that2, ok := that.(WeightedPodAffinityTerm)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Weight != that1.Weight {
		return false
	}
	if !this.PodAffinityTerm.Equal(that1.PodAffinityTerm) {
		return false
	}
	return true
}
func (this *WindowsSecurityContextOptions) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*WindowsSecurityContextOptions)
	if !ok {
		that2, ok := that.(WindowsSecurityContextOptions)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.GmsaCredentialSpecName != that1.GmsaCredentialSpecName {
		return false
	}
	if this.GmsaCredentialSpec != that1.GmsaCredentialSpec {
		return false
	}
	if this.RunAsUserName != that1.RunAsUserName {
		return false
	}
	return true
}
func (this *AWSElasticBlockStoreVolumeSource) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&k8s_io_api_core_v1.AWSElasticBlockStoreVolumeSource{")
	s = append(s, "VolumeID: "+fmt.Sprintf("%#v", this.VolumeID)+",\n")
	s = append(s, "FsType: "+fmt.Sprintf("%#v", this.FsType)+",\n")
	s = append(s, "Partition: "+fmt.Sprintf("%#v", this.Partition)+",\n")
	s = append(s, "ReadOnly: "+fmt.Sprintf("%#v", this.ReadOnly)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Affinity) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&k8s_io_api_core_v1.Affinity{")
	if this.NodeAffinity != nil {
		s = append(s, "NodeAffinity: "+fmt.Sprintf("%#v", this.NodeAffinity)+",\n")
	}
	if this.PodAffinity != nil {
		s = append(s, "PodAffinity: "+fmt.Sprintf("%#v", this.PodAffinity)+",\n")
	}
	if this.PodAntiAffinity != nil {
		s = append(s, "PodAntiAffinity: "+fmt.Sprintf("%#v", this.PodAntiAffinity)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *AttachedVolume) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&k8s_io_api_core_v1.AttachedVolume{")
	s = append(s, "Name: "+fmt.Sprintf("%#v", this.Name)+",\n")
	s = append(s, "DevicePath: "+fmt.Sprintf("%#v", this.DevicePath)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *AvoidPods) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&k8s_io_api_core_v1.AvoidPods{")
	if this.PreferAvoidPods != nil {
		s = append(s, "PreferAvoidPods: "+fmt.Sprintf("%#v", this.PreferAvoidPods)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *AzureDiskVolumeSource) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 10)
	s = append(s, "&k8s_io_api_core_v1.AzureDiskVolumeSource{")
	s = append(s, "DiskName: "+fmt.Sprintf("%#v", this.DiskName)+",\n")
	s = append(s, "DiskURI: "+fmt.Sprintf("%#v", this.DiskURI)+",\n")
	s = append(s, "CachingMode: "+fmt.Sprintf("%#v", this.CachingMode)+",\n")
	s = append(s, "FsType: "+fmt.Sprintf("%#v", this.FsType)+",\n")
	s = append(s, "ReadOnly: "+fmt.Sprintf("%#v", this.ReadOnly)+",\n")
	s = append(s, "Kind: "+fmt.Sprintf("%#v", this.Kind)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *AzureFilePersistentVolumeSource) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&k8s_io_api_core_v1.AzureFilePersistentVolumeSource{")
	s = append(s, "SecretName: "+fmt.Sprintf("%#v", this.SecretName)+",\n")
	s = append(s, "ShareName: "+fmt.Sprintf("%#v", this.ShareName)+",\n")
	s = append(s, "ReadOnly: "+fmt.Sprintf("%#v", this.ReadOnly)+",\n")
	s = append(s, "SecretNamespace: "+fmt.Sprintf("%#v", this.SecretNamespace)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *AzureFileVolumeSource) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&k8s_io_api_core_v1.AzureFileVolumeSource{")
	s = append(s, "SecretName: "+fmt.Sprintf("%#v", this.SecretName)+",\n")
	s = append(s, "ShareName: "+fmt.Sprintf("%#v", this.ShareName)+",\n")
	s = append(s, "ReadOnly: "+fmt.Sprintf("%#v", this.ReadOnly)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Binding) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&k8s_io_api_core_v1.Binding{")
	if this.Metadata != nil {
		s = append(s, "Metadata: "+fmt.Sprintf("%#v", this.Metadata)+",\n")
	}
	if this.Target != nil {
		s = append(s, "Target: "+fmt.Sprintf("%#v", this.Target)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *CSIPersistentVolumeSource) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 13)
	s = append(s, "&k8s_io_api_core_v1.CSIPersistentVolumeSource{")
	s = append(s, "Driver: "+fmt.Sprintf("%#v", this.Driver)+",\n")
	s = append(s, "VolumeHandle: "+fmt.Sprintf("%#v", this.VolumeHandle)+",\n")
	s = append(s, "ReadOnly: "+fmt.Sprintf("%#v", this.ReadOnly)+",\n")
	s = append(s, "FsType: "+fmt.Sprintf("%#v", this.FsType)+",\n")
	keysForVolumeAttributes := make([]string, 0, len(this.VolumeAttributes))
	for k, _ := range this.VolumeAttributes {
		keysForVolumeAttributes = append(keysForVolumeAttributes, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForVolumeAttributes)
	mapStringForVolumeAttributes := "map[string]string{"
	for _, k := range keysForVolumeAttributes {
		mapStringForVolumeAttributes += fmt.Sprintf("%#v: %#v,", k, this.VolumeAttributes[k])
	}
	mapStringForVolumeAttributes += "}"
	if this.VolumeAttributes != nil {
		s = append(s, "VolumeAttributes: "+mapStringForVolumeAttributes+",\n")
	}
	if this.ControllerPublishSecretRef != nil {
		s = append(s, "ControllerPublishSecretRef: "+fmt.Sprintf("%#v", this.ControllerPublishSecretRef)+",\n")
	}
	if this.NodeStageSecretRef != nil {
		s = append(s, "NodeStageSecretRef: "+fmt.Sprintf("%#v", this.NodeStageSecretRef)+",\n")
	}
	if this.NodePublishSecretRef != nil {
		s = append(s, "NodePublishSecretRef: "+fmt.Sprintf("%#v", this.NodePublishSecretRef)+",\n")
	}
	if this.ControllerExpandSecretRef != nil {
		s = append(s, "ControllerExpandSecretRef: "+fmt.Sprintf("%#v", this.ControllerExpandSecretRef)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *CSIVolumeSource) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 9)
	s = append(s, "&k8s_io_api_core_v1.CSIVolumeSource{")
	s = append(s, "Driver: "+fmt.Sprintf("%#v", this.Driver)+",\n")
	s = append(s, "ReadOnly: "+fmt.Sprintf("%#v", this.ReadOnly)+",\n")
	s = append(s, "FsType: "+fmt.Sprintf("%#v", this.FsType)+",\n")
	keysForVolumeAttributes := make([]string, 0, len(this.VolumeAttributes))
	for k, _ := range this.VolumeAttributes {
		keysForVolumeAttributes = append(keysForVolumeAttributes, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForVolumeAttributes)
	mapStringForVolumeAttributes := "map[string]string{"
	for _, k := range keysForVolumeAttributes {
		mapStringForVolumeAttributes += fmt.Sprintf("%#v: %#v,", k, this.VolumeAttributes[k])
	}
	mapStringForVolumeAttributes += "}"
	if this.VolumeAttributes != nil {
		s = append(s, "VolumeAttributes: "+mapStringForVolumeAttributes+",\n")
	}
	if this.NodePublishSecretRef != nil {
		s = append(s, "NodePublishSecretRef: "+fmt.Sprintf("%#v", this.NodePublishSecretRef)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Capabilities) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&k8s_io_api_core_v1.Capabilities{")
	if this.Add != nil {
		s = append(s, "Add: "+fmt.Sprintf("%#v", this.Add)+",\n")
	}
	if this.Drop != nil {
		s = append(s, "Drop: "+fmt.Sprintf("%#v", this.Drop)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *CephFSPersistentVolumeSource) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 10)
	s = append(s, "&k8s_io_api_core_v1.CephFSPersistentVolumeSource{")
	if this.Monitors != nil {
		s = append(s, "Monitors: "+fmt.Sprintf("%#v", this.Monitors)+",\n")
	}
	s = append(s, "Path: "+fmt.Sprintf("%#v", this.Path)+",\n")
	s = append(s, "User: "+fmt.Sprintf("%#v", this.User)+",\n")
	s = append(s, "SecretFile: "+fmt.Sprintf("%#v", this.SecretFile)+",\n")
	if this.SecretRef != nil {
		s = append(s, "SecretRef: "+fmt.Sprintf("%#v", this.SecretRef)+",\n")
	}
	s = append(s, "ReadOnly: "+fmt.Sprintf("%#v", this.ReadOnly)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *CephFSVolumeSource) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 10)
	s = append(s, "&k8s_io_api_core_v1.CephFSVolumeSource{")
	if this.Monitors != nil {
		s = append(s, "Monitors: "+fmt.Sprintf("%#v", this.Monitors)+",\n")
	}
	s = append(s, "Path: "+fmt.Sprintf("%#v", this.Path)+",\n")
	s = append(s, "User: "+fmt.Sprintf("%#v", this.User)+",\n")
	s = append(s, "SecretFile: "+fmt.Sprintf("%#v", this.SecretFile)+",\n")
	if this.SecretRef != nil {
		s = append(s, "SecretRef: "+fmt.Sprintf("%#v", this.SecretRef)+",\n")
	}
	s = append(s, "ReadOnly: "+fmt.Sprintf("%#v", this.ReadOnly)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *CinderPersistentVolumeSource) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&k8s_io_api_core_v1.CinderPersistentVolumeSource{")
	s = append(s, "VolumeID: "+fmt.Sprintf("%#v", this.VolumeID)+",\n")
	s = append(s, "FsType: "+fmt.Sprintf("%#v", this.FsType)+",\n")
	s = append(s, "ReadOnly: "+fmt.Sprintf("%#v", this.ReadOnly)+",\n")
	if this.SecretRef != nil {
		s = append(s, "SecretRef: "+fmt.Sprintf("%#v", this.SecretRef)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *CinderVolumeSource) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&k8s_io_api_core_v1.CinderVolumeSource{")
	s = append(s, "VolumeID: "+fmt.Sprintf("%#v", this.VolumeID)+",\n")
	s = append(s, "FsType: "+fmt.Sprintf("%#v", this.FsType)+",\n")
	s = append(s, "ReadOnly: "+fmt.Sprintf("%#v", this.ReadOnly)+",\n")
	if this.SecretRef != nil {
		s = append(s, "SecretRef: "+fmt.Sprintf("%#v", this.SecretRef)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ClientIPConfig) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&k8s_io_api_core_v1.ClientIPConfig{")
	s = append(s, "TimeoutSeconds: "+fmt.Sprintf("%#v", this.TimeoutSeconds)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ComponentCondition) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&k8s_io_api_core_v1.ComponentCondition{")
	s = append(s, "Type: "+fmt.Sprintf("%#v", this.Type)+",\n")
	s = append(s, "Status: "+fmt.Sprintf("%#v", this.Status)+",\n")
	s = append(s, "Message: "+fmt.Sprintf("%#v", this.Message)+",\n")
	s = append(s, "Error: "+fmt.Sprintf("%#v", this.Error)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ComponentStatus) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&k8s_io_api_core_v1.ComponentStatus{")
	if this.Metadata != nil {
		s = append(s, "Metadata: "+fmt.Sprintf("%#v", this.Metadata)+",\n")
	}
	if this.Conditions != nil {
		s = append(s, "Conditions: "+fmt.Sprintf("%#v", this.Conditions)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ComponentStatusList) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&k8s_io_api_core_v1.ComponentStatusList{")
	if this.Metadata != nil {
		s = append(s, "Metadata: "+fmt.Sprintf("%#v", this.Metadata)+",\n")
	}
	if this.Items != nil {
		s = append(s, "Items: "+fmt.Sprintf("%#v", this.Items)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ConfigMap) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&k8s_io_api_core_v1.ConfigMap{")
	if this.Metadata != nil {
		s = append(s, "Metadata: "+fmt.Sprintf("%#v", this.Metadata)+",\n")
	}
	keysForData := make([]string, 0, len(this.Data))
	for k, _ := range this.Data {
		keysForData = append(keysForData, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForData)
	mapStringForData := "map[string]string{"
	for _, k := range keysForData {
		mapStringForData += fmt.Sprintf("%#v: %#v,", k, this.Data[k])
	}
	mapStringForData += "}"
	if this.Data != nil {
		s = append(s, "Data: "+mapStringForData+",\n")
	}
	keysForBinaryData := make([]string, 0, len(this.BinaryData))
	for k, _ := range this.BinaryData {
		keysForBinaryData = append(keysForBinaryData, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForBinaryData)
	mapStringForBinaryData := "map[string][]byte{"
	for _, k := range keysForBinaryData {
		mapStringForBinaryData += fmt.Sprintf("%#v: %#v,", k, this.BinaryData[k])
	}
	mapStringForBinaryData += "}"
	if this.BinaryData != nil {
		s = append(s, "BinaryData: "+mapStringForBinaryData+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ConfigMapEnvSource) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&k8s_io_api_core_v1.ConfigMapEnvSource{")
	if this.LocalObjectReference != nil {
		s = append(s, "LocalObjectReference: "+fmt.Sprintf("%#v", this.LocalObjectReference)+",\n")
	}
	s = append(s, "Optional: "+fmt.Sprintf("%#v", this.Optional)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ConfigMapKeySelector) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&k8s_io_api_core_v1.ConfigMapKeySelector{")
	if this.LocalObjectReference != nil {
		s = append(s, "LocalObjectReference: "+fmt.Sprintf("%#v", this.LocalObjectReference)+",\n")
	}
	s = append(s, "Key: "+fmt.Sprintf("%#v", this.Key)+",\n")
	s = append(s, "Optional: "+fmt.Sprintf("%#v", this.Optional)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ConfigMapList) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&k8s_io_api_core_v1.ConfigMapList{")
	if this.Metadata != nil {
		s = append(s, "Metadata: "+fmt.Sprintf("%#v", this.Metadata)+",\n")
	}
	if this.Items != nil {
		s = append(s, "Items: "+fmt.Sprintf("%#v", this.Items)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ConfigMapNodeConfigSource) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 9)
	s = append(s, "&k8s_io_api_core_v1.ConfigMapNodeConfigSource{")
	s = append(s, "Namespace: "+fmt.Sprintf("%#v", this.Namespace)+",\n")
	s = append(s, "Name: "+fmt.Sprintf("%#v", this.Name)+",\n")
	s = append(s, "Uid: "+fmt.Sprintf("%#v", this.Uid)+",\n")
	s = append(s, "ResourceVersion: "+fmt.Sprintf("%#v", this.ResourceVersion)+",\n")
	s = append(s, "KubeletConfigKey: "+fmt.Sprintf("%#v", this.KubeletConfigKey)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ConfigMapProjection) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&k8s_io_api_core_v1.ConfigMapProjection{")
	if this.LocalObjectReference != nil {
		s = append(s, "LocalObjectReference: "+fmt.Sprintf("%#v", this.LocalObjectReference)+",\n")
	}
	if this.Items != nil {
		s = append(s, "Items: "+fmt.Sprintf("%#v", this.Items)+",\n")
	}
	s = append(s, "Optional: "+fmt.Sprintf("%#v", this.Optional)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ConfigMapVolumeSource) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&k8s_io_api_core_v1.ConfigMapVolumeSource{")
	if this.LocalObjectReference != nil {
		s = append(s, "LocalObjectReference: "+fmt.Sprintf("%#v", this.LocalObjectReference)+",\n")
	}
	if this.Items != nil {
		s = append(s, "Items: "+fmt.Sprintf("%#v", this.Items)+",\n")
	}
	s = append(s, "DefaultMode: "+fmt.Sprintf("%#v", this.DefaultMode)+",\n")
	s = append(s, "Optional: "+fmt.Sprintf("%#v", this.Optional)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Container) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 25)
	s = append(s, "&k8s_io_api_core_v1.Container{")
	s = append(s, "Name: "+fmt.Sprintf("%#v", this.Name)+",\n")
	s = append(s, "Image: "+fmt.Sprintf("%#v", this.Image)+",\n")
	if this.Command != nil {
		s = append(s, "Command: "+fmt.Sprintf("%#v", this.Command)+",\n")
	}
	if this.Args != nil {
		s = append(s, "Args: "+fmt.Sprintf("%#v", this.Args)+",\n")
	}
	s = append(s, "WorkingDir: "+fmt.Sprintf("%#v", this.WorkingDir)+",\n")
	if this.Ports != nil {
		s = append(s, "Ports: "+fmt.Sprintf("%#v", this.Ports)+",\n")
	}
	if this.EnvFrom != nil {
		s = append(s, "EnvFrom: "+fmt.Sprintf("%#v", this.EnvFrom)+",\n")
	}
	if this.Env != nil {
		s = append(s, "Env: "+fmt.Sprintf("%#v", this.Env)+",\n")
	}
	if this.Resources != nil {
		s = append(s, "Resources: "+fmt.Sprintf("%#v", this.Resources)+",\n")
	}
	if this.VolumeMounts != nil {
		s = append(s, "VolumeMounts: "+fmt.Sprintf("%#v", this.VolumeMounts)+",\n")
	}
	if this.VolumeDevices != nil {
		s = append(s, "VolumeDevices: "+fmt.Sprintf("%#v", this.VolumeDevices)+",\n")
	}
	if this.LivenessProbe != nil {
		s = append(s, "LivenessProbe: "+fmt.Sprintf("%#v", this.LivenessProbe)+",\n")
	}
	if this.ReadinessProbe != nil {
		s = append(s, "ReadinessProbe: "+fmt.Sprintf("%#v", this.ReadinessProbe)+",\n")
	}
	if this.Lifecycle != nil {
		s = append(s, "Lifecycle: "+fmt.Sprintf("%#v", this.Lifecycle)+",\n")
	}
	s = append(s, "TerminationMessagePath: "+fmt.Sprintf("%#v", this.TerminationMessagePath)+",\n")
	s = append(s, "TerminationMessagePolicy: "+fmt.Sprintf("%#v", this.TerminationMessagePolicy)+",\n")
	s = append(s, "ImagePullPolicy: "+fmt.Sprintf("%#v", this.ImagePullPolicy)+",\n")
	if this.SecurityContext != nil {
		s = append(s, "SecurityContext: "+fmt.Sprintf("%#v", this.SecurityContext)+",\n")
	}
	s = append(s, "Stdin: "+fmt.Sprintf("%#v", this.Stdin)+",\n")
	s = append(s, "StdinOnce: "+fmt.Sprintf("%#v", this.StdinOnce)+",\n")
	s = append(s, "Tty: "+fmt.Sprintf("%#v", this.Tty)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ContainerImage) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&k8s_io_api_core_v1.ContainerImage{")
	if this.Names != nil {
		s = append(s, "Names: "+fmt.Sprintf("%#v", this.Names)+",\n")
	}
	s = append(s, "SizeBytes: "+fmt.Sprintf("%#v", this.SizeBytes)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ContainerPort) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 9)
	s = append(s, "&k8s_io_api_core_v1.ContainerPort{")
	s = append(s, "Name: "+fmt.Sprintf("%#v", this.Name)+",\n")
	s = append(s, "HostPort: "+fmt.Sprintf("%#v", this.HostPort)+",\n")
	s = append(s, "ContainerPort: "+fmt.Sprintf("%#v", this.ContainerPort)+",\n")
	s = append(s, "Protocol: "+fmt.Sprintf("%#v", this.Protocol)+",\n")
	s = append(s, "HostIP: "+fmt.Sprintf("%#v", this.HostIP)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ContainerState) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&k8s_io_api_core_v1.ContainerState{")
	if this.Waiting != nil {
		s = append(s, "Waiting: "+fmt.Sprintf("%#v", this.Waiting)+",\n")
	}
	if this.Running != nil {
		s = append(s, "Running: "+fmt.Sprintf("%#v", this.Running)+",\n")
	}
	if this.Terminated != nil {
		s = append(s, "Terminated: "+fmt.Sprintf("%#v", this.Terminated)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ContainerStateRunning) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&k8s_io_api_core_v1.ContainerStateRunning{")
	if this.StartedAt != nil {
		s = append(s, "StartedAt: "+fmt.Sprintf("%#v", this.StartedAt)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ContainerStateTerminated) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 11)
	s = append(s, "&k8s_io_api_core_v1.ContainerStateTerminated{")
	s = append(s, "ExitCode: "+fmt.Sprintf("%#v", this.ExitCode)+",\n")
	s = append(s, "Signal: "+fmt.Sprintf("%#v", this.Signal)+",\n")
	s = append(s, "Reason: "+fmt.Sprintf("%#v", this.Reason)+",\n")
	s = append(s, "Message: "+fmt.Sprintf("%#v", this.Message)+",\n")
	if this.StartedAt != nil {
		s = append(s, "StartedAt: "+fmt.Sprintf("%#v", this.StartedAt)+",\n")
	}
	if this.FinishedAt != nil {
		s = append(s, "FinishedAt: "+fmt.Sprintf("%#v", this.FinishedAt)+",\n")
	}
	s = append(s, "ContainerID: "+fmt.Sprintf("%#v", this.ContainerID)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ContainerStateWaiting) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&k8s_io_api_core_v1.ContainerStateWaiting{")
	s = append(s, "Reason: "+fmt.Sprintf("%#v", this.Reason)+",\n")
	s = append(s, "Message: "+fmt.Sprintf("%#v", this.Message)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ContainerStatus) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 12)
	s = append(s, "&k8s_io_api_core_v1.ContainerStatus{")
	s = append(s, "Name: "+fmt.Sprintf("%#v", this.Name)+",\n")
	if this.State != nil {
		s = append(s, "State: "+fmt.Sprintf("%#v", this.State)+",\n")
	}
	if this.LastState != nil {
		s = append(s, "LastState: "+fmt.Sprintf("%#v", this.LastState)+",\n")
	}
	s = append(s, "Ready: "+fmt.Sprintf("%#v", this.Ready)+",\n")
	s = append(s, "RestartCount: "+fmt.Sprintf("%#v", this.RestartCount)+",\n")
	s = append(s, "Image: "+fmt.Sprintf("%#v", this.Image)+",\n")
	s = append(s, "ImageID: "+fmt.Sprintf("%#v", this.ImageID)+",\n")
	s = append(s, "ContainerID: "+fmt.Sprintf("%#v", this.ContainerID)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *DaemonEndpoint) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&k8s_io_api_core_v1.DaemonEndpoint{")
	s = append(s, "Port: "+fmt.Sprintf("%#v", this.Port)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *DownwardAPIProjection) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&k8s_io_api_core_v1.DownwardAPIProjection{")
	if this.Items != nil {
		s = append(s, "Items: "+fmt.Sprintf("%#v", this.Items)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *DownwardAPIVolumeFile) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&k8s_io_api_core_v1.DownwardAPIVolumeFile{")
	s = append(s, "Path: "+fmt.Sprintf("%#v", this.Path)+",\n")
	if this.FieldRef != nil {
		s = append(s, "FieldRef: "+fmt.Sprintf("%#v", this.FieldRef)+",\n")
	}
	if this.ResourceFieldRef != nil {
		s = append(s, "ResourceFieldRef: "+fmt.Sprintf("%#v", this.ResourceFieldRef)+",\n")
	}
	s = append(s, "Mode: "+fmt.Sprintf("%#v", this.Mode)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *DownwardAPIVolumeSource) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&k8s_io_api_core_v1.DownwardAPIVolumeSource{")
	if this.Items != nil {
		s = append(s, "Items: "+fmt.Sprintf("%#v", this.Items)+",\n")
	}
	s = append(s, "DefaultMode: "+fmt.Sprintf("%#v", this.DefaultMode)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *EmptyDirVolumeSource) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&k8s_io_api_core_v1.EmptyDirVolumeSource{")
	s = append(s, "Medium: "+fmt.Sprintf("%#v", this.Medium)+",\n")
	if this.SizeLimit != nil {
		s = append(s, "SizeLimit: "+fmt.Sprintf("%#v", this.SizeLimit)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *EndpointAddress) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&k8s_io_api_core_v1.EndpointAddress{")
	s = append(s, "Ip: "+fmt.Sprintf("%#v", this.Ip)+",\n")
	s = append(s, "Hostname: "+fmt.Sprintf("%#v", this.Hostname)+",\n")
	s = append(s, "NodeName: "+fmt.Sprintf("%#v", this.NodeName)+",\n")
	if this.TargetRef != nil {
		s = append(s, "TargetRef: "+fmt.Sprintf("%#v", this.TargetRef)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *EndpointPort) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&k8s_io_api_core_v1.EndpointPort{")
	s = append(s, "Name: "+fmt.Sprintf("%#v", this.Name)+",\n")
	s = append(s, "Port: "+fmt.Sprintf("%#v", this.Port)+",\n")
	s = append(s, "Protocol: "+fmt.Sprintf("%#v", this.Protocol)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *EndpointSubset) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&k8s_io_api_core_v1.EndpointSubset{")
	if this.Addresses != nil {
		s = append(s, "Addresses: "+fmt.Sprintf("%#v", this.Addresses)+",\n")
	}
	if this.NotReadyAddresses != nil {
		s = append(s, "NotReadyAddresses: "+fmt.Sprintf("%#v", this.NotReadyAddresses)+",\n")
	}
	if this.Ports != nil {
		s = append(s, "Ports: "+fmt.Sprintf("%#v", this.Ports)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Endpoints) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&k8s_io_api_core_v1.Endpoints{")
	if this.Metadata != nil {
		s = append(s, "Metadata: "+fmt.Sprintf("%#v", this.Metadata)+",\n")
	}
	if this.Subsets != nil {
		s = append(s, "Subsets: "+fmt.Sprintf("%#v", this.Subsets)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *EndpointsList) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&k8s_io_api_core_v1.EndpointsList{")
	if this.Metadata != nil {
		s = append(s, "Metadata: "+fmt.Sprintf("%#v", this.Metadata)+",\n")
	}
	if this.Items != nil {
		s = append(s, "Items: "+fmt.Sprintf("%#v", this.Items)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *EnvFromSource) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&k8s_io_api_core_v1.EnvFromSource{")
	s = append(s, "Prefix: "+fmt.Sprintf("%#v", this.Prefix)+",\n")
	if this.ConfigMapRef != nil {
		s = append(s, "ConfigMapRef: "+fmt.Sprintf("%#v", this.ConfigMapRef)+",\n")
	}
	if this.SecretRef != nil {
		s = append(s, "SecretRef: "+fmt.Sprintf("%#v", this.SecretRef)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *EnvVar) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&k8s_io_api_core_v1.EnvVar{")
	s = append(s, "Name: "+fmt.Sprintf("%#v", this.Name)+",\n")
	s = append(s, "Value: "+fmt.Sprintf("%#v", this.Value)+",\n")
	if this.ValueFrom != nil {
		s = append(s, "ValueFrom: "+fmt.Sprintf("%#v", this.ValueFrom)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *EnvVarSource) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&k8s_io_api_core_v1.EnvVarSource{")
	if this.FieldRef != nil {
		s = append(s, "FieldRef: "+fmt.Sprintf("%#v", this.FieldRef)+",\n")
	}
	if this.ResourceFieldRef != nil {
		s = append(s, "ResourceFieldRef: "+fmt.Sprintf("%#v", this.ResourceFieldRef)+",\n")
	}
	if this.ConfigMapKeyRef != nil {
		s = append(s, "ConfigMapKeyRef: "+fmt.Sprintf("%#v", this.ConfigMapKeyRef)+",\n")
	}
	if this.SecretKeyRef != nil {
		s = append(s, "SecretKeyRef: "+fmt.Sprintf("%#v", this.SecretKeyRef)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *EphemeralContainer) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&k8s_io_api_core_v1.EphemeralContainer{")
	if this.EphemeralContainerCommon != nil {
		s = append(s, "EphemeralContainerCommon: "+fmt.Sprintf("%#v", this.EphemeralContainerCommon)+",\n")
	}
	s = append(s, "TargetContainerName: "+fmt.Sprintf("%#v", this.TargetContainerName)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *EphemeralContainerCommon) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 25)
	s = append(s, "&k8s_io_api_core_v1.EphemeralContainerCommon{")
	s = append(s, "Name: "+fmt.Sprintf("%#v", this.Name)+",\n")
	s = append(s, "Image: "+fmt.Sprintf("%#v", this.Image)+",\n")
	if this.Command != nil {
		s = append(s, "Command: "+fmt.Sprintf("%#v", this.Command)+",\n")
	}
	if this.Args != nil {
		s = append(s, "Args: "+fmt.Sprintf("%#v", this.Args)+",\n")
	}
	s = append(s, "WorkingDir: "+fmt.Sprintf("%#v", this.WorkingDir)+",\n")
	if this.Ports != nil {
		s = append(s, "Ports: "+fmt.Sprintf("%#v", this.Ports)+",\n")
	}
	if this.EnvFrom != nil {
		s = append(s, "EnvFrom: "+fmt.Sprintf("%#v", this.EnvFrom)+",\n")
	}
	if this.Env != nil {
		s = append(s, "Env: "+fmt.Sprintf("%#v", this.Env)+",\n")
	}
	if this.Resources != nil {
		s = append(s, "Resources: "+fmt.Sprintf("%#v", this.Resources)+",\n")
	}
	if this.VolumeMounts != nil {
		s = append(s, "VolumeMounts: "+fmt.Sprintf("%#v", this.VolumeMounts)+",\n")
	}
	if this.VolumeDevices != nil {
		s = append(s, "VolumeDevices: "+fmt.Sprintf("%#v", this.VolumeDevices)+",\n")
	}
	if this.LivenessProbe != nil {
		s = append(s, "LivenessProbe: "+fmt.Sprintf("%#v", this.LivenessProbe)+",\n")
	}
	if this.ReadinessProbe != nil {
		s = append(s, "ReadinessProbe: "+fmt.Sprintf("%#v", this.ReadinessProbe)+",\n")
	}
	if this.Lifecycle != nil {
		s = append(s, "Lifecycle: "+fmt.Sprintf("%#v", this.Lifecycle)+",\n")
	}
	s = append(s, "TerminationMessagePath: "+fmt.Sprintf("%#v", this.TerminationMessagePath)+",\n")
	s = append(s, "TerminationMessagePolicy: "+fmt.Sprintf("%#v", this.TerminationMessagePolicy)+",\n")
	s = append(s, "ImagePullPolicy: "+fmt.Sprintf("%#v", this.ImagePullPolicy)+",\n")
	if this.SecurityContext != nil {
		s = append(s, "SecurityContext: "+fmt.Sprintf("%#v", this.SecurityContext)+",\n")
	}
	s = append(s, "Stdin: "+fmt.Sprintf("%#v", this.Stdin)+",\n")
	s = append(s, "StdinOnce: "+fmt.Sprintf("%#v", this.StdinOnce)+",\n")
	s = append(s, "Tty: "+fmt.Sprintf("%#v", this.Tty)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *EphemeralContainers) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&k8s_io_api_core_v1.EphemeralContainers{")
	if this.Metadata != nil {
		s = append(s, "Metadata: "+fmt.Sprintf("%#v", this.Metadata)+",\n")
	}
	if this.EphemeralContainers != nil {
		s = append(s, "EphemeralContainers: "+fmt.Sprintf("%#v", this.EphemeralContainers)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Event) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 19)
	s = append(s, "&k8s_io_api_core_v1.Event{")
	if this.Metadata != nil {
		s = append(s, "Metadata: "+fmt.Sprintf("%#v", this.Metadata)+",\n")
	}
	if this.InvolvedObject != nil {
		s = append(s, "InvolvedObject: "+fmt.Sprintf("%#v", this.InvolvedObject)+",\n")
	}
	s = append(s, "Reason: "+fmt.Sprintf("%#v", this.Reason)+",\n")
	s = append(s, "Message: "+fmt.Sprintf("%#v", this.Message)+",\n")
	if this.Source != nil {
		s = append(s, "Source: "+fmt.Sprintf("%#v", this.Source)+",\n")
	}
	if this.FirstTimestamp != nil {
		s = append(s, "FirstTimestamp: "+fmt.Sprintf("%#v", this.FirstTimestamp)+",\n")
	}
	if this.LastTimestamp != nil {
		s = append(s, "LastTimestamp: "+fmt.Sprintf("%#v", this.LastTimestamp)+",\n")
	}
	s = append(s, "Count: "+fmt.Sprintf("%#v", this.Count)+",\n")
	s = append(s, "Type: "+fmt.Sprintf("%#v", this.Type)+",\n")
	if this.EventTime != nil {
		s = append(s, "EventTime: "+fmt.Sprintf("%#v", this.EventTime)+",\n")
	}
	if this.Series != nil {
		s = append(s, "Series: "+fmt.Sprintf("%#v", this.Series)+",\n")
	}
	s = append(s, "Action: "+fmt.Sprintf("%#v", this.Action)+",\n")
	if this.Related != nil {
		s = append(s, "Related: "+fmt.Sprintf("%#v", this.Related)+",\n")
	}
	s = append(s, "ReportingComponent: "+fmt.Sprintf("%#v", this.ReportingComponent)+",\n")
	s = append(s, "ReportingInstance: "+fmt.Sprintf("%#v", this.ReportingInstance)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *EventList) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&k8s_io_api_core_v1.EventList{")
	if this.Metadata != nil {
		s = append(s, "Metadata: "+fmt.Sprintf("%#v", this.Metadata)+",\n")
	}
	if this.Items != nil {
		s = append(s, "Items: "+fmt.Sprintf("%#v", this.Items)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *EventSeries) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&k8s_io_api_core_v1.EventSeries{")
	s = append(s, "Count: "+fmt.Sprintf("%#v", this.Count)+",\n")
	if this.LastObservedTime != nil {
		s = append(s, "LastObservedTime: "+fmt.Sprintf("%#v", this.LastObservedTime)+",\n")
	}
	s = append(s, "State: "+fmt.Sprintf("%#v", this.State)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *EventSource) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&k8s_io_api_core_v1.EventSource{")
	s = append(s, "Component: "+fmt.Sprintf("%#v", this.Component)+",\n")
	s = append(s, "Host: "+fmt.Sprintf("%#v", this.Host)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ExecAction) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&k8s_io_api_core_v1.ExecAction{")
	if this.Command != nil {
		s = append(s, "Command: "+fmt.Sprintf("%#v", this.Command)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *FCVolumeSource) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 9)
	s = append(s, "&k8s_io_api_core_v1.FCVolumeSource{")
	if this.TargetWWNs != nil {
		s = append(s, "TargetWWNs: "+fmt.Sprintf("%#v", this.TargetWWNs)+",\n")
	}
	s = append(s, "Lun: "+fmt.Sprintf("%#v", this.Lun)+",\n")
	s = append(s, "FsType: "+fmt.Sprintf("%#v", this.FsType)+",\n")
	s = append(s, "ReadOnly: "+fmt.Sprintf("%#v", this.ReadOnly)+",\n")
	if this.Wwids != nil {
		s = append(s, "Wwids: "+fmt.Sprintf("%#v", this.Wwids)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *FlexPersistentVolumeSource) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 9)
	s = append(s, "&k8s_io_api_core_v1.FlexPersistentVolumeSource{")
	s = append(s, "Driver: "+fmt.Sprintf("%#v", this.Driver)+",\n")
	s = append(s, "FsType: "+fmt.Sprintf("%#v", this.FsType)+",\n")
	if this.SecretRef != nil {
		s = append(s, "SecretRef: "+fmt.Sprintf("%#v", this.SecretRef)+",\n")
	}
	s = append(s, "ReadOnly: "+fmt.Sprintf("%#v", this.ReadOnly)+",\n")
	keysForOptions := make([]string, 0, len(this.Options))
	for k, _ := range this.Options {
		keysForOptions = append(keysForOptions, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForOptions)
	mapStringForOptions := "map[string]string{"
	for _, k := range keysForOptions {
		mapStringForOptions += fmt.Sprintf("%#v: %#v,", k, this.Options[k])
	}
	mapStringForOptions += "}"
	if this.Options != nil {
		s = append(s, "Options: "+mapStringForOptions+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *FlexVolumeSource) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 9)
	s = append(s, "&k8s_io_api_core_v1.FlexVolumeSource{")
	s = append(s, "Driver: "+fmt.Sprintf("%#v", this.Driver)+",\n")
	s = append(s, "FsType: "+fmt.Sprintf("%#v", this.FsType)+",\n")
	if this.SecretRef != nil {
		s = append(s, "SecretRef: "+fmt.Sprintf("%#v", this.SecretRef)+",\n")
	}
	s = append(s, "ReadOnly: "+fmt.Sprintf("%#v", this.ReadOnly)+",\n")
	keysForOptions := make([]string, 0, len(this.Options))
	for k, _ := range this.Options {
		keysForOptions = append(keysForOptions, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForOptions)
	mapStringForOptions := "map[string]string{"
	for _, k := range keysForOptions {
		mapStringForOptions += fmt.Sprintf("%#v: %#v,", k, this.Options[k])
	}
	mapStringForOptions += "}"
	if this.Options != nil {
		s = append(s, "Options: "+mapStringForOptions+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *FlockerVolumeSource) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&k8s_io_api_core_v1.FlockerVolumeSource{")
	s = append(s, "DatasetName: "+fmt.Sprintf("%#v", this.DatasetName)+",\n")
	s = append(s, "DatasetUUID: "+fmt.Sprintf("%#v", this.DatasetUUID)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *GCEPersistentDiskVolumeSource) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&k8s_io_api_core_v1.GCEPersistentDiskVolumeSource{")
	s = append(s, "PdName: "+fmt.Sprintf("%#v", this.PdName)+",\n")
	s = append(s, "FsType: "+fmt.Sprintf("%#v", this.FsType)+",\n")
	s = append(s, "Partition: "+fmt.Sprintf("%#v", this.Partition)+",\n")
	s = append(s, "ReadOnly: "+fmt.Sprintf("%#v", this.ReadOnly)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *GitRepoVolumeSource) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&k8s_io_api_core_v1.GitRepoVolumeSource{")
	s = append(s, "Repository: "+fmt.Sprintf("%#v", this.Repository)+",\n")
	s = append(s, "Revision: "+fmt.Sprintf("%#v", this.Revision)+",\n")
	s = append(s, "Directory: "+fmt.Sprintf("%#v", this.Directory)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *GlusterfsPersistentVolumeSource) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&k8s_io_api_core_v1.GlusterfsPersistentVolumeSource{")
	s = append(s, "Endpoints: "+fmt.Sprintf("%#v", this.Endpoints)+",\n")
	s = append(s, "Path: "+fmt.Sprintf("%#v", this.Path)+",\n")
	s = append(s, "ReadOnly: "+fmt.Sprintf("%#v", this.ReadOnly)+",\n")
	s = append(s, "EndpointsNamespace: "+fmt.Sprintf("%#v", this.EndpointsNamespace)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *GlusterfsVolumeSource) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&k8s_io_api_core_v1.GlusterfsVolumeSource{")
	s = append(s, "Endpoints: "+fmt.Sprintf("%#v", this.Endpoints)+",\n")
	s = append(s, "Path: "+fmt.Sprintf("%#v", this.Path)+",\n")
	s = append(s, "ReadOnly: "+fmt.Sprintf("%#v", this.ReadOnly)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *HTTPGetAction) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 9)
	s = append(s, "&k8s_io_api_core_v1.HTTPGetAction{")
	s = append(s, "Path: "+fmt.Sprintf("%#v", this.Path)+",\n")
	if this.Port != nil {
		s = append(s, "Port: "+fmt.Sprintf("%#v", this.Port)+",\n")
	}
	s = append(s, "Host: "+fmt.Sprintf("%#v", this.Host)+",\n")
	s = append(s, "Scheme: "+fmt.Sprintf("%#v", this.Scheme)+",\n")
	if this.HttpHeaders != nil {
		s = append(s, "HttpHeaders: "+fmt.Sprintf("%#v", this.HttpHeaders)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *HTTPHeader) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&k8s_io_api_core_v1.HTTPHeader{")
	s = append(s, "Name: "+fmt.Sprintf("%#v", this.Name)+",\n")
	s = append(s, "Value: "+fmt.Sprintf("%#v", this.Value)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Handler) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&k8s_io_api_core_v1.Handler{")
	if this.Exec != nil {
		s = append(s, "Exec: "+fmt.Sprintf("%#v", this.Exec)+",\n")
	}
	if this.HttpGet != nil {
		s = append(s, "HttpGet: "+fmt.Sprintf("%#v", this.HttpGet)+",\n")
	}
	if this.TcpSocket != nil {
		s = append(s, "TcpSocket: "+fmt.Sprintf("%#v", this.TcpSocket)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *HostAlias) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&k8s_io_api_core_v1.HostAlias{")
	s = append(s, "Ip: "+fmt.Sprintf("%#v", this.Ip)+",\n")
	if this.Hostnames != nil {
		s = append(s, "Hostnames: "+fmt.Sprintf("%#v", this.Hostnames)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *HostPathVolumeSource) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&k8s_io_api_core_v1.HostPathVolumeSource{")
	s = append(s, "Path: "+fmt.Sprintf("%#v", this.Path)+",\n")
	s = append(s, "Type: "+fmt.Sprintf("%#v", this.Type)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ISCSIPersistentVolumeSource) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 15)
	s = append(s, "&k8s_io_api_core_v1.ISCSIPersistentVolumeSource{")
	s = append(s, "TargetPortal: "+fmt.Sprintf("%#v", this.TargetPortal)+",\n")
	s = append(s, "Iqn: "+fmt.Sprintf("%#v", this.Iqn)+",\n")
	s = append(s, "Lun: "+fmt.Sprintf("%#v", this.Lun)+",\n")
	s = append(s, "IscsiInterface: "+fmt.Sprintf("%#v", this.IscsiInterface)+",\n")
	s = append(s, "FsType: "+fmt.Sprintf("%#v", this.FsType)+",\n")
	s = append(s, "ReadOnly: "+fmt.Sprintf("%#v", this.ReadOnly)+",\n")
	if this.Portals != nil {
		s = append(s, "Portals: "+fmt.Sprintf("%#v", this.Portals)+",\n")
	}
	s = append(s, "ChapAuthDiscovery: "+fmt.Sprintf("%#v", this.ChapAuthDiscovery)+",\n")
	s = append(s, "ChapAuthSession: "+fmt.Sprintf("%#v", this.ChapAuthSession)+",\n")
	if this.SecretRef != nil {
		s = append(s, "SecretRef: "+fmt.Sprintf("%#v", this.SecretRef)+",\n")
	}
	s = append(s, "InitiatorName: "+fmt.Sprintf("%#v", this.InitiatorName)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ISCSIVolumeSource) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 15)
	s = append(s, "&k8s_io_api_core_v1.ISCSIVolumeSource{")
	s = append(s, "TargetPortal: "+fmt.Sprintf("%#v", this.TargetPortal)+",\n")
	s = append(s, "Iqn: "+fmt.Sprintf("%#v", this.Iqn)+",\n")
	s = append(s, "Lun: "+fmt.Sprintf("%#v", this.Lun)+",\n")
	s = append(s, "IscsiInterface: "+fmt.Sprintf("%#v", this.IscsiInterface)+",\n")
	s = append(s, "FsType: "+fmt.Sprintf("%#v", this.FsType)+",\n")
	s = append(s, "ReadOnly: "+fmt.Sprintf("%#v", this.ReadOnly)+",\n")
	if this.Portals != nil {
		s = append(s, "Portals: "+fmt.Sprintf("%#v", this.Portals)+",\n")
	}
	s = append(s, "ChapAuthDiscovery: "+fmt.Sprintf("%#v", this.ChapAuthDiscovery)+",\n")
	s = append(s, "ChapAuthSession: "+fmt.Sprintf("%#v", this.ChapAuthSession)+",\n")
	if this.SecretRef != nil {
		s = append(s, "SecretRef: "+fmt.Sprintf("%#v", this.SecretRef)+",\n")
	}
	s = append(s, "InitiatorName: "+fmt.Sprintf("%#v", this.InitiatorName)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *KeyToPath) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&k8s_io_api_core_v1.KeyToPath{")
	s = append(s, "Key: "+fmt.Sprintf("%#v", this.Key)+",\n")
	s = append(s, "Path: "+fmt.Sprintf("%#v", this.Path)+",\n")
	s = append(s, "Mode: "+fmt.Sprintf("%#v", this.Mode)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Lifecycle) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&k8s_io_api_core_v1.Lifecycle{")
	if this.PostStart != nil {
		s = append(s, "PostStart: "+fmt.Sprintf("%#v", this.PostStart)+",\n")
	}
	if this.PreStop != nil {
		s = append(s, "PreStop: "+fmt.Sprintf("%#v", this.PreStop)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *LimitRange) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&k8s_io_api_core_v1.LimitRange{")
	if this.Metadata != nil {
		s = append(s, "Metadata: "+fmt.Sprintf("%#v", this.Metadata)+",\n")
	}
	if this.Spec != nil {
		s = append(s, "Spec: "+fmt.Sprintf("%#v", this.Spec)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *LimitRangeItem) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 10)
	s = append(s, "&k8s_io_api_core_v1.LimitRangeItem{")
	s = append(s, "Type: "+fmt.Sprintf("%#v", this.Type)+",\n")
	keysForMax := make([]string, 0, len(this.Max))
	for k, _ := range this.Max {
		keysForMax = append(keysForMax, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForMax)
	mapStringForMax := "map[string]*resource.Quantity{"
	for _, k := range keysForMax {
		mapStringForMax += fmt.Sprintf("%#v: %#v,", k, this.Max[k])
	}
	mapStringForMax += "}"
	if this.Max != nil {
		s = append(s, "Max: "+mapStringForMax+",\n")
	}
	keysForMin := make([]string, 0, len(this.Min))
	for k, _ := range this.Min {
		keysForMin = append(keysForMin, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForMin)
	mapStringForMin := "map[string]*resource.Quantity{"
	for _, k := range keysForMin {
		mapStringForMin += fmt.Sprintf("%#v: %#v,", k, this.Min[k])
	}
	mapStringForMin += "}"
	if this.Min != nil {
		s = append(s, "Min: "+mapStringForMin+",\n")
	}
	keysForDefault := make([]string, 0, len(this.Default))
	for k, _ := range this.Default {
		keysForDefault = append(keysForDefault, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForDefault)
	mapStringForDefault := "map[string]*resource.Quantity{"
	for _, k := range keysForDefault {
		mapStringForDefault += fmt.Sprintf("%#v: %#v,", k, this.Default[k])
	}
	mapStringForDefault += "}"
	if this.Default != nil {
		s = append(s, "Default: "+mapStringForDefault+",\n")
	}
	keysForDefaultRequest := make([]string, 0, len(this.DefaultRequest))
	for k, _ := range this.DefaultRequest {
		keysForDefaultRequest = append(keysForDefaultRequest, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForDefaultRequest)
	mapStringForDefaultRequest := "map[string]*resource.Quantity{"
	for _, k := range keysForDefaultRequest {
		mapStringForDefaultRequest += fmt.Sprintf("%#v: %#v,", k, this.DefaultRequest[k])
	}
	mapStringForDefaultRequest += "}"
	if this.DefaultRequest != nil {
		s = append(s, "DefaultRequest: "+mapStringForDefaultRequest+",\n")
	}
	keysForMaxLimitRequestRatio := make([]string, 0, len(this.MaxLimitRequestRatio))
	for k, _ := range this.MaxLimitRequestRatio {
		keysForMaxLimitRequestRatio = append(keysForMaxLimitRequestRatio, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForMaxLimitRequestRatio)
	mapStringForMaxLimitRequestRatio := "map[string]*resource.Quantity{"
	for _, k := range keysForMaxLimitRequestRatio {
		mapStringForMaxLimitRequestRatio += fmt.Sprintf("%#v: %#v,", k, this.MaxLimitRequestRatio[k])
	}
	mapStringForMaxLimitRequestRatio += "}"
	if this.MaxLimitRequestRatio != nil {
		s = append(s, "MaxLimitRequestRatio: "+mapStringForMaxLimitRequestRatio+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *LimitRangeList) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&k8s_io_api_core_v1.LimitRangeList{")
	if this.Metadata != nil {
		s = append(s, "Metadata: "+fmt.Sprintf("%#v", this.Metadata)+",\n")
	}
	if this.Items != nil {
		s = append(s, "Items: "+fmt.Sprintf("%#v", this.Items)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *LimitRangeSpec) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&k8s_io_api_core_v1.LimitRangeSpec{")
	if this.Limits != nil {
		s = append(s, "Limits: "+fmt.Sprintf("%#v", this.Limits)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *List) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&k8s_io_api_core_v1.List{")
	if this.Metadata != nil {
		s = append(s, "Metadata: "+fmt.Sprintf("%#v", this.Metadata)+",\n")
	}
	if this.Items != nil {
		s = append(s, "Items: "+fmt.Sprintf("%#v", this.Items)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *LoadBalancerIngress) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&k8s_io_api_core_v1.LoadBalancerIngress{")
	s = append(s, "Ip: "+fmt.Sprintf("%#v", this.Ip)+",\n")
	s = append(s, "Hostname: "+fmt.Sprintf("%#v", this.Hostname)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *LoadBalancerStatus) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&k8s_io_api_core_v1.LoadBalancerStatus{")
	if this.Ingress != nil {
		s = append(s, "Ingress: "+fmt.Sprintf("%#v", this.Ingress)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *LocalObjectReference) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&k8s_io_api_core_v1.LocalObjectReference{")
	s = append(s, "Name: "+fmt.Sprintf("%#v", this.Name)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *LocalVolumeSource) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&k8s_io_api_core_v1.LocalVolumeSource{")
	s = append(s, "Path: "+fmt.Sprintf("%#v", this.Path)+",\n")
	s = append(s, "FsType: "+fmt.Sprintf("%#v", this.FsType)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *NFSVolumeSource) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&k8s_io_api_core_v1.NFSVolumeSource{")
	s = append(s, "Server: "+fmt.Sprintf("%#v", this.Server)+",\n")
	s = append(s, "Path: "+fmt.Sprintf("%#v", this.Path)+",\n")
	s = append(s, "ReadOnly: "+fmt.Sprintf("%#v", this.ReadOnly)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Namespace) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&k8s_io_api_core_v1.Namespace{")
	if this.Metadata != nil {
		s = append(s, "Metadata: "+fmt.Sprintf("%#v", this.Metadata)+",\n")
	}
	if this.Spec != nil {
		s = append(s, "Spec: "+fmt.Sprintf("%#v", this.Spec)+",\n")
	}
	if this.Status != nil {
		s = append(s, "Status: "+fmt.Sprintf("%#v", this.Status)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *NamespaceList) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&k8s_io_api_core_v1.NamespaceList{")
	if this.Metadata != nil {
		s = append(s, "Metadata: "+fmt.Sprintf("%#v", this.Metadata)+",\n")
	}
	if this.Items != nil {
		s = append(s, "Items: "+fmt.Sprintf("%#v", this.Items)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *NamespaceSpec) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&k8s_io_api_core_v1.NamespaceSpec{")
	if this.Finalizers != nil {
		s = append(s, "Finalizers: "+fmt.Sprintf("%#v", this.Finalizers)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *NamespaceStatus) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&k8s_io_api_core_v1.NamespaceStatus{")
	s = append(s, "Phase: "+fmt.Sprintf("%#v", this.Phase)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Node) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&k8s_io_api_core_v1.Node{")
	if this.Metadata != nil {
		s = append(s, "Metadata: "+fmt.Sprintf("%#v", this.Metadata)+",\n")
	}
	if this.Spec != nil {
		s = append(s, "Spec: "+fmt.Sprintf("%#v", this.Spec)+",\n")
	}
	if this.Status != nil {
		s = append(s, "Status: "+fmt.Sprintf("%#v", this.Status)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *NodeAddress) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&k8s_io_api_core_v1.NodeAddress{")
	s = append(s, "Type: "+fmt.Sprintf("%#v", this.Type)+",\n")
	s = append(s, "Address: "+fmt.Sprintf("%#v", this.Address)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *NodeAffinity) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&k8s_io_api_core_v1.NodeAffinity{")
	if this.RequiredDuringSchedulingIgnoredDuringExecution != nil {
		s = append(s, "RequiredDuringSchedulingIgnoredDuringExecution: "+fmt.Sprintf("%#v", this.RequiredDuringSchedulingIgnoredDuringExecution)+",\n")
	}
	if this.PreferredDuringSchedulingIgnoredDuringExecution != nil {
		s = append(s, "PreferredDuringSchedulingIgnoredDuringExecution: "+fmt.Sprintf("%#v", this.PreferredDuringSchedulingIgnoredDuringExecution)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *NodeCondition) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 10)
	s = append(s, "&k8s_io_api_core_v1.NodeCondition{")
	s = append(s, "Type: "+fmt.Sprintf("%#v", this.Type)+",\n")
	s = append(s, "Status: "+fmt.Sprintf("%#v", this.Status)+",\n")
	if this.LastHeartbeatTime != nil {
		s = append(s, "LastHeartbeatTime: "+fmt.Sprintf("%#v", this.LastHeartbeatTime)+",\n")
	}
	if this.LastTransitionTime != nil {
		s = append(s, "LastTransitionTime: "+fmt.Sprintf("%#v", this.LastTransitionTime)+",\n")
	}
	s = append(s, "Reason: "+fmt.Sprintf("%#v", this.Reason)+",\n")
	s = append(s, "Message: "+fmt.Sprintf("%#v", this.Message)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *NodeConfigSource) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&k8s_io_api_core_v1.NodeConfigSource{")
	if this.ConfigMap != nil {
		s = append(s, "ConfigMap: "+fmt.Sprintf("%#v", this.ConfigMap)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *NodeConfigStatus) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&k8s_io_api_core_v1.NodeConfigStatus{")
	if this.Assigned != nil {
		s = append(s, "Assigned: "+fmt.Sprintf("%#v", this.Assigned)+",\n")
	}
	if this.Active != nil {
		s = append(s, "Active: "+fmt.Sprintf("%#v", this.Active)+",\n")
	}
	if this.LastKnownGood != nil {
		s = append(s, "LastKnownGood: "+fmt.Sprintf("%#v", this.LastKnownGood)+",\n")
	}
	s = append(s, "Error: "+fmt.Sprintf("%#v", this.Error)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *NodeDaemonEndpoints) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&k8s_io_api_core_v1.NodeDaemonEndpoints{")
	if this.KubeletEndpoint != nil {
		s = append(s, "KubeletEndpoint: "+fmt.Sprintf("%#v", this.KubeletEndpoint)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *NodeList) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&k8s_io_api_core_v1.NodeList{")
	if this.Metadata != nil {
		s = append(s, "Metadata: "+fmt.Sprintf("%#v", this.Metadata)+",\n")
	}
	if this.Items != nil {
		s = append(s, "Items: "+fmt.Sprintf("%#v", this.Items)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *NodeProxyOptions) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&k8s_io_api_core_v1.NodeProxyOptions{")
	s = append(s, "Path: "+fmt.Sprintf("%#v", this.Path)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *NodeResources) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&k8s_io_api_core_v1.NodeResources{")
	keysForCapacity := make([]string, 0, len(this.Capacity))
	for k, _ := range this.Capacity {
		keysForCapacity = append(keysForCapacity, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForCapacity)
	mapStringForCapacity := "map[string]*resource.Quantity{"
	for _, k := range keysForCapacity {
		mapStringForCapacity += fmt.Sprintf("%#v: %#v,", k, this.Capacity[k])
	}
	mapStringForCapacity += "}"
	if this.Capacity != nil {
		s = append(s, "Capacity: "+mapStringForCapacity+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *NodeSelector) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&k8s_io_api_core_v1.NodeSelector{")
	if this.NodeSelectorTerms != nil {
		s = append(s, "NodeSelectorTerms: "+fmt.Sprintf("%#v", this.NodeSelectorTerms)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *NodeSelectorRequirement) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&k8s_io_api_core_v1.NodeSelectorRequirement{")
	s = append(s, "Key: "+fmt.Sprintf("%#v", this.Key)+",\n")
	s = append(s, "Operator: "+fmt.Sprintf("%#v", this.Operator)+",\n")
	if this.Values != nil {
		s = append(s, "Values: "+fmt.Sprintf("%#v", this.Values)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *NodeSelectorTerm) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&k8s_io_api_core_v1.NodeSelectorTerm{")
	if this.MatchExpressions != nil {
		s = append(s, "MatchExpressions: "+fmt.Sprintf("%#v", this.MatchExpressions)+",\n")
	}
	if this.MatchFields != nil {
		s = append(s, "MatchFields: "+fmt.Sprintf("%#v", this.MatchFields)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *NodeSpec) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 11)
	s = append(s, "&k8s_io_api_core_v1.NodeSpec{")
	s = append(s, "PodCIDR: "+fmt.Sprintf("%#v", this.PodCIDR)+",\n")
	if this.PodCIDRs != nil {
		s = append(s, "PodCIDRs: "+fmt.Sprintf("%#v", this.PodCIDRs)+",\n")
	}
	s = append(s, "ProviderID: "+fmt.Sprintf("%#v", this.ProviderID)+",\n")
	s = append(s, "Unschedulable: "+fmt.Sprintf("%#v", this.Unschedulable)+",\n")
	if this.Taints != nil {
		s = append(s, "Taints: "+fmt.Sprintf("%#v", this.Taints)+",\n")
	}
	if this.ConfigSource != nil {
		s = append(s, "ConfigSource: "+fmt.Sprintf("%#v", this.ConfigSource)+",\n")
	}
	s = append(s, "ExternalID: "+fmt.Sprintf("%#v", this.ExternalID)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *NodeStatus) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 15)
	s = append(s, "&k8s_io_api_core_v1.NodeStatus{")
	keysForCapacity := make([]string, 0, len(this.Capacity))
	for k, _ := range this.Capacity {
		keysForCapacity = append(keysForCapacity, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForCapacity)
	mapStringForCapacity := "map[string]*resource.Quantity{"
	for _, k := range keysForCapacity {
		mapStringForCapacity += fmt.Sprintf("%#v: %#v,", k, this.Capacity[k])
	}
	mapStringForCapacity += "}"
	if this.Capacity != nil {
		s = append(s, "Capacity: "+mapStringForCapacity+",\n")
	}
	keysForAllocatable := make([]string, 0, len(this.Allocatable))
	for k, _ := range this.Allocatable {
		keysForAllocatable = append(keysForAllocatable, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForAllocatable)
	mapStringForAllocatable := "map[string]*resource.Quantity{"
	for _, k := range keysForAllocatable {
		mapStringForAllocatable += fmt.Sprintf("%#v: %#v,", k, this.Allocatable[k])
	}
	mapStringForAllocatable += "}"
	if this.Allocatable != nil {
		s = append(s, "Allocatable: "+mapStringForAllocatable+",\n")
	}
	s = append(s, "Phase: "+fmt.Sprintf("%#v", this.Phase)+",\n")
	if this.Conditions != nil {
		s = append(s, "Conditions: "+fmt.Sprintf("%#v", this.Conditions)+",\n")
	}
	if this.Addresses != nil {
		s = append(s, "Addresses: "+fmt.Sprintf("%#v", this.Addresses)+",\n")
	}
	if this.DaemonEndpoints != nil {
		s = append(s, "DaemonEndpoints: "+fmt.Sprintf("%#v", this.DaemonEndpoints)+",\n")
	}
	if this.NodeInfo != nil {
		s = append(s, "NodeInfo: "+fmt.Sprintf("%#v", this.NodeInfo)+",\n")
	}
	if this.Images != nil {
		s = append(s, "Images: "+fmt.Sprintf("%#v", this.Images)+",\n")
	}
	if this.VolumesInUse != nil {
		s = append(s, "VolumesInUse: "+fmt.Sprintf("%#v", this.VolumesInUse)+",\n")
	}
	if this.VolumesAttached != nil {
		s = append(s, "VolumesAttached: "+fmt.Sprintf("%#v", this.VolumesAttached)+",\n")
	}
	if this.Config != nil {
		s = append(s, "Config: "+fmt.Sprintf("%#v", this.Config)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *NodeSystemInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 14)
	s = append(s, "&k8s_io_api_core_v1.NodeSystemInfo{")
	s = append(s, "MachineID: "+fmt.Sprintf("%#v", this.MachineID)+",\n")
	s = append(s, "SystemUUID: "+fmt.Sprintf("%#v", this.SystemUUID)+",\n")
	s = append(s, "BootID: "+fmt.Sprintf("%#v", this.BootID)+",\n")
	s = append(s, "KernelVersion: "+fmt.Sprintf("%#v", this.KernelVersion)+",\n")
	s = append(s, "OsImage: "+fmt.Sprintf("%#v", this.OsImage)+",\n")
	s = append(s, "ContainerRuntimeVersion: "+fmt.Sprintf("%#v", this.ContainerRuntimeVersion)+",\n")
	s = append(s, "KubeletVersion: "+fmt.Sprintf("%#v", this.KubeletVersion)+",\n")
	s = append(s, "KubeProxyVersion: "+fmt.Sprintf("%#v", this.KubeProxyVersion)+",\n")
	s = append(s, "OperatingSystem: "+fmt.Sprintf("%#v", this.OperatingSystem)+",\n")
	s = append(s, "Architecture: "+fmt.Sprintf("%#v", this.Architecture)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ObjectFieldSelector) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&k8s_io_api_core_v1.ObjectFieldSelector{")
	s = append(s, "ApiVersion: "+fmt.Sprintf("%#v", this.ApiVersion)+",\n")
	s = append(s, "FieldPath: "+fmt.Sprintf("%#v", this.FieldPath)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ObjectReference) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 11)
	s = append(s, "&k8s_io_api_core_v1.ObjectReference{")
	s = append(s, "Kind: "+fmt.Sprintf("%#v", this.Kind)+",\n")
	s = append(s, "Namespace: "+fmt.Sprintf("%#v", this.Namespace)+",\n")
	s = append(s, "Name: "+fmt.Sprintf("%#v", this.Name)+",\n")
	s = append(s, "Uid: "+fmt.Sprintf("%#v", this.Uid)+",\n")
	s = append(s, "ApiVersion: "+fmt.Sprintf("%#v", this.ApiVersion)+",\n")
	s = append(s, "ResourceVersion: "+fmt.Sprintf("%#v", this.ResourceVersion)+",\n")
	s = append(s, "FieldPath: "+fmt.Sprintf("%#v", this.FieldPath)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *PersistentVolume) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&k8s_io_api_core_v1.PersistentVolume{")
	if this.Metadata != nil {
		s = append(s, "Metadata: "+fmt.Sprintf("%#v", this.Metadata)+",\n")
	}
	if this.Spec != nil {
		s = append(s, "Spec: "+fmt.Sprintf("%#v", this.Spec)+",\n")
	}
	if this.Status != nil {
		s = append(s, "Status: "+fmt.Sprintf("%#v", this.Status)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *PersistentVolumeClaim) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&k8s_io_api_core_v1.PersistentVolumeClaim{")
	if this.Metadata != nil {
		s = append(s, "Metadata: "+fmt.Sprintf("%#v", this.Metadata)+",\n")
	}
	if this.Spec != nil {
		s = append(s, "Spec: "+fmt.Sprintf("%#v", this.Spec)+",\n")
	}
	if this.Status != nil {
		s = append(s, "Status: "+fmt.Sprintf("%#v", this.Status)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *PersistentVolumeClaimCondition) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 10)
	s = append(s, "&k8s_io_api_core_v1.PersistentVolumeClaimCondition{")
	s = append(s, "Type: "+fmt.Sprintf("%#v", this.Type)+",\n")
	s = append(s, "Status: "+fmt.Sprintf("%#v", this.Status)+",\n")
	if this.LastProbeTime != nil {
		s = append(s, "LastProbeTime: "+fmt.Sprintf("%#v", this.LastProbeTime)+",\n")
	}
	if this.LastTransitionTime != nil {
		s = append(s, "LastTransitionTime: "+fmt.Sprintf("%#v", this.LastTransitionTime)+",\n")
	}
	s = append(s, "Reason: "+fmt.Sprintf("%#v", this.Reason)+",\n")
	s = append(s, "Message: "+fmt.Sprintf("%#v", this.Message)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *PersistentVolumeClaimList) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&k8s_io_api_core_v1.PersistentVolumeClaimList{")
	if this.Metadata != nil {
		s = append(s, "Metadata: "+fmt.Sprintf("%#v", this.Metadata)+",\n")
	}
	if this.Items != nil {
		s = append(s, "Items: "+fmt.Sprintf("%#v", this.Items)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *PersistentVolumeClaimSpec) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 11)
	s = append(s, "&k8s_io_api_core_v1.PersistentVolumeClaimSpec{")
	if this.AccessModes != nil {
		s = append(s, "AccessModes: "+fmt.Sprintf("%#v", this.AccessModes)+",\n")
	}
	if this.Selector != nil {
		s = append(s, "Selector: "+fmt.Sprintf("%#v", this.Selector)+",\n")
	}
	if this.Resources != nil {
		s = append(s, "Resources: "+fmt.Sprintf("%#v", this.Resources)+",\n")
	}
	s = append(s, "VolumeName: "+fmt.Sprintf("%#v", this.VolumeName)+",\n")
	s = append(s, "StorageClassName: "+fmt.Sprintf("%#v", this.StorageClassName)+",\n")
	s = append(s, "VolumeMode: "+fmt.Sprintf("%#v", this.VolumeMode)+",\n")
	if this.DataSource != nil {
		s = append(s, "DataSource: "+fmt.Sprintf("%#v", this.DataSource)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *PersistentVolumeClaimStatus) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&k8s_io_api_core_v1.PersistentVolumeClaimStatus{")
	s = append(s, "Phase: "+fmt.Sprintf("%#v", this.Phase)+",\n")
	if this.AccessModes != nil {
		s = append(s, "AccessModes: "+fmt.Sprintf("%#v", this.AccessModes)+",\n")
	}
	keysForCapacity := make([]string, 0, len(this.Capacity))
	for k, _ := range this.Capacity {
		keysForCapacity = append(keysForCapacity, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForCapacity)
	mapStringForCapacity := "map[string]*resource.Quantity{"
	for _, k := range keysForCapacity {
		mapStringForCapacity += fmt.Sprintf("%#v: %#v,", k, this.Capacity[k])
	}
	mapStringForCapacity += "}"
	if this.Capacity != nil {
		s = append(s, "Capacity: "+mapStringForCapacity+",\n")
	}
	if this.Conditions != nil {
		s = append(s, "Conditions: "+fmt.Sprintf("%#v", this.Conditions)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *PersistentVolumeClaimVolumeSource) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&k8s_io_api_core_v1.PersistentVolumeClaimVolumeSource{")
	s = append(s, "ClaimName: "+fmt.Sprintf("%#v", this.ClaimName)+",\n")
	s = append(s, "ReadOnly: "+fmt.Sprintf("%#v", this.ReadOnly)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *PersistentVolumeList) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&k8s_io_api_core_v1.PersistentVolumeList{")
	if this.Metadata != nil {
		s = append(s, "Metadata: "+fmt.Sprintf("%#v", this.Metadata)+",\n")
	}
	if this.Items != nil {
		s = append(s, "Items: "+fmt.Sprintf("%#v", this.Items)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *PersistentVolumeSource) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 26)
	s = append(s, "&k8s_io_api_core_v1.PersistentVolumeSource{")
	if this.GcePersistentDisk != nil {
		s = append(s, "GcePersistentDisk: "+fmt.Sprintf("%#v", this.GcePersistentDisk)+",\n")
	}
	if this.AwsElasticBlockStore != nil {
		s = append(s, "AwsElasticBlockStore: "+fmt.Sprintf("%#v", this.AwsElasticBlockStore)+",\n")
	}
	if this.HostPath != nil {
		s = append(s, "HostPath: "+fmt.Sprintf("%#v", this.HostPath)+",\n")
	}
	if this.Glusterfs != nil {
		s = append(s, "Glusterfs: "+fmt.Sprintf("%#v", this.Glusterfs)+",\n")
	}
	if this.Nfs != nil {
		s = append(s, "Nfs: "+fmt.Sprintf("%#v", this.Nfs)+",\n")
	}
	if this.Rbd != nil {
		s = append(s, "Rbd: "+fmt.Sprintf("%#v", this.Rbd)+",\n")
	}
	if this.Iscsi != nil {
		s = append(s, "Iscsi: "+fmt.Sprintf("%#v", this.Iscsi)+",\n")
	}
	if this.Cinder != nil {
		s = append(s, "Cinder: "+fmt.Sprintf("%#v", this.Cinder)+",\n")
	}
	if this.Cephfs != nil {
		s = append(s, "Cephfs: "+fmt.Sprintf("%#v", this.Cephfs)+",\n")
	}
	if this.Fc != nil {
		s = append(s, "Fc: "+fmt.Sprintf("%#v", this.Fc)+",\n")
	}
	if this.Flocker != nil {
		s = append(s, "Flocker: "+fmt.Sprintf("%#v", this.Flocker)+",\n")
	}
	if this.FlexVolume != nil {
		s = append(s, "FlexVolume: "+fmt.Sprintf("%#v", this.FlexVolume)+",\n")
	}
	if this.AzureFile != nil {
		s = append(s, "AzureFile: "+fmt.Sprintf("%#v", this.AzureFile)+",\n")
	}
	if this.VsphereVolume != nil {
		s = append(s, "VsphereVolume: "+fmt.Sprintf("%#v", this.VsphereVolume)+",\n")
	}
	if this.Quobyte != nil {
		s = append(s, "Quobyte: "+fmt.Sprintf("%#v", this.Quobyte)+",\n")
	}
	if this.AzureDisk != nil {
		s = append(s, "AzureDisk: "+fmt.Sprintf("%#v", this.AzureDisk)+",\n")
	}
	if this.PhotonPersistentDisk != nil {
		s = append(s, "PhotonPersistentDisk: "+fmt.Sprintf("%#v", this.PhotonPersistentDisk)+",\n")
	}
	if this.PortworxVolume != nil {
		s = append(s, "PortworxVolume: "+fmt.Sprintf("%#v", this.PortworxVolume)+",\n")
	}
	if this.ScaleIO != nil {
		s = append(s, "ScaleIO: "+fmt.Sprintf("%#v", this.ScaleIO)+",\n")
	}
	if this.Local != nil {
		s = append(s, "Local: "+fmt.Sprintf("%#v", this.Local)+",\n")
	}
	if this.Storageos != nil {
		s = append(s, "Storageos: "+fmt.Sprintf("%#v", this.Storageos)+",\n")
	}
	if this.Csi != nil {
		s = append(s, "Csi: "+fmt.Sprintf("%#v", this.Csi)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *PersistentVolumeSpec) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 13)
	s = append(s, "&k8s_io_api_core_v1.PersistentVolumeSpec{")
	keysForCapacity := make([]string, 0, len(this.Capacity))
	for k, _ := range this.Capacity {
		keysForCapacity = append(keysForCapacity, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForCapacity)
	mapStringForCapacity := "map[string]*resource.Quantity{"
	for _, k := range keysForCapacity {
		mapStringForCapacity += fmt.Sprintf("%#v: %#v,", k, this.Capacity[k])
	}
	mapStringForCapacity += "}"
	if this.Capacity != nil {
		s = append(s, "Capacity: "+mapStringForCapacity+",\n")
	}
	if this.PersistentVolumeSource != nil {
		s = append(s, "PersistentVolumeSource: "+fmt.Sprintf("%#v", this.PersistentVolumeSource)+",\n")
	}
	if this.AccessModes != nil {
		s = append(s, "AccessModes: "+fmt.Sprintf("%#v", this.AccessModes)+",\n")
	}
	if this.ClaimRef != nil {
		s = append(s, "ClaimRef: "+fmt.Sprintf("%#v", this.ClaimRef)+",\n")
	}
	s = append(s, "PersistentVolumeReclaimPolicy: "+fmt.Sprintf("%#v", this.PersistentVolumeReclaimPolicy)+",\n")
	s = append(s, "StorageClassName: "+fmt.Sprintf("%#v", this.StorageClassName)+",\n")
	if this.MountOptions != nil {
		s = append(s, "MountOptions: "+fmt.Sprintf("%#v", this.MountOptions)+",\n")
	}
	s = append(s, "VolumeMode: "+fmt.Sprintf("%#v", this.VolumeMode)+",\n")
	if this.NodeAffinity != nil {
		s = append(s, "NodeAffinity: "+fmt.Sprintf("%#v", this.NodeAffinity)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *PersistentVolumeStatus) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&k8s_io_api_core_v1.PersistentVolumeStatus{")
	s = append(s, "Phase: "+fmt.Sprintf("%#v", this.Phase)+",\n")
	s = append(s, "Message: "+fmt.Sprintf("%#v", this.Message)+",\n")
	s = append(s, "Reason: "+fmt.Sprintf("%#v", this.Reason)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *PhotonPersistentDiskVolumeSource) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&k8s_io_api_core_v1.PhotonPersistentDiskVolumeSource{")
	s = append(s, "PdID: "+fmt.Sprintf("%#v", this.PdID)+",\n")
	s = append(s, "FsType: "+fmt.Sprintf("%#v", this.FsType)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Pod) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&k8s_io_api_core_v1.Pod{")
	if this.Metadata != nil {
		s = append(s, "Metadata: "+fmt.Sprintf("%#v", this.Metadata)+",\n")
	}
	if this.Spec != nil {
		s = append(s, "Spec: "+fmt.Sprintf("%#v", this.Spec)+",\n")
	}
	if this.Status != nil {
		s = append(s, "Status: "+fmt.Sprintf("%#v", this.Status)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *PodAffinity) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&k8s_io_api_core_v1.PodAffinity{")
	if this.RequiredDuringSchedulingIgnoredDuringExecution != nil {
		s = append(s, "RequiredDuringSchedulingIgnoredDuringExecution: "+fmt.Sprintf("%#v", this.RequiredDuringSchedulingIgnoredDuringExecution)+",\n")
	}
	if this.PreferredDuringSchedulingIgnoredDuringExecution != nil {
		s = append(s, "PreferredDuringSchedulingIgnoredDuringExecution: "+fmt.Sprintf("%#v", this.PreferredDuringSchedulingIgnoredDuringExecution)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *PodAffinityTerm) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&k8s_io_api_core_v1.PodAffinityTerm{")
	if this.LabelSelector != nil {
		s = append(s, "LabelSelector: "+fmt.Sprintf("%#v", this.LabelSelector)+",\n")
	}
	if this.Namespaces != nil {
		s = append(s, "Namespaces: "+fmt.Sprintf("%#v", this.Namespaces)+",\n")
	}
	s = append(s, "TopologyKey: "+fmt.Sprintf("%#v", this.TopologyKey)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *PodAntiAffinity) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&k8s_io_api_core_v1.PodAntiAffinity{")
	if this.RequiredDuringSchedulingIgnoredDuringExecution != nil {
		s = append(s, "RequiredDuringSchedulingIgnoredDuringExecution: "+fmt.Sprintf("%#v", this.RequiredDuringSchedulingIgnoredDuringExecution)+",\n")
	}
	if this.PreferredDuringSchedulingIgnoredDuringExecution != nil {
		s = append(s, "PreferredDuringSchedulingIgnoredDuringExecution: "+fmt.Sprintf("%#v", this.PreferredDuringSchedulingIgnoredDuringExecution)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *PodAttachOptions) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 9)
	s = append(s, "&k8s_io_api_core_v1.PodAttachOptions{")
	s = append(s, "Stdin: "+fmt.Sprintf("%#v", this.Stdin)+",\n")
	s = append(s, "Stdout: "+fmt.Sprintf("%#v", this.Stdout)+",\n")
	s = append(s, "Stderr: "+fmt.Sprintf("%#v", this.Stderr)+",\n")
	s = append(s, "Tty: "+fmt.Sprintf("%#v", this.Tty)+",\n")
	s = append(s, "Container: "+fmt.Sprintf("%#v", this.Container)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *PodCondition) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 10)
	s = append(s, "&k8s_io_api_core_v1.PodCondition{")
	s = append(s, "Type: "+fmt.Sprintf("%#v", this.Type)+",\n")
	s = append(s, "Status: "+fmt.Sprintf("%#v", this.Status)+",\n")
	if this.LastProbeTime != nil {
		s = append(s, "LastProbeTime: "+fmt.Sprintf("%#v", this.LastProbeTime)+",\n")
	}
	if this.LastTransitionTime != nil {
		s = append(s, "LastTransitionTime: "+fmt.Sprintf("%#v", this.LastTransitionTime)+",\n")
	}
	s = append(s, "Reason: "+fmt.Sprintf("%#v", this.Reason)+",\n")
	s = append(s, "Message: "+fmt.Sprintf("%#v", this.Message)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *PodDNSConfig) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&k8s_io_api_core_v1.PodDNSConfig{")
	if this.Nameservers != nil {
		s = append(s, "Nameservers: "+fmt.Sprintf("%#v", this.Nameservers)+",\n")
	}
	if this.Searches != nil {
		s = append(s, "Searches: "+fmt.Sprintf("%#v", this.Searches)+",\n")
	}
	if this.Options != nil {
		s = append(s, "Options: "+fmt.Sprintf("%#v", this.Options)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *PodDNSConfigOption) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&k8s_io_api_core_v1.PodDNSConfigOption{")
	s = append(s, "Name: "+fmt.Sprintf("%#v", this.Name)+",\n")
	s = append(s, "Value: "+fmt.Sprintf("%#v", this.Value)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *PodExecOptions) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 10)
	s = append(s, "&k8s_io_api_core_v1.PodExecOptions{")
	s = append(s, "Stdin: "+fmt.Sprintf("%#v", this.Stdin)+",\n")
	s = append(s, "Stdout: "+fmt.Sprintf("%#v", this.Stdout)+",\n")
	s = append(s, "Stderr: "+fmt.Sprintf("%#v", this.Stderr)+",\n")
	s = append(s, "Tty: "+fmt.Sprintf("%#v", this.Tty)+",\n")
	s = append(s, "Container: "+fmt.Sprintf("%#v", this.Container)+",\n")
	if this.Command != nil {
		s = append(s, "Command: "+fmt.Sprintf("%#v", this.Command)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *PodIP) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&k8s_io_api_core_v1.PodIP{")
	s = append(s, "Ip: "+fmt.Sprintf("%#v", this.Ip)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *PodList) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&k8s_io_api_core_v1.PodList{")
	if this.Metadata != nil {
		s = append(s, "Metadata: "+fmt.Sprintf("%#v", this.Metadata)+",\n")
	}
	if this.Items != nil {
		s = append(s, "Items: "+fmt.Sprintf("%#v", this.Items)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *PodLogOptions) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 12)
	s = append(s, "&k8s_io_api_core_v1.PodLogOptions{")
	s = append(s, "Container: "+fmt.Sprintf("%#v", this.Container)+",\n")
	s = append(s, "Follow: "+fmt.Sprintf("%#v", this.Follow)+",\n")
	s = append(s, "Previous: "+fmt.Sprintf("%#v", this.Previous)+",\n")
	s = append(s, "SinceSeconds: "+fmt.Sprintf("%#v", this.SinceSeconds)+",\n")
	if this.SinceTime != nil {
		s = append(s, "SinceTime: "+fmt.Sprintf("%#v", this.SinceTime)+",\n")
	}
	s = append(s, "Timestamps: "+fmt.Sprintf("%#v", this.Timestamps)+",\n")
	s = append(s, "TailLines: "+fmt.Sprintf("%#v", this.TailLines)+",\n")
	s = append(s, "LimitBytes: "+fmt.Sprintf("%#v", this.LimitBytes)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *PodPortForwardOptions) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&k8s_io_api_core_v1.PodPortForwardOptions{")
	if this.Ports != nil {
		s = append(s, "Ports: "+fmt.Sprintf("%#v", this.Ports)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *PodProxyOptions) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&k8s_io_api_core_v1.PodProxyOptions{")
	s = append(s, "Path: "+fmt.Sprintf("%#v", this.Path)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *PodReadinessGate) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&k8s_io_api_core_v1.PodReadinessGate{")
	s = append(s, "ConditionType: "+fmt.Sprintf("%#v", this.ConditionType)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *PodSecurityContext) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 12)
	s = append(s, "&k8s_io_api_core_v1.PodSecurityContext{")
	if this.SeLinuxOptions != nil {
		s = append(s, "SeLinuxOptions: "+fmt.Sprintf("%#v", this.SeLinuxOptions)+",\n")
	}
	if this.WindowsOptions != nil {
		s = append(s, "WindowsOptions: "+fmt.Sprintf("%#v", this.WindowsOptions)+",\n")
	}
	s = append(s, "RunAsUser: "+fmt.Sprintf("%#v", this.RunAsUser)+",\n")
	s = append(s, "RunAsGroup: "+fmt.Sprintf("%#v", this.RunAsGroup)+",\n")
	s = append(s, "RunAsNonRoot: "+fmt.Sprintf("%#v", this.RunAsNonRoot)+",\n")
	if this.SupplementalGroups != nil {
		s = append(s, "SupplementalGroups: "+fmt.Sprintf("%#v", this.SupplementalGroups)+",\n")
	}
	s = append(s, "FsGroup: "+fmt.Sprintf("%#v", this.FsGroup)+",\n")
	if this.Sysctls != nil {
		s = append(s, "Sysctls: "+fmt.Sprintf("%#v", this.Sysctls)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *PodSignature) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&k8s_io_api_core_v1.PodSignature{")
	if this.PodController != nil {
		s = append(s, "PodController: "+fmt.Sprintf("%#v", this.PodController)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *PodSpec) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 38)
	s = append(s, "&k8s_io_api_core_v1.PodSpec{")
	if this.Volumes != nil {
		s = append(s, "Volumes: "+fmt.Sprintf("%#v", this.Volumes)+",\n")
	}
	if this.InitContainers != nil {
		s = append(s, "InitContainers: "+fmt.Sprintf("%#v", this.InitContainers)+",\n")
	}
	if this.Containers != nil {
		s = append(s, "Containers: "+fmt.Sprintf("%#v", this.Containers)+",\n")
	}
	if this.EphemeralContainers != nil {
		s = append(s, "EphemeralContainers: "+fmt.Sprintf("%#v", this.EphemeralContainers)+",\n")
	}
	s = append(s, "RestartPolicy: "+fmt.Sprintf("%#v", this.RestartPolicy)+",\n")
	s = append(s, "TerminationGracePeriodSeconds: "+fmt.Sprintf("%#v", this.TerminationGracePeriodSeconds)+",\n")
	s = append(s, "ActiveDeadlineSeconds: "+fmt.Sprintf("%#v", this.ActiveDeadlineSeconds)+",\n")
	s = append(s, "DnsPolicy: "+fmt.Sprintf("%#v", this.DnsPolicy)+",\n")
	keysForNodeSelector := make([]string, 0, len(this.NodeSelector))
	for k, _ := range this.NodeSelector {
		keysForNodeSelector = append(keysForNodeSelector, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForNodeSelector)
	mapStringForNodeSelector := "map[string]string{"
	for _, k := range keysForNodeSelector {
		mapStringForNodeSelector += fmt.Sprintf("%#v: %#v,", k, this.NodeSelector[k])
	}
	mapStringForNodeSelector += "}"
	if this.NodeSelector != nil {
		s = append(s, "NodeSelector: "+mapStringForNodeSelector+",\n")
	}
	s = append(s, "ServiceAccountName: "+fmt.Sprintf("%#v", this.ServiceAccountName)+",\n")
	s = append(s, "ServiceAccount: "+fmt.Sprintf("%#v", this.ServiceAccount)+",\n")
	s = append(s, "AutomountServiceAccountToken: "+fmt.Sprintf("%#v", this.AutomountServiceAccountToken)+",\n")
	s = append(s, "NodeName: "+fmt.Sprintf("%#v", this.NodeName)+",\n")
	s = append(s, "HostNetwork: "+fmt.Sprintf("%#v", this.HostNetwork)+",\n")
	s = append(s, "HostPID: "+fmt.Sprintf("%#v", this.HostPID)+",\n")
	s = append(s, "HostIPC: "+fmt.Sprintf("%#v", this.HostIPC)+",\n")
	s = append(s, "ShareProcessNamespace: "+fmt.Sprintf("%#v", this.ShareProcessNamespace)+",\n")
	if this.SecurityContext != nil {
		s = append(s, "SecurityContext: "+fmt.Sprintf("%#v", this.SecurityContext)+",\n")
	}
	if this.ImagePullSecrets != nil {
		s = append(s, "ImagePullSecrets: "+fmt.Sprintf("%#v", this.ImagePullSecrets)+",\n")
	}
	s = append(s, "Hostname: "+fmt.Sprintf("%#v", this.Hostname)+",\n")
	s = append(s, "Subdomain: "+fmt.Sprintf("%#v", this.Subdomain)+",\n")
	if this.Affinity != nil {
		s = append(s, "Affinity: "+fmt.Sprintf("%#v", this.Affinity)+",\n")
	}
	s = append(s, "SchedulerName: "+fmt.Sprintf("%#v", this.SchedulerName)+",\n")
	if this.Tolerations != nil {
		s = append(s, "Tolerations: "+fmt.Sprintf("%#v", this.Tolerations)+",\n")
	}
	if this.HostAliases != nil {
		s = append(s, "HostAliases: "+fmt.Sprintf("%#v", this.HostAliases)+",\n")
	}
	s = append(s, "PriorityClassName: "+fmt.Sprintf("%#v", this.PriorityClassName)+",\n")
	s = append(s, "Priority: "+fmt.Sprintf("%#v", this.Priority)+",\n")
	if this.DnsConfig != nil {
		s = append(s, "DnsConfig: "+fmt.Sprintf("%#v", this.DnsConfig)+",\n")
	}
	if this.ReadinessGates != nil {
		s = append(s, "ReadinessGates: "+fmt.Sprintf("%#v", this.ReadinessGates)+",\n")
	}
	s = append(s, "RuntimeClassName: "+fmt.Sprintf("%#v", this.RuntimeClassName)+",\n")
	s = append(s, "EnableServiceLinks: "+fmt.Sprintf("%#v", this.EnableServiceLinks)+",\n")
	s = append(s, "PreemptionPolicy: "+fmt.Sprintf("%#v", this.PreemptionPolicy)+",\n")
	keysForOverhead := make([]string, 0, len(this.Overhead))
	for k, _ := range this.Overhead {
		keysForOverhead = append(keysForOverhead, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForOverhead)
	mapStringForOverhead := "map[string]*resource.Quantity{"
	for _, k := range keysForOverhead {
		mapStringForOverhead += fmt.Sprintf("%#v: %#v,", k, this.Overhead[k])
	}
	mapStringForOverhead += "}"
	if this.Overhead != nil {
		s = append(s, "Overhead: "+mapStringForOverhead+",\n")
	}
	if this.TopologySpreadConstraints != nil {
		s = append(s, "TopologySpreadConstraints: "+fmt.Sprintf("%#v", this.TopologySpreadConstraints)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *PodStatus) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 17)
	s = append(s, "&k8s_io_api_core_v1.PodStatus{")
	s = append(s, "Phase: "+fmt.Sprintf("%#v", this.Phase)+",\n")
	if this.Conditions != nil {
		s = append(s, "Conditions: "+fmt.Sprintf("%#v", this.Conditions)+",\n")
	}
	s = append(s, "Message: "+fmt.Sprintf("%#v", this.Message)+",\n")
	s = append(s, "Reason: "+fmt.Sprintf("%#v", this.Reason)+",\n")
	s = append(s, "NominatedNodeName: "+fmt.Sprintf("%#v", this.NominatedNodeName)+",\n")
	s = append(s, "HostIP: "+fmt.Sprintf("%#v", this.HostIP)+",\n")
	s = append(s, "PodIP: "+fmt.Sprintf("%#v", this.PodIP)+",\n")
	if this.PodIPs != nil {
		s = append(s, "PodIPs: "+fmt.Sprintf("%#v", this.PodIPs)+",\n")
	}
	if this.StartTime != nil {
		s = append(s, "StartTime: "+fmt.Sprintf("%#v", this.StartTime)+",\n")
	}
	if this.InitContainerStatuses != nil {
		s = append(s, "InitContainerStatuses: "+fmt.Sprintf("%#v", this.InitContainerStatuses)+",\n")
	}
	if this.ContainerStatuses != nil {
		s = append(s, "ContainerStatuses: "+fmt.Sprintf("%#v", this.ContainerStatuses)+",\n")
	}
	s = append(s, "QosClass: "+fmt.Sprintf("%#v", this.QosClass)+",\n")
	if this.EphemeralContainerStatuses != nil {
		s = append(s, "EphemeralContainerStatuses: "+fmt.Sprintf("%#v", this.EphemeralContainerStatuses)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *PodStatusResult) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&k8s_io_api_core_v1.PodStatusResult{")
	if this.Metadata != nil {
		s = append(s, "Metadata: "+fmt.Sprintf("%#v", this.Metadata)+",\n")
	}
	if this.Status != nil {
		s = append(s, "Status: "+fmt.Sprintf("%#v", this.Status)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *PodTemplate) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&k8s_io_api_core_v1.PodTemplate{")
	if this.Metadata != nil {
		s = append(s, "Metadata: "+fmt.Sprintf("%#v", this.Metadata)+",\n")
	}
	if this.Template != nil {
		s = append(s, "Template: "+fmt.Sprintf("%#v", this.Template)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *PodTemplateList) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&k8s_io_api_core_v1.PodTemplateList{")
	if this.Metadata != nil {
		s = append(s, "Metadata: "+fmt.Sprintf("%#v", this.Metadata)+",\n")
	}
	if this.Items != nil {
		s = append(s, "Items: "+fmt.Sprintf("%#v", this.Items)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *PodTemplateSpec) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&k8s_io_api_core_v1.PodTemplateSpec{")
	if this.Metadata != nil {
		s = append(s, "Metadata: "+fmt.Sprintf("%#v", this.Metadata)+",\n")
	}
	if this.Spec != nil {
		s = append(s, "Spec: "+fmt.Sprintf("%#v", this.Spec)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *PortworxVolumeSource) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&k8s_io_api_core_v1.PortworxVolumeSource{")
	s = append(s, "VolumeID: "+fmt.Sprintf("%#v", this.VolumeID)+",\n")
	s = append(s, "FsType: "+fmt.Sprintf("%#v", this.FsType)+",\n")
	s = append(s, "ReadOnly: "+fmt.Sprintf("%#v", this.ReadOnly)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Preconditions) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&k8s_io_api_core_v1.Preconditions{")
	s = append(s, "Uid: "+fmt.Sprintf("%#v", this.Uid)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *PreferAvoidPodsEntry) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&k8s_io_api_core_v1.PreferAvoidPodsEntry{")
	if this.PodSignature != nil {
		s = append(s, "PodSignature: "+fmt.Sprintf("%#v", this.PodSignature)+",\n")
	}
	if this.EvictionTime != nil {
		s = append(s, "EvictionTime: "+fmt.Sprintf("%#v", this.EvictionTime)+",\n")
	}
	s = append(s, "Reason: "+fmt.Sprintf("%#v", this.Reason)+",\n")
	s = append(s, "Message: "+fmt.Sprintf("%#v", this.Message)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *PreferredSchedulingTerm) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&k8s_io_api_core_v1.PreferredSchedulingTerm{")
	s = append(s, "Weight: "+fmt.Sprintf("%#v", this.Weight)+",\n")
	if this.Preference != nil {
		s = append(s, "Preference: "+fmt.Sprintf("%#v", this.Preference)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Probe) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 10)
	s = append(s, "&k8s_io_api_core_v1.Probe{")
	if this.Handler != nil {
		s = append(s, "Handler: "+fmt.Sprintf("%#v", this.Handler)+",\n")
	}
	s = append(s, "InitialDelaySeconds: "+fmt.Sprintf("%#v", this.InitialDelaySeconds)+",\n")
	s = append(s, "TimeoutSeconds: "+fmt.Sprintf("%#v", this.TimeoutSeconds)+",\n")
	s = append(s, "PeriodSeconds: "+fmt.Sprintf("%#v", this.PeriodSeconds)+",\n")
	s = append(s, "SuccessThreshold: "+fmt.Sprintf("%#v", this.SuccessThreshold)+",\n")
	s = append(s, "FailureThreshold: "+fmt.Sprintf("%#v", this.FailureThreshold)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ProjectedVolumeSource) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&k8s_io_api_core_v1.ProjectedVolumeSource{")
	if this.Sources != nil {
		s = append(s, "Sources: "+fmt.Sprintf("%#v", this.Sources)+",\n")
	}
	s = append(s, "DefaultMode: "+fmt.Sprintf("%#v", this.DefaultMode)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *QuobyteVolumeSource) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 10)
	s = append(s, "&k8s_io_api_core_v1.QuobyteVolumeSource{")
	s = append(s, "Registry: "+fmt.Sprintf("%#v", this.Registry)+",\n")
	s = append(s, "Volume: "+fmt.Sprintf("%#v", this.Volume)+",\n")
	s = append(s, "ReadOnly: "+fmt.Sprintf("%#v", this.ReadOnly)+",\n")
	s = append(s, "User: "+fmt.Sprintf("%#v", this.User)+",\n")
	s = append(s, "Group: "+fmt.Sprintf("%#v", this.Group)+",\n")
	s = append(s, "Tenant: "+fmt.Sprintf("%#v", this.Tenant)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *RBDPersistentVolumeSource) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 12)
	s = append(s, "&k8s_io_api_core_v1.RBDPersistentVolumeSource{")
	if this.Monitors != nil {
		s = append(s, "Monitors: "+fmt.Sprintf("%#v", this.Monitors)+",\n")
	}
	s = append(s, "Image: "+fmt.Sprintf("%#v", this.Image)+",\n")
	s = append(s, "FsType: "+fmt.Sprintf("%#v", this.FsType)+",\n")
	s = append(s, "Pool: "+fmt.Sprintf("%#v", this.Pool)+",\n")
	s = append(s, "User: "+fmt.Sprintf("%#v", this.User)+",\n")
	s = append(s, "Keyring: "+fmt.Sprintf("%#v", this.Keyring)+",\n")
	if this.SecretRef != nil {
		s = append(s, "SecretRef: "+fmt.Sprintf("%#v", this.SecretRef)+",\n")
	}
	s = append(s, "ReadOnly: "+fmt.Sprintf("%#v", this.ReadOnly)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *RBDVolumeSource) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 12)
	s = append(s, "&k8s_io_api_core_v1.RBDVolumeSource{")
	if this.Monitors != nil {
		s = append(s, "Monitors: "+fmt.Sprintf("%#v", this.Monitors)+",\n")
	}
	s = append(s, "Image: "+fmt.Sprintf("%#v", this.Image)+",\n")
	s = append(s, "FsType: "+fmt.Sprintf("%#v", this.FsType)+",\n")
	s = append(s, "Pool: "+fmt.Sprintf("%#v", this.Pool)+",\n")
	s = append(s, "User: "+fmt.Sprintf("%#v", this.User)+",\n")
	s = append(s, "Keyring: "+fmt.Sprintf("%#v", this.Keyring)+",\n")
	if this.SecretRef != nil {
		s = append(s, "SecretRef: "+fmt.Sprintf("%#v", this.SecretRef)+",\n")
	}
	s = append(s, "ReadOnly: "+fmt.Sprintf("%#v", this.ReadOnly)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *RangeAllocation) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&k8s_io_api_core_v1.RangeAllocation{")
	if this.Metadata != nil {
		s = append(s, "Metadata: "+fmt.Sprintf("%#v", this.Metadata)+",\n")
	}
	s = append(s, "Range: "+fmt.Sprintf("%#v", this.Range)+",\n")
	s = append(s, "Data: "+fmt.Sprintf("%#v", this.Data)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ReplicationController) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&k8s_io_api_core_v1.ReplicationController{")
	if this.Metadata != nil {
		s = append(s, "Metadata: "+fmt.Sprintf("%#v", this.Metadata)+",\n")
	}
	if this.Spec != nil {
		s = append(s, "Spec: "+fmt.Sprintf("%#v", this.Spec)+",\n")
	}
	if this.Status != nil {
		s = append(s, "Status: "+fmt.Sprintf("%#v", this.Status)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ReplicationControllerCondition) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 9)
	s = append(s, "&k8s_io_api_core_v1.ReplicationControllerCondition{")
	s = append(s, "Type: "+fmt.Sprintf("%#v", this.Type)+",\n")
	s = append(s, "Status: "+fmt.Sprintf("%#v", this.Status)+",\n")
	if this.LastTransitionTime != nil {
		s = append(s, "LastTransitionTime: "+fmt.Sprintf("%#v", this.LastTransitionTime)+",\n")
	}
	s = append(s, "Reason: "+fmt.Sprintf("%#v", this.Reason)+",\n")
	s = append(s, "Message: "+fmt.Sprintf("%#v", this.Message)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ReplicationControllerList) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&k8s_io_api_core_v1.ReplicationControllerList{")
	if this.Metadata != nil {
		s = append(s, "Metadata: "+fmt.Sprintf("%#v", this.Metadata)+",\n")
	}
	if this.Items != nil {
		s = append(s, "Items: "+fmt.Sprintf("%#v", this.Items)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ReplicationControllerSpec) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&k8s_io_api_core_v1.ReplicationControllerSpec{")
	s = append(s, "Replicas: "+fmt.Sprintf("%#v", this.Replicas)+",\n")
	s = append(s, "MinReadySeconds: "+fmt.Sprintf("%#v", this.MinReadySeconds)+",\n")
	keysForSelector := make([]string, 0, len(this.Selector))
	for k, _ := range this.Selector {
		keysForSelector = append(keysForSelector, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForSelector)
	mapStringForSelector := "map[string]string{"
	for _, k := range keysForSelector {
		mapStringForSelector += fmt.Sprintf("%#v: %#v,", k, this.Selector[k])
	}
	mapStringForSelector += "}"
	if this.Selector != nil {
		s = append(s, "Selector: "+mapStringForSelector+",\n")
	}
	if this.Template != nil {
		s = append(s, "Template: "+fmt.Sprintf("%#v", this.Template)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ReplicationControllerStatus) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 10)
	s = append(s, "&k8s_io_api_core_v1.ReplicationControllerStatus{")
	s = append(s, "Replicas: "+fmt.Sprintf("%#v", this.Replicas)+",\n")
	s = append(s, "FullyLabeledReplicas: "+fmt.Sprintf("%#v", this.FullyLabeledReplicas)+",\n")
	s = append(s, "ReadyReplicas: "+fmt.Sprintf("%#v", this.ReadyReplicas)+",\n")
	s = append(s, "AvailableReplicas: "+fmt.Sprintf("%#v", this.AvailableReplicas)+",\n")
	s = append(s, "ObservedGeneration: "+fmt.Sprintf("%#v", this.ObservedGeneration)+",\n")
	if this.Conditions != nil {
		s = append(s, "Conditions: "+fmt.Sprintf("%#v", this.Conditions)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ResourceFieldSelector) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&k8s_io_api_core_v1.ResourceFieldSelector{")
	s = append(s, "ContainerName: "+fmt.Sprintf("%#v", this.ContainerName)+",\n")
	s = append(s, "Resource: "+fmt.Sprintf("%#v", this.Resource)+",\n")
	if this.Divisor != nil {
		s = append(s, "Divisor: "+fmt.Sprintf("%#v", this.Divisor)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ResourceQuota) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&k8s_io_api_core_v1.ResourceQuota{")
	if this.Metadata != nil {
		s = append(s, "Metadata: "+fmt.Sprintf("%#v", this.Metadata)+",\n")
	}
	if this.Spec != nil {
		s = append(s, "Spec: "+fmt.Sprintf("%#v", this.Spec)+",\n")
	}
	if this.Status != nil {
		s = append(s, "Status: "+fmt.Sprintf("%#v", this.Status)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ResourceQuotaList) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&k8s_io_api_core_v1.ResourceQuotaList{")
	if this.Metadata != nil {
		s = append(s, "Metadata: "+fmt.Sprintf("%#v", this.Metadata)+",\n")
	}
	if this.Items != nil {
		s = append(s, "Items: "+fmt.Sprintf("%#v", this.Items)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ResourceQuotaSpec) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&k8s_io_api_core_v1.ResourceQuotaSpec{")
	keysForHard := make([]string, 0, len(this.Hard))
	for k, _ := range this.Hard {
		keysForHard = append(keysForHard, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForHard)
	mapStringForHard := "map[string]*resource.Quantity{"
	for _, k := range keysForHard {
		mapStringForHard += fmt.Sprintf("%#v: %#v,", k, this.Hard[k])
	}
	mapStringForHard += "}"
	if this.Hard != nil {
		s = append(s, "Hard: "+mapStringForHard+",\n")
	}
	if this.Scopes != nil {
		s = append(s, "Scopes: "+fmt.Sprintf("%#v", this.Scopes)+",\n")
	}
	if this.ScopeSelector != nil {
		s = append(s, "ScopeSelector: "+fmt.Sprintf("%#v", this.ScopeSelector)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ResourceQuotaStatus) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&k8s_io_api_core_v1.ResourceQuotaStatus{")
	keysForHard := make([]string, 0, len(this.Hard))
	for k, _ := range this.Hard {
		keysForHard = append(keysForHard, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForHard)
	mapStringForHard := "map[string]*resource.Quantity{"
	for _, k := range keysForHard {
		mapStringForHard += fmt.Sprintf("%#v: %#v,", k, this.Hard[k])
	}
	mapStringForHard += "}"
	if this.Hard != nil {
		s = append(s, "Hard: "+mapStringForHard+",\n")
	}
	keysForUsed := make([]string, 0, len(this.Used))
	for k, _ := range this.Used {
		keysForUsed = append(keysForUsed, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForUsed)
	mapStringForUsed := "map[string]*resource.Quantity{"
	for _, k := range keysForUsed {
		mapStringForUsed += fmt.Sprintf("%#v: %#v,", k, this.Used[k])
	}
	mapStringForUsed += "}"
	if this.Used != nil {
		s = append(s, "Used: "+mapStringForUsed+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ResourceRequirements) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&k8s_io_api_core_v1.ResourceRequirements{")
	keysForLimits := make([]string, 0, len(this.Limits))
	for k, _ := range this.Limits {
		keysForLimits = append(keysForLimits, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForLimits)
	mapStringForLimits := "map[string]*resource.Quantity{"
	for _, k := range keysForLimits {
		mapStringForLimits += fmt.Sprintf("%#v: %#v,", k, this.Limits[k])
	}
	mapStringForLimits += "}"
	if this.Limits != nil {
		s = append(s, "Limits: "+mapStringForLimits+",\n")
	}
	keysForRequests := make([]string, 0, len(this.Requests))
	for k, _ := range this.Requests {
		keysForRequests = append(keysForRequests, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForRequests)
	mapStringForRequests := "map[string]*resource.Quantity{"
	for _, k := range keysForRequests {
		mapStringForRequests += fmt.Sprintf("%#v: %#v,", k, this.Requests[k])
	}
	mapStringForRequests += "}"
	if this.Requests != nil {
		s = append(s, "Requests: "+mapStringForRequests+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *SELinuxOptions) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&k8s_io_api_core_v1.SELinuxOptions{")
	s = append(s, "User: "+fmt.Sprintf("%#v", this.User)+",\n")
	s = append(s, "Role: "+fmt.Sprintf("%#v", this.Role)+",\n")
	s = append(s, "Type: "+fmt.Sprintf("%#v", this.Type)+",\n")
	s = append(s, "Level: "+fmt.Sprintf("%#v", this.Level)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ScaleIOPersistentVolumeSource) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 14)
	s = append(s, "&k8s_io_api_core_v1.ScaleIOPersistentVolumeSource{")
	s = append(s, "Gateway: "+fmt.Sprintf("%#v", this.Gateway)+",\n")
	s = append(s, "System: "+fmt.Sprintf("%#v", this.System)+",\n")
	if this.SecretRef != nil {
		s = append(s, "SecretRef: "+fmt.Sprintf("%#v", this.SecretRef)+",\n")
	}
	s = append(s, "SslEnabled: "+fmt.Sprintf("%#v", this.SslEnabled)+",\n")
	s = append(s, "ProtectionDomain: "+fmt.Sprintf("%#v", this.ProtectionDomain)+",\n")
	s = append(s, "StoragePool: "+fmt.Sprintf("%#v", this.StoragePool)+",\n")
	s = append(s, "StorageMode: "+fmt.Sprintf("%#v", this.StorageMode)+",\n")
	s = append(s, "VolumeName: "+fmt.Sprintf("%#v", this.VolumeName)+",\n")
	s = append(s, "FsType: "+fmt.Sprintf("%#v", this.FsType)+",\n")
	s = append(s, "ReadOnly: "+fmt.Sprintf("%#v", this.ReadOnly)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ScaleIOVolumeSource) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 14)
	s = append(s, "&k8s_io_api_core_v1.ScaleIOVolumeSource{")
	s = append(s, "Gateway: "+fmt.Sprintf("%#v", this.Gateway)+",\n")
	s = append(s, "System: "+fmt.Sprintf("%#v", this.System)+",\n")
	if this.SecretRef != nil {
		s = append(s, "SecretRef: "+fmt.Sprintf("%#v", this.SecretRef)+",\n")
	}
	s = append(s, "SslEnabled: "+fmt.Sprintf("%#v", this.SslEnabled)+",\n")
	s = append(s, "ProtectionDomain: "+fmt.Sprintf("%#v", this.ProtectionDomain)+",\n")
	s = append(s, "StoragePool: "+fmt.Sprintf("%#v", this.StoragePool)+",\n")
	s = append(s, "StorageMode: "+fmt.Sprintf("%#v", this.StorageMode)+",\n")
	s = append(s, "VolumeName: "+fmt.Sprintf("%#v", this.VolumeName)+",\n")
	s = append(s, "FsType: "+fmt.Sprintf("%#v", this.FsType)+",\n")
	s = append(s, "ReadOnly: "+fmt.Sprintf("%#v", this.ReadOnly)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ScopeSelector) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&k8s_io_api_core_v1.ScopeSelector{")
	if this.MatchExpressions != nil {
		s = append(s, "MatchExpressions: "+fmt.Sprintf("%#v", this.MatchExpressions)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ScopedResourceSelectorRequirement) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&k8s_io_api_core_v1.ScopedResourceSelectorRequirement{")
	s = append(s, "ScopeName: "+fmt.Sprintf("%#v", this.ScopeName)+",\n")
	s = append(s, "Operator: "+fmt.Sprintf("%#v", this.Operator)+",\n")
	if this.Values != nil {
		s = append(s, "Values: "+fmt.Sprintf("%#v", this.Values)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Secret) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&k8s_io_api_core_v1.Secret{")
	if this.Metadata != nil {
		s = append(s, "Metadata: "+fmt.Sprintf("%#v", this.Metadata)+",\n")
	}
	keysForData := make([]string, 0, len(this.Data))
	for k, _ := range this.Data {
		keysForData = append(keysForData, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForData)
	mapStringForData := "map[string][]byte{"
	for _, k := range keysForData {
		mapStringForData += fmt.Sprintf("%#v: %#v,", k, this.Data[k])
	}
	mapStringForData += "}"
	if this.Data != nil {
		s = append(s, "Data: "+mapStringForData+",\n")
	}
	keysForStringData := make([]string, 0, len(this.StringData))
	for k, _ := range this.StringData {
		keysForStringData = append(keysForStringData, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForStringData)
	mapStringForStringData := "map[string]string{"
	for _, k := range keysForStringData {
		mapStringForStringData += fmt.Sprintf("%#v: %#v,", k, this.StringData[k])
	}
	mapStringForStringData += "}"
	if this.StringData != nil {
		s = append(s, "StringData: "+mapStringForStringData+",\n")
	}
	s = append(s, "Type: "+fmt.Sprintf("%#v", this.Type)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *SecretEnvSource) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&k8s_io_api_core_v1.SecretEnvSource{")
	if this.LocalObjectReference != nil {
		s = append(s, "LocalObjectReference: "+fmt.Sprintf("%#v", this.LocalObjectReference)+",\n")
	}
	s = append(s, "Optional: "+fmt.Sprintf("%#v", this.Optional)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *SecretKeySelector) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&k8s_io_api_core_v1.SecretKeySelector{")
	if this.LocalObjectReference != nil {
		s = append(s, "LocalObjectReference: "+fmt.Sprintf("%#v", this.LocalObjectReference)+",\n")
	}
	s = append(s, "Key: "+fmt.Sprintf("%#v", this.Key)+",\n")
	s = append(s, "Optional: "+fmt.Sprintf("%#v", this.Optional)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *SecretList) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&k8s_io_api_core_v1.SecretList{")
	if this.Metadata != nil {
		s = append(s, "Metadata: "+fmt.Sprintf("%#v", this.Metadata)+",\n")
	}
	if this.Items != nil {
		s = append(s, "Items: "+fmt.Sprintf("%#v", this.Items)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *SecretProjection) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&k8s_io_api_core_v1.SecretProjection{")
	if this.LocalObjectReference != nil {
		s = append(s, "LocalObjectReference: "+fmt.Sprintf("%#v", this.LocalObjectReference)+",\n")
	}
	if this.Items != nil {
		s = append(s, "Items: "+fmt.Sprintf("%#v", this.Items)+",\n")
	}
	s = append(s, "Optional: "+fmt.Sprintf("%#v", this.Optional)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *SecretReference) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&k8s_io_api_core_v1.SecretReference{")
	s = append(s, "Name: "+fmt.Sprintf("%#v", this.Name)+",\n")
	s = append(s, "Namespace: "+fmt.Sprintf("%#v", this.Namespace)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *SecretVolumeSource) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&k8s_io_api_core_v1.SecretVolumeSource{")
	s = append(s, "SecretName: "+fmt.Sprintf("%#v", this.SecretName)+",\n")
	if this.Items != nil {
		s = append(s, "Items: "+fmt.Sprintf("%#v", this.Items)+",\n")
	}
	s = append(s, "DefaultMode: "+fmt.Sprintf("%#v", this.DefaultMode)+",\n")
	s = append(s, "Optional: "+fmt.Sprintf("%#v", this.Optional)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *SecurityContext) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 14)
	s = append(s, "&k8s_io_api_core_v1.SecurityContext{")
	if this.Capabilities != nil {
		s = append(s, "Capabilities: "+fmt.Sprintf("%#v", this.Capabilities)+",\n")
	}
	s = append(s, "Privileged: "+fmt.Sprintf("%#v", this.Privileged)+",\n")
	if this.SeLinuxOptions != nil {
		s = append(s, "SeLinuxOptions: "+fmt.Sprintf("%#v", this.SeLinuxOptions)+",\n")
	}
	if this.WindowsOptions != nil {
		s = append(s, "WindowsOptions: "+fmt.Sprintf("%#v", this.WindowsOptions)+",\n")
	}
	s = append(s, "RunAsUser: "+fmt.Sprintf("%#v", this.RunAsUser)+",\n")
	s = append(s, "RunAsGroup: "+fmt.Sprintf("%#v", this.RunAsGroup)+",\n")
	s = append(s, "RunAsNonRoot: "+fmt.Sprintf("%#v", this.RunAsNonRoot)+",\n")
	s = append(s, "ReadOnlyRootFilesystem: "+fmt.Sprintf("%#v", this.ReadOnlyRootFilesystem)+",\n")
	s = append(s, "AllowPrivilegeEscalation: "+fmt.Sprintf("%#v", this.AllowPrivilegeEscalation)+",\n")
	s = append(s, "ProcMount: "+fmt.Sprintf("%#v", this.ProcMount)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *SerializedReference) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&k8s_io_api_core_v1.SerializedReference{")
	if this.Reference != nil {
		s = append(s, "Reference: "+fmt.Sprintf("%#v", this.Reference)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Service) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&k8s_io_api_core_v1.Service{")
	if this.Metadata != nil {
		s = append(s, "Metadata: "+fmt.Sprintf("%#v", this.Metadata)+",\n")
	}
	if this.Spec != nil {
		s = append(s, "Spec: "+fmt.Sprintf("%#v", this.Spec)+",\n")
	}
	if this.Status != nil {
		s = append(s, "Status: "+fmt.Sprintf("%#v", this.Status)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ServiceAccount) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&k8s_io_api_core_v1.ServiceAccount{")
	if this.Metadata != nil {
		s = append(s, "Metadata: "+fmt.Sprintf("%#v", this.Metadata)+",\n")
	}
	if this.Secrets != nil {
		s = append(s, "Secrets: "+fmt.Sprintf("%#v", this.Secrets)+",\n")
	}
	if this.ImagePullSecrets != nil {
		s = append(s, "ImagePullSecrets: "+fmt.Sprintf("%#v", this.ImagePullSecrets)+",\n")
	}
	s = append(s, "AutomountServiceAccountToken: "+fmt.Sprintf("%#v", this.AutomountServiceAccountToken)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ServiceAccountList) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&k8s_io_api_core_v1.ServiceAccountList{")
	if this.Metadata != nil {
		s = append(s, "Metadata: "+fmt.Sprintf("%#v", this.Metadata)+",\n")
	}
	if this.Items != nil {
		s = append(s, "Items: "+fmt.Sprintf("%#v", this.Items)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ServiceAccountTokenProjection) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&k8s_io_api_core_v1.ServiceAccountTokenProjection{")
	s = append(s, "Audience: "+fmt.Sprintf("%#v", this.Audience)+",\n")
	s = append(s, "ExpirationSeconds: "+fmt.Sprintf("%#v", this.ExpirationSeconds)+",\n")
	s = append(s, "Path: "+fmt.Sprintf("%#v", this.Path)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ServiceList) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&k8s_io_api_core_v1.ServiceList{")
	if this.Metadata != nil {
		s = append(s, "Metadata: "+fmt.Sprintf("%#v", this.Metadata)+",\n")
	}
	if this.Items != nil {
		s = append(s, "Items: "+fmt.Sprintf("%#v", this.Items)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ServicePort) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 9)
	s = append(s, "&k8s_io_api_core_v1.ServicePort{")
	s = append(s, "Name: "+fmt.Sprintf("%#v", this.Name)+",\n")
	s = append(s, "Protocol: "+fmt.Sprintf("%#v", this.Protocol)+",\n")
	s = append(s, "Port: "+fmt.Sprintf("%#v", this.Port)+",\n")
	if this.TargetPort != nil {
		s = append(s, "TargetPort: "+fmt.Sprintf("%#v", this.TargetPort)+",\n")
	}
	s = append(s, "NodePort: "+fmt.Sprintf("%#v", this.NodePort)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ServiceProxyOptions) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&k8s_io_api_core_v1.ServiceProxyOptions{")
	s = append(s, "Path: "+fmt.Sprintf("%#v", this.Path)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ServiceSpec) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 18)
	s = append(s, "&k8s_io_api_core_v1.ServiceSpec{")
	if this.Ports != nil {
		s = append(s, "Ports: "+fmt.Sprintf("%#v", this.Ports)+",\n")
	}
	keysForSelector := make([]string, 0, len(this.Selector))
	for k, _ := range this.Selector {
		keysForSelector = append(keysForSelector, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForSelector)
	mapStringForSelector := "map[string]string{"
	for _, k := range keysForSelector {
		mapStringForSelector += fmt.Sprintf("%#v: %#v,", k, this.Selector[k])
	}
	mapStringForSelector += "}"
	if this.Selector != nil {
		s = append(s, "Selector: "+mapStringForSelector+",\n")
	}
	s = append(s, "ClusterIP: "+fmt.Sprintf("%#v", this.ClusterIP)+",\n")
	s = append(s, "Type: "+fmt.Sprintf("%#v", this.Type)+",\n")
	if this.ExternalIPs != nil {
		s = append(s, "ExternalIPs: "+fmt.Sprintf("%#v", this.ExternalIPs)+",\n")
	}
	s = append(s, "SessionAffinity: "+fmt.Sprintf("%#v", this.SessionAffinity)+",\n")
	s = append(s, "LoadBalancerIP: "+fmt.Sprintf("%#v", this.LoadBalancerIP)+",\n")
	if this.LoadBalancerSourceRanges != nil {
		s = append(s, "LoadBalancerSourceRanges: "+fmt.Sprintf("%#v", this.LoadBalancerSourceRanges)+",\n")
	}
	s = append(s, "ExternalName: "+fmt.Sprintf("%#v", this.ExternalName)+",\n")
	s = append(s, "ExternalTrafficPolicy: "+fmt.Sprintf("%#v", this.ExternalTrafficPolicy)+",\n")
	s = append(s, "HealthCheckNodePort: "+fmt.Sprintf("%#v", this.HealthCheckNodePort)+",\n")
	s = append(s, "PublishNotReadyAddresses: "+fmt.Sprintf("%#v", this.PublishNotReadyAddresses)+",\n")
	if this.SessionAffinityConfig != nil {
		s = append(s, "SessionAffinityConfig: "+fmt.Sprintf("%#v", this.SessionAffinityConfig)+",\n")
	}
	s = append(s, "IpFamily: "+fmt.Sprintf("%#v", this.IpFamily)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ServiceStatus) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&k8s_io_api_core_v1.ServiceStatus{")
	if this.LoadBalancer != nil {
		s = append(s, "LoadBalancer: "+fmt.Sprintf("%#v", this.LoadBalancer)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *SessionAffinityConfig) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&k8s_io_api_core_v1.SessionAffinityConfig{")
	if this.ClientIP != nil {
		s = append(s, "ClientIP: "+fmt.Sprintf("%#v", this.ClientIP)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *StorageOSPersistentVolumeSource) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 9)
	s = append(s, "&k8s_io_api_core_v1.StorageOSPersistentVolumeSource{")
	s = append(s, "VolumeName: "+fmt.Sprintf("%#v", this.VolumeName)+",\n")
	s = append(s, "VolumeNamespace: "+fmt.Sprintf("%#v", this.VolumeNamespace)+",\n")
	s = append(s, "FsType: "+fmt.Sprintf("%#v", this.FsType)+",\n")
	s = append(s, "ReadOnly: "+fmt.Sprintf("%#v", this.ReadOnly)+",\n")
	if this.SecretRef != nil {
		s = append(s, "SecretRef: "+fmt.Sprintf("%#v", this.SecretRef)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *StorageOSVolumeSource) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 9)
	s = append(s, "&k8s_io_api_core_v1.StorageOSVolumeSource{")
	s = append(s, "VolumeName: "+fmt.Sprintf("%#v", this.VolumeName)+",\n")
	s = append(s, "VolumeNamespace: "+fmt.Sprintf("%#v", this.VolumeNamespace)+",\n")
	s = append(s, "FsType: "+fmt.Sprintf("%#v", this.FsType)+",\n")
	s = append(s, "ReadOnly: "+fmt.Sprintf("%#v", this.ReadOnly)+",\n")
	if this.SecretRef != nil {
		s = append(s, "SecretRef: "+fmt.Sprintf("%#v", this.SecretRef)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Sysctl) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&k8s_io_api_core_v1.Sysctl{")
	s = append(s, "Name: "+fmt.Sprintf("%#v", this.Name)+",\n")
	s = append(s, "Value: "+fmt.Sprintf("%#v", this.Value)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *TCPSocketAction) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&k8s_io_api_core_v1.TCPSocketAction{")
	if this.Port != nil {
		s = append(s, "Port: "+fmt.Sprintf("%#v", this.Port)+",\n")
	}
	s = append(s, "Host: "+fmt.Sprintf("%#v", this.Host)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Taint) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&k8s_io_api_core_v1.Taint{")
	s = append(s, "Key: "+fmt.Sprintf("%#v", this.Key)+",\n")
	s = append(s, "Value: "+fmt.Sprintf("%#v", this.Value)+",\n")
	s = append(s, "Effect: "+fmt.Sprintf("%#v", this.Effect)+",\n")
	if this.TimeAdded != nil {
		s = append(s, "TimeAdded: "+fmt.Sprintf("%#v", this.TimeAdded)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Toleration) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 9)
	s = append(s, "&k8s_io_api_core_v1.Toleration{")
	s = append(s, "Key: "+fmt.Sprintf("%#v", this.Key)+",\n")
	s = append(s, "Operator: "+fmt.Sprintf("%#v", this.Operator)+",\n")
	s = append(s, "Value: "+fmt.Sprintf("%#v", this.Value)+",\n")
	s = append(s, "Effect: "+fmt.Sprintf("%#v", this.Effect)+",\n")
	s = append(s, "TolerationSeconds: "+fmt.Sprintf("%#v", this.TolerationSeconds)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *TopologySelectorLabelRequirement) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&k8s_io_api_core_v1.TopologySelectorLabelRequirement{")
	s = append(s, "Key: "+fmt.Sprintf("%#v", this.Key)+",\n")
	if this.Values != nil {
		s = append(s, "Values: "+fmt.Sprintf("%#v", this.Values)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *TopologySelectorTerm) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&k8s_io_api_core_v1.TopologySelectorTerm{")
	if this.MatchLabelExpressions != nil {
		s = append(s, "MatchLabelExpressions: "+fmt.Sprintf("%#v", this.MatchLabelExpressions)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *TopologySpreadConstraint) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&k8s_io_api_core_v1.TopologySpreadConstraint{")
	s = append(s, "MaxSkew: "+fmt.Sprintf("%#v", this.MaxSkew)+",\n")
	s = append(s, "TopologyKey: "+fmt.Sprintf("%#v", this.TopologyKey)+",\n")
	s = append(s, "WhenUnsatisfiable: "+fmt.Sprintf("%#v", this.WhenUnsatisfiable)+",\n")
	if this.LabelSelector != nil {
		s = append(s, "LabelSelector: "+fmt.Sprintf("%#v", this.LabelSelector)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *TypedLocalObjectReference) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&k8s_io_api_core_v1.TypedLocalObjectReference{")
	s = append(s, "ApiGroup: "+fmt.Sprintf("%#v", this.ApiGroup)+",\n")
	s = append(s, "Kind: "+fmt.Sprintf("%#v", this.Kind)+",\n")
	s = append(s, "Name: "+fmt.Sprintf("%#v", this.Name)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Volume) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&k8s_io_api_core_v1.Volume{")
	s = append(s, "Name: "+fmt.Sprintf("%#v", this.Name)+",\n")
	if this.VolumeSource != nil {
		s = append(s, "VolumeSource: "+fmt.Sprintf("%#v", this.VolumeSource)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *VolumeDevice) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&k8s_io_api_core_v1.VolumeDevice{")
	s = append(s, "Name: "+fmt.Sprintf("%#v", this.Name)+",\n")
	s = append(s, "DevicePath: "+fmt.Sprintf("%#v", this.DevicePath)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *VolumeMount) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 10)
	s = append(s, "&k8s_io_api_core_v1.VolumeMount{")
	s = append(s, "Name: "+fmt.Sprintf("%#v", this.Name)+",\n")
	s = append(s, "ReadOnly: "+fmt.Sprintf("%#v", this.ReadOnly)+",\n")
	s = append(s, "MountPath: "+fmt.Sprintf("%#v", this.MountPath)+",\n")
	s = append(s, "SubPath: "+fmt.Sprintf("%#v", this.SubPath)+",\n")
	s = append(s, "MountPropagation: "+fmt.Sprintf("%#v", this.MountPropagation)+",\n")
	s = append(s, "SubPathExpr: "+fmt.Sprintf("%#v", this.SubPathExpr)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *VolumeNodeAffinity) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&k8s_io_api_core_v1.VolumeNodeAffinity{")
	if this.Required != nil {
		s = append(s, "Required: "+fmt.Sprintf("%#v", this.Required)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *VolumeProjection) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&k8s_io_api_core_v1.VolumeProjection{")
	if this.Secret != nil {
		s = append(s, "Secret: "+fmt.Sprintf("%#v", this.Secret)+",\n")
	}
	if this.DownwardAPI != nil {
		s = append(s, "DownwardAPI: "+fmt.Sprintf("%#v", this.DownwardAPI)+",\n")
	}
	if this.ConfigMap != nil {
		s = append(s, "ConfigMap: "+fmt.Sprintf("%#v", this.ConfigMap)+",\n")
	}
	if this.ServiceAccountToken != nil {
		s = append(s, "ServiceAccountToken: "+fmt.Sprintf("%#v", this.ServiceAccountToken)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *VolumeSource) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 32)
	s = append(s, "&k8s_io_api_core_v1.VolumeSource{")
	if this.HostPath != nil {
		s = append(s, "HostPath: "+fmt.Sprintf("%#v", this.HostPath)+",\n")
	}
	if this.EmptyDir != nil {
		s = append(s, "EmptyDir: "+fmt.Sprintf("%#v", this.EmptyDir)+",\n")
	}
	if this.GcePersistentDisk != nil {
		s = append(s, "GcePersistentDisk: "+fmt.Sprintf("%#v", this.GcePersistentDisk)+",\n")
	}
	if this.AwsElasticBlockStore != nil {
		s = append(s, "AwsElasticBlockStore: "+fmt.Sprintf("%#v", this.AwsElasticBlockStore)+",\n")
	}
	if this.GitRepo != nil {
		s = append(s, "GitRepo: "+fmt.Sprintf("%#v", this.GitRepo)+",\n")
	}
	if this.Secret != nil {
		s = append(s, "Secret: "+fmt.Sprintf("%#v", this.Secret)+",\n")
	}
	if this.Nfs != nil {
		s = append(s, "Nfs: "+fmt.Sprintf("%#v", this.Nfs)+",\n")
	}
	if this.Iscsi != nil {
		s = append(s, "Iscsi: "+fmt.Sprintf("%#v", this.Iscsi)+",\n")
	}
	if this.Glusterfs != nil {
		s = append(s, "Glusterfs: "+fmt.Sprintf("%#v", this.Glusterfs)+",\n")
	}
	if this.PersistentVolumeClaim != nil {
		s = append(s, "PersistentVolumeClaim: "+fmt.Sprintf("%#v", this.PersistentVolumeClaim)+",\n")
	}
	if this.Rbd != nil {
		s = append(s, "Rbd: "+fmt.Sprintf("%#v", this.Rbd)+",\n")
	}
	if this.FlexVolume != nil {
		s = append(s, "FlexVolume: "+fmt.Sprintf("%#v", this.FlexVolume)+",\n")
	}
	if this.Cinder != nil {
		s = append(s, "Cinder: "+fmt.Sprintf("%#v", this.Cinder)+",\n")
	}
	if this.Cephfs != nil {
		s = append(s, "Cephfs: "+fmt.Sprintf("%#v", this.Cephfs)+",\n")
	}
	if this.Flocker != nil {
		s = append(s, "Flocker: "+fmt.Sprintf("%#v", this.Flocker)+",\n")
	}
	if this.DownwardAPI != nil {
		s = append(s, "DownwardAPI: "+fmt.Sprintf("%#v", this.DownwardAPI)+",\n")
	}
	if this.Fc != nil {
		s = append(s, "Fc: "+fmt.Sprintf("%#v", this.Fc)+",\n")
	}
	if this.AzureFile != nil {
		s = append(s, "AzureFile: "+fmt.Sprintf("%#v", this.AzureFile)+",\n")
	}
	if this.ConfigMap != nil {
		s = append(s, "ConfigMap: "+fmt.Sprintf("%#v", this.ConfigMap)+",\n")
	}
	if this.VsphereVolume != nil {
		s = append(s, "VsphereVolume: "+fmt.Sprintf("%#v", this.VsphereVolume)+",\n")
	}
	if this.Quobyte != nil {
		s = append(s, "Quobyte: "+fmt.Sprintf("%#v", this.Quobyte)+",\n")
	}
	if this.AzureDisk != nil {
		s = append(s, "AzureDisk: "+fmt.Sprintf("%#v", this.AzureDisk)+",\n")
	}
	if this.PhotonPersistentDisk != nil {
		s = append(s, "PhotonPersistentDisk: "+fmt.Sprintf("%#v", this.PhotonPersistentDisk)+",\n")
	}
	if this.Projected != nil {
		s = append(s, "Projected: "+fmt.Sprintf("%#v", this.Projected)+",\n")
	}
	if this.PortworxVolume != nil {
		s = append(s, "PortworxVolume: "+fmt.Sprintf("%#v", this.PortworxVolume)+",\n")
	}
	if this.ScaleIO != nil {
		s = append(s, "ScaleIO: "+fmt.Sprintf("%#v", this.ScaleIO)+",\n")
	}
	if this.Storageos != nil {
		s = append(s, "Storageos: "+fmt.Sprintf("%#v", this.Storageos)+",\n")
	}
	if this.Csi != nil {
		s = append(s, "Csi: "+fmt.Sprintf("%#v", this.Csi)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *VsphereVirtualDiskVolumeSource) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&k8s_io_api_core_v1.VsphereVirtualDiskVolumeSource{")
	s = append(s, "VolumePath: "+fmt.Sprintf("%#v", this.VolumePath)+",\n")
	s = append(s, "FsType: "+fmt.Sprintf("%#v", this.FsType)+",\n")
	s = append(s, "StoragePolicyName: "+fmt.Sprintf("%#v", this.StoragePolicyName)+",\n")
	s = append(s, "StoragePolicyID: "+fmt.Sprintf("%#v", this.StoragePolicyID)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *WeightedPodAffinityTerm) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&k8s_io_api_core_v1.WeightedPodAffinityTerm{")
	s = append(s, "Weight: "+fmt.Sprintf("%#v", this.Weight)+",\n")
	if this.PodAffinityTerm != nil {
		s = append(s, "PodAffinityTerm: "+fmt.Sprintf("%#v", this.PodAffinityTerm)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *WindowsSecurityContextOptions) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&k8s_io_api_core_v1.WindowsSecurityContextOptions{")
	s = append(s, "GmsaCredentialSpecName: "+fmt.Sprintf("%#v", this.GmsaCredentialSpecName)+",\n")
	s = append(s, "GmsaCredentialSpec: "+fmt.Sprintf("%#v", this.GmsaCredentialSpec)+",\n")
	s = append(s, "RunAsUserName: "+fmt.Sprintf("%#v", this.RunAsUserName)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringGenerated(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}
func (m *AWSElasticBlockStoreVolumeSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AWSElasticBlockStoreVolumeSource) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AWSElasticBlockStoreVolumeSource) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	i--
	if m.ReadOnly {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i--
	dAtA[i] = 0x20
	i = encodeVarintGenerated(dAtA, i, uint64(m.Partition))
	i--
	dAtA[i] = 0x18
	i -= len(m.FsType)
	copy(dAtA[i:], m.FsType)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.FsType)))
	i--
	dAtA[i] = 0x12
	i -= len(m.VolumeID)
	copy(dAtA[i:], m.VolumeID)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.VolumeID)))
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *Affinity) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Affinity) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Affinity) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.PodAntiAffinity != nil {
		{
			size, err := m.PodAntiAffinity.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.PodAffinity != nil {
		{
			size, err := m.PodAffinity.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.NodeAffinity != nil {
		{
			size, err := m.NodeAffinity.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *AttachedVolume) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AttachedVolume) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AttachedVolume) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	i -= len(m.DevicePath)
	copy(dAtA[i:], m.DevicePath)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.DevicePath)))
	i--
	dAtA[i] = 0x12
	i -= len(m.Name)
	copy(dAtA[i:], m.Name)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Name)))
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *AvoidPods) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AvoidPods) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AvoidPods) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.PreferAvoidPods) > 0 {
		for iNdEx := len(m.PreferAvoidPods) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.PreferAvoidPods[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintGenerated(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *AzureDiskVolumeSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AzureDiskVolumeSource) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AzureDiskVolumeSource) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	i -= len(m.Kind)
	copy(dAtA[i:], m.Kind)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Kind)))
	i--
	dAtA[i] = 0x32
	i--
	if m.ReadOnly {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i--
	dAtA[i] = 0x28
	i -= len(m.FsType)
	copy(dAtA[i:], m.FsType)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.FsType)))
	i--
	dAtA[i] = 0x22
	i -= len(m.CachingMode)
	copy(dAtA[i:], m.CachingMode)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.CachingMode)))
	i--
	dAtA[i] = 0x1a
	i -= len(m.DiskURI)
	copy(dAtA[i:], m.DiskURI)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.DiskURI)))
	i--
	dAtA[i] = 0x12
	i -= len(m.DiskName)
	copy(dAtA[i:], m.DiskName)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.DiskName)))
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *AzureFilePersistentVolumeSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AzureFilePersistentVolumeSource) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AzureFilePersistentVolumeSource) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	i -= len(m.SecretNamespace)
	copy(dAtA[i:], m.SecretNamespace)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.SecretNamespace)))
	i--
	dAtA[i] = 0x22
	i--
	if m.ReadOnly {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i--
	dAtA[i] = 0x18
	i -= len(m.ShareName)
	copy(dAtA[i:], m.ShareName)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.ShareName)))
	i--
	dAtA[i] = 0x12
	i -= len(m.SecretName)
	copy(dAtA[i:], m.SecretName)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.SecretName)))
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *AzureFileVolumeSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AzureFileVolumeSource) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AzureFileVolumeSource) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	i--
	if m.ReadOnly {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i--
	dAtA[i] = 0x18
	i -= len(m.ShareName)
	copy(dAtA[i:], m.ShareName)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.ShareName)))
	i--
	dAtA[i] = 0x12
	i -= len(m.SecretName)
	copy(dAtA[i:], m.SecretName)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.SecretName)))
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *Binding) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Binding) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Binding) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Target != nil {
		{
			size, err := m.Target.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Metadata != nil {
		{
			size, err := m.Metadata.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CSIPersistentVolumeSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CSIPersistentVolumeSource) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CSIPersistentVolumeSource) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.ControllerExpandSecretRef != nil {
		{
			size, err := m.ControllerExpandSecretRef.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x4a
	}
	if m.NodePublishSecretRef != nil {
		{
			size, err := m.NodePublishSecretRef.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x42
	}
	if m.NodeStageSecretRef != nil {
		{
			size, err := m.NodeStageSecretRef.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	if m.ControllerPublishSecretRef != nil {
		{
			size, err := m.ControllerPublishSecretRef.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	if len(m.VolumeAttributes) > 0 {
		for k := range m.VolumeAttributes {
			v := m.VolumeAttributes[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintGenerated(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintGenerated(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintGenerated(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x2a
		}
	}
	i -= len(m.FsType)
	copy(dAtA[i:], m.FsType)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.FsType)))
	i--
	dAtA[i] = 0x22
	i--
	if m.ReadOnly {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i--
	dAtA[i] = 0x18
	i -= len(m.VolumeHandle)
	copy(dAtA[i:], m.VolumeHandle)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.VolumeHandle)))
	i--
	dAtA[i] = 0x12
	i -= len(m.Driver)
	copy(dAtA[i:], m.Driver)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Driver)))
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *CSIVolumeSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CSIVolumeSource) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CSIVolumeSource) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.NodePublishSecretRef != nil {
		{
			size, err := m.NodePublishSecretRef.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if len(m.VolumeAttributes) > 0 {
		for k := range m.VolumeAttributes {
			v := m.VolumeAttributes[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintGenerated(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintGenerated(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintGenerated(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x22
		}
	}
	i -= len(m.FsType)
	copy(dAtA[i:], m.FsType)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.FsType)))
	i--
	dAtA[i] = 0x1a
	i--
	if m.ReadOnly {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i--
	dAtA[i] = 0x10
	i -= len(m.Driver)
	copy(dAtA[i:], m.Driver)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Driver)))
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *Capabilities) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Capabilities) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Capabilities) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Drop) > 0 {
		for iNdEx := len(m.Drop) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Drop[iNdEx])
			copy(dAtA[i:], m.Drop[iNdEx])
			i = encodeVarintGenerated(dAtA, i, uint64(len(m.Drop[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Add) > 0 {
		for iNdEx := len(m.Add) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Add[iNdEx])
			copy(dAtA[i:], m.Add[iNdEx])
			i = encodeVarintGenerated(dAtA, i, uint64(len(m.Add[iNdEx])))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *CephFSPersistentVolumeSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CephFSPersistentVolumeSource) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CephFSPersistentVolumeSource) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	i--
	if m.ReadOnly {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i--
	dAtA[i] = 0x30
	if m.SecretRef != nil {
		{
			size, err := m.SecretRef.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	i -= len(m.SecretFile)
	copy(dAtA[i:], m.SecretFile)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.SecretFile)))
	i--
	dAtA[i] = 0x22
	i -= len(m.User)
	copy(dAtA[i:], m.User)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.User)))
	i--
	dAtA[i] = 0x1a
	i -= len(m.Path)
	copy(dAtA[i:], m.Path)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Path)))
	i--
	dAtA[i] = 0x12
	if len(m.Monitors) > 0 {
		for iNdEx := len(m.Monitors) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Monitors[iNdEx])
			copy(dAtA[i:], m.Monitors[iNdEx])
			i = encodeVarintGenerated(dAtA, i, uint64(len(m.Monitors[iNdEx])))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *CephFSVolumeSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CephFSVolumeSource) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CephFSVolumeSource) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	i--
	if m.ReadOnly {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i--
	dAtA[i] = 0x30
	if m.SecretRef != nil {
		{
			size, err := m.SecretRef.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	i -= len(m.SecretFile)
	copy(dAtA[i:], m.SecretFile)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.SecretFile)))
	i--
	dAtA[i] = 0x22
	i -= len(m.User)
	copy(dAtA[i:], m.User)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.User)))
	i--
	dAtA[i] = 0x1a
	i -= len(m.Path)
	copy(dAtA[i:], m.Path)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Path)))
	i--
	dAtA[i] = 0x12
	if len(m.Monitors) > 0 {
		for iNdEx := len(m.Monitors) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Monitors[iNdEx])
			copy(dAtA[i:], m.Monitors[iNdEx])
			i = encodeVarintGenerated(dAtA, i, uint64(len(m.Monitors[iNdEx])))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *CinderPersistentVolumeSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CinderPersistentVolumeSource) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CinderPersistentVolumeSource) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.SecretRef != nil {
		{
			size, err := m.SecretRef.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	i--
	if m.ReadOnly {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i--
	dAtA[i] = 0x18
	i -= len(m.FsType)
	copy(dAtA[i:], m.FsType)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.FsType)))
	i--
	dAtA[i] = 0x12
	i -= len(m.VolumeID)
	copy(dAtA[i:], m.VolumeID)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.VolumeID)))
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *CinderVolumeSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CinderVolumeSource) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CinderVolumeSource) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.SecretRef != nil {
		{
			size, err := m.SecretRef.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	i--
	if m.ReadOnly {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i--
	dAtA[i] = 0x18
	i -= len(m.FsType)
	copy(dAtA[i:], m.FsType)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.FsType)))
	i--
	dAtA[i] = 0x12
	i -= len(m.VolumeID)
	copy(dAtA[i:], m.VolumeID)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.VolumeID)))
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *ClientIPConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ClientIPConfig) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ClientIPConfig) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	i = encodeVarintGenerated(dAtA, i, uint64(m.TimeoutSeconds))
	i--
	dAtA[i] = 0x8
	return len(dAtA) - i, nil
}

func (m *ComponentCondition) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ComponentCondition) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ComponentCondition) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	i -= len(m.Error)
	copy(dAtA[i:], m.Error)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Error)))
	i--
	dAtA[i] = 0x22
	i -= len(m.Message)
	copy(dAtA[i:], m.Message)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Message)))
	i--
	dAtA[i] = 0x1a
	i -= len(m.Status)
	copy(dAtA[i:], m.Status)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Status)))
	i--
	dAtA[i] = 0x12
	i -= len(m.Type)
	copy(dAtA[i:], m.Type)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Type)))
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *ComponentStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ComponentStatus) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ComponentStatus) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Conditions) > 0 {
		for iNdEx := len(m.Conditions) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Conditions[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintGenerated(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.Metadata != nil {
		{
			size, err := m.Metadata.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ComponentStatusList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ComponentStatusList) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ComponentStatusList) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Items) > 0 {
		for iNdEx := len(m.Items) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Items[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintGenerated(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.Metadata != nil {
		{
			size, err := m.Metadata.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ConfigMap) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ConfigMap) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ConfigMap) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.BinaryData) > 0 {
		for k := range m.BinaryData {
			v := m.BinaryData[k]
			baseI := i
			if v != nil {
				i -= len(v)
				copy(dAtA[i:], v)
				i = encodeVarintGenerated(dAtA, i, uint64(len(v)))
				i--
				dAtA[i] = 0x12
			}
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintGenerated(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintGenerated(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.Data) > 0 {
		for k := range m.Data {
			v := m.Data[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintGenerated(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintGenerated(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintGenerated(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x12
		}
	}
	if m.Metadata != nil {
		{
			size, err := m.Metadata.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ConfigMapEnvSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ConfigMapEnvSource) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ConfigMapEnvSource) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	i--
	if m.Optional {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i--
	dAtA[i] = 0x10
	if m.LocalObjectReference != nil {
		{
			size, err := m.LocalObjectReference.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ConfigMapKeySelector) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ConfigMapKeySelector) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ConfigMapKeySelector) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	i--
	if m.Optional {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i--
	dAtA[i] = 0x18
	i -= len(m.Key)
	copy(dAtA[i:], m.Key)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Key)))
	i--
	dAtA[i] = 0x12
	if m.LocalObjectReference != nil {
		{
			size, err := m.LocalObjectReference.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ConfigMapList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ConfigMapList) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ConfigMapList) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Items) > 0 {
		for iNdEx := len(m.Items) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Items[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintGenerated(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.Metadata != nil {
		{
			size, err := m.Metadata.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ConfigMapNodeConfigSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ConfigMapNodeConfigSource) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ConfigMapNodeConfigSource) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	i -= len(m.KubeletConfigKey)
	copy(dAtA[i:], m.KubeletConfigKey)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.KubeletConfigKey)))
	i--
	dAtA[i] = 0x2a
	i -= len(m.ResourceVersion)
	copy(dAtA[i:], m.ResourceVersion)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.ResourceVersion)))
	i--
	dAtA[i] = 0x22
	i -= len(m.Uid)
	copy(dAtA[i:], m.Uid)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Uid)))
	i--
	dAtA[i] = 0x1a
	i -= len(m.Name)
	copy(dAtA[i:], m.Name)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Name)))
	i--
	dAtA[i] = 0x12
	i -= len(m.Namespace)
	copy(dAtA[i:], m.Namespace)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Namespace)))
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *ConfigMapProjection) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ConfigMapProjection) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ConfigMapProjection) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	i--
	if m.Optional {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i--
	dAtA[i] = 0x20
	if len(m.Items) > 0 {
		for iNdEx := len(m.Items) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Items[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintGenerated(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.LocalObjectReference != nil {
		{
			size, err := m.LocalObjectReference.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ConfigMapVolumeSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ConfigMapVolumeSource) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ConfigMapVolumeSource) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	i--
	if m.Optional {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i--
	dAtA[i] = 0x20
	i = encodeVarintGenerated(dAtA, i, uint64(m.DefaultMode))
	i--
	dAtA[i] = 0x18
	if len(m.Items) > 0 {
		for iNdEx := len(m.Items) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Items[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintGenerated(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.LocalObjectReference != nil {
		{
			size, err := m.LocalObjectReference.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Container) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Container) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Container) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.VolumeDevices) > 0 {
		for iNdEx := len(m.VolumeDevices) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.VolumeDevices[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintGenerated(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1
			i--
			dAtA[i] = 0xaa
		}
	}
	i -= len(m.TerminationMessagePolicy)
	copy(dAtA[i:], m.TerminationMessagePolicy)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.TerminationMessagePolicy)))
	i--
	dAtA[i] = 0x1
	i--
	dAtA[i] = 0xa2
	if len(m.EnvFrom) > 0 {
		for iNdEx := len(m.EnvFrom) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.EnvFrom[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintGenerated(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1
			i--
			dAtA[i] = 0x9a
		}
	}
	i--
	if m.Tty {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i--
	dAtA[i] = 0x1
	i--
	dAtA[i] = 0x90
	i--
	if m.StdinOnce {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i--
	dAtA[i] = 0x1
	i--
	dAtA[i] = 0x88
	i--
	if m.Stdin {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i--
	dAtA[i] = 0x1
	i--
	dAtA[i] = 0x80
	if m.SecurityContext != nil {
		{
			size, err := m.SecurityContext.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x7a
	}
	i -= len(m.ImagePullPolicy)
	copy(dAtA[i:], m.ImagePullPolicy)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.ImagePullPolicy)))
	i--
	dAtA[i] = 0x72
	i -= len(m.TerminationMessagePath)
	copy(dAtA[i:], m.TerminationMessagePath)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.TerminationMessagePath)))
	i--
	dAtA[i] = 0x6a
	if m.Lifecycle != nil {
		{
			size, err := m.Lifecycle.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x62
	}
	if m.ReadinessProbe != nil {
		{
			size, err := m.ReadinessProbe.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x5a
	}
	if m.LivenessProbe != nil {
		{
			size, err := m.LivenessProbe.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x52
	}
	if len(m.VolumeMounts) > 0 {
		for iNdEx := len(m.VolumeMounts) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.VolumeMounts[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintGenerated(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x4a
		}
	}
	if m.Resources != nil {
		{
			size, err := m.Resources.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x42
	}
	if len(m.Env) > 0 {
		for iNdEx := len(m.Env) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Env[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintGenerated(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x3a
		}
	}
	if len(m.Ports) > 0 {
		for iNdEx := len(m.Ports) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Ports[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintGenerated(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x32
		}
	}
	i -= len(m.WorkingDir)
	copy(dAtA[i:], m.WorkingDir)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.WorkingDir)))
	i--
	dAtA[i] = 0x2a
	if len(m.Args) > 0 {
		for iNdEx := len(m.Args) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Args[iNdEx])
			copy(dAtA[i:], m.Args[iNdEx])
			i = encodeVarintGenerated(dAtA, i, uint64(len(m.Args[iNdEx])))
			i--
			dAtA[i] = 0x22
		}
	}
	if len(m.Command) > 0 {
		for iNdEx := len(m.Command) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Command[iNdEx])
			copy(dAtA[i:], m.Command[iNdEx])
			i = encodeVarintGenerated(dAtA, i, uint64(len(m.Command[iNdEx])))
			i--
			dAtA[i] = 0x1a
		}
	}
	i -= len(m.Image)
	copy(dAtA[i:], m.Image)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Image)))
	i--
	dAtA[i] = 0x12
	i -= len(m.Name)
	copy(dAtA[i:], m.Name)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Name)))
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *ContainerImage) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ContainerImage) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ContainerImage) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	i = encodeVarintGenerated(dAtA, i, uint64(m.SizeBytes))
	i--
	dAtA[i] = 0x10
	if len(m.Names) > 0 {
		for iNdEx := len(m.Names) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Names[iNdEx])
			copy(dAtA[i:], m.Names[iNdEx])
			i = encodeVarintGenerated(dAtA, i, uint64(len(m.Names[iNdEx])))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *ContainerPort) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ContainerPort) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ContainerPort) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	i -= len(m.HostIP)
	copy(dAtA[i:], m.HostIP)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.HostIP)))
	i--
	dAtA[i] = 0x2a
	i -= len(m.Protocol)
	copy(dAtA[i:], m.Protocol)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Protocol)))
	i--
	dAtA[i] = 0x22
	i = encodeVarintGenerated(dAtA, i, uint64(m.ContainerPort))
	i--
	dAtA[i] = 0x18
	i = encodeVarintGenerated(dAtA, i, uint64(m.HostPort))
	i--
	dAtA[i] = 0x10
	i -= len(m.Name)
	copy(dAtA[i:], m.Name)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Name)))
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *ContainerState) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ContainerState) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ContainerState) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Terminated != nil {
		{
			size, err := m.Terminated.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.Running != nil {
		{
			size, err := m.Running.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Waiting != nil {
		{
			size, err := m.Waiting.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ContainerStateRunning) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ContainerStateRunning) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ContainerStateRunning) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.StartedAt != nil {
		{
			size, err := m.StartedAt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ContainerStateTerminated) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ContainerStateTerminated) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ContainerStateTerminated) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	i -= len(m.ContainerID)
	copy(dAtA[i:], m.ContainerID)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.ContainerID)))
	i--
	dAtA[i] = 0x3a
	if m.FinishedAt != nil {
		{
			size, err := m.FinishedAt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	if m.StartedAt != nil {
		{
			size, err := m.StartedAt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	i -= len(m.Message)
	copy(dAtA[i:], m.Message)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Message)))
	i--
	dAtA[i] = 0x22
	i -= len(m.Reason)
	copy(dAtA[i:], m.Reason)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Reason)))
	i--
	dAtA[i] = 0x1a
	i = encodeVarintGenerated(dAtA, i, uint64(m.Signal))
	i--
	dAtA[i] = 0x10
	i = encodeVarintGenerated(dAtA, i, uint64(m.ExitCode))
	i--
	dAtA[i] = 0x8
	return len(dAtA) - i, nil
}

func (m *ContainerStateWaiting) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ContainerStateWaiting) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ContainerStateWaiting) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	i -= len(m.Message)
	copy(dAtA[i:], m.Message)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Message)))
	i--
	dAtA[i] = 0x12
	i -= len(m.Reason)
	copy(dAtA[i:], m.Reason)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Reason)))
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *ContainerStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ContainerStatus) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ContainerStatus) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	i -= len(m.ContainerID)
	copy(dAtA[i:], m.ContainerID)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.ContainerID)))
	i--
	dAtA[i] = 0x42
	i -= len(m.ImageID)
	copy(dAtA[i:], m.ImageID)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.ImageID)))
	i--
	dAtA[i] = 0x3a
	i -= len(m.Image)
	copy(dAtA[i:], m.Image)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Image)))
	i--
	dAtA[i] = 0x32
	i = encodeVarintGenerated(dAtA, i, uint64(m.RestartCount))
	i--
	dAtA[i] = 0x28
	i--
	if m.Ready {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i--
	dAtA[i] = 0x20
	if m.LastState != nil {
		{
			size, err := m.LastState.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.State != nil {
		{
			size, err := m.State.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	i -= len(m.Name)
	copy(dAtA[i:], m.Name)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Name)))
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *DaemonEndpoint) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DaemonEndpoint) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DaemonEndpoint) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	i = encodeVarintGenerated(dAtA, i, uint64(m.Port))
	i--
	dAtA[i] = 0x8
	return len(dAtA) - i, nil
}

func (m *DownwardAPIProjection) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DownwardAPIProjection) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DownwardAPIProjection) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Items) > 0 {
		for iNdEx := len(m.Items) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Items[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintGenerated(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *DownwardAPIVolumeFile) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DownwardAPIVolumeFile) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DownwardAPIVolumeFile) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	i = encodeVarintGenerated(dAtA, i, uint64(m.Mode))
	i--
	dAtA[i] = 0x20
	if m.ResourceFieldRef != nil {
		{
			size, err := m.ResourceFieldRef.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.FieldRef != nil {
		{
			size, err := m.FieldRef.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	i -= len(m.Path)
	copy(dAtA[i:], m.Path)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Path)))
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *DownwardAPIVolumeSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DownwardAPIVolumeSource) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DownwardAPIVolumeSource) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	i = encodeVarintGenerated(dAtA, i, uint64(m.DefaultMode))
	i--
	dAtA[i] = 0x10
	if len(m.Items) > 0 {
		for iNdEx := len(m.Items) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Items[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintGenerated(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *EmptyDirVolumeSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EmptyDirVolumeSource) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *EmptyDirVolumeSource) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.SizeLimit != nil {
		{
			size, err := m.SizeLimit.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	i -= len(m.Medium)
	copy(dAtA[i:], m.Medium)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Medium)))
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *EndpointAddress) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EndpointAddress) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *EndpointAddress) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	i -= len(m.NodeName)
	copy(dAtA[i:], m.NodeName)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.NodeName)))
	i--
	dAtA[i] = 0x22
	i -= len(m.Hostname)
	copy(dAtA[i:], m.Hostname)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Hostname)))
	i--
	dAtA[i] = 0x1a
	if m.TargetRef != nil {
		{
			size, err := m.TargetRef.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	i -= len(m.Ip)
	copy(dAtA[i:], m.Ip)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Ip)))
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *EndpointPort) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EndpointPort) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *EndpointPort) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	i -= len(m.Protocol)
	copy(dAtA[i:], m.Protocol)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Protocol)))
	i--
	dAtA[i] = 0x1a
	i = encodeVarintGenerated(dAtA, i, uint64(m.Port))
	i--
	dAtA[i] = 0x10
	i -= len(m.Name)
	copy(dAtA[i:], m.Name)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Name)))
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *EndpointSubset) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EndpointSubset) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *EndpointSubset) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Ports) > 0 {
		for iNdEx := len(m.Ports) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Ports[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintGenerated(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.NotReadyAddresses) > 0 {
		for iNdEx := len(m.NotReadyAddresses) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.NotReadyAddresses[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintGenerated(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Addresses) > 0 {
		for iNdEx := len(m.Addresses) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Addresses[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintGenerated(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *Endpoints) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Endpoints) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Endpoints) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Subsets) > 0 {
		for iNdEx := len(m.Subsets) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Subsets[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintGenerated(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.Metadata != nil {
		{
			size, err := m.Metadata.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *EndpointsList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EndpointsList) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *EndpointsList) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Items) > 0 {
		for iNdEx := len(m.Items) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Items[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintGenerated(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.Metadata != nil {
		{
			size, err := m.Metadata.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *EnvFromSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EnvFromSource) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *EnvFromSource) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.SecretRef != nil {
		{
			size, err := m.SecretRef.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.ConfigMapRef != nil {
		{
			size, err := m.ConfigMapRef.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	i -= len(m.Prefix)
	copy(dAtA[i:], m.Prefix)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Prefix)))
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *EnvVar) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EnvVar) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *EnvVar) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.ValueFrom != nil {
		{
			size, err := m.ValueFrom.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	i -= len(m.Value)
	copy(dAtA[i:], m.Value)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Value)))
	i--
	dAtA[i] = 0x12
	i -= len(m.Name)
	copy(dAtA[i:], m.Name)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Name)))
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *EnvVarSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EnvVarSource) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *EnvVarSource) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.SecretKeyRef != nil {
		{
			size, err := m.SecretKeyRef.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if m.ConfigMapKeyRef != nil {
		{
			size, err := m.ConfigMapKeyRef.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.ResourceFieldRef != nil {
		{
			size, err := m.ResourceFieldRef.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.FieldRef != nil {
		{
			size, err := m.FieldRef.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *EphemeralContainer) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EphemeralContainer) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *EphemeralContainer) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	i -= len(m.TargetContainerName)
	copy(dAtA[i:], m.TargetContainerName)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.TargetContainerName)))
	i--
	dAtA[i] = 0x12
	if m.EphemeralContainerCommon != nil {
		{
			size, err := m.EphemeralContainerCommon.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *EphemeralContainerCommon) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EphemeralContainerCommon) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *EphemeralContainerCommon) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.VolumeDevices) > 0 {
		for iNdEx := len(m.VolumeDevices) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.VolumeDevices[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintGenerated(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1
			i--
			dAtA[i] = 0xaa
		}
	}
	i -= len(m.TerminationMessagePolicy)
	copy(dAtA[i:], m.TerminationMessagePolicy)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.TerminationMessagePolicy)))
	i--
	dAtA[i] = 0x1
	i--
	dAtA[i] = 0xa2
	if len(m.EnvFrom) > 0 {
		for iNdEx := len(m.EnvFrom) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.EnvFrom[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintGenerated(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1
			i--
			dAtA[i] = 0x9a
		}
	}
	i--
	if m.Tty {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i--
	dAtA[i] = 0x1
	i--
	dAtA[i] = 0x90
	i--
	if m.StdinOnce {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i--
	dAtA[i] = 0x1
	i--
	dAtA[i] = 0x88
	i--
	if m.Stdin {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i--
	dAtA[i] = 0x1
	i--
	dAtA[i] = 0x80
	if m.SecurityContext != nil {
		{
			size, err := m.SecurityContext.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x7a
	}
	i -= len(m.ImagePullPolicy)
	copy(dAtA[i:], m.ImagePullPolicy)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.ImagePullPolicy)))
	i--
	dAtA[i] = 0x72
	i -= len(m.TerminationMessagePath)
	copy(dAtA[i:], m.TerminationMessagePath)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.TerminationMessagePath)))
	i--
	dAtA[i] = 0x6a
	if m.Lifecycle != nil {
		{
			size, err := m.Lifecycle.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x62
	}
	if m.ReadinessProbe != nil {
		{
			size, err := m.ReadinessProbe.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x5a
	}
	if m.LivenessProbe != nil {
		{
			size, err := m.LivenessProbe.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x52
	}
	if len(m.VolumeMounts) > 0 {
		for iNdEx := len(m.VolumeMounts) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.VolumeMounts[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintGenerated(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x4a
		}
	}
	if m.Resources != nil {
		{
			size, err := m.Resources.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x42
	}
	if len(m.Env) > 0 {
		for iNdEx := len(m.Env) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Env[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintGenerated(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x3a
		}
	}
	if len(m.Ports) > 0 {
		for iNdEx := len(m.Ports) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Ports[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintGenerated(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x32
		}
	}
	i -= len(m.WorkingDir)
	copy(dAtA[i:], m.WorkingDir)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.WorkingDir)))
	i--
	dAtA[i] = 0x2a
	if len(m.Args) > 0 {
		for iNdEx := len(m.Args) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Args[iNdEx])
			copy(dAtA[i:], m.Args[iNdEx])
			i = encodeVarintGenerated(dAtA, i, uint64(len(m.Args[iNdEx])))
			i--
			dAtA[i] = 0x22
		}
	}
	if len(m.Command) > 0 {
		for iNdEx := len(m.Command) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Command[iNdEx])
			copy(dAtA[i:], m.Command[iNdEx])
			i = encodeVarintGenerated(dAtA, i, uint64(len(m.Command[iNdEx])))
			i--
			dAtA[i] = 0x1a
		}
	}
	i -= len(m.Image)
	copy(dAtA[i:], m.Image)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Image)))
	i--
	dAtA[i] = 0x12
	i -= len(m.Name)
	copy(dAtA[i:], m.Name)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Name)))
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *EphemeralContainers) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EphemeralContainers) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *EphemeralContainers) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.EphemeralContainers) > 0 {
		for iNdEx := len(m.EphemeralContainers) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.EphemeralContainers[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintGenerated(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.Metadata != nil {
		{
			size, err := m.Metadata.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Event) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Event) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Event) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	i -= len(m.ReportingInstance)
	copy(dAtA[i:], m.ReportingInstance)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.ReportingInstance)))
	i--
	dAtA[i] = 0x7a
	i -= len(m.ReportingComponent)
	copy(dAtA[i:], m.ReportingComponent)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.ReportingComponent)))
	i--
	dAtA[i] = 0x72
	if m.Related != nil {
		{
			size, err := m.Related.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x6a
	}
	i -= len(m.Action)
	copy(dAtA[i:], m.Action)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Action)))
	i--
	dAtA[i] = 0x62
	if m.Series != nil {
		{
			size, err := m.Series.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x5a
	}
	if m.EventTime != nil {
		{
			size, err := m.EventTime.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x52
	}
	i -= len(m.Type)
	copy(dAtA[i:], m.Type)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Type)))
	i--
	dAtA[i] = 0x4a
	i = encodeVarintGenerated(dAtA, i, uint64(m.Count))
	i--
	dAtA[i] = 0x40
	if m.LastTimestamp != nil {
		{
			size, err := m.LastTimestamp.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	if m.FirstTimestamp != nil {
		{
			size, err := m.FirstTimestamp.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	if m.Source != nil {
		{
			size, err := m.Source.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	i -= len(m.Message)
	copy(dAtA[i:], m.Message)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Message)))
	i--
	dAtA[i] = 0x22
	i -= len(m.Reason)
	copy(dAtA[i:], m.Reason)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Reason)))
	i--
	dAtA[i] = 0x1a
	if m.InvolvedObject != nil {
		{
			size, err := m.InvolvedObject.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Metadata != nil {
		{
			size, err := m.Metadata.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *EventList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EventList) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *EventList) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Items) > 0 {
		for iNdEx := len(m.Items) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Items[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintGenerated(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.Metadata != nil {
		{
			size, err := m.Metadata.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *EventSeries) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EventSeries) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *EventSeries) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	i -= len(m.State)
	copy(dAtA[i:], m.State)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.State)))
	i--
	dAtA[i] = 0x1a
	if m.LastObservedTime != nil {
		{
			size, err := m.LastObservedTime.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	i = encodeVarintGenerated(dAtA, i, uint64(m.Count))
	i--
	dAtA[i] = 0x8
	return len(dAtA) - i, nil
}

func (m *EventSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EventSource) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *EventSource) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	i -= len(m.Host)
	copy(dAtA[i:], m.Host)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Host)))
	i--
	dAtA[i] = 0x12
	i -= len(m.Component)
	copy(dAtA[i:], m.Component)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Component)))
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *ExecAction) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ExecAction) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ExecAction) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Command) > 0 {
		for iNdEx := len(m.Command) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Command[iNdEx])
			copy(dAtA[i:], m.Command[iNdEx])
			i = encodeVarintGenerated(dAtA, i, uint64(len(m.Command[iNdEx])))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *FCVolumeSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *FCVolumeSource) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *FCVolumeSource) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Wwids) > 0 {
		for iNdEx := len(m.Wwids) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Wwids[iNdEx])
			copy(dAtA[i:], m.Wwids[iNdEx])
			i = encodeVarintGenerated(dAtA, i, uint64(len(m.Wwids[iNdEx])))
			i--
			dAtA[i] = 0x2a
		}
	}
	i--
	if m.ReadOnly {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i--
	dAtA[i] = 0x20
	i -= len(m.FsType)
	copy(dAtA[i:], m.FsType)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.FsType)))
	i--
	dAtA[i] = 0x1a
	i = encodeVarintGenerated(dAtA, i, uint64(m.Lun))
	i--
	dAtA[i] = 0x10
	if len(m.TargetWWNs) > 0 {
		for iNdEx := len(m.TargetWWNs) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.TargetWWNs[iNdEx])
			copy(dAtA[i:], m.TargetWWNs[iNdEx])
			i = encodeVarintGenerated(dAtA, i, uint64(len(m.TargetWWNs[iNdEx])))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *FlexPersistentVolumeSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *FlexPersistentVolumeSource) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *FlexPersistentVolumeSource) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Options) > 0 {
		for k := range m.Options {
			v := m.Options[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintGenerated(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintGenerated(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintGenerated(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x2a
		}
	}
	i--
	if m.ReadOnly {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i--
	dAtA[i] = 0x20
	if m.SecretRef != nil {
		{
			size, err := m.SecretRef.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	i -= len(m.FsType)
	copy(dAtA[i:], m.FsType)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.FsType)))
	i--
	dAtA[i] = 0x12
	i -= len(m.Driver)
	copy(dAtA[i:], m.Driver)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Driver)))
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *FlexVolumeSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *FlexVolumeSource) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *FlexVolumeSource) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Options) > 0 {
		for k := range m.Options {
			v := m.Options[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintGenerated(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintGenerated(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintGenerated(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x2a
		}
	}
	i--
	if m.ReadOnly {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i--
	dAtA[i] = 0x20
	if m.SecretRef != nil {
		{
			size, err := m.SecretRef.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	i -= len(m.FsType)
	copy(dAtA[i:], m.FsType)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.FsType)))
	i--
	dAtA[i] = 0x12
	i -= len(m.Driver)
	copy(dAtA[i:], m.Driver)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Driver)))
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *FlockerVolumeSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *FlockerVolumeSource) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *FlockerVolumeSource) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	i -= len(m.DatasetUUID)
	copy(dAtA[i:], m.DatasetUUID)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.DatasetUUID)))
	i--
	dAtA[i] = 0x12
	i -= len(m.DatasetName)
	copy(dAtA[i:], m.DatasetName)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.DatasetName)))
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *GCEPersistentDiskVolumeSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GCEPersistentDiskVolumeSource) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GCEPersistentDiskVolumeSource) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	i--
	if m.ReadOnly {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i--
	dAtA[i] = 0x20
	i = encodeVarintGenerated(dAtA, i, uint64(m.Partition))
	i--
	dAtA[i] = 0x18
	i -= len(m.FsType)
	copy(dAtA[i:], m.FsType)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.FsType)))
	i--
	dAtA[i] = 0x12
	i -= len(m.PdName)
	copy(dAtA[i:], m.PdName)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.PdName)))
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *GitRepoVolumeSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GitRepoVolumeSource) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GitRepoVolumeSource) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	i -= len(m.Directory)
	copy(dAtA[i:], m.Directory)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Directory)))
	i--
	dAtA[i] = 0x1a
	i -= len(m.Revision)
	copy(dAtA[i:], m.Revision)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Revision)))
	i--
	dAtA[i] = 0x12
	i -= len(m.Repository)
	copy(dAtA[i:], m.Repository)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Repository)))
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *GlusterfsPersistentVolumeSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GlusterfsPersistentVolumeSource) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GlusterfsPersistentVolumeSource) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	i -= len(m.EndpointsNamespace)
	copy(dAtA[i:], m.EndpointsNamespace)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.EndpointsNamespace)))
	i--
	dAtA[i] = 0x22
	i--
	if m.ReadOnly {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i--
	dAtA[i] = 0x18
	i -= len(m.Path)
	copy(dAtA[i:], m.Path)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Path)))
	i--
	dAtA[i] = 0x12
	i -= len(m.Endpoints)
	copy(dAtA[i:], m.Endpoints)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Endpoints)))
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *GlusterfsVolumeSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GlusterfsVolumeSource) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GlusterfsVolumeSource) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	i--
	if m.ReadOnly {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i--
	dAtA[i] = 0x18
	i -= len(m.Path)
	copy(dAtA[i:], m.Path)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Path)))
	i--
	dAtA[i] = 0x12
	i -= len(m.Endpoints)
	copy(dAtA[i:], m.Endpoints)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Endpoints)))
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *HTTPGetAction) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HTTPGetAction) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *HTTPGetAction) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.HttpHeaders) > 0 {
		for iNdEx := len(m.HttpHeaders) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.HttpHeaders[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintGenerated(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x2a
		}
	}
	i -= len(m.Scheme)
	copy(dAtA[i:], m.Scheme)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Scheme)))
	i--
	dAtA[i] = 0x22
	i -= len(m.Host)
	copy(dAtA[i:], m.Host)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Host)))
	i--
	dAtA[i] = 0x1a
	if m.Port != nil {
		{
			size, err := m.Port.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	i -= len(m.Path)
	copy(dAtA[i:], m.Path)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Path)))
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *HTTPHeader) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HTTPHeader) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *HTTPHeader) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	i -= len(m.Value)
	copy(dAtA[i:], m.Value)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Value)))
	i--
	dAtA[i] = 0x12
	i -= len(m.Name)
	copy(dAtA[i:], m.Name)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Name)))
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *Handler) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Handler) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Handler) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.TcpSocket != nil {
		{
			size, err := m.TcpSocket.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.HttpGet != nil {
		{
			size, err := m.HttpGet.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Exec != nil {
		{
			size, err := m.Exec.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *HostAlias) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HostAlias) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *HostAlias) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Hostnames) > 0 {
		for iNdEx := len(m.Hostnames) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Hostnames[iNdEx])
			copy(dAtA[i:], m.Hostnames[iNdEx])
			i = encodeVarintGenerated(dAtA, i, uint64(len(m.Hostnames[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	i -= len(m.Ip)
	copy(dAtA[i:], m.Ip)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Ip)))
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *HostPathVolumeSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HostPathVolumeSource) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *HostPathVolumeSource) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	i -= len(m.Type)
	copy(dAtA[i:], m.Type)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Type)))
	i--
	dAtA[i] = 0x12
	i -= len(m.Path)
	copy(dAtA[i:], m.Path)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Path)))
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *ISCSIPersistentVolumeSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ISCSIPersistentVolumeSource) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ISCSIPersistentVolumeSource) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	i -= len(m.InitiatorName)
	copy(dAtA[i:], m.InitiatorName)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.InitiatorName)))
	i--
	dAtA[i] = 0x62
	i--
	if m.ChapAuthSession {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i--
	dAtA[i] = 0x58
	if m.SecretRef != nil {
		{
			size, err := m.SecretRef.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x52
	}
	i--
	if m.ChapAuthDiscovery {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i--
	dAtA[i] = 0x40
	if len(m.Portals) > 0 {
		for iNdEx := len(m.Portals) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Portals[iNdEx])
			copy(dAtA[i:], m.Portals[iNdEx])
			i = encodeVarintGenerated(dAtA, i, uint64(len(m.Portals[iNdEx])))
			i--
			dAtA[i] = 0x3a
		}
	}
	i--
	if m.ReadOnly {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i--
	dAtA[i] = 0x30
	i -= len(m.FsType)
	copy(dAtA[i:], m.FsType)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.FsType)))
	i--
	dAtA[i] = 0x2a
	i -= len(m.IscsiInterface)
	copy(dAtA[i:], m.IscsiInterface)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.IscsiInterface)))
	i--
	dAtA[i] = 0x22
	i = encodeVarintGenerated(dAtA, i, uint64(m.Lun))
	i--
	dAtA[i] = 0x18
	i -= len(m.Iqn)
	copy(dAtA[i:], m.Iqn)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Iqn)))
	i--
	dAtA[i] = 0x12
	i -= len(m.TargetPortal)
	copy(dAtA[i:], m.TargetPortal)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.TargetPortal)))
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *ISCSIVolumeSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ISCSIVolumeSource) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ISCSIVolumeSource) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	i -= len(m.InitiatorName)
	copy(dAtA[i:], m.InitiatorName)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.InitiatorName)))
	i--
	dAtA[i] = 0x62
	i--
	if m.ChapAuthSession {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i--
	dAtA[i] = 0x58
	if m.SecretRef != nil {
		{
			size, err := m.SecretRef.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x52
	}
	i--
	if m.ChapAuthDiscovery {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i--
	dAtA[i] = 0x40
	if len(m.Portals) > 0 {
		for iNdEx := len(m.Portals) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Portals[iNdEx])
			copy(dAtA[i:], m.Portals[iNdEx])
			i = encodeVarintGenerated(dAtA, i, uint64(len(m.Portals[iNdEx])))
			i--
			dAtA[i] = 0x3a
		}
	}
	i--
	if m.ReadOnly {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i--
	dAtA[i] = 0x30
	i -= len(m.FsType)
	copy(dAtA[i:], m.FsType)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.FsType)))
	i--
	dAtA[i] = 0x2a
	i -= len(m.IscsiInterface)
	copy(dAtA[i:], m.IscsiInterface)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.IscsiInterface)))
	i--
	dAtA[i] = 0x22
	i = encodeVarintGenerated(dAtA, i, uint64(m.Lun))
	i--
	dAtA[i] = 0x18
	i -= len(m.Iqn)
	copy(dAtA[i:], m.Iqn)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Iqn)))
	i--
	dAtA[i] = 0x12
	i -= len(m.TargetPortal)
	copy(dAtA[i:], m.TargetPortal)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.TargetPortal)))
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *KeyToPath) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *KeyToPath) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *KeyToPath) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	i = encodeVarintGenerated(dAtA, i, uint64(m.Mode))
	i--
	dAtA[i] = 0x18
	i -= len(m.Path)
	copy(dAtA[i:], m.Path)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Path)))
	i--
	dAtA[i] = 0x12
	i -= len(m.Key)
	copy(dAtA[i:], m.Key)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Key)))
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *Lifecycle) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Lifecycle) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Lifecycle) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.PreStop != nil {
		{
			size, err := m.PreStop.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.PostStart != nil {
		{
			size, err := m.PostStart.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *LimitRange) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LimitRange) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *LimitRange) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Spec != nil {
		{
			size, err := m.Spec.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Metadata != nil {
		{
			size, err := m.Metadata.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *LimitRangeItem) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LimitRangeItem) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *LimitRangeItem) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.MaxLimitRequestRatio) > 0 {
		for k := range m.MaxLimitRequestRatio {
			v := m.MaxLimitRequestRatio[k]
			baseI := i
			if v != nil {
				{
					size, err := v.MarshalToSizedBuffer(dAtA[:i])
					if err != nil {
						return 0, err
					}
					i -= size
					i = encodeVarintGenerated(dAtA, i, uint64(size))
				}
				i--
				dAtA[i] = 0x12
			}
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintGenerated(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintGenerated(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x32
		}
	}
	if len(m.DefaultRequest) > 0 {
		for k := range m.DefaultRequest {
			v := m.DefaultRequest[k]
			baseI := i
			if v != nil {
				{
					size, err := v.MarshalToSizedBuffer(dAtA[:i])
					if err != nil {
						return 0, err
					}
					i -= size
					i = encodeVarintGenerated(dAtA, i, uint64(size))
				}
				i--
				dAtA[i] = 0x12
			}
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintGenerated(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintGenerated(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x2a
		}
	}
	if len(m.Default) > 0 {
		for k := range m.Default {
			v := m.Default[k]
			baseI := i
			if v != nil {
				{
					size, err := v.MarshalToSizedBuffer(dAtA[:i])
					if err != nil {
						return 0, err
					}
					i -= size
					i = encodeVarintGenerated(dAtA, i, uint64(size))
				}
				i--
				dAtA[i] = 0x12
			}
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintGenerated(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintGenerated(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x22
		}
	}
	if len(m.Min) > 0 {
		for k := range m.Min {
			v := m.Min[k]
			baseI := i
			if v != nil {
				{
					size, err := v.MarshalToSizedBuffer(dAtA[:i])
					if err != nil {
						return 0, err
					}
					i -= size
					i = encodeVarintGenerated(dAtA, i, uint64(size))
				}
				i--
				dAtA[i] = 0x12
			}
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintGenerated(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintGenerated(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.Max) > 0 {
		for k := range m.Max {
			v := m.Max[k]
			baseI := i
			if v != nil {
				{
					size, err := v.MarshalToSizedBuffer(dAtA[:i])
					if err != nil {
						return 0, err
					}
					i -= size
					i = encodeVarintGenerated(dAtA, i, uint64(size))
				}
				i--
				dAtA[i] = 0x12
			}
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintGenerated(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintGenerated(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x12
		}
	}
	i -= len(m.Type)
	copy(dAtA[i:], m.Type)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Type)))
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *LimitRangeList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LimitRangeList) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *LimitRangeList) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Items) > 0 {
		for iNdEx := len(m.Items) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Items[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintGenerated(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.Metadata != nil {
		{
			size, err := m.Metadata.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *LimitRangeSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LimitRangeSpec) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *LimitRangeSpec) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Limits) > 0 {
		for iNdEx := len(m.Limits) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Limits[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintGenerated(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *List) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *List) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *List) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Items) > 0 {
		for iNdEx := len(m.Items) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Items[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintGenerated(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.Metadata != nil {
		{
			size, err := m.Metadata.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *LoadBalancerIngress) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LoadBalancerIngress) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *LoadBalancerIngress) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	i -= len(m.Hostname)
	copy(dAtA[i:], m.Hostname)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Hostname)))
	i--
	dAtA[i] = 0x12
	i -= len(m.Ip)
	copy(dAtA[i:], m.Ip)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Ip)))
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *LoadBalancerStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LoadBalancerStatus) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *LoadBalancerStatus) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Ingress) > 0 {
		for iNdEx := len(m.Ingress) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Ingress[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintGenerated(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *LocalObjectReference) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LocalObjectReference) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *LocalObjectReference) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	i -= len(m.Name)
	copy(dAtA[i:], m.Name)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Name)))
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *LocalVolumeSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LocalVolumeSource) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *LocalVolumeSource) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	i -= len(m.FsType)
	copy(dAtA[i:], m.FsType)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.FsType)))
	i--
	dAtA[i] = 0x12
	i -= len(m.Path)
	copy(dAtA[i:], m.Path)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Path)))
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *NFSVolumeSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NFSVolumeSource) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NFSVolumeSource) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	i--
	if m.ReadOnly {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i--
	dAtA[i] = 0x18
	i -= len(m.Path)
	copy(dAtA[i:], m.Path)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Path)))
	i--
	dAtA[i] = 0x12
	i -= len(m.Server)
	copy(dAtA[i:], m.Server)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Server)))
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *Namespace) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Namespace) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Namespace) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Status != nil {
		{
			size, err := m.Status.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.Spec != nil {
		{
			size, err := m.Spec.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Metadata != nil {
		{
			size, err := m.Metadata.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *NamespaceList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NamespaceList) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NamespaceList) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Items) > 0 {
		for iNdEx := len(m.Items) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Items[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintGenerated(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.Metadata != nil {
		{
			size, err := m.Metadata.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *NamespaceSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NamespaceSpec) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NamespaceSpec) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Finalizers) > 0 {
		for iNdEx := len(m.Finalizers) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Finalizers[iNdEx])
			copy(dAtA[i:], m.Finalizers[iNdEx])
			i = encodeVarintGenerated(dAtA, i, uint64(len(m.Finalizers[iNdEx])))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *NamespaceStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NamespaceStatus) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NamespaceStatus) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	i -= len(m.Phase)
	copy(dAtA[i:], m.Phase)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Phase)))
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *Node) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Node) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Node) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Status != nil {
		{
			size, err := m.Status.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.Spec != nil {
		{
			size, err := m.Spec.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Metadata != nil {
		{
			size, err := m.Metadata.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *NodeAddress) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NodeAddress) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NodeAddress) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	i -= len(m.Address)
	copy(dAtA[i:], m.Address)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Address)))
	i--
	dAtA[i] = 0x12
	i -= len(m.Type)
	copy(dAtA[i:], m.Type)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Type)))
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *NodeAffinity) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NodeAffinity) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NodeAffinity) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.PreferredDuringSchedulingIgnoredDuringExecution) > 0 {
		for iNdEx := len(m.PreferredDuringSchedulingIgnoredDuringExecution) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.PreferredDuringSchedulingIgnoredDuringExecution[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintGenerated(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.RequiredDuringSchedulingIgnoredDuringExecution != nil {
		{
			size, err := m.RequiredDuringSchedulingIgnoredDuringExecution.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *NodeCondition) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NodeCondition) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NodeCondition) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	i -= len(m.Message)
	copy(dAtA[i:], m.Message)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Message)))
	i--
	dAtA[i] = 0x32
	i -= len(m.Reason)
	copy(dAtA[i:], m.Reason)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Reason)))
	i--
	dAtA[i] = 0x2a
	if m.LastTransitionTime != nil {
		{
			size, err := m.LastTransitionTime.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if m.LastHeartbeatTime != nil {
		{
			size, err := m.LastHeartbeatTime.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	i -= len(m.Status)
	copy(dAtA[i:], m.Status)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Status)))
	i--
	dAtA[i] = 0x12
	i -= len(m.Type)
	copy(dAtA[i:], m.Type)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Type)))
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *NodeConfigSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NodeConfigSource) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NodeConfigSource) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.ConfigMap != nil {
		{
			size, err := m.ConfigMap.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	return len(dAtA) - i, nil
}

func (m *NodeConfigStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NodeConfigStatus) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NodeConfigStatus) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	i -= len(m.Error)
	copy(dAtA[i:], m.Error)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Error)))
	i--
	dAtA[i] = 0x22
	if m.LastKnownGood != nil {
		{
			size, err := m.LastKnownGood.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.Active != nil {
		{
			size, err := m.Active.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Assigned != nil {
		{
			size, err := m.Assigned.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *NodeDaemonEndpoints) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NodeDaemonEndpoints) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NodeDaemonEndpoints) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.KubeletEndpoint != nil {
		{
			size, err := m.KubeletEndpoint.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *NodeList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NodeList) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NodeList) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Items) > 0 {
		for iNdEx := len(m.Items) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Items[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintGenerated(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.Metadata != nil {
		{
			size, err := m.Metadata.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *NodeProxyOptions) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NodeProxyOptions) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NodeProxyOptions) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	i -= len(m.Path)
	copy(dAtA[i:], m.Path)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Path)))
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *NodeResources) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NodeResources) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NodeResources) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Capacity) > 0 {
		for k := range m.Capacity {
			v := m.Capacity[k]
			baseI := i
			if v != nil {
				{
					size, err := v.MarshalToSizedBuffer(dAtA[:i])
					if err != nil {
						return 0, err
					}
					i -= size
					i = encodeVarintGenerated(dAtA, i, uint64(size))
				}
				i--
				dAtA[i] = 0x12
			}
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintGenerated(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintGenerated(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *NodeSelector) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NodeSelector) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NodeSelector) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.NodeSelectorTerms) > 0 {
		for iNdEx := len(m.NodeSelectorTerms) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.NodeSelectorTerms[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintGenerated(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *NodeSelectorRequirement) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NodeSelectorRequirement) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NodeSelectorRequirement) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Values) > 0 {
		for iNdEx := len(m.Values) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Values[iNdEx])
			copy(dAtA[i:], m.Values[iNdEx])
			i = encodeVarintGenerated(dAtA, i, uint64(len(m.Values[iNdEx])))
			i--
			dAtA[i] = 0x1a
		}
	}
	i -= len(m.Operator)
	copy(dAtA[i:], m.Operator)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Operator)))
	i--
	dAtA[i] = 0x12
	i -= len(m.Key)
	copy(dAtA[i:], m.Key)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Key)))
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *NodeSelectorTerm) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NodeSelectorTerm) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NodeSelectorTerm) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.MatchFields) > 0 {
		for iNdEx := len(m.MatchFields) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.MatchFields[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintGenerated(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.MatchExpressions) > 0 {
		for iNdEx := len(m.MatchExpressions) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.MatchExpressions[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintGenerated(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *NodeSpec) Marshal() (dAtA []byte, err e