// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: k8s.io/api/settings/v1alpha1/generated.proto

package k8s_io_api_settings_v1alpha1

import (
	fmt "fmt"
	proto "github.com/gogo/protobuf/proto"
	io "io"
	v11 "istio.io/gogo-genproto/k8s.io/api/core/v1"
	v1 "istio.io/gogo-genproto/k8s.io/apimachinery/pkg/apis/meta/v1"
	_ "istio.io/gogo-genproto/k8s.io/apimachinery/pkg/runtime"
	_ "istio.io/gogo-genproto/k8s.io/apimachinery/pkg/runtime/schema"
	math "math"
	math_bits "math/bits"
	reflect "reflect"
	strings "strings"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

// PodPreset is a policy resource that defines additional runtime
// requirements for a Pod.
type PodPreset struct {
	// +optional
	Metadata *v1.ObjectMeta `protobuf:"bytes,1,opt,name=metadata" json:"metadata,omitempty"`
	// +optional
	Spec *PodPresetSpec `protobuf:"bytes,2,opt,name=spec" json:"spec,omitempty"`
}

func (m *PodPreset) Reset()      { *m = PodPreset{} }
func (*PodPreset) ProtoMessage() {}
func (*PodPreset) Descriptor() ([]byte, []int) {
	return fileDescriptor_8229fcbd37f583b1, []int{0}
}
func (m *PodPreset) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PodPreset) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PodPreset.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PodPreset) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PodPreset.Merge(m, src)
}
func (m *PodPreset) XXX_Size() int {
	return m.Size()
}
func (m *PodPreset) XXX_DiscardUnknown() {
	xxx_messageInfo_PodPreset.DiscardUnknown(m)
}

var xxx_messageInfo_PodPreset proto.InternalMessageInfo

func (m *PodPreset) GetMetadata() *v1.ObjectMeta {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *PodPreset) GetSpec() *PodPresetSpec {
	if m != nil {
		return m.Spec
	}
	return nil
}

// PodPresetList is a list of PodPreset objects.
type PodPresetList struct {
	// Standard list metadata.
	// More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
	// +optional
	Metadata *v1.ListMeta `protobuf:"bytes,1,opt,name=metadata" json:"metadata,omitempty"`
	// Items is a list of schema objects.
	Items []*PodPreset `protobuf:"bytes,2,rep,name=items" json:"items,omitempty"`
}

func (m *PodPresetList) Reset()      { *m = PodPresetList{} }
func (*PodPresetList) ProtoMessage() {}
func (*PodPresetList) Descriptor() ([]byte, []int) {
	return fileDescriptor_8229fcbd37f583b1, []int{1}
}
func (m *PodPresetList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PodPresetList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PodPresetList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PodPresetList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PodPresetList.Merge(m, src)
}
func (m *PodPresetList) XXX_Size() int {
	return m.Size()
}
func (m *PodPresetList) XXX_DiscardUnknown() {
	xxx_messageInfo_PodPresetList.DiscardUnknown(m)
}

var xxx_messageInfo_PodPresetList proto.InternalMessageInfo

func (m *PodPresetList) GetMetadata() *v1.ListMeta {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *PodPresetList) GetItems() []*PodPreset {
	if m != nil {
		return m.Items
	}
	return nil
}

// PodPresetSpec is a description of a pod preset.
type PodPresetSpec struct {
	// Selector is a label query over a set of resources, in this case pods.
	// Required.
	Selector *v1.LabelSelector `protobuf:"bytes,1,opt,name=selector" json:"selector,omitempty"`
	// Env defines the collection of EnvVar to inject into containers.
	// +optional
	Env []*v11.EnvVar `protobuf:"bytes,2,rep,name=env" json:"env,omitempty"`
	// EnvFrom defines the collection of EnvFromSource to inject into containers.
	// +optional
	EnvFrom []*v11.EnvFromSource `protobuf:"bytes,3,rep,name=envFrom" json:"envFrom,omitempty"`
	// Volumes defines the collection of Volume to inject into the pod.
	// +optional
	Volumes []*v11.Volume `protobuf:"bytes,4,rep,name=volumes" json:"volumes,omitempty"`
	// VolumeMounts defines the collection of VolumeMount to inject into containers.
	// +optional
	VolumeMounts []*v11.VolumeMount `protobuf:"bytes,5,rep,name=volumeMounts" json:"volumeMounts,omitempty"`
}

func (m *PodPresetSpec) Reset()      { *m = PodPresetSpec{} }
func (*PodPresetSpec) ProtoMessage() {}
func (*PodPresetSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_8229fcbd37f583b1, []int{2}
}
func (m *PodPresetSpec) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PodPresetSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PodPresetSpec.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PodPresetSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PodPresetSpec.Merge(m, src)
}
func (m *PodPresetSpec) XXX_Size() int {
	return m.Size()
}
func (m *PodPresetSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_PodPresetSpec.DiscardUnknown(m)
}

var xxx_messageInfo_PodPresetSpec proto.InternalMessageInfo

func (m *PodPresetSpec) GetSelector() *v1.LabelSelector {
	if m != nil {
		return m.Selector
	}
	return nil
}

func (m *PodPresetSpec) GetEnv() []*v11.EnvVar {
	if m != nil {
		return m.Env
	}
	return nil
}

func (m *PodPresetSpec) GetEnvFrom() []*v11.EnvFromSource {
	if m != nil {
		return m.EnvFrom
	}
	return nil
}

func (m *PodPresetSpec) GetVolumes() []*v11.Volume {
	if m != nil {
		return m.Volumes
	}
	return nil
}

func (m *PodPresetSpec) GetVolumeMounts() []*v11.VolumeMount {
	if m != nil {
		return m.VolumeMounts
	}
	return nil
}

func init() {
	proto.RegisterType((*PodPreset)(nil), "k8s.io.api.settings.v1alpha1.PodPreset")
	proto.RegisterType((*PodPresetList)(nil), "k8s.io.api.settings.v1alpha1.PodPresetList")
	proto.RegisterType((*PodPresetSpec)(nil), "k8s.io.api.settings.v1alpha1.PodPresetSpec")
}

func init() {
	proto.RegisterFile("k8s.io/api/settings/v1alpha1/generated.proto", fileDescriptor_8229fcbd37f583b1)
}

var fileDescriptor_8229fcbd37f583b1 = []byte{
	// 449 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x8c, 0x92, 0xc1, 0x6a, 0x13, 0x41,
	0x1c, 0x87, 0x77, 0x92, 0x96, 0xd6, 0xa9, 0x5e, 0xe6, 0xb4, 0x04, 0x19, 0x6b, 0x2e, 0x16, 0x2c,
	0xb3, 0xa6, 0x06, 0x11, 0x44, 0x04, 0x45, 0x0f, 0xd2, 0xd2, 0xb2, 0x81, 0xde, 0xa7, 0x93, 0x3f,
	0xc9, 0x98, 0xec, 0xcc, 0x30, 0x33, 0x59, 0xf0, 0xe6, 0x23, 0x78, 0xf6, 0x09, 0x7c, 0x12, 0xf1,
	0x98, 0x63, 0x8f, 0x66, 0x73, 0xf1, 0xd8, 0x47, 0x90, 0xd9, 0x24, 0xdb, 0x98, 0x18, 0x9b, 0x5b,
	0xf8, 0xf3, 0x7d, 0xbf, 0x7c, 0x0c, 0x8b, 0x8f, 0x07, 0x2f, 0x1d, 0x93, 0x3a, 0xe1, 0x46, 0x26,
	0x0e, 0xbc, 0x97, 0xaa, 0xe7, 0x92, 0xbc, 0xc5, 0x87, 0xa6, 0xcf, 0x5b, 0x49, 0x0f, 0x14, 0x58,
	0xee, 0xa1, 0xcb, 0x8c, 0xd5, 0x5e, 0x93, 0x87, 0x33, 0x9a, 0x71, 0x23, 0xd9, 0x82, 0x66, 0x0b,
	0xba, 0xd1, 0x5c, 0xda, 0x12, 0xda, 0x42, 0x92, 0xaf, 0x2d, 0x34, 0xda, 0xb7, 0x4c, 0xc6, 0x45,
	0x5f, 0x2a, 0xb0, 0x9f, 0x13, 0x33, 0xe8, 0x85, 0x83, 0x4b, 0x32, 0xf0, 0xfc, 0x5f, 0x56, 0xb2,
	0xc9, 0xb2, 0x23, 0xe5, 0x65, 0x06, 0x6b, 0xc2, 0x8b, 0xbb, 0x04, 0x27, 0xfa, 0x90, 0xf1, 0x55,
	0xaf, 0xf9, 0x0d, 0xe1, 0x7b, 0x17, 0xba, 0x7b, 0x61, 0xc1, 0x81, 0x27, 0xa7, 0x78, 0x3f, 0x14,
	0x75, 0xb9, 0xe7, 0x31, 0x3a, 0x44, 0x47, 0x07, 0x27, 0xcf, 0xd8, 0xed, 0x0b, 0x54, 0xc3, 0xcc,
	0x0c, 0x7a, 0xe1, 0xe0, 0x58, 0xa0, 0x59, 0xde, 0x62, 0xe7, 0x57, 0x9f, 0x40, 0xf8, 0x33, 0xf0,
	0x3c, 0xad, 0x16, 0xc8, 0x1b, 0xbc, 0xe3, 0x0c, 0x88, 0xb8, 0x56, 0x2e, 0x3d, 0x65, 0xff, 0x7b,
	0x4b, 0x56, 0x45, 0x74, 0x0c, 0x88, 0xb4, 0x14, 0x43, 0xdc, 0x83, 0xea, 0x7e, 0x2a, 0x9d, 0x27,
	0x1f, 0xd7, 0x02, 0xd9, 0x76, 0x81, 0xc1, 0x5e, 0xc9, 0x7b, 0x8d, 0x77, 0xa5, 0x87, 0xcc, 0xc5,
	0xb5, 0xc3, 0xfa, 0xd1, 0xc1, 0xc9, 0x93, 0x2d, 0xfb, 0xd2, 0x99, 0xd5, 0xfc, 0x51, 0x5b, 0x8a,
	0x0b, 0xd1, 0xe4, 0x1c, 0xef, 0x3b, 0x18, 0x82, 0xf0, 0xda, 0xce, 0xe3, 0x9e, 0x6f, 0x19, 0xc7,
	0xaf, 0x60, 0xd8, 0x99, 0xab, 0x69, 0x35, 0x42, 0x8e, 0x71, 0x1d, 0x54, 0x3e, 0xef, 0x6b, 0x2c,
	0xf7, 0x85, 0xaf, 0x2d, 0x98, 0xef, 0x55, 0x7e, 0xc9, 0x6d, 0x1a, 0x30, 0xf2, 0x0a, 0xef, 0x81,
	0xca, 0x3f, 0x58, 0x9d, 0xc5, 0xf5, 0xd2, 0x78, 0xbc, 0xc1, 0x08, 0x48, 0x47, 0x8f, 0xac, 0x80,
	0x74, 0x61, 0x90, 0x36, 0xde, 0xcb, 0xf5, 0x70, 0x94, 0x81, 0x8b, 0x77, 0x36, 0xff, 0xdd, 0x65,
	0x89, 0xa4, 0x0b, 0x94, 0xbc, 0xc3, 0xf7, 0x67, 0x3f, 0xcf, 0xf4, 0x48, 0x79, 0x17, 0xef, 0x96,
	0xea, 0xa3, 0xcd, 0x6a, 0xc9, 0xa5, 0x7f, 0x49, 0x6f, 0xdb, 0xe3, 0x09, 0x8d, 0xae, 0x27, 0x34,
	0xba, 0x99, 0x50, 0xf4, 0xa5, 0xa0, 0xe8, 0x7b, 0x41, 0xd1, 0xcf, 0x82, 0xa2, 0x71, 0x41, 0xd1,
	0xaf, 0x82, 0xa2, 0xdf, 0x05, 0x8d, 0x6e, 0x0a, 0x8a, 0xbe, 0x4e, 0x69, 0x34, 0x9e, 0xd2, 0xe8,
	0x7a, 0x4a, 0xa3, 0x3f, 0x01, 0x00, 0x00, 0xff, 0xff, 0x0e, 0x10, 0x27, 0xe7, 0xc8, 0x03, 0x00,
	0x00,
}

func (this *PodPreset) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PodPreset)
	if !ok {
		that2, ok := that.(PodPreset)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Metadata.Equal(that1.Metadata) {
		return false
	}
	if !this.Spec.Equal(that1.Spec) {
		return false
	}
	return true
}
func (this *PodPresetList) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PodPresetList)
	if !ok {
		that2, ok := that.(PodPresetList)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Metadata.Equal(that1.Metadata) {
		return false
	}
	if len(this.Items) != len(that1.Items) {
		return false
	}
	for i := range this.Items {
		if !this.Items[i].Equal(that1.Items[i]) {
			return false
		}
	}
	return true
}
func (this *PodPresetSpec) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PodPresetSpec)
	if !ok {
		that2, ok := that.(PodPresetSpec)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Selector.Equal(that1.Selector) {
		return false
	}
	if len(this.Env) != len(that1.Env) {
		return false
	}
	for i := range this.Env {
		if !this.Env[i].Equal(that1.Env[i]) {
			return false
		}
	}
	if len(this.EnvFrom) != len(that1.EnvFrom) {
		return false
	}
	for i := range this.EnvFrom {
		if !this.EnvFrom[i].Equal(that1.EnvFrom[i]) {
			return false
		}
	}
	if len(this.Volumes) != len(that1.Volumes) {
		return false
	}
	for i := range this.Volumes {
		if !this.Volumes[i].Equal(that1.Volumes[i]) {
			return false
		}
	}
	if len(this.VolumeMounts) != len(that1.VolumeMounts) {
		return false
	}
	for i := range this.VolumeMounts {
		if !this.VolumeMounts[i].Equal(that1.VolumeMounts[i]) {
			return false
		}
	}
	return true
}
func (this *PodPreset) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&k8s_io_api_settings_v1alpha1.PodPreset{")
	if this.Metadata != nil {
		s = append(s, "Metadata: "+fmt.Sprintf("%#v", this.Metadata)+",\n")
	}
	if this.Spec != nil {
		s = append(s, "Spec: "+fmt.Sprintf("%#v", this.Spec)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *PodPresetList) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&k8s_io_api_settings_v1alpha1.PodPresetList{")
	if this.Metadata != nil {
		s = append(s, "Metadata: "+fmt.Sprintf("%#v", this.Metadata)+",\n")
	}
	if this.Items != nil {
		s = append(s, "Items: "+fmt.Sprintf("%#v", this.Items)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *PodPresetSpec) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 9)
	s = append(s, "&k8s_io_api_settings_v1alpha1.PodPresetSpec{")
	if this.Selector != nil {
		s = append(s, "Selector: "+fmt.Sprintf("%#v", this.Selector)+",\n")
	}
	if this.Env != nil {
		s = append(s, "Env: "+fmt.Sprintf("%#v", this.Env)+",\n")
	}
	if this.EnvFrom != nil {
		s = append(s, "EnvFrom: "+fmt.Sprintf("%#v", this.EnvFrom)+",\n")
	}
	if this.Volumes != nil {
		s = append(s, "Volumes: "+fmt.Sprintf("%#v", this.Volumes)+",\n")
	}
	if this.VolumeMounts != nil {
		s = append(s, "VolumeMounts: "+fmt.Sprintf("%#v", this.VolumeMounts)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringGenerated(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}
func (m *PodPreset) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PodPreset) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PodPreset) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Spec != nil {
		{
			size, err := m.Spec.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Metadata != nil {
		{
			size, err := m.Metadata.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PodPresetList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PodPresetList) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PodPresetList) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Items) > 0 {
		for iNdEx := len(m.Items) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Items[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintGenerated(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.Metadata != nil {
		{
			size, err := m.Metadata.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PodPresetSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PodPresetSpec) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PodPresetSpec) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.VolumeMounts) > 0 {
		for iNdEx := len(m.VolumeMounts) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.VolumeMounts[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintGenerated(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x2a
		}
	}
	if len(m.Volumes) > 0 {
		for iNdEx := len(m.Volumes) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Volumes[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintGenerated(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x22
		}
	}
	if len(m.EnvFrom) > 0 {
		for iNdEx := len(m.EnvFrom) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.EnvFrom[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintGenerated(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.Env) > 0 {
		for iNdEx := len(m.Env) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Env[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintGenerated(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.Selector != nil {
		{
			size, err := m.Selector.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintGenerated(dAtA []byte, offset int, v uint64) int {
	offset -= sovGenerated(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *PodPreset) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Metadata != nil {
		l = m.Metadata.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Spec != nil {
		l = m.Spec.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	return n
}

func (m *PodPresetList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Metadata != nil {
		l = m.Metadata.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	return n
}

func (m *PodPresetSpec) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Selector != nil {
		l = m.Selector.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if len(m.Env) > 0 {
		for _, e := range m.Env {
			l = e.Size()
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if len(m.EnvFrom) > 0 {
		for _, e := range m.EnvFrom {
			l = e.Size()
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if len(m.Volumes) > 0 {
		for _, e := range m.Volumes {
			l = e.Size()
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if len(m.VolumeMounts) > 0 {
		for _, e := range m.VolumeMounts {
			l = e.Size()
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	return n
}

func sovGenerated(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozGenerated(x uint64) (n int) {
	return sovGenerated(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *PodPreset) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&PodPreset{`,
		`Metadata:` + strings.Replace(fmt.Sprintf("%v", this.Metadata), "ObjectMeta", "v1.ObjectMeta", 1) + `,`,
		`Spec:` + strings.Replace(this.Spec.String(), "PodPresetSpec", "PodPresetSpec", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *PodPresetList) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForItems := "[]*PodPreset{"
	for _, f := range this.Items {
		repeatedStringForItems += strings.Replace(f.String(), "PodPreset", "PodPreset", 1) + ","
	}
	repeatedStringForItems += "}"
	s := strings.Join([]string{`&PodPresetList{`,
		`Metadata:` + strings.Replace(fmt.Sprintf("%v", this.Metadata), "ListMeta", "v1.ListMeta", 1) + `,`,
		`Items:` + repeatedStringForItems + `,`,
		`}`,
	}, "")
	return s
}
func (this *PodPresetSpec) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForEnv := "[]*EnvVar{"
	for _, f := range this.Env {
		repeatedStringForEnv += strings.Replace(fmt.Sprintf("%v", f), "EnvVar", "v11.EnvVar", 1) + ","
	}
	repeatedStringForEnv += "}"
	repeatedStringForEnvFrom := "[]*EnvFromSource{"
	for _, f := range this.EnvFrom {
		repeatedStringForEnvFrom += strings.Replace(fmt.Sprintf("%v", f), "EnvFromSource", "v11.EnvFromSource", 1) + ","
	}
	repeatedStringForEnvFrom += "}"
	repeatedStringForVolumes := "[]*Volume{"
	for _, f := range this.Volumes {
		repeatedStringForVolumes += strings.Replace(fmt.Sprintf("%v", f), "Volume", "v11.Volume", 1) + ","
	}
	repeatedStringForVolumes += "}"
	repeatedStringForVolumeMounts := "[]*VolumeMount{"
	for _, f := range this.VolumeMounts {
		repeatedStringForVolumeMounts += strings.Replace(fmt.Sprintf("%v", f), "VolumeMount", "v11.VolumeMount", 1) + ","
	}
	repeatedStringForVolumeMounts += "}"
	s := strings.Join([]string{`&PodPresetSpec{`,
		`Selector:` + strings.Replace(fmt.Sprintf("%v", this.Selector), "LabelSelector", "v1.LabelSelector", 1) + `,`,
		`Env:` + repeatedStringForEnv + `,`,
		`EnvFrom:` + repeatedStringForEnvFrom + `,`,
		`Volumes:` + repeatedStringForVolumes + `,`,
		`VolumeMounts:` + repeatedStringForVolumeMounts + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringGenerated(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *PodPreset) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PodPreset: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PodPreset: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metadata", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Metadata == nil {
				m.Metadata = &v1.ObjectMeta{}
			}
			if err := m.Metadata.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Spec", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Spec == nil {
				m.Spec = &PodPresetSpec{}
			}
			if err := m.Spec.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PodPresetList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PodPresetList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PodPresetList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metadata", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Metadata == nil {
				m.Metadata = &v1.ListMeta{}
			}
			if err := m.Metadata.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, &PodPreset{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PodPresetSpec) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PodPresetSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PodPresetSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Selector", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Selector == nil {
				m.Selector = &v1.LabelSelector{}
			}
			if err := m.Selector.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Env", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Env = append(m.Env, &v11.EnvVar{})
			if err := m.Env[len(m.Env)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EnvFrom", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EnvFrom = append(m.EnvFrom, &v11.EnvFromSource{})
			if err := m.EnvFrom[len(m.EnvFrom)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Volumes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Volumes = append(m.Volumes, &v11.Volume{})
			if err := m.Volumes[len(m.Volumes)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field VolumeMounts", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.VolumeMounts = append(m.VolumeMounts, &v11.VolumeMount{})
			if err := m.VolumeMounts[len(m.VolumeMounts)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipGenerated(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthGenerated
			}
			iNdEx += length
			if iNdEx < 0 {
				return 0, ErrInvalidLengthGenerated
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowGenerated
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipGenerated(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
				if iNdEx < 0 {
					return 0, ErrInvalidLengthGenerated
				}
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthGenerated = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowGenerated   = fmt.Errorf("proto: integer overflow")
)
