// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: mesh/v1alpha1/proxy.proto

package v1alpha1

import (
	encoding_binary "encoding/binary"
	fmt "fmt"
	proto "github.com/gogo/protobuf/proto"
	types "github.com/gogo/protobuf/types"
	io "io"
	v1alpha3 "istio.io/api/networking/v1alpha3"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

// AuthenticationPolicy defines how the proxy is authenticated when it connects to the control plane.
// It can be set for two different scopes, mesh-wide or set on a per-pod basis using the ProxyConfig annotation.
// Mesh policy cannot be INHERIT.
type AuthenticationPolicy int32

const (
	// Do not encrypt proxy to control plane traffic.
	AuthenticationPolicy_NONE AuthenticationPolicy = 0
	// Proxy to control plane traffic is wrapped into mutual TLS connections.
	AuthenticationPolicy_MUTUAL_TLS AuthenticationPolicy = 1
	// Use the policy defined by the parent scope. Should not be used for mesh
	// policy.
	AuthenticationPolicy_INHERIT AuthenticationPolicy = 1000
)

var AuthenticationPolicy_name = map[int32]string{
	0:    "NONE",
	1:    "MUTUAL_TLS",
	1000: "INHERIT",
}

var AuthenticationPolicy_value = map[string]int32{
	"NONE":       0,
	"MUTUAL_TLS": 1,
	"INHERIT":    1000,
}

func (x AuthenticationPolicy) String() string {
	return proto.EnumName(AuthenticationPolicy_name, int32(x))
}

func (AuthenticationPolicy) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_5efecd978cf3d28d, []int{0}
}

// TraceContext selects the context propagation headers used for
// distributed tracing.
type Tracing_OpenCensusAgent_TraceContext int32

const (
	// $hide_from_docs
	// Unspecified context. Should not be used for now, but added to reserve
	// the 0 enum value if TraceContext is used outside of a repeated field.
	Tracing_OpenCensusAgent_UNSPECIFIED Tracing_OpenCensusAgent_TraceContext = 0
	// Use W3C Trace Context propagation using the `traceparent` HTTP header.
	// See the
	// [Trace Context documentation](https://www.w3.org/TR/trace-context/) for details.
	Tracing_OpenCensusAgent_W3C_TRACE_CONTEXT Tracing_OpenCensusAgent_TraceContext = 1
	// Use gRPC binary context propagation using the `grpc-trace-bin` http header.
	Tracing_OpenCensusAgent_GRPC_BIN Tracing_OpenCensusAgent_TraceContext = 2
	// Use Cloud Trace context propagation using the
	// `X-Cloud-Trace-Context` http header.
	Tracing_OpenCensusAgent_CLOUD_TRACE_CONTEXT Tracing_OpenCensusAgent_TraceContext = 3
	// Use multi-header B3 context propagation using the `X-B3-TraceId`,
	// `X-B3-SpanId`, and `X-B3-Sampled` HTTP headers. See
	// [B3 header propagation README](https://github.com/openzipkin/b3-propagation)
	// for details.
	Tracing_OpenCensusAgent_B3 Tracing_OpenCensusAgent_TraceContext = 4
)

var Tracing_OpenCensusAgent_TraceContext_name = map[int32]string{
	0: "UNSPECIFIED",
	1: "W3C_TRACE_CONTEXT",
	2: "GRPC_BIN",
	3: "CLOUD_TRACE_CONTEXT",
	4: "B3",
}

var Tracing_OpenCensusAgent_TraceContext_value = map[string]int32{
	"UNSPECIFIED":         0,
	"W3C_TRACE_CONTEXT":   1,
	"GRPC_BIN":            2,
	"CLOUD_TRACE_CONTEXT": 3,
	"B3":                  4,
}

func (x Tracing_OpenCensusAgent_TraceContext) String() string {
	return proto.EnumName(Tracing_OpenCensusAgent_TraceContext_name, int32(x))
}

func (Tracing_OpenCensusAgent_TraceContext) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_5efecd978cf3d28d, []int{0, 4, 0}
}

// $hide_from_docs
// ForwardClientCertDetails controls how the x-forwarded-client-cert (XFCC)
// header is handled by the gateway proxy.
// See [Envoy XFCC](https://www.envoyproxy.io/docs/envoy/latest/api-v2/config/filter/network/http_connection_manager/v2/http_connection_manager.proto#envoy-api-enum-config-filter-network-http-connection-manager-v2-httpconnectionmanager-forwardclientcertdetails)
// header handling for more details.
type Topology_ForwardClientCertDetails int32

const (
	// Field is not set
	Topology_UNDEFINED Topology_ForwardClientCertDetails = 0
	// Do not send the XFCC header to the next hop. This is the default value.
	Topology_SANITIZE Topology_ForwardClientCertDetails = 1
	// When the client connection is mTLS (Mutual TLS), forward the XFCC header
	// in the request.
	Topology_FORWARD_ONLY Topology_ForwardClientCertDetails = 2
	// When the client connection is mTLS, append the client certificate
	// information to the request’s XFCC header and forward it.
	Topology_APPEND_FORWARD Topology_ForwardClientCertDetails = 3
	// When the client connection is mTLS, reset the XFCC header with the client
	// certificate information and send it to the next hop.
	Topology_SANITIZE_SET Topology_ForwardClientCertDetails = 4
	// Always forward the XFCC header in the request, regardless of whether the
	// client connection is mTLS.
	Topology_ALWAYS_FORWARD_ONLY Topology_ForwardClientCertDetails = 5
)

var Topology_ForwardClientCertDetails_name = map[int32]string{
	0: "UNDEFINED",
	1: "SANITIZE",
	2: "FORWARD_ONLY",
	3: "APPEND_FORWARD",
	4: "SANITIZE_SET",
	5: "ALWAYS_FORWARD_ONLY",
}

var Topology_ForwardClientCertDetails_value = map[string]int32{
	"UNDEFINED":           0,
	"SANITIZE":            1,
	"FORWARD_ONLY":        2,
	"APPEND_FORWARD":      3,
	"SANITIZE_SET":        4,
	"ALWAYS_FORWARD_ONLY": 5,
}

func (x Topology_ForwardClientCertDetails) String() string {
	return proto.EnumName(Topology_ForwardClientCertDetails_name, int32(x))
}

func (Topology_ForwardClientCertDetails) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_5efecd978cf3d28d, []int{2, 0}
}

// The mode used to redirect inbound traffic to Envoy.
// This setting has no effect on outbound traffic: iptables `REDIRECT` is always used for
// outbound connections.
type ProxyConfig_InboundInterceptionMode int32

const (
	// The `REDIRECT` mode uses iptables `REDIRECT` to `NAT` and redirect to Envoy. This mode loses
	// source IP addresses during redirection.
	ProxyConfig_REDIRECT ProxyConfig_InboundInterceptionMode = 0
	// The `TPROXY` mode uses iptables `TPROXY` to redirect to Envoy. This mode preserves both the
	// source and destination IP addresses and ports, so that they can be used for advanced
	// filtering and manipulation. This mode also configures the sidecar to run with the
	// `CAP_NET_ADMIN` capability, which is required to use `TPROXY`.
	ProxyConfig_TPROXY ProxyConfig_InboundInterceptionMode = 1
)

var ProxyConfig_InboundInterceptionMode_name = map[int32]string{
	0: "REDIRECT",
	1: "TPROXY",
}

var ProxyConfig_InboundInterceptionMode_value = map[string]int32{
	"REDIRECT": 0,
	"TPROXY":   1,
}

func (x ProxyConfig_InboundInterceptionMode) String() string {
	return proto.EnumName(ProxyConfig_InboundInterceptionMode_name, int32(x))
}

func (ProxyConfig_InboundInterceptionMode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_5efecd978cf3d28d, []int{3, 0}
}

// Tracing defines configuration for the tracing performed by Envoy instances.
type Tracing struct {
	// The tracer implementation to be used by Envoy.
	//
	// Types that are valid to be assigned to Tracer:
	//	*Tracing_Zipkin_
	//	*Tracing_Lightstep_
	//	*Tracing_Datadog_
	//	*Tracing_Stackdriver_
	//	*Tracing_OpenCensusAgent_
	Tracer isTracing_Tracer `protobuf_oneof:"tracer"`
	// Configures the custom tags to be added to active span by all proxies (i.e. sidecars
	// and gateways).
	// The key represents the name of the tag.
	// Ex:
	// ```yaml
	// custom_tags:
	//   new_tag_name:
	//     header:
	//       name: custom-http-header-name
	//       default_value: defaulted-value-from-custom-header
	// ```
	// $hide_from_docs
	CustomTags map[string]*Tracing_CustomTag `protobuf:"bytes,5,rep,name=custom_tags,json=customTags,proto3" json:"customTags,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Configures the maximum length of the request path to extract and include in the
	// HttpUrl tag. Used to truncate length request paths to meet the needs of tracing
	// backend. If not set, then a length of 256 will be used.
	// $hide_from_docs
	MaxPathTagLength uint32 `protobuf:"varint,6,opt,name=max_path_tag_length,json=maxPathTagLength,proto3" json:"maxPathTagLength,omitempty"`
	// The percentage of requests (0.0 - 100.0) that will be randomly selected for trace generation,
	// if not requested by the client or not forced. Default is 1.0.
	Sampling float64 `protobuf:"fixed64,7,opt,name=sampling,proto3" json:"sampling,omitempty"`
	// Use the tls_settings to specify the tls mode to use. If the remote tracing service
	// uses Istio mutual TLS and shares the root CA with Pilot, specify the TLS
	// mode as `ISTIO_MUTUAL`.
	TlsSettings          *v1alpha3.ClientTLSSettings `protobuf:"bytes,8,opt,name=tls_settings,json=tlsSettings,proto3" json:"tlsSettings,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                    `json:"-"`
	XXX_unrecognized     []byte                      `json:"-"`
	XXX_sizecache        int32                       `json:"-"`
}

func (m *Tracing) Reset()         { *m = Tracing{} }
func (m *Tracing) String() string { return proto.CompactTextString(m) }
func (*Tracing) ProtoMessage()    {}
func (*Tracing) Descriptor() ([]byte, []int) {
	return fileDescriptor_5efecd978cf3d28d, []int{0}
}
func (m *Tracing) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Tracing) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Tracing.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Tracing) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Tracing.Merge(m, src)
}
func (m *Tracing) XXX_Size() int {
	return m.Size()
}
func (m *Tracing) XXX_DiscardUnknown() {
	xxx_messageInfo_Tracing.DiscardUnknown(m)
}

var xxx_messageInfo_Tracing proto.InternalMessageInfo

type isTracing_Tracer interface {
	isTracing_Tracer()
	MarshalTo([]byte) (int, error)
	Size() int
}

type Tracing_Zipkin_ struct {
	Zipkin *Tracing_Zipkin `protobuf:"bytes,1,opt,name=zipkin,proto3,oneof" json:"zipkin,omitempty"`
}
type Tracing_Lightstep_ struct {
	Lightstep *Tracing_Lightstep `protobuf:"bytes,2,opt,name=lightstep,proto3,oneof" json:"lightstep,omitempty"`
}
type Tracing_Datadog_ struct {
	Datadog *Tracing_Datadog `protobuf:"bytes,3,opt,name=datadog,proto3,oneof" json:"datadog,omitempty"`
}
type Tracing_Stackdriver_ struct {
	Stackdriver *Tracing_Stackdriver `protobuf:"bytes,4,opt,name=stackdriver,proto3,oneof" json:"stackdriver,omitempty"`
}
type Tracing_OpenCensusAgent_ struct {
	OpenCensusAgent *Tracing_OpenCensusAgent `protobuf:"bytes,9,opt,name=open_census_agent,json=openCensusAgent,proto3,oneof" json:"openCensusAgent,omitempty"`
}

func (*Tracing_Zipkin_) isTracing_Tracer()          {}
func (*Tracing_Lightstep_) isTracing_Tracer()       {}
func (*Tracing_Datadog_) isTracing_Tracer()         {}
func (*Tracing_Stackdriver_) isTracing_Tracer()     {}
func (*Tracing_OpenCensusAgent_) isTracing_Tracer() {}

func (m *Tracing) GetTracer() isTracing_Tracer {
	if m != nil {
		return m.Tracer
	}
	return nil
}

func (m *Tracing) GetZipkin() *Tracing_Zipkin {
	if x, ok := m.GetTracer().(*Tracing_Zipkin_); ok {
		return x.Zipkin
	}
	return nil
}

func (m *Tracing) GetLightstep() *Tracing_Lightstep {
	if x, ok := m.GetTracer().(*Tracing_Lightstep_); ok {
		return x.Lightstep
	}
	return nil
}

func (m *Tracing) GetDatadog() *Tracing_Datadog {
	if x, ok := m.GetTracer().(*Tracing_Datadog_); ok {
		return x.Datadog
	}
	return nil
}

func (m *Tracing) GetStackdriver() *Tracing_Stackdriver {
	if x, ok := m.GetTracer().(*Tracing_Stackdriver_); ok {
		return x.Stackdriver
	}
	return nil
}

func (m *Tracing) GetOpenCensusAgent() *Tracing_OpenCensusAgent {
	if x, ok := m.GetTracer().(*Tracing_OpenCensusAgent_); ok {
		return x.OpenCensusAgent
	}
	return nil
}

func (m *Tracing) GetCustomTags() map[string]*Tracing_CustomTag {
	if m != nil {
		return m.CustomTags
	}
	return nil
}

func (m *Tracing) GetMaxPathTagLength() uint32 {
	if m != nil {
		return m.MaxPathTagLength
	}
	return 0
}

func (m *Tracing) GetSampling() float64 {
	if m != nil {
		return m.Sampling
	}
	return 0
}

func (m *Tracing) GetTlsSettings() *v1alpha3.ClientTLSSettings {
	if m != nil {
		return m.TlsSettings
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Tracing) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Tracing_Zipkin_)(nil),
		(*Tracing_Lightstep_)(nil),
		(*Tracing_Datadog_)(nil),
		(*Tracing_Stackdriver_)(nil),
		(*Tracing_OpenCensusAgent_)(nil),
	}
}

// Zipkin defines configuration for a Zipkin tracer.
type Tracing_Zipkin struct {
	// Address of the Zipkin service (e.g. _zipkin:9411_).
	Address              string   `protobuf:"bytes,1,opt,name=address,proto3" json:"address,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Tracing_Zipkin) Reset()         { *m = Tracing_Zipkin{} }
func (m *Tracing_Zipkin) String() string { return proto.CompactTextString(m) }
func (*Tracing_Zipkin) ProtoMessage()    {}
func (*Tracing_Zipkin) Descriptor() ([]byte, []int) {
	return fileDescriptor_5efecd978cf3d28d, []int{0, 0}
}
func (m *Tracing_Zipkin) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Tracing_Zipkin) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Tracing_Zipkin.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Tracing_Zipkin) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Tracing_Zipkin.Merge(m, src)
}
func (m *Tracing_Zipkin) XXX_Size() int {
	return m.Size()
}
func (m *Tracing_Zipkin) XXX_DiscardUnknown() {
	xxx_messageInfo_Tracing_Zipkin.DiscardUnknown(m)
}

var xxx_messageInfo_Tracing_Zipkin proto.InternalMessageInfo

func (m *Tracing_Zipkin) GetAddress() string {
	if m != nil {
		return m.Address
	}
	return ""
}

// Defines configuration for a Lightstep tracer.
type Tracing_Lightstep struct {
	// Address of the Lightstep Satellite pool.
	Address string `protobuf:"bytes,1,opt,name=address,proto3" json:"address,omitempty"`
	// The Lightstep access token.
	AccessToken          string   `protobuf:"bytes,2,opt,name=access_token,json=accessToken,proto3" json:"accessToken,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Tracing_Lightstep) Reset()         { *m = Tracing_Lightstep{} }
func (m *Tracing_Lightstep) String() string { return proto.CompactTextString(m) }
func (*Tracing_Lightstep) ProtoMessage()    {}
func (*Tracing_Lightstep) Descriptor() ([]byte, []int) {
	return fileDescriptor_5efecd978cf3d28d, []int{0, 1}
}
func (m *Tracing_Lightstep) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Tracing_Lightstep) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Tracing_Lightstep.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Tracing_Lightstep) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Tracing_Lightstep.Merge(m, src)
}
func (m *Tracing_Lightstep) XXX_Size() int {
	return m.Size()
}
func (m *Tracing_Lightstep) XXX_DiscardUnknown() {
	xxx_messageInfo_Tracing_Lightstep.DiscardUnknown(m)
}

var xxx_messageInfo_Tracing_Lightstep proto.InternalMessageInfo

func (m *Tracing_Lightstep) GetAddress() string {
	if m != nil {
		return m.Address
	}
	return ""
}

func (m *Tracing_Lightstep) GetAccessToken() string {
	if m != nil {
		return m.AccessToken
	}
	return ""
}

// Datadog defines configuration for a Datadog tracer.
type Tracing_Datadog struct {
	// Address of the Datadog Agent.
	Address              string   `protobuf:"bytes,1,opt,name=address,proto3" json:"address,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Tracing_Datadog) Reset()         { *m = Tracing_Datadog{} }
func (m *Tracing_Datadog) String() string { return proto.CompactTextString(m) }
func (*Tracing_Datadog) ProtoMessage()    {}
func (*Tracing_Datadog) Descriptor() ([]byte, []int) {
	return fileDescriptor_5efecd978cf3d28d, []int{0, 2}
}
func (m *Tracing_Datadog) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Tracing_Datadog) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Tracing_Datadog.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Tracing_Datadog) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Tracing_Datadog.Merge(m, src)
}
func (m *Tracing_Datadog) XXX_Size() int {
	return m.Size()
}
func (m *Tracing_Datadog) XXX_DiscardUnknown() {
	xxx_messageInfo_Tracing_Datadog.DiscardUnknown(m)
}

var xxx_messageInfo_Tracing_Datadog proto.InternalMessageInfo

func (m *Tracing_Datadog) GetAddress() string {
	if m != nil {
		return m.Address
	}
	return ""
}

// Stackdriver defines configuration for a Stackdriver tracer.
// See [Envoy's OpenCensus trace configuration](https://www.envoyproxy.io/docs/envoy/latest/api-v3/config/trace/v3/opencensus.proto)
// and
// [OpenCensus trace config](https://github.com/census-instrumentation/opencensus-proto/blob/master/src/opencensus/proto/trace/v1/trace_config.proto) for details.
type Tracing_Stackdriver struct {
	// debug enables trace output to stdout.
	// $hide_from_docs
	Debug bool `protobuf:"varint,1,opt,name=debug,proto3" json:"debug,omitempty"`
	// The global default max number of attributes per span.
	// default is 200.
	// $hide_from_docs
	MaxNumberOfAttributes *types.Int64Value `protobuf:"bytes,2,opt,name=max_number_of_attributes,json=maxNumberOfAttributes,proto3" json:"maxNumberOfAttributes,omitempty"`
	// The global default max number of annotation events per span.
	// default is 200.
	// $hide_from_docs
	MaxNumberOfAnnotations *types.Int64Value `protobuf:"bytes,3,opt,name=max_number_of_annotations,json=maxNumberOfAnnotations,proto3" json:"maxNumberOfAnnotations,omitempty"`
	// The global default max number of message events per span.
	// default is 200.
	// $hide_from_docs
	MaxNumberOfMessageEvents *types.Int64Value `protobuf:"bytes,4,opt,name=max_number_of_message_events,json=maxNumberOfMessageEvents,proto3" json:"maxNumberOfMessageEvents,omitempty"`
	XXX_NoUnkeyedLiteral     struct{}          `json:"-"`
	XXX_unrecognized         []byte            `json:"-"`
	XXX_sizecache            int32             `json:"-"`
}

func (m *Tracing_Stackdriver) Reset()         { *m = Tracing_Stackdriver{} }
func (m *Tracing_Stackdriver) String() string { return proto.CompactTextString(m) }
func (*Tracing_Stackdriver) ProtoMessage()    {}
func (*Tracing_Stackdriver) Descriptor() ([]byte, []int) {
	return fileDescriptor_5efecd978cf3d28d, []int{0, 3}
}
func (m *Tracing_Stackdriver) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Tracing_Stackdriver) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Tracing_Stackdriver.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Tracing_Stackdriver) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Tracing_Stackdriver.Merge(m, src)
}
func (m *Tracing_Stackdriver) XXX_Size() int {
	return m.Size()
}
func (m *Tracing_Stackdriver) XXX_DiscardUnknown() {
	xxx_messageInfo_Tracing_Stackdriver.DiscardUnknown(m)
}

var xxx_messageInfo_Tracing_Stackdriver proto.InternalMessageInfo

func (m *Tracing_Stackdriver) GetDebug() bool {
	if m != nil {
		return m.Debug
	}
	return false
}

func (m *Tracing_Stackdriver) GetMaxNumberOfAttributes() *types.Int64Value {
	if m != nil {
		return m.MaxNumberOfAttributes
	}
	return nil
}

func (m *Tracing_Stackdriver) GetMaxNumberOfAnnotations() *types.Int64Value {
	if m != nil {
		return m.MaxNumberOfAnnotations
	}
	return nil
}

func (m *Tracing_Stackdriver) GetMaxNumberOfMessageEvents() *types.Int64Value {
	if m != nil {
		return m.MaxNumberOfMessageEvents
	}
	return nil
}

// OpenCensusAgent defines configuration for an OpenCensus tracer writing to
// an OpenCensus agent backend. See
// [Envoy's OpenCensus trace configuration](https://www.envoyproxy.io/docs/envoy/latest/api-v3/config/trace/v3/opencensus.proto)
// and
// [OpenCensus trace config](https://github.com/census-instrumentation/opencensus-proto/blob/master/src/opencensus/proto/trace/v1/trace_config.proto)
// for details.
type Tracing_OpenCensusAgent struct {
	// gRPC address for the OpenCensus agent (e.g. dns://authority/host:port or
	// unix:path). See [gRPC naming
	// docs](https://github.com/grpc/grpc/blob/master/doc/naming.md) for
	// details.
	Address string `protobuf:"bytes,1,opt,name=address,proto3" json:"address,omitempty"`
	// Specifies the set of context propagation headers used for distributed
	// tracing. Default is `["W3C_TRACE_CONTEXT"]`. If multiple values are specified,
	// the proxy will attempt to read each header for each request and will
	// write all headers.
	Context              []Tracing_OpenCensusAgent_TraceContext `protobuf:"varint,2,rep,packed,name=context,proto3,enum=istio.mesh.v1alpha1.Tracing_OpenCensusAgent_TraceContext" json:"context,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                               `json:"-"`
	XXX_unrecognized     []byte                                 `json:"-"`
	XXX_sizecache        int32                                  `json:"-"`
}

func (m *Tracing_OpenCensusAgent) Reset()         { *m = Tracing_OpenCensusAgent{} }
func (m *Tracing_OpenCensusAgent) String() string { return proto.CompactTextString(m) }
func (*Tracing_OpenCensusAgent) ProtoMessage()    {}
func (*Tracing_OpenCensusAgent) Descriptor() ([]byte, []int) {
	return fileDescriptor_5efecd978cf3d28d, []int{0, 4}
}
func (m *Tracing_OpenCensusAgent) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Tracing_OpenCensusAgent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Tracing_OpenCensusAgent.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Tracing_OpenCensusAgent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Tracing_OpenCensusAgent.Merge(m, src)
}
func (m *Tracing_OpenCensusAgent) XXX_Size() int {
	return m.Size()
}
func (m *Tracing_OpenCensusAgent) XXX_DiscardUnknown() {
	xxx_messageInfo_Tracing_OpenCensusAgent.DiscardUnknown(m)
}

var xxx_messageInfo_Tracing_OpenCensusAgent proto.InternalMessageInfo

func (m *Tracing_OpenCensusAgent) GetAddress() string {
	if m != nil {
		return m.Address
	}
	return ""
}

func (m *Tracing_OpenCensusAgent) GetContext() []Tracing_OpenCensusAgent_TraceContext {
	if m != nil {
		return m.Context
	}
	return nil
}

// Configure custom tags that will be added to any active span.
// Tags can be generated via literals, environment variables or an incoming request header.
// $hide_from_docs
type Tracing_CustomTag struct {
	// Specify how to populate the value in a custom tag
	//
	// Types that are valid to be assigned to Type:
	//	*Tracing_CustomTag_Literal
	//	*Tracing_CustomTag_Environment
	//	*Tracing_CustomTag_Header
	Type                 isTracing_CustomTag_Type `protobuf_oneof:"type"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *Tracing_CustomTag) Reset()         { *m = Tracing_CustomTag{} }
func (m *Tracing_CustomTag) String() string { return proto.CompactTextString(m) }
func (*Tracing_CustomTag) ProtoMessage()    {}
func (*Tracing_CustomTag) Descriptor() ([]byte, []int) {
	return fileDescriptor_5efecd978cf3d28d, []int{0, 5}
}
func (m *Tracing_CustomTag) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Tracing_CustomTag) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Tracing_CustomTag.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Tracing_CustomTag) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Tracing_CustomTag.Merge(m, src)
}
func (m *Tracing_CustomTag) XXX_Size() int {
	return m.Size()
}
func (m *Tracing_CustomTag) XXX_DiscardUnknown() {
	xxx_messageInfo_Tracing_CustomTag.DiscardUnknown(m)
}

var xxx_messageInfo_Tracing_CustomTag proto.InternalMessageInfo

type isTracing_CustomTag_Type interface {
	isTracing_CustomTag_Type()
	MarshalTo([]byte) (int, error)
	Size() int
}

type Tracing_CustomTag_Literal struct {
	Literal *Tracing_Literal `protobuf:"bytes,1,opt,name=literal,proto3,oneof" json:"literal,omitempty"`
}
type Tracing_CustomTag_Environment struct {
	Environment *Tracing_Environment `protobuf:"bytes,2,opt,name=environment,proto3,oneof" json:"environment,omitempty"`
}
type Tracing_CustomTag_Header struct {
	Header *Tracing_RequestHeader `protobuf:"bytes,3,opt,name=header,proto3,oneof" json:"header,omitempty"`
}

func (*Tracing_CustomTag_Literal) isTracing_CustomTag_Type()     {}
func (*Tracing_CustomTag_Environment) isTracing_CustomTag_Type() {}
func (*Tracing_CustomTag_Header) isTracing_CustomTag_Type()      {}

func (m *Tracing_CustomTag) GetType() isTracing_CustomTag_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (m *Tracing_CustomTag) GetLiteral() *Tracing_Literal {
	if x, ok := m.GetType().(*Tracing_CustomTag_Literal); ok {
		return x.Literal
	}
	return nil
}

func (m *Tracing_CustomTag) GetEnvironment() *Tracing_Environment {
	if x, ok := m.GetType().(*Tracing_CustomTag_Environment); ok {
		return x.Environment
	}
	return nil
}

func (m *Tracing_CustomTag) GetHeader() *Tracing_RequestHeader {
	if x, ok := m.GetType().(*Tracing_CustomTag_Header); ok {
		return x.Header
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Tracing_CustomTag) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Tracing_CustomTag_Literal)(nil),
		(*Tracing_CustomTag_Environment)(nil),
		(*Tracing_CustomTag_Header)(nil),
	}
}

// Literal type represents a static value.
// $hide_from_docs
type Tracing_Literal struct {
	// Static literal value used to populate the tag value.
	Value                string   `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Tracing_Literal) Reset()         { *m = Tracing_Literal{} }
func (m *Tracing_Literal) String() string { return proto.CompactTextString(m) }
func (*Tracing_Literal) ProtoMessage()    {}
func (*Tracing_Literal) Descriptor() ([]byte, []int) {
	return fileDescriptor_5efecd978cf3d28d, []int{0, 6}
}
func (m *Tracing_Literal) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Tracing_Literal) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Tracing_Literal.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Tracing_Literal) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Tracing_Literal.Merge(m, src)
}
func (m *Tracing_Literal) XXX_Size() int {
	return m.Size()
}
func (m *Tracing_Literal) XXX_DiscardUnknown() {
	xxx_messageInfo_Tracing_Literal.DiscardUnknown(m)
}

var xxx_messageInfo_Tracing_Literal proto.InternalMessageInfo

func (m *Tracing_Literal) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

// Environment is the proxy's environment variable to be used for populating the custom span tag.
// $hide_from_docs
type Tracing_Environment struct {
	// Name of the environment variable used to populate the tag's value
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// When the environment variable is not found,
	// the tag's value will be populated with this default value if specified,
	// otherwise the tag will not be populated.
	DefaultValue         string   `protobuf:"bytes,2,opt,name=default_value,json=defaultValue,proto3" json:"defaultValue,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Tracing_Environment) Reset()         { *m = Tracing_Environment{} }
func (m *Tracing_Environment) String() string { return proto.CompactTextString(m) }
func (*Tracing_Environment) ProtoMessage()    {}
func (*Tracing_Environment) Descriptor() ([]byte, []int) {
	return fileDescriptor_5efecd978cf3d28d, []int{0, 7}
}
func (m *Tracing_Environment) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Tracing_Environment) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Tracing_Environment.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Tracing_Environment) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Tracing_Environment.Merge(m, src)
}
func (m *Tracing_Environment) XXX_Size() int {
	return m.Size()
}
func (m *Tracing_Environment) XXX_DiscardUnknown() {
	xxx_messageInfo_Tracing_Environment.DiscardUnknown(m)
}

var xxx_messageInfo_Tracing_Environment proto.InternalMessageInfo

func (m *Tracing_Environment) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Tracing_Environment) GetDefaultValue() string {
	if m != nil {
		return m.DefaultValue
	}
	return ""
}

// RequestHeader is the HTTP request header which will be used to populate the span tag.
// A default value can be configured if the header does not exist.
// $hide_from_docs
type Tracing_RequestHeader struct {
	// HTTP header name used to obtain the value from to populate the tag value.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Default value to be used for the tag when the named HTTP header does not exist.
	// The tag will be skipped if no default value is provided.
	DefaultValue         string   `protobuf:"bytes,2,opt,name=default_value,json=defaultValue,proto3" json:"defaultValue,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Tracing_RequestHeader) Reset()         { *m = Tracing_RequestHeader{} }
func (m *Tracing_RequestHeader) String() string { return proto.CompactTextString(m) }
func (*Tracing_RequestHeader) ProtoMessage()    {}
func (*Tracing_RequestHeader) Descriptor() ([]byte, []int) {
	return fileDescriptor_5efecd978cf3d28d, []int{0, 8}
}
func (m *Tracing_RequestHeader) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Tracing_RequestHeader) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Tracing_RequestHeader.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Tracing_RequestHeader) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Tracing_RequestHeader.Merge(m, src)
}
func (m *Tracing_RequestHeader) XXX_Size() int {
	return m.Size()
}
func (m *Tracing_RequestHeader) XXX_DiscardUnknown() {
	xxx_messageInfo_Tracing_RequestHeader.DiscardUnknown(m)
}

var xxx_messageInfo_Tracing_RequestHeader proto.InternalMessageInfo

func (m *Tracing_RequestHeader) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Tracing_RequestHeader) GetDefaultValue() string {
	if m != nil {
		return m.DefaultValue
	}
	return ""
}

// SDS defines secret discovery service(SDS) configuration to be used by the proxy.
// For workload, its values are set in sidecar injector(passed as arguments to istio-proxy container).
// For pilot/mixer, it's passed as arguments to istio-proxy container in pilot/mixer deployment yaml files directly.
type SDS struct {
	// True if SDS is enabled.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// Path of k8s service account JWT path.
	K8SSaJwtPath         string   `protobuf:"bytes,2,opt,name=k8s_sa_jwt_path,json=k8sSaJwtPath,proto3" json:"k8sSaJwtPath,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SDS) Reset()         { *m = SDS{} }
func (m *SDS) String() string { return proto.CompactTextString(m) }
func (*SDS) ProtoMessage()    {}
func (*SDS) Descriptor() ([]byte, []int) {
	return fileDescriptor_5efecd978cf3d28d, []int{1}
}
func (m *SDS) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SDS) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SDS.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SDS) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SDS.Merge(m, src)
}
func (m *SDS) XXX_Size() int {
	return m.Size()
}
func (m *SDS) XXX_DiscardUnknown() {
	xxx_messageInfo_SDS.DiscardUnknown(m)
}

var xxx_messageInfo_SDS proto.InternalMessageInfo

func (m *SDS) GetEnabled() bool {
	if m != nil {
		return m.Enabled
	}
	return false
}

func (m *SDS) GetK8SSaJwtPath() string {
	if m != nil {
		return m.K8SSaJwtPath
	}
	return ""
}

// $hide_from_docs
// Topology describes the configuration for relative location of a proxy with
// respect to intermediate trusted proxies and the client. These settings
// control how the client attributes are retrieved from the incoming traffic by
// the gateway proxy and propagated to the upstream services in the cluster.
type Topology struct {
	// $hide_from_docs
	// Number of trusted proxies deployed in front of the Istio gateway proxy.
	// When this option is set to value N greater than zero, the trusted client
	// address is assumed to be the Nth address from the right end of the
	// X-Forwarded-For (XFF) header from the incoming request. If the
	// X-Forwarded-For (XFF) header is missing or has fewer than N addresses, the
	// gateway proxy falls back to using the immediate downstream connection's
	// source address as the trusted client address.
	// Note that the gateway proxy will append the downstream connection's source
	// address to the X-Forwarded-For (XFF) address and set the
	// X-Envoy-External-Address header to the trusted client address before
	// forwarding it to the upstream services in the cluster.
	// The default value of num_trusted_proxies is 0.
	// See [Envoy XFF] (https://www.envoyproxy.io/docs/envoy/latest/configuration/http/http_conn_man/headers#config-http-conn-man-headers-x-forwarded-for)
	// header handling for more details.
	NumTrustedProxies uint32 `protobuf:"varint,1,opt,name=num_trusted_proxies,json=numTrustedProxies,proto3" json:"numTrustedProxies,omitempty"`
	// $hide_from_docs
	// Configures how the gateway proxy handles x-forwarded-client-cert (XFCC)
	// header in the incoming request.
	ForwardClientCertDetails Topology_ForwardClientCertDetails `protobuf:"varint,2,opt,name=forward_client_cert_details,json=forwardClientCertDetails,proto3,enum=istio.mesh.v1alpha1.Topology_ForwardClientCertDetails" json:"forwardClientCertDetails,omitempty"`
	XXX_NoUnkeyedLiteral     struct{}                          `json:"-"`
	XXX_unrecognized         []byte                            `json:"-"`
	XXX_sizecache            int32                             `json:"-"`
}

func (m *Topology) Reset()         { *m = Topology{} }
func (m *Topology) String() string { return proto.CompactTextString(m) }
func (*Topology) ProtoMessage()    {}
func (*Topology) Descriptor() ([]byte, []int) {
	return fileDescriptor_5efecd978cf3d28d, []int{2}
}
func (m *Topology) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Topology) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Topology.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Topology) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Topology.Merge(m, src)
}
func (m *Topology) XXX_Size() int {
	return m.Size()
}
func (m *Topology) XXX_DiscardUnknown() {
	xxx_messageInfo_Topology.DiscardUnknown(m)
}

var xxx_messageInfo_Topology proto.InternalMessageInfo

func (m *Topology) GetNumTrustedProxies() uint32 {
	if m != nil {
		return m.NumTrustedProxies
	}
	return 0
}

func (m *Topology) GetForwardClientCertDetails() Topology_ForwardClientCertDetails {
	if m != nil {
		return m.ForwardClientCertDetails
	}
	return Topology_UNDEFINED
}

// ProxyConfig defines variables for individual Envoy instances.
type ProxyConfig struct {
	// Path to the generated configuration file directory.
	// Proxy agent generates the actual configuration and stores it in this directory.
	ConfigPath string `protobuf:"bytes,1,opt,name=config_path,json=configPath,proto3" json:"configPath,omitempty"`
	// Path to the proxy binary
	BinaryPath string `protobuf:"bytes,2,opt,name=binary_path,json=binaryPath,proto3" json:"binaryPath,omitempty"`
	// Service cluster defines the name for the `service_cluster` that is
	// shared by all Envoy instances. This setting corresponds to
	// `--service-cluster` flag in Envoy.  In a typical Envoy deployment, the
	// `service-cluster` flag is used to identify the caller, for
	// source-based routing scenarios.
	//
	// Since Istio does not assign a local `service/service` version to each
	// Envoy instance, the name is same for all of them.  However, the
	// source/caller's identity (e.g., IP address) is encoded in the
	// `--service-node` flag when launching Envoy.  When the RDS service
	// receives API calls from Envoy, it uses the value of the `service-node`
	// flag to compute routes that are relative to the service instances
	// located at that IP address.
	ServiceCluster string `protobuf:"bytes,3,opt,name=service_cluster,json=serviceCluster,proto3" json:"serviceCluster,omitempty"`
	// The time in seconds that Envoy will drain connections during a hot
	// restart. MUST be >=1s (e.g., _1s/1m/1h_)
	// Default drain duration is `45s`.
	DrainDuration *types.Duration `protobuf:"bytes,4,opt,name=drain_duration,json=drainDuration,proto3" json:"drainDuration,omitempty"`
	// The time in seconds that Envoy will wait before shutting down the
	// parent process during a hot restart. MUST be >=1s (e.g., `1s/1m/1h`).
	// MUST BE greater than `drain_duration` parameter.
	// Default shutdown duration is `60s`.
	ParentShutdownDuration *types.Duration `protobuf:"bytes,5,opt,name=parent_shutdown_duration,json=parentShutdownDuration,proto3" json:"parentShutdownDuration,omitempty"`
	// Address of the discovery service exposing xDS with mTLS connection.
	// The inject configuration may override this value.
	DiscoveryAddress string `protobuf:"bytes,6,opt,name=discovery_address,json=discoveryAddress,proto3" json:"discoveryAddress,omitempty"`
	// $hide_from_docs
	DiscoveryRefreshDelay *types.Duration `protobuf:"bytes,7,opt,name=discovery_refresh_delay,json=discoveryRefreshDelay,proto3" json:"discoveryRefreshDelay,omitempty"` // Deprecated: Do not use.
	// Address of the Zipkin service (e.g. _zipkin:9411_).
	// DEPRECATED: Use [tracing][istio.mesh.v1alpha1.ProxyConfig.tracing] instead.
	ZipkinAddress string `protobuf:"bytes,8,opt,name=zipkin_address,json=zipkinAddress,proto3" json:"zipkinAddress,omitempty"` // Deprecated: Do not use.
	// IP Address and Port of a statsd UDP listener (e.g. `10.75.241.127:9125`).
	StatsdUdpAddress string `protobuf:"bytes,10,opt,name=statsd_udp_address,json=statsdUdpAddress,proto3" json:"statsdUdpAddress,omitempty"`
	// $hide_from_docs
	EnvoyMetricsServiceAddress string `protobuf:"bytes,20,opt,name=envoy_metrics_service_address,json=envoyMetricsServiceAddress,proto3" json:"envoyMetricsServiceAddress,omitempty"` // Deprecated: Do not use.
	// Port on which Envoy should listen for administrative commands.
	// Default port is `15000`.
	ProxyAdminPort int32 `protobuf:"varint,11,opt,name=proxy_admin_port,json=proxyAdminPort,proto3" json:"proxyAdminPort,omitempty"`
	// $hide_from_docs
	AvailabilityZone string `protobuf:"bytes,12,opt,name=availability_zone,json=availabilityZone,proto3" json:"availabilityZone,omitempty"` // Deprecated: Do not use.
	// AuthenticationPolicy defines how the proxy is authenticated when it connects to the control plane.
	// Default is set to `MUTUAL_TLS`.
	ControlPlaneAuthPolicy AuthenticationPolicy `protobuf:"varint,13,opt,name=control_plane_auth_policy,json=controlPlaneAuthPolicy,proto3,enum=istio.mesh.v1alpha1.AuthenticationPolicy" json:"controlPlaneAuthPolicy,omitempty"`
	// File path of custom proxy configuration, currently used by proxies
	// in front of Mixer and Pilot.
	CustomConfigFile string `protobuf:"bytes,14,opt,name=custom_config_file,json=customConfigFile,proto3" json:"customConfigFile,omitempty"`
	// Maximum length of name field in Envoy's metrics. The length of the name field
	// is determined by the length of a name field in a service and the set of labels that
	// comprise a particular version of the service. The default value is set to 189 characters.
	// Envoy's internal metrics take up 67 characters, for a total of 256 character name per metric.
	// Increase the value of this field if you find that the metrics from Envoys are truncated.
	StatNameLength int32 `protobuf:"varint,15,opt,name=stat_name_length,json=statNameLength,proto3" json:"statNameLength,omitempty"`
	// The number of worker threads to run.
	// If unset, this will be automatically determined based on CPU requests/limits.
	// If set to 0, all cores on the machine will be used.
	// Default is 2 worker threads.
	Concurrency *types.Int32Value `protobuf:"bytes,16,opt,name=concurrency,proto3" json:"concurrency,omitempty"`
	// Path to the proxy bootstrap template file
	ProxyBootstrapTemplatePath string `protobuf:"bytes,17,opt,name=proxy_bootstrap_template_path,json=proxyBootstrapTemplatePath,proto3" json:"proxyBootstrapTemplatePath,omitempty"`
	// The mode used to redirect inbound traffic to Envoy.
	InterceptionMode ProxyConfig_InboundInterceptionMode `protobuf:"varint,18,opt,name=interception_mode,json=interceptionMode,proto3,enum=istio.mesh.v1alpha1.ProxyConfig_InboundInterceptionMode" json:"interceptionMode,omitempty"`
	// Tracing configuration to be used by the proxy.
	Tracing *Tracing `protobuf:"bytes,19,opt,name=tracing,proto3" json:"tracing,omitempty"`
	// Secret Discovery Service(SDS) configuration to be used by the proxy.
	Sds *SDS `protobuf:"bytes,21,opt,name=sds,proto3" json:"sds,omitempty"`
	// Address of the service to which access logs from Envoys should be
	// sent. (e.g. `accesslog-service:15000`). See [Access Log
	// Service](https://www.envoyproxy.io/docs/envoy/latest/api-v2/config/accesslog/v2/als.proto)
	// for details about Envoy's gRPC Access Log Service API.
	EnvoyAccessLogService *RemoteService `protobuf:"bytes,22,opt,name=envoy_access_log_service,json=envoyAccessLogService,proto3" json:"envoyAccessLogService,omitempty"`
	// Address of the Envoy Metrics Service implementation (e.g. `metrics-service:15000`).
	// See [Metric Service](https://www.envoyproxy.io/docs/envoy/latest/api-v2/config/metrics/v2/metrics_service.proto)
	// for details about Envoy's Metrics Service API.
	EnvoyMetricsService *RemoteService `protobuf:"bytes,23,opt,name=envoy_metrics_service,json=envoyMetricsService,proto3" json:"envoyMetricsService,omitempty"`
	// Additional environment variables for the proxy.
	// Names starting with `ISTIO_META_` will be included in the generated bootstrap and sent to the XDS server.
	ProxyMetadata map[string]string `protobuf:"bytes,24,rep,name=proxy_metadata,json=proxyMetadata,proto3" json:"proxyMetadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Port on which the agent should listen for administrative commands such as readiness probe.
	// Default is set to port `15020`.
	StatusPort int32 `protobuf:"varint,26,opt,name=status_port,json=statusPort,proto3" json:"statusPort,omitempty"`
	// An additional list of tags to extract from the in-proxy Istio telemetry. These extra tags can be
	// added by configuring the telemetry extension. Each additional tag needs to be present in this list.
	// Extra tags emitted by the telemetry extensions must be listed here so that they can be processed
	// and exposed as Prometheus metrics.
	ExtraStatTags []string `protobuf:"bytes,27,rep,name=extra_stat_tags,json=extraStatTags,proto3" json:"extraStatTags,omitempty"`
	// $hide_from_docs
	// Topology encapsulates the configuration which describes where the proxy is
	// located i.e. behind a (or N) trusted proxy (proxies) or directly exposed
	// to the internet. This configuration only effects gateways and is applied
	// to all the gateways in the cluster unless overriden via annotations of the
	// gateway workloads.
	GatewayTopology *Topology `protobuf:"bytes,28,opt,name=gateway_topology,json=gatewayTopology,proto3" json:"gatewayTopology,omitempty"`
	// The amount of time allowed for connections to complete on proxy shutdown.
	// On receiving `SIGTERM` or `SIGINT`, `istio-agent` tells the active Envoy to start draining,
	// preventing any new connections and allowing existing connections to complete. It then
	// sleeps for the `termination_drain_duration` and then kills any remaining active Envoy processes.
	// If not set, a default of `5s` will be applied.
	TerminationDrainDuration *types.Duration `protobuf:"bytes,29,opt,name=termination_drain_duration,json=terminationDrainDuration,proto3" json:"terminationDrainDuration,omitempty"`
	// The unique identifier for the [service mesh](https://istio.io/docs/reference/glossary/#service-mesh)
	// All control planes running in the same service mesh should specify the same mesh ID.
	// Mesh ID is used to label telemetry reports for cases where telemetry from multiple meshes is mixed together.
	MeshId string `protobuf:"bytes,30,opt,name=mesh_id,json=meshId,proto3" json:"meshId,omitempty"`
	// VM Health Checking readiness probe. This health check config exactly mirrors the
	// kubernetes readiness probe configuration both in schema and logic.
	// Only one health check method of 3 can be set at a time.
	ReadinessProbe *v1alpha3.ReadinessProbe `protobuf:"bytes,31,opt,name=readiness_probe,json=readinessProbe,proto3" json:"readinessProbe,omitempty"`
	// Proxy stats matcher defines configuration for reporting custom Envoy stats.
	// To reduce memory and CPU overhead from Envoy stats system, Istio proxies by
	// default create and expose only a subset of Envoy stats. This option is to
	// control creation of additional Envoy stats with prefix, suffix, and regex
	// expressions match on the name of the stats. This replaces the stats
	// inclusion annotations
	// (`sidecar.istio.io/statsInclusionPrefixes`,
	// `sidecar.istio.io/statsInclusionRegexps`, and
	// `sidecar.istio.io/statsInclusionSuffixes`). For example, to enable stats
	// for circuit breaker, retry, and upstream connections, you can specify stats
	// matcher as follow:
	// ```yaml
	// proxyStatsMatcher:
	//   inclusionRegexps:
	//     - .*circuit_breakers.*
	//   inclusionPrefixes:
	//     - upstream_rq_retry
	//     - upstream_cx
	// ```
	// Note including more Envoy stats might increase number of time series
	// collected by prometheus significantly. Care needs to be taken on Prometheus
	// resource provision and configuration to reduce cardinality.
	ProxyStatsMatcher *ProxyConfig_ProxyStatsMatcher `protobuf:"bytes,32,opt,name=proxy_stats_matcher,json=proxyStatsMatcher,proto3" json:"proxyStatsMatcher,omitempty"`
	// Boolean flag for enabling/disabling the holdApplicationUntilProxyStarts behavior.
	// This feature adds hooks to delay application startup until the pod proxy
	// is ready to accept traffic, mitigating some startup race conditions.
	// Default value is 'false'.
	HoldApplicationUntilProxyStarts *types.BoolValue `protobuf:"bytes,33,opt,name=hold_application_until_proxy_starts,json=holdApplicationUntilProxyStarts,proto3" json:"holdApplicationUntilProxyStarts,omitempty"`
	// The PEM data of the extra root certificates for workload-to-workload communication.
	// This includes the certificates defined in MeshConfig and any other certificates that Istiod uses as CA.
	// The plugin certificates (the 'cacerts' secret), self-signed certificates (the 'istio-ca-secret' secret)
	// are added automatically by Istiod.
	CaCertificatesPem    []string `protobuf:"bytes,34,rep,name=ca_certificates_pem,json=caCertificatesPem,proto3" json:"caCertificatesPem,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ProxyConfig) Reset()         { *m = ProxyConfig{} }
func (m *ProxyConfig) String() string { return proto.CompactTextString(m) }
func (*ProxyConfig) ProtoMessage()    {}
func (*ProxyConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_5efecd978cf3d28d, []int{3}
}
func (m *ProxyConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ProxyConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ProxyConfig.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ProxyConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProxyConfig.Merge(m, src)
}
func (m *ProxyConfig) XXX_Size() int {
	return m.Size()
}
func (m *ProxyConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_ProxyConfig.DiscardUnknown(m)
}

var xxx_messageInfo_ProxyConfig proto.InternalMessageInfo

func (m *ProxyConfig) GetConfigPath() string {
	if m != nil {
		return m.ConfigPath
	}
	return ""
}

func (m *ProxyConfig) GetBinaryPath() string {
	if m != nil {
		return m.BinaryPath
	}
	return ""
}

func (m *ProxyConfig) GetServiceCluster() string {
	if m != nil {
		return m.ServiceCluster
	}
	return ""
}

func (m *ProxyConfig) GetDrainDuration() *types.Duration {
	if m != nil {
		return m.DrainDuration
	}
	return nil
}

func (m *ProxyConfig) GetParentShutdownDuration() *types.Duration {
	if m != nil {
		return m.ParentShutdownDuration
	}
	return nil
}

func (m *ProxyConfig) GetDiscoveryAddress() string {
	if m != nil {
		return m.DiscoveryAddress
	}
	return ""
}

// Deprecated: Do not use.
func (m *ProxyConfig) GetDiscoveryRefreshDelay() *types.Duration {
	if m != nil {
		return m.DiscoveryRefreshDelay
	}
	return nil
}

// Deprecated: Do not use.
func (m *ProxyConfig) GetZipkinAddress() string {
	if m != nil {
		return m.ZipkinAddress
	}
	return ""
}

func (m *ProxyConfig) GetStatsdUdpAddress() string {
	if m != nil {
		return m.StatsdUdpAddress
	}
	return ""
}

// Deprecated: Do not use.
func (m *ProxyConfig) GetEnvoyMetricsServiceAddress() string {
	if m != nil {
		return m.EnvoyMetricsServiceAddress
	}
	return ""
}

func (m *ProxyConfig) GetProxyAdminPort() int32 {
	if m != nil {
		return m.ProxyAdminPort
	}
	return 0
}

// Deprecated: Do not use.
func (m *ProxyConfig) GetAvailabilityZone() string {
	if m != nil {
		return m.AvailabilityZone
	}
	return ""
}

func (m *ProxyConfig) GetControlPlaneAuthPolicy() AuthenticationPolicy {
	if m != nil {
		return m.ControlPlaneAuthPolicy
	}
	return AuthenticationPolicy_NONE
}

func (m *ProxyConfig) GetCustomConfigFile() string {
	if m != nil {
		return m.CustomConfigFile
	}
	return ""
}

func (m *ProxyConfig) GetStatNameLength() int32 {
	if m != nil {
		return m.StatNameLength
	}
	return 0
}

func (m *ProxyConfig) GetConcurrency() *types.Int32Value {
	if m != nil {
		return m.Concurrency
	}
	return nil
}

func (m *ProxyConfig) GetProxyBootstrapTemplatePath() string {
	if m != nil {
		return m.ProxyBootstrapTemplatePath
	}
	return ""
}

func (m *ProxyConfig) GetInterceptionMode() ProxyConfig_InboundInterceptionMode {
	if m != nil {
		return m.InterceptionMode
	}
	return ProxyConfig_REDIRECT
}

func (m *ProxyConfig) GetTracing() *Tracing {
	if m != nil {
		return m.Tracing
	}
	return nil
}

func (m *ProxyConfig) GetSds() *SDS {
	if m != nil {
		return m.Sds
	}
	return nil
}

func (m *ProxyConfig) GetEnvoyAccessLogService() *RemoteService {
	if m != nil {
		return m.EnvoyAccessLogService
	}
	return nil
}

func (m *ProxyConfig) GetEnvoyMetricsService() *RemoteService {
	if m != nil {
		return m.EnvoyMetricsService
	}
	return nil
}

func (m *ProxyConfig) GetProxyMetadata() map[string]string {
	if m != nil {
		return m.ProxyMetadata
	}
	return nil
}

func (m *ProxyConfig) GetStatusPort() int32 {
	if m != nil {
		return m.StatusPort
	}
	return 0
}

func (m *ProxyConfig) GetExtraStatTags() []string {
	if m != nil {
		return m.ExtraStatTags
	}
	return nil
}

func (m *ProxyConfig) GetGatewayTopology() *Topology {
	if m != nil {
		return m.GatewayTopology
	}
	return nil
}

func (m *ProxyConfig) GetTerminationDrainDuration() *types.Duration {
	if m != nil {
		return m.TerminationDrainDuration
	}
	return nil
}

func (m *ProxyConfig) GetMeshId() string {
	if m != nil {
		return m.MeshId
	}
	return ""
}

func (m *ProxyConfig) GetReadinessProbe() *v1alpha3.ReadinessProbe {
	if m != nil {
		return m.ReadinessProbe
	}
	return nil
}

func (m *ProxyConfig) GetProxyStatsMatcher() *ProxyConfig_ProxyStatsMatcher {
	if m != nil {
		return m.ProxyStatsMatcher
	}
	return nil
}

func (m *ProxyConfig) GetHoldApplicationUntilProxyStarts() *types.BoolValue {
	if m != nil {
		return m.HoldApplicationUntilProxyStarts
	}
	return nil
}

func (m *ProxyConfig) GetCaCertificatesPem() []string {
	if m != nil {
		return m.CaCertificatesPem
	}
	return nil
}

// Proxy stats name matchers for stats creation. Note this is in addition to
// the minimum Envoy stats that Istio generates by default.
type ProxyConfig_ProxyStatsMatcher struct {
	// Proxy stats name prefix matcher for inclusion.
	InclusionPrefixes []string `protobuf:"bytes,1,rep,name=inclusion_prefixes,json=inclusionPrefixes,proto3" json:"inclusionPrefixes,omitempty"`
	// Proxy stats name suffix matcher for inclusion.
	InclusionSuffixes []string `protobuf:"bytes,2,rep,name=inclusion_suffixes,json=inclusionSuffixes,proto3" json:"inclusionSuffixes,omitempty"`
	// Proxy stats name regexps matcher for inclusion.
	InclusionRegexps     []string `protobuf:"bytes,3,rep,name=inclusion_regexps,json=inclusionRegexps,proto3" json:"inclusionRegexps,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ProxyConfig_ProxyStatsMatcher) Reset()         { *m = ProxyConfig_ProxyStatsMatcher{} }
func (m *ProxyConfig_ProxyStatsMatcher) String() string { return proto.CompactTextString(m) }
func (*ProxyConfig_ProxyStatsMatcher) ProtoMessage()    {}
func (*ProxyConfig_ProxyStatsMatcher) Descriptor() ([]byte, []int) {
	return fileDescriptor_5efecd978cf3d28d, []int{3, 1}
}
func (m *ProxyConfig_ProxyStatsMatcher) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ProxyConfig_ProxyStatsMatcher) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ProxyConfig_ProxyStatsMatcher.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ProxyConfig_ProxyStatsMatcher) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProxyConfig_ProxyStatsMatcher.Merge(m, src)
}
func (m *ProxyConfig_ProxyStatsMatcher) XXX_Size() int {
	return m.Size()
}
func (m *ProxyConfig_ProxyStatsMatcher) XXX_DiscardUnknown() {
	xxx_messageInfo_ProxyConfig_ProxyStatsMatcher.DiscardUnknown(m)
}

var xxx_messageInfo_ProxyConfig_ProxyStatsMatcher proto.InternalMessageInfo

func (m *ProxyConfig_ProxyStatsMatcher) GetInclusionPrefixes() []string {
	if m != nil {
		return m.InclusionPrefixes
	}
	return nil
}

func (m *ProxyConfig_ProxyStatsMatcher) GetInclusionSuffixes() []string {
	if m != nil {
		return m.InclusionSuffixes
	}
	return nil
}

func (m *ProxyConfig_ProxyStatsMatcher) GetInclusionRegexps() []string {
	if m != nil {
		return m.InclusionRegexps
	}
	return nil
}

type RemoteService struct {
	// Address of a remove service used for various purposes (access log
	// receiver, metrics receiver, etc.). Can be IP address or a fully
	// qualified DNS name.
	Address string `protobuf:"bytes,1,opt,name=address,proto3" json:"address,omitempty"`
	// Use the `tls_settings` to specify the tls mode to use. If the remote service
	// uses Istio mutual TLS and shares the root CA with Pilot, specify the TLS
	// mode as `ISTIO_MUTUAL`.
	TlsSettings *v1alpha3.ClientTLSSettings `protobuf:"bytes,2,opt,name=tls_settings,json=tlsSettings,proto3" json:"tlsSettings,omitempty"`
	// If set then set `SO_KEEPALIVE` on the socket to enable TCP Keepalives.
	TcpKeepalive         *v1alpha3.ConnectionPoolSettings_TCPSettings_TcpKeepalive `protobuf:"bytes,3,opt,name=tcp_keepalive,json=tcpKeepalive,proto3" json:"tcpKeepalive,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                                  `json:"-"`
	XXX_unrecognized     []byte                                                    `json:"-"`
	XXX_sizecache        int32                                                     `json:"-"`
}

func (m *RemoteService) Reset()         { *m = RemoteService{} }
func (m *RemoteService) String() string { return proto.CompactTextString(m) }
func (*RemoteService) ProtoMessage()    {}
func (*RemoteService) Descriptor() ([]byte, []int) {
	return fileDescriptor_5efecd978cf3d28d, []int{4}
}
func (m *RemoteService) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RemoteService) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RemoteService.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RemoteService) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RemoteService.Merge(m, src)
}
func (m *RemoteService) XXX_Size() int {
	return m.Size()
}
func (m *RemoteService) XXX_DiscardUnknown() {
	xxx_messageInfo_RemoteService.DiscardUnknown(m)
}

var xxx_messageInfo_RemoteService proto.InternalMessageInfo

func (m *RemoteService) GetAddress() string {
	if m != nil {
		return m.Address
	}
	return ""
}

func (m *RemoteService) GetTlsSettings() *v1alpha3.ClientTLSSettings {
	if m != nil {
		return m.TlsSettings
	}
	return nil
}

func (m *RemoteService) GetTcpKeepalive() *v1alpha3.ConnectionPoolSettings_TCPSettings_TcpKeepalive {
	if m != nil {
		return m.TcpKeepalive
	}
	return nil
}

func init() {
	proto.RegisterEnum("istio.mesh.v1alpha1.AuthenticationPolicy", AuthenticationPolicy_name, AuthenticationPolicy_value)
	proto.RegisterEnum("istio.mesh.v1alpha1.Tracing_OpenCensusAgent_TraceContext", Tracing_OpenCensusAgent_TraceContext_name, Tracing_OpenCensusAgent_TraceContext_value)
	proto.RegisterEnum("istio.mesh.v1alpha1.Topology_ForwardClientCertDetails", Topology_ForwardClientCertDetails_name, Topology_ForwardClientCertDetails_value)
	proto.RegisterEnum("istio.mesh.v1alpha1.ProxyConfig_InboundInterceptionMode", ProxyConfig_InboundInterceptionMode_name, ProxyConfig_InboundInterceptionMode_value)
	proto.RegisterType((*Tracing)(nil), "istio.mesh.v1alpha1.Tracing")
	proto.RegisterMapType((map[string]*Tracing_CustomTag)(nil), "istio.mesh.v1alpha1.Tracing.CustomTagsEntry")
	proto.RegisterType((*Tracing_Zipkin)(nil), "istio.mesh.v1alpha1.Tracing.Zipkin")
	proto.RegisterType((*Tracing_Lightstep)(nil), "istio.mesh.v1alpha1.Tracing.Lightstep")
	proto.RegisterType((*Tracing_Datadog)(nil), "istio.mesh.v1alpha1.Tracing.Datadog")
	proto.RegisterType((*Tracing_Stackdriver)(nil), "istio.mesh.v1alpha1.Tracing.Stackdriver")
	proto.RegisterType((*Tracing_OpenCensusAgent)(nil), "istio.mesh.v1alpha1.Tracing.OpenCensusAgent")
	proto.RegisterType((*Tracing_CustomTag)(nil), "istio.mesh.v1alpha1.Tracing.CustomTag")
	proto.RegisterType((*Tracing_Literal)(nil), "istio.mesh.v1alpha1.Tracing.Literal")
	proto.RegisterType((*Tracing_Environment)(nil), "istio.mesh.v1alpha1.Tracing.Environment")
	proto.RegisterType((*Tracing_RequestHeader)(nil), "istio.mesh.v1alpha1.Tracing.RequestHeader")
	proto.RegisterType((*SDS)(nil), "istio.mesh.v1alpha1.SDS")
	proto.RegisterType((*Topology)(nil), "istio.mesh.v1alpha1.Topology")
	proto.RegisterType((*ProxyConfig)(nil), "istio.mesh.v1alpha1.ProxyConfig")
	proto.RegisterMapType((map[string]string)(nil), "istio.mesh.v1alpha1.ProxyConfig.ProxyMetadataEntry")
	proto.RegisterType((*ProxyConfig_ProxyStatsMatcher)(nil), "istio.mesh.v1alpha1.ProxyConfig.ProxyStatsMatcher")
	proto.RegisterType((*RemoteService)(nil), "istio.mesh.v1alpha1.RemoteService")
}

func init() { proto.RegisterFile("mesh/v1alpha1/proxy.proto", fileDescriptor_5efecd978cf3d28d) }

var fileDescriptor_5efecd978cf3d28d = []byte{
	// 2169 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x58, 0xdd, 0x52, 0x1b, 0xc9,
	0xf5, 0x47, 0x02, 0x03, 0x3a, 0x7c, 0x89, 0xc6, 0xd8, 0x63, 0xf9, 0x8b, 0xc5, 0xfb, 0xdf, 0x3f,
	0x76, 0x76, 0x45, 0xad, 0x49, 0xb9, 0x9c, 0x54, 0x36, 0x65, 0x21, 0x89, 0x20, 0x07, 0x84, 0x6a,
	0x24, 0xec, 0x35, 0x7b, 0xd1, 0xd5, 0x9a, 0x69, 0x49, 0x13, 0x66, 0xba, 0x27, 0xdd, 0x3d, 0x80,
	0xf6, 0x09, 0xf2, 0x14, 0xb9, 0xcb, 0x6d, 0x2a, 0x0f, 0x90, 0x07, 0xc8, 0x65, 0x1e, 0x21, 0xe5,
	0x9b, 0x24, 0x95, 0x97, 0x48, 0x75, 0xf7, 0x8c, 0x10, 0x18, 0xcb, 0x4e, 0x72, 0xa7, 0x3e, 0xe7,
	0xf7, 0xfb, 0x4d, 0x7f, 0x9c, 0x73, 0xfa, 0xb4, 0xe0, 0x5e, 0x44, 0xe5, 0x60, 0xfb, 0xec, 0x5b,
	0x12, 0xc6, 0x03, 0xf2, 0xed, 0x76, 0x2c, 0xf8, 0xc5, 0xb0, 0x1c, 0x0b, 0xae, 0x38, 0x5a, 0x0b,
	0xa4, 0x0a, 0x78, 0x59, 0x03, 0xca, 0x19, 0xa0, 0xf4, 0xa8, 0xcf, 0x79, 0x3f, 0xa4, 0xdb, 0x06,
	0xd2, 0x4d, 0x7a, 0xdb, 0x7e, 0x22, 0x88, 0x0a, 0x38, 0xb3, 0xa4, 0x0f, 0xfd, 0xe7, 0x82, 0xc4,
	0x31, 0x15, 0x32, 0xf5, 0x3f, 0x63, 0x54, 0x9d, 0x73, 0x71, 0x1a, 0xb0, 0x7e, 0xf6, 0xd5, 0x9d,
	0x6d, 0x9f, 0x4a, 0x15, 0x30, 0x23, 0x83, 0x45, 0x12, 0xd2, 0x14, 0xbb, 0x75, 0x13, 0x56, 0x1b,
	0x42, 0x4e, 0x7c, 0xdc, 0x17, 0x3c, 0x89, 0x2d, 0x72, 0xf3, 0x0f, 0xcb, 0x30, 0xd7, 0x11, 0xc4,
	0x0b, 0x58, 0x1f, 0x7d, 0x07, 0xb3, 0x3f, 0x06, 0xf1, 0x69, 0xc0, 0x9c, 0xdc, 0x46, 0x6e, 0x6b,
	0xe1, 0xf9, 0x93, 0xf2, 0x0d, 0xeb, 0x28, 0xa7, 0xe8, 0xf2, 0x89, 0x81, 0xee, 0x4f, 0xb9, 0x29,
	0x09, 0xed, 0x41, 0x21, 0x0c, 0xfa, 0x03, 0x25, 0x15, 0x8d, 0x9d, 0xbc, 0x51, 0xf8, 0x6a, 0xa2,
	0xc2, 0x41, 0x86, 0xde, 0x9f, 0x72, 0x2f, 0xa9, 0xe8, 0x15, 0xcc, 0xf9, 0x44, 0x11, 0x9f, 0xf7,
	0x9d, 0x69, 0xa3, 0xf2, 0xe5, 0x44, 0x95, 0x9a, 0xc5, 0xee, 0x4f, 0xb9, 0x19, 0x0d, 0x1d, 0xc0,
	0x82, 0x54, 0xc4, 0x3b, 0xf5, 0x45, 0x70, 0x46, 0x85, 0x33, 0x63, 0x54, 0xb6, 0x26, 0xaa, 0xb4,
	0x2f, 0xf1, 0xfb, 0x53, 0xee, 0x38, 0x1d, 0x9d, 0xc0, 0x2a, 0x8f, 0x29, 0xc3, 0x1e, 0x65, 0x32,
	0x91, 0x98, 0xf4, 0x29, 0x53, 0x4e, 0xc1, 0x68, 0x7e, 0x3d, 0x51, 0xf3, 0x28, 0xa6, 0xac, 0x6a,
	0x48, 0x15, 0xcd, 0xd9, 0x9f, 0x72, 0x57, 0xf8, 0x55, 0x13, 0x3a, 0x84, 0x05, 0x2f, 0x91, 0x8a,
	0x47, 0x58, 0x91, 0xbe, 0x74, 0x6e, 0x6d, 0x4c, 0x7f, 0x52, 0xb5, 0x6a, 0xf0, 0x1d, 0xd2, 0x97,
	0x75, 0xa6, 0xc4, 0xd0, 0x05, 0x6f, 0x64, 0x40, 0xdf, 0xc0, 0x5a, 0x44, 0x2e, 0x70, 0x4c, 0xd4,
	0x40, 0x0b, 0xe2, 0x90, 0xb2, 0xbe, 0x1a, 0x38, 0xb3, 0x1b, 0xb9, 0xad, 0x25, 0xb7, 0x18, 0x91,
	0x8b, 0x16, 0x51, 0x83, 0x0e, 0xe9, 0x1f, 0x18, 0x3b, 0x2a, 0xc1, 0xbc, 0x24, 0x51, 0x1c, 0x06,
	0xac, 0xef, 0xcc, 0x6d, 0xe4, 0xb6, 0x72, 0xee, 0x68, 0x8c, 0x8e, 0x60, 0x51, 0x85, 0x12, 0x4b,
	0xaa, 0x54, 0xc0, 0xfa, 0xd2, 0x99, 0xbf, 0xb2, 0xe0, 0xcb, 0xf8, 0xca, 0x26, 0xb8, 0x53, 0xae,
	0x86, 0x01, 0x65, 0xaa, 0x73, 0xd0, 0x6e, 0xa7, 0x1c, 0x77, 0x41, 0x85, 0x32, 0x1b, 0x94, 0x36,
	0x61, 0xd6, 0x86, 0x0c, 0x72, 0x60, 0x8e, 0xf8, 0xbe, 0xa0, 0x52, 0x9a, 0x40, 0x2b, 0xb8, 0xd9,
	0xb0, 0xb4, 0x0f, 0x85, 0x51, 0x50, 0x7c, 0x1c, 0x86, 0xbe, 0x80, 0x45, 0xe2, 0x79, 0x54, 0x4a,
	0xac, 0xf8, 0x29, 0x65, 0x26, 0xd8, 0x0a, 0xee, 0x82, 0xb5, 0x75, 0xb4, 0xa9, 0xf4, 0x04, 0xe6,
	0xd2, 0xc0, 0x98, 0xf0, 0xb9, 0x3f, 0xe6, 0x61, 0x61, 0xec, 0xe0, 0xd1, 0x6d, 0xb8, 0xe5, 0xd3,
	0x6e, 0xd2, 0x37, 0xb8, 0x79, 0xd7, 0x0e, 0x50, 0x07, 0x1c, 0xbd, 0xa9, 0x2c, 0x89, 0xba, 0x54,
	0x60, 0xde, 0xc3, 0x44, 0x29, 0x11, 0x74, 0x13, 0x45, 0x65, 0x1a, 0xe6, 0xf7, 0xcb, 0x36, 0x77,
	0xcb, 0x59, 0xee, 0x96, 0x1b, 0x4c, 0xbd, 0xf8, 0xe9, 0x1b, 0x12, 0x26, 0xd4, 0x5d, 0x8f, 0xc8,
	0x45, 0xd3, 0x70, 0x8f, 0x7a, 0x95, 0x11, 0x13, 0xbd, 0x81, 0x7b, 0xd7, 0x54, 0x19, 0xe3, 0xca,
	0x64, 0xb2, 0x4c, 0xe3, 0x7e, 0xa2, 0xec, 0x9d, 0x71, 0xd9, 0x4b, 0x2a, 0xfa, 0x01, 0x1e, 0x5c,
	0xd5, 0x8d, 0xa8, 0x94, 0xa4, 0x4f, 0x31, 0x3d, 0xa3, 0x4c, 0xc9, 0x34, 0x19, 0x26, 0x4a, 0x3b,
	0x63, 0xd2, 0x87, 0x96, 0x5d, 0x37, 0xe4, 0xd2, 0xdf, 0x73, 0xb0, 0x72, 0x2d, 0xaa, 0x27, 0x1c,
	0x53, 0x1b, 0xe6, 0x3c, 0xce, 0x14, 0xbd, 0x50, 0x4e, 0x7e, 0x63, 0x7a, 0x6b, 0xf9, 0xf9, 0xcf,
	0xfe, 0x93, 0x74, 0x31, 0x76, 0x5a, 0xb5, 0x02, 0x6e, 0xa6, 0xb4, 0x49, 0x61, 0x71, 0xdc, 0x81,
	0x56, 0x60, 0xe1, 0xb8, 0xd9, 0x6e, 0xd5, 0xab, 0x8d, 0xbd, 0x46, 0xbd, 0x56, 0x9c, 0x42, 0xeb,
	0xb0, 0xfa, 0x76, 0xa7, 0x8a, 0x3b, 0x6e, 0xa5, 0x5a, 0xc7, 0xd5, 0xa3, 0x66, 0xa7, 0xfe, 0x7d,
	0xa7, 0x98, 0x43, 0x8b, 0x30, 0xff, 0x2b, 0xb7, 0x55, 0xc5, 0xbb, 0x8d, 0x66, 0x31, 0x8f, 0xee,
	0xc2, 0x5a, 0xf5, 0xe0, 0xe8, 0xb8, 0x76, 0x0d, 0x36, 0x8d, 0x66, 0x21, 0xbf, 0xbb, 0x53, 0x9c,
	0x29, 0xfd, 0x33, 0x07, 0x85, 0x51, 0xa6, 0xe9, 0x92, 0x14, 0x06, 0x8a, 0x0a, 0x12, 0xa6, 0xa5,
	0xf1, 0xcb, 0x4f, 0x14, 0x36, 0x83, 0xd5, 0x25, 0x29, 0xa5, 0xe9, 0x92, 0x44, 0xd9, 0x59, 0x20,
	0x38, 0x8b, 0x74, 0xf9, 0xc8, 0x7f, 0x46, 0x49, 0xaa, 0x5f, 0xe2, 0x75, 0x49, 0x1a, 0xa3, 0xa3,
	0x1a, 0xcc, 0x0e, 0x28, 0xf1, 0xa9, 0x48, 0x23, 0xe5, 0xd9, 0x44, 0x21, 0x97, 0xfe, 0x36, 0xa1,
	0x52, 0xed, 0x1b, 0x86, 0x2e, 0xd8, 0x96, 0xbb, 0x3b, 0x0b, 0x33, 0x6a, 0x18, 0xd3, 0xd2, 0x63,
	0x98, 0x4b, 0x67, 0xac, 0x33, 0xe0, 0x4c, 0xc7, 0x40, 0x7a, 0x94, 0x76, 0x50, 0xda, 0x83, 0x85,
	0xb1, 0xc9, 0x20, 0x04, 0x33, 0x8c, 0x44, 0x19, 0xc6, 0xfc, 0x46, 0x4f, 0x60, 0xc9, 0xa7, 0x3d,
	0x92, 0x84, 0x0a, 0x5b, 0x01, 0x9b, 0x93, 0x8b, 0xa9, 0xd1, 0x04, 0x56, 0x69, 0x1f, 0x96, 0xae,
	0xcc, 0xe5, 0xbf, 0x57, 0xa2, 0xb0, 0x72, 0xad, 0x0e, 0xa2, 0x22, 0x4c, 0x9f, 0xd2, 0x61, 0x2a,
	0xa5, 0x7f, 0xa2, 0x5f, 0x64, 0x8b, 0xf9, 0x9c, 0xcb, 0x68, 0x24, 0x97, 0x2e, 0xfa, 0xe7, 0xf9,
	0x97, 0xb9, 0xdd, 0x79, 0x98, 0x55, 0x3a, 0xd8, 0xc4, 0xe6, 0x1e, 0x4c, 0xb7, 0x6b, 0x6d, 0x1d,
	0xec, 0x94, 0x91, 0x6e, 0x48, 0xfd, 0xb4, 0x46, 0x64, 0x43, 0xf4, 0x7f, 0xb0, 0x72, 0xfa, 0x52,
	0x62, 0x49, 0xf0, 0x6f, 0xce, 0x95, 0xa9, 0xc0, 0xd9, 0xc4, 0x4f, 0x5f, 0xca, 0x36, 0x79, 0x7d,
	0xae, 0x74, 0xed, 0xdd, 0xfc, 0x73, 0x1e, 0xe6, 0x3b, 0x3c, 0xe6, 0x21, 0xef, 0x0f, 0x51, 0x19,
	0xd6, 0x58, 0x12, 0x61, 0x25, 0x12, 0xa9, 0xa8, 0x8f, 0x75, 0x0b, 0x11, 0x50, 0x9b, 0x46, 0x4b,
	0xee, 0x2a, 0x4b, 0xa2, 0x8e, 0xf5, 0xb4, 0xac, 0x03, 0x25, 0x70, 0xbf, 0xc7, 0xc5, 0x39, 0x11,
	0x3e, 0xf6, 0x4c, 0xb1, 0xc5, 0x1e, 0x15, 0x0a, 0xfb, 0x54, 0x91, 0x20, 0xb4, 0xc5, 0x68, 0xf9,
	0xf9, 0x8b, 0x9b, 0x97, 0x99, 0x7e, 0xb3, 0xbc, 0x67, 0x05, 0x6c, 0xb1, 0xae, 0x52, 0xa1, 0x6a,
	0x96, 0xed, 0x3a, 0xbd, 0x8f, 0x78, 0x36, 0x7f, 0x97, 0x03, 0xe7, 0x63, 0x34, 0xb4, 0x04, 0x85,
	0xe3, 0x66, 0xad, 0xbe, 0xd7, 0x68, 0x9a, 0xec, 0x5b, 0x84, 0xf9, 0x76, 0xa5, 0xd9, 0xe8, 0x34,
	0x4e, 0xea, 0xc5, 0x1c, 0x2a, 0xc2, 0xe2, 0xde, 0x91, 0xfb, 0xb6, 0xe2, 0xd6, 0xf0, 0x51, 0xf3,
	0xe0, 0x5d, 0x31, 0x8f, 0x10, 0x2c, 0x57, 0x5a, 0xad, 0x7a, 0xb3, 0x86, 0x53, 0x47, 0x71, 0x5a,
	0xa3, 0x32, 0x0e, 0x6e, 0xd7, 0x3b, 0xc5, 0x19, 0x9d, 0x9e, 0x95, 0x83, 0xb7, 0x95, 0x77, 0x6d,
	0x7c, 0x85, 0x7e, 0x6b, 0xf3, 0x4f, 0x08, 0x16, 0xf4, 0x6e, 0x0c, 0xab, 0x9c, 0xf5, 0x82, 0x3e,
	0x7a, 0x0c, 0x0b, 0x9e, 0xf9, 0x65, 0x77, 0xdc, 0x1e, 0x3e, 0x58, 0x93, 0xde, 0x6f, 0x0d, 0xe8,
	0x06, 0x8c, 0x88, 0xe1, 0xf8, 0x91, 0x80, 0x35, 0x19, 0xc0, 0xff, 0xc3, 0x8a, 0xa4, 0xe2, 0x2c,
	0xf0, 0x28, 0xf6, 0x42, 0xbd, 0xdb, 0x36, 0xa7, 0x0a, 0xee, 0x72, 0x6a, 0xae, 0x5a, 0x2b, 0x7a,
	0x05, 0xcb, 0xbe, 0x20, 0x01, 0xc3, 0x59, 0xdf, 0x96, 0x96, 0xd2, 0x7b, 0x1f, 0x94, 0xd2, 0x5a,
	0x0a, 0x70, 0x97, 0x0c, 0x21, 0x1b, 0xa2, 0x36, 0x38, 0x31, 0x11, 0xfa, 0xd8, 0xe4, 0x20, 0x51,
	0x3e, 0x3f, 0x1f, 0xd3, 0xba, 0xf5, 0x29, 0xad, 0x3b, 0x96, 0xda, 0x4e, 0x99, 0x23, 0xd1, 0x9f,
	0xc0, 0xaa, 0x1f, 0x48, 0x8f, 0x9f, 0x51, 0x31, 0xc4, 0x59, 0x21, 0x9e, 0x35, 0x2b, 0x28, 0x8e,
	0x1c, 0x95, 0xb4, 0x22, 0x1f, 0xc3, 0xdd, 0x4b, 0xb0, 0xa0, 0x3d, 0x41, 0xe5, 0x00, 0xfb, 0x34,
	0x24, 0x43, 0x73, 0xff, 0x4f, 0x9a, 0xc0, 0x6e, 0xde, 0xc9, 0xb9, 0xeb, 0x23, 0xb6, 0x6b, 0xc9,
	0x35, 0xcd, 0x45, 0x4f, 0x61, 0xd9, 0xf6, 0x80, 0xa3, 0x09, 0xe8, 0x6e, 0xa1, 0x60, 0x28, 0x4b,
	0xd6, 0x93, 0xcd, 0xe0, 0x6b, 0x40, 0x52, 0x11, 0x25, 0x7d, 0x9c, 0xf8, 0xf1, 0x08, 0x0e, 0x76,
	0xbe, 0xd6, 0x73, 0xec, 0xc7, 0x19, 0xba, 0x0e, 0x0f, 0x29, 0x3b, 0xe3, 0x43, 0x1c, 0x51, 0x25,
	0x02, 0x4f, 0xb7, 0x23, 0xf6, 0xa8, 0x32, 0xe2, 0xed, 0xd1, 0x77, 0x4a, 0x06, 0x78, 0x68, 0x71,
	0x6d, 0x0b, 0xcb, 0x64, 0xb6, 0xa0, 0x68, 0xda, 0x73, 0x4c, 0xfc, 0x28, 0x60, 0x38, 0xe6, 0x42,
	0x39, 0x0b, 0x1b, 0xb9, 0xad, 0x5b, 0xee, 0xb2, 0xb1, 0x57, 0xb4, 0xb9, 0xc5, 0x85, 0x42, 0xdb,
	0xb0, 0x4a, 0xce, 0x48, 0x10, 0x92, 0x6e, 0x10, 0x06, 0x6a, 0x88, 0x7f, 0xe4, 0x8c, 0x3a, 0x8b,
	0xa3, 0x8f, 0x14, 0xc7, 0x9d, 0x27, 0x9c, 0x51, 0xe4, 0xc3, 0x3d, 0x7d, 0x33, 0x09, 0x1e, 0xe2,
	0x38, 0x24, 0x8c, 0x62, 0x92, 0xa8, 0x01, 0x8e, 0x79, 0x18, 0x78, 0x43, 0x67, 0xc9, 0x24, 0xe4,
	0xd3, 0x1b, 0x13, 0xb2, 0x92, 0xa8, 0x01, 0x65, 0x2a, 0xf0, 0xcc, 0xee, 0xb6, 0x0c, 0xc1, 0xbd,
	0x93, 0x6a, 0xb5, 0xb4, 0x94, 0x46, 0x58, 0xbb, 0xde, 0xb5, 0xb4, 0x4d, 0x4c, 0xa3, 0xbd, 0x17,
	0x84, 0xd4, 0x59, 0xb6, 0xbb, 0x66, 0x3d, 0x36, 0x21, 0xf6, 0x82, 0x90, 0xea, 0xe5, 0xea, 0x9d,
	0xc4, 0xba, 0x9c, 0x66, 0x2d, 0xe0, 0x8a, 0x5d, 0xae, 0xb6, 0x37, 0x49, 0x44, 0xd3, 0x06, 0xf0,
	0x3b, 0x93, 0x3e, 0x5e, 0x22, 0x04, 0x65, 0xde, 0xd0, 0x29, 0x7e, 0xbc, 0x37, 0xd8, 0x79, 0x6e,
	0x7b, 0x83, 0x71, 0x3c, 0xaa, 0xc0, 0x43, 0xbb, 0xaf, 0x5d, 0xce, 0x95, 0x54, 0x82, 0xc4, 0x58,
	0xd1, 0x28, 0x0e, 0x89, 0xa2, 0x36, 0xdd, 0x56, 0xcd, 0x0c, 0x4b, 0x06, 0xb4, 0x9b, 0x61, 0x3a,
	0x29, 0xc4, 0xa4, 0x1f, 0x85, 0xd5, 0x80, 0x29, 0x2a, 0x3c, 0x1a, 0x9b, 0x47, 0x4c, 0xc4, 0x7d,
	0xea, 0x20, 0xb3, 0x6f, 0x2f, 0x6f, 0xdc, 0xb7, 0xb1, 0xec, 0x2f, 0x37, 0x58, 0x97, 0x27, 0xcc,
	0x6f, 0x8c, 0x09, 0x1c, 0x72, 0x9f, 0xba, 0xc5, 0xe0, 0x9a, 0x05, 0xbd, 0x80, 0x39, 0x65, 0x0b,
	0xbd, 0xb3, 0x66, 0x16, 0xf9, 0x60, 0xd2, 0x65, 0xe0, 0x66, 0x60, 0xf4, 0x0c, 0xa6, 0xa5, 0x2f,
	0x9d, 0x75, 0xc3, 0x71, 0x6e, 0xe4, 0xb4, 0x6b, 0x6d, 0x57, 0x83, 0xd0, 0x0f, 0xe0, 0xd8, 0x60,
	0x4d, 0x7b, 0xd3, 0x90, 0xf7, 0xb3, 0x78, 0x75, 0xee, 0x18, 0x81, 0xcd, 0x1b, 0x05, 0x5c, 0x1a,
	0x71, 0x45, 0xd3, 0x90, 0x75, 0xd7, 0x8d, 0x46, 0xc5, 0x48, 0x1c, 0xf0, 0x7e, 0x6a, 0x46, 0x6f,
	0x60, 0xfd, 0xc6, 0x4c, 0x70, 0xee, 0x7e, 0xb6, 0xf2, 0xda, 0x0d, 0x19, 0x82, 0x4e, 0xc0, 0xa6,
	0x80, 0xd6, 0x25, 0xfa, 0xfd, 0xe4, 0x38, 0xe6, 0x0d, 0xb2, 0xf3, 0xc9, 0xcd, 0x37, 0xbf, 0x0f,
	0x53, 0x96, 0x7d, 0x8a, 0x2c, 0xc5, 0xe3, 0x36, 0x5d, 0x7b, 0x75, 0xbc, 0x25, 0xd2, 0x66, 0x5c,
	0xc9, 0x84, 0x20, 0x58, 0x93, 0xc9, 0xb6, 0xaf, 0x60, 0x85, 0x5e, 0x28, 0x41, 0xb0, 0x09, 0x57,
	0xf3, 0x02, 0xba, 0xbf, 0x31, 0xbd, 0x55, 0x70, 0x97, 0x8c, 0xb9, 0xad, 0x88, 0x32, 0xcf, 0x9a,
	0x7d, 0x28, 0xf6, 0x89, 0xa2, 0xe7, 0x64, 0x88, 0x55, 0x7a, 0x8f, 0x39, 0x0f, 0xcc, 0xba, 0x1f,
	0x4e, 0xbc, 0xec, 0xdc, 0x95, 0x94, 0x36, 0xba, 0x71, 0xdf, 0x42, 0x49, 0x51, 0x11, 0x65, 0x4f,
	0xe6, 0x6b, 0x05, 0xfd, 0xe1, 0xa7, 0x8a, 0xb0, 0x33, 0x46, 0xae, 0x5d, 0xa9, 0xed, 0x77, 0x61,
	0x4e, 0xcf, 0x01, 0x07, 0xbe, 0xf3, 0xc8, 0x04, 0xfd, 0xac, 0x1e, 0x36, 0x7c, 0xe4, 0xc2, 0x8a,
	0xa0, 0xc4, 0x0f, 0x98, 0x0e, 0x89, 0x58, 0xf0, 0x2e, 0x75, 0x1e, 0x9b, 0xcf, 0x3c, 0x9d, 0xf0,
	0x94, 0x72, 0x33, 0x46, 0x4b, 0x13, 0xdc, 0x65, 0x71, 0x65, 0x8c, 0xba, 0xb0, 0x66, 0x0f, 0xcd,
	0x14, 0x4c, 0x1c, 0x11, 0xe5, 0x0d, 0xa8, 0x70, 0x36, 0x8c, 0xee, 0xf3, 0xcf, 0x3b, 0x39, 0xbd,
	0xb9, 0xf2, 0xd0, 0x32, 0xdd, 0xd5, 0xf8, 0xba, 0x09, 0x0d, 0xe0, 0xc9, 0x80, 0x87, 0x3e, 0x26,
	0x71, 0x1c, 0xa6, 0x45, 0x0a, 0x27, 0x4c, 0x05, 0x21, 0x1e, 0x7d, 0x5a, 0x28, 0xe9, 0x7c, 0x61,
	0xbe, 0x59, 0xfa, 0x60, 0xcb, 0x76, 0x39, 0x0f, 0x6d, 0xc5, 0x78, 0xac, 0x65, 0x2a, 0x97, 0x2a,
	0xc7, 0x5a, 0x24, 0x9b, 0x82, 0x50, 0x52, 0x77, 0x41, 0x1e, 0x31, 0x9d, 0x4c, 0xd0, 0xd3, 0x18,
	0x2a, 0x71, 0x4c, 0x23, 0x67, 0xd3, 0x44, 0xc2, 0xaa, 0x47, 0xaa, 0x63, 0x9e, 0x16, 0x8d, 0x4a,
	0xaf, 0x00, 0x7d, 0x18, 0x7b, 0x37, 0xb4, 0x7f, 0xb7, 0xc7, 0xdb, 0xbf, 0xc2, 0x58, 0x5b, 0x57,
	0xfa, 0x7d, 0x0e, 0x56, 0x3f, 0xd8, 0x04, 0xf4, 0x0d, 0xa0, 0x80, 0xe9, 0x1e, 0x40, 0x2f, 0x35,
	0x16, 0xb4, 0x17, 0x5c, 0x98, 0x66, 0xcc, 0x4c, 0x63, 0xe4, 0x69, 0xa5, 0x8e, 0xab, 0x70, 0x99,
	0xf4, 0x2c, 0x3c, 0x7f, 0x0d, 0xde, 0x4e, 0x1d, 0xfa, 0x9e, 0xbe, 0x84, 0x0b, 0xda, 0xa7, 0x17,
	0xb1, 0x7e, 0xe7, 0x69, 0x74, 0x71, 0xe4, 0x70, 0xad, 0x7d, 0x73, 0x07, 0xee, 0x7e, 0xa4, 0xb6,
	0xe9, 0x06, 0xcb, 0xad, 0xd7, 0x1a, 0x6e, 0xbd, 0xda, 0x29, 0x4e, 0x21, 0x80, 0xd9, 0x4e, 0xcb,
	0x3d, 0xfa, 0xfe, 0x5d, 0x31, 0xf7, 0x7a, 0x66, 0xbe, 0x50, 0x04, 0x77, 0xc5, 0xe3, 0x8c, 0x51,
	0x4f, 0x61, 0x15, 0x44, 0x94, 0x27, 0x6a, 0xf3, 0x5f, 0x39, 0xdd, 0x75, 0x8f, 0x15, 0x82, 0x09,
	0x2f, 0xb6, 0xeb, 0x8f, 0xfe, 0xfc, 0xff, 0xf8, 0xe8, 0x47, 0x1c, 0x96, 0x94, 0x17, 0xe3, 0x53,
	0x4a, 0x63, 0x12, 0x06, 0x67, 0x34, 0x7d, 0xaf, 0xbc, 0x9e, 0xa4, 0x68, 0xe7, 0x6f, 0x2e, 0x45,
	0x1e, 0x66, 0x4a, 0xe5, 0x4e, 0xb5, 0x75, 0xf9, 0xdb, 0x8b, 0x7f, 0x9d, 0x29, 0xba, 0x8b, 0x6a,
	0x6c, 0xf4, 0xec, 0x97, 0x70, 0xfb, 0xa6, 0x9b, 0x15, 0xcd, 0xc3, 0x4c, 0xf3, 0xa8, 0x59, 0x2f,
	0x4e, 0xa1, 0x65, 0x80, 0xc3, 0xe3, 0xce, 0x71, 0xe5, 0x00, 0x77, 0x0e, 0xda, 0xe6, 0x61, 0x38,
	0xd7, 0x68, 0xee, 0xd7, 0xdd, 0x46, 0xa7, 0xf8, 0x8f, 0xb9, 0xdd, 0xad, 0xbf, 0xbc, 0x7f, 0x94,
	0xfb, 0xeb, 0xfb, 0x47, 0xb9, 0xbf, 0xbd, 0x7f, 0x94, 0x3b, 0x29, 0xd9, 0x69, 0x06, 0x7c, 0x9b,
	0xc4, 0xc1, 0xf6, 0x95, 0x3f, 0xfc, 0xba, 0xb3, 0x26, 0xd6, 0x77, 0xfe, 0x1d, 0x00, 0x00, 0xff,
	0xff, 0xea, 0xf9, 0xf1, 0xea, 0x08, 0x14, 0x00, 0x00,
}

func (m *Tracing) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Tracing) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Tracing) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Tracer != nil {
		{
			size := m.Tracer.Size()
			i -= size
			if _, err := m.Tracer.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	if m.TlsSettings != nil {
		{
			size, err := m.TlsSettings.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintProxy(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x42
	}
	if m.Sampling != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.Sampling))))
		i--
		dAtA[i] = 0x39
	}
	if m.MaxPathTagLength != 0 {
		i = encodeVarintProxy(dAtA, i, uint64(m.MaxPathTagLength))
		i--
		dAtA[i] = 0x30
	}
	if len(m.CustomTags) > 0 {
		for k := range m.CustomTags {
			v := m.CustomTags[k]
			baseI := i
			if v != nil {
				{
					size, err := v.MarshalToSizedBuffer(dAtA[:i])
					if err != nil {
						return 0, err
					}
					i -= size
					i = encodeVarintProxy(dAtA, i, uint64(size))
				}
				i--
				dAtA[i] = 0x12
			}
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintProxy(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintProxy(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x2a
		}
	}
	return len(dAtA) - i, nil
}

func (m *Tracing_Zipkin_) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Tracing_Zipkin_) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Zipkin != nil {
		{
			size, err := m.Zipkin.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintProxy(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}
func (m *Tracing_Lightstep_) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Tracing_Lightstep_) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Lightstep != nil {
		{
			size, err := m.Lightstep.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintProxy(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	return len(dAtA) - i, nil
}
func (m *Tracing_Datadog_) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Tracing_Datadog_) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Datadog != nil {
		{
			size, err := m.Datadog.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintProxy(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	return len(dAtA) - i, nil
}
func (m *Tracing_Stackdriver_) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Tracing_Stackdriver_) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Stackdriver != nil {
		{
			size, err := m.Stackdriver.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintProxy(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	return len(dAtA) - i, nil
}
func (m *Tracing_OpenCensusAgent_) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Tracing_OpenCensusAgent_) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.OpenCensusAgent != nil {
		{
			size, err := m.OpenCensusAgent.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintProxy(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x4a
	}
	return len(dAtA) - i, nil
}
func (m *Tracing_Zipkin) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Tracing_Zipkin) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Tracing_Zipkin) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Address) > 0 {
		i -= len(m.Address)
		copy(dAtA[i:], m.Address)
		i = encodeVarintProxy(dAtA, i, uint64(len(m.Address)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Tracing_Lightstep) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Tracing_Lightstep) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Tracing_Lightstep) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.AccessToken) > 0 {
		i -= len(m.AccessToken)
		copy(dAtA[i:], m.AccessToken)
		i = encodeVarintProxy(dAtA, i, uint64(len(m.AccessToken)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Address) > 0 {
		i -= len(m.Address)
		copy(dAtA[i:], m.Address)
		i = encodeVarintProxy(dAtA, i, uint64(len(m.Address)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Tracing_Datadog) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Tracing_Datadog) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Tracing_Datadog) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Address) > 0 {
		i -= len(m.Address)
		copy(dAtA[i:], m.Address)
		i = encodeVarintProxy(dAtA, i, uint64(len(m.Address)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Tracing_Stackdriver) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Tracing_Stackdriver) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Tracing_Stackdriver) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.MaxNumberOfMessageEvents != nil {
		{
			size, err := m.MaxNumberOfMessageEvents.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintProxy(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if m.MaxNumberOfAnnotations != nil {
		{
			size, err := m.MaxNumberOfAnnotations.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintProxy(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.MaxNumberOfAttributes != nil {
		{
			size, err := m.MaxNumberOfAttributes.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintProxy(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Debug {
		i--
		if m.Debug {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *Tracing_OpenCensusAgent) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Tracing_OpenCensusAgent) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Tracing_OpenCensusAgent) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Context) > 0 {
		dAtA12 := make([]byte, len(m.Context)*10)
		var j11 int
		for _, num := range m.Context {
			for num >= 1<<7 {
				dAtA12[j11] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j11++
			}
			dAtA12[j11] = uint8(num)
			j11++
		}
		i -= j11
		copy(dAtA[i:], dAtA12[:j11])
		i = encodeVarintProxy(dAtA, i, uint64(j11))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Address) > 0 {
		i -= len(m.Address)
		copy(dAtA[i:], m.Address)
		i = encodeVarintProxy(dAtA, i, uint64(len(m.Address)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Tracing_CustomTag) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Tracing_CustomTag) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Tracing_CustomTag) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Type != nil {
		{
			size := m.Type.Size()
			i -= size
			if _, err := m.Type.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	return len(dAtA) - i, nil
}

func (m *Tracing_CustomTag_Literal) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Tracing_CustomTag_Literal) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Literal != nil {
		{
			size, err := m.Literal.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintProxy(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}
func (m *Tracing_CustomTag_Environment) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Tracing_CustomTag_Environment) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Environment != nil {
		{
			size, err := m.Environment.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintProxy(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	return len(dAtA) - i, nil
}
func (m *Tracing_CustomTag_Header) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Tracing_CustomTag_Header) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Header != nil {
		{
			size, err := m.Header.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintProxy(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	return len(dAtA) - i, nil
}
func (m *Tracing_Literal) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Tracing_Literal) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Tracing_Literal) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Value) > 0 {
		i -= len(m.Value)
		copy(dAtA[i:], m.Value)
		i = encodeVarintProxy(dAtA, i, uint64(len(m.Value)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Tracing_Environment) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Tracing_Environment) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Tracing_Environment) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.DefaultValue) > 0 {
		i -= len(m.DefaultValue)
		copy(dAtA[i:], m.DefaultValue)
		i = encodeVarintProxy(dAtA, i, uint64(len(m.DefaultValue)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintProxy(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Tracing_RequestHeader) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Tracing_RequestHeader) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Tracing_RequestHeader) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.DefaultValue) > 0 {
		i -= len(m.DefaultValue)
		copy(dAtA[i:], m.DefaultValue)
		i = encodeVarintProxy(dAtA, i, uint64(len(m.DefaultValue)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintProxy(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *SDS) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SDS) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SDS) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.K8SSaJwtPath) > 0 {
		i -= len(m.K8SSaJwtPath)
		copy(dAtA[i:], m.K8SSaJwtPath)
		i = encodeVarintProxy(dAtA, i, uint64(len(m.K8SSaJwtPath)))
		i--
		dAtA[i] = 0x12
	}
	if m.Enabled {
		i--
		if m.Enabled {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *Topology) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Topology) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Topology) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.ForwardClientCertDetails != 0 {
		i = encodeVarintProxy(dAtA, i, uint64(m.ForwardClientCertDetails))
		i--
		dAtA[i] = 0x10
	}
	if m.NumTrustedProxies != 0 {
		i = encodeVarintProxy(dAtA, i, uint64(m.NumTrustedProxies))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *ProxyConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ProxyConfig) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ProxyConfig) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.CaCertificatesPem) > 0 {
		for iNdEx := len(m.CaCertificatesPem) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.CaCertificatesPem[iNdEx])
			copy(dAtA[i:], m.CaCertificatesPem[iNdEx])
			i = encodeVarintProxy(dAtA, i, uint64(len(m.CaCertificatesPem[iNdEx])))
			i--
			dAtA[i] = 0x2
			i--
			dAtA[i] = 0x92
		}
	}
	if m.HoldApplicationUntilProxyStarts != nil {
		{
			size, err := m.HoldApplicationUntilProxyStarts.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintProxy(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0x8a
	}
	if m.ProxyStatsMatcher != nil {
		{
			size, err := m.ProxyStatsMatcher.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintProxy(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0x82
	}
	if m.ReadinessProbe != nil {
		{
			size, err := m.ReadinessProbe.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintProxy(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xfa
	}
	if len(m.MeshId) > 0 {
		i -= len(m.MeshId)
		copy(dAtA[i:], m.MeshId)
		i = encodeVarintProxy(dAtA, i, uint64(len(m.MeshId)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xf2
	}
	if m.TerminationDrainDuration != nil {
		{
			size, err := m.TerminationDrainDuration.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintProxy(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xea
	}
	if m.GatewayTopology != nil {
		{
			size, err := m.GatewayTopology.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintProxy(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xe2
	}
	if len(m.ExtraStatTags) > 0 {
		for iNdEx := len(m.ExtraStatTags) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.ExtraStatTags[iNdEx])
			copy(dAtA[i:], m.ExtraStatTags[iNdEx])
			i = encodeVarintProxy(dAtA, i, uint64(len(m.ExtraStatTags[iNdEx])))
			i--
			dAtA[i] = 0x1
			i--
			dAtA[i] = 0xda
		}
	}
	if m.StatusPort != 0 {
		i = encodeVarintProxy(dAtA, i, uint64(m.StatusPort))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xd0
	}
	if len(m.ProxyMetadata) > 0 {
		for k := range m.ProxyMetadata {
			v := m.ProxyMetadata[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintProxy(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintProxy(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintProxy(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x1
			i--
			dAtA[i] = 0xc2
		}
	}
	if m.EnvoyMetricsService != nil {
		{
			size, err := m.EnvoyMetricsService.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintProxy(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xba
	}
	if m.EnvoyAccessLogService != nil {
		{
			size, err := m.EnvoyAccessLogService.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintProxy(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xb2
	}
	if m.Sds != nil {
		{
			size, err := m.Sds.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintProxy(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xaa
	}
	if len(m.EnvoyMetricsServiceAddress) > 0 {
		i -= len(m.EnvoyMetricsServiceAddress)
		copy(dAtA[i:], m.EnvoyMetricsServiceAddress)
		i = encodeVarintProxy(dAtA, i, uint64(len(m.EnvoyMetricsServiceAddress)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xa2
	}
	if m.Tracing != nil {
		{
			size, err := m.Tracing.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintProxy(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x9a
	}
	if m.InterceptionMode != 0 {
		i = encodeVarintProxy(dAtA, i, uint64(m.InterceptionMode))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x90
	}
	if len(m.ProxyBootstrapTemplatePath) > 0 {
		i -= len(m.ProxyBootstrapTemplatePath)
		copy(dAtA[i:], m.ProxyBootstrapTemplatePath)
		i = encodeVarintProxy(dAtA, i, uint64(len(m.ProxyBootstrapTemplatePath)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x8a
	}
	if m.Concurrency != nil {
		{
			size, err := m.Concurrency.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintProxy(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x82
	}
	if m.StatNameLength != 0 {
		i = encodeVarintProxy(dAtA, i, uint64(m.StatNameLength))
		i--
		dAtA[i] = 0x78
	}
	if len(m.CustomConfigFile) > 0 {
		i -= len(m.CustomConfigFile)
		copy(dAtA[i:], m.CustomConfigFile)
		i = encodeVarintProxy(dAtA, i, uint64(len(m.CustomConfigFile)))
		i--
		dAtA[i] = 0x72
	}
	if m.ControlPlaneAuthPolicy != 0 {
		i = encodeVarintProxy(dAtA, i, uint64(m.ControlPlaneAuthPolicy))
		i--
		dAtA[i] = 0x68
	}
	if len(m.AvailabilityZone) > 0 {
		i -= len(m.AvailabilityZone)
		copy(dAtA[i:], m.AvailabilityZone)
		i = encodeVarintProxy(dAtA, i, uint64(len(m.AvailabilityZone)))
		i--
		dAtA[i] = 0x62
	}
	if m.ProxyAdminPort != 0 {
		i = encodeVarintProxy(dAtA, i, uint64(m.ProxyAdminPort))
		i--
		dAtA[i] = 0x58
	}
	if len(m.StatsdUdpAddress) > 0 {
		i -= len(m.StatsdUdpAddress)
		copy(dAtA[i:], m.StatsdUdpAddress)
		i = encodeVarintProxy(dAtA, i, uint64(len(m.StatsdUdpAddress)))
		i--
		dAtA[i] = 0x52
	}
	if len(m.ZipkinAddress) > 0 {
		i -= len(m.ZipkinAddress)
		copy(dAtA[i:], m.ZipkinAddress)
		i = encodeVarintProxy(dAtA, i, uint64(len(m.ZipkinAddress)))
		i--
		dAtA[i] = 0x42
	}
	if m.DiscoveryRefreshDelay != nil {
		{
			size, err := m.DiscoveryRefreshDelay.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintProxy(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	if len(m.DiscoveryAddress) > 0 {
		i -= len(m.DiscoveryAddress)
		copy(dAtA[i:], m.DiscoveryAddress)
		i = encodeVarintProxy(dAtA, i, uint64(len(m.DiscoveryAddress)))
		i--
		dAtA[i] = 0x32
	}
	if m.ParentShutdownDuration != nil {
		{
			size, err := m.ParentShutdownDuration.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintProxy(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if m.DrainDuration != nil {
		{
			size, err := m.DrainDuration.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintProxy(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if len(m.ServiceCluster) > 0 {
		i -= len(m.ServiceCluster)
		copy(dAtA[i:], m.ServiceCluster)
		i = encodeVarintProxy(dAtA, i, uint64(len(m.ServiceCluster)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.BinaryPath) > 0 {
		i -= len(m.BinaryPath)
		copy(dAtA[i:], m.BinaryPath)
		i = encodeVarintProxy(dAtA, i, uint64(len(m.BinaryPath)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.ConfigPath) > 0 {
		i -= len(m.ConfigPath)
		copy(dAtA[i:], m.ConfigPath)
		i = encodeVarintProxy(dAtA, i, uint64(len(m.ConfigPath)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ProxyConfig_ProxyStatsMatcher) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ProxyConfig_ProxyStatsMatcher) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ProxyConfig_ProxyStatsMatcher) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.InclusionRegexps) > 0 {
		for iNdEx := len(m.InclusionRegexps) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.InclusionRegexps[iNdEx])
			copy(dAtA[i:], m.InclusionRegexps[iNdEx])
			i = encodeVarintProxy(dAtA, i, uint64(len(m.InclusionRegexps[iNdEx])))
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.InclusionSuffixes) > 0 {
		for iNdEx := len(m.InclusionSuffixes) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.InclusionSuffixes[iNdEx])
			copy(dAtA[i:], m.InclusionSuffixes[iNdEx])
			i = encodeVarintProxy(dAtA, i, uint64(len(m.InclusionSuffixes[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.InclusionPrefixes) > 0 {
		for iNdEx := len(m.InclusionPrefixes) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.InclusionPrefixes[iNdEx])
			copy(dAtA[i:], m.InclusionPrefixes[iNdEx])
			i = encodeVarintProxy(dAtA, i, uint64(len(m.InclusionPrefixes[iNdEx])))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *RemoteService) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RemoteService) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RemoteService) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.TcpKeepalive != nil {
		{
			size, err := m.TcpKeepalive.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintProxy(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.TlsSettings != nil {
		{
			size, err := m.TlsSettings.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintProxy(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.Address) > 0 {
		i -= len(m.Address)
		copy(dAtA[i:], m.Address)
		i = encodeVarintProxy(dAtA, i, uint64(len(m.Address)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintProxy(dAtA []byte, offset int, v uint64) int {
	offset -= sovProxy(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *Tracing) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Tracer != nil {
		n += m.Tracer.Size()
	}
	if len(m.CustomTags) > 0 {
		for k, v := range m.CustomTags {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovProxy(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovProxy(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovProxy(uint64(mapEntrySize))
		}
	}
	if m.MaxPathTagLength != 0 {
		n += 1 + sovProxy(uint64(m.MaxPathTagLength))
	}
	if m.Sampling != 0 {
		n += 9
	}
	if m.TlsSettings != nil {
		l = m.TlsSettings.Size()
		n += 1 + l + sovProxy(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Tracing_Zipkin_) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Zipkin != nil {
		l = m.Zipkin.Size()
		n += 1 + l + sovProxy(uint64(l))
	}
	return n
}
func (m *Tracing_Lightstep_) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Lightstep != nil {
		l = m.Lightstep.Size()
		n += 1 + l + sovProxy(uint64(l))
	}
	return n
}
func (m *Tracing_Datadog_) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Datadog != nil {
		l = m.Datadog.Size()
		n += 1 + l + sovProxy(uint64(l))
	}
	return n
}
func (m *Tracing_Stackdriver_) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Stackdriver != nil {
		l = m.Stackdriver.Size()
		n += 1 + l + sovProxy(uint64(l))
	}
	return n
}
func (m *Tracing_OpenCensusAgent_) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.OpenCensusAgent != nil {
		l = m.OpenCensusAgent.Size()
		n += 1 + l + sovProxy(uint64(l))
	}
	return n
}
func (m *Tracing_Zipkin) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Address)
	if l > 0 {
		n += 1 + l + sovProxy(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Tracing_Lightstep) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Address)
	if l > 0 {
		n += 1 + l + sovProxy(uint64(l))
	}
	l = len(m.AccessToken)
	if l > 0 {
		n += 1 + l + sovProxy(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Tracing_Datadog) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Address)
	if l > 0 {
		n += 1 + l + sovProxy(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Tracing_Stackdriver) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Debug {
		n += 2
	}
	if m.MaxNumberOfAttributes != nil {
		l = m.MaxNumberOfAttributes.Size()
		n += 1 + l + sovProxy(uint64(l))
	}
	if m.MaxNumberOfAnnotations != nil {
		l = m.MaxNumberOfAnnotations.Size()
		n += 1 + l + sovProxy(uint64(l))
	}
	if m.MaxNumberOfMessageEvents != nil {
		l = m.MaxNumberOfMessageEvents.Size()
		n += 1 + l + sovProxy(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Tracing_OpenCensusAgent) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Address)
	if l > 0 {
		n += 1 + l + sovProxy(uint64(l))
	}
	if len(m.Context) > 0 {
		l = 0
		for _, e := range m.Context {
			l += sovProxy(uint64(e))
		}
		n += 1 + sovProxy(uint64(l)) + l
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Tracing_CustomTag) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Type != nil {
		n += m.Type.Size()
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Tracing_CustomTag_Literal) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Literal != nil {
		l = m.Literal.Size()
		n += 1 + l + sovProxy(uint64(l))
	}
	return n
}
func (m *Tracing_CustomTag_Environment) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Environment != nil {
		l = m.Environment.Size()
		n += 1 + l + sovProxy(uint64(l))
	}
	return n
}
func (m *Tracing_CustomTag_Header) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Header != nil {
		l = m.Header.Size()
		n += 1 + l + sovProxy(uint64(l))
	}
	return n
}
func (m *Tracing_Literal) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Value)
	if l > 0 {
		n += 1 + l + sovProxy(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Tracing_Environment) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovProxy(uint64(l))
	}
	l = len(m.DefaultValue)
	if l > 0 {
		n += 1 + l + sovProxy(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Tracing_RequestHeader) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovProxy(uint64(l))
	}
	l = len(m.DefaultValue)
	if l > 0 {
		n += 1 + l + sovProxy(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *SDS) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Enabled {
		n += 2
	}
	l = len(m.K8SSaJwtPath)
	if l > 0 {
		n += 1 + l + sovProxy(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Topology) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.NumTrustedProxies != 0 {
		n += 1 + sovProxy(uint64(m.NumTrustedProxies))
	}
	if m.ForwardClientCertDetails != 0 {
		n += 1 + sovProxy(uint64(m.ForwardClientCertDetails))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ProxyConfig) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ConfigPath)
	if l > 0 {
		n += 1 + l + sovProxy(uint64(l))
	}
	l = len(m.BinaryPath)
	if l > 0 {
		n += 1 + l + sovProxy(uint64(l))
	}
	l = len(m.ServiceCluster)
	if l > 0 {
		n += 1 + l + sovProxy(uint64(l))
	}
	if m.DrainDuration != nil {
		l = m.DrainDuration.Size()
		n += 1 + l + sovProxy(uint64(l))
	}
	if m.ParentShutdownDuration != nil {
		l = m.ParentShutdownDuration.Size()
		n += 1 + l + sovProxy(uint64(l))
	}
	l = len(m.DiscoveryAddress)
	if l > 0 {
		n += 1 + l + sovProxy(uint64(l))
	}
	if m.DiscoveryRefreshDelay != nil {
		l = m.DiscoveryRefreshDelay.Size()
		n += 1 + l + sovProxy(uint64(l))
	}
	l = len(m.ZipkinAddress)
	if l > 0 {
		n += 1 + l + sovProxy(uint64(l))
	}
	l = len(m.StatsdUdpAddress)
	if l > 0 {
		n += 1 + l + sovProxy(uint64(l))
	}
	if m.ProxyAdminPort != 0 {
		n += 1 + sovProxy(uint64(m.ProxyAdminPort))
	}
	l = len(m.AvailabilityZone)
	if l > 0 {
		n += 1 + l + sovProxy(uint64(l))
	}
	if m.ControlPlaneAuthPolicy != 0 {
		n += 1 + sovProxy(uint64(m.ControlPlaneAuthPolicy))
	}
	l = len(m.CustomConfigFile)
	if l > 0 {
		n += 1 + l + sovProxy(uint64(l))
	}
	if m.StatNameLength != 0 {
		n += 1 + sovProxy(uint64(m.StatNameLength))
	}
	if m.Concurrency != nil {
		l = m.Concurrency.Size()
		n += 2 + l + sovProxy(uint64(l))
	}
	l = len(m.ProxyBootstrapTemplatePath)
	if l > 0 {
		n += 2 + l + sovProxy(uint64(l))
	}
	if m.InterceptionMode != 0 {
		n += 2 + sovProxy(uint64(m.InterceptionMode))
	}
	if m.Tracing != nil {
		l = m.Tracing.Size()
		n += 2 + l + sovProxy(uint64(l))
	}
	l = len(m.EnvoyMetricsServiceAddress)
	if l > 0 {
		n += 2 + l + sovProxy(uint64(l))
	}
	if m.Sds != nil {
		l = m.Sds.Size()
		n += 2 + l + sovProxy(uint64(l))
	}
	if m.EnvoyAccessLogService != nil {
		l = m.EnvoyAccessLogService.Size()
		n += 2 + l + sovProxy(uint64(l))
	}
	if m.EnvoyMetricsService != nil {
		l = m.EnvoyMetricsService.Size()
		n += 2 + l + sovProxy(uint64(l))
	}
	if len(m.ProxyMetadata) > 0 {
		for k, v := range m.ProxyMetadata {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovProxy(uint64(len(k))) + 1 + len(v) + sovProxy(uint64(len(v)))
			n += mapEntrySize + 2 + sovProxy(uint64(mapEntrySize))
		}
	}
	if m.StatusPort != 0 {
		n += 2 + sovProxy(uint64(m.StatusPort))
	}
	if len(m.ExtraStatTags) > 0 {
		for _, s := range m.ExtraStatTags {
			l = len(s)
			n += 2 + l + sovProxy(uint64(l))
		}
	}
	if m.GatewayTopology != nil {
		l = m.GatewayTopology.Size()
		n += 2 + l + sovProxy(uint64(l))
	}
	if m.TerminationDrainDuration != nil {
		l = m.TerminationDrainDuration.Size()
		n += 2 + l + sovProxy(uint64(l))
	}
	l = len(m.MeshId)
	if l > 0 {
		n += 2 + l + sovProxy(uint64(l))
	}
	if m.ReadinessProbe != nil {
		l = m.ReadinessProbe.Size()
		n += 2 + l + sovProxy(uint64(l))
	}
	if m.ProxyStatsMatcher != nil {
		l = m.ProxyStatsMatcher.Size()
		n += 2 + l + sovProxy(uint64(l))
	}
	if m.HoldApplicationUntilProxyStarts != nil {
		l = m.HoldApplicationUntilProxyStarts.Size()
		n += 2 + l + sovProxy(uint64(l))
	}
	if len(m.CaCertificatesPem) > 0 {
		for _, s := range m.CaCertificatesPem {
			l = len(s)
			n += 2 + l + sovProxy(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ProxyConfig_ProxyStatsMatcher) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.InclusionPrefixes) > 0 {
		for _, s := range m.InclusionPrefixes {
			l = len(s)
			n += 1 + l + sovProxy(uint64(l))
		}
	}
	if len(m.InclusionSuffixes) > 0 {
		for _, s := range m.InclusionSuffixes {
			l = len(s)
			n += 1 + l + sovProxy(uint64(l))
		}
	}
	if len(m.InclusionRegexps) > 0 {
		for _, s := range m.InclusionRegexps {
			l = len(s)
			n += 1 + l + sovProxy(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RemoteService) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Address)
	if l > 0 {
		n += 1 + l + sovProxy(uint64(l))
	}
	if m.TlsSettings != nil {
		l = m.TlsSettings.Size()
		n += 1 + l + sovProxy(uint64(l))
	}
	if m.TcpKeepalive != nil {
		l = m.TcpKeepalive.Size()
		n += 1 + l + sovProxy(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovProxy(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozProxy(x uint64) (n int) {
	return sovProxy(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *Tracing) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProxy
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Tracing: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Tracing: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Zipkin", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProxy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Tracing_Zipkin{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Tracer = &Tracing_Zipkin_{v}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Lightstep", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProxy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Tracing_Lightstep{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Tracer = &Tracing_Lightstep_{v}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Datadog", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProxy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Tracing_Datadog{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Tracer = &Tracing_Datadog_{v}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Stackdriver", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProxy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Tracing_Stackdriver{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Tracer = &Tracing_Stackdriver_{v}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CustomTags", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProxy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CustomTags == nil {
				m.CustomTags = make(map[string]*Tracing_CustomTag)
			}
			var mapkey string
			var mapvalue *Tracing_CustomTag
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowProxy
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowProxy
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthProxy
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthProxy
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowProxy
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthProxy
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthProxy
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &Tracing_CustomTag{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipProxy(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthProxy
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.CustomTags[mapkey] = mapvalue
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxPathTagLength", wireType)
			}
			m.MaxPathTagLength = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaxPathTagLength |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field Sampling", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.Sampling = float64(math.Float64frombits(v))
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TlsSettings", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProxy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TlsSettings == nil {
				m.TlsSettings = &v1alpha3.ClientTLSSettings{}
			}
			if err := m.TlsSettings.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OpenCensusAgent", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProxy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Tracing_OpenCensusAgent{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Tracer = &Tracing_OpenCensusAgent_{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProxy(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProxy
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Tracing_Zipkin) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProxy
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Zipkin: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Zipkin: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Address", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProxy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Address = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProxy(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProxy
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Tracing_Lightstep) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProxy
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Lightstep: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Lightstep: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Address", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProxy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Address = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AccessToken", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProxy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AccessToken = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProxy(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProxy
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Tracing_Datadog) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProxy
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Datadog: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Datadog: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Address", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProxy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Address = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProxy(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProxy
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Tracing_Stackdriver) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProxy
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Stackdriver: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Stackdriver: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Debug", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Debug = bool(v != 0)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxNumberOfAttributes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProxy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MaxNumberOfAttributes == nil {
				m.MaxNumberOfAttributes = &types.Int64Value{}
			}
			if err := m.MaxNumberOfAttributes.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxNumberOfAnnotations", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProxy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MaxNumberOfAnnotations == nil {
				m.MaxNumberOfAnnotations = &types.Int64Value{}
			}
			if err := m.MaxNumberOfAnnotations.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxNumberOfMessageEvents", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProxy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MaxNumberOfMessageEvents == nil {
				m.MaxNumberOfMessageEvents = &types.Int64Value{}
			}
			if err := m.MaxNumberOfMessageEvents.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProxy(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProxy
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Tracing_OpenCensusAgent) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProxy
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: OpenCensusAgent: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: OpenCensusAgent: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Address", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProxy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Address = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType == 0 {
				var v Tracing_OpenCensusAgent_TraceContext
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowProxy
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= Tracing_OpenCensusAgent_TraceContext(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.Context = append(m.Context, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowProxy
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthProxy
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthProxy
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				if elementCount != 0 && len(m.Context) == 0 {
					m.Context = make([]Tracing_OpenCensusAgent_TraceContext, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v Tracing_OpenCensusAgent_TraceContext
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowProxy
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= Tracing_OpenCensusAgent_TraceContext(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.Context = append(m.Context, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Context", wireType)
			}
		default:
			iNdEx = preIndex
			skippy, err := skipProxy(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProxy
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Tracing_CustomTag) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProxy
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CustomTag: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CustomTag: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Literal", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProxy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Tracing_Literal{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Type = &Tracing_CustomTag_Literal{v}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Environment", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProxy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Tracing_Environment{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Type = &Tracing_CustomTag_Environment{v}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Header", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProxy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Tracing_RequestHeader{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Type = &Tracing_CustomTag_Header{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProxy(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProxy
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Tracing_Literal) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProxy
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Literal: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Literal: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProxy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProxy(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProxy
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Tracing_Environment) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProxy
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Environment: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Environment: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProxy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DefaultValue", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProxy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DefaultValue = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProxy(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProxy
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Tracing_RequestHeader) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProxy
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RequestHeader: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RequestHeader: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProxy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DefaultValue", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProxy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DefaultValue = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProxy(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProxy
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SDS) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProxy
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SDS: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SDS: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Enabled", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Enabled = bool(v != 0)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field K8SSaJwtPath", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProxy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.K8SSaJwtPath = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProxy(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProxy
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Topology) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProxy
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Topology: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Topology: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NumTrustedProxies", wireType)
			}
			m.NumTrustedProxies = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NumTrustedProxies |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ForwardClientCertDetails", wireType)
			}
			m.ForwardClientCertDetails = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ForwardClientCertDetails |= Topology_ForwardClientCertDetails(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipProxy(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProxy
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ProxyConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProxy
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ProxyConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ProxyConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConfigPath", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProxy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ConfigPath = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BinaryPath", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProxy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.BinaryPath = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ServiceCluster", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProxy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ServiceCluster = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DrainDuration", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProxy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DrainDuration == nil {
				m.DrainDuration = &types.Duration{}
			}
			if err := m.DrainDuration.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ParentShutdownDuration", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProxy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ParentShutdownDuration == nil {
				m.ParentShutdownDuration = &types.Duration{}
			}
			if err := m.ParentShutdownDuration.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DiscoveryAddress", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProxy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DiscoveryAddress = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DiscoveryRefreshDelay", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProxy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DiscoveryRefreshDelay == nil {
				m.DiscoveryRefreshDelay = &types.Duration{}
			}
			if err := m.DiscoveryRefreshDelay.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ZipkinAddress", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProxy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ZipkinAddress = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StatsdUdpAddress", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProxy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StatsdUdpAddress = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProxyAdminPort", wireType)
			}
			m.ProxyAdminPort = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ProxyAdminPort |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AvailabilityZone", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProxy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AvailabilityZone = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 13:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ControlPlaneAuthPolicy", wireType)
			}
			m.ControlPlaneAuthPolicy = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ControlPlaneAuthPolicy |= AuthenticationPolicy(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CustomConfigFile", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProxy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CustomConfigFile = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 15:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StatNameLength", wireType)
			}
			m.StatNameLength = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StatNameLength |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 16:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Concurrency", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProxy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Concurrency == nil {
				m.Concurrency = &types.Int32Value{}
			}
			if err := m.Concurrency.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 17:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProxyBootstrapTemplatePath", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProxy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ProxyBootstrapTemplatePath = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 18:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field InterceptionMode", wireType)
			}
			m.InterceptionMode = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.InterceptionMode |= ProxyConfig_InboundInterceptionMode(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 19:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tracing", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProxy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Tracing == nil {
				m.Tracing = &Tracing{}
			}
			if err := m.Tracing.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 20:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EnvoyMetricsServiceAddress", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProxy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EnvoyMetricsServiceAddress = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 21:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Sds", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProxy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Sds == nil {
				m.Sds = &SDS{}
			}
			if err := m.Sds.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 22:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EnvoyAccessLogService", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProxy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.EnvoyAccessLogService == nil {
				m.EnvoyAccessLogService = &RemoteService{}
			}
			if err := m.EnvoyAccessLogService.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 23:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EnvoyMetricsService", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProxy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.EnvoyMetricsService == nil {
				m.EnvoyMetricsService = &RemoteService{}
			}
			if err := m.EnvoyMetricsService.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 24:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProxyMetadata", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProxy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ProxyMetadata == nil {
				m.ProxyMetadata = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowProxy
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowProxy
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthProxy
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthProxy
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowProxy
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthProxy
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthProxy
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipProxy(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthProxy
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.ProxyMetadata[mapkey] = mapvalue
			iNdEx = postIndex
		case 26:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StatusPort", wireType)
			}
			m.StatusPort = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StatusPort |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 27:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExtraStatTags", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProxy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ExtraStatTags = append(m.ExtraStatTags, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 28:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GatewayTopology", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProxy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.GatewayTopology == nil {
				m.GatewayTopology = &Topology{}
			}
			if err := m.GatewayTopology.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 29:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TerminationDrainDuration", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProxy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TerminationDrainDuration == nil {
				m.TerminationDrainDuration = &types.Duration{}
			}
			if err := m.TerminationDrainDuration.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 30:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MeshId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProxy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.MeshId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 31:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReadinessProbe", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProxy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ReadinessProbe == nil {
				m.ReadinessProbe = &v1alpha3.ReadinessProbe{}
			}
			if err := m.ReadinessProbe.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 32:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProxyStatsMatcher", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProxy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ProxyStatsMatcher == nil {
				m.ProxyStatsMatcher = &ProxyConfig_ProxyStatsMatcher{}
			}
			if err := m.ProxyStatsMatcher.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 33:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HoldApplicationUntilProxyStarts", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProxy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.HoldApplicationUntilProxyStarts == nil {
				m.HoldApplicationUntilProxyStarts = &types.BoolValue{}
			}
			if err := m.HoldApplicationUntilProxyStarts.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 34:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CaCertificatesPem", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProxy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CaCertificatesPem = append(m.CaCertificatesPem, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProxy(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProxy
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ProxyConfig_ProxyStatsMatcher) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProxy
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ProxyStatsMatcher: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ProxyStatsMatcher: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field InclusionPrefixes", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProxy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.InclusionPrefixes = append(m.InclusionPrefixes, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field InclusionSuffixes", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProxy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.InclusionSuffixes = append(m.InclusionSuffixes, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field InclusionRegexps", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProxy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.InclusionRegexps = append(m.InclusionRegexps, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProxy(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProxy
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RemoteService) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProxy
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RemoteService: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RemoteService: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Address", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProxy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Address = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TlsSettings", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProxy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TlsSettings == nil {
				m.TlsSettings = &v1alpha3.ClientTLSSettings{}
			}
			if err := m.TlsSettings.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TcpKeepalive", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProxy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProxy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TcpKeepalive == nil {
				m.TcpKeepalive = &v1alpha3.ConnectionPoolSettings_TCPSettings_TcpKeepalive{}
			}
			if err := m.TcpKeepalive.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProxy(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProxy
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipProxy(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowProxy
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowProxy
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthProxy
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupProxy
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthProxy
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthProxy        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowProxy          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupProxy = fmt.Errorf("proto: unexpected end of group")
)
