// Copyright 2020 Istio Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Configuration affecting Istio control plane installation version and shape.

package v1alpha1

import (
	"fmt"
	"math"

	"github.com/gogo/protobuf/proto"
)

// Reference imports to suppress errors if they are not otherwise used.
var (
	_ = proto.Marshal
	_ = fmt.Errorf
	_ = math.Inf
)

// DeepCopyInto supports using IstioOperatorSpec within kubernetes types, where deepcopy-gen is used.
func (in *IstioOperatorSpec) DeepCopyInto(out *IstioOperatorSpec) {
	p := proto.Clone(in).(*IstioOperatorSpec)
	*out = *p
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new IstioOperatorSpec. Required by controller-gen.
func (in *IstioOperatorSpec) DeepCopy() *IstioOperatorSpec {
	if in == nil {
		return nil
	}
	out := new(IstioOperatorSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto supports using InstallStatus within kubernetes types, where deepcopy-gen is used.
func (in *InstallStatus) DeepCopyInto(out *InstallStatus) {
	p := proto.Clone(in).(*InstallStatus)
	*out = *p
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new InstallStatus. Required by controller-gen.
func (in *InstallStatus) DeepCopy() *InstallStatus {
	if in == nil {
		return nil
	}
	out := new(InstallStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto supports using InstallStatus_VersionStatus within kubernetes types, where deepcopy-gen is used.
func (in *InstallStatus_VersionStatus) DeepCopyInto(out *InstallStatus_VersionStatus) {
	p := proto.Clone(in).(*InstallStatus_VersionStatus)
	*out = *p
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new InstallStatus_VersionStatus. Required by controller-gen.
func (in *InstallStatus_VersionStatus) DeepCopy() *InstallStatus_VersionStatus {
	if in == nil {
		return nil
	}
	out := new(InstallStatus_VersionStatus)
	in.DeepCopyInto(out)
	return out
}
