// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: operator/v1alpha1/operator.proto

// Configuration affecting Istio control plane installation version and shape.

package v1alpha1

import (
	fmt "fmt"
	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	types "github.com/gogo/protobuf/types"
	v1 "k8s.io/api/core/v1"
	v11 "k8s.io/apimachinery/pkg/apis/meta/v1"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

// Status describes the current state of a component.
type InstallStatus_Status int32

const (
	// Component is not present.
	InstallStatus_NONE InstallStatus_Status = 0
	// Component is being updated to a different version.
	InstallStatus_UPDATING InstallStatus_Status = 1
	// Controller has started but not yet completed reconciliation loop for the component.
	InstallStatus_RECONCILING InstallStatus_Status = 2
	// Component is healthy.
	InstallStatus_HEALTHY InstallStatus_Status = 3
	// Component is in an error state.
	InstallStatus_ERROR InstallStatus_Status = 4
	// Overall status only and would not be set as a component status.
	// Action is needed from the user for reconciliation to proceed
	// e.g. There are proxies still pointing to the control plane revision when try to remove an `IstioOperator` CR.
	InstallStatus_ACTION_REQUIRED InstallStatus_Status = 5
)

var InstallStatus_Status_name = map[int32]string{
	0: "NONE",
	1: "UPDATING",
	2: "RECONCILING",
	3: "HEALTHY",
	4: "ERROR",
	5: "ACTION_REQUIRED",
}

var InstallStatus_Status_value = map[string]int32{
	"NONE":            0,
	"UPDATING":        1,
	"RECONCILING":     2,
	"HEALTHY":         3,
	"ERROR":           4,
	"ACTION_REQUIRED": 5,
}

func (x InstallStatus_Status) String() string {
	return proto.EnumName(InstallStatus_Status_name, int32(x))
}

func (InstallStatus_Status) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_8023ebf2dcfea843, []int{1, 0}
}

// IstioOperatorSpec defines the desired installed state of Istio components.
// The spec is a used to define a customization of the default profile values that are supplied with each Istio release.
// Because the spec is a customization API, specifying an empty IstioOperatorSpec results in a default Istio
// component values.
//
// ```yaml
// apiVersion: install.istio.io/v1alpha1
// kind: IstioOperator
// spec:
//   profile: default
//   hub: gcr.io/istio-testing
//   tag: latest
//   revision: 1-8-0
//   meshConfig:
//     accessLogFile: /dev/stdout
//     enableTracing: true
//   components:
//     egressGateways:
//     - name: istio-egressgateway
//       enabled: true
// ```
//
type IstioOperatorSpec struct {
	// Path or name for the profile e.g.
	//
	// * minimal (looks in profiles dir for a file called minimal.yaml)
	// * /tmp/istio/install/values/custom/custom-install.yaml (local file path)
	//
	// default profile is used if this field is unset.
	Profile string `protobuf:"bytes,10,opt,name=profile,proto3" json:"profile,omitempty"`
	// Path for the install package. e.g.
	//
	// * /tmp/istio-installer/nightly (local file path)
	//
	InstallPackagePath string `protobuf:"bytes,11,opt,name=install_package_path,json=installPackagePath,proto3" json:"installPackagePath,omitempty"`
	// Root for docker image paths e.g. `docker.io/istio`
	Hub string `protobuf:"bytes,12,opt,name=hub,proto3" json:"hub,omitempty"`
	// Version tag for docker images e.g. `1.7.2`
	Tag interface{} `protobuf:"bytes,13,opt,name=tag,proto3" json:"tag,omitempty"`
	// $hide_from_docs
	// Resource suffix is appended to all resources installed by each component.
	// Never implemented; replaced by revision.
	ResourceSuffix string `protobuf:"bytes,14,opt,name=resource_suffix,json=resourceSuffix,proto3" json:"resourceSuffix,omitempty"` // Deprecated: Do not use.
	// Namespace to install control plane resources into. If unset, Istio will be installed into the same namespace
	// as the `IstioOperator` CR. You must also set `values.global.istioNamespace` if you wish to install Istio in
	// a custom namespace.
	// If you have enabled CNI, you must  exclude this namespace by adding it to the list `values.cni.excludeNamespaces`.
	Namespace string `protobuf:"bytes,15,opt,name=namespace,proto3" json:"namespace,omitempty"`
	// Identify the revision this installation is associated with.
	// This option is currently experimental.
	Revision string `protobuf:"bytes,16,opt,name=revision,proto3" json:"revision,omitempty"`
	// Identify whether this revision is the default revision for the cluster
	// This option is currently experimental.
	DefaultRevision bool `protobuf:"varint,17,opt,name=default_revision,json=defaultRevision,proto3" json:"defaultRevision,omitempty"`
	// Config used by control plane components internally.
	MeshConfig map[string]interface{} `protobuf:"bytes,40,opt,name=mesh_config,json=meshConfig,proto3" json:"meshConfig,omitempty"`
	// Kubernetes resource settings, enablement and component-specific settings that are not internal to the
	// component.
	Components *IstioComponentSetSpec `protobuf:"bytes,50,opt,name=components,proto3" json:"components,omitempty"`
	// Deprecated.
	// Users should manage the installation of addon components on their own.
	// Refer to samples/addons for demo installation of addon components.
	AddonComponents map[string]*ExternalComponentSpec `protobuf:"bytes,51,rep,name=addon_components,json=addonComponents,proto3" json:"addonComponents,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"` // Deprecated: Do not use.
	// Overrides for default `values.yaml`. This is a validated pass-through to Helm templates.
	// See the [Helm installation options](https://istio.io/v1.5/docs/reference/config/installation-options/) for schema details.
	// Anything that is available in `IstioOperatorSpec` should be set above rather than using the passthrough. This
	// includes Kubernetes resource settings for components in `KubernetesResourcesSpec`.
	Values map[string]interface{} `protobuf:"bytes,100,opt,name=values,proto3" json:"values,omitempty"`
	// Unvalidated overrides for default `values.yaml`. Used for custom templates where new parameters are added.
	UnvalidatedValues    map[string]interface{} `protobuf:"bytes,101,opt,name=unvalidated_values,json=unvalidatedValues,proto3" json:"unvalidatedValues,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *IstioOperatorSpec) Reset()         { *m = IstioOperatorSpec{} }
func (m *IstioOperatorSpec) String() string { return proto.CompactTextString(m) }
func (*IstioOperatorSpec) ProtoMessage()    {}
func (*IstioOperatorSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_8023ebf2dcfea843, []int{0}
}
func (m *IstioOperatorSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_IstioOperatorSpec.Unmarshal(m, b)
}
func (m *IstioOperatorSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_IstioOperatorSpec.Marshal(b, m, deterministic)
}
func (m *IstioOperatorSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IstioOperatorSpec.Merge(m, src)
}
func (m *IstioOperatorSpec) XXX_Size() int {
	return xxx_messageInfo_IstioOperatorSpec.Size(m)
}
func (m *IstioOperatorSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_IstioOperatorSpec.DiscardUnknown(m)
}

var xxx_messageInfo_IstioOperatorSpec proto.InternalMessageInfo

func (m *IstioOperatorSpec) GetProfile() string {
	if m != nil {
		return m.Profile
	}
	return ""
}

func (m *IstioOperatorSpec) GetInstallPackagePath() string {
	if m != nil {
		return m.InstallPackagePath
	}
	return ""
}

func (m *IstioOperatorSpec) GetHub() string {
	if m != nil {
		return m.Hub
	}
	return ""
}


// Deprecated: Do not use.
func (m *IstioOperatorSpec) GetResourceSuffix() string {
	if m != nil {
		return m.ResourceSuffix
	}
	return ""
}

func (m *IstioOperatorSpec) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *IstioOperatorSpec) GetRevision() string {
	if m != nil {
		return m.Revision
	}
	return ""
}

func (m *IstioOperatorSpec) GetDefaultRevision() bool {
	if m != nil {
		return m.DefaultRevision
	}
	return false
}


func (m *IstioOperatorSpec) GetComponents() *IstioComponentSetSpec {
	if m != nil {
		return m.Components
	}
	return nil
}

// Deprecated: Do not use.
func (m *IstioOperatorSpec) GetAddonComponents() map[string]*ExternalComponentSpec {
	if m != nil {
		return m.AddonComponents
	}
	return nil
}



// Observed state of IstioOperator
type InstallStatus struct {
	// Overall status of all components controlled by the operator.
	//
	// * If all components have status `NONE`, overall status is `NONE`.
	// * If all components are `HEALTHY`, overall status is `HEALTHY`.
	// * If one or more components are `RECONCILING` and others are `HEALTHY`, overall status is `RECONCILING`.
	// * If one or more components are `UPDATING` and others are `HEALTHY`, overall status is `UPDATING`.
	// * If components are a mix of `RECONCILING`, `UPDATING` and `HEALTHY`, overall status is `UPDATING`.
	// * If any component is in `ERROR` state, overall status is `ERROR`.
	// * If further action is needed for reconciliation to proceed, overall status is `ACTION_REQUIRED`.
	//
	Status InstallStatus_Status `protobuf:"varint,1,opt,name=status,proto3,enum=istio.operator.v1alpha1.InstallStatus_Status" json:"status,omitempty"`
	// Optional message providing additional information about the existing overall status.
	Message string `protobuf:"bytes,3,opt,name=message,proto3" json:"message,omitempty"`
	// Individual status of each component controlled by the operator. The map key is the name of the component.
	ComponentStatus      map[string]*InstallStatus_VersionStatus `protobuf:"bytes,2,rep,name=component_status,json=componentStatus,proto3" json:"componentStatus,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}                                `json:"-"`
	XXX_unrecognized     []byte                                  `json:"-"`
	XXX_sizecache        int32                                   `json:"-"`
}

func (m *InstallStatus) Reset()         { *m = InstallStatus{} }
func (m *InstallStatus) String() string { return proto.CompactTextString(m) }
func (*InstallStatus) ProtoMessage()    {}
func (*InstallStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_8023ebf2dcfea843, []int{1}
}
func (m *InstallStatus) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_InstallStatus.Unmarshal(m, b)
}
func (m *InstallStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_InstallStatus.Marshal(b, m, deterministic)
}
func (m *InstallStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InstallStatus.Merge(m, src)
}
func (m *InstallStatus) XXX_Size() int {
	return xxx_messageInfo_InstallStatus.Size(m)
}
func (m *InstallStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_InstallStatus.DiscardUnknown(m)
}

var xxx_messageInfo_InstallStatus proto.InternalMessageInfo

func (m *InstallStatus) GetStatus() InstallStatus_Status {
	if m != nil {
		return m.Status
	}
	return InstallStatus_NONE
}

func (m *InstallStatus) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

func (m *InstallStatus) GetComponentStatus() map[string]*InstallStatus_VersionStatus {
	if m != nil {
		return m.ComponentStatus
	}
	return nil
}

// VersionStatus is the status and version of a component.
type InstallStatus_VersionStatus struct {
	Version              string               `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	Status               InstallStatus_Status `protobuf:"varint,2,opt,name=status,proto3,enum=istio.operator.v1alpha1.InstallStatus_Status" json:"status,omitempty"`
	Error                string               `protobuf:"bytes,4,opt,name=error,proto3" json:"error,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *InstallStatus_VersionStatus) Reset()         { *m = InstallStatus_VersionStatus{} }
func (m *InstallStatus_VersionStatus) String() string { return proto.CompactTextString(m) }
func (*InstallStatus_VersionStatus) ProtoMessage()    {}
func (*InstallStatus_VersionStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_8023ebf2dcfea843, []int{1, 0}
}
func (m *InstallStatus_VersionStatus) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_InstallStatus_VersionStatus.Unmarshal(m, b)
}
func (m *InstallStatus_VersionStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_InstallStatus_VersionStatus.Marshal(b, m, deterministic)
}
func (m *InstallStatus_VersionStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InstallStatus_VersionStatus.Merge(m, src)
}
func (m *InstallStatus_VersionStatus) XXX_Size() int {
	return xxx_messageInfo_InstallStatus_VersionStatus.Size(m)
}
func (m *InstallStatus_VersionStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_InstallStatus_VersionStatus.DiscardUnknown(m)
}

var xxx_messageInfo_InstallStatus_VersionStatus proto.InternalMessageInfo

func (m *InstallStatus_VersionStatus) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

func (m *InstallStatus_VersionStatus) GetStatus() InstallStatus_Status {
	if m != nil {
		return m.Status
	}
	return InstallStatus_NONE
}

func (m *InstallStatus_VersionStatus) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

// IstioComponentSpec defines the desired installed state of Istio components.
type IstioComponentSetSpec struct {
	Base                 *BaseComponentSpec `protobuf:"bytes,29,opt,name=base,proto3" json:"base,omitempty"`
	Pilot                *ComponentSpec     `protobuf:"bytes,30,opt,name=pilot,proto3" json:"pilot,omitempty"`
	Cni                  *ComponentSpec     `protobuf:"bytes,38,opt,name=cni,proto3" json:"cni,omitempty"`
	IstiodRemote         *ComponentSpec     `protobuf:"bytes,39,opt,name=istiod_remote,json=istiodRemote,proto3" json:"istiodRemote,omitempty"`
	IngressGateways      []*GatewaySpec     `protobuf:"bytes,40,rep,name=ingress_gateways,json=ingressGateways,proto3" json:"ingressGateways,omitempty"`
	EgressGateways       []*GatewaySpec     `protobuf:"bytes,41,rep,name=egress_gateways,json=egressGateways,proto3" json:"egressGateways,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *IstioComponentSetSpec) Reset()         { *m = IstioComponentSetSpec{} }
func (m *IstioComponentSetSpec) String() string { return proto.CompactTextString(m) }
func (*IstioComponentSetSpec) ProtoMessage()    {}
func (*IstioComponentSetSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_8023ebf2dcfea843, []int{2}
}
func (m *IstioComponentSetSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_IstioComponentSetSpec.Unmarshal(m, b)
}
func (m *IstioComponentSetSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_IstioComponentSetSpec.Marshal(b, m, deterministic)
}
func (m *IstioComponentSetSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IstioComponentSetSpec.Merge(m, src)
}
func (m *IstioComponentSetSpec) XXX_Size() int {
	return xxx_messageInfo_IstioComponentSetSpec.Size(m)
}
func (m *IstioComponentSetSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_IstioComponentSetSpec.DiscardUnknown(m)
}

var xxx_messageInfo_IstioComponentSetSpec proto.InternalMessageInfo

func (m *IstioComponentSetSpec) GetBase() *BaseComponentSpec {
	if m != nil {
		return m.Base
	}
	return nil
}

func (m *IstioComponentSetSpec) GetPilot() *ComponentSpec {
	if m != nil {
		return m.Pilot
	}
	return nil
}

func (m *IstioComponentSetSpec) GetCni() *ComponentSpec {
	if m != nil {
		return m.Cni
	}
	return nil
}

func (m *IstioComponentSetSpec) GetIstiodRemote() *ComponentSpec {
	if m != nil {
		return m.IstiodRemote
	}
	return nil
}

func (m *IstioComponentSetSpec) GetIngressGateways() []*GatewaySpec {
	if m != nil {
		return m.IngressGateways
	}
	return nil
}

func (m *IstioComponentSetSpec) GetEgressGateways() []*GatewaySpec {
	if m != nil {
		return m.EgressGateways
	}
	return nil
}

// Configuration for base component.
type BaseComponentSpec struct {
	// Selects whether this component is installed.
	Enabled *BoolValueForPB `protobuf:"bytes,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// Kubernetes resource spec.
	K8S                  *KubernetesResourcesSpec `protobuf:"bytes,50,opt,name=k8s,proto3" json:"k8s,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *BaseComponentSpec) Reset()         { *m = BaseComponentSpec{} }
func (m *BaseComponentSpec) String() string { return proto.CompactTextString(m) }
func (*BaseComponentSpec) ProtoMessage()    {}
func (*BaseComponentSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_8023ebf2dcfea843, []int{3}
}
func (m *BaseComponentSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BaseComponentSpec.Unmarshal(m, b)
}
func (m *BaseComponentSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BaseComponentSpec.Marshal(b, m, deterministic)
}
func (m *BaseComponentSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BaseComponentSpec.Merge(m, src)
}
func (m *BaseComponentSpec) XXX_Size() int {
	return xxx_messageInfo_BaseComponentSpec.Size(m)
}
func (m *BaseComponentSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_BaseComponentSpec.DiscardUnknown(m)
}

var xxx_messageInfo_BaseComponentSpec proto.InternalMessageInfo


func (m *BaseComponentSpec) GetK8S() *KubernetesResourcesSpec {
	if m != nil {
		return m.K8S
	}
	return nil
}

// Configuration for internal components.
type ComponentSpec struct {
	// Selects whether this component is installed.
	Enabled *BoolValueForPB `protobuf:"bytes,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// Namespace for the component.
	Namespace string `protobuf:"bytes,2,opt,name=namespace,proto3" json:"namespace,omitempty"`
	// Hub for the component (overrides top level hub setting).
	Hub string `protobuf:"bytes,10,opt,name=hub,proto3" json:"hub,omitempty"`
	// Tag for the component (overrides top level tag setting).
	Tag interface{} `protobuf:"bytes,11,opt,name=tag,proto3" json:"tag,omitempty"`
	// Arbitrary install time configuration for the component.
	Spec interface{} `protobuf:"bytes,30,opt,name=spec,proto3" json:"spec,omitempty"`
	// Kubernetes resource spec.
	K8S                  *KubernetesResourcesSpec `protobuf:"bytes,50,opt,name=k8s,proto3" json:"k8s,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *ComponentSpec) Reset()         { *m = ComponentSpec{} }
func (m *ComponentSpec) String() string { return proto.CompactTextString(m) }
func (*ComponentSpec) ProtoMessage()    {}
func (*ComponentSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_8023ebf2dcfea843, []int{4}
}
func (m *ComponentSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ComponentSpec.Unmarshal(m, b)
}
func (m *ComponentSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ComponentSpec.Marshal(b, m, deterministic)
}
func (m *ComponentSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ComponentSpec.Merge(m, src)
}
func (m *ComponentSpec) XXX_Size() int {
	return xxx_messageInfo_ComponentSpec.Size(m)
}
func (m *ComponentSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_ComponentSpec.DiscardUnknown(m)
}

var xxx_messageInfo_ComponentSpec proto.InternalMessageInfo


func (m *ComponentSpec) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *ComponentSpec) GetHub() string {
	if m != nil {
		return m.Hub
	}
	return ""
}



func (m *ComponentSpec) GetK8S() *KubernetesResourcesSpec {
	if m != nil {
		return m.K8S
	}
	return nil
}

// Configuration for external components.
type ExternalComponentSpec struct {
	// Selects whether this component is installed.
	Enabled *BoolValueForPB `protobuf:"bytes,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// Namespace for the component.
	Namespace string `protobuf:"bytes,2,opt,name=namespace,proto3" json:"namespace,omitempty"`
	// Arbitrary install time configuration for the component.
	Spec interface{} `protobuf:"bytes,10,opt,name=spec,proto3" json:"spec,omitempty"`
	// Chart path for addon components.
	ChartPath string `protobuf:"bytes,30,opt,name=chart_path,json=chartPath,proto3" json:"chartPath,omitempty"`
	// Optional schema to validate spec against.
	Schema *types.Any `protobuf:"bytes,35,opt,name=schema,proto3" json:"schema,omitempty"`
	// Kubernetes resource spec.
	K8S                  *KubernetesResourcesSpec `protobuf:"bytes,50,opt,name=k8s,proto3" json:"k8s,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *ExternalComponentSpec) Reset()         { *m = ExternalComponentSpec{} }
func (m *ExternalComponentSpec) String() string { return proto.CompactTextString(m) }
func (*ExternalComponentSpec) ProtoMessage()    {}
func (*ExternalComponentSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_8023ebf2dcfea843, []int{5}
}
func (m *ExternalComponentSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExternalComponentSpec.Unmarshal(m, b)
}
func (m *ExternalComponentSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExternalComponentSpec.Marshal(b, m, deterministic)
}
func (m *ExternalComponentSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExternalComponentSpec.Merge(m, src)
}
func (m *ExternalComponentSpec) XXX_Size() int {
	return xxx_messageInfo_ExternalComponentSpec.Size(m)
}
func (m *ExternalComponentSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_ExternalComponentSpec.DiscardUnknown(m)
}

var xxx_messageInfo_ExternalComponentSpec proto.InternalMessageInfo


func (m *ExternalComponentSpec) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}


func (m *ExternalComponentSpec) GetChartPath() string {
	if m != nil {
		return m.ChartPath
	}
	return ""
}

func (m *ExternalComponentSpec) GetSchema() *types.Any {
	if m != nil {
		return m.Schema
	}
	return nil
}

func (m *ExternalComponentSpec) GetK8S() *KubernetesResourcesSpec {
	if m != nil {
		return m.K8S
	}
	return nil
}

// Configuration for gateways.
type GatewaySpec struct {
	// Selects whether this gateway is installed.
	Enabled *BoolValueForPB `protobuf:"bytes,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// Namespace for the gateway.
	Namespace string `protobuf:"bytes,2,opt,name=namespace,proto3" json:"namespace,omitempty"`
	// Name for the gateway.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// Labels for the gateway.
	Label map[string]string `protobuf:"bytes,4,rep,name=label,proto3" json:"label,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Hub for the component (overrides top level hub setting).
	Hub string `protobuf:"bytes,10,opt,name=hub,proto3" json:"hub,omitempty"`
	// Tag for the component (overrides top level tag setting).
	Tag interface{} `protobuf:"bytes,11,opt,name=tag,proto3" json:"tag,omitempty"`
	// Kubernetes resource spec.
	K8S                  *KubernetesResourcesSpec `protobuf:"bytes,50,opt,name=k8s,proto3" json:"k8s,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *GatewaySpec) Reset()         { *m = GatewaySpec{} }
func (m *GatewaySpec) String() string { return proto.CompactTextString(m) }
func (*GatewaySpec) ProtoMessage()    {}
func (*GatewaySpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_8023ebf2dcfea843, []int{6}
}
func (m *GatewaySpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GatewaySpec.Unmarshal(m, b)
}
func (m *GatewaySpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GatewaySpec.Marshal(b, m, deterministic)
}
func (m *GatewaySpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GatewaySpec.Merge(m, src)
}
func (m *GatewaySpec) XXX_Size() int {
	return xxx_messageInfo_GatewaySpec.Size(m)
}
func (m *GatewaySpec) XXX_DiscardUnknown() {
	xxx_messageInfo_GatewaySpec.DiscardUnknown(m)
}

var xxx_messageInfo_GatewaySpec proto.InternalMessageInfo


func (m *GatewaySpec) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *GatewaySpec) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *GatewaySpec) GetLabel() map[string]string {
	if m != nil {
		return m.Label
	}
	return nil
}

func (m *GatewaySpec) GetHub() string {
	if m != nil {
		return m.Hub
	}
	return ""
}


func (m *GatewaySpec) GetK8S() *KubernetesResourcesSpec {
	if m != nil {
		return m.K8S
	}
	return nil
}

// KubernetesResourcesConfig is a common set of k8s resource configs for components.
type KubernetesResourcesSpec struct {
	// k8s affinity.
	// [https://kubernetes.io/docs/concepts/configuration/assign-pod-node/#affinity-and-anti-affinity](https://kubernetes.io/docs/concepts/configuration/assign-pod-node/#affinity-and-anti-affinity)
	Affinity *Affinity `protobuf:"bytes,1,opt,name=affinity,proto3" json:"affinity,omitempty"`
	// Deployment environment variables.
	// [https://kubernetes.io/docs/tasks/inject-data-application/define-environment-variable-container/](https://kubernetes.io/docs/tasks/inject-data-application/define-environment-variable-container/)
	Env []*EnvVar `protobuf:"bytes,2,rep,name=env,proto3" json:"env,omitempty"`
	// k8s HorizontalPodAutoscaler settings.
	// [https://kubernetes.io/docs/tasks/run-application/horizontal-pod-autoscale/](https://kubernetes.io/docs/tasks/run-application/horizontal-pod-autoscale/)
	HpaSpec *HorizontalPodAutoscalerSpec `protobuf:"bytes,3,opt,name=hpa_spec,json=hpaSpec,proto3" json:"hpaSpec,omitempty"`
	// k8s imagePullPolicy.
	// [https://kubernetes.io/docs/concepts/containers/images/](https://kubernetes.io/docs/concepts/containers/images/)
	ImagePullPolicy string `protobuf:"bytes,4,opt,name=image_pull_policy,json=imagePullPolicy,proto3" json:"imagePullPolicy,omitempty"`
	// k8s nodeSelector.
	// [https://kubernetes.io/docs/concepts/configuration/assign-pod-node/#nodeselector](https://kubernetes.io/docs/concepts/configuration/assign-pod-node/#nodeselector)
	NodeSelector map[string]string `protobuf:"bytes,5,rep,name=node_selector,json=nodeSelector,proto3" json:"nodeSelector,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// k8s PodDisruptionBudget settings.
	// [https://kubernetes.io/docs/concepts/workloads/pods/disruptions/#how-disruption-budgets-work](https://kubernetes.io/docs/concepts/workloads/pods/disruptions/#how-disruption-budgets-work)
	PodDisruptionBudget *PodDisruptionBudgetSpec `protobuf:"bytes,6,opt,name=pod_disruption_budget,json=podDisruptionBudget,proto3" json:"podDisruptionBudget,omitempty"`
	// k8s pod annotations.
	// [https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations/](https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations/)
	PodAnnotations map[string]string `protobuf:"bytes,7,rep,name=pod_annotations,json=podAnnotations,proto3" json:"podAnnotations,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// k8s priority_class_name. Default for all resources unless overridden.
	// [https://kubernetes.io/docs/concepts/configuration/pod-priority-preemption/#priorityclass](https://kubernetes.io/docs/concepts/configuration/pod-priority-preemption/#priorityclass)
	PriorityClassName string `protobuf:"bytes,8,opt,name=priority_class_name,json=priorityClassName,proto3" json:"priorityClassName,omitempty"`
	// k8s readinessProbe settings.
	// [https://kubernetes.io/docs/tasks/configure-pod-container/configure-liveness-readiness-probes/](https://kubernetes.io/docs/tasks/configure-pod-container/configure-liveness-readiness-probes/)
	// k8s.io.api.core.v1.Probe readiness_probe = 9;
	ReadinessProbe *ReadinessProbe `protobuf:"bytes,9,opt,name=readiness_probe,json=readinessProbe,proto3" json:"readinessProbe,omitempty"`
	// k8s Deployment replicas setting.
	// [https://kubernetes.io/docs/concepts/workloads/controllers/deployment/](https://kubernetes.io/docs/concepts/workloads/controllers/deployment/)
	ReplicaCount uint32 `protobuf:"varint,10,opt,name=replica_count,json=replicaCount,proto3" json:"replicaCount,omitempty"`
	// k8s resources settings.
	// [https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/#resource-requests-and-limits-of-pod-and-container](https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/#resource-requests-and-limits-of-pod-and-container)
	Resources *Resources `protobuf:"bytes,11,opt,name=resources,proto3" json:"resources,omitempty"`
	// k8s Service settings.
	// [https://kubernetes.io/docs/concepts/services-networking/service/](https://kubernetes.io/docs/concepts/services-networking/service/)
	Service *ServiceSpec `protobuf:"bytes,12,opt,name=service,proto3" json:"service,omitempty"`
	// k8s deployment strategy.
	// [https://kubernetes.io/docs/concepts/workloads/controllers/deployment/](https://kubernetes.io/docs/concepts/workloads/controllers/deployment/)
	Strategy *DeploymentStrategy `protobuf:"bytes,13,opt,name=strategy,proto3" json:"strategy,omitempty"`
	// k8s toleration
	// [https://kubernetes.io/docs/concepts/configuration/taint-and-toleration/](https://kubernetes.io/docs/concepts/configuration/taint-and-toleration/)
	Tolerations []*Toleration `protobuf:"bytes,14,rep,name=tolerations,proto3" json:"tolerations,omitempty"`
	// k8s service annotations.
	// [https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations/](https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations/)
	ServiceAnnotations map[string]string `protobuf:"bytes,15,rep,name=service_annotations,json=serviceAnnotations,proto3" json:"serviceAnnotations,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// k8s pod security context
	// [https://kubernetes.io/docs/tasks/configure-pod-container/security-context/#set-the-security-context-for-a-pod](https://kubernetes.io/docs/tasks/configure-pod-container/security-context/#set-the-security-context-for-a-pod)
	SecurityContext *PodSecurityContext `protobuf:"bytes,16,opt,name=securityContext,proto3" json:"securityContext,omitempty"`
	// k8s volume
	// [https://kubernetes.io/docs/concepts/storage/volumes/](https://kubernetes.io/docs/concepts/storage/volumes/)
	// Volumes defines the collection of Volume to inject into the pod.
	Volumes []*v1.Volume `protobuf:"bytes,17,rep,name=volumes,proto3" json:"volumes,omitempty"`
	// k8s volumeMounts
	// VolumeMounts defines the collection of VolumeMount to inject into containers.
	VolumeMounts []*v1.VolumeMount `protobuf:"bytes,18,rep,name=volumeMounts,proto3" json:"volumeMounts,omitempty"`
	// Overlays for k8s resources in rendered manifests.
	Overlays             []*K8SObjectOverlay `protobuf:"bytes,100,rep,name=overlays,proto3" json:"overlays,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *KubernetesResourcesSpec) Reset()         { *m = KubernetesResourcesSpec{} }
func (m *KubernetesResourcesSpec) String() string { return proto.CompactTextString(m) }
func (*KubernetesResourcesSpec) ProtoMessage()    {}
func (*KubernetesResourcesSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_8023ebf2dcfea843, []int{7}
}
func (m *KubernetesResourcesSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_KubernetesResourcesSpec.Unmarshal(m, b)
}
func (m *KubernetesResourcesSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_KubernetesResourcesSpec.Marshal(b, m, deterministic)
}
func (m *KubernetesResourcesSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_KubernetesResourcesSpec.Merge(m, src)
}
func (m *KubernetesResourcesSpec) XXX_Size() int {
	return xxx_messageInfo_KubernetesResourcesSpec.Size(m)
}
func (m *KubernetesResourcesSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_KubernetesResourcesSpec.DiscardUnknown(m)
}

var xxx_messageInfo_KubernetesResourcesSpec proto.InternalMessageInfo

func (m *KubernetesResourcesSpec) GetAffinity() *Affinity {
	if m != nil {
		return m.Affinity
	}
	return nil
}

func (m *KubernetesResourcesSpec) GetEnv() []*EnvVar {
	if m != nil {
		return m.Env
	}
	return nil
}

func (m *KubernetesResourcesSpec) GetHpaSpec() *HorizontalPodAutoscalerSpec {
	if m != nil {
		return m.HpaSpec
	}
	return nil
}

func (m *KubernetesResourcesSpec) GetImagePullPolicy() string {
	if m != nil {
		return m.ImagePullPolicy
	}
	return ""
}

func (m *KubernetesResourcesSpec) GetNodeSelector() map[string]string {
	if m != nil {
		return m.NodeSelector
	}
	return nil
}

func (m *KubernetesResourcesSpec) GetPodDisruptionBudget() *PodDisruptionBudgetSpec {
	if m != nil {
		return m.PodDisruptionBudget
	}
	return nil
}

func (m *KubernetesResourcesSpec) GetPodAnnotations() map[string]string {
	if m != nil {
		return m.PodAnnotations
	}
	return nil
}

func (m *KubernetesResourcesSpec) GetPriorityClassName() string {
	if m != nil {
		return m.PriorityClassName
	}
	return ""
}

func (m *KubernetesResourcesSpec) GetReadinessProbe() *ReadinessProbe {
	if m != nil {
		return m.ReadinessProbe
	}
	return nil
}

func (m *KubernetesResourcesSpec) GetReplicaCount() uint32 {
	if m != nil {
		return m.ReplicaCount
	}
	return 0
}

func (m *KubernetesResourcesSpec) GetResources() *Resources {
	if m != nil {
		return m.Resources
	}
	return nil
}

func (m *KubernetesResourcesSpec) GetService() *ServiceSpec {
	if m != nil {
		return m.Service
	}
	return nil
}

func (m *KubernetesResourcesSpec) GetStrategy() *DeploymentStrategy {
	if m != nil {
		return m.Strategy
	}
	return nil
}

func (m *KubernetesResourcesSpec) GetTolerations() []*Toleration {
	if m != nil {
		return m.Tolerations
	}
	return nil
}

func (m *KubernetesResourcesSpec) GetServiceAnnotations() map[string]string {
	if m != nil {
		return m.ServiceAnnotations
	}
	return nil
}

func (m *KubernetesResourcesSpec) GetSecurityContext() *PodSecurityContext {
	if m != nil {
		return m.SecurityContext
	}
	return nil
}

func (m *KubernetesResourcesSpec) GetVolumes() []*v1.Volume {
	if m != nil {
		return m.Volumes
	}
	return nil
}

func (m *KubernetesResourcesSpec) GetVolumeMounts() []*v1.VolumeMount {
	if m != nil {
		return m.VolumeMounts
	}
	return nil
}

func (m *KubernetesResourcesSpec) GetOverlays() []*K8SObjectOverlay {
	if m != nil {
		return m.Overlays
	}
	return nil
}

// Patch for an existing k8s resource.
type K8SObjectOverlay struct {
	// Resource API version.
	ApiVersion string `protobuf:"bytes,1,opt,name=api_version,json=apiVersion,proto3" json:"apiVersion,omitempty"`
	// Resource kind.
	Kind string `protobuf:"bytes,2,opt,name=kind,proto3" json:"kind,omitempty"`
	// Name of resource.
	// Namespace is always the component namespace.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// List of patches to apply to resource.
	Patches              []*K8SObjectOverlay_PathValue `protobuf:"bytes,4,rep,name=patches,proto3" json:"patches,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                      `json:"-"`
	XXX_unrecognized     []byte                        `json:"-"`
	XXX_sizecache        int32                         `json:"-"`
}

func (m *K8SObjectOverlay) Reset()         { *m = K8SObjectOverlay{} }
func (m *K8SObjectOverlay) String() string { return proto.CompactTextString(m) }
func (*K8SObjectOverlay) ProtoMessage()    {}
func (*K8SObjectOverlay) Descriptor() ([]byte, []int) {
	return fileDescriptor_8023ebf2dcfea843, []int{8}
}
func (m *K8SObjectOverlay) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_K8SObjectOverlay.Unmarshal(m, b)
}
func (m *K8SObjectOverlay) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_K8SObjectOverlay.Marshal(b, m, deterministic)
}
func (m *K8SObjectOverlay) XXX_Merge(src proto.Message) {
	xxx_messageInfo_K8SObjectOverlay.Merge(m, src)
}
func (m *K8SObjectOverlay) XXX_Size() int {
	return xxx_messageInfo_K8SObjectOverlay.Size(m)
}
func (m *K8SObjectOverlay) XXX_DiscardUnknown() {
	xxx_messageInfo_K8SObjectOverlay.DiscardUnknown(m)
}

var xxx_messageInfo_K8SObjectOverlay proto.InternalMessageInfo

func (m *K8SObjectOverlay) GetApiVersion() string {
	if m != nil {
		return m.ApiVersion
	}
	return ""
}

func (m *K8SObjectOverlay) GetKind() string {
	if m != nil {
		return m.Kind
	}
	return ""
}

func (m *K8SObjectOverlay) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *K8SObjectOverlay) GetPatches() []*K8SObjectOverlay_PathValue {
	if m != nil {
		return m.Patches
	}
	return nil
}

type K8SObjectOverlay_PathValue struct {
	// Path of the form a.[key1:value1].b.[:value2]
	// Where [key1:value1] is a selector for a key-value pair to identify a list element and [:value] is a value
	// selector to identify a list element in a leaf list.
	// All path intermediate nodes must exist.
	Path string `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
	// Value to add, delete or replace.
	// For add, the path should be a new leaf.
	// For delete, value should be unset.
	// For replace, path should reference an existing node.
	// All values are strings but are converted into appropriate type based on schema.
	Value                interface{} `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *K8SObjectOverlay_PathValue) Reset()         { *m = K8SObjectOverlay_PathValue{} }
func (m *K8SObjectOverlay_PathValue) String() string { return proto.CompactTextString(m) }
func (*K8SObjectOverlay_PathValue) ProtoMessage()    {}
func (*K8SObjectOverlay_PathValue) Descriptor() ([]byte, []int) {
	return fileDescriptor_8023ebf2dcfea843, []int{8, 0}
}
func (m *K8SObjectOverlay_PathValue) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_K8SObjectOverlay_PathValue.Unmarshal(m, b)
}
func (m *K8SObjectOverlay_PathValue) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_K8SObjectOverlay_PathValue.Marshal(b, m, deterministic)
}
func (m *K8SObjectOverlay_PathValue) XXX_Merge(src proto.Message) {
	xxx_messageInfo_K8SObjectOverlay_PathValue.Merge(m, src)
}
func (m *K8SObjectOverlay_PathValue) XXX_Size() int {
	return xxx_messageInfo_K8SObjectOverlay_PathValue.Size(m)
}
func (m *K8SObjectOverlay_PathValue) XXX_DiscardUnknown() {
	xxx_messageInfo_K8SObjectOverlay_PathValue.DiscardUnknown(m)
}

var xxx_messageInfo_K8SObjectOverlay_PathValue proto.InternalMessageInfo

func (m *K8SObjectOverlay_PathValue) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}


// See k8s.io.api.core.v1.Affinity.
type Affinity struct {
	NodeAffinity         *NodeAffinity    `protobuf:"bytes,1,opt,name=nodeAffinity,proto3" json:"nodeAffinity,omitempty"`
	PodAffinity          *PodAffinity     `protobuf:"bytes,2,opt,name=podAffinity,proto3" json:"podAffinity,omitempty"`
	PodAntiAffinity      *PodAntiAffinity `protobuf:"bytes,3,opt,name=podAntiAffinity,proto3" json:"podAntiAffinity,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *Affinity) Reset()         { *m = Affinity{} }
func (m *Affinity) String() string { return proto.CompactTextString(m) }
func (*Affinity) ProtoMessage()    {}
func (*Affinity) Descriptor() ([]byte, []int) {
	return fileDescriptor_8023ebf2dcfea843, []int{9}
}
func (m *Affinity) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Affinity.Unmarshal(m, b)
}
func (m *Affinity) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Affinity.Marshal(b, m, deterministic)
}
func (m *Affinity) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Affinity.Merge(m, src)
}
func (m *Affinity) XXX_Size() int {
	return xxx_messageInfo_Affinity.Size(m)
}
func (m *Affinity) XXX_DiscardUnknown() {
	xxx_messageInfo_Affinity.DiscardUnknown(m)
}

var xxx_messageInfo_Affinity proto.InternalMessageInfo

func (m *Affinity) GetNodeAffinity() *NodeAffinity {
	if m != nil {
		return m.NodeAffinity
	}
	return nil
}

func (m *Affinity) GetPodAffinity() *PodAffinity {
	if m != nil {
		return m.PodAffinity
	}
	return nil
}

func (m *Affinity) GetPodAntiAffinity() *PodAntiAffinity {
	if m != nil {
		return m.PodAntiAffinity
	}
	return nil
}

// See k8s.io.api.core.v1.ConfigMapKeySelector.
type ConfigMapKeySelector struct {
	LocalObjectReference *LocalObjectReference `protobuf:"bytes,1,opt,name=localObjectReference,proto3" json:"localObjectReference,omitempty"`
	Key                  string                `protobuf:"bytes,2,opt,name=key,proto3" json:"key,omitempty"`
	Optional             bool                  `protobuf:"varint,3,opt,name=optional,proto3" json:"optional,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *ConfigMapKeySelector) Reset()         { *m = ConfigMapKeySelector{} }
func (m *ConfigMapKeySelector) String() string { return proto.CompactTextString(m) }
func (*ConfigMapKeySelector) ProtoMessage()    {}
func (*ConfigMapKeySelector) Descriptor() ([]byte, []int) {
	return fileDescriptor_8023ebf2dcfea843, []int{10}
}
func (m *ConfigMapKeySelector) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ConfigMapKeySelector.Unmarshal(m, b)
}
func (m *ConfigMapKeySelector) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ConfigMapKeySelector.Marshal(b, m, deterministic)
}
func (m *ConfigMapKeySelector) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ConfigMapKeySelector.Merge(m, src)
}
func (m *ConfigMapKeySelector) XXX_Size() int {
	return xxx_messageInfo_ConfigMapKeySelector.Size(m)
}
func (m *ConfigMapKeySelector) XXX_DiscardUnknown() {
	xxx_messageInfo_ConfigMapKeySelector.DiscardUnknown(m)
}

var xxx_messageInfo_ConfigMapKeySelector proto.InternalMessageInfo

func (m *ConfigMapKeySelector) GetLocalObjectReference() *LocalObjectReference {
	if m != nil {
		return m.LocalObjectReference
	}
	return nil
}

func (m *ConfigMapKeySelector) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

func (m *ConfigMapKeySelector) GetOptional() bool {
	if m != nil {
		return m.Optional
	}
	return false
}

// See k8s.io.api.core.v1.ClientIPConfig.
type ClientIPConfig struct {
	TimeoutSeconds       int32    `protobuf:"varint,1,opt,name=timeoutSeconds,proto3" json:"timeoutSeconds,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ClientIPConfig) Reset()         { *m = ClientIPConfig{} }
func (m *ClientIPConfig) String() string { return proto.CompactTextString(m) }
func (*ClientIPConfig) ProtoMessage()    {}
func (*ClientIPConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_8023ebf2dcfea843, []int{11}
}
func (m *ClientIPConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ClientIPConfig.Unmarshal(m, b)
}
func (m *ClientIPConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ClientIPConfig.Marshal(b, m, deterministic)
}
func (m *ClientIPConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ClientIPConfig.Merge(m, src)
}
func (m *ClientIPConfig) XXX_Size() int {
	return xxx_messageInfo_ClientIPConfig.Size(m)
}
func (m *ClientIPConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_ClientIPConfig.DiscardUnknown(m)
}

var xxx_messageInfo_ClientIPConfig proto.InternalMessageInfo

func (m *ClientIPConfig) GetTimeoutSeconds() int32 {
	if m != nil {
		return m.TimeoutSeconds
	}
	return 0
}

// See k8s.io.api.autoscaling.v2beta2.CrossVersionObjectReference.
type CrossVersionObjectReference struct {
	Kind                 string   `protobuf:"bytes,1,opt,name=kind,proto3" json:"kind,omitempty"`
	Name                 string   `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	ApiVersion           string   `protobuf:"bytes,3,opt,name=apiVersion,proto3" json:"apiVersion,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CrossVersionObjectReference) Reset()         { *m = CrossVersionObjectReference{} }
func (m *CrossVersionObjectReference) String() string { return proto.CompactTextString(m) }
func (*CrossVersionObjectReference) ProtoMessage()    {}
func (*CrossVersionObjectReference) Descriptor() ([]byte, []int) {
	return fileDescriptor_8023ebf2dcfea843, []int{12}
}
func (m *CrossVersionObjectReference) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CrossVersionObjectReference.Unmarshal(m, b)
}
func (m *CrossVersionObjectReference) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CrossVersionObjectReference.Marshal(b, m, deterministic)
}
func (m *CrossVersionObjectReference) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CrossVersionObjectReference.Merge(m, src)
}
func (m *CrossVersionObjectReference) XXX_Size() int {
	return xxx_messageInfo_CrossVersionObjectReference.Size(m)
}
func (m *CrossVersionObjectReference) XXX_DiscardUnknown() {
	xxx_messageInfo_CrossVersionObjectReference.DiscardUnknown(m)
}

var xxx_messageInfo_CrossVersionObjectReference proto.InternalMessageInfo

func (m *CrossVersionObjectReference) GetKind() string {
	if m != nil {
		return m.Kind
	}
	return ""
}

func (m *CrossVersionObjectReference) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *CrossVersionObjectReference) GetApiVersion() string {
	if m != nil {
		return m.ApiVersion
	}
	return ""
}

// See k8s.io.api.apps.v1.DeploymentStrategy.
type DeploymentStrategy struct {
	Type                 string                   `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	RollingUpdate        *RollingUpdateDeployment `protobuf:"bytes,2,opt,name=rollingUpdate,proto3" json:"rollingUpdate,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *DeploymentStrategy) Reset()         { *m = DeploymentStrategy{} }
func (m *DeploymentStrategy) String() string { return proto.CompactTextString(m) }
func (*DeploymentStrategy) ProtoMessage()    {}
func (*DeploymentStrategy) Descriptor() ([]byte, []int) {
	return fileDescriptor_8023ebf2dcfea843, []int{13}
}
func (m *DeploymentStrategy) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeploymentStrategy.Unmarshal(m, b)
}
func (m *DeploymentStrategy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeploymentStrategy.Marshal(b, m, deterministic)
}
func (m *DeploymentStrategy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeploymentStrategy.Merge(m, src)
}
func (m *DeploymentStrategy) XXX_Size() int {
	return xxx_messageInfo_DeploymentStrategy.Size(m)
}
func (m *DeploymentStrategy) XXX_DiscardUnknown() {
	xxx_messageInfo_DeploymentStrategy.DiscardUnknown(m)
}

var xxx_messageInfo_DeploymentStrategy proto.InternalMessageInfo

func (m *DeploymentStrategy) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *DeploymentStrategy) GetRollingUpdate() *RollingUpdateDeployment {
	if m != nil {
		return m.RollingUpdate
	}
	return nil
}

// See k8s.io.api.core.v1.EnvVar.
type EnvVar struct {
	Name                 string        `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Value                string        `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	ValueFrom            *EnvVarSource `protobuf:"bytes,3,opt,name=valueFrom,proto3" json:"valueFrom,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *EnvVar) Reset()         { *m = EnvVar{} }
func (m *EnvVar) String() string { return proto.CompactTextString(m) }
func (*EnvVar) ProtoMessage()    {}
func (*EnvVar) Descriptor() ([]byte, []int) {
	return fileDescriptor_8023ebf2dcfea843, []int{14}
}
func (m *EnvVar) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EnvVar.Unmarshal(m, b)
}
func (m *EnvVar) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EnvVar.Marshal(b, m, deterministic)
}
func (m *EnvVar) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EnvVar.Merge(m, src)
}
func (m *EnvVar) XXX_Size() int {
	return xxx_messageInfo_EnvVar.Size(m)
}
func (m *EnvVar) XXX_DiscardUnknown() {
	xxx_messageInfo_EnvVar.DiscardUnknown(m)
}

var xxx_messageInfo_EnvVar proto.InternalMessageInfo

func (m *EnvVar) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *EnvVar) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

func (m *EnvVar) GetValueFrom() *EnvVarSource {
	if m != nil {
		return m.ValueFrom
	}
	return nil
}

// See k8s.io.api.core.v1.EnvVarSource.
type EnvVarSource struct {
	FieldRef             *ObjectFieldSelector   `protobuf:"bytes,1,opt,name=fieldRef,proto3" json:"fieldRef,omitempty"`
	ResourceFieldRef     *ResourceFieldSelector `protobuf:"bytes,2,opt,name=resourceFieldRef,proto3" json:"resourceFieldRef,omitempty"`
	ConfigMapKeyRef      *ConfigMapKeySelector  `protobuf:"bytes,3,opt,name=configMapKeyRef,proto3" json:"configMapKeyRef,omitempty"`
	SecretKeyRef         *SecretKeySelector     `protobuf:"bytes,4,opt,name=secretKeyRef,proto3" json:"secretKeyRef,omitempty"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *EnvVarSource) Reset()         { *m = EnvVarSource{} }
func (m *EnvVarSource) String() string { return proto.CompactTextString(m) }
func (*EnvVarSource) ProtoMessage()    {}
func (*EnvVarSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_8023ebf2dcfea843, []int{15}
}
func (m *EnvVarSource) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EnvVarSource.Unmarshal(m, b)
}
func (m *EnvVarSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EnvVarSource.Marshal(b, m, deterministic)
}
func (m *EnvVarSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EnvVarSource.Merge(m, src)
}
func (m *EnvVarSource) XXX_Size() int {
	return xxx_messageInfo_EnvVarSource.Size(m)
}
func (m *EnvVarSource) XXX_DiscardUnknown() {
	xxx_messageInfo_EnvVarSource.DiscardUnknown(m)
}

var xxx_messageInfo_EnvVarSource proto.InternalMessageInfo

func (m *EnvVarSource) GetFieldRef() *ObjectFieldSelector {
	if m != nil {
		return m.FieldRef
	}
	return nil
}

func (m *EnvVarSource) GetResourceFieldRef() *ResourceFieldSelector {
	if m != nil {
		return m.ResourceFieldRef
	}
	return nil
}

func (m *EnvVarSource) GetConfigMapKeyRef() *ConfigMapKeySelector {
	if m != nil {
		return m.ConfigMapKeyRef
	}
	return nil
}

func (m *EnvVarSource) GetSecretKeyRef() *SecretKeySelector {
	if m != nil {
		return m.SecretKeyRef
	}
	return nil
}

// See k8s.io.api.core.v1.ExecAction.
type ExecAction struct {
	Command              []string `protobuf:"bytes,1,rep,name=command,proto3" json:"command,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ExecAction) Reset()         { *m = ExecAction{} }
func (m *ExecAction) String() string { return proto.CompactTextString(m) }
func (*ExecAction) ProtoMessage()    {}
func (*ExecAction) Descriptor() ([]byte, []int) {
	return fileDescriptor_8023ebf2dcfea843, []int{16}
}
func (m *ExecAction) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExecAction.Unmarshal(m, b)
}
func (m *ExecAction) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExecAction.Marshal(b, m, deterministic)
}
func (m *ExecAction) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExecAction.Merge(m, src)
}
func (m *ExecAction) XXX_Size() int {
	return xxx_messageInfo_ExecAction.Size(m)
}
func (m *ExecAction) XXX_DiscardUnknown() {
	xxx_messageInfo_ExecAction.DiscardUnknown(m)
}

var xxx_messageInfo_ExecAction proto.InternalMessageInfo

func (m *ExecAction) GetCommand() []string {
	if m != nil {
		return m.Command
	}
	return nil
}

// See k8s.io.api.autoscaling.v2beta2.CrossVersionObjectReference.
type ExternalMetricSource struct {
	MetricName           string                `protobuf:"bytes,1,opt,name=metricName,proto3" json:"metricName,omitempty"`
	MetricSelector       *v11.LabelSelector    `protobuf:"bytes,2,opt,name=metricSelector,proto3" json:"metricSelector,omitempty"`
	TargetValue          *IntOrStringForPB `protobuf:"bytes,3,opt,name=targetValue,proto3" json:"targetValue,omitempty"`
	TargetAverageValue   *IntOrStringForPB `protobuf:"bytes,4,opt,name=targetAverageValue,proto3" json:"targetAverageValue,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *ExternalMetricSource) Reset()         { *m = ExternalMetricSource{} }
func (m *ExternalMetricSource) String() string { return proto.CompactTextString(m) }
func (*ExternalMetricSource) ProtoMessage()    {}
func (*ExternalMetricSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_8023ebf2dcfea843, []int{17}
}
func (m *ExternalMetricSource) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExternalMetricSource.Unmarshal(m, b)
}
func (m *ExternalMetricSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExternalMetricSource.Marshal(b, m, deterministic)
}
func (m *ExternalMetricSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExternalMetricSource.Merge(m, src)
}
func (m *ExternalMetricSource) XXX_Size() int {
	return xxx_messageInfo_ExternalMetricSource.Size(m)
}
func (m *ExternalMetricSource) XXX_DiscardUnknown() {
	xxx_messageInfo_ExternalMetricSource.DiscardUnknown(m)
}

var xxx_messageInfo_ExternalMetricSource proto.InternalMessageInfo

func (m *ExternalMetricSource) GetMetricName() string {
	if m != nil {
		return m.MetricName
	}
	return ""
}

func (m *ExternalMetricSource) GetMetricSelector() *v11.LabelSelector {
	if m != nil {
		return m.MetricSelector
	}
	return nil
}



// See k8s.io.api.core.v1.HTTPGetAction.
type HTTPGetAction struct {
	Path                 string                `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
	Port                 *IntOrStringForPB `protobuf:"bytes,2,opt,name=port,proto3" json:"port,omitempty"`
	Host                 string                `protobuf:"bytes,3,opt,name=host,proto3" json:"host,omitempty"`
	Scheme               string                `protobuf:"bytes,4,opt,name=scheme,proto3" json:"scheme,omitempty"`
	HttpHeaders          []*HTTPHeader         `protobuf:"bytes,5,rep,name=httpHeaders,proto3" json:"httpHeaders,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *HTTPGetAction) Reset()         { *m = HTTPGetAction{} }
func (m *HTTPGetAction) String() string { return proto.CompactTextString(m) }
func (*HTTPGetAction) ProtoMessage()    {}
func (*HTTPGetAction) Descriptor() ([]byte, []int) {
	return fileDescriptor_8023ebf2dcfea843, []int{18}
}
func (m *HTTPGetAction) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_HTTPGetAction.Unmarshal(m, b)
}
func (m *HTTPGetAction) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_HTTPGetAction.Marshal(b, m, deterministic)
}
func (m *HTTPGetAction) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HTTPGetAction.Merge(m, src)
}
func (m *HTTPGetAction) XXX_Size() int {
	return xxx_messageInfo_HTTPGetAction.Size(m)
}
func (m *HTTPGetAction) XXX_DiscardUnknown() {
	xxx_messageInfo_HTTPGetAction.DiscardUnknown(m)
}

var xxx_messageInfo_HTTPGetAction proto.InternalMessageInfo

func (m *HTTPGetAction) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}


func (m *HTTPGetAction) GetHost() string {
	if m != nil {
		return m.Host
	}
	return ""
}

func (m *HTTPGetAction) GetScheme() string {
	if m != nil {
		return m.Scheme
	}
	return ""
}

func (m *HTTPGetAction) GetHttpHeaders() []*HTTPHeader {
	if m != nil {
		return m.HttpHeaders
	}
	return nil
}

// See k8s.io.api.core.v1.HTTPHeader.
type HTTPHeader struct {
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Value                string   `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *HTTPHeader) Reset()         { *m = HTTPHeader{} }
func (m *HTTPHeader) String() string { return proto.CompactTextString(m) }
func (*HTTPHeader) ProtoMessage()    {}
func (*HTTPHeader) Descriptor() ([]byte, []int) {
	return fileDescriptor_8023ebf2dcfea843, []int{19}
}
func (m *HTTPHeader) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_HTTPHeader.Unmarshal(m, b)
}
func (m *HTTPHeader) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_HTTPHeader.Marshal(b, m, deterministic)
}
func (m *HTTPHeader) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HTTPHeader.Merge(m, src)
}
func (m *HTTPHeader) XXX_Size() int {
	return xxx_messageInfo_HTTPHeader.Size(m)
}
func (m *HTTPHeader) XXX_DiscardUnknown() {
	xxx_messageInfo_HTTPHeader.DiscardUnknown(m)
}

var xxx_messageInfo_HTTPHeader proto.InternalMessageInfo

func (m *HTTPHeader) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *HTTPHeader) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

// See k8s.io.api.autoscaling.v2beta1.HorizontalPodAutoscalerSpec.
type HorizontalPodAutoscalerSpec struct {
	ScaleTargetRef       *CrossVersionObjectReference `protobuf:"bytes,1,opt,name=scaleTargetRef,proto3" json:"scaleTargetRef,omitempty"`
	MinReplicas          int32                        `protobuf:"varint,2,opt,name=minReplicas,proto3" json:"minReplicas,omitempty"`
	MaxReplicas          int32                        `protobuf:"varint,3,opt,name=maxReplicas,proto3" json:"maxReplicas,omitempty"`
	Metrics              []*MetricSpec                `protobuf:"bytes,4,rep,name=metrics,proto3" json:"metrics,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                     `json:"-"`
	XXX_unrecognized     []byte                       `json:"-"`
	XXX_sizecache        int32                        `json:"-"`
}

func (m *HorizontalPodAutoscalerSpec) Reset()         { *m = HorizontalPodAutoscalerSpec{} }
func (m *HorizontalPodAutoscalerSpec) String() string { return proto.CompactTextString(m) }
func (*HorizontalPodAutoscalerSpec) ProtoMessage()    {}
func (*HorizontalPodAutoscalerSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_8023ebf2dcfea843, []int{20}
}
func (m *HorizontalPodAutoscalerSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_HorizontalPodAutoscalerSpec.Unmarshal(m, b)
}
func (m *HorizontalPodAutoscalerSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_HorizontalPodAutoscalerSpec.Marshal(b, m, deterministic)
}
func (m *HorizontalPodAutoscalerSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HorizontalPodAutoscalerSpec.Merge(m, src)
}
func (m *HorizontalPodAutoscalerSpec) XXX_Size() int {
	return xxx_messageInfo_HorizontalPodAutoscalerSpec.Size(m)
}
func (m *HorizontalPodAutoscalerSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_HorizontalPodAutoscalerSpec.DiscardUnknown(m)
}

var xxx_messageInfo_HorizontalPodAutoscalerSpec proto.InternalMessageInfo

func (m *HorizontalPodAutoscalerSpec) GetScaleTargetRef() *CrossVersionObjectReference {
	if m != nil {
		return m.ScaleTargetRef
	}
	return nil
}

func (m *HorizontalPodAutoscalerSpec) GetMinReplicas() int32 {
	if m != nil {
		return m.MinReplicas
	}
	return 0
}

func (m *HorizontalPodAutoscalerSpec) GetMaxReplicas() int32 {
	if m != nil {
		return m.MaxReplicas
	}
	return 0
}

func (m *HorizontalPodAutoscalerSpec) GetMetrics() []*MetricSpec {
	if m != nil {
		return m.Metrics
	}
	return nil
}

// See k8s.io.api.core.v1.LocalObjectReference.
type LocalObjectReference struct {
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LocalObjectReference) Reset()         { *m = LocalObjectReference{} }
func (m *LocalObjectReference) String() string { return proto.CompactTextString(m) }
func (*LocalObjectReference) ProtoMessage()    {}
func (*LocalObjectReference) Descriptor() ([]byte, []int) {
	return fileDescriptor_8023ebf2dcfea843, []int{21}
}
func (m *LocalObjectReference) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LocalObjectReference.Unmarshal(m, b)
}
func (m *LocalObjectReference) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LocalObjectReference.Marshal(b, m, deterministic)
}
func (m *LocalObjectReference) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LocalObjectReference.Merge(m, src)
}
func (m *LocalObjectReference) XXX_Size() int {
	return xxx_messageInfo_LocalObjectReference.Size(m)
}
func (m *LocalObjectReference) XXX_DiscardUnknown() {
	xxx_messageInfo_LocalObjectReference.DiscardUnknown(m)
}

var xxx_messageInfo_LocalObjectReference proto.InternalMessageInfo

func (m *LocalObjectReference) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// See k8s.io.autoscaling.v2beta1.MetricSpec.
type MetricSpec struct {
	Type                 string                `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	Object               *ObjectMetricSource   `protobuf:"bytes,2,opt,name=object,proto3" json:"object,omitempty"`
	Pods                 *PodsMetricSource     `protobuf:"bytes,3,opt,name=pods,proto3" json:"pods,omitempty"`
	Resource             *ResourceMetricSource `protobuf:"bytes,4,opt,name=resource,proto3" json:"resource,omitempty"`
	External             *ExternalMetricSource `protobuf:"bytes,5,opt,name=external,proto3" json:"external,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *MetricSpec) Reset()         { *m = MetricSpec{} }
func (m *MetricSpec) String() string { return proto.CompactTextString(m) }
func (*MetricSpec) ProtoMessage()    {}
func (*MetricSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_8023ebf2dcfea843, []int{22}
}
func (m *MetricSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MetricSpec.Unmarshal(m, b)
}
func (m *MetricSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MetricSpec.Marshal(b, m, deterministic)
}
func (m *MetricSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MetricSpec.Merge(m, src)
}
func (m *MetricSpec) XXX_Size() int {
	return xxx_messageInfo_MetricSpec.Size(m)
}
func (m *MetricSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_MetricSpec.DiscardUnknown(m)
}

var xxx_messageInfo_MetricSpec proto.InternalMessageInfo

func (m *MetricSpec) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *MetricSpec) GetObject() *ObjectMetricSource {
	if m != nil {
		return m.Object
	}
	return nil
}

func (m *MetricSpec) GetPods() *PodsMetricSource {
	if m != nil {
		return m.Pods
	}
	return nil
}

func (m *MetricSpec) GetResource() *ResourceMetricSource {
	if m != nil {
		return m.Resource
	}
	return nil
}

func (m *MetricSpec) GetExternal() *ExternalMetricSource {
	if m != nil {
		return m.External
	}
	return nil
}

// See k8s.io.api.core.v1.NodeAffinity.
type NodeAffinity struct {
	RequiredDuringSchedulingIgnoredDuringExecution  *NodeSelector              `protobuf:"bytes,1,opt,name=requiredDuringSchedulingIgnoredDuringExecution,proto3" json:"requiredDuringSchedulingIgnoredDuringExecution,omitempty"`
	PreferredDuringSchedulingIgnoredDuringExecution []*PreferredSchedulingTerm `protobuf:"bytes,2,rep,name=preferredDuringSchedulingIgnoredDuringExecution,proto3" json:"preferredDuringSchedulingIgnoredDuringExecution,omitempty"`
	XXX_NoUnkeyedLiteral                            struct{}                   `json:"-"`
	XXX_unrecognized                                []byte                     `json:"-"`
	XXX_sizecache                                   int32                      `json:"-"`
}

func (m *NodeAffinity) Reset()         { *m = NodeAffinity{} }
func (m *NodeAffinity) String() string { return proto.CompactTextString(m) }
func (*NodeAffinity) ProtoMessage()    {}
func (*NodeAffinity) Descriptor() ([]byte, []int) {
	return fileDescriptor_8023ebf2dcfea843, []int{23}
}
func (m *NodeAffinity) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NodeAffinity.Unmarshal(m, b)
}
func (m *NodeAffinity) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NodeAffinity.Marshal(b, m, deterministic)
}
func (m *NodeAffinity) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NodeAffinity.Merge(m, src)
}
func (m *NodeAffinity) XXX_Size() int {
	return xxx_messageInfo_NodeAffinity.Size(m)
}
func (m *NodeAffinity) XXX_DiscardUnknown() {
	xxx_messageInfo_NodeAffinity.DiscardUnknown(m)
}

var xxx_messageInfo_NodeAffinity proto.InternalMessageInfo

func (m *NodeAffinity) GetRequiredDuringSchedulingIgnoredDuringExecution() *NodeSelector {
	if m != nil {
		return m.RequiredDuringSchedulingIgnoredDuringExecution
	}
	return nil
}

func (m *NodeAffinity) GetPreferredDuringSchedulingIgnoredDuringExecution() []*PreferredSchedulingTerm {
	if m != nil {
		return m.PreferredDuringSchedulingIgnoredDuringExecution
	}
	return nil
}

// See k8s.io.api.core.v1.NodeSelector.
type NodeSelector struct {
	NodeSelectorTerms    []*NodeSelectorTerm `protobuf:"bytes,1,rep,name=nodeSelectorTerms,proto3" json:"nodeSelectorTerms,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *NodeSelector) Reset()         { *m = NodeSelector{} }
func (m *NodeSelector) String() string { return proto.CompactTextString(m) }
func (*NodeSelector) ProtoMessage()    {}
func (*NodeSelector) Descriptor() ([]byte, []int) {
	return fileDescriptor_8023ebf2dcfea843, []int{24}
}
func (m *NodeSelector) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NodeSelector.Unmarshal(m, b)
}
func (m *NodeSelector) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NodeSelector.Marshal(b, m, deterministic)
}
func (m *NodeSelector) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NodeSelector.Merge(m, src)
}
func (m *NodeSelector) XXX_Size() int {
	return xxx_messageInfo_NodeSelector.Size(m)
}
func (m *NodeSelector) XXX_DiscardUnknown() {
	xxx_messageInfo_NodeSelector.DiscardUnknown(m)
}

var xxx_messageInfo_NodeSelector proto.InternalMessageInfo

func (m *NodeSelector) GetNodeSelectorTerms() []*NodeSelectorTerm {
	if m != nil {
		return m.NodeSelectorTerms
	}
	return nil
}

// See k8s.io.api.core.v1.NodeSelectorTerm.
type NodeSelectorTerm struct {
	MatchExpressions     []*NodeSelectorRequirement `protobuf:"bytes,1,rep,name=matchExpressions,proto3" json:"matchExpressions,omitempty"`
	MatchFields          []*NodeSelectorRequirement `protobuf:"bytes,2,rep,name=matchFields,proto3" json:"matchFields,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *NodeSelectorTerm) Reset()         { *m = NodeSelectorTerm{} }
func (m *NodeSelectorTerm) String() string { return proto.CompactTextString(m) }
func (*NodeSelectorTerm) ProtoMessage()    {}
func (*NodeSelectorTerm) Descriptor() ([]byte, []int) {
	return fileDescriptor_8023ebf2dcfea843, []int{25}
}
func (m *NodeSelectorTerm) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NodeSelectorTerm.Unmarshal(m, b)
}
func (m *NodeSelectorTerm) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NodeSelectorTerm.Marshal(b, m, deterministic)
}
func (m *NodeSelectorTerm) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NodeSelectorTerm.Merge(m, src)
}
func (m *NodeSelectorTerm) XXX_Size() int {
	return xxx_messageInfo_NodeSelectorTerm.Size(m)
}
func (m *NodeSelectorTerm) XXX_DiscardUnknown() {
	xxx_messageInfo_NodeSelectorTerm.DiscardUnknown(m)
}

var xxx_messageInfo_NodeSelectorTerm proto.InternalMessageInfo

func (m *NodeSelectorTerm) GetMatchExpressions() []*NodeSelectorRequirement {
	if m != nil {
		return m.MatchExpressions
	}
	return nil
}

func (m *NodeSelectorTerm) GetMatchFields() []*NodeSelectorRequirement {
	if m != nil {
		return m.MatchFields
	}
	return nil
}

// See k8s.io.api.core.v1.NodeSelectorRequirement.
type NodeSelectorRequirement struct {
	Key                  string   `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	Operator             string   `protobuf:"bytes,2,opt,name=operator,proto3" json:"operator,omitempty"`
	Values               []string `protobuf:"bytes,3,rep,name=values,proto3" json:"values,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *NodeSelectorRequirement) Reset()         { *m = NodeSelectorRequirement{} }
func (m *NodeSelectorRequirement) String() string { return proto.CompactTextString(m) }
func (*NodeSelectorRequirement) ProtoMessage()    {}
func (*NodeSelectorRequirement) Descriptor() ([]byte, []int) {
	return fileDescriptor_8023ebf2dcfea843, []int{26}
}
func (m *NodeSelectorRequirement) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NodeSelectorRequirement.Unmarshal(m, b)
}
func (m *NodeSelectorRequirement) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NodeSelectorRequirement.Marshal(b, m, deterministic)
}
func (m *NodeSelectorRequirement) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NodeSelectorRequirement.Merge(m, src)
}
func (m *NodeSelectorRequirement) XXX_Size() int {
	return xxx_messageInfo_NodeSelectorRequirement.Size(m)
}
func (m *NodeSelectorRequirement) XXX_DiscardUnknown() {
	xxx_messageInfo_NodeSelectorRequirement.DiscardUnknown(m)
}

var xxx_messageInfo_NodeSelectorRequirement proto.InternalMessageInfo

func (m *NodeSelectorRequirement) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

func (m *NodeSelectorRequirement) GetOperator() string {
	if m != nil {
		return m.Operator
	}
	return ""
}

func (m *NodeSelectorRequirement) GetValues() []string {
	if m != nil {
		return m.Values
	}
	return nil
}

// See k8s.io.api.core.v1.ObjectFieldSelector.
type ObjectFieldSelector struct {
	ApiVersion           string   `protobuf:"bytes,1,opt,name=apiVersion,proto3" json:"apiVersion,omitempty"`
	FieldPath            string   `protobuf:"bytes,2,opt,name=fieldPath,proto3" json:"fieldPath,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ObjectFieldSelector) Reset()         { *m = ObjectFieldSelector{} }
func (m *ObjectFieldSelector) String() string { return proto.CompactTextString(m) }
func (*ObjectFieldSelector) ProtoMessage()    {}
func (*ObjectFieldSelector) Descriptor() ([]byte, []int) {
	return fileDescriptor_8023ebf2dcfea843, []int{27}
}
func (m *ObjectFieldSelector) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ObjectFieldSelector.Unmarshal(m, b)
}
func (m *ObjectFieldSelector) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ObjectFieldSelector.Marshal(b, m, deterministic)
}
func (m *ObjectFieldSelector) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ObjectFieldSelector.Merge(m, src)
}
func (m *ObjectFieldSelector) XXX_Size() int {
	return xxx_messageInfo_ObjectFieldSelector.Size(m)
}
func (m *ObjectFieldSelector) XXX_DiscardUnknown() {
	xxx_messageInfo_ObjectFieldSelector.DiscardUnknown(m)
}

var xxx_messageInfo_ObjectFieldSelector proto.InternalMessageInfo

func (m *ObjectFieldSelector) GetApiVersion() string {
	if m != nil {
		return m.ApiVersion
	}
	return ""
}

func (m *ObjectFieldSelector) GetFieldPath() string {
	if m != nil {
		return m.FieldPath
	}
	return ""
}

// From k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta.
type ObjectMeta struct {
	Name                 string   `protobuf:"bytes,5,opt,name=name,proto3" json:"name,omitempty"`
	Namespace            string   `protobuf:"bytes,6,opt,name=namespace,proto3" json:"namespace,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ObjectMeta) Reset()         { *m = ObjectMeta{} }
func (m *ObjectMeta) String() string { return proto.CompactTextString(m) }
func (*ObjectMeta) ProtoMessage()    {}
func (*ObjectMeta) Descriptor() ([]byte, []int) {
	return fileDescriptor_8023ebf2dcfea843, []int{28}
}
func (m *ObjectMeta) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ObjectMeta.Unmarshal(m, b)
}
func (m *ObjectMeta) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ObjectMeta.Marshal(b, m, deterministic)
}
func (m *ObjectMeta) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ObjectMeta.Merge(m, src)
}
func (m *ObjectMeta) XXX_Size() int {
	return xxx_messageInfo_ObjectMeta.Size(m)
}
func (m *ObjectMeta) XXX_DiscardUnknown() {
	xxx_messageInfo_ObjectMeta.DiscardUnknown(m)
}

var xxx_messageInfo_ObjectMeta proto.InternalMessageInfo

func (m *ObjectMeta) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ObjectMeta) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

// See k8s.io.autoscaling.v2beta1.ObjectMetricSource.
type ObjectMetricSource struct {
	Target               *CrossVersionObjectReference `protobuf:"bytes,1,opt,name=target,proto3" json:"target,omitempty"`
	MetricName           string                       `protobuf:"bytes,2,opt,name=metricName,proto3" json:"metricName,omitempty"`
	TargetValue          *IntOrStringForPB        `protobuf:"bytes,3,opt,name=targetValue,proto3" json:"targetValue,omitempty"`
	Selector             *v11.LabelSelector           `protobuf:"bytes,4,opt,name=selector,proto3" json:"selector,omitempty"`
	AverageValue         *IntOrStringForPB        `protobuf:"bytes,5,opt,name=averageValue,proto3" json:"averageValue,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                     `json:"-"`
	XXX_unrecognized     []byte                       `json:"-"`
	XXX_sizecache        int32                        `json:"-"`
}

func (m *ObjectMetricSource) Reset()         { *m = ObjectMetricSource{} }
func (m *ObjectMetricSource) String() string { return proto.CompactTextString(m) }
func (*ObjectMetricSource) ProtoMessage()    {}
func (*ObjectMetricSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_8023ebf2dcfea843, []int{29}
}
func (m *ObjectMetricSource) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ObjectMetricSource.Unmarshal(m, b)
}
func (m *ObjectMetricSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ObjectMetricSource.Marshal(b, m, deterministic)
}
func (m *ObjectMetricSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ObjectMetricSource.Merge(m, src)
}
func (m *ObjectMetricSource) XXX_Size() int {
	return xxx_messageInfo_ObjectMetricSource.Size(m)
}
func (m *ObjectMetricSource) XXX_DiscardUnknown() {
	xxx_messageInfo_ObjectMetricSource.DiscardUnknown(m)
}

var xxx_messageInfo_ObjectMetricSource proto.InternalMessageInfo

func (m *ObjectMetricSource) GetTarget() *CrossVersionObjectReference {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *ObjectMetricSource) GetMetricName() string {
	if m != nil {
		return m.MetricName
	}
	return ""
}


func (m *ObjectMetricSource) GetSelector() *v11.LabelSelector {
	if m != nil {
		return m.Selector
	}
	return nil
}


// See k8s.io.api.core.v1.PodAffinity.
type PodAffinity struct {
	RequiredDuringSchedulingIgnoredDuringExecution  []*PodAffinityTerm         `protobuf:"bytes,1,rep,name=requiredDuringSchedulingIgnoredDuringExecution,proto3" json:"requiredDuringSchedulingIgnoredDuringExecution,omitempty"`
	PreferredDuringSchedulingIgnoredDuringExecution []*WeightedPodAffinityTerm `protobuf:"bytes,2,rep,name=preferredDuringSchedulingIgnoredDuringExecution,proto3" json:"preferredDuringSchedulingIgnoredDuringExecution,omitempty"`
	XXX_NoUnkeyedLiteral                            struct{}                   `json:"-"`
	XXX_unrecognized                                []byte                     `json:"-"`
	XXX_sizecache                                   int32                      `json:"-"`
}

func (m *PodAffinity) Reset()         { *m = PodAffinity{} }
func (m *PodAffinity) String() string { return proto.CompactTextString(m) }
func (*PodAffinity) ProtoMessage()    {}
func (*PodAffinity) Descriptor() ([]byte, []int) {
	return fileDescriptor_8023ebf2dcfea843, []int{30}
}
func (m *PodAffinity) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PodAffinity.Unmarshal(m, b)
}
func (m *PodAffinity) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PodAffinity.Marshal(b, m, deterministic)
}
func (m *PodAffinity) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PodAffinity.Merge(m, src)
}
func (m *PodAffinity) XXX_Size() int {
	return xxx_messageInfo_PodAffinity.Size(m)
}
func (m *PodAffinity) XXX_DiscardUnknown() {
	xxx_messageInfo_PodAffinity.DiscardUnknown(m)
}

var xxx_messageInfo_PodAffinity proto.InternalMessageInfo

func (m *PodAffinity) GetRequiredDuringSchedulingIgnoredDuringExecution() []*PodAffinityTerm {
	if m != nil {
		return m.RequiredDuringSchedulingIgnoredDuringExecution
	}
	return nil
}

func (m *PodAffinity) GetPreferredDuringSchedulingIgnoredDuringExecution() []*WeightedPodAffinityTerm {
	if m != nil {
		return m.PreferredDuringSchedulingIgnoredDuringExecution
	}
	return nil
}

// See k8s.io.api.core.v1.PodAntiAffinity.
type PodAntiAffinity struct {
	RequiredDuringSchedulingIgnoredDuringExecution  []*PodAffinityTerm         `protobuf:"bytes,1,rep,name=requiredDuringSchedulingIgnoredDuringExecution,proto3" json:"requiredDuringSchedulingIgnoredDuringExecution,omitempty"`
	PreferredDuringSchedulingIgnoredDuringExecution []*WeightedPodAffinityTerm `protobuf:"bytes,2,rep,name=preferredDuringSchedulingIgnoredDuringExecution,proto3" json:"preferredDuringSchedulingIgnoredDuringExecution,omitempty"`
	XXX_NoUnkeyedLiteral                            struct{}                   `json:"-"`
	XXX_unrecognized                                []byte                     `json:"-"`
	XXX_sizecache                                   int32                      `json:"-"`
}

func (m *PodAntiAffinity) Reset()         { *m = PodAntiAffinity{} }
func (m *PodAntiAffinity) String() string { return proto.CompactTextString(m) }
func (*PodAntiAffinity) ProtoMessage()    {}
func (*PodAntiAffinity) Descriptor() ([]byte, []int) {
	return fileDescriptor_8023ebf2dcfea843, []int{31}
}
func (m *PodAntiAffinity) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PodAntiAffinity.Unmarshal(m, b)
}
func (m *PodAntiAffinity) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PodAntiAffinity.Marshal(b, m, deterministic)
}
func (m *PodAntiAffinity) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PodAntiAffinity.Merge(m, src)
}
func (m *PodAntiAffinity) XXX_Size() int {
	return xxx_messageInfo_PodAntiAffinity.Size(m)
}
func (m *PodAntiAffinity) XXX_DiscardUnknown() {
	xxx_messageInfo_PodAntiAffinity.DiscardUnknown(m)
}

var xxx_messageInfo_PodAntiAffinity proto.InternalMessageInfo

func (m *PodAntiAffinity) GetRequiredDuringSchedulingIgnoredDuringExecution() []*PodAffinityTerm {
	if m != nil {
		return m.RequiredDuringSchedulingIgnoredDuringExecution
	}
	return nil
}

func (m *PodAntiAffinity) GetPreferredDuringSchedulingIgnoredDuringExecution() []*WeightedPodAffinityTerm {
	if m != nil {
		return m.PreferredDuringSchedulingIgnoredDuringExecution
	}
	return nil
}

// See k8s.io.api.core.v1.PodAntiAffinity.
type PodAffinityTerm struct {
	LabelSelector        *v11.LabelSelector `protobuf:"bytes,1,opt,name=labelSelector,proto3" json:"labelSelector,omitempty"`
	Namespaces           []string           `protobuf:"bytes,2,rep,name=namespaces,proto3" json:"namespaces,omitempty"`
	TopologyKey          string             `protobuf:"bytes,3,opt,name=topologyKey,proto3" json:"topologyKey,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *PodAffinityTerm) Reset()         { *m = PodAffinityTerm{} }
func (m *PodAffinityTerm) String() string { return proto.CompactTextString(m) }
func (*PodAffinityTerm) ProtoMessage()    {}
func (*PodAffinityTerm) Descriptor() ([]byte, []int) {
	return fileDescriptor_8023ebf2dcfea843, []int{32}
}
func (m *PodAffinityTerm) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PodAffinityTerm.Unmarshal(m, b)
}
func (m *PodAffinityTerm) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PodAffinityTerm.Marshal(b, m, deterministic)
}
func (m *PodAffinityTerm) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PodAffinityTerm.Merge(m, src)
}
func (m *PodAffinityTerm) XXX_Size() int {
	return xxx_messageInfo_PodAffinityTerm.Size(m)
}
func (m *PodAffinityTerm) XXX_DiscardUnknown() {
	xxx_messageInfo_PodAffinityTerm.DiscardUnknown(m)
}

var xxx_messageInfo_PodAffinityTerm proto.InternalMessageInfo

func (m *PodAffinityTerm) GetLabelSelector() *v11.LabelSelector {
	if m != nil {
		return m.LabelSelector
	}
	return nil
}

func (m *PodAffinityTerm) GetNamespaces() []string {
	if m != nil {
		return m.Namespaces
	}
	return nil
}

func (m *PodAffinityTerm) GetTopologyKey() string {
	if m != nil {
		return m.TopologyKey
	}
	return ""
}

// See k8s.io.api.policy.v1beta1.PodDisruptionBudget.
type PodDisruptionBudgetSpec struct {
	MinAvailable         uint32             `protobuf:"varint,1,opt,name=minAvailable,proto3" json:"minAvailable,omitempty"`
	Selector             *v11.LabelSelector `protobuf:"bytes,2,opt,name=selector,proto3" json:"selector,omitempty"`
	MaxUnavailable       uint32             `protobuf:"varint,3,opt,name=maxUnavailable,proto3" json:"maxUnavailable,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *PodDisruptionBudgetSpec) Reset()         { *m = PodDisruptionBudgetSpec{} }
func (m *PodDisruptionBudgetSpec) String() string { return proto.CompactTextString(m) }
func (*PodDisruptionBudgetSpec) ProtoMessage()    {}
func (*PodDisruptionBudgetSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_8023ebf2dcfea843, []int{33}
}
func (m *PodDisruptionBudgetSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PodDisruptionBudgetSpec.Unmarshal(m, b)
}
func (m *PodDisruptionBudgetSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PodDisruptionBudgetSpec.Marshal(b, m, deterministic)
}
func (m *PodDisruptionBudgetSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PodDisruptionBudgetSpec.Merge(m, src)
}
func (m *PodDisruptionBudgetSpec) XXX_Size() int {
	return xxx_messageInfo_PodDisruptionBudgetSpec.Size(m)
}
func (m *PodDisruptionBudgetSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_PodDisruptionBudgetSpec.DiscardUnknown(m)
}

var xxx_messageInfo_PodDisruptionBudgetSpec proto.InternalMessageInfo

func (m *PodDisruptionBudgetSpec) GetMinAvailable() uint32 {
	if m != nil {
		return m.MinAvailable
	}
	return 0
}

func (m *PodDisruptionBudgetSpec) GetSelector() *v11.LabelSelector {
	if m != nil {
		return m.Selector
	}
	return nil
}

func (m *PodDisruptionBudgetSpec) GetMaxUnavailable() uint32 {
	if m != nil {
		return m.MaxUnavailable
	}
	return 0
}

// See k8s.io.api.core.v1.PodsMetricSource.
type PodsMetricSource struct {
	MetricName           string                `protobuf:"bytes,1,opt,name=metricName,proto3" json:"metricName,omitempty"`
	TargetAverageValue   *IntOrStringForPB `protobuf:"bytes,2,opt,name=targetAverageValue,proto3" json:"targetAverageValue,omitempty"`
	Selector             *v11.LabelSelector    `protobuf:"bytes,3,opt,name=selector,proto3" json:"selector,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *PodsMetricSource) Reset()         { *m = PodsMetricSource{} }
func (m *PodsMetricSource) String() string { return proto.CompactTextString(m) }
func (*PodsMetricSource) ProtoMessage()    {}
func (*PodsMetricSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_8023ebf2dcfea843, []int{34}
}
func (m *PodsMetricSource) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PodsMetricSource.Unmarshal(m, b)
}
func (m *PodsMetricSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PodsMetricSource.Marshal(b, m, deterministic)
}
func (m *PodsMetricSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PodsMetricSource.Merge(m, src)
}
func (m *PodsMetricSource) XXX_Size() int {
	return xxx_messageInfo_PodsMetricSource.Size(m)
}
func (m *PodsMetricSource) XXX_DiscardUnknown() {
	xxx_messageInfo_PodsMetricSource.DiscardUnknown(m)
}

var xxx_messageInfo_PodsMetricSource proto.InternalMessageInfo

func (m *PodsMetricSource) GetMetricName() string {
	if m != nil {
		return m.MetricName
	}
	return ""
}


func (m *PodsMetricSource) GetSelector() *v11.LabelSelector {
	if m != nil {
		return m.Selector
	}
	return nil
}

// See k8s.io.api.core.v1.PreferredSchedulingTerm.
type PreferredSchedulingTerm struct {
	Weight               int32             `protobuf:"varint,1,opt,name=weight,proto3" json:"weight,omitempty"`
	Preference           *NodeSelectorTerm `protobuf:"bytes,2,opt,name=preference,proto3" json:"preference,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *PreferredSchedulingTerm) Reset()         { *m = PreferredSchedulingTerm{} }
func (m *PreferredSchedulingTerm) String() string { return proto.CompactTextString(m) }
func (*PreferredSchedulingTerm) ProtoMessage()    {}
func (*PreferredSchedulingTerm) Descriptor() ([]byte, []int) {
	return fileDescriptor_8023ebf2dcfea843, []int{35}
}
func (m *PreferredSchedulingTerm) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PreferredSchedulingTerm.Unmarshal(m, b)
}
func (m *PreferredSchedulingTerm) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PreferredSchedulingTerm.Marshal(b, m, deterministic)
}
func (m *PreferredSchedulingTerm) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PreferredSchedulingTerm.Merge(m, src)
}
func (m *PreferredSchedulingTerm) XXX_Size() int {
	return xxx_messageInfo_PreferredSchedulingTerm.Size(m)
}
func (m *PreferredSchedulingTerm) XXX_DiscardUnknown() {
	xxx_messageInfo_PreferredSchedulingTerm.DiscardUnknown(m)
}

var xxx_messageInfo_PreferredSchedulingTerm proto.InternalMessageInfo

func (m *PreferredSchedulingTerm) GetWeight() int32 {
	if m != nil {
		return m.Weight
	}
	return 0
}

func (m *PreferredSchedulingTerm) GetPreference() *NodeSelectorTerm {
	if m != nil {
		return m.Preference
	}
	return nil
}

// See k8s.io.api.core.v1.ReadinessProbe.
type ReadinessProbe struct {
	Exec                 *ExecAction      `protobuf:"bytes,1,opt,name=exec,proto3" json:"exec,omitempty"`
	HttpGet              *HTTPGetAction   `protobuf:"bytes,2,opt,name=httpGet,proto3" json:"httpGet,omitempty"`
	TcpSocket            *TCPSocketAction `protobuf:"bytes,3,opt,name=tcpSocket,proto3" json:"tcpSocket,omitempty"`
	InitialDelaySeconds  int32            `protobuf:"varint,4,opt,name=initialDelaySeconds,proto3" json:"initialDelaySeconds,omitempty"`
	TimeoutSeconds       int32            `protobuf:"varint,5,opt,name=timeoutSeconds,proto3" json:"timeoutSeconds,omitempty"`
	PeriodSeconds        int32            `protobuf:"varint,6,opt,name=periodSeconds,proto3" json:"periodSeconds,omitempty"`
	SuccessThreshold     int32            `protobuf:"varint,7,opt,name=successThreshold,proto3" json:"successThreshold,omitempty"`
	FailureThreshold     int32            `protobuf:"varint,8,opt,name=failureThreshold,proto3" json:"failureThreshold,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *ReadinessProbe) Reset()         { *m = ReadinessProbe{} }
func (m *ReadinessProbe) String() string { return proto.CompactTextString(m) }
func (*ReadinessProbe) ProtoMessage()    {}
func (*ReadinessProbe) Descriptor() ([]byte, []int) {
	return fileDescriptor_8023ebf2dcfea843, []int{36}
}
func (m *ReadinessProbe) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReadinessProbe.Unmarshal(m, b)
}
func (m *ReadinessProbe) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReadinessProbe.Marshal(b, m, deterministic)
}
func (m *ReadinessProbe) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReadinessProbe.Merge(m, src)
}
func (m *ReadinessProbe) XXX_Size() int {
	return xxx_messageInfo_ReadinessProbe.Size(m)
}
func (m *ReadinessProbe) XXX_DiscardUnknown() {
	xxx_messageInfo_ReadinessProbe.DiscardUnknown(m)
}

var xxx_messageInfo_ReadinessProbe proto.InternalMessageInfo

func (m *ReadinessProbe) GetExec() *ExecAction {
	if m != nil {
		return m.Exec
	}
	return nil
}

func (m *ReadinessProbe) GetHttpGet() *HTTPGetAction {
	if m != nil {
		return m.HttpGet
	}
	return nil
}

func (m *ReadinessProbe) GetTcpSocket() *TCPSocketAction {
	if m != nil {
		return m.TcpSocket
	}
	return nil
}

func (m *ReadinessProbe) GetInitialDelaySeconds() int32 {
	if m != nil {
		return m.InitialDelaySeconds
	}
	return 0
}

func (m *ReadinessProbe) GetTimeoutSeconds() int32 {
	if m != nil {
		return m.TimeoutSeconds
	}
	return 0
}

func (m *ReadinessProbe) GetPeriodSeconds() int32 {
	if m != nil {
		return m.PeriodSeconds
	}
	return 0
}

func (m *ReadinessProbe) GetSuccessThreshold() int32 {
	if m != nil {
		return m.SuccessThreshold
	}
	return 0
}

func (m *ReadinessProbe) GetFailureThreshold() int32 {
	if m != nil {
		return m.FailureThreshold
	}
	return 0
}

// See k8s.io.api.core.v1..
type ResourceFieldSelector struct {
	ContainerName        string                `protobuf:"bytes,1,opt,name=containerName,proto3" json:"containerName,omitempty"`
	Resource             string                `protobuf:"bytes,2,opt,name=resource,proto3" json:"resource,omitempty"`
	Divisor              *IntOrStringForPB `protobuf:"bytes,3,opt,name=divisor,proto3" json:"divisor,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *ResourceFieldSelector) Reset()         { *m = ResourceFieldSelector{} }
func (m *ResourceFieldSelector) String() string { return proto.CompactTextString(m) }
func (*ResourceFieldSelector) ProtoMessage()    {}
func (*ResourceFieldSelector) Descriptor() ([]byte, []int) {
	return fileDescriptor_8023ebf2dcfea843, []int{37}
}
func (m *ResourceFieldSelector) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ResourceFieldSelector.Unmarshal(m, b)
}
func (m *ResourceFieldSelector) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ResourceFieldSelector.Marshal(b, m, deterministic)
}
func (m *ResourceFieldSelector) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResourceFieldSelector.Merge(m, src)
}
func (m *ResourceFieldSelector) XXX_Size() int {
	return xxx_messageInfo_ResourceFieldSelector.Size(m)
}
func (m *ResourceFieldSelector) XXX_DiscardUnknown() {
	xxx_messageInfo_ResourceFieldSelector.DiscardUnknown(m)
}

var xxx_messageInfo_ResourceFieldSelector proto.InternalMessageInfo

func (m *ResourceFieldSelector) GetContainerName() string {
	if m != nil {
		return m.ContainerName
	}
	return ""
}

func (m *ResourceFieldSelector) GetResource() string {
	if m != nil {
		return m.Resource
	}
	return ""
}


// See k8s.io.api.core.v1.ResourceMetricSource.
type ResourceMetricSource struct {
	Name                     string                `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	TargetAverageUtilization int32                 `protobuf:"varint,2,opt,name=targetAverageUtilization,proto3" json:"targetAverageUtilization,omitempty"`
	TargetAverageValue       *IntOrStringForPB `protobuf:"bytes,3,opt,name=targetAverageValue,proto3" json:"targetAverageValue,omitempty"`
	XXX_NoUnkeyedLiteral     struct{}              `json:"-"`
	XXX_unrecognized         []byte                `json:"-"`
	XXX_sizecache            int32                 `json:"-"`
}

func (m *ResourceMetricSource) Reset()         { *m = ResourceMetricSource{} }
func (m *ResourceMetricSource) String() string { return proto.CompactTextString(m) }
func (*ResourceMetricSource) ProtoMessage()    {}
func (*ResourceMetricSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_8023ebf2dcfea843, []int{38}
}
func (m *ResourceMetricSource) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ResourceMetricSource.Unmarshal(m, b)
}
func (m *ResourceMetricSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ResourceMetricSource.Marshal(b, m, deterministic)
}
func (m *ResourceMetricSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResourceMetricSource.Merge(m, src)
}
func (m *ResourceMetricSource) XXX_Size() int {
	return xxx_messageInfo_ResourceMetricSource.Size(m)
}
func (m *ResourceMetricSource) XXX_DiscardUnknown() {
	xxx_messageInfo_ResourceMetricSource.DiscardUnknown(m)
}

var xxx_messageInfo_ResourceMetricSource proto.InternalMessageInfo

func (m *ResourceMetricSource) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ResourceMetricSource) GetTargetAverageUtilization() int32 {
	if m != nil {
		return m.TargetAverageUtilization
	}
	return 0
}


// See k8s.io.api.core.v1.ResourceRequirements.
type Resources struct {
	Limits               map[string]string `protobuf:"bytes,1,rep,name=limits,proto3" json:"limits,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	Requests             map[string]string `protobuf:"bytes,2,rep,name=requests,proto3" json:"requests,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *Resources) Reset()         { *m = Resources{} }
func (m *Resources) String() string { return proto.CompactTextString(m) }
func (*Resources) ProtoMessage()    {}
func (*Resources) Descriptor() ([]byte, []int) {
	return fileDescriptor_8023ebf2dcfea843, []int{39}
}
func (m *Resources) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Resources.Unmarshal(m, b)
}
func (m *Resources) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Resources.Marshal(b, m, deterministic)
}
func (m *Resources) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Resources.Merge(m, src)
}
func (m *Resources) XXX_Size() int {
	return xxx_messageInfo_Resources.Size(m)
}
func (m *Resources) XXX_DiscardUnknown() {
	xxx_messageInfo_Resources.DiscardUnknown(m)
}

var xxx_messageInfo_Resources proto.InternalMessageInfo

func (m *Resources) GetLimits() map[string]string {
	if m != nil {
		return m.Limits
	}
	return nil
}

func (m *Resources) GetRequests() map[string]string {
	if m != nil {
		return m.Requests
	}
	return nil
}

// See k8s.io.api.apps.v1.RollingUpdateDeployment.
type RollingUpdateDeployment struct {
	MaxUnavailable       *IntOrStringForPB `protobuf:"bytes,1,opt,name=maxUnavailable,proto3" json:"maxUnavailable,omitempty"`
	MaxSurge             *IntOrStringForPB `protobuf:"bytes,2,opt,name=maxSurge,proto3" json:"maxSurge,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *RollingUpdateDeployment) Reset()         { *m = RollingUpdateDeployment{} }
func (m *RollingUpdateDeployment) String() string { return proto.CompactTextString(m) }
func (*RollingUpdateDeployment) ProtoMessage()    {}
func (*RollingUpdateDeployment) Descriptor() ([]byte, []int) {
	return fileDescriptor_8023ebf2dcfea843, []int{40}
}
func (m *RollingUpdateDeployment) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RollingUpdateDeployment.Unmarshal(m, b)
}
func (m *RollingUpdateDeployment) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RollingUpdateDeployment.Marshal(b, m, deterministic)
}
func (m *RollingUpdateDeployment) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RollingUpdateDeployment.Merge(m, src)
}
func (m *RollingUpdateDeployment) XXX_Size() int {
	return xxx_messageInfo_RollingUpdateDeployment.Size(m)
}
func (m *RollingUpdateDeployment) XXX_DiscardUnknown() {
	xxx_messageInfo_RollingUpdateDeployment.DiscardUnknown(m)
}

var xxx_messageInfo_RollingUpdateDeployment proto.InternalMessageInfo



// See k8s.io.api.core.v1.SecretKeySelector.
type SecretKeySelector struct {
	LocalObjectReference *LocalObjectReference `protobuf:"bytes,1,opt,name=localObjectReference,proto3" json:"localObjectReference,omitempty"`
	Key                  string                `protobuf:"bytes,2,opt,name=key,proto3" json:"key,omitempty"`
	Optional             bool                  `protobuf:"varint,3,opt,name=optional,proto3" json:"optional,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *SecretKeySelector) Reset()         { *m = SecretKeySelector{} }
func (m *SecretKeySelector) String() string { return proto.CompactTextString(m) }
func (*SecretKeySelector) ProtoMessage()    {}
func (*SecretKeySelector) Descriptor() ([]byte, []int) {
	return fileDescriptor_8023ebf2dcfea843, []int{41}
}
func (m *SecretKeySelector) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SecretKeySelector.Unmarshal(m, b)
}
func (m *SecretKeySelector) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SecretKeySelector.Marshal(b, m, deterministic)
}
func (m *SecretKeySelector) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SecretKeySelector.Merge(m, src)
}
func (m *SecretKeySelector) XXX_Size() int {
	return xxx_messageInfo_SecretKeySelector.Size(m)
}
func (m *SecretKeySelector) XXX_DiscardUnknown() {
	xxx_messageInfo_SecretKeySelector.DiscardUnknown(m)
}

var xxx_messageInfo_SecretKeySelector proto.InternalMessageInfo

func (m *SecretKeySelector) GetLocalObjectReference() *LocalObjectReference {
	if m != nil {
		return m.LocalObjectReference
	}
	return nil
}

func (m *SecretKeySelector) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

func (m *SecretKeySelector) GetOptional() bool {
	if m != nil {
		return m.Optional
	}
	return false
}

// See k8s.io.api.core.v1.ServiceSpec.
type ServiceSpec struct {
	Ports                    []*ServicePort         `protobuf:"bytes,1,rep,name=ports,proto3" json:"ports,omitempty"`
	Selector                 map[string]string      `protobuf:"bytes,2,rep,name=selector,proto3" json:"selector,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	ClusterIP                string                 `protobuf:"bytes,3,opt,name=clusterIP,proto3" json:"clusterIP,omitempty"`
	Type                     string                 `protobuf:"bytes,4,opt,name=type,proto3" json:"type,omitempty"`
	ExternalIPs              []string               `protobuf:"bytes,5,rep,name=externalIPs,proto3" json:"externalIPs,omitempty"`
	SessionAffinity          string                 `protobuf:"bytes,7,opt,name=sessionAffinity,proto3" json:"sessionAffinity,omitempty"`
	LoadBalancerIP           string                 `protobuf:"bytes,8,opt,name=loadBalancerIP,proto3" json:"loadBalancerIP,omitempty"`
	LoadBalancerSourceRanges []string               `protobuf:"bytes,9,rep,name=loadBalancerSourceRanges,proto3" json:"loadBalancerSourceRanges,omitempty"`
	ExternalName             string                 `protobuf:"bytes,10,opt,name=externalName,proto3" json:"externalName,omitempty"`
	ExternalTrafficPolicy    string                 `protobuf:"bytes,11,opt,name=externalTrafficPolicy,proto3" json:"externalTrafficPolicy,omitempty"`
	HealthCheckNodePort      int32                  `protobuf:"varint,12,opt,name=healthCheckNodePort,proto3" json:"healthCheckNodePort,omitempty"`
	PublishNotReadyAddresses bool                   `protobuf:"varint,13,opt,name=publishNotReadyAddresses,proto3" json:"publishNotReadyAddresses,omitempty"`
	SessionAffinityConfig    *SessionAffinityConfig `protobuf:"bytes,14,opt,name=sessionAffinityConfig,proto3" json:"sessionAffinityConfig,omitempty"`
	XXX_NoUnkeyedLiteral     struct{}               `json:"-"`
	XXX_unrecognized         []byte                 `json:"-"`
	XXX_sizecache            int32                  `json:"-"`
}

func (m *ServiceSpec) Reset()         { *m = ServiceSpec{} }
func (m *ServiceSpec) String() string { return proto.CompactTextString(m) }
func (*ServiceSpec) ProtoMessage()    {}
func (*ServiceSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_8023ebf2dcfea843, []int{42}
}
func (m *ServiceSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ServiceSpec.Unmarshal(m, b)
}
func (m *ServiceSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ServiceSpec.Marshal(b, m, deterministic)
}
func (m *ServiceSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ServiceSpec.Merge(m, src)
}
func (m *ServiceSpec) XXX_Size() int {
	return xxx_messageInfo_ServiceSpec.Size(m)
}
func (m *ServiceSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_ServiceSpec.DiscardUnknown(m)
}

var xxx_messageInfo_ServiceSpec proto.InternalMessageInfo

func (m *ServiceSpec) GetPorts() []*ServicePort {
	if m != nil {
		return m.Ports
	}
	return nil
}

func (m *ServiceSpec) GetSelector() map[string]string {
	if m != nil {
		return m.Selector
	}
	return nil
}

func (m *ServiceSpec) GetClusterIP() string {
	if m != nil {
		return m.ClusterIP
	}
	return ""
}

func (m *ServiceSpec) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *ServiceSpec) GetExternalIPs() []string {
	if m != nil {
		return m.ExternalIPs
	}
	return nil
}

func (m *ServiceSpec) GetSessionAffinity() string {
	if m != nil {
		return m.SessionAffinity
	}
	return ""
}

func (m *ServiceSpec) GetLoadBalancerIP() string {
	if m != nil {
		return m.LoadBalancerIP
	}
	return ""
}

func (m *ServiceSpec) GetLoadBalancerSourceRanges() []string {
	if m != nil {
		return m.LoadBalancerSourceRanges
	}
	return nil
}

func (m *ServiceSpec) GetExternalName() string {
	if m != nil {
		return m.ExternalName
	}
	return ""
}

func (m *ServiceSpec) GetExternalTrafficPolicy() string {
	if m != nil {
		return m.ExternalTrafficPolicy
	}
	return ""
}

func (m *ServiceSpec) GetHealthCheckNodePort() int32 {
	if m != nil {
		return m.HealthCheckNodePort
	}
	return 0
}

func (m *ServiceSpec) GetPublishNotReadyAddresses() bool {
	if m != nil {
		return m.PublishNotReadyAddresses
	}
	return false
}

func (m *ServiceSpec) GetSessionAffinityConfig() *SessionAffinityConfig {
	if m != nil {
		return m.SessionAffinityConfig
	}
	return nil
}

// See k8s.io.api.core.v1..
type ServicePort struct {
	Name                 string                `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Protocol             string                `protobuf:"bytes,2,opt,name=protocol,proto3" json:"protocol,omitempty"`
	Port                 int32                 `protobuf:"varint,3,opt,name=port,proto3" json:"port,omitempty"`
	TargetPort           *IntOrStringForPB `protobuf:"bytes,4,opt,name=targetPort,proto3" json:"targetPort,omitempty"`
	NodePort             int32                 `protobuf:"varint,5,opt,name=nodePort,proto3" json:"nodePort,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *ServicePort) Reset()         { *m = ServicePort{} }
func (m *ServicePort) String() string { return proto.CompactTextString(m) }
func (*ServicePort) ProtoMessage()    {}
func (*ServicePort) Descriptor() ([]byte, []int) {
	return fileDescriptor_8023ebf2dcfea843, []int{43}
}
func (m *ServicePort) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ServicePort.Unmarshal(m, b)
}
func (m *ServicePort) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ServicePort.Marshal(b, m, deterministic)
}
func (m *ServicePort) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ServicePort.Merge(m, src)
}
func (m *ServicePort) XXX_Size() int {
	return xxx_messageInfo_ServicePort.Size(m)
}
func (m *ServicePort) XXX_DiscardUnknown() {
	xxx_messageInfo_ServicePort.DiscardUnknown(m)
}

var xxx_messageInfo_ServicePort proto.InternalMessageInfo

func (m *ServicePort) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ServicePort) GetProtocol() string {
	if m != nil {
		return m.Protocol
	}
	return ""
}

func (m *ServicePort) GetPort() int32 {
	if m != nil {
		return m.Port
	}
	return 0
}


func (m *ServicePort) GetNodePort() int32 {
	if m != nil {
		return m.NodePort
	}
	return 0
}

// See k8s.io.api.core.v1.SessionAffinityConfig.
type SessionAffinityConfig struct {
	ClientIP             *ClientIPConfig `protobuf:"bytes,1,opt,name=clientIP,proto3" json:"clientIP,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *SessionAffinityConfig) Reset()         { *m = SessionAffinityConfig{} }
func (m *SessionAffinityConfig) String() string { return proto.CompactTextString(m) }
func (*SessionAffinityConfig) ProtoMessage()    {}
func (*SessionAffinityConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_8023ebf2dcfea843, []int{44}
}
func (m *SessionAffinityConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SessionAffinityConfig.Unmarshal(m, b)
}
func (m *SessionAffinityConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SessionAffinityConfig.Marshal(b, m, deterministic)
}
func (m *SessionAffinityConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SessionAffinityConfig.Merge(m, src)
}
func (m *SessionAffinityConfig) XXX_Size() int {
	return xxx_messageInfo_SessionAffinityConfig.Size(m)
}
func (m *SessionAffinityConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_SessionAffinityConfig.DiscardUnknown(m)
}

var xxx_messageInfo_SessionAffinityConfig proto.InternalMessageInfo

func (m *SessionAffinityConfig) GetClientIP() *ClientIPConfig {
	if m != nil {
		return m.ClientIP
	}
	return nil
}

// See k8s.io.api.core.v1.TCPSocketAction.
type TCPSocketAction struct {
	Port                 *IntOrStringForPB `protobuf:"bytes,1,opt,name=port,proto3" json:"port,omitempty"`
	Host                 string                `protobuf:"bytes,2,opt,name=host,proto3" json:"host,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *TCPSocketAction) Reset()         { *m = TCPSocketAction{} }
func (m *TCPSocketAction) String() string { return proto.CompactTextString(m) }
func (*TCPSocketAction) ProtoMessage()    {}
func (*TCPSocketAction) Descriptor() ([]byte, []int) {
	return fileDescriptor_8023ebf2dcfea843, []int{45}
}
func (m *TCPSocketAction) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TCPSocketAction.Unmarshal(m, b)
}
func (m *TCPSocketAction) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TCPSocketAction.Marshal(b, m, deterministic)
}
func (m *TCPSocketAction) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TCPSocketAction.Merge(m, src)
}
func (m *TCPSocketAction) XXX_Size() int {
	return xxx_messageInfo_TCPSocketAction.Size(m)
}
func (m *TCPSocketAction) XXX_DiscardUnknown() {
	xxx_messageInfo_TCPSocketAction.DiscardUnknown(m)
}

var xxx_messageInfo_TCPSocketAction proto.InternalMessageInfo


func (m *TCPSocketAction) GetHost() string {
	if m != nil {
		return m.Host
	}
	return ""
}

// See k8s.io.api.core.v1.Toleration.
type Toleration struct {
	Key                  string   `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	Operator             string   `protobuf:"bytes,2,opt,name=operator,proto3" json:"operator,omitempty"`
	Value                string   `protobuf:"bytes,3,opt,name=value,proto3" json:"value,omitempty"`
	Effect               string   `protobuf:"bytes,4,opt,name=effect,proto3" json:"effect,omitempty"`
	TolerationSeconds    int64    `protobuf:"varint,5,opt,name=tolerationSeconds,proto3" json:"tolerationSeconds,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Toleration) Reset()         { *m = Toleration{} }
func (m *Toleration) String() string { return proto.CompactTextString(m) }
func (*Toleration) ProtoMessage()    {}
func (*Toleration) Descriptor() ([]byte, []int) {
	return fileDescriptor_8023ebf2dcfea843, []int{46}
}
func (m *Toleration) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Toleration.Unmarshal(m, b)
}
func (m *Toleration) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Toleration.Marshal(b, m, deterministic)
}
func (m *Toleration) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Toleration.Merge(m, src)
}
func (m *Toleration) XXX_Size() int {
	return xxx_messageInfo_Toleration.Size(m)
}
func (m *Toleration) XXX_DiscardUnknown() {
	xxx_messageInfo_Toleration.DiscardUnknown(m)
}

var xxx_messageInfo_Toleration proto.InternalMessageInfo

func (m *Toleration) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

func (m *Toleration) GetOperator() string {
	if m != nil {
		return m.Operator
	}
	return ""
}

func (m *Toleration) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

func (m *Toleration) GetEffect() string {
	if m != nil {
		return m.Effect
	}
	return ""
}

func (m *Toleration) GetTolerationSeconds() int64 {
	if m != nil {
		return m.TolerationSeconds
	}
	return 0
}

// See k8s.io.api.core.v1.WeightedPodAffinityTerm.
type WeightedPodAffinityTerm struct {
	Weight               int32            `protobuf:"varint,1,opt,name=weight,proto3" json:"weight,omitempty"`
	PodAffinityTerm      *PodAffinityTerm `protobuf:"bytes,2,opt,name=podAffinityTerm,proto3" json:"podAffinityTerm,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *WeightedPodAffinityTerm) Reset()         { *m = WeightedPodAffinityTerm{} }
func (m *WeightedPodAffinityTerm) String() string { return proto.CompactTextString(m) }
func (*WeightedPodAffinityTerm) ProtoMessage()    {}
func (*WeightedPodAffinityTerm) Descriptor() ([]byte, []int) {
	return fileDescriptor_8023ebf2dcfea843, []int{47}
}
func (m *WeightedPodAffinityTerm) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_WeightedPodAffinityTerm.Unmarshal(m, b)
}
func (m *WeightedPodAffinityTerm) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_WeightedPodAffinityTerm.Marshal(b, m, deterministic)
}
func (m *WeightedPodAffinityTerm) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WeightedPodAffinityTerm.Merge(m, src)
}
func (m *WeightedPodAffinityTerm) XXX_Size() int {
	return xxx_messageInfo_WeightedPodAffinityTerm.Size(m)
}
func (m *WeightedPodAffinityTerm) XXX_DiscardUnknown() {
	xxx_messageInfo_WeightedPodAffinityTerm.DiscardUnknown(m)
}

var xxx_messageInfo_WeightedPodAffinityTerm proto.InternalMessageInfo

func (m *WeightedPodAffinityTerm) GetWeight() int32 {
	if m != nil {
		return m.Weight
	}
	return 0
}

func (m *WeightedPodAffinityTerm) GetPodAffinityTerm() *PodAffinityTerm {
	if m != nil {
		return m.PodAffinityTerm
	}
	return nil
}

// See k8s.io.api.core.v1.PodSecurityContext.
type PodSecurityContext struct {
	SeLinuxOptions       *SELinuxOptions                `protobuf:"bytes,1,opt,name=seLinuxOptions,proto3" json:"seLinuxOptions,omitempty"`
	RunAsUser            int64                          `protobuf:"varint,2,opt,name=runAsUser,proto3" json:"runAsUser,omitempty"`
	RunAsNonRoot         bool                           `protobuf:"varint,3,opt,name=runAsNonRoot,proto3" json:"runAsNonRoot,omitempty"`
	SupplementalGroups   []int64                        `protobuf:"varint,4,rep,packed,name=supplementalGroups,proto3" json:"supplementalGroups,omitempty"`
	FsGroup              int64                          `protobuf:"varint,5,opt,name=fsGroup,proto3" json:"fsGroup,omitempty"`
	RunAsGroup           int64                          `protobuf:"varint,6,opt,name=runAsGroup,proto3" json:"runAsGroup,omitempty"`
	Sysctls              []*Sysctl                      `protobuf:"bytes,7,rep,name=sysctls,proto3" json:"sysctls,omitempty"`
	WindowsOptions       *WindowsSecurityContextOptions `protobuf:"bytes,8,opt,name=windowsOptions,proto3" json:"windowsOptions,omitempty"`
	FsGroupChangePolicy  string                         `protobuf:"bytes,9,opt,name=fsGroupChangePolicy,proto3" json:"fsGroupChangePolicy,omitempty"`
	SeccompProfile       *SeccompProfile                `protobuf:"bytes,10,opt,name=seccompProfile,proto3" json:"seccompProfile,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                       `json:"-"`
	XXX_unrecognized     []byte                         `json:"-"`
	XXX_sizecache        int32                          `json:"-"`
}

func (m *PodSecurityContext) Reset()         { *m = PodSecurityContext{} }
func (m *PodSecurityContext) String() string { return proto.CompactTextString(m) }
func (*PodSecurityContext) ProtoMessage()    {}
func (*PodSecurityContext) Descriptor() ([]byte, []int) {
	return fileDescriptor_8023ebf2dcfea843, []int{48}
}
func (m *PodSecurityContext) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PodSecurityContext.Unmarshal(m, b)
}
func (m *PodSecurityContext) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PodSecurityContext.Marshal(b, m, deterministic)
}
func (m *PodSecurityContext) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PodSecurityContext.Merge(m, src)
}
func (m *PodSecurityContext) XXX_Size() int {
	return xxx_messageInfo_PodSecurityContext.Size(m)
}
func (m *PodSecurityContext) XXX_DiscardUnknown() {
	xxx_messageInfo_PodSecurityContext.DiscardUnknown(m)
}

var xxx_messageInfo_PodSecurityContext proto.InternalMessageInfo

func (m *PodSecurityContext) GetSeLinuxOptions() *SELinuxOptions {
	if m != nil {
		return m.SeLinuxOptions
	}
	return nil
}

func (m *PodSecurityContext) GetRunAsUser() int64 {
	if m != nil {
		return m.RunAsUser
	}
	return 0
}

func (m *PodSecurityContext) GetRunAsNonRoot() bool {
	if m != nil {
		return m.RunAsNonRoot
	}
	return false
}

func (m *PodSecurityContext) GetSupplementalGroups() []int64 {
	if m != nil {
		return m.SupplementalGroups
	}
	return nil
}

func (m *PodSecurityContext) GetFsGroup() int64 {
	if m != nil {
		return m.FsGroup
	}
	return 0
}

func (m *PodSecurityContext) GetRunAsGroup() int64 {
	if m != nil {
		return m.RunAsGroup
	}
	return 0
}

func (m *PodSecurityContext) GetSysctls() []*Sysctl {
	if m != nil {
		return m.Sysctls
	}
	return nil
}

func (m *PodSecurityContext) GetWindowsOptions() *WindowsSecurityContextOptions {
	if m != nil {
		return m.WindowsOptions
	}
	return nil
}

func (m *PodSecurityContext) GetFsGroupChangePolicy() string {
	if m != nil {
		return m.FsGroupChangePolicy
	}
	return ""
}

func (m *PodSecurityContext) GetSeccompProfile() *SeccompProfile {
	if m != nil {
		return m.SeccompProfile
	}
	return nil
}

// See k8s.io.api.core.v1.SELinuxOptions.
type SELinuxOptions struct {
	User                 string   `protobuf:"bytes,1,opt,name=user,proto3" json:"user,omitempty"`
	Role                 string   `protobuf:"bytes,2,opt,name=role,proto3" json:"role,omitempty"`
	Type                 string   `protobuf:"bytes,3,opt,name=type,proto3" json:"type,omitempty"`
	Level                string   `protobuf:"bytes,4,opt,name=level,proto3" json:"level,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SELinuxOptions) Reset()         { *m = SELinuxOptions{} }
func (m *SELinuxOptions) String() string { return proto.CompactTextString(m) }
func (*SELinuxOptions) ProtoMessage()    {}
func (*SELinuxOptions) Descriptor() ([]byte, []int) {
	return fileDescriptor_8023ebf2dcfea843, []int{49}
}
func (m *SELinuxOptions) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SELinuxOptions.Unmarshal(m, b)
}
func (m *SELinuxOptions) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SELinuxOptions.Marshal(b, m, deterministic)
}
func (m *SELinuxOptions) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SELinuxOptions.Merge(m, src)
}
func (m *SELinuxOptions) XXX_Size() int {
	return xxx_messageInfo_SELinuxOptions.Size(m)
}
func (m *SELinuxOptions) XXX_DiscardUnknown() {
	xxx_messageInfo_SELinuxOptions.DiscardUnknown(m)
}

var xxx_messageInfo_SELinuxOptions proto.InternalMessageInfo

func (m *SELinuxOptions) GetUser() string {
	if m != nil {
		return m.User
	}
	return ""
}

func (m *SELinuxOptions) GetRole() string {
	if m != nil {
		return m.Role
	}
	return ""
}

func (m *SELinuxOptions) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *SELinuxOptions) GetLevel() string {
	if m != nil {
		return m.Level
	}
	return ""
}

// See k8s.io.api.core.v1.Sysctl.
type Sysctl struct {
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Value                string   `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Sysctl) Reset()         { *m = Sysctl{} }
func (m *Sysctl) String() string { return proto.CompactTextString(m) }
func (*Sysctl) ProtoMessage()    {}
func (*Sysctl) Descriptor() ([]byte, []int) {
	return fileDescriptor_8023ebf2dcfea843, []int{50}
}
func (m *Sysctl) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Sysctl.Unmarshal(m, b)
}
func (m *Sysctl) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Sysctl.Marshal(b, m, deterministic)
}
func (m *Sysctl) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Sysctl.Merge(m, src)
}
func (m *Sysctl) XXX_Size() int {
	return xxx_messageInfo_Sysctl.Size(m)
}
func (m *Sysctl) XXX_DiscardUnknown() {
	xxx_messageInfo_Sysctl.DiscardUnknown(m)
}

var xxx_messageInfo_Sysctl proto.InternalMessageInfo

func (m *Sysctl) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Sysctl) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

// See k8s.io.api.core.v1.WindowsSecurityContextOptions.
type WindowsSecurityContextOptions struct {
	GmsaCredentialSpecName string   `protobuf:"bytes,1,opt,name=gmsaCredentialSpecName,proto3" json:"gmsaCredentialSpecName,omitempty"`
	GmsaCredentialSpec     string   `protobuf:"bytes,2,opt,name=gmsaCredentialSpec,proto3" json:"gmsaCredentialSpec,omitempty"`
	RunAsUserName          string   `protobuf:"bytes,3,opt,name=runAsUserName,proto3" json:"runAsUserName,omitempty"`
	XXX_NoUnkeyedLiteral   struct{} `json:"-"`
	XXX_unrecognized       []byte   `json:"-"`
	XXX_sizecache          int32    `json:"-"`
}

func (m *WindowsSecurityContextOptions) Reset()         { *m = WindowsSecurityContextOptions{} }
func (m *WindowsSecurityContextOptions) String() string { return proto.CompactTextString(m) }
func (*WindowsSecurityContextOptions) ProtoMessage()    {}
func (*WindowsSecurityContextOptions) Descriptor() ([]byte, []int) {
	return fileDescriptor_8023ebf2dcfea843, []int{51}
}
func (m *WindowsSecurityContextOptions) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_WindowsSecurityContextOptions.Unmarshal(m, b)
}
func (m *WindowsSecurityContextOptions) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_WindowsSecurityContextOptions.Marshal(b, m, deterministic)
}
func (m *WindowsSecurityContextOptions) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WindowsSecurityContextOptions.Merge(m, src)
}
func (m *WindowsSecurityContextOptions) XXX_Size() int {
	return xxx_messageInfo_WindowsSecurityContextOptions.Size(m)
}
func (m *WindowsSecurityContextOptions) XXX_DiscardUnknown() {
	xxx_messageInfo_WindowsSecurityContextOptions.DiscardUnknown(m)
}

var xxx_messageInfo_WindowsSecurityContextOptions proto.InternalMessageInfo

func (m *WindowsSecurityContextOptions) GetGmsaCredentialSpecName() string {
	if m != nil {
		return m.GmsaCredentialSpecName
	}
	return ""
}

func (m *WindowsSecurityContextOptions) GetGmsaCredentialSpec() string {
	if m != nil {
		return m.GmsaCredentialSpec
	}
	return ""
}

func (m *WindowsSecurityContextOptions) GetRunAsUserName() string {
	if m != nil {
		return m.RunAsUserName
	}
	return ""
}

// See k8s.io.api.core.v1.SeccompProfile.
type SeccompProfile struct {
	Type                 string   `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	LocalhostProfile     string   `protobuf:"bytes,2,opt,name=localhostProfile,proto3" json:"localhostProfile,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SeccompProfile) Reset()         { *m = SeccompProfile{} }
func (m *SeccompProfile) String() string { return proto.CompactTextString(m) }
func (*SeccompProfile) ProtoMessage()    {}
func (*SeccompProfile) Descriptor() ([]byte, []int) {
	return fileDescriptor_8023ebf2dcfea843, []int{52}
}
func (m *SeccompProfile) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SeccompProfile.Unmarshal(m, b)
}
func (m *SeccompProfile) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SeccompProfile.Marshal(b, m, deterministic)
}
func (m *SeccompProfile) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SeccompProfile.Merge(m, src)
}
func (m *SeccompProfile) XXX_Size() int {
	return xxx_messageInfo_SeccompProfile.Size(m)
}
func (m *SeccompProfile) XXX_DiscardUnknown() {
	xxx_messageInfo_SeccompProfile.DiscardUnknown(m)
}

var xxx_messageInfo_SeccompProfile proto.InternalMessageInfo

func (m *SeccompProfile) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *SeccompProfile) GetLocalhostProfile() string {
	if m != nil {
		return m.LocalhostProfile
	}
	return ""
}

// Synthetic type for generating Go structs.

// Synthetic type for generating Go structs.

// Synthetic type for generating Go structs.

// Synthetic type for generating Go structs.

func init() {
	proto.RegisterEnum("istio.operator.v1alpha1.InstallStatus_Status", InstallStatus_Status_name, InstallStatus_Status_value)
	proto.RegisterType((*IstioOperatorSpec)(nil), "istio.operator.v1alpha1.IstioOperatorSpec")
	proto.RegisterMapType((map[string]*ExternalComponentSpec)(nil), "istio.operator.v1alpha1.IstioOperatorSpec.AddonComponentsEntry")
	proto.RegisterType((*InstallStatus)(nil), "istio.operator.v1alpha1.InstallStatus")
	proto.RegisterMapType((map[string]*InstallStatus_VersionStatus)(nil), "istio.operator.v1alpha1.InstallStatus.ComponentStatusEntry")
	proto.RegisterType((*InstallStatus_VersionStatus)(nil), "istio.operator.v1alpha1.InstallStatus.VersionStatus")
	proto.RegisterType((*IstioComponentSetSpec)(nil), "istio.operator.v1alpha1.IstioComponentSetSpec")
	proto.RegisterType((*BaseComponentSpec)(nil), "istio.operator.v1alpha1.BaseComponentSpec")
	proto.RegisterType((*ComponentSpec)(nil), "istio.operator.v1alpha1.ComponentSpec")
	proto.RegisterType((*ExternalComponentSpec)(nil), "istio.operator.v1alpha1.ExternalComponentSpec")
	proto.RegisterType((*GatewaySpec)(nil), "istio.operator.v1alpha1.GatewaySpec")
	proto.RegisterMapType((map[string]string)(nil), "istio.operator.v1alpha1.GatewaySpec.LabelEntry")
	proto.RegisterType((*KubernetesResourcesSpec)(nil), "istio.operator.v1alpha1.KubernetesResourcesSpec")
	proto.RegisterMapType((map[string]string)(nil), "istio.operator.v1alpha1.KubernetesResourcesSpec.NodeSelectorEntry")
	proto.RegisterMapType((map[string]string)(nil), "istio.operator.v1alpha1.KubernetesResourcesSpec.PodAnnotationsEntry")
	proto.RegisterMapType((map[string]string)(nil), "istio.operator.v1alpha1.KubernetesResourcesSpec.ServiceAnnotationsEntry")
	proto.RegisterType((*K8SObjectOverlay)(nil), "istio.operator.v1alpha1.K8sObjectOverlay")
	proto.RegisterType((*K8SObjectOverlay_PathValue)(nil), "istio.operator.v1alpha1.K8sObjectOverlay.PathValue")
	proto.RegisterType((*Affinity)(nil), "istio.operator.v1alpha1.Affinity")
	proto.RegisterType((*ConfigMapKeySelector)(nil), "istio.operator.v1alpha1.ConfigMapKeySelector")
	proto.RegisterType((*ClientIPConfig)(nil), "istio.operator.v1alpha1.ClientIPConfig")
	proto.RegisterType((*CrossVersionObjectReference)(nil), "istio.operator.v1alpha1.CrossVersionObjectReference")
	proto.RegisterType((*DeploymentStrategy)(nil), "istio.operator.v1alpha1.DeploymentStrategy")
	proto.RegisterType((*EnvVar)(nil), "istio.operator.v1alpha1.EnvVar")
	proto.RegisterType((*EnvVarSource)(nil), "istio.operator.v1alpha1.EnvVarSource")
	proto.RegisterType((*ExecAction)(nil), "istio.operator.v1alpha1.ExecAction")
	proto.RegisterType((*ExternalMetricSource)(nil), "istio.operator.v1alpha1.ExternalMetricSource")
	proto.RegisterType((*HTTPGetAction)(nil), "istio.operator.v1alpha1.HTTPGetAction")
	proto.RegisterType((*HTTPHeader)(nil), "istio.operator.v1alpha1.HTTPHeader")
	proto.RegisterType((*HorizontalPodAutoscalerSpec)(nil), "istio.operator.v1alpha1.HorizontalPodAutoscalerSpec")
	proto.RegisterType((*LocalObjectReference)(nil), "istio.operator.v1alpha1.LocalObjectReference")
	proto.RegisterType((*MetricSpec)(nil), "istio.operator.v1alpha1.MetricSpec")
	proto.RegisterType((*NodeAffinity)(nil), "istio.operator.v1alpha1.NodeAffinity")
	proto.RegisterType((*NodeSelector)(nil), "istio.operator.v1alpha1.NodeSelector")
	proto.RegisterType((*NodeSelectorTerm)(nil), "istio.operator.v1alpha1.NodeSelectorTerm")
	proto.RegisterType((*NodeSelectorRequirement)(nil), "istio.operator.v1alpha1.NodeSelectorRequirement")
	proto.RegisterType((*ObjectFieldSelector)(nil), "istio.operator.v1alpha1.ObjectFieldSelector")
	proto.RegisterType((*ObjectMeta)(nil), "istio.operator.v1alpha1.ObjectMeta")
	proto.RegisterType((*ObjectMetricSource)(nil), "istio.operator.v1alpha1.ObjectMetricSource")
	proto.RegisterType((*PodAffinity)(nil), "istio.operator.v1alpha1.PodAffinity")
	proto.RegisterType((*PodAntiAffinity)(nil), "istio.operator.v1alpha1.PodAntiAffinity")
	proto.RegisterType((*PodAffinityTerm)(nil), "istio.operator.v1alpha1.PodAffinityTerm")
	proto.RegisterType((*PodDisruptionBudgetSpec)(nil), "istio.operator.v1alpha1.PodDisruptionBudgetSpec")
	proto.RegisterType((*PodsMetricSource)(nil), "istio.operator.v1alpha1.PodsMetricSource")
	proto.RegisterType((*PreferredSchedulingTerm)(nil), "istio.operator.v1alpha1.PreferredSchedulingTerm")
	proto.RegisterType((*ReadinessProbe)(nil), "istio.operator.v1alpha1.ReadinessProbe")
	proto.RegisterType((*ResourceFieldSelector)(nil), "istio.operator.v1alpha1.ResourceFieldSelector")
	proto.RegisterType((*ResourceMetricSource)(nil), "istio.operator.v1alpha1.ResourceMetricSource")
	proto.RegisterType((*Resources)(nil), "istio.operator.v1alpha1.Resources")
	proto.RegisterMapType((map[string]string)(nil), "istio.operator.v1alpha1.Resources.LimitsEntry")
	proto.RegisterMapType((map[string]string)(nil), "istio.operator.v1alpha1.Resources.RequestsEntry")
	proto.RegisterType((*RollingUpdateDeployment)(nil), "istio.operator.v1alpha1.RollingUpdateDeployment")
	proto.RegisterType((*SecretKeySelector)(nil), "istio.operator.v1alpha1.SecretKeySelector")
	proto.RegisterType((*ServiceSpec)(nil), "istio.operator.v1alpha1.ServiceSpec")
	proto.RegisterMapType((map[string]string)(nil), "istio.operator.v1alpha1.ServiceSpec.SelectorEntry")
	proto.RegisterType((*ServicePort)(nil), "istio.operator.v1alpha1.ServicePort")
	proto.RegisterType((*SessionAffinityConfig)(nil), "istio.operator.v1alpha1.SessionAffinityConfig")
	proto.RegisterType((*TCPSocketAction)(nil), "istio.operator.v1alpha1.TCPSocketAction")
	proto.RegisterType((*Toleration)(nil), "istio.operator.v1alpha1.Toleration")
	proto.RegisterType((*WeightedPodAffinityTerm)(nil), "istio.operator.v1alpha1.WeightedPodAffinityTerm")
	proto.RegisterType((*PodSecurityContext)(nil), "istio.operator.v1alpha1.PodSecurityContext")
	proto.RegisterType((*SELinuxOptions)(nil), "istio.operator.v1alpha1.SELinuxOptions")
	proto.RegisterType((*Sysctl)(nil), "istio.operator.v1alpha1.Sysctl")
	proto.RegisterType((*WindowsSecurityContextOptions)(nil), "istio.operator.v1alpha1.WindowsSecurityContextOptions")
	proto.RegisterType((*SeccompProfile)(nil), "istio.operator.v1alpha1.SeccompProfile")
}

func init() { proto.RegisterFile("operator/v1alpha1/operator.proto", fileDescriptor_8023ebf2dcfea843) }

var fileDescriptor_8023ebf2dcfea843 = []byte{
	// 4002 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xec, 0x5b, 0x4d, 0x90, 0x1c, 0x47,
	0x56, 0x76, 0xff, 0xcc, 0x4c, 0xcf, 0x9b, 0xbf, 0x9e, 0xd4, 0x48, 0x2a, 0x66, 0x6d, 0x59, 0x2e,
	0xd9, 0x5a, 0x59, 0x36, 0x3d, 0x96, 0xec, 0x30, 0x5a, 0x2f, 0xf6, 0xee, 0x68, 0x34, 0x92, 0x46,
	0x96, 0x66, 0x7a, 0xb3, 0x47, 0x72, 0xec, 0xe2, 0x75, 0x47, 0x4e, 0x55, 0x76, 0x77, 0x31, 0xd5,
	0x95, 0xb5, 0x95, 0xd9, 0xa3, 0xe9, 0x0d, 0x0e, 0x5c, 0x20, 0x82, 0x03, 0x11, 0x9c, 0x20, 0xe0,
	0xc0, 0x81, 0x20, 0x82, 0x03, 0x01, 0x7b, 0xe3, 0x80, 0x21, 0x02, 0x02, 0x88, 0x80, 0x1b, 0x57,
	0x0e, 0x10, 0x84, 0x0f, 0x9c, 0xb8, 0x70, 0xe2, 0x46, 0x10, 0xf9, 0x53, 0xd5, 0x55, 0xdd, 0x55,
	0xd3, 0xea, 0xb1, 0xd8, 0xf0, 0x81, 0xd3, 0x74, 0xbe, 0x7c, 0xef, 0xab, 0xca, 0x97, 0x2f, 0xdf,
	0x5f, 0xd6, 0xc0, 0x55, 0x16, 0xd2, 0x88, 0x08, 0x16, 0x6d, 0x9d, 0xdc, 0x22, 0x7e, 0xd8, 0x23,
	0xb7, 0xb6, 0x62, 0x4a, 0x23, 0x8c, 0x98, 0x60, 0xe8, 0xb2, 0xc7, 0x85, 0xc7, 0x1a, 0x09, 0x35,
	0xe6, 0xdb, 0xfc, 0x85, 0x2e, 0x63, 0x5d, 0x9f, 0x6e, 0x29, 0xb6, 0xa3, 0x41, 0x67, 0x8b, 0x04,
	0x43, 0x2d, 0xb3, 0xf9, 0xc1, 0xf1, 0x1d, 0xde, 0xf0, 0xd8, 0x16, 0x09, 0xbd, 0x3e, 0x71, 0x7a,
	0x5e, 0x40, 0xa3, 0xe1, 0x56, 0x78, 0xdc, 0x95, 0x04, 0xbe, 0xd5, 0xa7, 0x82, 0x6c, 0x9d, 0xdc,
	0xda, 0xea, 0xd2, 0x40, 0x62, 0x52, 0xd7, 0x48, 0xd9, 0x23, 0xa9, 0x2d, 0x87, 0x45, 0x34, 0x8f,
	0x67, 0xa3, 0xcb, 0xba, 0x4c, 0xfd, 0xdc, 0x92, 0xbf, 0x34, 0xd5, 0xfe, 0xcf, 0x79, 0x58, 0xdf,
	0x93, 0xaf, 0x79, 0x60, 0xde, 0xb2, 0x15, 0x52, 0x07, 0x59, 0xb0, 0x10, 0x46, 0xac, 0xe3, 0xf9,
	0xd4, 0x82, 0xab, 0xa5, 0x1b, 0x8b, 0x38, 0x1e, 0xa2, 0xf7, 0x60, 0xc3, 0x0b, 0xb8, 0x20, 0xbe,
	0xdf, 0x0e, 0x89, 0x73, 0x4c, 0xba, 0xb4, 0x1d, 0x12, 0xd1, 0xb3, 0x96, 0x14, 0x1b, 0x32, 0x73,
	0x4d, 0x3d, 0xd5, 0x24, 0xa2, 0x87, 0xea, 0x50, 0xe9, 0x0d, 0x8e, 0xac, 0x65, 0xc5, 0x20, 0x7f,
	0xa2, 0x3b, 0x50, 0x11, 0xa4, 0x6b, 0xad, 0x5c, 0x2d, 0xdd, 0x58, 0xba, 0x7d, 0xbd, 0x51, 0xa0,
	0xa5, 0xc6, 0xe1, 0x30, 0xa4, 0x7b, 0x81, 0xa0, 0x51, 0x87, 0x38, 0x14, 0x4b, 0x11, 0xf4, 0x0e,
	0xac, 0x45, 0x94, 0xb3, 0x41, 0xe4, 0xd0, 0x36, 0x1f, 0x74, 0x3a, 0xde, 0xa9, 0xb5, 0x2a, 0x71,
	0xef, 0x96, 0xad, 0x12, 0x5e, 0x8d, 0xa7, 0x5a, 0x6a, 0x06, 0xbd, 0x0a, 0x8b, 0x01, 0xe9, 0x53,
	0x1e, 0x12, 0x87, 0x5a, 0x6b, 0xea, 0xf1, 0x23, 0x02, 0xda, 0x84, 0x5a, 0x44, 0x4f, 0x3c, 0xee,
	0xb1, 0xc0, 0xaa, 0xab, 0xc9, 0x64, 0x8c, 0xde, 0x86, 0xba, 0x4b, 0x3b, 0x64, 0xe0, 0x8b, 0x76,
	0xc2, 0xb3, 0x7e, 0xb5, 0x74, 0xa3, 0x86, 0xd7, 0x0c, 0x1d, 0xc7, 0xac, 0x4d, 0x58, 0xea, 0x53,
	0xde, 0x6b, 0x3b, 0x2c, 0xe8, 0x78, 0x5d, 0xeb, 0x86, 0x5a, 0xd3, 0xd6, 0x99, 0x6b, 0x7a, 0x42,
	0xc2, 0x96, 0x88, 0xbc, 0xa0, 0x3b, 0x5a, 0x1c, 0x48, 0x8c, 0x1d, 0x05, 0x81, 0xf6, 0x01, 0x1c,
	0xd6, 0x0f, 0x59, 0x40, 0x03, 0xc1, 0xad, 0xdb, 0x0a, 0xb0, 0x51, 0x08, 0xa8, 0xf6, 0x6e, 0x27,
	0xe6, 0x6f, 0x51, 0x21, 0xf7, 0x0f, 0xa7, 0x10, 0x50, 0x00, 0x75, 0xe2, 0xba, 0x2c, 0x68, 0xa7,
	0x50, 0xdf, 0xbf, 0x5a, 0xb9, 0xb1, 0x74, 0xfb, 0x7b, 0x67, 0xa3, 0xa6, 0x2d, 0xa2, 0xb1, 0x2d,
	0x21, 0x92, 0xe7, 0xf0, 0xdd, 0x40, 0x44, 0x43, 0xa5, 0xf5, 0x35, 0x92, 0x9d, 0x41, 0x0f, 0x60,
	0xfe, 0x84, 0xf8, 0x03, 0xca, 0x2d, 0xf7, 0x7c, 0xca, 0x30, 0xe2, 0xe8, 0x0b, 0x40, 0x83, 0xe0,
	0x84, 0xf8, 0x9e, 0x2b, 0xad, 0xb8, 0x6d, 0x40, 0xe9, 0xf9, 0x40, 0xd7, 0x53, 0x50, 0xcf, 0x14,
	0xd2, 0x66, 0x04, 0x1b, 0x79, 0xab, 0x92, 0x06, 0x7b, 0x4c, 0x87, 0x56, 0x49, 0x1b, 0xec, 0x31,
	0x1d, 0xa2, 0x7b, 0x30, 0xa7, 0x9e, 0x6e, 0x95, 0xa7, 0xec, 0xc6, 0xee, 0xa9, 0xa0, 0x51, 0x40,
	0xfc, 0xd1, 0x86, 0xc8, 0xdd, 0xd0, 0xc2, 0x1f, 0x95, 0xef, 0x94, 0xec, 0x2f, 0xab, 0xb0, 0xb2,
	0xa7, 0xcf, 0x48, 0x4b, 0x10, 0x31, 0xe0, 0x68, 0x17, 0xe6, 0xb9, 0xfa, 0xa5, 0x1e, 0xb8, 0x7a,
	0xfb, 0x17, 0x8b, 0x37, 0x25, 0x2d, 0xd7, 0xd0, 0x7f, 0xb0, 0x11, 0x96, 0x27, 0xb6, 0x4f, 0x39,
	0x27, 0x5d, 0x6a, 0x55, 0xf4, 0x89, 0x35, 0x43, 0xd4, 0x81, 0x7a, 0xb2, 0xf3, 0x6d, 0xf3, 0xa8,
	0xb2, 0xda, 0xff, 0xef, 0xbe, 0xe0, 0xa3, 0x46, 0xab, 0x51, 0x63, 0xa5, 0x25, 0xbc, 0xe6, 0x64,
	0xa9, 0x9b, 0xbf, 0x59, 0x82, 0x95, 0x67, 0x34, 0x92, 0xa7, 0xa2, 0x95, 0xbc, 0xd3, 0x89, 0x26,
	0x18, 0x65, 0xc6, 0xc3, 0xd4, 0xa2, 0xcb, 0x5f, 0x67, 0xd1, 0x1b, 0x30, 0x47, 0xa3, 0x88, 0x45,
	0x56, 0x55, 0xc1, 0xeb, 0xc1, 0xe6, 0x29, 0x6c, 0xe4, 0xbd, 0x71, 0xce, 0xbe, 0x3e, 0xca, 0xee,
	0xeb, 0x07, 0x2f, 0xf8, 0x16, 0x99, 0x55, 0xa6, 0x77, 0xf7, 0x0b, 0x98, 0x37, 0x4b, 0xaf, 0x41,
	0x75, 0xff, 0x60, 0x7f, 0xb7, 0xfe, 0x0a, 0x5a, 0x86, 0xda, 0xd3, 0xe6, 0xbd, 0xed, 0xc3, 0xbd,
	0xfd, 0x07, 0xf5, 0x12, 0x5a, 0x83, 0x25, 0xbc, 0xbb, 0x73, 0xb0, 0xbf, 0xb3, 0xf7, 0x58, 0x12,
	0xca, 0x68, 0x09, 0x16, 0x1e, 0xee, 0x6e, 0x3f, 0x3e, 0x7c, 0xf8, 0xc3, 0x7a, 0x05, 0x2d, 0xc2,
	0xdc, 0x2e, 0xc6, 0x07, 0xb8, 0x5e, 0x45, 0x17, 0x60, 0x6d, 0x7b, 0xe7, 0x70, 0xef, 0x60, 0xbf,
	0x8d, 0x77, 0x7f, 0xf0, 0x74, 0x0f, 0xef, 0xde, 0xab, 0xcf, 0xd9, 0x3f, 0xab, 0xc2, 0xc5, 0xdc,
	0x03, 0x8f, 0x3e, 0x81, 0xea, 0x11, 0xe1, 0xd4, 0x7a, 0x4d, 0x2d, 0xe4, 0x66, 0xe1, 0x42, 0xee,
	0x12, 0x4e, 0xb3, 0xc6, 0xa9, 0xe4, 0xd0, 0x2f, 0xc3, 0x5c, 0xe8, 0xf9, 0x4c, 0x58, 0x57, 0xa6,
	0x38, 0xe5, 0x31, 0xcb, 0x56, 0x42, 0xd2, 0xa1, 0x3b, 0x81, 0x67, 0x5d, 0x9f, 0x49, 0x56, 0x8a,
	0xa0, 0x4f, 0x61, 0x45, 0x71, 0xbb, 0xed, 0x88, 0xf6, 0x99, 0xa0, 0xd6, 0xb7, 0x67, 0xc2, 0x58,
	0xd6, 0xc2, 0x58, 0xc9, 0xa2, 0x03, 0xa8, 0x7b, 0x41, 0x37, 0xa2, 0x9c, 0xb7, 0xbb, 0x44, 0xd0,
	0xe7, 0x64, 0xc8, 0xad, 0x1b, 0xca, 0xd2, 0xdf, 0x2c, 0xc4, 0x7b, 0xa0, 0x19, 0x15, 0xda, 0x9a,
	0x91, 0x36, 0x34, 0x8e, 0x9e, 0xc0, 0x1a, 0x1d, 0xc3, 0x7b, 0x7b, 0x06, 0xbc, 0x55, 0x9a, 0x81,
	0x7b, 0x54, 0xad, 0xbd, 0x5e, 0xbf, 0xfa, 0xa8, 0x5a, 0xbb, 0x5a, 0x7f, 0xe3, 0x51, 0xb5, 0xf6,
	0x46, 0xdd, 0x7e, 0x54, 0xad, 0xd9, 0xf5, 0x6b, 0x8f, 0xaa, 0xb5, 0x6b, 0xf5, 0x37, 0x1f, 0x55,
	0x6b, 0x6f, 0xd6, 0xdf, 0x7a, 0x54, 0xad, 0xbd, 0x55, 0xbf, 0x8e, 0x17, 0x1c, 0x4f, 0x10, 0x97,
	0xfa, 0x78, 0x3e, 0x64, 0xbe, 0xe7, 0x0c, 0xf1, 0xa2, 0xa0, 0x3e, 0xed, 0x53, 0x79, 0xf0, 0xe6,
	0xbb, 0xc4, 0xf7, 0xe9, 0x10, 0x43, 0xc0, 0x5c, 0xda, 0x26, 0x5d, 0x1a, 0x08, 0x3c, 0x17, 0x46,
	0xec, 0x74, 0x88, 0xeb, 0xdc, 0x73, 0xa9, 0x43, 0xa2, 0xb6, 0x17, 0xfc, 0x2a, 0x75, 0x04, 0x8b,
	0xec, 0x3f, 0x2c, 0xc1, 0xfa, 0xc4, 0x9e, 0xa3, 0x5d, 0x58, 0xa0, 0x01, 0x39, 0xf2, 0xa9, 0xab,
	0x4e, 0xc3, 0xd2, 0xed, 0x77, 0xce, 0x74, 0xa7, 0x77, 0x19, 0xf3, 0x95, 0xcf, 0xbc, 0xcf, 0xa2,
	0xe6, 0x5d, 0x1c, 0xcb, 0xa2, 0xbb, 0x50, 0x39, 0xbe, 0x13, 0x87, 0xa8, 0xf7, 0x0a, 0x21, 0x3e,
	0x1d, 0x1c, 0xd1, 0x28, 0xa0, 0x82, 0x72, 0x6c, 0x02, 0x34, 0xd7, 0x06, 0x70, 0x7c, 0x87, 0xdb,
	0x7f, 0x53, 0x86, 0x95, 0xff, 0x93, 0x97, 0xcb, 0x44, 0xff, 0xf2, 0x78, 0xf4, 0x37, 0x49, 0x09,
	0x4c, 0x24, 0x25, 0x4b, 0xb3, 0x27, 0x25, 0x1f, 0x41, 0x95, 0x87, 0xd4, 0x99, 0x7a, 0x74, 0xb2,
	0xa2, 0x4a, 0xe6, 0xa5, 0xa8, 0xf0, 0x9f, 0xca, 0x70, 0x31, 0x37, 0xf0, 0xfc, 0x7c, 0x54, 0x19,
	0x2f, 0x1f, 0xce, 0xb1, 0xfc, 0xd7, 0x00, 0x9c, 0x1e, 0x89, 0x84, 0xce, 0x21, 0xaf, 0x68, 0x68,
	0x45, 0x51, 0xa9, 0xe3, 0xbb, 0x30, 0xcf, 0x9d, 0x1e, 0xed, 0x13, 0xeb, 0x9a, 0x02, 0xdf, 0x68,
	0xe8, 0xc4, 0xb9, 0x11, 0x27, 0xce, 0x8d, 0xed, 0x60, 0x88, 0x0d, 0xcf, 0x4b, 0xd1, 0xe5, 0xef,
	0x55, 0x60, 0x29, 0x75, 0x84, 0x7f, 0x3e, 0x1a, 0x44, 0x50, 0x95, 0x03, 0x13, 0xb8, 0xd5, 0x6f,
	0xb4, 0x0b, 0x73, 0x3e, 0x39, 0xa2, 0xbe, 0x55, 0x55, 0x0e, 0x67, 0xeb, 0x45, 0x1c, 0x4e, 0xe3,
	0xb1, 0x94, 0xd0, 0xe1, 0x59, 0x4b, 0xbf, 0x54, 0x3b, 0x7f, 0x09, 0xfa, 0xdd, 0xbc, 0x03, 0x30,
	0x7a, 0xc9, 0x9c, 0x88, 0xbc, 0x91, 0x8e, 0xc8, 0x8b, 0xe9, 0xd8, 0xfa, 0x6f, 0xcb, 0x70, 0xb9,
	0x00, 0x1a, 0x7d, 0x0c, 0x35, 0xd2, 0xe9, 0x78, 0x81, 0x27, 0x86, 0x66, 0x9b, 0xde, 0x28, 0x7c,
	0xbd, 0x6d, 0xc3, 0x88, 0x13, 0x11, 0x74, 0x0b, 0x2a, 0x34, 0x38, 0x31, 0x49, 0xd1, 0xeb, 0xc5,
	0xc9, 0x5d, 0x70, 0xf2, 0x8c, 0x44, 0x58, 0xf2, 0xa2, 0x03, 0xa8, 0xf5, 0x42, 0xd2, 0x56, 0x86,
	0x5f, 0x99, 0x92, 0x3c, 0x3c, 0x64, 0x91, 0xf7, 0x53, 0x16, 0x08, 0xe2, 0x37, 0x99, 0xbb, 0x3d,
	0x10, 0x8c, 0x3b, 0xc4, 0xa7, 0x2a, 0xad, 0xc6, 0x0b, 0xbd, 0x90, 0xa8, 0x25, 0xdc, 0x84, 0x75,
	0xaf, 0xaf, 0xaa, 0xa9, 0x81, 0x2c, 0xad, 0x94, 0xd7, 0x37, 0x69, 0xcd, 0x9a, 0x9a, 0x68, 0x0e,
	0x7c, 0xbf, 0xa9, 0xc8, 0xa8, 0x0b, 0x2b, 0xca, 0xf7, 0x73, 0xea, 0x2b, 0x2f, 0x6f, 0xcd, 0xa9,
	0x37, 0xbf, 0x3b, 0xeb, 0x96, 0x34, 0xf6, 0x99, 0x4b, 0x5b, 0x06, 0x44, 0x9b, 0xcd, 0x72, 0x90,
	0x22, 0x21, 0x17, 0x2e, 0x86, 0xcc, 0x6d, 0xbb, 0x1e, 0x8f, 0x06, 0xa1, 0xf0, 0x58, 0xd0, 0x3e,
	0x1a, 0xb8, 0x5d, 0x2a, 0xac, 0xf9, 0x29, 0x36, 0xd0, 0x64, 0xee, 0xbd, 0x44, 0xe8, 0xae, 0x92,
	0x51, 0xcb, 0xbd, 0x10, 0x4e, 0x4e, 0xa0, 0x3e, 0xac, 0xc9, 0xa7, 0x90, 0x20, 0x60, 0x82, 0x48,
	0x3a, 0xb7, 0x16, 0xd4, 0x82, 0xee, 0xcd, 0xbc, 0x20, 0xa9, 0xe0, 0x11, 0x8c, 0x5e, 0xd2, 0x6a,
	0x98, 0x21, 0xa2, 0x06, 0x5c, 0x08, 0x23, 0x8f, 0x45, 0x9e, 0x18, 0xb6, 0x1d, 0x9f, 0x70, 0xde,
	0x56, 0x87, 0xaf, 0xa6, 0x74, 0xbd, 0x1e, 0x4f, 0xed, 0xc8, 0x99, 0x7d, 0x79, 0x12, 0x9b, 0xb2,
	0xe6, 0x24, 0xae, 0x17, 0xc8, 0x3c, 0x20, 0x8c, 0xd8, 0x11, 0xb5, 0x16, 0xd5, 0xf2, 0xbf, 0x5d,
	0xf8, 0x7a, 0x38, 0xe6, 0x6f, 0x4a, 0x76, 0x59, 0x98, 0xa6, 0xc7, 0xe8, 0x1a, 0xac, 0x44, 0x34,
	0xf4, 0x3d, 0x87, 0xb4, 0x1d, 0x36, 0x08, 0x84, 0x3a, 0x9e, 0x2b, 0x78, 0xd9, 0x10, 0x77, 0x24,
	0x0d, 0x7d, 0x1f, 0x16, 0xe3, 0x7a, 0x96, 0x9b, 0xd3, 0x6a, 0x9f, 0xf1, 0x40, 0xc3, 0x89, 0x47,
	0x42, 0xe8, 0x13, 0x58, 0xe0, 0x34, 0x3a, 0xf1, 0x1c, 0xaa, 0x8a, 0xef, 0xb3, 0xb2, 0x96, 0x96,
	0xe6, 0xd3, 0x26, 0x69, 0x84, 0xd0, 0x03, 0xa8, 0x71, 0x11, 0x11, 0x41, 0xbb, 0x43, 0x53, 0xab,
	0x17, 0x3b, 0xbf, 0x7b, 0x34, 0xf4, 0xd9, 0xb0, 0xaf, 0x32, 0x6e, 0x2d, 0x82, 0x13, 0x61, 0xb4,
	0x0b, 0x4b, 0x82, 0xf9, 0x52, 0x44, 0x6d, 0xee, 0xaa, 0xda, 0xdc, 0x6b, 0xc5, 0xae, 0x27, 0xe1,
	0xc5, 0x69, 0x39, 0x34, 0x84, 0x0b, 0xe6, 0xd5, 0x32, 0xb6, 0xb2, 0xa6, 0xe0, 0x1e, 0xce, 0x6c,
	0x2b, 0x66, 0xcd, 0x13, 0xf6, 0x82, 0xf8, 0xc4, 0x04, 0x7a, 0x0a, 0x6b, 0x9c, 0x3a, 0x03, 0x65,
	0x18, 0x2c, 0x10, 0xf4, 0x54, 0xa8, 0x9e, 0xc1, 0x59, 0x1a, 0x69, 0x32, 0xb7, 0x95, 0x15, 0xc1,
	0xe3, 0x18, 0xe8, 0x03, 0x58, 0x38, 0x61, 0xfe, 0xa0, 0x4f, 0xb9, 0xb5, 0xae, 0x56, 0xb1, 0xd9,
	0xd0, 0x8d, 0x9c, 0x06, 0x09, 0xbd, 0x86, 0xc3, 0x22, 0xda, 0x38, 0xb9, 0xd5, 0x78, 0xa6, 0x58,
	0x70, 0xcc, 0x8a, 0x76, 0x60, 0x59, 0xff, 0x7c, 0x22, 0x0d, 0x85, 0x5b, 0xc8, 0xf8, 0xad, 0x42,
	0x51, 0xc5, 0x87, 0x33, 0x42, 0x68, 0x17, 0x6a, 0xec, 0x84, 0x46, 0xbe, 0xcc, 0x69, 0x5d, 0x05,
	0xf0, 0x76, 0xb1, 0x06, 0xef, 0xf0, 0x83, 0x23, 0x99, 0x50, 0x1e, 0x68, 0x09, 0x9c, 0x88, 0x6e,
	0x7e, 0x0f, 0xd6, 0x27, 0x9c, 0xc8, 0x2c, 0x6e, 0x7d, 0x73, 0x1b, 0x2e, 0xe4, 0x1c, 0xda, 0x99,
	0x20, 0x76, 0xe1, 0x72, 0xc1, 0x5e, 0xce, 0x14, 0x60, 0x7e, 0xab, 0x0c, 0xf5, 0xf1, 0x95, 0xa2,
	0xd7, 0x61, 0x89, 0x84, 0x5e, 0x3b, 0x5b, 0xc6, 0x02, 0x09, 0x3d, 0x53, 0x03, 0xca, 0xd8, 0x7d,
	0xec, 0x05, 0xae, 0x81, 0x53, 0xbf, 0x73, 0xe3, 0xf9, 0x13, 0x58, 0x08, 0x89, 0x70, 0x7a, 0x94,
	0x9b, 0x88, 0xfe, 0xfe, 0x0b, 0xab, 0xbb, 0x21, 0x73, 0x21, 0x95, 0x55, 0xe0, 0x18, 0x63, 0xf3,
	0xc7, 0xb0, 0x98, 0x50, 0xe5, 0xf3, 0x54, 0xfe, 0xa4, 0xdf, 0x4e, 0xfd, 0x96, 0x05, 0x5d, 0xba,
	0xb4, 0x7d, 0xd1, 0x40, 0xaf, 0x85, 0xec, 0xff, 0x2a, 0x41, 0x2d, 0x0e, 0x94, 0x68, 0x0f, 0x54,
	0x54, 0xd8, 0xce, 0x46, 0xd8, 0xb7, 0x0a, 0x11, 0xf7, 0x53, 0xcc, 0x38, 0x23, 0x8a, 0xee, 0xc3,
	0x92, 0xf4, 0xc6, 0x31, 0x52, 0x79, 0x8a, 0x5b, 0x6a, 0x8e, 0x78, 0x71, 0x5a, 0x10, 0x61, 0x15,
	0x32, 0xb6, 0x03, 0xe1, 0x25, 0x58, 0x3a, 0x0a, 0xdf, 0x38, 0x13, 0x2b, 0xc5, 0x8f, 0xc7, 0x01,
	0xec, 0x3f, 0x29, 0xc1, 0x86, 0x6e, 0xc1, 0x3d, 0x21, 0xe1, 0xa7, 0x74, 0x98, 0x44, 0x41, 0x02,
	0x1b, 0x3e, 0x73, 0x88, 0xaf, 0x37, 0x05, 0xd3, 0x0e, 0x8d, 0x68, 0xe0, 0x50, 0xa3, 0x87, 0xe2,
	0xd6, 0xc5, 0xe3, 0x1c, 0x21, 0x9c, 0x0b, 0x15, 0xdb, 0x69, 0x79, 0x64, 0xa7, 0x9b, 0x50, 0x63,
	0x2a, 0x48, 0x12, 0x5f, 0x2d, 0xad, 0x86, 0x93, 0xb1, 0x7d, 0x07, 0x56, 0x77, 0x7c, 0x8f, 0x06,
	0x62, 0xaf, 0x69, 0x7a, 0x86, 0xd7, 0x61, 0x55, 0x78, 0x7d, 0xca, 0x06, 0xa2, 0x45, 0x1d, 0x16,
	0xb8, 0xba, 0x99, 0x34, 0x87, 0xc7, 0xa8, 0x36, 0x85, 0x6f, 0xed, 0x44, 0x8c, 0x73, 0x63, 0xbd,
	0xe3, 0xaf, 0x11, 0x1b, 0x73, 0x29, 0xc7, 0x98, 0xcb, 0x29, 0x63, 0xbe, 0x02, 0xa9, 0x23, 0x60,
	0xcc, 0x3c, 0x45, 0xb1, 0x7f, 0xbd, 0x04, 0x68, 0x32, 0x22, 0x48, 0x28, 0x31, 0x0c, 0x69, 0x0c,
	0x2f, 0x7f, 0xa3, 0x67, 0xb0, 0x12, 0x31, 0xdf, 0xf7, 0x82, 0xee, 0xd3, 0xd0, 0x25, 0x22, 0xb6,
	0xd7, 0xe2, 0xd4, 0x02, 0xa7, 0xb9, 0x47, 0x0f, 0xc1, 0x59, 0x18, 0xfb, 0x39, 0xcc, 0xeb, 0x7c,
	0x2d, 0x59, 0x40, 0x29, 0xb5, 0x80, 0x5c, 0x2f, 0x80, 0x76, 0x60, 0x51, 0xfd, 0xb8, 0x1f, 0xb1,
	0xbe, 0xb1, 0xa7, 0xb7, 0xa6, 0x64, 0x83, 0x2d, 0x15, 0x50, 0xf0, 0x48, 0xce, 0xfe, 0xd7, 0x32,
	0x2c, 0xa7, 0xe7, 0xd0, 0x43, 0xa8, 0x75, 0x3c, 0xea, 0xbb, 0x98, 0x76, 0x8c, 0xc9, 0xbc, 0x5b,
	0x08, 0xaa, 0x37, 0xe4, 0xbe, 0x64, 0x8f, 0xcd, 0x0f, 0x27, 0xd2, 0xe8, 0x47, 0x50, 0x8f, 0xa3,
	0xfb, 0xfd, 0x18, 0x71, 0x5a, 0x47, 0x12, 0xa7, 0x05, 0x12, 0xcc, 0x09, 0x1c, 0xf4, 0x19, 0xac,
	0x39, 0x29, 0xe3, 0x97, 0xd0, 0x95, 0x29, 0xf6, 0x9d, 0x77, 0x58, 0xf0, 0x38, 0x0a, 0xda, 0x87,
	0x65, 0x4e, 0x9d, 0x88, 0x0a, 0x83, 0x5a, 0x9d, 0xd2, 0xa1, 0x6a, 0xc5, 0xcc, 0x09, 0x64, 0x46,
	0xde, 0xbe, 0x0e, 0xb0, 0x7b, 0x4a, 0x9d, 0x6d, 0x47, 0x1e, 0x06, 0x64, 0xc1, 0x82, 0xc3, 0xfa,
	0x7d, 0xa2, 0x8c, 0xb6, 0x72, 0x63, 0x11, 0xc7, 0x43, 0xfb, 0xef, 0xca, 0xb0, 0x11, 0x57, 0xc5,
	0x4f, 0xa8, 0x88, 0x3c, 0xc7, 0xec, 0xc7, 0x15, 0x80, 0xbe, 0x1a, 0xef, 0x8f, 0xac, 0x22, 0x45,
	0x41, 0xbf, 0x02, 0xab, 0x7a, 0x14, 0xbf, 0x80, 0xd1, 0xf1, 0xfb, 0xa9, 0x00, 0x9b, 0x5c, 0xcd,
	0x34, 0xc2, 0xe3, 0xae, 0x24, 0xf0, 0x46, 0x9f, 0x0a, 0x22, 0x43, 0xae, 0x2a, 0x6f, 0x92, 0x77,
	0x1f, 0x83, 0x42, 0x07, 0xb0, 0x24, 0x48, 0xd4, 0xa5, 0x42, 0x79, 0xee, 0xa9, 0x2a, 0x36, 0xce,
	0xf9, 0x20, 0xd2, 0xed, 0x6c, 0x5d, 0x55, 0xa6, 0x11, 0xd0, 0x8f, 0x01, 0xe9, 0xe1, 0xf6, 0x09,
	0x8d, 0x48, 0x97, 0x6a, 0xdc, 0xea, 0x79, 0x70, 0x73, 0x80, 0xec, 0x7f, 0x29, 0xc1, 0xca, 0xc3,
	0xc3, 0xc3, 0xe6, 0x03, 0x2a, 0x8c, 0xc6, 0xf3, 0x82, 0xcd, 0x36, 0x54, 0x43, 0x16, 0x09, 0xa3,
	0xa8, 0x19, 0x1f, 0xab, 0x44, 0x25, 0x6c, 0x8f, 0x71, 0x11, 0xc7, 0x4c, 0xf9, 0x1b, 0x5d, 0x32,
	0xe5, 0x3f, 0x35, 0x85, 0x90, 0x19, 0xc9, 0x7c, 0xb2, 0x27, 0x44, 0xf8, 0x90, 0x12, 0x97, 0x46,
	0xdc, 0x54, 0x3f, 0xc5, 0xf9, 0xa4, 0x7c, 0x7f, 0xcd, 0x8b, 0xd3, 0x72, 0xf6, 0x87, 0x00, 0xa3,
	0xa9, 0x17, 0x77, 0x13, 0xf6, 0xff, 0x94, 0xe0, 0x5b, 0x67, 0xd4, 0x74, 0xe8, 0x73, 0x58, 0x55,
	0xa3, 0x43, 0xa5, 0xce, 0xd1, 0xb1, 0x2f, 0xae, 0x10, 0xcf, 0xf0, 0xc9, 0x78, 0x0c, 0x0b, 0x5d,
	0x85, 0xa5, 0xbe, 0x17, 0x60, 0x5d, 0x2a, 0xe8, 0xfe, 0xf9, 0x1c, 0x4e, 0x93, 0x14, 0x07, 0x39,
	0x4d, 0x38, 0x2a, 0x86, 0x63, 0x44, 0x42, 0x1f, 0xc3, 0x82, 0xb6, 0xcb, 0x38, 0x19, 0x29, 0x56,
	0x9e, 0x39, 0x3a, 0xaa, 0x30, 0x30, 0x32, 0xf6, 0x4d, 0xd8, 0xc8, 0x8b, 0x6d, 0x79, 0x2a, 0xb4,
	0xff, 0xb2, 0x0c, 0x30, 0xc2, 0xc8, 0x0d, 0x01, 0x3b, 0x30, 0xcf, 0x14, 0x92, 0xb1, 0x9f, 0x77,
	0xa6, 0xb8, 0xc7, 0xf4, 0x69, 0xc6, 0x46, 0x14, 0x7d, 0x2c, 0x4d, 0xd0, 0xe5, 0xe6, 0x44, 0xbd,
	0x7d, 0x56, 0x1a, 0xc0, 0x33, 0x00, 0x4a, 0x0c, 0xed, 0x41, 0x2d, 0x76, 0x89, 0x53, 0x0f, 0x4f,
	0xec, 0x52, 0x33, 0x30, 0x89, 0xb8, 0x84, 0xa2, 0xc6, 0xef, 0x58, 0x73, 0x53, 0xa0, 0xf2, 0x1c,
	0x14, 0x4e, 0xc4, 0xed, 0x2f, 0xcb, 0xb0, 0x9c, 0xce, 0xa6, 0xd0, 0x6f, 0x97, 0xa0, 0x11, 0xd1,
	0x9f, 0x0c, 0xbc, 0x88, 0xba, 0xf7, 0x06, 0xf2, 0x0c, 0xb5, 0x9c, 0x1e, 0x75, 0x07, 0x32, 0xf0,
	0xed, 0x75, 0x03, 0x96, 0x90, 0xa5, 0x8b, 0x1c, 0x88, 0x38, 0x65, 0x9d, 0x96, 0xad, 0x25, 0xee,
	0x6a, 0x46, 0x70, 0xf4, 0x07, 0x25, 0xd8, 0x0a, 0x23, 0x69, 0x00, 0x2f, 0xfe, 0x42, 0xba, 0xcd,
	0x72, 0x46, 0xef, 0x20, 0xc6, 0x1b, 0x21, 0x1d, 0xd2, 0xa8, 0x8f, 0x67, 0x7d, 0x90, 0xdd, 0xd5,
	0xca, 0x4b, 0x7c, 0xef, 0x67, 0xb0, 0x9e, 0xee, 0x6e, 0x48, 0x50, 0xae, 0xa2, 0xc6, 0x59, 0xf6,
	0xb2, 0x3f, 0x26, 0x81, 0x27, 0x31, 0xec, 0xbf, 0x2f, 0x41, 0x7d, 0x9c, 0x0f, 0x7d, 0x0e, 0xf5,
	0xbe, 0x4c, 0xd6, 0x77, 0x4f, 0xc3, 0x88, 0x72, 0xae, 0x4a, 0xd5, 0xd2, 0x94, 0xa5, 0x67, 0xf6,
	0x42, 0xef, 0x84, 0xca, 0x6d, 0x26, 0x90, 0x10, 0x96, 0x67, 0x5c, 0x38, 0x3d, 0x15, 0xbf, 0xf9,
	0x54, 0x9d, 0x16, 0x01, 0xa7, 0x41, 0xec, 0x36, 0x5c, 0x2e, 0xe0, 0xcb, 0xa9, 0xa3, 0x54, 0x7e,
	0xaa, 0x1f, 0x63, 0xbc, 0x63, 0x32, 0x96, 0x7e, 0xdb, 0x5c, 0xd6, 0x56, 0x54, 0x4c, 0x36, 0x23,
	0xbb, 0x05, 0x17, 0x72, 0x12, 0x9c, 0xb1, 0x6c, 0x72, 0xb2, 0xc4, 0x7a, 0x15, 0x16, 0x55, 0x0a,
	0x24, 0x0b, 0x9e, 0xb8, 0x79, 0x9a, 0x10, 0xec, 0x4f, 0x00, 0x12, 0xb7, 0x40, 0x12, 0x17, 0x34,
	0x97, 0xf2, 0xe2, 0x99, 0xe6, 0xeb, 0xfc, 0x58, 0xf3, 0xd5, 0xfe, 0xef, 0x32, 0xa0, 0x49, 0xbf,
	0x82, 0x1e, 0xc3, 0xbc, 0x0e, 0x87, 0x5f, 0xcb, 0x79, 0x1b, 0x8c, 0xb1, 0x9c, 0xa3, 0x3c, 0x91,
	0x73, 0xbc, 0xf4, 0xb4, 0xe0, 0x00, 0x6a, 0x49, 0x77, 0xb0, 0x7a, 0xfe, 0xf4, 0x25, 0x01, 0x41,
	0x3f, 0x80, 0x65, 0x92, 0xce, 0x30, 0xe6, 0xce, 0xf3, 0x8a, 0x19, 0x08, 0xfb, 0xaf, 0xcb, 0xb0,
	0x94, 0xaa, 0xf0, 0xd0, 0xef, 0x9c, 0xc7, 0xb9, 0x55, 0xa6, 0x16, 0x7d, 0x06, 0x5e, 0x1d, 0xde,
	0x6f, 0x82, 0x7f, 0xfb, 0x8c, 0x7a, 0xdd, 0x9e, 0xa0, 0xee, 0xf8, 0xbb, 0xcd, 0xec, 0xdf, 0xfe,
	0xb6, 0x0c, 0x6b, 0x63, 0x55, 0xed, 0xff, 0xeb, 0x70, 0x46, 0x1d, 0xfe, 0x79, 0x49, 0xeb, 0x30,
	0x05, 0x82, 0x7e, 0x08, 0x2b, 0x7e, 0xfa, 0x14, 0x18, 0x0f, 0x70, 0xae, 0x03, 0x94, 0x45, 0x92,
	0x7e, 0x20, 0xf1, 0x3c, 0xda, 0x6b, 0x2f, 0xe2, 0x14, 0x45, 0xa6, 0x6e, 0x82, 0x85, 0xcc, 0x67,
	0xdd, 0xe1, 0xa7, 0x74, 0x68, 0x92, 0xe1, 0x34, 0xc9, 0xfe, 0x8b, 0x12, 0x5c, 0x2e, 0xe8, 0xae,
	0x23, 0x1b, 0x96, 0xfb, 0x5e, 0xb0, 0x7d, 0x42, 0x3c, 0x9f, 0x1c, 0xf9, 0x3a, 0xc9, 0x5a, 0xc1,
	0x19, 0x5a, 0xc6, 0x31, 0x94, 0x5f, 0x86, 0x63, 0xb8, 0x0e, 0xab, 0x7d, 0x72, 0xfa, 0x34, 0x20,
	0xc9, 0x63, 0x2b, 0xea, 0xb1, 0x63, 0x54, 0xfb, 0xab, 0x12, 0xd4, 0xc7, 0x93, 0xaf, 0xa9, 0xb5,
	0x58, 0x7e, 0x75, 0x53, 0x7e, 0x49, 0xd5, 0x4d, 0x46, 0x19, 0x95, 0x97, 0xa0, 0x0c, 0xfb, 0xd7,
	0xe0, 0x72, 0x41, 0xfa, 0x22, 0x83, 0xe2, 0x73, 0x65, 0xb5, 0xa6, 0x35, 0x63, 0x46, 0x68, 0x0f,
	0x40, 0x1b, 0xad, 0xea, 0x29, 0x95, 0xa7, 0xa4, 0xaf, 0x13, 0xe9, 0x48, 0x4a, 0xd8, 0xfe, 0xd3,
	0x0a, 0xac, 0x66, 0xaf, 0x1e, 0xd0, 0x2f, 0x41, 0x95, 0x9e, 0x52, 0xc7, 0x98, 0xf0, 0xb5, 0x33,
	0x12, 0xd1, 0xb8, 0xa4, 0xc6, 0x4a, 0x00, 0x7d, 0x1f, 0x16, 0x64, 0xad, 0xf4, 0x80, 0x8a, 0xa9,
	0x1d, 0xc4, 0x4c, 0x7d, 0x88, 0x63, 0x31, 0x74, 0x1f, 0x16, 0x85, 0x13, 0xb6, 0x98, 0x73, 0x4c,
	0xc5, 0xd4, 0xee, 0xdc, 0xe1, 0x4e, 0x53, 0x73, 0x1a, 0x94, 0x91, 0x28, 0x7a, 0x0f, 0x2e, 0xc8,
	0xb3, 0xe9, 0x11, 0xff, 0x1e, 0xf5, 0xc9, 0x30, 0x6e, 0x70, 0x55, 0x95, 0x16, 0xf3, 0xa6, 0x72,
	0xba, 0x61, 0x73, 0x79, 0xdd, 0x30, 0xf4, 0x26, 0xac, 0x84, 0x34, 0xf2, 0x54, 0xa3, 0x5e, 0xb1,
	0xcd, 0x2b, 0xb6, 0x2c, 0x11, 0xdd, 0x84, 0x3a, 0x1f, 0x38, 0x0e, 0xe5, 0xfc, 0xb0, 0x17, 0x51,
	0xde, 0x63, 0xbe, 0x6b, 0x2d, 0x28, 0xc6, 0x09, 0xba, 0xe4, 0xed, 0x10, 0xcf, 0x1f, 0x44, 0x74,
	0xc4, 0x5b, 0xd3, 0xbc, 0xe3, 0x74, 0xfb, 0x8f, 0x4a, 0x70, 0x31, 0xb7, 0x3b, 0x23, 0xdf, 0xcb,
	0x91, 0xb5, 0xa5, 0x34, 0xbe, 0xd4, 0xc1, 0xc8, 0x12, 0xf5, 0x07, 0x8c, 0xa6, 0x64, 0x29, 0xc7,
	0x1f, 0x30, 0x9a, 0x1a, 0xe4, 0x01, 0x2c, 0xb8, 0xde, 0x89, 0xc7, 0x13, 0xbb, 0x9e, 0xf1, 0xb0,
	0xc4, 0xd2, 0xf6, 0x3f, 0x94, 0x60, 0x23, 0xaf, 0xde, 0xc9, 0x2d, 0x97, 0x3f, 0x02, 0x2b, 0x73,
	0xc8, 0x9e, 0x0a, 0xcf, 0xf7, 0x7e, 0x4a, 0x8c, 0x47, 0x97, 0x5a, 0x28, 0x9c, 0x2f, 0x38, 0xe9,
	0x95, 0x97, 0xd5, 0xc7, 0xf8, 0xfd, 0x32, 0x2c, 0x26, 0xd7, 0x3f, 0xe8, 0x3e, 0xcc, 0xfb, 0x5e,
	0xdf, 0x13, 0x71, 0x46, 0x3e, 0xbd, 0x7d, 0xc6, 0x1b, 0x8f, 0x95, 0x80, 0xbe, 0x22, 0x32, 0xd2,
	0xe8, 0xb1, 0xdc, 0x82, 0x9f, 0x0c, 0x28, 0x17, 0xd3, 0x53, 0xf0, 0x11, 0x12, 0x36, 0x22, 0x1a,
	0x2b, 0x41, 0xd8, 0xfc, 0x0e, 0x2c, 0xa5, 0x1e, 0x32, 0xd3, 0x15, 0xc8, 0x77, 0x61, 0x25, 0x83,
	0x3a, 0xd3, 0xc5, 0xc7, 0x97, 0x25, 0xb8, 0x5c, 0xd0, 0x55, 0x45, 0x4f, 0x27, 0xbc, 0x7b, 0xe9,
	0x3c, 0x5b, 0x32, 0x06, 0x22, 0x6b, 0xe4, 0x3e, 0x39, 0x6d, 0x0d, 0xa2, 0xee, 0x39, 0xbd, 0x79,
	0x22, 0x6e, 0xff, 0x71, 0x09, 0xd6, 0x27, 0x7a, 0x86, 0xdf, 0xbc, 0x9e, 0xfd, 0x7f, 0xcc, 0xc1,
	0x52, 0xea, 0x96, 0x15, 0x7d, 0x04, 0x73, 0x21, 0x8b, 0x12, 0x0b, 0x9c, 0x7a, 0x35, 0xdb, 0x64,
	0x91, 0xc0, 0x5a, 0x04, 0xed, 0x67, 0x62, 0xb8, 0x14, 0xbf, 0xfd, 0x22, 0x37, 0xbb, 0x8d, 0xec,
	0x55, 0xff, 0x28, 0x84, 0xbf, 0x0a, 0x8b, 0x8e, 0x3f, 0xe0, 0x82, 0x46, 0x7b, 0x4d, 0x93, 0x73,
	0x8c, 0x08, 0x49, 0xcb, 0xa6, 0x9a, 0x6a, 0xd9, 0x5c, 0x85, 0xa5, 0xb8, 0x49, 0xb1, 0xd7, 0xd4,
	0x1d, 0xb8, 0x45, 0x9c, 0x26, 0xa1, 0x1b, 0xb0, 0xc6, 0x75, 0xb1, 0x9a, 0xdc, 0xd0, 0x2c, 0xe8,
	0xaf, 0x19, 0xc6, 0xc8, 0xd2, 0x5b, 0xfb, 0x8c, 0xb8, 0x77, 0x89, 0x4f, 0x02, 0x47, 0xbd, 0x82,
	0xbe, 0x8a, 0x1f, 0xa3, 0x4a, 0xef, 0x92, 0xa6, 0x98, 0x66, 0x09, 0x09, 0xba, 0x94, 0x5b, 0x8b,
	0xea, 0x05, 0x0a, 0xe7, 0x65, 0x66, 0x14, 0xbf, 0x9c, 0x72, 0xa8, 0xfa, 0x7b, 0x98, 0x0c, 0x0d,
	0x7d, 0x00, 0x17, 0xe3, 0xf1, 0x61, 0x44, 0x3a, 0x1d, 0xcf, 0xd1, 0x9f, 0x5b, 0x98, 0x4f, 0xdb,
	0xf3, 0x27, 0x65, 0x74, 0xea, 0x51, 0xe2, 0x8b, 0xde, 0x4e, 0x8f, 0x3a, 0xc7, 0x32, 0x3c, 0xcb,
	0x9d, 0x52, 0x17, 0xee, 0x73, 0x38, 0x6f, 0x4a, 0xae, 0x23, 0x1c, 0x1c, 0xf9, 0x1e, 0xef, 0xed,
	0x33, 0x21, 0xc3, 0xf5, 0x70, 0xdb, 0x75, 0x65, 0x61, 0x4f, 0xb9, 0xba, 0x66, 0xaf, 0xe1, 0xc2,
	0x79, 0xe4, 0xc2, 0xc5, 0x31, 0xf5, 0xe9, 0x26, 0xbc, 0xfa, 0x0a, 0xfe, 0x2c, 0x3f, 0xd6, 0xca,
	0x93, 0xc2, 0xf9, 0x60, 0xd2, 0x9b, 0x9c, 0xfb, 0x42, 0xd7, 0xfe, 0xab, 0x52, 0x62, 0xe8, 0x4d,
	0xd3, 0xd8, 0x9d, 0x08, 0x14, 0x9b, 0x50, 0x53, 0x5f, 0x70, 0x39, 0xcc, 0x8f, 0x43, 0x57, 0x3c,
	0x56, 0xfd, 0x65, 0xa9, 0x41, 0xdd, 0xb6, 0xd4, 0xcd, 0xe1, 0x27, 0x00, 0xda, 0xa7, 0x2b, 0xdd,
	0x9e, 0xab, 0xb9, 0x9d, 0x02, 0x90, 0x8f, 0x0f, 0xe2, 0x8d, 0xd2, 0x99, 0x41, 0x32, 0xb6, 0x3f,
	0x87, 0x8b, 0xb9, 0xba, 0x42, 0x3b, 0x50, 0x73, 0xcc, 0xa5, 0x9b, 0xf1, 0x22, 0xc5, 0xdf, 0x7f,
	0x64, 0x6f, 0xe7, 0x70, 0x22, 0x68, 0xf7, 0x60, 0x6d, 0x2c, 0xd3, 0x49, 0x7a, 0xe7, 0xa5, 0xaf,
	0xdf, 0x3b, 0x2f, 0x8f, 0x7a, 0xe7, 0xf6, 0xef, 0x96, 0x00, 0x46, 0x1f, 0x52, 0xcc, 0xd8, 0xc0,
	0x49, 0x76, 0xb7, 0x92, 0xbe, 0x1e, 0xbb, 0x04, 0xf3, 0xb4, 0xd3, 0xa1, 0x8e, 0x88, 0xdb, 0xf1,
	0x7a, 0x84, 0xde, 0x85, 0xf5, 0xd1, 0x67, 0x1a, 0xe9, 0x8c, 0xab, 0x82, 0x27, 0x27, 0xec, 0xdf,
	0x28, 0xc1, 0xe5, 0x82, 0xf2, 0xad, 0x30, 0x47, 0x36, 0xd7, 0xbd, 0x29, 0x56, 0x13, 0x35, 0x5e,
	0xbc, 0x6a, 0x1d, 0x07, 0xb0, 0x7f, 0x56, 0x05, 0x34, 0xf9, 0x8d, 0x06, 0x3a, 0x80, 0x55, 0x4e,
	0x1f, 0x7b, 0xc1, 0xe0, 0xf4, 0x20, 0x14, 0xa6, 0x69, 0x77, 0xf6, 0x66, 0xb7, 0x76, 0xd3, 0xec,
	0x78, 0x4c, 0x5c, 0x3a, 0xd7, 0x68, 0x10, 0x6c, 0xf3, 0xa7, 0x9c, 0x6a, 0x45, 0x57, 0xf0, 0x88,
	0x20, 0x1d, 0x93, 0x1a, 0xec, 0xb3, 0x00, 0x33, 0x26, 0x4c, 0xd8, 0xc8, 0xd0, 0x50, 0x03, 0x10,
	0x1f, 0x84, 0xa1, 0xaf, 0x5a, 0x71, 0xc4, 0x7f, 0x10, 0xb1, 0x41, 0xa8, 0x1b, 0xf7, 0x15, 0x9c,
	0x33, 0x83, 0x2c, 0x58, 0xe8, 0x70, 0xf5, 0xdb, 0xec, 0x42, 0x3c, 0x94, 0xe5, 0x96, 0x42, 0xd6,
	0x93, 0xf3, 0x6a, 0x32, 0x45, 0x41, 0xdf, 0x81, 0x05, 0x3e, 0xe4, 0x8e, 0xf0, 0xe3, 0x2f, 0xb0,
	0x8a, 0x3f, 0x86, 0x6b, 0x29, 0x3e, 0x1c, 0xf3, 0xa3, 0x2f, 0x60, 0xf5, 0xb9, 0x17, 0xb8, 0xec,
	0x39, 0x8f, 0xf5, 0x56, 0x53, 0x7a, 0xfb, 0xb0, 0xb8, 0x86, 0xd7, 0xec, 0x63, 0x1b, 0x90, 0xa8,
	0x31, 0x8b, 0x26, 0xfd, 0xac, 0x59, 0xc5, 0x4e, 0x4f, 0xfa, 0x74, 0xe3, 0x9b, 0x17, 0x95, 0x25,
	0xe6, 0x4d, 0xe9, 0x9d, 0x74, 0x1c, 0xd6, 0x0f, 0x9b, 0xa9, 0x7f, 0x65, 0x3a, 0x73, 0x27, 0x33,
	0xec, 0x78, 0x4c, 0xdc, 0x3e, 0x82, 0xd5, 0xec, 0x5e, 0xcb, 0x83, 0x37, 0x90, 0xdb, 0x6a, 0x7c,
	0x9b, 0xfc, 0x2d, 0x69, 0x11, 0xf3, 0x93, 0xfb, 0x72, 0xf9, 0x3b, 0x09, 0xa1, 0x95, 0x54, 0x08,
	0xdd, 0x80, 0x39, 0x9f, 0x9e, 0xa8, 0x0f, 0x3c, 0xd5, 0x19, 0x53, 0x03, 0xfb, 0x36, 0xcc, 0x6b,
	0xcd, 0xce, 0x70, 0x1f, 0xf5, 0x67, 0x25, 0x78, 0xed, 0x4c, 0x65, 0xa2, 0x0f, 0xe1, 0x52, 0xb7,
	0xcf, 0xc9, 0x4e, 0x44, 0x5d, 0x1a, 0xc8, 0x72, 0x49, 0xa6, 0x03, 0xa9, 0xca, 0xa2, 0x60, 0x56,
	0x5a, 0xde, 0xe4, 0x8c, 0x79, 0x78, 0xce, 0x8c, 0x2c, 0x5c, 0x12, 0xd3, 0xde, 0x1f, 0x7d, 0x01,
	0x93, 0x25, 0xda, 0x4d, 0x58, 0xcd, 0x6a, 0x3a, 0xf7, 0x56, 0xe8, 0x26, 0xd4, 0x55, 0xda, 0x25,
	0xbd, 0x59, 0xbc, 0x81, 0xfa, 0xc9, 0x13, 0x74, 0x7b, 0x0d, 0x56, 0x32, 0x9f, 0xb1, 0xd8, 0x16,
	0x5c, 0xca, 0xff, 0x3f, 0x20, 0xfb, 0x12, 0x6c, 0xe4, 0x79, 0x52, 0x7b, 0x03, 0xd0, 0xe4, 0x07,
	0xbc, 0x77, 0xdf, 0xfd, 0xc7, 0xaf, 0xae, 0xbc, 0xf2, 0xcf, 0x5f, 0x5d, 0x79, 0xe5, 0xdf, 0xbf,
	0xba, 0xf2, 0xca, 0x8f, 0xae, 0x68, 0xc3, 0x31, 0xff, 0x67, 0x37, 0xf1, 0xef, 0x7f, 0x47, 0xf3,
	0x2a, 0x88, 0xbd, 0xff, 0xbf, 0x01, 0x00, 0x00, 0xff, 0xff, 0xec, 0xd4, 0x4a, 0x8f, 0x1a, 0x38,
	0x00, 0x00,
}
