// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: security/v1beta1/authorization_policy.proto

// Istio Authorization Policy enables access control on workloads in the mesh.
//
// Authorization policy supports CUSTOM, DENY and ALLOW actions for access control. When CUSTOM, DENY and ALLOW actions
// are used for a workload at the same time, the CUSTOM action is evaluated first, then the DENY action, and finally the ALLOW action.
// The evaluation is determined by the following rules:
//
// 1. If there are any CUSTOM policies that match the request, evaluate and deny the request if the evaluation result is deny.
// 2. If there are any DENY policies that match the request, deny the request.
// 3. If there are no ALLOW policies for the workload, allow the request.
// 4. If any of the ALLOW policies match the request, allow the request.
// 5. Deny the request.
//
// Istio Authorization Policy also supports the AUDIT action to decide whether to log requests.
// AUDIT policies do not affect whether requests are allowed or denied to the workload.
// Requests will be allowed or denied based solely on CUSTOM, DENY and ALLOW actions.
//
// A request will be internally marked that it should be audited if there is an AUDIT policy on the workload that matches the request.
// A separate plugin must be configured and enabled to actually fulfill the audit decision and complete the audit behavior.
// The request will not be audited if there are no such supporting plugins enabled.
// Currently, the only supported plugin is the [Stackdriver](https://istio.io/latest/docs/reference/config/proxy_extensions/stackdriver/) plugin.
//
// Here is an example of Istio Authorization Policy:
//
// It sets the `action` to "ALLOW" to create an allow policy. The default action is "ALLOW"
// but it is useful to be explicit in the policy.
//
// It allows requests from:
//
// - service account "cluster.local/ns/default/sa/sleep" or
// - namespace "test"
//
// to access the workload with:
//
// - "GET" method at paths of prefix "/info" or,
// - "POST" method at path "/data".
//
// when the request has a valid JWT token issued by "https://accounts.google.com".
//
// Any other requests will be denied.
//
// ```yaml
// apiVersion: security.istio.io/v1beta1
// kind: AuthorizationPolicy
// metadata:
//   name: httpbin
//   namespace: foo
// spec:
//   action: ALLOW
//   rules:
//   - from:
//     - source:
//         principals: ["cluster.local/ns/default/sa/sleep"]
//     - source:
//         namespaces: ["test"]
//     to:
//     - operation:
//         methods: ["GET"]
//         paths: ["/info*"]
//     - operation:
//         methods: ["POST"]
//         paths: ["/data"]
//     when:
//     - key: request.auth.claims[iss]
//       values: ["https://accounts.google.com"]
// ```
//
// The following is another example that sets `action` to "DENY" to create a deny policy.
// It denies requests from the "dev" namespace to the "POST" method on all workloads
// in the "foo" namespace.
//
// ```yaml
// apiVersion: security.istio.io/v1beta1
// kind: AuthorizationPolicy
// metadata:
//   name: httpbin
//   namespace: foo
// spec:
//   action: DENY
//   rules:
//   - from:
//     - source:
//         namespaces: ["dev"]
//     to:
//     - operation:
//         methods: ["POST"]
// ```
//
// The following authorization policy sets the `action` to "AUDIT". It will audit any GET requests to the path with the
// prefix "/user/profile".
//
// ```yaml
// apiVersion: security.istio.io/v1beta1
// kind: AuthorizationPolicy
// metadata:
//   namespace: ns1
//   name: anyname
// spec:
//   selector:
//     matchLabels:
//       app: myapi
//   action: AUDIT
//   rules:
//   - to:
//     - operation:
//         methods: ["GET"]
//         paths: ["/user/profile/*"]
// ```
//
// Authorization Policy scope (target) is determined by "metadata/namespace" and
// an optional "selector".
//
// - "metadata/namespace" tells which namespace the policy applies. If set to root
// namespace, the policy applies to all namespaces in a mesh.
// - workload "selector" can be used to further restrict where a policy applies.
//
// For example,
//
// The following authorization policy applies to workloads containing label
// "app: httpbin" in namespace bar.
//
// ```yaml
// apiVersion: security.istio.io/v1beta1
// kind: AuthorizationPolicy
// metadata:
//   name: policy
//   namespace: bar
// spec:
//   selector:
//     matchLabels:
//       app: httpbin
// ```
//
// The following authorization policy applies to all workloads in namespace foo.
//
// ```yaml
// apiVersion: security.istio.io/v1beta1
// kind: AuthorizationPolicy
// metadata:
//  name: policy
//  namespace: foo
// spec:
//   {}
// ```
//
// The following authorization policy applies to workloads containing label
// "version: v1" in all namespaces in the mesh. (Assuming the root namespace is
// configured to "istio-config").
//
// ```yaml
// apiVersion: security.istio.io/v1beta1
// kind: AuthorizationPolicy
// metadata:
//  name: policy
//  namespace: istio-config
// spec:
//  selector:
//    matchLabels:
//      version: v1
// ```

package v1beta1

import (
	fmt "fmt"
	proto "github.com/gogo/protobuf/proto"
	io "io"
	v1beta1 "istio.io/api/type/v1beta1"
	_ "istio.io/gogo-genproto/googleapis/google/api"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

// Action specifies the operation to take.
type AuthorizationPolicy_Action int32

const (
	// Allow a request only if it matches the rules. This is the default type.
	AuthorizationPolicy_ALLOW AuthorizationPolicy_Action = 0
	// Deny a request if it matches any of the rules.
	AuthorizationPolicy_DENY AuthorizationPolicy_Action = 1
	// Audit a request if it matches any of the rules.
	AuthorizationPolicy_AUDIT AuthorizationPolicy_Action = 2
	// The CUSTOM action allows an extension to handle the user request if the matching rules evaluate to true.
	// The extension is evaluated independently and before the native ALLOW and DENY actions. When used together, A request
	// is allowed if and only if all the actions return allow, in other words, the extension cannot bypass the
	// authorization decision made by ALLOW and DENY action.
	// Extension behavior is defined by the named providers declared in MeshConfig. The authorization policy refers to
	// the extension by specifying the name of the provider.
	// One example use case of the extension is to integrate with a custom external authorization system to delegate
	// the authorization decision to it.
	//
	// Note: The CUSTOM action is currently an **experimental feature** and is subject to breaking changes in later versions.
	//
	// The following authorization policy applies to an ingress gateway and delegates the authorization check to a named extension
	// "my-custom-authz" if the request path has prefix "/admin/".
	//
	// ```yaml
	// apiVersion: security.istio.io/v1beta1
	// kind: AuthorizationPolicy
	// metadata:
	//  name: ext-authz
	//  namespace: istio-system
	// spec:
	//  selector:
	//    matchLabels:
	//      app: istio-ingressgateway
	//  action: CUSTOM
	//  provider:
	//    name: "my-custom-authz"
	//  rules:
	//  - to:
	//    - operation:
	//        paths: ["/admin/*"]
	// ```
	AuthorizationPolicy_CUSTOM AuthorizationPolicy_Action = 3
)

var AuthorizationPolicy_Action_name = map[int32]string{
	0: "ALLOW",
	1: "DENY",
	2: "AUDIT",
	3: "CUSTOM",
}

var AuthorizationPolicy_Action_value = map[string]int32{
	"ALLOW":  0,
	"DENY":   1,
	"AUDIT":  2,
	"CUSTOM": 3,
}

func (x AuthorizationPolicy_Action) String() string {
	return proto.EnumName(AuthorizationPolicy_Action_name, int32(x))
}

func (AuthorizationPolicy_Action) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_438e25379256bb35, []int{0, 0}
}

// AuthorizationPolicy enables access control on workloads.
//
// For example, the following authorization policy allows nothing and effectively denies all requests to workloads
// in namespace foo.
//
// ```yaml
// apiVersion: security.istio.io/v1beta1
// kind: AuthorizationPolicy
// metadata:
//  name: allow-nothing
//  namespace: foo
// spec:
//   {}
// ```
//
// The following authorization policy allows all requests to workloads in namespace foo.
//
// ```yaml
// apiVersion: security.istio.io/v1beta1
// kind: AuthorizationPolicy
// metadata:
//  name: allow-all
//  namespace: foo
// spec:
//  rules:
//  - {}
// ```
//
// <!-- crd generation tags
// +cue-gen:AuthorizationPolicy:groupName:security.istio.io
// +cue-gen:AuthorizationPolicy:version:v1beta1
// +cue-gen:AuthorizationPolicy:storageVersion
// +cue-gen:AuthorizationPolicy:annotations:helm.sh/resource-policy=keep
// +cue-gen:AuthorizationPolicy:labels:app=istio-pilot,chart=istio,istio=security,heritage=Tiller,release=istio
// +cue-gen:AuthorizationPolicy:subresource:status
// +cue-gen:AuthorizationPolicy:scope:Namespaced
// +cue-gen:AuthorizationPolicy:resource:categories=istio-io,security-istio-io,plural=authorizationpolicies
// +cue-gen:AuthorizationPolicy:preserveUnknownFields:false
// -->
//
// <!-- go code generation tags
// +kubetype-gen
// +kubetype-gen:groupVersion=security.istio.io/v1beta1
// +genclient
// +k8s:deepcopy-gen=true
// -->
type AuthorizationPolicy struct {
	// Optional. Workload selector decides where to apply the authorization policy.
	// If not set, the authorization policy will be applied to all workloads in the
	// same namespace as the authorization policy.
	Selector *v1beta1.WorkloadSelector `protobuf:"bytes,1,opt,name=selector,proto3" json:"selector,omitempty"`
	// Optional. A list of rules to match the request. A match occurs when at least
	// one rule matches the request.
	//
	// If not set, the match will never occur. This is equivalent to setting a
	// default of deny for the target workloads.
	Rules []*Rule `protobuf:"bytes,2,rep,name=rules,proto3" json:"rules,omitempty"`
	// Optional. The action to take if the request is matched with the rules.
	Action AuthorizationPolicy_Action `protobuf:"varint,3,opt,name=action,proto3,enum=istio.security.v1beta1.AuthorizationPolicy_Action" json:"action,omitempty"`
	// Types that are valid to be assigned to ActionDetail:
	//	*AuthorizationPolicy_Provider
	ActionDetail         isAuthorizationPolicy_ActionDetail `protobuf_oneof:"action_detail"`
	XXX_NoUnkeyedLiteral struct{}                           `json:"-"`
	XXX_unrecognized     []byte                             `json:"-"`
	XXX_sizecache        int32                              `json:"-"`
}

func (m *AuthorizationPolicy) Reset()         { *m = AuthorizationPolicy{} }
func (m *AuthorizationPolicy) String() string { return proto.CompactTextString(m) }
func (*AuthorizationPolicy) ProtoMessage()    {}
func (*AuthorizationPolicy) Descriptor() ([]byte, []int) {
	return fileDescriptor_438e25379256bb35, []int{0}
}
func (m *AuthorizationPolicy) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AuthorizationPolicy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AuthorizationPolicy.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AuthorizationPolicy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AuthorizationPolicy.Merge(m, src)
}
func (m *AuthorizationPolicy) XXX_Size() int {
	return m.Size()
}
func (m *AuthorizationPolicy) XXX_DiscardUnknown() {
	xxx_messageInfo_AuthorizationPolicy.DiscardUnknown(m)
}

var xxx_messageInfo_AuthorizationPolicy proto.InternalMessageInfo

type isAuthorizationPolicy_ActionDetail interface {
	isAuthorizationPolicy_ActionDetail()
	MarshalTo([]byte) (int, error)
	Size() int
}

type AuthorizationPolicy_Provider struct {
	Provider *AuthorizationPolicy_ExtensionProvider `protobuf:"bytes,4,opt,name=provider,proto3,oneof" json:"provider,omitempty"`
}

func (*AuthorizationPolicy_Provider) isAuthorizationPolicy_ActionDetail() {}

func (m *AuthorizationPolicy) GetActionDetail() isAuthorizationPolicy_ActionDetail {
	if m != nil {
		return m.ActionDetail
	}
	return nil
}

func (m *AuthorizationPolicy) GetSelector() *v1beta1.WorkloadSelector {
	if m != nil {
		return m.Selector
	}
	return nil
}

func (m *AuthorizationPolicy) GetRules() []*Rule {
	if m != nil {
		return m.Rules
	}
	return nil
}

func (m *AuthorizationPolicy) GetAction() AuthorizationPolicy_Action {
	if m != nil {
		return m.Action
	}
	return AuthorizationPolicy_ALLOW
}

func (m *AuthorizationPolicy) GetProvider() *AuthorizationPolicy_ExtensionProvider {
	if x, ok := m.GetActionDetail().(*AuthorizationPolicy_Provider); ok {
		return x.Provider
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*AuthorizationPolicy) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*AuthorizationPolicy_Provider)(nil),
	}
}

type AuthorizationPolicy_ExtensionProvider struct {
	// Specifies the name of the extension provider. The list of available providers is defined in the MeshConfig.
	// Note, currently at most 1 extension provider is allowed per workload. Different workloads can use different extension provider.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AuthorizationPolicy_ExtensionProvider) Reset()         { *m = AuthorizationPolicy_ExtensionProvider{} }
func (m *AuthorizationPolicy_ExtensionProvider) String() string { return proto.CompactTextString(m) }
func (*AuthorizationPolicy_ExtensionProvider) ProtoMessage()    {}
func (*AuthorizationPolicy_ExtensionProvider) Descriptor() ([]byte, []int) {
	return fileDescriptor_438e25379256bb35, []int{0, 0}
}
func (m *AuthorizationPolicy_ExtensionProvider) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AuthorizationPolicy_ExtensionProvider) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AuthorizationPolicy_ExtensionProvider.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AuthorizationPolicy_ExtensionProvider) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AuthorizationPolicy_ExtensionProvider.Merge(m, src)
}
func (m *AuthorizationPolicy_ExtensionProvider) XXX_Size() int {
	return m.Size()
}
func (m *AuthorizationPolicy_ExtensionProvider) XXX_DiscardUnknown() {
	xxx_messageInfo_AuthorizationPolicy_ExtensionProvider.DiscardUnknown(m)
}

var xxx_messageInfo_AuthorizationPolicy_ExtensionProvider proto.InternalMessageInfo

func (m *AuthorizationPolicy_ExtensionProvider) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Rule matches requests from a list of sources that perform a list of operations subject to a
// list of conditions. A match occurs when at least one source, one operation and all conditions
// matches the request. An empty rule is always matched.
//
// Any string field in the rule supports Exact, Prefix, Suffix and Presence match:
//
// - Exact match: "abc" will match on value "abc".
// - Prefix match: "abc*" will match on value "abc" and "abcd".
// - Suffix match: "*abc" will match on value "abc" and "xabc".
// - Presence match: "*" will match when value is not empty.
type Rule struct {
	// Optional. from specifies the source of a request.
	//
	// If not set, any source is allowed.
	From []*Rule_From `protobuf:"bytes,1,rep,name=from,proto3" json:"from,omitempty"`
	// Optional. to specifies the operation of a request.
	//
	// If not set, any operation is allowed.
	To []*Rule_To `protobuf:"bytes,2,rep,name=to,proto3" json:"to,omitempty"`
	// Optional. when specifies a list of additional conditions of a request.
	//
	// If not set, any condition is allowed.
	When                 []*Condition `protobuf:"bytes,3,rep,name=when,proto3" json:"when,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *Rule) Reset()         { *m = Rule{} }
func (m *Rule) String() string { return proto.CompactTextString(m) }
func (*Rule) ProtoMessage()    {}
func (*Rule) Descriptor() ([]byte, []int) {
	return fileDescriptor_438e25379256bb35, []int{1}
}
func (m *Rule) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Rule) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Rule.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Rule) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Rule.Merge(m, src)
}
func (m *Rule) XXX_Size() int {
	return m.Size()
}
func (m *Rule) XXX_DiscardUnknown() {
	xxx_messageInfo_Rule.DiscardUnknown(m)
}

var xxx_messageInfo_Rule proto.InternalMessageInfo

func (m *Rule) GetFrom() []*Rule_From {
	if m != nil {
		return m.From
	}
	return nil
}

func (m *Rule) GetTo() []*Rule_To {
	if m != nil {
		return m.To
	}
	return nil
}

func (m *Rule) GetWhen() []*Condition {
	if m != nil {
		return m.When
	}
	return nil
}

// From includes a list or sources.
type Rule_From struct {
	// Source specifies the source of a request.
	Source               *Source  `protobuf:"bytes,1,opt,name=source,proto3" json:"source,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Rule_From) Reset()         { *m = Rule_From{} }
func (m *Rule_From) String() string { return proto.CompactTextString(m) }
func (*Rule_From) ProtoMessage()    {}
func (*Rule_From) Descriptor() ([]byte, []int) {
	return fileDescriptor_438e25379256bb35, []int{1, 0}
}
func (m *Rule_From) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Rule_From) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Rule_From.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Rule_From) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Rule_From.Merge(m, src)
}
func (m *Rule_From) XXX_Size() int {
	return m.Size()
}
func (m *Rule_From) XXX_DiscardUnknown() {
	xxx_messageInfo_Rule_From.DiscardUnknown(m)
}

var xxx_messageInfo_Rule_From proto.InternalMessageInfo

func (m *Rule_From) GetSource() *Source {
	if m != nil {
		return m.Source
	}
	return nil
}

// To includes a list or operations.
type Rule_To struct {
	// Operation specifies the operation of a request.
	Operation            *Operation `protobuf:"bytes,1,opt,name=operation,proto3" json:"operation,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *Rule_To) Reset()         { *m = Rule_To{} }
func (m *Rule_To) String() string { return proto.CompactTextString(m) }
func (*Rule_To) ProtoMessage()    {}
func (*Rule_To) Descriptor() ([]byte, []int) {
	return fileDescriptor_438e25379256bb35, []int{1, 1}
}
func (m *Rule_To) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Rule_To) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Rule_To.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Rule_To) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Rule_To.Merge(m, src)
}
func (m *Rule_To) XXX_Size() int {
	return m.Size()
}
func (m *Rule_To) XXX_DiscardUnknown() {
	xxx_messageInfo_Rule_To.DiscardUnknown(m)
}

var xxx_messageInfo_Rule_To proto.InternalMessageInfo

func (m *Rule_To) GetOperation() *Operation {
	if m != nil {
		return m.Operation
	}
	return nil
}

// Source specifies the source identities of a request. Fields in the source are
// ANDed together.
//
// For example, the following source matches if the principal is "admin" or "dev"
// and the namespace is "prod" or "test" and the ip is not "1.2.3.4".
//
// ```yaml
// principals: ["admin", "dev"]
// namespaces: ["prod", "test"]
// not_ipblocks: ["1.2.3.4"]
// ```
type Source struct {
	// Optional. A list of source peer identities (i.e. service account), which
	// matches to the "source.principal" attribute. This field requires mTLS enabled.
	//
	// If not set, any principal is allowed.
	Principals []string `protobuf:"bytes,1,rep,name=principals,proto3" json:"principals,omitempty"`
	// Optional. A list of negative match of source peer identities.
	NotPrincipals []string `protobuf:"bytes,5,rep,name=not_principals,json=notPrincipals,proto3" json:"not_principals,omitempty"`
	// Optional. A list of request identities (i.e. "iss/sub" claims), which
	// matches to the "request.auth.principal" attribute.
	//
	// If not set, any request principal is allowed.
	RequestPrincipals []string `protobuf:"bytes,2,rep,name=request_principals,json=requestPrincipals,proto3" json:"request_principals,omitempty"`
	// Optional. A list of negative match of request identities.
	NotRequestPrincipals []string `protobuf:"bytes,6,rep,name=not_request_principals,json=notRequestPrincipals,proto3" json:"not_request_principals,omitempty"`
	// Optional. A list of namespaces, which matches to the "source.namespace"
	// attribute. This field requires mTLS enabled.
	//
	// If not set, any namespace is allowed.
	Namespaces []string `protobuf:"bytes,3,rep,name=namespaces,proto3" json:"namespaces,omitempty"`
	// Optional. A list of negative match of namespaces.
	NotNamespaces []string `protobuf:"bytes,7,rep,name=not_namespaces,json=notNamespaces,proto3" json:"not_namespaces,omitempty"`
	// Optional. A list of IP blocks, which matches to the "source.ip" attribute.
	// Populated from the source address of the IP packet.
	// Single IP (e.g. "1.2.3.4") and CIDR (e.g. "1.2.3.0/24") are supported.
	//
	// If not set, any IP is allowed.
	IpBlocks []string `protobuf:"bytes,4,rep,name=ip_blocks,json=ipBlocks,proto3" json:"ip_blocks,omitempty"`
	// Optional. A list of negative match of IP blocks.
	NotIpBlocks []string `protobuf:"bytes,8,rep,name=not_ip_blocks,json=notIpBlocks,proto3" json:"not_ip_blocks,omitempty"`
	// Optional. A list of IP blocks, which matches to the "remote.ip" attribute.
	// Populated from X-Forwarded-For header or proxy protocol.
	// To make use of this field, you must configure the numTrustedProxies field of the gatewayTopology under the meshConfig
	// when you install Istio or using an annotation on the ingress gateway.  See the documentation here:
	// [Configuring Gateway Network Topology](https://istio.io/latest/docs/ops/configuration/traffic-management/network-topologies/).
	// Single IP (e.g. "1.2.3.4") and CIDR (e.g. "1.2.3.0/24") are supported.
	//
	// If not set, any IP is allowed.
	RemoteIpBlocks []string `protobuf:"bytes,9,rep,name=remote_ip_blocks,json=remoteIpBlocks,proto3" json:"remote_ip_blocks,omitempty"`
	// Optional. A list of negative match of remote IP blocks.
	NotRemoteIpBlocks    []string `protobuf:"bytes,10,rep,name=not_remote_ip_blocks,json=notRemoteIpBlocks,proto3" json:"not_remote_ip_blocks,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Source) Reset()         { *m = Source{} }
func (m *Source) String() string { return proto.CompactTextString(m) }
func (*Source) ProtoMessage()    {}
func (*Source) Descriptor() ([]byte, []int) {
	return fileDescriptor_438e25379256bb35, []int{2}
}
func (m *Source) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Source) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Source.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Source) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Source.Merge(m, src)
}
func (m *Source) XXX_Size() int {
	return m.Size()
}
func (m *Source) XXX_DiscardUnknown() {
	xxx_messageInfo_Source.DiscardUnknown(m)
}

var xxx_messageInfo_Source proto.InternalMessageInfo

func (m *Source) GetPrincipals() []string {
	if m != nil {
		return m.Principals
	}
	return nil
}

func (m *Source) GetNotPrincipals() []string {
	if m != nil {
		return m.NotPrincipals
	}
	return nil
}

func (m *Source) GetRequestPrincipals() []string {
	if m != nil {
		return m.RequestPrincipals
	}
	return nil
}

func (m *Source) GetNotRequestPrincipals() []string {
	if m != nil {
		return m.NotRequestPrincipals
	}
	return nil
}

func (m *Source) GetNamespaces() []string {
	if m != nil {
		return m.Namespaces
	}
	return nil
}

func (m *Source) GetNotNamespaces() []string {
	if m != nil {
		return m.NotNamespaces
	}
	return nil
}

func (m *Source) GetIpBlocks() []string {
	if m != nil {
		return m.IpBlocks
	}
	return nil
}

func (m *Source) GetNotIpBlocks() []string {
	if m != nil {
		return m.NotIpBlocks
	}
	return nil
}

func (m *Source) GetRemoteIpBlocks() []string {
	if m != nil {
		return m.RemoteIpBlocks
	}
	return nil
}

func (m *Source) GetNotRemoteIpBlocks() []string {
	if m != nil {
		return m.NotRemoteIpBlocks
	}
	return nil
}

// Operation specifies the operations of a request. Fields in the operation are
// ANDed together.
//
// For example, the following operation matches if the host has suffix ".example.com"
// and the method is "GET" or "HEAD" and the path doesn't have prefix "/admin".
//
// ```yaml
// hosts: ["*.example.com"]
// methods: ["GET", "HEAD"]
// not_paths: ["/admin*"]
// ```
type Operation struct {
	// Optional. A list of hosts, which matches to the "request.host" attribute.
	//
	// If not set, any host is allowed. Must be used only with HTTP.
	Hosts []string `protobuf:"bytes,1,rep,name=hosts,proto3" json:"hosts,omitempty"`
	// Optional. A list of negative match of hosts.
	NotHosts []string `protobuf:"bytes,5,rep,name=not_hosts,json=notHosts,proto3" json:"not_hosts,omitempty"`
	// Optional. A list of ports, which matches to the "destination.port" attribute.
	//
	// If not set, any port is allowed.
	Ports []string `protobuf:"bytes,2,rep,name=ports,proto3" json:"ports,omitempty"`
	// Optional. A list of negative match of ports.
	NotPorts []string `protobuf:"bytes,6,rep,name=not_ports,json=notPorts,proto3" json:"not_ports,omitempty"`
	// Optional. A list of methods, which matches to the "request.method" attribute.
	// For gRPC service, this will always be "POST".
	//
	// If not set, any method is allowed. Must be used only with HTTP.
	Methods []string `protobuf:"bytes,3,rep,name=methods,proto3" json:"methods,omitempty"`
	// Optional. A list of negative match of methods.
	NotMethods []string `protobuf:"bytes,7,rep,name=not_methods,json=notMethods,proto3" json:"not_methods,omitempty"`
	// Optional. A list of paths, which matches to the "request.url_path" attribute.
	// For gRPC service, this will be the fully-qualified name in the form of
	// "/package.service/method".
	//
	// If not set, any path is allowed. Must be used only with HTTP.
	Paths []string `protobuf:"bytes,4,rep,name=paths,proto3" json:"paths,omitempty"`
	// Optional. A list of negative match of paths.
	NotPaths             []string `protobuf:"bytes,8,rep,name=not_paths,json=notPaths,proto3" json:"not_paths,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Operation) Reset()         { *m = Operation{} }
func (m *Operation) String() string { return proto.CompactTextString(m) }
func (*Operation) ProtoMessage()    {}
func (*Operation) Descriptor() ([]byte, []int) {
	return fileDescriptor_438e25379256bb35, []int{3}
}
func (m *Operation) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Operation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Operation.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Operation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Operation.Merge(m, src)
}
func (m *Operation) XXX_Size() int {
	return m.Size()
}
func (m *Operation) XXX_DiscardUnknown() {
	xxx_messageInfo_Operation.DiscardUnknown(m)
}

var xxx_messageInfo_Operation proto.InternalMessageInfo

func (m *Operation) GetHosts() []string {
	if m != nil {
		return m.Hosts
	}
	return nil
}

func (m *Operation) GetNotHosts() []string {
	if m != nil {
		return m.NotHosts
	}
	return nil
}

func (m *Operation) GetPorts() []string {
	if m != nil {
		return m.Ports
	}
	return nil
}

func (m *Operation) GetNotPorts() []string {
	if m != nil {
		return m.NotPorts
	}
	return nil
}

func (m *Operation) GetMethods() []string {
	if m != nil {
		return m.Methods
	}
	return nil
}

func (m *Operation) GetNotMethods() []string {
	if m != nil {
		return m.NotMethods
	}
	return nil
}

func (m *Operation) GetPaths() []string {
	if m != nil {
		return m.Paths
	}
	return nil
}

func (m *Operation) GetNotPaths() []string {
	if m != nil {
		return m.NotPaths
	}
	return nil
}

// Condition specifies additional required attributes.
type Condition struct {
	// The name of an Istio attribute.
	// See the [full list of supported attributes](https://istio.io/docs/reference/config/security/conditions/).
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// Optional. A list of allowed values for the attribute.
	// Note: at least one of values or not_values must be set.
	Values []string `protobuf:"bytes,2,rep,name=values,proto3" json:"values,omitempty"`
	// Optional. A list of negative match of values for the attribute.
	// Note: at least one of values or not_values must be set.
	NotValues            []string `protobuf:"bytes,3,rep,name=not_values,json=notValues,proto3" json:"not_values,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Condition) Reset()         { *m = Condition{} }
func (m *Condition) String() string { return proto.CompactTextString(m) }
func (*Condition) ProtoMessage()    {}
func (*Condition) Descriptor() ([]byte, []int) {
	return fileDescriptor_438e25379256bb35, []int{4}
}
func (m *Condition) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Condition) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Condition.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Condition) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Condition.Merge(m, src)
}
func (m *Condition) XXX_Size() int {
	return m.Size()
}
func (m *Condition) XXX_DiscardUnknown() {
	xxx_messageInfo_Condition.DiscardUnknown(m)
}

var xxx_messageInfo_Condition proto.InternalMessageInfo

func (m *Condition) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

func (m *Condition) GetValues() []string {
	if m != nil {
		return m.Values
	}
	return nil
}

func (m *Condition) GetNotValues() []string {
	if m != nil {
		return m.NotValues
	}
	return nil
}

func init() {
	proto.RegisterEnum("istio.security.v1beta1.AuthorizationPolicy_Action", AuthorizationPolicy_Action_name, AuthorizationPolicy_Action_value)
	proto.RegisterType((*AuthorizationPolicy)(nil), "istio.security.v1beta1.AuthorizationPolicy")
	proto.RegisterType((*AuthorizationPolicy_ExtensionProvider)(nil), "istio.security.v1beta1.AuthorizationPolicy.ExtensionProvider")
	proto.RegisterType((*Rule)(nil), "istio.security.v1beta1.Rule")
	proto.RegisterType((*Rule_From)(nil), "istio.security.v1beta1.Rule.From")
	proto.RegisterType((*Rule_To)(nil), "istio.security.v1beta1.Rule.To")
	proto.RegisterType((*Source)(nil), "istio.security.v1beta1.Source")
	proto.RegisterType((*Operation)(nil), "istio.security.v1beta1.Operation")
	proto.RegisterType((*Condition)(nil), "istio.security.v1beta1.Condition")
}

func init() {
	proto.RegisterFile("security/v1beta1/authorization_policy.proto", fileDescriptor_438e25379256bb35)
}

var fileDescriptor_438e25379256bb35 = []byte{
	// 768 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x95, 0xdd, 0x6e, 0xe3, 0x44,
	0x14, 0xc7, 0xd7, 0x8e, 0xe3, 0xc6, 0xa7, 0xda, 0x92, 0x1d, 0xa2, 0x28, 0xca, 0xb2, 0x69, 0x89,
	0x40, 0x44, 0x5a, 0xe1, 0x68, 0xc3, 0xc2, 0x1d, 0x1f, 0xc9, 0x6e, 0xd1, 0x16, 0xf5, 0x4b, 0x6e,
	0x4a, 0x45, 0xb9, 0xb0, 0x1c, 0x67, 0xda, 0x8c, 0xea, 0xf8, 0x98, 0xf1, 0x24, 0x10, 0x5e, 0x84,
	0x17, 0xe0, 0x92, 0x07, 0xe1, 0x92, 0x37, 0x00, 0xe5, 0x49, 0xd0, 0xcc, 0xd8, 0x8e, 0xe9, 0x97,
	0xc4, 0x5d, 0xce, 0x9c, 0xdf, 0xff, 0x9c, 0x33, 0xff, 0x63, 0x3b, 0xf0, 0x32, 0xa5, 0xe1, 0x82,
	0x33, 0xb1, 0xea, 0x2f, 0x5f, 0x4d, 0xa8, 0x08, 0x5e, 0xf5, 0x83, 0x85, 0x98, 0x21, 0x67, 0xbf,
	0x06, 0x82, 0x61, 0xec, 0x27, 0x18, 0xb1, 0x70, 0xe5, 0x26, 0x1c, 0x05, 0x92, 0x26, 0x4b, 0x05,
	0x43, 0x37, 0x97, 0xb8, 0x99, 0xa4, 0xbd, 0x7b, 0x8d, 0x78, 0x1d, 0xd1, 0x7e, 0x90, 0xb0, 0xfe,
	0x15, 0xa3, 0xd1, 0xd4, 0x9f, 0xd0, 0x59, 0xb0, 0x64, 0xc8, 0xb5, 0xb0, 0xfd, 0x5c, 0xac, 0x12,
	0x5a, 0x74, 0x48, 0x69, 0x44, 0x43, 0x91, 0x27, 0xbb, 0xbf, 0x57, 0xe0, 0xfd, 0x61, 0xb9, 0xe9,
	0xa9, 0xea, 0x49, 0xbe, 0x81, 0x5a, 0x4e, 0xb6, 0x8c, 0x3d, 0xa3, 0xb7, 0x3d, 0xf8, 0xc8, 0xd5,
	0x03, 0xc8, 0x6a, 0x79, 0x73, 0xf7, 0x02, 0xf9, 0x4d, 0x84, 0xc1, 0xf4, 0x2c, 0x63, 0xbd, 0x42,
	0x45, 0x06, 0x50, 0xe5, 0x8b, 0x88, 0xa6, 0x2d, 0x73, 0xaf, 0xd2, 0xdb, 0x1e, 0x7c, 0xe0, 0xde,
	0x3f, 0xbf, 0xeb, 0x2d, 0x22, 0xea, 0x69, 0x94, 0x7c, 0x07, 0x76, 0x10, 0xca, 0x29, 0x5a, 0x95,
	0x3d, 0xa3, 0xb7, 0x33, 0x18, 0x3c, 0x24, 0xba, 0x67, 0x64, 0x77, 0xa8, 0x94, 0x5e, 0x56, 0x81,
	0xfc, 0x08, 0xb5, 0x84, 0xe3, 0x92, 0x4d, 0x29, 0x6f, 0x59, 0xea, 0x06, 0x5f, 0xfe, 0x9f, 0x6a,
	0xfb, 0xbf, 0x08, 0x1a, 0xa7, 0x32, 0xce, 0x8a, 0xbc, 0x7b, 0xe2, 0x15, 0x05, 0xdb, 0x9f, 0xc0,
	0xb3, 0x3b, 0x00, 0x21, 0x60, 0xc5, 0xc1, 0x9c, 0x2a, 0xbf, 0x1c, 0x4f, 0xfd, 0xee, 0xbe, 0x06,
	0x5b, 0xcf, 0x45, 0x1c, 0xa8, 0x0e, 0x0f, 0x0f, 0x4f, 0x2e, 0xea, 0x4f, 0x48, 0x0d, 0xac, 0xb7,
	0xfb, 0xc7, 0x3f, 0xd4, 0x0d, 0x75, 0x78, 0xfe, 0xf6, 0x60, 0x5c, 0x37, 0x09, 0x80, 0xfd, 0xe6,
	0xfc, 0x6c, 0x7c, 0x72, 0x54, 0xaf, 0x8c, 0xde, 0x83, 0xa7, 0xfa, 0x16, 0xfe, 0x94, 0x8a, 0x80,
	0x45, 0xdd, 0x3f, 0x4c, 0xb0, 0xa4, 0x51, 0xe4, 0x73, 0xb0, 0xae, 0x38, 0xce, 0x5b, 0x86, 0x32,
	0xf5, 0xc3, 0xc7, 0x4c, 0x75, 0xbf, 0xe5, 0x38, 0xf7, 0x14, 0x4e, 0xfa, 0x60, 0x0a, 0xcc, 0x36,
	0xb1, 0xfb, 0xa8, 0x68, 0x8c, 0x9e, 0x29, 0x50, 0xf6, 0xf9, 0x79, 0x46, 0xe5, 0x1e, 0x1e, 0xed,
	0xf3, 0x06, 0xe3, 0x29, 0x53, 0xb6, 0x2b, 0xbc, 0xfd, 0x15, 0x58, 0xb2, 0x2b, 0xf9, 0x02, 0xec,
	0x14, 0x17, 0x3c, 0xa4, 0xd9, 0xc3, 0xd3, 0x79, 0xa8, 0xc0, 0x99, 0xa2, 0xbc, 0x8c, 0x6e, 0xef,
	0x83, 0x39, 0x46, 0xf2, 0x35, 0x38, 0x98, 0x50, 0xae, 0xd6, 0x91, 0x15, 0x78, 0x70, 0x82, 0x93,
	0x1c, 0xf4, 0x36, 0x9a, 0xee, 0x6f, 0x15, 0xb0, 0x75, 0x65, 0xd2, 0x01, 0x48, 0x38, 0x8b, 0x43,
	0x96, 0x04, 0x51, 0xaa, 0x6c, 0x73, 0xbc, 0xd2, 0x09, 0xf9, 0x18, 0x76, 0x62, 0x14, 0x7e, 0x89,
	0xa9, 0x2a, 0xe6, 0x69, 0x8c, 0xe2, 0x74, 0x83, 0x7d, 0x0a, 0x84, 0xd3, 0x9f, 0x16, 0x34, 0xfd,
	0x0f, 0x6a, 0x2a, 0xf4, 0x59, 0x96, 0x29, 0xe1, 0xaf, 0xa1, 0x29, 0xab, 0xde, 0x23, 0xb1, 0x95,
	0xa4, 0x11, 0xa3, 0xf0, 0xee, 0xa8, 0x3a, 0x00, 0xf2, 0xa1, 0x49, 0x93, 0x20, 0xa4, 0xa9, 0xb2,
	0xde, 0xf1, 0x4a, 0x27, 0xf9, 0xac, 0x25, 0x66, 0xab, 0x98, 0xf5, 0x78, 0x83, 0x3d, 0x07, 0x87,
	0x25, 0xfe, 0x24, 0xc2, 0xf0, 0x26, 0x6d, 0x59, 0x8a, 0xa8, 0xb1, 0x64, 0xa4, 0x62, 0xd2, 0x05,
	0x49, 0xfb, 0x1b, 0xa0, 0xa6, 0x80, 0xed, 0x18, 0xc5, 0x41, 0xce, 0xf4, 0xa0, 0xce, 0xe9, 0x1c,
	0x05, 0x2d, 0x61, 0x8e, 0xc2, 0x76, 0xf4, 0x79, 0x41, 0xf6, 0xa1, 0xa1, 0xef, 0x79, 0x8b, 0x06,
	0x6d, 0x8c, 0xba, 0x65, 0x59, 0xd0, 0xfd, 0xdb, 0x00, 0xa7, 0x58, 0x19, 0x69, 0x40, 0x75, 0x86,
	0xa9, 0xc8, 0xf7, 0xa2, 0x03, 0x39, 0xbf, 0x2c, 0xaa, 0x33, 0x7a, 0x1b, 0xb5, 0x18, 0xc5, 0x3b,
	0x95, 0x6c, 0x40, 0x35, 0x41, 0x2e, 0x72, 0xef, 0x75, 0x90, 0x4b, 0x74, 0xc6, 0x2e, 0x24, 0xa7,
	0x2a, 0xd9, 0x82, 0xad, 0x39, 0x15, 0x33, 0x9c, 0xe6, 0x9e, 0xe6, 0x21, 0xd9, 0x05, 0x79, 0x6f,
	0x3f, 0xcf, 0x6e, 0x65, 0x8e, 0xa3, 0x38, 0xca, 0x00, 0xd9, 0x2d, 0x10, 0xb3, 0xdc, 0x46, 0x1d,
	0x14, 0xdd, 0x54, 0xa6, 0xb6, 0xe9, 0x26, 0xe3, 0xee, 0x25, 0x38, 0xc5, 0x5b, 0x41, 0x9a, 0x50,
	0xb9, 0xa1, 0x2b, 0xfd, 0x45, 0x18, 0x59, 0xeb, 0xa1, 0x61, 0x7a, 0xf2, 0x80, 0x34, 0xc1, 0x5e,
	0x06, 0xd1, 0x82, 0xe6, 0xd7, 0xc8, 0x22, 0xf2, 0x02, 0x64, 0x77, 0x3f, 0xcb, 0xe9, 0x69, 0x65,
	0xaf, 0xef, 0xd5, 0xc1, 0xe8, 0xe5, 0x9f, 0xeb, 0x8e, 0xf1, 0xd7, 0xba, 0x63, 0xfc, 0xb3, 0xee,
	0x18, 0x97, 0x2f, 0xf4, 0x2b, 0xc1, 0x50, 0x7d, 0xfb, 0x6f, 0xff, 0x97, 0x4c, 0x6c, 0xf5, 0x85,
	0xff, 0xec, 0xdf, 0x00, 0x00, 0x00, 0xff, 0xff, 0xe2, 0xda, 0xc0, 0xc7, 0x66, 0x06, 0x00, 0x00,
}

func (m *AuthorizationPolicy) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AuthorizationPolicy) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AuthorizationPolicy) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.ActionDetail != nil {
		{
			size := m.ActionDetail.Size()
			i -= size
			if _, err := m.ActionDetail.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	if m.Action != 0 {
		i = encodeVarintAuthorizationPolicy(dAtA, i, uint64(m.Action))
		i--
		dAtA[i] = 0x18
	}
	if len(m.Rules) > 0 {
		for iNdEx := len(m.Rules) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Rules[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAuthorizationPolicy(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.Selector != nil {
		{
			size, err := m.Selector.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAuthorizationPolicy(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *AuthorizationPolicy_Provider) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AuthorizationPolicy_Provider) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Provider != nil {
		{
			size, err := m.Provider.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAuthorizationPolicy(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	return len(dAtA) - i, nil
}
func (m *AuthorizationPolicy_ExtensionProvider) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AuthorizationPolicy_ExtensionProvider) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AuthorizationPolicy_ExtensionProvider) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintAuthorizationPolicy(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Rule) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Rule) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Rule) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.When) > 0 {
		for iNdEx := len(m.When) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.When[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAuthorizationPolicy(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.To) > 0 {
		for iNdEx := len(m.To) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.To[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAuthorizationPolicy(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.From) > 0 {
		for iNdEx := len(m.From) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.From[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAuthorizationPolicy(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *Rule_From) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Rule_From) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Rule_From) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Source != nil {
		{
			size, err := m.Source.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAuthorizationPolicy(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Rule_To) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Rule_To) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Rule_To) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Operation != nil {
		{
			size, err := m.Operation.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAuthorizationPolicy(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Source) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Source) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Source) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.NotRemoteIpBlocks) > 0 {
		for iNdEx := len(m.NotRemoteIpBlocks) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.NotRemoteIpBlocks[iNdEx])
			copy(dAtA[i:], m.NotRemoteIpBlocks[iNdEx])
			i = encodeVarintAuthorizationPolicy(dAtA, i, uint64(len(m.NotRemoteIpBlocks[iNdEx])))
			i--
			dAtA[i] = 0x52
		}
	}
	if len(m.RemoteIpBlocks) > 0 {
		for iNdEx := len(m.RemoteIpBlocks) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.RemoteIpBlocks[iNdEx])
			copy(dAtA[i:], m.RemoteIpBlocks[iNdEx])
			i = encodeVarintAuthorizationPolicy(dAtA, i, uint64(len(m.RemoteIpBlocks[iNdEx])))
			i--
			dAtA[i] = 0x4a
		}
	}
	if len(m.NotIpBlocks) > 0 {
		for iNdEx := len(m.NotIpBlocks) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.NotIpBlocks[iNdEx])
			copy(dAtA[i:], m.NotIpBlocks[iNdEx])
			i = encodeVarintAuthorizationPolicy(dAtA, i, uint64(len(m.NotIpBlocks[iNdEx])))
			i--
			dAtA[i] = 0x42
		}
	}
	if len(m.NotNamespaces) > 0 {
		for iNdEx := len(m.NotNamespaces) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.NotNamespaces[iNdEx])
			copy(dAtA[i:], m.NotNamespaces[iNdEx])
			i = encodeVarintAuthorizationPolicy(dAtA, i, uint64(len(m.NotNamespaces[iNdEx])))
			i--
			dAtA[i] = 0x3a
		}
	}
	if len(m.NotRequestPrincipals) > 0 {
		for iNdEx := len(m.NotRequestPrincipals) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.NotRequestPrincipals[iNdEx])
			copy(dAtA[i:], m.NotRequestPrincipals[iNdEx])
			i = encodeVarintAuthorizationPolicy(dAtA, i, uint64(len(m.NotRequestPrincipals[iNdEx])))
			i--
			dAtA[i] = 0x32
		}
	}
	if len(m.NotPrincipals) > 0 {
		for iNdEx := len(m.NotPrincipals) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.NotPrincipals[iNdEx])
			copy(dAtA[i:], m.NotPrincipals[iNdEx])
			i = encodeVarintAuthorizationPolicy(dAtA, i, uint64(len(m.NotPrincipals[iNdEx])))
			i--
			dAtA[i] = 0x2a
		}
	}
	if len(m.IpBlocks) > 0 {
		for iNdEx := len(m.IpBlocks) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.IpBlocks[iNdEx])
			copy(dAtA[i:], m.IpBlocks[iNdEx])
			i = encodeVarintAuthorizationPolicy(dAtA, i, uint64(len(m.IpBlocks[iNdEx])))
			i--
			dAtA[i] = 0x22
		}
	}
	if len(m.Namespaces) > 0 {
		for iNdEx := len(m.Namespaces) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Namespaces[iNdEx])
			copy(dAtA[i:], m.Namespaces[iNdEx])
			i = encodeVarintAuthorizationPolicy(dAtA, i, uint64(len(m.Namespaces[iNdEx])))
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.RequestPrincipals) > 0 {
		for iNdEx := len(m.RequestPrincipals) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.RequestPrincipals[iNdEx])
			copy(dAtA[i:], m.RequestPrincipals[iNdEx])
			i = encodeVarintAuthorizationPolicy(dAtA, i, uint64(len(m.RequestPrincipals[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Principals) > 0 {
		for iNdEx := len(m.Principals) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Principals[iNdEx])
			copy(dAtA[i:], m.Principals[iNdEx])
			i = encodeVarintAuthorizationPolicy(dAtA, i, uint64(len(m.Principals[iNdEx])))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *Operation) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Operation) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Operation) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.NotPaths) > 0 {
		for iNdEx := len(m.NotPaths) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.NotPaths[iNdEx])
			copy(dAtA[i:], m.NotPaths[iNdEx])
			i = encodeVarintAuthorizationPolicy(dAtA, i, uint64(len(m.NotPaths[iNdEx])))
			i--
			dAtA[i] = 0x42
		}
	}
	if len(m.NotMethods) > 0 {
		for iNdEx := len(m.NotMethods) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.NotMethods[iNdEx])
			copy(dAtA[i:], m.NotMethods[iNdEx])
			i = encodeVarintAuthorizationPolicy(dAtA, i, uint64(len(m.NotMethods[iNdEx])))
			i--
			dAtA[i] = 0x3a
		}
	}
	if len(m.NotPorts) > 0 {
		for iNdEx := len(m.NotPorts) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.NotPorts[iNdEx])
			copy(dAtA[i:], m.NotPorts[iNdEx])
			i = encodeVarintAuthorizationPolicy(dAtA, i, uint64(len(m.NotPorts[iNdEx])))
			i--
			dAtA[i] = 0x32
		}
	}
	if len(m.NotHosts) > 0 {
		for iNdEx := len(m.NotHosts) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.NotHosts[iNdEx])
			copy(dAtA[i:], m.NotHosts[iNdEx])
			i = encodeVarintAuthorizationPolicy(dAtA, i, uint64(len(m.NotHosts[iNdEx])))
			i--
			dAtA[i] = 0x2a
		}
	}
	if len(m.Paths) > 0 {
		for iNdEx := len(m.Paths) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Paths[iNdEx])
			copy(dAtA[i:], m.Paths[iNdEx])
			i = encodeVarintAuthorizationPolicy(dAtA, i, uint64(len(m.Paths[iNdEx])))
			i--
			dAtA[i] = 0x22
		}
	}
	if len(m.Methods) > 0 {
		for iNdEx := len(m.Methods) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Methods[iNdEx])
			copy(dAtA[i:], m.Methods[iNdEx])
			i = encodeVarintAuthorizationPolicy(dAtA, i, uint64(len(m.Methods[iNdEx])))
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.Ports) > 0 {
		for iNdEx := len(m.Ports) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Ports[iNdEx])
			copy(dAtA[i:], m.Ports[iNdEx])
			i = encodeVarintAuthorizationPolicy(dAtA, i, uint64(len(m.Ports[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Hosts) > 0 {
		for iNdEx := len(m.Hosts) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Hosts[iNdEx])
			copy(dAtA[i:], m.Hosts[iNdEx])
			i = encodeVarintAuthorizationPolicy(dAtA, i, uint64(len(m.Hosts[iNdEx])))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *Condition) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Condition) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Condition) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.NotValues) > 0 {
		for iNdEx := len(m.NotValues) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.NotValues[iNdEx])
			copy(dAtA[i:], m.NotValues[iNdEx])
			i = encodeVarintAuthorizationPolicy(dAtA, i, uint64(len(m.NotValues[iNdEx])))
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.Values) > 0 {
		for iNdEx := len(m.Values) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Values[iNdEx])
			copy(dAtA[i:], m.Values[iNdEx])
			i = encodeVarintAuthorizationPolicy(dAtA, i, uint64(len(m.Values[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Key) > 0 {
		i -= len(m.Key)
		copy(dAtA[i:], m.Key)
		i = encodeVarintAuthorizationPolicy(dAtA, i, uint64(len(m.Key)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintAuthorizationPolicy(dAtA []byte, offset int, v uint64) int {
	offset -= sovAuthorizationPolicy(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *AuthorizationPolicy) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Selector != nil {
		l = m.Selector.Size()
		n += 1 + l + sovAuthorizationPolicy(uint64(l))
	}
	if len(m.Rules) > 0 {
		for _, e := range m.Rules {
			l = e.Size()
			n += 1 + l + sovAuthorizationPolicy(uint64(l))
		}
	}
	if m.Action != 0 {
		n += 1 + sovAuthorizationPolicy(uint64(m.Action))
	}
	if m.ActionDetail != nil {
		n += m.ActionDetail.Size()
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AuthorizationPolicy_Provider) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Provider != nil {
		l = m.Provider.Size()
		n += 1 + l + sovAuthorizationPolicy(uint64(l))
	}
	return n
}
func (m *AuthorizationPolicy_ExtensionProvider) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovAuthorizationPolicy(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Rule) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.From) > 0 {
		for _, e := range m.From {
			l = e.Size()
			n += 1 + l + sovAuthorizationPolicy(uint64(l))
		}
	}
	if len(m.To) > 0 {
		for _, e := range m.To {
			l = e.Size()
			n += 1 + l + sovAuthorizationPolicy(uint64(l))
		}
	}
	if len(m.When) > 0 {
		for _, e := range m.When {
			l = e.Size()
			n += 1 + l + sovAuthorizationPolicy(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Rule_From) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Source != nil {
		l = m.Source.Size()
		n += 1 + l + sovAuthorizationPolicy(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Rule_To) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Operation != nil {
		l = m.Operation.Size()
		n += 1 + l + sovAuthorizationPolicy(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Source) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Principals) > 0 {
		for _, s := range m.Principals {
			l = len(s)
			n += 1 + l + sovAuthorizationPolicy(uint64(l))
		}
	}
	if len(m.RequestPrincipals) > 0 {
		for _, s := range m.RequestPrincipals {
			l = len(s)
			n += 1 + l + sovAuthorizationPolicy(uint64(l))
		}
	}
	if len(m.Namespaces) > 0 {
		for _, s := range m.Namespaces {
			l = len(s)
			n += 1 + l + sovAuthorizationPolicy(uint64(l))
		}
	}
	if len(m.IpBlocks) > 0 {
		for _, s := range m.IpBlocks {
			l = len(s)
			n += 1 + l + sovAuthorizationPolicy(uint64(l))
		}
	}
	if len(m.NotPrincipals) > 0 {
		for _, s := range m.NotPrincipals {
			l = len(s)
			n += 1 + l + sovAuthorizationPolicy(uint64(l))
		}
	}
	if len(m.NotRequestPrincipals) > 0 {
		for _, s := range m.NotRequestPrincipals {
			l = len(s)
			n += 1 + l + sovAuthorizationPolicy(uint64(l))
		}
	}
	if len(m.NotNamespaces) > 0 {
		for _, s := range m.NotNamespaces {
			l = len(s)
			n += 1 + l + sovAuthorizationPolicy(uint64(l))
		}
	}
	if len(m.NotIpBlocks) > 0 {
		for _, s := range m.NotIpBlocks {
			l = len(s)
			n += 1 + l + sovAuthorizationPolicy(uint64(l))
		}
	}
	if len(m.RemoteIpBlocks) > 0 {
		for _, s := range m.RemoteIpBlocks {
			l = len(s)
			n += 1 + l + sovAuthorizationPolicy(uint64(l))
		}
	}
	if len(m.NotRemoteIpBlocks) > 0 {
		for _, s := range m.NotRemoteIpBlocks {
			l = len(s)
			n += 1 + l + sovAuthorizationPolicy(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Operation) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Hosts) > 0 {
		for _, s := range m.Hosts {
			l = len(s)
			n += 1 + l + sovAuthorizationPolicy(uint64(l))
		}
	}
	if len(m.Ports) > 0 {
		for _, s := range m.Ports {
			l = len(s)
			n += 1 + l + sovAuthorizationPolicy(uint64(l))
		}
	}
	if len(m.Methods) > 0 {
		for _, s := range m.Methods {
			l = len(s)
			n += 1 + l + sovAuthorizationPolicy(uint64(l))
		}
	}
	if len(m.Paths) > 0 {
		for _, s := range m.Paths {
			l = len(s)
			n += 1 + l + sovAuthorizationPolicy(uint64(l))
		}
	}
	if len(m.NotHosts) > 0 {
		for _, s := range m.NotHosts {
			l = len(s)
			n += 1 + l + sovAuthorizationPolicy(uint64(l))
		}
	}
	if len(m.NotPorts) > 0 {
		for _, s := range m.NotPorts {
			l = len(s)
			n += 1 + l + sovAuthorizationPolicy(uint64(l))
		}
	}
	if len(m.NotMethods) > 0 {
		for _, s := range m.NotMethods {
			l = len(s)
			n += 1 + l + sovAuthorizationPolicy(uint64(l))
		}
	}
	if len(m.NotPaths) > 0 {
		for _, s := range m.NotPaths {
			l = len(s)
			n += 1 + l + sovAuthorizationPolicy(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Condition) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Key)
	if l > 0 {
		n += 1 + l + sovAuthorizationPolicy(uint64(l))
	}
	if len(m.Values) > 0 {
		for _, s := range m.Values {
			l = len(s)
			n += 1 + l + sovAuthorizationPolicy(uint64(l))
		}
	}
	if len(m.NotValues) > 0 {
		for _, s := range m.NotValues {
			l = len(s)
			n += 1 + l + sovAuthorizationPolicy(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovAuthorizationPolicy(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozAuthorizationPolicy(x uint64) (n int) {
	return sovAuthorizationPolicy(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *AuthorizationPolicy) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAuthorizationPolicy
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AuthorizationPolicy: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AuthorizationPolicy: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Selector", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAuthorizationPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAuthorizationPolicy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAuthorizationPolicy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Selector == nil {
				m.Selector = &v1beta1.WorkloadSelector{}
			}
			if err := m.Selector.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Rules", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAuthorizationPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAuthorizationPolicy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAuthorizationPolicy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Rules = append(m.Rules, &Rule{})
			if err := m.Rules[len(m.Rules)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Action", wireType)
			}
			m.Action = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAuthorizationPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Action |= AuthorizationPolicy_Action(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Provider", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAuthorizationPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAuthorizationPolicy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAuthorizationPolicy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &AuthorizationPolicy_ExtensionProvider{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.ActionDetail = &AuthorizationPolicy_Provider{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAuthorizationPolicy(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAuthorizationPolicy
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AuthorizationPolicy_ExtensionProvider) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAuthorizationPolicy
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ExtensionProvider: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ExtensionProvider: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAuthorizationPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAuthorizationPolicy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAuthorizationPolicy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAuthorizationPolicy(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAuthorizationPolicy
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Rule) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAuthorizationPolicy
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Rule: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Rule: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field From", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAuthorizationPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAuthorizationPolicy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAuthorizationPolicy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.From = append(m.From, &Rule_From{})
			if err := m.From[len(m.From)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field To", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAuthorizationPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAuthorizationPolicy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAuthorizationPolicy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.To = append(m.To, &Rule_To{})
			if err := m.To[len(m.To)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field When", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAuthorizationPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAuthorizationPolicy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAuthorizationPolicy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.When = append(m.When, &Condition{})
			if err := m.When[len(m.When)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAuthorizationPolicy(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAuthorizationPolicy
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Rule_From) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAuthorizationPolicy
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: From: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: From: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Source", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAuthorizationPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAuthorizationPolicy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAuthorizationPolicy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Source == nil {
				m.Source = &Source{}
			}
			if err := m.Source.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAuthorizationPolicy(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAuthorizationPolicy
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Rule_To) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAuthorizationPolicy
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: To: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: To: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Operation", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAuthorizationPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAuthorizationPolicy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAuthorizationPolicy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Operation == nil {
				m.Operation = &Operation{}
			}
			if err := m.Operation.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAuthorizationPolicy(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAuthorizationPolicy
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Source) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAuthorizationPolicy
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Source: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Source: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Principals", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAuthorizationPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAuthorizationPolicy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAuthorizationPolicy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Principals = append(m.Principals, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestPrincipals", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAuthorizationPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAuthorizationPolicy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAuthorizationPolicy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RequestPrincipals = append(m.RequestPrincipals, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Namespaces", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAuthorizationPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAuthorizationPolicy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAuthorizationPolicy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Namespaces = append(m.Namespaces, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IpBlocks", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAuthorizationPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAuthorizationPolicy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAuthorizationPolicy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.IpBlocks = append(m.IpBlocks, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NotPrincipals", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAuthorizationPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAuthorizationPolicy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAuthorizationPolicy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NotPrincipals = append(m.NotPrincipals, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NotRequestPrincipals", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAuthorizationPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAuthorizationPolicy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAuthorizationPolicy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NotRequestPrincipals = append(m.NotRequestPrincipals, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NotNamespaces", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAuthorizationPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAuthorizationPolicy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAuthorizationPolicy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NotNamespaces = append(m.NotNamespaces, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NotIpBlocks", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAuthorizationPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAuthorizationPolicy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAuthorizationPolicy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NotIpBlocks = append(m.NotIpBlocks, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RemoteIpBlocks", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAuthorizationPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAuthorizationPolicy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAuthorizationPolicy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RemoteIpBlocks = append(m.RemoteIpBlocks, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NotRemoteIpBlocks", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAuthorizationPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAuthorizationPolicy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAuthorizationPolicy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NotRemoteIpBlocks = append(m.NotRemoteIpBlocks, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAuthorizationPolicy(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAuthorizationPolicy
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Operation) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAuthorizationPolicy
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Operation: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Operation: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Hosts", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAuthorizationPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAuthorizationPolicy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAuthorizationPolicy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Hosts = append(m.Hosts, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ports", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAuthorizationPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAuthorizationPolicy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAuthorizationPolicy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Ports = append(m.Ports, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Methods", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAuthorizationPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAuthorizationPolicy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAuthorizationPolicy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Methods = append(m.Methods, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Paths", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAuthorizationPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAuthorizationPolicy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAuthorizationPolicy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Paths = append(m.Paths, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NotHosts", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAuthorizationPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAuthorizationPolicy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAuthorizationPolicy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NotHosts = append(m.NotHosts, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NotPorts", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAuthorizationPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAuthorizationPolicy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAuthorizationPolicy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NotPorts = append(m.NotPorts, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NotMethods", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAuthorizationPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAuthorizationPolicy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAuthorizationPolicy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NotMethods = append(m.NotMethods, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NotPaths", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAuthorizationPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAuthorizationPolicy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAuthorizationPolicy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NotPaths = append(m.NotPaths, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAuthorizationPolicy(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAuthorizationPolicy
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Condition) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAuthorizationPolicy
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Condition: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Condition: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAuthorizationPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAuthorizationPolicy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAuthorizationPolicy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Values", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAuthorizationPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAuthorizationPolicy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAuthorizationPolicy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Values = append(m.Values, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NotValues", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAuthorizationPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAuthorizationPolicy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAuthorizationPolicy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NotValues = append(m.NotValues, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAuthorizationPolicy(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAuthorizationPolicy
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipAuthorizationPolicy(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowAuthorizationPolicy
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowAuthorizationPolicy
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowAuthorizationPolicy
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthAuthorizationPolicy
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupAuthorizationPolicy
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthAuthorizationPolicy
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthAuthorizationPolicy        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowAuthorizationPolicy          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupAuthorizationPolicy = fmt.Errorf("proto: unexpected end of group")
)
