// Copyright Istio Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by informer-gen. DO NOT EDIT.

package v1alpha1

import (
	"context"
	time "time"

	telemetryv1alpha1 "istio.io/client-go/pkg/apis/telemetry/v1alpha1"
	versioned "istio.io/client-go/pkg/clientset/versioned"
	internalinterfaces "istio.io/client-go/pkg/informers/externalversions/internalinterfaces"
	v1alpha1 "istio.io/client-go/pkg/listers/telemetry/v1alpha1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	runtime "k8s.io/apimachinery/pkg/runtime"
	watch "k8s.io/apimachinery/pkg/watch"
	cache "k8s.io/client-go/tools/cache"
)

// TelemetryInformer provides access to a shared informer and lister for
// Telemetries.
type TelemetryInformer interface {
	Informer() cache.SharedIndexInformer
	Lister() v1alpha1.TelemetryLister
}

type telemetryInformer struct {
	factory          internalinterfaces.SharedInformerFactory
	tweakListOptions internalinterfaces.TweakListOptionsFunc
	namespace        string
}

// NewTelemetryInformer constructs a new informer for Telemetry type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewTelemetryInformer(client versioned.Interface, namespace string, resyncPeriod time.Duration, indexers cache.Indexers) cache.SharedIndexInformer {
	return NewFilteredTelemetryInformer(client, namespace, resyncPeriod, indexers, nil)
}

// NewFilteredTelemetryInformer constructs a new informer for Telemetry type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewFilteredTelemetryInformer(client versioned.Interface, namespace string, resyncPeriod time.Duration, indexers cache.Indexers, tweakListOptions internalinterfaces.TweakListOptionsFunc) cache.SharedIndexInformer {
	return cache.NewSharedIndexInformer(
		&cache.ListWatch{
			ListFunc: func(options v1.ListOptions) (runtime.Object, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.TelemetryV1alpha1().Telemetries(namespace).List(context.TODO(), options)
			},
			WatchFunc: func(options v1.ListOptions) (watch.Interface, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.TelemetryV1alpha1().Telemetries(namespace).Watch(context.TODO(), options)
			},
		},
		&telemetryv1alpha1.Telemetry{},
		resyncPeriod,
		indexers,
	)
}

func (f *telemetryInformer) defaultInformer(client versioned.Interface, resyncPeriod time.Duration) cache.SharedIndexInformer {
	return NewFilteredTelemetryInformer(client, f.namespace, resyncPeriod, cache.Indexers{cache.NamespaceIndex: cache.MetaNamespaceIndexFunc}, f.tweakListOptions)
}

func (f *telemetryInformer) Informer() cache.SharedIndexInformer {
	return f.factory.InformerFor(&telemetryv1alpha1.Telemetry{}, f.defaultInformer)
}

func (f *telemetryInformer) Lister() v1alpha1.TelemetryLister {
	return v1alpha1.NewTelemetryLister(f.Informer().GetIndexer())
}
