// Copyright Istio Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by lister-gen. DO NOT EDIT.

package v1alpha3

import (
	v1alpha3 "istio.io/client-go/pkg/apis/networking/v1alpha3"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// EnvoyFilterLister helps list EnvoyFilters.
type EnvoyFilterLister interface {
	// List lists all EnvoyFilters in the indexer.
	List(selector labels.Selector) (ret []*v1alpha3.EnvoyFilter, err error)
	// EnvoyFilters returns an object that can list and get EnvoyFilters.
	EnvoyFilters(namespace string) EnvoyFilterNamespaceLister
	EnvoyFilterListerExpansion
}

// envoyFilterLister implements the EnvoyFilterLister interface.
type envoyFilterLister struct {
	indexer cache.Indexer
}

// NewEnvoyFilterLister returns a new EnvoyFilterLister.
func NewEnvoyFilterLister(indexer cache.Indexer) EnvoyFilterLister {
	return &envoyFilterLister{indexer: indexer}
}

// List lists all EnvoyFilters in the indexer.
func (s *envoyFilterLister) List(selector labels.Selector) (ret []*v1alpha3.EnvoyFilter, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha3.EnvoyFilter))
	})
	return ret, err
}

// EnvoyFilters returns an object that can list and get EnvoyFilters.
func (s *envoyFilterLister) EnvoyFilters(namespace string) EnvoyFilterNamespaceLister {
	return envoyFilterNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// EnvoyFilterNamespaceLister helps list and get EnvoyFilters.
type EnvoyFilterNamespaceLister interface {
	// List lists all EnvoyFilters in the indexer for a given namespace.
	List(selector labels.Selector) (ret []*v1alpha3.EnvoyFilter, err error)
	// Get retrieves the EnvoyFilter from the indexer for a given namespace and name.
	Get(name string) (*v1alpha3.EnvoyFilter, error)
	EnvoyFilterNamespaceListerExpansion
}

// envoyFilterNamespaceLister implements the EnvoyFilterNamespaceLister
// interface.
type envoyFilterNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all EnvoyFilters in the indexer for a given namespace.
func (s envoyFilterNamespaceLister) List(selector labels.Selector) (ret []*v1alpha3.EnvoyFilter, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha3.EnvoyFilter))
	})
	return ret, err
}

// Get retrieves the EnvoyFilter from the indexer for a given namespace and name.
func (s envoyFilterNamespaceLister) Get(name string) (*v1alpha3.EnvoyFilter, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1alpha3.Resource("envoyfilter"), name)
	}
	return obj.(*v1alpha3.EnvoyFilter), nil
}
