// Copyright Istio Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by lister-gen. DO NOT EDIT.

package v1alpha3

import (
	v1alpha3 "istio.io/client-go/pkg/apis/networking/v1alpha3"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// WorkloadGroupLister helps list WorkloadGroups.
type WorkloadGroupLister interface {
	// List lists all WorkloadGroups in the indexer.
	List(selector labels.Selector) (ret []*v1alpha3.WorkloadGroup, err error)
	// WorkloadGroups returns an object that can list and get WorkloadGroups.
	WorkloadGroups(namespace string) WorkloadGroupNamespaceLister
	WorkloadGroupListerExpansion
}

// workloadGroupLister implements the WorkloadGroupLister interface.
type workloadGroupLister struct {
	indexer cache.Indexer
}

// NewWorkloadGroupLister returns a new WorkloadGroupLister.
func NewWorkloadGroupLister(indexer cache.Indexer) WorkloadGroupLister {
	return &workloadGroupLister{indexer: indexer}
}

// List lists all WorkloadGroups in the indexer.
func (s *workloadGroupLister) List(selector labels.Selector) (ret []*v1alpha3.WorkloadGroup, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha3.WorkloadGroup))
	})
	return ret, err
}

// WorkloadGroups returns an object that can list and get WorkloadGroups.
func (s *workloadGroupLister) WorkloadGroups(namespace string) WorkloadGroupNamespaceLister {
	return workloadGroupNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// WorkloadGroupNamespaceLister helps list and get WorkloadGroups.
type WorkloadGroupNamespaceLister interface {
	// List lists all WorkloadGroups in the indexer for a given namespace.
	List(selector labels.Selector) (ret []*v1alpha3.WorkloadGroup, err error)
	// Get retrieves the WorkloadGroup from the indexer for a given namespace and name.
	Get(name string) (*v1alpha3.WorkloadGroup, error)
	WorkloadGroupNamespaceListerExpansion
}

// workloadGroupNamespaceLister implements the WorkloadGroupNamespaceLister
// interface.
type workloadGroupNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all WorkloadGroups in the indexer for a given namespace.
func (s workloadGroupNamespaceLister) List(selector labels.Selector) (ret []*v1alpha3.WorkloadGroup, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha3.WorkloadGroup))
	})
	return ret, err
}

// Get retrieves the WorkloadGroup from the indexer for a given namespace and name.
func (s workloadGroupNamespaceLister) Get(name string) (*v1alpha3.WorkloadGroup, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1alpha3.Resource("workloadgroup"), name)
	}
	return obj.(*v1alpha3.WorkloadGroup), nil
}
