// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: istio.io/extensions/field_rules.proto

package istio_extensions

import (
	encoding_binary "encoding/binary"
	fmt "fmt"
	proto "github.com/gogo/protobuf/proto"
	descriptor "github.com/gogo/protobuf/protoc-gen-gogo/descriptor"
	io "io"
	math "math"
	math_bits "math/bits"
	reflect "reflect"
	strings "strings"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

// Field rules for a particular type.
// Currently only primitive types of OpenAPI schemas are included. (https://swagger.io/docs/specification/data-models/data-types)
type FieldRules struct {
	// Types that are valid to be assigned to Type:
	//	*FieldRules_Float
	//	*FieldRules_Double
	//	*FieldRules_String_
	//	*FieldRules_Bool
	//	*FieldRules_Int32
	//	*FieldRules_Int64
	Type isFieldRules_Type `protobuf_oneof:"type"`
}

func (m *FieldRules) Reset()      { *m = FieldRules{} }
func (*FieldRules) ProtoMessage() {}
func (*FieldRules) Descriptor() ([]byte, []int) {
	return fileDescriptor_391d0dd54580dba2, []int{0}
}
func (m *FieldRules) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *FieldRules) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_FieldRules.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *FieldRules) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FieldRules.Merge(m, src)
}
func (m *FieldRules) XXX_Size() int {
	return m.Size()
}
func (m *FieldRules) XXX_DiscardUnknown() {
	xxx_messageInfo_FieldRules.DiscardUnknown(m)
}

var xxx_messageInfo_FieldRules proto.InternalMessageInfo

type isFieldRules_Type interface {
	isFieldRules_Type()
	Equal(interface{}) bool
	MarshalTo([]byte) (int, error)
	Size() int
}

type FieldRules_Float struct {
	Float *FloatRules `protobuf:"bytes,1,opt,name=float,proto3,oneof"`
}
type FieldRules_Double struct {
	Double *DoubleRules `protobuf:"bytes,2,opt,name=double,proto3,oneof"`
}
type FieldRules_String_ struct {
	String_ *StringRules `protobuf:"bytes,3,opt,name=string,proto3,oneof"`
}
type FieldRules_Bool struct {
	Bool *BoolRules `protobuf:"bytes,4,opt,name=bool,proto3,oneof"`
}
type FieldRules_Int32 struct {
	Int32 *Int32Rules `protobuf:"bytes,5,opt,name=int32,proto3,oneof"`
}
type FieldRules_Int64 struct {
	Int64 *Int64Rules `protobuf:"bytes,6,opt,name=int64,proto3,oneof"`
}

func (*FieldRules_Float) isFieldRules_Type()   {}
func (*FieldRules_Double) isFieldRules_Type()  {}
func (*FieldRules_String_) isFieldRules_Type() {}
func (*FieldRules_Bool) isFieldRules_Type()    {}
func (*FieldRules_Int32) isFieldRules_Type()   {}
func (*FieldRules_Int64) isFieldRules_Type()   {}

func (m *FieldRules) GetType() isFieldRules_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (m *FieldRules) GetFloat() *FloatRules {
	if x, ok := m.GetType().(*FieldRules_Float); ok {
		return x.Float
	}
	return nil
}

func (m *FieldRules) GetDouble() *DoubleRules {
	if x, ok := m.GetType().(*FieldRules_Double); ok {
		return x.Double
	}
	return nil
}

func (m *FieldRules) GetString_() *StringRules {
	if x, ok := m.GetType().(*FieldRules_String_); ok {
		return x.String_
	}
	return nil
}

func (m *FieldRules) GetBool() *BoolRules {
	if x, ok := m.GetType().(*FieldRules_Bool); ok {
		return x.Bool
	}
	return nil
}

func (m *FieldRules) GetInt32() *Int32Rules {
	if x, ok := m.GetType().(*FieldRules_Int32); ok {
		return x.Int32
	}
	return nil
}

func (m *FieldRules) GetInt64() *Int64Rules {
	if x, ok := m.GetType().(*FieldRules_Int64); ok {
		return x.Int64
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*FieldRules) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*FieldRules_Float)(nil),
		(*FieldRules_Double)(nil),
		(*FieldRules_String_)(nil),
		(*FieldRules_Bool)(nil),
		(*FieldRules_Int32)(nil),
		(*FieldRules_Int64)(nil),
	}
}

// FloatRules describe the rules for the float type.
type FloatRules struct {
	Default float32 `protobuf:"fixed32,1,opt,name=default,proto3" json:"default,omitempty"`
}

func (m *FloatRules) Reset()      { *m = FloatRules{} }
func (*FloatRules) ProtoMessage() {}
func (*FloatRules) Descriptor() ([]byte, []int) {
	return fileDescriptor_391d0dd54580dba2, []int{1}
}
func (m *FloatRules) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *FloatRules) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_FloatRules.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *FloatRules) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FloatRules.Merge(m, src)
}
func (m *FloatRules) XXX_Size() int {
	return m.Size()
}
func (m *FloatRules) XXX_DiscardUnknown() {
	xxx_messageInfo_FloatRules.DiscardUnknown(m)
}

var xxx_messageInfo_FloatRules proto.InternalMessageInfo

func (m *FloatRules) GetDefault() float32 {
	if m != nil {
		return m.Default
	}
	return 0
}

// DoubleRules describe the rules for the double type.
type DoubleRules struct {
	Default float64 `protobuf:"fixed64,1,opt,name=default,proto3" json:"default,omitempty"`
}

func (m *DoubleRules) Reset()      { *m = DoubleRules{} }
func (*DoubleRules) ProtoMessage() {}
func (*DoubleRules) Descriptor() ([]byte, []int) {
	return fileDescriptor_391d0dd54580dba2, []int{2}
}
func (m *DoubleRules) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DoubleRules) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DoubleRules.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DoubleRules) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DoubleRules.Merge(m, src)
}
func (m *DoubleRules) XXX_Size() int {
	return m.Size()
}
func (m *DoubleRules) XXX_DiscardUnknown() {
	xxx_messageInfo_DoubleRules.DiscardUnknown(m)
}

var xxx_messageInfo_DoubleRules proto.InternalMessageInfo

func (m *DoubleRules) GetDefault() float64 {
	if m != nil {
		return m.Default
	}
	return 0
}

// StringRules describe the rules for the string type.
type StringRules struct {
	Default string `protobuf:"bytes,1,opt,name=default,proto3" json:"default,omitempty"`
	// The regular expression the field must match against (RE2 syntax).
	Pattern string `protobuf:"bytes,2,opt,name=pattern,proto3" json:"pattern,omitempty"`
}

func (m *StringRules) Reset()      { *m = StringRules{} }
func (*StringRules) ProtoMessage() {}
func (*StringRules) Descriptor() ([]byte, []int) {
	return fileDescriptor_391d0dd54580dba2, []int{3}
}
func (m *StringRules) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *StringRules) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_StringRules.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *StringRules) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StringRules.Merge(m, src)
}
func (m *StringRules) XXX_Size() int {
	return m.Size()
}
func (m *StringRules) XXX_DiscardUnknown() {
	xxx_messageInfo_StringRules.DiscardUnknown(m)
}

var xxx_messageInfo_StringRules proto.InternalMessageInfo

func (m *StringRules) GetDefault() string {
	if m != nil {
		return m.Default
	}
	return ""
}

func (m *StringRules) GetPattern() string {
	if m != nil {
		return m.Pattern
	}
	return ""
}

// BoolRules describe the rules for the bool type.
type BoolRules struct {
	Default bool `protobuf:"varint,1,opt,name=default,proto3" json:"default,omitempty"`
}

func (m *BoolRules) Reset()      { *m = BoolRules{} }
func (*BoolRules) ProtoMessage() {}
func (*BoolRules) Descriptor() ([]byte, []int) {
	return fileDescriptor_391d0dd54580dba2, []int{4}
}
func (m *BoolRules) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *BoolRules) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_BoolRules.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *BoolRules) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BoolRules.Merge(m, src)
}
func (m *BoolRules) XXX_Size() int {
	return m.Size()
}
func (m *BoolRules) XXX_DiscardUnknown() {
	xxx_messageInfo_BoolRules.DiscardUnknown(m)
}

var xxx_messageInfo_BoolRules proto.InternalMessageInfo

func (m *BoolRules) GetDefault() bool {
	if m != nil {
		return m.Default
	}
	return false
}

// Int32Rules describe the rules for the int32 type.
type Int32Rules struct {
	Default int32 `protobuf:"varint,1,opt,name=default,proto3" json:"default,omitempty"`
}

func (m *Int32Rules) Reset()      { *m = Int32Rules{} }
func (*Int32Rules) ProtoMessage() {}
func (*Int32Rules) Descriptor() ([]byte, []int) {
	return fileDescriptor_391d0dd54580dba2, []int{5}
}
func (m *Int32Rules) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Int32Rules) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Int32Rules.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Int32Rules) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Int32Rules.Merge(m, src)
}
func (m *Int32Rules) XXX_Size() int {
	return m.Size()
}
func (m *Int32Rules) XXX_DiscardUnknown() {
	xxx_messageInfo_Int32Rules.DiscardUnknown(m)
}

var xxx_messageInfo_Int32Rules proto.InternalMessageInfo

func (m *Int32Rules) GetDefault() int32 {
	if m != nil {
		return m.Default
	}
	return 0
}

// Int64Rules describe the rules for the int64 type.
type Int64Rules struct {
	Default int64 `protobuf:"varint,1,opt,name=default,proto3" json:"default,omitempty"`
}

func (m *Int64Rules) Reset()      { *m = Int64Rules{} }
func (*Int64Rules) ProtoMessage() {}
func (*Int64Rules) Descriptor() ([]byte, []int) {
	return fileDescriptor_391d0dd54580dba2, []int{6}
}
func (m *Int64Rules) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Int64Rules) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Int64Rules.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Int64Rules) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Int64Rules.Merge(m, src)
}
func (m *Int64Rules) XXX_Size() int {
	return m.Size()
}
func (m *Int64Rules) XXX_DiscardUnknown() {
	xxx_messageInfo_Int64Rules.DiscardUnknown(m)
}

var xxx_messageInfo_Int64Rules proto.InternalMessageInfo

func (m *Int64Rules) GetDefault() int64 {
	if m != nil {
		return m.Default
	}
	return 0
}

var E_Rules = &proto.ExtensionDesc{
	ExtendedType:  (*descriptor.FieldOptions)(nil),
	ExtensionType: (*FieldRules)(nil),
	Field:         1200,
	Name:          "istio.extensions.rules",
	Tag:           "bytes,1200,opt,name=rules",
	Filename:      "istio.io/extensions/field_rules.proto",
}

func init() {
	proto.RegisterType((*FieldRules)(nil), "istio.extensions.FieldRules")
	proto.RegisterType((*FloatRules)(nil), "istio.extensions.FloatRules")
	proto.RegisterType((*DoubleRules)(nil), "istio.extensions.DoubleRules")
	proto.RegisterType((*StringRules)(nil), "istio.extensions.StringRules")
	proto.RegisterType((*BoolRules)(nil), "istio.extensions.BoolRules")
	proto.RegisterType((*Int32Rules)(nil), "istio.extensions.Int32Rules")
	proto.RegisterType((*Int64Rules)(nil), "istio.extensions.Int64Rules")
	proto.RegisterExtension(E_Rules)
}

func init() {
	proto.RegisterFile("istio.io/extensions/field_rules.proto", fileDescriptor_391d0dd54580dba2)
}

var fileDescriptor_391d0dd54580dba2 = []byte{
	// 413 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x7c, 0x92, 0x41, 0xea, 0xd3, 0x40,
	0x14, 0xc6, 0x33, 0x6d, 0x13, 0xcd, 0xeb, 0x46, 0xb2, 0x1a, 0xd4, 0x0e, 0x25, 0xd0, 0xea, 0x2a,
	0xc1, 0x36, 0x54, 0x70, 0x67, 0x91, 0xa2, 0x2b, 0x21, 0x1e, 0x40, 0x1a, 0x33, 0x29, 0x03, 0x43,
	0x26, 0x24, 0x13, 0xd0, 0x9d, 0x47, 0xf0, 0x18, 0x2e, 0x3d, 0x86, 0xcb, 0x2e, 0x0b, 0x6e, 0x6c,
	0xba, 0x71, 0xd9, 0x23, 0xc8, 0x4c, 0x9a, 0xa4, 0xa4, 0xf4, 0xbf, 0x0c, 0xef, 0xf7, 0x7b, 0xc3,
	0xfb, 0xf2, 0xc1, 0x8c, 0x15, 0x92, 0x09, 0x8f, 0x09, 0x9f, 0x7e, 0x95, 0x34, 0x2d, 0x98, 0x48,
	0x0b, 0x3f, 0x61, 0x94, 0xc7, 0x9f, 0xf3, 0x92, 0xd3, 0xc2, 0xcb, 0x72, 0x21, 0x85, 0xf3, 0xa4,
	0xc6, 0x3a, 0xe6, 0xe9, 0x74, 0x27, 0xc4, 0x8e, 0x53, 0x5f, 0xcf, 0xa3, 0x32, 0xf1, 0x63, 0x5a,
	0x7c, 0xc9, 0x59, 0x26, 0x45, 0x5e, 0x3b, 0xee, 0x9f, 0x01, 0xc0, 0x46, 0x6d, 0x0a, 0xd5, 0x22,
	0x27, 0x00, 0x33, 0xe1, 0x62, 0x2b, 0x31, 0x9a, 0xa2, 0x97, 0xe3, 0xc5, 0x73, 0xaf, 0xbf, 0xd2,
	0xdb, 0xa8, 0xb1, 0x86, 0xdf, 0x1b, 0x61, 0x0d, 0x3b, 0xaf, 0xc1, 0x8a, 0x45, 0x19, 0x71, 0x8a,
	0x07, 0x5a, 0x9b, 0xdc, 0x6a, 0xef, 0xf4, 0xbc, 0xf1, 0x2e, 0xb8, 0x12, 0x0b, 0x99, 0xb3, 0x74,
	0x87, 0x87, 0xf7, 0xc4, 0x4f, 0x7a, 0xde, 0x8a, 0x35, 0xee, 0xbc, 0x82, 0x51, 0x24, 0x04, 0xc7,
	0x23, 0xad, 0x3d, 0xbb, 0xd5, 0xd6, 0x42, 0xf0, 0x46, 0xd2, 0xa8, 0x3a, 0x8d, 0xa5, 0x72, 0xb9,
	0xc0, 0xe6, 0xbd, 0xd3, 0x3e, 0xa8, 0x71, 0x7b, 0x9a, 0x86, 0x2f, 0xd6, 0x2a, 0xc0, 0xd6, 0x03,
	0xd6, 0x2a, 0xb8, 0xb6, 0x56, 0xc1, 0xda, 0x82, 0x91, 0xfc, 0x96, 0x51, 0x77, 0x0e, 0xd0, 0xe5,
	0xe5, 0x60, 0x78, 0x14, 0xd3, 0x64, 0x5b, 0xf2, 0x3a, 0xde, 0x41, 0xd8, 0x7c, 0xba, 0x2f, 0x60,
	0x7c, 0x15, 0x50, 0x1f, 0x44, 0x1d, 0xf8, 0x16, 0xc6, 0x57, 0x81, 0xf4, 0x41, 0xbb, 0x05, 0xd5,
	0x24, 0xdb, 0x4a, 0x49, 0xf3, 0x54, 0xff, 0x13, 0x3b, 0x6c, 0x3e, 0xdd, 0x19, 0xd8, 0x6d, 0x38,
	0xfd, 0x05, 0x8f, 0xbb, 0x97, 0xe6, 0x00, 0x5d, 0x1e, 0x7d, 0xce, 0xec, 0x73, 0x97, 0x04, 0xfa,
	0xdc, 0xb0, 0xe5, 0xde, 0x84, 0x60, 0xea, 0xae, 0x3a, 0x13, 0xaf, 0x2e, 0xa5, 0xd7, 0x94, 0xd2,
	0xd3, 0xfd, 0xfb, 0x98, 0x49, 0x15, 0x27, 0xfe, 0x65, 0xdf, 0x6d, 0x5e, 0x5b, 0xd3, 0xb0, 0x5e,
	0xb5, 0x0e, 0xf6, 0x47, 0x62, 0x1c, 0x8e, 0xc4, 0x38, 0x1f, 0x09, 0xfa, 0x5e, 0x11, 0xf4, 0xb3,
	0x22, 0xe8, 0x77, 0x45, 0xd0, 0xbe, 0x22, 0xe8, 0x6f, 0x45, 0xd0, 0xbf, 0x8a, 0x18, 0xe7, 0x8a,
	0xa0, 0x1f, 0x27, 0x62, 0xec, 0x4f, 0xc4, 0x38, 0x9c, 0x88, 0x11, 0x59, 0xfa, 0xe1, 0xe5, 0xff,
	0x00, 0x00, 0x00, 0xff, 0xff, 0x0c, 0x7a, 0x32, 0x07, 0x56, 0x03, 0x00, 0x00,
}

func (this *FieldRules) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*FieldRules)
	if !ok {
		that2, ok := that.(FieldRules)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if that1.Type == nil {
		if this.Type != nil {
			return false
		}
	} else if this.Type == nil {
		return false
	} else if !this.Type.Equal(that1.Type) {
		return false
	}
	return true
}
func (this *FieldRules_Float) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*FieldRules_Float)
	if !ok {
		that2, ok := that.(FieldRules_Float)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Float.Equal(that1.Float) {
		return false
	}
	return true
}
func (this *FieldRules_Double) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*FieldRules_Double)
	if !ok {
		that2, ok := that.(FieldRules_Double)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Double.Equal(that1.Double) {
		return false
	}
	return true
}
func (this *FieldRules_String_) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*FieldRules_String_)
	if !ok {
		that2, ok := that.(FieldRules_String_)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.String_.Equal(that1.String_) {
		return false
	}
	return true
}
func (this *FieldRules_Bool) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*FieldRules_Bool)
	if !ok {
		that2, ok := that.(FieldRules_Bool)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Bool.Equal(that1.Bool) {
		return false
	}
	return true
}
func (this *FieldRules_Int32) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*FieldRules_Int32)
	if !ok {
		that2, ok := that.(FieldRules_Int32)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Int32.Equal(that1.Int32) {
		return false
	}
	return true
}
func (this *FieldRules_Int64) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*FieldRules_Int64)
	if !ok {
		that2, ok := that.(FieldRules_Int64)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Int64.Equal(that1.Int64) {
		return false
	}
	return true
}
func (this *FloatRules) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*FloatRules)
	if !ok {
		that2, ok := that.(FloatRules)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Default != that1.Default {
		return false
	}
	return true
}
func (this *DoubleRules) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*DoubleRules)
	if !ok {
		that2, ok := that.(DoubleRules)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Default != that1.Default {
		return false
	}
	return true
}
func (this *StringRules) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*StringRules)
	if !ok {
		that2, ok := that.(StringRules)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Default != that1.Default {
		return false
	}
	if this.Pattern != that1.Pattern {
		return false
	}
	return true
}
func (this *BoolRules) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*BoolRules)
	if !ok {
		that2, ok := that.(BoolRules)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Default != that1.Default {
		return false
	}
	return true
}
func (this *Int32Rules) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Int32Rules)
	if !ok {
		that2, ok := that.(Int32Rules)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Default != that1.Default {
		return false
	}
	return true
}
func (this *Int64Rules) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Int64Rules)
	if !ok {
		that2, ok := that.(Int64Rules)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Default != that1.Default {
		return false
	}
	return true
}
func (this *FieldRules) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 10)
	s = append(s, "&istio_extensions.FieldRules{")
	if this.Type != nil {
		s = append(s, "Type: "+fmt.Sprintf("%#v", this.Type)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *FieldRules_Float) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&istio_extensions.FieldRules_Float{` +
		`Float:` + fmt.Sprintf("%#v", this.Float) + `}`}, ", ")
	return s
}
func (this *FieldRules_Double) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&istio_extensions.FieldRules_Double{` +
		`Double:` + fmt.Sprintf("%#v", this.Double) + `}`}, ", ")
	return s
}
func (this *FieldRules_String_) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&istio_extensions.FieldRules_String_{` +
		`String_:` + fmt.Sprintf("%#v", this.String_) + `}`}, ", ")
	return s
}
func (this *FieldRules_Bool) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&istio_extensions.FieldRules_Bool{` +
		`Bool:` + fmt.Sprintf("%#v", this.Bool) + `}`}, ", ")
	return s
}
func (this *FieldRules_Int32) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&istio_extensions.FieldRules_Int32{` +
		`Int32:` + fmt.Sprintf("%#v", this.Int32) + `}`}, ", ")
	return s
}
func (this *FieldRules_Int64) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&istio_extensions.FieldRules_Int64{` +
		`Int64:` + fmt.Sprintf("%#v", this.Int64) + `}`}, ", ")
	return s
}
func (this *FloatRules) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&istio_extensions.FloatRules{")
	s = append(s, "Default: "+fmt.Sprintf("%#v", this.Default)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *DoubleRules) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&istio_extensions.DoubleRules{")
	s = append(s, "Default: "+fmt.Sprintf("%#v", this.Default)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *StringRules) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&istio_extensions.StringRules{")
	s = append(s, "Default: "+fmt.Sprintf("%#v", this.Default)+",\n")
	s = append(s, "Pattern: "+fmt.Sprintf("%#v", this.Pattern)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *BoolRules) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&istio_extensions.BoolRules{")
	s = append(s, "Default: "+fmt.Sprintf("%#v", this.Default)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Int32Rules) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&istio_extensions.Int32Rules{")
	s = append(s, "Default: "+fmt.Sprintf("%#v", this.Default)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Int64Rules) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&istio_extensions.Int64Rules{")
	s = append(s, "Default: "+fmt.Sprintf("%#v", this.Default)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringFieldRules(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}
func (m *FieldRules) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *FieldRules) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *FieldRules) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Type != nil {
		{
			size := m.Type.Size()
			i -= size
			if _, err := m.Type.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	return len(dAtA) - i, nil
}

func (m *FieldRules_Float) MarshalTo(dAtA []byte) (int, error) {
	return m.MarshalToSizedBuffer(dAtA[:m.Size()])
}

func (m *FieldRules_Float) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Float != nil {
		{
			size, err := m.Float.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintFieldRules(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}
func (m *FieldRules_Double) MarshalTo(dAtA []byte) (int, error) {
	return m.MarshalToSizedBuffer(dAtA[:m.Size()])
}

func (m *FieldRules_Double) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Double != nil {
		{
			size, err := m.Double.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintFieldRules(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	return len(dAtA) - i, nil
}
func (m *FieldRules_String_) MarshalTo(dAtA []byte) (int, error) {
	return m.MarshalToSizedBuffer(dAtA[:m.Size()])
}

func (m *FieldRules_String_) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.String_ != nil {
		{
			size, err := m.String_.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintFieldRules(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	return len(dAtA) - i, nil
}
func (m *FieldRules_Bool) MarshalTo(dAtA []byte) (int, error) {
	return m.MarshalToSizedBuffer(dAtA[:m.Size()])
}

func (m *FieldRules_Bool) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Bool != nil {
		{
			size, err := m.Bool.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintFieldRules(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	return len(dAtA) - i, nil
}
func (m *FieldRules_Int32) MarshalTo(dAtA []byte) (int, error) {
	return m.MarshalToSizedBuffer(dAtA[:m.Size()])
}

func (m *FieldRules_Int32) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Int32 != nil {
		{
			size, err := m.Int32.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintFieldRules(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	return len(dAtA) - i, nil
}
func (m *FieldRules_Int64) MarshalTo(dAtA []byte) (int, error) {
	return m.MarshalToSizedBuffer(dAtA[:m.Size()])
}

func (m *FieldRules_Int64) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Int64 != nil {
		{
			size, err := m.Int64.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintFieldRules(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	return len(dAtA) - i, nil
}
func (m *FloatRules) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *FloatRules) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *FloatRules) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Default != 0 {
		i -= 4
		encoding_binary.LittleEndian.PutUint32(dAtA[i:], uint32(math.Float32bits(float32(m.Default))))
		i--
		dAtA[i] = 0xd
	}
	return len(dAtA) - i, nil
}

func (m *DoubleRules) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DoubleRules) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DoubleRules) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Default != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.Default))))
		i--
		dAtA[i] = 0x9
	}
	return len(dAtA) - i, nil
}

func (m *StringRules) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StringRules) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *StringRules) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Pattern) > 0 {
		i -= len(m.Pattern)
		copy(dAtA[i:], m.Pattern)
		i = encodeVarintFieldRules(dAtA, i, uint64(len(m.Pattern)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Default) > 0 {
		i -= len(m.Default)
		copy(dAtA[i:], m.Default)
		i = encodeVarintFieldRules(dAtA, i, uint64(len(m.Default)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *BoolRules) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *BoolRules) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *BoolRules) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Default {
		i--
		if m.Default {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *Int32Rules) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Int32Rules) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Int32Rules) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Default != 0 {
		i = encodeVarintFieldRules(dAtA, i, uint64(m.Default))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *Int64Rules) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Int64Rules) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Int64Rules) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Default != 0 {
		i = encodeVarintFieldRules(dAtA, i, uint64(m.Default))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func encodeVarintFieldRules(dAtA []byte, offset int, v uint64) int {
	offset -= sovFieldRules(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *FieldRules) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Type != nil {
		n += m.Type.Size()
	}
	return n
}

func (m *FieldRules_Float) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Float != nil {
		l = m.Float.Size()
		n += 1 + l + sovFieldRules(uint64(l))
	}
	return n
}
func (m *FieldRules_Double) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Double != nil {
		l = m.Double.Size()
		n += 1 + l + sovFieldRules(uint64(l))
	}
	return n
}
func (m *FieldRules_String_) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.String_ != nil {
		l = m.String_.Size()
		n += 1 + l + sovFieldRules(uint64(l))
	}
	return n
}
func (m *FieldRules_Bool) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Bool != nil {
		l = m.Bool.Size()
		n += 1 + l + sovFieldRules(uint64(l))
	}
	return n
}
func (m *FieldRules_Int32) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Int32 != nil {
		l = m.Int32.Size()
		n += 1 + l + sovFieldRules(uint64(l))
	}
	return n
}
func (m *FieldRules_Int64) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Int64 != nil {
		l = m.Int64.Size()
		n += 1 + l + sovFieldRules(uint64(l))
	}
	return n
}
func (m *FloatRules) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Default != 0 {
		n += 5
	}
	return n
}

func (m *DoubleRules) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Default != 0 {
		n += 9
	}
	return n
}

func (m *StringRules) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Default)
	if l > 0 {
		n += 1 + l + sovFieldRules(uint64(l))
	}
	l = len(m.Pattern)
	if l > 0 {
		n += 1 + l + sovFieldRules(uint64(l))
	}
	return n
}

func (m *BoolRules) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Default {
		n += 2
	}
	return n
}

func (m *Int32Rules) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Default != 0 {
		n += 1 + sovFieldRules(uint64(m.Default))
	}
	return n
}

func (m *Int64Rules) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Default != 0 {
		n += 1 + sovFieldRules(uint64(m.Default))
	}
	return n
}

func sovFieldRules(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozFieldRules(x uint64) (n int) {
	return sovFieldRules(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *FieldRules) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&FieldRules{`,
		`Type:` + fmt.Sprintf("%v", this.Type) + `,`,
		`}`,
	}, "")
	return s
}
func (this *FieldRules_Float) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&FieldRules_Float{`,
		`Float:` + strings.Replace(fmt.Sprintf("%v", this.Float), "FloatRules", "FloatRules", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *FieldRules_Double) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&FieldRules_Double{`,
		`Double:` + strings.Replace(fmt.Sprintf("%v", this.Double), "DoubleRules", "DoubleRules", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *FieldRules_String_) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&FieldRules_String_{`,
		`String_:` + strings.Replace(fmt.Sprintf("%v", this.String_), "StringRules", "StringRules", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *FieldRules_Bool) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&FieldRules_Bool{`,
		`Bool:` + strings.Replace(fmt.Sprintf("%v", this.Bool), "BoolRules", "BoolRules", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *FieldRules_Int32) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&FieldRules_Int32{`,
		`Int32:` + strings.Replace(fmt.Sprintf("%v", this.Int32), "Int32Rules", "Int32Rules", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *FieldRules_Int64) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&FieldRules_Int64{`,
		`Int64:` + strings.Replace(fmt.Sprintf("%v", this.Int64), "Int64Rules", "Int64Rules", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *FloatRules) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&FloatRules{`,
		`Default:` + fmt.Sprintf("%v", this.Default) + `,`,
		`}`,
	}, "")
	return s
}
func (this *DoubleRules) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&DoubleRules{`,
		`Default:` + fmt.Sprintf("%v", this.Default) + `,`,
		`}`,
	}, "")
	return s
}
func (this *StringRules) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&StringRules{`,
		`Default:` + fmt.Sprintf("%v", this.Default) + `,`,
		`Pattern:` + fmt.Sprintf("%v", this.Pattern) + `,`,
		`}`,
	}, "")
	return s
}
func (this *BoolRules) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&BoolRules{`,
		`Default:` + fmt.Sprintf("%v", this.Default) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Int32Rules) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Int32Rules{`,
		`Default:` + fmt.Sprintf("%v", this.Default) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Int64Rules) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Int64Rules{`,
		`Default:` + fmt.Sprintf("%v", this.Default) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringFieldRules(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *FieldRules) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowFieldRules
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: FieldRules: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: FieldRules: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Float", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowFieldRules
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthFieldRules
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthFieldRules
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &FloatRules{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Type = &FieldRules_Float{v}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Double", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowFieldRules
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthFieldRules
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthFieldRules
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &DoubleRules{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Type = &FieldRules_Double{v}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field String_", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowFieldRules
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthFieldRules
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthFieldRules
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &StringRules{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Type = &FieldRules_String_{v}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Bool", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowFieldRules
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthFieldRules
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthFieldRules
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &BoolRules{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Type = &FieldRules_Bool{v}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Int32", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowFieldRules
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthFieldRules
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthFieldRules
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Int32Rules{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Type = &FieldRules_Int32{v}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Int64", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowFieldRules
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthFieldRules
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthFieldRules
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Int64Rules{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Type = &FieldRules_Int64{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipFieldRules(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthFieldRules
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthFieldRules
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *FloatRules) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowFieldRules
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: FloatRules: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: FloatRules: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 5 {
				return fmt.Errorf("proto: wrong wireType = %d for field Default", wireType)
			}
			var v uint32
			if (iNdEx + 4) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint32(encoding_binary.LittleEndian.Uint32(dAtA[iNdEx:]))
			iNdEx += 4
			m.Default = float32(math.Float32frombits(v))
		default:
			iNdEx = preIndex
			skippy, err := skipFieldRules(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthFieldRules
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthFieldRules
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DoubleRules) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowFieldRules
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DoubleRules: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DoubleRules: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field Default", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.Default = float64(math.Float64frombits(v))
		default:
			iNdEx = preIndex
			skippy, err := skipFieldRules(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthFieldRules
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthFieldRules
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StringRules) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowFieldRules
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StringRules: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StringRules: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Default", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowFieldRules
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthFieldRules
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthFieldRules
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Default = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Pattern", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowFieldRules
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthFieldRules
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthFieldRules
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Pattern = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipFieldRules(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthFieldRules
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthFieldRules
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *BoolRules) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowFieldRules
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: BoolRules: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: BoolRules: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Default", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowFieldRules
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Default = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipFieldRules(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthFieldRules
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthFieldRules
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Int32Rules) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowFieldRules
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Int32Rules: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Int32Rules: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Default", wireType)
			}
			m.Default = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowFieldRules
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Default |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipFieldRules(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthFieldRules
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthFieldRules
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Int64Rules) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowFieldRules
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Int64Rules: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Int64Rules: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Default", wireType)
			}
			m.Default = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowFieldRules
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Default |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipFieldRules(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthFieldRules
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthFieldRules
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipFieldRules(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowFieldRules
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowFieldRules
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowFieldRules
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthFieldRules
			}
			iNdEx += length
			if iNdEx < 0 {
				return 0, ErrInvalidLengthFieldRules
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowFieldRules
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipFieldRules(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
				if iNdEx < 0 {
					return 0, ErrInvalidLengthFieldRules
				}
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthFieldRules = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowFieldRules   = fmt.Errorf("proto: integer overflow")
)
