// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: k8s.io/api/admission/v1beta1/generated.proto

package k8s_io_api_admission_v1beta1

import (
	bytes "bytes"
	fmt "fmt"
	proto "github.com/gogo/protobuf/proto"
	github_com_gogo_protobuf_sortkeys "github.com/gogo/protobuf/sortkeys"
	io "io"
	v11 "istio.io/gogo-genproto/k8s.io/api/authentication/v1"
	v1 "istio.io/gogo-genproto/k8s.io/apimachinery/pkg/apis/meta/v1"
	runtime "istio.io/gogo-genproto/k8s.io/apimachinery/pkg/runtime"
	_ "istio.io/gogo-genproto/k8s.io/apimachinery/pkg/runtime/schema"
	math "math"
	math_bits "math/bits"
	reflect "reflect"
	strings "strings"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

// AdmissionRequest describes the admission.Attributes for the admission request.
type AdmissionRequest struct {
	// UID is an identifier for the individual request/response. It allows us to distinguish instances of requests which are
	// otherwise identical (parallel requests, requests when earlier requests did not modify etc)
	// The UID is meant to track the round trip (request/response) between the KAS and the WebHook, not the user request.
	// It is suitable for correlating log entries between the webhook and apiserver, for either auditing or debugging.
	Uid string `protobuf:"bytes,1,opt,name=uid" json:"uid"`
	// Kind is the fully-qualified type of object being submitted (for example, v1.Pod or autoscaling.v1.Scale)
	Kind *v1.GroupVersionKind `protobuf:"bytes,2,opt,name=kind" json:"kind,omitempty"`
	// Resource is the fully-qualified resource being requested (for example, v1.pods)
	Resource *v1.GroupVersionResource `protobuf:"bytes,3,opt,name=resource" json:"resource,omitempty"`
	// SubResource is the subresource being requested, if any (for example, "status" or "scale")
	// +optional
	SubResource string `protobuf:"bytes,4,opt,name=subResource" json:"subResource"`
	// RequestKind is the fully-qualified type of the original API request (for example, v1.Pod or autoscaling.v1.Scale).
	// If this is specified and differs from the value in "kind", an equivalent match and conversion was performed.
	//
	// For example, if deployments can be modified via apps/v1 and apps/v1beta1, and a webhook registered a rule of
	// `apiGroups:["apps"], apiVersions:["v1"], resources: ["deployments"]` and `matchPolicy: Equivalent`,
	// an API request to apps/v1beta1 deployments would be converted and sent to the webhook
	// with `kind: {group:"apps", version:"v1", kind:"Deployment"}` (matching the rule the webhook registered for),
	// and `requestKind: {group:"apps", version:"v1beta1", kind:"Deployment"}` (indicating the kind of the original API request).
	//
	// See documentation for the "matchPolicy" field in the webhook configuration type for more details.
	// +optional
	RequestKind *v1.GroupVersionKind `protobuf:"bytes,13,opt,name=requestKind" json:"requestKind,omitempty"`
	// RequestResource is the fully-qualified resource of the original API request (for example, v1.pods).
	// If this is specified and differs from the value in "resource", an equivalent match and conversion was performed.
	//
	// For example, if deployments can be modified via apps/v1 and apps/v1beta1, and a webhook registered a rule of
	// `apiGroups:["apps"], apiVersions:["v1"], resources: ["deployments"]` and `matchPolicy: Equivalent`,
	// an API request to apps/v1beta1 deployments would be converted and sent to the webhook
	// with `resource: {group:"apps", version:"v1", resource:"deployments"}` (matching the resource the webhook registered for),
	// and `requestResource: {group:"apps", version:"v1beta1", resource:"deployments"}` (indicating the resource of the original API request).
	//
	// See documentation for the "matchPolicy" field in the webhook configuration type.
	// +optional
	RequestResource *v1.GroupVersionResource `protobuf:"bytes,14,opt,name=requestResource" json:"requestResource,omitempty"`
	// RequestSubResource is the name of the subresource of the original API request, if any (for example, "status" or "scale")
	// If this is specified and differs from the value in "subResource", an equivalent match and conversion was performed.
	// See documentation for the "matchPolicy" field in the webhook configuration type.
	// +optional
	RequestSubResource string `protobuf:"bytes,15,opt,name=requestSubResource" json:"requestSubResource"`
	// Name is the name of the object as presented in the request.  On a CREATE operation, the client may omit name and
	// rely on the server to generate the name.  If that is the case, this field will contain an empty string.
	// +optional
	Name string `protobuf:"bytes,5,opt,name=name" json:"name"`
	// Namespace is the namespace associated with the request (if any).
	// +optional
	Namespace string `protobuf:"bytes,6,opt,name=namespace" json:"namespace"`
	// Operation is the operation being performed. This may be different than the operation
	// requested. e.g. a patch can result in either a CREATE or UPDATE Operation.
	Operation string `protobuf:"bytes,7,opt,name=operation" json:"operation"`
	// UserInfo is information about the requesting user
	UserInfo *v11.UserInfo `protobuf:"bytes,8,opt,name=userInfo" json:"userInfo,omitempty"`
	// Object is the object from the incoming request.
	// +optional
	Object *runtime.RawExtension `protobuf:"bytes,9,opt,name=object" json:"object,omitempty"`
	// OldObject is the existing object. Only populated for DELETE and UPDATE requests.
	// +optional
	OldObject *runtime.RawExtension `protobuf:"bytes,10,opt,name=oldObject" json:"oldObject,omitempty"`
	// DryRun indicates that modifications will definitely not be persisted for this request.
	// Defaults to false.
	// +optional
	DryRun bool `protobuf:"varint,11,opt,name=dryRun" json:"dryRun"`
	// Options is the operation option structure of the operation being performed.
	// e.g. `meta.k8s.io/v1.DeleteOptions` or `meta.k8s.io/v1.CreateOptions`. This may be
	// different than the options the caller provided. e.g. for a patch request the performed
	// Operation might be a CREATE, in which case the Options will a
	// `meta.k8s.io/v1.CreateOptions` even though the caller provided `meta.k8s.io/v1.PatchOptions`.
	// +optional
	Options *runtime.RawExtension `protobuf:"bytes,12,opt,name=options" json:"options,omitempty"`
}

func (m *AdmissionRequest) Reset()      { *m = AdmissionRequest{} }
func (*AdmissionRequest) ProtoMessage() {}
func (*AdmissionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_d8f147b43c61e73e, []int{0}
}
func (m *AdmissionRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AdmissionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AdmissionRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AdmissionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AdmissionRequest.Merge(m, src)
}
func (m *AdmissionRequest) XXX_Size() int {
	return m.Size()
}
func (m *AdmissionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AdmissionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AdmissionRequest proto.InternalMessageInfo

func (m *AdmissionRequest) GetUid() string {
	if m != nil {
		return m.Uid
	}
	return ""
}

func (m *AdmissionRequest) GetKind() *v1.GroupVersionKind {
	if m != nil {
		return m.Kind
	}
	return nil
}

func (m *AdmissionRequest) GetResource() *v1.GroupVersionResource {
	if m != nil {
		return m.Resource
	}
	return nil
}

func (m *AdmissionRequest) GetSubResource() string {
	if m != nil {
		return m.SubResource
	}
	return ""
}

func (m *AdmissionRequest) GetRequestKind() *v1.GroupVersionKind {
	if m != nil {
		return m.RequestKind
	}
	return nil
}

func (m *AdmissionRequest) GetRequestResource() *v1.GroupVersionResource {
	if m != nil {
		return m.RequestResource
	}
	return nil
}

func (m *AdmissionRequest) GetRequestSubResource() string {
	if m != nil {
		return m.RequestSubResource
	}
	return ""
}

func (m *AdmissionRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *AdmissionRequest) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *AdmissionRequest) GetOperation() string {
	if m != nil {
		return m.Operation
	}
	return ""
}

func (m *AdmissionRequest) GetUserInfo() *v11.UserInfo {
	if m != nil {
		return m.UserInfo
	}
	return nil
}

func (m *AdmissionRequest) GetObject() *runtime.RawExtension {
	if m != nil {
		return m.Object
	}
	return nil
}

func (m *AdmissionRequest) GetOldObject() *runtime.RawExtension {
	if m != nil {
		return m.OldObject
	}
	return nil
}

func (m *AdmissionRequest) GetDryRun() bool {
	if m != nil {
		return m.DryRun
	}
	return false
}

func (m *AdmissionRequest) GetOptions() *runtime.RawExtension {
	if m != nil {
		return m.Options
	}
	return nil
}

// AdmissionResponse describes an admission response.
type AdmissionResponse struct {
	// UID is an identifier for the individual request/response.
	// This should be copied over from the corresponding AdmissionRequest.
	Uid string `protobuf:"bytes,1,opt,name=uid" json:"uid"`
	// Allowed indicates whether or not the admission request was permitted.
	Allowed bool `protobuf:"varint,2,opt,name=allowed" json:"allowed"`
	// Result contains extra details into why an admission request was denied.
	// This field IS NOT consulted in any way if "Allowed" is "true".
	// +optional
	Status *v1.Status `protobuf:"bytes,3,opt,name=status" json:"status,omitempty"`
	// The patch body. Currently we only support "JSONPatch" which implements RFC 6902.
	// +optional
	Patch []byte `protobuf:"bytes,4,opt,name=patch" json:"patch"`
	// The type of Patch. Currently we only allow "JSONPatch".
	// +optional
	PatchType string `protobuf:"bytes,5,opt,name=patchType" json:"patchType"`
	// AuditAnnotations is an unstructured key value map set by remote admission controller (e.g. error=image-blacklisted).
	// MutatingAdmissionWebhook and ValidatingAdmissionWebhook admission controller will prefix the keys with
	// admission webhook name (e.g. imagepolicy.example.com/error=image-blacklisted). AuditAnnotations will be provided by
	// the admission webhook to add additional context to the audit log for this request.
	// +optional
	AuditAnnotations map[string]string `protobuf:"bytes,6,rep,name=auditAnnotations" json:"auditAnnotations,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *AdmissionResponse) Reset()      { *m = AdmissionResponse{} }
func (*AdmissionResponse) ProtoMessage() {}
func (*AdmissionResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_d8f147b43c61e73e, []int{1}
}
func (m *AdmissionResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AdmissionResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AdmissionResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AdmissionResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AdmissionResponse.Merge(m, src)
}
func (m *AdmissionResponse) XXX_Size() int {
	return m.Size()
}
func (m *AdmissionResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_AdmissionResponse.DiscardUnknown(m)
}

var xxx_messageInfo_AdmissionResponse proto.InternalMessageInfo

func (m *AdmissionResponse) GetUid() string {
	if m != nil {
		return m.Uid
	}
	return ""
}

func (m *AdmissionResponse) GetAllowed() bool {
	if m != nil {
		return m.Allowed
	}
	return false
}

func (m *AdmissionResponse) GetStatus() *v1.Status {
	if m != nil {
		return m.Status
	}
	return nil
}

func (m *AdmissionResponse) GetPatch() []byte {
	if m != nil {
		return m.Patch
	}
	return nil
}

func (m *AdmissionResponse) GetPatchType() string {
	if m != nil {
		return m.PatchType
	}
	return ""
}

func (m *AdmissionResponse) GetAuditAnnotations() map[string]string {
	if m != nil {
		return m.AuditAnnotations
	}
	return nil
}

// AdmissionReview describes an admission review request/response.
type AdmissionReview struct {
	// Request describes the attributes for the admission request.
	// +optional
	Request *AdmissionRequest `protobuf:"bytes,1,opt,name=request" json:"request,omitempty"`
	// Response describes the attributes for the admission response.
	// +optional
	Response *AdmissionResponse `protobuf:"bytes,2,opt,name=response" json:"response,omitempty"`
}

func (m *AdmissionReview) Reset()      { *m = AdmissionReview{} }
func (*AdmissionReview) ProtoMessage() {}
func (*AdmissionReview) Descriptor() ([]byte, []int) {
	return fileDescriptor_d8f147b43c61e73e, []int{2}
}
func (m *AdmissionReview) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AdmissionReview) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AdmissionReview.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AdmissionReview) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AdmissionReview.Merge(m, src)
}
func (m *AdmissionReview) XXX_Size() int {
	return m.Size()
}
func (m *AdmissionReview) XXX_DiscardUnknown() {
	xxx_messageInfo_AdmissionReview.DiscardUnknown(m)
}

var xxx_messageInfo_AdmissionReview proto.InternalMessageInfo

func (m *AdmissionReview) GetRequest() *AdmissionRequest {
	if m != nil {
		return m.Request
	}
	return nil
}

func (m *AdmissionReview) GetResponse() *AdmissionResponse {
	if m != nil {
		return m.Response
	}
	return nil
}

func init() {
	proto.RegisterType((*AdmissionRequest)(nil), "k8s.io.api.admission.v1beta1.AdmissionRequest")
	proto.RegisterType((*AdmissionResponse)(nil), "k8s.io.api.admission.v1beta1.AdmissionResponse")
	proto.RegisterMapType((map[string]string)(nil), "k8s.io.api.admission.v1beta1.AdmissionResponse.AuditAnnotationsEntry")
	proto.RegisterType((*AdmissionReview)(nil), "k8s.io.api.admission.v1beta1.AdmissionReview")
}

func init() {
	proto.RegisterFile("k8s.io/api/admission/v1beta1/generated.proto", fileDescriptor_d8f147b43c61e73e)
}

var fileDescriptor_d8f147b43c61e73e = []byte{
	// 700 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x54, 0xcd, 0x4e, 0x1b, 0x3d,
	0x14, 0xcd, 0x90, 0x90, 0x1f, 0x87, 0xef, 0x83, 0x5a, 0x6a, 0x35, 0x8a, 0x90, 0x1b, 0x65, 0x81,
	0xb2, 0xa0, 0x1e, 0x81, 0x10, 0x42, 0xec, 0x40, 0x8d, 0x68, 0xcb, 0x02, 0x69, 0x68, 0x51, 0xb7,
	0x26, 0xe3, 0x12, 0x37, 0x89, 0x3d, 0x8c, 0x3d, 0xa1, 0xd9, 0xf5, 0x05, 0x2a, 0x75, 0xd3, 0x77,
	0xe0, 0x51, 0x58, 0xb2, 0x64, 0x55, 0x95, 0xb0, 0xe9, 0x92, 0x47, 0xa8, 0x3c, 0xe3, 0x99, 0x4c,
	0x02, 0xb4, 0xfc, 0xac, 0x92, 0x39, 0xf7, 0x9e, 0x63, 0x9f, 0xab, 0x7b, 0x0c, 0x96, 0xbb, 0x1b,
	0x12, 0x33, 0xe1, 0x10, 0x9f, 0x39, 0xc4, 0xeb, 0x33, 0x29, 0x99, 0xe0, 0xce, 0x60, 0xe5, 0x90,
	0x2a, 0xb2, 0xe2, 0x1c, 0x51, 0x4e, 0x03, 0xa2, 0xa8, 0x87, 0xfd, 0x40, 0x28, 0x01, 0x17, 0xe3,
	0x6e, 0x4c, 0x7c, 0x86, 0xd3, 0x6e, 0x6c, 0xba, 0x6b, 0x13, 0x5a, 0xa1, 0xea, 0x50, 0xae, 0x58,
	0x9b, 0xa8, 0x58, 0x70, 0x5a, 0xab, 0xb6, 0x36, 0xee, 0xee, 0x93, 0x76, 0x87, 0x71, 0x1a, 0x0c,
	0x1d, 0xbf, 0x7b, 0xa4, 0x01, 0xe9, 0xf4, 0xa9, 0x22, 0xb7, 0xb1, 0x9c, 0xbb, 0x58, 0x41, 0xc8,
	0x15, 0xeb, 0xd3, 0x1b, 0x84, 0xf5, 0x7f, 0x11, 0x64, 0xbb, 0x43, 0xfb, 0x64, 0x9a, 0xd7, 0xf8,
	0x56, 0x02, 0x0b, 0x5b, 0x89, 0x45, 0x97, 0x1e, 0x87, 0x54, 0x2a, 0xf8, 0x02, 0xe4, 0x43, 0xe6,
	0xd9, 0x56, 0xdd, 0x6a, 0x56, 0xb6, 0x0b, 0x67, 0x3f, 0x5f, 0xe6, 0x5c, 0x0d, 0xc0, 0x77, 0xa0,
	0xd0, 0x65, 0xdc, 0xb3, 0x67, 0xea, 0x56, 0xb3, 0xba, 0xba, 0x8e, 0xc7, 0x63, 0x4a, 0xcf, 0xc4,
	0x7e, 0xf7, 0x48, 0x03, 0x12, 0x6b, 0x6b, 0x78, 0xb0, 0x82, 0x77, 0x02, 0x11, 0xfa, 0x07, 0x34,
	0xd0, 0x07, 0xec, 0x32, 0xee, 0xb9, 0x91, 0x06, 0x3c, 0x00, 0xe5, 0x80, 0x4a, 0x11, 0x06, 0x6d,
	0x6a, 0xe7, 0x23, 0xbd, 0xcd, 0x87, 0xeb, 0xb9, 0x46, 0xc1, 0x4d, 0xb5, 0xe0, 0x12, 0xa8, 0xca,
	0xf0, 0x30, 0x29, 0xd8, 0x85, 0x8c, 0x87, 0x6c, 0x01, 0x7e, 0x04, 0xd5, 0x20, 0xb6, 0xab, 0x2f,
	0x65, 0xff, 0xf7, 0x24, 0x4b, 0x59, 0x29, 0xe8, 0x81, 0x79, 0xf3, 0x99, 0xde, 0xe2, 0xff, 0x27,
	0x1b, 0x9c, 0x96, 0x84, 0x6b, 0x00, 0x1a, 0x68, 0x3f, 0x63, 0x77, 0x3e, 0x63, 0xf7, 0x96, 0x3a,
	0xb4, 0x41, 0x81, 0x93, 0x3e, 0xb5, 0x67, 0x33, 0x7d, 0x11, 0x02, 0x1b, 0xa0, 0xa2, 0x7f, 0xa5,
	0x4f, 0xda, 0xd4, 0x2e, 0x66, 0xca, 0x63, 0x58, 0xf7, 0x08, 0x5f, 0xaf, 0x0f, 0x13, 0xdc, 0x2e,
	0x65, 0x7b, 0x52, 0x18, 0x6e, 0x83, 0x72, 0x28, 0x69, 0xf0, 0x96, 0x7f, 0x12, 0x76, 0x39, 0xb2,
	0xbd, 0x84, 0xb3, 0x71, 0x9a, 0x08, 0x8c, 0xb6, 0xfb, 0xc1, 0x74, 0xbb, 0x29, 0x0f, 0xb6, 0x40,
	0x51, 0x1c, 0x7e, 0xa6, 0x6d, 0x65, 0x57, 0x22, 0x85, 0x57, 0x77, 0x0e, 0xce, 0x6c, 0x37, 0x76,
	0xc9, 0x49, 0xeb, 0x8b, 0xa2, 0x3c, 0x9a, 0x99, 0x21, 0xc3, 0x5d, 0x50, 0x11, 0x3d, 0x6f, 0x2f,
	0x56, 0x02, 0x8f, 0x51, 0x1a, 0xf3, 0xe1, 0x22, 0x28, 0x7a, 0xc1, 0xd0, 0x0d, 0xb9, 0x5d, 0xad,
	0x5b, 0xcd, 0xb2, 0x31, 0x6e, 0x30, 0xb8, 0x03, 0x4a, 0xc2, 0xd7, 0x8e, 0xa4, 0x3d, 0xf7, 0x98,
	0x83, 0x12, 0x76, 0xe3, 0x47, 0x1e, 0x3c, 0xcb, 0xe4, 0x51, 0xfa, 0x82, 0x4b, 0x7a, 0x67, 0x20,
	0x11, 0x28, 0x91, 0x5e, 0x4f, 0x9c, 0xd0, 0x38, 0x93, 0xc9, 0xad, 0x12, 0x10, 0xbe, 0x06, 0x45,
	0xa9, 0x88, 0x0a, 0xa5, 0x89, 0xd8, 0xf2, 0xfd, 0x36, 0x70, 0x3f, 0xe2, 0xb8, 0x86, 0x0b, 0x6b,
	0x60, 0xd6, 0x27, 0xaa, 0xdd, 0x89, 0xc2, 0x34, 0x67, 0xce, 0x88, 0x21, 0xbd, 0x12, 0xd1, 0x9f,
	0xf7, 0x43, 0x7f, 0x72, 0xab, 0xc6, 0x30, 0x3c, 0x06, 0x0b, 0x24, 0xf4, 0x98, 0xda, 0xe2, 0x5c,
	0x28, 0x12, 0x4f, 0xa9, 0x58, 0xcf, 0x37, 0xab, 0xab, 0x2d, 0xfc, 0xb7, 0x97, 0x16, 0xdf, 0x18,
	0x04, 0xde, 0x9a, 0xd2, 0x69, 0x71, 0x15, 0x0c, 0xdd, 0x1b, 0xf2, 0xb5, 0x3d, 0xf0, 0xfc, 0xd6,
	0x56, 0x3d, 0xc9, 0x2e, 0x1d, 0x4e, 0x4e, 0xb2, 0x4b, 0x87, 0xda, 0xe3, 0x80, 0xf4, 0x42, 0x1a,
	0xcd, 0x31, 0xa9, 0xc4, 0xd0, 0xe6, 0xcc, 0x86, 0xd5, 0x38, 0xb5, 0xc0, 0x7c, 0xe6, 0x3a, 0x03,
	0x46, 0x4f, 0xe0, 0x1b, 0x50, 0x32, 0x11, 0x8b, 0xf4, 0xaa, 0xab, 0xf8, 0xde, 0x76, 0xe2, 0x2c,
	0x27, 0x74, 0xb8, 0x1b, 0x3d, 0x86, 0x91, 0x45, 0xf3, 0xb8, 0x3a, 0x0f, 0x9c, 0x8c, 0x9b, 0x0a,
	0x6c, 0xaf, 0x9d, 0x5f, 0xa2, 0xdc, 0xc5, 0x25, 0xca, 0x5d, 0x5f, 0x22, 0xeb, 0xeb, 0x08, 0x59,
	0xa7, 0x23, 0x64, 0x9d, 0x8d, 0x90, 0x75, 0x3e, 0x42, 0xd6, 0xaf, 0x11, 0xb2, 0x7e, 0x8f, 0x50,
	0xee, 0x7a, 0x84, 0xac, 0xef, 0x57, 0x28, 0x77, 0x7e, 0x85, 0x72, 0x17, 0x57, 0x28, 0xf7, 0x27,
	0x00, 0x00, 0xff, 0xff, 0x0f, 0x9b, 0x4d, 0xca, 0x22, 0x07, 0x00, 0x00,
}

func (this *AdmissionRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*AdmissionRequest)
	if !ok {
		that2, ok := that.(AdmissionRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Uid != that1.Uid {
		return false
	}
	if !this.Kind.Equal(that1.Kind) {
		return false
	}
	if !this.Resource.Equal(that1.Resource) {
		return false
	}
	if this.SubResource != that1.SubResource {
		return false
	}
	if !this.RequestKind.Equal(that1.RequestKind) {
		return false
	}
	if !this.RequestResource.Equal(that1.RequestResource) {
		return false
	}
	if this.RequestSubResource != that1.RequestSubResource {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if this.Namespace != that1.Namespace {
		return false
	}
	if this.Operation != that1.Operation {
		return false
	}
	if !this.UserInfo.Equal(that1.UserInfo) {
		return false
	}
	if !this.Object.Equal(that1.Object) {
		return false
	}
	if !this.OldObject.Equal(that1.OldObject) {
		return false
	}
	if this.DryRun != that1.DryRun {
		return false
	}
	if !this.Options.Equal(that1.Options) {
		return false
	}
	return true
}
func (this *AdmissionResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*AdmissionResponse)
	if !ok {
		that2, ok := that.(AdmissionResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Uid != that1.Uid {
		return false
	}
	if this.Allowed != that1.Allowed {
		return false
	}
	if !this.Status.Equal(that1.Status) {
		return false
	}
	if !bytes.Equal(this.Patch, that1.Patch) {
		return false
	}
	if this.PatchType != that1.PatchType {
		return false
	}
	if len(this.AuditAnnotations) != len(that1.AuditAnnotations) {
		return false
	}
	for i := range this.AuditAnnotations {
		if this.AuditAnnotations[i] != that1.AuditAnnotations[i] {
			return false
		}
	}
	return true
}
func (this *AdmissionReview) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*AdmissionReview)
	if !ok {
		that2, ok := that.(AdmissionReview)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Request.Equal(that1.Request) {
		return false
	}
	if !this.Response.Equal(that1.Response) {
		return false
	}
	return true
}
func (this *AdmissionRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 19)
	s = append(s, "&k8s_io_api_admission_v1beta1.AdmissionRequest{")
	s = append(s, "Uid: "+fmt.Sprintf("%#v", this.Uid)+",\n")
	if this.Kind != nil {
		s = append(s, "Kind: "+fmt.Sprintf("%#v", this.Kind)+",\n")
	}
	if this.Resource != nil {
		s = append(s, "Resource: "+fmt.Sprintf("%#v", this.Resource)+",\n")
	}
	s = append(s, "SubResource: "+fmt.Sprintf("%#v", this.SubResource)+",\n")
	if this.RequestKind != nil {
		s = append(s, "RequestKind: "+fmt.Sprintf("%#v", this.RequestKind)+",\n")
	}
	if this.RequestResource != nil {
		s = append(s, "RequestResource: "+fmt.Sprintf("%#v", this.RequestResource)+",\n")
	}
	s = append(s, "RequestSubResource: "+fmt.Sprintf("%#v", this.RequestSubResource)+",\n")
	s = append(s, "Name: "+fmt.Sprintf("%#v", this.Name)+",\n")
	s = append(s, "Namespace: "+fmt.Sprintf("%#v", this.Namespace)+",\n")
	s = append(s, "Operation: "+fmt.Sprintf("%#v", this.Operation)+",\n")
	if this.UserInfo != nil {
		s = append(s, "UserInfo: "+fmt.Sprintf("%#v", this.UserInfo)+",\n")
	}
	if this.Object != nil {
		s = append(s, "Object: "+fmt.Sprintf("%#v", this.Object)+",\n")
	}
	if this.OldObject != nil {
		s = append(s, "OldObject: "+fmt.Sprintf("%#v", this.OldObject)+",\n")
	}
	s = append(s, "DryRun: "+fmt.Sprintf("%#v", this.DryRun)+",\n")
	if this.Options != nil {
		s = append(s, "Options: "+fmt.Sprintf("%#v", this.Options)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *AdmissionResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 10)
	s = append(s, "&k8s_io_api_admission_v1beta1.AdmissionResponse{")
	s = append(s, "Uid: "+fmt.Sprintf("%#v", this.Uid)+",\n")
	s = append(s, "Allowed: "+fmt.Sprintf("%#v", this.Allowed)+",\n")
	if this.Status != nil {
		s = append(s, "Status: "+fmt.Sprintf("%#v", this.Status)+",\n")
	}
	s = append(s, "Patch: "+fmt.Sprintf("%#v", this.Patch)+",\n")
	s = append(s, "PatchType: "+fmt.Sprintf("%#v", this.PatchType)+",\n")
	keysForAuditAnnotations := make([]string, 0, len(this.AuditAnnotations))
	for k, _ := range this.AuditAnnotations {
		keysForAuditAnnotations = append(keysForAuditAnnotations, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForAuditAnnotations)
	mapStringForAuditAnnotations := "map[string]string{"
	for _, k := range keysForAuditAnnotations {
		mapStringForAuditAnnotations += fmt.Sprintf("%#v: %#v,", k, this.AuditAnnotations[k])
	}
	mapStringForAuditAnnotations += "}"
	if this.AuditAnnotations != nil {
		s = append(s, "AuditAnnotations: "+mapStringForAuditAnnotations+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *AdmissionReview) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&k8s_io_api_admission_v1beta1.AdmissionReview{")
	if this.Request != nil {
		s = append(s, "Request: "+fmt.Sprintf("%#v", this.Request)+",\n")
	}
	if this.Response != nil {
		s = append(s, "Response: "+fmt.Sprintf("%#v", this.Response)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringGenerated(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}
func (m *AdmissionRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AdmissionRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AdmissionRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	i -= len(m.RequestSubResource)
	copy(dAtA[i:], m.RequestSubResource)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.RequestSubResource)))
	i--
	dAtA[i] = 0x7a
	if m.RequestResource != nil {
		{
			size, err := m.RequestResource.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x72
	}
	if m.RequestKind != nil {
		{
			size, err := m.RequestKind.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x6a
	}
	if m.Options != nil {
		{
			size, err := m.Options.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x62
	}
	i--
	if m.DryRun {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i--
	dAtA[i] = 0x58
	if m.OldObject != nil {
		{
			size, err := m.OldObject.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x52
	}
	if m.Object != nil {
		{
			size, err := m.Object.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x4a
	}
	if m.UserInfo != nil {
		{
			size, err := m.UserInfo.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x42
	}
	i -= len(m.Operation)
	copy(dAtA[i:], m.Operation)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Operation)))
	i--
	dAtA[i] = 0x3a
	i -= len(m.Namespace)
	copy(dAtA[i:], m.Namespace)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Namespace)))
	i--
	dAtA[i] = 0x32
	i -= len(m.Name)
	copy(dAtA[i:], m.Name)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Name)))
	i--
	dAtA[i] = 0x2a
	i -= len(m.SubResource)
	copy(dAtA[i:], m.SubResource)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.SubResource)))
	i--
	dAtA[i] = 0x22
	if m.Resource != nil {
		{
			size, err := m.Resource.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.Kind != nil {
		{
			size, err := m.Kind.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	i -= len(m.Uid)
	copy(dAtA[i:], m.Uid)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Uid)))
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *AdmissionResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AdmissionResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AdmissionResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.AuditAnnotations) > 0 {
		for k := range m.AuditAnnotations {
			v := m.AuditAnnotations[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintGenerated(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintGenerated(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintGenerated(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x32
		}
	}
	i -= len(m.PatchType)
	copy(dAtA[i:], m.PatchType)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.PatchType)))
	i--
	dAtA[i] = 0x2a
	if m.Patch != nil {
		i -= len(m.Patch)
		copy(dAtA[i:], m.Patch)
		i = encodeVarintGenerated(dAtA, i, uint64(len(m.Patch)))
		i--
		dAtA[i] = 0x22
	}
	if m.Status != nil {
		{
			size, err := m.Status.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	i--
	if m.Allowed {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i--
	dAtA[i] = 0x10
	i -= len(m.Uid)
	copy(dAtA[i:], m.Uid)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Uid)))
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *AdmissionReview) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AdmissionReview) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AdmissionReview) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Response != nil {
		{
			size, err := m.Response.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Request != nil {
		{
			size, err := m.Request.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintGenerated(dAtA []byte, offset int, v uint64) int {
	offset -= sovGenerated(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *AdmissionRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Uid)
	n += 1 + l + sovGenerated(uint64(l))
	if m.Kind != nil {
		l = m.Kind.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Resource != nil {
		l = m.Resource.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	l = len(m.SubResource)
	n += 1 + l + sovGenerated(uint64(l))
	l = len(m.Name)
	n += 1 + l + sovGenerated(uint64(l))
	l = len(m.Namespace)
	n += 1 + l + sovGenerated(uint64(l))
	l = len(m.Operation)
	n += 1 + l + sovGenerated(uint64(l))
	if m.UserInfo != nil {
		l = m.UserInfo.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Object != nil {
		l = m.Object.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.OldObject != nil {
		l = m.OldObject.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	n += 2
	if m.Options != nil {
		l = m.Options.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.RequestKind != nil {
		l = m.RequestKind.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.RequestResource != nil {
		l = m.RequestResource.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	l = len(m.RequestSubResource)
	n += 1 + l + sovGenerated(uint64(l))
	return n
}

func (m *AdmissionResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Uid)
	n += 1 + l + sovGenerated(uint64(l))
	n += 2
	if m.Status != nil {
		l = m.Status.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Patch != nil {
		l = len(m.Patch)
		n += 1 + l + sovGenerated(uint64(l))
	}
	l = len(m.PatchType)
	n += 1 + l + sovGenerated(uint64(l))
	if len(m.AuditAnnotations) > 0 {
		for k, v := range m.AuditAnnotations {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovGenerated(uint64(len(k))) + 1 + len(v) + sovGenerated(uint64(len(v)))
			n += mapEntrySize + 1 + sovGenerated(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *AdmissionReview) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Request != nil {
		l = m.Request.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Response != nil {
		l = m.Response.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	return n
}

func sovGenerated(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozGenerated(x uint64) (n int) {
	return sovGenerated(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *AdmissionRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&AdmissionRequest{`,
		`Uid:` + fmt.Sprintf("%v", this.Uid) + `,`,
		`Kind:` + strings.Replace(fmt.Sprintf("%v", this.Kind), "GroupVersionKind", "v1.GroupVersionKind", 1) + `,`,
		`Resource:` + strings.Replace(fmt.Sprintf("%v", this.Resource), "GroupVersionResource", "v1.GroupVersionResource", 1) + `,`,
		`SubResource:` + fmt.Sprintf("%v", this.SubResource) + `,`,
		`Name:` + fmt.Sprintf("%v", this.Name) + `,`,
		`Namespace:` + fmt.Sprintf("%v", this.Namespace) + `,`,
		`Operation:` + fmt.Sprintf("%v", this.Operation) + `,`,
		`UserInfo:` + strings.Replace(fmt.Sprintf("%v", this.UserInfo), "UserInfo", "v11.UserInfo", 1) + `,`,
		`Object:` + strings.Replace(fmt.Sprintf("%v", this.Object), "RawExtension", "runtime.RawExtension", 1) + `,`,
		`OldObject:` + strings.Replace(fmt.Sprintf("%v", this.OldObject), "RawExtension", "runtime.RawExtension", 1) + `,`,
		`DryRun:` + fmt.Sprintf("%v", this.DryRun) + `,`,
		`Options:` + strings.Replace(fmt.Sprintf("%v", this.Options), "RawExtension", "runtime.RawExtension", 1) + `,`,
		`RequestKind:` + strings.Replace(fmt.Sprintf("%v", this.RequestKind), "GroupVersionKind", "v1.GroupVersionKind", 1) + `,`,
		`RequestResource:` + strings.Replace(fmt.Sprintf("%v", this.RequestResource), "GroupVersionResource", "v1.GroupVersionResource", 1) + `,`,
		`RequestSubResource:` + fmt.Sprintf("%v", this.RequestSubResource) + `,`,
		`}`,
	}, "")
	return s
}
func (this *AdmissionResponse) String() string {
	if this == nil {
		return "nil"
	}
	keysForAuditAnnotations := make([]string, 0, len(this.AuditAnnotations))
	for k, _ := range this.AuditAnnotations {
		keysForAuditAnnotations = append(keysForAuditAnnotations, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForAuditAnnotations)
	mapStringForAuditAnnotations := "map[string]string{"
	for _, k := range keysForAuditAnnotations {
		mapStringForAuditAnnotations += fmt.Sprintf("%v: %v,", k, this.AuditAnnotations[k])
	}
	mapStringForAuditAnnotations += "}"
	s := strings.Join([]string{`&AdmissionResponse{`,
		`Uid:` + fmt.Sprintf("%v", this.Uid) + `,`,
		`Allowed:` + fmt.Sprintf("%v", this.Allowed) + `,`,
		`Status:` + strings.Replace(fmt.Sprintf("%v", this.Status), "Status", "v1.Status", 1) + `,`,
		`Patch:` + fmt.Sprintf("%v", this.Patch) + `,`,
		`PatchType:` + fmt.Sprintf("%v", this.PatchType) + `,`,
		`AuditAnnotations:` + mapStringForAuditAnnotations + `,`,
		`}`,
	}, "")
	return s
}
func (this *AdmissionReview) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&AdmissionReview{`,
		`Request:` + strings.Replace(this.Request.String(), "AdmissionRequest", "AdmissionRequest", 1) + `,`,
		`Response:` + strings.Replace(this.Response.String(), "AdmissionResponse", "AdmissionResponse", 1) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringGenerated(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *AdmissionRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AdmissionRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AdmissionRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Uid", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Uid = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Kind", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Kind == nil {
				m.Kind = &v1.GroupVersionKind{}
			}
			if err := m.Kind.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Resource", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Resource == nil {
				m.Resource = &v1.GroupVersionResource{}
			}
			if err := m.Resource.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SubResource", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SubResource = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Namespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Namespace = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Operation", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Operation = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UserInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.UserInfo == nil {
				m.UserInfo = &v11.UserInfo{}
			}
			if err := m.UserInfo.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Object", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Object == nil {
				m.Object = &runtime.RawExtension{}
			}
			if err := m.Object.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OldObject", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.OldObject == nil {
				m.OldObject = &runtime.RawExtension{}
			}
			if err := m.OldObject.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DryRun", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.DryRun = bool(v != 0)
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Options", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Options == nil {
				m.Options = &runtime.RawExtension{}
			}
			if err := m.Options.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestKind", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RequestKind == nil {
				m.RequestKind = &v1.GroupVersionKind{}
			}
			if err := m.RequestKind.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestResource", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RequestResource == nil {
				m.RequestResource = &v1.GroupVersionResource{}
			}
			if err := m.RequestResource.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 15:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestSubResource", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RequestSubResource = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AdmissionResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AdmissionResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AdmissionResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Uid", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Uid = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Allowed", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Allowed = bool(v != 0)
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Status == nil {
				m.Status = &v1.Status{}
			}
			if err := m.Status.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Patch", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Patch = append(m.Patch[:0], dAtA[iNdEx:postIndex]...)
			if m.Patch == nil {
				m.Patch = []byte{}
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PatchType", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PatchType = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AuditAnnotations", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AuditAnnotations == nil {
				m.AuditAnnotations = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowGenerated
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowGenerated
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthGenerated
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthGenerated
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowGenerated
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthGenerated
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthGenerated
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipGenerated(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthGenerated
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.AuditAnnotations[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AdmissionReview) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AdmissionReview: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AdmissionReview: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Request", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Request == nil {
				m.Request = &AdmissionRequest{}
			}
			if err := m.Request.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Response", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Response == nil {
				m.Response = &AdmissionResponse{}
			}
			if err := m.Response.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipGenerated(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthGenerated
			}
			iNdEx += length
			if iNdEx < 0 {
				return 0, ErrInvalidLengthGenerated
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowGenerated
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipGenerated(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
				if iNdEx < 0 {
					return 0, ErrInvalidLengthGenerated
				}
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthGenerated = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowGenerated   = fmt.Errorf("proto: integer overflow")
)
