// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: k8s.io/api/auditregistration/v1alpha1/generated.proto

package k8s_io_api_auditregistration_v1alpha1

import (
	bytes "bytes"
	fmt "fmt"
	proto "github.com/gogo/protobuf/proto"
	io "io"
	v1 "istio.io/gogo-genproto/k8s.io/apimachinery/pkg/apis/meta/v1"
	_ "istio.io/gogo-genproto/k8s.io/apimachinery/pkg/runtime"
	_ "istio.io/gogo-genproto/k8s.io/apimachinery/pkg/runtime/schema"
	math "math"
	math_bits "math/bits"
	reflect "reflect"
	strings "strings"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

// AuditSink represents a cluster level audit sink
type AuditSink struct {
	// +optional
	Metadata *v1.ObjectMeta `protobuf:"bytes,1,opt,name=metadata" json:"metadata,omitempty"`
	// Spec defines the audit configuration spec
	Spec *AuditSinkSpec `protobuf:"bytes,2,opt,name=spec" json:"spec,omitempty"`
}

func (m *AuditSink) Reset()      { *m = AuditSink{} }
func (*AuditSink) ProtoMessage() {}
func (*AuditSink) Descriptor() ([]byte, []int) {
	return fileDescriptor_1af3dad3b6bc082e, []int{0}
}
func (m *AuditSink) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AuditSink) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AuditSink.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AuditSink) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AuditSink.Merge(m, src)
}
func (m *AuditSink) XXX_Size() int {
	return m.Size()
}
func (m *AuditSink) XXX_DiscardUnknown() {
	xxx_messageInfo_AuditSink.DiscardUnknown(m)
}

var xxx_messageInfo_AuditSink proto.InternalMessageInfo

func (m *AuditSink) GetMetadata() *v1.ObjectMeta {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *AuditSink) GetSpec() *AuditSinkSpec {
	if m != nil {
		return m.Spec
	}
	return nil
}

// AuditSinkList is a list of AuditSink items.
type AuditSinkList struct {
	// +optional
	Metadata *v1.ListMeta `protobuf:"bytes,1,opt,name=metadata" json:"metadata,omitempty"`
	// List of audit configurations.
	Items []*AuditSink `protobuf:"bytes,2,rep,name=items" json:"items,omitempty"`
}

func (m *AuditSinkList) Reset()      { *m = AuditSinkList{} }
func (*AuditSinkList) ProtoMessage() {}
func (*AuditSinkList) Descriptor() ([]byte, []int) {
	return fileDescriptor_1af3dad3b6bc082e, []int{1}
}
func (m *AuditSinkList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AuditSinkList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AuditSinkList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AuditSinkList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AuditSinkList.Merge(m, src)
}
func (m *AuditSinkList) XXX_Size() int {
	return m.Size()
}
func (m *AuditSinkList) XXX_DiscardUnknown() {
	xxx_messageInfo_AuditSinkList.DiscardUnknown(m)
}

var xxx_messageInfo_AuditSinkList proto.InternalMessageInfo

func (m *AuditSinkList) GetMetadata() *v1.ListMeta {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *AuditSinkList) GetItems() []*AuditSink {
	if m != nil {
		return m.Items
	}
	return nil
}

// AuditSinkSpec holds the spec for the audit sink
type AuditSinkSpec struct {
	// Policy defines the policy for selecting which events should be sent to the webhook
	// required
	Policy *Policy `protobuf:"bytes,1,opt,name=policy" json:"policy,omitempty"`
	// Webhook to send events
	// required
	Webhook *Webhook `protobuf:"bytes,2,opt,name=webhook" json:"webhook,omitempty"`
}

func (m *AuditSinkSpec) Reset()      { *m = AuditSinkSpec{} }
func (*AuditSinkSpec) ProtoMessage() {}
func (*AuditSinkSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_1af3dad3b6bc082e, []int{2}
}
func (m *AuditSinkSpec) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AuditSinkSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AuditSinkSpec.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AuditSinkSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AuditSinkSpec.Merge(m, src)
}
func (m *AuditSinkSpec) XXX_Size() int {
	return m.Size()
}
func (m *AuditSinkSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_AuditSinkSpec.DiscardUnknown(m)
}

var xxx_messageInfo_AuditSinkSpec proto.InternalMessageInfo

func (m *AuditSinkSpec) GetPolicy() *Policy {
	if m != nil {
		return m.Policy
	}
	return nil
}

func (m *AuditSinkSpec) GetWebhook() *Webhook {
	if m != nil {
		return m.Webhook
	}
	return nil
}

// Policy defines the configuration of how audit events are logged
type Policy struct {
	// The Level that all requests are recorded at.
	// available options: None, Metadata, Request, RequestResponse
	// required
	Level string `protobuf:"bytes,1,opt,name=level" json:"level"`
	// Stages is a list of stages for which events are created.
	// +optional
	Stages []string `protobuf:"bytes,2,rep,name=stages" json:"stages,omitempty"`
}

func (m *Policy) Reset()      { *m = Policy{} }
func (*Policy) ProtoMessage() {}
func (*Policy) Descriptor() ([]byte, []int) {
	return fileDescriptor_1af3dad3b6bc082e, []int{3}
}
func (m *Policy) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Policy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Policy.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Policy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Policy.Merge(m, src)
}
func (m *Policy) XXX_Size() int {
	return m.Size()
}
func (m *Policy) XXX_DiscardUnknown() {
	xxx_messageInfo_Policy.DiscardUnknown(m)
}

var xxx_messageInfo_Policy proto.InternalMessageInfo

func (m *Policy) GetLevel() string {
	if m != nil {
		return m.Level
	}
	return ""
}

func (m *Policy) GetStages() []string {
	if m != nil {
		return m.Stages
	}
	return nil
}

// ServiceReference holds a reference to Service.legacy.k8s.io
type ServiceReference struct {
	// `namespace` is the namespace of the service.
	// Required
	Namespace string `protobuf:"bytes,1,opt,name=namespace" json:"namespace"`
	// `name` is the name of the service.
	// Required
	Name string `protobuf:"bytes,2,opt,name=name" json:"name"`
	// `path` is an optional URL path which will be sent in any request to
	// this service.
	// +optional
	Path string `protobuf:"bytes,3,opt,name=path" json:"path"`
	// If specified, the port on the service that hosting webhook.
	// Default to 443 for backward compatibility.
	// `port` should be a valid port number (1-65535, inclusive).
	// +optional
	Port int32 `protobuf:"varint,4,opt,name=port" json:"port"`
}

func (m *ServiceReference) Reset()      { *m = ServiceReference{} }
func (*ServiceReference) ProtoMessage() {}
func (*ServiceReference) Descriptor() ([]byte, []int) {
	return fileDescriptor_1af3dad3b6bc082e, []int{4}
}
func (m *ServiceReference) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ServiceReference) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ServiceReference.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ServiceReference) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ServiceReference.Merge(m, src)
}
func (m *ServiceReference) XXX_Size() int {
	return m.Size()
}
func (m *ServiceReference) XXX_DiscardUnknown() {
	xxx_messageInfo_ServiceReference.DiscardUnknown(m)
}

var xxx_messageInfo_ServiceReference proto.InternalMessageInfo

func (m *ServiceReference) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *ServiceReference) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ServiceReference) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

func (m *ServiceReference) GetPort() int32 {
	if m != nil {
		return m.Port
	}
	return 0
}

// Webhook holds the configuration of the webhook
type Webhook struct {
	// Throttle holds the options for throttling the webhook
	// +optional
	Throttle *WebhookThrottleConfig `protobuf:"bytes,1,opt,name=throttle" json:"throttle,omitempty"`
	// ClientConfig holds the connection parameters for the webhook
	// required
	ClientConfig *WebhookClientConfig `protobuf:"bytes,2,opt,name=clientConfig" json:"clientConfig,omitempty"`
}

func (m *Webhook) Reset()      { *m = Webhook{} }
func (*Webhook) ProtoMessage() {}
func (*Webhook) Descriptor() ([]byte, []int) {
	return fileDescriptor_1af3dad3b6bc082e, []int{5}
}
func (m *Webhook) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Webhook) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Webhook.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Webhook) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Webhook.Merge(m, src)
}
func (m *Webhook) XXX_Size() int {
	return m.Size()
}
func (m *Webhook) XXX_DiscardUnknown() {
	xxx_messageInfo_Webhook.DiscardUnknown(m)
}

var xxx_messageInfo_Webhook proto.InternalMessageInfo

func (m *Webhook) GetThrottle() *WebhookThrottleConfig {
	if m != nil {
		return m.Throttle
	}
	return nil
}

func (m *Webhook) GetClientConfig() *WebhookClientConfig {
	if m != nil {
		return m.ClientConfig
	}
	return nil
}

// WebhookClientConfig contains the information to make a connection with the webhook
type WebhookClientConfig struct {
	// `url` gives the location of the webhook, in standard URL form
	// (`scheme://host:port/path`). Exactly one of `url` or `service`
	// must be specified.
	//
	// The `host` should not refer to a service running in the cluster; use
	// the `service` field instead. The host might be resolved via external
	// DNS in some apiservers (e.g., `kube-apiserver` cannot resolve
	// in-cluster DNS as that would be a layering violation). `host` may
	// also be an IP address.
	//
	// Please note that using `localhost` or `127.0.0.1` as a `host` is
	// risky unless you take great care to run this webhook on all hosts
	// which run an apiserver which might need to make calls to this
	// webhook. Such installs are likely to be non-portable, i.e., not easy
	// to turn up in a new cluster.
	//
	// The scheme must be "https"; the URL must begin with "https://".
	//
	// A path is optional, and if present may be any string permissible in
	// a URL. You may use the path to pass an arbitrary string to the
	// webhook, for example, a cluster identifier.
	//
	// Attempting to use a user or basic auth e.g. "user:password@" is not
	// allowed. Fragments ("#...") and query parameters ("?...") are not
	// allowed, either.
	//
	// +optional
	Url string `protobuf:"bytes,1,opt,name=url" json:"url"`
	// `service` is a reference to the service for this webhook. Either
	// `service` or `url` must be specified.
	//
	// If the webhook is running within the cluster, then you should use `service`.
	//
	// +optional
	Service *ServiceReference `protobuf:"bytes,2,opt,name=service" json:"service,omitempty"`
	// `caBundle` is a PEM encoded CA bundle which will be used to validate the webhook's server certificate.
	// If unspecified, system trust roots on the apiserver are used.
	// +optional
	CaBundle []byte `protobuf:"bytes,3,opt,name=caBundle" json:"caBundle"`
}

func (m *WebhookClientConfig) Reset()      { *m = WebhookClientConfig{} }
func (*WebhookClientConfig) ProtoMessage() {}
func (*WebhookClientConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_1af3dad3b6bc082e, []int{6}
}
func (m *WebhookClientConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *WebhookClientConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_WebhookClientConfig.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *WebhookClientConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WebhookClientConfig.Merge(m, src)
}
func (m *WebhookClientConfig) XXX_Size() int {
	return m.Size()
}
func (m *WebhookClientConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_WebhookClientConfig.DiscardUnknown(m)
}

var xxx_messageInfo_WebhookClientConfig proto.InternalMessageInfo

func (m *WebhookClientConfig) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

func (m *WebhookClientConfig) GetService() *ServiceReference {
	if m != nil {
		return m.Service
	}
	return nil
}

func (m *WebhookClientConfig) GetCaBundle() []byte {
	if m != nil {
		return m.CaBundle
	}
	return nil
}

// WebhookThrottleConfig holds the configuration for throttling events
type WebhookThrottleConfig struct {
	// ThrottleQPS maximum number of batches per second
	// default 10 QPS
	// +optional
	Qps int64 `protobuf:"varint,1,opt,name=qps" json:"qps"`
	// ThrottleBurst is the maximum number of events sent at the same moment
	// default 15 QPS
	// +optional
	Burst int64 `protobuf:"varint,2,opt,name=burst" json:"burst"`
}

func (m *WebhookThrottleConfig) Reset()      { *m = WebhookThrottleConfig{} }
func (*WebhookThrottleConfig) ProtoMessage() {}
func (*WebhookThrottleConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_1af3dad3b6bc082e, []int{7}
}
func (m *WebhookThrottleConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *WebhookThrottleConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_WebhookThrottleConfig.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *WebhookThrottleConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WebhookThrottleConfig.Merge(m, src)
}
func (m *WebhookThrottleConfig) XXX_Size() int {
	return m.Size()
}
func (m *WebhookThrottleConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_WebhookThrottleConfig.DiscardUnknown(m)
}

var xxx_messageInfo_WebhookThrottleConfig proto.InternalMessageInfo

func (m *WebhookThrottleConfig) GetQps() int64 {
	if m != nil {
		return m.Qps
	}
	return 0
}

func (m *WebhookThrottleConfig) GetBurst() int64 {
	if m != nil {
		return m.Burst
	}
	return 0
}

func init() {
	proto.RegisterType((*AuditSink)(nil), "k8s.io.api.auditregistration.v1alpha1.AuditSink")
	proto.RegisterType((*AuditSinkList)(nil), "k8s.io.api.auditregistration.v1alpha1.AuditSinkList")
	proto.RegisterType((*AuditSinkSpec)(nil), "k8s.io.api.auditregistration.v1alpha1.AuditSinkSpec")
	proto.RegisterType((*Policy)(nil), "k8s.io.api.auditregistration.v1alpha1.Policy")
	proto.RegisterType((*ServiceReference)(nil), "k8s.io.api.auditregistration.v1alpha1.ServiceReference")
	proto.RegisterType((*Webhook)(nil), "k8s.io.api.auditregistration.v1alpha1.Webhook")
	proto.RegisterType((*WebhookClientConfig)(nil), "k8s.io.api.auditregistration.v1alpha1.WebhookClientConfig")
	proto.RegisterType((*WebhookThrottleConfig)(nil), "k8s.io.api.auditregistration.v1alpha1.WebhookThrottleConfig")
}

func init() {
	proto.RegisterFile("k8s.io/api/auditregistration/v1alpha1/generated.proto", fileDescriptor_1af3dad3b6bc082e)
}

var fileDescriptor_1af3dad3b6bc082e = []byte{
	// 609 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x92, 0xcb, 0x6e, 0x13, 0x31,
	0x14, 0x86, 0xc7, 0x4d, 0x7a, 0x89, 0x29, 0x12, 0x32, 0xa2, 0x8a, 0xba, 0x30, 0xd1, 0x48, 0x48,
	0xdd, 0xe0, 0xa1, 0xa8, 0x5c, 0x84, 0xba, 0xa1, 0x15, 0xa8, 0x82, 0x22, 0x60, 0x8a, 0x04, 0x2b,
	0x24, 0x77, 0x72, 0x9a, 0x98, 0xcc, 0xc5, 0xb5, 0x9d, 0xa0, 0xee, 0x58, 0xf0, 0x00, 0x3c, 0x02,
	0x82, 0x0d, 0xef, 0xc1, 0xa6, 0xcb, 0x2e, 0xbb, 0x42, 0x74, 0xba, 0x61, 0xd9, 0x47, 0x40, 0x9e,
	0x5b, 0xdb, 0xa4, 0x88, 0xe9, 0x72, 0xfe, 0xe3, 0xff, 0xcb, 0xe7, 0xe3, 0xe0, 0x7b, 0x83, 0x87,
	0x9a, 0x89, 0xc4, 0xe3, 0x52, 0x78, 0x7c, 0xd8, 0x15, 0x46, 0x41, 0x4f, 0x68, 0xa3, 0xb8, 0x11,
	0x49, 0xec, 0x8d, 0x96, 0x79, 0x28, 0xfb, 0x7c, 0xd9, 0xeb, 0x41, 0x0c, 0x8a, 0x1b, 0xe8, 0x32,
	0xa9, 0x12, 0x93, 0x90, 0x5b, 0x79, 0x8d, 0x71, 0x29, 0xd8, 0x44, 0x8d, 0x95, 0xb5, 0xc5, 0x95,
	0x53, 0x7a, 0xc4, 0x83, 0xbe, 0x88, 0x41, 0xed, 0x79, 0x72, 0xd0, 0xb3, 0x81, 0xf6, 0x22, 0x30,
	0xdc, 0x1b, 0x4d, 0xc0, 0x17, 0xbd, 0x7f, 0xb5, 0xd4, 0x30, 0x36, 0x22, 0x82, 0x89, 0xc2, 0xfd,
	0xff, 0x15, 0x74, 0xd0, 0x87, 0x88, 0x8f, 0xf7, 0xdc, 0xef, 0x08, 0xb7, 0x1e, 0x5b, 0xfb, 0x2d,
	0x11, 0x0f, 0xc8, 0x26, 0x9e, 0xb3, 0x46, 0x5d, 0x6e, 0x78, 0x1b, 0x75, 0xd0, 0xd2, 0x95, 0xbb,
	0x77, 0xd8, 0xe9, 0x35, 0x2b, 0x30, 0x93, 0x83, 0x9e, 0x0d, 0x34, 0xb3, 0xa7, 0xd9, 0x68, 0x99,
	0xbd, 0xdc, 0xfe, 0x00, 0x81, 0x79, 0x01, 0x86, 0xfb, 0x15, 0x81, 0x6c, 0xe0, 0xa6, 0x96, 0x10,
	0xb4, 0xa7, 0x32, 0xd2, 0x0a, 0xab, 0xb5, 0x30, 0x56, 0xd9, 0x6c, 0x49, 0x08, 0xfc, 0x8c, 0x60,
	0x2d, 0xaf, 0x56, 0xf9, 0xa6, 0xd0, 0x86, 0x3c, 0x9b, 0x30, 0x65, 0xf5, 0x4c, 0x6d, 0x7b, 0xcc,
	0xf3, 0x29, 0x9e, 0x16, 0x06, 0x22, 0xdd, 0x9e, 0xea, 0x34, 0xc6, 0xae, 0x5c, 0x4b, 0xd4, 0xcf,
	0xeb, 0xee, 0xd7, 0xb3, 0x96, 0xd6, 0x9e, 0x3c, 0xc1, 0x33, 0x32, 0x09, 0x45, 0xb0, 0x57, 0x38,
	0xde, 0xae, 0x89, 0x7e, 0x95, 0x95, 0xfc, 0xa2, 0x4c, 0x36, 0xf0, 0xec, 0x47, 0xd8, 0xee, 0x27,
	0xc9, 0xa0, 0xd8, 0x25, 0xab, 0xc9, 0x79, 0x9b, 0xb7, 0xfc, 0xb2, 0xee, 0xae, 0xe2, 0x99, 0x9c,
	0x4d, 0x16, 0xf1, 0x74, 0x08, 0x23, 0x08, 0x33, 0xb3, 0xd6, 0x5a, 0x73, 0xff, 0xd7, 0x4d, 0xc7,
	0xcf, 0x23, 0xb2, 0x80, 0x67, 0xb4, 0xe1, 0x3d, 0xc8, 0x37, 0xd2, 0xf2, 0x8b, 0x2f, 0xf7, 0x33,
	0xc2, 0xd7, 0xb6, 0x40, 0x8d, 0x44, 0x00, 0x3e, 0xec, 0x80, 0x82, 0x38, 0x00, 0xe2, 0xe2, 0x56,
	0xcc, 0x23, 0xd0, 0x92, 0x07, 0x70, 0x0e, 0x76, 0x1a, 0x93, 0x36, 0x6e, 0xda, 0x8f, 0xcc, 0xbe,
	0x1c, 0x67, 0x89, 0x9d, 0x48, 0x6e, 0xfa, 0xed, 0xc6, 0xd9, 0x89, 0x4d, 0xb2, 0x49, 0xa2, 0x4c,
	0xbb, 0xd9, 0x41, 0x4b, 0xd3, 0xd5, 0x24, 0x51, 0xc6, 0xfd, 0x89, 0xf0, 0x6c, 0x71, 0x33, 0xf2,
	0x0e, 0xcf, 0x99, 0xbe, 0x4a, 0x8c, 0x09, 0xa1, 0xd8, 0xf1, 0xea, 0xe5, 0x76, 0xf3, 0xa6, 0x68,
	0xaf, 0x27, 0xf1, 0x8e, 0xe8, 0xf9, 0x15, 0x8d, 0xbc, 0xc7, 0xf3, 0x41, 0x28, 0x20, 0x36, 0xf9,
	0xa4, 0xd8, 0xfc, 0xa3, 0xcb, 0xd1, 0xd7, 0xcf, 0x10, 0xfc, 0x73, 0x3c, 0xf7, 0x1b, 0xc2, 0xd7,
	0x2f, 0x38, 0x45, 0x16, 0x70, 0x63, 0xa8, 0xce, 0x3f, 0x8b, 0x0d, 0xc8, 0x6b, 0x3c, 0xab, 0xf3,
	0xdd, 0x17, 0x2a, 0x0f, 0x6a, 0xaa, 0x8c, 0xbf, 0x98, 0x5f, 0x72, 0x48, 0x07, 0xcf, 0x05, 0x7c,
	0x6d, 0x18, 0x77, 0x43, 0xc8, 0x1e, 0x60, 0xbe, 0xf8, 0xbd, 0x2a, 0x75, 0x9f, 0xe3, 0x1b, 0x17,
	0xee, 0xc9, 0x5a, 0xee, 0x4a, 0x9d, 0x59, 0x36, 0x4a, 0xcb, 0x5d, 0xa9, 0xed, 0xdf, 0x6a, 0x7b,
	0xa8, 0xb4, 0xc9, 0x1c, 0xcb, 0x49, 0x1e, 0xad, 0xad, 0x1c, 0x1c, 0x51, 0xe7, 0xf0, 0x88, 0x3a,
	0x27, 0x47, 0x14, 0x7d, 0x4a, 0x29, 0xfa, 0x91, 0x52, 0xb4, 0x9f, 0x52, 0x74, 0x90, 0x52, 0xf4,
	0x3b, 0xa5, 0xe8, 0x4f, 0x4a, 0x9d, 0x93, 0x94, 0xa2, 0x2f, 0xc7, 0xd4, 0x39, 0x38, 0xa6, 0xce,
	0xe1, 0x31, 0x75, 0xfe, 0x06, 0x00, 0x00, 0xff, 0xff, 0x4d, 0x6e, 0x5f, 0x31, 0x9f, 0x05, 0x00,
	0x00,
}

func (this *AuditSink) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*AuditSink)
	if !ok {
		that2, ok := that.(AuditSink)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Metadata.Equal(that1.Metadata) {
		return false
	}
	if !this.Spec.Equal(that1.Spec) {
		return false
	}
	return true
}
func (this *AuditSinkList) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*AuditSinkList)
	if !ok {
		that2, ok := that.(AuditSinkList)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Metadata.Equal(that1.Metadata) {
		return false
	}
	if len(this.Items) != len(that1.Items) {
		return false
	}
	for i := range this.Items {
		if !this.Items[i].Equal(that1.Items[i]) {
			return false
		}
	}
	return true
}
func (this *AuditSinkSpec) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*AuditSinkSpec)
	if !ok {
		that2, ok := that.(AuditSinkSpec)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Policy.Equal(that1.Policy) {
		return false
	}
	if !this.Webhook.Equal(that1.Webhook) {
		return false
	}
	return true
}
func (this *Policy) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Policy)
	if !ok {
		that2, ok := that.(Policy)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Level != that1.Level {
		return false
	}
	if len(this.Stages) != len(that1.Stages) {
		return false
	}
	for i := range this.Stages {
		if this.Stages[i] != that1.Stages[i] {
			return false
		}
	}
	return true
}
func (this *ServiceReference) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ServiceReference)
	if !ok {
		that2, ok := that.(ServiceReference)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Namespace != that1.Namespace {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if this.Path != that1.Path {
		return false
	}
	if this.Port != that1.Port {
		return false
	}
	return true
}
func (this *Webhook) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Webhook)
	if !ok {
		that2, ok := that.(Webhook)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Throttle.Equal(that1.Throttle) {
		return false
	}
	if !this.ClientConfig.Equal(that1.ClientConfig) {
		return false
	}
	return true
}
func (this *WebhookClientConfig) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*WebhookClientConfig)
	if !ok {
		that2, ok := that.(WebhookClientConfig)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Url != that1.Url {
		return false
	}
	if !this.Service.Equal(that1.Service) {
		return false
	}
	if !bytes.Equal(this.CaBundle, that1.CaBundle) {
		return false
	}
	return true
}
func (this *WebhookThrottleConfig) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*WebhookThrottleConfig)
	if !ok {
		that2, ok := that.(WebhookThrottleConfig)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Qps != that1.Qps {
		return false
	}
	if this.Burst != that1.Burst {
		return false
	}
	return true
}
func (this *AuditSink) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&k8s_io_api_auditregistration_v1alpha1.AuditSink{")
	if this.Metadata != nil {
		s = append(s, "Metadata: "+fmt.Sprintf("%#v", this.Metadata)+",\n")
	}
	if this.Spec != nil {
		s = append(s, "Spec: "+fmt.Sprintf("%#v", this.Spec)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *AuditSinkList) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&k8s_io_api_auditregistration_v1alpha1.AuditSinkList{")
	if this.Metadata != nil {
		s = append(s, "Metadata: "+fmt.Sprintf("%#v", this.Metadata)+",\n")
	}
	if this.Items != nil {
		s = append(s, "Items: "+fmt.Sprintf("%#v", this.Items)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *AuditSinkSpec) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&k8s_io_api_auditregistration_v1alpha1.AuditSinkSpec{")
	if this.Policy != nil {
		s = append(s, "Policy: "+fmt.Sprintf("%#v", this.Policy)+",\n")
	}
	if this.Webhook != nil {
		s = append(s, "Webhook: "+fmt.Sprintf("%#v", this.Webhook)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Policy) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&k8s_io_api_auditregistration_v1alpha1.Policy{")
	s = append(s, "Level: "+fmt.Sprintf("%#v", this.Level)+",\n")
	if this.Stages != nil {
		s = append(s, "Stages: "+fmt.Sprintf("%#v", this.Stages)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ServiceReference) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&k8s_io_api_auditregistration_v1alpha1.ServiceReference{")
	s = append(s, "Namespace: "+fmt.Sprintf("%#v", this.Namespace)+",\n")
	s = append(s, "Name: "+fmt.Sprintf("%#v", this.Name)+",\n")
	s = append(s, "Path: "+fmt.Sprintf("%#v", this.Path)+",\n")
	s = append(s, "Port: "+fmt.Sprintf("%#v", this.Port)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Webhook) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&k8s_io_api_auditregistration_v1alpha1.Webhook{")
	if this.Throttle != nil {
		s = append(s, "Throttle: "+fmt.Sprintf("%#v", this.Throttle)+",\n")
	}
	if this.ClientConfig != nil {
		s = append(s, "ClientConfig: "+fmt.Sprintf("%#v", this.ClientConfig)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *WebhookClientConfig) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&k8s_io_api_auditregistration_v1alpha1.WebhookClientConfig{")
	s = append(s, "Url: "+fmt.Sprintf("%#v", this.Url)+",\n")
	if this.Service != nil {
		s = append(s, "Service: "+fmt.Sprintf("%#v", this.Service)+",\n")
	}
	s = append(s, "CaBundle: "+fmt.Sprintf("%#v", this.CaBundle)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *WebhookThrottleConfig) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&k8s_io_api_auditregistration_v1alpha1.WebhookThrottleConfig{")
	s = append(s, "Qps: "+fmt.Sprintf("%#v", this.Qps)+",\n")
	s = append(s, "Burst: "+fmt.Sprintf("%#v", this.Burst)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringGenerated(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}
func (m *AuditSink) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AuditSink) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AuditSink) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Spec != nil {
		{
			size, err := m.Spec.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Metadata != nil {
		{
			size, err := m.Metadata.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *AuditSinkList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AuditSinkList) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AuditSinkList) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Items) > 0 {
		for iNdEx := len(m.Items) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Items[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintGenerated(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.Metadata != nil {
		{
			size, err := m.Metadata.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *AuditSinkSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AuditSinkSpec) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AuditSinkSpec) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Webhook != nil {
		{
			size, err := m.Webhook.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Policy != nil {
		{
			size, err := m.Policy.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Policy) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Policy) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Policy) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Stages) > 0 {
		for iNdEx := len(m.Stages) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Stages[iNdEx])
			copy(dAtA[i:], m.Stages[iNdEx])
			i = encodeVarintGenerated(dAtA, i, uint64(len(m.Stages[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	i -= len(m.Level)
	copy(dAtA[i:], m.Level)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Level)))
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *ServiceReference) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ServiceReference) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ServiceReference) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	i = encodeVarintGenerated(dAtA, i, uint64(m.Port))
	i--
	dAtA[i] = 0x20
	i -= len(m.Path)
	copy(dAtA[i:], m.Path)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Path)))
	i--
	dAtA[i] = 0x1a
	i -= len(m.Name)
	copy(dAtA[i:], m.Name)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Name)))
	i--
	dAtA[i] = 0x12
	i -= len(m.Namespace)
	copy(dAtA[i:], m.Namespace)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Namespace)))
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *Webhook) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Webhook) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Webhook) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.ClientConfig != nil {
		{
			size, err := m.ClientConfig.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Throttle != nil {
		{
			size, err := m.Throttle.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *WebhookClientConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *WebhookClientConfig) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *WebhookClientConfig) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.CaBundle != nil {
		i -= len(m.CaBundle)
		copy(dAtA[i:], m.CaBundle)
		i = encodeVarintGenerated(dAtA, i, uint64(len(m.CaBundle)))
		i--
		dAtA[i] = 0x1a
	}
	if m.Service != nil {
		{
			size, err := m.Service.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	i -= len(m.Url)
	copy(dAtA[i:], m.Url)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Url)))
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *WebhookThrottleConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *WebhookThrottleConfig) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *WebhookThrottleConfig) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	i = encodeVarintGenerated(dAtA, i, uint64(m.Burst))
	i--
	dAtA[i] = 0x10
	i = encodeVarintGenerated(dAtA, i, uint64(m.Qps))
	i--
	dAtA[i] = 0x8
	return len(dAtA) - i, nil
}

func encodeVarintGenerated(dAtA []byte, offset int, v uint64) int {
	offset -= sovGenerated(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *AuditSink) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Metadata != nil {
		l = m.Metadata.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Spec != nil {
		l = m.Spec.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	return n
}

func (m *AuditSinkList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Metadata != nil {
		l = m.Metadata.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	return n
}

func (m *AuditSinkSpec) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Policy != nil {
		l = m.Policy.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Webhook != nil {
		l = m.Webhook.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	return n
}

func (m *Policy) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Level)
	n += 1 + l + sovGenerated(uint64(l))
	if len(m.Stages) > 0 {
		for _, s := range m.Stages {
			l = len(s)
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	return n
}

func (m *ServiceReference) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Namespace)
	n += 1 + l + sovGenerated(uint64(l))
	l = len(m.Name)
	n += 1 + l + sovGenerated(uint64(l))
	l = len(m.Path)
	n += 1 + l + sovGenerated(uint64(l))
	n += 1 + sovGenerated(uint64(m.Port))
	return n
}

func (m *Webhook) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Throttle != nil {
		l = m.Throttle.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.ClientConfig != nil {
		l = m.ClientConfig.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	return n
}

func (m *WebhookClientConfig) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Url)
	n += 1 + l + sovGenerated(uint64(l))
	if m.Service != nil {
		l = m.Service.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.CaBundle != nil {
		l = len(m.CaBundle)
		n += 1 + l + sovGenerated(uint64(l))
	}
	return n
}

func (m *WebhookThrottleConfig) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 1 + sovGenerated(uint64(m.Qps))
	n += 1 + sovGenerated(uint64(m.Burst))
	return n
}

func sovGenerated(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozGenerated(x uint64) (n int) {
	return sovGenerated(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *AuditSink) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&AuditSink{`,
		`Metadata:` + strings.Replace(fmt.Sprintf("%v", this.Metadata), "ObjectMeta", "v1.ObjectMeta", 1) + `,`,
		`Spec:` + strings.Replace(this.Spec.String(), "AuditSinkSpec", "AuditSinkSpec", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *AuditSinkList) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForItems := "[]*AuditSink{"
	for _, f := range this.Items {
		repeatedStringForItems += strings.Replace(f.String(), "AuditSink", "AuditSink", 1) + ","
	}
	repeatedStringForItems += "}"
	s := strings.Join([]string{`&AuditSinkList{`,
		`Metadata:` + strings.Replace(fmt.Sprintf("%v", this.Metadata), "ListMeta", "v1.ListMeta", 1) + `,`,
		`Items:` + repeatedStringForItems + `,`,
		`}`,
	}, "")
	return s
}
func (this *AuditSinkSpec) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&AuditSinkSpec{`,
		`Policy:` + strings.Replace(this.Policy.String(), "Policy", "Policy", 1) + `,`,
		`Webhook:` + strings.Replace(this.Webhook.String(), "Webhook", "Webhook", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Policy) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Policy{`,
		`Level:` + fmt.Sprintf("%v", this.Level) + `,`,
		`Stages:` + fmt.Sprintf("%v", this.Stages) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ServiceReference) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ServiceReference{`,
		`Namespace:` + fmt.Sprintf("%v", this.Namespace) + `,`,
		`Name:` + fmt.Sprintf("%v", this.Name) + `,`,
		`Path:` + fmt.Sprintf("%v", this.Path) + `,`,
		`Port:` + fmt.Sprintf("%v", this.Port) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Webhook) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Webhook{`,
		`Throttle:` + strings.Replace(this.Throttle.String(), "WebhookThrottleConfig", "WebhookThrottleConfig", 1) + `,`,
		`ClientConfig:` + strings.Replace(this.ClientConfig.String(), "WebhookClientConfig", "WebhookClientConfig", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *WebhookClientConfig) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&WebhookClientConfig{`,
		`Url:` + fmt.Sprintf("%v", this.Url) + `,`,
		`Service:` + strings.Replace(this.Service.String(), "ServiceReference", "ServiceReference", 1) + `,`,
		`CaBundle:` + fmt.Sprintf("%v", this.CaBundle) + `,`,
		`}`,
	}, "")
	return s
}
func (this *WebhookThrottleConfig) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&WebhookThrottleConfig{`,
		`Qps:` + fmt.Sprintf("%v", this.Qps) + `,`,
		`Burst:` + fmt.Sprintf("%v", this.Burst) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringGenerated(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *AuditSink) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AuditSink: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AuditSink: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metadata", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Metadata == nil {
				m.Metadata = &v1.ObjectMeta{}
			}
			if err := m.Metadata.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Spec", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Spec == nil {
				m.Spec = &AuditSinkSpec{}
			}
			if err := m.Spec.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AuditSinkList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AuditSinkList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AuditSinkList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metadata", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Metadata == nil {
				m.Metadata = &v1.ListMeta{}
			}
			if err := m.Metadata.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, &AuditSink{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AuditSinkSpec) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AuditSinkSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AuditSinkSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Policy", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Policy == nil {
				m.Policy = &Policy{}
			}
			if err := m.Policy.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Webhook", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Webhook == nil {
				m.Webhook = &Webhook{}
			}
			if err := m.Webhook.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Policy) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Policy: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Policy: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Level", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Level = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Stages", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Stages = append(m.Stages, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ServiceReference) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ServiceReference: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ServiceReference: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Namespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Namespace = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Path", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Path = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Port", wireType)
			}
			m.Port = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Port |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Webhook) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Webhook: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Webhook: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Throttle", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Throttle == nil {
				m.Throttle = &WebhookThrottleConfig{}
			}
			if err := m.Throttle.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClientConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ClientConfig == nil {
				m.ClientConfig = &WebhookClientConfig{}
			}
			if err := m.ClientConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *WebhookClientConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: WebhookClientConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: WebhookClientConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Url", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Url = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Service", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Service == nil {
				m.Service = &ServiceReference{}
			}
			if err := m.Service.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CaBundle", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CaBundle = append(m.CaBundle[:0], dAtA[iNdEx:postIndex]...)
			if m.CaBundle == nil {
				m.CaBundle = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *WebhookThrottleConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: WebhookThrottleConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: WebhookThrottleConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Qps", wireType)
			}
			m.Qps = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Qps |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Burst", wireType)
			}
			m.Burst = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Burst |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipGenerated(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthGenerated
			}
			iNdEx += length
			if iNdEx < 0 {
				return 0, ErrInvalidLengthGenerated
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowGenerated
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipGenerated(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
				if iNdEx < 0 {
					return 0, ErrInvalidLengthGenerated
				}
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthGenerated = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowGenerated   = fmt.Errorf("proto: integer overflow")
)
