// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: opencensus/proto/stats/v1/stats.proto

package opencensus_proto_stats_v1

import (
	encoding_binary "encoding/binary"
	fmt "fmt"
	proto "github.com/gogo/protobuf/proto"
	types "github.com/gogo/protobuf/types"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

type Measure_Type int32

const (
	// Unknown type.
	Measure_TYPE_UNSPECIFIED Measure_Type = 0
	// Indicates an int64 Measure.
	Measure_INT64 Measure_Type = 1
	// Indicates a double Measure.
	Measure_DOUBLE Measure_Type = 2
)

var Measure_Type_name = map[int32]string{
	0: "TYPE_UNSPECIFIED",
	1: "INT64",
	2: "DOUBLE",
}

var Measure_Type_value = map[string]int32{
	"TYPE_UNSPECIFIED": 0,
	"INT64":            1,
	"DOUBLE":           2,
}

func (x Measure_Type) String() string {
	return proto.EnumName(Measure_Type_name, int32(x))
}

func (Measure_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_5cb731b1ef81fd07, []int{1, 0}
}

// TODO(bdrutu): Consider if this should be moved to a "tags" directory to match the API structure.
type Tag struct {
	Key   string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	Value string `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (m *Tag) Reset()         { *m = Tag{} }
func (m *Tag) String() string { return proto.CompactTextString(m) }
func (*Tag) ProtoMessage()    {}
func (*Tag) Descriptor() ([]byte, []int) {
	return fileDescriptor_5cb731b1ef81fd07, []int{0}
}
func (m *Tag) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Tag) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Tag.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Tag) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Tag.Merge(m, src)
}
func (m *Tag) XXX_Size() int {
	return m.Size()
}
func (m *Tag) XXX_DiscardUnknown() {
	xxx_messageInfo_Tag.DiscardUnknown(m)
}

var xxx_messageInfo_Tag proto.InternalMessageInfo

func (m *Tag) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

func (m *Tag) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

// Measure .
type Measure struct {
	// A string by which the measure will be referred to, e.g. "rpc_server_latency". Names MUST be
	// unique within the library.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Describes the measure, e.g. "RPC latency in seconds".
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Describes the unit used for the Measure. Follows the format described by
	// http://unitsofmeasure.org/ucum.html.
	Unit string `protobuf:"bytes,3,opt,name=unit,proto3" json:"unit,omitempty"`
	// The type used for this Measure.
	Type Measure_Type `protobuf:"varint,4,opt,name=type,proto3,enum=opencensus.proto.stats.v1.Measure_Type" json:"type,omitempty"`
}

func (m *Measure) Reset()         { *m = Measure{} }
func (m *Measure) String() string { return proto.CompactTextString(m) }
func (*Measure) ProtoMessage()    {}
func (*Measure) Descriptor() ([]byte, []int) {
	return fileDescriptor_5cb731b1ef81fd07, []int{1}
}
func (m *Measure) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Measure) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Measure.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Measure) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Measure.Merge(m, src)
}
func (m *Measure) XXX_Size() int {
	return m.Size()
}
func (m *Measure) XXX_DiscardUnknown() {
	xxx_messageInfo_Measure.DiscardUnknown(m)
}

var xxx_messageInfo_Measure proto.InternalMessageInfo

func (m *Measure) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Measure) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Measure) GetUnit() string {
	if m != nil {
		return m.Unit
	}
	return ""
}

func (m *Measure) GetType() Measure_Type {
	if m != nil {
		return m.Type
	}
	return Measure_TYPE_UNSPECIFIED
}

type View struct {
	// A string by which the View will be referred to, e.g. "rpc_latency". Names MUST be unique
	// within the library.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Describes the view, e.g. "RPC latency distribution"
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// The Measure to which this view is applied.
	Measure *Measure `protobuf:"bytes,3,opt,name=measure,proto3" json:"measure,omitempty"`
	// An array of tag keys. These values associated with tags of this name form the basis by which
	// individual stats will be aggregated (one aggregation per unique tag value). If none are
	// provided, then all data is recorded in a single aggregation.
	Columns []string `protobuf:"bytes,4,rep,name=columns,proto3" json:"columns,omitempty"`
	// The description of the aggregation used for this view which describes how data collected are
	// aggregated.
	//
	// Types that are valid to be assigned to Aggregation:
	//	*View_CountAggregation
	//	*View_SumAggregation
	//	*View_LastValueAggregation
	//	*View_DistributionAggregation
	Aggregation isView_Aggregation `protobuf_oneof:"aggregation"`
}

func (m *View) Reset()         { *m = View{} }
func (m *View) String() string { return proto.CompactTextString(m) }
func (*View) ProtoMessage()    {}
func (*View) Descriptor() ([]byte, []int) {
	return fileDescriptor_5cb731b1ef81fd07, []int{2}
}
func (m *View) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *View) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_View.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *View) XXX_Merge(src proto.Message) {
	xxx_messageInfo_View.Merge(m, src)
}
func (m *View) XXX_Size() int {
	return m.Size()
}
func (m *View) XXX_DiscardUnknown() {
	xxx_messageInfo_View.DiscardUnknown(m)
}

var xxx_messageInfo_View proto.InternalMessageInfo

type isView_Aggregation interface {
	isView_Aggregation()
	MarshalTo([]byte) (int, error)
	Size() int
}

type View_CountAggregation struct {
	CountAggregation *CountAggregation `protobuf:"bytes,5,opt,name=count_aggregation,json=countAggregation,proto3,oneof"`
}
type View_SumAggregation struct {
	SumAggregation *SumAggregation `protobuf:"bytes,6,opt,name=sum_aggregation,json=sumAggregation,proto3,oneof"`
}
type View_LastValueAggregation struct {
	LastValueAggregation *LastValueAggregation `protobuf:"bytes,7,opt,name=last_value_aggregation,json=lastValueAggregation,proto3,oneof"`
}
type View_DistributionAggregation struct {
	DistributionAggregation *DistributionAggregation `protobuf:"bytes,8,opt,name=distribution_aggregation,json=distributionAggregation,proto3,oneof"`
}

func (*View_CountAggregation) isView_Aggregation()        {}
func (*View_SumAggregation) isView_Aggregation()          {}
func (*View_LastValueAggregation) isView_Aggregation()    {}
func (*View_DistributionAggregation) isView_Aggregation() {}

func (m *View) GetAggregation() isView_Aggregation {
	if m != nil {
		return m.Aggregation
	}
	return nil
}

func (m *View) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *View) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *View) GetMeasure() *Measure {
	if m != nil {
		return m.Measure
	}
	return nil
}

func (m *View) GetColumns() []string {
	if m != nil {
		return m.Columns
	}
	return nil
}

func (m *View) GetCountAggregation() *CountAggregation {
	if x, ok := m.GetAggregation().(*View_CountAggregation); ok {
		return x.CountAggregation
	}
	return nil
}

func (m *View) GetSumAggregation() *SumAggregation {
	if x, ok := m.GetAggregation().(*View_SumAggregation); ok {
		return x.SumAggregation
	}
	return nil
}

func (m *View) GetLastValueAggregation() *LastValueAggregation {
	if x, ok := m.GetAggregation().(*View_LastValueAggregation); ok {
		return x.LastValueAggregation
	}
	return nil
}

func (m *View) GetDistributionAggregation() *DistributionAggregation {
	if x, ok := m.GetAggregation().(*View_DistributionAggregation); ok {
		return x.DistributionAggregation
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*View) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*View_CountAggregation)(nil),
		(*View_SumAggregation)(nil),
		(*View_LastValueAggregation)(nil),
		(*View_DistributionAggregation)(nil),
	}
}

type CountAggregation struct {
}

func (m *CountAggregation) Reset()         { *m = CountAggregation{} }
func (m *CountAggregation) String() string { return proto.CompactTextString(m) }
func (*CountAggregation) ProtoMessage()    {}
func (*CountAggregation) Descriptor() ([]byte, []int) {
	return fileDescriptor_5cb731b1ef81fd07, []int{3}
}
func (m *CountAggregation) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CountAggregation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CountAggregation.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CountAggregation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CountAggregation.Merge(m, src)
}
func (m *CountAggregation) XXX_Size() int {
	return m.Size()
}
func (m *CountAggregation) XXX_DiscardUnknown() {
	xxx_messageInfo_CountAggregation.DiscardUnknown(m)
}

var xxx_messageInfo_CountAggregation proto.InternalMessageInfo

type SumAggregation struct {
}

func (m *SumAggregation) Reset()         { *m = SumAggregation{} }
func (m *SumAggregation) String() string { return proto.CompactTextString(m) }
func (*SumAggregation) ProtoMessage()    {}
func (*SumAggregation) Descriptor() ([]byte, []int) {
	return fileDescriptor_5cb731b1ef81fd07, []int{4}
}
func (m *SumAggregation) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SumAggregation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SumAggregation.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SumAggregation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SumAggregation.Merge(m, src)
}
func (m *SumAggregation) XXX_Size() int {
	return m.Size()
}
func (m *SumAggregation) XXX_DiscardUnknown() {
	xxx_messageInfo_SumAggregation.DiscardUnknown(m)
}

var xxx_messageInfo_SumAggregation proto.InternalMessageInfo

type LastValueAggregation struct {
}

func (m *LastValueAggregation) Reset()         { *m = LastValueAggregation{} }
func (m *LastValueAggregation) String() string { return proto.CompactTextString(m) }
func (*LastValueAggregation) ProtoMessage()    {}
func (*LastValueAggregation) Descriptor() ([]byte, []int) {
	return fileDescriptor_5cb731b1ef81fd07, []int{5}
}
func (m *LastValueAggregation) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LastValueAggregation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_LastValueAggregation.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *LastValueAggregation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LastValueAggregation.Merge(m, src)
}
func (m *LastValueAggregation) XXX_Size() int {
	return m.Size()
}
func (m *LastValueAggregation) XXX_DiscardUnknown() {
	xxx_messageInfo_LastValueAggregation.DiscardUnknown(m)
}

var xxx_messageInfo_LastValueAggregation proto.InternalMessageInfo

type DistributionAggregation struct {
	// A Distribution may optionally contain a histogram of the values in the
	// population. The bucket boundaries for that histogram are described by
	// `bucket_bounds`. This defines `size(bucket_bounds) + 1` (= N)
	// buckets. The boundaries for bucket index i are:
	//
	// (-infinity, bucket_bounds[i]) for i == 0
	// [bucket_bounds[i-1], bucket_bounds[i]) for 0 < i < N-2
	// [bucket_bounds[i-1], +infinity) for i == N-1
	//
	// i.e. an underflow bucket (number 0), zero or more finite buckets (1
	// through N - 2, and an overflow bucket (N - 1), with inclusive lower
	// bounds and exclusive upper bounds.
	//
	// If `bucket_bounds` has no elements (zero size), then there is no
	// histogram associated with the Distribution. If `bucket_bounds` has only
	// one element, there are no finite buckets, and that single element is the
	// common boundary of the overflow and underflow buckets. The values must
	// be monotonically increasing.
	BucketBounds []float64 `protobuf:"fixed64,1,rep,packed,name=bucket_bounds,json=bucketBounds,proto3" json:"bucket_bounds,omitempty"`
}

func (m *DistributionAggregation) Reset()         { *m = DistributionAggregation{} }
func (m *DistributionAggregation) String() string { return proto.CompactTextString(m) }
func (*DistributionAggregation) ProtoMessage()    {}
func (*DistributionAggregation) Descriptor() ([]byte, []int) {
	return fileDescriptor_5cb731b1ef81fd07, []int{6}
}
func (m *DistributionAggregation) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DistributionAggregation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DistributionAggregation.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DistributionAggregation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DistributionAggregation.Merge(m, src)
}
func (m *DistributionAggregation) XXX_Size() int {
	return m.Size()
}
func (m *DistributionAggregation) XXX_DiscardUnknown() {
	xxx_messageInfo_DistributionAggregation.DiscardUnknown(m)
}

var xxx_messageInfo_DistributionAggregation proto.InternalMessageInfo

func (m *DistributionAggregation) GetBucketBounds() []float64 {
	if m != nil {
		return m.BucketBounds
	}
	return nil
}

// Describes a data point to be collected for a Measure.
type Measurement struct {
	Tags []*Tag `protobuf:"bytes,1,rep,name=tags,proto3" json:"tags,omitempty"`
	// The name of the measure to which the value is applied.
	MeasureName string `protobuf:"bytes,2,opt,name=measure_name,json=measureName,proto3" json:"measure_name,omitempty"`
	// The recorded value, MUST have the appropriate type to match the Measure.
	//
	// Types that are valid to be assigned to Value:
	//	*Measurement_DoubleValue
	//	*Measurement_IntValue
	Value isMeasurement_Value `protobuf_oneof:"value"`
	// The time when this measurement was recorded. If the implementation uses a async buffer to
	// record measurements this may be the time when the measurement was read from the buffer.
	Time *types.Timestamp `protobuf:"bytes,5,opt,name=time,proto3" json:"time,omitempty"`
}

func (m *Measurement) Reset()         { *m = Measurement{} }
func (m *Measurement) String() string { return proto.CompactTextString(m) }
func (*Measurement) ProtoMessage()    {}
func (*Measurement) Descriptor() ([]byte, []int) {
	return fileDescriptor_5cb731b1ef81fd07, []int{7}
}
func (m *Measurement) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Measurement) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Measurement.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Measurement) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Measurement.Merge(m, src)
}
func (m *Measurement) XXX_Size() int {
	return m.Size()
}
func (m *Measurement) XXX_DiscardUnknown() {
	xxx_messageInfo_Measurement.DiscardUnknown(m)
}

var xxx_messageInfo_Measurement proto.InternalMessageInfo

type isMeasurement_Value interface {
	isMeasurement_Value()
	MarshalTo([]byte) (int, error)
	Size() int
}

type Measurement_DoubleValue struct {
	DoubleValue float64 `protobuf:"fixed64,3,opt,name=double_value,json=doubleValue,proto3,oneof"`
}
type Measurement_IntValue struct {
	IntValue int64 `protobuf:"varint,4,opt,name=int_value,json=intValue,proto3,oneof"`
}

func (*Measurement_DoubleValue) isMeasurement_Value() {}
func (*Measurement_IntValue) isMeasurement_Value()    {}

func (m *Measurement) GetValue() isMeasurement_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *Measurement) GetTags() []*Tag {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *Measurement) GetMeasureName() string {
	if m != nil {
		return m.MeasureName
	}
	return ""
}

func (m *Measurement) GetDoubleValue() float64 {
	if x, ok := m.GetValue().(*Measurement_DoubleValue); ok {
		return x.DoubleValue
	}
	return 0
}

func (m *Measurement) GetIntValue() int64 {
	if x, ok := m.GetValue().(*Measurement_IntValue); ok {
		return x.IntValue
	}
	return 0
}

func (m *Measurement) GetTime() *types.Timestamp {
	if m != nil {
		return m.Time
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Measurement) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Measurement_DoubleValue)(nil),
		(*Measurement_IntValue)(nil),
	}
}

func init() {
	proto.RegisterEnum("opencensus.proto.stats.v1.Measure_Type", Measure_Type_name, Measure_Type_value)
	proto.RegisterType((*Tag)(nil), "opencensus.proto.stats.v1.Tag")
	proto.RegisterType((*Measure)(nil), "opencensus.proto.stats.v1.Measure")
	proto.RegisterType((*View)(nil), "opencensus.proto.stats.v1.View")
	proto.RegisterType((*CountAggregation)(nil), "opencensus.proto.stats.v1.CountAggregation")
	proto.RegisterType((*SumAggregation)(nil), "opencensus.proto.stats.v1.SumAggregation")
	proto.RegisterType((*LastValueAggregation)(nil), "opencensus.proto.stats.v1.LastValueAggregation")
	proto.RegisterType((*DistributionAggregation)(nil), "opencensus.proto.stats.v1.DistributionAggregation")
	proto.RegisterType((*Measurement)(nil), "opencensus.proto.stats.v1.Measurement")
}

func init() {
	proto.RegisterFile("opencensus/proto/stats/v1/stats.proto", fileDescriptor_5cb731b1ef81fd07)
}

var fileDescriptor_5cb731b1ef81fd07 = []byte{
	// 648 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x54, 0xd1, 0x4e, 0x13, 0x4d,
	0x14, 0xde, 0xa1, 0x0b, 0xa5, 0xa7, 0xc0, 0xbf, 0xff, 0xa4, 0x81, 0x85, 0xe8, 0x5a, 0x97, 0x18,
	0x6b, 0x8c, 0xdb, 0x50, 0x8c, 0x37, 0x1a, 0x13, 0x0b, 0x35, 0x90, 0x20, 0x34, 0xcb, 0x42, 0xa2,
	0x37, 0x75, 0xdb, 0x8e, 0x9b, 0x0d, 0xdd, 0x99, 0x4d, 0x67, 0x06, 0xc3, 0x5b, 0xf8, 0x26, 0x3e,
	0x85, 0x89, 0x97, 0x5c, 0x7a, 0xa9, 0x70, 0xe7, 0x53, 0x98, 0x9d, 0xd9, 0x06, 0x96, 0x40, 0x4d,
	0xbc, 0x3b, 0xe7, 0x9b, 0xf3, 0x9d, 0x6f, 0xce, 0xce, 0xb7, 0x07, 0x1e, 0xb1, 0x94, 0xd0, 0x01,
	0xa1, 0x5c, 0xf2, 0x66, 0x3a, 0x66, 0x82, 0x35, 0xb9, 0x08, 0x05, 0x6f, 0x9e, 0x6e, 0xe8, 0xc0,
	0x53, 0x20, 0x5e, 0xbd, 0x2a, 0xd3, 0x88, 0xa7, 0x4f, 0x4f, 0x37, 0xd6, 0x1e, 0x44, 0x8c, 0x45,
	0x23, 0xa2, 0xd9, 0x7d, 0xf9, 0xa9, 0x29, 0xe2, 0x84, 0x70, 0x11, 0x26, 0xa9, 0xae, 0x74, 0x9f,
	0x41, 0x29, 0x08, 0x23, 0x6c, 0x41, 0xe9, 0x84, 0x9c, 0xd9, 0xa8, 0x8e, 0x1a, 0x15, 0x3f, 0x0b,
	0x71, 0x0d, 0x66, 0x4f, 0xc3, 0x91, 0x24, 0xf6, 0x8c, 0xc2, 0x74, 0xe2, 0x7e, 0x43, 0x50, 0x7e,
	0x47, 0x42, 0x2e, 0xc7, 0x04, 0x63, 0x30, 0x69, 0x98, 0x90, 0x9c, 0xa4, 0x62, 0x5c, 0x87, 0xea,
	0x90, 0xf0, 0xc1, 0x38, 0x4e, 0x45, 0xcc, 0x68, 0xce, 0xbd, 0x0e, 0x65, 0x2c, 0x49, 0x63, 0x61,
	0x97, 0x34, 0x2b, 0x8b, 0xf1, 0x4b, 0x30, 0xc5, 0x59, 0x4a, 0x6c, 0xb3, 0x8e, 0x1a, 0x4b, 0xad,
	0xc7, 0xde, 0x9d, 0xf3, 0x78, 0xb9, 0xb6, 0x17, 0x9c, 0xa5, 0xc4, 0x57, 0x24, 0x77, 0x13, 0xcc,
	0x2c, 0xc3, 0x35, 0xb0, 0x82, 0xf7, 0xdd, 0x4e, 0xef, 0x68, 0xff, 0xb0, 0xdb, 0xd9, 0xda, 0x7d,
	0xbb, 0xdb, 0xd9, 0xb6, 0x0c, 0x5c, 0x81, 0xd9, 0xdd, 0xfd, 0xe0, 0xc5, 0x73, 0x0b, 0x61, 0x80,
	0xb9, 0xed, 0x83, 0xa3, 0xf6, 0x5e, 0xc7, 0x9a, 0x71, 0xbf, 0x9a, 0x60, 0x1e, 0xc7, 0xe4, 0xf3,
	0x3f, 0x0e, 0xf1, 0x0a, 0xca, 0x89, 0xbe, 0x89, 0x9a, 0xa3, 0xda, 0x72, 0xff, 0x7e, 0x67, 0x7f,
	0x42, 0xc1, 0x36, 0x94, 0x07, 0x6c, 0x24, 0x13, 0xca, 0x6d, 0xb3, 0x5e, 0x6a, 0x54, 0xfc, 0x49,
	0x8a, 0x3f, 0xc0, 0xff, 0x03, 0x26, 0xa9, 0xe8, 0x85, 0x51, 0x34, 0x26, 0x51, 0xa8, 0xf4, 0x67,
	0x95, 0xc2, 0xd3, 0x29, 0x0a, 0x5b, 0x19, 0xe7, 0xcd, 0x15, 0x65, 0xc7, 0xf0, 0xad, 0xc1, 0x0d,
	0x0c, 0x07, 0xf0, 0x1f, 0x97, 0x49, 0xa1, 0xf3, 0x9c, 0xea, 0xfc, 0x64, 0x4a, 0xe7, 0x43, 0x99,
	0x14, 0xfb, 0x2e, 0xf1, 0x02, 0x82, 0x23, 0x58, 0x1e, 0x85, 0x5c, 0xf4, 0x94, 0x3d, 0x0a, 0xcd,
	0xcb, 0xaa, 0x79, 0x73, 0x4a, 0xf3, 0xbd, 0x90, 0x8b, 0xe3, 0x8c, 0x57, 0x94, 0xa8, 0x8d, 0x6e,
	0xc1, 0x31, 0x03, 0x7b, 0x18, 0x73, 0x31, 0x8e, 0xfb, 0x32, 0xcb, 0x0b, 0x52, 0xf3, 0x4a, 0xaa,
	0x35, 0x45, 0x6a, 0xfb, 0x1a, 0xb5, 0xa8, 0xb6, 0x32, 0xbc, 0xfd, 0xa8, 0xbd, 0x08, 0xd5, 0x6b,
	0x1a, 0x2e, 0x06, 0xeb, 0xe6, 0x67, 0x76, 0x2d, 0x58, 0x2a, 0x7e, 0x20, 0x77, 0x19, 0x6a, 0xb7,
	0x4d, 0xe5, 0xbe, 0x86, 0x95, 0x3b, 0xae, 0x80, 0xd7, 0x61, 0xb1, 0x2f, 0x07, 0x27, 0x44, 0xf4,
	0xfa, 0x4c, 0xd2, 0x21, 0xb7, 0x51, 0xbd, 0xd4, 0x40, 0xfe, 0x82, 0x06, 0xdb, 0x0a, 0x73, 0x7f,
	0x21, 0xa8, 0xe6, 0x3e, 0x4a, 0x08, 0x15, 0xb8, 0x05, 0xa6, 0x08, 0x23, 0x5d, 0x5b, 0x6d, 0x39,
	0x53, 0x26, 0x0f, 0xc2, 0xc8, 0x57, 0xb5, 0xf8, 0x21, 0x2c, 0xe4, 0x0e, 0xec, 0x29, 0xcb, 0xe7,
	0xbe, 0xce, 0xb1, 0xfd, 0xcc, 0xf9, 0xeb, 0xb0, 0x30, 0x64, 0xb2, 0x3f, 0x22, 0xfa, 0x3d, 0x95,
	0xb9, 0xd1, 0x8e, 0xe1, 0x57, 0x35, 0xaa, 0xc6, 0xc2, 0xf7, 0xa1, 0x12, 0xd3, 0xfc, 0xc5, 0xd5,
	0x2f, 0x5b, 0xda, 0x31, 0xfc, 0xf9, 0x98, 0xea, 0xa9, 0xb1, 0x07, 0x66, 0xb6, 0x64, 0x72, 0xdb,
	0xae, 0x79, 0x7a, 0x03, 0x79, 0x93, 0x0d, 0xe4, 0x05, 0x93, 0x0d, 0xe4, 0xab, 0xba, 0x76, 0x39,
	0x5f, 0x34, 0xed, 0x8f, 0xdf, 0x2f, 0x1c, 0x74, 0x7e, 0xe1, 0xa0, 0x9f, 0x17, 0x0e, 0xfa, 0x72,
	0xe9, 0x18, 0xe7, 0x97, 0x8e, 0xf1, 0xe3, 0xd2, 0x31, 0xe0, 0x5e, 0xcc, 0xee, 0x9e, 0xb0, 0x0d,
	0x87, 0x59, 0xd4, 0xcd, 0xc0, 0x2e, 0xfa, 0x3d, 0xb3, 0x7a, 0x90, 0x12, 0xba, 0xa5, 0x2b, 0x15,
	0xe8, 0xa9, 0x73, 0xef, 0x78, 0xa3, 0x3f, 0xa7, 0x98, 0x9b, 0x7f, 0x02, 0x00, 0x00, 0xff, 0xff,
	0x25, 0x27, 0x89, 0xb5, 0x58, 0x05, 0x00, 0x00,
}

func (m *Tag) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Tag) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Tag) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Value) > 0 {
		i -= len(m.Value)
		copy(dAtA[i:], m.Value)
		i = encodeVarintStats(dAtA, i, uint64(len(m.Value)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Key) > 0 {
		i -= len(m.Key)
		copy(dAtA[i:], m.Key)
		i = encodeVarintStats(dAtA, i, uint64(len(m.Key)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Measure) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Measure) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Measure) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Type != 0 {
		i = encodeVarintStats(dAtA, i, uint64(m.Type))
		i--
		dAtA[i] = 0x20
	}
	if len(m.Unit) > 0 {
		i -= len(m.Unit)
		copy(dAtA[i:], m.Unit)
		i = encodeVarintStats(dAtA, i, uint64(len(m.Unit)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Description) > 0 {
		i -= len(m.Description)
		copy(dAtA[i:], m.Description)
		i = encodeVarintStats(dAtA, i, uint64(len(m.Description)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintStats(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *View) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *View) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *View) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Aggregation != nil {
		{
			size := m.Aggregation.Size()
			i -= size
			if _, err := m.Aggregation.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	if len(m.Columns) > 0 {
		for iNdEx := len(m.Columns) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Columns[iNdEx])
			copy(dAtA[i:], m.Columns[iNdEx])
			i = encodeVarintStats(dAtA, i, uint64(len(m.Columns[iNdEx])))
			i--
			dAtA[i] = 0x22
		}
	}
	if m.Measure != nil {
		{
			size, err := m.Measure.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintStats(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Description) > 0 {
		i -= len(m.Description)
		copy(dAtA[i:], m.Description)
		i = encodeVarintStats(dAtA, i, uint64(len(m.Description)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintStats(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *View_CountAggregation) MarshalTo(dAtA []byte) (int, error) {
	return m.MarshalToSizedBuffer(dAtA[:m.Size()])
}

func (m *View_CountAggregation) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.CountAggregation != nil {
		{
			size, err := m.CountAggregation.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintStats(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	return len(dAtA) - i, nil
}
func (m *View_SumAggregation) MarshalTo(dAtA []byte) (int, error) {
	return m.MarshalToSizedBuffer(dAtA[:m.Size()])
}

func (m *View_SumAggregation) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.SumAggregation != nil {
		{
			size, err := m.SumAggregation.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintStats(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	return len(dAtA) - i, nil
}
func (m *View_LastValueAggregation) MarshalTo(dAtA []byte) (int, error) {
	return m.MarshalToSizedBuffer(dAtA[:m.Size()])
}

func (m *View_LastValueAggregation) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.LastValueAggregation != nil {
		{
			size, err := m.LastValueAggregation.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintStats(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	return len(dAtA) - i, nil
}
func (m *View_DistributionAggregation) MarshalTo(dAtA []byte) (int, error) {
	return m.MarshalToSizedBuffer(dAtA[:m.Size()])
}

func (m *View_DistributionAggregation) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.DistributionAggregation != nil {
		{
			size, err := m.DistributionAggregation.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintStats(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x42
	}
	return len(dAtA) - i, nil
}
func (m *CountAggregation) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CountAggregation) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CountAggregation) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func (m *SumAggregation) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SumAggregation) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SumAggregation) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func (m *LastValueAggregation) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LastValueAggregation) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *LastValueAggregation) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func (m *DistributionAggregation) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DistributionAggregation) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DistributionAggregation) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.BucketBounds) > 0 {
		for iNdEx := len(m.BucketBounds) - 1; iNdEx >= 0; iNdEx-- {
			f6 := math.Float64bits(float64(m.BucketBounds[iNdEx]))
			i -= 8
			encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(f6))
		}
		i = encodeVarintStats(dAtA, i, uint64(len(m.BucketBounds)*8))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Measurement) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Measurement) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Measurement) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Time != nil {
		{
			size, err := m.Time.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintStats(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if m.Value != nil {
		{
			size := m.Value.Size()
			i -= size
			if _, err := m.Value.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	if len(m.MeasureName) > 0 {
		i -= len(m.MeasureName)
		copy(dAtA[i:], m.MeasureName)
		i = encodeVarintStats(dAtA, i, uint64(len(m.MeasureName)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Tags) > 0 {
		for iNdEx := len(m.Tags) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Tags[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintStats(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *Measurement_DoubleValue) MarshalTo(dAtA []byte) (int, error) {
	return m.MarshalToSizedBuffer(dAtA[:m.Size()])
}

func (m *Measurement_DoubleValue) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i -= 8
	encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.DoubleValue))))
	i--
	dAtA[i] = 0x19
	return len(dAtA) - i, nil
}
func (m *Measurement_IntValue) MarshalTo(dAtA []byte) (int, error) {
	return m.MarshalToSizedBuffer(dAtA[:m.Size()])
}

func (m *Measurement_IntValue) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i = encodeVarintStats(dAtA, i, uint64(m.IntValue))
	i--
	dAtA[i] = 0x20
	return len(dAtA) - i, nil
}
func encodeVarintStats(dAtA []byte, offset int, v uint64) int {
	offset -= sovStats(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *Tag) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Key)
	if l > 0 {
		n += 1 + l + sovStats(uint64(l))
	}
	l = len(m.Value)
	if l > 0 {
		n += 1 + l + sovStats(uint64(l))
	}
	return n
}

func (m *Measure) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovStats(uint64(l))
	}
	l = len(m.Description)
	if l > 0 {
		n += 1 + l + sovStats(uint64(l))
	}
	l = len(m.Unit)
	if l > 0 {
		n += 1 + l + sovStats(uint64(l))
	}
	if m.Type != 0 {
		n += 1 + sovStats(uint64(m.Type))
	}
	return n
}

func (m *View) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovStats(uint64(l))
	}
	l = len(m.Description)
	if l > 0 {
		n += 1 + l + sovStats(uint64(l))
	}
	if m.Measure != nil {
		l = m.Measure.Size()
		n += 1 + l + sovStats(uint64(l))
	}
	if len(m.Columns) > 0 {
		for _, s := range m.Columns {
			l = len(s)
			n += 1 + l + sovStats(uint64(l))
		}
	}
	if m.Aggregation != nil {
		n += m.Aggregation.Size()
	}
	return n
}

func (m *View_CountAggregation) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.CountAggregation != nil {
		l = m.CountAggregation.Size()
		n += 1 + l + sovStats(uint64(l))
	}
	return n
}
func (m *View_SumAggregation) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.SumAggregation != nil {
		l = m.SumAggregation.Size()
		n += 1 + l + sovStats(uint64(l))
	}
	return n
}
func (m *View_LastValueAggregation) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.LastValueAggregation != nil {
		l = m.LastValueAggregation.Size()
		n += 1 + l + sovStats(uint64(l))
	}
	return n
}
func (m *View_DistributionAggregation) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.DistributionAggregation != nil {
		l = m.DistributionAggregation.Size()
		n += 1 + l + sovStats(uint64(l))
	}
	return n
}
func (m *CountAggregation) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *SumAggregation) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *LastValueAggregation) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *DistributionAggregation) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.BucketBounds) > 0 {
		n += 1 + sovStats(uint64(len(m.BucketBounds)*8)) + len(m.BucketBounds)*8
	}
	return n
}

func (m *Measurement) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Tags) > 0 {
		for _, e := range m.Tags {
			l = e.Size()
			n += 1 + l + sovStats(uint64(l))
		}
	}
	l = len(m.MeasureName)
	if l > 0 {
		n += 1 + l + sovStats(uint64(l))
	}
	if m.Value != nil {
		n += m.Value.Size()
	}
	if m.Time != nil {
		l = m.Time.Size()
		n += 1 + l + sovStats(uint64(l))
	}
	return n
}

func (m *Measurement_DoubleValue) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 9
	return n
}
func (m *Measurement_IntValue) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 1 + sovStats(uint64(m.IntValue))
	return n
}

func sovStats(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozStats(x uint64) (n int) {
	return sovStats(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *Tag) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStats
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Tag: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Tag: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStats
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthStats
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStats
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthStats
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStats(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStats
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthStats
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Measure) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStats
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Measure: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Measure: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStats
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthStats
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Description", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStats
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthStats
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Description = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Unit", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStats
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthStats
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Unit = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= Measure_Type(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipStats(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStats
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthStats
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *View) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStats
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: View: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: View: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStats
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthStats
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Description", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStats
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthStats
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Description = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Measure", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStats
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthStats
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Measure == nil {
				m.Measure = &Measure{}
			}
			if err := m.Measure.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Columns", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStats
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthStats
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Columns = append(m.Columns, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CountAggregation", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStats
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthStats
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &CountAggregation{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Aggregation = &View_CountAggregation{v}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SumAggregation", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStats
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthStats
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &SumAggregation{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Aggregation = &View_SumAggregation{v}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastValueAggregation", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStats
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthStats
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &LastValueAggregation{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Aggregation = &View_LastValueAggregation{v}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DistributionAggregation", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStats
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthStats
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &DistributionAggregation{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Aggregation = &View_DistributionAggregation{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStats(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStats
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthStats
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CountAggregation) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStats
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CountAggregation: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CountAggregation: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipStats(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStats
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthStats
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SumAggregation) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStats
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SumAggregation: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SumAggregation: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipStats(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStats
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthStats
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LastValueAggregation) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStats
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LastValueAggregation: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LastValueAggregation: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipStats(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStats
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthStats
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DistributionAggregation) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStats
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DistributionAggregation: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DistributionAggregation: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType == 1 {
				var v uint64
				if (iNdEx + 8) > l {
					return io.ErrUnexpectedEOF
				}
				v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
				iNdEx += 8
				v2 := float64(math.Float64frombits(v))
				m.BucketBounds = append(m.BucketBounds, v2)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowStats
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthStats
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthStats
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				elementCount = packedLen / 8
				if elementCount != 0 && len(m.BucketBounds) == 0 {
					m.BucketBounds = make([]float64, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v uint64
					if (iNdEx + 8) > l {
						return io.ErrUnexpectedEOF
					}
					v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
					iNdEx += 8
					v2 := float64(math.Float64frombits(v))
					m.BucketBounds = append(m.BucketBounds, v2)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field BucketBounds", wireType)
			}
		default:
			iNdEx = preIndex
			skippy, err := skipStats(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStats
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthStats
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Measurement) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStats
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Measurement: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Measurement: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tags", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStats
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthStats
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Tags = append(m.Tags, &Tag{})
			if err := m.Tags[len(m.Tags)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MeasureName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStats
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthStats
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.MeasureName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field DoubleValue", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.Value = &Measurement_DoubleValue{float64(math.Float64frombits(v))}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IntValue", wireType)
			}
			var v int64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Value = &Measurement_IntValue{v}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Time", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStats
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthStats
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Time == nil {
				m.Time = &types.Timestamp{}
			}
			if err := m.Time.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStats(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStats
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthStats
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipStats(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowStats
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowStats
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowStats
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthStats
			}
			iNdEx += length
			if iNdEx < 0 {
				return 0, ErrInvalidLengthStats
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowStats
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipStats(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
				if iNdEx < 0 {
					return 0, ErrInvalidLengthStats
				}
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthStats = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowStats   = fmt.Errorf("proto: integer overflow")
)
