// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: authentication/v1alpha1/policy.proto

// This package defines user-facing authentication policy.

package v1alpha1

import (
	fmt "fmt"
	proto "github.com/gogo/protobuf/proto"
	io "io"
	_ "istio.io/gogo-genproto/googleapis/google/api"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

// $hide_from_docs
// Deprecated. When using security/v1beta1/RequestAuthentication, the request principal always
// comes from request authentication (i.e JWT).
// Associates authentication with request principal.
type PrincipalBinding int32

const (
	// Principal will be set to the identity from peer authentication.
	PrincipalBinding_USE_PEER PrincipalBinding = 0
	// Principal will be set to the identity from origin authentication.
	PrincipalBinding_USE_ORIGIN PrincipalBinding = 1
)

var PrincipalBinding_name = map[int32]string{
	0: "USE_PEER",
	1: "USE_ORIGIN",
}

var PrincipalBinding_value = map[string]int32{
	"USE_PEER":   0,
	"USE_ORIGIN": 1,
}

func (x PrincipalBinding) String() string {
	return proto.EnumName(PrincipalBinding_name, int32(x))
}

func (PrincipalBinding) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_30ec3f7cef93301a, []int{0}
}

// $hide_from_docs
// Defines the acceptable connection TLS mode.
type MutualTls_Mode int32

const (
	// Client cert must be presented, connection is in TLS.
	MutualTls_STRICT MutualTls_Mode = 0
	// Connection can be either plaintext or TLS with Client cert.
	MutualTls_PERMISSIVE MutualTls_Mode = 1
)

var MutualTls_Mode_name = map[int32]string{
	0: "STRICT",
	1: "PERMISSIVE",
}

var MutualTls_Mode_value = map[string]int32{
	"STRICT":     0,
	"PERMISSIVE": 1,
}

func (x MutualTls_Mode) String() string {
	return proto.EnumName(MutualTls_Mode_name, int32(x))
}

func (MutualTls_Mode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_30ec3f7cef93301a, []int{1, 0}
}

// $hide_from_docs
// Describes how to match a given string. Match is case-sensitive.
type StringMatch struct {
	// Types that are valid to be assigned to MatchType:
	//	*StringMatch_Exact
	//	*StringMatch_Prefix
	//	*StringMatch_Suffix
	//	*StringMatch_Regex
	MatchType            isStringMatch_MatchType `protobuf_oneof:"match_type"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *StringMatch) Reset()         { *m = StringMatch{} }
func (m *StringMatch) String() string { return proto.CompactTextString(m) }
func (*StringMatch) ProtoMessage()    {}
func (*StringMatch) Descriptor() ([]byte, []int) {
	return fileDescriptor_30ec3f7cef93301a, []int{0}
}
func (m *StringMatch) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *StringMatch) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_StringMatch.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *StringMatch) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StringMatch.Merge(m, src)
}
func (m *StringMatch) XXX_Size() int {
	return m.Size()
}
func (m *StringMatch) XXX_DiscardUnknown() {
	xxx_messageInfo_StringMatch.DiscardUnknown(m)
}

var xxx_messageInfo_StringMatch proto.InternalMessageInfo

type isStringMatch_MatchType interface {
	isStringMatch_MatchType()
	MarshalTo([]byte) (int, error)
	Size() int
}

type StringMatch_Exact struct {
	Exact string `protobuf:"bytes,1,opt,name=exact,proto3,oneof" json:"exact,omitempty"`
}
type StringMatch_Prefix struct {
	Prefix string `protobuf:"bytes,2,opt,name=prefix,proto3,oneof" json:"prefix,omitempty"`
}
type StringMatch_Suffix struct {
	Suffix string `protobuf:"bytes,3,opt,name=suffix,proto3,oneof" json:"suffix,omitempty"`
}
type StringMatch_Regex struct {
	Regex string `protobuf:"bytes,4,opt,name=regex,proto3,oneof" json:"regex,omitempty"`
}

func (*StringMatch_Exact) isStringMatch_MatchType()  {}
func (*StringMatch_Prefix) isStringMatch_MatchType() {}
func (*StringMatch_Suffix) isStringMatch_MatchType() {}
func (*StringMatch_Regex) isStringMatch_MatchType()  {}

func (m *StringMatch) GetMatchType() isStringMatch_MatchType {
	if m != nil {
		return m.MatchType
	}
	return nil
}

func (m *StringMatch) GetExact() string {
	if x, ok := m.GetMatchType().(*StringMatch_Exact); ok {
		return x.Exact
	}
	return ""
}

func (m *StringMatch) GetPrefix() string {
	if x, ok := m.GetMatchType().(*StringMatch_Prefix); ok {
		return x.Prefix
	}
	return ""
}

func (m *StringMatch) GetSuffix() string {
	if x, ok := m.GetMatchType().(*StringMatch_Suffix); ok {
		return x.Suffix
	}
	return ""
}

func (m *StringMatch) GetRegex() string {
	if x, ok := m.GetMatchType().(*StringMatch_Regex); ok {
		return x.Regex
	}
	return ""
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*StringMatch) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*StringMatch_Exact)(nil),
		(*StringMatch_Prefix)(nil),
		(*StringMatch_Suffix)(nil),
		(*StringMatch_Regex)(nil),
	}
}

// $hide_from_docs
// Deprecated. Please use security/v1beta1/PeerAuthentication instead.
// TLS authentication params.
type MutualTls struct {
	// Deprecated. Please use mode = PERMISSIVE instead.
	// If set, will translate to `TLS_PERMISSIVE` mode.
	// Set this flag to true to allow regular TLS (i.e without client x509
	// certificate). If request carries client certificate, identity will be
	// extracted and used (set to peer identity). Otherwise, peer identity will
	// be left unset.
	// When the flag is false (default), request must have client certificate.
	AllowTls bool `protobuf:"varint,1,opt,name=allow_tls,json=allowTls,proto3" json:"allow_tls,omitempty"` // Deprecated: Do not use.
	// Defines the mode of mTLS authentication.
	Mode                 MutualTls_Mode `protobuf:"varint,2,opt,name=mode,proto3,enum=istio.authentication.v1alpha1.MutualTls_Mode" json:"mode,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *MutualTls) Reset()         { *m = MutualTls{} }
func (m *MutualTls) String() string { return proto.CompactTextString(m) }
func (*MutualTls) ProtoMessage()    {}
func (*MutualTls) Descriptor() ([]byte, []int) {
	return fileDescriptor_30ec3f7cef93301a, []int{1}
}
func (m *MutualTls) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MutualTls) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MutualTls.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *MutualTls) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutualTls.Merge(m, src)
}
func (m *MutualTls) XXX_Size() int {
	return m.Size()
}
func (m *MutualTls) XXX_DiscardUnknown() {
	xxx_messageInfo_MutualTls.DiscardUnknown(m)
}

var xxx_messageInfo_MutualTls proto.InternalMessageInfo

// Deprecated: Do not use.
func (m *MutualTls) GetAllowTls() bool {
	if m != nil {
		return m.AllowTls
	}
	return false
}

func (m *MutualTls) GetMode() MutualTls_Mode {
	if m != nil {
		return m.Mode
	}
	return MutualTls_STRICT
}

// $hide_from_docs
// Deprecated. Please use security/v1beta1/RequestAuthentication instead.
// JSON Web Token (JWT) token format for authentication as defined by
// [RFC 7519](https://tools.ietf.org/html/rfc7519). See [OAuth 2.0](https://tools.ietf.org/html/rfc6749) and
// [OIDC 1.0](http://openid.net/connect) for how this is used in the whole
// authentication flow.
//
// For example:
//
// A JWT for any requests:
//
// ```yaml
// issuer: https://example.com
// audiences:
// - bookstore_android.apps.googleusercontent.com
//   bookstore_web.apps.googleusercontent.com
// jwksUri: https://example.com/.well-known/jwks.json
// ```
//
// A JWT for all requests except request at path `/health_check` and path with
// prefix `/status/`. This is useful to expose some paths for public access but
// keep others JWT validated.
//
// ```yaml
// issuer: https://example.com
// jwksUri: https://example.com/.well-known/jwks.json
// triggerRules:
// - excludedPaths:
//   - exact: /health_check
//   - prefix: /status/
// ```
//
// A JWT only for requests at path `/admin`. This is useful to only require JWT
// validation on a specific set of paths but keep others public accessible.
//
// ```yaml
// issuer: https://example.com
// jwksUri: https://example.com/.well-known/jwks.json
// triggerRules:
// - includedPaths:
//   - prefix: /admin
// ```
//
// A JWT only for requests at path of prefix `/status/` but except the path of
// `/status/version`. This means for any request path with prefix `/status/` except
// `/status/version` will require a valid JWT to proceed.
//
// ```yaml
// issuer: https://example.com
// jwksUri: https://example.com/.well-known/jwks.json
// triggerRules:
// - excludedPaths:
//   - exact: /status/version
//   includedPaths:
//   - prefix: /status/
// ```
type Jwt struct {
	// Identifies the issuer that issued the JWT. See
	// [issuer](https://tools.ietf.org/html/rfc7519#section-4.1.1)
	// Usually a URL or an email address.
	//
	// Example: https://securetoken.google.com
	// Example: 1234567-compute@developer.gserviceaccount.com
	Issuer string `protobuf:"bytes,1,opt,name=issuer,proto3" json:"issuer,omitempty"`
	// The list of JWT
	// [audiences](https://tools.ietf.org/html/rfc7519#section-4.1.3).
	// that are allowed to access. A JWT containing any of these
	// audiences will be accepted.
	//
	// The service name will be accepted if audiences is empty.
	//
	// Example:
	//
	// ```yaml
	// audiences:
	// - bookstore_android.apps.googleusercontent.com
	//   bookstore_web.apps.googleusercontent.com
	// ```
	Audiences []string `protobuf:"bytes,2,rep,name=audiences,proto3" json:"audiences,omitempty"`
	// URL of the provider's public key set to validate signature of the
	// JWT. See [OpenID Discovery](https://openid.net/specs/openid-connect-discovery-1_0.html#ProviderMetadata).
	//
	// Optional if the key set document can either (a) be retrieved from
	// [OpenID
	// Discovery](https://openid.net/specs/openid-connect-discovery-1_0.html) of
	// the issuer or (b) inferred from the email domain of the issuer (e.g. a
	// Google service account).
	//
	// Example: `https://www.googleapis.com/oauth2/v1/certs`
	//
	// Note: Only one of jwks_uri and jwks should be used.
	JwksUri string `protobuf:"bytes,3,opt,name=jwks_uri,json=jwksUri,proto3" json:"jwks_uri,omitempty"`
	// JSON Web Key Set of public keys to validate signature of the JWT.
	// See https://auth0.com/docs/jwks.
	//
	// Note: Only one of jwks_uri and jwks should be used.
	Jwks string `protobuf:"bytes,10,opt,name=jwks,proto3" json:"jwks,omitempty"`
	// JWT is sent in a request header. `header` represents the
	// header name.
	//
	// For example, if `header=x-goog-iap-jwt-assertion`, the header
	// format will be `x-goog-iap-jwt-assertion: <JWT>`.
	JwtHeaders []string `protobuf:"bytes,6,rep,name=jwt_headers,json=jwtHeaders,proto3" json:"jwt_headers,omitempty"`
	// JWT is sent in a query parameter. `query` represents the
	// query parameter name.
	//
	// For example, `query=jwt_token`.
	JwtParams []string `protobuf:"bytes,7,rep,name=jwt_params,json=jwtParams,proto3" json:"jwt_params,omitempty"`
	// List of trigger rules to decide if this JWT should be used to validate the
	// request. The JWT validation happens if any one of the rules matched.
	// If the list is not empty and none of the rules matched, authentication will
	// skip the JWT validation.
	// Leave this empty to always trigger the JWT validation.
	TriggerRules         []*Jwt_TriggerRule `protobuf:"bytes,9,rep,name=trigger_rules,json=triggerRules,proto3" json:"trigger_rules,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *Jwt) Reset()         { *m = Jwt{} }
func (m *Jwt) String() string { return proto.CompactTextString(m) }
func (*Jwt) ProtoMessage()    {}
func (*Jwt) Descriptor() ([]byte, []int) {
	return fileDescriptor_30ec3f7cef93301a, []int{2}
}
func (m *Jwt) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Jwt) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Jwt.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Jwt) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Jwt.Merge(m, src)
}
func (m *Jwt) XXX_Size() int {
	return m.Size()
}
func (m *Jwt) XXX_DiscardUnknown() {
	xxx_messageInfo_Jwt.DiscardUnknown(m)
}

var xxx_messageInfo_Jwt proto.InternalMessageInfo

func (m *Jwt) GetIssuer() string {
	if m != nil {
		return m.Issuer
	}
	return ""
}

func (m *Jwt) GetAudiences() []string {
	if m != nil {
		return m.Audiences
	}
	return nil
}

func (m *Jwt) GetJwksUri() string {
	if m != nil {
		return m.JwksUri
	}
	return ""
}

func (m *Jwt) GetJwks() string {
	if m != nil {
		return m.Jwks
	}
	return ""
}

func (m *Jwt) GetJwtHeaders() []string {
	if m != nil {
		return m.JwtHeaders
	}
	return nil
}

func (m *Jwt) GetJwtParams() []string {
	if m != nil {
		return m.JwtParams
	}
	return nil
}

func (m *Jwt) GetTriggerRules() []*Jwt_TriggerRule {
	if m != nil {
		return m.TriggerRules
	}
	return nil
}

// $hide_from_docs
// Trigger rule to match against a request. The trigger rule is satisfied if
// and only if both rules, excluded_paths and include_paths are satisfied.
type Jwt_TriggerRule struct {
	// List of paths to be excluded from the request. The rule is satisfied if
	// request path does not match to any of the path in this list.
	ExcludedPaths []*StringMatch `protobuf:"bytes,1,rep,name=excluded_paths,json=excludedPaths,proto3" json:"excluded_paths,omitempty"`
	// List of paths that the request must include. If the list is not empty, the
	// rule is satisfied if request path matches at least one of the path in the list.
	// If the list is empty, the rule is ignored, in other words the rule is always satisfied.
	IncludedPaths        []*StringMatch `protobuf:"bytes,2,rep,name=included_paths,json=includedPaths,proto3" json:"included_paths,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *Jwt_TriggerRule) Reset()         { *m = Jwt_TriggerRule{} }
func (m *Jwt_TriggerRule) String() string { return proto.CompactTextString(m) }
func (*Jwt_TriggerRule) ProtoMessage()    {}
func (*Jwt_TriggerRule) Descriptor() ([]byte, []int) {
	return fileDescriptor_30ec3f7cef93301a, []int{2, 0}
}
func (m *Jwt_TriggerRule) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Jwt_TriggerRule) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Jwt_TriggerRule.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Jwt_TriggerRule) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Jwt_TriggerRule.Merge(m, src)
}
func (m *Jwt_TriggerRule) XXX_Size() int {
	return m.Size()
}
func (m *Jwt_TriggerRule) XXX_DiscardUnknown() {
	xxx_messageInfo_Jwt_TriggerRule.DiscardUnknown(m)
}

var xxx_messageInfo_Jwt_TriggerRule proto.InternalMessageInfo

func (m *Jwt_TriggerRule) GetExcludedPaths() []*StringMatch {
	if m != nil {
		return m.ExcludedPaths
	}
	return nil
}

func (m *Jwt_TriggerRule) GetIncludedPaths() []*StringMatch {
	if m != nil {
		return m.IncludedPaths
	}
	return nil
}

// $hide_from_docs
// Deprecated. Please use security/v1beta1/PeerAuthentication instead.
// PeerAuthenticationMethod defines one particular type of authentication. Only mTLS is supported
// at the moment.
// The type can be progammatically determine by checking the type of the
// "params" field.
type PeerAuthenticationMethod struct {
	// $hide_from_docs
	//
	// Types that are valid to be assigned to Params:
	//	*PeerAuthenticationMethod_Mtls
	//	*PeerAuthenticationMethod_Jwt
	Params               isPeerAuthenticationMethod_Params `protobuf_oneof:"params"`
	XXX_NoUnkeyedLiteral struct{}                          `json:"-"`
	XXX_unrecognized     []byte                            `json:"-"`
	XXX_sizecache        int32                             `json:"-"`
}

func (m *PeerAuthenticationMethod) Reset()         { *m = PeerAuthenticationMethod{} }
func (m *PeerAuthenticationMethod) String() string { return proto.CompactTextString(m) }
func (*PeerAuthenticationMethod) ProtoMessage()    {}
func (*PeerAuthenticationMethod) Descriptor() ([]byte, []int) {
	return fileDescriptor_30ec3f7cef93301a, []int{3}
}
func (m *PeerAuthenticationMethod) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PeerAuthenticationMethod) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PeerAuthenticationMethod.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PeerAuthenticationMethod) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PeerAuthenticationMethod.Merge(m, src)
}
func (m *PeerAuthenticationMethod) XXX_Size() int {
	return m.Size()
}
func (m *PeerAuthenticationMethod) XXX_DiscardUnknown() {
	xxx_messageInfo_PeerAuthenticationMethod.DiscardUnknown(m)
}

var xxx_messageInfo_PeerAuthenticationMethod proto.InternalMessageInfo

type isPeerAuthenticationMethod_Params interface {
	isPeerAuthenticationMethod_Params()
	MarshalTo([]byte) (int, error)
	Size() int
}

type PeerAuthenticationMethod_Mtls struct {
	Mtls *MutualTls `protobuf:"bytes,1,opt,name=mtls,proto3,oneof" json:"mtls,omitempty"`
}
type PeerAuthenticationMethod_Jwt struct {
	Jwt *Jwt `protobuf:"bytes,2,opt,name=jwt,proto3,oneof" json:"jwt,omitempty"`
}

func (*PeerAuthenticationMethod_Mtls) isPeerAuthenticationMethod_Params() {}
func (*PeerAuthenticationMethod_Jwt) isPeerAuthenticationMethod_Params()  {}

func (m *PeerAuthenticationMethod) GetParams() isPeerAuthenticationMethod_Params {
	if m != nil {
		return m.Params
	}
	return nil
}

func (m *PeerAuthenticationMethod) GetMtls() *MutualTls {
	if x, ok := m.GetParams().(*PeerAuthenticationMethod_Mtls); ok {
		return x.Mtls
	}
	return nil
}

// Deprecated: Do not use.
func (m *PeerAuthenticationMethod) GetJwt() *Jwt {
	if x, ok := m.GetParams().(*PeerAuthenticationMethod_Jwt); ok {
		return x.Jwt
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*PeerAuthenticationMethod) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*PeerAuthenticationMethod_Mtls)(nil),
		(*PeerAuthenticationMethod_Jwt)(nil),
	}
}

// $hide_from_docs
// Deprecated. Please use security/v1beta1/RequestAuthentication instead.
// OriginAuthenticationMethod defines authentication method/params for origin
// authentication. Origin could be end-user, device, delegate service etc.
// Currently, only JWT is supported for origin authentication.
type OriginAuthenticationMethod struct {
	// Jwt params for the method.
	Jwt                  *Jwt     `protobuf:"bytes,1,opt,name=jwt,proto3" json:"jwt,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *OriginAuthenticationMethod) Reset()         { *m = OriginAuthenticationMethod{} }
func (m *OriginAuthenticationMethod) String() string { return proto.CompactTextString(m) }
func (*OriginAuthenticationMethod) ProtoMessage()    {}
func (*OriginAuthenticationMethod) Descriptor() ([]byte, []int) {
	return fileDescriptor_30ec3f7cef93301a, []int{4}
}
func (m *OriginAuthenticationMethod) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *OriginAuthenticationMethod) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_OriginAuthenticationMethod.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *OriginAuthenticationMethod) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OriginAuthenticationMethod.Merge(m, src)
}
func (m *OriginAuthenticationMethod) XXX_Size() int {
	return m.Size()
}
func (m *OriginAuthenticationMethod) XXX_DiscardUnknown() {
	xxx_messageInfo_OriginAuthenticationMethod.DiscardUnknown(m)
}

var xxx_messageInfo_OriginAuthenticationMethod proto.InternalMessageInfo

func (m *OriginAuthenticationMethod) GetJwt() *Jwt {
	if m != nil {
		return m.Jwt
	}
	return nil
}

// $hide_from_docs
// Policy defines what authentication methods can be accepted on workload(s),
// and if authenticated, which method/certificate will set the request principal
// (i.e request.auth.principal attribute).
//
// Authentication policy is composed of 2-part authentication:
// - peer: verify caller service credentials. This part will set source.user
// (peer identity).
// - origin: verify the origin credentials. This part will set request.auth.user
// (origin identity), as well as other attributes like request.auth.presenter,
// request.auth.audiences and raw claims. Note that the identity could be
// end-user, service account, device etc.
//
// Last but not least, the principal binding rule defines which identity (peer
// or origin) should be used as principal. By default, it uses peer.
//
// Examples:
//
// Policy to enable mTLS for all services in namespace frod. The policy name must be
// `default`, and it contains no rule for `targets`.
//
// ```yaml
// apiVersion: authentication.istio.io/v1alpha1
// kind: Policy
// metadata:
//   name: default
//   namespace: frod
// spec:
//   peers:
//   - mtls:
// ```
// Policy to disable mTLS for "productpage" service
//
// ```yaml
// apiVersion: authentication.istio.io/v1alpha1
// kind: Policy
// metadata:
//   name: productpage-mTLS-disable
//   namespace: frod
// spec:
//   targets:
//   - name: productpage
// ```
// Policy to require mTLS for peer authentication, and JWT for origin authentication
// for productpage:9000 except the path '/health_check' . Principal is set from origin identity.
//
// ```yaml
// apiVersion: authentication.istio.io/v1alpha1
// kind: Policy
// metadata:
//   name: productpage-mTLS-with-JWT
//   namespace: frod
// spec:
//   targets:
//   - name: productpage
//     ports:
//     - number: 9000
//   peers:
//   - mtls:
//   origins:
//   - jwt:
//       issuer: "https://securetoken.google.com"
//       audiences:
//       - "productpage"
//       jwksUri: "https://www.googleapis.com/oauth2/v1/certs"
//       jwtHeaders:
//       - "x-goog-iap-jwt-assertion"
//       triggerRules:
//       - excludedPaths:
//         - exact: /health_check
//   principalBinding: USE_ORIGIN
// ```
type Policy struct {
	// Deprecated. Only mesh-level and namespace-level policies are supported.
	// List rules to select workloads that the policy should be applied on.
	// If empty, policy will be used on all workloads in the same namespace.
	Targets []*TargetSelector `protobuf:"bytes,1,rep,name=targets,proto3" json:"targets,omitempty"` // Deprecated: Do not use.
	// $hide_from_docs
	// Deprecated. Please use security/v1beta1/PeerAuthentication instead.
	// List of authentication methods that can be used for peer authentication.
	// They will be evaluated in order; the first validate one will be used to
	// set peer identity (source.user) and other peer attributes. If none of
	// these methods pass, request will be rejected with authentication failed error (401).
	// Leave the list empty if peer authentication is not required
	Peers []*PeerAuthenticationMethod `protobuf:"bytes,2,rep,name=peers,proto3" json:"peers,omitempty"`
	// Deprecated. Should set mTLS to PERMISSIVE instead.
	// Set this flag to true to accept request (for peer authentication perspective),
	// even when none of the peer authentication methods defined above satisfied.
	// Typically, this is used to delay the rejection decision to next layer (e.g
	// authorization).
	// This flag is ignored if no authentication defined for peer (peers field is empty).
	PeerIsOptional bool `protobuf:"varint,3,opt,name=peer_is_optional,json=peerIsOptional,proto3" json:"peer_is_optional,omitempty"` // Deprecated: Do not use.
	// Deprecated. Please use security/v1beta1/RequestAuthentication instead.
	// List of authentication methods that can be used for origin authentication.
	// Similar to peers, these will be evaluated in order; the first validate one
	// will be used to set origin identity and attributes (i.e request.auth.user,
	// request.auth.issuer etc). If none of these methods pass, request will be
	// rejected with authentication failed error (401).
	// A method may be skipped, depends on its trigger rule. If all of these methods
	// are skipped, origin authentication will be ignored, as if it is not defined.
	// Leave the list empty if origin authentication is not required.
	Origins []*OriginAuthenticationMethod `protobuf:"bytes,4,rep,name=origins,proto3" json:"origins,omitempty"` // Deprecated: Do not use.
	// Deprecated. Please use security/v1beta1/RequestAuthentication instead.
	// Set this flag to true to accept request (for origin authentication perspective),
	// even when none of the origin authentication methods defined above satisfied.
	// Typically, this is used to delay the rejection decision to next layer (e.g
	// authorization).
	// This flag is ignored if no authentication defined for origin (origins field is empty).
	OriginIsOptional bool `protobuf:"varint,5,opt,name=origin_is_optional,json=originIsOptional,proto3" json:"origin_is_optional,omitempty"` // Deprecated: Do not use.
	// Deprecated. Source principal is always from peer, and request principal is always from
	// RequestAuthentication.
	// Define whether peer or origin identity should be use for principal. Default
	// value is USE_PEER.
	// If peer (or origin) identity is not available, either because of peer/origin
	// authentication is not defined, or failed, principal will be left unset.
	// In other words, binding rule does not affect the decision to accept or
	// reject request.
	PrincipalBinding     PrincipalBinding `protobuf:"varint,6,opt,name=principal_binding,json=principalBinding,proto3,enum=istio.authentication.v1alpha1.PrincipalBinding" json:"principal_binding,omitempty"` // Deprecated: Do not use.
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *Policy) Reset()         { *m = Policy{} }
func (m *Policy) String() string { return proto.CompactTextString(m) }
func (*Policy) ProtoMessage()    {}
func (*Policy) Descriptor() ([]byte, []int) {
	return fileDescriptor_30ec3f7cef93301a, []int{5}
}
func (m *Policy) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Policy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Policy.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Policy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Policy.Merge(m, src)
}
func (m *Policy) XXX_Size() int {
	return m.Size()
}
func (m *Policy) XXX_DiscardUnknown() {
	xxx_messageInfo_Policy.DiscardUnknown(m)
}

var xxx_messageInfo_Policy proto.InternalMessageInfo

// Deprecated: Do not use.
func (m *Policy) GetTargets() []*TargetSelector {
	if m != nil {
		return m.Targets
	}
	return nil
}

func (m *Policy) GetPeers() []*PeerAuthenticationMethod {
	if m != nil {
		return m.Peers
	}
	return nil
}

// Deprecated: Do not use.
func (m *Policy) GetPeerIsOptional() bool {
	if m != nil {
		return m.PeerIsOptional
	}
	return false
}

// Deprecated: Do not use.
func (m *Policy) GetOrigins() []*OriginAuthenticationMethod {
	if m != nil {
		return m.Origins
	}
	return nil
}

// Deprecated: Do not use.
func (m *Policy) GetOriginIsOptional() bool {
	if m != nil {
		return m.OriginIsOptional
	}
	return false
}

// Deprecated: Do not use.
func (m *Policy) GetPrincipalBinding() PrincipalBinding {
	if m != nil {
		return m.PrincipalBinding
	}
	return PrincipalBinding_USE_PEER
}

// $hide_from_docs
// Deprecated. Only support mesh and namespace level policy in the future.
// TargetSelector defines a matching rule to a workload. A workload is selected
// if it is associated with the service name and service port(s) specified in the selector rule.
type TargetSelector struct {
	// The name must be a short name from the service registry. The
	// fully qualified domain name will be resolved in a platform specific manner.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Specifies the ports. Note that this is the port(s) exposed by the service, not workload instance ports.
	// For example, if a service is defined as below, then `8000` should be used, not `9000`.
	// ```yaml
	// kind: Service
	// metadata:
	//   ...
	// spec:
	//   ports:
	//   - name: http
	//     port: 8000
	//     targetPort: 9000
	//   selector:
	//     app: backend
	// ```
	//Leave empty to match all ports that are exposed.
	Ports                []*PortSelector `protobuf:"bytes,2,rep,name=ports,proto3" json:"ports,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *TargetSelector) Reset()         { *m = TargetSelector{} }
func (m *TargetSelector) String() string { return proto.CompactTextString(m) }
func (*TargetSelector) ProtoMessage()    {}
func (*TargetSelector) Descriptor() ([]byte, []int) {
	return fileDescriptor_30ec3f7cef93301a, []int{6}
}
func (m *TargetSelector) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TargetSelector) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TargetSelector.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *TargetSelector) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TargetSelector.Merge(m, src)
}
func (m *TargetSelector) XXX_Size() int {
	return m.Size()
}
func (m *TargetSelector) XXX_DiscardUnknown() {
	xxx_messageInfo_TargetSelector.DiscardUnknown(m)
}

var xxx_messageInfo_TargetSelector proto.InternalMessageInfo

func (m *TargetSelector) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *TargetSelector) GetPorts() []*PortSelector {
	if m != nil {
		return m.Ports
	}
	return nil
}

// $hide_from_docs
// Deprecated. Only support mesh and namespace level policy in the future.
// PortSelector specifies the name or number of a port to be used for
// matching targets for authentication policy. This is copied from
// networking API to avoid dependency.
type PortSelector struct {
	// Types that are valid to be assigned to Port:
	//	*PortSelector_Number
	//	*PortSelector_Name
	Port                 isPortSelector_Port `protobuf_oneof:"port"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *PortSelector) Reset()         { *m = PortSelector{} }
func (m *PortSelector) String() string { return proto.CompactTextString(m) }
func (*PortSelector) ProtoMessage()    {}
func (*PortSelector) Descriptor() ([]byte, []int) {
	return fileDescriptor_30ec3f7cef93301a, []int{7}
}
func (m *PortSelector) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PortSelector) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PortSelector.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PortSelector) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PortSelector.Merge(m, src)
}
func (m *PortSelector) XXX_Size() int {
	return m.Size()
}
func (m *PortSelector) XXX_DiscardUnknown() {
	xxx_messageInfo_PortSelector.DiscardUnknown(m)
}

var xxx_messageInfo_PortSelector proto.InternalMessageInfo

type isPortSelector_Port interface {
	isPortSelector_Port()
	MarshalTo([]byte) (int, error)
	Size() int
}

type PortSelector_Number struct {
	Number uint32 `protobuf:"varint,1,opt,name=number,proto3,oneof" json:"number,omitempty"`
}
type PortSelector_Name struct {
	Name string `protobuf:"bytes,2,opt,name=name,proto3,oneof" json:"name,omitempty"`
}

func (*PortSelector_Number) isPortSelector_Port() {}
func (*PortSelector_Name) isPortSelector_Port()   {}

func (m *PortSelector) GetPort() isPortSelector_Port {
	if m != nil {
		return m.Port
	}
	return nil
}

func (m *PortSelector) GetNumber() uint32 {
	if x, ok := m.GetPort().(*PortSelector_Number); ok {
		return x.Number
	}
	return 0
}

func (m *PortSelector) GetName() string {
	if x, ok := m.GetPort().(*PortSelector_Name); ok {
		return x.Name
	}
	return ""
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*PortSelector) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*PortSelector_Number)(nil),
		(*PortSelector_Name)(nil),
	}
}

func init() {
	proto.RegisterEnum("istio.authentication.v1alpha1.PrincipalBinding", PrincipalBinding_name, PrincipalBinding_value)
	proto.RegisterEnum("istio.authentication.v1alpha1.MutualTls_Mode", MutualTls_Mode_name, MutualTls_Mode_value)
	proto.RegisterType((*StringMatch)(nil), "istio.authentication.v1alpha1.StringMatch")
	proto.RegisterType((*MutualTls)(nil), "istio.authentication.v1alpha1.MutualTls")
	proto.RegisterType((*Jwt)(nil), "istio.authentication.v1alpha1.Jwt")
	proto.RegisterType((*Jwt_TriggerRule)(nil), "istio.authentication.v1alpha1.Jwt.TriggerRule")
	proto.RegisterType((*PeerAuthenticationMethod)(nil), "istio.authentication.v1alpha1.PeerAuthenticationMethod")
	proto.RegisterType((*OriginAuthenticationMethod)(nil), "istio.authentication.v1alpha1.OriginAuthenticationMethod")
	proto.RegisterType((*Policy)(nil), "istio.authentication.v1alpha1.Policy")
	proto.RegisterType((*TargetSelector)(nil), "istio.authentication.v1alpha1.TargetSelector")
	proto.RegisterType((*PortSelector)(nil), "istio.authentication.v1alpha1.PortSelector")
}

func init() {
	proto.RegisterFile("authentication/v1alpha1/policy.proto", fileDescriptor_30ec3f7cef93301a)
}

var fileDescriptor_30ec3f7cef93301a = []byte{
	// 838 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x55, 0x4f, 0x6f, 0x23, 0x35,
	0x14, 0xef, 0x24, 0xd3, 0x69, 0xf2, 0xd2, 0x46, 0xc1, 0x42, 0xab, 0xa1, 0x62, 0xdb, 0x6a, 0xb4,
	0x87, 0x6a, 0x81, 0x64, 0x37, 0x20, 0x21, 0x38, 0x20, 0x35, 0x28, 0xd0, 0x14, 0x85, 0x06, 0x27,
	0x0b, 0x12, 0x97, 0xc1, 0xc9, 0xb8, 0x13, 0x07, 0x67, 0x3c, 0xb2, 0x3d, 0x9b, 0xae, 0x38, 0xf0,
	0x21, 0xf8, 0x02, 0x7c, 0x07, 0xc4, 0x99, 0x2b, 0x47, 0x3e, 0x02, 0xea, 0x27, 0x41, 0xb6, 0x33,
	0xdd, 0x66, 0x45, 0x49, 0xb9, 0xf9, 0xf7, 0xfe, 0xfc, 0xde, 0xf3, 0x7b, 0xcf, 0xcf, 0xf0, 0x84,
	0x14, 0x7a, 0x4e, 0x33, 0xcd, 0x66, 0x44, 0x33, 0x91, 0x75, 0x5e, 0x3e, 0x27, 0x3c, 0x9f, 0x93,
	0xe7, 0x9d, 0x5c, 0x70, 0x36, 0x7b, 0xd5, 0xce, 0xa5, 0xd0, 0x02, 0x3d, 0x66, 0x4a, 0x33, 0xd1,
	0xde, 0xb4, 0x6d, 0x97, 0xb6, 0x87, 0xc7, 0xa9, 0x10, 0x29, 0xa7, 0x1d, 0x92, 0xb3, 0xce, 0x15,
	0xa3, 0x3c, 0x89, 0xa7, 0x74, 0x4e, 0x5e, 0x32, 0x21, 0x9d, 0x7f, 0xf4, 0x33, 0x34, 0xc6, 0x5a,
	0xb2, 0x2c, 0x1d, 0x12, 0x3d, 0x9b, 0xa3, 0x47, 0xb0, 0x4b, 0xaf, 0xc9, 0x4c, 0x87, 0xde, 0x89,
	0x77, 0x5a, 0x3f, 0xdf, 0xc1, 0x0e, 0xa2, 0x10, 0x82, 0x5c, 0xd2, 0x2b, 0x76, 0x1d, 0x56, 0xd6,
	0x8a, 0x35, 0x36, 0x1a, 0x55, 0x5c, 0x19, 0x4d, 0xb5, 0xd4, 0x38, 0x6c, 0xb8, 0x24, 0x4d, 0xe9,
	0x75, 0xe8, 0x97, 0x5c, 0x16, 0xf6, 0xf6, 0x01, 0x96, 0x26, 0x58, 0xac, 0x5f, 0xe5, 0x34, 0xfa,
	0xc5, 0x83, 0xfa, 0xb0, 0xd0, 0x05, 0xe1, 0x13, 0xae, 0xd0, 0x31, 0xd4, 0x09, 0xe7, 0x62, 0x15,
	0x6b, 0xae, 0x6c, 0x0e, 0xb5, 0x5e, 0x25, 0xf4, 0x70, 0xcd, 0x0a, 0x8d, 0xc1, 0x19, 0xf8, 0x4b,
	0x91, 0x50, 0x9b, 0x46, 0xb3, 0xfb, 0x41, 0xfb, 0x3f, 0xaf, 0xdf, 0xbe, 0x25, 0x6e, 0x0f, 0x45,
	0x42, 0xb1, 0x75, 0x8d, 0x22, 0xf0, 0x0d, 0x42, 0x00, 0xc1, 0x78, 0x82, 0x07, 0x9f, 0x4f, 0x5a,
	0x3b, 0xa8, 0x09, 0x30, 0xea, 0xe3, 0xe1, 0x60, 0x3c, 0x1e, 0x7c, 0xdb, 0x6f, 0x79, 0xd1, 0xef,
	0x55, 0xa8, 0x5e, 0xac, 0x34, 0x7a, 0x04, 0x01, 0x53, 0xaa, 0xa0, 0xd2, 0x15, 0x04, 0xaf, 0x11,
	0x7a, 0x17, 0xea, 0xa4, 0x48, 0x18, 0xcd, 0x66, 0x54, 0x85, 0x95, 0x93, 0xea, 0x69, 0x1d, 0xbf,
	0x16, 0xa0, 0x77, 0xa0, 0xb6, 0x58, 0xfd, 0xa8, 0xe2, 0x42, 0x32, 0x57, 0x15, 0xbc, 0x67, 0xf0,
	0x0b, 0xc9, 0x10, 0x02, 0xdf, 0x1c, 0x43, 0xb0, 0x62, 0x7b, 0x46, 0xc7, 0xd0, 0x58, 0xac, 0x74,
	0x3c, 0xa7, 0x24, 0xa1, 0x52, 0x85, 0x81, 0xa5, 0x83, 0xc5, 0x4a, 0x9f, 0x3b, 0x09, 0x7a, 0x0c,
	0x06, 0xc5, 0x39, 0x91, 0x64, 0xa9, 0xc2, 0x3d, 0x17, 0x6e, 0xb1, 0xd2, 0x23, 0x2b, 0x40, 0x63,
	0x38, 0xd0, 0x92, 0xa5, 0x29, 0x95, 0xb1, 0x2c, 0x38, 0x55, 0x61, 0xfd, 0xa4, 0x7a, 0xda, 0xe8,
	0xb6, 0xb7, 0x14, 0xe7, 0x62, 0xa5, 0xdb, 0x13, 0xe7, 0x87, 0x0b, 0x4e, 0xf1, 0xbe, 0x7e, 0x0d,
	0xd4, 0xe1, 0x6f, 0x1e, 0x34, 0xee, 0x68, 0xd1, 0x37, 0xd0, 0xa4, 0xd7, 0x33, 0x5e, 0x24, 0x34,
	0x89, 0x73, 0xa2, 0xe7, 0xa6, 0x3d, 0x26, 0xca, 0xd3, 0x2d, 0x51, 0xee, 0x4c, 0x17, 0x3e, 0x28,
	0x19, 0x46, 0x86, 0xc0, 0x50, 0xb2, 0x6c, 0x83, 0xb2, 0xf2, 0xff, 0x29, 0x4b, 0x06, 0x4b, 0x19,
	0xfd, 0xea, 0x41, 0x38, 0xa2, 0x54, 0x9e, 0x6d, 0xb8, 0x0e, 0xa9, 0x9e, 0x8b, 0x04, 0x7d, 0x06,
	0xfe, 0xb2, 0x9c, 0xab, 0x46, 0xf7, 0xf4, 0xa1, 0xb3, 0x73, 0xbe, 0x83, 0xad, 0x1f, 0xfa, 0x14,
	0xaa, 0x8b, 0x95, 0xb6, 0xa3, 0xd7, 0xe8, 0x46, 0xdb, 0xab, 0x6b, 0x46, 0xf7, 0x7c, 0x07, 0x1b,
	0xa7, 0x5e, 0x0d, 0x02, 0xd7, 0xbe, 0x08, 0xc3, 0xe1, 0xa5, 0x64, 0x29, 0xcb, 0xfe, 0x35, 0xc7,
	0x8f, 0x5c, 0x0c, 0xef, 0xa1, 0x31, 0x2c, 0x7b, 0xf4, 0x47, 0x15, 0x82, 0x91, 0x5d, 0x0b, 0xe8,
	0x2b, 0xd8, 0xd3, 0x44, 0xa6, 0x54, 0x97, 0x0d, 0xda, 0xf6, 0x46, 0x26, 0xd6, 0x7a, 0x4c, 0x39,
	0x9d, 0x69, 0x21, 0xed, 0x73, 0x2b, 0x19, 0xd0, 0x10, 0x76, 0x73, 0x6a, 0x66, 0xd2, 0x35, 0xe6,
	0xe3, 0x2d, 0x54, 0xf7, 0x55, 0x1e, 0x3b, 0x16, 0xf4, 0x3e, 0xb4, 0xcc, 0x21, 0x66, 0x2a, 0x16,
	0xb9, 0x51, 0x13, 0x6e, 0xdf, 0x87, 0x7b, 0xe4, 0x4d, 0xa3, 0x1b, 0xa8, 0xcb, 0xb5, 0x06, 0x7d,
	0x07, 0x7b, 0xc2, 0x16, 0x4a, 0x85, 0xbe, 0x0d, 0xff, 0xc9, 0x96, 0xf0, 0xf7, 0x97, 0xd5, 0xdd,
	0x6a, 0xcd, 0x86, 0x9e, 0x01, 0x72, 0xc7, 0x8d, 0x44, 0x76, 0x6f, 0x13, 0x69, 0x39, 0xed, 0x9d,
	0x54, 0x7e, 0x80, 0xb7, 0x72, 0xc9, 0xb2, 0x19, 0xcb, 0x09, 0x8f, 0xa7, 0x2c, 0x4b, 0x58, 0x96,
	0x86, 0x81, 0x5d, 0x41, 0x9d, 0x6d, 0x35, 0x29, 0xfd, 0x7a, 0xce, 0xcd, 0x45, 0xc8, 0xdf, 0x90,
	0x46, 0x3f, 0x41, 0x73, 0xb3, 0x11, 0x28, 0x04, 0x3f, 0x23, 0x4b, 0xea, 0x16, 0x4f, 0xcf, 0xbf,
	0x39, 0xf3, 0x2a, 0xd8, 0x4a, 0xd0, 0x19, 0xec, 0xe6, 0x42, 0xea, 0xb2, 0x2b, 0xef, 0x6d, 0xcb,
	0x40, 0xc8, 0x5b, 0x56, 0xec, 0x3c, 0x2f, 0xfc, 0x5a, 0xb5, 0xe5, 0xe3, 0x80, 0x93, 0x29, 0xe5,
	0x2a, 0xfa, 0x02, 0xf6, 0xef, 0x1a, 0x99, 0x9d, 0x9e, 0x15, 0xcb, 0xe9, 0x7a, 0xeb, 0x1d, 0x98,
	0x9d, 0xee, 0x30, 0x7a, 0x7b, 0x9d, 0x54, 0xf9, 0x0b, 0x58, 0xd4, 0x0b, 0xc0, 0x37, 0xb4, 0x4f,
	0x9f, 0x41, 0xeb, 0xcd, 0xeb, 0xa2, 0x7d, 0xa8, 0xbd, 0x18, 0xf7, 0xe3, 0x51, 0xbf, 0x8f, 0xdd,
	0x9e, 0x35, 0xe8, 0x12, 0x0f, 0xbe, 0x1c, 0x7c, 0xdd, 0xf2, 0x7a, 0xdd, 0x3f, 0x6f, 0x8e, 0xbc,
	0xbf, 0x6e, 0x8e, 0xbc, 0xbf, 0x6f, 0x8e, 0xbc, 0xef, 0x9f, 0xb8, 0x8b, 0x30, 0x61, 0xff, 0xab,
	0x7b, 0xfe, 0xbf, 0x69, 0x60, 0x7f, 0xae, 0x0f, 0xff, 0x09, 0x00, 0x00, 0xff, 0xff, 0x8c, 0x12,
	0x7a, 0xb4, 0x21, 0x07, 0x00, 0x00,
}

func (m *StringMatch) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StringMatch) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *StringMatch) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.MatchType != nil {
		{
			size := m.MatchType.Size()
			i -= size
			if _, err := m.MatchType.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	return len(dAtA) - i, nil
}

func (m *StringMatch_Exact) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *StringMatch_Exact) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i -= len(m.Exact)
	copy(dAtA[i:], m.Exact)
	i = encodeVarintPolicy(dAtA, i, uint64(len(m.Exact)))
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}
func (m *StringMatch_Prefix) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *StringMatch_Prefix) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i -= len(m.Prefix)
	copy(dAtA[i:], m.Prefix)
	i = encodeVarintPolicy(dAtA, i, uint64(len(m.Prefix)))
	i--
	dAtA[i] = 0x12
	return len(dAtA) - i, nil
}
func (m *StringMatch_Suffix) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *StringMatch_Suffix) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i -= len(m.Suffix)
	copy(dAtA[i:], m.Suffix)
	i = encodeVarintPolicy(dAtA, i, uint64(len(m.Suffix)))
	i--
	dAtA[i] = 0x1a
	return len(dAtA) - i, nil
}
func (m *StringMatch_Regex) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *StringMatch_Regex) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i -= len(m.Regex)
	copy(dAtA[i:], m.Regex)
	i = encodeVarintPolicy(dAtA, i, uint64(len(m.Regex)))
	i--
	dAtA[i] = 0x22
	return len(dAtA) - i, nil
}
func (m *MutualTls) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MutualTls) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MutualTls) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Mode != 0 {
		i = encodeVarintPolicy(dAtA, i, uint64(m.Mode))
		i--
		dAtA[i] = 0x10
	}
	if m.AllowTls {
		i--
		if m.AllowTls {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *Jwt) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Jwt) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Jwt) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Jwks) > 0 {
		i -= len(m.Jwks)
		copy(dAtA[i:], m.Jwks)
		i = encodeVarintPolicy(dAtA, i, uint64(len(m.Jwks)))
		i--
		dAtA[i] = 0x52
	}
	if len(m.TriggerRules) > 0 {
		for iNdEx := len(m.TriggerRules) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.TriggerRules[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintPolicy(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x4a
		}
	}
	if len(m.JwtParams) > 0 {
		for iNdEx := len(m.JwtParams) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.JwtParams[iNdEx])
			copy(dAtA[i:], m.JwtParams[iNdEx])
			i = encodeVarintPolicy(dAtA, i, uint64(len(m.JwtParams[iNdEx])))
			i--
			dAtA[i] = 0x3a
		}
	}
	if len(m.JwtHeaders) > 0 {
		for iNdEx := len(m.JwtHeaders) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.JwtHeaders[iNdEx])
			copy(dAtA[i:], m.JwtHeaders[iNdEx])
			i = encodeVarintPolicy(dAtA, i, uint64(len(m.JwtHeaders[iNdEx])))
			i--
			dAtA[i] = 0x32
		}
	}
	if len(m.JwksUri) > 0 {
		i -= len(m.JwksUri)
		copy(dAtA[i:], m.JwksUri)
		i = encodeVarintPolicy(dAtA, i, uint64(len(m.JwksUri)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Audiences) > 0 {
		for iNdEx := len(m.Audiences) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Audiences[iNdEx])
			copy(dAtA[i:], m.Audiences[iNdEx])
			i = encodeVarintPolicy(dAtA, i, uint64(len(m.Audiences[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Issuer) > 0 {
		i -= len(m.Issuer)
		copy(dAtA[i:], m.Issuer)
		i = encodeVarintPolicy(dAtA, i, uint64(len(m.Issuer)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Jwt_TriggerRule) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Jwt_TriggerRule) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Jwt_TriggerRule) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.IncludedPaths) > 0 {
		for iNdEx := len(m.IncludedPaths) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.IncludedPaths[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintPolicy(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.ExcludedPaths) > 0 {
		for iNdEx := len(m.ExcludedPaths) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.ExcludedPaths[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintPolicy(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *PeerAuthenticationMethod) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PeerAuthenticationMethod) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PeerAuthenticationMethod) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Params != nil {
		{
			size := m.Params.Size()
			i -= size
			if _, err := m.Params.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	return len(dAtA) - i, nil
}

func (m *PeerAuthenticationMethod_Mtls) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PeerAuthenticationMethod_Mtls) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Mtls != nil {
		{
			size, err := m.Mtls.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPolicy(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}
func (m *PeerAuthenticationMethod_Jwt) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PeerAuthenticationMethod_Jwt) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Jwt != nil {
		{
			size, err := m.Jwt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPolicy(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	return len(dAtA) - i, nil
}
func (m *OriginAuthenticationMethod) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *OriginAuthenticationMethod) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *OriginAuthenticationMethod) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Jwt != nil {
		{
			size, err := m.Jwt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPolicy(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Policy) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Policy) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Policy) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.PrincipalBinding != 0 {
		i = encodeVarintPolicy(dAtA, i, uint64(m.PrincipalBinding))
		i--
		dAtA[i] = 0x30
	}
	if m.OriginIsOptional {
		i--
		if m.OriginIsOptional {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x28
	}
	if len(m.Origins) > 0 {
		for iNdEx := len(m.Origins) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Origins[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintPolicy(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x22
		}
	}
	if m.PeerIsOptional {
		i--
		if m.PeerIsOptional {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x18
	}
	if len(m.Peers) > 0 {
		for iNdEx := len(m.Peers) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Peers[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintPolicy(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Targets) > 0 {
		for iNdEx := len(m.Targets) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Targets[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintPolicy(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *TargetSelector) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TargetSelector) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *TargetSelector) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Ports) > 0 {
		for iNdEx := len(m.Ports) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Ports[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintPolicy(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintPolicy(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PortSelector) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PortSelector) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PortSelector) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Port != nil {
		{
			size := m.Port.Size()
			i -= size
			if _, err := m.Port.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	return len(dAtA) - i, nil
}

func (m *PortSelector_Number) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PortSelector_Number) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i = encodeVarintPolicy(dAtA, i, uint64(m.Number))
	i--
	dAtA[i] = 0x8
	return len(dAtA) - i, nil
}
func (m *PortSelector_Name) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PortSelector_Name) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i -= len(m.Name)
	copy(dAtA[i:], m.Name)
	i = encodeVarintPolicy(dAtA, i, uint64(len(m.Name)))
	i--
	dAtA[i] = 0x12
	return len(dAtA) - i, nil
}
func encodeVarintPolicy(dAtA []byte, offset int, v uint64) int {
	offset -= sovPolicy(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *StringMatch) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.MatchType != nil {
		n += m.MatchType.Size()
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *StringMatch_Exact) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Exact)
	n += 1 + l + sovPolicy(uint64(l))
	return n
}
func (m *StringMatch_Prefix) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Prefix)
	n += 1 + l + sovPolicy(uint64(l))
	return n
}
func (m *StringMatch_Suffix) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Suffix)
	n += 1 + l + sovPolicy(uint64(l))
	return n
}
func (m *StringMatch_Regex) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Regex)
	n += 1 + l + sovPolicy(uint64(l))
	return n
}
func (m *MutualTls) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.AllowTls {
		n += 2
	}
	if m.Mode != 0 {
		n += 1 + sovPolicy(uint64(m.Mode))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Jwt) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Issuer)
	if l > 0 {
		n += 1 + l + sovPolicy(uint64(l))
	}
	if len(m.Audiences) > 0 {
		for _, s := range m.Audiences {
			l = len(s)
			n += 1 + l + sovPolicy(uint64(l))
		}
	}
	l = len(m.JwksUri)
	if l > 0 {
		n += 1 + l + sovPolicy(uint64(l))
	}
	if len(m.JwtHeaders) > 0 {
		for _, s := range m.JwtHeaders {
			l = len(s)
			n += 1 + l + sovPolicy(uint64(l))
		}
	}
	if len(m.JwtParams) > 0 {
		for _, s := range m.JwtParams {
			l = len(s)
			n += 1 + l + sovPolicy(uint64(l))
		}
	}
	if len(m.TriggerRules) > 0 {
		for _, e := range m.TriggerRules {
			l = e.Size()
			n += 1 + l + sovPolicy(uint64(l))
		}
	}
	l = len(m.Jwks)
	if l > 0 {
		n += 1 + l + sovPolicy(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Jwt_TriggerRule) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.ExcludedPaths) > 0 {
		for _, e := range m.ExcludedPaths {
			l = e.Size()
			n += 1 + l + sovPolicy(uint64(l))
		}
	}
	if len(m.IncludedPaths) > 0 {
		for _, e := range m.IncludedPaths {
			l = e.Size()
			n += 1 + l + sovPolicy(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PeerAuthenticationMethod) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Params != nil {
		n += m.Params.Size()
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PeerAuthenticationMethod_Mtls) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Mtls != nil {
		l = m.Mtls.Size()
		n += 1 + l + sovPolicy(uint64(l))
	}
	return n
}
func (m *PeerAuthenticationMethod_Jwt) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Jwt != nil {
		l = m.Jwt.Size()
		n += 1 + l + sovPolicy(uint64(l))
	}
	return n
}
func (m *OriginAuthenticationMethod) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Jwt != nil {
		l = m.Jwt.Size()
		n += 1 + l + sovPolicy(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Policy) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Targets) > 0 {
		for _, e := range m.Targets {
			l = e.Size()
			n += 1 + l + sovPolicy(uint64(l))
		}
	}
	if len(m.Peers) > 0 {
		for _, e := range m.Peers {
			l = e.Size()
			n += 1 + l + sovPolicy(uint64(l))
		}
	}
	if m.PeerIsOptional {
		n += 2
	}
	if len(m.Origins) > 0 {
		for _, e := range m.Origins {
			l = e.Size()
			n += 1 + l + sovPolicy(uint64(l))
		}
	}
	if m.OriginIsOptional {
		n += 2
	}
	if m.PrincipalBinding != 0 {
		n += 1 + sovPolicy(uint64(m.PrincipalBinding))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *TargetSelector) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovPolicy(uint64(l))
	}
	if len(m.Ports) > 0 {
		for _, e := range m.Ports {
			l = e.Size()
			n += 1 + l + sovPolicy(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PortSelector) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Port != nil {
		n += m.Port.Size()
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PortSelector_Number) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 1 + sovPolicy(uint64(m.Number))
	return n
}
func (m *PortSelector_Name) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	n += 1 + l + sovPolicy(uint64(l))
	return n
}

func sovPolicy(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozPolicy(x uint64) (n int) {
	return sovPolicy(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *StringMatch) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPolicy
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StringMatch: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StringMatch: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Exact", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPolicy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPolicy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.MatchType = &StringMatch_Exact{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Prefix", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPolicy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPolicy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.MatchType = &StringMatch_Prefix{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Suffix", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPolicy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPolicy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.MatchType = &StringMatch_Suffix{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Regex", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPolicy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPolicy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.MatchType = &StringMatch_Regex{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPolicy(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthPolicy
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MutualTls) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPolicy
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MutualTls: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MutualTls: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AllowTls", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.AllowTls = bool(v != 0)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Mode", wireType)
			}
			m.Mode = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Mode |= MutualTls_Mode(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipPolicy(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthPolicy
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Jwt) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPolicy
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Jwt: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Jwt: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Issuer", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPolicy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPolicy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Issuer = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Audiences", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPolicy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPolicy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Audiences = append(m.Audiences, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field JwksUri", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPolicy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPolicy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.JwksUri = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field JwtHeaders", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPolicy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPolicy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.JwtHeaders = append(m.JwtHeaders, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field JwtParams", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPolicy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPolicy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.JwtParams = append(m.JwtParams, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TriggerRules", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPolicy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPolicy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TriggerRules = append(m.TriggerRules, &Jwt_TriggerRule{})
			if err := m.TriggerRules[len(m.TriggerRules)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Jwks", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPolicy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPolicy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Jwks = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPolicy(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthPolicy
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Jwt_TriggerRule) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPolicy
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TriggerRule: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TriggerRule: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExcludedPaths", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPolicy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPolicy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ExcludedPaths = append(m.ExcludedPaths, &StringMatch{})
			if err := m.ExcludedPaths[len(m.ExcludedPaths)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IncludedPaths", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPolicy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPolicy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.IncludedPaths = append(m.IncludedPaths, &StringMatch{})
			if err := m.IncludedPaths[len(m.IncludedPaths)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPolicy(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthPolicy
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PeerAuthenticationMethod) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPolicy
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PeerAuthenticationMethod: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PeerAuthenticationMethod: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Mtls", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPolicy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPolicy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &MutualTls{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Params = &PeerAuthenticationMethod_Mtls{v}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Jwt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPolicy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPolicy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Jwt{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Params = &PeerAuthenticationMethod_Jwt{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPolicy(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthPolicy
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *OriginAuthenticationMethod) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPolicy
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: OriginAuthenticationMethod: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: OriginAuthenticationMethod: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Jwt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPolicy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPolicy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Jwt == nil {
				m.Jwt = &Jwt{}
			}
			if err := m.Jwt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPolicy(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthPolicy
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Policy) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPolicy
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Policy: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Policy: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Targets", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPolicy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPolicy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Targets = append(m.Targets, &TargetSelector{})
			if err := m.Targets[len(m.Targets)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Peers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPolicy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPolicy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Peers = append(m.Peers, &PeerAuthenticationMethod{})
			if err := m.Peers[len(m.Peers)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PeerIsOptional", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.PeerIsOptional = bool(v != 0)
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Origins", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPolicy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPolicy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Origins = append(m.Origins, &OriginAuthenticationMethod{})
			if err := m.Origins[len(m.Origins)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field OriginIsOptional", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.OriginIsOptional = bool(v != 0)
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PrincipalBinding", wireType)
			}
			m.PrincipalBinding = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.PrincipalBinding |= PrincipalBinding(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipPolicy(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthPolicy
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TargetSelector) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPolicy
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TargetSelector: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TargetSelector: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPolicy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPolicy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ports", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPolicy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPolicy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Ports = append(m.Ports, &PortSelector{})
			if err := m.Ports[len(m.Ports)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPolicy(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthPolicy
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PortSelector) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPolicy
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PortSelector: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PortSelector: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Number", wireType)
			}
			var v uint32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Port = &PortSelector_Number{v}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPolicy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPolicy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Port = &PortSelector_Name{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPolicy(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthPolicy
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipPolicy(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowPolicy
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthPolicy
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupPolicy
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthPolicy
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthPolicy        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowPolicy          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupPolicy = fmt.Errorf("proto: unexpected end of group")
)
