// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: mesh/v1alpha1/config.proto

// Configuration affecting the service mesh as a whole.

package v1alpha1

import (
	fmt "fmt"
	proto "github.com/gogo/protobuf/proto"
	types "github.com/gogo/protobuf/types"
	io "io"
	v1alpha3 "istio.io/api/networking/v1alpha3"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

// Resource describes the source of configuration
type Resource int32

const (
	// Set to only receive service entries that are generated by the platform.
	// These auto generated service entries are combination of services and endpoints
	// that are generated by a specific platform e.g. k8
	Resource_SERVICE_REGISTRY Resource = 0
)

var Resource_name = map[int32]string{
	0: "SERVICE_REGISTRY",
}

var Resource_value = map[string]int32{
	"SERVICE_REGISTRY": 0,
}

func (x Resource) String() string {
	return proto.EnumName(Resource_name, int32(x))
}

func (Resource) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_b5c7ece76d5d5022, []int{0}
}

type MeshConfig_IngressControllerMode int32

const (
	// Unspecified Istio ingress controller.
	MeshConfig_UNSPECIFIED MeshConfig_IngressControllerMode = 0
	// Disables Istio ingress controller.
	MeshConfig_OFF MeshConfig_IngressControllerMode = 1
	// Istio ingress controller will act on ingress resources that do not
	// contain any annotation or whose annotations match the value
	// specified in the ingress_class parameter described earlier. Use this
	// mode if Istio ingress controller will be the default ingress
	// controller for the entire Kubernetes cluster.
	MeshConfig_DEFAULT MeshConfig_IngressControllerMode = 2
	// Istio ingress controller will only act on ingress resources whose
	// annotations match the value specified in the ingress_class parameter
	// described earlier. Use this mode if Istio ingress controller will be
	// a secondary ingress controller (e.g., in addition to a
	// cloud-provided ingress controller).
	MeshConfig_STRICT MeshConfig_IngressControllerMode = 3
)

var MeshConfig_IngressControllerMode_name = map[int32]string{
	0: "UNSPECIFIED",
	1: "OFF",
	2: "DEFAULT",
	3: "STRICT",
}

var MeshConfig_IngressControllerMode_value = map[string]int32{
	"UNSPECIFIED": 0,
	"OFF":         1,
	"DEFAULT":     2,
	"STRICT":      3,
}

func (x MeshConfig_IngressControllerMode) String() string {
	return proto.EnumName(MeshConfig_IngressControllerMode_name, int32(x))
}

func (MeshConfig_IngressControllerMode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_b5c7ece76d5d5022, []int{0, 0}
}

// $hide_from_docs
type MeshConfig_AuthPolicy int32

const (
	MeshConfig_NONE       MeshConfig_AuthPolicy = 0
	MeshConfig_MUTUAL_TLS MeshConfig_AuthPolicy = 1
)

var MeshConfig_AuthPolicy_name = map[int32]string{
	0: "NONE",
	1: "MUTUAL_TLS",
}

var MeshConfig_AuthPolicy_value = map[string]int32{
	"NONE":       0,
	"MUTUAL_TLS": 1,
}

func (x MeshConfig_AuthPolicy) String() string {
	return proto.EnumName(MeshConfig_AuthPolicy_name, int32(x))
}

func (MeshConfig_AuthPolicy) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_b5c7ece76d5d5022, []int{0, 1}
}

type MeshConfig_AccessLogEncoding int32

const (
	// text encoding for the proxy access log
	MeshConfig_TEXT MeshConfig_AccessLogEncoding = 0
	// json encoding for the proxy access log
	MeshConfig_JSON MeshConfig_AccessLogEncoding = 1
)

var MeshConfig_AccessLogEncoding_name = map[int32]string{
	0: "TEXT",
	1: "JSON",
}

var MeshConfig_AccessLogEncoding_value = map[string]int32{
	"TEXT": 0,
	"JSON": 1,
}

func (x MeshConfig_AccessLogEncoding) String() string {
	return proto.EnumName(MeshConfig_AccessLogEncoding_name, int32(x))
}

func (MeshConfig_AccessLogEncoding) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_b5c7ece76d5d5022, []int{0, 2}
}

// Default Policy for upgrading http1.1 connections to http2.
type MeshConfig_H2UpgradePolicy int32

const (
	// Do not upgrade connections to http2.
	MeshConfig_DO_NOT_UPGRADE MeshConfig_H2UpgradePolicy = 0
	// Upgrade the connections to http2.
	MeshConfig_UPGRADE MeshConfig_H2UpgradePolicy = 1
)

var MeshConfig_H2UpgradePolicy_name = map[int32]string{
	0: "DO_NOT_UPGRADE",
	1: "UPGRADE",
}

var MeshConfig_H2UpgradePolicy_value = map[string]int32{
	"DO_NOT_UPGRADE": 0,
	"UPGRADE":        1,
}

func (x MeshConfig_H2UpgradePolicy) String() string {
	return proto.EnumName(MeshConfig_H2UpgradePolicy_name, int32(x))
}

func (MeshConfig_H2UpgradePolicy) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_b5c7ece76d5d5022, []int{0, 3}
}

type MeshConfig_OutboundTrafficPolicy_Mode int32

const (
	// outbound traffic will be restricted to services defined in the
	// service registry as well as those defined through ServiceEntries
	MeshConfig_OutboundTrafficPolicy_REGISTRY_ONLY MeshConfig_OutboundTrafficPolicy_Mode = 0
	// outbound traffic to unknown destinations will be allowed, in case
	// there are no services or ServiceEntries for the destination port
	MeshConfig_OutboundTrafficPolicy_ALLOW_ANY MeshConfig_OutboundTrafficPolicy_Mode = 1
)

var MeshConfig_OutboundTrafficPolicy_Mode_name = map[int32]string{
	0: "REGISTRY_ONLY",
	1: "ALLOW_ANY",
}

var MeshConfig_OutboundTrafficPolicy_Mode_value = map[string]int32{
	"REGISTRY_ONLY": 0,
	"ALLOW_ANY":     1,
}

func (x MeshConfig_OutboundTrafficPolicy_Mode) String() string {
	return proto.EnumName(MeshConfig_OutboundTrafficPolicy_Mode_name, int32(x))
}

func (MeshConfig_OutboundTrafficPolicy_Mode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_b5c7ece76d5d5022, []int{0, 0, 0}
}

// TraceContext selects the context propagation headers used for
// distributed tracing.
type MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider_TraceContext int32

const (
	// $hide_from_docs
	// Unspecified context. Should not be used for now, but added to reserve
	// the 0 enum value if TraceContext is used outside of a repeated field.
	MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider_UNSPECIFIED MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider_TraceContext = 0
	// Use W3C Trace Context propagation using the `traceparent` HTTP header.
	// See the
	// [Trace Context documentation](https://www.w3.org/TR/trace-context/) for details.
	MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider_W3C_TRACE_CONTEXT MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider_TraceContext = 1
	// Use gRPC binary context propagation using the `grpc-trace-bin` http header.
	MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider_GRPC_BIN MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider_TraceContext = 2
	// Use Cloud Trace context propagation using the
	// `X-Cloud-Trace-Context` http header.
	MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider_CLOUD_TRACE_CONTEXT MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider_TraceContext = 3
	// Use multi-header B3 context propagation using the `X-B3-TraceId`,
	// `X-B3-SpanId`, and `X-B3-Sampled` HTTP headers. See
	// [B3 header propagation README](https://github.com/openzipkin/b3-propagation)
	// for details.
	MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider_B3 MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider_TraceContext = 4
)

var MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider_TraceContext_name = map[int32]string{
	0: "UNSPECIFIED",
	1: "W3C_TRACE_CONTEXT",
	2: "GRPC_BIN",
	3: "CLOUD_TRACE_CONTEXT",
	4: "B3",
}

var MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider_TraceContext_value = map[string]int32{
	"UNSPECIFIED":         0,
	"W3C_TRACE_CONTEXT":   1,
	"GRPC_BIN":            2,
	"CLOUD_TRACE_CONTEXT": 3,
	"B3":                  4,
}

func (x MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider_TraceContext) String() string {
	return proto.EnumName(MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider_TraceContext_name, int32(x))
}

func (MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider_TraceContext) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_b5c7ece76d5d5022, []int{0, 5, 7, 0}
}

type MeshConfig_ProxyPathNormalization_NormalizationType int32

const (
	// Apply default normalizations. Currently, this is BASE.
	MeshConfig_ProxyPathNormalization_DEFAULT MeshConfig_ProxyPathNormalization_NormalizationType = 0
	// No normalization, paths are used as is.
	MeshConfig_ProxyPathNormalization_NONE MeshConfig_ProxyPathNormalization_NormalizationType = 1
	// Normalize according to [RFC 3986](https://tools.ietf.org/html/rfc3986).
	// For Envoy proxies, this is the [`normalize_path`](https://www.envoyproxy.io/docs/envoy/latest/api-v3/extensions/filters/network/http_connection_manager/v3/http_connection_manager.proto.html) option.
	// For example, `/a/../b` normalizes to `/b`.
	MeshConfig_ProxyPathNormalization_BASE MeshConfig_ProxyPathNormalization_NormalizationType = 2
	// In addition to the `BASE` normalization, consecutive slashes are also merged.
	// For example, `/a//b` normalizes to `a/b`.
	MeshConfig_ProxyPathNormalization_MERGE_SLASHES MeshConfig_ProxyPathNormalization_NormalizationType = 3
	// In addition to normalization in `MERGE_SLASHES`, slash characters are UTF-8 decoded (case insensitive) prior to merging.
	// This means `%2F`, `%2f`, `%5C`, and `%5c` sequences in the request path will be rewritten to `/` or `\`.
	// For example, `/a%2f/b` normalizes to `a/b`.
	MeshConfig_ProxyPathNormalization_DECODE_AND_MERGE_SLASHES MeshConfig_ProxyPathNormalization_NormalizationType = 4
)

var MeshConfig_ProxyPathNormalization_NormalizationType_name = map[int32]string{
	0: "DEFAULT",
	1: "NONE",
	2: "BASE",
	3: "MERGE_SLASHES",
	4: "DECODE_AND_MERGE_SLASHES",
}

var MeshConfig_ProxyPathNormalization_NormalizationType_value = map[string]int32{
	"DEFAULT":                  0,
	"NONE":                     1,
	"BASE":                     2,
	"MERGE_SLASHES":            3,
	"DECODE_AND_MERGE_SLASHES": 4,
}

func (x MeshConfig_ProxyPathNormalization_NormalizationType) String() string {
	return proto.EnumName(MeshConfig_ProxyPathNormalization_NormalizationType_name, int32(x))
}

func (MeshConfig_ProxyPathNormalization_NormalizationType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_b5c7ece76d5d5022, []int{0, 7, 0}
}

// MeshConfig defines mesh-wide settings for the Istio service mesh.
type MeshConfig struct {
	// Port on which Envoy should listen for incoming connections from
	// other services. Default port is 15001.
	ProxyListenPort int32 `protobuf:"varint,4,opt,name=proxy_listen_port,json=proxyListenPort,proto3" json:"proxyListenPort,omitempty"`
	// Port on which Envoy should listen for HTTP PROXY requests if set.
	ProxyHttpPort int32 `protobuf:"varint,5,opt,name=proxy_http_port,json=proxyHttpPort,proto3" json:"proxyHttpPort,omitempty"`
	// Connection timeout used by Envoy. (MUST BE >=1ms)
	// Default timeout is 10s.
	ConnectTimeout *types.Duration `protobuf:"bytes,6,opt,name=connect_timeout,json=connectTimeout,proto3" json:"connectTimeout,omitempty"`
	// Automatic protocol detection uses a set of heuristics to
	// determine whether the connection is using TLS or not (on the
	// server side), as well as the application protocol being used
	// (e.g., http vs tcp). These heuristics rely on the client sending
	// the first bits of data. For server first protocols like MySQL,
	// MongoDB, etc. Envoy will timeout on the protocol detection after
	// the specified period, defaulting to non mTLS plain TCP
	// traffic. Set this field to tweak the period that Envoy will wait
	// for the client to send the first bits of data. (MUST BE >=1ms or
	// 0s to disable). Default detection timeout is 5s.
	ProtocolDetectionTimeout *types.Duration `protobuf:"bytes,42,opt,name=protocol_detection_timeout,json=protocolDetectionTimeout,proto3" json:"protocolDetectionTimeout,omitempty"`
	// If set then set `SO_KEEPALIVE` on the socket to enable TCP Keepalives.
	TcpKeepalive *v1alpha3.ConnectionPoolSettings_TCPSettings_TcpKeepalive `protobuf:"bytes,28,opt,name=tcp_keepalive,json=tcpKeepalive,proto3" json:"tcpKeepalive,omitempty"`
	// Class of ingress resources to be processed by Istio ingress
	// controller. This corresponds to the value of
	// `kubernetes.io/ingress.class` annotation.
	IngressClass string `protobuf:"bytes,7,opt,name=ingress_class,json=ingressClass,proto3" json:"ingressClass,omitempty"`
	// Name of the Kubernetes service used for the istio ingress controller.
	// If no ingress controller is specified, the default value `istio-ingressgateway` is used.
	IngressService string `protobuf:"bytes,8,opt,name=ingress_service,json=ingressService,proto3" json:"ingressService,omitempty"`
	// Defines whether to use Istio ingress controller for annotated or all ingress resources.
	// Default mode is `STRICT`.
	IngressControllerMode MeshConfig_IngressControllerMode `protobuf:"varint,9,opt,name=ingress_controller_mode,json=ingressControllerMode,proto3,enum=istio.mesh.v1alpha1.MeshConfig_IngressControllerMode" json:"ingressControllerMode,omitempty"`
	// Defines which gateway deployment to use as the Ingress controller. This field corresponds to
	// the Gateway.selector field, and will be set as `istio: INGRESS_SELECTOR`.
	// By default, `ingressgateway` is used, which will select the default IngressGateway as it has the
	// `istio: ingressgateway` labels.
	// It is recommended that this is the same value as ingress_service.
	IngressSelector string `protobuf:"bytes,52,opt,name=ingress_selector,json=ingressSelector,proto3" json:"ingressSelector,omitempty"`
	// Flag to control generation of trace spans and request IDs.
	// Requires a trace span collector defined in the proxy configuration.
	EnableTracing bool `protobuf:"varint,12,opt,name=enable_tracing,json=enableTracing,proto3" json:"enableTracing,omitempty"`
	// File address for the proxy access log (e.g. /dev/stdout).
	// Empty value disables access logging.
	AccessLogFile string `protobuf:"bytes,13,opt,name=access_log_file,json=accessLogFile,proto3" json:"accessLogFile,omitempty"`
	// Format for the proxy access log
	// Empty value results in proxy's default access log format
	AccessLogFormat string `protobuf:"bytes,24,opt,name=access_log_format,json=accessLogFormat,proto3" json:"accessLogFormat,omitempty"`
	// Encoding for the proxy access log (`TEXT` or `JSON`).
	// Default value is `TEXT`.
	AccessLogEncoding MeshConfig_AccessLogEncoding `protobuf:"varint,27,opt,name=access_log_encoding,json=accessLogEncoding,proto3,enum=istio.mesh.v1alpha1.MeshConfig_AccessLogEncoding" json:"accessLogEncoding,omitempty"`
	// This flag enables Envoy's gRPC Access Log Service.
	// See [Access Log Service](https://www.envoyproxy.io/docs/envoy/latest/api-v2/config/accesslog/v2/als.proto)
	// for details about Envoy's gRPC Access Log Service API.
	// Default value is `false`.
	EnableEnvoyAccessLogService bool `protobuf:"varint,40,opt,name=enable_envoy_access_log_service,json=enableEnvoyAccessLogService,proto3" json:"enableEnvoyAccessLogService,omitempty"`
	// This flag disables Envoy Listener logs.
	// See [Listener Access Log](https://www.envoyproxy.io/docs/envoy/latest/api-v3/config/listener/v3/listener.proto#envoy-v3-api-field-config-listener-v3-listener-access-log)
	// Istio Enables Envoy's listener access logs on "NoRoute" response flag.
	// Default value is `false`.
	DisableEnvoyListenerLog bool `protobuf:"varint,56,opt,name=disable_envoy_listener_log,json=disableEnvoyListenerLog,proto3" json:"disableEnvoyListenerLog,omitempty"`
	// Default proxy config used by gateway and sidecars.
	// In case of Kubernetes, the proxy config is applied once during the injection process,
	// and remain constant for the duration of the pod. The rest of the mesh config can be changed
	// at runtime and config gets distributed dynamically.
	// On Kubernetes, this can be overridden on individual pods with the `proxy.istio.io/config` annotation.
	DefaultConfig *ProxyConfig `protobuf:"bytes,14,opt,name=default_config,json=defaultConfig,proto3" json:"defaultConfig,omitempty"`
	// Set the default behavior of the sidecar for handling outbound
	// traffic from the application.  If your application uses one or
	// more external services that are not known apriori, setting the
	// policy to `ALLOW_ANY` will cause the sidecars to route any unknown
	// traffic originating from the application to its requested
	// destination. Users are strongly encouraged to use ServiceEntries
	// to explicitly declare any external dependencies, instead of using
	// `ALLOW_ANY`, so that traffic to these services can be
	// monitored. Can be overridden at a Sidecar level by setting the
	// `OutboundTrafficPolicy` in the [Sidecar
	// API](https://istio.io/docs/reference/config/networking/sidecar/#OutboundTrafficPolicy).
	// Default mode is `ALLOW_ANY` which means outbound traffic to unknown destinations will be allowed.
	OutboundTrafficPolicy *MeshConfig_OutboundTrafficPolicy `protobuf:"bytes,17,opt,name=outbound_traffic_policy,json=outboundTrafficPolicy,proto3" json:"outboundTrafficPolicy,omitempty"`
	// ConfigSource describes a source of configuration data for networking
	// rules, and other Istio configuration artifacts. Multiple data sources
	// can be configured for a single control plane.
	ConfigSources []*ConfigSource `protobuf:"bytes,22,rep,name=config_sources,json=configSources,proto3" json:"configSources,omitempty"`
	// This flag is used to enable mutual `TLS` automatically for service to service communication
	// within the mesh, default true.
	// If set to true, and a given service does not have a corresponding `DestinationRule` configured,
	// or its `DestinationRule` does not have ClientTLSSettings specified, Istio configures client side
	// TLS configuration appropriately. More specifically,
	// If the upstream authentication policy is in `STRICT` mode, use Istio provisioned certificate
	// for mutual `TLS` to connect to upstream.
	// If upstream service is in plain text mode, use plain text.
	// If the upstream authentication policy is in PERMISSIVE mode, Istio configures clients to use
	// mutual `TLS` when server sides are capable of accepting mutual `TLS` traffic.
	// If service `DestinationRule` exists and has `ClientTLSSettings` specified, that is always used instead.
	EnableAutoMtls *types.BoolValue `protobuf:"bytes,43,opt,name=enable_auto_mtls,json=enableAutoMtls,proto3" json:"enableAutoMtls,omitempty"`
	// The trust domain corresponds to the trust root of a system.
	// Refer to [SPIFFE-ID](https://github.com/spiffe/spiffe/blob/master/standards/SPIFFE-ID.md#21-trust-domain)
	TrustDomain string `protobuf:"bytes,26,opt,name=trust_domain,json=trustDomain,proto3" json:"trustDomain,omitempty"`
	// The trust domain aliases represent the aliases of `trust_domain`.
	// For example, if we have
	// ```yaml
	// trustDomain: td1
	// trustDomainAliases: ["td2", "td3"]
	// ```
	// Any service with the identity `td1/ns/foo/sa/a-service-account`, `td2/ns/foo/sa/a-service-account`,
	// or `td3/ns/foo/sa/a-service-account` will be treated the same in the Istio mesh.
	TrustDomainAliases []string `protobuf:"bytes,46,rep,name=trust_domain_aliases,json=trustDomainAliases,proto3" json:"trustDomainAliases,omitempty"`
	// The extra root certificates for workload-to-workload communication.
	// The plugin certificates (the 'cacerts' secret) or self-signed certificates (the 'istio-ca-secret' secret)
	// are automatically added by Istiod.
	// The CA certificate that signs the workload certificates is automatically added by Istio Agent.
	CaCertificates []*MeshConfig_CertificateData `protobuf:"bytes,58,rep,name=ca_certificates,json=caCertificates,proto3" json:"caCertificates,omitempty"`
	// The default value for the ServiceEntry.export_to field and services
	// imported through container registry integrations, e.g. this applies to
	// Kubernetes Service resources. The value is a list of namespace names and
	// reserved namespace aliases. The allowed namespace aliases are:
	// ```
	// * - All Namespaces
	// . - Current Namespace
	// ~ - No Namespace
	// ```
	// If not set the system will use "*" as the default value which implies that
	// services are exported to all namespaces.
	//
	// `All namespaces` is a reasonable default for implementations that don't
	// need to restrict access or visibility of services across namespace
	// boundaries. If that requirement is present it is generally good practice to
	// make the default `Current namespace` so that services are only visible
	// within their own namespaces by default. Operators can then expand the
	// visibility of services to other namespaces as needed. Use of `No Namespace`
	// is expected to be rare but can have utility for deployments where
	// dependency management needs to be precise even within the scope of a single
	// namespace.
	//
	// For further discussion see the reference documentation for `ServiceEntry`,
	// `Sidecar`, and `Gateway`.
	DefaultServiceExportTo []string `protobuf:"bytes,31,rep,name=default_service_export_to,json=defaultServiceExportTo,proto3" json:"defaultServiceExportTo,omitempty"`
	// The default value for the VirtualService.export_to field. Has the same
	// syntax as `default_service_export_to`.
	//
	// If not set the system will use "*" as the default value which implies that
	// virtual services are exported to all namespaces
	DefaultVirtualServiceExportTo []string `protobuf:"bytes,32,rep,name=default_virtual_service_export_to,json=defaultVirtualServiceExportTo,proto3" json:"defaultVirtualServiceExportTo,omitempty"`
	// The default value for the `DestinationRule.export_to` field. Has the same
	// syntax as `default_service_export_to`.
	//
	// If not set the system will use "*" as the default value which implies that
	// destination rules are exported to all namespaces
	DefaultDestinationRuleExportTo []string `protobuf:"bytes,33,rep,name=default_destination_rule_export_to,json=defaultDestinationRuleExportTo,proto3" json:"defaultDestinationRuleExportTo,omitempty"`
	// The namespace to treat as the administrative root namespace for
	// Istio configuration. When processing a leaf namespace Istio will search for
	// declarations in that namespace first and if none are found it will
	// search in the root namespace. Any matching declaration found in the root
	// namespace is processed as if it were declared in the leaf namespace.
	//
	// The precise semantics of this processing are documented on each resource
	// type.
	RootNamespace string `protobuf:"bytes,34,opt,name=root_namespace,json=rootNamespace,proto3" json:"rootNamespace,omitempty"`
	// Locality based load balancing distribution or failover settings.
	LocalityLbSetting *v1alpha3.LocalityLoadBalancerSetting `protobuf:"bytes,35,opt,name=locality_lb_setting,json=localityLbSetting,proto3" json:"localityLbSetting,omitempty"`
	// Configures DNS refresh rate for Envoy clusters of type `STRICT_DNS`
	// Default refresh rate is `5s`.
	DnsRefreshRate *types.Duration `protobuf:"bytes,36,opt,name=dns_refresh_rate,json=dnsRefreshRate,proto3" json:"dnsRefreshRate,omitempty"`
	// Specify if http1.1 connections should be upgraded to http2 by default.
	// if sidecar is installed on all pods in the mesh, then this should be set to `UPGRADE`.
	// If one or more services or namespaces do not have sidecar(s), then this should be set to `DO_NOT_UPGRADE`.
	// It can be enabled by destination using the `destinationRule.trafficPolicy.connectionPool.http.h2UpgradePolicy` override.
	H2UpgradePolicy MeshConfig_H2UpgradePolicy `protobuf:"varint,41,opt,name=h2_upgrade_policy,json=h2UpgradePolicy,proto3,enum=istio.mesh.v1alpha1.MeshConfig_H2UpgradePolicy" json:"h2UpgradePolicy,omitempty"`
	// Name to be used while emitting statistics for inbound clusters. The same pattern is used while computing stat prefix for
	// network filters like TCP and Redis.
	// By default, Istio emits statistics with the pattern `inbound|<port>|<port-name>|<service-FQDN>`.
	// For example `inbound|7443|grpc-reviews|reviews.prod.svc.cluster.local`. This can be used to override that pattern.
	//
	// A Pattern can be composed of various pre-defined variables. The following variables are supported.
	//
	// - `%SERVICE%` - Will be substituted with name of the service.
	// - `%SERVICE_FQDN%` - Will be substituted with FQDN of the service.
	// - `%SERVICE_PORT%` - Will be substituted with port of the service.
	// - `%SERVICE_PORT_NAME%` - Will be substituted with port name of the service.
	//
	// Following are some examples of supported patterns for reviews:
	//
	// - `%SERVICE_FQDN%_%SERVICE_PORT%` will use reviews.prod.svc.cluster.local_7443 as the stats name.
	// - `%SERVICE%` will use reviews.prod as the stats name.
	InboundClusterStatName string `protobuf:"bytes,44,opt,name=inbound_cluster_stat_name,json=inboundClusterStatName,proto3" json:"inboundClusterStatName,omitempty"`
	// Name to be used while emitting statistics for outbound clusters. The same pattern is used while computing stat prefix for
	// network filters like TCP and Redis.
	// By default, Istio emits statistics with the pattern `outbound|<port>|<subsetname>|<service-FQDN>`.
	// For example `outbound|8080|v2|reviews.prod.svc.cluster.local`. This can be used to override that pattern.
	//
	// A Pattern can be composed of various pre-defined variables. The following variables are supported.
	//
	// - `%SERVICE%` - Will be substituted with name of the service.
	// - `%SERVICE_FQDN%` - Will be substituted with FQDN of the service.
	// - `%SERVICE_PORT%` - Will be substituted with port of the service.
	// - `%SERVICE_PORT_NAME%` - Will be substituted with port name of the service.
	// - `%SUBSET_NAME%` - Will be substituted with subset.
	//
	// Following are some examples of supported patterns for reviews:
	//
	// - `%SERVICE_FQDN%_%SERVICE_PORT%` will use `reviews.prod.svc.cluster.local_7443` as the stats name.
	// - `%SERVICE%` will use reviews.prod as the stats name.
	OutboundClusterStatName string `protobuf:"bytes,45,opt,name=outbound_cluster_stat_name,json=outboundClusterStatName,proto3" json:"outboundClusterStatName,omitempty"`
	// Configure the provision of certificates.
	Certificates []*Certificate `protobuf:"bytes,47,rep,name=certificates,proto3" json:"certificates,omitempty"`
	// Set configuration for Thrift protocol
	ThriftConfig *MeshConfig_ThriftConfig `protobuf:"bytes,49,opt,name=thrift_config,json=thriftConfig,proto3" json:"thriftConfig,omitempty"`
	// $hide_from_docs
	// Settings to be applied to select services.
	ServiceSettings []*MeshConfig_ServiceSettings `protobuf:"bytes,50,rep,name=service_settings,json=serviceSettings,proto3" json:"serviceSettings,omitempty"`
	// If enabled, Istio agent will merge metrics exposed by the application with metrics from Envoy
	// and Istio agent. The sidecar injection will replace `prometheus.io` annotations present on the pod
	// and redirect them towards Istio agent, which will then merge metrics of from the application with Istio metrics.
	// This relies on the annotations `prometheus.io/scrape`, `prometheus.io/port`, and
	// `prometheus.io/path` annotations.
	// If you are running a separately managed Envoy with an Istio sidecar, this may cause issues, as the metrics will collide.
	// In this case, it is recommended to disable aggregation on that deployment with the
	// `prometheus.istio.io/merge-metrics: "false"` annotation.
	// If not specified, this will be enabled by default.
	EnablePrometheusMerge *types.BoolValue `protobuf:"bytes,51,opt,name=enable_prometheus_merge,json=enablePrometheusMerge,proto3" json:"enablePrometheusMerge,omitempty"`
	// `VerifyCertificateAtClient` sets the mesh global default for peer certificate validation
	// at the client-side proxy when `SIMPLE` TLS or `MUTUAL` TLS (non `ISTIO_MUTUAL`) origination
	// modes are used. This setting can be overridden at the host level via DestinationRule API.
	// By default, `VerifyCertificateAtClient` is `true`.
	//
	// `CaCertificates`: If set, proxy verifies CA signature based on given CaCertificates. If unset,
	// and VerifyCertificateAtClient is true, proxy uses default System CA bundle. If unset and
	// `VerifyCertificateAtClient` is false, proxy will not verify the CA.
	//
	// `SubjectAltNames`: If set, proxy verifies subject alt names are present in the SAN. If unset,
	// and `VerifyCertificateAtClient` is true, proxy uses host in destination rule to verify the SANs.
	// If unset, and `VerifyCertificateAtClient` is false, proxy does not verify SANs.
	//
	// For SAN, client-side proxy will exact match host in `DestinationRule` as well as one level
	// wildcard if the specified host in DestinationRule doesn't contain a wildcard.
	// For example, if the host in `DestinationRule` is `x.y.com`, client-side proxy will
	// match either `x.y.com` or `*.y.com` for the SAN in the presented server certificate.
	// For wildcard host name in DestinationRule, client-side proxy will do a suffix match. For example,
	// if host is `*.x.y.com`, client-side proxy will verify the presented server certificate SAN matches
	// ``.x.y.com` suffix.
	VerifyCertificateAtClient *types.BoolValue `protobuf:"bytes,54,opt,name=verify_certificate_at_client,json=verifyCertificateAtClient,proto3" json:"verifyCertificateAtClient,omitempty"`
	// $hide_from_docs
	// If specified, Istiod will authorize and forward the CSRs from the workloads to the specified external CA
	// using the Istio CA gRPC API.
	Ca *MeshConfig_CA `protobuf:"bytes,55,opt,name=ca,proto3" json:"ca,omitempty"`
	// Defines a list of extension providers that extend Istio's functionality. For example, the AuthorizationPolicy
	// can be used with an extension provider to delegate the authorization decision to a custom authorization system.
	ExtensionProviders []*MeshConfig_ExtensionProvider `protobuf:"bytes,57,rep,name=extension_providers,json=extensionProviders,proto3" json:"extensionProviders,omitempty"`
	// Specifies extension providers to use by default in Istio configuration resources.
	DefaultProviders *MeshConfig_DefaultProviders `protobuf:"bytes,60,opt,name=default_providers,json=defaultProviders,proto3" json:"defaultProviders,omitempty"`
	// A list of Kubernetes selectors that specify the set of namespaces that Istio considers when
	// computing configuration updates for sidecars. This can be used to reduce Istio's computational load
	// by limiting the number of entities (including services, pods, and endpoints) that are watched and processed.
	// If omitted, Istio will use the default behavior of processing all namespaces in the cluster.
	// Elements in the list are disjunctive (OR semantics), i.e. a namespace will be included if it matches any selector.
	// The following example selects any namespace that matches either below:
	// 1. The namespace has both of these labels: `env: prod` and `region: us-east1`
	// 2. The namespace has label `app` equal to `cassandra` or `spark`.
	// ```yaml
	// discoverySelectors:
	//   - matchLabels:
	//       env: prod
	//       region: us-east1
	//   - matchExpressions:
	//     - key: app
	//       operator: In
	//       values:
	//         - cassandra
	//         - spark
	// ```
	// Refer to the [kubernetes selector docs](https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors)
	// for additional detail on selector semantics.
	DiscoverySelectors []*v1.LabelSelector `protobuf:"bytes,59,rep,name=discovery_selectors,json=discoverySelectors,proto3" json:"discoverySelectors,omitempty"`
	// ProxyPathNormalization configures how URL paths in incoming and outgoing HTTP requests are
	// normalized by the sidecars and gateways.
	// The normalized paths will be used in all aspects through the requests' lifetime on the
	// sidecars and gateways, which includes routing decisions in outbound direction (client proxy),
	// authorization policy match and enforcement in inbound direction (server proxy), and the URL
	// path proxied to the upstream service.
	// If not set, the NormalizationType.DEFAULT configuration will be used.
	PathNormalization    *MeshConfig_ProxyPathNormalization `protobuf:"bytes,61,opt,name=path_normalization,json=pathNormalization,proto3" json:"pathNormalization,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                           `json:"-"`
	XXX_unrecognized     []byte                             `json:"-"`
	XXX_sizecache        int32                              `json:"-"`
}

func (m *MeshConfig) Reset()         { *m = MeshConfig{} }
func (m *MeshConfig) String() string { return proto.CompactTextString(m) }
func (*MeshConfig) ProtoMessage()    {}
func (*MeshConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_b5c7ece76d5d5022, []int{0}
}
func (m *MeshConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MeshConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MeshConfig.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *MeshConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MeshConfig.Merge(m, src)
}
func (m *MeshConfig) XXX_Size() int {
	return m.Size()
}
func (m *MeshConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_MeshConfig.DiscardUnknown(m)
}

var xxx_messageInfo_MeshConfig proto.InternalMessageInfo

func (m *MeshConfig) GetProxyListenPort() int32 {
	if m != nil {
		return m.ProxyListenPort
	}
	return 0
}

func (m *MeshConfig) GetProxyHttpPort() int32 {
	if m != nil {
		return m.ProxyHttpPort
	}
	return 0
}

func (m *MeshConfig) GetConnectTimeout() *types.Duration {
	if m != nil {
		return m.ConnectTimeout
	}
	return nil
}

func (m *MeshConfig) GetProtocolDetectionTimeout() *types.Duration {
	if m != nil {
		return m.ProtocolDetectionTimeout
	}
	return nil
}

func (m *MeshConfig) GetTcpKeepalive() *v1alpha3.ConnectionPoolSettings_TCPSettings_TcpKeepalive {
	if m != nil {
		return m.TcpKeepalive
	}
	return nil
}

func (m *MeshConfig) GetIngressClass() string {
	if m != nil {
		return m.IngressClass
	}
	return ""
}

func (m *MeshConfig) GetIngressService() string {
	if m != nil {
		return m.IngressService
	}
	return ""
}

func (m *MeshConfig) GetIngressControllerMode() MeshConfig_IngressControllerMode {
	if m != nil {
		return m.IngressControllerMode
	}
	return MeshConfig_UNSPECIFIED
}

func (m *MeshConfig) GetIngressSelector() string {
	if m != nil {
		return m.IngressSelector
	}
	return ""
}

func (m *MeshConfig) GetEnableTracing() bool {
	if m != nil {
		return m.EnableTracing
	}
	return false
}

func (m *MeshConfig) GetAccessLogFile() string {
	if m != nil {
		return m.AccessLogFile
	}
	return ""
}

func (m *MeshConfig) GetAccessLogFormat() string {
	if m != nil {
		return m.AccessLogFormat
	}
	return ""
}

func (m *MeshConfig) GetAccessLogEncoding() MeshConfig_AccessLogEncoding {
	if m != nil {
		return m.AccessLogEncoding
	}
	return MeshConfig_TEXT
}

func (m *MeshConfig) GetEnableEnvoyAccessLogService() bool {
	if m != nil {
		return m.EnableEnvoyAccessLogService
	}
	return false
}

func (m *MeshConfig) GetDisableEnvoyListenerLog() bool {
	if m != nil {
		return m.DisableEnvoyListenerLog
	}
	return false
}

func (m *MeshConfig) GetDefaultConfig() *ProxyConfig {
	if m != nil {
		return m.DefaultConfig
	}
	return nil
}

func (m *MeshConfig) GetOutboundTrafficPolicy() *MeshConfig_OutboundTrafficPolicy {
	if m != nil {
		return m.OutboundTrafficPolicy
	}
	return nil
}

func (m *MeshConfig) GetConfigSources() []*ConfigSource {
	if m != nil {
		return m.ConfigSources
	}
	return nil
}

func (m *MeshConfig) GetEnableAutoMtls() *types.BoolValue {
	if m != nil {
		return m.EnableAutoMtls
	}
	return nil
}

func (m *MeshConfig) GetTrustDomain() string {
	if m != nil {
		return m.TrustDomain
	}
	return ""
}

func (m *MeshConfig) GetTrustDomainAliases() []string {
	if m != nil {
		return m.TrustDomainAliases
	}
	return nil
}

func (m *MeshConfig) GetCaCertificates() []*MeshConfig_CertificateData {
	if m != nil {
		return m.CaCertificates
	}
	return nil
}

func (m *MeshConfig) GetDefaultServiceExportTo() []string {
	if m != nil {
		return m.DefaultServiceExportTo
	}
	return nil
}

func (m *MeshConfig) GetDefaultVirtualServiceExportTo() []string {
	if m != nil {
		return m.DefaultVirtualServiceExportTo
	}
	return nil
}

func (m *MeshConfig) GetDefaultDestinationRuleExportTo() []string {
	if m != nil {
		return m.DefaultDestinationRuleExportTo
	}
	return nil
}

func (m *MeshConfig) GetRootNamespace() string {
	if m != nil {
		return m.RootNamespace
	}
	return ""
}

func (m *MeshConfig) GetLocalityLbSetting() *v1alpha3.LocalityLoadBalancerSetting {
	if m != nil {
		return m.LocalityLbSetting
	}
	return nil
}

func (m *MeshConfig) GetDnsRefreshRate() *types.Duration {
	if m != nil {
		return m.DnsRefreshRate
	}
	return nil
}

func (m *MeshConfig) GetH2UpgradePolicy() MeshConfig_H2UpgradePolicy {
	if m != nil {
		return m.H2UpgradePolicy
	}
	return MeshConfig_DO_NOT_UPGRADE
}

func (m *MeshConfig) GetInboundClusterStatName() string {
	if m != nil {
		return m.InboundClusterStatName
	}
	return ""
}

func (m *MeshConfig) GetOutboundClusterStatName() string {
	if m != nil {
		return m.OutboundClusterStatName
	}
	return ""
}

func (m *MeshConfig) GetCertificates() []*Certificate {
	if m != nil {
		return m.Certificates
	}
	return nil
}

func (m *MeshConfig) GetThriftConfig() *MeshConfig_ThriftConfig {
	if m != nil {
		return m.ThriftConfig
	}
	return nil
}

func (m *MeshConfig) GetServiceSettings() []*MeshConfig_ServiceSettings {
	if m != nil {
		return m.ServiceSettings
	}
	return nil
}

func (m *MeshConfig) GetEnablePrometheusMerge() *types.BoolValue {
	if m != nil {
		return m.EnablePrometheusMerge
	}
	return nil
}

func (m *MeshConfig) GetVerifyCertificateAtClient() *types.BoolValue {
	if m != nil {
		return m.VerifyCertificateAtClient
	}
	return nil
}

func (m *MeshConfig) GetCa() *MeshConfig_CA {
	if m != nil {
		return m.Ca
	}
	return nil
}

func (m *MeshConfig) GetExtensionProviders() []*MeshConfig_ExtensionProvider {
	if m != nil {
		return m.ExtensionProviders
	}
	return nil
}

func (m *MeshConfig) GetDefaultProviders() *MeshConfig_DefaultProviders {
	if m != nil {
		return m.DefaultProviders
	}
	return nil
}

func (m *MeshConfig) GetDiscoverySelectors() []*v1.LabelSelector {
	if m != nil {
		return m.DiscoverySelectors
	}
	return nil
}

func (m *MeshConfig) GetPathNormalization() *MeshConfig_ProxyPathNormalization {
	if m != nil {
		return m.PathNormalization
	}
	return nil
}

type MeshConfig_OutboundTrafficPolicy struct {
	Mode                 MeshConfig_OutboundTrafficPolicy_Mode `protobuf:"varint,1,opt,name=mode,proto3,enum=istio.mesh.v1alpha1.MeshConfig_OutboundTrafficPolicy_Mode" json:"mode,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                              `json:"-"`
	XXX_unrecognized     []byte                                `json:"-"`
	XXX_sizecache        int32                                 `json:"-"`
}

func (m *MeshConfig_OutboundTrafficPolicy) Reset()         { *m = MeshConfig_OutboundTrafficPolicy{} }
func (m *MeshConfig_OutboundTrafficPolicy) String() string { return proto.CompactTextString(m) }
func (*MeshConfig_OutboundTrafficPolicy) ProtoMessage()    {}
func (*MeshConfig_OutboundTrafficPolicy) Descriptor() ([]byte, []int) {
	return fileDescriptor_b5c7ece76d5d5022, []int{0, 0}
}
func (m *MeshConfig_OutboundTrafficPolicy) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MeshConfig_OutboundTrafficPolicy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MeshConfig_OutboundTrafficPolicy.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *MeshConfig_OutboundTrafficPolicy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MeshConfig_OutboundTrafficPolicy.Merge(m, src)
}
func (m *MeshConfig_OutboundTrafficPolicy) XXX_Size() int {
	return m.Size()
}
func (m *MeshConfig_OutboundTrafficPolicy) XXX_DiscardUnknown() {
	xxx_messageInfo_MeshConfig_OutboundTrafficPolicy.DiscardUnknown(m)
}

var xxx_messageInfo_MeshConfig_OutboundTrafficPolicy proto.InternalMessageInfo

func (m *MeshConfig_OutboundTrafficPolicy) GetMode() MeshConfig_OutboundTrafficPolicy_Mode {
	if m != nil {
		return m.Mode
	}
	return MeshConfig_OutboundTrafficPolicy_REGISTRY_ONLY
}

type MeshConfig_CertificateData struct {
	// Types that are valid to be assigned to CertificateData:
	//	*MeshConfig_CertificateData_Pem
	//	*MeshConfig_CertificateData_SpiffeBundleUrl
	CertificateData      isMeshConfig_CertificateData_CertificateData `protobuf_oneof:"certificate_data"`
	XXX_NoUnkeyedLiteral struct{}                                     `json:"-"`
	XXX_unrecognized     []byte                                       `json:"-"`
	XXX_sizecache        int32                                        `json:"-"`
}

func (m *MeshConfig_CertificateData) Reset()         { *m = MeshConfig_CertificateData{} }
func (m *MeshConfig_CertificateData) String() string { return proto.CompactTextString(m) }
func (*MeshConfig_CertificateData) ProtoMessage()    {}
func (*MeshConfig_CertificateData) Descriptor() ([]byte, []int) {
	return fileDescriptor_b5c7ece76d5d5022, []int{0, 1}
}
func (m *MeshConfig_CertificateData) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MeshConfig_CertificateData) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MeshConfig_CertificateData.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *MeshConfig_CertificateData) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MeshConfig_CertificateData.Merge(m, src)
}
func (m *MeshConfig_CertificateData) XXX_Size() int {
	return m.Size()
}
func (m *MeshConfig_CertificateData) XXX_DiscardUnknown() {
	xxx_messageInfo_MeshConfig_CertificateData.DiscardUnknown(m)
}

var xxx_messageInfo_MeshConfig_CertificateData proto.InternalMessageInfo

type isMeshConfig_CertificateData_CertificateData interface {
	isMeshConfig_CertificateData_CertificateData()
	MarshalTo([]byte) (int, error)
	Size() int
}

type MeshConfig_CertificateData_Pem struct {
	Pem string `protobuf:"bytes,1,opt,name=pem,proto3,oneof" json:"pem,omitempty"`
}
type MeshConfig_CertificateData_SpiffeBundleUrl struct {
	SpiffeBundleUrl string `protobuf:"bytes,2,opt,name=spiffe_bundle_url,json=spiffeBundleUrl,proto3,oneof" json:"spiffeBundleUrl,omitempty"`
}

func (*MeshConfig_CertificateData_Pem) isMeshConfig_CertificateData_CertificateData()             {}
func (*MeshConfig_CertificateData_SpiffeBundleUrl) isMeshConfig_CertificateData_CertificateData() {}

func (m *MeshConfig_CertificateData) GetCertificateData() isMeshConfig_CertificateData_CertificateData {
	if m != nil {
		return m.CertificateData
	}
	return nil
}

func (m *MeshConfig_CertificateData) GetPem() string {
	if x, ok := m.GetCertificateData().(*MeshConfig_CertificateData_Pem); ok {
		return x.Pem
	}
	return ""
}

func (m *MeshConfig_CertificateData) GetSpiffeBundleUrl() string {
	if x, ok := m.GetCertificateData().(*MeshConfig_CertificateData_SpiffeBundleUrl); ok {
		return x.SpiffeBundleUrl
	}
	return ""
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*MeshConfig_CertificateData) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*MeshConfig_CertificateData_Pem)(nil),
		(*MeshConfig_CertificateData_SpiffeBundleUrl)(nil),
	}
}

type MeshConfig_ThriftConfig struct {
	// Specify thrift rate limit service URL. If pilot has thrift protocol support enabled,
	// this will enable the rate limit service for destinations that have matching rate
	// limit configurations.
	RateLimitUrl string `protobuf:"bytes,1,opt,name=rate_limit_url,json=rateLimitUrl,proto3" json:"rateLimitUrl,omitempty"`
	// Specify thrift rate limit service timeout, in milliseconds. Default is `50ms`
	RateLimitTimeout     *types.Duration `protobuf:"bytes,2,opt,name=rate_limit_timeout,json=rateLimitTimeout,proto3" json:"rateLimitTimeout,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *MeshConfig_ThriftConfig) Reset()         { *m = MeshConfig_ThriftConfig{} }
func (m *MeshConfig_ThriftConfig) String() string { return proto.CompactTextString(m) }
func (*MeshConfig_ThriftConfig) ProtoMessage()    {}
func (*MeshConfig_ThriftConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_b5c7ece76d5d5022, []int{0, 2}
}
func (m *MeshConfig_ThriftConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MeshConfig_ThriftConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MeshConfig_ThriftConfig.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *MeshConfig_ThriftConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MeshConfig_ThriftConfig.Merge(m, src)
}
func (m *MeshConfig_ThriftConfig) XXX_Size() int {
	return m.Size()
}
func (m *MeshConfig_ThriftConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_MeshConfig_ThriftConfig.DiscardUnknown(m)
}

var xxx_messageInfo_MeshConfig_ThriftConfig proto.InternalMessageInfo

func (m *MeshConfig_ThriftConfig) GetRateLimitUrl() string {
	if m != nil {
		return m.RateLimitUrl
	}
	return ""
}

func (m *MeshConfig_ThriftConfig) GetRateLimitTimeout() *types.Duration {
	if m != nil {
		return m.RateLimitTimeout
	}
	return nil
}

// $hide_from_docs
// Settings to be applied to select services.
//
// For example, the following configures all services in namespace "foo" as well as the
// "bar" service in namespace "baz" to be considered cluster-local:
//
// ```yaml
// serviceSettings:
//   - settings:
//       cluster_local: true
//     hosts:
//       - "*.foo.svc.cluster.local"
//       - "bar.baz.svc.cluster.local"
// ```
type MeshConfig_ServiceSettings struct {
	// The settings to apply to the selected services.
	Settings *MeshConfig_ServiceSettings_Settings `protobuf:"bytes,1,opt,name=settings,proto3" json:"settings,omitempty"`
	// The services to which the Settings should be applied. Services are selected using the hostname
	// matching rules used by DestinationRule.
	//
	// For example: foo.bar.svc.cluster.local, *.baz.svc.cluster.local
	Hosts                []string `protobuf:"bytes,2,rep,name=hosts,proto3" json:"hosts,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MeshConfig_ServiceSettings) Reset()         { *m = MeshConfig_ServiceSettings{} }
func (m *MeshConfig_ServiceSettings) String() string { return proto.CompactTextString(m) }
func (*MeshConfig_ServiceSettings) ProtoMessage()    {}
func (*MeshConfig_ServiceSettings) Descriptor() ([]byte, []int) {
	return fileDescriptor_b5c7ece76d5d5022, []int{0, 3}
}
func (m *MeshConfig_ServiceSettings) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MeshConfig_ServiceSettings) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MeshConfig_ServiceSettings.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *MeshConfig_ServiceSettings) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MeshConfig_ServiceSettings.Merge(m, src)
}
func (m *MeshConfig_ServiceSettings) XXX_Size() int {
	return m.Size()
}
func (m *MeshConfig_ServiceSettings) XXX_DiscardUnknown() {
	xxx_messageInfo_MeshConfig_ServiceSettings.DiscardUnknown(m)
}

var xxx_messageInfo_MeshConfig_ServiceSettings proto.InternalMessageInfo

func (m *MeshConfig_ServiceSettings) GetSettings() *MeshConfig_ServiceSettings_Settings {
	if m != nil {
		return m.Settings
	}
	return nil
}

func (m *MeshConfig_ServiceSettings) GetHosts() []string {
	if m != nil {
		return m.Hosts
	}
	return nil
}

// Settings for the selected services.
type MeshConfig_ServiceSettings_Settings struct {
	// If true, specifies that the client and service endpoints must reside in the same cluster.
	// By default, in multi-cluster deployments, the Istio control plane assumes all service
	// endpoints to be reachable from any client in any of the clusters which are part of the
	// mesh. This configuration option limits the set of service endpoints visible to a client
	// to be cluster scoped.
	//
	// There are some common scenarios when this can be useful:
	//
	//   - A service (or group of services) is inherently local to the cluster and has local storage
	//     for that cluster. For example, the kube-system namespace (e.g. the Kube API Server).
	//   - A mesh administrator wants to slowly migrate services to Istio. They might start by first
	//     having services cluster-local and then slowly transition them to mesh-wide. They could do
	//     this service-by-service (e.g. mysvc.myns.svc.cluster.local) or as a group
	//     (e.g. *.myns.svc.cluster.local).
	//
	// By default Istio will consider kubernetes.default.svc (i.e. the API Server) as well as all
	// services in the kube-system namespace to be cluster-local, unless explicitly overridden here.
	ClusterLocal         bool     `protobuf:"varint,1,opt,name=cluster_local,json=clusterLocal,proto3" json:"clusterLocal,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MeshConfig_ServiceSettings_Settings) Reset()         { *m = MeshConfig_ServiceSettings_Settings{} }
func (m *MeshConfig_ServiceSettings_Settings) String() string { return proto.CompactTextString(m) }
func (*MeshConfig_ServiceSettings_Settings) ProtoMessage()    {}
func (*MeshConfig_ServiceSettings_Settings) Descriptor() ([]byte, []int) {
	return fileDescriptor_b5c7ece76d5d5022, []int{0, 3, 0}
}
func (m *MeshConfig_ServiceSettings_Settings) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MeshConfig_ServiceSettings_Settings) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MeshConfig_ServiceSettings_Settings.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *MeshConfig_ServiceSettings_Settings) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MeshConfig_ServiceSettings_Settings.Merge(m, src)
}
func (m *MeshConfig_ServiceSettings_Settings) XXX_Size() int {
	return m.Size()
}
func (m *MeshConfig_ServiceSettings_Settings) XXX_DiscardUnknown() {
	xxx_messageInfo_MeshConfig_ServiceSettings_Settings.DiscardUnknown(m)
}

var xxx_messageInfo_MeshConfig_ServiceSettings_Settings proto.InternalMessageInfo

func (m *MeshConfig_ServiceSettings_Settings) GetClusterLocal() bool {
	if m != nil {
		return m.ClusterLocal
	}
	return false
}

type MeshConfig_CA struct {
	// REQUIRED. Address of the CA server implementing the Istio CA gRPC API.
	// Can be IP address or a fully qualified DNS name with port
	// Eg: custom-ca.default.svc.cluster.local:8932, 192.168.23.2:9000
	Address string `protobuf:"bytes,1,opt,name=address,proto3" json:"address,omitempty"`
	// Use the tls_settings to specify the tls mode to use.
	// Regarding tls_settings:
	// - DISABLE MODE is legitimate for the case Istiod is making the request via an Envoy sidecar.
	// DISABLE MODE can also be used for testing
	// - TLS MUTUAL MODE be on by default. If the CA certificates
	// (cert bundle to verify the CA server's certificate) is omitted, Istiod will
	// use the system root certs to verify the CA server's certificate.
	TlsSettings *v1alpha3.ClientTLSSettings `protobuf:"bytes,2,opt,name=tls_settings,json=tlsSettings,proto3" json:"tlsSettings,omitempty"`
	// timeout for forward CSR requests from Istiod to External CA
	// Default: 10s
	RequestTimeout *types.Duration `protobuf:"bytes,3,opt,name=request_timeout,json=requestTimeout,proto3" json:"requestTimeout,omitempty"`
	// Use istiod_side to specify CA Server integrate to Istiod side or Agent side
	// Default: true
	IstiodSide           bool     `protobuf:"varint,4,opt,name=istiod_side,json=istiodSide,proto3" json:"istiodSide,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MeshConfig_CA) Reset()         { *m = MeshConfig_CA{} }
func (m *MeshConfig_CA) String() string { return proto.CompactTextString(m) }
func (*MeshConfig_CA) ProtoMessage()    {}
func (*MeshConfig_CA) Descriptor() ([]byte, []int) {
	return fileDescriptor_b5c7ece76d5d5022, []int{0, 4}
}
func (m *MeshConfig_CA) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MeshConfig_CA) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MeshConfig_CA.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *MeshConfig_CA) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MeshConfig_CA.Merge(m, src)
}
func (m *MeshConfig_CA) XXX_Size() int {
	return m.Size()
}
func (m *MeshConfig_CA) XXX_DiscardUnknown() {
	xxx_messageInfo_MeshConfig_CA.DiscardUnknown(m)
}

var xxx_messageInfo_MeshConfig_CA proto.InternalMessageInfo

func (m *MeshConfig_CA) GetAddress() string {
	if m != nil {
		return m.Address
	}
	return ""
}

func (m *MeshConfig_CA) GetTlsSettings() *v1alpha3.ClientTLSSettings {
	if m != nil {
		return m.TlsSettings
	}
	return nil
}

func (m *MeshConfig_CA) GetRequestTimeout() *types.Duration {
	if m != nil {
		return m.RequestTimeout
	}
	return nil
}

func (m *MeshConfig_CA) GetIstiodSide() bool {
	if m != nil {
		return m.IstiodSide
	}
	return false
}

type MeshConfig_ExtensionProvider struct {
	// REQUIRED. A unique name identifying the extension provider.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// REQUIRED. Specifies detailed configuration for the extension provider.
	//
	// Types that are valid to be assigned to Provider:
	//	*MeshConfig_ExtensionProvider_EnvoyExtAuthzHttp
	//	*MeshConfig_ExtensionProvider_EnvoyExtAuthzGrpc
	//	*MeshConfig_ExtensionProvider_Zipkin
	//	*MeshConfig_ExtensionProvider_Lightstep
	//	*MeshConfig_ExtensionProvider_Datadog
	//	*MeshConfig_ExtensionProvider_Stackdriver
	//	*MeshConfig_ExtensionProvider_Opencensus
	Provider             isMeshConfig_ExtensionProvider_Provider `protobuf_oneof:"provider"`
	XXX_NoUnkeyedLiteral struct{}                                `json:"-"`
	XXX_unrecognized     []byte                                  `json:"-"`
	XXX_sizecache        int32                                   `json:"-"`
}

func (m *MeshConfig_ExtensionProvider) Reset()         { *m = MeshConfig_ExtensionProvider{} }
func (m *MeshConfig_ExtensionProvider) String() string { return proto.CompactTextString(m) }
func (*MeshConfig_ExtensionProvider) ProtoMessage()    {}
func (*MeshConfig_ExtensionProvider) Descriptor() ([]byte, []int) {
	return fileDescriptor_b5c7ece76d5d5022, []int{0, 5}
}
func (m *MeshConfig_ExtensionProvider) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MeshConfig_ExtensionProvider) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MeshConfig_ExtensionProvider.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *MeshConfig_ExtensionProvider) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MeshConfig_ExtensionProvider.Merge(m, src)
}
func (m *MeshConfig_ExtensionProvider) XXX_Size() int {
	return m.Size()
}
func (m *MeshConfig_ExtensionProvider) XXX_DiscardUnknown() {
	xxx_messageInfo_MeshConfig_ExtensionProvider.DiscardUnknown(m)
}

var xxx_messageInfo_MeshConfig_ExtensionProvider proto.InternalMessageInfo

type isMeshConfig_ExtensionProvider_Provider interface {
	isMeshConfig_ExtensionProvider_Provider()
	MarshalTo([]byte) (int, error)
	Size() int
}

type MeshConfig_ExtensionProvider_EnvoyExtAuthzHttp struct {
	EnvoyExtAuthzHttp *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationHttpProvider `protobuf:"bytes,2,opt,name=envoy_ext_authz_http,json=envoyExtAuthzHttp,proto3,oneof" json:"envoyExtAuthzHttp,omitempty"`
}
type MeshConfig_ExtensionProvider_EnvoyExtAuthzGrpc struct {
	EnvoyExtAuthzGrpc *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationGrpcProvider `protobuf:"bytes,3,opt,name=envoy_ext_authz_grpc,json=envoyExtAuthzGrpc,proto3,oneof" json:"envoyExtAuthzGrpc,omitempty"`
}
type MeshConfig_ExtensionProvider_Zipkin struct {
	Zipkin *MeshConfig_ExtensionProvider_ZipkinTracingProvider `protobuf:"bytes,4,opt,name=zipkin,proto3,oneof" json:"zipkin,omitempty"`
}
type MeshConfig_ExtensionProvider_Lightstep struct {
	Lightstep *MeshConfig_ExtensionProvider_LightstepTracingProvider `protobuf:"bytes,5,opt,name=lightstep,proto3,oneof" json:"lightstep,omitempty"`
}
type MeshConfig_ExtensionProvider_Datadog struct {
	Datadog *MeshConfig_ExtensionProvider_DatadogTracingProvider `protobuf:"bytes,6,opt,name=datadog,proto3,oneof" json:"datadog,omitempty"`
}
type MeshConfig_ExtensionProvider_Stackdriver struct {
	Stackdriver *MeshConfig_ExtensionProvider_StackdriverProvider `protobuf:"bytes,7,opt,name=stackdriver,proto3,oneof" json:"stackdriver,omitempty"`
}
type MeshConfig_ExtensionProvider_Opencensus struct {
	Opencensus *MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider `protobuf:"bytes,8,opt,name=opencensus,proto3,oneof" json:"opencensus,omitempty"`
}

func (*MeshConfig_ExtensionProvider_EnvoyExtAuthzHttp) isMeshConfig_ExtensionProvider_Provider() {}
func (*MeshConfig_ExtensionProvider_EnvoyExtAuthzGrpc) isMeshConfig_ExtensionProvider_Provider() {}
func (*MeshConfig_ExtensionProvider_Zipkin) isMeshConfig_ExtensionProvider_Provider()            {}
func (*MeshConfig_ExtensionProvider_Lightstep) isMeshConfig_ExtensionProvider_Provider()         {}
func (*MeshConfig_ExtensionProvider_Datadog) isMeshConfig_ExtensionProvider_Provider()           {}
func (*MeshConfig_ExtensionProvider_Stackdriver) isMeshConfig_ExtensionProvider_Provider()       {}
func (*MeshConfig_ExtensionProvider_Opencensus) isMeshConfig_ExtensionProvider_Provider()        {}

func (m *MeshConfig_ExtensionProvider) GetProvider() isMeshConfig_ExtensionProvider_Provider {
	if m != nil {
		return m.Provider
	}
	return nil
}

func (m *MeshConfig_ExtensionProvider) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *MeshConfig_ExtensionProvider) GetEnvoyExtAuthzHttp() *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationHttpProvider {
	if x, ok := m.GetProvider().(*MeshConfig_ExtensionProvider_EnvoyExtAuthzHttp); ok {
		return x.EnvoyExtAuthzHttp
	}
	return nil
}

func (m *MeshConfig_ExtensionProvider) GetEnvoyExtAuthzGrpc() *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationGrpcProvider {
	if x, ok := m.GetProvider().(*MeshConfig_ExtensionProvider_EnvoyExtAuthzGrpc); ok {
		return x.EnvoyExtAuthzGrpc
	}
	return nil
}

func (m *MeshConfig_ExtensionProvider) GetZipkin() *MeshConfig_ExtensionProvider_ZipkinTracingProvider {
	if x, ok := m.GetProvider().(*MeshConfig_ExtensionProvider_Zipkin); ok {
		return x.Zipkin
	}
	return nil
}

func (m *MeshConfig_ExtensionProvider) GetLightstep() *MeshConfig_ExtensionProvider_LightstepTracingProvider {
	if x, ok := m.GetProvider().(*MeshConfig_ExtensionProvider_Lightstep); ok {
		return x.Lightstep
	}
	return nil
}

func (m *MeshConfig_ExtensionProvider) GetDatadog() *MeshConfig_ExtensionProvider_DatadogTracingProvider {
	if x, ok := m.GetProvider().(*MeshConfig_ExtensionProvider_Datadog); ok {
		return x.Datadog
	}
	return nil
}

func (m *MeshConfig_ExtensionProvider) GetStackdriver() *MeshConfig_ExtensionProvider_StackdriverProvider {
	if x, ok := m.GetProvider().(*MeshConfig_ExtensionProvider_Stackdriver); ok {
		return x.Stackdriver
	}
	return nil
}

func (m *MeshConfig_ExtensionProvider) GetOpencensus() *MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider {
	if x, ok := m.GetProvider().(*MeshConfig_ExtensionProvider_Opencensus); ok {
		return x.Opencensus
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*MeshConfig_ExtensionProvider) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*MeshConfig_ExtensionProvider_EnvoyExtAuthzHttp)(nil),
		(*MeshConfig_ExtensionProvider_EnvoyExtAuthzGrpc)(nil),
		(*MeshConfig_ExtensionProvider_Zipkin)(nil),
		(*MeshConfig_ExtensionProvider_Lightstep)(nil),
		(*MeshConfig_ExtensionProvider_Datadog)(nil),
		(*MeshConfig_ExtensionProvider_Stackdriver)(nil),
		(*MeshConfig_ExtensionProvider_Opencensus)(nil),
	}
}

type MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationRequestBody struct {
	// Sets the maximum size of a message body that the ext-authz filter will hold in memory.
	// If max_request_bytes is reached, and allow_partial_message is false, Envoy will return a 413 (Payload Too Large).
	// Otherwise the request will be sent to the provider with a partial message.
	// Note that this setting will have precedence over the fail_open field, the 413 will be returned even when the
	// fail_open is set to true.
	MaxRequestBytes uint32 `protobuf:"varint,1,opt,name=max_request_bytes,json=maxRequestBytes,proto3" json:"maxRequestBytes,omitempty"`
	// When this field is true, ext-authz filter will buffer the message until max_request_bytes is reached.
	// The authorization request will be dispatched and no 413 HTTP error will be returned by the filter.
	// A "x-envoy-auth-partial-body: false|true" metadata header will be added to the authorization request message
	// indicating if the body data is partial.
	AllowPartialMessage bool `protobuf:"varint,2,opt,name=allow_partial_message,json=allowPartialMessage,proto3" json:"allowPartialMessage,omitempty"`
	// If true, the body sent to the external authorization service in the gRPC authorization request is set with raw bytes
	// in the raw_body field (https://github.com/envoyproxy/envoy/blame/cffb095d59d7935abda12b9509bcd136808367bb/api/envoy/service/auth/v3/attribute_context.proto#L153).
	// Otherwise, it will be filled with UTF-8 string in the body field (https://github.com/envoyproxy/envoy/blame/cffb095d59d7935abda12b9509bcd136808367bb/api/envoy/service/auth/v3/attribute_context.proto#L147).
	// This field only works with the envoy_ext_authz_grpc provider and has no effect for the envoy_ext_authz_http provider.
	PackAsBytes          bool     `protobuf:"varint,3,opt,name=pack_as_bytes,json=packAsBytes,proto3" json:"packAsBytes,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationRequestBody) Reset() {
	*m = MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationRequestBody{}
}
func (m *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationRequestBody) String() string {
	return proto.CompactTextString(m)
}
func (*MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationRequestBody) ProtoMessage() {}
func (*MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationRequestBody) Descriptor() ([]byte, []int) {
	return fileDescriptor_b5c7ece76d5d5022, []int{0, 5, 0}
}
func (m *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationRequestBody) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationRequestBody) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationRequestBody.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationRequestBody) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationRequestBody.Merge(m, src)
}
func (m *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationRequestBody) XXX_Size() int {
	return m.Size()
}
func (m *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationRequestBody) XXX_DiscardUnknown() {
	xxx_messageInfo_MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationRequestBody.DiscardUnknown(m)
}

var xxx_messageInfo_MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationRequestBody proto.InternalMessageInfo

func (m *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationRequestBody) GetMaxRequestBytes() uint32 {
	if m != nil {
		return m.MaxRequestBytes
	}
	return 0
}

func (m *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationRequestBody) GetAllowPartialMessage() bool {
	if m != nil {
		return m.AllowPartialMessage
	}
	return false
}

func (m *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationRequestBody) GetPackAsBytes() bool {
	if m != nil {
		return m.PackAsBytes
	}
	return false
}

type MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationHttpProvider struct {
	// REQUIRED. Specifies the service that implements the Envoy ext_authz HTTP authorization service.
	// The format is "[<Namespace>/]<Hostname>". The specification of <Namespace> is required only when it is insufficient
	// to unambiguously resolve a service in the service registry. The <Hostname> is a fully qualified host name of a
	// service defined by the Kubernetes service or ServiceEntry.
	//
	// Example: "my-ext-authz.foo.svc.cluster.local" or "bar/my-ext-authz.example.com".
	Service string `protobuf:"bytes,1,opt,name=service,proto3" json:"service,omitempty"`
	// REQUIRED. Specifies the port of the service.
	Port uint32 `protobuf:"varint,2,opt,name=port,proto3" json:"port,omitempty"`
	// The maximum duration that the proxy will wait for a response from the provider (default timeout: 600s).
	// When this timeout condition is met, the proxy marks the communication to the authorization service as failure.
	// In this situation, the response sent back to the client will depend on the configured `fail_open` field.
	Timeout *types.Duration `protobuf:"bytes,9,opt,name=timeout,proto3" json:"timeout,omitempty"`
	// Sets a prefix to the value of authorization request header *Path*.
	// For example, setting this to "/check" for an original user request at path "/admin" will cause the
	// authorization check request to be sent to the authorization service at the path "/check/admin" instead of "/admin".
	PathPrefix string `protobuf:"bytes,3,opt,name=path_prefix,json=pathPrefix,proto3" json:"pathPrefix,omitempty"`
	// If true, the user request will be allowed even if the communication with the authorization service has failed,
	// or if the authorization service has returned a HTTP 5xx error.
	// Default is false and the request will be rejected with "Forbidden" response.
	FailOpen bool `protobuf:"varint,4,opt,name=fail_open,json=failOpen,proto3" json:"failOpen,omitempty"`
	// Sets the HTTP status that is returned to the client when there is a network error to the authorization service.
	// The default status is "403" (HTTP Forbidden).
	StatusOnError string `protobuf:"bytes,5,opt,name=status_on_error,json=statusOnError,proto3" json:"statusOnError,omitempty"`
	// DEPRECATED. Use include_request_headers_in_check instead.
	IncludeHeadersInCheck []string `protobuf:"bytes,6,rep,name=include_headers_in_check,json=includeHeadersInCheck,proto3" json:"includeHeadersInCheck,omitempty"`
	// List of client request headers that should be included in the authorization request sent to the authorization service.
	// Note that in addition to the headers specified here following headers are included by default:
	// 1. *Host*, *Method*, *Path* and *Content-Length* are automatically sent.
	// 2. *Content-Length* will be set to 0 and the request will not have a message body. However, the authorization
	// request can include the buffered client request body (controlled by include_request_body_in_check setting),
	// consequently the value of Content-Length of the authorization request reflects the size of its payload size.
	//
	// Exact, prefix and suffix matches are supported (similar to the authorization policy rule syntax except the presence match
	// https://istio.io/latest/docs/reference/config/security/authorization-policy/#Rule):
	// - Exact match: "abc" will match on value "abc".
	// - Prefix match: "abc*" will match on value "abc" and "abcd".
	// - Suffix match: "*abc" will match on value "abc" and "xabc".
	IncludeRequestHeadersInCheck []string `protobuf:"bytes,10,rep,name=include_request_headers_in_check,json=includeRequestHeadersInCheck,proto3" json:"includeRequestHeadersInCheck,omitempty"`
	// Set of additional fixed headers that should be included in the authorization request sent to the authorization service.
	// Key is the header name and value is the header value.
	// Note that client request of the same key or headers specified in include_request_headers_in_check will be overridden.
	IncludeAdditionalHeadersInCheck map[string]string `protobuf:"bytes,11,rep,name=include_additional_headers_in_check,json=includeAdditionalHeadersInCheck,proto3" json:"includeAdditionalHeadersInCheck,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// If set, the client request body will be included in the authorization request sent to the authorization service.
	IncludeRequestBodyInCheck *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationRequestBody `protobuf:"bytes,12,opt,name=include_request_body_in_check,json=includeRequestBodyInCheck,proto3" json:"includeRequestBodyInCheck,omitempty"`
	// List of headers from the authorization service that should be added or overridden in the original request and
	// forwarded to the upstream when the authorization check result is allowed (HTTP code 200).
	// If not specified, the original request will not be modified and forwarded to backend as-is.
	// Note, any existing headers will be overridden.
	//
	// Exact, prefix and suffix matches are supported (similar to the authorization policy rule syntax except the presence match
	// https://istio.io/latest/docs/reference/config/security/authorization-policy/#Rule):
	// - Exact match: "abc" will match on value "abc".
	// - Prefix match: "abc*" will match on value "abc" and "abcd".
	// - Suffix match: "*abc" will match on value "abc" and "xabc".
	HeadersToUpstreamOnAllow []string `protobuf:"bytes,7,rep,name=headers_to_upstream_on_allow,json=headersToUpstreamOnAllow,proto3" json:"headersToUpstreamOnAllow,omitempty"`
	// List of headers from the authorization service that should be forwarded to downstream when the authorization
	// check result is not allowed (HTTP code other than 200).
	// If not specified, all the authorization response headers, except *Authority (Host)* will be in the response to
	// the downstream.
	// When a header is included in this list, *Path*, *Status*, *Content-Length*, *WWWAuthenticate* and *Location* are
	// automatically added.
	// Note, the body from the authorization service is always included in the response to downstream.
	//
	// Exact, prefix and suffix matches are supported (similar to the authorization policy rule syntax except the presence match
	// https://istio.io/latest/docs/reference/config/security/authorization-policy/#Rule):
	// - Exact match: "abc" will match on value "abc".
	// - Prefix match: "abc*" will match on value "abc" and "abcd".
	// - Suffix match: "*abc" will match on value "abc" and "xabc".
	HeadersToDownstreamOnDeny []string `protobuf:"bytes,8,rep,name=headers_to_downstream_on_deny,json=headersToDownstreamOnDeny,proto3" json:"headersToDownstreamOnDeny,omitempty"`
	XXX_NoUnkeyedLiteral      struct{} `json:"-"`
	XXX_unrecognized          []byte   `json:"-"`
	XXX_sizecache             int32    `json:"-"`
}

func (m *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationHttpProvider) Reset() {
	*m = MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationHttpProvider{}
}
func (m *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationHttpProvider) String() string {
	return proto.CompactTextString(m)
}
func (*MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationHttpProvider) ProtoMessage() {}
func (*MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationHttpProvider) Descriptor() ([]byte, []int) {
	return fileDescriptor_b5c7ece76d5d5022, []int{0, 5, 1}
}
func (m *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationHttpProvider) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationHttpProvider) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationHttpProvider.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationHttpProvider) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationHttpProvider.Merge(m, src)
}
func (m *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationHttpProvider) XXX_Size() int {
	return m.Size()
}
func (m *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationHttpProvider) XXX_DiscardUnknown() {
	xxx_messageInfo_MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationHttpProvider.DiscardUnknown(m)
}

var xxx_messageInfo_MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationHttpProvider proto.InternalMessageInfo

func (m *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationHttpProvider) GetService() string {
	if m != nil {
		return m.Service
	}
	return ""
}

func (m *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationHttpProvider) GetPort() uint32 {
	if m != nil {
		return m.Port
	}
	return 0
}

func (m *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationHttpProvider) GetTimeout() *types.Duration {
	if m != nil {
		return m.Timeout
	}
	return nil
}

func (m *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationHttpProvider) GetPathPrefix() string {
	if m != nil {
		return m.PathPrefix
	}
	return ""
}

func (m *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationHttpProvider) GetFailOpen() bool {
	if m != nil {
		return m.FailOpen
	}
	return false
}

func (m *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationHttpProvider) GetStatusOnError() string {
	if m != nil {
		return m.StatusOnError
	}
	return ""
}

func (m *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationHttpProvider) GetIncludeHeadersInCheck() []string {
	if m != nil {
		return m.IncludeHeadersInCheck
	}
	return nil
}

func (m *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationHttpProvider) GetIncludeRequestHeadersInCheck() []string {
	if m != nil {
		return m.IncludeRequestHeadersInCheck
	}
	return nil
}

func (m *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationHttpProvider) GetIncludeAdditionalHeadersInCheck() map[string]string {
	if m != nil {
		return m.IncludeAdditionalHeadersInCheck
	}
	return nil
}

func (m *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationHttpProvider) GetIncludeRequestBodyInCheck() *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationRequestBody {
	if m != nil {
		return m.IncludeRequestBodyInCheck
	}
	return nil
}

func (m *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationHttpProvider) GetHeadersToUpstreamOnAllow() []string {
	if m != nil {
		return m.HeadersToUpstreamOnAllow
	}
	return nil
}

func (m *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationHttpProvider) GetHeadersToDownstreamOnDeny() []string {
	if m != nil {
		return m.HeadersToDownstreamOnDeny
	}
	return nil
}

type MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationGrpcProvider struct {
	// REQUIRED. Specifies the service that implements the Envoy ext_authz gRPC authorization service.
	// The format is "[<Namespace>/]<Hostname>". The specification of <Namespace> is required only when it is insufficient
	// to unambiguously resolve a service in the service registry. The <Hostname> is a fully qualified host name of a
	// service defined by the Kubernetes service or ServiceEntry.
	//
	// Example: "my-ext-authz.foo.svc.cluster.local" or "bar/my-ext-authz.example.com".
	Service string `protobuf:"bytes,1,opt,name=service,proto3" json:"service,omitempty"`
	// REQUIRED. Specifies the port of the service.
	Port uint32 `protobuf:"varint,2,opt,name=port,proto3" json:"port,omitempty"`
	// The maximum duration that the proxy will wait for a response from the provider, this is the timeout for a specific request (default timeout: 600s).
	// When this timeout condition is met, the proxy marks the communication to the authorization service as failure.
	// In this situation, the response sent back to the client will depend on the configured `fail_open` field.
	Timeout *types.Duration `protobuf:"bytes,5,opt,name=timeout,proto3" json:"timeout,omitempty"`
	// If true, the HTTP request or TCP connection will be allowed even if the communication with the authorization service has failed,
	// or if the authorization service has returned a HTTP 5xx error.
	// Default is false. For HTTP request, it will be rejected with 403 (HTTP Forbidden). For TCP connection, it will be closed immediately.
	FailOpen bool `protobuf:"varint,3,opt,name=fail_open,json=failOpen,proto3" json:"failOpen,omitempty"`
	// Sets the HTTP status that is returned to the client when there is a network error to the authorization service.
	// The default status is "403" (HTTP Forbidden).
	StatusOnError string `protobuf:"bytes,4,opt,name=status_on_error,json=statusOnError,proto3" json:"statusOnError,omitempty"`
	// If set, the client request body will be included in the authorization request sent to the authorization service.
	IncludeRequestBodyInCheck *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationRequestBody `protobuf:"bytes,6,opt,name=include_request_body_in_check,json=includeRequestBodyInCheck,proto3" json:"includeRequestBodyInCheck,omitempty"`
	XXX_NoUnkeyedLiteral      struct{}                                                            `json:"-"`
	XXX_unrecognized          []byte                                                              `json:"-"`
	XXX_sizecache             int32                                                               `json:"-"`
}

func (m *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationGrpcProvider) Reset() {
	*m = MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationGrpcProvider{}
}
func (m *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationGrpcProvider) String() string {
	return proto.CompactTextString(m)
}
func (*MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationGrpcProvider) ProtoMessage() {}
func (*MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationGrpcProvider) Descriptor() ([]byte, []int) {
	return fileDescriptor_b5c7ece76d5d5022, []int{0, 5, 2}
}
func (m *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationGrpcProvider) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationGrpcProvider) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationGrpcProvider.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationGrpcProvider) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationGrpcProvider.Merge(m, src)
}
func (m *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationGrpcProvider) XXX_Size() int {
	return m.Size()
}
func (m *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationGrpcProvider) XXX_DiscardUnknown() {
	xxx_messageInfo_MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationGrpcProvider.DiscardUnknown(m)
}

var xxx_messageInfo_MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationGrpcProvider proto.InternalMessageInfo

func (m *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationGrpcProvider) GetService() string {
	if m != nil {
		return m.Service
	}
	return ""
}

func (m *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationGrpcProvider) GetPort() uint32 {
	if m != nil {
		return m.Port
	}
	return 0
}

func (m *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationGrpcProvider) GetTimeout() *types.Duration {
	if m != nil {
		return m.Timeout
	}
	return nil
}

func (m *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationGrpcProvider) GetFailOpen() bool {
	if m != nil {
		return m.FailOpen
	}
	return false
}

func (m *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationGrpcProvider) GetStatusOnError() string {
	if m != nil {
		return m.StatusOnError
	}
	return ""
}

func (m *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationGrpcProvider) GetIncludeRequestBodyInCheck() *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationRequestBody {
	if m != nil {
		return m.IncludeRequestBodyInCheck
	}
	return nil
}

// Defines configuration for a Zipkin tracer.
type MeshConfig_ExtensionProvider_ZipkinTracingProvider struct {
	// REQUIRED. Specifies the service that the Zipkin API.
	// The format is "[<Namespace>/]<Hostname>". The specification of <Namespace> is required only when it is insufficient
	// to unambiguously resolve a service in the service registry. The <Hostname> is a fully qualified host name of a
	// service defined by the Kubernetes service or ServiceEntry.
	//
	// Example: "zipkin.default.svc.cluster.local" or "bar/zipkin.example.com".
	Service string `protobuf:"bytes,1,opt,name=service,proto3" json:"service,omitempty"`
	// REQUIRED. Specifies the port of the service.
	Port uint32 `protobuf:"varint,2,opt,name=port,proto3" json:"port,omitempty"`
	// Optional. Controls the overall path length allowed in a reported span.
	// NOTE: currently only controls max length of the path tag.
	MaxTagLength         uint32   `protobuf:"varint,3,opt,name=max_tag_length,json=maxTagLength,proto3" json:"maxTagLength,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MeshConfig_ExtensionProvider_ZipkinTracingProvider) Reset() {
	*m = MeshConfig_ExtensionProvider_ZipkinTracingProvider{}
}
func (m *MeshConfig_ExtensionProvider_ZipkinTracingProvider) String() string {
	return proto.CompactTextString(m)
}
func (*MeshConfig_ExtensionProvider_ZipkinTracingProvider) ProtoMessage() {}
func (*MeshConfig_ExtensionProvider_ZipkinTracingProvider) Descriptor() ([]byte, []int) {
	return fileDescriptor_b5c7ece76d5d5022, []int{0, 5, 3}
}
func (m *MeshConfig_ExtensionProvider_ZipkinTracingProvider) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MeshConfig_ExtensionProvider_ZipkinTracingProvider) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MeshConfig_ExtensionProvider_ZipkinTracingProvider.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *MeshConfig_ExtensionProvider_ZipkinTracingProvider) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MeshConfig_ExtensionProvider_ZipkinTracingProvider.Merge(m, src)
}
func (m *MeshConfig_ExtensionProvider_ZipkinTracingProvider) XXX_Size() int {
	return m.Size()
}
func (m *MeshConfig_ExtensionProvider_ZipkinTracingProvider) XXX_DiscardUnknown() {
	xxx_messageInfo_MeshConfig_ExtensionProvider_ZipkinTracingProvider.DiscardUnknown(m)
}

var xxx_messageInfo_MeshConfig_ExtensionProvider_ZipkinTracingProvider proto.InternalMessageInfo

func (m *MeshConfig_ExtensionProvider_ZipkinTracingProvider) GetService() string {
	if m != nil {
		return m.Service
	}
	return ""
}

func (m *MeshConfig_ExtensionProvider_ZipkinTracingProvider) GetPort() uint32 {
	if m != nil {
		return m.Port
	}
	return 0
}

func (m *MeshConfig_ExtensionProvider_ZipkinTracingProvider) GetMaxTagLength() uint32 {
	if m != nil {
		return m.MaxTagLength
	}
	return 0
}

// Defines configuration for a Lightstep tracer.
type MeshConfig_ExtensionProvider_LightstepTracingProvider struct {
	// REQUIRED. Specifies the service for the Lightstep collector.
	// The format is "[<Namespace>/]<Hostname>". The specification of <Namespace> is required only when it is insufficient
	// to unambiguously resolve a service in the service registry. The <Hostname> is a fully qualified host name of a
	// service defined by the Kubernetes service or ServiceEntry.
	//
	// Example: "lightstep.default.svc.cluster.local" or "bar/lightstep.example.com".
	Service string `protobuf:"bytes,1,opt,name=service,proto3" json:"service,omitempty"`
	// REQUIRED. Specifies the port of the service.
	Port uint32 `protobuf:"varint,2,opt,name=port,proto3" json:"port,omitempty"`
	// The Lightstep access token.
	AccessToken string `protobuf:"bytes,3,opt,name=access_token,json=accessToken,proto3" json:"accessToken,omitempty"`
	// Optional. Controls the overall path length allowed in a reported span.
	// NOTE: currently only controls max length of the path tag.
	MaxTagLength         uint32   `protobuf:"varint,4,opt,name=max_tag_length,json=maxTagLength,proto3" json:"maxTagLength,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MeshConfig_ExtensionProvider_LightstepTracingProvider) Reset() {
	*m = MeshConfig_ExtensionProvider_LightstepTracingProvider{}
}
func (m *MeshConfig_ExtensionProvider_LightstepTracingProvider) String() string {
	return proto.CompactTextString(m)
}
func (*MeshConfig_ExtensionProvider_LightstepTracingProvider) ProtoMessage() {}
func (*MeshConfig_ExtensionProvider_LightstepTracingProvider) Descriptor() ([]byte, []int) {
	return fileDescriptor_b5c7ece76d5d5022, []int{0, 5, 4}
}
func (m *MeshConfig_ExtensionProvider_LightstepTracingProvider) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MeshConfig_ExtensionProvider_LightstepTracingProvider) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MeshConfig_ExtensionProvider_LightstepTracingProvider.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *MeshConfig_ExtensionProvider_LightstepTracingProvider) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MeshConfig_ExtensionProvider_LightstepTracingProvider.Merge(m, src)
}
func (m *MeshConfig_ExtensionProvider_LightstepTracingProvider) XXX_Size() int {
	return m.Size()
}
func (m *MeshConfig_ExtensionProvider_LightstepTracingProvider) XXX_DiscardUnknown() {
	xxx_messageInfo_MeshConfig_ExtensionProvider_LightstepTracingProvider.DiscardUnknown(m)
}

var xxx_messageInfo_MeshConfig_ExtensionProvider_LightstepTracingProvider proto.InternalMessageInfo

func (m *MeshConfig_ExtensionProvider_LightstepTracingProvider) GetService() string {
	if m != nil {
		return m.Service
	}
	return ""
}

func (m *MeshConfig_ExtensionProvider_LightstepTracingProvider) GetPort() uint32 {
	if m != nil {
		return m.Port
	}
	return 0
}

func (m *MeshConfig_ExtensionProvider_LightstepTracingProvider) GetAccessToken() string {
	if m != nil {
		return m.AccessToken
	}
	return ""
}

func (m *MeshConfig_ExtensionProvider_LightstepTracingProvider) GetMaxTagLength() uint32 {
	if m != nil {
		return m.MaxTagLength
	}
	return 0
}

// Defines configuration for a Datadog tracer.
type MeshConfig_ExtensionProvider_DatadogTracingProvider struct {
	// REQUIRED. Specifies the service for the Datadog agent.
	// The format is "[<Namespace>/]<Hostname>". The specification of <Namespace> is required only when it is insufficient
	// to unambiguously resolve a service in the service registry. The <Hostname> is a fully qualified host name of a
	// service defined by the Kubernetes service or ServiceEntry.
	//
	// Example: "datadog.default.svc.cluster.local" or "bar/datadog.example.com".
	Service string `protobuf:"bytes,1,opt,name=service,proto3" json:"service,omitempty"`
	// REQUIRED. Specifies the port of the service.
	Port uint32 `protobuf:"varint,2,opt,name=port,proto3" json:"port,omitempty"`
	// Optional. Controls the overall path length allowed in a reported span.
	// NOTE: currently only controls max length of the path tag.
	MaxTagLength         uint32   `protobuf:"varint,3,opt,name=max_tag_length,json=maxTagLength,proto3" json:"maxTagLength,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MeshConfig_ExtensionProvider_DatadogTracingProvider) Reset() {
	*m = MeshConfig_ExtensionProvider_DatadogTracingProvider{}
}
func (m *MeshConfig_ExtensionProvider_DatadogTracingProvider) String() string {
	return proto.CompactTextString(m)
}
func (*MeshConfig_ExtensionProvider_DatadogTracingProvider) ProtoMessage() {}
func (*MeshConfig_ExtensionProvider_DatadogTracingProvider) Descriptor() ([]byte, []int) {
	return fileDescriptor_b5c7ece76d5d5022, []int{0, 5, 5}
}
func (m *MeshConfig_ExtensionProvider_DatadogTracingProvider) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MeshConfig_ExtensionProvider_DatadogTracingProvider) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MeshConfig_ExtensionProvider_DatadogTracingProvider.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *MeshConfig_ExtensionProvider_DatadogTracingProvider) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MeshConfig_ExtensionProvider_DatadogTracingProvider.Merge(m, src)
}
func (m *MeshConfig_ExtensionProvider_DatadogTracingProvider) XXX_Size() int {
	return m.Size()
}
func (m *MeshConfig_ExtensionProvider_DatadogTracingProvider) XXX_DiscardUnknown() {
	xxx_messageInfo_MeshConfig_ExtensionProvider_DatadogTracingProvider.DiscardUnknown(m)
}

var xxx_messageInfo_MeshConfig_ExtensionProvider_DatadogTracingProvider proto.InternalMessageInfo

func (m *MeshConfig_ExtensionProvider_DatadogTracingProvider) GetService() string {
	if m != nil {
		return m.Service
	}
	return ""
}

func (m *MeshConfig_ExtensionProvider_DatadogTracingProvider) GetPort() uint32 {
	if m != nil {
		return m.Port
	}
	return 0
}

func (m *MeshConfig_ExtensionProvider_DatadogTracingProvider) GetMaxTagLength() uint32 {
	if m != nil {
		return m.MaxTagLength
	}
	return 0
}

// Defines configuration for Stackdriver.
type MeshConfig_ExtensionProvider_StackdriverProvider struct {
	// debug enables trace output to stdout.
	// $hide_from_docs
	Debug bool `protobuf:"varint,1,opt,name=debug,proto3" json:"debug,omitempty"`
	// The global default max number of attributes per span.
	// default is 200.
	// $hide_from_docs
	MaxNumberOfAttributes *types.Int64Value `protobuf:"bytes,2,opt,name=max_number_of_attributes,json=maxNumberOfAttributes,proto3" json:"maxNumberOfAttributes,omitempty"`
	// The global default max number of annotation events per span.
	// default is 200.
	// $hide_from_docs
	MaxNumberOfAnnotations *types.Int64Value `protobuf:"bytes,3,opt,name=max_number_of_annotations,json=maxNumberOfAnnotations,proto3" json:"maxNumberOfAnnotations,omitempty"`
	// The global default max number of message events per span.
	// default is 200.
	// $hide_from_docs
	MaxNumberOfMessageEvents *types.Int64Value `protobuf:"bytes,4,opt,name=max_number_of_message_events,json=maxNumberOfMessageEvents,proto3" json:"maxNumberOfMessageEvents,omitempty"`
	// Optional. Controls the overall path length allowed in a reported span.
	// NOTE: currently only controls max length of the path tag.
	MaxTagLength         uint32   `protobuf:"varint,5,opt,name=max_tag_length,json=maxTagLength,proto3" json:"maxTagLength,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MeshConfig_ExtensionProvider_StackdriverProvider) Reset() {
	*m = MeshConfig_ExtensionProvider_StackdriverProvider{}
}
func (m *MeshConfig_ExtensionProvider_StackdriverProvider) String() string {
	return proto.CompactTextString(m)
}
func (*MeshConfig_ExtensionProvider_StackdriverProvider) ProtoMessage() {}
func (*MeshConfig_ExtensionProvider_StackdriverProvider) Descriptor() ([]byte, []int) {
	return fileDescriptor_b5c7ece76d5d5022, []int{0, 5, 6}
}
func (m *MeshConfig_ExtensionProvider_StackdriverProvider) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MeshConfig_ExtensionProvider_StackdriverProvider) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MeshConfig_ExtensionProvider_StackdriverProvider.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *MeshConfig_ExtensionProvider_StackdriverProvider) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MeshConfig_ExtensionProvider_StackdriverProvider.Merge(m, src)
}
func (m *MeshConfig_ExtensionProvider_StackdriverProvider) XXX_Size() int {
	return m.Size()
}
func (m *MeshConfig_ExtensionProvider_StackdriverProvider) XXX_DiscardUnknown() {
	xxx_messageInfo_MeshConfig_ExtensionProvider_StackdriverProvider.DiscardUnknown(m)
}

var xxx_messageInfo_MeshConfig_ExtensionProvider_StackdriverProvider proto.InternalMessageInfo

func (m *MeshConfig_ExtensionProvider_StackdriverProvider) GetDebug() bool {
	if m != nil {
		return m.Debug
	}
	return false
}

func (m *MeshConfig_ExtensionProvider_StackdriverProvider) GetMaxNumberOfAttributes() *types.Int64Value {
	if m != nil {
		return m.MaxNumberOfAttributes
	}
	return nil
}

func (m *MeshConfig_ExtensionProvider_StackdriverProvider) GetMaxNumberOfAnnotations() *types.Int64Value {
	if m != nil {
		return m.MaxNumberOfAnnotations
	}
	return nil
}

func (m *MeshConfig_ExtensionProvider_StackdriverProvider) GetMaxNumberOfMessageEvents() *types.Int64Value {
	if m != nil {
		return m.MaxNumberOfMessageEvents
	}
	return nil
}

func (m *MeshConfig_ExtensionProvider_StackdriverProvider) GetMaxTagLength() uint32 {
	if m != nil {
		return m.MaxTagLength
	}
	return 0
}

// Defines configuration for an OpenCensus tracer writing to an OpenCensus backend.
type MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider struct {
	// REQUIRED. Specifies the service for the OpenCensusAgent.
	// The format is "[<Namespace>/]<Hostname>". The specification of <Namespace> is required only when it is insufficient
	// to unambiguously resolve a service in the service registry. The <Hostname> is a fully qualified host name of a
	// service defined by the Kubernetes service or ServiceEntry.
	//
	// Example: "ocagent.default.svc.cluster.local" or "bar/ocagent.example.com".
	Service string `protobuf:"bytes,1,opt,name=service,proto3" json:"service,omitempty"`
	// REQUIRED. Specifies the port of the service.
	Port uint32 `protobuf:"varint,2,opt,name=port,proto3" json:"port,omitempty"`
	// Specifies the set of context propagation headers used for distributed
	// tracing. Default is `["W3C_TRACE_CONTEXT"]`. If multiple values are specified,
	// the proxy will attempt to read each header for each request and will
	// write all headers.
	Context []MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider_TraceContext `protobuf:"varint,3,rep,packed,name=context,proto3,enum=istio.mesh.v1alpha1.MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider_TraceContext" json:"context,omitempty"`
	// Optional. Controls the overall path length allowed in a reported span.
	// NOTE: currently only controls max length of the path tag.
	MaxTagLength         uint32   `protobuf:"varint,4,opt,name=max_tag_length,json=maxTagLength,proto3" json:"maxTagLength,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider) Reset() {
	*m = MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider{}
}
func (m *MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider) String() string {
	return proto.CompactTextString(m)
}
func (*MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider) ProtoMessage() {}
func (*MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider) Descriptor() ([]byte, []int) {
	return fileDescriptor_b5c7ece76d5d5022, []int{0, 5, 7}
}
func (m *MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider.Merge(m, src)
}
func (m *MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider) XXX_Size() int {
	return m.Size()
}
func (m *MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider) XXX_DiscardUnknown() {
	xxx_messageInfo_MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider.DiscardUnknown(m)
}

var xxx_messageInfo_MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider proto.InternalMessageInfo

func (m *MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider) GetService() string {
	if m != nil {
		return m.Service
	}
	return ""
}

func (m *MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider) GetPort() uint32 {
	if m != nil {
		return m.Port
	}
	return 0
}

func (m *MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider) GetContext() []MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider_TraceContext {
	if m != nil {
		return m.Context
	}
	return nil
}

func (m *MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider) GetMaxTagLength() uint32 {
	if m != nil {
		return m.MaxTagLength
	}
	return 0
}

// Holds the name references to the providers that will be used by default
// in other Istio configuration resources if the provider is not specified.
type MeshConfig_DefaultProviders struct {
	// Name of the default provider for tracing. This must match a provider
	// defined in `extension_providers` that is one of the support tracing
	// providers.
	Tracing              string   `protobuf:"bytes,1,opt,name=tracing,proto3" json:"tracing,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MeshConfig_DefaultProviders) Reset()         { *m = MeshConfig_DefaultProviders{} }
func (m *MeshConfig_DefaultProviders) String() string { return proto.CompactTextString(m) }
func (*MeshConfig_DefaultProviders) ProtoMessage()    {}
func (*MeshConfig_DefaultProviders) Descriptor() ([]byte, []int) {
	return fileDescriptor_b5c7ece76d5d5022, []int{0, 6}
}
func (m *MeshConfig_DefaultProviders) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MeshConfig_DefaultProviders) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MeshConfig_DefaultProviders.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *MeshConfig_DefaultProviders) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MeshConfig_DefaultProviders.Merge(m, src)
}
func (m *MeshConfig_DefaultProviders) XXX_Size() int {
	return m.Size()
}
func (m *MeshConfig_DefaultProviders) XXX_DiscardUnknown() {
	xxx_messageInfo_MeshConfig_DefaultProviders.DiscardUnknown(m)
}

var xxx_messageInfo_MeshConfig_DefaultProviders proto.InternalMessageInfo

func (m *MeshConfig_DefaultProviders) GetTracing() string {
	if m != nil {
		return m.Tracing
	}
	return ""
}

type MeshConfig_ProxyPathNormalization struct {
	Normalization        MeshConfig_ProxyPathNormalization_NormalizationType `protobuf:"varint,1,opt,name=normalization,proto3,enum=istio.mesh.v1alpha1.MeshConfig_ProxyPathNormalization_NormalizationType" json:"normalization,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                            `json:"-"`
	XXX_unrecognized     []byte                                              `json:"-"`
	XXX_sizecache        int32                                               `json:"-"`
}

func (m *MeshConfig_ProxyPathNormalization) Reset()         { *m = MeshConfig_ProxyPathNormalization{} }
func (m *MeshConfig_ProxyPathNormalization) String() string { return proto.CompactTextString(m) }
func (*MeshConfig_ProxyPathNormalization) ProtoMessage()    {}
func (*MeshConfig_ProxyPathNormalization) Descriptor() ([]byte, []int) {
	return fileDescriptor_b5c7ece76d5d5022, []int{0, 7}
}
func (m *MeshConfig_ProxyPathNormalization) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MeshConfig_ProxyPathNormalization) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MeshConfig_ProxyPathNormalization.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *MeshConfig_ProxyPathNormalization) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MeshConfig_ProxyPathNormalization.Merge(m, src)
}
func (m *MeshConfig_ProxyPathNormalization) XXX_Size() int {
	return m.Size()
}
func (m *MeshConfig_ProxyPathNormalization) XXX_DiscardUnknown() {
	xxx_messageInfo_MeshConfig_ProxyPathNormalization.DiscardUnknown(m)
}

var xxx_messageInfo_MeshConfig_ProxyPathNormalization proto.InternalMessageInfo

func (m *MeshConfig_ProxyPathNormalization) GetNormalization() MeshConfig_ProxyPathNormalization_NormalizationType {
	if m != nil {
		return m.Normalization
	}
	return MeshConfig_ProxyPathNormalization_DEFAULT
}

// ConfigSource describes information about a configuration store inside a
// mesh. A single control plane instance can interact with one or more data
// sources.
type ConfigSource struct {
	// Address of the server implementing the Istio Mesh Configuration
	// protocol (MCP). Can be IP address or a fully qualified DNS name.
	// Use fs:/// to specify a file-based backend with absolute path to the directory.
	Address string `protobuf:"bytes,1,opt,name=address,proto3" json:"address,omitempty"`
	// Use the tls_settings to specify the tls mode to use. If the MCP server
	// uses Istio mutual TLS and shares the root CA with Pilot, specify the TLS
	// mode as `ISTIO_MUTUAL`.
	TlsSettings *v1alpha3.ClientTLSSettings `protobuf:"bytes,2,opt,name=tls_settings,json=tlsSettings,proto3" json:"tlsSettings,omitempty"`
	// Describes the source of configuration, if nothing is specified default is MCP
	SubscribedResources  []Resource `protobuf:"varint,3,rep,packed,name=subscribed_resources,json=subscribedResources,proto3,enum=istio.mesh.v1alpha1.Resource" json:"subscribedResources,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *ConfigSource) Reset()         { *m = ConfigSource{} }
func (m *ConfigSource) String() string { return proto.CompactTextString(m) }
func (*ConfigSource) ProtoMessage()    {}
func (*ConfigSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_b5c7ece76d5d5022, []int{1}
}
func (m *ConfigSource) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ConfigSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ConfigSource.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ConfigSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ConfigSource.Merge(m, src)
}
func (m *ConfigSource) XXX_Size() int {
	return m.Size()
}
func (m *ConfigSource) XXX_DiscardUnknown() {
	xxx_messageInfo_ConfigSource.DiscardUnknown(m)
}

var xxx_messageInfo_ConfigSource proto.InternalMessageInfo

func (m *ConfigSource) GetAddress() string {
	if m != nil {
		return m.Address
	}
	return ""
}

func (m *ConfigSource) GetTlsSettings() *v1alpha3.ClientTLSSettings {
	if m != nil {
		return m.TlsSettings
	}
	return nil
}

func (m *ConfigSource) GetSubscribedResources() []Resource {
	if m != nil {
		return m.SubscribedResources
	}
	return nil
}

// Certificate configures the provision of a certificate and its key.
// Example 1: key and cert stored in a secret
// ```
// { secretName: galley-cert
//   secretNamespace: istio-system
//   dnsNames:
//     - galley.istio-system.svc
//     - galley.mydomain.com
// }
// ```
// Example 2: key and cert stored in a directory
// ```
// { dnsNames:
//     - pilot.istio-system
//     - pilot.istio-system.svc
//     - pilot.mydomain.com
// }
// ```
type Certificate struct {
	// Name of the secret the certificate and its key will be stored into.
	// If it is empty, it will not be stored into a secret.
	// Instead, the certificate and its key will be stored into a hard-coded directory.
	SecretName string `protobuf:"bytes,1,opt,name=secret_name,json=secretName,proto3" json:"secretName,omitempty"`
	// The DNS names for the certificate. A certificate may contain
	// multiple DNS names.
	DnsNames             []string `protobuf:"bytes,2,rep,name=dns_names,json=dnsNames,proto3" json:"dnsNames,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Certificate) Reset()         { *m = Certificate{} }
func (m *Certificate) String() string { return proto.CompactTextString(m) }
func (*Certificate) ProtoMessage()    {}
func (*Certificate) Descriptor() ([]byte, []int) {
	return fileDescriptor_b5c7ece76d5d5022, []int{2}
}
func (m *Certificate) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Certificate) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Certificate.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Certificate) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Certificate.Merge(m, src)
}
func (m *Certificate) XXX_Size() int {
	return m.Size()
}
func (m *Certificate) XXX_DiscardUnknown() {
	xxx_messageInfo_Certificate.DiscardUnknown(m)
}

var xxx_messageInfo_Certificate proto.InternalMessageInfo

func (m *Certificate) GetSecretName() string {
	if m != nil {
		return m.SecretName
	}
	return ""
}

func (m *Certificate) GetDnsNames() []string {
	if m != nil {
		return m.DnsNames
	}
	return nil
}

func init() {
	proto.RegisterEnum("istio.mesh.v1alpha1.Resource", Resource_name, Resource_value)
	proto.RegisterEnum("istio.mesh.v1alpha1.MeshConfig_IngressControllerMode", MeshConfig_IngressControllerMode_name, MeshConfig_IngressControllerMode_value)
	proto.RegisterEnum("istio.mesh.v1alpha1.MeshConfig_AuthPolicy", MeshConfig_AuthPolicy_name, MeshConfig_AuthPolicy_value)
	proto.RegisterEnum("istio.mesh.v1alpha1.MeshConfig_AccessLogEncoding", MeshConfig_AccessLogEncoding_name, MeshConfig_AccessLogEncoding_value)
	proto.RegisterEnum("istio.mesh.v1alpha1.MeshConfig_H2UpgradePolicy", MeshConfig_H2UpgradePolicy_name, MeshConfig_H2UpgradePolicy_value)
	proto.RegisterEnum("istio.mesh.v1alpha1.MeshConfig_OutboundTrafficPolicy_Mode", MeshConfig_OutboundTrafficPolicy_Mode_name, MeshConfig_OutboundTrafficPolicy_Mode_value)
	proto.RegisterEnum("istio.mesh.v1alpha1.MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider_TraceContext", MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider_TraceContext_name, MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider_TraceContext_value)
	proto.RegisterEnum("istio.mesh.v1alpha1.MeshConfig_ProxyPathNormalization_NormalizationType", MeshConfig_ProxyPathNormalization_NormalizationType_name, MeshConfig_ProxyPathNormalization_NormalizationType_value)
	proto.RegisterType((*MeshConfig)(nil), "istio.mesh.v1alpha1.MeshConfig")
	proto.RegisterType((*MeshConfig_OutboundTrafficPolicy)(nil), "istio.mesh.v1alpha1.MeshConfig.OutboundTrafficPolicy")
	proto.RegisterType((*MeshConfig_CertificateData)(nil), "istio.mesh.v1alpha1.MeshConfig.CertificateData")
	proto.RegisterType((*MeshConfig_ThriftConfig)(nil), "istio.mesh.v1alpha1.MeshConfig.ThriftConfig")
	proto.RegisterType((*MeshConfig_ServiceSettings)(nil), "istio.mesh.v1alpha1.MeshConfig.ServiceSettings")
	proto.RegisterType((*MeshConfig_ServiceSettings_Settings)(nil), "istio.mesh.v1alpha1.MeshConfig.ServiceSettings.Settings")
	proto.RegisterType((*MeshConfig_CA)(nil), "istio.mesh.v1alpha1.MeshConfig.CA")
	proto.RegisterType((*MeshConfig_ExtensionProvider)(nil), "istio.mesh.v1alpha1.MeshConfig.ExtensionProvider")
	proto.RegisterType((*MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationRequestBody)(nil), "istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.EnvoyExternalAuthorizationRequestBody")
	proto.RegisterType((*MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationHttpProvider)(nil), "istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.EnvoyExternalAuthorizationHttpProvider")
	proto.RegisterMapType((map[string]string)(nil), "istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.EnvoyExternalAuthorizationHttpProvider.IncludeAdditionalHeadersInCheckEntry")
	proto.RegisterType((*MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationGrpcProvider)(nil), "istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.EnvoyExternalAuthorizationGrpcProvider")
	proto.RegisterType((*MeshConfig_ExtensionProvider_ZipkinTracingProvider)(nil), "istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.ZipkinTracingProvider")
	proto.RegisterType((*MeshConfig_ExtensionProvider_LightstepTracingProvider)(nil), "istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.LightstepTracingProvider")
	proto.RegisterType((*MeshConfig_ExtensionProvider_DatadogTracingProvider)(nil), "istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.DatadogTracingProvider")
	proto.RegisterType((*MeshConfig_ExtensionProvider_StackdriverProvider)(nil), "istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.StackdriverProvider")
	proto.RegisterType((*MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider)(nil), "istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.OpenCensusAgentTracingProvider")
	proto.RegisterType((*MeshConfig_DefaultProviders)(nil), "istio.mesh.v1alpha1.MeshConfig.DefaultProviders")
	proto.RegisterType((*MeshConfig_ProxyPathNormalization)(nil), "istio.mesh.v1alpha1.MeshConfig.ProxyPathNormalization")
	proto.RegisterType((*ConfigSource)(nil), "istio.mesh.v1alpha1.ConfigSource")
	proto.RegisterType((*Certificate)(nil), "istio.mesh.v1alpha1.Certificate")
}

func init() { proto.RegisterFile("mesh/v1alpha1/config.proto", fileDescriptor_b5c7ece76d5d5022) }

var fileDescriptor_b5c7ece76d5d5022 = []byte{
	// 3270 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xc4, 0x5a, 0x4b, 0x73, 0x1b, 0x49,
	0x72, 0x16, 0x40, 0x48, 0x6c, 0x26, 0x08, 0xb2, 0x51, 0x7c, 0xa8, 0x05, 0xbd, 0x28, 0xce, 0x48,
	0xc3, 0x95, 0xc7, 0xe0, 0x88, 0x9a, 0x9d, 0xd5, 0xce, 0xda, 0x8e, 0x05, 0x01, 0x48, 0x24, 0x16,
	0x22, 0xe9, 0x22, 0xa8, 0x79, 0xc5, 0x46, 0x45, 0xb1, 0xbb, 0x00, 0xf4, 0xb2, 0xd1, 0xdd, 0xee,
	0x2a, 0x50, 0xe4, 0x44, 0xec, 0x2f, 0xf0, 0xc9, 0xe1, 0x93, 0x7f, 0x83, 0xc3, 0x3e, 0xf8, 0x57,
	0x38, 0x62, 0x2f, 0x3e, 0xec, 0xc9, 0xe1, 0x83, 0x63, 0xce, 0x8e, 0xf0, 0x5f, 0x70, 0xd4, 0xa3,
	0x81, 0x26, 0x09, 0x09, 0xe2, 0xc4, 0xac, 0xf7, 0x86, 0xce, 0xca, 0xfc, 0x32, 0x2b, 0xab, 0xf2,
	0x51, 0x55, 0x80, 0xca, 0x80, 0xf1, 0xfe, 0xe6, 0xe9, 0x33, 0x1a, 0xc4, 0x7d, 0xfa, 0x6c, 0xd3,
	0x8d, 0xc2, 0xae, 0xdf, 0xab, 0xc6, 0x49, 0x24, 0x22, 0xb4, 0xe4, 0x73, 0xe1, 0x47, 0x55, 0xc9,
	0x51, 0x4d, 0x39, 0x2a, 0x0f, 0x7a, 0x51, 0xd4, 0x0b, 0xd8, 0xa6, 0x62, 0x39, 0x1e, 0x76, 0x37,
	0xbd, 0x61, 0x42, 0x85, 0x1f, 0x85, 0x5a, 0xe8, 0xea, 0xf8, 0xdb, 0x84, 0xc6, 0x31, 0x4b, 0xb8,
	0x19, 0xbf, 0x73, 0x51, 0x61, 0x9c, 0x44, 0x67, 0xe7, 0x66, 0xe8, 0x69, 0xc8, 0xc4, 0xdb, 0x28,
	0x39, 0xf1, 0xc3, 0x5e, 0xca, 0xf0, 0x7c, 0xd3, 0x63, 0x5c, 0xf8, 0xa1, 0xd2, 0x40, 0x92, 0x61,
	0xc0, 0x0c, 0xef, 0xe7, 0x27, 0x2f, 0x78, 0xd5, 0x8f, 0x36, 0x69, 0xec, 0x0f, 0xa8, 0xdb, 0xf7,
	0x43, 0x96, 0x9c, 0x6f, 0xc6, 0x27, 0x3d, 0x49, 0xe0, 0x9b, 0x03, 0x26, 0xe8, 0xe6, 0xe9, 0xb3,
	0xcd, 0x1e, 0x0b, 0x59, 0x42, 0x05, 0xf3, 0xb4, 0xd4, 0xfa, 0x3f, 0xfe, 0x1a, 0xe0, 0x35, 0xe3,
	0xfd, 0xba, 0x9a, 0x26, 0x7a, 0x0a, 0x65, 0xa5, 0x9f, 0x04, 0x3e, 0x17, 0x2c, 0x24, 0x71, 0x94,
	0x08, 0xa7, 0xb0, 0x96, 0xdb, 0xb8, 0x89, 0x17, 0xd5, 0x40, 0x5b, 0xd1, 0x0f, 0xa2, 0x44, 0xa0,
	0x27, 0xa0, 0x49, 0xa4, 0x2f, 0x44, 0xac, 0x39, 0x6f, 0x2a, 0xce, 0x92, 0x22, 0xef, 0x08, 0x11,
	0x2b, 0xbe, 0x6d, 0x58, 0x74, 0xa3, 0x30, 0x64, 0xae, 0x20, 0xc2, 0x1f, 0xb0, 0x68, 0x28, 0x9c,
	0x5b, 0x6b, 0xb9, 0x8d, 0xe2, 0xd6, 0x9d, 0xaa, 0xf6, 0x4c, 0x35, 0xf5, 0x4c, 0xb5, 0x61, 0x3c,
	0x87, 0x17, 0x8c, 0x44, 0x47, 0x0b, 0xa0, 0xaf, 0xa0, 0xa2, 0x98, 0xdc, 0x28, 0x20, 0x1e, 0x13,
	0xcc, 0x55, 0xb3, 0x4f, 0xe1, 0x9e, 0x4e, 0x83, 0x73, 0x52, 0xe1, 0x46, 0x2a, 0x9b, 0x02, 0x47,
	0x50, 0x12, 0x6e, 0x4c, 0x4e, 0x18, 0x8b, 0x69, 0xe0, 0x9f, 0x32, 0xe7, 0x9e, 0xc2, 0x6a, 0x55,
	0xf5, 0x4a, 0x8f, 0xfd, 0x9f, 0xae, 0xf7, 0xf3, 0x6a, 0x5d, 0x9b, 0xe6, 0x47, 0xe1, 0x41, 0x14,
	0x05, 0x87, 0x4c, 0x08, 0x3f, 0xec, 0xf1, 0x6a, 0xa7, 0x7e, 0x30, 0xfe, 0xed, 0xc6, 0xbf, 0x49,
	0x11, 0xf1, 0xbc, 0xc8, 0x7c, 0xa1, 0x8f, 0xa0, 0xe4, 0x87, 0xbd, 0x84, 0x71, 0x4e, 0xdc, 0x80,
	0x72, 0xee, 0xcc, 0xae, 0xe5, 0x36, 0xe6, 0xf0, 0xbc, 0x21, 0xd6, 0x25, 0x0d, 0x7d, 0x02, 0x8b,
	0x29, 0x13, 0x67, 0xc9, 0xa9, 0xef, 0x32, 0xc7, 0x52, 0x6c, 0x0b, 0x86, 0x7c, 0xa8, 0xa9, 0x68,
	0x00, 0xb7, 0x47, 0x68, 0x51, 0x28, 0x92, 0x28, 0x08, 0x58, 0x42, 0x06, 0x91, 0xc7, 0x9c, 0xb9,
	0xb5, 0xdc, 0xc6, 0xc2, 0xd6, 0xcf, 0xab, 0x13, 0xb6, 0x6c, 0x75, 0xbc, 0xe2, 0xd5, 0x5d, 0xa3,
	0x77, 0x24, 0xfd, 0x3a, 0xf2, 0x18, 0x5e, 0xf1, 0x27, 0x91, 0xd1, 0xcf, 0xc0, 0x1e, 0xdb, 0x15,
	0x30, 0x57, 0x44, 0x89, 0xf3, 0xb9, 0x32, 0x6c, 0x71, 0x64, 0x98, 0x26, 0xa3, 0xc7, 0xb0, 0xc0,
	0x42, 0x7a, 0x1c, 0x30, 0x22, 0x12, 0xea, 0xfa, 0x61, 0xcf, 0x99, 0x5f, 0xcb, 0x6d, 0x58, 0xb8,
	0xa4, 0xa9, 0x1d, 0x4d, 0x94, 0x9b, 0x88, 0xba, 0xae, 0x04, 0x0c, 0xa2, 0x1e, 0xe9, 0xfa, 0x01,
	0x73, 0x4a, 0x0a, 0xb0, 0xa4, 0xc9, 0xed, 0xa8, 0xf7, 0xd2, 0x0f, 0x98, 0xdc, 0x98, 0x59, 0xbe,
	0x28, 0x19, 0x50, 0xe1, 0x38, 0x5a, 0xf5, 0x98, 0x53, 0x91, 0x11, 0x85, 0xa5, 0x0c, 0x2f, 0x0b,
	0xdd, 0xc8, 0x93, 0xfa, 0xef, 0x2a, 0x87, 0x3c, 0x9b, 0xe6, 0x90, 0x5a, 0x8a, 0xd6, 0x34, 0x82,
	0xb8, 0x4c, 0x2f, 0x93, 0x50, 0x03, 0x1e, 0x9a, 0xd9, 0xb1, 0xf0, 0x34, 0x3a, 0x27, 0x19, 0x7d,
	0xe9, 0x82, 0x6d, 0xa8, 0xe9, 0xde, 0xd5, 0x6c, 0x4d, 0xc9, 0x35, 0x42, 0x4e, 0x57, 0xef, 0x57,
	0x50, 0xf1, 0x7c, 0x9e, 0x81, 0xd1, 0x51, 0xc7, 0x12, 0x09, 0xe4, 0xbc, 0x50, 0x00, 0xb7, 0x0d,
	0x87, 0x42, 0x68, 0x9b, 0xf1, 0x76, 0xd4, 0x43, 0xaf, 0x60, 0xc1, 0x63, 0x5d, 0x3a, 0x0c, 0x04,
	0xd1, 0x39, 0xca, 0x59, 0x50, 0x5b, 0x77, 0x6d, 0xe2, 0x04, 0x0f, 0x64, 0x48, 0xea, 0x19, 0xe2,
	0x92, 0x91, 0x33, 0x31, 0x3f, 0x80, 0xdb, 0xd1, 0x50, 0x1c, 0x47, 0xc3, 0xd0, 0x93, 0x6b, 0xd5,
	0xed, 0xfa, 0x2e, 0x89, 0xa3, 0xc0, 0x77, 0xcf, 0x9d, 0xb2, 0x42, 0x9c, 0xba, 0x87, 0xf6, 0x8d,
	0x78, 0x47, 0x4b, 0x1f, 0x28, 0x61, 0xbc, 0x12, 0x4d, 0x22, 0xa3, 0x1d, 0x58, 0xd0, 0xf6, 0x12,
	0x1e, 0x0d, 0x13, 0x97, 0x71, 0x67, 0x75, 0x6d, 0x66, 0xa3, 0xb8, 0xf5, 0x68, 0xa2, 0x16, 0xad,
	0xe1, 0x50, 0x71, 0xe2, 0x92, 0x9b, 0xf9, 0xe2, 0xa8, 0x01, 0xb6, 0x59, 0x04, 0x3a, 0x14, 0x11,
	0x19, 0x88, 0x80, 0x3b, 0x7f, 0xa1, 0x2c, 0xae, 0x5c, 0x49, 0x05, 0xdb, 0x51, 0x14, 0xbc, 0xa1,
	0xc1, 0x90, 0x61, 0xb3, 0x2d, 0x6b, 0x43, 0x11, 0xbd, 0x16, 0x01, 0x47, 0x8f, 0x60, 0x5e, 0x24,
	0x43, 0x2e, 0x88, 0x17, 0x0d, 0xa8, 0x1f, 0x3a, 0x15, 0xb5, 0xa9, 0x8a, 0x8a, 0xd6, 0x50, 0x24,
	0xf4, 0x19, 0x2c, 0x67, 0x59, 0x08, 0x0d, 0x7c, 0xca, 0x19, 0x77, 0xaa, 0x6b, 0x33, 0x1b, 0x73,
	0x18, 0x65, 0x58, 0x6b, 0x7a, 0x04, 0x7d, 0x0d, 0x8b, 0x2e, 0x25, 0x2e, 0x4b, 0x84, 0xdf, 0xf5,
	0x5d, 0x2a, 0x18, 0x77, 0xbe, 0x54, 0xb3, 0xdc, 0x9c, 0xe6, 0xcb, 0xfa, 0x58, 0xa6, 0x41, 0x05,
	0xc5, 0x0b, 0x2e, 0xcd, 0x90, 0x38, 0xfa, 0x25, 0xdc, 0x49, 0x97, 0xdd, 0xec, 0x34, 0xc2, 0xce,
	0x64, 0xf2, 0x25, 0x22, 0x72, 0x1e, 0x2a, 0x83, 0x56, 0x0d, 0x83, 0xd9, 0x66, 0x4d, 0x35, 0xdc,
	0x89, 0xd0, 0x0e, 0x3c, 0x4a, 0x45, 0x4f, 0xfd, 0x44, 0x0c, 0x69, 0x30, 0x01, 0x62, 0x4d, 0x41,
	0xdc, 0x37, 0x8c, 0x6f, 0x34, 0xdf, 0x65, 0xa4, 0x16, 0xac, 0xa7, 0x48, 0x97, 0xab, 0x51, 0x06,
	0xea, 0x91, 0x82, 0x7a, 0x60, 0x38, 0x1b, 0x63, 0x46, 0x3c, 0x0c, 0xc6, 0x58, 0x8f, 0x61, 0x21,
	0x89, 0x22, 0x41, 0x42, 0x3a, 0x60, 0x3c, 0xa6, 0x2e, 0x73, 0xd6, 0x75, 0x02, 0x90, 0xd4, 0xbd,
	0x94, 0x88, 0xba, 0xb0, 0x14, 0x44, 0x2e, 0x0d, 0x7c, 0x71, 0x4e, 0x82, 0x63, 0xc2, 0x75, 0xaa,
	0x75, 0x3e, 0x52, 0xeb, 0xfd, 0xc5, 0x7b, 0xd2, 0x75, 0xdb, 0x48, 0xb5, 0x23, 0xea, 0x6d, 0xd3,
	0x80, 0x86, 0x2e, 0x4b, 0x4c, 0xa2, 0xc6, 0xe5, 0x14, 0xb2, 0x7d, 0x6c, 0x48, 0xa8, 0x0e, 0xb6,
	0x17, 0x72, 0x92, 0xb0, 0x6e, 0xc2, 0x78, 0x9f, 0xc8, 0x5a, 0xe9, 0x7c, 0x3c, 0xb5, 0x5c, 0x79,
	0x21, 0xc7, 0x5a, 0x02, 0x53, 0xc1, 0xd0, 0x77, 0x50, 0xee, 0x6f, 0x91, 0x61, 0xdc, 0x4b, 0xa8,
	0xc7, 0xd2, 0x60, 0xfa, 0x99, 0xca, 0x3f, 0x53, 0x37, 0xc0, 0xce, 0xd6, 0x91, 0x96, 0x33, 0x61,
	0xb4, 0xd8, 0xbf, 0x48, 0x90, 0x3b, 0xc0, 0x0f, 0x75, 0xb8, 0xba, 0xc1, 0x90, 0x0b, 0x96, 0x10,
	0x2e, 0xa8, 0x76, 0xa0, 0xf3, 0xa9, 0xf2, 0xdd, 0xaa, 0x61, 0xa8, 0xeb, 0xf1, 0x43, 0x41, 0x95,
	0x27, 0x65, 0xc2, 0x19, 0x85, 0xfa, 0x55, 0xd9, 0xbf, 0x54, 0xb2, 0xa3, 0x64, 0x70, 0x59, 0xb8,
	0x01, 0xf3, 0x17, 0x36, 0xf4, 0xa6, 0xda, 0xd0, 0x93, 0xd3, 0x4d, 0x66, 0xcb, 0xe2, 0x0b, 0x52,
	0xe8, 0x6f, 0xa1, 0x24, 0xfa, 0x89, 0xdf, 0x1d, 0x65, 0xad, 0x67, 0xca, 0xb9, 0x9f, 0x4e, 0x73,
	0x4b, 0x47, 0x09, 0x99, 0x0c, 0x36, 0x2f, 0x32, 0x5f, 0xe8, 0x5b, 0xb0, 0xd3, 0x7d, 0x6c, 0xb6,
	0x05, 0x77, 0xb6, 0x3e, 0x2c, 0xda, 0xcc, 0xc6, 0x4e, 0x0b, 0x37, 0x5e, 0xe4, 0x17, 0x09, 0x08,
	0xc3, 0x6d, 0x93, 0x63, 0xe2, 0x24, 0x1a, 0x30, 0xd1, 0x67, 0x43, 0x4e, 0x06, 0x2c, 0xe9, 0x31,
	0xe7, 0xf9, 0xd4, 0x54, 0xb3, 0xa2, 0x45, 0x0f, 0x46, 0x92, 0xaf, 0xa5, 0x20, 0xfa, 0x0e, 0xee,
	0x9d, 0xb2, 0xc4, 0xef, 0x9e, 0x67, 0x13, 0x04, 0xa1, 0x82, 0xb8, 0x81, 0xcf, 0x42, 0xe1, 0x7c,
	0x31, 0x15, 0xf8, 0x8e, 0x96, 0xcf, 0x78, 0xb9, 0x26, 0xea, 0x4a, 0x18, 0x6d, 0x41, 0xde, 0xa5,
	0xce, 0x2f, 0x14, 0xc4, 0xfa, 0xd4, 0x64, 0x53, 0xc3, 0x79, 0x97, 0xa2, 0x63, 0x58, 0x62, 0x67,
	0x82, 0x85, 0x5c, 0x06, 0x71, 0x9c, 0x44, 0xa7, 0xbe, 0xc7, 0x12, 0xee, 0xfc, 0x52, 0xf9, 0x70,
	0x6a, 0xc1, 0x6c, 0xa6, 0xa2, 0x07, 0x46, 0x12, 0x23, 0x76, 0x99, 0xc4, 0xd1, 0x6f, 0xa1, 0x9c,
	0xa6, 0x8c, 0xb1, 0x86, 0xbf, 0x52, 0x66, 0x7e, 0x36, 0x4d, 0x43, 0x43, 0x0b, 0x8e, 0xc0, 0xb0,
	0xed, 0x5d, 0xa2, 0x20, 0x0f, 0x96, 0x3c, 0x9f, 0xbb, 0xd1, 0x29, 0x4b, 0xce, 0x47, 0xbd, 0x09,
	0x77, 0x7e, 0xa5, 0xa6, 0xf0, 0xbc, 0xaa, 0x7b, 0xe3, 0x6a, 0xb6, 0x37, 0xae, 0xc6, 0x27, 0x3d,
	0x49, 0xe0, 0x55, 0xd9, 0x1b, 0x57, 0x4f, 0x9f, 0x55, 0xdb, 0xf4, 0x98, 0x05, 0x69, 0x03, 0x83,
	0xd1, 0x08, 0x2f, 0x25, 0x71, 0xc4, 0x00, 0xc5, 0x54, 0xf4, 0x49, 0x28, 0x1b, 0x8d, 0xc0, 0xff,
	0x5e, 0x45, 0xbf, 0xf3, 0xd7, 0x17, 0x72, 0xd0, 0x3b, 0x67, 0xa1, 0x4a, 0xf0, 0x01, 0x15, 0xfd,
	0xbd, 0xac, 0x34, 0x2e, 0xc7, 0x97, 0x49, 0x95, 0x7f, 0xc9, 0xc1, 0xca, 0xc4, 0x9a, 0x8a, 0xf6,
	0xa0, 0xa0, 0x9a, 0xbb, 0x9c, 0xca, 0x25, 0x5f, 0xfe, 0xa8, 0xc2, 0x5c, 0x55, 0x1d, 0x9e, 0xc2,
	0x59, 0x6f, 0x40, 0x41, 0x35, 0x76, 0x65, 0x28, 0xe1, 0xe6, 0xab, 0xdd, 0xc3, 0x0e, 0xfe, 0x86,
	0xec, 0xef, 0xb5, 0xbf, 0xb1, 0x6f, 0xa0, 0x12, 0xcc, 0xd5, 0xda, 0xed, 0xfd, 0xaf, 0x48, 0x6d,
	0xef, 0x1b, 0x3b, 0xb7, 0x5e, 0xb0, 0xf2, 0x76, 0xfe, 0xe9, 0xf2, 0x9b, 0x5d, 0xdc, 0x39, 0xaa,
	0xb5, 0xc9, 0x61, 0x13, 0xbf, 0xd9, 0xad, 0x37, 0x15, 0x73, 0xa5, 0x07, 0x8b, 0x97, 0xca, 0x16,
	0x42, 0x30, 0x13, 0xb3, 0x81, 0xb2, 0x73, 0x6e, 0xe7, 0x06, 0x96, 0x1f, 0xe8, 0x53, 0x28, 0xf3,
	0xd8, 0xef, 0x76, 0x19, 0x39, 0x1e, 0x86, 0x5e, 0xc0, 0xc8, 0x30, 0x09, 0x9c, 0xbc, 0xe1, 0x58,
	0xd4, 0x43, 0xdb, 0x6a, 0xe4, 0x28, 0x09, 0xb6, 0x11, 0xd8, 0xd9, 0xf0, 0xf0, 0xa8, 0xa0, 0x95,
	0xdf, 0xc3, 0x7c, 0x36, 0x0f, 0xa0, 0x8f, 0x61, 0x41, 0x26, 0x68, 0x12, 0xf8, 0x03, 0x5f, 0x28,
	0xb8, 0x9c, 0xee, 0xa6, 0x25, 0xb5, 0x2d, 0x89, 0x47, 0x49, 0x80, 0x5e, 0x01, 0xca, 0x70, 0xa5,
	0x87, 0x86, 0xfc, 0xb4, 0xa4, 0x6e, 0x8f, 0x40, 0xcc, 0x61, 0xa1, 0xf2, 0xaf, 0x39, 0x58, 0xbc,
	0x94, 0x31, 0x50, 0x07, 0xac, 0x51, 0xd2, 0xc9, 0x29, 0xc8, 0x17, 0xd7, 0x4c, 0x3a, 0xd5, 0x51,
	0xf6, 0x19, 0x21, 0xa1, 0x65, 0xb8, 0xd9, 0x8f, 0xb8, 0xe0, 0x4e, 0x5e, 0xd5, 0x50, 0xfd, 0x51,
	0xd9, 0x04, 0x6b, 0xa4, 0xf7, 0x23, 0x28, 0xa5, 0x19, 0x5c, 0x15, 0x31, 0xa5, 0xdc, 0xc2, 0xf3,
	0x86, 0xa8, 0xaa, 0x5e, 0xe5, 0x8f, 0x39, 0xc8, 0xd7, 0x6b, 0xc8, 0x81, 0x59, 0xea, 0x79, 0xb2,
	0x3d, 0x37, 0xfe, 0x49, 0x3f, 0xd1, 0x3e, 0xcc, 0x8b, 0x80, 0x8f, 0xd3, 0x66, 0xfe, 0x42, 0x32,
	0x9e, 0x78, 0xfa, 0x51, 0x69, 0xa6, 0xd3, 0x3e, 0x1c, 0x59, 0x5d, 0x14, 0x01, 0x1f, 0x99, 0xb5,
	0x0d, 0x8b, 0x09, 0xfb, 0xbb, 0x21, 0xe3, 0x63, 0x47, 0xcf, 0x4c, 0xad, 0x9e, 0x46, 0x22, 0x3d,
	0x93, 0x3d, 0x84, 0xa2, 0xd2, 0xef, 0x11, 0xee, 0x7b, 0x4c, 0x1d, 0x3f, 0x2d, 0x0c, 0x9a, 0x74,
	0xe8, 0x7b, 0xac, 0xf2, 0x9f, 0x15, 0x28, 0x5f, 0xc9, 0x3a, 0x08, 0x41, 0x41, 0x95, 0x31, 0x3d,
	0x45, 0xf5, 0x1b, 0xfd, 0x7d, 0x0e, 0x96, 0x75, 0x6b, 0xcd, 0xce, 0x84, 0x6c, 0x13, 0xfb, 0xdf,
	0xab, 0xe3, 0xaa, 0x99, 0xe8, 0xd7, 0xd7, 0xce, 0x6d, 0x55, 0xd5, 0x87, 0x4b, 0x72, 0x12, 0xd2,
	0xa0, 0x36, 0x14, 0xfd, 0x28, 0x31, 0x61, 0xab, 0x0e, 0xbc, 0x86, 0x6d, 0xe7, 0x06, 0x2e, 0x33,
	0xc3, 0x29, 0x99, 0xbe, 0x97, 0x83, 0x13, 0xad, 0xe9, 0x25, 0xb1, 0x6b, 0x5c, 0xf4, 0x93, 0x5a,
	0xf3, 0x2a, 0x89, 0xdd, 0x77, 0x5a, 0x23, 0x07, 0x11, 0x85, 0x5b, 0xdf, 0xfb, 0xf1, 0x89, 0x1f,
	0x2a, 0x0f, 0x17, 0xb7, 0x5e, 0x5d, 0x5f, 0xfd, 0xb7, 0x4a, 0xde, 0x9c, 0xe5, 0x32, 0xda, 0x0c,
	0x30, 0xfa, 0x1d, 0xcc, 0x05, 0x7e, 0xaf, 0x2f, 0xb8, 0x60, 0xb1, 0xba, 0x1c, 0x18, 0x9f, 0xac,
	0xaf, 0xa1, 0xa5, 0x9d, 0x42, 0x5c, 0x55, 0x34, 0x86, 0x47, 0x1e, 0xcc, 0xca, 0x1c, 0xe1, 0x45,
	0x3d, 0x73, 0xbd, 0xb0, 0x73, 0x7d, 0x4d, 0x0d, 0x0d, 0x70, 0x55, 0x4f, 0x0a, 0x8d, 0x7c, 0x28,
	0x72, 0x41, 0xdd, 0x13, 0x2f, 0xf1, 0x4f, 0x59, 0xa2, 0x0e, 0xef, 0xc5, 0xad, 0xe6, 0xf5, 0x35,
	0x1d, 0x8e, 0x41, 0x32, 0x6a, 0xb2, 0xd8, 0x28, 0x01, 0x88, 0x62, 0x16, 0xba, 0x2c, 0xe4, 0x43,
	0xae, 0xce, 0xff, 0xc5, 0xad, 0x83, 0xeb, 0x6b, 0xda, 0x8f, 0x59, 0x58, 0x57, 0x18, 0xb5, 0x9e,
	0x8c, 0xdc, 0x2b, 0x73, 0xcb, 0x68, 0xa9, 0xfc, 0x73, 0x0e, 0x1e, 0xbf, 0x7b, 0x4f, 0x61, 0x1d,
	0xa7, 0xdb, 0x91, 0x77, 0x2e, 0x0f, 0xe4, 0x03, 0x7a, 0x46, 0xd2, 0x60, 0x3f, 0x3e, 0x97, 0x2d,
	0xa1, 0x0c, 0xbd, 0x12, 0x5e, 0x1c, 0xd0, 0xb3, 0x94, 0x55, 0x92, 0xd1, 0x16, 0xac, 0xd0, 0x20,
	0x88, 0xde, 0x92, 0x98, 0x26, 0xc2, 0xa7, 0x01, 0x19, 0x30, 0xce, 0x69, 0x8f, 0xa9, 0x28, 0xb4,
	0xf0, 0x92, 0x1a, 0x3c, 0xd0, 0x63, 0xaf, 0xf5, 0x10, 0x5a, 0x87, 0x52, 0x4c, 0xdd, 0x13, 0x42,
	0xb9, 0xc1, 0x9e, 0x51, 0xbc, 0x45, 0x49, 0xac, 0x71, 0x85, 0x5b, 0xf9, 0xb7, 0x59, 0x78, 0xf2,
	0x61, 0xf1, 0x28, 0x53, 0x60, 0x7a, 0x30, 0x37, 0x29, 0xd0, 0x7c, 0xca, 0xb4, 0xa1, 0xee, 0xae,
	0xf2, 0xca, 0x76, 0xf5, 0x1b, 0x3d, 0x87, 0xd9, 0x34, 0x7b, 0xcd, 0x4d, 0xcb, 0x5e, 0x29, 0xa7,
	0x4c, 0x5b, 0xaa, 0x39, 0x88, 0x13, 0xd6, 0xf5, 0xcf, 0x94, 0xbd, 0x73, 0x18, 0x24, 0xe9, 0x40,
	0x51, 0xd0, 0x5d, 0x98, 0xeb, 0x52, 0x3f, 0x20, 0xd2, 0xdf, 0x26, 0xab, 0x59, 0x92, 0x20, 0x57,
	0x08, 0x3d, 0x81, 0x45, 0xd9, 0x89, 0x0f, 0x39, 0x89, 0x42, 0xc2, 0x92, 0x24, 0x4a, 0x54, 0xc0,
	0xcc, 0xe1, 0x92, 0x26, 0xef, 0x87, 0x4d, 0x49, 0x44, 0xbf, 0x00, 0xc7, 0x0f, 0xdd, 0x60, 0xe8,
	0x31, 0xd2, 0x67, 0x54, 0xf6, 0x3e, 0xc4, 0x0f, 0x89, 0xdb, 0x67, 0xee, 0x89, 0x73, 0x4b, 0x15,
	0x8b, 0x15, 0x33, 0xbe, 0xa3, 0x87, 0x77, 0xc3, 0xba, 0x1c, 0x44, 0x2f, 0x61, 0x2d, 0x15, 0x4c,
	0x17, 0xed, 0x0a, 0x00, 0x28, 0x80, 0x7b, 0x86, 0xcf, 0xac, 0xe1, 0x25, 0x9c, 0x3f, 0xe4, 0xe0,
	0xa3, 0x14, 0x88, 0x7a, 0x9e, 0x2f, 0x9d, 0x40, 0x83, 0xab, 0x58, 0x45, 0xd5, 0x7a, 0xfd, 0xfe,
	0x4f, 0x95, 0x61, 0xab, 0xbb, 0xda, 0x86, 0xda, 0xc8, 0x84, 0x8b, 0x76, 0x36, 0x43, 0x91, 0x9c,
	0xe3, 0x87, 0xfe, 0xfb, 0xb9, 0xd0, 0x3f, 0xe5, 0xe0, 0xfe, 0x65, 0xb7, 0x1c, 0x47, 0xde, 0xf9,
	0x78, 0x1e, 0xf3, 0x6a, 0x03, 0x7c, 0xf5, 0x53, 0xce, 0x23, 0x13, 0x47, 0xf8, 0xce, 0x45, 0x67,
	0x4b, 0x5a, 0x6a, 0xdb, 0xdf, 0xc0, 0xbd, 0xd4, 0xab, 0x22, 0x22, 0xc3, 0x98, 0x8b, 0x84, 0xd1,
	0x81, 0xdc, 0x1f, 0x2a, 0x60, 0x9c, 0x59, 0xb5, 0x5a, 0x8e, 0xe1, 0xe9, 0x44, 0x47, 0x86, 0x63,
	0x3f, 0xac, 0xc9, 0x71, 0xf4, 0x6b, 0xb8, 0x9f, 0x91, 0xf7, 0xa2, 0xb7, 0xe1, 0x18, 0xc1, 0x63,
	0xe1, 0xb9, 0x63, 0x29, 0x80, 0x3b, 0x23, 0x80, 0xc6, 0x88, 0x65, 0x3f, 0x6c, 0xb0, 0xf0, 0xbc,
	0x82, 0xe1, 0xe3, 0x0f, 0x71, 0x33, 0xb2, 0x61, 0xe6, 0x84, 0x9d, 0x9b, 0xc8, 0x92, 0x3f, 0x65,
	0x03, 0x73, 0x2a, 0x8f, 0x2a, 0xba, 0xbf, 0xc3, 0xfa, 0xe3, 0xcb, 0xfc, 0x8b, 0x5c, 0xe5, 0x7f,
	0xf2, 0xef, 0x0b, 0xda, 0x6c, 0xd9, 0xfa, 0xf1, 0x41, 0x7b, 0xf3, 0x83, 0x83, 0xf6, 0x42, 0x4c,
	0xce, 0x4c, 0x8f, 0xc9, 0xc2, 0xa4, 0x98, 0x9c, 0xbe, 0x89, 0x6e, 0xfd, 0xb9, 0x36, 0x51, 0xe5,
	0x04, 0x56, 0x26, 0x56, 0xe9, 0x6b, 0x3a, 0xf7, 0x63, 0x58, 0x90, 0xe9, 0x5e, 0xd0, 0x1e, 0x09,
	0x58, 0xd8, 0x13, 0x7d, 0xe5, 0xac, 0x12, 0x9e, 0x1f, 0xd0, 0xb3, 0x0e, 0xed, 0xb5, 0x15, 0xad,
	0xf2, 0x0f, 0x39, 0x70, 0xde, 0x55, 0xad, 0xaf, 0xa9, 0xf0, 0x11, 0xcc, 0x9b, 0x4b, 0x55, 0x11,
	0x9d, 0x98, 0xb5, 0x99, 0xc3, 0x45, 0x4d, 0xeb, 0x48, 0xd2, 0x04, 0x9b, 0x0a, 0x13, 0x6c, 0x0a,
	0x60, 0x75, 0x72, 0x59, 0xff, 0x93, 0x78, 0xe0, 0xbf, 0xf2, 0xb0, 0x34, 0xa1, 0xb6, 0xcb, 0x78,
	0xf0, 0xd8, 0xf1, 0xb0, 0x67, 0xda, 0x74, 0xfd, 0x81, 0x3a, 0xe0, 0x48, 0xcc, 0x70, 0x38, 0x38,
	0x66, 0x09, 0x89, 0xba, 0x84, 0x0a, 0x91, 0xf8, 0xc7, 0x43, 0x59, 0xef, 0x74, 0x87, 0x7a, 0xf7,
	0xca, 0x1e, 0xde, 0x0d, 0xc5, 0x17, 0x9f, 0x9b, 0xfb, 0x85, 0x01, 0x3d, 0xdb, 0x53, 0xb2, 0xfb,
	0xdd, 0xda, 0x48, 0x12, 0xbd, 0x81, 0x3b, 0x97, 0x50, 0xc3, 0x30, 0x12, 0x6a, 0xd3, 0x70, 0xd3,
	0x6a, 0xbe, 0x17, 0x76, 0x35, 0x0b, 0x3b, 0x16, 0x45, 0xdf, 0xc1, 0xbd, 0x8b, 0xb8, 0xa6, 0x8c,
	0x13, 0x76, 0xca, 0x42, 0xc1, 0x4d, 0x1b, 0xf9, 0x5e, 0x68, 0x27, 0x03, 0x6d, 0x2a, 0x7d, 0x53,
	0x09, 0x4f, 0x70, 0xef, 0xcd, 0x09, 0xee, 0xfd, 0x63, 0x1e, 0x1e, 0xbc, 0xbf, 0xa1, 0xb9, 0xe6,
	0xaa, 0xbe, 0x85, 0x59, 0x37, 0x0a, 0x05, 0x3b, 0x93, 0xe7, 0x94, 0x99, 0x8d, 0x85, 0xad, 0xdf,
	0xfe, 0xd4, 0x1d, 0x56, 0x55, 0x7e, 0xb3, 0xba, 0x56, 0x82, 0x53, 0x6d, 0x1f, 0xb6, 0x79, 0xd7,
	0x19, 0xcc, 0x67, 0xc5, 0xd1, 0x22, 0x14, 0x8f, 0xf6, 0x0e, 0x0f, 0x9a, 0xf5, 0xdd, 0x97, 0xbb,
	0xcd, 0x86, 0x7d, 0x03, 0xad, 0x40, 0xf9, 0xab, 0xe7, 0x75, 0xd2, 0xc1, 0xb5, 0x7a, 0x93, 0xd4,
	0xf7, 0xf7, 0x3a, 0xcd, 0xaf, 0x3b, 0x76, 0x0e, 0xcd, 0x83, 0xf5, 0x0a, 0x1f, 0xd4, 0xc9, 0xf6,
	0xee, 0x9e, 0x9d, 0x47, 0xb7, 0x61, 0xa9, 0xde, 0xde, 0x3f, 0x6a, 0x5c, 0x62, 0x9b, 0x41, 0xb7,
	0x20, 0xbf, 0xfd, 0xdc, 0x2e, 0x6c, 0x03, 0x58, 0xe9, 0xa5, 0x4c, 0xe5, 0x53, 0xb0, 0x2f, 0xdf,
	0xb7, 0x48, 0x9f, 0xa6, 0xaf, 0x38, 0xc6, 0xa7, 0xe6, 0xb3, 0xf2, 0xbf, 0x39, 0x58, 0x9d, 0x7c,
	0xb1, 0x81, 0x42, 0x28, 0x5d, 0xbc, 0x27, 0xd1, 0x97, 0x16, 0x3b, 0x3f, 0xee, 0x9e, 0xa4, 0x7a,
	0xe1, 0xab, 0x73, 0x1e, 0x33, 0x7c, 0x11, 0x7e, 0x9d, 0x41, 0xf9, 0x0a, 0x0f, 0x2a, 0xc2, 0x6c,
	0xa3, 0xf9, 0xb2, 0x76, 0xd4, 0xee, 0xd8, 0x37, 0x90, 0x05, 0x85, 0xbd, 0xfd, 0xbd, 0xa6, 0x9d,
	0x93, 0xbf, 0xb6, 0x6b, 0x87, 0x4d, 0x3b, 0x8f, 0xca, 0x50, 0x7a, 0xdd, 0xc4, 0xaf, 0x9a, 0xe4,
	0xb0, 0x5d, 0x3b, 0xdc, 0x69, 0x1e, 0xda, 0x33, 0xe8, 0x1e, 0x38, 0x8d, 0x66, 0x7d, 0xbf, 0xd1,
	0x24, 0xb5, 0xbd, 0x06, 0xb9, 0x38, 0x5a, 0x58, 0x6f, 0xc1, 0xca, 0xc4, 0x37, 0xb3, 0xab, 0x6b,
	0x33, 0x0b, 0x33, 0xfb, 0x2f, 0x5f, 0xda, 0xb9, 0xac, 0x11, 0x79, 0x04, 0x70, 0xeb, 0xb0, 0x83,
	0x77, 0xeb, 0x1d, 0x7b, 0x66, 0xfd, 0x09, 0x80, 0xcc, 0xe9, 0xe6, 0x72, 0x27, 0x35, 0xef, 0x06,
	0x5a, 0x00, 0x78, 0x7d, 0xa4, 0xee, 0x59, 0x3a, 0xed, 0x43, 0x3b, 0xb7, 0xfe, 0x09, 0x94, 0xaf,
	0x3c, 0x4b, 0x49, 0x76, 0xb5, 0x8c, 0x6a, 0x5e, 0xad, 0xc3, 0xfd, 0x3d, 0x3b, 0xb7, 0xbe, 0x05,
	0x8b, 0x97, 0xee, 0x8f, 0x11, 0x82, 0x85, 0xc6, 0x3e, 0xd9, 0xdb, 0xef, 0x90, 0xa3, 0x83, 0x57,
	0xb8, 0xd6, 0x90, 0xf8, 0x45, 0x98, 0x4d, 0x3f, 0x72, 0xad, 0x82, 0x95, 0xb3, 0xf3, 0xad, 0x82,
	0x95, 0xb7, 0x67, 0x5a, 0x05, 0x6b, 0xc6, 0x2e, 0xb4, 0x0a, 0xd6, 0x67, 0xf6, 0xb3, 0x56, 0xc1,
	0xba, 0x63, 0x57, 0x5a, 0x05, 0xeb, 0x81, 0xfd, 0xb0, 0x55, 0xb0, 0xc0, 0x2e, 0xb6, 0x0a, 0x56,
	0xd1, 0x9e, 0x6f, 0x15, 0xac, 0x45, 0xdb, 0x6e, 0x15, 0x2c, 0xdb, 0x2e, 0xb7, 0x0a, 0x16, 0xb2,
	0x97, 0x5a, 0x05, 0x6b, 0xc9, 0x5e, 0x6e, 0x15, 0xac, 0x65, 0x7b, 0xa5, 0x55, 0xb0, 0x56, 0xec,
	0xd5, 0x56, 0xc1, 0xba, 0x6d, 0x3b, 0xad, 0x82, 0x75, 0xdf, 0x7e, 0xd0, 0x2a, 0x58, 0x3f, 0xb7,
	0xbf, 0x68, 0x15, 0xac, 0xc7, 0xf6, 0x93, 0x56, 0xc1, 0x7a, 0x62, 0x7f, 0xd2, 0x2a, 0x58, 0x9f,
	0xd8, 0x1b, 0x18, 0x0d, 0xfc, 0x33, 0x96, 0xe8, 0x02, 0xa9, 0x1e, 0x22, 0x58, 0x82, 0x97, 0x34,
	0x2d, 0x61, 0xea, 0x0d, 0xc1, 0x10, 0x57, 0xd2, 0x47, 0x32, 0x7d, 0x91, 0xae, 0x25, 0x38, 0x1e,
	0xbd, 0x9d, 0x69, 0x19, 0xf5, 0x0a, 0xad, 0x05, 0x39, 0x5e, 0xcd, 0xb2, 0x92, 0x51, 0x85, 0xc7,
	0x8f, 0xb9, 0xef, 0x31, 0x97, 0x26, 0xb2, 0x21, 0x12, 0x2c, 0x60, 0x03, 0x26, 0xd4, 0x7d, 0x21,
	0x57, 0x57, 0x9f, 0xb4, 0xdb, 0xf5, 0x43, 0x5f, 0x9c, 0xe3, 0xa2, 0x3c, 0x9b, 0x1b, 0x75, 0xb8,
	0x9c, 0x78, 0xe3, 0xf7, 0x00, 0x8f, 0x05, 0xf4, 0x1c, 0x97, 0xb4, 0x4a, 0x73, 0x8b, 0x82, 0xd3,
	0xb7, 0x40, 0x7d, 0x7f, 0xab, 0x6e, 0x2d, 0x2e, 0xd8, 0x8a, 0xe7, 0xb9, 0xc7, 0xc9, 0xd0, 0xe3,
	0x44, 0x9e, 0x06, 0x70, 0x99, 0x5f, 0x01, 0x5c, 0x35, 0x08, 0x72, 0x44, 0xd5, 0x3b, 0x32, 0x88,
	0x86, 0xa1, 0xc0, 0x48, 0x09, 0x72, 0x46, 0x4e, 0x5e, 0x70, 0xc2, 0x29, 0xf9, 0xdd, 0x5b, 0x81,
	0x2b, 0x82, 0x25, 0x83, 0xf4, 0xc9, 0xc5, 0x4b, 0xa8, 0x1f, 0x92, 0xf4, 0x1f, 0x07, 0x78, 0x39,
	0xf5, 0x89, 0xf1, 0xe0, 0x31, 0x15, 0x6e, 0x1f, 0x3b, 0xd9, 0x2f, 0x22, 0xd3, 0x0e, 0x0b, 0x45,
	0xe2, 0x33, 0x8e, 0x57, 0xae, 0x8c, 0xc8, 0xc6, 0x68, 0xfd, 0x0f, 0x39, 0x98, 0xcf, 0xbe, 0xbc,
	0xfd, 0x7f, 0xde, 0x20, 0x1d, 0xc0, 0x32, 0x1f, 0x1e, 0x73, 0x37, 0xf1, 0x8f, 0x99, 0x47, 0x12,
	0x96, 0xbe, 0x12, 0xea, 0xf4, 0x7c, 0x7f, 0x62, 0xf6, 0xc0, 0x86, 0x0b, 0x2f, 0x8d, 0x45, 0x53,
	0x1a, 0x5f, 0xff, 0x0d, 0x14, 0x33, 0xd7, 0x93, 0xf2, 0x9c, 0xc6, 0x99, 0x9b, 0x30, 0xf3, 0xea,
	0xa1, 0xe7, 0x03, 0x9a, 0xa4, 0x1e, 0x3a, 0xee, 0xc2, 0x9c, 0x17, 0x72, 0xfd, 0x20, 0x65, 0x2e,
	0xe0, 0x2c, 0x2f, 0xe4, 0xea, 0x2d, 0xea, 0xe9, 0x1a, 0x58, 0x29, 0x32, 0x5a, 0x06, 0x3b, 0xbd,
	0x07, 0x4d, 0x6f, 0x4f, 0xed, 0x1b, 0xdb, 0x1b, 0xff, 0xfe, 0xc3, 0x83, 0xdc, 0x7f, 0xfc, 0xf0,
	0x20, 0xf7, 0xdf, 0x3f, 0x3c, 0xc8, 0x7d, 0x5b, 0xd1, 0xf6, 0xea, 0x3f, 0x66, 0x6c, 0x5e, 0xf8,
	0xab, 0xc7, 0xf1, 0x2d, 0x55, 0x22, 0x9f, 0xff, 0x5f, 0x00, 0x00, 0x00, 0xff, 0xff, 0x51, 0x82,
	0xe9, 0x66, 0x73, 0x22, 0x00, 0x00,
}

func (m *MeshConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MeshConfig) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MeshConfig) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.PathNormalization != nil {
		{
			size, err := m.PathNormalization.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintConfig(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3
		i--
		dAtA[i] = 0xea
	}
	if m.DefaultProviders != nil {
		{
			size, err := m.DefaultProviders.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintConfig(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3
		i--
		dAtA[i] = 0xe2
	}
	if len(m.DiscoverySelectors) > 0 {
		for iNdEx := len(m.DiscoverySelectors) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.DiscoverySelectors[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintConfig(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x3
			i--
			dAtA[i] = 0xda
		}
	}
	if len(m.CaCertificates) > 0 {
		for iNdEx := len(m.CaCertificates) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.CaCertificates[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintConfig(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x3
			i--
			dAtA[i] = 0xd2
		}
	}
	if len(m.ExtensionProviders) > 0 {
		for iNdEx := len(m.ExtensionProviders) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.ExtensionProviders[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintConfig(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x3
			i--
			dAtA[i] = 0xca
		}
	}
	if m.DisableEnvoyListenerLog {
		i--
		if m.DisableEnvoyListenerLog {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x3
		i--
		dAtA[i] = 0xc0
	}
	if m.Ca != nil {
		{
			size, err := m.Ca.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintConfig(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3
		i--
		dAtA[i] = 0xba
	}
	if m.VerifyCertificateAtClient != nil {
		{
			size, err := m.VerifyCertificateAtClient.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintConfig(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3
		i--
		dAtA[i] = 0xb2
	}
	if len(m.IngressSelector) > 0 {
		i -= len(m.IngressSelector)
		copy(dAtA[i:], m.IngressSelector)
		i = encodeVarintConfig(dAtA, i, uint64(len(m.IngressSelector)))
		i--
		dAtA[i] = 0x3
		i--
		dAtA[i] = 0xa2
	}
	if m.EnablePrometheusMerge != nil {
		{
			size, err := m.EnablePrometheusMerge.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintConfig(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3
		i--
		dAtA[i] = 0x9a
	}
	if len(m.ServiceSettings) > 0 {
		for iNdEx := len(m.ServiceSettings) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.ServiceSettings[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintConfig(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x3
			i--
			dAtA[i] = 0x92
		}
	}
	if m.ThriftConfig != nil {
		{
			size, err := m.ThriftConfig.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintConfig(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3
		i--
		dAtA[i] = 0x8a
	}
	if len(m.Certificates) > 0 {
		for iNdEx := len(m.Certificates) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Certificates[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintConfig(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x2
			i--
			dAtA[i] = 0xfa
		}
	}
	if len(m.TrustDomainAliases) > 0 {
		for iNdEx := len(m.TrustDomainAliases) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.TrustDomainAliases[iNdEx])
			copy(dAtA[i:], m.TrustDomainAliases[iNdEx])
			i = encodeVarintConfig(dAtA, i, uint64(len(m.TrustDomainAliases[iNdEx])))
			i--
			dAtA[i] = 0x2
			i--
			dAtA[i] = 0xf2
		}
	}
	if len(m.OutboundClusterStatName) > 0 {
		i -= len(m.OutboundClusterStatName)
		copy(dAtA[i:], m.OutboundClusterStatName)
		i = encodeVarintConfig(dAtA, i, uint64(len(m.OutboundClusterStatName)))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0xea
	}
	if len(m.InboundClusterStatName) > 0 {
		i -= len(m.InboundClusterStatName)
		copy(dAtA[i:], m.InboundClusterStatName)
		i = encodeVarintConfig(dAtA, i, uint64(len(m.InboundClusterStatName)))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0xe2
	}
	if m.EnableAutoMtls != nil {
		{
			size, err := m.EnableAutoMtls.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintConfig(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0xda
	}
	if m.ProtocolDetectionTimeout != nil {
		{
			size, err := m.ProtocolDetectionTimeout.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintConfig(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0xd2
	}
	if m.H2UpgradePolicy != 0 {
		i = encodeVarintConfig(dAtA, i, uint64(m.H2UpgradePolicy))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0xc8
	}
	if m.EnableEnvoyAccessLogService {
		i--
		if m.EnableEnvoyAccessLogService {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0xc0
	}
	if m.DnsRefreshRate != nil {
		{
			size, err := m.DnsRefreshRate.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintConfig(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0xa2
	}
	if m.LocalityLbSetting != nil {
		{
			size, err := m.LocalityLbSetting.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintConfig(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0x9a
	}
	if len(m.RootNamespace) > 0 {
		i -= len(m.RootNamespace)
		copy(dAtA[i:], m.RootNamespace)
		i = encodeVarintConfig(dAtA, i, uint64(len(m.RootNamespace)))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0x92
	}
	if len(m.DefaultDestinationRuleExportTo) > 0 {
		for iNdEx := len(m.DefaultDestinationRuleExportTo) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.DefaultDestinationRuleExportTo[iNdEx])
			copy(dAtA[i:], m.DefaultDestinationRuleExportTo[iNdEx])
			i = encodeVarintConfig(dAtA, i, uint64(len(m.DefaultDestinationRuleExportTo[iNdEx])))
			i--
			dAtA[i] = 0x2
			i--
			dAtA[i] = 0x8a
		}
	}
	if len(m.DefaultVirtualServiceExportTo) > 0 {
		for iNdEx := len(m.DefaultVirtualServiceExportTo) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.DefaultVirtualServiceExportTo[iNdEx])
			copy(dAtA[i:], m.DefaultVirtualServiceExportTo[iNdEx])
			i = encodeVarintConfig(dAtA, i, uint64(len(m.DefaultVirtualServiceExportTo[iNdEx])))
			i--
			dAtA[i] = 0x2
			i--
			dAtA[i] = 0x82
		}
	}
	if len(m.DefaultServiceExportTo) > 0 {
		for iNdEx := len(m.DefaultServiceExportTo) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.DefaultServiceExportTo[iNdEx])
			copy(dAtA[i:], m.DefaultServiceExportTo[iNdEx])
			i = encodeVarintConfig(dAtA, i, uint64(len(m.DefaultServiceExportTo[iNdEx])))
			i--
			dAtA[i] = 0x1
			i--
			dAtA[i] = 0xfa
		}
	}
	if m.TcpKeepalive != nil {
		{
			size, err := m.TcpKeepalive.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintConfig(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xe2
	}
	if m.AccessLogEncoding != 0 {
		i = encodeVarintConfig(dAtA, i, uint64(m.AccessLogEncoding))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xd8
	}
	if len(m.TrustDomain) > 0 {
		i -= len(m.TrustDomain)
		copy(dAtA[i:], m.TrustDomain)
		i = encodeVarintConfig(dAtA, i, uint64(len(m.TrustDomain)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xd2
	}
	if len(m.AccessLogFormat) > 0 {
		i -= len(m.AccessLogFormat)
		copy(dAtA[i:], m.AccessLogFormat)
		i = encodeVarintConfig(dAtA, i, uint64(len(m.AccessLogFormat)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xc2
	}
	if len(m.ConfigSources) > 0 {
		for iNdEx := len(m.ConfigSources) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.ConfigSources[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintConfig(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1
			i--
			dAtA[i] = 0xb2
		}
	}
	if m.OutboundTrafficPolicy != nil {
		{
			size, err := m.OutboundTrafficPolicy.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintConfig(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x8a
	}
	if m.DefaultConfig != nil {
		{
			size, err := m.DefaultConfig.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintConfig(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x72
	}
	if len(m.AccessLogFile) > 0 {
		i -= len(m.AccessLogFile)
		copy(dAtA[i:], m.AccessLogFile)
		i = encodeVarintConfig(dAtA, i, uint64(len(m.AccessLogFile)))
		i--
		dAtA[i] = 0x6a
	}
	if m.EnableTracing {
		i--
		if m.EnableTracing {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x60
	}
	if m.IngressControllerMode != 0 {
		i = encodeVarintConfig(dAtA, i, uint64(m.IngressControllerMode))
		i--
		dAtA[i] = 0x48
	}
	if len(m.IngressService) > 0 {
		i -= len(m.IngressService)
		copy(dAtA[i:], m.IngressService)
		i = encodeVarintConfig(dAtA, i, uint64(len(m.IngressService)))
		i--
		dAtA[i] = 0x42
	}
	if len(m.IngressClass) > 0 {
		i -= len(m.IngressClass)
		copy(dAtA[i:], m.IngressClass)
		i = encodeVarintConfig(dAtA, i, uint64(len(m.IngressClass)))
		i--
		dAtA[i] = 0x3a
	}
	if m.ConnectTimeout != nil {
		{
			size, err := m.ConnectTimeout.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintConfig(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	if m.ProxyHttpPort != 0 {
		i = encodeVarintConfig(dAtA, i, uint64(m.ProxyHttpPort))
		i--
		dAtA[i] = 0x28
	}
	if m.ProxyListenPort != 0 {
		i = encodeVarintConfig(dAtA, i, uint64(m.ProxyListenPort))
		i--
		dAtA[i] = 0x20
	}
	return len(dAtA) - i, nil
}

func (m *MeshConfig_OutboundTrafficPolicy) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MeshConfig_OutboundTrafficPolicy) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MeshConfig_OutboundTrafficPolicy) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Mode != 0 {
		i = encodeVarintConfig(dAtA, i, uint64(m.Mode))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *MeshConfig_CertificateData) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MeshConfig_CertificateData) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MeshConfig_CertificateData) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.CertificateData != nil {
		{
			size := m.CertificateData.Size()
			i -= size
			if _, err := m.CertificateData.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	return len(dAtA) - i, nil
}

func (m *MeshConfig_CertificateData_Pem) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MeshConfig_CertificateData_Pem) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i -= len(m.Pem)
	copy(dAtA[i:], m.Pem)
	i = encodeVarintConfig(dAtA, i, uint64(len(m.Pem)))
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}
func (m *MeshConfig_CertificateData_SpiffeBundleUrl) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MeshConfig_CertificateData_SpiffeBundleUrl) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i -= len(m.SpiffeBundleUrl)
	copy(dAtA[i:], m.SpiffeBundleUrl)
	i = encodeVarintConfig(dAtA, i, uint64(len(m.SpiffeBundleUrl)))
	i--
	dAtA[i] = 0x12
	return len(dAtA) - i, nil
}
func (m *MeshConfig_ThriftConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MeshConfig_ThriftConfig) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MeshConfig_ThriftConfig) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.RateLimitTimeout != nil {
		{
			size, err := m.RateLimitTimeout.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintConfig(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.RateLimitUrl) > 0 {
		i -= len(m.RateLimitUrl)
		copy(dAtA[i:], m.RateLimitUrl)
		i = encodeVarintConfig(dAtA, i, uint64(len(m.RateLimitUrl)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *MeshConfig_ServiceSettings) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MeshConfig_ServiceSettings) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MeshConfig_ServiceSettings) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Hosts) > 0 {
		for iNdEx := len(m.Hosts) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Hosts[iNdEx])
			copy(dAtA[i:], m.Hosts[iNdEx])
			i = encodeVarintConfig(dAtA, i, uint64(len(m.Hosts[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	if m.Settings != nil {
		{
			size, err := m.Settings.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintConfig(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *MeshConfig_ServiceSettings_Settings) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MeshConfig_ServiceSettings_Settings) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MeshConfig_ServiceSettings_Settings) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.ClusterLocal {
		i--
		if m.ClusterLocal {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *MeshConfig_CA) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MeshConfig_CA) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MeshConfig_CA) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.IstiodSide {
		i--
		if m.IstiodSide {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x20
	}
	if m.RequestTimeout != nil {
		{
			size, err := m.RequestTimeout.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintConfig(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.TlsSettings != nil {
		{
			size, err := m.TlsSettings.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintConfig(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.Address) > 0 {
		i -= len(m.Address)
		copy(dAtA[i:], m.Address)
		i = encodeVarintConfig(dAtA, i, uint64(len(m.Address)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *MeshConfig_ExtensionProvider) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MeshConfig_ExtensionProvider) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MeshConfig_ExtensionProvider) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Provider != nil {
		{
			size := m.Provider.Size()
			i -= size
			if _, err := m.Provider.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintConfig(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *MeshConfig_ExtensionProvider_EnvoyExtAuthzHttp) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MeshConfig_ExtensionProvider_EnvoyExtAuthzHttp) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.EnvoyExtAuthzHttp != nil {
		{
			size, err := m.EnvoyExtAuthzHttp.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintConfig(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	return len(dAtA) - i, nil
}
func (m *MeshConfig_ExtensionProvider_EnvoyExtAuthzGrpc) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MeshConfig_ExtensionProvider_EnvoyExtAuthzGrpc) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.EnvoyExtAuthzGrpc != nil {
		{
			size, err := m.EnvoyExtAuthzGrpc.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintConfig(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	return len(dAtA) - i, nil
}
func (m *MeshConfig_ExtensionProvider_Zipkin) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MeshConfig_ExtensionProvider_Zipkin) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Zipkin != nil {
		{
			size, err := m.Zipkin.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintConfig(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	return len(dAtA) - i, nil
}
func (m *MeshConfig_ExtensionProvider_Lightstep) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MeshConfig_ExtensionProvider_Lightstep) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Lightstep != nil {
		{
			size, err := m.Lightstep.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintConfig(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	return len(dAtA) - i, nil
}
func (m *MeshConfig_ExtensionProvider_Datadog) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MeshConfig_ExtensionProvider_Datadog) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Datadog != nil {
		{
			size, err := m.Datadog.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintConfig(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	return len(dAtA) - i, nil
}
func (m *MeshConfig_ExtensionProvider_Stackdriver) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MeshConfig_ExtensionProvider_Stackdriver) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Stackdriver != nil {
		{
			size, err := m.Stackdriver.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintConfig(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	return len(dAtA) - i, nil
}
func (m *MeshConfig_ExtensionProvider_Opencensus) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MeshConfig_ExtensionProvider_Opencensus) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Opencensus != nil {
		{
			size, err := m.Opencensus.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintConfig(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x42
	}
	return len(dAtA) - i, nil
}
func (m *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationRequestBody) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationRequestBody) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationRequestBody) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.PackAsBytes {
		i--
		if m.PackAsBytes {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x18
	}
	if m.AllowPartialMessage {
		i--
		if m.AllowPartialMessage {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x10
	}
	if m.MaxRequestBytes != 0 {
		i = encodeVarintConfig(dAtA, i, uint64(m.MaxRequestBytes))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationHttpProvider) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationHttpProvider) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationHttpProvider) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.IncludeRequestBodyInCheck != nil {
		{
			size, err := m.IncludeRequestBodyInCheck.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintConfig(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x62
	}
	if len(m.IncludeAdditionalHeadersInCheck) > 0 {
		for k := range m.IncludeAdditionalHeadersInCheck {
			v := m.IncludeAdditionalHeadersInCheck[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintConfig(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintConfig(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintConfig(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x5a
		}
	}
	if len(m.IncludeRequestHeadersInCheck) > 0 {
		for iNdEx := len(m.IncludeRequestHeadersInCheck) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.IncludeRequestHeadersInCheck[iNdEx])
			copy(dAtA[i:], m.IncludeRequestHeadersInCheck[iNdEx])
			i = encodeVarintConfig(dAtA, i, uint64(len(m.IncludeRequestHeadersInCheck[iNdEx])))
			i--
			dAtA[i] = 0x52
		}
	}
	if m.Timeout != nil {
		{
			size, err := m.Timeout.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintConfig(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x4a
	}
	if len(m.HeadersToDownstreamOnDeny) > 0 {
		for iNdEx := len(m.HeadersToDownstreamOnDeny) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.HeadersToDownstreamOnDeny[iNdEx])
			copy(dAtA[i:], m.HeadersToDownstreamOnDeny[iNdEx])
			i = encodeVarintConfig(dAtA, i, uint64(len(m.HeadersToDownstreamOnDeny[iNdEx])))
			i--
			dAtA[i] = 0x42
		}
	}
	if len(m.HeadersToUpstreamOnAllow) > 0 {
		for iNdEx := len(m.HeadersToUpstreamOnAllow) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.HeadersToUpstreamOnAllow[iNdEx])
			copy(dAtA[i:], m.HeadersToUpstreamOnAllow[iNdEx])
			i = encodeVarintConfig(dAtA, i, uint64(len(m.HeadersToUpstreamOnAllow[iNdEx])))
			i--
			dAtA[i] = 0x3a
		}
	}
	if len(m.IncludeHeadersInCheck) > 0 {
		for iNdEx := len(m.IncludeHeadersInCheck) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.IncludeHeadersInCheck[iNdEx])
			copy(dAtA[i:], m.IncludeHeadersInCheck[iNdEx])
			i = encodeVarintConfig(dAtA, i, uint64(len(m.IncludeHeadersInCheck[iNdEx])))
			i--
			dAtA[i] = 0x32
		}
	}
	if len(m.StatusOnError) > 0 {
		i -= len(m.StatusOnError)
		copy(dAtA[i:], m.StatusOnError)
		i = encodeVarintConfig(dAtA, i, uint64(len(m.StatusOnError)))
		i--
		dAtA[i] = 0x2a
	}
	if m.FailOpen {
		i--
		if m.FailOpen {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x20
	}
	if len(m.PathPrefix) > 0 {
		i -= len(m.PathPrefix)
		copy(dAtA[i:], m.PathPrefix)
		i = encodeVarintConfig(dAtA, i, uint64(len(m.PathPrefix)))
		i--
		dAtA[i] = 0x1a
	}
	if m.Port != 0 {
		i = encodeVarintConfig(dAtA, i, uint64(m.Port))
		i--
		dAtA[i] = 0x10
	}
	if len(m.Service) > 0 {
		i -= len(m.Service)
		copy(dAtA[i:], m.Service)
		i = encodeVarintConfig(dAtA, i, uint64(len(m.Service)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationGrpcProvider) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationGrpcProvider) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationGrpcProvider) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.IncludeRequestBodyInCheck != nil {
		{
			size, err := m.IncludeRequestBodyInCheck.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintConfig(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	if m.Timeout != nil {
		{
			size, err := m.Timeout.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintConfig(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if len(m.StatusOnError) > 0 {
		i -= len(m.StatusOnError)
		copy(dAtA[i:], m.StatusOnError)
		i = encodeVarintConfig(dAtA, i, uint64(len(m.StatusOnError)))
		i--
		dAtA[i] = 0x22
	}
	if m.FailOpen {
		i--
		if m.FailOpen {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x18
	}
	if m.Port != 0 {
		i = encodeVarintConfig(dAtA, i, uint64(m.Port))
		i--
		dAtA[i] = 0x10
	}
	if len(m.Service) > 0 {
		i -= len(m.Service)
		copy(dAtA[i:], m.Service)
		i = encodeVarintConfig(dAtA, i, uint64(len(m.Service)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *MeshConfig_ExtensionProvider_ZipkinTracingProvider) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MeshConfig_ExtensionProvider_ZipkinTracingProvider) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MeshConfig_ExtensionProvider_ZipkinTracingProvider) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.MaxTagLength != 0 {
		i = encodeVarintConfig(dAtA, i, uint64(m.MaxTagLength))
		i--
		dAtA[i] = 0x18
	}
	if m.Port != 0 {
		i = encodeVarintConfig(dAtA, i, uint64(m.Port))
		i--
		dAtA[i] = 0x10
	}
	if len(m.Service) > 0 {
		i -= len(m.Service)
		copy(dAtA[i:], m.Service)
		i = encodeVarintConfig(dAtA, i, uint64(len(m.Service)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *MeshConfig_ExtensionProvider_LightstepTracingProvider) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MeshConfig_ExtensionProvider_LightstepTracingProvider) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MeshConfig_ExtensionProvider_LightstepTracingProvider) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.MaxTagLength != 0 {
		i = encodeVarintConfig(dAtA, i, uint64(m.MaxTagLength))
		i--
		dAtA[i] = 0x20
	}
	if len(m.AccessToken) > 0 {
		i -= len(m.AccessToken)
		copy(dAtA[i:], m.AccessToken)
		i = encodeVarintConfig(dAtA, i, uint64(len(m.AccessToken)))
		i--
		dAtA[i] = 0x1a
	}
	if m.Port != 0 {
		i = encodeVarintConfig(dAtA, i, uint64(m.Port))
		i--
		dAtA[i] = 0x10
	}
	if len(m.Service) > 0 {
		i -= len(m.Service)
		copy(dAtA[i:], m.Service)
		i = encodeVarintConfig(dAtA, i, uint64(len(m.Service)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *MeshConfig_ExtensionProvider_DatadogTracingProvider) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MeshConfig_ExtensionProvider_DatadogTracingProvider) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MeshConfig_ExtensionProvider_DatadogTracingProvider) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.MaxTagLength != 0 {
		i = encodeVarintConfig(dAtA, i, uint64(m.MaxTagLength))
		i--
		dAtA[i] = 0x18
	}
	if m.Port != 0 {
		i = encodeVarintConfig(dAtA, i, uint64(m.Port))
		i--
		dAtA[i] = 0x10
	}
	if len(m.Service) > 0 {
		i -= len(m.Service)
		copy(dAtA[i:], m.Service)
		i = encodeVarintConfig(dAtA, i, uint64(len(m.Service)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *MeshConfig_ExtensionProvider_StackdriverProvider) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MeshConfig_ExtensionProvider_StackdriverProvider) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MeshConfig_ExtensionProvider_StackdriverProvider) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.MaxTagLength != 0 {
		i = encodeVarintConfig(dAtA, i, uint64(m.MaxTagLength))
		i--
		dAtA[i] = 0x28
	}
	if m.MaxNumberOfMessageEvents != nil {
		{
			size, err := m.MaxNumberOfMessageEvents.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintConfig(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if m.MaxNumberOfAnnotations != nil {
		{
			size, err := m.MaxNumberOfAnnotations.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintConfig(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.MaxNumberOfAttributes != nil {
		{
			size, err := m.MaxNumberOfAttributes.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintConfig(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Debug {
		i--
		if m.Debug {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.MaxTagLength != 0 {
		i = encodeVarintConfig(dAtA, i, uint64(m.MaxTagLength))
		i--
		dAtA[i] = 0x20
	}
	if len(m.Context) > 0 {
		dAtA34 := make([]byte, len(m.Context)*10)
		var j33 int
		for _, num := range m.Context {
			for num >= 1<<7 {
				dAtA34[j33] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j33++
			}
			dAtA34[j33] = uint8(num)
			j33++
		}
		i -= j33
		copy(dAtA[i:], dAtA34[:j33])
		i = encodeVarintConfig(dAtA, i, uint64(j33))
		i--
		dAtA[i] = 0x1a
	}
	if m.Port != 0 {
		i = encodeVarintConfig(dAtA, i, uint64(m.Port))
		i--
		dAtA[i] = 0x10
	}
	if len(m.Service) > 0 {
		i -= len(m.Service)
		copy(dAtA[i:], m.Service)
		i = encodeVarintConfig(dAtA, i, uint64(len(m.Service)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *MeshConfig_DefaultProviders) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MeshConfig_DefaultProviders) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MeshConfig_DefaultProviders) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Tracing) > 0 {
		i -= len(m.Tracing)
		copy(dAtA[i:], m.Tracing)
		i = encodeVarintConfig(dAtA, i, uint64(len(m.Tracing)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *MeshConfig_ProxyPathNormalization) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MeshConfig_ProxyPathNormalization) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MeshConfig_ProxyPathNormalization) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Normalization != 0 {
		i = encodeVarintConfig(dAtA, i, uint64(m.Normalization))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *ConfigSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ConfigSource) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ConfigSource) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.SubscribedResources) > 0 {
		dAtA36 := make([]byte, len(m.SubscribedResources)*10)
		var j35 int
		for _, num := range m.SubscribedResources {
			for num >= 1<<7 {
				dAtA36[j35] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j35++
			}
			dAtA36[j35] = uint8(num)
			j35++
		}
		i -= j35
		copy(dAtA[i:], dAtA36[:j35])
		i = encodeVarintConfig(dAtA, i, uint64(j35))
		i--
		dAtA[i] = 0x1a
	}
	if m.TlsSettings != nil {
		{
			size, err := m.TlsSettings.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintConfig(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.Address) > 0 {
		i -= len(m.Address)
		copy(dAtA[i:], m.Address)
		i = encodeVarintConfig(dAtA, i, uint64(len(m.Address)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Certificate) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Certificate) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Certificate) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.DnsNames) > 0 {
		for iNdEx := len(m.DnsNames) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.DnsNames[iNdEx])
			copy(dAtA[i:], m.DnsNames[iNdEx])
			i = encodeVarintConfig(dAtA, i, uint64(len(m.DnsNames[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.SecretName) > 0 {
		i -= len(m.SecretName)
		copy(dAtA[i:], m.SecretName)
		i = encodeVarintConfig(dAtA, i, uint64(len(m.SecretName)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintConfig(dAtA []byte, offset int, v uint64) int {
	offset -= sovConfig(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *MeshConfig) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ProxyListenPort != 0 {
		n += 1 + sovConfig(uint64(m.ProxyListenPort))
	}
	if m.ProxyHttpPort != 0 {
		n += 1 + sovConfig(uint64(m.ProxyHttpPort))
	}
	if m.ConnectTimeout != nil {
		l = m.ConnectTimeout.Size()
		n += 1 + l + sovConfig(uint64(l))
	}
	l = len(m.IngressClass)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	l = len(m.IngressService)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	if m.IngressControllerMode != 0 {
		n += 1 + sovConfig(uint64(m.IngressControllerMode))
	}
	if m.EnableTracing {
		n += 2
	}
	l = len(m.AccessLogFile)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	if m.DefaultConfig != nil {
		l = m.DefaultConfig.Size()
		n += 1 + l + sovConfig(uint64(l))
	}
	if m.OutboundTrafficPolicy != nil {
		l = m.OutboundTrafficPolicy.Size()
		n += 2 + l + sovConfig(uint64(l))
	}
	if len(m.ConfigSources) > 0 {
		for _, e := range m.ConfigSources {
			l = e.Size()
			n += 2 + l + sovConfig(uint64(l))
		}
	}
	l = len(m.AccessLogFormat)
	if l > 0 {
		n += 2 + l + sovConfig(uint64(l))
	}
	l = len(m.TrustDomain)
	if l > 0 {
		n += 2 + l + sovConfig(uint64(l))
	}
	if m.AccessLogEncoding != 0 {
		n += 2 + sovConfig(uint64(m.AccessLogEncoding))
	}
	if m.TcpKeepalive != nil {
		l = m.TcpKeepalive.Size()
		n += 2 + l + sovConfig(uint64(l))
	}
	if len(m.DefaultServiceExportTo) > 0 {
		for _, s := range m.DefaultServiceExportTo {
			l = len(s)
			n += 2 + l + sovConfig(uint64(l))
		}
	}
	if len(m.DefaultVirtualServiceExportTo) > 0 {
		for _, s := range m.DefaultVirtualServiceExportTo {
			l = len(s)
			n += 2 + l + sovConfig(uint64(l))
		}
	}
	if len(m.DefaultDestinationRuleExportTo) > 0 {
		for _, s := range m.DefaultDestinationRuleExportTo {
			l = len(s)
			n += 2 + l + sovConfig(uint64(l))
		}
	}
	l = len(m.RootNamespace)
	if l > 0 {
		n += 2 + l + sovConfig(uint64(l))
	}
	if m.LocalityLbSetting != nil {
		l = m.LocalityLbSetting.Size()
		n += 2 + l + sovConfig(uint64(l))
	}
	if m.DnsRefreshRate != nil {
		l = m.DnsRefreshRate.Size()
		n += 2 + l + sovConfig(uint64(l))
	}
	if m.EnableEnvoyAccessLogService {
		n += 3
	}
	if m.H2UpgradePolicy != 0 {
		n += 2 + sovConfig(uint64(m.H2UpgradePolicy))
	}
	if m.ProtocolDetectionTimeout != nil {
		l = m.ProtocolDetectionTimeout.Size()
		n += 2 + l + sovConfig(uint64(l))
	}
	if m.EnableAutoMtls != nil {
		l = m.EnableAutoMtls.Size()
		n += 2 + l + sovConfig(uint64(l))
	}
	l = len(m.InboundClusterStatName)
	if l > 0 {
		n += 2 + l + sovConfig(uint64(l))
	}
	l = len(m.OutboundClusterStatName)
	if l > 0 {
		n += 2 + l + sovConfig(uint64(l))
	}
	if len(m.TrustDomainAliases) > 0 {
		for _, s := range m.TrustDomainAliases {
			l = len(s)
			n += 2 + l + sovConfig(uint64(l))
		}
	}
	if len(m.Certificates) > 0 {
		for _, e := range m.Certificates {
			l = e.Size()
			n += 2 + l + sovConfig(uint64(l))
		}
	}
	if m.ThriftConfig != nil {
		l = m.ThriftConfig.Size()
		n += 2 + l + sovConfig(uint64(l))
	}
	if len(m.ServiceSettings) > 0 {
		for _, e := range m.ServiceSettings {
			l = e.Size()
			n += 2 + l + sovConfig(uint64(l))
		}
	}
	if m.EnablePrometheusMerge != nil {
		l = m.EnablePrometheusMerge.Size()
		n += 2 + l + sovConfig(uint64(l))
	}
	l = len(m.IngressSelector)
	if l > 0 {
		n += 2 + l + sovConfig(uint64(l))
	}
	if m.VerifyCertificateAtClient != nil {
		l = m.VerifyCertificateAtClient.Size()
		n += 2 + l + sovConfig(uint64(l))
	}
	if m.Ca != nil {
		l = m.Ca.Size()
		n += 2 + l + sovConfig(uint64(l))
	}
	if m.DisableEnvoyListenerLog {
		n += 3
	}
	if len(m.ExtensionProviders) > 0 {
		for _, e := range m.ExtensionProviders {
			l = e.Size()
			n += 2 + l + sovConfig(uint64(l))
		}
	}
	if len(m.CaCertificates) > 0 {
		for _, e := range m.CaCertificates {
			l = e.Size()
			n += 2 + l + sovConfig(uint64(l))
		}
	}
	if len(m.DiscoverySelectors) > 0 {
		for _, e := range m.DiscoverySelectors {
			l = e.Size()
			n += 2 + l + sovConfig(uint64(l))
		}
	}
	if m.DefaultProviders != nil {
		l = m.DefaultProviders.Size()
		n += 2 + l + sovConfig(uint64(l))
	}
	if m.PathNormalization != nil {
		l = m.PathNormalization.Size()
		n += 2 + l + sovConfig(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MeshConfig_OutboundTrafficPolicy) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Mode != 0 {
		n += 1 + sovConfig(uint64(m.Mode))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MeshConfig_CertificateData) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.CertificateData != nil {
		n += m.CertificateData.Size()
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MeshConfig_CertificateData_Pem) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Pem)
	n += 1 + l + sovConfig(uint64(l))
	return n
}
func (m *MeshConfig_CertificateData_SpiffeBundleUrl) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.SpiffeBundleUrl)
	n += 1 + l + sovConfig(uint64(l))
	return n
}
func (m *MeshConfig_ThriftConfig) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.RateLimitUrl)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	if m.RateLimitTimeout != nil {
		l = m.RateLimitTimeout.Size()
		n += 1 + l + sovConfig(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MeshConfig_ServiceSettings) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Settings != nil {
		l = m.Settings.Size()
		n += 1 + l + sovConfig(uint64(l))
	}
	if len(m.Hosts) > 0 {
		for _, s := range m.Hosts {
			l = len(s)
			n += 1 + l + sovConfig(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MeshConfig_ServiceSettings_Settings) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ClusterLocal {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MeshConfig_CA) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Address)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	if m.TlsSettings != nil {
		l = m.TlsSettings.Size()
		n += 1 + l + sovConfig(uint64(l))
	}
	if m.RequestTimeout != nil {
		l = m.RequestTimeout.Size()
		n += 1 + l + sovConfig(uint64(l))
	}
	if m.IstiodSide {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MeshConfig_ExtensionProvider) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	if m.Provider != nil {
		n += m.Provider.Size()
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MeshConfig_ExtensionProvider_EnvoyExtAuthzHttp) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.EnvoyExtAuthzHttp != nil {
		l = m.EnvoyExtAuthzHttp.Size()
		n += 1 + l + sovConfig(uint64(l))
	}
	return n
}
func (m *MeshConfig_ExtensionProvider_EnvoyExtAuthzGrpc) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.EnvoyExtAuthzGrpc != nil {
		l = m.EnvoyExtAuthzGrpc.Size()
		n += 1 + l + sovConfig(uint64(l))
	}
	return n
}
func (m *MeshConfig_ExtensionProvider_Zipkin) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Zipkin != nil {
		l = m.Zipkin.Size()
		n += 1 + l + sovConfig(uint64(l))
	}
	return n
}
func (m *MeshConfig_ExtensionProvider_Lightstep) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Lightstep != nil {
		l = m.Lightstep.Size()
		n += 1 + l + sovConfig(uint64(l))
	}
	return n
}
func (m *MeshConfig_ExtensionProvider_Datadog) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Datadog != nil {
		l = m.Datadog.Size()
		n += 1 + l + sovConfig(uint64(l))
	}
	return n
}
func (m *MeshConfig_ExtensionProvider_Stackdriver) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Stackdriver != nil {
		l = m.Stackdriver.Size()
		n += 1 + l + sovConfig(uint64(l))
	}
	return n
}
func (m *MeshConfig_ExtensionProvider_Opencensus) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Opencensus != nil {
		l = m.Opencensus.Size()
		n += 1 + l + sovConfig(uint64(l))
	}
	return n
}
func (m *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationRequestBody) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.MaxRequestBytes != 0 {
		n += 1 + sovConfig(uint64(m.MaxRequestBytes))
	}
	if m.AllowPartialMessage {
		n += 2
	}
	if m.PackAsBytes {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationHttpProvider) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Service)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	if m.Port != 0 {
		n += 1 + sovConfig(uint64(m.Port))
	}
	l = len(m.PathPrefix)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	if m.FailOpen {
		n += 2
	}
	l = len(m.StatusOnError)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	if len(m.IncludeHeadersInCheck) > 0 {
		for _, s := range m.IncludeHeadersInCheck {
			l = len(s)
			n += 1 + l + sovConfig(uint64(l))
		}
	}
	if len(m.HeadersToUpstreamOnAllow) > 0 {
		for _, s := range m.HeadersToUpstreamOnAllow {
			l = len(s)
			n += 1 + l + sovConfig(uint64(l))
		}
	}
	if len(m.HeadersToDownstreamOnDeny) > 0 {
		for _, s := range m.HeadersToDownstreamOnDeny {
			l = len(s)
			n += 1 + l + sovConfig(uint64(l))
		}
	}
	if m.Timeout != nil {
		l = m.Timeout.Size()
		n += 1 + l + sovConfig(uint64(l))
	}
	if len(m.IncludeRequestHeadersInCheck) > 0 {
		for _, s := range m.IncludeRequestHeadersInCheck {
			l = len(s)
			n += 1 + l + sovConfig(uint64(l))
		}
	}
	if len(m.IncludeAdditionalHeadersInCheck) > 0 {
		for k, v := range m.IncludeAdditionalHeadersInCheck {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovConfig(uint64(len(k))) + 1 + len(v) + sovConfig(uint64(len(v)))
			n += mapEntrySize + 1 + sovConfig(uint64(mapEntrySize))
		}
	}
	if m.IncludeRequestBodyInCheck != nil {
		l = m.IncludeRequestBodyInCheck.Size()
		n += 1 + l + sovConfig(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationGrpcProvider) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Service)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	if m.Port != 0 {
		n += 1 + sovConfig(uint64(m.Port))
	}
	if m.FailOpen {
		n += 2
	}
	l = len(m.StatusOnError)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	if m.Timeout != nil {
		l = m.Timeout.Size()
		n += 1 + l + sovConfig(uint64(l))
	}
	if m.IncludeRequestBodyInCheck != nil {
		l = m.IncludeRequestBodyInCheck.Size()
		n += 1 + l + sovConfig(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MeshConfig_ExtensionProvider_ZipkinTracingProvider) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Service)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	if m.Port != 0 {
		n += 1 + sovConfig(uint64(m.Port))
	}
	if m.MaxTagLength != 0 {
		n += 1 + sovConfig(uint64(m.MaxTagLength))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MeshConfig_ExtensionProvider_LightstepTracingProvider) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Service)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	if m.Port != 0 {
		n += 1 + sovConfig(uint64(m.Port))
	}
	l = len(m.AccessToken)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	if m.MaxTagLength != 0 {
		n += 1 + sovConfig(uint64(m.MaxTagLength))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MeshConfig_ExtensionProvider_DatadogTracingProvider) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Service)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	if m.Port != 0 {
		n += 1 + sovConfig(uint64(m.Port))
	}
	if m.MaxTagLength != 0 {
		n += 1 + sovConfig(uint64(m.MaxTagLength))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MeshConfig_ExtensionProvider_StackdriverProvider) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Debug {
		n += 2
	}
	if m.MaxNumberOfAttributes != nil {
		l = m.MaxNumberOfAttributes.Size()
		n += 1 + l + sovConfig(uint64(l))
	}
	if m.MaxNumberOfAnnotations != nil {
		l = m.MaxNumberOfAnnotations.Size()
		n += 1 + l + sovConfig(uint64(l))
	}
	if m.MaxNumberOfMessageEvents != nil {
		l = m.MaxNumberOfMessageEvents.Size()
		n += 1 + l + sovConfig(uint64(l))
	}
	if m.MaxTagLength != 0 {
		n += 1 + sovConfig(uint64(m.MaxTagLength))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Service)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	if m.Port != 0 {
		n += 1 + sovConfig(uint64(m.Port))
	}
	if len(m.Context) > 0 {
		l = 0
		for _, e := range m.Context {
			l += sovConfig(uint64(e))
		}
		n += 1 + sovConfig(uint64(l)) + l
	}
	if m.MaxTagLength != 0 {
		n += 1 + sovConfig(uint64(m.MaxTagLength))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MeshConfig_DefaultProviders) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Tracing)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MeshConfig_ProxyPathNormalization) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Normalization != 0 {
		n += 1 + sovConfig(uint64(m.Normalization))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ConfigSource) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Address)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	if m.TlsSettings != nil {
		l = m.TlsSettings.Size()
		n += 1 + l + sovConfig(uint64(l))
	}
	if len(m.SubscribedResources) > 0 {
		l = 0
		for _, e := range m.SubscribedResources {
			l += sovConfig(uint64(e))
		}
		n += 1 + sovConfig(uint64(l)) + l
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Certificate) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.SecretName)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	if len(m.DnsNames) > 0 {
		for _, s := range m.DnsNames {
			l = len(s)
			n += 1 + l + sovConfig(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovConfig(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozConfig(x uint64) (n int) {
	return sovConfig(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *MeshConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MeshConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MeshConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProxyListenPort", wireType)
			}
			m.ProxyListenPort = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ProxyListenPort |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProxyHttpPort", wireType)
			}
			m.ProxyHttpPort = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ProxyHttpPort |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConnectTimeout", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ConnectTimeout == nil {
				m.ConnectTimeout = &types.Duration{}
			}
			if err := m.ConnectTimeout.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IngressClass", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.IngressClass = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IngressService", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.IngressService = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IngressControllerMode", wireType)
			}
			m.IngressControllerMode = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.IngressControllerMode |= MeshConfig_IngressControllerMode(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 12:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field EnableTracing", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.EnableTracing = bool(v != 0)
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AccessLogFile", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AccessLogFile = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DefaultConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DefaultConfig == nil {
				m.DefaultConfig = &ProxyConfig{}
			}
			if err := m.DefaultConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 17:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OutboundTrafficPolicy", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.OutboundTrafficPolicy == nil {
				m.OutboundTrafficPolicy = &MeshConfig_OutboundTrafficPolicy{}
			}
			if err := m.OutboundTrafficPolicy.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 22:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConfigSources", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ConfigSources = append(m.ConfigSources, &ConfigSource{})
			if err := m.ConfigSources[len(m.ConfigSources)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 24:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AccessLogFormat", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AccessLogFormat = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 26:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TrustDomain", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TrustDomain = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 27:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AccessLogEncoding", wireType)
			}
			m.AccessLogEncoding = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.AccessLogEncoding |= MeshConfig_AccessLogEncoding(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 28:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TcpKeepalive", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TcpKeepalive == nil {
				m.TcpKeepalive = &v1alpha3.ConnectionPoolSettings_TCPSettings_TcpKeepalive{}
			}
			if err := m.TcpKeepalive.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 31:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DefaultServiceExportTo", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DefaultServiceExportTo = append(m.DefaultServiceExportTo, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 32:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DefaultVirtualServiceExportTo", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DefaultVirtualServiceExportTo = append(m.DefaultVirtualServiceExportTo, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 33:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DefaultDestinationRuleExportTo", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DefaultDestinationRuleExportTo = append(m.DefaultDestinationRuleExportTo, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 34:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RootNamespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RootNamespace = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 35:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LocalityLbSetting", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LocalityLbSetting == nil {
				m.LocalityLbSetting = &v1alpha3.LocalityLoadBalancerSetting{}
			}
			if err := m.LocalityLbSetting.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 36:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DnsRefreshRate", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DnsRefreshRate == nil {
				m.DnsRefreshRate = &types.Duration{}
			}
			if err := m.DnsRefreshRate.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 40:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field EnableEnvoyAccessLogService", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.EnableEnvoyAccessLogService = bool(v != 0)
		case 41:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field H2UpgradePolicy", wireType)
			}
			m.H2UpgradePolicy = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.H2UpgradePolicy |= MeshConfig_H2UpgradePolicy(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 42:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProtocolDetectionTimeout", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ProtocolDetectionTimeout == nil {
				m.ProtocolDetectionTimeout = &types.Duration{}
			}
			if err := m.ProtocolDetectionTimeout.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 43:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EnableAutoMtls", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.EnableAutoMtls == nil {
				m.EnableAutoMtls = &types.BoolValue{}
			}
			if err := m.EnableAutoMtls.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 44:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field InboundClusterStatName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.InboundClusterStatName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 45:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OutboundClusterStatName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OutboundClusterStatName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 46:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TrustDomainAliases", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TrustDomainAliases = append(m.TrustDomainAliases, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 47:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Certificates", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Certificates = append(m.Certificates, &Certificate{})
			if err := m.Certificates[len(m.Certificates)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 49:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ThriftConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ThriftConfig == nil {
				m.ThriftConfig = &MeshConfig_ThriftConfig{}
			}
			if err := m.ThriftConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 50:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ServiceSettings", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ServiceSettings = append(m.ServiceSettings, &MeshConfig_ServiceSettings{})
			if err := m.ServiceSettings[len(m.ServiceSettings)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 51:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EnablePrometheusMerge", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.EnablePrometheusMerge == nil {
				m.EnablePrometheusMerge = &types.BoolValue{}
			}
			if err := m.EnablePrometheusMerge.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 52:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IngressSelector", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.IngressSelector = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 54:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field VerifyCertificateAtClient", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.VerifyCertificateAtClient == nil {
				m.VerifyCertificateAtClient = &types.BoolValue{}
			}
			if err := m.VerifyCertificateAtClient.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 55:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ca", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Ca == nil {
				m.Ca = &MeshConfig_CA{}
			}
			if err := m.Ca.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 56:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DisableEnvoyListenerLog", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.DisableEnvoyListenerLog = bool(v != 0)
		case 57:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExtensionProviders", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ExtensionProviders = append(m.ExtensionProviders, &MeshConfig_ExtensionProvider{})
			if err := m.ExtensionProviders[len(m.ExtensionProviders)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 58:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CaCertificates", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CaCertificates = append(m.CaCertificates, &MeshConfig_CertificateData{})
			if err := m.CaCertificates[len(m.CaCertificates)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 59:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DiscoverySelectors", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DiscoverySelectors = append(m.DiscoverySelectors, &v1.LabelSelector{})
			if err := m.DiscoverySelectors[len(m.DiscoverySelectors)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 60:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DefaultProviders", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DefaultProviders == nil {
				m.DefaultProviders = &MeshConfig_DefaultProviders{}
			}
			if err := m.DefaultProviders.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 61:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PathNormalization", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.PathNormalization == nil {
				m.PathNormalization = &MeshConfig_ProxyPathNormalization{}
			}
			if err := m.PathNormalization.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipConfig(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MeshConfig_OutboundTrafficPolicy) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: OutboundTrafficPolicy: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: OutboundTrafficPolicy: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Mode", wireType)
			}
			m.Mode = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Mode |= MeshConfig_OutboundTrafficPolicy_Mode(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipConfig(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MeshConfig_CertificateData) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CertificateData: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CertificateData: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Pem", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CertificateData = &MeshConfig_CertificateData_Pem{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SpiffeBundleUrl", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CertificateData = &MeshConfig_CertificateData_SpiffeBundleUrl{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipConfig(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MeshConfig_ThriftConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ThriftConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ThriftConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RateLimitUrl", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RateLimitUrl = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RateLimitTimeout", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RateLimitTimeout == nil {
				m.RateLimitTimeout = &types.Duration{}
			}
			if err := m.RateLimitTimeout.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipConfig(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MeshConfig_ServiceSettings) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ServiceSettings: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ServiceSettings: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Settings", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Settings == nil {
				m.Settings = &MeshConfig_ServiceSettings_Settings{}
			}
			if err := m.Settings.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Hosts", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Hosts = append(m.Hosts, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipConfig(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MeshConfig_ServiceSettings_Settings) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Settings: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Settings: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterLocal", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ClusterLocal = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipConfig(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MeshConfig_CA) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CA: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CA: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Address", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Address = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TlsSettings", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TlsSettings == nil {
				m.TlsSettings = &v1alpha3.ClientTLSSettings{}
			}
			if err := m.TlsSettings.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestTimeout", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RequestTimeout == nil {
				m.RequestTimeout = &types.Duration{}
			}
			if err := m.RequestTimeout.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IstiodSide", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IstiodSide = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipConfig(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MeshConfig_ExtensionProvider) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ExtensionProvider: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ExtensionProvider: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EnvoyExtAuthzHttp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationHttpProvider{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Provider = &MeshConfig_ExtensionProvider_EnvoyExtAuthzHttp{v}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EnvoyExtAuthzGrpc", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationGrpcProvider{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Provider = &MeshConfig_ExtensionProvider_EnvoyExtAuthzGrpc{v}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Zipkin", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &MeshConfig_ExtensionProvider_ZipkinTracingProvider{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Provider = &MeshConfig_ExtensionProvider_Zipkin{v}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Lightstep", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &MeshConfig_ExtensionProvider_LightstepTracingProvider{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Provider = &MeshConfig_ExtensionProvider_Lightstep{v}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Datadog", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &MeshConfig_ExtensionProvider_DatadogTracingProvider{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Provider = &MeshConfig_ExtensionProvider_Datadog{v}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Stackdriver", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &MeshConfig_ExtensionProvider_StackdriverProvider{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Provider = &MeshConfig_ExtensionProvider_Stackdriver{v}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Opencensus", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Provider = &MeshConfig_ExtensionProvider_Opencensus{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipConfig(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationRequestBody) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: EnvoyExternalAuthorizationRequestBody: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: EnvoyExternalAuthorizationRequestBody: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxRequestBytes", wireType)
			}
			m.MaxRequestBytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaxRequestBytes |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AllowPartialMessage", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.AllowPartialMessage = bool(v != 0)
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PackAsBytes", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.PackAsBytes = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipConfig(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationHttpProvider) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: EnvoyExternalAuthorizationHttpProvider: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: EnvoyExternalAuthorizationHttpProvider: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Service", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Service = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Port", wireType)
			}
			m.Port = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Port |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PathPrefix", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PathPrefix = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field FailOpen", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.FailOpen = bool(v != 0)
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StatusOnError", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StatusOnError = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IncludeHeadersInCheck", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.IncludeHeadersInCheck = append(m.IncludeHeadersInCheck, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HeadersToUpstreamOnAllow", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.HeadersToUpstreamOnAllow = append(m.HeadersToUpstreamOnAllow, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HeadersToDownstreamOnDeny", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.HeadersToDownstreamOnDeny = append(m.HeadersToDownstreamOnDeny, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timeout", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Timeout == nil {
				m.Timeout = &types.Duration{}
			}
			if err := m.Timeout.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IncludeRequestHeadersInCheck", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.IncludeRequestHeadersInCheck = append(m.IncludeRequestHeadersInCheck, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IncludeAdditionalHeadersInCheck", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.IncludeAdditionalHeadersInCheck == nil {
				m.IncludeAdditionalHeadersInCheck = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowConfig
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConfig
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthConfig
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthConfig
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConfig
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthConfig
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthConfig
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipConfig(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthConfig
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.IncludeAdditionalHeadersInCheck[mapkey] = mapvalue
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IncludeRequestBodyInCheck", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.IncludeRequestBodyInCheck == nil {
				m.IncludeRequestBodyInCheck = &MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationRequestBody{}
			}
			if err := m.IncludeRequestBodyInCheck.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipConfig(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationGrpcProvider) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: EnvoyExternalAuthorizationGrpcProvider: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: EnvoyExternalAuthorizationGrpcProvider: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Service", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Service = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Port", wireType)
			}
			m.Port = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Port |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field FailOpen", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.FailOpen = bool(v != 0)
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StatusOnError", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StatusOnError = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timeout", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Timeout == nil {
				m.Timeout = &types.Duration{}
			}
			if err := m.Timeout.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IncludeRequestBodyInCheck", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.IncludeRequestBodyInCheck == nil {
				m.IncludeRequestBodyInCheck = &MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationRequestBody{}
			}
			if err := m.IncludeRequestBodyInCheck.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipConfig(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MeshConfig_ExtensionProvider_ZipkinTracingProvider) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ZipkinTracingProvider: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ZipkinTracingProvider: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Service", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Service = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Port", wireType)
			}
			m.Port = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Port |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxTagLength", wireType)
			}
			m.MaxTagLength = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaxTagLength |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipConfig(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MeshConfig_ExtensionProvider_LightstepTracingProvider) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LightstepTracingProvider: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LightstepTracingProvider: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Service", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Service = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Port", wireType)
			}
			m.Port = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Port |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AccessToken", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AccessToken = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxTagLength", wireType)
			}
			m.MaxTagLength = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaxTagLength |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipConfig(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MeshConfig_ExtensionProvider_DatadogTracingProvider) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DatadogTracingProvider: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DatadogTracingProvider: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Service", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Service = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Port", wireType)
			}
			m.Port = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Port |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxTagLength", wireType)
			}
			m.MaxTagLength = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaxTagLength |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipConfig(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MeshConfig_ExtensionProvider_StackdriverProvider) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StackdriverProvider: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StackdriverProvider: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Debug", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Debug = bool(v != 0)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxNumberOfAttributes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MaxNumberOfAttributes == nil {
				m.MaxNumberOfAttributes = &types.Int64Value{}
			}
			if err := m.MaxNumberOfAttributes.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxNumberOfAnnotations", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MaxNumberOfAnnotations == nil {
				m.MaxNumberOfAnnotations = &types.Int64Value{}
			}
			if err := m.MaxNumberOfAnnotations.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxNumberOfMessageEvents", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MaxNumberOfMessageEvents == nil {
				m.MaxNumberOfMessageEvents = &types.Int64Value{}
			}
			if err := m.MaxNumberOfMessageEvents.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxTagLength", wireType)
			}
			m.MaxTagLength = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaxTagLength |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipConfig(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: OpenCensusAgentTracingProvider: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: OpenCensusAgentTracingProvider: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Service", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Service = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Port", wireType)
			}
			m.Port = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Port |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType == 0 {
				var v MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider_TraceContext
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowConfig
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider_TraceContext(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.Context = append(m.Context, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowConfig
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthConfig
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthConfig
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				if elementCount != 0 && len(m.Context) == 0 {
					m.Context = make([]MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider_TraceContext, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider_TraceContext
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConfig
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider_TraceContext(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.Context = append(m.Context, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Context", wireType)
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxTagLength", wireType)
			}
			m.MaxTagLength = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaxTagLength |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipConfig(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MeshConfig_DefaultProviders) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DefaultProviders: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DefaultProviders: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tracing", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Tracing = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipConfig(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MeshConfig_ProxyPathNormalization) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ProxyPathNormalization: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ProxyPathNormalization: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Normalization", wireType)
			}
			m.Normalization = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Normalization |= MeshConfig_ProxyPathNormalization_NormalizationType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipConfig(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ConfigSource) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ConfigSource: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ConfigSource: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Address", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Address = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TlsSettings", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TlsSettings == nil {
				m.TlsSettings = &v1alpha3.ClientTLSSettings{}
			}
			if err := m.TlsSettings.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType == 0 {
				var v Resource
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowConfig
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= Resource(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.SubscribedResources = append(m.SubscribedResources, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowConfig
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthConfig
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthConfig
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				if elementCount != 0 && len(m.SubscribedResources) == 0 {
					m.SubscribedResources = make([]Resource, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v Resource
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConfig
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= Resource(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.SubscribedResources = append(m.SubscribedResources, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field SubscribedResources", wireType)
			}
		default:
			iNdEx = preIndex
			skippy, err := skipConfig(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Certificate) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Certificate: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Certificate: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SecretName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SecretName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DnsNames", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DnsNames = append(m.DnsNames, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipConfig(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipConfig(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthConfig
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupConfig
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthConfig
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthConfig        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowConfig          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupConfig = fmt.Errorf("proto: unexpected end of group")
)
