// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: telemetry/v1alpha1/telemetry.proto

package v1alpha1

import (
	fmt "fmt"
	proto "github.com/gogo/protobuf/proto"
	types "github.com/gogo/protobuf/types"
	io "io"
	v1beta1 "istio.io/api/type/v1beta1"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

// Telemetry defines how the telemetry is generated for workloads within a mesh.
//
// For mesh level configuration, put the resource in root configuration namespace for
// your Istio installation *without* a workload selector.
//
// For any namespace, including the root configuration namespace, it is only valid
// to have a single workload selector-less Telemetry resource.
//
// For resources with a workload selector, it is only valid to have one resource selecting
// any given workload.
//
// Telemetry configuration will use a "shallow merge" semantic for configuration override
// for each telemetry type (Tracing, Metrics, AccessLogging). For example, Tracing configuration
// will support overrides of the fields `providers`, `random_sampling_percentage`, `disable_span_reporting`,
// and `custom_tags` at each level in the configuration hierarchy, with missing values filled in
// from parent resources. However, when specified, fields like `custom_tags` will
// fully replace any values provided by parent configuration.
//
// The hierarchy of Telemetry configuration is as follows:
// 1. Workload-specific configuration
// 1. Namespace-specific configuration
// 1. Root namespace configuration
//
// WARNING: Support for Telemetry policies is under active development and is *not*
// stable or supported by Istio at this time.
//
// Examples:
//
// Policy to enable random sampling for 10% of traffic:
// ```yaml
// apiVersion: telemetry.istio.io/v1alpha1
// kind: Telemetry
// metadata:
//   name: mesh-default
//   namespace: istio-system
// spec:
//   tracing:
//   - randomSamplingPercentage: 10.00
// ```
//
// Policy to disable trace reporting for the "foo" workload (note: tracing
// context will still be propagated):
// ```yaml
// apiVersion: telemetry.istio.io/v1alpha1
// kind: Telemetry
// metadata:
//   name: foo-tracing
//   namespace: bar
// spec:
//   selector:
//     labels:
//       service.istio.io/canonical-name: foo
//   tracing:
//   - disableSpanReporting: true
// ```
//
// Policy to select the alternate zipkin provider for trace reporting:
// ```yaml
// apiVersion: telemetry.istio.io/v1alpha1
// kind: Telemetry
// metadata:
//   name: foo-tracing-alternate
//   namespace: baz
// spec:
//   selector:
//     labels:
//       service.istio.io/canonical-name: foo
//   tracing:
//   - providers:
//     - name: "zipkin-alternate"
//     randomSamplingPercentage: 10.00
// ```
//
// Policy to add a custom tag from a literal value:
// ```yaml
// apiVersion: telemetry.istio.io/v1alpha1
// kind: Telemetry
// metadata:
//   name: mesh-default
//   namespace: istio-system
// spec:
//   tracing:
//   - randomSamplingPercentage: 10.00
//     customTags:
//       my_new_foo_tag:
//         literal:
//           value: "foo"
// ```
//
// <!-- crd generation tags
// +cue-gen:Telemetry:groupName:telemetry.istio.io
// +cue-gen:Telemetry:version:v1alpha1
// +cue-gen:Telemetry:storageVersion
// +cue-gen:Telemetry:annotations:helm.sh/resource-policy=keep
// +cue-gen:Telemetry:labels:app=istio-pilot,chart=istio,istio=telemetry,heritage=Tiller,release=istio
// +cue-gen:Telemetry:subresource:status
// +cue-gen:Telemetry:scope:Namespaced
// +cue-gen:Telemetry:resource:categories=istio-io,telemetry-istio-io,shortNames=telemetry,plural=telemetries
// +cue-gen:Telemetry:preserveUnknownFields:false
// +cue-gen:Telemetry:printerColumn:name=Age,type=date,JSONPath=.metadata.creationTimestamp,description="CreationTimestamp is a timestamp
// representing the server time when this object was created. It is not guaranteed to be set in happens-before order across separate operations.
// Clients may not set this value. It is represented in RFC3339 form and is in UTC.
// Populated by the system. Read-only. Null for lists. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata"
// -->
//
// <!-- go code generation tags
// +kubetype-gen
// +kubetype-gen:groupVersion=telemetry.istio.io/v1alpha1
// +genclient
// +k8s:deepcopy-gen=true
// -->
type Telemetry struct {
	// Optional. The selector decides where to apply the Telemetry policy.
	// If not set, the Telemetry policy will be applied to all workloads in the
	// same namespace as the Telemetry policy.
	Selector *v1beta1.WorkloadSelector `protobuf:"bytes,1,opt,name=selector,proto3" json:"selector,omitempty"`
	// Optional. Tracing configures the tracing behavior for all
	// selected workloads.
	Tracing              []*Tracing `protobuf:"bytes,2,rep,name=tracing,proto3" json:"tracing,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *Telemetry) Reset()         { *m = Telemetry{} }
func (m *Telemetry) String() string { return proto.CompactTextString(m) }
func (*Telemetry) ProtoMessage()    {}
func (*Telemetry) Descriptor() ([]byte, []int) {
	return fileDescriptor_991c84745e2b7651, []int{0}
}
func (m *Telemetry) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Telemetry) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Telemetry.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Telemetry) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Telemetry.Merge(m, src)
}
func (m *Telemetry) XXX_Size() int {
	return m.Size()
}
func (m *Telemetry) XXX_DiscardUnknown() {
	xxx_messageInfo_Telemetry.DiscardUnknown(m)
}

var xxx_messageInfo_Telemetry proto.InternalMessageInfo

func (m *Telemetry) GetSelector() *v1beta1.WorkloadSelector {
	if m != nil {
		return m.Selector
	}
	return nil
}

func (m *Telemetry) GetTracing() []*Tracing {
	if m != nil {
		return m.Tracing
	}
	return nil
}

// Tracing configures tracing behavior for workloads within a mesh.
// It can be used to enable/disable tracing, as well as to set sampling
// rates and custom tag extraction.
type Tracing struct {
	// Optional. Name of provider(s) to use for span reporting. If a provider is
	// not specified, the [default tracing provider][istio.mesh.v1alpha1.MeshConfig.default_tracing_provider]
	// will be used.
	// NOTE: At the moment, only a single provider can be specified in a given
	// Tracing rule.
	Providers []*ProviderRef `protobuf:"bytes,2,rep,name=providers,proto3" json:"providers,omitempty"`
	// Controls the rate at which traffic will be selected for tracing if no
	// prior sampling decision has been made. If a prior sampling decision has been
	// made, that decision will be respected. However, if no sampling decision
	// has been made (example: no `x-b3-sampled` tracing header was present in the
	// requests), the traffic will be selected for telemetry generation at the
	// percentage specified.
	//
	// Defaults to 0%. Valid values [0.00-100.00]. Can be specified in 0.01%
	// increments.
	RandomSamplingPercentage *types.DoubleValue `protobuf:"bytes,3,opt,name=random_sampling_percentage,json=randomSamplingPercentage,proto3" json:"random_sampling_percentage,omitempty"`
	// Controls span reporting. If set to true, no spans will be reported for
	// impacted workloads. This does NOT impact context propagation or trace
	// sampling behavior.
	DisableSpanReporting *types.BoolValue `protobuf:"bytes,4,opt,name=disable_span_reporting,json=disableSpanReporting,proto3" json:"disable_span_reporting,omitempty"`
	// Optional. Configures additional custom tags to the generated trace spans.
	CustomTags           map[string]*Tracing_CustomTag `protobuf:"bytes,5,rep,name=custom_tags,json=customTags,proto3" json:"custom_tags,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}                      `json:"-"`
	XXX_unrecognized     []byte                        `json:"-"`
	XXX_sizecache        int32                         `json:"-"`
}

func (m *Tracing) Reset()         { *m = Tracing{} }
func (m *Tracing) String() string { return proto.CompactTextString(m) }
func (*Tracing) ProtoMessage()    {}
func (*Tracing) Descriptor() ([]byte, []int) {
	return fileDescriptor_991c84745e2b7651, []int{1}
}
func (m *Tracing) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Tracing) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Tracing.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Tracing) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Tracing.Merge(m, src)
}
func (m *Tracing) XXX_Size() int {
	return m.Size()
}
func (m *Tracing) XXX_DiscardUnknown() {
	xxx_messageInfo_Tracing.DiscardUnknown(m)
}

var xxx_messageInfo_Tracing proto.InternalMessageInfo

func (m *Tracing) GetProviders() []*ProviderRef {
	if m != nil {
		return m.Providers
	}
	return nil
}

func (m *Tracing) GetRandomSamplingPercentage() *types.DoubleValue {
	if m != nil {
		return m.RandomSamplingPercentage
	}
	return nil
}

func (m *Tracing) GetDisableSpanReporting() *types.BoolValue {
	if m != nil {
		return m.DisableSpanReporting
	}
	return nil
}

func (m *Tracing) GetCustomTags() map[string]*Tracing_CustomTag {
	if m != nil {
		return m.CustomTags
	}
	return nil
}

// CustomTag defines a tag to be added to a trace span that is based on
// an operator-supplied value. This value can either be a hard-coded value,
// a value taken from an environment variable known to the sidecar proxy, or
// from a request header.
type Tracing_CustomTag struct {
	// Types that are valid to be assigned to Type:
	//	*Tracing_CustomTag_Literal
	//	*Tracing_CustomTag_Environment
	//	*Tracing_CustomTag_Header
	Type                 isTracing_CustomTag_Type `protobuf_oneof:"type"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *Tracing_CustomTag) Reset()         { *m = Tracing_CustomTag{} }
func (m *Tracing_CustomTag) String() string { return proto.CompactTextString(m) }
func (*Tracing_CustomTag) ProtoMessage()    {}
func (*Tracing_CustomTag) Descriptor() ([]byte, []int) {
	return fileDescriptor_991c84745e2b7651, []int{1, 0}
}
func (m *Tracing_CustomTag) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Tracing_CustomTag) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Tracing_CustomTag.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Tracing_CustomTag) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Tracing_CustomTag.Merge(m, src)
}
func (m *Tracing_CustomTag) XXX_Size() int {
	return m.Size()
}
func (m *Tracing_CustomTag) XXX_DiscardUnknown() {
	xxx_messageInfo_Tracing_CustomTag.DiscardUnknown(m)
}

var xxx_messageInfo_Tracing_CustomTag proto.InternalMessageInfo

type isTracing_CustomTag_Type interface {
	isTracing_CustomTag_Type()
	MarshalTo([]byte) (int, error)
	Size() int
}

type Tracing_CustomTag_Literal struct {
	Literal *Tracing_Literal `protobuf:"bytes,1,opt,name=literal,proto3,oneof" json:"literal,omitempty"`
}
type Tracing_CustomTag_Environment struct {
	Environment *Tracing_Environment `protobuf:"bytes,2,opt,name=environment,proto3,oneof" json:"environment,omitempty"`
}
type Tracing_CustomTag_Header struct {
	Header *Tracing_RequestHeader `protobuf:"bytes,3,opt,name=header,proto3,oneof" json:"header,omitempty"`
}

func (*Tracing_CustomTag_Literal) isTracing_CustomTag_Type()     {}
func (*Tracing_CustomTag_Environment) isTracing_CustomTag_Type() {}
func (*Tracing_CustomTag_Header) isTracing_CustomTag_Type()      {}

func (m *Tracing_CustomTag) GetType() isTracing_CustomTag_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (m *Tracing_CustomTag) GetLiteral() *Tracing_Literal {
	if x, ok := m.GetType().(*Tracing_CustomTag_Literal); ok {
		return x.Literal
	}
	return nil
}

func (m *Tracing_CustomTag) GetEnvironment() *Tracing_Environment {
	if x, ok := m.GetType().(*Tracing_CustomTag_Environment); ok {
		return x.Environment
	}
	return nil
}

func (m *Tracing_CustomTag) GetHeader() *Tracing_RequestHeader {
	if x, ok := m.GetType().(*Tracing_CustomTag_Header); ok {
		return x.Header
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Tracing_CustomTag) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Tracing_CustomTag_Literal)(nil),
		(*Tracing_CustomTag_Environment)(nil),
		(*Tracing_CustomTag_Header)(nil),
	}
}

type Tracing_Literal struct {
	// The tag value to use.
	Value                string   `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Tracing_Literal) Reset()         { *m = Tracing_Literal{} }
func (m *Tracing_Literal) String() string { return proto.CompactTextString(m) }
func (*Tracing_Literal) ProtoMessage()    {}
func (*Tracing_Literal) Descriptor() ([]byte, []int) {
	return fileDescriptor_991c84745e2b7651, []int{1, 1}
}
func (m *Tracing_Literal) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Tracing_Literal) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Tracing_Literal.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Tracing_Literal) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Tracing_Literal.Merge(m, src)
}
func (m *Tracing_Literal) XXX_Size() int {
	return m.Size()
}
func (m *Tracing_Literal) XXX_DiscardUnknown() {
	xxx_messageInfo_Tracing_Literal.DiscardUnknown(m)
}

var xxx_messageInfo_Tracing_Literal proto.InternalMessageInfo

func (m *Tracing_Literal) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

type Tracing_Environment struct {
	// Name of the environment variable from which to extract the tag value.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. If the environment variable is not found, this value will be
	// used instead.
	DefaultValue         string   `protobuf:"bytes,2,opt,name=default_value,json=defaultValue,proto3" json:"default_value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Tracing_Environment) Reset()         { *m = Tracing_Environment{} }
func (m *Tracing_Environment) String() string { return proto.CompactTextString(m) }
func (*Tracing_Environment) ProtoMessage()    {}
func (*Tracing_Environment) Descriptor() ([]byte, []int) {
	return fileDescriptor_991c84745e2b7651, []int{1, 2}
}
func (m *Tracing_Environment) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Tracing_Environment) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Tracing_Environment.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Tracing_Environment) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Tracing_Environment.Merge(m, src)
}
func (m *Tracing_Environment) XXX_Size() int {
	return m.Size()
}
func (m *Tracing_Environment) XXX_DiscardUnknown() {
	xxx_messageInfo_Tracing_Environment.DiscardUnknown(m)
}

var xxx_messageInfo_Tracing_Environment proto.InternalMessageInfo

func (m *Tracing_Environment) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Tracing_Environment) GetDefaultValue() string {
	if m != nil {
		return m.DefaultValue
	}
	return ""
}

type Tracing_RequestHeader struct {
	// Name of the header from which to extract the tag value.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. If the header is not found, this value will be
	// used instead.
	DefaultValue         string   `protobuf:"bytes,2,opt,name=default_value,json=defaultValue,proto3" json:"default_value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Tracing_RequestHeader) Reset()         { *m = Tracing_RequestHeader{} }
func (m *Tracing_RequestHeader) String() string { return proto.CompactTextString(m) }
func (*Tracing_RequestHeader) ProtoMessage()    {}
func (*Tracing_RequestHeader) Descriptor() ([]byte, []int) {
	return fileDescriptor_991c84745e2b7651, []int{1, 3}
}
func (m *Tracing_RequestHeader) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Tracing_RequestHeader) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Tracing_RequestHeader.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Tracing_RequestHeader) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Tracing_RequestHeader.Merge(m, src)
}
func (m *Tracing_RequestHeader) XXX_Size() int {
	return m.Size()
}
func (m *Tracing_RequestHeader) XXX_DiscardUnknown() {
	xxx_messageInfo_Tracing_RequestHeader.DiscardUnknown(m)
}

var xxx_messageInfo_Tracing_RequestHeader proto.InternalMessageInfo

func (m *Tracing_RequestHeader) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Tracing_RequestHeader) GetDefaultValue() string {
	if m != nil {
		return m.DefaultValue
	}
	return ""
}

// Used to bind Telemetry configuration to specific providers for
// targeted customization.
type ProviderRef struct {
	// Required. Name of Telemetry provider in MeshConfig.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ProviderRef) Reset()         { *m = ProviderRef{} }
func (m *ProviderRef) String() string { return proto.CompactTextString(m) }
func (*ProviderRef) ProtoMessage()    {}
func (*ProviderRef) Descriptor() ([]byte, []int) {
	return fileDescriptor_991c84745e2b7651, []int{2}
}
func (m *ProviderRef) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ProviderRef) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ProviderRef.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ProviderRef) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProviderRef.Merge(m, src)
}
func (m *ProviderRef) XXX_Size() int {
	return m.Size()
}
func (m *ProviderRef) XXX_DiscardUnknown() {
	xxx_messageInfo_ProviderRef.DiscardUnknown(m)
}

var xxx_messageInfo_ProviderRef proto.InternalMessageInfo

func (m *ProviderRef) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func init() {
	proto.RegisterType((*Telemetry)(nil), "istio.telemetry.v1alpha1.Telemetry")
	proto.RegisterType((*Tracing)(nil), "istio.telemetry.v1alpha1.Tracing")
	proto.RegisterMapType((map[string]*Tracing_CustomTag)(nil), "istio.telemetry.v1alpha1.Tracing.CustomTagsEntry")
	proto.RegisterType((*Tracing_CustomTag)(nil), "istio.telemetry.v1alpha1.Tracing.CustomTag")
	proto.RegisterType((*Tracing_Literal)(nil), "istio.telemetry.v1alpha1.Tracing.Literal")
	proto.RegisterType((*Tracing_Environment)(nil), "istio.telemetry.v1alpha1.Tracing.Environment")
	proto.RegisterType((*Tracing_RequestHeader)(nil), "istio.telemetry.v1alpha1.Tracing.RequestHeader")
	proto.RegisterType((*ProviderRef)(nil), "istio.telemetry.v1alpha1.ProviderRef")
}

func init() {
	proto.RegisterFile("telemetry/v1alpha1/telemetry.proto", fileDescriptor_991c84745e2b7651)
}

var fileDescriptor_991c84745e2b7651 = []byte{
	// 570 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x94, 0x41, 0x6f, 0xd3, 0x30,
	0x14, 0x80, 0x97, 0x6e, 0x6b, 0xe9, 0x0b, 0x13, 0xc8, 0x9a, 0x50, 0x14, 0x50, 0xb7, 0x15, 0x90,
	0x86, 0xd0, 0x12, 0x75, 0x5c, 0x10, 0x5c, 0x60, 0x63, 0xa8, 0x48, 0x1c, 0x86, 0x37, 0x81, 0xb4,
	0x4b, 0xe4, 0x36, 0x6f, 0x59, 0x98, 0x13, 0x1b, 0xc7, 0x29, 0xea, 0x5f, 0xe0, 0x97, 0x71, 0xe4,
	0x27, 0xa0, 0x1e, 0xf9, 0x05, 0x1c, 0x51, 0x1d, 0xa7, 0x2d, 0x8c, 0xa9, 0x82, 0x5b, 0xfc, 0xfc,
	0xbe, 0xcf, 0xef, 0x3d, 0xbb, 0x85, 0xae, 0x46, 0x8e, 0x19, 0x6a, 0x35, 0x0e, 0x47, 0x3d, 0xc6,
	0xe5, 0x05, 0xeb, 0x85, 0xb3, 0x50, 0x20, 0x95, 0xd0, 0x82, 0x78, 0x69, 0xa1, 0x53, 0x11, 0xcc,
	0xc3, 0x75, 0xa6, 0x7f, 0x57, 0x8f, 0x25, 0x86, 0xa3, 0xde, 0x00, 0x35, 0xeb, 0x85, 0x05, 0x72,
	0x1c, 0x6a, 0xa1, 0x2a, 0xcc, 0xef, 0x24, 0x42, 0x24, 0x1c, 0x43, 0xb3, 0x1a, 0x94, 0xe7, 0xe1,
	0x67, 0xc5, 0xa4, 0x44, 0x55, 0x54, 0xfb, 0xdd, 0x2f, 0x0e, 0xb4, 0x4f, 0x6b, 0x27, 0x79, 0x01,
	0x37, 0x6a, 0xde, 0x73, 0xb6, 0x9d, 0x5d, 0x77, 0xff, 0x41, 0x60, 0xcf, 0x1d, 0x4b, 0x0c, 0xec,
	0x19, 0xc1, 0x07, 0xa1, 0x2e, 0xb9, 0x60, 0xf1, 0x89, 0xcd, 0xa5, 0x33, 0x8a, 0x3c, 0x87, 0x96,
	0x56, 0x6c, 0x98, 0xe6, 0x89, 0xd7, 0xd8, 0x5e, 0xdd, 0x75, 0xf7, 0x77, 0x82, 0xeb, 0x0a, 0x0f,
	0x4e, 0xab, 0x44, 0x5a, 0x13, 0xdd, 0x1f, 0x4d, 0x68, 0xd9, 0x20, 0x39, 0x84, 0xb6, 0x54, 0x62,
	0x94, 0xc6, 0xa8, 0x0a, 0xab, 0x7a, 0x78, 0xbd, 0xea, 0xd8, 0xa6, 0x52, 0x3c, 0xa7, 0x73, 0x8e,
	0x9c, 0x81, 0xaf, 0x58, 0x1e, 0x8b, 0x2c, 0x2a, 0x58, 0x26, 0x79, 0x9a, 0x27, 0x91, 0x44, 0x35,
	0xc4, 0x5c, 0xb3, 0x04, 0xbd, 0x55, 0xd3, 0xe1, 0xbd, 0xa0, 0x1a, 0x51, 0x50, 0x8f, 0x28, 0x78,
	0x25, 0xca, 0x01, 0xc7, 0xf7, 0x8c, 0x97, 0x48, 0xbd, 0x8a, 0x3f, 0xb1, 0xf8, 0xf1, 0x8c, 0x26,
	0xc7, 0x70, 0x27, 0x4e, 0x0b, 0x36, 0xe0, 0x18, 0x15, 0x92, 0xe5, 0x91, 0x42, 0x29, 0x94, 0x9e,
	0x36, 0xbe, 0x66, 0xbc, 0xfe, 0x15, 0xef, 0x81, 0x10, 0xbc, 0xb2, 0x6e, 0x5a, 0xf2, 0x44, 0xb2,
	0x9c, 0xd6, 0x1c, 0xa1, 0xe0, 0x0e, 0xcb, 0x42, 0x8b, 0x2c, 0xd2, 0x2c, 0x29, 0xbc, 0x75, 0xd3,
	0x74, 0x6f, 0xe9, 0xfc, 0x82, 0x43, 0x03, 0x9d, 0xb2, 0xa4, 0x38, 0xca, 0xb5, 0x1a, 0x53, 0x18,
	0xce, 0x02, 0xfe, 0x4f, 0x07, 0xda, 0xb3, 0x7d, 0x72, 0x04, 0x2d, 0x9e, 0x6a, 0x54, 0x8c, 0xdb,
	0xeb, 0x7d, 0xb4, 0xdc, 0xfe, 0xb6, 0x02, 0xfa, 0x2b, 0xb4, 0x66, 0xc9, 0x3b, 0x70, 0x31, 0x1f,
	0xa5, 0x4a, 0xe4, 0x19, 0xe6, 0xda, 0x6b, 0x18, 0xd5, 0xde, 0x72, 0xd5, 0xd1, 0x1c, 0xea, 0xaf,
	0xd0, 0x45, 0x07, 0x79, 0x03, 0xcd, 0x0b, 0x64, 0x31, 0x2a, 0x7b, 0x2b, 0xe1, 0x72, 0x1b, 0xc5,
	0x4f, 0x25, 0x16, 0xba, 0x6f, 0xb0, 0xfe, 0x0a, 0xb5, 0x82, 0x83, 0x26, 0xac, 0x4d, 0x5f, 0xab,
	0xbf, 0x05, 0x2d, 0x5b, 0x3b, 0xd9, 0x84, 0xf5, 0xd1, 0x74, 0xf0, 0xa6, 0xeb, 0x36, 0xad, 0x16,
	0xfe, 0x6b, 0x70, 0x17, 0x2a, 0x22, 0x04, 0xd6, 0x72, 0x96, 0xd5, 0x39, 0xe6, 0x9b, 0xdc, 0x87,
	0x8d, 0x18, 0xcf, 0x59, 0xc9, 0x75, 0x54, 0x09, 0x1a, 0x66, 0xf3, 0xa6, 0x0d, 0x9a, 0xdb, 0xf4,
	0xfb, 0xb0, 0xf1, 0x5b, 0x2d, 0xff, 0x6f, 0xfa, 0x08, 0xb7, 0xfe, 0xb8, 0x4c, 0x72, 0x1b, 0x56,
	0x2f, 0x71, 0x6c, 0x55, 0xd3, 0x4f, 0xf2, 0xb2, 0x6e, 0xa6, 0x9a, 0xfb, 0xe3, 0x7f, 0x78, 0x20,
	0xb6, 0xf3, 0x67, 0x8d, 0xa7, 0x4e, 0x77, 0x07, 0xdc, 0x85, 0x5f, 0xcd, 0xdf, 0x6a, 0x3e, 0xd8,
	0xfb, 0x3a, 0xe9, 0x38, 0xdf, 0x26, 0x1d, 0xe7, 0xfb, 0xa4, 0xe3, 0x9c, 0x6d, 0x55, 0xe7, 0xa4,
	0x22, 0x64, 0x32, 0x0d, 0xaf, 0xfe, 0x65, 0x0d, 0x9a, 0xe6, 0xa5, 0x3f, 0xf9, 0x15, 0x00, 0x00,
	0xff, 0xff, 0x80, 0x58, 0xd4, 0xa9, 0xcf, 0x04, 0x00, 0x00,
}

func (m *Telemetry) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Telemetry) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Telemetry) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Tracing) > 0 {
		for iNdEx := len(m.Tracing) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Tracing[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintTelemetry(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.Selector != nil {
		{
			size, err := m.Selector.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintTelemetry(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Tracing) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Tracing) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Tracing) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.CustomTags) > 0 {
		for k := range m.CustomTags {
			v := m.CustomTags[k]
			baseI := i
			if v != nil {
				{
					size, err := v.MarshalToSizedBuffer(dAtA[:i])
					if err != nil {
						return 0, err
					}
					i -= size
					i = encodeVarintTelemetry(dAtA, i, uint64(size))
				}
				i--
				dAtA[i] = 0x12
			}
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintTelemetry(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintTelemetry(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x2a
		}
	}
	if m.DisableSpanReporting != nil {
		{
			size, err := m.DisableSpanReporting.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintTelemetry(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if m.RandomSamplingPercentage != nil {
		{
			size, err := m.RandomSamplingPercentage.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintTelemetry(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Providers) > 0 {
		for iNdEx := len(m.Providers) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Providers[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintTelemetry(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	return len(dAtA) - i, nil
}

func (m *Tracing_CustomTag) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Tracing_CustomTag) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Tracing_CustomTag) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Type != nil {
		{
			size := m.Type.Size()
			i -= size
			if _, err := m.Type.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	return len(dAtA) - i, nil
}

func (m *Tracing_CustomTag_Literal) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Tracing_CustomTag_Literal) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Literal != nil {
		{
			size, err := m.Literal.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintTelemetry(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}
func (m *Tracing_CustomTag_Environment) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Tracing_CustomTag_Environment) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Environment != nil {
		{
			size, err := m.Environment.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintTelemetry(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	return len(dAtA) - i, nil
}
func (m *Tracing_CustomTag_Header) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Tracing_CustomTag_Header) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Header != nil {
		{
			size, err := m.Header.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintTelemetry(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	return len(dAtA) - i, nil
}
func (m *Tracing_Literal) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Tracing_Literal) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Tracing_Literal) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Value) > 0 {
		i -= len(m.Value)
		copy(dAtA[i:], m.Value)
		i = encodeVarintTelemetry(dAtA, i, uint64(len(m.Value)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Tracing_Environment) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Tracing_Environment) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Tracing_Environment) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.DefaultValue) > 0 {
		i -= len(m.DefaultValue)
		copy(dAtA[i:], m.DefaultValue)
		i = encodeVarintTelemetry(dAtA, i, uint64(len(m.DefaultValue)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintTelemetry(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Tracing_RequestHeader) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Tracing_RequestHeader) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Tracing_RequestHeader) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.DefaultValue) > 0 {
		i -= len(m.DefaultValue)
		copy(dAtA[i:], m.DefaultValue)
		i = encodeVarintTelemetry(dAtA, i, uint64(len(m.DefaultValue)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintTelemetry(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ProviderRef) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ProviderRef) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ProviderRef) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintTelemetry(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintTelemetry(dAtA []byte, offset int, v uint64) int {
	offset -= sovTelemetry(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *Telemetry) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Selector != nil {
		l = m.Selector.Size()
		n += 1 + l + sovTelemetry(uint64(l))
	}
	if len(m.Tracing) > 0 {
		for _, e := range m.Tracing {
			l = e.Size()
			n += 1 + l + sovTelemetry(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Tracing) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Providers) > 0 {
		for _, e := range m.Providers {
			l = e.Size()
			n += 1 + l + sovTelemetry(uint64(l))
		}
	}
	if m.RandomSamplingPercentage != nil {
		l = m.RandomSamplingPercentage.Size()
		n += 1 + l + sovTelemetry(uint64(l))
	}
	if m.DisableSpanReporting != nil {
		l = m.DisableSpanReporting.Size()
		n += 1 + l + sovTelemetry(uint64(l))
	}
	if len(m.CustomTags) > 0 {
		for k, v := range m.CustomTags {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovTelemetry(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovTelemetry(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovTelemetry(uint64(mapEntrySize))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Tracing_CustomTag) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Type != nil {
		n += m.Type.Size()
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Tracing_CustomTag_Literal) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Literal != nil {
		l = m.Literal.Size()
		n += 1 + l + sovTelemetry(uint64(l))
	}
	return n
}
func (m *Tracing_CustomTag_Environment) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Environment != nil {
		l = m.Environment.Size()
		n += 1 + l + sovTelemetry(uint64(l))
	}
	return n
}
func (m *Tracing_CustomTag_Header) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Header != nil {
		l = m.Header.Size()
		n += 1 + l + sovTelemetry(uint64(l))
	}
	return n
}
func (m *Tracing_Literal) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Value)
	if l > 0 {
		n += 1 + l + sovTelemetry(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Tracing_Environment) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovTelemetry(uint64(l))
	}
	l = len(m.DefaultValue)
	if l > 0 {
		n += 1 + l + sovTelemetry(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Tracing_RequestHeader) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovTelemetry(uint64(l))
	}
	l = len(m.DefaultValue)
	if l > 0 {
		n += 1 + l + sovTelemetry(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ProviderRef) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovTelemetry(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovTelemetry(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozTelemetry(x uint64) (n int) {
	return sovTelemetry(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *Telemetry) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTelemetry
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Telemetry: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Telemetry: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Selector", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTelemetry
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTelemetry
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTelemetry
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Selector == nil {
				m.Selector = &v1beta1.WorkloadSelector{}
			}
			if err := m.Selector.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tracing", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTelemetry
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTelemetry
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTelemetry
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Tracing = append(m.Tracing, &Tracing{})
			if err := m.Tracing[len(m.Tracing)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTelemetry(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthTelemetry
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Tracing) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTelemetry
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Tracing: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Tracing: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Providers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTelemetry
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTelemetry
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTelemetry
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Providers = append(m.Providers, &ProviderRef{})
			if err := m.Providers[len(m.Providers)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RandomSamplingPercentage", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTelemetry
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTelemetry
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTelemetry
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RandomSamplingPercentage == nil {
				m.RandomSamplingPercentage = &types.DoubleValue{}
			}
			if err := m.RandomSamplingPercentage.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DisableSpanReporting", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTelemetry
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTelemetry
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTelemetry
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DisableSpanReporting == nil {
				m.DisableSpanReporting = &types.BoolValue{}
			}
			if err := m.DisableSpanReporting.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CustomTags", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTelemetry
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTelemetry
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTelemetry
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CustomTags == nil {
				m.CustomTags = make(map[string]*Tracing_CustomTag)
			}
			var mapkey string
			var mapvalue *Tracing_CustomTag
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowTelemetry
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowTelemetry
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthTelemetry
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthTelemetry
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowTelemetry
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthTelemetry
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthTelemetry
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &Tracing_CustomTag{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipTelemetry(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthTelemetry
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.CustomTags[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTelemetry(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthTelemetry
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Tracing_CustomTag) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTelemetry
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CustomTag: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CustomTag: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Literal", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTelemetry
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTelemetry
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTelemetry
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Tracing_Literal{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Type = &Tracing_CustomTag_Literal{v}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Environment", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTelemetry
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTelemetry
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTelemetry
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Tracing_Environment{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Type = &Tracing_CustomTag_Environment{v}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Header", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTelemetry
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTelemetry
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTelemetry
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Tracing_RequestHeader{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Type = &Tracing_CustomTag_Header{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTelemetry(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthTelemetry
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Tracing_Literal) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTelemetry
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Literal: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Literal: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTelemetry
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTelemetry
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTelemetry
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTelemetry(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthTelemetry
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Tracing_Environment) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTelemetry
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Environment: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Environment: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTelemetry
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTelemetry
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTelemetry
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DefaultValue", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTelemetry
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTelemetry
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTelemetry
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DefaultValue = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTelemetry(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthTelemetry
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Tracing_RequestHeader) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTelemetry
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RequestHeader: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RequestHeader: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTelemetry
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTelemetry
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTelemetry
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DefaultValue", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTelemetry
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTelemetry
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTelemetry
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DefaultValue = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTelemetry(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthTelemetry
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ProviderRef) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTelemetry
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ProviderRef: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ProviderRef: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTelemetry
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTelemetry
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTelemetry
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTelemetry(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthTelemetry
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipTelemetry(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowTelemetry
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowTelemetry
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowTelemetry
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthTelemetry
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupTelemetry
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthTelemetry
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthTelemetry        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowTelemetry          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupTelemetry = fmt.Errorf("proto: unexpected end of group")
)
