/*
Copyright 2019 The Knative Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
	v1alpha1 "knative.dev/eventing/pkg/apis/sources/v1alpha1"
)

// FakeCronJobSources implements CronJobSourceInterface
type FakeCronJobSources struct {
	Fake *FakeSourcesV1alpha1
	ns   string
}

var cronjobsourcesResource = schema.GroupVersionResource{Group: "sources.eventing.knative.dev", Version: "v1alpha1", Resource: "cronjobsources"}

var cronjobsourcesKind = schema.GroupVersionKind{Group: "sources.eventing.knative.dev", Version: "v1alpha1", Kind: "CronJobSource"}

// Get takes name of the cronJobSource, and returns the corresponding cronJobSource object, and an error if there is any.
func (c *FakeCronJobSources) Get(name string, options v1.GetOptions) (result *v1alpha1.CronJobSource, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(cronjobsourcesResource, c.ns, name), &v1alpha1.CronJobSource{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.CronJobSource), err
}

// List takes label and field selectors, and returns the list of CronJobSources that match those selectors.
func (c *FakeCronJobSources) List(opts v1.ListOptions) (result *v1alpha1.CronJobSourceList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(cronjobsourcesResource, cronjobsourcesKind, c.ns, opts), &v1alpha1.CronJobSourceList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1alpha1.CronJobSourceList{ListMeta: obj.(*v1alpha1.CronJobSourceList).ListMeta}
	for _, item := range obj.(*v1alpha1.CronJobSourceList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested cronJobSources.
func (c *FakeCronJobSources) Watch(opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(cronjobsourcesResource, c.ns, opts))

}

// Create takes the representation of a cronJobSource and creates it.  Returns the server's representation of the cronJobSource, and an error, if there is any.
func (c *FakeCronJobSources) Create(cronJobSource *v1alpha1.CronJobSource) (result *v1alpha1.CronJobSource, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(cronjobsourcesResource, c.ns, cronJobSource), &v1alpha1.CronJobSource{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.CronJobSource), err
}

// Update takes the representation of a cronJobSource and updates it. Returns the server's representation of the cronJobSource, and an error, if there is any.
func (c *FakeCronJobSources) Update(cronJobSource *v1alpha1.CronJobSource) (result *v1alpha1.CronJobSource, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(cronjobsourcesResource, c.ns, cronJobSource), &v1alpha1.CronJobSource{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.CronJobSource), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeCronJobSources) UpdateStatus(cronJobSource *v1alpha1.CronJobSource) (*v1alpha1.CronJobSource, error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateSubresourceAction(cronjobsourcesResource, "status", c.ns, cronJobSource), &v1alpha1.CronJobSource{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.CronJobSource), err
}

// Delete takes name of the cronJobSource and deletes it. Returns an error if one occurs.
func (c *FakeCronJobSources) Delete(name string, options *v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteAction(cronjobsourcesResource, c.ns, name), &v1alpha1.CronJobSource{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeCronJobSources) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(cronjobsourcesResource, c.ns, listOptions)

	_, err := c.Fake.Invokes(action, &v1alpha1.CronJobSourceList{})
	return err
}

// Patch applies the patch and returns the patched cronJobSource.
func (c *FakeCronJobSources) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha1.CronJobSource, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(cronjobsourcesResource, c.ns, name, pt, data, subresources...), &v1alpha1.CronJobSource{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.CronJobSource), err
}
