/*
Copyright 2020 The Knative Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
	v1beta1 "knative.dev/eventing-contrib/kafka/source/pkg/apis/sources/v1beta1"
)

// FakeKafkaSources implements KafkaSourceInterface
type FakeKafkaSources struct {
	Fake *FakeSourcesV1beta1
	ns   string
}

var kafkasourcesResource = schema.GroupVersionResource{Group: "sources.knative.dev", Version: "v1beta1", Resource: "kafkasources"}

var kafkasourcesKind = schema.GroupVersionKind{Group: "sources.knative.dev", Version: "v1beta1", Kind: "KafkaSource"}

// Get takes name of the kafkaSource, and returns the corresponding kafkaSource object, and an error if there is any.
func (c *FakeKafkaSources) Get(name string, options v1.GetOptions) (result *v1beta1.KafkaSource, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(kafkasourcesResource, c.ns, name), &v1beta1.KafkaSource{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.KafkaSource), err
}

// List takes label and field selectors, and returns the list of KafkaSources that match those selectors.
func (c *FakeKafkaSources) List(opts v1.ListOptions) (result *v1beta1.KafkaSourceList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(kafkasourcesResource, kafkasourcesKind, c.ns, opts), &v1beta1.KafkaSourceList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1beta1.KafkaSourceList{ListMeta: obj.(*v1beta1.KafkaSourceList).ListMeta}
	for _, item := range obj.(*v1beta1.KafkaSourceList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested kafkaSources.
func (c *FakeKafkaSources) Watch(opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(kafkasourcesResource, c.ns, opts))

}

// Create takes the representation of a kafkaSource and creates it.  Returns the server's representation of the kafkaSource, and an error, if there is any.
func (c *FakeKafkaSources) Create(kafkaSource *v1beta1.KafkaSource) (result *v1beta1.KafkaSource, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(kafkasourcesResource, c.ns, kafkaSource), &v1beta1.KafkaSource{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.KafkaSource), err
}

// Update takes the representation of a kafkaSource and updates it. Returns the server's representation of the kafkaSource, and an error, if there is any.
func (c *FakeKafkaSources) Update(kafkaSource *v1beta1.KafkaSource) (result *v1beta1.KafkaSource, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(kafkasourcesResource, c.ns, kafkaSource), &v1beta1.KafkaSource{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.KafkaSource), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeKafkaSources) UpdateStatus(kafkaSource *v1beta1.KafkaSource) (*v1beta1.KafkaSource, error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateSubresourceAction(kafkasourcesResource, "status", c.ns, kafkaSource), &v1beta1.KafkaSource{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.KafkaSource), err
}

// Delete takes name of the kafkaSource and deletes it. Returns an error if one occurs.
func (c *FakeKafkaSources) Delete(name string, options *v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteAction(kafkasourcesResource, c.ns, name), &v1beta1.KafkaSource{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeKafkaSources) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(kafkasourcesResource, c.ns, listOptions)

	_, err := c.Fake.Invokes(action, &v1beta1.KafkaSourceList{})
	return err
}

// Patch applies the patch and returns the patched kafkaSource.
func (c *FakeKafkaSources) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1beta1.KafkaSource, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(kafkasourcesResource, c.ns, name, pt, data, subresources...), &v1beta1.KafkaSource{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.KafkaSource), err
}
