// +build e2e

/*
Copyright 2020 The Knative Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package conformance

import (
	"testing"

	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"knative.dev/eventing/test/conformance/helpers"
	testlib "knative.dev/eventing/test/lib"
	"knative.dev/eventing/test/lib/resources"

	contribtest "knative.dev/eventing-contrib/test"
)

func TestChannelTracingWithReply(t *testing.T) {
	// Enable this test only for Kafka
	helpers.ChannelTracingTestHelperWithChannelTestRunner(t, testlib.ComponentsTestRunner{
		ComponentFeatureMap: map[metav1.TypeMeta][]testlib.Feature{
			{
				APIVersion: resources.MessagingAPIVersion,
				Kind:       contribtest.KafkaChannelKind,
			}: {
				testlib.FeatureBasic,
				testlib.FeatureRedelivery,
				testlib.FeaturePersistence,
			},
		},
		ComponentsToTest: []metav1.TypeMeta{
			{
				APIVersion: resources.MessagingAPIVersion,
				Kind:       contribtest.KafkaChannelKind,
			},
		},
	}, testlib.SetupClientOptionNoop)
}
