/*
Copyright 2020 The Knative Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1alpha1

import (
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
	v1alpha1 "knative.dev/eventing-contrib/github/pkg/apis/bindings/v1alpha1"
)

// GitHubBindingLister helps list GitHubBindings.
type GitHubBindingLister interface {
	// List lists all GitHubBindings in the indexer.
	List(selector labels.Selector) (ret []*v1alpha1.GitHubBinding, err error)
	// GitHubBindings returns an object that can list and get GitHubBindings.
	GitHubBindings(namespace string) GitHubBindingNamespaceLister
	GitHubBindingListerExpansion
}

// gitHubBindingLister implements the GitHubBindingLister interface.
type gitHubBindingLister struct {
	indexer cache.Indexer
}

// NewGitHubBindingLister returns a new GitHubBindingLister.
func NewGitHubBindingLister(indexer cache.Indexer) GitHubBindingLister {
	return &gitHubBindingLister{indexer: indexer}
}

// List lists all GitHubBindings in the indexer.
func (s *gitHubBindingLister) List(selector labels.Selector) (ret []*v1alpha1.GitHubBinding, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.GitHubBinding))
	})
	return ret, err
}

// GitHubBindings returns an object that can list and get GitHubBindings.
func (s *gitHubBindingLister) GitHubBindings(namespace string) GitHubBindingNamespaceLister {
	return gitHubBindingNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// GitHubBindingNamespaceLister helps list and get GitHubBindings.
type GitHubBindingNamespaceLister interface {
	// List lists all GitHubBindings in the indexer for a given namespace.
	List(selector labels.Selector) (ret []*v1alpha1.GitHubBinding, err error)
	// Get retrieves the GitHubBinding from the indexer for a given namespace and name.
	Get(name string) (*v1alpha1.GitHubBinding, error)
	GitHubBindingNamespaceListerExpansion
}

// gitHubBindingNamespaceLister implements the GitHubBindingNamespaceLister
// interface.
type gitHubBindingNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all GitHubBindings in the indexer for a given namespace.
func (s gitHubBindingNamespaceLister) List(selector labels.Selector) (ret []*v1alpha1.GitHubBinding, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.GitHubBinding))
	})
	return ret, err
}

// Get retrieves the GitHubBinding from the indexer for a given namespace and name.
func (s gitHubBindingNamespaceLister) Get(name string) (*v1alpha1.GitHubBinding, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1alpha1.Resource("githubbinding"), name)
	}
	return obj.(*v1alpha1.GitHubBinding), nil
}
