/*
Copyright 2020 The Knative Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1alpha1

import (
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
	v1alpha1 "knative.dev/eventing-contrib/gitlab/pkg/apis/sources/v1alpha1"
)

// GitLabSourceLister helps list GitLabSources.
type GitLabSourceLister interface {
	// List lists all GitLabSources in the indexer.
	List(selector labels.Selector) (ret []*v1alpha1.GitLabSource, err error)
	// GitLabSources returns an object that can list and get GitLabSources.
	GitLabSources(namespace string) GitLabSourceNamespaceLister
	GitLabSourceListerExpansion
}

// gitLabSourceLister implements the GitLabSourceLister interface.
type gitLabSourceLister struct {
	indexer cache.Indexer
}

// NewGitLabSourceLister returns a new GitLabSourceLister.
func NewGitLabSourceLister(indexer cache.Indexer) GitLabSourceLister {
	return &gitLabSourceLister{indexer: indexer}
}

// List lists all GitLabSources in the indexer.
func (s *gitLabSourceLister) List(selector labels.Selector) (ret []*v1alpha1.GitLabSource, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.GitLabSource))
	})
	return ret, err
}

// GitLabSources returns an object that can list and get GitLabSources.
func (s *gitLabSourceLister) GitLabSources(namespace string) GitLabSourceNamespaceLister {
	return gitLabSourceNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// GitLabSourceNamespaceLister helps list and get GitLabSources.
type GitLabSourceNamespaceLister interface {
	// List lists all GitLabSources in the indexer for a given namespace.
	List(selector labels.Selector) (ret []*v1alpha1.GitLabSource, err error)
	// Get retrieves the GitLabSource from the indexer for a given namespace and name.
	Get(name string) (*v1alpha1.GitLabSource, error)
	GitLabSourceNamespaceListerExpansion
}

// gitLabSourceNamespaceLister implements the GitLabSourceNamespaceLister
// interface.
type gitLabSourceNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all GitLabSources in the indexer for a given namespace.
func (s gitLabSourceNamespaceLister) List(selector labels.Selector) (ret []*v1alpha1.GitLabSource, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.GitLabSource))
	})
	return ret, err
}

// Get retrieves the GitLabSource from the indexer for a given namespace and name.
func (s gitLabSourceNamespaceLister) Get(name string) (*v1alpha1.GitLabSource, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1alpha1.Resource("gitlabsource"), name)
	}
	return obj.(*v1alpha1.GitLabSource), nil
}
