/*
Copyright 2020 The Knative Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1alpha2

import (
	"time"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
	v1alpha2 "knative.dev/eventing/pkg/apis/sources/v1alpha2"
	scheme "knative.dev/eventing/pkg/client/clientset/versioned/scheme"
)

// ContainerSourcesGetter has a method to return a ContainerSourceInterface.
// A group's client should implement this interface.
type ContainerSourcesGetter interface {
	ContainerSources(namespace string) ContainerSourceInterface
}

// ContainerSourceInterface has methods to work with ContainerSource resources.
type ContainerSourceInterface interface {
	Create(*v1alpha2.ContainerSource) (*v1alpha2.ContainerSource, error)
	Update(*v1alpha2.ContainerSource) (*v1alpha2.ContainerSource, error)
	UpdateStatus(*v1alpha2.ContainerSource) (*v1alpha2.ContainerSource, error)
	Delete(name string, options *v1.DeleteOptions) error
	DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error
	Get(name string, options v1.GetOptions) (*v1alpha2.ContainerSource, error)
	List(opts v1.ListOptions) (*v1alpha2.ContainerSourceList, error)
	Watch(opts v1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha2.ContainerSource, err error)
	ContainerSourceExpansion
}

// containerSources implements ContainerSourceInterface
type containerSources struct {
	client rest.Interface
	ns     string
}

// newContainerSources returns a ContainerSources
func newContainerSources(c *SourcesV1alpha2Client, namespace string) *containerSources {
	return &containerSources{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the containerSource, and returns the corresponding containerSource object, and an error if there is any.
func (c *containerSources) Get(name string, options v1.GetOptions) (result *v1alpha2.ContainerSource, err error) {
	result = &v1alpha2.ContainerSource{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("containersources").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of ContainerSources that match those selectors.
func (c *containerSources) List(opts v1.ListOptions) (result *v1alpha2.ContainerSourceList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1alpha2.ContainerSourceList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("containersources").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do().
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested containerSources.
func (c *containerSources) Watch(opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("containersources").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch()
}

// Create takes the representation of a containerSource and creates it.  Returns the server's representation of the containerSource, and an error, if there is any.
func (c *containerSources) Create(containerSource *v1alpha2.ContainerSource) (result *v1alpha2.ContainerSource, err error) {
	result = &v1alpha2.ContainerSource{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("containersources").
		Body(containerSource).
		Do().
		Into(result)
	return
}

// Update takes the representation of a containerSource and updates it. Returns the server's representation of the containerSource, and an error, if there is any.
func (c *containerSources) Update(containerSource *v1alpha2.ContainerSource) (result *v1alpha2.ContainerSource, err error) {
	result = &v1alpha2.ContainerSource{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("containersources").
		Name(containerSource.Name).
		Body(containerSource).
		Do().
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().

func (c *containerSources) UpdateStatus(containerSource *v1alpha2.ContainerSource) (result *v1alpha2.ContainerSource, err error) {
	result = &v1alpha2.ContainerSource{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("containersources").
		Name(containerSource.Name).
		SubResource("status").
		Body(containerSource).
		Do().
		Into(result)
	return
}

// Delete takes name of the containerSource and deletes it. Returns an error if one occurs.
func (c *containerSources) Delete(name string, options *v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("containersources").
		Name(name).
		Body(options).
		Do().
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *containerSources) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	var timeout time.Duration
	if listOptions.TimeoutSeconds != nil {
		timeout = time.Duration(*listOptions.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("containersources").
		VersionedParams(&listOptions, scheme.ParameterCodec).
		Timeout(timeout).
		Body(options).
		Do().
		Error()
}

// Patch applies the patch and returns the patched containerSource.
func (c *containerSources) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha2.ContainerSource, err error) {
	result = &v1alpha2.ContainerSource{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("containersources").
		SubResource(subresources...).
		Name(name).
		Body(data).
		Do().
		Into(result)
	return
}
