// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: envoy/config/filter/http/jwt_auth/v2alpha1/config.proto

package v2alpha1

import (
	fmt "fmt"
	proto "github.com/gogo/protobuf/proto"
	types "github.com/gogo/protobuf/types"
	io "io"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

// Copied from @envoy/api/envoy/api/v2/core/http_uri.proto
// Envoy external URI descriptor
type HttpUri struct {
	// The HTTP server URI. It should be a full FQDN with protocol, host and path.
	//
	// Example:
	//
	// .. code-block:: yaml
	//
	//    uri: https://www.googleapis.com/oauth2/v1/certs
	//
	Uri string `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
	// Specify how `uri` is to be fetched. Today, this requires an explicit
	// cluster, but in the future we may support dynamic cluster creation or
	// inline DNS resolution. See `issue
	// <https://github.com/envoyproxy/envoy/issues/1606>`_.
	//
	// Types that are valid to be assigned to HttpUpstreamType:
	//	*HttpUri_Cluster
	HttpUpstreamType isHttpUri_HttpUpstreamType `protobuf_oneof:"http_upstream_type"`
	// Sets the maximum duration in milliseconds that a response can take to arrive upon request.
	Timeout              *types.Duration `protobuf:"bytes,3,opt,name=timeout,proto3" json:"timeout,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *HttpUri) Reset()         { *m = HttpUri{} }
func (m *HttpUri) String() string { return proto.CompactTextString(m) }
func (*HttpUri) ProtoMessage()    {}
func (*HttpUri) Descriptor() ([]byte, []int) {
	return fileDescriptor_7c36de3e06e3b641, []int{0}
}
func (m *HttpUri) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HttpUri) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_HttpUri.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *HttpUri) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HttpUri.Merge(m, src)
}
func (m *HttpUri) XXX_Size() int {
	return m.Size()
}
func (m *HttpUri) XXX_DiscardUnknown() {
	xxx_messageInfo_HttpUri.DiscardUnknown(m)
}

var xxx_messageInfo_HttpUri proto.InternalMessageInfo

type isHttpUri_HttpUpstreamType interface {
	isHttpUri_HttpUpstreamType()
	MarshalTo([]byte) (int, error)
	Size() int
}

type HttpUri_Cluster struct {
	Cluster string `protobuf:"bytes,2,opt,name=cluster,proto3,oneof"`
}

func (*HttpUri_Cluster) isHttpUri_HttpUpstreamType() {}

func (m *HttpUri) GetHttpUpstreamType() isHttpUri_HttpUpstreamType {
	if m != nil {
		return m.HttpUpstreamType
	}
	return nil
}

func (m *HttpUri) GetUri() string {
	if m != nil {
		return m.Uri
	}
	return ""
}

func (m *HttpUri) GetCluster() string {
	if x, ok := m.GetHttpUpstreamType().(*HttpUri_Cluster); ok {
		return x.Cluster
	}
	return ""
}

func (m *HttpUri) GetTimeout() *types.Duration {
	if m != nil {
		return m.Timeout
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*HttpUri) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _HttpUri_OneofMarshaler, _HttpUri_OneofUnmarshaler, _HttpUri_OneofSizer, []interface{}{
		(*HttpUri_Cluster)(nil),
	}
}

func _HttpUri_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*HttpUri)
	// http_upstream_type
	switch x := m.HttpUpstreamType.(type) {
	case *HttpUri_Cluster:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.Cluster)
	case nil:
	default:
		return fmt.Errorf("HttpUri.HttpUpstreamType has unexpected type %T", x)
	}
	return nil
}

func _HttpUri_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*HttpUri)
	switch tag {
	case 2: // http_upstream_type.cluster
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.HttpUpstreamType = &HttpUri_Cluster{x}
		return true, err
	default:
		return false, nil
	}
}

func _HttpUri_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*HttpUri)
	// http_upstream_type
	switch x := m.HttpUpstreamType.(type) {
	case *HttpUri_Cluster:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.Cluster)))
		n += len(x.Cluster)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Copied from @envoy/api/envoy/api/v2/core/base.proto
// Data source consisting of either a file or an inline value.
type DataSource struct {
	// Types that are valid to be assigned to Specifier:
	//	*DataSource_Filename
	//	*DataSource_InlineBytes
	//	*DataSource_InlineString
	Specifier            isDataSource_Specifier `protobuf_oneof:"specifier"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *DataSource) Reset()         { *m = DataSource{} }
func (m *DataSource) String() string { return proto.CompactTextString(m) }
func (*DataSource) ProtoMessage()    {}
func (*DataSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_7c36de3e06e3b641, []int{1}
}
func (m *DataSource) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DataSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DataSource.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DataSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DataSource.Merge(m, src)
}
func (m *DataSource) XXX_Size() int {
	return m.Size()
}
func (m *DataSource) XXX_DiscardUnknown() {
	xxx_messageInfo_DataSource.DiscardUnknown(m)
}

var xxx_messageInfo_DataSource proto.InternalMessageInfo

type isDataSource_Specifier interface {
	isDataSource_Specifier()
	MarshalTo([]byte) (int, error)
	Size() int
}

type DataSource_Filename struct {
	Filename string `protobuf:"bytes,1,opt,name=filename,proto3,oneof"`
}
type DataSource_InlineBytes struct {
	InlineBytes []byte `protobuf:"bytes,2,opt,name=inline_bytes,json=inlineBytes,proto3,oneof"`
}
type DataSource_InlineString struct {
	InlineString string `protobuf:"bytes,3,opt,name=inline_string,json=inlineString,proto3,oneof"`
}

func (*DataSource_Filename) isDataSource_Specifier()     {}
func (*DataSource_InlineBytes) isDataSource_Specifier()  {}
func (*DataSource_InlineString) isDataSource_Specifier() {}

func (m *DataSource) GetSpecifier() isDataSource_Specifier {
	if m != nil {
		return m.Specifier
	}
	return nil
}

func (m *DataSource) GetFilename() string {
	if x, ok := m.GetSpecifier().(*DataSource_Filename); ok {
		return x.Filename
	}
	return ""
}

func (m *DataSource) GetInlineBytes() []byte {
	if x, ok := m.GetSpecifier().(*DataSource_InlineBytes); ok {
		return x.InlineBytes
	}
	return nil
}

func (m *DataSource) GetInlineString() string {
	if x, ok := m.GetSpecifier().(*DataSource_InlineString); ok {
		return x.InlineString
	}
	return ""
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*DataSource) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _DataSource_OneofMarshaler, _DataSource_OneofUnmarshaler, _DataSource_OneofSizer, []interface{}{
		(*DataSource_Filename)(nil),
		(*DataSource_InlineBytes)(nil),
		(*DataSource_InlineString)(nil),
	}
}

func _DataSource_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*DataSource)
	// specifier
	switch x := m.Specifier.(type) {
	case *DataSource_Filename:
		_ = b.EncodeVarint(1<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.Filename)
	case *DataSource_InlineBytes:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		_ = b.EncodeRawBytes(x.InlineBytes)
	case *DataSource_InlineString:
		_ = b.EncodeVarint(3<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.InlineString)
	case nil:
	default:
		return fmt.Errorf("DataSource.Specifier has unexpected type %T", x)
	}
	return nil
}

func _DataSource_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*DataSource)
	switch tag {
	case 1: // specifier.filename
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Specifier = &DataSource_Filename{x}
		return true, err
	case 2: // specifier.inline_bytes
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.Specifier = &DataSource_InlineBytes{x}
		return true, err
	case 3: // specifier.inline_string
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Specifier = &DataSource_InlineString{x}
		return true, err
	default:
		return false, nil
	}
}

func _DataSource_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*DataSource)
	// specifier
	switch x := m.Specifier.(type) {
	case *DataSource_Filename:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.Filename)))
		n += len(x.Filename)
	case *DataSource_InlineBytes:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.InlineBytes)))
		n += len(x.InlineBytes)
	case *DataSource_InlineString:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.InlineString)))
		n += len(x.InlineString)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// This message specifies how a JSON Web Token (JWT) can be verified. See the [JWT format definition](https://tools.ietf.org/html/rfc7519)
// for details. Please see [OAuth2.0](https://tools.ietf.org/html/rfc6749) and
// [OIDC1.0](http://openid.net/connect) for
// the authentication flow.
//
// Example:
//
// ```yaml
//     issuer: https://example.com
//     audiences:
//     - bookstore_android.apps.googleusercontent.com
//       bookstore_web.apps.googleusercontent.com
//     remote_jwks:
//     - http_uri:
//       - uri: https://example.com/.well-known/jwks.json
//         cluster: example_jwks_cluster
//       cache_duration:
//       - seconds: 300
// ```
type JwtRule struct {
	// Identifies the principal that issued the JWT. See `here
	//  <https://tools.ietf.org/html/rfc7519#section-4.1.1>`_. Usually a URL or an email address.
	//
	// Example: https://securetoken.google.com
	// Example: 1234567-compute@developer.gserviceaccount.com
	//
	Issuer string `protobuf:"bytes,1,opt,name=issuer,proto3" json:"issuer,omitempty"`
	// The list of JWT `audiences <https://tools.ietf.org/html/rfc7519#section-4.1.3>`_. that are
	// allowed to access. A JWT containing any of these audiences will be accepted. If not specified,
	// will not check audiences in the token.
	//
	// Example:
	//
	// .. code-block:: yaml
	//
	//     audiences:
	//     - bookstore_android.apps.googleusercontent.com
	//       bookstore_web.apps.googleusercontent.com
	//
	Audiences []string `protobuf:"bytes,2,rep,name=audiences,proto3" json:"audiences,omitempty"`
	// `JSON Web Key Set <https://tools.ietf.org/html/rfc7517#appendix-A>`_ is needed. to validate
	// signature of the JWT. This field specifies where to fetch JWKS.
	//
	// Types that are valid to be assigned to JwksSourceSpecifier:
	//	*JwtRule_RemoteJwks
	//	*JwtRule_LocalJwks
	JwksSourceSpecifier isJwtRule_JwksSourceSpecifier `protobuf_oneof:"jwks_source_specifier"`
	// If false, the JWT is removed in the request after a success verification. If true, the JWT is
	// not removed in the request. Default value is false.
	Forward bool `protobuf:"varint,5,opt,name=forward,proto3" json:"forward,omitempty"`
	// Specify the HTTP headers to extract JWT token. For examples, following config:
	//
	// .. code-block:: yaml
	//
	//   from_headers:
	//   - name: x-goog-iap-jwt-assertion
	//
	// can be used to extract token from header::
	//
	//   x-goog-iap-jwt-assertion: <JWT>.
	//
	FromHeaders []*JwtHeader `protobuf:"bytes,6,rep,name=from_headers,json=fromHeaders,proto3" json:"from_headers,omitempty"`
	// JWT is sent in a query parameter. `jwt_params` represents the query parameter names.
	//
	// For example, if config is:
	//
	// .. code-block:: yaml
	//
	//   from_params:
	//   - jwt_token
	//
	// The JWT format in query parameter is::
	//
	//    /path?jwt_token=<JWT>
	//
	FromParams []string `protobuf:"bytes,7,rep,name=from_params,json=fromParams,proto3" json:"from_params,omitempty"`
	// This field specifies the header name to forward a successfully verified JWT payload to the
	// backend. The forwarded data is::
	//
	//    base64_encoded(jwt_payload_in_JSON)
	//
	// If it is not specified, the payload will not be forwarded.
	// Multiple JWTs in a request from different issuers will be supported. Multiple JWTs from the
	// same issuer will not be supported. Each issuer can config this `forward_payload_header`. If
	// multiple JWTs from different issuers want to forward their payloads, their
	// `forward_payload_header` should be different.
	ForwardPayloadHeader string   `protobuf:"bytes,8,opt,name=forward_payload_header,json=forwardPayloadHeader,proto3" json:"forward_payload_header,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *JwtRule) Reset()         { *m = JwtRule{} }
func (m *JwtRule) String() string { return proto.CompactTextString(m) }
func (*JwtRule) ProtoMessage()    {}
func (*JwtRule) Descriptor() ([]byte, []int) {
	return fileDescriptor_7c36de3e06e3b641, []int{2}
}
func (m *JwtRule) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *JwtRule) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_JwtRule.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *JwtRule) XXX_Merge(src proto.Message) {
	xxx_messageInfo_JwtRule.Merge(m, src)
}
func (m *JwtRule) XXX_Size() int {
	return m.Size()
}
func (m *JwtRule) XXX_DiscardUnknown() {
	xxx_messageInfo_JwtRule.DiscardUnknown(m)
}

var xxx_messageInfo_JwtRule proto.InternalMessageInfo

type isJwtRule_JwksSourceSpecifier interface {
	isJwtRule_JwksSourceSpecifier()
	MarshalTo([]byte) (int, error)
	Size() int
}

type JwtRule_RemoteJwks struct {
	RemoteJwks *RemoteJwks `protobuf:"bytes,3,opt,name=remote_jwks,json=remoteJwks,proto3,oneof"`
}
type JwtRule_LocalJwks struct {
	LocalJwks *DataSource `protobuf:"bytes,4,opt,name=local_jwks,json=localJwks,proto3,oneof"`
}

func (*JwtRule_RemoteJwks) isJwtRule_JwksSourceSpecifier() {}
func (*JwtRule_LocalJwks) isJwtRule_JwksSourceSpecifier()  {}

func (m *JwtRule) GetJwksSourceSpecifier() isJwtRule_JwksSourceSpecifier {
	if m != nil {
		return m.JwksSourceSpecifier
	}
	return nil
}

func (m *JwtRule) GetIssuer() string {
	if m != nil {
		return m.Issuer
	}
	return ""
}

func (m *JwtRule) GetAudiences() []string {
	if m != nil {
		return m.Audiences
	}
	return nil
}

func (m *JwtRule) GetRemoteJwks() *RemoteJwks {
	if x, ok := m.GetJwksSourceSpecifier().(*JwtRule_RemoteJwks); ok {
		return x.RemoteJwks
	}
	return nil
}

func (m *JwtRule) GetLocalJwks() *DataSource {
	if x, ok := m.GetJwksSourceSpecifier().(*JwtRule_LocalJwks); ok {
		return x.LocalJwks
	}
	return nil
}

func (m *JwtRule) GetForward() bool {
	if m != nil {
		return m.Forward
	}
	return false
}

func (m *JwtRule) GetFromHeaders() []*JwtHeader {
	if m != nil {
		return m.FromHeaders
	}
	return nil
}

func (m *JwtRule) GetFromParams() []string {
	if m != nil {
		return m.FromParams
	}
	return nil
}

func (m *JwtRule) GetForwardPayloadHeader() string {
	if m != nil {
		return m.ForwardPayloadHeader
	}
	return ""
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*JwtRule) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _JwtRule_OneofMarshaler, _JwtRule_OneofUnmarshaler, _JwtRule_OneofSizer, []interface{}{
		(*JwtRule_RemoteJwks)(nil),
		(*JwtRule_LocalJwks)(nil),
	}
}

func _JwtRule_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*JwtRule)
	// jwks_source_specifier
	switch x := m.JwksSourceSpecifier.(type) {
	case *JwtRule_RemoteJwks:
		_ = b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.RemoteJwks); err != nil {
			return err
		}
	case *JwtRule_LocalJwks:
		_ = b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.LocalJwks); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("JwtRule.JwksSourceSpecifier has unexpected type %T", x)
	}
	return nil
}

func _JwtRule_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*JwtRule)
	switch tag {
	case 3: // jwks_source_specifier.remote_jwks
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(RemoteJwks)
		err := b.DecodeMessage(msg)
		m.JwksSourceSpecifier = &JwtRule_RemoteJwks{msg}
		return true, err
	case 4: // jwks_source_specifier.local_jwks
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(DataSource)
		err := b.DecodeMessage(msg)
		m.JwksSourceSpecifier = &JwtRule_LocalJwks{msg}
		return true, err
	default:
		return false, nil
	}
}

func _JwtRule_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*JwtRule)
	// jwks_source_specifier
	switch x := m.JwksSourceSpecifier.(type) {
	case *JwtRule_RemoteJwks:
		s := proto.Size(x.RemoteJwks)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *JwtRule_LocalJwks:
		s := proto.Size(x.LocalJwks)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// This message specifies how to fetch JWKS from remote and how to cache it.
type RemoteJwks struct {
	// The HTTP URI to fetch the JWKS. For example:
	//
	// .. code-block:: yaml
	//
	//    http_uri:
	//    - uri: https://www.googleapis.com/oauth2/v1/certs
	//      cluster: jwt.www.googleapis.com|443
	//
	HttpUri *HttpUri `protobuf:"bytes,1,opt,name=http_uri,json=httpUri,proto3" json:"http_uri,omitempty"`
	// Duration after which the cached JWKS should be expired. If not specified, default cache
	// duration is 5 minutes.
	CacheDuration        *types.Duration `protobuf:"bytes,2,opt,name=cache_duration,json=cacheDuration,proto3" json:"cache_duration,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *RemoteJwks) Reset()         { *m = RemoteJwks{} }
func (m *RemoteJwks) String() string { return proto.CompactTextString(m) }
func (*RemoteJwks) ProtoMessage()    {}
func (*RemoteJwks) Descriptor() ([]byte, []int) {
	return fileDescriptor_7c36de3e06e3b641, []int{3}
}
func (m *RemoteJwks) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RemoteJwks) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RemoteJwks.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RemoteJwks) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RemoteJwks.Merge(m, src)
}
func (m *RemoteJwks) XXX_Size() int {
	return m.Size()
}
func (m *RemoteJwks) XXX_DiscardUnknown() {
	xxx_messageInfo_RemoteJwks.DiscardUnknown(m)
}

var xxx_messageInfo_RemoteJwks proto.InternalMessageInfo

func (m *RemoteJwks) GetHttpUri() *HttpUri {
	if m != nil {
		return m.HttpUri
	}
	return nil
}

func (m *RemoteJwks) GetCacheDuration() *types.Duration {
	if m != nil {
		return m.CacheDuration
	}
	return nil
}

// This message specifies a header location to extract JWT token.
type JwtHeader struct {
	// The HTTP header name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The value prefix. The value format is "value_prefix<token>"
	// For example, for "Authorization: Bearer <token>", value_prefix="Bearer " with a space at the
	// end.
	ValuePrefix          string   `protobuf:"bytes,2,opt,name=value_prefix,json=valuePrefix,proto3" json:"value_prefix,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *JwtHeader) Reset()         { *m = JwtHeader{} }
func (m *JwtHeader) String() string { return proto.CompactTextString(m) }
func (*JwtHeader) ProtoMessage()    {}
func (*JwtHeader) Descriptor() ([]byte, []int) {
	return fileDescriptor_7c36de3e06e3b641, []int{4}
}
func (m *JwtHeader) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *JwtHeader) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_JwtHeader.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *JwtHeader) XXX_Merge(src proto.Message) {
	xxx_messageInfo_JwtHeader.Merge(m, src)
}
func (m *JwtHeader) XXX_Size() int {
	return m.Size()
}
func (m *JwtHeader) XXX_DiscardUnknown() {
	xxx_messageInfo_JwtHeader.DiscardUnknown(m)
}

var xxx_messageInfo_JwtHeader proto.InternalMessageInfo

func (m *JwtHeader) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *JwtHeader) GetValuePrefix() string {
	if m != nil {
		return m.ValuePrefix
	}
	return ""
}

// This is the Envoy HTTP filter config for JWT authentication.
// [#not-implemented-hide:]
type JwtAuthentication struct {
	// List of JWT rules to valide.
	Rules []*JwtRule `protobuf:"bytes,1,rep,name=rules,proto3" json:"rules,omitempty"`
	// If true, the request is allowed if JWT is missing or JWT verification fails.
	// Default is false, a request without JWT or failed JWT verification is not allowed.
	AllowMissingOrFailed bool     `protobuf:"varint,2,opt,name=allow_missing_or_failed,json=allowMissingOrFailed,proto3" json:"allow_missing_or_failed,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *JwtAuthentication) Reset()         { *m = JwtAuthentication{} }
func (m *JwtAuthentication) String() string { return proto.CompactTextString(m) }
func (*JwtAuthentication) ProtoMessage()    {}
func (*JwtAuthentication) Descriptor() ([]byte, []int) {
	return fileDescriptor_7c36de3e06e3b641, []int{5}
}
func (m *JwtAuthentication) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *JwtAuthentication) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_JwtAuthentication.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *JwtAuthentication) XXX_Merge(src proto.Message) {
	xxx_messageInfo_JwtAuthentication.Merge(m, src)
}
func (m *JwtAuthentication) XXX_Size() int {
	return m.Size()
}
func (m *JwtAuthentication) XXX_DiscardUnknown() {
	xxx_messageInfo_JwtAuthentication.DiscardUnknown(m)
}

var xxx_messageInfo_JwtAuthentication proto.InternalMessageInfo

func (m *JwtAuthentication) GetRules() []*JwtRule {
	if m != nil {
		return m.Rules
	}
	return nil
}

func (m *JwtAuthentication) GetAllowMissingOrFailed() bool {
	if m != nil {
		return m.AllowMissingOrFailed
	}
	return false
}

func init() {
	proto.RegisterType((*HttpUri)(nil), "istio.envoy.config.filter.http.jwt_auth.v2alpha1.HttpUri")
	proto.RegisterType((*DataSource)(nil), "istio.envoy.config.filter.http.jwt_auth.v2alpha1.DataSource")
	proto.RegisterType((*JwtRule)(nil), "istio.envoy.config.filter.http.jwt_auth.v2alpha1.JwtRule")
	proto.RegisterType((*RemoteJwks)(nil), "istio.envoy.config.filter.http.jwt_auth.v2alpha1.RemoteJwks")
	proto.RegisterType((*JwtHeader)(nil), "istio.envoy.config.filter.http.jwt_auth.v2alpha1.JwtHeader")
	proto.RegisterType((*JwtAuthentication)(nil), "istio.envoy.config.filter.http.jwt_auth.v2alpha1.JwtAuthentication")
}

func init() {
	proto.RegisterFile("envoy/config/filter/http/jwt_auth/v2alpha1/config.proto", fileDescriptor_7c36de3e06e3b641)
}

var fileDescriptor_7c36de3e06e3b641 = []byte{
	// 678 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x54, 0xc1, 0x6e, 0xd3, 0x4a,
	0x14, 0x8d, 0x5f, 0xda, 0x26, 0xb9, 0x4e, 0x9f, 0xde, 0x1b, 0x95, 0xd6, 0x54, 0x55, 0x08, 0x41,
	0x48, 0x59, 0xd9, 0x90, 0x82, 0xaa, 0x0a, 0x16, 0x10, 0x15, 0x14, 0x45, 0x42, 0xad, 0xa6, 0xb0,
	0x41, 0x82, 0xd1, 0xd4, 0x19, 0x27, 0xd3, 0x8e, 0x3d, 0xd6, 0xcc, 0xb8, 0x26, 0x5b, 0xf8, 0x0c,
	0xb6, 0x7c, 0x0c, 0x4b, 0x3e, 0x01, 0x75, 0xc7, 0x5f, 0x20, 0x8f, 0xed, 0x66, 0x87, 0x68, 0x77,
	0x73, 0xcf, 0x9d, 0x7b, 0xee, 0xf1, 0xb9, 0x73, 0x0d, 0x07, 0x2c, 0xb9, 0x94, 0xcb, 0x20, 0x94,
	0x49, 0xc4, 0xe7, 0x41, 0xc4, 0x85, 0x61, 0x2a, 0x58, 0x18, 0x93, 0x06, 0xe7, 0xb9, 0x21, 0x34,
	0x33, 0x8b, 0xe0, 0x72, 0x44, 0x45, 0xba, 0xa0, 0x8f, 0xab, 0x4b, 0x7e, 0xaa, 0xa4, 0x91, 0xe8,
	0x11, 0xd7, 0x86, 0x4b, 0xdf, 0x96, 0xfb, 0x55, 0xa6, 0x2c, 0xf7, 0x8b, 0x72, 0xbf, 0x2e, 0xf7,
	0xeb, 0xf2, 0xdd, 0xde, 0x5c, 0xca, 0xb9, 0x60, 0x81, 0xad, 0x3f, 0xcb, 0xa2, 0x60, 0x96, 0x29,
	0x6a, 0xb8, 0x4c, 0x4a, 0xc6, 0xc1, 0x67, 0x07, 0x5a, 0x13, 0x63, 0xd2, 0x77, 0x8a, 0xa3, 0xff,
	0xa0, 0x99, 0x29, 0xee, 0x39, 0x7d, 0x67, 0xd8, 0xc1, 0xc5, 0x11, 0xed, 0x42, 0x2b, 0x14, 0x99,
	0x36, 0x4c, 0x79, 0xff, 0x14, 0xe8, 0xa4, 0x81, 0x6b, 0x00, 0xed, 0x43, 0xcb, 0xf0, 0x98, 0xc9,
	0xcc, 0x78, 0xcd, 0xbe, 0x33, 0x74, 0x47, 0x77, 0xfd, 0xb2, 0x97, 0x5f, 0xf7, 0xf2, 0x8f, 0xaa,
	0x5e, 0xb8, 0xbe, 0x39, 0xde, 0x02, 0x54, 0x08, 0x25, 0x59, 0xaa, 0x8d, 0x62, 0x34, 0x26, 0x66,
	0x99, 0xb2, 0xc1, 0x17, 0x07, 0xe0, 0x88, 0x1a, 0x7a, 0x2a, 0x33, 0x15, 0x32, 0xb4, 0x07, 0xed,
	0x88, 0x0b, 0x96, 0xd0, 0x98, 0x95, 0x62, 0x26, 0x0d, 0x7c, 0x8d, 0xa0, 0x07, 0xd0, 0xe5, 0x89,
	0xe0, 0x09, 0x23, 0x67, 0x4b, 0xc3, 0xb4, 0x15, 0xd6, 0x9d, 0x34, 0xb0, 0x5b, 0xa2, 0xe3, 0x02,
	0x44, 0x0f, 0x61, 0xb3, 0xba, 0xa4, 0x8d, 0xe2, 0xc9, 0xdc, 0x4a, 0x2c, 0x78, 0xaa, 0xda, 0x53,
	0x8b, 0x8e, 0x5d, 0xe8, 0xe8, 0x94, 0x85, 0x3c, 0xe2, 0x4c, 0x0d, 0x7e, 0x35, 0xa1, 0x35, 0xcd,
	0x0d, 0xce, 0x04, 0x43, 0xdb, 0xb0, 0xc1, 0xb5, 0xce, 0x98, 0xaa, 0xdc, 0xa8, 0x22, 0xb4, 0x07,
	0x1d, 0x9a, 0xcd, 0x38, 0x4b, 0x42, 0xdb, 0xb9, 0x39, 0xec, 0xe0, 0x15, 0x80, 0x08, 0xb8, 0x8a,
	0xc5, 0xd2, 0x30, 0x72, 0x9e, 0x5f, 0xe8, 0xca, 0x96, 0xe7, 0xfe, 0x4d, 0x87, 0xe6, 0x63, 0x4b,
	0x32, 0xcd, 0x2f, 0xf4, 0xa4, 0x81, 0x41, 0x5d, 0x47, 0xe8, 0x03, 0x80, 0x90, 0x21, 0x15, 0x25,
	0xff, 0xda, 0x6d, 0xf9, 0x57, 0x5e, 0x4f, 0x1a, 0xb8, 0x63, 0x19, 0x2d, 0xbd, 0x07, 0xad, 0x48,
	0xaa, 0x9c, 0xaa, 0x99, 0xb7, 0xde, 0x77, 0x86, 0x6d, 0x5c, 0x87, 0xe8, 0x23, 0x74, 0x23, 0x25,
	0x63, 0xb2, 0x60, 0x74, 0xc6, 0x94, 0xf6, 0x36, 0xfa, 0xcd, 0xa1, 0x3b, 0x7a, 0x76, 0xf3, 0xd6,
	0xd3, 0xdc, 0x4c, 0x2c, 0x07, 0x76, 0x0b, 0xc2, 0xf2, 0xac, 0xd1, 0x3d, 0xb0, 0x21, 0x49, 0xa9,
	0xa2, 0xb1, 0xf6, 0x5a, 0xd6, 0x59, 0x28, 0xa0, 0x13, 0x8b, 0xa0, 0x27, 0xb0, 0x5d, 0x69, 0x21,
	0x29, 0x5d, 0x0a, 0x49, 0x67, 0x95, 0x16, 0xaf, 0x6d, 0x07, 0xb4, 0x55, 0x65, 0x4f, 0xca, 0x64,
	0xc9, 0x3b, 0xde, 0x81, 0x3b, 0x85, 0x53, 0x44, 0xdb, 0x8f, 0x25, 0xab, 0x59, 0x7f, 0x73, 0x00,
	0x56, 0x2e, 0xa3, 0xb7, 0xd0, 0x2e, 0x9f, 0x65, 0xf5, 0xfc, 0xdd, 0xd1, 0xe1, 0xcd, 0x3f, 0xad,
	0x5a, 0x23, 0xdc, 0x5a, 0x54, 0xfb, 0xf4, 0x02, 0xfe, 0x0d, 0x69, 0xb8, 0x60, 0xa4, 0xde, 0x39,
	0xfb, 0x56, 0xff, 0xb8, 0x28, 0x9b, 0xb6, 0xa0, 0x0e, 0x07, 0x63, 0xe8, 0x5c, 0x1b, 0x86, 0x10,
	0xac, 0xad, 0x56, 0x02, 0xdb, 0x33, 0xba, 0x0f, 0xdd, 0x4b, 0x2a, 0x32, 0x46, 0x52, 0xc5, 0x22,
	0xfe, 0xa9, 0xdc, 0x52, 0xec, 0x5a, 0xec, 0xc4, 0x42, 0x83, 0xaf, 0x0e, 0xfc, 0x3f, 0xcd, 0xcd,
	0xcb, 0xcc, 0x2c, 0x58, 0x62, 0x78, 0x68, 0x99, 0xd1, 0x31, 0xac, 0xab, 0x4c, 0x30, 0xed, 0x39,
	0x76, 0x92, 0x87, 0xb7, 0x9a, 0x64, 0xb1, 0x2a, 0xb8, 0xe4, 0x41, 0x4f, 0x61, 0x87, 0x0a, 0x21,
	0x73, 0x12, 0x73, 0xad, 0x79, 0x32, 0x27, 0x52, 0x91, 0x88, 0x72, 0xc1, 0x66, 0x56, 0x54, 0x1b,
	0x6f, 0xd9, 0xf4, 0x9b, 0x32, 0x7b, 0xac, 0x5e, 0xdb, 0xdc, 0xf8, 0xd5, 0xf7, 0xab, 0x9e, 0xf3,
	0xe3, 0xaa, 0xe7, 0xfc, 0xbc, 0xea, 0x39, 0xef, 0x0f, 0x4a, 0x15, 0x5c, 0x06, 0x34, 0xe5, 0xc1,
	0xdf, 0xff, 0x25, 0xcf, 0x36, 0xac, 0x95, 0xfb, 0xbf, 0x03, 0x00, 0x00, 0xff, 0xff, 0x1b, 0x4f,
	0x9e, 0x6b, 0x5a, 0x05, 0x00, 0x00,
}

func (m *HttpUri) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HttpUri) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Uri) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintConfig(dAtA, i, uint64(len(m.Uri)))
		i += copy(dAtA[i:], m.Uri)
	}
	if m.HttpUpstreamType != nil {
		nn1, err := m.HttpUpstreamType.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn1
	}
	if m.Timeout != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintConfig(dAtA, i, uint64(m.Timeout.Size()))
		n2, err := m.Timeout.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *HttpUri_Cluster) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x12
	i++
	i = encodeVarintConfig(dAtA, i, uint64(len(m.Cluster)))
	i += copy(dAtA[i:], m.Cluster)
	return i, nil
}
func (m *DataSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DataSource) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Specifier != nil {
		nn3, err := m.Specifier.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn3
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *DataSource_Filename) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0xa
	i++
	i = encodeVarintConfig(dAtA, i, uint64(len(m.Filename)))
	i += copy(dAtA[i:], m.Filename)
	return i, nil
}
func (m *DataSource_InlineBytes) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.InlineBytes != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintConfig(dAtA, i, uint64(len(m.InlineBytes)))
		i += copy(dAtA[i:], m.InlineBytes)
	}
	return i, nil
}
func (m *DataSource_InlineString) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x1a
	i++
	i = encodeVarintConfig(dAtA, i, uint64(len(m.InlineString)))
	i += copy(dAtA[i:], m.InlineString)
	return i, nil
}
func (m *JwtRule) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *JwtRule) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Issuer) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintConfig(dAtA, i, uint64(len(m.Issuer)))
		i += copy(dAtA[i:], m.Issuer)
	}
	if len(m.Audiences) > 0 {
		for _, s := range m.Audiences {
			dAtA[i] = 0x12
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if m.JwksSourceSpecifier != nil {
		nn4, err := m.JwksSourceSpecifier.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn4
	}
	if m.Forward {
		dAtA[i] = 0x28
		i++
		if m.Forward {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if len(m.FromHeaders) > 0 {
		for _, msg := range m.FromHeaders {
			dAtA[i] = 0x32
			i++
			i = encodeVarintConfig(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.FromParams) > 0 {
		for _, s := range m.FromParams {
			dAtA[i] = 0x3a
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if len(m.ForwardPayloadHeader) > 0 {
		dAtA[i] = 0x42
		i++
		i = encodeVarintConfig(dAtA, i, uint64(len(m.ForwardPayloadHeader)))
		i += copy(dAtA[i:], m.ForwardPayloadHeader)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *JwtRule_RemoteJwks) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.RemoteJwks != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintConfig(dAtA, i, uint64(m.RemoteJwks.Size()))
		n5, err := m.RemoteJwks.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	return i, nil
}
func (m *JwtRule_LocalJwks) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.LocalJwks != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintConfig(dAtA, i, uint64(m.LocalJwks.Size()))
		n6, err := m.LocalJwks.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n6
	}
	return i, nil
}
func (m *RemoteJwks) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RemoteJwks) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.HttpUri != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintConfig(dAtA, i, uint64(m.HttpUri.Size()))
		n7, err := m.HttpUri.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n7
	}
	if m.CacheDuration != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintConfig(dAtA, i, uint64(m.CacheDuration.Size()))
		n8, err := m.CacheDuration.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n8
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *JwtHeader) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *JwtHeader) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintConfig(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if len(m.ValuePrefix) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintConfig(dAtA, i, uint64(len(m.ValuePrefix)))
		i += copy(dAtA[i:], m.ValuePrefix)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *JwtAuthentication) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *JwtAuthentication) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Rules) > 0 {
		for _, msg := range m.Rules {
			dAtA[i] = 0xa
			i++
			i = encodeVarintConfig(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.AllowMissingOrFailed {
		dAtA[i] = 0x10
		i++
		if m.AllowMissingOrFailed {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func encodeVarintConfig(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *HttpUri) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Uri)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	if m.HttpUpstreamType != nil {
		n += m.HttpUpstreamType.Size()
	}
	if m.Timeout != nil {
		l = m.Timeout.Size()
		n += 1 + l + sovConfig(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *HttpUri_Cluster) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Cluster)
	n += 1 + l + sovConfig(uint64(l))
	return n
}
func (m *DataSource) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Specifier != nil {
		n += m.Specifier.Size()
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DataSource_Filename) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Filename)
	n += 1 + l + sovConfig(uint64(l))
	return n
}
func (m *DataSource_InlineBytes) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.InlineBytes != nil {
		l = len(m.InlineBytes)
		n += 1 + l + sovConfig(uint64(l))
	}
	return n
}
func (m *DataSource_InlineString) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.InlineString)
	n += 1 + l + sovConfig(uint64(l))
	return n
}
func (m *JwtRule) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Issuer)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	if len(m.Audiences) > 0 {
		for _, s := range m.Audiences {
			l = len(s)
			n += 1 + l + sovConfig(uint64(l))
		}
	}
	if m.JwksSourceSpecifier != nil {
		n += m.JwksSourceSpecifier.Size()
	}
	if m.Forward {
		n += 2
	}
	if len(m.FromHeaders) > 0 {
		for _, e := range m.FromHeaders {
			l = e.Size()
			n += 1 + l + sovConfig(uint64(l))
		}
	}
	if len(m.FromParams) > 0 {
		for _, s := range m.FromParams {
			l = len(s)
			n += 1 + l + sovConfig(uint64(l))
		}
	}
	l = len(m.ForwardPayloadHeader)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *JwtRule_RemoteJwks) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RemoteJwks != nil {
		l = m.RemoteJwks.Size()
		n += 1 + l + sovConfig(uint64(l))
	}
	return n
}
func (m *JwtRule_LocalJwks) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.LocalJwks != nil {
		l = m.LocalJwks.Size()
		n += 1 + l + sovConfig(uint64(l))
	}
	return n
}
func (m *RemoteJwks) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.HttpUri != nil {
		l = m.HttpUri.Size()
		n += 1 + l + sovConfig(uint64(l))
	}
	if m.CacheDuration != nil {
		l = m.CacheDuration.Size()
		n += 1 + l + sovConfig(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *JwtHeader) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	l = len(m.ValuePrefix)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *JwtAuthentication) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Rules) > 0 {
		for _, e := range m.Rules {
			l = e.Size()
			n += 1 + l + sovConfig(uint64(l))
		}
	}
	if m.AllowMissingOrFailed {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovConfig(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozConfig(x uint64) (n int) {
	return sovConfig(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *HttpUri) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HttpUri: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HttpUri: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Uri", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Uri = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Cluster", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.HttpUpstreamType = &HttpUri_Cluster{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timeout", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Timeout == nil {
				m.Timeout = &types.Duration{}
			}
			if err := m.Timeout.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipConfig(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DataSource) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DataSource: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DataSource: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Filename", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Specifier = &DataSource_Filename{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field InlineBytes", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := make([]byte, postIndex-iNdEx)
			copy(v, dAtA[iNdEx:postIndex])
			m.Specifier = &DataSource_InlineBytes{v}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field InlineString", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Specifier = &DataSource_InlineString{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipConfig(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *JwtRule) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: JwtRule: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: JwtRule: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Issuer", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Issuer = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Audiences", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Audiences = append(m.Audiences, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RemoteJwks", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &RemoteJwks{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.JwksSourceSpecifier = &JwtRule_RemoteJwks{v}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LocalJwks", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &DataSource{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.JwksSourceSpecifier = &JwtRule_LocalJwks{v}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Forward", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Forward = bool(v != 0)
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FromHeaders", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.FromHeaders = append(m.FromHeaders, &JwtHeader{})
			if err := m.FromHeaders[len(m.FromHeaders)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FromParams", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.FromParams = append(m.FromParams, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ForwardPayloadHeader", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ForwardPayloadHeader = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipConfig(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RemoteJwks) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RemoteJwks: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RemoteJwks: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HttpUri", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.HttpUri == nil {
				m.HttpUri = &HttpUri{}
			}
			if err := m.HttpUri.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CacheDuration", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CacheDuration == nil {
				m.CacheDuration = &types.Duration{}
			}
			if err := m.CacheDuration.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipConfig(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *JwtHeader) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: JwtHeader: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: JwtHeader: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ValuePrefix", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ValuePrefix = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipConfig(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *JwtAuthentication) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: JwtAuthentication: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: JwtAuthentication: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Rules", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Rules = append(m.Rules, &JwtRule{})
			if err := m.Rules[len(m.Rules)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AllowMissingOrFailed", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.AllowMissingOrFailed = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipConfig(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipConfig(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthConfig
			}
			iNdEx += length
			if iNdEx < 0 {
				return 0, ErrInvalidLengthConfig
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowConfig
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipConfig(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
				if iNdEx < 0 {
					return 0, ErrInvalidLengthConfig
				}
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthConfig = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowConfig   = fmt.Errorf("proto: integer overflow")
)
