// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	"context"
	"time"

	v1alpha1 "github.com/openshift/cert-manager-operator/apis/operator/v1alpha1"
	scheme "github.com/openshift/cert-manager-operator/pkg/operator/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// CertManagersGetter has a method to return a CertManagerInterface.
// A group's client should implement this interface.
type CertManagersGetter interface {
	CertManagers() CertManagerInterface
}

// CertManagerInterface has methods to work with CertManager resources.
type CertManagerInterface interface {
	Create(ctx context.Context, certManager *v1alpha1.CertManager, opts v1.CreateOptions) (*v1alpha1.CertManager, error)
	Update(ctx context.Context, certManager *v1alpha1.CertManager, opts v1.UpdateOptions) (*v1alpha1.CertManager, error)
	UpdateStatus(ctx context.Context, certManager *v1alpha1.CertManager, opts v1.UpdateOptions) (*v1alpha1.CertManager, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1alpha1.CertManager, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1alpha1.CertManagerList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.CertManager, err error)
	CertManagerExpansion
}

// certManagers implements CertManagerInterface
type certManagers struct {
	client rest.Interface
}

// newCertManagers returns a CertManagers
func newCertManagers(c *OperatorV1alpha1Client) *certManagers {
	return &certManagers{
		client: c.RESTClient(),
	}
}

// Get takes name of the certManager, and returns the corresponding certManager object, and an error if there is any.
func (c *certManagers) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha1.CertManager, err error) {
	result = &v1alpha1.CertManager{}
	err = c.client.Get().
		Resource("certmanagers").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of CertManagers that match those selectors.
func (c *certManagers) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha1.CertManagerList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1alpha1.CertManagerList{}
	err = c.client.Get().
		Resource("certmanagers").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested certManagers.
func (c *certManagers) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Resource("certmanagers").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a certManager and creates it.  Returns the server's representation of the certManager, and an error, if there is any.
func (c *certManagers) Create(ctx context.Context, certManager *v1alpha1.CertManager, opts v1.CreateOptions) (result *v1alpha1.CertManager, err error) {
	result = &v1alpha1.CertManager{}
	err = c.client.Post().
		Resource("certmanagers").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(certManager).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a certManager and updates it. Returns the server's representation of the certManager, and an error, if there is any.
func (c *certManagers) Update(ctx context.Context, certManager *v1alpha1.CertManager, opts v1.UpdateOptions) (result *v1alpha1.CertManager, err error) {
	result = &v1alpha1.CertManager{}
	err = c.client.Put().
		Resource("certmanagers").
		Name(certManager.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(certManager).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *certManagers) UpdateStatus(ctx context.Context, certManager *v1alpha1.CertManager, opts v1.UpdateOptions) (result *v1alpha1.CertManager, err error) {
	result = &v1alpha1.CertManager{}
	err = c.client.Put().
		Resource("certmanagers").
		Name(certManager.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(certManager).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the certManager and deletes it. Returns an error if one occurs.
func (c *certManagers) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return c.client.Delete().
		Resource("certmanagers").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *certManagers) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Resource("certmanagers").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched certManager.
func (c *certManagers) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.CertManager, err error) {
	result = &v1alpha1.CertManager{}
	err = c.client.Patch(pt).
		Resource("certmanagers").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
